"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AwsLoadBalancerPolicy = exports.VersionsLists = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
var VersionsLists;
(function (VersionsLists) {
    VersionsLists["AWS_LOAD_BALANCER_CONTROLLER_POLICY_V2"] = "v2";
})(VersionsLists = exports.VersionsLists || (exports.VersionsLists = {}));
const awsLoadBalancerControllerPolicyV2 = [
    {
        Effect: 'Allow',
        Action: [
            'iam:CreateServiceLinkedRole',
            'ec2:DescribeAccountAttributes',
            'ec2:DescribeAddresses',
            'ec2:DescribeAvailabilityZones',
            'ec2:DescribeInternetGateways',
            'ec2:DescribeVpcs',
            'ec2:DescribeSubnets',
            'ec2:DescribeSecurityGroups',
            'ec2:DescribeInstances',
            'ec2:DescribeNetworkInterfaces',
            'ec2:DescribeTags',
            'ec2:GetCoipPoolUsage',
            'ec2:DescribeCoipPools',
            'elasticloadbalancing:DescribeLoadBalancers',
            'elasticloadbalancing:DescribeLoadBalancerAttributes',
            'elasticloadbalancing:DescribeListeners',
            'elasticloadbalancing:DescribeListenerCertificates',
            'elasticloadbalancing:DescribeSSLPolicies',
            'elasticloadbalancing:DescribeRules',
            'elasticloadbalancing:DescribeTargetGroups',
            'elasticloadbalancing:DescribeTargetGroupAttributes',
            'elasticloadbalancing:DescribeTargetHealth',
            'elasticloadbalancing:DescribeTags',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'cognito-idp:DescribeUserPoolClient',
            'acm:ListCertificates',
            'acm:DescribeCertificate',
            'iam:ListServerCertificates',
            'iam:GetServerCertificate',
            'waf-regional:GetWebACL',
            'waf-regional:GetWebACLForResource',
            'waf-regional:AssociateWebACL',
            'waf-regional:DisassociateWebACL',
            'wafv2:GetWebACL',
            'wafv2:GetWebACLForResource',
            'wafv2:AssociateWebACL',
            'wafv2:DisassociateWebACL',
            'shield:GetSubscriptionState',
            'shield:DescribeProtection',
            'shield:CreateProtection',
            'shield:DeleteProtection',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateSecurityGroup',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            StringEquals: {
                'ec2:CreateAction': 'CreateSecurityGroup',
            },
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:CreateTags',
            'ec2:DeleteTags',
        ],
        Resource: 'arn:aws:ec2:*:*:security-group/*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'ec2:AuthorizeSecurityGroupIngress',
            'ec2:RevokeSecurityGroupIngress',
            'ec2:DeleteSecurityGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateLoadBalancer',
            'elasticloadbalancing:CreateTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:CreateListener',
            'elasticloadbalancing:DeleteListener',
            'elasticloadbalancing:CreateRule',
            'elasticloadbalancing:DeleteRule',
        ],
        Resource: '*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/net/*/*',
            'arn:aws:elasticloadbalancing:*:*:loadbalancer/app/*/*',
        ],
        Condition: {
            Null: {
                'aws:RequestTag/elbv2.k8s.aws/cluster': 'true',
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:AddTags',
            'elasticloadbalancing:RemoveTags',
        ],
        Resource: [
            'arn:aws:elasticloadbalancing:*:*:listener/net/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener/app/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener-rule/net/*/*/*',
            'arn:aws:elasticloadbalancing:*:*:listener-rule/app/*/*/*',
        ],
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:ModifyLoadBalancerAttributes',
            'elasticloadbalancing:SetIpAddressType',
            'elasticloadbalancing:SetSecurityGroups',
            'elasticloadbalancing:SetSubnets',
            'elasticloadbalancing:DeleteLoadBalancer',
            'elasticloadbalancing:ModifyTargetGroup',
            'elasticloadbalancing:ModifyTargetGroupAttributes',
            'elasticloadbalancing:DeleteTargetGroup',
        ],
        Resource: '*',
        Condition: {
            Null: {
                'aws:ResourceTag/elbv2.k8s.aws/cluster': 'false',
            },
        },
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:RegisterTargets',
            'elasticloadbalancing:DeregisterTargets',
        ],
        Resource: 'arn:aws:elasticloadbalancing:*:*:targetgroup/*/*',
    },
    {
        Effect: 'Allow',
        Action: [
            'elasticloadbalancing:SetWebAcl',
            'elasticloadbalancing:ModifyListener',
            'elasticloadbalancing:AddListenerCertificates',
            'elasticloadbalancing:RemoveListenerCertificates',
            'elasticloadbalancing:ModifyRule',
        ],
        Resource: '*',
    },
];
/**
 * (experimental) awsLoadBalancerPolicy class ,help you add policy to your Iam Role for service account.
 *
 * @experimental
 */
class AwsLoadBalancerPolicy {
    /**
     * @experimental
     */
    static addPolicy(version, role) {
        if (version == 'v2') {
            awsLoadBalancerControllerPolicyV2.forEach(element => {
                role.addToPolicy(iam.PolicyStatement.fromJson(element));
            });
            return role;
        }
    }
}
exports.AwsLoadBalancerPolicy = AwsLoadBalancerPolicy;
_a = JSII_RTTI_SYMBOL_1;
AwsLoadBalancerPolicy[_a] = { fqn: "@opencdk8s/cdk8s-aws-lb-controller.AwsLoadBalancerPolicy", version: "0.2.3" };
;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29udHJvbGxlci1wb2xpY3kuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvY29udHJvbGxlci1wb2xpY3kudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSx3Q0FBd0M7QUFDeEMsSUFBWSxhQUtYO0FBTEQsV0FBWSxhQUFhO0lBSXZCLDhEQUE2QyxDQUFBO0FBQy9DLENBQUMsRUFMVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQUt4QjtBQUVELE1BQU0saUNBQWlDLEdBQUc7SUFFeEM7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLDZCQUE2QjtZQUM3QiwrQkFBK0I7WUFDL0IsdUJBQXVCO1lBQ3ZCLCtCQUErQjtZQUMvQiw4QkFBOEI7WUFDOUIsa0JBQWtCO1lBQ2xCLHFCQUFxQjtZQUNyQiw0QkFBNEI7WUFDNUIsdUJBQXVCO1lBQ3ZCLCtCQUErQjtZQUMvQixrQkFBa0I7WUFDbEIsc0JBQXNCO1lBQ3RCLHVCQUF1QjtZQUN2Qiw0Q0FBNEM7WUFDNUMscURBQXFEO1lBQ3JELHdDQUF3QztZQUN4QyxtREFBbUQ7WUFDbkQsMENBQTBDO1lBQzFDLG9DQUFvQztZQUNwQywyQ0FBMkM7WUFDM0Msb0RBQW9EO1lBQ3BELDJDQUEyQztZQUMzQyxtQ0FBbUM7U0FDcEM7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUNkO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLG9DQUFvQztZQUNwQyxzQkFBc0I7WUFDdEIseUJBQXlCO1lBQ3pCLDRCQUE0QjtZQUM1QiwwQkFBMEI7WUFDMUIsd0JBQXdCO1lBQ3hCLG1DQUFtQztZQUNuQyw4QkFBOEI7WUFDOUIsaUNBQWlDO1lBQ2pDLGlCQUFpQjtZQUNqQiw0QkFBNEI7WUFDNUIsdUJBQXVCO1lBQ3ZCLDBCQUEwQjtZQUMxQiw2QkFBNkI7WUFDN0IsMkJBQTJCO1lBQzNCLHlCQUF5QjtZQUN6Qix5QkFBeUI7U0FDMUI7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUNkO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLG1DQUFtQztZQUNuQyxnQ0FBZ0M7U0FDakM7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUNkO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLHlCQUF5QjtTQUMxQjtRQUNELFFBQVEsRUFBRSxHQUFHO0tBQ2Q7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sZ0JBQWdCO1NBQ2pCO1FBQ0QsUUFBUSxFQUFFLGtDQUFrQztRQUM1QyxTQUFTLEVBQUU7WUFDVCxZQUFZLEVBQUU7Z0JBQ1osa0JBQWtCLEVBQUUscUJBQXFCO2FBQzFDO1lBQ0QsSUFBSSxFQUFFO2dCQUNKLHNDQUFzQyxFQUFFLE9BQU87YUFDaEQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLGdCQUFnQjtZQUNoQixnQkFBZ0I7U0FDakI7UUFDRCxRQUFRLEVBQUUsa0NBQWtDO1FBQzVDLFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSixzQ0FBc0MsRUFBRSxNQUFNO2dCQUM5Qyx1Q0FBdUMsRUFBRSxPQUFPO2FBQ2pEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixtQ0FBbUM7WUFDbkMsZ0NBQWdDO1lBQ2hDLHlCQUF5QjtTQUMxQjtRQUNELFFBQVEsRUFBRSxHQUFHO1FBQ2IsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFO2dCQUNKLHVDQUF1QyxFQUFFLE9BQU87YUFDakQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLHlDQUF5QztZQUN6Qyx3Q0FBd0M7U0FDekM7UUFDRCxRQUFRLEVBQUUsR0FBRztRQUNiLFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSixzQ0FBc0MsRUFBRSxPQUFPO2FBQ2hEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTixxQ0FBcUM7WUFDckMscUNBQXFDO1lBQ3JDLGlDQUFpQztZQUNqQyxpQ0FBaUM7U0FDbEM7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUNkO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLDhCQUE4QjtZQUM5QixpQ0FBaUM7U0FDbEM7UUFDRCxRQUFRLEVBQUU7WUFDUixrREFBa0Q7WUFDbEQsdURBQXVEO1lBQ3ZELHVEQUF1RDtTQUN4RDtRQUNELFNBQVMsRUFBRTtZQUNULElBQUksRUFBRTtnQkFDSixzQ0FBc0MsRUFBRSxNQUFNO2dCQUM5Qyx1Q0FBdUMsRUFBRSxPQUFPO2FBQ2pEO1NBQ0Y7S0FDRjtJQUNEO1FBQ0UsTUFBTSxFQUFFLE9BQU87UUFDZixNQUFNLEVBQUU7WUFDTiw4QkFBOEI7WUFDOUIsaUNBQWlDO1NBQ2xDO1FBQ0QsUUFBUSxFQUFFO1lBQ1IscURBQXFEO1lBQ3JELHFEQUFxRDtZQUNyRCwwREFBMEQ7WUFDMUQsMERBQTBEO1NBQzNEO0tBQ0Y7SUFDRDtRQUNFLE1BQU0sRUFBRSxPQUFPO1FBQ2YsTUFBTSxFQUFFO1lBQ04sbURBQW1EO1lBQ25ELHVDQUF1QztZQUN2Qyx3Q0FBd0M7WUFDeEMsaUNBQWlDO1lBQ2pDLHlDQUF5QztZQUN6Qyx3Q0FBd0M7WUFDeEMsa0RBQWtEO1lBQ2xELHdDQUF3QztTQUN6QztRQUNELFFBQVEsRUFBRSxHQUFHO1FBQ2IsU0FBUyxFQUFFO1lBQ1QsSUFBSSxFQUFFO2dCQUNKLHVDQUF1QyxFQUFFLE9BQU87YUFDakQ7U0FDRjtLQUNGO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLHNDQUFzQztZQUN0Qyx3Q0FBd0M7U0FDekM7UUFDRCxRQUFRLEVBQUUsa0RBQWtEO0tBQzdEO0lBQ0Q7UUFDRSxNQUFNLEVBQUUsT0FBTztRQUNmLE1BQU0sRUFBRTtZQUNOLGdDQUFnQztZQUNoQyxxQ0FBcUM7WUFDckMsOENBQThDO1lBQzlDLGlEQUFpRDtZQUNqRCxpQ0FBaUM7U0FDbEM7UUFDRCxRQUFRLEVBQUUsR0FBRztLQUdkO0NBRUYsQ0FBQzs7Ozs7O0FBS0YsTUFBYSxxQkFBcUI7Ozs7SUFDekIsTUFBTSxDQUFDLFNBQVMsQ0FBQyxPQUFlLEVBQUUsSUFBUztRQUNoRCxJQUFJLE9BQU8sSUFBSSxJQUFJLEVBQUU7WUFDbkIsaUNBQWlDLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxFQUFFO2dCQUNsRCxJQUFJLENBQUMsV0FBVyxDQUFDLEdBQUcsQ0FBQyxlQUFlLENBQUMsUUFBUSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUM7WUFDMUQsQ0FBQyxDQUFDLENBQUM7WUFDSCxPQUFPLElBQUksQ0FBQztTQUNiO0lBQ0gsQ0FBQzs7QUFSSCxzREFTQzs7O0FBQUEsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tICdAYXdzLWNkay9hd3MtaWFtJztcbmV4cG9ydCBlbnVtIFZlcnNpb25zTGlzdHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIEFXU19MT0FEX0JBTEFOQ0VSX0NPTlRST0xMRVJfUE9MSUNZX1YyID0gJ3YyJyxcbn1cblxuY29uc3QgYXdzTG9hZEJhbGFuY2VyQ29udHJvbGxlclBvbGljeVYyID0gW1xuXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnaWFtOkNyZWF0ZVNlcnZpY2VMaW5rZWRSb2xlJyxcbiAgICAgICdlYzI6RGVzY3JpYmVBY2NvdW50QXR0cmlidXRlcycsXG4gICAgICAnZWMyOkRlc2NyaWJlQWRkcmVzc2VzJyxcbiAgICAgICdlYzI6RGVzY3JpYmVBdmFpbGFiaWxpdHlab25lcycsXG4gICAgICAnZWMyOkRlc2NyaWJlSW50ZXJuZXRHYXRld2F5cycsXG4gICAgICAnZWMyOkRlc2NyaWJlVnBjcycsXG4gICAgICAnZWMyOkRlc2NyaWJlU3VibmV0cycsXG4gICAgICAnZWMyOkRlc2NyaWJlU2VjdXJpdHlHcm91cHMnLFxuICAgICAgJ2VjMjpEZXNjcmliZUluc3RhbmNlcycsXG4gICAgICAnZWMyOkRlc2NyaWJlTmV0d29ya0ludGVyZmFjZXMnLFxuICAgICAgJ2VjMjpEZXNjcmliZVRhZ3MnLFxuICAgICAgJ2VjMjpHZXRDb2lwUG9vbFVzYWdlJyxcbiAgICAgICdlYzI6RGVzY3JpYmVDb2lwUG9vbHMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlTG9hZEJhbGFuY2VycycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMb2FkQmFsYW5jZXJBdHRyaWJ1dGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZUxpc3RlbmVycycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVMaXN0ZW5lckNlcnRpZmljYXRlcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVTU0xQb2xpY2llcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVSdWxlcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYXJnZXRHcm91cHMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlc2NyaWJlVGFyZ2V0R3JvdXBBdHRyaWJ1dGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXNjcmliZVRhcmdldEhlYWx0aCcsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVzY3JpYmVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnY29nbml0by1pZHA6RGVzY3JpYmVVc2VyUG9vbENsaWVudCcsXG4gICAgICAnYWNtOkxpc3RDZXJ0aWZpY2F0ZXMnLFxuICAgICAgJ2FjbTpEZXNjcmliZUNlcnRpZmljYXRlJyxcbiAgICAgICdpYW06TGlzdFNlcnZlckNlcnRpZmljYXRlcycsXG4gICAgICAnaWFtOkdldFNlcnZlckNlcnRpZmljYXRlJyxcbiAgICAgICd3YWYtcmVnaW9uYWw6R2V0V2ViQUNMJyxcbiAgICAgICd3YWYtcmVnaW9uYWw6R2V0V2ViQUNMRm9yUmVzb3VyY2UnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpBc3NvY2lhdGVXZWJBQ0wnLFxuICAgICAgJ3dhZi1yZWdpb25hbDpEaXNhc3NvY2lhdGVXZWJBQ0wnLFxuICAgICAgJ3dhZnYyOkdldFdlYkFDTCcsXG4gICAgICAnd2FmdjI6R2V0V2ViQUNMRm9yUmVzb3VyY2UnLFxuICAgICAgJ3dhZnYyOkFzc29jaWF0ZVdlYkFDTCcsXG4gICAgICAnd2FmdjI6RGlzYXNzb2NpYXRlV2ViQUNMJyxcbiAgICAgICdzaGllbGQ6R2V0U3Vic2NyaXB0aW9uU3RhdGUnLFxuICAgICAgJ3NoaWVsZDpEZXNjcmliZVByb3RlY3Rpb24nLFxuICAgICAgJ3NoaWVsZDpDcmVhdGVQcm90ZWN0aW9uJyxcbiAgICAgICdzaGllbGQ6RGVsZXRlUHJvdGVjdGlvbicsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VjMjpBdXRob3JpemVTZWN1cml0eUdyb3VwSW5ncmVzcycsXG4gICAgICAnZWMyOlJldm9rZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWMyOkNyZWF0ZVNlY3VyaXR5R3JvdXAnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlYzI6Q3JlYXRlVGFncycsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJ2Fybjphd3M6ZWMyOio6KjpzZWN1cml0eS1ncm91cC8qJyxcbiAgICBDb25kaXRpb246IHtcbiAgICAgIFN0cmluZ0VxdWFsczoge1xuICAgICAgICAnZWMyOkNyZWF0ZUFjdGlvbic6ICdDcmVhdGVTZWN1cml0eUdyb3VwJyxcbiAgICAgIH0sXG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVxdWVzdFRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VjMjpDcmVhdGVUYWdzJyxcbiAgICAgICdlYzI6RGVsZXRlVGFncycsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJ2Fybjphd3M6ZWMyOio6KjpzZWN1cml0eS1ncm91cC8qJyxcbiAgICBDb25kaXRpb246IHtcbiAgICAgIE51bGw6IHtcbiAgICAgICAgJ2F3czpSZXF1ZXN0VGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICd0cnVlJyxcbiAgICAgICAgJ2F3czpSZXNvdXJjZVRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAnZmFsc2UnLFxuICAgICAgfSxcbiAgICB9LFxuICB9LFxuICB7XG4gICAgRWZmZWN0OiAnQWxsb3cnLFxuICAgIEFjdGlvbjogW1xuICAgICAgJ2VjMjpBdXRob3JpemVTZWN1cml0eUdyb3VwSW5ncmVzcycsXG4gICAgICAnZWMyOlJldm9rZVNlY3VyaXR5R3JvdXBJbmdyZXNzJyxcbiAgICAgICdlYzI6RGVsZXRlU2VjdXJpdHlHcm91cCcsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgTnVsbDoge1xuICAgICAgICAnYXdzOlJlc291cmNlVGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6Q3JlYXRlTG9hZEJhbGFuY2VyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVUYXJnZXRHcm91cCcsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgTnVsbDoge1xuICAgICAgICAnYXdzOlJlcXVlc3RUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpDcmVhdGVMaXN0ZW5lcicsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlTGlzdGVuZXInLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkNyZWF0ZVJ1bGUnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOkRlbGV0ZVJ1bGUnLFxuICAgIF0sXG4gICAgUmVzb3VyY2U6ICcqJyxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpBZGRUYWdzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpSZW1vdmVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiBbXG4gICAgICAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6dGFyZ2V0Z3JvdXAvKi8qJyxcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6Kjpsb2FkYmFsYW5jZXIvbmV0LyovKicsXG4gICAgICAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6bG9hZGJhbGFuY2VyL2FwcC8qLyonLFxuICAgIF0sXG4gICAgQ29uZGl0aW9uOiB7XG4gICAgICBOdWxsOiB7XG4gICAgICAgICdhd3M6UmVxdWVzdFRhZy9lbGJ2Mi5rOHMuYXdzL2NsdXN0ZXInOiAndHJ1ZScsXG4gICAgICAgICdhd3M6UmVzb3VyY2VUYWcvZWxidjIuazhzLmF3cy9jbHVzdGVyJzogJ2ZhbHNlJyxcbiAgICAgIH0sXG4gICAgfSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpBZGRUYWdzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpSZW1vdmVUYWdzJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiBbXG4gICAgICAnYXJuOmF3czplbGFzdGljbG9hZGJhbGFuY2luZzoqOio6bGlzdGVuZXIvbmV0LyovKi8qJyxcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6KjpsaXN0ZW5lci9hcHAvKi8qLyonLFxuICAgICAgJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOmxpc3RlbmVyLXJ1bGUvbmV0LyovKi8qJyxcbiAgICAgICdhcm46YXdzOmVsYXN0aWNsb2FkYmFsYW5jaW5nOio6KjpsaXN0ZW5lci1ydWxlL2FwcC8qLyovKicsXG4gICAgXSxcbiAgfSxcbiAge1xuICAgIEVmZmVjdDogJ0FsbG93JyxcbiAgICBBY3Rpb246IFtcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlMb2FkQmFsYW5jZXJBdHRyaWJ1dGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRJcEFkZHJlc3NUeXBlJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpTZXRTZWN1cml0eUdyb3VwcycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6U2V0U3VibmV0cycsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6RGVsZXRlTG9hZEJhbGFuY2VyJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlUYXJnZXRHcm91cCcsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6TW9kaWZ5VGFyZ2V0R3JvdXBBdHRyaWJ1dGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZWxldGVUYXJnZXRHcm91cCcsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJyonLFxuICAgIENvbmRpdGlvbjoge1xuICAgICAgTnVsbDoge1xuICAgICAgICAnYXdzOlJlc291cmNlVGFnL2VsYnYyLms4cy5hd3MvY2x1c3Rlcic6ICdmYWxzZScsXG4gICAgICB9LFxuICAgIH0sXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6UmVnaXN0ZXJUYXJnZXRzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpEZXJlZ2lzdGVyVGFyZ2V0cycsXG4gICAgXSxcbiAgICBSZXNvdXJjZTogJ2Fybjphd3M6ZWxhc3RpY2xvYWRiYWxhbmNpbmc6KjoqOnRhcmdldGdyb3VwLyovKicsXG4gIH0sXG4gIHtcbiAgICBFZmZlY3Q6ICdBbGxvdycsXG4gICAgQWN0aW9uOiBbXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6U2V0V2ViQWNsJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlMaXN0ZW5lcicsXG4gICAgICAnZWxhc3RpY2xvYWRiYWxhbmNpbmc6QWRkTGlzdGVuZXJDZXJ0aWZpY2F0ZXMnLFxuICAgICAgJ2VsYXN0aWNsb2FkYmFsYW5jaW5nOlJlbW92ZUxpc3RlbmVyQ2VydGlmaWNhdGVzJyxcbiAgICAgICdlbGFzdGljbG9hZGJhbGFuY2luZzpNb2RpZnlSdWxlJyxcbiAgICBdLFxuICAgIFJlc291cmNlOiAnKicsXG5cblxuICB9LFxuXG5dO1xuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgQXdzTG9hZEJhbGFuY2VyUG9saWN5IHtcbiAgcHVibGljIHN0YXRpYyBhZGRQb2xpY3kodmVyc2lvbjogc3RyaW5nLCByb2xlOiBhbnkpIDphbnkge1xuICAgIGlmICh2ZXJzaW9uID09ICd2MicpIHtcbiAgICAgIGF3c0xvYWRCYWxhbmNlckNvbnRyb2xsZXJQb2xpY3lWMi5mb3JFYWNoKGVsZW1lbnQgPT4ge1xuICAgICAgICByb2xlLmFkZFRvUG9saWN5KGlhbS5Qb2xpY3lTdGF0ZW1lbnQuZnJvbUpzb24oZWxlbWVudCkpO1xuICAgICAgfSk7XG4gICAgICByZXR1cm4gcm9sZTtcbiAgICB9XG4gIH1cbn07Il19