/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb;

import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.value.DefaultValueArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

public abstract class DrbAbstractSequence
implements DrbSequence {
    @Override
    public ValueArray atomize() {
        return DrbAbstractSequence.atomize(this);
    }

    static ValueArray atomize(DrbSequence seq) {
        int count = seq.getLength();
        if (count == 1 && seq.getItem(0).getValue() != null && seq.getItem(0).getValue().getType() == 10) {
            return (ValueArray)seq.getItem(0).getValue();
        }
        DefaultValueArray values = new DefaultValueArray(count);
        int k = 0;
        for (int i = 0; i < count; ++i) {
            Value v = seq.getItem(i).getValue();
            if (v != null && v.getType() == 10) {
                ValueArray array = (ValueArray)v;
                for (int j = 0; j < array.getLength(); ++j) {
                    values.assign(k, array.getItem(j).getValue());
                    ++k;
                }
                continue;
            }
            if (v == null) continue;
            values.assign(k, v);
            ++k;
        }
        return values;
    }

    @Override
    public DrbSequence addItem(int index, DrbItem item) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        throw new UnsupportedOperationException("DrbAbstractSequence.addItem(): This operation is not supported.");
    }

    public DrbSequence addItem(DrbItem item) throws NullPointerException, UnsupportedOperationException {
        return this.addItem(this.getLength(), item);
    }

    @Override
    public DrbSequence removeItem(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        throw new UnsupportedOperationException("DrbAbstractSequence.removeItem(): This operation is not supported.");
    }
}

