/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl;

import fr.gael.drb.DrbFactoryImpl;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.DrbDefaultMetadataResolver;
import fr.gael.drb.meta.DrbMetadata;
import fr.gael.drb.meta.DrbMetadataResolver;
import fr.gael.drb.meta.MetadataResolver;
import fr.gael.drb.value.Value;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public abstract class DrbFactoryResolver {
    private static Logger logger = Logger.getLogger(DrbFactoryResolver.class);
    private static DrbMetadataResolver metadataResolver = null;
    private static Hashtable<String, String> factoryHash;
    private static Hashtable<String, DrbFactoryImpl> factoryCacheHash;

    public static DrbFactoryImpl resolveImpl(String implementation_identifier) throws NullPointerException {
        if (implementation_identifier == null) {
            throw new NullPointerException("Cannot resolve implementation factory from a null identifier.");
        }
        String lower_case_identifier = implementation_identifier.toLowerCase();
        DrbFactoryImpl impl = factoryCacheHash.get(lower_case_identifier);
        if (impl != null) {
            return impl;
        }
        String impl_name = factoryHash.get(lower_case_identifier);
        if (impl_name == null) {
            String factory_name = lower_case_identifier.substring(0, 1).toUpperCase() + lower_case_identifier.substring(1) + "Factory";
            impl_name = "fr.gael.drb.impl." + lower_case_identifier + "." + factory_name;
        }
        try {
            impl = (DrbFactoryImpl)Class.forName(impl_name).newInstance();
            logger.debug("Implementation Factory \"" + impl_name + "\" loaded.");
            if (impl != null) {
                factoryCacheHash.put(lower_case_identifier, impl);
                logger.debug("Implementation Factory \"" + impl_name + "\" cached.");
            }
            return impl;
        }
        catch (Exception exception) {
            logger.warn("Cannot get new instance of \"" + impl_name + "\" implementation factory (" + exception.getMessage() + ").");
            return null;
        }
    }

    public static DrbFactoryImpl resolveImpl(DrbNode base_node) {
        Value factory_id;
        if (DrbFactoryResolver.getMetadataResolver() == null) {
            return null;
        }
        DrbMetadata metadata = DrbFactoryResolver.getMetadataResolver().resolveMetadata(base_node);
        if (metadata != null && (factory_id = metadata.getProperty("implementationIdentifier")) != null) {
            DrbFactoryImpl factory = DrbFactoryResolver.resolveImpl(factory_id.toString());
            return factory;
        }
        return null;
    }

    public static DrbMetadataResolver getMetadataResolver() {
        return metadataResolver;
    }

    public static void setMetadataResolver(DrbMetadataResolver metadata_resolver) {
        metadataResolver = metadata_resolver;
    }

    public static void registerFactory(String format, String classpath) {
        factoryHash.put(format, classpath);
    }

    public static void registerSchema(String extension, String schema_location) {
        DrbMetadataResolver resolver = DrbFactoryResolver.getMetadataResolver();
        if (resolver != null && resolver instanceof DrbDefaultMetadataResolver) {
            DrbDefaultMetadataResolver.registerSchemaLocation(extension, schema_location);
        }
    }

    public static void registerMetadata(MetadataResolver metadata) {
        DrbFactoryResolver.setMetadataResolver(metadata);
    }

    static {
        String metadata_resolver_property = System.getProperty("fr.gael.drb.meta.DrbMetadataResolver");
        if (metadata_resolver_property != null) {
            try {
                Class<?> metadata_resolver_class = ClassLoader.getSystemClassLoader().loadClass(metadata_resolver_property);
                metadataResolver = (DrbMetadataResolver)metadata_resolver_class.newInstance();
            }
            catch (ClassNotFoundException exception) {
                logger.warn("Cannot find metadata resolver class (" + exception.getMessage() + ")");
            }
            catch (IllegalAccessException exception) {
                logger.warn("Cannot access metadata resolver class (" + exception.getMessage() + ")");
            }
            catch (InstantiationException exception) {
                logger.warn("Cannot instanciate metadata resolver class (" + exception.getMessage() + ")");
            }
            catch (Exception exception) {
                logger.warn("Cannot get metadata resolver class (" + exception.getMessage() + ")");
            }
            finally {
                if (metadataResolver != null) {
                    logger.info("User defined metatadata resolver: \"" + metadata_resolver_property + "\"");
                } else {
                    logger.warn("Using default metadata resolver.");
                    metadataResolver = new DrbDefaultMetadataResolver();
                }
            }
        } else {
            metadataResolver = new DrbDefaultMetadataResolver();
        }
        factoryHash = new Hashtable();
        factoryHash.put("file", "fr.gael.drb.impl.file.FileFactory");
        factoryHash.put("sdf", "fr.gael.drb.impl.sds.SdfFactory");
        factoryHash.put("xml", "fr.gael.drb.impl.xml.XmlFactory");
        factoryCacheHash = new Hashtable();
    }
}

