/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.value.Boolean;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.log4j.Logger;

public class URLNode
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(URLNode.class);
    protected URL url;
    protected InputStream inputstream;

    public URLNode(URL url) {
        this.url = url;
    }

    @Override
    public boolean allowsMultiOccurrence() {
        return false;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof URLNode) {
            URLNode urlNode = (URLNode)obj;
            return this.url.equals(urlNode.url);
        }
        return false;
    }

    @Override
    public String getName() {
        String name = this.url.getPath();
        String urlName = this.url.toString();
        if (name.equals("")) {
            return urlName;
        }
        if (name.equals("/")) {
            return urlName.substring(0, urlName.lastIndexOf("/"));
        }
        String[] str = name.split("/");
        return str[str.length - 1];
    }

    @Override
    public DrbNodeList getChildren() {
        return null;
    }

    @Override
    public boolean hasChild() {
        return false;
    }

    @Override
    public int getChildrenCount() {
        return 0;
    }

    @Override
    public DrbNode getChildAt(int index) {
        return null;
    }

    @Override
    public DrbNode getParent() {
        try {
            String u;
            String path = u = this.url.toString();
            if (path.contains("?")) {
                path = u.substring(0, u.indexOf("?"));
            }
            URI uri = new URI(path);
            uri = path.endsWith("/") ? URLNode.resolve(uri, "..") : URLNode.resolve(uri, "");
            try {
                String file = uri.toURL().getFile();
                if (file.equals("/")) {
                    return null;
                }
                return this.createNode(uri.toURL());
            }
            catch (MalformedURLException e1) {
                logger.warn("fr.gael.drb.impl.URLNode.getParent:  " + e1.getMessage());
            }
        }
        catch (URISyntaxException e) {
            logger.warn("fr.gael.drb.impl.URLNode.getParent:  " + e.getMessage());
        }
        return null;
    }

    public static URI resolve(URI base, String child) throws URISyntaxException {
        URI childUri = new URI(child);
        URI ruri = base.resolve(childUri);
        if (childUri.equals(ruri) && !childUri.isAbsolute() && (base.getScheme().equals("jar") || base.getScheme().equals("zip"))) {
            String r = base.toString();
            int lastslash = r.lastIndexOf(47);
            int exclPointSlashIndex = (r = r.substring(0, lastslash) + "/" + childUri).lastIndexOf("!/");
            if (exclPointSlashIndex > 0) {
                int slashDotDotIndex = r.indexOf("/..", exclPointSlashIndex);
                while (slashDotDotIndex > 0) {
                    int prevSlashIndex = r.lastIndexOf("/", slashDotDotIndex - 1);
                    if (prevSlashIndex >= exclPointSlashIndex) {
                        String temp = r.substring(slashDotDotIndex + 3);
                        r = r.substring(0, prevSlashIndex).concat(temp);
                    }
                    slashDotDotIndex = r.indexOf("/..", exclPointSlashIndex);
                }
            }
            return URI.create(r);
        }
        if ("file".equals(ruri.getScheme()) && !child.equals(ruri) && base.getPath().startsWith("//") && !ruri.getPath().startsWith("//")) {
            String path = "///".concat(ruri.getPath());
            try {
                ruri = new URI("file", null, path, ruri.getQuery(), ruri.getFragment());
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ruri;
    }

    @Override
    public String getPath() {
        return this.url.toString();
    }

    @Override
    public DrbNode getNamedChild(String name, int occurence) {
        if (occurence != 1) {
            return null;
        }
        try {
            URI uri = URLNode.resolve(this.url.toURI(), name);
            uri = uri.normalize();
            try {
                return this.createNode(uri.toURL());
            }
            catch (MalformedURLException e1) {
                logger.error("fr.gael.drb.impl.URLNode.getNamedChild:  " + e1.getMessage());
            }
        }
        catch (URISyntaxException e) {
            logger.error("fr.gael.drb.impl.URLNode.getNamedChild:  " + e.getMessage());
        }
        return null;
    }

    protected URLNode createNode(URL url) {
        return new URLNode(url);
    }

    @Override
    public boolean hasImpl(Class api) {
        if (api.isAssignableFrom(InputStream.class)) {
            return true;
        }
        if (api.isAssignableFrom(OutputStream.class)) {
            return true;
        }
        if (api == URL.class) {
            return true;
        }
        return super.hasImpl(api);
    }

    @Override
    public Object getImpl(Class api) {
        block8: {
            if (api.isAssignableFrom(InputStream.class)) {
                try {
                    if (this.url != null) {
                        URLConnection urlConnect = this.url.openConnection();
                        urlConnect.setDoInput(true);
                        urlConnect.setUseCaches(false);
                        InputStream stream = urlConnect.getInputStream();
                        return stream;
                    }
                    break block8;
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (api.isAssignableFrom(OutputStream.class)) {
                try {
                    URLConnection urlConnect = this.url.openConnection();
                    return urlConnect.getOutputStream();
                }
                catch (Exception e) {
                    return null;
                }
            }
            if (api == URL.class && this.url != null) {
                return this.url;
            }
        }
        return super.getImpl(api);
    }

    @Override
    public DrbAttributeList getAttributes() {
        DrbDefaultAttributeList attribute_list = new DrbDefaultAttributeList();
        attribute_list.add(new DrbDefaultAttribute("directory", new Boolean(false)));
        return attribute_list;
    }
}

