/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sdf;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.impl.sdf.BlockTools;
import fr.gael.drb.impl.sdf.DefaultBlock;
import fr.gael.drb.impl.sdf.Descriptor;
import fr.gael.drb.impl.sdf.IntMap;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import java.io.EOFException;
import java.io.IOException;
import org.apache.log4j.Logger;

public class MultipleOccurrenceBlock
extends DefaultBlock {
    private static Logger logger = Logger.getLogger(MultipleOccurrenceBlock.class);
    protected int occurrence;
    protected int occurrenceCount;
    protected long offset;
    protected long length;

    protected MultipleOccurrenceBlock(Descriptor descriptor, int[] key, int occurrence_count, long offset, long length) {
        super(descriptor, key);
        if (key.length == 0 || occurrence_count < 0 || occurrence_count <= key[key.length - 1]) {
            logger.error("MultipleOccurrenceBlock.MultipleOccurrenceBlock() ERROR: Invalid parameter(s).");
            logger.error("   descriptor name = " + (descriptor == null ? null : descriptor.getName()));
            logger.error("   key.length      = " + key.length);
            if (key.length == 0) {
                logger.error("      The root block should not be instanciated as MultipleOccurrenceBlock !");
            }
            logger.error("   key             = " + IntMap.keyToString(key));
            logger.error("   occurrence_count = " + occurrence_count);
        }
        this.occurrence = key[key.length - 1];
        this.occurrenceCount = occurrence_count;
        this.offset = offset;
        this.length = length;
    }

    @Override
    public Value getValue() {
        if (this.hasChild()) {
            return null;
        }
        if (this.value == null) {
            try {
                BlockTools blockTools = new BlockTools();
                this.value = blockTools.extractValue(this.descriptor.getFile(), this.offset, 0, (int)this.length, 0, this.descriptor.getEncoding(), this.descriptor.getValueType(), 0, 0);
                blockTools = null;
            }
            catch (EOFException e) {
                logger.error(e);
                logger.error("MultipleOccurrenceBlock.getValue(): Unable to read value for node \"" + this.getName() + "\" (key=" + IntMap.keyToString(this.key) + ").");
            }
            catch (IOException e) {
                logger.error(e);
                logger.error("MultipleOccurrenceBlock.getValue(): Unable to read value for node \"" + this.getName() + "\" (key=" + IntMap.keyToString(this.key) + ").");
            }
        }
        return this.value;
    }

    @Override
    public DrbAttributeList getAttributes() {
        java.lang.String strTmp;
        DrbDefaultAttributeList attr_list = new DrbDefaultAttributeList();
        switch (this.descriptor.getEncoding()) {
            case 1: {
                strTmp = "Binary";
                break;
            }
            case 2: {
                strTmp = "Ascii";
                break;
            }
            case 3: {
                strTmp = "Ebcdic";
                break;
            }
            default: {
                strTmp = "Unknown (" + this.descriptor.getEncoding() + ")";
            }
        }
        String str_value = new String(strTmp);
        DrbDefaultAttribute attr = new DrbDefaultAttribute("encoding", str_value, false, this);
        attr_list.add(attr);
        str_value = new String(this.occurrence + 1 + "/" + this.occurrenceCount);
        attr = new DrbDefaultAttribute("occurrence", str_value, false, this);
        attr_list.add(attr);
        Long long_value = new Long(this.offset);
        attr = new DrbDefaultAttribute("offset", long_value, false, this);
        attr_list.add(attr);
        long_value = new Long(this.length);
        attr = new DrbDefaultAttribute("length", long_value, false, this);
        attr_list.add(attr);
        strTmp = this.descriptor.getDocumentation();
        if (strTmp != null) {
            str_value = new String(strTmp);
            attr = new DrbDefaultAttribute("documentation", str_value, false, this);
            attr_list.add(attr);
        }
        if (attr_list.getLength() > 0) {
            return attr_list;
        }
        return null;
    }

    @Override
    public DrbNode getPreviousSibling() {
        if (this.occurrence > 0) {
            int[] previousKey = IntMap.getSiblingKey(this.key, this.occurrence - 1);
            return new MultipleOccurrenceBlock(this.descriptor, previousKey, this.occurrenceCount, this.offset - this.length, this.length);
        }
        Descriptor previousDesc = this.descriptor;
        while ((previousDesc = previousDesc.getPreviousSibling()) != null) {
            int[] previousKey = IntMap.getSiblingKey(this.key, 0);
            int descOccurrenceCount = previousDesc.getOccurrenceCount(previousKey);
            if (descOccurrenceCount <= 0) continue;
            previousKey = IntMap.getSiblingKey(this.key, descOccurrenceCount - 1);
            return MultipleOccurrenceBlock.createOptimalBlock(previousDesc, previousKey, descOccurrenceCount);
        }
        return null;
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.occurrence < this.occurrenceCount - 1) {
            int[] nextKey = IntMap.getSiblingKey(this.key, this.occurrence + 1);
            return new MultipleOccurrenceBlock(this.descriptor, nextKey, this.occurrenceCount, this.offset + this.length, this.length);
        }
        Descriptor nextDesc = this.descriptor;
        while ((nextDesc = nextDesc.getNextSibling()) != null) {
            int[] nextKey = IntMap.getSiblingKey(this.key, 0);
            int descOccurrenceCount = nextDesc.getOccurrenceCount(nextKey);
            if (descOccurrenceCount <= 0) continue;
            return MultipleOccurrenceBlock.createOptimalBlock(nextDesc, nextKey, descOccurrenceCount);
        }
        return null;
    }
}

