/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbAttribute;
import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbNodesChangeEvent;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.DefaultBlock;
import fr.gael.drb.impl.sds.Descriptor;
import fr.gael.drb.impl.sds.IntMap;
import fr.gael.drb.impl.sds.Length;
import fr.gael.drb.impl.sds.SdfNodeView;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdNode;
import java.io.IOException;
import java.util.Arrays;
import org.apache.log4j.Logger;

abstract class AbstractBlock
extends DrbNodeImpl
implements XsdNode {
    private static Logger logger = Logger.getLogger(AbstractBlock.class);
    public static java.lang.String SDF_NAMESPACE = "http://www.gael.fr/2005/04/drb/sdf";
    protected Descriptor descriptor;
    protected Descriptor baseDescriptor;
    protected int[] key;

    protected AbstractBlock(Descriptor descriptor, int[] key) {
        if (descriptor == null || key == null) {
            logger.error("AbstractBlock.AbstractBlock() ERROR: Invalid parameter(s).");
            if (descriptor == null) {
                logger.error("   descriptor       = null");
            } else {
                logger.error("   descriptor.name  = " + descriptor.getName());
            }
            logger.error("   key              = " + IntMap.keyToString(key));
        }
        this.descriptor = descriptor.getInstance(key);
        this.baseDescriptor = descriptor.getBase();
        this.key = key;
    }

    @Override
    public final java.lang.String getName() {
        return this.descriptor.getName();
    }

    @Override
    public final java.lang.String getNamespaceURI() {
        if (this.descriptor.getSchema() == null) {
            return null;
        }
        return this.descriptor.getSchema().getTargetNamespace();
    }

    protected Length getOffset() {
        return this.descriptor.getOffset(this.key);
    }

    protected Length getLength() {
        return this.descriptor.getLength(this.key);
    }

    @Override
    public java.lang.String getXPathName() {
        if (this.key.length == 0) {
            return this.descriptor.getRoot().getName();
        }
        java.lang.String desc_name = this.descriptor.getName();
        Descriptor childDesc = null;
        int occurrence = 0;
        if (this.descriptor.getParent() != null) {
            childDesc = this.descriptor.getParent().getFirstChild();
        }
        while (childDesc != null) {
            if (childDesc.isSame(desc_name)) {
                int child_occurs = this.baseDescriptor == childDesc ? this.key[this.key.length - 1] + 1 : childDesc.getOccurrenceCount(this.key);
                if (childDesc.getSubstitutionCount() > 0) {
                    int[] child_key = IntMap.getSiblingKey(this.key, 0);
                    Descriptor child_instance_desc = null;
                    for (int i = 0; i < child_occurs; ++i) {
                        child_key[child_key.length - 1] = i;
                        child_instance_desc = childDesc.getInstance(child_key);
                        if (!desc_name.equals(child_instance_desc.getName())) continue;
                        ++occurrence;
                    }
                } else {
                    occurrence += child_occurs;
                }
                if (this.baseDescriptor == childDesc) break;
            }
            childDesc = childDesc.getNextSibling();
        }
        if (occurrence <= 1) {
            return desc_name;
        }
        return desc_name + "[" + occurrence + "]";
    }

    @Override
    public DrbAttribute getAttribute(java.lang.String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("documentation")) {
            java.lang.String strTmp = this.descriptor.getDocumentation();
            if (strTmp == null) {
                return null;
            }
            String str_value = new String(strTmp);
            DrbDefaultAttribute attr = new DrbDefaultAttribute("documentation", str_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("xpath")) {
            java.lang.String file_path = this.descriptor.getFileNodePath();
            if (file_path != null) {
                String str_value = new String(file_path);
                DrbDefaultAttribute attr = new DrbDefaultAttribute("xpath", str_value, false, this);
                attr.setNamespaceURI(SDF_NAMESPACE);
                return attr;
            }
            return null;
        }
        if (name.equals("encoding")) {
            java.lang.String strTmp;
            if (this.getValueType() == -1) {
                return null;
            }
            switch (this.descriptor.getEncoding()) {
                case 1: {
                    strTmp = "Binary";
                    break;
                }
                case 2: {
                    strTmp = this.descriptor.charsetName;
                    break;
                }
                default: {
                    strTmp = "Unknown (" + this.descriptor.getEncoding() + ")";
                }
            }
            String str_value = new String(strTmp);
            DrbDefaultAttribute attr = new DrbDefaultAttribute("encoding", str_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("byteOrder")) {
            java.lang.String strTmp;
            if (this.getValueType() == -1) {
                return null;
            }
            switch (this.descriptor.getByteOrdering()) {
                case 1: {
                    strTmp = "LSB";
                    break;
                }
                case 2: {
                    strTmp = "MSB";
                    break;
                }
                default: {
                    strTmp = "(" + this.descriptor.getByteOrdering() + ")";
                }
            }
            String str_value = new String(strTmp);
            DrbDefaultAttribute attr = new DrbDefaultAttribute("byteOrder", str_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("occurrence")) {
            int occurrence = this.key.length > 0 ? this.key[this.key.length - 1] : 1;
            fr.gael.drb.value.Long long_value = new fr.gael.drb.value.Long(occurrence + 1);
            DrbDefaultAttribute attr = new DrbDefaultAttribute("occurrence", long_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("offset")) {
            fr.gael.drb.value.Long long_value = new fr.gael.drb.value.Long(this.getOffset().getLength());
            DrbDefaultAttribute attr = new DrbDefaultAttribute("offset", long_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("bitOffset")) {
            fr.gael.drb.value.Long long_value = new fr.gael.drb.value.Long(this.getOffset().getBitLength());
            DrbDefaultAttribute attr = new DrbDefaultAttribute("bitOffset", long_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("length")) {
            fr.gael.drb.value.Long long_value = new fr.gael.drb.value.Long(this.getLength().getLength());
            DrbDefaultAttribute attr = new DrbDefaultAttribute("length", long_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        if (name.equals("bitLength")) {
            fr.gael.drb.value.Long long_value = new fr.gael.drb.value.Long(this.getLength().getBitLength());
            DrbDefaultAttribute attr = new DrbDefaultAttribute("bitLength", long_value, false, this);
            attr.setNamespaceURI(SDF_NAMESPACE);
            return attr;
        }
        return null;
    }

    @Override
    public DrbAttributeList getAttributes() {
        return null;
    }

    @Override
    public abstract Value getValue();

    @Override
    public abstract int getValueType();

    @Override
    public int getIndex() {
        if (this.key.length == 0) {
            return 0;
        }
        int curIndex = 0;
        for (Descriptor childDesc = this.descriptor.getParent().getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (this.baseDescriptor == childDesc) {
                return curIndex + this.key[this.key.length - 1];
            }
            curIndex += childDesc.getOccurrenceCount(this.key);
        }
        logger.error("AbstractBlock.getIndex() ERROR: This message should never appear !");
        logger.error("   No descriptor in the parent matches the current one = " + this.descriptor);
        return -1;
    }

    @Override
    public DrbNode getRoot() {
        if (this.key.length == 0) {
            return this;
        }
        return new DefaultBlock(this.baseDescriptor.getRoot(), new int[0]);
    }

    protected AbstractBlock getRootBlock() {
        if (this.key.length == 0) {
            return this;
        }
        return new DefaultBlock(this.baseDescriptor.getRoot(), new int[0]);
    }

    @Override
    public DrbNode getParent() {
        if (this.key.length == 0) {
            return this.baseDescriptor.getBaseNode();
        }
        Descriptor parentDesc = this.baseDescriptor.getParent();
        int[] parentKey = IntMap.getParentKey(this.key);
        DrbNode block = AbstractBlock.createOptimalBlock(parentDesc, parentKey, -1);
        return block;
    }

    @Override
    public DrbNodeList getChildren() {
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int childDescOccurrenceCount = childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0));
            for (int i = 0; i < childDescOccurrenceCount; ++i) {
                children.add(AbstractBlock.createOptimalBlock(childDesc, IntMap.getChildKey(this.key, i), childDescOccurrenceCount));
            }
        }
        if (children.size() == 0) {
            return null;
        }
        return children;
    }

    @Override
    public boolean hasChild() {
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0), 1L) <= 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public DrbNode getFirstChild() {
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int[] childKey = IntMap.getChildKey(this.key, 0);
            int childDescOccurrenceCount = childDesc.getOccurrenceCount(childKey, 1L);
            if (childDescOccurrenceCount <= 0) continue;
            return AbstractBlock.createOptimalBlock(childDesc, childKey, childDescOccurrenceCount);
        }
        return null;
    }

    @Override
    public DrbNode getLastChild() {
        return this.getChildAt(this.getChildrenCount() - 1);
    }

    @Override
    public DrbNode getChildAt(int index) {
        if (index < 0) {
            return null;
        }
        int childrenCount = 0;
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            int[] childKey = IntMap.getChildKey(this.key, index - childrenCount);
            int descOccurrenceCount = childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0), (long)index - (long)childrenCount + 1L);
            if (descOccurrenceCount > index - childrenCount) {
                DrbNode child_block = null;
                if (child_block == null) {
                    child_block = AbstractBlock.createOptimalBlock(childDesc, childKey, descOccurrenceCount);
                }
                return child_block;
            }
            childrenCount += descOccurrenceCount;
        }
        return null;
    }

    @Override
    public DrbNode getNamedChild(java.lang.String name, int occurrence) {
        if (occurrence < 1) {
            logger.error("getNamedChild() Error : Invalid occurrence (" + occurrence + ").");
            return null;
        }
        boolean found = false;
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            if (!childDesc.getName().equals(name)) continue;
            int[] childKey = IntMap.getChildKey(this.key, 0);
            found = true;
            int descOccurrenceCount = childDesc.getOccurrenceCount(childKey, Long.valueOf(occurrence));
            if (descOccurrenceCount >= occurrence) {
                childKey[childKey.length - 1] = occurrence - 1;
                DrbNode block = AbstractBlock.createOptimalBlock(childDesc, childKey, descOccurrenceCount);
                return block;
            }
            occurrence -= descOccurrenceCount;
        }
        if (!found) {
            int occurs = 0;
            int i = 0;
            while (true) {
                DrbNode child;
                if ((child = this.getChildAt(i)) == null) {
                    return null;
                }
                if (child.getName().equals(name) && ++occurs == occurrence) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public int getChildrenCount() {
        int childrenCount = 0;
        for (Descriptor childDesc = this.descriptor.getFirstChild(); childDesc != null; childDesc = childDesc.getNextSibling()) {
            childrenCount += childDesc.getOccurrenceCount(IntMap.getChildKey(this.key, 0));
        }
        return childrenCount;
    }

    @Override
    public DrbNode getPreviousSibling() {
        return ((AbstractBlock)this.getParent()).getChildAt(this.getIndex() - 1);
    }

    @Override
    public DrbNode getNextSibling() {
        if (this.key.length == 0) {
            return null;
        }
        int curOccurrence = this.key[this.key.length - 1] + 1;
        int descOccurrenceCount = this.baseDescriptor.getOccurrenceCount(IntMap.getSiblingKey(this.key, 0), (long)curOccurrence + 1L);
        if (curOccurrence < descOccurrenceCount) {
            return AbstractBlock.createOptimalBlock(this.baseDescriptor, IntMap.getSiblingKey(this.key, curOccurrence), descOccurrenceCount);
        }
        Descriptor nextDesc = this.baseDescriptor;
        while ((nextDesc = nextDesc.getNextSibling()) != null) {
            int[] nextKey = IntMap.getSiblingKey(this.key, 0);
            descOccurrenceCount = nextDesc.getOccurrenceCount(nextKey, 1L);
            if (descOccurrenceCount <= 0) continue;
            return AbstractBlock.createOptimalBlock(nextDesc, nextKey, descOccurrenceCount);
        }
        return null;
    }

    protected static final DrbNode createOptimalBlock(Descriptor descriptor, int[] key, int occurrence_count) {
        AbstractBlock new_block = descriptor.createOptimalBlock(key);
        if (descriptor.viewDesc != null) {
            SdfNodeView view_node = new SdfNodeView(descriptor.viewDesc, new_block);
            return view_node;
        }
        return new_block;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof AbstractBlock) {
            AbstractBlock block = (AbstractBlock)obj;
            return this.descriptor == block.descriptor && Arrays.equals(this.key, block.key);
        }
        return false;
    }

    @Override
    public void close(boolean deep) {
        if (deep && this.descriptor != null && this.key.length == 0) {
            this.descriptor.dispose();
        }
    }

    @Override
    public XsdInvalid isValid() {
        if (this.descriptor.getType() == null) {
            return null;
        }
        return this.descriptor.getType().isValid(this);
    }

    @Override
    public void rename(java.lang.String name) throws NullPointerException, UnsupportedOperationException {
        if (!this.descriptor.getName().equals(name)) {
            throw new UnsupportedOperationException("AbstractBlock.rename(): This operation is not supported. SDF node name is defined by the underlying schema.");
        }
    }

    @Override
    public Value setValue(Value value) throws NullPointerException, ClassCastException, UnsupportedOperationException {
        if (value == null) {
            throw new NullPointerException("AbstractBlock.setValue(): The reference to the new value is null.");
        }
        return this.descriptor.setValue(value, this.key);
    }

    @Override
    public void setAttributes(DrbAttributeList attributes) throws NullPointerException, UnsupportedOperationException {
        throw new UnsupportedOperationException("AbstractBlock.setAttributes(): This operation is not supported. SDF node attributes are computed according to the file instance and the underlying schema.");
    }

    @Override
    public void setNamespaceURI(java.lang.String namespace_uri) throws NullPointerException, UnsupportedOperationException {
        java.lang.String target_namespace = this.descriptor.getSchema().getTargetNamespace();
        if (!(target_namespace == namespace_uri || target_namespace != null && target_namespace.equals(namespace_uri))) {
            throw new UnsupportedOperationException("AbstractBlock.setNamespaceURI(): This operation is not supported. SDF namespace is defined and constant.");
        }
    }

    @Override
    public DrbNode insertChild(DrbNode node, int index) throws NullPointerException, UnsupportedOperationException, IndexOutOfBoundsException {
        if (node == null) {
            throw new NullPointerException("AbstractBlock.insertChild(): The reference to the node to append is null.");
        }
        int children_count = this.getChildrenCount();
        if (index < 0 || index > children_count) {
            throw new IndexOutOfBoundsException("AbstractBlock.insertChild(): The child index is not valid (" + index + ").");
        }
        if (index == children_count) {
            return this.appendChild(node);
        }
        try {
            AbstractBlock child = (AbstractBlock)this.getChildAt(index);
            if (child.baseDescriptor.isSame(node.getName())) {
                DrbNode insert_child = child.baseDescriptor.insert(node, child.key, true, 1);
                DrbDefaultNodeList node_list = new DrbDefaultNodeList();
                node_list.add(this);
                this.structureChanged(new DrbNodesChangeEvent(this, node_list));
                return insert_child;
            }
            for (Descriptor childDesc = index == 0 ? this.descriptor.getFirstChild() : ((AbstractBlock)this.getChildAt((int)(index - 1))).baseDescriptor; childDesc != null && childDesc != child.baseDescriptor; childDesc = childDesc.getNextSibling()) {
                int descOccurrenceCount;
                if (!childDesc.isSame(node.getName())) continue;
                int[] childKey = IntMap.getChildKey(this.key, 0);
                childKey[childKey.length - 1] = descOccurrenceCount = childDesc.getOccurrenceCount(childKey);
                DrbNode insert_child = childDesc.insert(node, childKey, true, 1);
                DrbDefaultNodeList node_list = new DrbDefaultNodeList();
                node_list.add(this);
                this.structureChanged(new DrbNodesChangeEvent(this, node_list));
                return insert_child;
            }
        }
        catch (IOException e) {
            logger.error("AbstractBlock.insertChild(): I/O error (" + e.getMessage() + ")");
            throw new UnsupportedOperationException(this.descriptor.getPath() + ": insertChild at index " + index + " failed due to an I/O error (" + e.getMessage() + ")");
        }
        throw new UnsupportedOperationException("AbstractBlock.insertChild(): This operation is not supported. ");
    }

    @Override
    public DrbNode appendChild(DrbNode node) throws NullPointerException, UnsupportedOperationException {
        if (node == null) {
            throw new NullPointerException("AbstractBlock.appendChild(): The reference to the node to append is null.");
        }
        try {
            return this.descriptor.appendChild(node, this.key, true, 1);
        }
        catch (IOException e) {
            logger.error("AbstractBlock.appendChild(): I/O error (" + e.getMessage() + ")");
            throw new UnsupportedOperationException(this.descriptor.getPath() + ": appendChild failed due to an I/O error (" + e.getMessage() + ")");
        }
    }

    @Override
    public DrbNode replaceChild(int index, DrbNode new_node) throws NullPointerException, IndexOutOfBoundsException, UnsupportedOperationException {
        AbstractBlock child = (AbstractBlock)this.getChildAt(index);
        if (index < 0 || child == null) {
            throw new IndexOutOfBoundsException("AbstractBlock.replaceChild(): The child index is not valid (" + index + ").");
        }
        if (child.baseDescriptor.isSame(new_node.getName())) {
            try {
                DrbNode replace_child = child.baseDescriptor.replace(new_node, child.key, true, 0);
                DrbDefaultNodeList node_list = new DrbDefaultNodeList();
                node_list.add(replace_child);
                this.structureChanged(new DrbNodesChangeEvent(this, node_list));
                return replace_child;
            }
            catch (IOException e) {
                logger.error("AbstractBlock.replaceChild(): I/O error (" + e.getMessage() + ")");
                throw new UnsupportedOperationException(this.descriptor.getPath() + ": replaceChild failed due to an I/O error (" + e.getMessage() + ")");
            }
            catch (NullPointerException e) {
                e.printStackTrace();
                throw new UnsupportedOperationException(this.descriptor.getPath() + ": replaceChild failed");
            }
        }
        this.removeChild(index);
        return this.insertChild(new_node, index);
    }

    @Override
    public void removeChild(int index) throws IndexOutOfBoundsException, UnsupportedOperationException {
        AbstractBlock child = (AbstractBlock)this.getChildAt(index);
        if (child != null) {
            child.descriptor.remove(child.key);
            DrbDefaultNodeList node_list = new DrbDefaultNodeList();
            node_list.add(this);
            this.structureChanged(new DrbNodesChangeEvent(this, node_list));
        } else {
            logger.error(this.getName() + ":AbstractBlock.removeChild(" + index + ") - child not found");
        }
    }

    @Override
    public java.lang.String toString() {
        java.lang.String info = this.descriptor.getName();
        Descriptor tmp = this.descriptor;
        while ((tmp = tmp.getParent()) != null) {
            info = tmp.getName() + "/" + info;
        }
        info = "{ \"" + info + "\" ";
        info = info + IntMap.keyToString(this.key) + " }";
        return info;
    }
}

