/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.KeyTreeMap;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.Long;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.Value;
import java.util.Set;
import org.apache.log4j.Logger;

class PhysicalAttribute {
    private static Logger logger = Logger.getLogger(PhysicalAttribute.class);
    private static final int UNKNOWN = -1;
    public static final int FIXED = 1;
    public static final int CONSTANT = 2;
    public static final int VARIABLE = 3;
    public static final int READ_ONLY = 1;
    public static final int WRITE_ONCE = 1;
    public static final int READ_WRITE = 3;
    public static final int SINGLE = 1;
    public static final int MULTIPLE = 3;
    protected static final short ROOT = 1;
    protected static final short PARENT = 2;
    protected static final short SELF = 3;
    protected String query;
    protected short queryContext = (short)3;
    protected Query queryObject;
    protected int accessType = -1;
    protected int occurrenceType = -1;
    protected KeyTreeMap map;
    protected boolean specified = false;

    protected PhysicalAttribute() {
        this(3, 3);
    }

    protected PhysicalAttribute(int access_type) {
        this(access_type, 3);
    }

    protected PhysicalAttribute(int access_type, int occurs_type) {
        this.setAccessType(access_type);
        this.setOccurrenceType(occurs_type);
    }

    protected final int getType() {
        if (this.occurrenceType == 3) {
            return 3;
        }
        if (this.occurrenceType == 1) {
            if (this.accessType == 3) {
                return 2;
            }
            return 1;
        }
        return -1;
    }

    protected final int getAccessType() {
        return this.accessType;
    }

    protected final int getOccurrenceType() {
        return this.occurrenceType;
    }

    protected final boolean isMutable() {
        return this.accessType == 3;
    }

    protected final boolean isSingle() {
        return this.occurrenceType == 1;
    }

    protected final boolean hasQuery() {
        return this.query != null;
    }

    protected final void setQuery(String query) {
        this.queryObject = null;
        this.query = query;
    }

    protected final void setSpecified(boolean specified) {
        this.specified = specified;
    }

    protected final void setQueryContext(short query_context) {
        this.queryContext = query_context;
    }

    protected final void setOccurrenceType(int occurrence_type) {
        if (occurrence_type != this.occurrenceType) {
            this.occurrenceType = occurrence_type;
            this.map = this.occurrenceType == 1 ? new KeyTreeMap(0) : new KeyTreeMap();
        }
    }

    protected final void setAccessType(int access_type) {
        this.accessType = access_type;
    }

    protected final Set getSiblingKeys(int[] key) {
        return this.map.getSiblingKeys(key);
    }

    protected final long getValue() {
        Object map_value = this.map.get();
        if (map_value == null) {
            return -1L;
        }
        return ((Long)map_value).longValue();
    }

    protected final long getValue(int[] key) {
        if (this.occurrenceType == -1) {
            return -1L;
        }
        Object mapValue = this.map.get(key);
        if (mapValue == null) {
            return -1L;
        }
        return ((Long)mapValue).longValue();
    }

    protected long solveValue(AbstractBlock context_node) {
        DrbSequence item_list;
        if (this.queryObject == null) {
            try {
                String base_uri = context_node.descriptor.getBaseURI();
                this.queryObject = new Query(this.query);
                this.queryObject.getEnvironment().setBaseURI(base_uri);
                if (logger.isDebugEnabled()) {
                    logger.debug("Fixed baseURI to " + base_uri);
                }
            }
            catch (Exception e) {
                logger.error("fr.gael.drb.impl.sdf.PhysicalValue.solveValue() : Cannot parse query (" + e + ")");
                return -1L;
            }
        }
        switch (this.queryContext) {
            case 2: {
                context_node = (AbstractBlock)context_node.getParent();
            }
            case 1: {
                context_node = context_node.getRootBlock();
            }
        }
        int current_occurs = 1;
        int total_occurs = 1;
        if (context_node.key.length > 0) {
            total_occurs = current_occurs = context_node.key[context_node.key.length - 1] + 1;
        }
        if ((item_list = this.queryObject.evaluate(context_node, current_occurs, total_occurs)) == null || item_list.getLength() <= 0) {
            return -1L;
        }
        DrbItem result_item = item_list.getItem(0);
        Value result_value = result_item.getValue();
        if (result_value == null) {
            return -1L;
        }
        try {
            result_value = result_value.convertTo(9);
        }
        catch (ClassCastException e) {
            logger.error("fr.gael.drb.impl.sdf.Descriptor.queryEval() : Cannot convert value '" + result_value + "' to integer." + result_value.getClass() + "\n");
            return -1L;
        }
        return ((Numeric)result_value).longValue();
    }

    protected void setValue(int[] key, long value) {
        if (this.occurrenceType == -1) {
            logger.error("PhysicalAttribute.setValue() ERROR: Value type is unknown => value not updated.");
            return;
        }
        if (key != null) {
            if (this.map.getSize() >= 2000) {
                int i = 0;
                KeyTreeMap.KeyTreeMapIterator iterator = this.map.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    if (i >= 1000) {
                        iterator.remove();
                    }
                    ++i;
                }
            }
            this.map.add(key, new Long(value));
        } else {
            this.map.add(new Long(value));
        }
    }

    protected void setValue(long value) {
        if (this.occurrenceType != 1) {
            logger.error("PhysicalAttribute.setValue() ERROR: Value type is invalid => value not updated.");
            return;
        }
        this.map.add(new Long(value));
    }

    protected final void clear() {
        if (this.accessType == 3) {
            this.map.clear();
        }
    }

    public String toString() {
        String tmpStr;
        switch (this.accessType) {
            case 1: {
                tmpStr = "access=READ_ONLY";
                break;
            }
            case 3: {
                tmpStr = "access=READ_WRITE";
                break;
            }
            default: {
                tmpStr = "access=INVALID (" + this.accessType + ")";
            }
        }
        switch (this.occurrenceType) {
            case 1: {
                tmpStr = tmpStr + " occurs=SINGLE " + this.map;
                break;
            }
            case 3: {
                tmpStr = tmpStr + " occurs=MULTIPLE " + this.map;
                break;
            }
            default: {
                tmpStr = tmpStr + " occurs=INVALID (" + this.occurrenceType + ")";
            }
        }
        return "{" + tmpStr + "}";
    }
}

