/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.sds;

import fr.gael.drb.DrbAttributeList;
import fr.gael.drb.DrbDefaultNodeList;
import fr.gael.drb.DrbItem;
import fr.gael.drb.DrbNode;
import fr.gael.drb.DrbNodeList;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.DrbNodeImpl;
import fr.gael.drb.impl.sds.AbstractBlock;
import fr.gael.drb.impl.sds.SdfViewDescriptor;
import fr.gael.drb.query.Query;
import fr.gael.drb.value.AbstractNumericArray;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.DoubleArray;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.IntArray;
import fr.gael.drb.value.LongArray;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.ShortArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.UnsignedByteArray;
import fr.gael.drb.value.UnsignedIntArray;
import fr.gael.drb.value.UnsignedLongArray;
import fr.gael.drb.value.UnsignedShortArray;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import org.apache.log4j.Logger;

class SdfNodeView
extends DrbNodeImpl {
    private static Logger logger = Logger.getLogger(SdfNodeView.class);
    public static final java.lang.String NAMESPACE = "sdf";
    public static final java.lang.String MAP_ID = "view";
    protected DrbNode baseNode;
    protected DrbNode parent;
    protected int index = -1;
    protected SdfViewDescriptor map;
    protected java.lang.String lastChildName;
    protected SdfViewDescriptor lastChildMap;
    protected DrbNodeList lastChildBase;

    public SdfNodeView(SdfViewDescriptor map, DrbNode base_node) {
        this.map = map;
        this.baseNode = base_node;
        this.parent = base_node.getParent();
        if (base_node instanceof AbstractBlock && map.query != null) {
            System.err.println("Evaluating root view from " + base_node.getPath());
            Query q = new Query(map.query);
            DrbNodeList node_list = q.eval(this.baseNode);
            this.baseNode = node_list.item(0);
        }
    }

    public SdfNodeView(SdfViewDescriptor map, DrbNode base_node, DrbNode parent) {
        this(map, base_node);
        this.parent = parent;
    }

    public SdfNodeView(SdfViewDescriptor map, DrbNode base_node, DrbNode parent, int index) {
        this(map, base_node, parent);
        this.index = index;
    }

    @Override
    public java.lang.String getName() {
        return this.map.name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public DrbNode getRoot() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getRoot();
    }

    @Override
    public java.lang.String getPath() {
        java.lang.String path = "";
        if (this.parent != null && (path = this.parent.getPath()) == null) {
            path = "";
        }
        path = path + "/" + this.getName();
        if (this.index > 0) {
            path = path + "[" + this.index + "]";
        }
        return path;
    }

    @Override
    public java.lang.String getNamespaceURI() {
        return "http://www.gael.fr/drb/impl/map-20020814";
    }

    @Override
    public int getValueType() {
        return this.map.valueType;
    }

    @Override
    public Value getValue() {
        if (this.map.valueQuery != null) {
            try {
                logger.debug("\n getValue of " + this.map.valueQuery);
                Query q = new Query(this.map.valueQuery);
                DrbSequence node_list = q.evaluate(this.baseNode);
                if (node_list != null && node_list.getLength() >= 1) {
                    Value value;
                    DrbItem node = node_list.getItem(0);
                    Value value2 = value = node == null ? null : node.getValue();
                    if (node_list.getLength() >= 1 && value != null && value instanceof Numeric) {
                        AbstractNumericArray value_array = null;
                        int value_type = this.getValueType();
                        if (value_type == -2) {
                            value_type = value.getType();
                        }
                        logger.debug("------- value_type = " + value_type);
                        switch (value_type) {
                            case 12: {
                                value_array = new UnsignedByteArray(node_list.getLength());
                                break;
                            }
                            case 1: {
                                value_array = new ByteArray(node_list.getLength());
                                break;
                            }
                            case 13: {
                                value_array = new UnsignedShortArray(node_list.getLength());
                                break;
                            }
                            case 2: {
                                value_array = new ShortArray(node_list.getLength());
                                break;
                            }
                            case 14: {
                                value_array = new UnsignedIntArray(node_list.getLength());
                                break;
                            }
                            case 3: {
                                value_array = new IntArray(node_list.getLength());
                                break;
                            }
                            case 15: {
                                value_array = new UnsignedLongArray(node_list.getLength());
                                break;
                            }
                            case 4: {
                                value_array = new LongArray(node_list.getLength());
                                break;
                            }
                            case 5: {
                                value_array = new FloatArray(node_list.getLength());
                                break;
                            }
                            case 6: {
                                value_array = new DoubleArray(node_list.getLength());
                            }
                        }
                        for (int i = 0; i < node_list.getLength(); ++i) {
                            node = node_list.getItem(i);
                            Value value3 = value = node == null ? null : node.getValue();
                            if (value == null) continue;
                            value_array.assign(i, value);
                        }
                        return value_array;
                    }
                    if (value == null) {
                        return null;
                    }
                    if (this.getValueType() == -2) {
                        return new String("" + value);
                    }
                    return value.convertTo(this.getValueType());
                }
            }
            catch (Exception exception) {
                logger.error("SdfNodeView.getValue() exception=" + exception.getMessage());
                exception.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public DrbAttributeList getAttributes() {
        return null;
    }

    @Override
    public DrbNode getParent() {
        if (this.parent == null) {
            return this;
        }
        return this.parent;
    }

    @Override
    public DrbNodeList getChildren() {
        if (this.map.children == null) {
            System.err.println("getChildren: returning baseNode at " + this.baseNode.getPath());
            return this.baseNode.getChildren();
        }
        DrbDefaultNodeList children = new DrbDefaultNodeList();
        for (int i = 0; i < this.map.children.size(); ++i) {
            SdfViewDescriptor child_map = (SdfViewDescriptor)this.map.children.get(i);
            DrbNodeList node_map_list = this.getNamedChildren(child_map);
            if (node_map_list == null) continue;
            for (int j = 0; j < node_map_list.getLength(); ++j) {
                children.add(node_map_list.item(j));
            }
        }
        return children;
    }

    protected DrbNodeList getNamedChildren(java.lang.String name) {
        if (this.lastChildName != null && this.lastChildName.equals(name)) {
            DrbDefaultNodeList node_map_list = new DrbDefaultNodeList();
            for (int j = 0; j < this.lastChildBase.getLength(); ++j) {
                SdfNodeView child_node_map = new SdfNodeView(this.lastChildMap, this.lastChildBase.item(j), this, j + 1);
                node_map_list.add(child_node_map);
            }
            return node_map_list;
        }
        for (int i = 0; i < this.map.children.size(); ++i) {
            SdfViewDescriptor child_map = (SdfViewDescriptor)this.map.children.get(i);
            if (!child_map.name.equals(name)) continue;
            return this.getNamedChildren(child_map);
        }
        return null;
    }

    protected DrbNodeList getNamedChildren(SdfViewDescriptor child_map) {
        try {
            this.lastChildName = child_map.name;
            this.lastChildMap = child_map;
            this.lastChildBase = null;
            Query q = new Query(child_map.query);
            DrbNodeList node_list = null;
            if (child_map.target == 1) {
                System.err.println("Evaluating self query '" + child_map.query + " on " + this.getPath());
                node_list = q.eval(this);
            } else {
                System.err.println("Evaluating query '" + child_map.query + " on " + this.baseNode.getPath());
                node_list = q.eval(this.baseNode);
            }
            this.lastChildBase = node_list;
            if (node_list != null) {
                DrbDefaultNodeList node_map_list = new DrbDefaultNodeList();
                for (int j = 0; j < node_list.getLength(); ++j) {
                    SdfNodeView child_node_map = new SdfNodeView(child_map, node_list.item(j), this, j + 1);
                    node_map_list.add(child_node_map);
                }
                return node_map_list;
            }
        }
        catch (Exception exception) {
            logger.error("SdfNodeView.getNamedChildren() : query='" + child_map.query, exception);
            exception.printStackTrace();
        }
        return null;
    }

    @Override
    public boolean hasChild() {
        if (this.map.children == null) {
            return this.baseNode.hasChild();
        }
        for (int i = 0; i < this.map.children.size(); ++i) {
            try {
                SdfViewDescriptor child_map = (SdfViewDescriptor)this.map.children.get(i);
                Query q = new Query(child_map.query);
                DrbNodeList node_list = null;
                node_list = child_map.target == 1 ? q.eval(this) : q.eval(this.baseNode);
                if (node_list == null || node_list.getLength() <= 0) continue;
                return true;
            }
            catch (Exception exception) {
                logger.error("SdfNodeView.hasChild() exception:", exception);
                exception.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public DrbNode getNamedChild(java.lang.String name, int occurrence) {
        if (this.map.children == null) {
            return this.baseNode.getNamedChild(name, occurrence);
        }
        if (this.lastChildName != null && this.lastChildName.equals(name)) {
            if (occurrence < 1 || this.lastChildBase == null || occurrence > this.lastChildBase.getLength()) {
                return null;
            }
            return new SdfNodeView(this.lastChildMap, this.lastChildBase.item(occurrence - 1), this, occurrence);
        }
        logger.debug("getNamedChild : computing named children " + name + " for occurrence " + occurrence);
        DrbNodeList node_list = this.getNamedChildren(name);
        if (node_list == null || occurrence < 1 || occurrence > node_list.getLength()) {
            return null;
        }
        return node_list.item(occurrence - 1);
    }

    @Override
    public DrbNode getFirstChild() {
        if (this.map.children == null) {
            return this.baseNode.getFirstChild();
        }
        return this.getChildren().item(0);
    }

    @Override
    public DrbNode getLastChild() {
        if (this.map.children == null) {
            return this.baseNode.getLastChild();
        }
        DrbNodeList children = this.getChildren();
        return children.item(children.getLength() - 1);
    }

    @Override
    public DrbNode getChildAt(int index) {
        if (this.map.children == null) {
            return this.baseNode.getChildAt(index);
        }
        return this.getChildren().item(index);
    }

    @Override
    public int getChildrenCount() {
        if (this.map.children == null) {
            return this.baseNode.getChildrenCount();
        }
        return this.getChildren().getLength();
    }

    @Override
    public DrbNode getPreviousSibling() {
        return null;
    }

    @Override
    public DrbNode getNextSibling() {
        return null;
    }

    @Override
    public boolean hasImpl(Class api) {
        return api.equals(DrbNode.class);
    }

    @Override
    public Object getImpl(Class api) {
        if (api.equals(DrbNode.class)) {
            return this;
        }
        return null;
    }

    @Override
    public void close(boolean deep) {
        if (deep && this.baseNode instanceof DrbNodeImpl) {
            ((DrbNodeImpl)this.baseNode).close(deep);
        }
    }

    public void print(java.lang.String header, int occur) {
        Value value = this.getValue();
        System.out.print(header + this.getName() + "[" + occur + "] : " + (value instanceof ValueArray ? new String("<array>") : value) + " (" + (value == null ? "-1" : Integer.toString(value.getType())) + " / " + this.getValueType() + " ) { base=" + this.baseNode.getName() + "@" + this.baseNode.getNamespaceURI() + " (" + this.baseNode.getValue() + ") }");
        occur = 1;
        java.lang.String child_name = null;
        if (this.map.children == null) {
            System.out.println("(*)");
        } else {
            System.out.println("");
        }
        DrbNodeList children = this.getChildren();
        if (children == null) {
            return;
        }
        int children_count = children.getLength();
        for (int i = 0; i < children_count; ++i) {
            DrbNode child_node = children.item(i);
            occur = child_name == null || !child_name.equals(child_node.getName()) ? 1 : ++occur;
            if (this.map.children == null) {
                SdfNodeView.print(child_node, header + "   ", occur);
            } else {
                ((SdfNodeView)child_node).print(header + "   ", occur);
            }
            child_name = child_node.getName();
        }
    }

    public static void print(DrbNode node, java.lang.String header, int occur) {
        Value value = node.getValue();
        System.out.print(header + node.getName() + "[" + occur + "] : " + (value instanceof ValueArray ? new String("<array>") : value) + " (" + (value == null ? "-1" : Integer.toString(value.getType())) + " )");
        occur = 1;
        java.lang.String child_name = null;
        System.out.println("(*)");
        for (int i = 0; i < node.getChildrenCount(); ++i) {
            occur = child_name == null || !child_name.equals(node.getChildAt(i).getName()) ? 1 : ++occur;
            SdfNodeView.print(node.getChildAt(i), header + "   ", occur);
            child_name = node.getChildAt(i).getName();
        }
    }

    @Override
    public java.lang.String toString() {
        return this.getName();
    }
}

