/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.impl.xml;

import fr.gael.drb.impl.xml.SaxNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

class SaxInputStream2
extends InputStream {
    ArrayList lineOffset = new ArrayList();
    InputStream input;
    Long startHole;
    Long stopHole;
    long offset = 0L;
    SaxNode node;

    SaxInputStream2(InputStream input, SaxNode node) {
        this.input = input;
        this.node = node;
        this.startHole = Long.MAX_VALUE;
        this.stopHole = Long.MAX_VALUE;
        this.offset = 0L;
        this.update();
        if (this.stopHole != Long.MAX_VALUE) {
            this.lineOffset.add(new Long(this.stopHole));
        } else {
            this.lineOffset.add(new Integer(0));
        }
    }

    public long getOffset(int line_number, int column_number) {
        if (line_number < 1 || line_number > this.lineOffset.size()) {
            return -1L;
        }
        return ((Number)this.lineOffset.get(line_number - 1)).longValue() + (long)column_number - 1L;
    }

    private void update() {
        if (this.node.depth > 0) {
            if (this.startHole == Long.MAX_VALUE) {
                this.startHole = 0L;
                this.stopHole = this.node.tag.startOffset;
            } else {
                this.startHole = this.node.tag.endOffset;
                this.stopHole = Long.MAX_VALUE;
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.offset == this.startHole) {
            if (this.stopHole == Long.MAX_VALUE) {
                return -1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.update();
            this.offset += size;
            return this.read();
        }
        int ch = this.input.read();
        if (ch == 10) {
            this.lineOffset.add(new Long(this.offset + 1L));
        }
        if (ch != -1) {
            ++this.offset;
        }
        return ch;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.offset == this.startHole) {
            if (this.stopHole == Long.MAX_VALUE) {
                return -1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.update();
            this.offset += size;
            return this.read(b, off, len);
        }
        if (this.offset >= this.stopHole) {
            int lenRead = this.input.read(b, off, len);
            if (lenRead == -1) {
                return -1;
            }
            for (int i = 0; i < lenRead; ++i) {
                if (b[off + i] != 10) continue;
                this.lineOffset.add(new Long(this.offset + (long)i + 1L));
            }
            this.offset += (long)lenRead;
            return lenRead;
        }
        if (this.offset < this.startHole) {
            long left = this.startHole - this.offset;
            if ((long)len <= left) {
                int lenRead = this.input.read(b, off, len);
                if (lenRead == -1) {
                    return -1;
                }
                for (int i = 0; i < lenRead; ++i) {
                    if (b[off + i] != 10) continue;
                    this.lineOffset.add(new Long(this.offset + (long)i + 1L));
                }
                this.offset += (long)lenRead;
                return lenRead;
            }
            int len1 = this.input.read(b, off, (int)left);
            if (len1 == -1) {
                return -1;
            }
            for (int i = 0; i < len1; ++i) {
                if (b[off + i] != 10) continue;
                this.lineOffset.add(new Long(this.offset + (long)i + 1L));
            }
            this.offset += (long)len1;
            if (this.stopHole == Long.MAX_VALUE) {
                return len1;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.update();
            this.offset += size;
            int len2 = this.read(b, off + len1, len - len1);
            if (len2 == -1) {
                return len1;
            }
            return len1 + len2;
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.offset == this.startHole) {
            if (this.stopHole == Long.MAX_VALUE) {
                return 0;
            }
            long size = this.stopHole - this.startHole;
            this.input.skip(size);
            this.offset += size;
            this.update();
            return this.available();
        }
        if (this.offset >= this.stopHole) {
            return this.input.available();
        }
        if (this.offset < this.startHole) {
            int left = this.input.available();
            if ((long)left < this.startHole - this.offset) {
                return left;
            }
            return (int)(this.startHole - this.offset);
        }
        return 0;
    }

    @Override
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("Mark not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

