/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.Expression;

public class DynamicException
extends RuntimeException {
    private Expression expression;

    protected DynamicException(Expression expression, String message) {
        super(message);
        this.expression = expression;
    }

    protected DynamicException(Expression expression, String message, Exception e) {
        super(message, e);
        this.expression = expression;
    }

    public int getBeginLine() {
        if (this.expression != null && this.expression.getToken() != null) {
            return this.expression.getToken().beginLine;
        }
        return -1;
    }

    public int getEndLine() {
        if (this.expression != null && this.expression.getToken() != null) {
            return this.expression.getToken().endLine;
        }
        return -1;
    }

    public int getBeginColumn() {
        if (this.expression != null && this.expression.getToken() != null) {
            return this.expression.getToken().beginColumn;
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.expression != null && this.expression.getToken() != null) {
            return this.expression.getToken().endColumn;
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.expression != null) {
            return super.getMessage() + " at line " + this.getBeginLine() + ", column " + this.getBeginColumn() + ".";
        }
        return super.getMessage() + ".";
    }
}

