/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.query.DefaultVariable;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.TypeException;

class DynamicVariable
extends DefaultVariable {
    private Expression expression;

    protected DynamicVariable(QName name, SequenceType sequence_type, Expression expression) {
        super(name, sequence_type);
        if (expression == null) {
            throw new DynamicException(expression, "Variable \"" + name + "\" has no bounding expression");
        }
        this.expression = expression;
    }

    Expression getExpression() {
        return this.expression;
    }

    @Override
    public void initialize(DynamicContext context) {
        try {
            this.setValue(this.expression.evaluate(context));
        }
        catch (ClassCastException e) {
            throw new TypeException(this.expression, e.getMessage());
        }
    }

    @Override
    public String toString() {
        String output_string = "";
        output_string = output_string + super.toString();
        if (this.expression != null) {
            output_string = output_string + " (bound to \"" + this.expression + "\")";
        }
        return output_string;
    }

    @Override
    public Object clone() {
        DynamicVariable variable = new DynamicVariable(this.getQName(), this.getSequenceType(), this.expression);
        variable.setValue(this.getValue());
        return variable;
    }
}

