/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbSequence;
import fr.gael.drb.impl.xml.XmlString;
import fr.gael.drb.query.ArithmeticExpression;
import fr.gael.drb.query.ComputedAttributeConstructorExpression;
import fr.gael.drb.query.ComputedElementConstructorExpression;
import fr.gael.drb.query.ConstructorExpression;
import fr.gael.drb.query.DefaultVariable;
import fr.gael.drb.query.DeleteExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicVariable;
import fr.gael.drb.query.EmptySequenceExpression;
import fr.gael.drb.query.Environment;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.ExternalVariable;
import fr.gael.drb.query.FLWORExpression;
import fr.gael.drb.query.FilterExpression;
import fr.gael.drb.query.Function;
import fr.gael.drb.query.FunctionCallExpression;
import fr.gael.drb.query.GeneralCompExpression;
import fr.gael.drb.query.GeneralStepExpression;
import fr.gael.drb.query.IfExpression;
import fr.gael.drb.query.InsertExpression;
import fr.gael.drb.query.JavaCharStream;
import fr.gael.drb.query.LiteralExpression;
import fr.gael.drb.query.LogicalExpression;
import fr.gael.drb.query.ParseException;
import fr.gael.drb.query.PathExpression;
import fr.gael.drb.query.PredicatsListExpression;
import fr.gael.drb.query.QName;
import fr.gael.drb.query.QueryParserConstants;
import fr.gael.drb.query.QueryParserTokenManager;
import fr.gael.drb.query.RangeExpression;
import fr.gael.drb.query.ReplaceExpression;
import fr.gael.drb.query.SequenceCombinationExpression;
import fr.gael.drb.query.SequenceExpression;
import fr.gael.drb.query.SequenceType;
import fr.gael.drb.query.StaticContext;
import fr.gael.drb.query.StaticException;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.query.UnaryExpression;
import fr.gael.drb.query.UserDefinedFunction;
import fr.gael.drb.query.Variable;
import fr.gael.drb.query.VariableExpression;
import fr.gael.drb.value.Decimal;
import fr.gael.drb.value.Double;
import fr.gael.drb.value.Integer;
import fr.gael.drb.xsd.Namespace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

class QueryParser
implements QueryParserConstants {
    Logger logger = Logger.getLogger(QueryParser.class);
    String targetNamespace = null;
    Namespace declaredNamespaces = new Namespace();
    boolean predicats_warning_message_printed = false;
    public QueryParserTokenManager token_source;
    JavaCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    private int jj_gen;
    private final int[] jj_la1 = new int[0];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private final JJCalls[] jj_2_rtns = new JJCalls[145];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public QueryParser() {
        this(new StringReader(""));
    }

    protected Expression parse(Reader reader, StaticContext context) throws StaticException, TypeException {
        Expression expression;
        this.ReInit(reader);
        this.targetNamespace = null;
        this.declaredNamespaces = new Namespace();
        try {
            expression = this.matchMainModule(context);
        }
        catch (ParseException e) {
            throw new StaticException(e);
        }
        return expression;
    }

    protected Expression parse(InputStream stream, StaticContext context) throws StaticException, TypeException {
        Expression expression;
        this.ReInit(stream);
        this.targetNamespace = null;
        this.declaredNamespaces = new Namespace();
        try {
            expression = this.matchMainModule(context);
        }
        catch (ParseException e) {
            throw new StaticException(e);
        }
        return expression;
    }

    void bindNamespace(StaticContext context, String prefix, String uri, Token token) {
        Namespace namespaces = context.getNamespace();
        if (prefix.equals("xml")) {
            throw new StaticException("XQ0070 - The \"xml\" prefix cannot be overriden", token);
        }
        if (prefix.equals("xmlns")) {
            throw new StaticException("XQ0070 - The \"xmlns\" prefix cannot be overriden", token);
        }
        if (uri.length() == 0) {
            this.declaredNamespaces.unbind(prefix);
            namespaces.unbind(prefix);
            return;
        }
        if (this.declaredNamespaces.resolveNamespace(prefix) != null) {
            throw new StaticException("XQ0033 - Namespace prefix \"" + prefix + "\" already assigned to \"" + this.declaredNamespaces.resolveNamespace(prefix) + "\".", token);
        }
        namespaces.bind(prefix, uri);
        this.declaredNamespaces.bind(prefix, uri);
    }

    public final Expression matchMainModule(StaticContext context) throws ParseException {
        Expression expression = null;
        if (this.jj_2_1(3)) {
            this.matchVersionDeclaration(context);
        }
        this.matchProlog(context);
        expression = this.matchExpression(context);
        this.jj_consume_token(0);
        return expression;
    }

    public final void matchVersionDeclaration(StaticContext context) throws ParseException {
        this.jj_consume_token(1);
        this.jj_consume_token(68);
        Token version = this.jj_consume_token(100);
        this.jj_consume_token(99);
        String version_string = version.image;
        version_string = XmlString.decode(version_string);
        if (!version_string.equals("\"1.0\"")) {
            throw new StaticException("XQ0031 - XQuery specifications version " + version_string + " not supported.", version);
        }
    }

    public final String matchLibraryModule(StaticContext context) throws ParseException {
        if (this.jj_2_2(3)) {
            this.matchVersionDeclaration(context);
        }
        this.jj_consume_token(2);
        this.jj_consume_token(3);
        Token prefix = this.jj_consume_token(105);
        this.jj_consume_token(39);
        Token uri = this.jj_consume_token(100);
        this.targetNamespace = uri.image.substring(1, uri.image.length() - 1);
        this.targetNamespace = XmlString.decode(this.targetNamespace);
        this.bindNamespace(context, prefix.image, this.targetNamespace, prefix);
        this.jj_consume_token(99);
        this.matchProlog(context);
        this.jj_consume_token(0);
        return this.targetNamespace;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void matchProlog(StaticContext context) throws ParseException {
        Token prefix = null;
        Token uri = null;
        Object module_path = null;
        boolean base_uri_declared = false;
        Token base_uri_token = null;
        Token updating_token = null;
        Token variable_token = null;
        Token function_name = null;
        UserDefinedFunction function = null;
        Expression value = null;
        Token label = null;
        SequenceType static_type = null;
        SequenceType return_static_type = null;
        boolean is_external = false;
        Namespace namespaces = context.getNamespace();
        while (true) {
            block60: {
                block61: {
                    block64: {
                        block63: {
                            String uri_string;
                            block62: {
                                if (!this.jj_2_3(3)) {
                                    return;
                                }
                                if (!this.jj_2_31(3)) break block61;
                                this.jj_consume_token(4);
                                if (!this.jj_2_22(3)) break block62;
                                this.jj_consume_token(3);
                                prefix = this.jj_consume_token(105);
                                this.jj_consume_token(39);
                                uri = this.jj_consume_token(100);
                                uri_string = uri.image.substring(1, uri.image.length() - 1);
                                uri_string = XmlString.decode(uri_string);
                                this.bindNamespace(context, prefix.image, uri_string, prefix);
                                prefix = null;
                                break block60;
                            }
                            if (!this.jj_2_23(3)) break block63;
                            this.jj_consume_token(5);
                            if (this.jj_2_4(3)) {
                                this.jj_consume_token(6);
                                this.jj_consume_token(3);
                                uri = this.jj_consume_token(100);
                                uri_string = uri.image.substring(1, uri.image.length() - 1);
                                uri_string = XmlString.decode(uri_string);
                                if (uri.image.length() <= 2) {
                                    throw new StaticException("XQ0046 - The default element namespace cannot be a zero-length string.", uri);
                                }
                                context.setDefaultElementNamespaceURI(uri_string);
                                break block60;
                            } else if (this.jj_2_5(3)) {
                                this.jj_consume_token(7);
                                this.jj_consume_token(3);
                                uri = this.jj_consume_token(100);
                                uri_string = uri.image.substring(1, uri.image.length() - 1);
                                uri_string = XmlString.decode(uri_string);
                                if (uri.image.length() <= 2) {
                                    throw new StaticException("XQ0046 - The default function namespace cannot be a zero-length string.", uri);
                                }
                                context.setDefaultFunctionNamespaceURI(uri_string);
                                break block60;
                            } else {
                                if (this.jj_2_6(3)) {
                                    this.jj_consume_token(8);
                                    uri = this.jj_consume_token(100);
                                    throw new StaticException("Declaration of default collation is not supported.", uri);
                                }
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                        }
                        if (!this.jj_2_24(3)) break block64;
                        this.jj_consume_token(9);
                        if (this.jj_2_7(3)) {
                            this.jj_consume_token(10);
                        } else {
                            if (!this.jj_2_8(3)) {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            this.jj_consume_token(11);
                        }
                        this.logger.warn("Change of XMLSpace policy not supported: remains to \"strip\".");
                        break block60;
                    }
                    if (this.jj_2_25(3)) {
                        this.jj_consume_token(12);
                        uri = this.jj_consume_token(100);
                        String base_uri_error_message = null;
                        String string_uri = "";
                        if (base_uri_declared) {
                            base_uri_error_message = base_uri_token != null ? "XQ0032 - A base URI has already been declared at line " + base_uri_token.beginLine + ", column " + base_uri_token.beginColumn + "." : "XQ0032 - A base URI has already been declared.";
                        }
                        if (uri.image.length() <= 2) {
                            base_uri_error_message = base_uri_error_message == null ? "" : base_uri_error_message + "\n";
                            base_uri_error_message = base_uri_error_message + "XQ0046 - The URI of a base URI declaration shall not be a zero-length string.";
                        }
                        if (base_uri_error_message != null) {
                            throw new StaticException(base_uri_error_message, uri);
                        }
                        String string2 = uri.image.substring(1, uri.image.length() - 1);
                        string2 = XmlString.decode(string2);
                        context.setBaseURI(string2);
                        base_uri_declared = true;
                        base_uri_token = uri;
                        break block60;
                    } else if (this.jj_2_26(3)) {
                        void var20_27;
                        QName variable_qname;
                        String variable_prefix;
                        this.jj_consume_token(13);
                        variable_token = this.jj_consume_token(109);
                        static_type = null;
                        value = null;
                        is_external = false;
                        label = null;
                        if (this.jj_2_9(3)) {
                            static_type = this.matchTypeDeclaration(context);
                        }
                        if (this.jj_2_12(3)) {
                            if (this.jj_2_10(3)) {
                                this.jj_consume_token(45);
                                value = this.matchExpression(context);
                                this.jj_consume_token(34);
                                this.logger.warn("Deprecated asignment syntax of variable " + variable_token.image + ". Since the XQuery working draft of October 29, 2004, use of curly braces has been replaced by a \":=\" assignment token to be inserted before the expression to be bound. In the present case, a correct declaration may be : \"declare variable " + variable_token.image + " := " + value.toString() + ";\".");
                            } else {
                                if (!this.jj_2_11(3)) {
                                    this.jj_consume_token(-1);
                                    throw new ParseException();
                                }
                                this.jj_consume_token(79);
                                value = this.matchExpression(context);
                            }
                        }
                        if (this.jj_2_14(3)) {
                            this.jj_consume_token(14);
                            if (value != null) {
                                this.logger.warn("Deprecated declaration of variable " + variable_token.image + ". Since the XQuery working draft of October 29, 2004, an assigned variable shall no longer be declared external. The variable " + variable_token.image + " will therefore, be considered as internal with the assigned expression \"" + value.toString() + "\".");
                            } else {
                                is_external = true;
                            }
                            if (this.jj_2_13(3)) {
                                this.jj_consume_token(15);
                                label = this.jj_consume_token(100);
                                this.logger.warn("Deprecated declaration of variable " + variable_token.image + ". Since the XQuery working draft of October 29, 2004, an external variable shall no longer be labelled. The label " + label.image + " will therefore, be discarded.");
                                label = null;
                            }
                        }
                        if ((variable_prefix = (variable_qname = new QName(variable_token.image.substring(1))).getPrefix()) != null) {
                            String string = namespaces.resolveNamespace(variable_prefix);
                            if (string == null) {
                                throw new StaticException("XP0008 - The prefix \"" + variable_prefix + "\" used in " + variable_token.image + " declaration has not been bound", variable_token);
                            }
                            if (this.targetNamespace != null && !this.targetNamespace.equals(string)) {
                                throw new StaticException("XP0048 - The prefix \"" + variable_prefix + "\" used in " + variable_token.image + " declaration does not match the target namespace \"" + this.targetNamespace + "\"", variable_token);
                            }
                            variable_qname.setNamespaceURI(string);
                        } else if (this.targetNamespace != null) {
                            throw new StaticException("XP0048 - The variable " + variable_token.image + " shall be qualified with a prefix bound to the target namespace \"" + this.targetNamespace + "\"", variable_token);
                        }
                        if (context.containsInScopeVariable(variable_qname)) {
                            throw new StaticException("XQ0049 - Invalid re-declaration of variable " + variable_token.image, variable_token);
                        }
                        if (!is_external && value == null) {
                            throw new StaticException("An internal variable shall have an assigned value expression.", variable_token);
                        }
                        Object var20_24 = null;
                        if (is_external) {
                            DrbSequence default_value = null;
                            if (value != null) {
                                default_value = value.evaluate(new DynamicContext(context));
                            }
                            ExternalVariable externalVariable = new ExternalVariable(variable_qname, static_type, default_value);
                            context.addExternalVariable(externalVariable);
                            is_external = false;
                        } else {
                            DynamicVariable dynamicVariable = new DynamicVariable(variable_qname, static_type, value);
                        }
                        context.addInScopeVariable((Variable)var20_27);
                        break block60;
                    } else {
                        if (!this.jj_2_27(3)) {
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                        if (this.jj_2_15(3)) {
                            updating_token = this.jj_consume_token(65);
                            this.jj_consume_token(7);
                        } else {
                            if (!this.jj_2_16(3)) {
                                this.jj_consume_token(-1);
                                throw new ParseException();
                            }
                            this.jj_consume_token(7);
                        }
                        function_name = this.jj_consume_token(105);
                        function = new UserDefinedFunction(context.resolveQName(function_name.image, context.getDefaultFunctionNamespaceURI()), updating_token != null);
                        StaticContext inner_context = new StaticContext(context);
                        this.jj_consume_token(84);
                        if (this.jj_2_20(3)) {
                            variable_token = this.jj_consume_token(109);
                            if (this.jj_2_17(3)) {
                                static_type = this.matchTypeDeclaration(context);
                            }
                            if (static_type == null) {
                                static_type = new SequenceType();
                            }
                            function.addParameter(context.resolveQName(variable_token.image.substring(1)), static_type);
                            inner_context.addInScopeVariable(new DefaultVariable(context.resolveQName(variable_token.image.substring(1))));
                            static_type = null;
                            while (this.jj_2_18(3)) {
                                this.jj_consume_token(97);
                                variable_token = this.jj_consume_token(109);
                                if (this.jj_2_19(3)) {
                                    static_type = this.matchTypeDeclaration(context);
                                }
                                if (static_type == null) {
                                    static_type = new SequenceType();
                                }
                                function.addParameter(context.resolveQName(variable_token.image.substring(1)), static_type);
                                inner_context.addInScopeVariable(new DefaultVariable(context.resolveQName(variable_token.image.substring(1)), static_type));
                                static_type = null;
                            }
                        }
                        this.jj_consume_token(88);
                        if (this.jj_2_21(3)) {
                            return_static_type = this.matchTypeDeclaration(inner_context);
                        }
                        this.jj_consume_token(45);
                        value = this.matchExpression(inner_context);
                        this.jj_consume_token(34);
                        QName function_qname = function.getQName();
                        String string = function_qname.getNamespaceURI();
                        String function_prefix = function_qname.getPrefix();
                        if (function_prefix != null && string == null) {
                            throw new StaticException("XP0008 - The prefix \"" + function_prefix + "\" used in " + function_name.image + " declaration has not been bound", function_name);
                        }
                        if (this.targetNamespace != null && !this.targetNamespace.equals(string)) {
                            throw new StaticException("XP0048 - The prefix \"" + function_prefix + "\" used in " + function_name.image + " declaration does not match the target namespace \"" + this.targetNamespace + "\"", function_name);
                        }
                        if (Environment.isReservedNamespace(string)) {
                            this.logger.error("XQST0045 - The function " + function_name.image + " is declared in a reserved namespace. Add the predefined 'local' prefix (local:" + function_qname.getLocalName() + ").");
                        }
                        if (context.containsInScopeFunction(function_qname)) {
                            throw new StaticException("XQST0034 - Invalid re-declaration of function " + function_name.image, function_name);
                        }
                        if (updating_token != null && return_static_type != null) {
                            throw new StaticException("XUST0001 - The return type of the function " + function_name.image + " must not be specified. The result of an updating function will be always the empty sequence.", function_name);
                        }
                        function.setExpression(value);
                        if (return_static_type != null) {
                            function.setReturnType(return_static_type);
                        }
                        context.addInScopeFunction(function);
                        return_static_type = null;
                    }
                    break block60;
                }
                if (!this.jj_2_32(3)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(16);
                this.jj_consume_token(2);
                if (this.jj_2_28(3)) {
                    this.jj_consume_token(3);
                    prefix = this.jj_consume_token(105);
                    this.jj_consume_token(39);
                }
                uri = this.jj_consume_token(100);
                String module_namespace = uri.image.substring(1, uri.image.length() - 1);
                module_namespace = XmlString.decode(module_namespace);
                if (prefix == null) {
                    throw new StaticException("The current implementation does not already support module imports with target namespaces not bound to a prefix. The expression \"namespace NCName =\" shall be  inserted before the target namespace URI, where NCName is to be replaced by the desired namespace prefix", uri);
                }
                this.bindNamespace(context, prefix.image, module_namespace, prefix);
                if (this.jj_2_30(3)) {
                    this.jj_consume_token(86);
                    this.matchModuleLocator(module_namespace, prefix.image, context);
                    while (this.jj_2_29(3)) {
                        this.jj_consume_token(97);
                        this.matchModuleLocator(module_namespace, prefix.image, context);
                    }
                }
                prefix = null;
            }
            this.jj_consume_token(99);
        }
    }

    public final void matchModuleLocator(String module_namespace, String module_prefix, StaticContext context) throws ParseException {
        Token module_path = null;
        module_path = this.jj_consume_token(100);
        URI module_uri = null;
        String uri_string = "";
        try {
            uri_string = module_path.image.replaceAll("\"", "");
            uri_string = XmlString.decode(uri_string);
            module_uri = new URI(uri_string);
        }
        catch (URISyntaxException exception) {
            throw new StaticException("XQ0046 - \"" + uri_string + "\" is not a valid URI (" + exception.getMessage() + ")", module_path);
        }
        InputStream module_input_stream = null;
        if ("classpath".equals(module_uri.getScheme())) {
            module_input_stream = this.getClass().getClassLoader().getResourceAsStream(module_uri.getSchemeSpecificPart());
            if (module_input_stream == null) {
                throw new StaticException("XQ0046 : Cannot open \"" + uri_string + "\" module from classpath.", module_path);
            }
        } else {
            try {
                uri_string = module_path.image.replaceAll("\"", "");
                uri_string = XmlString.decode(uri_string);
                module_uri = new URI(uri_string);
                if (!module_uri.isAbsolute() && context.getBaseURI() != null) {
                    URI local_uri = new File(".").toURI();
                    URI base_uri = local_uri.resolve(new URI(context.getBaseURI()));
                    File base_file = new File(base_uri);
                    if (base_file.exists()) {
                        base_uri = base_file.toURI();
                    }
                    module_uri = base_uri.resolve(module_uri);
                }
            }
            catch (URISyntaxException exception) {
                throw new StaticException("XQ0046 - \"" + uri_string + "\" is not a valid URI (" + exception.getMessage() + ")", module_path);
            }
            File module_file = null;
            try {
                module_file = new File(module_uri);
            }
            catch (NullPointerException exception) {
                throw new StaticException("XQ0046 : \"" + uri_string + "\" module lead to a null URI (Internal error)", module_path);
            }
            catch (IllegalArgumentException exception) {
                throw new StaticException("XQ0046 : \"" + uri_string + "\" module URI is not supported by the current implementation (" + exception.getMessage() + ")", module_path);
            }
            try {
                module_input_stream = new FileInputStream(module_file);
            }
            catch (FileNotFoundException exception) {
                throw new StaticException("XQ0046 : \"" + uri_string + "\" module file not found", module_path);
            }
            catch (SecurityException exception) {
                throw new StaticException("XQ0046 : \"" + uri_string + "\" module cannot be read for security reasons (" + exception.getMessage() + ")", module_path);
            }
        }
        QueryParser module_parser = new QueryParser(module_input_stream);
        StaticContext module_context = new StaticContext((Environment)context);
        String module_targetnamespace = null;
        try {
            module_targetnamespace = module_parser.matchLibraryModule(module_context);
        }
        catch (ParseException exception) {
            StaticException static_exception = new StaticException(exception);
            String error_message = static_exception.getMessage() + " of module \"" + module_namespace + "\"";
            if (module_path.image != null) {
                error_message = error_message + " located at \"" + uri_string + "\" and imported";
            }
            throw new StaticException(error_message, module_path);
        }
        catch (StaticException static_exception) {
            String error_message = static_exception.getMessage();
            error_message = error_message.substring(0, error_message.length() - 1);
            error_message = error_message + " of module \"" + module_namespace + "\"";
            if (module_path.image != null) {
                error_message = error_message + " located at \"" + uri_string + "\" and imported";
            }
            throw new StaticException(error_message, module_path);
        }
        catch (TypeException type_exception) {
            String error_message = type_exception.getMessage();
            error_message = error_message.substring(0, error_message.length() - 1);
            error_message = error_message + " of module \"" + module_namespace + "\"";
            if (module_path.image != null) {
                error_message = error_message + " located at \"" + uri_string + "\" and imported";
            }
            throw new StaticException(error_message, module_path);
        }
        if (module_targetnamespace == null) {
            throw new StaticException("Unable to get target namespace of module located at \"" + uri_string + "\"", module_path);
        }
        if (!module_targetnamespace.equals(module_namespace)) {
            throw new StaticException("The target namespace \"" + module_targetnamespace + "\" of module located at \"" + uri_string + "\" does not match the module import target namespace \"" + module_namespace + "\"", module_path);
        }
        Collection<Variable> module_variables = module_context.getInScopeVariables();
        for (Variable variable : module_variables) {
            QName var_name = variable.getQName();
            if (context.containsInScopeVariable(var_name)) {
                throw new StaticException("XQ0049 - Variable " + var_name + " declared in the module located at \"" + uri_string + "\" has already been declared in the current context", module_path);
            }
            context.addInScopeVariable(variable);
        }
        Map<QName, Function> module_functions = module_context.getInScopeFunctions();
        Set<QName> module_function_set = module_functions.keySet();
        for (QName function_name : module_function_set) {
            Function function = module_context.getInScopeFunction(function_name);
            if (context.containsInScopeFunction(function_name)) {
                throw new StaticException("XQ0049 - Function " + function_name + " declared in the module located at \"" + uri_string + "\" has already been declared in the current context", module_path);
            }
            context.addInScopeFunction(function);
        }
    }

    public final SequenceType matchTypeDeclaration(StaticContext context) throws ParseException {
        this.jj_consume_token(15);
        SequenceType sequence_type = this.matchSequenceType(context);
        return sequence_type;
    }

    public final SequenceType matchSequenceType(StaticContext context) throws ParseException {
        String type_name;
        int occurrence = 0;
        if (this.jj_2_33(3)) {
            this.jj_consume_token(17);
            this.jj_consume_token(84);
            this.jj_consume_token(88);
            type_name = "node()";
        } else if (this.jj_2_34(3)) {
            this.jj_consume_token(18);
            this.jj_consume_token(84);
            this.jj_consume_token(88);
            type_name = "item()";
        } else if (this.jj_2_35(3)) {
            Token atomic_type = this.matchQNameToken();
            type_name = atomic_type.image;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_39(3)) {
            if (this.jj_2_36(3)) {
                this.jj_consume_token(83);
                occurrence = 3;
            } else if (this.jj_2_37(3)) {
                this.jj_consume_token(63);
                occurrence = 2;
            } else if (this.jj_2_38(3)) {
                this.jj_consume_token(19);
                occurrence = 1;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        SequenceType sequence_type = new SequenceType(type_name, occurrence);
        return sequence_type;
    }

    public final Expression matchExpression(StaticContext context) throws ParseException {
        boolean first_expression = true;
        Expression expression = this.matchSingleExpression(context);
        while (this.jj_2_40(3)) {
            Token current_token = this.jj_consume_token(97);
            Expression single_expression = this.matchSingleExpression(context);
            if (first_expression) {
                expression = new SequenceExpression(current_token, expression);
                first_expression = false;
            }
            ((SequenceExpression)expression).addExpression(single_expression);
        }
        return expression;
    }

    public final Expression matchSingleExpression(StaticContext context) throws ParseException {
        Expression expression;
        if (this.jj_2_41(3)) {
            expression = this.matchFLWORExpression(context);
        } else if (this.jj_2_42(3)) {
            expression = this.matchIfExpression(context);
        } else if (this.jj_2_43(3)) {
            expression = this.matchOrExpression(context);
        } else if (this.jj_2_44(3)) {
            expression = this.matchInsertExpression(context);
        } else if (this.jj_2_45(3)) {
            expression = this.matchDeleteExpression(context);
        } else if (this.jj_2_46(3)) {
            expression = this.matchReplaceExpression(context);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression matchFLWORExpression(StaticContext context) throws ParseException {
        FLWORExpression expression = null;
        Token name = null;
        Token positional_variable_token = null;
        Token begin = null;
        Expression variable_expression = null;
        Expression where_expression = null;
        Expression return_expression = null;
        DynamicVariable variable = null;
        DefaultVariable positional_variable = null;
        SequenceType type = null;
        StaticContext inner_context = new StaticContext(context);
        do {
            if (this.jj_2_55(3)) {
                begin = this.jj_consume_token(90);
                name = this.jj_consume_token(109);
                if (this.jj_2_47(3)) {
                    type = this.matchTypeDeclaration(inner_context);
                }
                if (this.jj_2_48(3)) {
                    this.jj_consume_token(86);
                    positional_variable_token = this.jj_consume_token(109);
                }
                this.jj_consume_token(64);
                variable_expression = this.matchSingleExpression(inner_context);
                if (expression == null) {
                    expression = new FLWORExpression(begin);
                }
                QName variable_qname = context.resolveQName(name.image.substring(1));
                variable = new DynamicVariable(variable_qname, type, variable_expression);
                inner_context.addInScopeVariable(variable);
                if (positional_variable_token != null) {
                    positional_variable = new DefaultVariable(context.resolveQName(positional_variable_token.image.substring(1)), new SequenceType("xs:integer", 0));
                    inner_context.addInScopeVariable(positional_variable);
                    positional_variable_token = null;
                }
                try {
                    expression.addForBinding(variable, positional_variable);
                }
                catch (Exception e) {
                    throw new StaticException(e.getMessage(), begin);
                }
                while (this.jj_2_49(3)) {
                    this.jj_consume_token(97);
                    name = this.jj_consume_token(109);
                    if (this.jj_2_50(3)) {
                        type = this.matchTypeDeclaration(inner_context);
                    }
                    if (this.jj_2_51(3)) {
                        this.jj_consume_token(86);
                        positional_variable_token = this.jj_consume_token(109);
                    }
                    this.jj_consume_token(64);
                    variable_expression = this.matchSingleExpression(inner_context);
                    variable = new DynamicVariable(context.resolveQName(name.image.substring(1)), type, variable_expression);
                    inner_context.addInScopeVariable(variable);
                    if (positional_variable_token != null) {
                        positional_variable = new DefaultVariable(context.resolveQName(positional_variable_token.image.substring(1)), new SequenceType("xs:integer", 0));
                        inner_context.addInScopeVariable(positional_variable);
                        positional_variable_token = null;
                    }
                    try {
                        expression.addForBinding(variable, positional_variable);
                    }
                    catch (Exception e) {
                        throw new StaticException(e.getMessage(), begin);
                    }
                }
                continue;
            }
            if (this.jj_2_56(3)) {
                begin = this.jj_consume_token(91);
                name = this.jj_consume_token(109);
                if (this.jj_2_52(3)) {
                    type = this.matchTypeDeclaration(inner_context);
                }
                this.jj_consume_token(79);
                variable_expression = this.matchSingleExpression(inner_context);
                if (expression == null) {
                    expression = new FLWORExpression(begin);
                }
                variable = new DynamicVariable(context.resolveQName(name.image.substring(1)), type, variable_expression);
                try {
                    expression.addLetBinding(variable);
                }
                catch (Exception e) {
                    throw new StaticException(e.getMessage(), begin);
                }
                inner_context.addInScopeVariable(variable);
                while (this.jj_2_53(3)) {
                    this.jj_consume_token(97);
                    name = this.jj_consume_token(109);
                    if (this.jj_2_54(3)) {
                        type = this.matchTypeDeclaration(inner_context);
                    }
                    this.jj_consume_token(79);
                    variable_expression = this.matchSingleExpression(inner_context);
                    variable = new DynamicVariable(context.resolveQName(name.image.substring(1)), type, variable_expression);
                    try {
                        expression.addLetBinding(variable);
                    }
                    catch (Exception e) {
                        throw new StaticException(e.getMessage(), begin);
                    }
                    inner_context.addInScopeVariable(variable);
                }
                continue;
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        } while (this.jj_2_57(3));
        if (this.jj_2_58(3)) {
            this.token = this.jj_consume_token(73);
            where_expression = this.matchExpression(inner_context);
            expression.setWhereExpression(where_expression);
        }
        this.jj_consume_token(69);
        return_expression = this.matchSingleExpression(inner_context);
        expression.setReturnExpression(return_expression);
        return expression;
    }

    public final Token matchQNameToken() throws ParseException {
        Token begin;
        if (this.jj_2_59(3)) {
            begin = this.jj_consume_token(105);
        } else if (this.jj_2_60(3)) {
            begin = this.jj_consume_token(66);
        } else if (this.jj_2_61(3)) {
            begin = this.jj_consume_token(67);
        } else if (this.jj_2_62(3)) {
            begin = this.jj_consume_token(68);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return begin;
    }

    public final Expression matchInsertExpression(StaticContext context) throws ParseException {
        InsertExpression expression = null;
        Token begin = this.jj_consume_token(20);
        this.jj_consume_token(21);
        Expression source_expression = this.matchSingleExpression(context);
        this.jj_consume_token(22);
        Expression target_expression = this.matchSingleExpression(context);
        expression = new InsertExpression(begin);
        expression.setSourceExpression(source_expression);
        expression.setTargetExpression(target_expression);
        return expression;
    }

    public final Expression matchDeleteExpression(StaticContext context) throws ParseException {
        DeleteExpression expression = null;
        Token begin = this.jj_consume_token(20);
        this.jj_consume_token(23);
        Expression target_expression = this.matchSingleExpression(context);
        expression = new DeleteExpression(begin);
        expression.setTargetExpression(target_expression);
        return expression;
    }

    public final Expression matchReplaceExpression(StaticContext context) throws ParseException {
        ReplaceExpression expression = null;
        Token value = null;
        Token begin = this.jj_consume_token(20);
        this.jj_consume_token(66);
        if (this.jj_2_63(3)) {
            value = this.jj_consume_token(67);
            this.jj_consume_token(24);
        }
        Expression target_expression = this.matchSingleExpression(context);
        this.jj_consume_token(25);
        Expression source_expression = this.matchSingleExpression(context);
        expression = new ReplaceExpression(begin);
        expression.setSourceExpression(source_expression);
        expression.setTargetExpression(target_expression);
        expression.setValueSpecified(value != null);
        return expression;
    }

    public final Expression matchIfExpression(StaticContext context) throws ParseException {
        IfExpression expression = null;
        Token begin = this.jj_consume_token(96);
        this.jj_consume_token(84);
        Expression test_expression = this.matchExpression(context);
        this.jj_consume_token(88);
        this.jj_consume_token(70);
        Expression then_expression = this.matchSingleExpression(context);
        this.jj_consume_token(71);
        Expression else_expression = this.matchSingleExpression(context);
        expression = new IfExpression(begin);
        expression.setTestExpression(test_expression);
        expression.setThenExpression(then_expression);
        expression.setElseExpression(else_expression);
        return expression;
    }

    public final Expression matchOrExpression(StaticContext context) throws ParseException {
        LogicalExpression expression = null;
        Expression left_operand = this.matchAndExpression(context);
        while (this.jj_2_64(3)) {
            Token or_token = this.jj_consume_token(59);
            Expression right_operand = this.matchAndExpression(context);
            if (expression == null) {
                expression = new LogicalExpression(or_token, left_operand, LogicalExpression.OR, right_operand);
                continue;
            }
            expression = new LogicalExpression(or_token, expression, LogicalExpression.OR, right_operand);
        }
        if (expression == null) {
            return left_operand;
        }
        return expression;
    }

    public final Expression matchAndExpression(StaticContext context) throws ParseException {
        LogicalExpression expression = null;
        Expression left_operand = this.matchGeneralCompExpression(context);
        while (this.jj_2_65(3)) {
            Token and_token = this.jj_consume_token(60);
            Expression right_operand = this.matchGeneralCompExpression(context);
            if (expression == null) {
                expression = new LogicalExpression(and_token, left_operand, LogicalExpression.AND, right_operand);
                continue;
            }
            expression = new LogicalExpression(and_token, expression, LogicalExpression.AND, right_operand);
        }
        if (expression == null) {
            return left_operand;
        }
        return expression;
    }

    public final Expression matchGeneralCompExpression(StaticContext context) throws ParseException {
        Expression left_operand = this.matchRangeExpression(context);
        if (this.jj_2_66(3)) {
            int comparison = this.matchGeneralCompOperator();
            Expression right_operand = this.matchRangeExpression(context);
            return new GeneralCompExpression(left_operand.getToken(), left_operand, comparison, right_operand);
        }
        return left_operand;
    }

    public final int matchGeneralCompOperator() throws ParseException {
        int comparison;
        if (this.jj_2_67(3)) {
            this.jj_consume_token(39);
            comparison = 0;
        } else if (this.jj_2_68(3)) {
            this.jj_consume_token(76);
            comparison = 1;
        } else if (this.jj_2_69(3)) {
            this.jj_consume_token(80);
            comparison = 2;
        } else if (this.jj_2_70(3)) {
            this.jj_consume_token(77);
            comparison = 3;
        } else if (this.jj_2_71(3)) {
            this.jj_consume_token(81);
            comparison = 4;
        } else if (this.jj_2_72(3)) {
            this.jj_consume_token(78);
            comparison = 5;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return comparison;
    }

    public final Expression matchRangeExpression(StaticContext context) throws ParseException {
        Expression minimum = this.matchAdditiveExpression(context);
        if (this.jj_2_73(3)) {
            Token range = this.jj_consume_token(72);
            Expression maximum = this.matchAdditiveExpression(context);
            return new RangeExpression(range, minimum, maximum);
        }
        return minimum;
    }

    public final Expression matchAdditiveExpression(StaticContext context) throws ParseException {
        Expression left_operand = this.matchMultiplicativeExpression(context);
        while (this.jj_2_74(3)) {
            int operation = this.matchAdditiveOperator();
            Expression right_operand = this.matchMultiplicativeExpression(context);
            left_operand = new ArithmeticExpression(left_operand.getToken(), left_operand, operation, right_operand);
        }
        return left_operand;
    }

    public final int matchAdditiveOperator() throws ParseException {
        int arithmetic_operator;
        if (this.jj_2_75(3)) {
            this.jj_consume_token(83);
            arithmetic_operator = ArithmeticExpression.PLUS;
        } else if (this.jj_2_76(3)) {
            this.jj_consume_token(82);
            arithmetic_operator = ArithmeticExpression.MINUS;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arithmetic_operator;
    }

    public final Expression matchMultiplicativeExpression(StaticContext context) throws ParseException {
        Expression left_operand = this.matchUnaryExpression(context);
        while (this.jj_2_77(3)) {
            int operation = this.matchMultiplicativeOperator();
            Expression right_operand = this.matchUnaryExpression(context);
            left_operand = new ArithmeticExpression(left_operand.getToken(), left_operand, operation, right_operand);
        }
        return left_operand;
    }

    public final int matchMultiplicativeOperator() throws ParseException {
        int arithmetic_operator;
        if (this.jj_2_78(3)) {
            this.jj_consume_token(63);
            arithmetic_operator = ArithmeticExpression.MULTIPLY;
        } else if (this.jj_2_79(3)) {
            this.jj_consume_token(61);
            arithmetic_operator = ArithmeticExpression.DIVIDE;
        } else if (this.jj_2_80(3)) {
            this.jj_consume_token(62);
            arithmetic_operator = ArithmeticExpression.MODULO;
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return arithmetic_operator;
    }

    public final Expression matchUnaryExpression(StaticContext context) throws ParseException {
        int operation = -1;
        if (this.jj_2_81(3)) {
            operation = this.matchAdditiveOperator();
        }
        Expression operand = this.matchUnionExpression(context);
        if (operation >= 0) {
            return new UnaryExpression(operand.getToken(), operand, operation);
        }
        return operand;
    }

    public final Expression matchUnionExpression(StaticContext context) throws ParseException {
        Expression left_operand = this.matchIntersectExceptExpression(context);
        while (this.jj_2_82(3)) {
            Token union_token;
            if (this.jj_2_83(3)) {
                union_token = this.jj_consume_token(26);
            } else if (this.jj_2_84(3)) {
                union_token = this.jj_consume_token(27);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            Expression right_operand = this.matchIntersectExceptExpression(context);
            left_operand = new SequenceCombinationExpression(union_token, left_operand, SequenceCombinationExpression.UNION, right_operand);
        }
        return left_operand;
    }

    public final Expression matchIntersectExceptExpression(StaticContext context) throws ParseException {
        Expression left_operand = this.matchPathExpression(context);
        while (this.jj_2_85(3)) {
            int combin;
            Token token;
            if (this.jj_2_86(3)) {
                token = this.jj_consume_token(28);
                combin = SequenceCombinationExpression.INTERSECT;
            } else if (this.jj_2_87(3)) {
                token = this.jj_consume_token(29);
                combin = SequenceCombinationExpression.EXCEPT;
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            Expression right_operand = this.matchPathExpression(context);
            left_operand = new SequenceCombinationExpression(token, left_operand, combin, right_operand);
        }
        return left_operand;
    }

    public final Expression matchPathExpression(StaticContext context) throws ParseException {
        Expression expression = null;
        Token prefix = null;
        String prefix_string = null;
        Token focus_token = null;
        Token slash = null;
        if (this.jj_2_92(3)) {
            if (this.jj_2_88(3)) {
                this.jj_consume_token(74);
            }
            prefix = this.jj_consume_token(110);
            if (this.jj_2_89(3)) {
                slash = this.jj_consume_token(74);
            }
            if (this.jj_2_90(3)) {
                expression = this.matchRelativePathExpression(context, null, true);
            }
        } else if (this.jj_2_93(3)) {
            slash = this.jj_consume_token(74);
            if (this.jj_2_91(3)) {
                expression = this.matchRelativePathExpression(context, null, true);
            }
        } else if (this.jj_2_94(3)) {
            expression = this.matchRelativePathExpression(context, null, false);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_95(3)) {
            slash = this.jj_consume_token(74);
        }
        focus_token = slash;
        if (prefix != null) {
            prefix_string = prefix.image;
            if (focus_token == null) {
                focus_token = prefix;
            }
        }
        if (expression == null) {
            expression = new PathExpression(focus_token, prefix_string, null, true);
        } else if (expression instanceof PathExpression) {
            ((PathExpression)expression).setRootPrefix(prefix_string);
        }
        return expression;
    }

    public final Expression matchRelativePathExpression(StaticContext context, Token prefix, boolean absolute) throws ParseException {
        Expression expression = null;
        Expression left_step = null;
        Expression right_step = null;
        boolean path_created = false;
        boolean atomic_step_used = false;
        Token slash = null;
        Token slash2 = null;
        String prefix_string = null;
        Expression schema = null;
        left_step = this.matchGeneralStep(context, false);
        if (absolute) {
            if (absolute && !(left_step instanceof GeneralStepExpression)) {
                throw new StaticException("Absolute path with non axis step is non supported.", left_step.getToken());
            }
            if (prefix != null) {
                prefix_string = prefix.image;
            }
            if (left_step instanceof GeneralStepExpression) {
                expression = new PathExpression(prefix, prefix_string, null, true);
                ((PathExpression)expression).addStep((GeneralStepExpression)left_step);
            } else {
                expression = new PathExpression(prefix, prefix_string, left_step, false);
            }
            path_created = true;
        } else {
            expression = left_step;
        }
        while (this.jj_2_96(3)) {
            if (this.jj_2_97(3)) {
                slash = this.jj_consume_token(74);
            } else if (this.jj_2_98(3)) {
                slash2 = this.jj_consume_token(75);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            if (this.jj_2_99(3)) {
                this.jj_consume_token(84);
                schema = this.matchPathExpression(context);
                this.jj_consume_token(88);
            }
            right_step = this.matchGeneralStep(context, slash2 != null);
            if (atomic_step_used) {
                throw new StaticException("XPTY0019 - Right step in a path expression  must not follow an atomic value.", right_step.getToken());
            }
            if (right_step instanceof LiteralExpression) {
                atomic_step_used = true;
            }
            if (!(right_step instanceof GeneralStepExpression)) {
                right_step = new GeneralStepExpression(right_step);
            }
            if (!path_created) {
                expression = new PathExpression(left_step.getToken(), null, left_step, false);
                path_created = true;
            }
            if (schema != null) {
                ((GeneralStepExpression)right_step).setSchema(schema);
                schema = null;
            }
            ((PathExpression)expression).addStep((GeneralStepExpression)right_step);
            slash2 = null;
            slash = null;
        }
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final Expression matchGeneralStep(StaticContext context, boolean descendant_step) throws ParseException {
        String name;
        Token token;
        Object filter_step = null;
        Expression step = null;
        boolean attribute_step = false;
        short axis = 1;
        if (this.jj_2_107(3)) {
            return this.matchFilterExpression(context);
        }
        if (!this.jj_2_108(3)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (this.jj_2_102(3)) {
            token = this.jj_consume_token(104);
            name = "*";
            axis = 8;
        } else if (this.jj_2_103(3)) {
            token = this.jj_consume_token(103);
            name = ".";
            axis = 4;
        } else if (this.jj_2_104(3)) {
            token = this.matchQNameToken();
            name = token.image;
        } else if (this.jj_2_105(3)) {
            token = this.jj_consume_token(63);
            name = "*";
        } else {
            if (!this.jj_2_106(3)) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            this.jj_consume_token(85);
            if (this.jj_2_100(3)) {
                token = this.jj_consume_token(105);
                name = token.image;
                attribute_step = true;
            } else {
                if (!this.jj_2_101(3)) {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                token = this.jj_consume_token(63);
                name = "*";
                attribute_step = true;
            }
        }
        step = new GeneralStepExpression(token, name, axis, null);
        ((GeneralStepExpression)step).setIsAttributeStep(attribute_step);
        ((GeneralStepExpression)step).setIsDescendantStep(descendant_step);
        Expression predicatsList = this.matchPredicatsListExpression(context);
        ((GeneralStepExpression)step).setPredicatsList((PredicatsListExpression)predicatsList);
        return step;
    }

    public final Expression matchFilterExpression(StaticContext context) throws ParseException {
        Expression primaryExpression = this.matchPrimaryExpression(context);
        Expression predicatsList = this.matchPredicatsListExpression(context);
        if (!((PredicatsListExpression)predicatsList).isEmpty()) {
            primaryExpression = new FilterExpression(primaryExpression.getToken(), primaryExpression, predicatsList);
        }
        return primaryExpression;
    }

    public final Expression matchStepQualifier(StaticContext context) throws ParseException {
        this.jj_consume_token(87);
        Expression expression = this.matchExpression(context);
        this.jj_consume_token(89);
        return expression;
    }

    public final Expression matchPrimaryExpression(StaticContext context) throws ParseException {
        Token token = null;
        Expression expression = null;
        if (this.jj_2_109(3)) {
            expression = this.matchLiteralExpression(context);
        } else if (this.jj_2_110(3)) {
            expression = this.matchVariableReference(context);
        } else if (this.jj_2_111(3)) {
            token = this.jj_consume_token(84);
            this.jj_consume_token(88);
            expression = new EmptySequenceExpression(token);
        } else if (this.jj_2_112(3)) {
            this.jj_consume_token(84);
            expression = this.matchExpression(context);
            this.jj_consume_token(88);
        } else if (this.jj_2_113(3)) {
            expression = this.matchFunctionCallExpression(context);
        } else if (this.jj_2_114(3)) {
            expression = this.matchElementConstructorExpression(context);
        } else if (this.jj_2_115(3)) {
            expression = this.matchComputedConstructorExpression(context);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression matchPredicatsListExpression(StaticContext context) throws ParseException {
        PredicatsListExpression predicatsListExpression = new PredicatsListExpression("Predicats List", null);
        while (this.jj_2_116(3)) {
            Expression qualifier = this.matchStepQualifier(context);
            if (!this.predicats_warning_message_printed && qualifier instanceof SequenceExpression | qualifier instanceof RangeExpression) {
                this.logger.warn("Using a sequence or a range expression inside predicats in order to extract items placed on specific positions is not compliant to the W3C specification. If you want to do so you should use either only a numeric for a single position ( [2] for example ), or use the following syntax for multi positions extraction: [position() = " + qualifier + "].");
                this.predicats_warning_message_printed = true;
            }
            predicatsListExpression.addPredicate(qualifier);
        }
        return predicatsListExpression;
    }

    public final Expression matchVariableReference(StaticContext context) throws ParseException {
        this.token = this.jj_consume_token(109);
        QName variable_name = context.resolveQName(this.token.image.substring(1));
        if (!context.containsInScopeVariable(variable_name)) {
            throw new StaticException("XQ0008 - Undefined variable $" + variable_name, this.token);
        }
        VariableExpression variableExpression = new VariableExpression(this.token, variable_name);
        return variableExpression;
    }

    public final Expression matchComputedConstructorExpression(StaticContext context) throws ParseException {
        Expression expression = null;
        if (this.jj_2_117(3)) {
            expression = this.matchComputedElementConstructorExpression(context);
        } else if (this.jj_2_118(3)) {
            expression = this.matchComputedAttributeConstructorExpression(context);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return expression;
    }

    public final Expression matchComputedElementConstructorExpression(StaticContext context) throws ParseException {
        Token element = null;
        Token node_name = null;
        ComputedElementConstructorExpression expression = null;
        Expression node_name_expression = null;
        Expression content_expression = null;
        StaticContext inner_context = new StaticContext(context);
        element = this.jj_consume_token(6);
        if (this.jj_2_119(3)) {
            node_name = this.matchQNameToken();
            QName name = new QName(node_name.image);
            Namespace namespace = inner_context.getNamespace();
            if (name.getPrefix() != null && namespace != null && namespace.resolveNamespace(name.getPrefix()) == null) {
                throw new StaticException("XPST0081 - The prefix \"" + name.getPrefix() + "\" has not been bound.", element);
            }
            expression = new ComputedElementConstructorExpression(element, node_name.image);
        } else if (this.jj_2_120(3)) {
            this.jj_consume_token(45);
            node_name_expression = this.matchExpression(context);
            this.jj_consume_token(34);
            expression = new ComputedElementConstructorExpression(element, node_name_expression);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(45);
        if (this.jj_2_121(3)) {
            content_expression = this.matchExpression(context);
        }
        this.jj_consume_token(34);
        if (content_expression != null) {
            expression.addChildExpression(content_expression);
        }
        return expression;
    }

    public final Expression matchComputedAttributeConstructorExpression(StaticContext context) throws ParseException {
        Token attribute = null;
        Token attr_name = null;
        ComputedAttributeConstructorExpression expression = null;
        Expression attr_name_expression = null;
        Expression content_expression = null;
        StaticContext inner_context = new StaticContext(context);
        attribute = this.jj_consume_token(30);
        if (this.jj_2_122(3)) {
            attr_name = this.jj_consume_token(105);
            QName name = new QName(attr_name.image);
            Namespace namespace = inner_context.getNamespace();
            if (name.getPrefix() != null && namespace != null && namespace.resolveNamespace(name.getPrefix()) == null && !name.getPrefix().equals("xmlns")) {
                throw new StaticException("XPST0081 - The prefix \"" + name.getPrefix() + "\" has not been bound.", attribute);
            }
            expression = new ComputedAttributeConstructorExpression(attribute, attr_name.image);
        } else if (this.jj_2_123(3)) {
            this.jj_consume_token(45);
            attr_name_expression = this.matchExpression(context);
            this.jj_consume_token(34);
            expression = new ComputedAttributeConstructorExpression(attribute, attr_name_expression);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(45);
        if (this.jj_2_124(3)) {
            content_expression = this.matchExpression(context);
        }
        this.jj_consume_token(34);
        expression.setContentExpression(content_expression);
        return expression;
    }

    public final Expression matchElementConstructorExpression(StaticContext context) throws ParseException {
        ConstructorExpression element = null;
        Expression expression = null;
        Token start_tag = null;
        Token end_tag = null;
        Token content_token = null;
        String content_string = null;
        String node_name = null;
        StaticContext inner_context = new StaticContext(context);
        start_tag = this.jj_consume_token(33);
        node_name = start_tag.image.substring(1, start_tag.image.length());
        element = new ConstructorExpression(start_tag, node_name);
        this.matchAttribute(element, inner_context);
        if (this.jj_2_129(3)) {
            this.jj_consume_token(37);
        } else if (this.jj_2_130(3)) {
            this.jj_consume_token(38);
            while (this.jj_2_125(3)) {
                if (this.jj_2_126(3)) {
                    expression = this.matchElementConstructorExpression(inner_context);
                    element.addChildExpression(expression);
                    continue;
                }
                if (this.jj_2_127(3)) {
                    content_token = this.jj_consume_token(31);
                    content_string = content_token.image;
                    if (content_string.trim().equals("")) continue;
                    content_string = XmlString.decode(content_string);
                    element.addChildExpression(new LiteralExpression(content_token, new fr.gael.drb.value.String(content_string)));
                    element.setIsStringValue(true);
                    continue;
                }
                if (this.jj_2_128(3)) {
                    this.jj_consume_token(45);
                    expression = this.matchExpression(inner_context);
                    this.jj_consume_token(34);
                    element.addChildExpression(expression);
                    continue;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            end_tag = this.jj_consume_token(32);
            String end_name = end_tag.image.substring(2, end_tag.image.length() - 1);
            if (!end_name.equals(node_name)) {
                throw new StaticException("The end tag </" + end_name + "> does not match the start tag <" + node_name + "> at line " + start_tag.beginLine + ", column " + start_tag.beginColumn + ".", end_tag);
            }
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        QName name = new QName(node_name);
        Namespace namespace = inner_context.getNamespace();
        if (name.getPrefix() != null && namespace != null && namespace.resolveNamespace(name.getPrefix()) == null) {
            throw new StaticException("XP0008 - The prefix \"" + name.getPrefix() + "\" has not been bound.", start_tag);
        }
        return element;
    }

    public final void matchAttribute(ConstructorExpression element, StaticContext context) throws ParseException {
        Token value_tag = null;
        Expression expression = null;
        Vector<Expression> expression_list = new Vector<Expression>();
        QName name = null;
        Vector<Token> declared_attribute = new Vector<Token>();
        Namespace namespace = context.getNamespace();
        while (this.jj_2_131(3)) {
            String value_string;
            Token name_tag = this.jj_consume_token(105);
            this.jj_consume_token(39);
            if (this.jj_2_138(3)) {
                this.jj_consume_token(35);
                while (this.jj_2_132(3)) {
                    if (this.jj_2_133(3)) {
                        this.jj_consume_token(45);
                        expression = this.matchExpression(context);
                        this.jj_consume_token(34);
                        expression_list.add(expression);
                        continue;
                    }
                    if (this.jj_2_134(3)) {
                        value_tag = this.jj_consume_token(41);
                        value_string = value_tag.image;
                        value_string = XmlString.decode(value_string);
                        expression = new LiteralExpression(value_tag, new fr.gael.drb.value.String(value_string));
                        expression_list.add(expression);
                        continue;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(42);
            } else if (this.jj_2_139(3)) {
                this.jj_consume_token(36);
                while (this.jj_2_135(3)) {
                    if (this.jj_2_136(3)) {
                        this.jj_consume_token(45);
                        expression = this.matchExpression(context);
                        this.jj_consume_token(34);
                        expression_list.add(expression);
                        continue;
                    }
                    if (this.jj_2_137(3)) {
                        value_tag = this.jj_consume_token(43);
                        value_string = value_tag.image;
                        value_string = XmlString.decode(value_string);
                        expression = new LiteralExpression(value_tag, new fr.gael.drb.value.String(value_string));
                        expression_list.add(expression);
                        continue;
                    }
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(44);
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            name = new QName(name_tag.image.substring(0, name_tag.image.length()));
            if (name.getPrefix() != null && name.getPrefix().equals("xmlns")) {
                if (expression_list.size() > 1 || !(expression_list.get(0) instanceof LiteralExpression) || value_tag == null) {
                    throw new StaticException("XQ0022 - The namespace declaration attribute is not a literal string.", name_tag);
                }
                if (value_tag == null || value_tag.image.length() <= 0) {
                    throw new StaticException("XQ0053 - The URI of namespace prefix \"" + name + "\" cannot be a zero-length string.", value_tag);
                }
                if (name.getLocalName().equals("xml") && namespace.resolveNamespace("xml") != null) {
                    throw new StaticException("The \"xml\" prefix cannot be overriden.", name_tag);
                }
                namespace.bind(name.getLocalName(), value_tag.image);
                element.bindNamespace(name.getLocalName(), value_tag.image);
            } else if (name.getPrefix() == null && name.getLocalName().equals("xmlns")) {
                if (expression_list.size() > 1 || !(expression_list.get(0) instanceof LiteralExpression) || value_tag == null) {
                    throw new StaticException("XQ0022 - The default namespace  declaration attribute is not a literal string.", name_tag);
                }
                if (value_tag == null || value_tag.image.length() <= 0) {
                    throw new StaticException("XQ0053 - The URI of the default namespace declaration  cannot be a zero-length string.", value_tag);
                }
                context.setDefaultElementNamespaceURI(value_tag.image);
                element.setElementDefaultNamespaceURI(value_tag.image);
                if (namespace.resolvePrefix(value_tag.image) != null) {
                    element.bindNamespace(namespace.resolvePrefix(value_tag.image), value_tag.image);
                } else {
                    element.bindNamespace("", value_tag.image);
                }
            } else {
                element.addAttributeExpressions(name.getName(), expression_list);
                declared_attribute.add(name_tag);
            }
            expression_list = new Vector();
        }
        for (int iattr = 0; iattr < declared_attribute.size(); ++iattr) {
            Token attribute_token = (Token)declared_attribute.get(iattr);
            QName attribute_name = new QName(attribute_token.image);
            if (attribute_name.getPrefix() == null || namespace.resolveNamespace(attribute_name.getPrefix()) != null) continue;
            throw new StaticException("XP0008 - The prefix \"" + attribute_name.getPrefix() + "\" has not been bound.", attribute_token);
        }
        value_tag = null;
    }

    public final Expression matchLiteralExpression(StaticContext context) throws ParseException {
        boolean exponent = false;
        Token string_token = null;
        Token integer = null;
        Token decimal = null;
        Object exponent_token = null;
        Object exponent_sign = null;
        if (this.jj_2_140(3)) {
            string_token = this.jj_consume_token(100);
            String string = string_token.image.substring(1, string_token.image.length() - 1);
            fr.gael.drb.value.String value = new fr.gael.drb.value.String(XmlString.decode(string));
            return new LiteralExpression(string_token, value);
        }
        if (this.jj_2_141(3)) {
            integer = this.jj_consume_token(92);
            Integer value = new Integer(integer.image);
            return new LiteralExpression(integer, value);
        }
        if (this.jj_2_142(3)) {
            decimal = this.jj_consume_token(94);
            Decimal value = new Decimal(decimal.image);
            return new LiteralExpression(decimal, value);
        }
        if (this.jj_2_143(3)) {
            decimal = this.jj_consume_token(95);
            Double value = new Double(java.lang.Double.parseDouble(decimal.image));
            return new LiteralExpression(decimal, value);
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Expression matchFunctionCallExpression(StaticContext context) throws ParseException {
        Token name = this.matchQNameToken();
        this.jj_consume_token(84);
        FunctionCallExpression expression = new FunctionCallExpression(name, context.resolveQName(name.image, context.getDefaultFunctionNamespaceURI()));
        this.logger.debug("Function call: " + name.image + ", NS=" + context.resolveQName(name.image).getNamespaceURI());
        if (this.jj_2_145(3)) {
            Expression parameter = this.matchSingleExpression(context);
            expression.addParameter(parameter);
            while (this.jj_2_144(3)) {
                this.jj_consume_token(97);
                parameter = this.matchSingleExpression(context);
                expression.addParameter(parameter);
            }
        }
        this.jj_consume_token(88);
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_53(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_53();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(52, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_54(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_54();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(53, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_55(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_55();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(54, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_56(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_56();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(55, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_57(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_57();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(56, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_58(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_58();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(57, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_59(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_59();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(58, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_60(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_60();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(59, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_61(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_61();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(60, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_62(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_62();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(61, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_63(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_63();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(62, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_64(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_64();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(63, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_65(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_65();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(64, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_66(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_66();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(65, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_67(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_67();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(66, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_68(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_68();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(67, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_69(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_69();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(68, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_70(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_70();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(69, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_71(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_71();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(70, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_72(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_72();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(71, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_73(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_73();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(72, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_74(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_74();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(73, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_75(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_75();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(74, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_76(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_76();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(75, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_77(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_77();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(76, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_78(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_78();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(77, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_79(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_79();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(78, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_80(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_80();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(79, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_81(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_81();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(80, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_82(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_82();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(81, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_83(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_83();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(82, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_84(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_84();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(83, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_85(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_85();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(84, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_86(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_86();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(85, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_87(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_87();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(86, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_88(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_88();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(87, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_89(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_89();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(88, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_90(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_90();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(89, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_91(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_91();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(90, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_92(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_92();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(91, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_93(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_93();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(92, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_94(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_94();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(93, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_95(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_95();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(94, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_96(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_96();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(95, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_97(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_97();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(96, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_98(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_98();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(97, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_99(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_99();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(98, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_100(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_100();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(99, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_101(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_101();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(100, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_102(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_102();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(101, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_103(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_103();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(102, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_104(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_104();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(103, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_105(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_105();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(104, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_106(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_106();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(105, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_107(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_107();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(106, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_108(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_108();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(107, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_109(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_109();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(108, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_110(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_110();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(109, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_111(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_111();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(110, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_112(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_112();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(111, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_113(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_113();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(112, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_114(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_114();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(113, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_115(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_115();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(114, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_116(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_116();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(115, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_117(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_117();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(116, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_118(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_118();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(117, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_119(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_119();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(118, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_120(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_120();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(119, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_121(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_121();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(120, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_122(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_122();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(121, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_123(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_123();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(122, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_124(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_124();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(123, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_125(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_125();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(124, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_126(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_126();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(125, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_127(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_127();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(126, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_128(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_128();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(127, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_129(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_129();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(128, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_130(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_130();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(129, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_131(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_131();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(130, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_132(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_132();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(131, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_133(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_133();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(132, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_134(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_134();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(133, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_135(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_135();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(134, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_136(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_136();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(135, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_137(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_137();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(136, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_138(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_138();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(137, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_139(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_139();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(138, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_140(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_140();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(139, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_141(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_141();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(140, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_142(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_142();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(141, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_143(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_143();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(142, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_144(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_144();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(143, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean jj_2_145(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_145();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(144, xla);
        }
    }

    private boolean jj_3R_36() {
        if (this.jj_3R_37()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_73()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_128() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_101() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3_100() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3_1() {
        return this.jj_3R_21();
    }

    private boolean jj_3_72() {
        return this.jj_scan_token(78);
    }

    private boolean jj_3_127() {
        return this.jj_scan_token(31);
    }

    private boolean jj_3_71() {
        return this.jj_scan_token(81);
    }

    private boolean jj_3_70() {
        return this.jj_scan_token(77);
    }

    private boolean jj_3_106() {
        if (this.jj_scan_token(85)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_100()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_101()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_69() {
        return this.jj_scan_token(80);
    }

    private boolean jj_3_105() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3_68() {
        return this.jj_scan_token(76);
    }

    private boolean jj_3_104() {
        return this.jj_3R_25();
    }

    private boolean jj_3_67() {
        return this.jj_scan_token(39);
    }

    private boolean jj_3_125() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_126()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_127()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_128()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_126() {
        return this.jj_3R_51();
    }

    private boolean jj_3_103() {
        return this.jj_scan_token(103);
    }

    private boolean jj_3_102() {
        return this.jj_scan_token(104);
    }

    private boolean jj_3R_35() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_67()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_68()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_69()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_70()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_71()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_72()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_130() {
        Token xsp;
        if (this.jj_scan_token(38)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_125());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(32);
    }

    private boolean jj_3_129() {
        return this.jj_scan_token(37);
    }

    private boolean jj_3_108() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_102()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_103()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_104()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_105()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_106()) {
                            return true;
                        }
                    }
                }
            }
        }
        return this.jj_3R_47();
    }

    private boolean jj_3_107() {
        return this.jj_3R_46();
    }

    private boolean jj_3R_45() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_107()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_108()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_48() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3_47() {
        return this.jj_3R_22();
    }

    private boolean jj_3_66() {
        if (this.jj_3R_35()) {
            return true;
        }
        return this.jj_3R_36();
    }

    private boolean jj_3R_51() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_3R_59()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_129()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_130()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3R_34() {
        if (this.jj_3R_36()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_66()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_55()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_56()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_55() {
        if (this.jj_scan_token(90)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_47()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_48()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(64);
    }

    private boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3_57()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_57());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_124() {
        return this.jj_3R_23();
    }

    private boolean jj_3_13() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_65() {
        if (this.jj_scan_token(60)) {
            return true;
        }
        return this.jj_3R_34();
    }

    private boolean jj_3R_33() {
        Token xsp;
        if (this.jj_3R_34()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_65());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_98() {
        return this.jj_scan_token(75);
    }

    private boolean jj_3_123() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_14() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_13()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_11() {
        if (this.jj_scan_token(79)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_99() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_3R_43()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_46() {
        return this.jj_3R_32();
    }

    private boolean jj_3_97() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_45() {
        return this.jj_3R_31();
    }

    private boolean jj_3_96() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_97()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_98()) {
                return true;
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_99()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_45();
    }

    private boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_10()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_11()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_10() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_44() {
        return this.jj_3R_30();
    }

    private boolean jj_3_43() {
        return this.jj_3R_29();
    }

    private boolean jj_3_9() {
        return this.jj_3R_22();
    }

    private boolean jj_3_42() {
        return this.jj_3R_28();
    }

    private boolean jj_3_122() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3_41() {
        return this.jj_3R_27();
    }

    private boolean jj_3_64() {
        if (this.jj_scan_token(59)) {
            return true;
        }
        return this.jj_3R_33();
    }

    private boolean jj_3R_26() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_42()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_43()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_44()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_45()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_46()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3R_29() {
        Token xsp;
        if (this.jj_3R_33()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_64());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_55() {
        if (this.jj_scan_token(30)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_122()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_123()) {
                return true;
            }
        }
        return this.jj_scan_token(45);
    }

    private boolean jj_3_26() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_9()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_12()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_14()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_44() {
        Token xsp;
        if (this.jj_3R_45()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_96());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_24() {
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_28() {
        if (this.jj_scan_token(96)) {
            return true;
        }
        if (this.jj_scan_token(84)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3_121() {
        return this.jj_3R_23();
    }

    private boolean jj_3_89() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_29() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_3R_24();
    }

    private boolean jj_3_28() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3_30() {
        Token xsp;
        if (this.jj_scan_token(86)) {
            return true;
        }
        if (this.jj_3R_24()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_40() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_120() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_23() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_40());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_8() {
        return this.jj_scan_token(11);
    }

    private boolean jj_3_95() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_91() {
        return this.jj_3R_44();
    }

    private boolean jj_3_94() {
        return this.jj_3R_44();
    }

    private boolean jj_3_63() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        return this.jj_scan_token(24);
    }

    private boolean jj_3_7() {
        return this.jj_scan_token(10);
    }

    private boolean jj_3_90() {
        return this.jj_3R_44();
    }

    private boolean jj_3_88() {
        return this.jj_scan_token(74);
    }

    private boolean jj_3_93() {
        if (this.jj_scan_token(74)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_91()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_32() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_28()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_119() {
        return this.jj_3R_25();
    }

    private boolean jj_3_92() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_88()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(110)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_89()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_90()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_32() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_scan_token(66)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_63()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_25() {
        if (this.jj_scan_token(12)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_38() {
        return this.jj_scan_token(19);
    }

    private boolean jj_3_37() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3_39() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_36()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_37()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_38()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_36() {
        return this.jj_scan_token(83);
    }

    private boolean jj_3R_54() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_119()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_120()) {
                return true;
            }
        }
        return this.jj_scan_token(45);
    }

    private boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_92()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_93()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_94()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_95()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_24() {
        if (this.jj_scan_token(9)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_7()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_8()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_35() {
        return this.jj_3R_25();
    }

    private boolean jj_3_6() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_34() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_scan_token(84)) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_31() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_scan_token(23)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_87() {
        return this.jj_scan_token(29);
    }

    private boolean jj_3_86() {
        return this.jj_scan_token(28);
    }

    private boolean jj_3_5() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_33() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_scan_token(84)) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_85() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_86()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_87()) {
                return true;
            }
        }
        return this.jj_3R_43();
    }

    private boolean jj_3_84() {
        return this.jj_scan_token(27);
    }

    private boolean jj_3_118() {
        return this.jj_3R_55();
    }

    private boolean jj_3R_42() {
        Token xsp;
        if (this.jj_3R_43()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_85());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_117() {
        return this.jj_3R_54();
    }

    private boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_33()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_34()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_35()) {
                    return true;
                }
            }
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_39()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_117()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_118()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_61() {
        return this.jj_scan_token(67);
    }

    private boolean jj_3_4() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_scan_token(3)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_23() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_4()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_5()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_6()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_83() {
        return this.jj_scan_token(26);
    }

    private boolean jj_3R_30() {
        if (this.jj_scan_token(20)) {
            return true;
        }
        if (this.jj_scan_token(21)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_82() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_83()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_84()) {
                return true;
            }
        }
        return this.jj_3R_42();
    }

    private boolean jj_3_60() {
        return this.jj_scan_token(66);
    }

    private boolean jj_3R_57() {
        Token xsp;
        if (this.jj_3R_42()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_82());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_22() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private boolean jj_3R_49() {
        return this.jj_scan_token(109);
    }

    private boolean jj_3_137() {
        return this.jj_scan_token(43);
    }

    private boolean jj_3R_22() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        return this.jj_3R_56();
    }

    private boolean jj_3_62() {
        return this.jj_scan_token(68);
    }

    private boolean jj_3_59() {
        return this.jj_scan_token(105);
    }

    private boolean jj_3R_25() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_60()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_61()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_62()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_135() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_136()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_137()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_136() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3_31() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_24()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_25()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_26()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_27()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_3() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_31()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_32()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_81() {
        return this.jj_3R_38();
    }

    private boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_81()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_57();
    }

    private boolean jj_3_139() {
        Token xsp;
        if (this.jj_scan_token(36)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_135());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(44);
    }

    private boolean jj_3_21() {
        return this.jj_3R_22();
    }

    private boolean jj_3_134() {
        return this.jj_scan_token(41);
    }

    private boolean jj_3_80() {
        return this.jj_scan_token(62);
    }

    private boolean jj_3_79() {
        return this.jj_scan_token(61);
    }

    private boolean jj_3_78() {
        return this.jj_scan_token(63);
    }

    private boolean jj_3_116() {
        return this.jj_3R_53();
    }

    private boolean jj_3_132() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_133()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_134()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_133() {
        if (this.jj_scan_token(45)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(34);
    }

    private boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_78()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_79()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_80()) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean jj_3_58() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private boolean jj_3R_47() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_116());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_19() {
        return this.jj_3R_22();
    }

    private boolean jj_3_144() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private boolean jj_3_138() {
        Token xsp;
        if (this.jj_scan_token(35)) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_132());
        this.jj_scanpos = xsp;
        return this.jj_scan_token(42);
    }

    private boolean jj_3_18() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private boolean jj_3_131() {
        if (this.jj_scan_token(105)) {
            return true;
        }
        if (this.jj_scan_token(39)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_138()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_139()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_145() {
        Token xsp;
        if (this.jj_3R_26()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_144());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_59() {
        Token xsp;
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_131());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_54() {
        return this.jj_3R_22();
    }

    private boolean jj_3_16() {
        return this.jj_scan_token(7);
    }

    private boolean jj_3_77() {
        if (this.jj_3R_40()) {
            return true;
        }
        return this.jj_3R_41();
    }

    private boolean jj_3_53() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_54()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(79);
    }

    private boolean jj_3_115() {
        return this.jj_3R_52();
    }

    private boolean jj_3_114() {
        return this.jj_3R_51();
    }

    private boolean jj_3R_50() {
        if (this.jj_3R_25()) {
            return true;
        }
        if (this.jj_scan_token(84)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_145()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3R_39() {
        Token xsp;
        if (this.jj_3R_41()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_77());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_113() {
        return this.jj_3R_50();
    }

    private boolean jj_3_17() {
        return this.jj_3R_22();
    }

    private boolean jj_3_112() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_20() {
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_17()) {
            this.jj_scanpos = xsp;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_18());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3_111() {
        if (this.jj_scan_token(84)) {
            return true;
        }
        return this.jj_scan_token(88);
    }

    private boolean jj_3_110() {
        return this.jj_3R_49();
    }

    private boolean jj_3_109() {
        return this.jj_3R_48();
    }

    private boolean jj_3_76() {
        return this.jj_scan_token(82);
    }

    private boolean jj_3R_58() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_109()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_110()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_111()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_112()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_113()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_114()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3_115()) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_75() {
        return this.jj_scan_token(83);
    }

    private boolean jj_3_52() {
        return this.jj_3R_22();
    }

    private boolean jj_3_15() {
        if (this.jj_scan_token(65)) {
            return true;
        }
        return this.jj_scan_token(7);
    }

    private boolean jj_3R_38() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_75()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_76()) {
                return true;
            }
        }
        return false;
    }

    private boolean jj_3_143() {
        return this.jj_scan_token(95);
    }

    private boolean jj_3_2() {
        return this.jj_3R_21();
    }

    private boolean jj_3_27() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_15()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_16()) {
                return true;
            }
        }
        if (this.jj_scan_token(105)) {
            return true;
        }
        return this.jj_scan_token(84);
    }

    private boolean jj_3_56() {
        if (this.jj_scan_token(91)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_52()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(79);
    }

    private boolean jj_3_142() {
        return this.jj_scan_token(94);
    }

    private boolean jj_3_141() {
        return this.jj_scan_token(92);
    }

    private boolean jj_3R_53() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        if (this.jj_3R_23()) {
            return true;
        }
        return this.jj_scan_token(89);
    }

    private boolean jj_3_74() {
        if (this.jj_3R_38()) {
            return true;
        }
        return this.jj_3R_39();
    }

    private boolean jj_3R_37() {
        Token xsp;
        if (this.jj_3R_39()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_74());
        this.jj_scanpos = xsp;
        return false;
    }

    private boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_140()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_141()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_142()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_143()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean jj_3_140() {
        return this.jj_scan_token(100);
    }

    private boolean jj_3R_21() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_scan_token(68)) {
            return true;
        }
        return this.jj_scan_token(100);
    }

    private boolean jj_3_51() {
        if (this.jj_scan_token(86)) {
            return true;
        }
        return this.jj_scan_token(109);
    }

    private boolean jj_3_50() {
        return this.jj_3R_22();
    }

    private boolean jj_3_49() {
        if (this.jj_scan_token(97)) {
            return true;
        }
        if (this.jj_scan_token(109)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3_50()) {
            this.jj_scanpos = xsp;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3_51()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(64);
    }

    private boolean jj_3_73() {
        if (this.jj_scan_token(72)) {
            return true;
        }
        return this.jj_3R_37();
    }

    private boolean jj_3R_46() {
        if (this.jj_3R_58()) {
            return true;
        }
        return this.jj_3R_47();
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[0];
    }

    private static void jj_la1_init_1() {
        jj_la1_1 = new int[0];
    }

    private static void jj_la1_init_2() {
        jj_la1_2 = new int[0];
    }

    private static void jj_la1_init_3() {
        jj_la1_3 = new int[0];
    }

    public QueryParser(InputStream stream) {
        this(stream, null);
    }

    public QueryParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new JavaCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(Reader stream) {
        int i;
        this.jj_input_stream = new JavaCharStream(stream, 1, 1);
        this.token_source = new QueryParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public QueryParser(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(QueryParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 0; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            block1: for (int[] oldentry : this.jj_expentries) {
                if (oldentry.length != this.jj_expentry.length) continue;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] != this.jj_expentry[i]) continue block1;
                }
                this.jj_expentries.add(this.jj_expentry);
                break;
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[119];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 0; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) == 0) continue;
                la1tokens[96 + j] = true;
            }
        }
        for (i = 0; i < 119; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 145; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                            break;
                        }
                        case 52: {
                            this.jj_3_53();
                            break;
                        }
                        case 53: {
                            this.jj_3_54();
                            break;
                        }
                        case 54: {
                            this.jj_3_55();
                            break;
                        }
                        case 55: {
                            this.jj_3_56();
                            break;
                        }
                        case 56: {
                            this.jj_3_57();
                            break;
                        }
                        case 57: {
                            this.jj_3_58();
                            break;
                        }
                        case 58: {
                            this.jj_3_59();
                            break;
                        }
                        case 59: {
                            this.jj_3_60();
                            break;
                        }
                        case 60: {
                            this.jj_3_61();
                            break;
                        }
                        case 61: {
                            this.jj_3_62();
                            break;
                        }
                        case 62: {
                            this.jj_3_63();
                            break;
                        }
                        case 63: {
                            this.jj_3_64();
                            break;
                        }
                        case 64: {
                            this.jj_3_65();
                            break;
                        }
                        case 65: {
                            this.jj_3_66();
                            break;
                        }
                        case 66: {
                            this.jj_3_67();
                            break;
                        }
                        case 67: {
                            this.jj_3_68();
                            break;
                        }
                        case 68: {
                            this.jj_3_69();
                            break;
                        }
                        case 69: {
                            this.jj_3_70();
                            break;
                        }
                        case 70: {
                            this.jj_3_71();
                            break;
                        }
                        case 71: {
                            this.jj_3_72();
                            break;
                        }
                        case 72: {
                            this.jj_3_73();
                            break;
                        }
                        case 73: {
                            this.jj_3_74();
                            break;
                        }
                        case 74: {
                            this.jj_3_75();
                            break;
                        }
                        case 75: {
                            this.jj_3_76();
                            break;
                        }
                        case 76: {
                            this.jj_3_77();
                            break;
                        }
                        case 77: {
                            this.jj_3_78();
                            break;
                        }
                        case 78: {
                            this.jj_3_79();
                            break;
                        }
                        case 79: {
                            this.jj_3_80();
                            break;
                        }
                        case 80: {
                            this.jj_3_81();
                            break;
                        }
                        case 81: {
                            this.jj_3_82();
                            break;
                        }
                        case 82: {
                            this.jj_3_83();
                            break;
                        }
                        case 83: {
                            this.jj_3_84();
                            break;
                        }
                        case 84: {
                            this.jj_3_85();
                            break;
                        }
                        case 85: {
                            this.jj_3_86();
                            break;
                        }
                        case 86: {
                            this.jj_3_87();
                            break;
                        }
                        case 87: {
                            this.jj_3_88();
                            break;
                        }
                        case 88: {
                            this.jj_3_89();
                            break;
                        }
                        case 89: {
                            this.jj_3_90();
                            break;
                        }
                        case 90: {
                            this.jj_3_91();
                            break;
                        }
                        case 91: {
                            this.jj_3_92();
                            break;
                        }
                        case 92: {
                            this.jj_3_93();
                            break;
                        }
                        case 93: {
                            this.jj_3_94();
                            break;
                        }
                        case 94: {
                            this.jj_3_95();
                            break;
                        }
                        case 95: {
                            this.jj_3_96();
                            break;
                        }
                        case 96: {
                            this.jj_3_97();
                            break;
                        }
                        case 97: {
                            this.jj_3_98();
                            break;
                        }
                        case 98: {
                            this.jj_3_99();
                            break;
                        }
                        case 99: {
                            this.jj_3_100();
                            break;
                        }
                        case 100: {
                            this.jj_3_101();
                            break;
                        }
                        case 101: {
                            this.jj_3_102();
                            break;
                        }
                        case 102: {
                            this.jj_3_103();
                            break;
                        }
                        case 103: {
                            this.jj_3_104();
                            break;
                        }
                        case 104: {
                            this.jj_3_105();
                            break;
                        }
                        case 105: {
                            this.jj_3_106();
                            break;
                        }
                        case 106: {
                            this.jj_3_107();
                            break;
                        }
                        case 107: {
                            this.jj_3_108();
                            break;
                        }
                        case 108: {
                            this.jj_3_109();
                            break;
                        }
                        case 109: {
                            this.jj_3_110();
                            break;
                        }
                        case 110: {
                            this.jj_3_111();
                            break;
                        }
                        case 111: {
                            this.jj_3_112();
                            break;
                        }
                        case 112: {
                            this.jj_3_113();
                            break;
                        }
                        case 113: {
                            this.jj_3_114();
                            break;
                        }
                        case 114: {
                            this.jj_3_115();
                            break;
                        }
                        case 115: {
                            this.jj_3_116();
                            break;
                        }
                        case 116: {
                            this.jj_3_117();
                            break;
                        }
                        case 117: {
                            this.jj_3_118();
                            break;
                        }
                        case 118: {
                            this.jj_3_119();
                            break;
                        }
                        case 119: {
                            this.jj_3_120();
                            break;
                        }
                        case 120: {
                            this.jj_3_121();
                            break;
                        }
                        case 121: {
                            this.jj_3_122();
                            break;
                        }
                        case 122: {
                            this.jj_3_123();
                            break;
                        }
                        case 123: {
                            this.jj_3_124();
                            break;
                        }
                        case 124: {
                            this.jj_3_125();
                            break;
                        }
                        case 125: {
                            this.jj_3_126();
                            break;
                        }
                        case 126: {
                            this.jj_3_127();
                            break;
                        }
                        case 127: {
                            this.jj_3_128();
                            break;
                        }
                        case 128: {
                            this.jj_3_129();
                            break;
                        }
                        case 129: {
                            this.jj_3_130();
                            break;
                        }
                        case 130: {
                            this.jj_3_131();
                            break;
                        }
                        case 131: {
                            this.jj_3_132();
                            break;
                        }
                        case 132: {
                            this.jj_3_133();
                            break;
                        }
                        case 133: {
                            this.jj_3_134();
                            break;
                        }
                        case 134: {
                            this.jj_3_135();
                            break;
                        }
                        case 135: {
                            this.jj_3_136();
                            break;
                        }
                        case 136: {
                            this.jj_3_137();
                            break;
                        }
                        case 137: {
                            this.jj_3_138();
                            break;
                        }
                        case 138: {
                            this.jj_3_139();
                            break;
                        }
                        case 139: {
                            this.jj_3_140();
                            break;
                        }
                        case 140: {
                            this.jj_3_141();
                            break;
                        }
                        case 141: {
                            this.jj_3_142();
                            break;
                        }
                        case 142: {
                            this.jj_3_143();
                            break;
                        }
                        case 143: {
                            this.jj_3_144();
                            break;
                        }
                        case 144: {
                            this.jj_3_145();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        QueryParser.jj_la1_init_0();
        QueryParser.jj_la1_init_1();
        QueryParser.jj_la1_init_2();
        QueryParser.jj_la1_init_3();
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }
}

