/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.query;

import fr.gael.drb.DrbDefaultSequence;
import fr.gael.drb.DrbSequence;
import fr.gael.drb.query.AbstractExpression;
import fr.gael.drb.query.DynamicContext;
import fr.gael.drb.query.DynamicException;
import fr.gael.drb.query.Expression;
import fr.gael.drb.query.Token;
import fr.gael.drb.query.TypeException;
import fr.gael.drb.value.Arithmetic;
import fr.gael.drb.value.Integer;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;

class UnaryExpression
extends AbstractExpression {
    protected static int PLUS = 0;
    protected static int MINUS = 1;
    private Expression operand;
    private int operation;

    public UnaryExpression(Token token, Expression operand, int operation) {
        super("Unary", token);
        this.operand = operand;
        this.operation = operation;
    }

    public String toString() {
        String operation_string = this.operation == PLUS ? "+" : (this.operation == MINUS ? "-" : "(unkown arithmetic operation #" + this.operation + ")");
        return "(" + operation_string + this.operand + ")";
    }

    @Override
    public DrbSequence evaluate(DynamicContext context) {
        DrbSequence sequence = this.operand.evaluate(context);
        if (sequence == null) {
            throw new DynamicException(this, "Error while evaluating the operand expression");
        }
        if (this.operation == PLUS) {
            return sequence;
        }
        ValueArray array = sequence.atomize();
        if (array.length() == 0) {
            return array;
        }
        if (array.length() > 1) {
            throw new TypeException(this, "The sequence length of operand is greater than one");
        }
        Value value = array.getElement(0);
        DrbDefaultSequence ouput_sequence = new DrbDefaultSequence();
        if (value instanceof Arithmetic) {
            Value zero = new Integer(0);
            try {
                zero = zero.convertTo(value.getType());
            }
            catch (ClassCastException e) {
                throw new DynamicException(this, e.getMessage());
            }
            ouput_sequence.add(((Arithmetic)((Object)zero)).sub(value));
            return ouput_sequence;
        }
        throw new TypeException(this, "Invalid type of operand (should derive from Arithmetic type)");
    }
}

