/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.value;

import fr.gael.drb.value.AbstractNumeric;
import fr.gael.drb.value.Comparison;
import fr.gael.drb.value.Numeric;
import fr.gael.drb.value.UnsignedLong;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueFormat;
import java.text.DecimalFormat;

public class Long
extends AbstractNumeric
implements ValueFormat {
    public static final int PRIORITY = 4;
    protected long value;

    public Long(long v) {
        this.value = v;
    }

    public String toString() {
        return java.lang.Long.toString(this.value);
    }

    @Override
    public String getFormattedString(int length) {
        String zero_string = "";
        for (int i_zero = 0; i_zero < length - 1; ++i_zero) {
            zero_string = zero_string + "0";
        }
        return new String(new DecimalFormat("+" + zero_string + ";-" + zero_string).format(this.value));
    }

    @Override
    public byte[] getFormattedBuffer() {
        byte[] buffer = new byte[]{(byte)(this.value >>> 56), (byte)(this.value >>> 48), (byte)(this.value >>> 40), (byte)(this.value >>> 32), (byte)(this.value >>> 24), (byte)(this.value >>> 16), (byte)(this.value >>> 8), (byte)this.value};
        return buffer;
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public final int getPriority() {
        return 4;
    }

    @Override
    public Value convertTo(int type) throws ClassCastException {
        switch (type) {
            case 4: 
            case 9: {
                return this;
            }
        }
        return super.convertTo(type);
    }

    @Override
    public void assign(Value v) {
        Numeric vl = (Numeric)v.convertTo(9);
        this.value = vl.longValue();
    }

    @Override
    public Value unaryMinus() {
        return new Long(-this.value);
    }

    @Override
    public Value add(Value x) {
        if (this.getPriority() < x.getPriority()) {
            return ((Numeric)this.convertTo(x.getType())).add(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        if (this.doubleValue() + num.doubleValue() > 9.223372036854776E18) {
            return new UnsignedLong(this.longValue() + num.longValue());
        }
        return new Long(this.longValue() + num.longValue());
    }

    @Override
    public Value sub(Value x) {
        if (this.getPriority() < x.getPriority()) {
            ((Numeric)this.convertTo(x.getType())).sub(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        if (this.doubleValue() - num.doubleValue() > 9.223372036854776E18) {
            return new UnsignedLong(this.longValue() - num.longValue());
        }
        return new Long(this.longValue() - num.longValue());
    }

    @Override
    public Value multiply(Value x) {
        if (this.getPriority() < x.getPriority()) {
            ((Numeric)this.convertTo(x.getType())).multiply(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        if (this.doubleValue() * num.doubleValue() > 9.223372036854776E18) {
            return new UnsignedLong(this.longValue() * num.longValue());
        }
        return new Long(this.longValue() * num.longValue());
    }

    @Override
    public final Value divide(Value x) {
        if (this.getPriority() < x.getPriority()) {
            ((Numeric)this.convertTo(x.getType())).divide(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        if (this.doubleValue() / num.doubleValue() > 9.223372036854776E18) {
            return new UnsignedLong(this.longValue() / num.longValue());
        }
        return new Long(this.longValue() / num.longValue());
    }

    @Override
    public Value modulus(Value x) {
        if (this.getPriority() < x.getPriority()) {
            ((Numeric)this.convertTo(x.getType())).modulus(x);
        }
        Numeric num = (Numeric)x.convertTo(9);
        if (this.doubleValue() % num.doubleValue() > 9.223372036854776E18) {
            return new UnsignedLong(this.longValue() % num.longValue());
        }
        return new Long(this.longValue() % num.longValue());
    }

    @Override
    public int compareTo(Value x) {
        if (this.getPriority() >= x.getPriority()) {
            long v2 = ((Numeric)x).longValue();
            if (this.value == v2) {
                return 0;
            }
            if (this.value < v2) {
                return -1;
            }
            return 1;
        }
        return -((Comparison)((Object)x)).compareTo(this);
    }

    @Override
    public final boolean booleanValue() {
        return this.value != 0L;
    }

    @Override
    public final byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public final short shortValue() {
        return (short)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final float floatValue() {
        return this.value;
    }

    @Override
    public final double doubleValue() {
        return this.value;
    }

    @Override
    public final void assign(boolean value) {
        this.value = value ? 1 : 0;
    }

    @Override
    public final void assign(byte value) {
        this.value = value;
    }

    @Override
    public final void assign(short value) {
        this.value = value;
    }

    @Override
    public final void assign(int value) {
        this.value = value;
    }

    @Override
    public final void assign(long value) {
        this.value = value;
    }

    @Override
    public final void assign(float value) {
        this.value = (long)value;
    }

    @Override
    public final void assign(double value) {
        this.value = (long)value;
    }
}

