/*
 * Decompiled with CFR 0.152.
 */
package fr.gael.drb.xsd;

import fr.gael.drb.DrbDefaultAttribute;
import fr.gael.drb.DrbDefaultAttributeList;
import fr.gael.drb.DrbDefaultMutableNode;
import fr.gael.drb.DrbNode;
import fr.gael.drb.value.Boolean;
import fr.gael.drb.value.ByteArray;
import fr.gael.drb.value.Float;
import fr.gael.drb.value.FloatArray;
import fr.gael.drb.value.String;
import fr.gael.drb.value.Value;
import fr.gael.drb.value.ValueArray;
import fr.gael.drb.xsd.XmlSchema;
import fr.gael.drb.xsd.XsdAtomicType;
import fr.gael.drb.xsd.XsdFacet;
import fr.gael.drb.xsd.XsdInvalid;
import fr.gael.drb.xsd.XsdMaxInclusiveFacet;
import fr.gael.drb.xsd.XsdMinInclusiveFacet;
import fr.gael.drb.xsd.XsdSimpleType;

public class XsdListType
extends XsdSimpleType {
    private XsdSimpleType itemType;
    static final java.lang.String TAG = "list";
    static final java.lang.String ITEM_TYPE_TAG = "itemType";
    public static final int LIST_METHOD = 3;

    public XsdListType(java.lang.String name, XsdSimpleType base_type, XsdFacet[] facets) {
        super(name, base_type);
        if (facets == null) {
            facets = new XsdFacet[]{};
        }
        this.facets = facets;
        if (base_type == null || base_type.getVariety() == 3) {
            this.itemType = ((XsdListType)base_type).getItemType();
            this.derivationMethod = 2;
        } else {
            this.itemType = base_type;
            this.derivationMethod = 3;
        }
        this.finals = 4;
    }

    public XsdListType(XsdSimpleType item_type, XsdFacet[] facets) {
        this(null, item_type, facets);
    }

    @Override
    DrbNode toNode() {
        if (this.getBase() != this.getItemType()) {
            return super.toNode();
        }
        DrbDefaultMutableNode typeNode = new DrbDefaultMutableNode("simpleType");
        typeNode.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
        if (this.getName() != null) {
            DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
            attributes.add(new DrbDefaultAttribute("name", (Value)new String(this.getName()), typeNode));
            typeNode.setAttributes(attributes);
        }
        if (this.getItemType() != null) {
            DrbDefaultMutableNode listNode = new DrbDefaultMutableNode(TAG);
            listNode.setNamespaceURI("http://www.w3.org/2001/XMLSchema");
            DrbDefaultAttributeList attributes = new DrbDefaultAttributeList();
            XmlSchema itemSchema = this.itemType.schema;
            if (itemSchema != null && this.itemType.getName() != null) {
                java.lang.String item_name = this.itemType.getName();
                if (itemSchema != null) {
                    java.lang.String prefix = itemSchema.namespaces.resolvePrefix(this.itemType.getTargetNamespace());
                    if (prefix == null && "http://www.w3.org/2001/XMLSchema".equals(this.itemType.getTargetNamespace())) {
                        prefix = "xs";
                    }
                    if (prefix != null) {
                        item_name = prefix + ":" + this.itemType.getName();
                    }
                }
                attributes.add(new DrbDefaultAttribute(ITEM_TYPE_TAG, (Value)new String(item_name), listNode));
                listNode.setAttributes(attributes);
            } else {
                DrbNode itemNode = this.itemType.toNode();
                if (itemNode != null) {
                    listNode.appendChild(itemNode);
                }
            }
            typeNode.appendChild(listNode);
            for (int i = 0; i < this.getFacets().length; ++i) {
                DrbNode facetNode = this.getFacets()[i].toNode();
                if (facetNode == null) continue;
                listNode.appendChild(facetNode);
            }
        }
        return typeNode;
    }

    @Override
    public final int getVariety() {
        return 3;
    }

    public final XsdSimpleType getItemType() {
        return this.itemType;
    }

    @Override
    public final int getTypeId() {
        return 10;
    }

    public int getItemTypeId() {
        if (this.itemType != null) {
            return this.itemType.getTypeId();
        }
        return -2;
    }

    @Override
    public Value getValue(java.lang.String text) {
        return new String(text).convertTo(10);
    }

    @Override
    public boolean isOrdered() {
        return false;
    }

    @Override
    public int getOrderRelation() {
        return 0;
    }

    @Override
    public boolean isBounded() {
        return false;
    }

    @Override
    public Value getInclusiveLowerBound() {
        return null;
    }

    @Override
    public Value getInclusiveUpperBound() {
        return null;
    }

    @Override
    public Value getExclusiveLowerBound() {
        return null;
    }

    @Override
    public Value getExclusiveUpperBound() {
        return null;
    }

    @Override
    public int getCardinality() {
        return 3;
    }

    @Override
    public boolean isNumeric() {
        return false;
    }

    @Override
    protected boolean isValidType(Value value) {
        if (value == null) {
            return false;
        }
        try {
            ValueArray array = (ValueArray)value.convertTo(10);
            if (array.getArrayType() == -2 || array.getArrayType() == -1) {
                for (int i = 0; i < array.length(); ++i) {
                    if (this.getItemType().isValidType(array.getElement(i))) continue;
                    return false;
                }
            } else if (array.length() > 0) {
                return this.getItemType().isValidType(array.getElement(0));
            }
        }
        catch (ClassCastException e) {
            return false;
        }
        return true;
    }

    @Override
    public XsdInvalid validate(Value value) {
        XsdInvalid invalid = super.validate(value);
        if (invalid == null) {
            ValueArray array = (ValueArray)value.convertTo(10);
            for (int i = 0; i < array.length() && (invalid = this.getItemType().validate(array.getElement(i))) == null; ++i) {
            }
        }
        return invalid;
    }

    public static void main(java.lang.String[] args) {
        System.out.println("Test 1 : <xsd:simpleType name='listOfFloat'>");
        System.out.println("           <xsd:list>");
        System.out.println("             <xsd:simpleType>");
        System.out.println("               <xsd:restriction base='xsd:float'>");
        System.out.println("                 <xsd:minInclusive value='10'/>");
        System.out.println("                 <xsd:maxInclusive value='40'/>");
        System.out.println("               </xsd:restriction>");
        System.out.println("             <xsd:simpleType>");
        System.out.println("           </xsd:list>");
        System.out.println("         </xsd:simpleType>");
        XsdFacet[] facets = new XsdFacet[]{new XsdMinInclusiveFacet(new Float(10.0f)), new XsdMaxInclusiveFacet(new Float(40.0f))};
        XsdAtomicType atomic = new XsdAtomicType(5, facets);
        XsdListType list = new XsdListType("listOfFloat", atomic, null);
        FloatArray floatList = new FloatArray(new float[]{10.0f, 20.0f, 30.0f});
        FloatArray floatList2 = new FloatArray(new float[]{10.0f, 50.0f, 30.0f});
        Value stringList1 = new String("10.0 20.0 30.0").convertTo(10);
        Value stringList2 = new String("10.0 20.0 300.0").convertTo(10);
        ByteArray byteList = new ByteArray(new byte[]{10, 20, 30});
        Boolean booleanValue = new Boolean(true);
        System.out.println("Checking floatList (" + floatList + ") -> " + list.validate(floatList));
        System.out.println("Checking floatList (" + floatList2 + ") -> " + list.validate(floatList2));
        System.out.println("Checking stringList1 (" + stringList1 + ") -> " + list.validate(stringList1));
        System.out.println("Checking stringList2 (" + stringList2 + ") -> " + list.validate(stringList2));
        System.out.println("Checking byteList (" + byteList + ") -> " + list.validate(byteList));
        System.out.println("Checking booleanValue (" + booleanValue + ") -> " + list.validate(booleanValue));
    }
}

