/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VarExprList {
    private List vars;
    private Map exprs;

    public VarExprList(List vars) {
        this.vars = vars;
        this.exprs = new HashMap();
    }

    public VarExprList() {
        this.vars = new ArrayList();
        this.exprs = new HashMap();
    }

    public List getVars() {
        return this.vars;
    }

    public Map getExprs() {
        return this.exprs;
    }

    public boolean contains(Var var) {
        return this.vars.contains((Object)var);
    }

    public boolean hasExpr(Var var) {
        return this.exprs.containsKey((Object)var);
    }

    public Expr getExpr(Var var) {
        return (Expr)this.exprs.get((Object)var);
    }

    public Node get(Var var, Binding binding, FunctionEnv funcEnv) {
        Expr expr = (Expr)this.exprs.get((Object)var);
        if (expr == null) {
            return binding.get(var);
        }
        try {
            NodeValue nv = expr.eval(binding, funcEnv);
            if (nv == null) {
                return null;
            }
            return nv.asNode();
        }
        catch (ExprEvalException ex) {
            return null;
        }
    }

    public void add(Var var) {
        if (!this.vars.contains((Object)var)) {
            this.vars.add(var);
        }
    }

    public void add(Var var, Expr expr) {
        if (var == null) {
            throw new ARQInternalErrorException("Attempt to add a named expression with a null variable");
        }
        if (this.exprs.containsKey((Object)var)) {
            throw new ARQInternalErrorException("Attempt to assign an expression again");
        }
        this.add(var);
        this.exprs.put(var, expr);
    }

    public int size() {
        return this.vars.size();
    }

    public boolean isEmpty() {
        return this.vars.isEmpty();
    }

    public int hashCode() {
        int x = ((Object)this.vars).hashCode() ^ ((Object)this.exprs).hashCode();
        return ((Object)this.vars).hashCode() ^ ((Object)this.exprs).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof VarExprList)) {
            return false;
        }
        VarExprList x = (VarExprList)other;
        return Utils.eq(this.vars, x.vars) && Utils.eq(this.exprs, x.exprs);
    }
}

