/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.main;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitorBase;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.core.Var;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class VarFinder {
    VarUsageVisitor varUsageVisitor;

    public static Set optDefined(Op op) {
        return VarUsageVisitor.apply((Op)op).optDefines;
    }

    public static Set fixed(Op op) {
        return VarUsageVisitor.apply((Op)op).defines;
    }

    public VarFinder(Op op) {
        this.varUsageVisitor = VarUsageVisitor.apply(op);
    }

    public Set getOpt() {
        return this.varUsageVisitor.optDefines;
    }

    public Set getFilter() {
        return this.varUsageVisitor.filterMentions;
    }

    public Set getFixed() {
        return this.varUsageVisitor.defines;
    }

    private static class VarUsageVisitor
    extends OpVisitorBase {
        Set defines = null;
        Set optDefines = null;
        Set filterMentions = null;

        static VarUsageVisitor apply(Op op) {
            VarUsageVisitor v = new VarUsageVisitor();
            op.visit(v);
            return v;
        }

        VarUsageVisitor() {
            this.defines = new HashSet();
            this.optDefines = new HashSet();
            this.filterMentions = new HashSet();
        }

        VarUsageVisitor(Set _defines, Set _optDefines, Set _filterMentions) {
            this.defines = _defines;
            this.optDefines = _optDefines;
            this.filterMentions = _filterMentions;
        }

        public void visit(OpQuadPattern quadPattern) {
            this.slot(quadPattern.getGraphNode());
            List quads = quadPattern.getQuads();
            Iterator iter = quads.iterator();
            while (iter.hasNext()) {
                Quad quad = (Quad)iter.next();
                this.slot(quad.getSubject());
                this.slot(quad.getPredicate());
                this.slot(quad.getObject());
            }
        }

        public void visit(OpBGP opBGP) {
            BasicPattern triples = opBGP.getPattern();
            ListIterator iter = triples.iterator();
            while (iter.hasNext()) {
                Triple triple = (Triple)iter.next();
                this.slot(triple.getSubject());
                this.slot(triple.getPredicate());
                this.slot(triple.getObject());
            }
        }

        private void slot(Node node) {
            if (Var.isVar(node)) {
                this.defines.add(Var.alloc(node));
            }
        }

        public void visit(OpExt opExt) {
            opExt.effectiveOp().visit(this);
        }

        public void visit(OpJoin opJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        public void visit(OpLeftJoin opLeftJoin) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opLeftJoin.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opLeftJoin.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.optDefines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
            if (opLeftJoin.getExprs() != null) {
                opLeftJoin.getExprs().varsMentioned(this.filterMentions);
            }
        }

        public void visit(OpUnion opUnion) {
            VarUsageVisitor leftUsage = VarUsageVisitor.apply(opUnion.getLeft());
            VarUsageVisitor rightUsage = VarUsageVisitor.apply(opUnion.getRight());
            this.defines.addAll(leftUsage.defines);
            this.optDefines.addAll(leftUsage.optDefines);
            this.filterMentions.addAll(leftUsage.filterMentions);
            this.defines.addAll(rightUsage.defines);
            this.optDefines.addAll(rightUsage.optDefines);
            this.filterMentions.addAll(rightUsage.filterMentions);
        }

        public void visit(OpGraph opGraph) {
            this.slot(opGraph.getNode());
        }

        public void visit(OpFilter opFilter) {
            opFilter.getExprs().varsMentioned(this.filterMentions);
            opFilter.getSubOp().visit(this);
        }
    }
}

