# collibra-data-classification
<p>The Catalog API offers functionality related to the catalog product.<br/> It is mainly focused on facilitating the ingestion of information into Catalog. The API enables users to more easily connect Catalog to sources that are not necessarily natively supported in the product. </p>

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 1.0
- Package version: 1.0.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python &gt;&#x3D;3.7

## Migration from other generators like python and python-legacy

### Changes
1. This generator uses spec case for all (object) property names and parameter names.
    - So if the spec has a property name like camelCase, it will use camelCase rather than camel_case
    - So you will need to update how you input and read properties to use spec case
2. Endpoint parameters are stored in dictionaries to prevent collisions (explanation below)
    - So you will need to update how you pass data in to endpoints
3. Endpoint responses now include the original response, the deserialized response body, and (todo)the deserialized headers
    - So you will need to update your code to use response.body to access deserialized data
4. All validated data is instantiated in an instance that subclasses all validated Schema classes and Decimal/str/list/tuple/frozendict/NoneClass/BoolClass/bytes/io.FileIO
    - This means that you can use isinstance to check if a payload validated against a schema class
    - This means that no data will be of type None/True/False
        - ingested None will subclass NoneClass
        - ingested True will subclass BoolClass
        - ingested False will subclass BoolClass
        - So if you need to check is True/False/None, instead use instance.is_true_oapg()/.is_false_oapg()/.is_none_oapg()
5. All validated class instances are immutable except for ones based on io.File
    - This is because if properties were changed after validation, that validation would no longer apply
    - So no changing values or property values after a class has been instantiated
6. String + Number types with formats
    - String type data is stored as a string and if you need to access types based on its format like date,
    date-time, uuid, number etc then you will need to use accessor functions on the instance
    - type string + format: See .as_date_oapg, .as_datetime_oapg, .as_decimal_oapg, .as_uuid_oapg
    - type number + format: See .as_float_oapg, .as_int_oapg
    - this was done because openapi/json-schema defines constraints. string data may be type string with no format
    keyword in one schema, and include a format constraint in another schema
    - So if you need to access a string format based type, use as_date_oapg/as_datetime_oapg/as_decimal_oapg/as_uuid_oapg
    - So if you need to access a number format based type, use as_int_oapg/as_float_oapg
7. Property access on AnyType(type unset) or object(dict) schemas
    - Only required keys with valid python names are properties like .someProp and have type hints
    - All optional keys may not exist, so properties are not defined for them
    - One can access optional values with dict_instance['optionalProp'] and KeyError will be raised if it does not exist
    - Use get_item_oapg if you need a way to always get a value whether or not the key exists
        - If the key does not exist, schemas.unset is returned from calling dict_instance.get_item_oapg('optionalProp')
        - All required and optional keys have type hints for this method, and @typing.overload is used
        - A type hint is also generated for additionalProperties accessed using this method
    - So you will need to update you code to use some_instance['optionalProp'] to access optional property
    and additionalProperty values
8. The location of the api classes has changed
    - Api classes are located in your_package.apis.tags.some_api
    - This change was made to eliminate redundant code generation
    - Legacy generators generated the same endpoint twice if it had > 1 tag on it
    - This generator defines an endpoint in one class, then inherits that class to generate
      apis by tags and by paths
    - This change reduces code and allows quicker run time if you use the path apis
        - path apis are at your_package.apis.paths.some_path
    - Those apis will only load their needed models, which is less to load than all of the resources needed in a tag api
    - So you will need to update your import paths to the api classes

### Why are Oapg and _oapg used in class and method names?
Classes can have arbitrarily named properties set on them
Endpoints can have arbitrary operationId method names set
For those reasons, I use the prefix Oapg and _oapg to greatly reduce the likelihood of collisions
on protected + public classes/methods.
oapg stands for OpenApi Python Generator.

### Object property spec case
This was done because when payloads are ingested, they can be validated against N number of schemas.
If the input signature used a different property name then that has mutated the payload.
So SchemaA and SchemaB must both see the camelCase spec named variable.
Also it is possible to send in two properties, named camelCase and camel_case in the same payload.
That use case should be support so spec case is used.

### Parameter spec case
Parameters can be included in different locations including:
- query
- path
- header
- cookie

Any of those parameters could use the same parameter names, so if every parameter
was included as an endpoint parameter in a function signature, they would collide.
For that reason, each of those inputs have been separated out into separate typed dictionaries:
- query_params
- path_params
- header_params
- cookie_params

So when updating your code, you will need to pass endpoint parameters in using those
dictionaries.

### Endpoint responses
Endpoint responses have been enriched to now include more information.
Any response reom an endpoint will now include the following properties:
response: urllib3.HTTPResponse
body: typing.Union[Unset, Schema]
headers: typing.Union[Unset, TODO]
Note: response header deserialization has not yet been added


## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import collibra_data_classification
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import collibra_data_classification
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import collibra_data_classification
from pprint import pprint
from collibra_data_classification.apis.tags import data_classification_api
from collibra_data_classification.model.add_classification_match_request import AddClassificationMatchRequest
from collibra_data_classification.model.add_classification_matches_request import AddClassificationMatchesRequest
from collibra_data_classification.model.add_classification_request import AddClassificationRequest
from collibra_data_classification.model.change_classification_match_request import ChangeClassificationMatchRequest
from collibra_data_classification.model.change_classification_request import ChangeClassificationRequest
from collibra_data_classification.model.classification import Classification
from collibra_data_classification.model.classification_match import ClassificationMatch
from collibra_data_classification.model.classify_request import ClassifyRequest
from collibra_data_classification.model.find_classification_matches_request import FindClassificationMatchesRequest
from collibra_data_classification.model.find_classifications_request import FindClassificationsRequest
from collibra_data_classification.model.paged_response_classification import PagedResponseClassification
from collibra_data_classification.model.paged_response_classification_match import PagedResponseClassificationMatch
# Defining the host is optional and defaults to http://localhost/rest/catalog/1.0
# See configuration.py for a list of all supported configuration parameters.
configuration = collibra_data_classification.Configuration(
    host = "http://localhost/rest/catalog/1.0"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = collibra_data_classification.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure Bearer authorization (JWT): bearerAuth
configuration = collibra_data_classification.Configuration(
    access_token = 'YOUR_BEARER_TOKEN'
)

# Enter a context with an instance of the API client
with collibra_data_classification.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = data_classification_api.DataClassificationApi(api_client)
    add_classification_request = AddClassificationRequest(
        name="name_example",
    ) # AddClassificationRequest | The request with data needed for creation of new classification. (optional)

    try:
        # Adds new Classification
        api_response = api_instance.add_classification(add_classification_request=add_classification_request)
        pprint(api_response)
    except collibra_data_classification.ApiException as e:
        print("Exception when calling DataClassificationApi->add_classification: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost/rest/catalog/1.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataClassificationApi* | [**add_classification**](docs/apis/tags/DataClassificationApi.md#add_classification) | **post** /dataClassification/classifications | Adds new Classification
*DataClassificationApi* | [**add_classification_match**](docs/apis/tags/DataClassificationApi.md#add_classification_match) | **post** /dataClassification/classificationMatches | Adds new Classification Match
*DataClassificationApi* | [**add_classification_matches**](docs/apis/tags/DataClassificationApi.md#add_classification_matches) | **post** /dataClassification/classificationMatches/bulk | Adds new Classification Matches
*DataClassificationApi* | [**change_classification**](docs/apis/tags/DataClassificationApi.md#change_classification) | **patch** /dataClassification/classifications/{classificationId} | Changes existing Classification
*DataClassificationApi* | [**change_classification_match**](docs/apis/tags/DataClassificationApi.md#change_classification_match) | **patch** /dataClassification/classificationMatches/{classificationMatchId} | Changes a Classification Match
*DataClassificationApi* | [**change_classification_matches**](docs/apis/tags/DataClassificationApi.md#change_classification_matches) | **patch** /dataClassification/classificationMatches/bulk | Changes multiple Classification Matches
*DataClassificationApi* | [**classify**](docs/apis/tags/DataClassificationApi.md#classify) | **post** /dataClassification/classifications/classify | Starts a job that classifies datasets, databases, schemas, tables or columns by external service based on sample data.
*DataClassificationApi* | [**find_classification_matches**](docs/apis/tags/DataClassificationApi.md#find_classification_matches) | **get** /dataClassification/classificationMatches | Finds Classification Matches
*DataClassificationApi* | [**find_classification_matches_with_params**](docs/apis/tags/DataClassificationApi.md#find_classification_matches_with_params) | **get** /dataClassification/classificationMatches/bulk | Finds Classification Matches
*DataClassificationApi* | [**find_classifications**](docs/apis/tags/DataClassificationApi.md#find_classifications) | **get** /dataClassification/classifications | Finds Classifications
*DataClassificationApi* | [**find_classifications_bulk**](docs/apis/tags/DataClassificationApi.md#find_classifications_bulk) | **get** /dataClassification/classifications/bulk | Finds Classifications
*DataClassificationApi* | [**get_classification**](docs/apis/tags/DataClassificationApi.md#get_classification) | **get** /dataClassification/classifications/{classificationId} | Gets existing Classification by id.
*DataClassificationApi* | [**remove_classification**](docs/apis/tags/DataClassificationApi.md#remove_classification) | **delete** /dataClassification/classifications/{classificationId} | Removes existing Classification. WARNING: This will also remove all ClassificationMatches that are joined with this Classification!

## Documentation For Models

 - [AddClassificationMatchRequest](docs/models/AddClassificationMatchRequest.md)
 - [AddClassificationMatchesRequest](docs/models/AddClassificationMatchesRequest.md)
 - [AddClassificationRequest](docs/models/AddClassificationRequest.md)
 - [ChangeClassificationMatchRequest](docs/models/ChangeClassificationMatchRequest.md)
 - [ChangeClassificationRequest](docs/models/ChangeClassificationRequest.md)
 - [Classification](docs/models/Classification.md)
 - [ClassificationMatch](docs/models/ClassificationMatch.md)
 - [ClassifyRequest](docs/models/ClassifyRequest.md)
 - [FindClassificationMatchesRequest](docs/models/FindClassificationMatchesRequest.md)
 - [FindClassificationsRequest](docs/models/FindClassificationsRequest.md)
 - [Job](docs/models/Job.md)
 - [NamedResourceReferenceImpl](docs/models/NamedResourceReferenceImpl.md)
 - [PagedResponseClassification](docs/models/PagedResponseClassification.md)
 - [PagedResponseClassificationMatch](docs/models/PagedResponseClassificationMatch.md)

## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication

 Authentication schemes defined for the API:
## bearerAuth

- **Type**: Bearer authentication (JWT)


## Author



## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in collibra_data_classification.apis and collibra_data_classification.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from collibra_data_classification.apis.default_api import DefaultApi`
- `from collibra_data_classification.model.pet import Pet`

Solution 1:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import collibra_data_classification
from collibra_data_classification.apis import *
from collibra_data_classification.models import *
```
