# -*- coding: utf-8 -*-
# Generated by Django 1.11.4 on 2018-02-12 17:22
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='APIUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('service_name', models.CharField(max_length=200)),
                ('auth_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='apis', to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='Form',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=200, unique=True)),
                ('redirect_url', models.CharField(blank=True, default=None, max_length=150, null=True)),
                ('success_message', models.TextField(blank=True, default=None, null=True)),
                ('submit_button_text', models.CharField(default='Submit', max_length=100)),
                ('submission_url', models.CharField(blank=True, default=None, max_length=200, null=True)),
                ('submission_contacts', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=400), blank=True, default=None, null=True, size=None)),
            ],
            options={
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='FormField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('label', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('label_position', models.CharField(blank=True, choices=[('TOP', 'TOP'), ('RIGHT', 'RIGHT'), ('BOTTOM', 'BOTTOM'), ('LEFT', 'LEFT')], default='TOP', max_length=50, null=True)),
                ('default_value', models.CharField(blank=True, default=None, max_length=300, null=True)),
                ('placeholder', models.CharField(blank=True, default=None, max_length=150, null=True)),
                ('index', models.IntegerField(default=0)),
                ('value_choices', django.contrib.postgres.fields.ArrayField(base_field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), size=2), blank=True, default=None, null=True, size=None)),
                ('validation_rule', models.CharField(blank=True, choices=[('OPTIONAL', 'OPTIONAL'), ('REQUIRED', 'REQUIRED'), ('EMAIL', 'EMAIL')], default='REQUIRED', max_length=50, null=True)),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='fields', to='apollo.Form')),
            ],
        ),
        migrations.CreateModel(
            name='FormFieldTemplate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('is_submission_label', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=100, unique=True)),
                ('input_type', models.CharField(choices=[('TEXT', 'TEXT'), ('HIDDEN', 'HIDDEN'), ('TEXTAREA', 'TEXTAREA'), ('SELECT', 'SELECT'), ('CHECKBOX', 'CHECKBOX'), ('RICHTEXT', 'RICHTEXT'), ('RADIO', 'RADIO')], default='text', max_length=50)),
                ('is_visible', models.BooleanField(default=True)),
                ('label', models.CharField(blank=True, default=None, max_length=100, null=True)),
                ('label_position', models.CharField(choices=[('TOP', 'TOP'), ('RIGHT', 'RIGHT'), ('BOTTOM', 'BOTTOM'), ('LEFT', 'LEFT')], default='TOP', max_length=50)),
                ('placeholder', models.CharField(blank=True, default=None, max_length=150, null=True)),
                ('default_value', models.CharField(blank=True, default=None, max_length=300, null=True)),
                ('value_choices', django.contrib.postgres.fields.ArrayField(base_field=django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=100), size=2), blank=True, default=None, null=True, size=None)),
                ('validation_rule', models.CharField(blank=True, choices=[('OPTIONAL', 'OPTIONAL'), ('REQUIRED', 'REQUIRED'), ('EMAIL', 'EMAIL')], default='REQUIRED', max_length=50, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='FormSubmission',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('raw_data', django.contrib.postgres.fields.jsonb.JSONField()),
                ('cleaned_data', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=None, null=True)),
                ('is_valid', models.BooleanField(default=True)),
                ('created_time', models.DateTimeField(auto_now_add=True)),
                ('form', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='submissions', to='apollo.Form')),
            ],
            options={
                'ordering': ['-created_time', 'is_valid'],
                'permissions': (('can_view_submissions', 'Can View Form Submissions'), ('can_download_submissions', 'Can Download Form Submissions')),
            },
        ),
        migrations.CreateModel(
            name='Layout',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=150, unique=True)),
                ('max_width', models.IntegerField(blank=True, default=None, null=True)),
            ],
        ),
        migrations.CreateModel(
            name='LayoutField',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('desktop_width', models.DecimalField(decimal_places=3, max_digits=6)),
                ('desktop_height', models.DecimalField(decimal_places=3, max_digits=6)),
                ('desktop_top_left', django.contrib.postgres.fields.ArrayField(base_field=models.DecimalField(decimal_places=3, max_digits=6), size=2)),
                ('mobile_width', models.DecimalField(decimal_places=3, max_digits=6)),
                ('mobile_height', models.DecimalField(decimal_places=3, max_digits=6)),
                ('mobile_top_left', django.contrib.postgres.fields.ArrayField(base_field=models.DecimalField(decimal_places=3, max_digits=6), size=2)),
                ('layout', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='blocks', to='apollo.Layout')),
            ],
        ),
        migrations.AddField(
            model_name='formfield',
            name='layout',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.SET_NULL, to='apollo.LayoutField'),
        ),
        migrations.AddField(
            model_name='formfield',
            name='template',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='instances', to='apollo.FormFieldTemplate'),
        ),
        migrations.AddField(
            model_name='form',
            name='layout',
            field=models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='forms', to='apollo.Layout'),
        ),
    ]
