/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.Const;
import com.teradata.jdbc.encode.Encoder;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.parcel.DataParcel;
import java.sql.SQLException;

public class LogonDataParcel
extends DataParcel {
    public LogonDataParcel(TDNetworkIOIF tDNetworkIOIF, String string, GenericTeradataConnection genericTeradataConnection) throws SQLException {
        super(genericTeradataConnection, Encoder.encodeStringAsciiReplace(genericTeradataConnection, LogonDataParcel.composeLogonSourceString(tDNetworkIOIF, string)), false);
    }

    private static String composeLogonSourceString(TDNetworkIOIF tDNetworkIOIF, String string) {
        String string2 = " CID=" + tDNetworkIOIF.getConnectionID() + " " + LogonDataParcel.truncate(20, System.getProperty("user.name")) + " " + LogonDataParcel.truncate(26, "JDBC" + string + Const.DRIVER_VERSION + ";" + System.getProperty("java.version")) + " 01 LSS";
        int n = 97 - string2.length();
        string2 = LogonDataParcel.truncate(n, tDNetworkIOIF.getOriginalHostName() + ";" + tDNetworkIOIF.getRemoteAddress() + ":" + tDNetworkIOIF.getRemotePort()) + string2;
        return string2;
    }

    private static String truncate(int n, String string) {
        return string.length() <= n ? string : string.substring(0, n);
    }
}

