"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiMapping = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const api_1 = require("../http/api");
/**
 * (experimental) Create a new API mapping for API Gateway API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::ApiMapping
 */
class ApiMapping extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        let stage = props.stage;
        if (!stage) {
            if (props.api instanceof api_1.HttpApi) {
                if (props.api.defaultStage) {
                    stage = props.api.defaultStage;
                }
                else {
                    throw new Error('stage is required if default stage is not available');
                }
            }
            else {
                throw new Error('stage is required for WebSocket API');
            }
        }
        if (props.apiMappingKey === '') {
            throw new Error('empty string for api mapping key not allowed');
        }
        const apiMappingProps = {
            apiId: props.api.apiId,
            domainName: props.domainName.name,
            stage: stage.stageName,
            apiMappingKey: props.apiMappingKey,
        };
        const resource = new apigatewayv2_generated_1.CfnApiMapping(this, 'Resource', apiMappingProps);
        // ensure the dependency on the provided stage
        this.node.addDependency(stage);
        this.apiMappingId = resource.ref;
        this.mappingKey = props.apiMappingKey;
        this.domainName = props.domainName;
    }
    /**
     * (experimental) import from API ID.
     *
     * @experimental
     */
    static fromApiMappingAttributes(scope, id, attrs) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.apiMappingId = attrs.apiMappingId;
            }
        }
        return new Import(scope, id);
    }
}
exports.ApiMapping = ApiMapping;
_a = JSII_RTTI_SYMBOL_1;
ApiMapping[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.ApiMapping", version: "1.132.0" };
//# sourceMappingURL=data:application/json;base64,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