import { ICertificate } from '@aws-cdk/aws-certificatemanager';
import { IBucket } from '@aws-cdk/aws-s3';
import { IResource, Resource } from '@aws-cdk/core';
import { Construct } from 'constructs';
/**
 * (experimental) Represents an APIGatewayV2 DomainName.
 *
 * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 * @experimental
 */
export interface IDomainName extends IResource {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     * @attribute true
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) custom domain name attributes.
 *
 * @experimental
 */
export interface DomainNameAttributes {
    /**
     * (experimental) domain name string.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
}
/**
 * (experimental) properties used for creating the DomainName.
 *
 * @experimental
 */
export interface DomainNameProps {
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly domainName: string;
    /**
     * (experimental) The ACM certificate for this domain name.
     *
     * @experimental
     */
    readonly certificate: ICertificate;
    /**
     * (experimental) The mutual TLS authentication configuration for a custom domain name.
     *
     * @default - mTLS is not configured.
     * @experimental
     */
    readonly mtls?: MTLSConfig;
}
/**
 * (experimental) The mTLS authentication configuration for a custom domain name.
 *
 * @experimental
 */
export interface MTLSConfig {
    /**
     * (experimental) The bucket that the trust store is hosted in.
     *
     * @experimental
     */
    readonly bucket: IBucket;
    /**
     * (experimental) The key in S3 to look at for the trust store.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) The version of the S3 object that contains your truststore.
     *
     * To specify a version, you must have versioning enabled for the S3 bucket.
     *
     * @default - latest version
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) Custom domain resource for the API.
 *
 * @experimental
 */
export declare class DomainName extends Resource implements IDomainName {
    /**
     * (experimental) Import from attributes.
     *
     * @experimental
     */
    static fromDomainNameAttributes(scope: Construct, id: string, attrs: DomainNameAttributes): IDomainName;
    /**
     * (experimental) The custom domain name.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) The domain name associated with the regional endpoint for this custom domain name.
     *
     * @experimental
     */
    readonly regionalDomainName: string;
    /**
     * (experimental) The region-specific Amazon Route 53 Hosted Zone ID of the regional endpoint.
     *
     * @experimental
     */
    readonly regionalHostedZoneId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainNameProps);
    private configureMTLS;
}
