import { Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IResource } from '@aws-cdk/core';
import { IDomainName } from './domain-name';
/**
 * (experimental) Represents a Stage.
 *
 * @experimental
 */
export interface IStage extends IResource {
    /**
     * (experimental) The name of the stage;
     *
     * its primary identifier.
     *
     * @experimental
     * @attribute true
     */
    readonly stageName: string;
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    readonly url: string;
    /**
     * (experimental) Return the given named metric for this HTTP Api Gateway Stage.
     *
     * @default - average over 5 minutes
     * @experimental
     */
    metric(metricName: string, props?: MetricOptions): Metric;
}
/**
 * (experimental) Options for DomainMapping.
 *
 * @experimental
 */
export interface DomainMappingOptions {
    /**
     * (experimental) The domain name for the mapping.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * (experimental) The API mapping key.
     *
     * Leave it undefined for the root path mapping.
     *
     * @default - empty key for the root path mapping
     * @experimental
     */
    readonly mappingKey?: string;
}
/**
 * (experimental) Options required to create a new stage.
 *
 * Options that are common between HTTP and Websocket APIs.
 *
 * @experimental
 */
export interface StageOptions {
    /**
     * (experimental) Whether updates to an API automatically trigger a new deployment.
     *
     * @default false
     * @experimental
     */
    readonly autoDeploy?: boolean;
    /**
     * (experimental) The options for custom domain and api mapping.
     *
     * @default - no custom domain and api mapping configuration
     * @experimental
     */
    readonly domainMapping?: DomainMappingOptions;
}
/**
 * (experimental) The attributes used to import existing Stage.
 *
 * @experimental
 */
export interface StageAttributes {
    /**
     * (experimental) The name of the stage.
     *
     * @experimental
     */
    readonly stageName: string;
}
