"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegrationCache = void 0;
const crypto = require("crypto");
const core_1 = require("@aws-cdk/core");
class IntegrationCache {
    constructor() {
        this.integrations = {};
    }
    getIntegration(scope, config) {
        const configHash = this.integrationConfigHash(scope, config);
        const integration = this.integrations[configHash];
        return { configHash, integration };
    }
    saveIntegration(scope, config, integration) {
        const configHash = this.integrationConfigHash(scope, config);
        this.integrations[configHash] = integration;
    }
    integrationConfigHash(scope, config) {
        const stringifiedConfig = JSON.stringify(core_1.Stack.of(scope).resolve(config));
        const configHash = crypto.createHash('md5').update(stringifiedConfig).digest('hex');
        return configHash;
    }
}
exports.IntegrationCache = IntegrationCache;
//# sourceMappingURL=data:application/json;base64,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