# Changelog

<!-- <START NEW CHANGELOG ENTRY> -->

## 0.6.3

([Full Changelog](https://github.com/jupyter-server/jupyter-resource-usage/compare/@jupyter-server/resource-usage@0.6.2...f2366db3a26109832ad0e2ff1f2a8d3488c9dee7))

### Bugs fixed

- Define \_jupyter_server_extension_paths for backward compatibility [#148](https://github.com/jupyter-server/jupyter-resource-usage/pull/148) ([@casparvl](https://github.com/casparvl))
- Fix update at zero cpu [#147](https://github.com/jupyter-server/jupyter-resource-usage/pull/147) ([@casparvl](https://github.com/casparvl))

### Maintenance and upkeep improvements

- Remove `prepare` script [#145](https://github.com/jupyter-server/jupyter-resource-usage/pull/145) ([@jtpio](https://github.com/jtpio))
- Bump terser from 5.10.0 to 5.15.0 [#141](https://github.com/jupyter-server/jupyter-resource-usage/pull/141) ([@dependabot](https://github.com/dependabot))
- Bump moment from 2.29.2 to 2.29.4 [#140](https://github.com/jupyter-server/jupyter-resource-usage/pull/140) ([@dependabot](https://github.com/dependabot))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyter-resource-usage/graphs/contributors?from=2022-08-24&to=2022-10-06&type=c))

[@casparvl](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Acasparvl+updated%3A2022-08-24..2022-10-06&type=Issues) | [@dependabot](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Adependabot+updated%3A2022-08-24..2022-10-06&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Ajtpio+updated%3A2022-08-24..2022-10-06&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Apre-commit-ci+updated%3A2022-08-24..2022-10-06&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Awelcome+updated%3A2022-08-24..2022-10-06&type=Issues)

<!-- <END NEW CHANGELOG ENTRY> -->

## 0.6.2

([Full Changelog](https://github.com/jupyter-server/jupyter-resource-usage/compare/@jupyter-server/resource-usage@0.6.1...d6edf6a8a94b5740670368c6ad91299049e5a34f))

### Enhancements made

- Allow users to opt out of prometheus metrics [#124](https://github.com/jupyter-server/jupyter-resource-usage/pull/124) ([@dleen](https://github.com/dleen))

### Maintenance and upkeep improvements

- Fix lint configuration and failures [#138](https://github.com/jupyter-server/jupyter-resource-usage/pull/138) ([@kevin-bates](https://github.com/kevin-bates))
- [pre-commit.ci] pre-commit autoupdate [#137](https://github.com/jupyter-server/jupyter-resource-usage/pull/137) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- [pre-commit.ci] pre-commit autoupdate [#135](https://github.com/jupyter-server/jupyter-resource-usage/pull/135) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Bump parse-url from 6.0.0 to 6.0.2 [#133](https://github.com/jupyter-server/jupyter-resource-usage/pull/133) ([@dependabot](https://github.com/dependabot))
- [pre-commit.ci] pre-commit autoupdate [#132](https://github.com/jupyter-server/jupyter-resource-usage/pull/132) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- [pre-commit.ci] pre-commit autoupdate [#131](https://github.com/jupyter-server/jupyter-resource-usage/pull/131) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- [pre-commit.ci] pre-commit autoupdate [#129](https://github.com/jupyter-server/jupyter-resource-usage/pull/129) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Bump nanoid from 3.1.30 to 3.3.3 [#128](https://github.com/jupyter-server/jupyter-resource-usage/pull/128) ([@dependabot](https://github.com/dependabot))
- [pre-commit.ci] pre-commit autoupdate [#126](https://github.com/jupyter-server/jupyter-resource-usage/pull/126) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Bump moment from 2.29.1 to 2.29.2 [#125](https://github.com/jupyter-server/jupyter-resource-usage/pull/125) ([@dependabot](https://github.com/dependabot))
- [pre-commit.ci] pre-commit autoupdate [#122](https://github.com/jupyter-server/jupyter-resource-usage/pull/122) ([@pre-commit-ci](https://github.com/pre-commit-ci))
- Bump minimist from 1.2.5 to 1.2.6 [#121](https://github.com/jupyter-server/jupyter-resource-usage/pull/121) ([@dependabot](https://github.com/dependabot))
- Bump url-parse from 1.5.3 to 1.5.10 [#120](https://github.com/jupyter-server/jupyter-resource-usage/pull/120) ([@dependabot](https://github.com/dependabot))

### Documentation improvements

- Point the Binder link to the default branch [#117](https://github.com/jupyter-server/jupyter-resource-usage/pull/117) ([@jtpio](https://github.com/jtpio))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyter-resource-usage/graphs/contributors?from=2021-12-06&to=2022-08-24&type=c))

[@dependabot](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Adependabot+updated%3A2021-12-06..2022-08-24&type=Issues) | [@dleen](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Adleen+updated%3A2021-12-06..2022-08-24&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Ajtpio+updated%3A2021-12-06..2022-08-24&type=Issues) | [@kevin-bates](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Akevin-bates+updated%3A2021-12-06..2022-08-24&type=Issues) | [@pre-commit-ci](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Apre-commit-ci+updated%3A2021-12-06..2022-08-24&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Awelcome+updated%3A2021-12-06..2022-08-24&type=Issues)

## 0.6.1

([Full Changelog](https://github.com/jupyter-server/jupyter-resource-usage/compare/0.6.0...42df870ca30c1373fd7c5e48b00d1bb3f383c10a))

### Enhancements made

- catch psutil exceptions [#113](https://github.com/jupyter-server/jupyter-resource-usage/pull/113) ([@jhgoebbert](https://github.com/jhgoebbert))
- Add CPU display to extension [#105](https://github.com/jupyter-server/jupyter-resource-usage/pull/105) ([@stevenstetzler](https://github.com/stevenstetzler))

### Bugs fixed

- Ensure we use backoff when request fails [#104](https://github.com/jupyter-server/jupyter-resource-usage/pull/104) ([@vidartf](https://github.com/vidartf))

### Maintenance and upkeep improvements

- Adopt the Jupyter Releaser, update Jupyter Packaging [#115](https://github.com/jupyter-server/jupyter-resource-usage/pull/115) ([@jtpio](https://github.com/jtpio))

### Other merged PRs

- Bump tar from 6.1.5 to 6.1.11 in /packages/labextension [#111](https://github.com/jupyter-server/jupyter-resource-usage/pull/111) ([@dependabot](https://github.com/dependabot))
- Bump url-parse from 1.5.1 to 1.5.3 in /packages/labextension [#110](https://github.com/jupyter-server/jupyter-resource-usage/pull/110) ([@dependabot](https://github.com/dependabot))
- Bump path-parse from 1.0.6 to 1.0.7 in /packages/labextension [#108](https://github.com/jupyter-server/jupyter-resource-usage/pull/108) ([@dependabot](https://github.com/dependabot))
- Bump tar from 6.1.0 to 6.1.5 in /packages/labextension [#106](https://github.com/jupyter-server/jupyter-resource-usage/pull/106) ([@dependabot](https://github.com/dependabot))
- Bump normalize-url from 4.5.0 to 4.5.1 in /packages/labextension [#103](https://github.com/jupyter-server/jupyter-resource-usage/pull/103) ([@dependabot](https://github.com/dependabot))
- Bump ws from 7.4.5 to 7.4.6 in /packages/labextension [#102](https://github.com/jupyter-server/jupyter-resource-usage/pull/102) ([@dependabot](https://github.com/dependabot))
- Update to 3.0.16 packages [#101](https://github.com/jupyter-server/jupyter-resource-usage/pull/101) ([@jtpio](https://github.com/jtpio))
- Update dependencies [#100](https://github.com/jupyter-server/jupyter-resource-usage/pull/100) ([@jtpio](https://github.com/jtpio))
- Bump lodash from 4.17.20 to 4.17.21 in /packages/labextension [#99](https://github.com/jupyter-server/jupyter-resource-usage/pull/99) ([@dependabot](https://github.com/dependabot))
- Bump hosted-git-info from 2.8.8 to 2.8.9 in /packages/labextension [#98](https://github.com/jupyter-server/jupyter-resource-usage/pull/98) ([@dependabot](https://github.com/dependabot))
- Add changelog for 0.6.0 [#96](https://github.com/jupyter-server/jupyter-resource-usage/pull/96) ([@jtpio](https://github.com/jtpio))

### Contributors to this release

([GitHub contributors page for this release](https://github.com/jupyter-server/jupyter-resource-usage/graphs/contributors?from=2021-04-29&to=2021-12-06&type=c))

[@dependabot](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Adependabot+updated%3A2021-04-29..2021-12-06&type=Issues) | [@jhgoebbert](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Ajhgoebbert+updated%3A2021-04-29..2021-12-06&type=Issues) | [@jtpio](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Ajtpio+updated%3A2021-04-29..2021-12-06&type=Issues) | [@stevenstetzler](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Astevenstetzler+updated%3A2021-04-29..2021-12-06&type=Issues) | [@vidartf](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Avidartf+updated%3A2021-04-29..2021-12-06&type=Issues) | [@welcome](https://github.com/search?q=repo%3Ajupyter-server%2Fjupyter-resource-usage+involves%3Awelcome+updated%3A2021-04-29..2021-12-06&type=Issues)

## 0.6.0

- `executor` as ApiHandle class attribute [\#95](https://github.com/jupyter-server/jupyter-resource-usage/pull/95) ([jtpio](https://github.com/jtpio))
- Update RELEASE.md [\#94](https://github.com/jupyter-server/jupyter-resource-usage/pull/94) ([jtpio](https://github.com/jtpio))
- Clarify notebook/jupyter_server usage [\#93](https://github.com/jupyter-server/jupyter-resource-usage/pull/93) ([fcollonval](https://github.com/fcollonval))
- Bump ssri from 8.0.0 to 8.0.1 in /packages/labextension [\#90](https://github.com/jupyter-server/jupyter-resource-usage/pull/90) ([dependabot[bot]](https://github.com/apps/dependabot))
- Update to JupyterLab 3.0 final packages [\#87](https://github.com/jupyter-server/jupyter-resource-usage/pull/87) ([jtpio](https://github.com/jtpio))
- Add instructions to install with conda [\#83](https://github.com/jupyter-server/jupyter-resource-usage/pull/83) ([jtpio](https://github.com/jtpio))
- Add Changelog for 0.5.1 [\#82](https://github.com/jupyter-server/jupyter-resource-usage/pull/82) ([jtpio](https://github.com/jtpio))

## 0.5.1

- Skip building js assets if they already exist: [#81](https://github.com/jupyter-server/jupyter-resource-usage/pull/81)

## 0.5.0

The repository has now moved to the [`jupyter-server`](https://github.com/jupyter-server) organization on GitHub.

It was also renamed to `jupyter-resource-usage`.

To install the package with `pip`:

```bash
pip install jupyter-resource-usage
```

### Other changes

- Add a JupyterLab extension for the memory usage status bar item: [#69](https://github.com/jupyter-server/jupyter-resource-usage/pull/69)
- Drop the deprecated `/metrics` endpoint: [#77](https://github.com/jupyter-server/jupyter-resource-usage/pull/77)

### Migrating to 0.5.0

For classic notebook users, there shouldn't be any major change or action to take. The classic notebook extension is still distributed with the Python package as before.

For JupyterLab 2.x users you will still need to use the previous `nbresuse` package. See below for more information.

For JupyterLab 3.x, the status bar item is now packaged in its own extension and distributed with the `jupyter-resource-usage` package. This means that a single `pip install jupyter-resource-usage` is enough to install the server extension, the classic notebook extension and the JupyterLab extension all at once.

## 0.4.0

- Soft-deprecate `/metrics` endpoint: [#68](https://github.com/jupyter-server/jupyter-resource-usage/pull/68)
- `nbresuse` now exposes a new endpoint: `/api/metrics/v1`: [#68](https://github.com/jupyter-server/jupyter-resource-usage/pull/68)

### Migrating to 0.4.0

To upgrade to the latest version:

```
python -m pip install -U nbresuse
```

If you use the classic notebook, there shouldn't be anything to do. The classic notebook extension already uses the new endpoint and is automatically installed.

If you use JupyterLab 2.x and want the memory usage indicator in the status bar to continue showing metrics:

![image](https://user-images.githubusercontent.com/591645/99947412-3c8b0000-2d78-11eb-868a-6a2da419a957.png)

Two options:

- continue using `nbresuse==0.3.6` instead of `0.4.0`
- enable the deprecated `/metrics` endpoint with:

```bash
jupyter lab --ResourceUseDisplay.disable_legacy_endpoint=False
```

## 0.3.6

- Fix handling of cpu percent in the API endpoint [#56](https://github.com/jupyter-server/jupyter-resource-usage/pull/56)
- Added Binder [#53](https://github.com/jupyter-server/jupyter-resource-usage/pull/53) & RELEASE.md [#54](https://github.com/jupyter-server/jupyter-resource-usage/pull/54)

## 0.3.5

- Adding support for jupyterlab statusbar-extension [#45](https://github.com/jupyter-server/jupyter-resource-usage/pull/45) [#36](https://github.com/jupyter-server/jupyter-resource-usage/issues/36)

**Note**: this release restores the `/metrics` endpoint returning a JSON response, that was removed in `0.3.4`.

## 0.3.4

- Autoformatting and documentation [#33](https://github.com/jupyter-server/jupyter-resource-usage/pull/33)
- Add section about CPU usage to the README [#30](https://github.com/jupyter-server/jupyter-resource-usage/pull/30)
- Make psutil optional dependency of NBResuse [#25](https://github.com/jupyter-server/jupyter-resource-usage/pull/25)
- Report the memory usage metrics as prometheus metrics [#22](https://github.com/jupyter-server/jupyter-resource-usage/pull/22)

**Note**: this release removed the `/metrics` endpoint that was returning a JSON response. As a result, JupyterLab does not display the memory usage indicator in the status bar with `nbresuse==0.3.4`.

## 0.3.3

- Made memory limit possibly dynamic via passing a callable in the config. [#23](https://github.com/jupyter-server/jupyter-resource-usage/pull/23)
- Track CPU usage [#21](https://github.com/jupyter-server/jupyter-resource-usage/pull/21)

## 0.3.2

- Require authentication for /metrics API Handler [#18](https://github.com/jupyter-server/jupyter-resource-usage/pull/18)

## 0.3.1

- Don't poll in background, since user does not see it [#15](https://github.com/jupyter-server/jupyter-resource-usage/pull/15)
- Poll instantly once page is foregrounded [#15](https://github.com/jupyter-server/jupyter-resource-usage/pull/15)

This should reduce the number of /metrics requests massively, with minimal interruption to user experience.

## 0.3.0

- Automatically install & enable extensions [#9](https://github.com/jupyter-server/jupyter-resource-usage/pull/9)
- Put nbextension / serverextension enables in different places
- Put nbresuse js files in appropriate path

## 0.2.0

- Change 'Mem' prefix in display to less cryptic 'Memory'
- Fix primary screenshot to show memory limit too
- Distribute static files via package_data [#1](https://github.com/jupyter-server/jupyter-resource-usage/pull/1)
- Add screenshot for memory usage warning
- Configurable memory usage warnings
- More configurability via traitlets
- Consolidate code into single file
- Document memory limit behavior
- Add CONTRIBUTING.md doc
- Updated README

## 0.1.0

- Initial Commits for memory usage display
