"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        var _b;
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        codeRepository.applyRemovalPolicy((_b = props.codeCommitRemovalPolicy) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.RemovalPolicy.RETAIN);
        // TODO: Implement prBuildChecker
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const codePipelineProps = {
            ...props,
            synth: new pipelines_1.ShellStep("Synth", {
                input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
                installCommands: ["yarn install --frozen-lockfile"],
                commands: commands && commands.length > 0
                    ? commands
                    : ["npx nx run-many --target=build --all"],
                primaryOutputDirectory: props.primarySynthDirectory,
                ...(synthShellStepPartialProps || {}),
            }),
        };
        super(scope, id, codePipelineProps);
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig = props.sonarCodeScannerConfig;
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    buildPipeline() {
        var _b;
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: (_b = this.pipeline.artifactBucket.encryptionKey) === null || _b === void 0 ? void 0 : _b.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "aws-prototyping-sdk.pdk_pipeline.PDKPipeline", version: "0.0.45" };
//# sourceMappingURL=data:application/json;base64,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