"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Destination = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Specifies docker image deployment destination
 *
 * Usage:
 *
 * ```ts
 * declare const repo: ecr.IRepository;
 * const destinationEcr = dockerDeploy.Destination.ecr(repository, {
 *   tag: 'tag',
 * });
 * ```
 *
 */
class Destination {
    /**
     * Uses an ECR repository in the same account as the stack as the destination for the image.
     */
    static ecr(repository, options) {
        return new EcrDestination(repository, options);
    }
}
exports.Destination = Destination;
_a = JSII_RTTI_SYMBOL_1;
Destination[_a] = { fqn: "cdk-docker-image-deployment.Destination", version: "0.0.56" };
/**
 * Class used when the destination of docker image deployment is an ECR repository in the same account as the stack
 */
class EcrDestination extends Destination {
    constructor(repository, options) {
        super();
        this.repository = repository;
        this.options = options;
    }
    bind(role) {
        const accountId = this.repository.env.account;
        const region = this.repository.env.region;
        this.repository.grantPullPush(role);
        return {
            destinationUri: this.repository.repositoryUri,
            loginConfig: {
                loginCommand: `aws ecr get-login-password --region ${region} | docker login --username AWS --password-stdin ${accountId}.dkr.ecr.${region}.amazonaws.com`,
                region: region,
            },
            destinationTag: this.options?.tag,
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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