/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CompressionType {
    NONE("None"),
    GZIP("Gzip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CompressionType> VALUE_MAP;
    private final String value;

    private CompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CompressionType> knownValues() {
        EnumSet<CompressionType> knownValues = EnumSet.allOf(CompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CompressionType.class, CompressionType::toString);
    }
}

