/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileSystemAccessMode {
    RW("rw"),
    RO("ro"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileSystemAccessMode> VALUE_MAP;
    private final String value;

    private FileSystemAccessMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileSystemAccessMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileSystemAccessMode> knownValues() {
        EnumSet<FileSystemAccessMode> knownValues = EnumSet.allOf(FileSystemAccessMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileSystemAccessMode.class, FileSystemAccessMode::toString);
    }
}

