/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.DeviceFleetSummary;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListDeviceFleetsResponse;

public class ListDeviceFleetsIterable
implements SdkIterable<ListDeviceFleetsResponse> {
    private final SageMakerClient client;
    private final ListDeviceFleetsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDeviceFleetsIterable(SageMakerClient client, ListDeviceFleetsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDeviceFleetsResponseFetcher();
    }

    public Iterator<ListDeviceFleetsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DeviceFleetSummary> deviceFleetSummaries() {
        Function<ListDeviceFleetsResponse, Iterator> getIterator = response -> {
            if (response != null && response.deviceFleetSummaries() != null) {
                return response.deviceFleetSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDeviceFleetsResponseFetcher
    implements SyncPageFetcher<ListDeviceFleetsResponse> {
        private ListDeviceFleetsResponseFetcher() {
        }

        public boolean hasNextPage(ListDeviceFleetsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDeviceFleetsResponse nextPage(ListDeviceFleetsResponse previousPage) {
            if (previousPage == null) {
                return ListDeviceFleetsIterable.this.client.listDeviceFleets(ListDeviceFleetsIterable.this.firstRequest);
            }
            return ListDeviceFleetsIterable.this.client.listDeviceFleets((ListDeviceFleetsRequest)((Object)ListDeviceFleetsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

