/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelQualityJobDefinitionsResponse;
import software.amazon.awssdk.services.sagemaker.model.MonitoringJobDefinitionSummary;

public class ListModelQualityJobDefinitionsPublisher
implements SdkPublisher<ListModelQualityJobDefinitionsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelQualityJobDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelQualityJobDefinitionsPublisher(SageMakerAsyncClient client, ListModelQualityJobDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelQualityJobDefinitionsPublisher(SageMakerAsyncClient client, ListModelQualityJobDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelQualityJobDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelQualityJobDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        Function<ListModelQualityJobDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.jobDefinitionSummaries() != null) {
                return response.jobDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelQualityJobDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelQualityJobDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListModelQualityJobDefinitionsResponse> {
        private ListModelQualityJobDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelQualityJobDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelQualityJobDefinitionsResponse> nextPage(ListModelQualityJobDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelQualityJobDefinitionsPublisher.this.client.listModelQualityJobDefinitions(ListModelQualityJobDefinitionsPublisher.this.firstRequest);
            }
            return ListModelQualityJobDefinitionsPublisher.this.client.listModelQualityJobDefinitions((ListModelQualityJobDefinitionsRequest)((Object)ListModelQualityJobDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

