/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListTransformJobsResponse;
import software.amazon.awssdk.services.sagemaker.model.TransformJobSummary;

public class ListTransformJobsPublisher
implements SdkPublisher<ListTransformJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListTransformJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransformJobsPublisher(SageMakerAsyncClient client, ListTransformJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransformJobsPublisher(SageMakerAsyncClient client, ListTransformJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransformJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTransformJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransformJobSummary> transformJobSummaries() {
        Function<ListTransformJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transformJobSummaries() != null) {
                return response.transformJobSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTransformJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTransformJobsResponseFetcher
    implements AsyncPageFetcher<ListTransformJobsResponse> {
        private ListTransformJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransformJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTransformJobsResponse> nextPage(ListTransformJobsResponse previousPage) {
            if (previousPage == null) {
                return ListTransformJobsPublisher.this.client.listTransformJobs(ListTransformJobsPublisher.this.firstRequest);
            }
            return ListTransformJobsPublisher.this.client.listTransformJobs((ListTransformJobsRequest)((Object)ListTransformJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

