/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.SearchRecord;
import software.amazon.awssdk.services.sagemaker.model.SearchRequest;
import software.amazon.awssdk.services.sagemaker.model.SearchResponse;

public class SearchIterable
implements SdkIterable<SearchResponse> {
    private final SageMakerClient client;
    private final SearchRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public SearchIterable(SageMakerClient client, SearchRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new SearchResponseFetcher();
    }

    public Iterator<SearchResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchRecord> results() {
        Function<SearchResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class SearchResponseFetcher
    implements SyncPageFetcher<SearchResponse> {
        private SearchResponseFetcher() {
        }

        public boolean hasNextPage(SearchResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public SearchResponse nextPage(SearchResponse previousPage) {
            if (previousPage == null) {
                return SearchIterable.this.client.search(SearchIterable.this.firstRequest);
            }
            return SearchIterable.this.client.search((SearchRequest)((Object)SearchIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

