/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sagemaker.featurestore.sparksdk.helpers;

import org.apache.spark.SparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Predef$;
import scala.collection.immutable.StringOps;

public final class DataFrameRepartitioner$ {
    public static DataFrameRepartitioner$ MODULE$;
    private final String DEFAULT_SHUFFLE_PARTITIONS;

    static {
        new DataFrameRepartitioner$();
    }

    public String DEFAULT_SHUFFLE_PARTITIONS() {
        return this.DEFAULT_SHUFFLE_PARTITIONS;
    }

    public int getParallelism(Dataset<Row> inputDataFrame) {
        SparkContext sparkContext = inputDataFrame.sparkSession().sparkContext();
        String configuredParallelism = sparkContext.getConf().get("spark.default.parallelism", null);
        int systemParallelism = sparkContext.defaultParallelism();
        return configuredParallelism != null ? new StringOps(Predef$.MODULE$.augmentString(configuredParallelism)).toInt() : systemParallelism;
    }

    public Dataset<Row> repartition(Dataset<Row> inputDataFrame) {
        SparkContext sparkContext = inputDataFrame.sparkSession().sparkContext();
        int parallelism = this.getParallelism(inputDataFrame);
        int maxPartitions = new StringOps(Predef$.MODULE$.augmentString(sparkContext.getConf().get("spark.sql.shuffle.partitions", this.DEFAULT_SHUFFLE_PARTITIONS()))).toInt();
        int partitionsCount = inputDataFrame.rdd().getNumPartitions();
        return partitionsCount < parallelism || partitionsCount > maxPartitions ? inputDataFrame.repartition(parallelism) : inputDataFrame;
    }

    private DataFrameRepartitioner$() {
        MODULE$ = this;
        this.DEFAULT_SHUFFLE_PARTITIONS = "200";
    }
}

