/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sagemaker.featurestore.sparksdk.validators;

import java.io.Serializable;
import java.util.regex.Pattern;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.FeatureDefinition;
import software.amazon.sagemaker.featurestore.sparksdk.exceptions.ValidationError;

public final class InputDataSchemaValidator$ {
    public static InputDataSchemaValidator$ MODULE$;
    private final Set<String> RESERVED_FEATURE_NAMES;
    private final Map<String, String> TYPE_MAP;

    static {
        new InputDataSchemaValidator$();
    }

    public Set<String> RESERVED_FEATURE_NAMES() {
        return this.RESERVED_FEATURE_NAMES;
    }

    public Map<String, String> TYPE_MAP() {
        return this.TYPE_MAP;
    }

    public Dataset<Row> validateInputDataFrame(Dataset<Row> dataFrame, DescribeFeatureGroupResponse describeResponse) {
        String recordIdentifierName = describeResponse.recordIdentifierFeatureName();
        String eventTimeFeatureName = describeResponse.eventTimeFeatureName();
        Set featuresInFeatureGroup = ((TraversableOnce)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(describeResponse.featureDefinitions()).asScala()).toStream().map((Function1 & Serializable & scala.Serializable)feature -> feature.featureName(), Stream$.MODULE$.canBuildFrom())).toSet();
        this.validateSchemaNames(dataFrame.schema().names(), (Set<String>)featuresInFeatureGroup, recordIdentifierName, eventTimeFeatureName);
        Map<String, Function1<String, Column>> schemaDataTypeValidatorMap = this.getSchemaDataTypeValidatorMap(dataFrame, (List<FeatureDefinition>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(describeResponse.featureDefinitions()).asScala()).toList(), describeResponse.eventTimeFeatureName());
        List<Column> schemaDataTypeValidatorColumn = this.getSchemaDataTypeValidatorColumn(schemaDataTypeValidatorMap, recordIdentifierName, eventTimeFeatureName);
        Dataset invalidRows = dataFrame.withColumn("dataTypeValidationErrors", functions$.MODULE$.concat_ws(",", schemaDataTypeValidatorColumn)).filter(functions$.MODULE$.col("dataTypeValidationErrors").like("%not valid"));
        if (!invalidRows.isEmpty()) {
            invalidRows.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(recordIdentifierName), functions$.MODULE$.col("dataTypeValidationErrors")})).show(20, false);
            throw new ValidationError("Cannot proceed. Some records contain columns with data types that are not registered in the FeatureGroup or records values equal to NaN.");
        }
        Map<String, Function1<String, Column>> dataTypeTransformationMap = this.getSchemaDataTypeTransformationMap(schemaDataTypeValidatorMap, (List<FeatureDefinition>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(describeResponse.featureDefinitions()).asScala()).toList(), eventTimeFeatureName);
        return dataFrame.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.columns())).map((Function1 & Serializable & scala.Serializable)col -> (Column)((Function1)dataTypeTransformationMap.apply(col)).apply(col), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)))));
    }

    private void validateSchemaNames(String[] schemaNames, Set<String> features, String recordIdentifierName, String eventTimeFeatureName) {
        String invalidCharSet = "[,;{}()\n\t=]";
        Pattern invalidCharSetPattern = Pattern.compile(invalidCharSet);
        ListBuffer unknown_columns = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ObjectRef missingRequiredFeatureNames = ObjectRef.create((Object)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{recordIdentifierName, eventTimeFeatureName}))));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schemaNames)).foreach((Function1 & Serializable & scala.Serializable)name -> {
            InputDataSchemaValidator$.$anonfun$validateSchemaNames$1(invalidCharSetPattern, invalidCharSet, features, unknown_columns, missingRequiredFeatureNames, name);
            return BoxedUnit.UNIT;
        });
        if (unknown_columns.nonEmpty()) {
            throw new ValidationError(new StringBuilder(51).append("Cannot proceed. Schema contains unknown columns: '").append(unknown_columns).append("'").toString());
        }
        if (((Set)missingRequiredFeatureNames.elem).nonEmpty()) {
            throw new ValidationError(new StringBuilder(51).append("Cannot proceed. Missing feature names '").append((Set)missingRequiredFeatureNames.elem).append("' in schema.").toString());
        }
    }

    private Map<String, Function1<String, Column>> getSchemaDataTypeValidatorMap(Dataset<Row> dataFrame, List<FeatureDefinition> featureDefinitions, String eventTimeFeatureName) {
        Function1 & Serializable & scala.Serializable lambdaCreator = (Function1 & Serializable & scala.Serializable)sparkType -> (Function1 & Serializable & scala.Serializable)featureName -> functions$.MODULE$.col(featureName).cast(sparkType);
        Map conversionsMap = (Map)featureDefinitions.foldLeft((Object)Predef$.MODULE$.Map().empty(), (Function2 & Serializable & scala.Serializable)(resultMap, featureDefinition) -> {
            String featureName2 = featureDefinition.featureName();
            String sparkType = (String)MODULE$.TYPE_MAP().apply((Object)featureDefinition.featureTypeAsString());
            return featureName2.equals(eventTimeFeatureName) ? resultMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)eventTimeFeatureName), (Function1 & Serializable & scala.Serializable)featureName -> functions$.MODULE$.col(featureName).cast(sparkType).cast((DataType)TimestampType$.MODULE$))) : (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataFrame.schema().names())).contains((Object)featureName2) ? resultMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)featureName2), lambdaCreator.apply((Object)sparkType))) : resultMap);
        });
        return conversionsMap;
    }

    private Map<String, Function1<String, Column>> getSchemaDataTypeTransformationMap(Map<String, Function1<String, Column>> validatorMap, List<FeatureDefinition> featureDefinitions, String eventTimeFeatureName) {
        String eventTimeFeatureType = ((FeatureDefinition)featureDefinitions.find((Function1 & Serializable & scala.Serializable)feature -> BoxesRunTime.boxToBoolean((boolean)InputDataSchemaValidator$.$anonfun$getSchemaDataTypeTransformationMap$1(eventTimeFeatureName, feature))).get()).featureTypeAsString();
        Map dataTypeTransformationMap = validatorMap;
        dataTypeTransformationMap = dataTypeTransformationMap.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)eventTimeFeatureName), (Function1 & Serializable & scala.Serializable)featureName -> functions$.MODULE$.col(featureName).cast((String)MODULE$.TYPE_MAP().apply((Object)eventTimeFeatureType))));
        return dataTypeTransformationMap;
    }

    private List<Column> getSchemaDataTypeValidatorColumn(Map<String, Function1<String, Column>> dataTypeValidatorMap, String recordIdentifierName, String eventTimeFeatureName) {
        return (List)dataTypeValidatorMap.foldLeft((Object)Nil$.MODULE$, (arg_0, arg_1) -> InputDataSchemaValidator$.$anonfun$getSchemaDataTypeValidatorColumn$1(recordIdentifierName, eventTimeFeatureName, arg_0, arg_1));
    }

    public static final /* synthetic */ void $anonfun$validateSchemaNames$1(Pattern invalidCharSetPattern$1, String invalidCharSet$1, Set features$1, ListBuffer unknown_columns$1, ObjectRef missingRequiredFeatureNames$1, String name) {
        block2: {
            if (invalidCharSetPattern$1.matcher(name).matches()) {
                throw new ValidationError(new StringBuilder(53).append("Cannot proceed. Invalid char among '").append(invalidCharSet$1).append("' detected in '").append(name).append("'.").toString());
            }
            if (MODULE$.RESERVED_FEATURE_NAMES().contains((Object)name)) {
                throw new ValidationError(new StringBuilder(62).append("Cannot proceed. Detected column with reserved feature name '").append(name).append("'.").toString());
            }
            Object object = !features$1.contains((Object)name) ? unknown_columns$1.$plus$eq((Object)name) : BoxedUnit.UNIT;
            if (!((Set)missingRequiredFeatureNames$1.elem).contains((Object)name)) break block2;
            missingRequiredFeatureNames$1.elem = (Set)((Set)missingRequiredFeatureNames$1.elem).$minus((Object)name);
        }
    }

    public static final /* synthetic */ boolean $anonfun$getSchemaDataTypeTransformationMap$1(String eventTimeFeatureName$2, FeatureDefinition feature) {
        return feature.featureName().equals(eventTimeFeatureName$2);
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ List $anonfun$getSchemaDataTypeValidatorColumn$1(String recordIdentifierName$1, String eventTimeFeatureName$3, List x0$1, Tuple2 x1$1) {
        block3: {
            block2: {
                var5_4 = new Tuple2((Object)x0$1, (Object)x1$1);
                if (var5_4 == null) break block2;
                resultList = (List)var5_4._1();
                var7_6 = (Tuple2)var5_4._2();
                if (var7_6 == null) break block2;
                featureName = (String)var7_6._1();
                conversion = (Function1)var7_6._2();
                v0 = featureName;
                var10_9 = recordIdentifierName$1;
                if (!(v0 == null ? var10_9 != null : v0.equals(var10_9) == false)) ** GOTO lbl-1000
                v1 = featureName;
                var11_10 = eventTimeFeatureName$3;
                if (!(v1 != null ? v1.equals(var11_10) == false : var11_10 != null)) lbl-1000:
                // 2 sources

                {
                    v2 = (List)resultList.$colon$plus((Object)functions$.MODULE$.when(((Column)conversion.apply((Object)featureName)).isNull().$amp$amp((Object)functions$.MODULE$.col(featureName).isNotNull()).$bar$bar((Object)functions$.MODULE$.col(featureName).isNaN()).$bar$bar((Object)functions$.MODULE$.col(featureName).isNull()), (Object)functions$.MODULE$.lit((Object)new StringBuilder(10).append(featureName).append(" not valid").toString())).otherwise((Object)functions$.MODULE$.lit(null)), List$.MODULE$.canBuildFrom());
                } else {
                    v2 = (List)resultList.$colon$plus((Object)functions$.MODULE$.when(((Column)conversion.apply((Object)featureName)).isNull().$amp$amp((Object)functions$.MODULE$.col(featureName).isNotNull()).$bar$bar((Object)functions$.MODULE$.col(featureName).isNaN()), (Object)functions$.MODULE$.lit((Object)new StringBuilder(10).append(featureName).append(" not valid").toString())).otherwise((Object)functions$.MODULE$.lit(null)), List$.MODULE$.canBuildFrom());
                }
                break block3;
            }
            throw new MatchError((Object)var5_4);
        }
        var4_11 = v2;
        return var4_11;
    }

    private InputDataSchemaValidator$() {
        MODULE$ = this;
        this.RESERVED_FEATURE_NAMES = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"is_deleted", "write_time", "api_invocation_time"}));
        this.TYPE_MAP = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Integral"), (Object)"long"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"String"), (Object)"string"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"Fractional"), (Object)"double")}));
    }
}

