/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.sagemaker.featurestore.sparksdk.helpers;

import scala.Option;
import scala.Option$;
import scala.Predef$;
import software.amazon.awssdk.services.sagemaker.model.DescribeFeatureGroupResponse;
import software.amazon.awssdk.services.sagemaker.model.FeatureGroupStatus;
import software.amazon.awssdk.services.sagemaker.model.OnlineStoreConfig;
import software.amazon.sagemaker.featurestore.sparksdk.exceptions.ValidationError;

public final class FeatureGroupHelper$ {
    public static FeatureGroupHelper$ MODULE$;

    static {
        new FeatureGroupHelper$();
    }

    public void checkIfFeatureGroupIsCreated(DescribeFeatureGroupResponse describeResponse) {
        if (!FeatureGroupStatus.CREATED.equals((Object)describeResponse.featureGroupStatus())) {
            throw new ValidationError(new StringBuilder(66).append("Feature group '").append(describeResponse.featureGroupName()).append("' is in ").append(new StringBuilder(11).append("'").append(describeResponse.featureGroupStatus()).append("' status, ").toString()).append("however status must be in 'Created' instead").toString());
        }
    }

    public void checkIfFeatureGroupArnIdentical(DescribeFeatureGroupResponse describeResponse, String providedFeatureGroupArn) {
        String string = describeResponse.featureGroupArn();
        String string2 = providedFeatureGroupArn;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new ValidationError(new StringBuilder(119).append("Provided feature group arn does not match the arn detected.").append(" For now cross account or region ingestion is not supported.").toString());
        }
    }

    public void checkDirectOfflineStore(DescribeFeatureGroupResponse describeResponse, boolean directOfflineStore) {
        if (!this.isFeatureGroupOfflineStoreEnabled(describeResponse) && directOfflineStore) {
            throw new ValidationError(new StringBuilder(93).append("OfflineStore of FeatureGroup: '").append(describeResponse.featureGroupName()).append("' is not enabled, however directOfflineStore is set to 'true'.").toString());
        }
    }

    public boolean isFeatureGroupOnlineStoreEnabled(DescribeFeatureGroupResponse describeResponse) {
        Option onlineStoreConfig = Option$.MODULE$.apply((Object)describeResponse.onlineStoreConfig());
        return onlineStoreConfig.nonEmpty() && Predef$.MODULE$.Boolean2boolean(((OnlineStoreConfig)onlineStoreConfig.get()).enableOnlineStore());
    }

    public boolean isFeatureGroupOfflineStoreEnabled(DescribeFeatureGroupResponse describeResponse) {
        Option offlineStoreConfig = Option$.MODULE$.apply((Object)describeResponse.offlineStoreConfig());
        return offlineStoreConfig.nonEmpty();
    }

    public String generateDestinationFilePath(DescribeFeatureGroupResponse describeResponse) {
        String resolvedOutputS3Uri = describeResponse.offlineStoreConfig().s3StorageConfig().resolvedOutputS3Uri();
        return resolvedOutputS3Uri.replaceFirst("s3", "s3a");
    }

    private FeatureGroupHelper$() {
        MODULE$ = this;
    }
}

