<div align="center">
  <img src="https://raw.githubusercontent.com/chandraveshchaudhari/personal-information/initial_setup/logos/my%20github%20logo%20template-browser-automationpy%20small.png" width="640" height="320">
</div>

# An open-source Python framework for Browser Automation : browser-automationpy
> Chaudhari, C., Purswani, G. (2023). Stock Market Prediction Techniques Using Artificial Intelligence: A Systematic Review. In: Kumar, S., Sharma, H., Balachandran, K., Kim, J.H., Bansal, J.C. (eds) Third Congress on Intelligent Systems. CIS 2022. Lecture Notes in Networks and Systems, vol 608. Springer, Singapore. https://doi.org/10.1007/978-981-19-9225-4_17


- [Introduction](#introduction)
- [Features](#features)
- [Installation](#installation)
- [Contribution](#contribution)

## Introduction
The main objective of the Python framework is easily launching custom automated browser. 
This framework doesn't ask you to download any browser binaries. Browser automation is very useful in data mining and 
automation of monotonous work.

### Authors
<img align="left" width="231.95" height="75" src="https://raw.githubusercontent.com/chandraveshchaudhari/personal-information/initial_setup/images/christ.png">

The packages [systematic-reviewpy](https://github.com/chandraveshchaudhari/systematic-reviewpy) and 
[browser-automationpy](https://github.com/chandraveshchaudhari/browser-automationpy) are part of Research paper 
`An Open-Source Python Framework For Systematic Review Based On PRISMA` created by [Chandravesh chaudhari][chandravesh linkedin], Doctoral candidate at [CHRIST (Deemed to be University), Bangalore, India][christ university website] under supervision of [Dr. Geetanjali purswani][geetanjali linkedin].

<br/>

[chandravesh linkedin]: https://www.linkedin.com/in/chandravesh-chaudhari "chandravesh linkedin profile"
[geetanjali linkedin]: https://www.linkedin.com/in/dr-geetanjali-purswani-546336b8 "geetanjali linkedin profile"
[christ university website]: https://christuniversity.in/ "website"

## Features
- one line code to install all supported browsers.
- easy customisation for browsers such as adding extensions and changing download paths.
- easy methods for clicking buttons or inputting data into web elements.
- support for chrome, safari, mozilla, edge etc.
- No need to download binary.

#### Advantages over manual methods
- Saves time
- Automate monotonous tasks

## Installation 
This project is available at [PyPI](https://github.com/chandraveshchaudhari/browser-automationpy). For help in 
installation check [instructions](https://packaging.python.org/tutorials/installing-packages/#installing-from-pypi)
```bash
python3 -m pip install browser-automationpy  
```

### Dependencies
##### Required
- [webdriver-manager](https://pypi.org/project/webdriver-manager/) - Library provides the way to automatically manage drivers for different browsers
- [selenium](https://pypi.org/project/selenium/) - The selenium package is used to automate web browser interaction from Python.
##### Optional
- [PyAutoGUI](https://pypi.org/project/PyAutoGUI/) - PyAutoGUI lets Python control the mouse and keyboard, and other GUI automation tasks.

## Important links
- [Documentation](https://chandraveshchaudhari.github.io/browser-automationpy/)
- [Quick tour](https://chandraveshchaudhari.github.io/browser-automationpy/browser_automationpy_tutorial.html#installing-the-browser_automationpy)
- [Project maintainer (feel free to contact)](mailto:chandraveshchaudhari@gmail.com?subject=[GitHub]%20Source%20browser-automationpy)
- [Future Improvements](https://github.com/chandraveshchaudhari/browser-automationpy/projects)
- [License](https://github.com/chandraveshchaudhari/browser-automationpy/blob/master/LICENSE.txt)

## Contribution
all kinds of contributions are appreciated.
- [Improving readability of documentation](https://chandraveshchaudhari.github.io/browser-automationpy/)
- [Feature Request](https://github.com/chandraveshchaudhari/browser-automationpy/issues/new/choose)
- [Reporting bugs](https://github.com/chandraveshchaudhari/browser-automationpy/issues/new/choose)
- [Contribute code](https://github.com/chandraveshchaudhari/browser-automationpy/compare)
- [Asking questions in discussions](https://github.com/chandraveshchaudhari/browser-automationpy/discussions)
