"use strict";
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
Object.defineProperty(exports, "__esModule", { value: true });
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline TS Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "Defaults",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelineTsProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelineTsProject", {
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.ts"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelineTsProject({
            cdkVersion: "2.0.0",
            defaultReleaseBranch: "mainline",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.ts",
        });
        expect(synth_1.synthSnapshot(project)).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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