"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebSocketApi = exports.WebSocketApiKeySelectionExpression = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const base_1 = require("../common/base");
const route_1 = require("./route");
/**
 * Represents the currently available API Key Selection Expressions
 */
class WebSocketApiKeySelectionExpression {
    /**
     * @param customApiKeySelector The expression used by API Gateway
     */
    constructor(customApiKeySelector) {
        this.customApiKeySelector = customApiKeySelector;
    }
}
exports.WebSocketApiKeySelectionExpression = WebSocketApiKeySelectionExpression;
_a = JSII_RTTI_SYMBOL_1;
WebSocketApiKeySelectionExpression[_a] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketApiKeySelectionExpression", version: "1.186.0" };
/**
 * The API will extract the key value from the `x-api-key` header in the user request.
 */
WebSocketApiKeySelectionExpression.HEADER_X_API_KEY = new WebSocketApiKeySelectionExpression('$request.header.x-api-key');
/**
  * The API will extract the key value from the `usageIdentifierKey` attribute in the `context` map,
  * returned by the Lambda Authorizer.
  * See https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
  */
WebSocketApiKeySelectionExpression.AUTHORIZER_USAGE_IDENTIFIER_KEY = new WebSocketApiKeySelectionExpression('$context.authorizer.usageIdentifierKey');
/**
 * Create a new API Gateway WebSocket API endpoint.
 * @resource AWS::ApiGatewayV2::Api
 */
class WebSocketApi extends base_1.ApiBase {
    constructor(scope, id, props) {
        super(scope, id);
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketApiProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, WebSocketApi);
            }
            throw error;
        }
        this.webSocketApiName = props?.apiName ?? id;
        const resource = new apigatewayv2_generated_1.CfnApi(this, 'Resource', {
            name: this.webSocketApiName,
            apiKeySelectionExpression: props?.apiKeySelectionExpression?.customApiKeySelector,
            protocolType: 'WEBSOCKET',
            description: props?.description,
            routeSelectionExpression: props?.routeSelectionExpression ?? '$request.body.action',
        });
        this.apiId = resource.ref;
        this.apiEndpoint = resource.attrApiEndpoint;
        if (props?.connectRouteOptions) {
            this.addRoute('$connect', props.connectRouteOptions);
        }
        if (props?.disconnectRouteOptions) {
            this.addRoute('$disconnect', props.disconnectRouteOptions);
        }
        if (props?.defaultRouteOptions) {
            this.addRoute('$default', props.defaultRouteOptions);
        }
    }
    /**
     * Import an existing WebSocket API into this CDK app.
     */
    static fromWebSocketApiAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketApiAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromWebSocketApiAttributes);
            }
            throw error;
        }
        class Import extends base_1.ApiBase {
            constructor() {
                super(...arguments);
                this.apiId = attrs.webSocketId;
                this.websocketApiId = attrs.webSocketId;
                this._apiEndpoint = attrs.apiEndpoint;
            }
            get apiEndpoint() {
                if (!this._apiEndpoint) {
                    throw new Error('apiEndpoint is not configured on the imported WebSocketApi.');
                }
                return this._apiEndpoint;
            }
        }
        return new Import(scope, id);
    }
    /**
     * Add a new route
     */
    addRoute(routeKey, options) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_WebSocketRouteOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addRoute);
            }
            throw error;
        }
        return new route_1.WebSocketRoute(this, `${routeKey}-Route`, {
            webSocketApi: this,
            routeKey,
            ...options,
        });
    }
    /**
     * Grant access to the API Gateway management API for this WebSocket API to an IAM
     * principal (Role/Group/User).
     *
     * @param identity The principal
     */
    grantManageConnections(identity) {
        const arn = core_1.Stack.of(this).formatArn({
            service: 'execute-api',
            resource: this.apiId,
        });
        return aws_iam_1.Grant.addToPrincipal({
            grantee: identity,
            actions: ['execute-api:ManageConnections'],
            resourceArns: [`${arn}/*/*/@connections/*`],
        });
    }
}
exports.WebSocketApi = WebSocketApi;
_b = JSII_RTTI_SYMBOL_1;
WebSocketApi[_b] = { fqn: "@aws-cdk/aws-apigatewayv2.WebSocketApi", version: "1.186.0" };
//# sourceMappingURL=data:application/json;base64,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