
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	5dc0106f          	j	800015e8 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	200000ef          	jal	ra,8000026c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	04051663          	bnez	a0,800000c0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	14408093          	addi	ra,ra,324 # 800001d8 <no_reschedule>
	tail _Fault
8000009c:	45c0106f          	j	800014f8 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
800000ac:	00008297          	auipc	t0,0x8
800000b0:	89c28293          	addi	t0,t0,-1892 # 80007948 <_offload_routine>
	lw t1, 0x00(t0)
800000b4:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
800000b8:	00031463          	bnez	t1,800000c0 <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000bc:	0900006f          	j	8000014c <reschedule>

800000c0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000c0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000c4:	00008397          	auipc	t2,0x8
800000c8:	c1c38393          	addi	t2,t2,-996 # 80007ce0 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000cc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000d0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000d4:	00512023          	sw	t0,0(sp)

800000d8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000d8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000dc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000e0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000e4:	00030863          	beqz	t1,800000f4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000e8:	00000097          	auipc	ra,0x0
800000ec:	03c08093          	addi	ra,ra,60 # 80000124 <on_thread_stack>
	tail z_irq_do_offload
800000f0:	4940106f          	j	80001584 <z_irq_do_offload>

800000f4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000f4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000f8:	800002b7          	lui	t0,0x80000
800000fc:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
80000100:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
80000104:	158000ef          	jal	ra,8000025c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
80000108:	00006297          	auipc	t0,0x6
8000010c:	56028293          	addi	t0,t0,1376 # 80006668 <_image_text_end>
	slli a0, a0, 3
80000110:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000114:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000118:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000011c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000120:	000300e7          	jalr	t1

80000124 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000124:	00008317          	auipc	t1,0x8
80000128:	bbc30313          	addi	t1,t1,-1092 # 80007ce0 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000012c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000130:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000134:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000138:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000013c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000140:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000144:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000148:	087e0863          	beq	t3,t2,800001d8 <no_reschedule>

8000014c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000014c:	00008297          	auipc	t0,0x8
80000150:	b9428293          	addi	t0,t0,-1132 # 80007ce0 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000154:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000158:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000015c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000160:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000164:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000168:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000016c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000170:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000174:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000178:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000017c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000180:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000184:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000188:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000018c:	00007397          	auipc	t2,0x7
80000190:	73438393          	addi	t2,t2,1844 # 800078c0 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000194:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000198:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000019c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
800001a0:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
800001a4:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
800001a8:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
800001ac:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001b0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001b4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001b8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001bc:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001c0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001c4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001c8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001cc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001d0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001d4:	05832d83          	lw	s11,88(t1)

800001d8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001d8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001dc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001e0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001e4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001e8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001ec:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001f0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001f4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001f8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001fc:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
80000200:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
80000204:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
80000208:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
8000020c:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000210:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000214:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000218:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000021c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000220:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000224:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000228:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000022c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000230:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000234:	30200073          	mret

80000238 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000238:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000023c:	00008297          	auipc	t0,0x8
80000240:	aa428293          	addi	t0,t0,-1372 # 80007ce0 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000244:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000248:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000024c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000250:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000254:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000025c:	00100313          	li	t1,1
	sll t0, t1, a0
80000260:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000264:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000268:	00008067          	ret

8000026c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000026c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000270:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000274:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000278:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000027c:	00028463          	beqz	t0,80000284 <not_interrupt>
	addi a0, a0, 1
80000280:	00150513          	addi	a0,a0,1

80000284 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000284:	00008067          	ret

Disassembly of section text:

80000288 <__lshrdi3>:
80000288:	02060063          	beqz	a2,800002a8 <__lshrdi3+0x20>
8000028c:	02000793          	li	a5,32
80000290:	40c787b3          	sub	a5,a5,a2
80000294:	00f04c63          	bgtz	a5,800002ac <__lshrdi3+0x24>
80000298:	fe060513          	addi	a0,a2,-32
8000029c:	00000713          	li	a4,0
800002a0:	00a5d533          	srl	a0,a1,a0
800002a4:	00070593          	mv	a1,a4
800002a8:	00008067          	ret
800002ac:	00c5d733          	srl	a4,a1,a2
800002b0:	00c55533          	srl	a0,a0,a2
800002b4:	00f595b3          	sll	a1,a1,a5
800002b8:	00b56533          	or	a0,a0,a1
800002bc:	fe9ff06f          	j	800002a4 <__lshrdi3+0x1c>

800002c0 <__udivdi3>:
800002c0:	00058793          	mv	a5,a1
800002c4:	00060813          	mv	a6,a2
800002c8:	00068713          	mv	a4,a3
800002cc:	00050313          	mv	t1,a0
800002d0:	28069663          	bnez	a3,8000055c <__udivdi3+0x29c>
800002d4:	00006897          	auipc	a7,0x6
800002d8:	51488893          	addi	a7,a7,1300 # 800067e8 <__devconfig_end>
800002dc:	0ec5f663          	bgeu	a1,a2,800003c8 <__udivdi3+0x108>
800002e0:	00010737          	lui	a4,0x10
800002e4:	0ce67863          	bgeu	a2,a4,800003b4 <__udivdi3+0xf4>
800002e8:	0ff00713          	li	a4,255
800002ec:	00c73733          	sltu	a4,a4,a2
800002f0:	00371713          	slli	a4,a4,0x3
800002f4:	00e656b3          	srl	a3,a2,a4
800002f8:	00d888b3          	add	a7,a7,a3
800002fc:	0008c683          	lbu	a3,0(a7)
80000300:	00e68733          	add	a4,a3,a4
80000304:	02000693          	li	a3,32
80000308:	40e686b3          	sub	a3,a3,a4
8000030c:	00068c63          	beqz	a3,80000324 <__udivdi3+0x64>
80000310:	00d797b3          	sll	a5,a5,a3
80000314:	00e55733          	srl	a4,a0,a4
80000318:	00d61833          	sll	a6,a2,a3
8000031c:	00f765b3          	or	a1,a4,a5
80000320:	00d51333          	sll	t1,a0,a3
80000324:	01085513          	srli	a0,a6,0x10
80000328:	02a5f733          	remu	a4,a1,a0
8000032c:	01081613          	slli	a2,a6,0x10
80000330:	01065613          	srli	a2,a2,0x10
80000334:	01035693          	srli	a3,t1,0x10
80000338:	02a5d5b3          	divu	a1,a1,a0
8000033c:	01071713          	slli	a4,a4,0x10
80000340:	00d766b3          	or	a3,a4,a3
80000344:	02b607b3          	mul	a5,a2,a1
80000348:	00058713          	mv	a4,a1
8000034c:	00f6fe63          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000350:	010686b3          	add	a3,a3,a6
80000354:	fff58713          	addi	a4,a1,-1
80000358:	0106e863          	bltu	a3,a6,80000368 <__udivdi3+0xa8>
8000035c:	00f6f663          	bgeu	a3,a5,80000368 <__udivdi3+0xa8>
80000360:	ffe58713          	addi	a4,a1,-2
80000364:	010686b3          	add	a3,a3,a6
80000368:	40f686b3          	sub	a3,a3,a5
8000036c:	02a6f7b3          	remu	a5,a3,a0
80000370:	01031313          	slli	t1,t1,0x10
80000374:	01035313          	srli	t1,t1,0x10
80000378:	02a6d6b3          	divu	a3,a3,a0
8000037c:	01079793          	slli	a5,a5,0x10
80000380:	0067e333          	or	t1,a5,t1
80000384:	02d605b3          	mul	a1,a2,a3
80000388:	00068513          	mv	a0,a3
8000038c:	00b37c63          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
80000390:	00680333          	add	t1,a6,t1
80000394:	fff68513          	addi	a0,a3,-1
80000398:	01036663          	bltu	t1,a6,800003a4 <__udivdi3+0xe4>
8000039c:	00b37463          	bgeu	t1,a1,800003a4 <__udivdi3+0xe4>
800003a0:	ffe68513          	addi	a0,a3,-2
800003a4:	01071713          	slli	a4,a4,0x10
800003a8:	00a76733          	or	a4,a4,a0
800003ac:	00000593          	li	a1,0
800003b0:	0e40006f          	j	80000494 <__udivdi3+0x1d4>
800003b4:	010006b7          	lui	a3,0x1000
800003b8:	01000713          	li	a4,16
800003bc:	f2d66ce3          	bltu	a2,a3,800002f4 <__udivdi3+0x34>
800003c0:	01800713          	li	a4,24
800003c4:	f31ff06f          	j	800002f4 <__udivdi3+0x34>
800003c8:	00061663          	bnez	a2,800003d4 <__udivdi3+0x114>
800003cc:	00100693          	li	a3,1
800003d0:	02c6d833          	divu	a6,a3,a2
800003d4:	000106b7          	lui	a3,0x10
800003d8:	0cd87263          	bgeu	a6,a3,8000049c <__udivdi3+0x1dc>
800003dc:	0ff00693          	li	a3,255
800003e0:	0106f463          	bgeu	a3,a6,800003e8 <__udivdi3+0x128>
800003e4:	00800713          	li	a4,8
800003e8:	00e856b3          	srl	a3,a6,a4
800003ec:	00d888b3          	add	a7,a7,a3
800003f0:	0008c683          	lbu	a3,0(a7)
800003f4:	00e686b3          	add	a3,a3,a4
800003f8:	02000713          	li	a4,32
800003fc:	40d70733          	sub	a4,a4,a3
80000400:	0a071863          	bnez	a4,800004b0 <__udivdi3+0x1f0>
80000404:	410787b3          	sub	a5,a5,a6
80000408:	00100593          	li	a1,1
8000040c:	01085613          	srli	a2,a6,0x10
80000410:	01081893          	slli	a7,a6,0x10
80000414:	0108d893          	srli	a7,a7,0x10
80000418:	01035693          	srli	a3,t1,0x10
8000041c:	02c7f733          	remu	a4,a5,a2
80000420:	02c7d7b3          	divu	a5,a5,a2
80000424:	01071713          	slli	a4,a4,0x10
80000428:	00d766b3          	or	a3,a4,a3
8000042c:	02f88533          	mul	a0,a7,a5
80000430:	00078713          	mv	a4,a5
80000434:	00a6fe63          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000438:	010686b3          	add	a3,a3,a6
8000043c:	fff78713          	addi	a4,a5,-1
80000440:	0106e863          	bltu	a3,a6,80000450 <__udivdi3+0x190>
80000444:	00a6f663          	bgeu	a3,a0,80000450 <__udivdi3+0x190>
80000448:	ffe78713          	addi	a4,a5,-2
8000044c:	010686b3          	add	a3,a3,a6
80000450:	40a686b3          	sub	a3,a3,a0
80000454:	02c6f7b3          	remu	a5,a3,a2
80000458:	01031313          	slli	t1,t1,0x10
8000045c:	01035313          	srli	t1,t1,0x10
80000460:	02c6d6b3          	divu	a3,a3,a2
80000464:	01079793          	slli	a5,a5,0x10
80000468:	0067e333          	or	t1,a5,t1
8000046c:	02d888b3          	mul	a7,a7,a3
80000470:	00068513          	mv	a0,a3
80000474:	01137c63          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000478:	00680333          	add	t1,a6,t1
8000047c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000480:	01036663          	bltu	t1,a6,8000048c <__udivdi3+0x1cc>
80000484:	01137463          	bgeu	t1,a7,8000048c <__udivdi3+0x1cc>
80000488:	ffe68513          	addi	a0,a3,-2
8000048c:	01071713          	slli	a4,a4,0x10
80000490:	00a76733          	or	a4,a4,a0
80000494:	00070513          	mv	a0,a4
80000498:	00008067          	ret
8000049c:	010006b7          	lui	a3,0x1000
800004a0:	01000713          	li	a4,16
800004a4:	f4d862e3          	bltu	a6,a3,800003e8 <__udivdi3+0x128>
800004a8:	01800713          	li	a4,24
800004ac:	f3dff06f          	j	800003e8 <__udivdi3+0x128>
800004b0:	00e81833          	sll	a6,a6,a4
800004b4:	00d7d5b3          	srl	a1,a5,a3
800004b8:	00e51333          	sll	t1,a0,a4
800004bc:	00d556b3          	srl	a3,a0,a3
800004c0:	01085513          	srli	a0,a6,0x10
800004c4:	00e797b3          	sll	a5,a5,a4
800004c8:	02a5f733          	remu	a4,a1,a0
800004cc:	00f6e8b3          	or	a7,a3,a5
800004d0:	01081793          	slli	a5,a6,0x10
800004d4:	0107d793          	srli	a5,a5,0x10
800004d8:	0108d613          	srli	a2,a7,0x10
800004dc:	02a5d5b3          	divu	a1,a1,a0
800004e0:	01071713          	slli	a4,a4,0x10
800004e4:	00c76733          	or	a4,a4,a2
800004e8:	02b786b3          	mul	a3,a5,a1
800004ec:	00058613          	mv	a2,a1
800004f0:	00d77e63          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
800004f4:	01070733          	add	a4,a4,a6
800004f8:	fff58613          	addi	a2,a1,-1
800004fc:	01076863          	bltu	a4,a6,8000050c <__udivdi3+0x24c>
80000500:	00d77663          	bgeu	a4,a3,8000050c <__udivdi3+0x24c>
80000504:	ffe58613          	addi	a2,a1,-2
80000508:	01070733          	add	a4,a4,a6
8000050c:	40d706b3          	sub	a3,a4,a3
80000510:	02a6f733          	remu	a4,a3,a0
80000514:	01089893          	slli	a7,a7,0x10
80000518:	0108d893          	srli	a7,a7,0x10
8000051c:	02a6d6b3          	divu	a3,a3,a0
80000520:	01071713          	slli	a4,a4,0x10
80000524:	02d785b3          	mul	a1,a5,a3
80000528:	011767b3          	or	a5,a4,a7
8000052c:	00068713          	mv	a4,a3
80000530:	00b7fe63          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000534:	010787b3          	add	a5,a5,a6
80000538:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000053c:	0107e863          	bltu	a5,a6,8000054c <__udivdi3+0x28c>
80000540:	00b7f663          	bgeu	a5,a1,8000054c <__udivdi3+0x28c>
80000544:	ffe68713          	addi	a4,a3,-2
80000548:	010787b3          	add	a5,a5,a6
8000054c:	40b787b3          	sub	a5,a5,a1
80000550:	01061593          	slli	a1,a2,0x10
80000554:	00e5e5b3          	or	a1,a1,a4
80000558:	eb5ff06f          	j	8000040c <__udivdi3+0x14c>
8000055c:	18d5e663          	bltu	a1,a3,800006e8 <__udivdi3+0x428>
80000560:	00010737          	lui	a4,0x10
80000564:	04e6f463          	bgeu	a3,a4,800005ac <__udivdi3+0x2ec>
80000568:	0ff00813          	li	a6,255
8000056c:	00d83733          	sltu	a4,a6,a3
80000570:	00371713          	slli	a4,a4,0x3
80000574:	00e6d833          	srl	a6,a3,a4
80000578:	00006597          	auipc	a1,0x6
8000057c:	27058593          	addi	a1,a1,624 # 800067e8 <__devconfig_end>
80000580:	010585b3          	add	a1,a1,a6
80000584:	0005c803          	lbu	a6,0(a1)
80000588:	02000593          	li	a1,32
8000058c:	00e80833          	add	a6,a6,a4
80000590:	410585b3          	sub	a1,a1,a6
80000594:	02059663          	bnez	a1,800005c0 <__udivdi3+0x300>
80000598:	00100713          	li	a4,1
8000059c:	eef6ece3          	bltu	a3,a5,80000494 <__udivdi3+0x1d4>
800005a0:	00c53533          	sltu	a0,a0,a2
800005a4:	00154713          	xori	a4,a0,1
800005a8:	eedff06f          	j	80000494 <__udivdi3+0x1d4>
800005ac:	010005b7          	lui	a1,0x1000
800005b0:	01000713          	li	a4,16
800005b4:	fcb6e0e3          	bltu	a3,a1,80000574 <__udivdi3+0x2b4>
800005b8:	01800713          	li	a4,24
800005bc:	fb9ff06f          	j	80000574 <__udivdi3+0x2b4>
800005c0:	01065733          	srl	a4,a2,a6
800005c4:	00b696b3          	sll	a3,a3,a1
800005c8:	00d766b3          	or	a3,a4,a3
800005cc:	0106de93          	srli	t4,a3,0x10
800005d0:	0107d733          	srl	a4,a5,a6
800005d4:	03d778b3          	remu	a7,a4,t4
800005d8:	00b797b3          	sll	a5,a5,a1
800005dc:	01055833          	srl	a6,a0,a6
800005e0:	00f86333          	or	t1,a6,a5
800005e4:	01069793          	slli	a5,a3,0x10
800005e8:	0107d793          	srli	a5,a5,0x10
800005ec:	01035813          	srli	a6,t1,0x10
800005f0:	00b61633          	sll	a2,a2,a1
800005f4:	03d75733          	divu	a4,a4,t4
800005f8:	01089893          	slli	a7,a7,0x10
800005fc:	0108e833          	or	a6,a7,a6
80000600:	02e78f33          	mul	t5,a5,a4
80000604:	00070e13          	mv	t3,a4
80000608:	01e87e63          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000060c:	00d80833          	add	a6,a6,a3
80000610:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000614:	00d86863          	bltu	a6,a3,80000624 <__udivdi3+0x364>
80000618:	01e87663          	bgeu	a6,t5,80000624 <__udivdi3+0x364>
8000061c:	ffe70e13          	addi	t3,a4,-2
80000620:	00d80833          	add	a6,a6,a3
80000624:	41e80833          	sub	a6,a6,t5
80000628:	03d878b3          	remu	a7,a6,t4
8000062c:	03d85833          	divu	a6,a6,t4
80000630:	01089893          	slli	a7,a7,0x10
80000634:	03078eb3          	mul	t4,a5,a6
80000638:	01031793          	slli	a5,t1,0x10
8000063c:	0107d793          	srli	a5,a5,0x10
80000640:	00f8e7b3          	or	a5,a7,a5
80000644:	00080713          	mv	a4,a6
80000648:	01d7fe63          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000064c:	00d787b3          	add	a5,a5,a3
80000650:	fff80713          	addi	a4,a6,-1
80000654:	00d7e863          	bltu	a5,a3,80000664 <__udivdi3+0x3a4>
80000658:	01d7f663          	bgeu	a5,t4,80000664 <__udivdi3+0x3a4>
8000065c:	ffe80713          	addi	a4,a6,-2
80000660:	00d787b3          	add	a5,a5,a3
80000664:	010e1e13          	slli	t3,t3,0x10
80000668:	41d787b3          	sub	a5,a5,t4
8000066c:	00010eb7          	lui	t4,0x10
80000670:	00ee6733          	or	a4,t3,a4
80000674:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000678:	01077333          	and	t1,a4,a6
8000067c:	01075893          	srli	a7,a4,0x10
80000680:	01067833          	and	a6,a2,a6
80000684:	01065613          	srli	a2,a2,0x10
80000688:	03030e33          	mul	t3,t1,a6
8000068c:	03088833          	mul	a6,a7,a6
80000690:	010e5693          	srli	a3,t3,0x10
80000694:	02c30333          	mul	t1,t1,a2
80000698:	01030333          	add	t1,t1,a6
8000069c:	006686b3          	add	a3,a3,t1
800006a0:	02c888b3          	mul	a7,a7,a2
800006a4:	0106f463          	bgeu	a3,a6,800006ac <__udivdi3+0x3ec>
800006a8:	01d888b3          	add	a7,a7,t4
800006ac:	0106d613          	srli	a2,a3,0x10
800006b0:	011608b3          	add	a7,a2,a7
800006b4:	0317e663          	bltu	a5,a7,800006e0 <__udivdi3+0x420>
800006b8:	cf179ae3          	bne	a5,a7,800003ac <__udivdi3+0xec>
800006bc:	000107b7          	lui	a5,0x10
800006c0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006c4:	00f6f6b3          	and	a3,a3,a5
800006c8:	01069693          	slli	a3,a3,0x10
800006cc:	00fe7e33          	and	t3,t3,a5
800006d0:	00b51533          	sll	a0,a0,a1
800006d4:	01c686b3          	add	a3,a3,t3
800006d8:	00000593          	li	a1,0
800006dc:	dad57ce3          	bgeu	a0,a3,80000494 <__udivdi3+0x1d4>
800006e0:	fff70713          	addi	a4,a4,-1
800006e4:	cc9ff06f          	j	800003ac <__udivdi3+0xec>
800006e8:	00000593          	li	a1,0
800006ec:	00000713          	li	a4,0
800006f0:	da5ff06f          	j	80000494 <__udivdi3+0x1d4>

800006f4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006f4:	00008067          	ret

800006f8 <test_main>:
			 ztest_unit_test(test_fifo_get_fail),
			 ztest_unit_test(test_fifo_loop),
			 ztest_unit_test(test_fifo_cancel_wait),
			 ztest_unit_test(test_fifo_is_empty_thread),
			 ztest_unit_test(test_fifo_is_empty_isr));
	ztest_run_test_suite(fifo_api);
800006f8:	800075b7          	lui	a1,0x80007
800006fc:	80007537          	lui	a0,0x80007
80000700:	7f858593          	addi	a1,a1,2040 # 800077f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077f9>
80000704:	9a050513          	addi	a0,a0,-1632 # 800069a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069a1>
80000708:	56c0206f          	j	80002c74 <z_ztest_run_test_suite>

8000070c <z_zassert.constprop.0>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
8000070c:	fd010113          	addi	sp,sp,-48
80000710:	00112e23          	sw	ra,28(sp)
80000714:	00812c23          	sw	s0,24(sp)
80000718:	03012423          	sw	a6,40(sp)
8000071c:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000720:	04051863          	bnez	a0,80000770 <z_zassert.constprop.0+0x64>
80000724:	00068613          	mv	a2,a3
80000728:	00058713          	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000072c:	800076b7          	lui	a3,0x80007
80000730:	800075b7          	lui	a1,0x80007
80000734:	80007537          	lui	a0,0x80007
80000738:	9ac68693          	addi	a3,a3,-1620 # 800069ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069ad>
8000073c:	00078413          	mv	s0,a5
80000740:	a5058593          	addi	a1,a1,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
		va_start(vargs, msg);
80000744:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000748:	a8450513          	addi	a0,a0,-1404 # 80006a84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a85>
		va_start(vargs, msg);
8000074c:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000750:	58d010ef          	jal	ra,800024dc <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000754:	00c12583          	lw	a1,12(sp)
80000758:	00040513          	mv	a0,s0
8000075c:	551010ef          	jal	ra,800024ac <vprintk>
		printk("\n");
80000760:	80007537          	lui	a0,0x80007
80000764:	f3850513          	addi	a0,a0,-200 # 80006f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f39>
80000768:	575010ef          	jal	ra,800024dc <printk>
		va_end(vargs);
		ztest_test_fail();
8000076c:	4d8020ef          	jal	ra,80002c44 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000770:	01c12083          	lw	ra,28(sp)
80000774:	01812403          	lw	s0,24(sp)
80000778:	03010113          	addi	sp,sp,48
8000077c:	00008067          	ret

80000780 <tfifo_thread_thread>:
	k_sleep(50);
	k_fifo_cancel_wait((struct k_fifo *)p1);
}

static void tfifo_thread_thread(struct k_fifo *pfifo)
{
80000780:	fd010113          	addi	sp,sp,-48
80000784:	02912223          	sw	s1,36(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_OBJECT_RELEASE, k_object_release, void *, object)

K_SYSCALL_DECLARE1(K_SYSCALL_K_OBJECT_ALLOC, k_object_alloc, void *, enum k_objects, otype)

K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000788:	00050713          	mv	a4,a0
8000078c:	00050493          	mv	s1,a0
80000790:	800016b7          	lui	a3,0x80001
80000794:	800085b7          	lui	a1,0x80008
80000798:	80008537          	lui	a0,0x80008
8000079c:	00000893          	li	a7,0
800007a0:	00000813          	li	a6,0
800007a4:	00000793          	li	a5,0
800007a8:	86868693          	addi	a3,a3,-1944 # 80000868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000869>
800007ac:	20000613          	li	a2,512
800007b0:	d1058593          	addi	a1,a1,-752 # 80007d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d11>
800007b4:	00012223          	sw	zero,4(sp)
800007b8:	00012023          	sw	zero,0(sp)
800007bc:	99850513          	addi	a0,a0,-1640 # 80007998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007999>
800007c0:	02112623          	sw	ra,44(sp)
800007c4:	02812423          	sw	s0,40(sp)
800007c8:	03212023          	sw	s2,32(sp)
800007cc:	01312e23          	sw	s3,28(sp)
800007d0:	691040ef          	jal	ra,80005660 <z_impl_k_thread_create>
800007d4:	00050913          	mv	s2,a0

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800007d8:	269050ef          	jal	ra,80006240 <z_impl_k_uptime_get_32>

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_APPEND, k_queue_alloc_append, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_ALLOC_PREPEND, k_queue_alloc_prepend, s32_t, struct k_queue *, queue, void *, data)

K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800007dc:	1f400593          	li	a1,500
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800007e0:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
800007e4:	00048513          	mv	a0,s1
800007e8:	70d020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
800007ec:	00050993          	mv	s3,a0
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800007f0:	251050ef          	jal	ra,80006240 <z_impl_k_uptime_get_32>
	k_tid_t tid = k_thread_create(&thread, tstack, STACK_SIZE,
				      t_cancel_wait_entry, pfifo, NULL, NULL,
				      K_PRIO_PREEMPT(0), 0, 0);
	u32_t start_t = k_uptime_get_32();
	void *ret = k_fifo_get(pfifo, 500);
	u32_t dur = k_uptime_get_32() - start_t;
800007f4:	40850433          	sub	s0,a0,s0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800007f8:	00090513          	mv	a0,s2
800007fc:	008050ef          	jal	ra,80005804 <z_impl_k_thread_abort>
	 * that the test runner below will try to create another
	 * thread in the same stack space, then 1st thread returns
	 * from the call, leading to crash.
	 */
	k_thread_abort(tid);
	zassert_is_null(ret,
80000800:	80007937          	lui	s2,0x80007
80000804:	800074b7          	lui	s1,0x80007
80000808:	800077b7          	lui	a5,0x80007
8000080c:	800075b7          	lui	a1,0x80007
80000810:	9ac90713          	addi	a4,s2,-1620 # 800069ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069ad>
80000814:	a5048613          	addi	a2,s1,-1456 # 80006a50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a51>
80000818:	0019b513          	seqz	a0,s3
8000081c:	9c078793          	addi	a5,a5,-1600 # 800069c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069c1>
80000820:	02b00693          	li	a3,43
80000824:	9f058593          	addi	a1,a1,-1552 # 800069f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069f1>
80000828:	ee5ff0ef          	jal	ra,8000070c <z_zassert.constprop.0>
	/* 80 includes generous fuzz factor as k_sleep() will add an extra
	 * tick for non-tickless systems, and we may cross another tick
	 * boundary while doing this. We just want to ensure we didn't
	 * hit the timeout anyway.
	 */
	zassert_true(dur < 80,
8000082c:	05043513          	sltiu	a0,s0,80
		     "k_fifo_get didn't get cancelled in expected timeframe");
}
80000830:	02812403          	lw	s0,40(sp)
80000834:	02c12083          	lw	ra,44(sp)
80000838:	01c12983          	lw	s3,28(sp)
	zassert_true(dur < 80,
8000083c:	9ac90713          	addi	a4,s2,-1620
80000840:	a5048613          	addi	a2,s1,-1456
}
80000844:	02012903          	lw	s2,32(sp)
80000848:	02412483          	lw	s1,36(sp)
	zassert_true(dur < 80,
8000084c:	800077b7          	lui	a5,0x80007
80000850:	800075b7          	lui	a1,0x80007
80000854:	a0478793          	addi	a5,a5,-1532 # 80006a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a05>
80000858:	03200693          	li	a3,50
8000085c:	a3c58593          	addi	a1,a1,-1476 # 80006a3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a3d>
}
80000860:	03010113          	addi	sp,sp,48
	zassert_true(dur < 80,
80000864:	ea9ff06f          	j	8000070c <z_zassert.constprop.0>

80000868 <t_cancel_wait_entry>:
{
80000868:	ff010113          	addi	sp,sp,-16
8000086c:	00812423          	sw	s0,8(sp)
80000870:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000874:	03200513          	li	a0,50
80000878:	00112623          	sw	ra,12(sp)
8000087c:	554040ef          	jal	ra,80004dd0 <z_impl_k_sleep>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_CANCEL_WAIT, k_queue_cancel_wait, struct k_queue *, queue)
80000880:	00040513          	mv	a0,s0
}
80000884:	00812403          	lw	s0,8(sp)
80000888:	00c12083          	lw	ra,12(sp)
8000088c:	01010113          	addi	sp,sp,16
80000890:	3d10206f          	j	80003460 <z_impl_k_queue_cancel_wait>

80000894 <test_fifo_cancel_wait>:
 * @details This routine causes first thread pending on fifo (if any),
 * to return from k_fifo_get() with NULL value (as if timeout expired).
 * @see k_fifo_init(),k_fifo_get(), k_fifo_cancel_wait()
 */
void test_fifo_cancel_wait(void)
{
80000894:	ff010113          	addi	sp,sp,-16
80000898:	00812423          	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
8000089c:	80008437          	lui	s0,0x80008
800008a0:	98440513          	addi	a0,s0,-1660 # 80007984 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007985>
800008a4:	00112623          	sw	ra,12(sp)
800008a8:	39d020ef          	jal	ra,80003444 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo_c);
	tfifo_thread_thread(&fifo_c);
800008ac:	98440513          	addi	a0,s0,-1660
800008b0:	ed1ff0ef          	jal	ra,80000780 <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo_c);
}
800008b4:	00812403          	lw	s0,8(sp)
800008b8:	00c12083          	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo_c);
800008bc:	80008537          	lui	a0,0x80008
800008c0:	90c50513          	addi	a0,a0,-1780 # 8000790c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000790d>
}
800008c4:	01010113          	addi	sp,sp,16
	tfifo_thread_thread(&kfifo_c);
800008c8:	eb9ff06f          	j	80000780 <tfifo_thread_thread>

800008cc <z_zassert.constprop.5>:
static inline void z_zassert(int cond,
800008cc:	fd010113          	addi	sp,sp,-48
800008d0:	00112e23          	sw	ra,28(sp)
800008d4:	03012423          	sw	a6,40(sp)
800008d8:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
800008dc:	04051663          	bnez	a0,80000928 <z_zassert.constprop.5+0x5c>
800008e0:	00068613          	mv	a2,a3
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800008e4:	80007537          	lui	a0,0x80007
800008e8:	00070693          	mv	a3,a4
800008ec:	00058713          	mv	a4,a1
800008f0:	800075b7          	lui	a1,0x80007
		va_start(vargs, msg);
800008f4:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800008f8:	c3c58593          	addi	a1,a1,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
800008fc:	a8450513          	addi	a0,a0,-1404 # 80006a84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a85>
		va_start(vargs, msg);
80000900:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000904:	3d9010ef          	jal	ra,800024dc <printk>
		vprintk(msg, vargs);
80000908:	00c12583          	lw	a1,12(sp)
8000090c:	80007537          	lui	a0,0x80007
80000910:	e3850513          	addi	a0,a0,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000914:	399010ef          	jal	ra,800024ac <vprintk>
		printk("\n");
80000918:	80007537          	lui	a0,0x80007
8000091c:	f3850513          	addi	a0,a0,-200 # 80006f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f39>
80000920:	3bd010ef          	jal	ra,800024dc <printk>
		ztest_test_fail();
80000924:	320020ef          	jal	ra,80002c44 <ztest_test_fail>
}
80000928:	01c12083          	lw	ra,28(sp)
8000092c:	03010113          	addi	sp,sp,48
80000930:	00008067          	ret

80000934 <tfifo_get>:
	sys_slist_append(&slist, (sys_snode_t *)&(data_sl[1].snode));
	k_fifo_put_slist(pfifo, &slist);
}

static void tfifo_get(struct k_fifo *pfifo)
{
80000934:	fe010113          	addi	sp,sp,-32
80000938:	00812c23          	sw	s0,24(sp)
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
8000093c:	00000593          	li	a1,0

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000940:	80008437          	lui	s0,0x80008
{
80000944:	00112e23          	sw	ra,28(sp)
80000948:	00912a23          	sw	s1,20(sp)
8000094c:	01212823          	sw	s2,16(sp)
80000950:	01312623          	sw	s3,12(sp)
80000954:	01412423          	sw	s4,8(sp)
80000958:	01512223          	sw	s5,4(sp)
8000095c:	00050a13          	mv	s4,a0
		zassert_equal(rx_data, (void *)&data[i], NULL);
80000960:	a0840413          	addi	s0,s0,-1528 # 80007a08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a09>
80000964:	591020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
80000968:	80007937          	lui	s2,0x80007
8000096c:	800079b7          	lui	s3,0x80007
80000970:	800074b7          	lui	s1,0x80007
80000974:	80007ab7          	lui	s5,0x80007
80000978:	40850533          	sub	a0,a0,s0
8000097c:	e3898793          	addi	a5,s3,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000980:	aac90713          	addi	a4,s2,-1364 # 80006aac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006aad>
80000984:	c3c48613          	addi	a2,s1,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80000988:	03600693          	li	a3,54
8000098c:	b80a8593          	addi	a1,s5,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
80000990:	00153513          	seqz	a0,a0
80000994:	f39ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>
80000998:	00000593          	li	a1,0
8000099c:	000a0513          	mv	a0,s4
800009a0:	555020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
800009a4:	00840413          	addi	s0,s0,8
800009a8:	40850533          	sub	a0,a0,s0
800009ac:	e3898793          	addi	a5,s3,-456
800009b0:	aac90713          	addi	a4,s2,-1364
800009b4:	c3c48613          	addi	a2,s1,-964
800009b8:	03600693          	li	a3,54
800009bc:	b80a8593          	addi	a1,s5,-1152
800009c0:	00153513          	seqz	a0,a0
800009c4:	f09ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>
800009c8:	00000593          	li	a1,0
800009cc:	000a0513          	mv	a0,s4
	}
	/*get fifo data from "fifo_put_list"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_l[i], NULL);
800009d0:	80008437          	lui	s0,0x80008
800009d4:	521020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
800009d8:	a1840413          	addi	s0,s0,-1512 # 80007a18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a19>
800009dc:	80007ab7          	lui	s5,0x80007
800009e0:	40850533          	sub	a0,a0,s0
800009e4:	e3898793          	addi	a5,s3,-456
800009e8:	aac90713          	addi	a4,s2,-1364
800009ec:	c3c48613          	addi	a2,s1,-964
800009f0:	03b00693          	li	a3,59
800009f4:	ba8a8593          	addi	a1,s5,-1112 # 80006ba8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ba9>
800009f8:	00153513          	seqz	a0,a0
800009fc:	ed1ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>
80000a00:	00000593          	li	a1,0
80000a04:	000a0513          	mv	a0,s4
80000a08:	4ed020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
80000a0c:	00840413          	addi	s0,s0,8
80000a10:	40850533          	sub	a0,a0,s0
80000a14:	e3898793          	addi	a5,s3,-456
80000a18:	aac90713          	addi	a4,s2,-1364
80000a1c:	c3c48613          	addi	a2,s1,-964
80000a20:	03b00693          	li	a3,59
80000a24:	ba8a8593          	addi	a1,s5,-1112
80000a28:	00153513          	seqz	a0,a0
80000a2c:	ea1ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>
80000a30:	00000593          	li	a1,0
80000a34:	000a0513          	mv	a0,s4
	}
	/*get fifo data from "fifo_put_slist"*/
	for (int i = 0; i < LIST_LEN; i++) {
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000a38:	80008437          	lui	s0,0x80008
80000a3c:	4b9020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
80000a40:	a2840413          	addi	s0,s0,-1496 # 80007a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a29>
80000a44:	80007ab7          	lui	s5,0x80007
80000a48:	40850533          	sub	a0,a0,s0
80000a4c:	e3898793          	addi	a5,s3,-456
80000a50:	aac90713          	addi	a4,s2,-1364
80000a54:	c3c48613          	addi	a2,s1,-964
80000a58:	04000693          	li	a3,64
80000a5c:	bd0a8593          	addi	a1,s5,-1072 # 80006bd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bd1>
80000a60:	00153513          	seqz	a0,a0
80000a64:	e69ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>
80000a68:	00000593          	li	a1,0
80000a6c:	000a0513          	mv	a0,s4
80000a70:	485020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
80000a74:	00840413          	addi	s0,s0,8
80000a78:	40850533          	sub	a0,a0,s0
	}
}
80000a7c:	01812403          	lw	s0,24(sp)
80000a80:	01c12083          	lw	ra,28(sp)
80000a84:	00812a03          	lw	s4,8(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000a88:	e3898793          	addi	a5,s3,-456
80000a8c:	aac90713          	addi	a4,s2,-1364
}
80000a90:	00c12983          	lw	s3,12(sp)
80000a94:	01012903          	lw	s2,16(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000a98:	c3c48613          	addi	a2,s1,-964
80000a9c:	bd0a8593          	addi	a1,s5,-1072
}
80000aa0:	01412483          	lw	s1,20(sp)
80000aa4:	00412a83          	lw	s5,4(sp)
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000aa8:	04000693          	li	a3,64
80000aac:	00153513          	seqz	a0,a0
}
80000ab0:	02010113          	addi	sp,sp,32
		zassert_equal(rx_data, (void *)&data_sl[i], NULL);
80000ab4:	e19ff06f          	j	800008cc <z_zassert.constprop.5>

80000ab8 <tIsr_entry_get>:
	tfifo_put((struct k_fifo *)p);
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
}

static void tIsr_entry_get(void *p)
{
80000ab8:	ff010113          	addi	sp,sp,-16
80000abc:	00812423          	sw	s0,8(sp)
80000ac0:	00112623          	sw	ra,12(sp)
80000ac4:	00050413          	mv	s0,a0
	tfifo_get((struct k_fifo *)p);
80000ac8:	e6dff0ef          	jal	ra,80000934 <tfifo_get>
 *
 * @return a boolean, true if it's empty, false otherwise
 */
static inline bool sys_sflist_is_empty(sys_sflist_t *list);

Z_GENLIST_IS_EMPTY(sflist)
80000acc:	00042503          	lw	a0,0(s0)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
}
80000ad0:	00812403          	lw	s0,8(sp)
80000ad4:	00c12083          	lw	ra,12(sp)
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000ad8:	800077b7          	lui	a5,0x80007
80000adc:	80007737          	lui	a4,0x80007
80000ae0:	80007637          	lui	a2,0x80007
80000ae4:	800075b7          	lui	a1,0x80007
80000ae8:	e3878793          	addi	a5,a5,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000aec:	ac870713          	addi	a4,a4,-1336 # 80006ac8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ac9>
80000af0:	04e00693          	li	a3,78
80000af4:	c3c60613          	addi	a2,a2,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80000af8:	b0458593          	addi	a1,a1,-1276 # 80006b04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b05>
80000afc:	00153513          	seqz	a0,a0
}
80000b00:	01010113          	addi	sp,sp,16
	zassert_true(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000b04:	dc9ff06f          	j	800008cc <z_zassert.constprop.5>

80000b08 <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
80000b08:	ff010113          	addi	sp,sp,-16
80000b0c:	00112623          	sw	ra,12(sp)
	tfifo_get((struct k_fifo *)p1);
80000b10:	e25ff0ef          	jal	ra,80000934 <tfifo_get>
	k_sem_give(&end_sema);
}
80000b14:	00c12083          	lw	ra,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b18:	80008537          	lui	a0,0x80008
80000b1c:	a3850513          	addi	a0,a0,-1480 # 80007a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a39>
80000b20:	01010113          	addi	sp,sp,16
80000b24:	5bc0406f          	j	800050e0 <z_impl_k_sem_give>

80000b28 <tfifo_thread_isr>:
	k_sem_take(&end_sema, K_FOREVER);
	k_thread_abort(tid);
}

static void tfifo_thread_isr(struct k_fifo *pfifo)
{
80000b28:	ff010113          	addi	sp,sp,-16
80000b2c:	00812423          	sw	s0,8(sp)
80000b30:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000b34:	80008537          	lui	a0,0x80008
80000b38:	00100613          	li	a2,1
80000b3c:	00000593          	li	a1,0
80000b40:	a3850513          	addi	a0,a0,-1480 # 80007a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a39>
80000b44:	00112623          	sw	ra,12(sp)
80000b48:	4d0040ef          	jal	ra,80005018 <z_impl_k_sem_init>
	k_sem_init(&end_sema, 0, 1);
	/**TESTPOINT: isr-thread data passing via fifo*/
	irq_offload(tIsr_entry_put, pfifo);
80000b4c:	80001537          	lui	a0,0x80001
80000b50:	00040593          	mv	a1,s0
80000b54:	bfc50513          	addi	a0,a0,-1028 # 80000bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000bfd>
80000b58:	255000ef          	jal	ra,800015ac <irq_offload>
	tfifo_get(pfifo);
80000b5c:	00040513          	mv	a0,s0
}
80000b60:	00812403          	lw	s0,8(sp)
80000b64:	00c12083          	lw	ra,12(sp)
80000b68:	01010113          	addi	sp,sp,16
	tfifo_get(pfifo);
80000b6c:	dc9ff06f          	j	80000934 <tfifo_get>

80000b70 <tfifo_put>:
{
80000b70:	fe010113          	addi	sp,sp,-32
		k_fifo_put(pfifo, (void *)&data[i]);
80000b74:	800085b7          	lui	a1,0x80008
{
80000b78:	00912a23          	sw	s1,20(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80000b7c:	a0858493          	addi	s1,a1,-1528 # 80007a08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a09>
80000b80:	a0858593          	addi	a1,a1,-1528
{
80000b84:	00112e23          	sw	ra,28(sp)
80000b88:	00812c23          	sw	s0,24(sp)
80000b8c:	00050413          	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80000b90:	181020ef          	jal	ra,80003510 <k_queue_append>
80000b94:	00848593          	addi	a1,s1,8
80000b98:	00040513          	mv	a0,s0
80000b9c:	175020ef          	jal	ra,80003510 <k_queue_append>
	head->snode.next = (sys_snode_t *)tail;
80000ba0:	800085b7          	lui	a1,0x80008
80000ba4:	a1858793          	addi	a5,a1,-1512 # 80007a18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a19>
80000ba8:	00878613          	addi	a2,a5,8
80000bac:	00c7a023          	sw	a2,0(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000bb0:	00040513          	mv	a0,s0
	tail->snode.next = NULL;
80000bb4:	0007a423          	sw	zero,8(a5)
	k_fifo_put_list(pfifo, (u32_t *)head, (u32_t *)tail);
80000bb8:	a1858593          	addi	a1,a1,-1512
80000bbc:	165020ef          	jal	ra,80003520 <k_queue_append_list>
	parent->next = child;
}

static inline void z_slist_head_set(sys_slist_t *list, sys_snode_t *node)
{
	list->head = node;
80000bc0:	800087b7          	lui	a5,0x80008
80000bc4:	a2878793          	addi	a5,a5,-1496 # 80007a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a29>
	parent->next = child;
80000bc8:	00878713          	addi	a4,a5,8
	k_fifo_put_slist(pfifo, &slist);
80000bcc:	00810593          	addi	a1,sp,8
80000bd0:	00040513          	mv	a0,s0
80000bd4:	0007a423          	sw	zero,8(a5)
80000bd8:	00e7a023          	sw	a4,0(a5)
	list->head = node;
80000bdc:	00f12423          	sw	a5,8(sp)
}

static inline void z_slist_tail_set(sys_slist_t *list, sys_snode_t *node)
{
	list->tail = node;
80000be0:	00e12623          	sw	a4,12(sp)
80000be4:	285020ef          	jal	ra,80003668 <k_queue_merge_slist>
}
80000be8:	01c12083          	lw	ra,28(sp)
80000bec:	01812403          	lw	s0,24(sp)
80000bf0:	01412483          	lw	s1,20(sp)
80000bf4:	02010113          	addi	sp,sp,32
80000bf8:	00008067          	ret

80000bfc <tIsr_entry_put>:
{
80000bfc:	ff010113          	addi	sp,sp,-16
80000c00:	00812423          	sw	s0,8(sp)
80000c04:	00112623          	sw	ra,12(sp)
80000c08:	00050413          	mv	s0,a0
	tfifo_put((struct k_fifo *)p);
80000c0c:	f65ff0ef          	jal	ra,80000b70 <tfifo_put>
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000c10:	00042503          	lw	a0,0(s0)
}
80000c14:	00812403          	lw	s0,8(sp)
80000c18:	00c12083          	lw	ra,12(sp)
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000c1c:	800077b7          	lui	a5,0x80007
80000c20:	80007737          	lui	a4,0x80007
80000c24:	80007637          	lui	a2,0x80007
80000c28:	800075b7          	lui	a1,0x80007
80000c2c:	e3878793          	addi	a5,a5,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000c30:	ab870713          	addi	a4,a4,-1352 # 80006ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ab9>
80000c34:	04800693          	li	a3,72
80000c38:	c3c60613          	addi	a2,a2,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80000c3c:	b3458593          	addi	a1,a1,-1228 # 80006b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b35>
80000c40:	00a03533          	snez	a0,a0
}
80000c44:	01010113          	addi	sp,sp,16
	zassert_false(k_fifo_is_empty((struct k_fifo *)p), NULL);
80000c48:	c85ff06f          	j	800008cc <z_zassert.constprop.5>

80000c4c <tfifo_is_empty>:
	tfifo_put(pfifo);
	irq_offload(tIsr_entry_get, pfifo);
}

static void tfifo_is_empty(void *p)
{
80000c4c:	fe010113          	addi	sp,sp,-32
80000c50:	01412423          	sw	s4,8(sp)
	struct k_fifo *pfifo = (struct k_fifo *)p;

	tfifo_put(&fifo);
80000c54:	80008a37          	lui	s4,0x80008
{
80000c58:	01312623          	sw	s3,12(sp)
80000c5c:	00050993          	mv	s3,a0
	tfifo_put(&fifo);
80000c60:	a48a0513          	addi	a0,s4,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
{
80000c64:	00112e23          	sw	ra,28(sp)
80000c68:	00812c23          	sw	s0,24(sp)
80000c6c:	00912a23          	sw	s1,20(sp)
80000c70:	01212823          	sw	s2,16(sp)
	tfifo_put(&fifo);
80000c74:	efdff0ef          	jal	ra,80000b70 <tfifo_put>
	/**TESTPOINT: return false when data available*/
	zassert_false(k_fifo_is_empty(pfifo), NULL);
80000c78:	0009a503          	lw	a0,0(s3)
80000c7c:	800074b7          	lui	s1,0x80007
80000c80:	80007937          	lui	s2,0x80007
80000c84:	80007437          	lui	s0,0x80007
80000c88:	800075b7          	lui	a1,0x80007
80000c8c:	e3890793          	addi	a5,s2,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000c90:	ad848713          	addi	a4,s1,-1320 # 80006ad8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ad9>
80000c94:	c3c40613          	addi	a2,s0,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80000c98:	07900693          	li	a3,121
80000c9c:	bfc58593          	addi	a1,a1,-1028 # 80006bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bfd>
80000ca0:	00a03533          	snez	a0,a0
80000ca4:	c29ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>

	tfifo_get(&fifo);
80000ca8:	a48a0513          	addi	a0,s4,-1464
80000cac:	c89ff0ef          	jal	ra,80000934 <tfifo_get>
80000cb0:	0009a503          	lw	a0,0(s3)
	/**TESTPOINT: return true with data unavailable*/
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000cb4:	c3c40613          	addi	a2,s0,-964
}
80000cb8:	01812403          	lw	s0,24(sp)
80000cbc:	01c12083          	lw	ra,28(sp)
80000cc0:	00c12983          	lw	s3,12(sp)
80000cc4:	00812a03          	lw	s4,8(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000cc8:	e3890793          	addi	a5,s2,-456
80000ccc:	ad848713          	addi	a4,s1,-1320
}
80000cd0:	01012903          	lw	s2,16(sp)
80000cd4:	01412483          	lw	s1,20(sp)
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000cd8:	800075b7          	lui	a1,0x80007
80000cdc:	07d00693          	li	a3,125
80000ce0:	c1c58593          	addi	a1,a1,-996 # 80006c1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c1d>
80000ce4:	00153513          	seqz	a0,a0
}
80000ce8:	02010113          	addi	sp,sp,32
	zassert_true(k_fifo_is_empty(pfifo), NULL);
80000cec:	be1ff06f          	j	800008cc <z_zassert.constprop.5>

80000cf0 <tfifo_thread_thread>:
{
80000cf0:	fe010113          	addi	sp,sp,-32
80000cf4:	00812c23          	sw	s0,24(sp)
80000cf8:	80008437          	lui	s0,0x80008
80000cfc:	00912a23          	sw	s1,20(sp)
80000d00:	00100613          	li	a2,1
80000d04:	00050493          	mv	s1,a0
80000d08:	00000593          	li	a1,0
80000d0c:	a3840513          	addi	a0,s0,-1480 # 80007a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a39>
80000d10:	00112e23          	sw	ra,28(sp)
80000d14:	01212823          	sw	s2,16(sp)
80000d18:	300040ef          	jal	ra,80005018 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000d1c:	800016b7          	lui	a3,0x80001
80000d20:	800085b7          	lui	a1,0x80008
80000d24:	80008537          	lui	a0,0x80008
80000d28:	00048713          	mv	a4,s1
80000d2c:	00000893          	li	a7,0
80000d30:	00000813          	li	a6,0
80000d34:	00000793          	li	a5,0
80000d38:	b0868693          	addi	a3,a3,-1272 # 80000b08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b09>
80000d3c:	20000613          	li	a2,512
80000d40:	f1058593          	addi	a1,a1,-240 # 80007f10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007f11>
80000d44:	00012223          	sw	zero,4(sp)
80000d48:	00012023          	sw	zero,0(sp)
80000d4c:	a5c50513          	addi	a0,a0,-1444 # 80007a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a5d>
80000d50:	111040ef          	jal	ra,80005660 <z_impl_k_thread_create>
80000d54:	00050913          	mv	s2,a0
	tfifo_put(pfifo);
80000d58:	00048513          	mv	a0,s1
80000d5c:	e15ff0ef          	jal	ra,80000b70 <tfifo_put>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000d60:	a3840513          	addi	a0,s0,-1480
80000d64:	fff00593          	li	a1,-1
80000d68:	45c040ef          	jal	ra,800051c4 <z_impl_k_sem_take>
}
80000d6c:	01812403          	lw	s0,24(sp)
80000d70:	01c12083          	lw	ra,28(sp)
80000d74:	01412483          	lw	s1,20(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000d78:	00090513          	mv	a0,s2
80000d7c:	01012903          	lw	s2,16(sp)
80000d80:	02010113          	addi	sp,sp,32
80000d84:	2810406f          	j	80005804 <z_impl_k_thread_abort>

80000d88 <tfifo_isr_thread>:
{
80000d88:	ff010113          	addi	sp,sp,-16
80000d8c:	00812423          	sw	s0,8(sp)
80000d90:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000d94:	80008537          	lui	a0,0x80008
80000d98:	00000593          	li	a1,0
80000d9c:	00100613          	li	a2,1
80000da0:	a3850513          	addi	a0,a0,-1480 # 80007a38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a39>
80000da4:	00112623          	sw	ra,12(sp)
80000da8:	270040ef          	jal	ra,80005018 <z_impl_k_sem_init>
	tfifo_put(pfifo);
80000dac:	00040513          	mv	a0,s0
80000db0:	dc1ff0ef          	jal	ra,80000b70 <tfifo_put>
	irq_offload(tIsr_entry_get, pfifo);
80000db4:	00040593          	mv	a1,s0
}
80000db8:	00812403          	lw	s0,8(sp)
80000dbc:	00c12083          	lw	ra,12(sp)
	irq_offload(tIsr_entry_get, pfifo);
80000dc0:	80001537          	lui	a0,0x80001
80000dc4:	ab850513          	addi	a0,a0,-1352 # 80000ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000ab9>
}
80000dc8:	01010113          	addi	sp,sp,16
	irq_offload(tIsr_entry_get, pfifo);
80000dcc:	7e00006f          	j	800015ac <irq_offload>

80000dd0 <test_fifo_thread2thread>:
/**
 * @brief Test thread to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get(), k_fifo_put_list()
 */
void test_fifo_thread2thread(void)
{
80000dd0:	ff010113          	addi	sp,sp,-16
80000dd4:	00812423          	sw	s0,8(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
80000dd8:	80008437          	lui	s0,0x80008
80000ddc:	a4840513          	addi	a0,s0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
80000de0:	00112623          	sw	ra,12(sp)
80000de4:	660020ef          	jal	ra,80003444 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_thread(&fifo);
80000de8:	a4840513          	addi	a0,s0,-1464
80000dec:	f05ff0ef          	jal	ra,80000cf0 <tfifo_thread_thread>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_thread(&kfifo);
}
80000df0:	00812403          	lw	s0,8(sp)
80000df4:	00c12083          	lw	ra,12(sp)
	tfifo_thread_thread(&kfifo);
80000df8:	80008537          	lui	a0,0x80008
80000dfc:	92050513          	addi	a0,a0,-1760 # 80007920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007921>
}
80000e00:	01010113          	addi	sp,sp,16
	tfifo_thread_thread(&kfifo);
80000e04:	eedff06f          	j	80000cf0 <tfifo_thread_thread>

80000e08 <test_fifo_thread2isr>:
/**
 * @brief Test isr to thread data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_thread2isr(void)
{
80000e08:	ff010113          	addi	sp,sp,-16
80000e0c:	00812423          	sw	s0,8(sp)
80000e10:	80008437          	lui	s0,0x80008
80000e14:	a4840513          	addi	a0,s0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
80000e18:	00112623          	sw	ra,12(sp)
80000e1c:	628020ef          	jal	ra,80003444 <z_impl_k_queue_init>
	/**TESTPOINT: init via k_fifo_init*/
	k_fifo_init(&fifo);
	tfifo_thread_isr(&fifo);
80000e20:	a4840513          	addi	a0,s0,-1464
80000e24:	d05ff0ef          	jal	ra,80000b28 <tfifo_thread_isr>

	/**TESTPOINT: test K_FIFO_DEFINEed fifo*/
	tfifo_thread_isr(&kfifo);
}
80000e28:	00812403          	lw	s0,8(sp)
80000e2c:	00c12083          	lw	ra,12(sp)
	tfifo_thread_isr(&kfifo);
80000e30:	80008537          	lui	a0,0x80008
80000e34:	92050513          	addi	a0,a0,-1760 # 80007920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007921>
}
80000e38:	01010113          	addi	sp,sp,16
	tfifo_thread_isr(&kfifo);
80000e3c:	cedff06f          	j	80000b28 <tfifo_thread_isr>

80000e40 <test_fifo_isr2thread>:
/**
 * @brief Test thread to isr data passing via fifo
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_isr2thread(void)
{
80000e40:	ff010113          	addi	sp,sp,-16
80000e44:	00812423          	sw	s0,8(sp)
80000e48:	80008437          	lui	s0,0x80008
80000e4c:	a4840513          	addi	a0,s0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
80000e50:	00112623          	sw	ra,12(sp)
80000e54:	5f0020ef          	jal	ra,80003444 <z_impl_k_queue_init>
	/**TESTPOINT: test k_fifo_init fifo*/
	k_fifo_init(&fifo);
	tfifo_isr_thread(&fifo);
80000e58:	a4840513          	addi	a0,s0,-1464
80000e5c:	f2dff0ef          	jal	ra,80000d88 <tfifo_isr_thread>

	/**TESTPOINT: test K_FIFO_DEFINE fifo*/
	tfifo_isr_thread(&kfifo);
}
80000e60:	00812403          	lw	s0,8(sp)
80000e64:	00c12083          	lw	ra,12(sp)
	tfifo_isr_thread(&kfifo);
80000e68:	80008537          	lui	a0,0x80008
80000e6c:	92050513          	addi	a0,a0,-1760 # 80007920 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007921>
}
80000e70:	01010113          	addi	sp,sp,16
	tfifo_isr_thread(&kfifo);
80000e74:	f15ff06f          	j	80000d88 <tfifo_isr_thread>

80000e78 <test_fifo_is_empty_thread>:
/**
 * @brief Test empty fifo
 * @see k_fifo_init(), k_fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_thread(void)
{
80000e78:	ff010113          	addi	sp,sp,-16
80000e7c:	00812423          	sw	s0,8(sp)
80000e80:	80008437          	lui	s0,0x80008
80000e84:	a4840513          	addi	a0,s0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
80000e88:	00112623          	sw	ra,12(sp)
80000e8c:	00912223          	sw	s1,4(sp)
80000e90:	5b4020ef          	jal	ra,80003444 <z_impl_k_queue_init>
80000e94:	a4840493          	addi	s1,s0,-1464
80000e98:	0004a503          	lw	a0,0(s1)
	k_fifo_init(&fifo);
	/**TESTPOINT: k_fifo_is_empty after init*/
	zassert_true(k_fifo_is_empty(&fifo), NULL);
80000e9c:	800077b7          	lui	a5,0x80007
80000ea0:	80007737          	lui	a4,0x80007
80000ea4:	80007637          	lui	a2,0x80007
80000ea8:	800075b7          	lui	a1,0x80007
80000eac:	00153513          	seqz	a0,a0
80000eb0:	e3878793          	addi	a5,a5,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000eb4:	ae870713          	addi	a4,a4,-1304 # 80006ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ae9>
80000eb8:	0b700693          	li	a3,183
80000ebc:	c3c60613          	addi	a2,a2,-964 # 80006c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c3d>
80000ec0:	b6058593          	addi	a1,a1,-1184 # 80006b60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b61>
80000ec4:	a09ff0ef          	jal	ra,800008cc <z_zassert.constprop.5>

	/**TESTPONT: check fifo is empty from thread*/
	tfifo_is_empty(&fifo);
80000ec8:	a4840513          	addi	a0,s0,-1464
}
80000ecc:	00812403          	lw	s0,8(sp)
80000ed0:	00c12083          	lw	ra,12(sp)
80000ed4:	00412483          	lw	s1,4(sp)
80000ed8:	01010113          	addi	sp,sp,16
	tfifo_is_empty(&fifo);
80000edc:	d71ff06f          	j	80000c4c <tfifo_is_empty>

80000ee0 <test_fifo_is_empty_isr>:
/**
 * @brief Test empty fifo in interrupt context
 * @see k_fifo_init(), fifo_is_empty(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_is_empty_isr(void)
{
80000ee0:	ff010113          	addi	sp,sp,-16
80000ee4:	00812423          	sw	s0,8(sp)
80000ee8:	80008437          	lui	s0,0x80008
80000eec:	a4840513          	addi	a0,s0,-1464 # 80007a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007a49>
80000ef0:	00112623          	sw	ra,12(sp)
80000ef4:	550020ef          	jal	ra,80003444 <z_impl_k_queue_init>
	k_fifo_init(&fifo);
	/**TESTPOINT: check fifo is empty from isr*/
	irq_offload(tfifo_is_empty, &fifo);
80000ef8:	a4840593          	addi	a1,s0,-1464
}
80000efc:	00812403          	lw	s0,8(sp)
80000f00:	00c12083          	lw	ra,12(sp)
	irq_offload(tfifo_is_empty, &fifo);
80000f04:	80001537          	lui	a0,0x80001
80000f08:	c4c50513          	addi	a0,a0,-948 # 80000c4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000c4d>
}
80000f0c:	01010113          	addi	sp,sp,16
	irq_offload(tfifo_is_empty, &fifo);
80000f10:	69c0006f          	j	800015ac <irq_offload>

80000f14 <z_zassert.constprop.0>:
static inline void z_zassert(int cond,
80000f14:	fd010113          	addi	sp,sp,-48
80000f18:	00112e23          	sw	ra,28(sp)
80000f1c:	03012423          	sw	a6,40(sp)
80000f20:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80000f24:	04051863          	bnez	a0,80000f74 <z_zassert.constprop.0+0x60>
80000f28:	00068613          	mv	a2,a3
80000f2c:	00058713          	mv	a4,a1
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000f30:	800076b7          	lui	a3,0x80007
80000f34:	800075b7          	lui	a1,0x80007
80000f38:	80007537          	lui	a0,0x80007
		va_start(vargs, msg);
80000f3c:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000f40:	c7468693          	addi	a3,a3,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
80000f44:	cdc58593          	addi	a1,a1,-804 # 80006cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cdd>
80000f48:	a8450513          	addi	a0,a0,-1404 # 80006a84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a85>
		va_start(vargs, msg);
80000f4c:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000f50:	58c010ef          	jal	ra,800024dc <printk>
		vprintk(msg, vargs);
80000f54:	00c12583          	lw	a1,12(sp)
80000f58:	80007537          	lui	a0,0x80007
80000f5c:	e3850513          	addi	a0,a0,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000f60:	54c010ef          	jal	ra,800024ac <vprintk>
		printk("\n");
80000f64:	80007537          	lui	a0,0x80007
80000f68:	f3850513          	addi	a0,a0,-200 # 80006f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f39>
80000f6c:	570010ef          	jal	ra,800024dc <printk>
		ztest_test_fail();
80000f70:	4d5010ef          	jal	ra,80002c44 <ztest_test_fail>
}
80000f74:	01c12083          	lw	ra,28(sp)
80000f78:	03010113          	addi	sp,sp,48
80000f7c:	00008067          	ret

80000f80 <test_fifo_get_fail>:
 * @details test zephyr fifo_get when no data to read,
 * it should returns NULL.
 * @see k_fifo_init(), k_fifo_get()
 */
void test_fifo_get_fail(void *p1, void *p2, void *p3)
{
80000f80:	fd010113          	addi	sp,sp,-48
80000f84:	00c10513          	addi	a0,sp,12
80000f88:	02112623          	sw	ra,44(sp)
80000f8c:	02812423          	sw	s0,40(sp)
80000f90:	02912223          	sw	s1,36(sp)
80000f94:	03212023          	sw	s2,32(sp)
80000f98:	4ac020ef          	jal	ra,80003444 <z_impl_k_queue_init>
K_SYSCALL_DECLARE2(K_SYSCALL_K_QUEUE_GET, k_queue_get, void *, struct k_queue *, queue, s32_t, timeout)
80000f9c:	00000593          	li	a1,0
80000fa0:	00c10513          	addi	a0,sp,12
80000fa4:	750020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
	struct k_fifo fifo;

	k_fifo_init(&fifo);
	/**TESTPOINT: fifo get returns NULL*/
	zassert_is_null(k_fifo_get(&fifo, K_NO_WAIT), NULL);
80000fa8:	800074b7          	lui	s1,0x80007
80000fac:	80007937          	lui	s2,0x80007
80000fb0:	80007437          	lui	s0,0x80007
80000fb4:	800075b7          	lui	a1,0x80007
80000fb8:	e3890793          	addi	a5,s2,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80000fbc:	c7448713          	addi	a4,s1,-908 # 80006c74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c75>
80000fc0:	cdc40613          	addi	a2,s0,-804 # 80006cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cdd>
80000fc4:	01c00693          	li	a3,28
80000fc8:	c8858593          	addi	a1,a1,-888 # 80006c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c89>
80000fcc:	00153513          	seqz	a0,a0
80000fd0:	f45ff0ef          	jal	ra,80000f14 <z_zassert.constprop.0>
80000fd4:	06400593          	li	a1,100
80000fd8:	00c10513          	addi	a0,sp,12
80000fdc:	718020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
	zassert_is_null(k_fifo_get(&fifo, TIMEOUT), NULL);
80000fe0:	800075b7          	lui	a1,0x80007
80000fe4:	e3890793          	addi	a5,s2,-456
80000fe8:	c7448713          	addi	a4,s1,-908
80000fec:	cdc40613          	addi	a2,s0,-804
80000ff0:	01d00693          	li	a3,29
80000ff4:	cb458593          	addi	a1,a1,-844 # 80006cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb5>
80000ff8:	00153513          	seqz	a0,a0
80000ffc:	f19ff0ef          	jal	ra,80000f14 <z_zassert.constprop.0>
}
80001000:	02c12083          	lw	ra,44(sp)
80001004:	02812403          	lw	s0,40(sp)
80001008:	02412483          	lw	s1,36(sp)
8000100c:	02012903          	lw	s2,32(sp)
80001010:	03010113          	addi	sp,sp,48
80001014:	00008067          	ret

80001018 <tfifo_put>:
static K_THREAD_STACK_DEFINE(tstack, STACK_SIZE);
static struct k_thread tdata;
static struct k_sem end_sema;

static void tfifo_put(struct k_fifo *pfifo)
{
80001018:	ff010113          	addi	sp,sp,-16
	/**TESTPOINT: fifo put*/
	for (int i = 0; i < LIST_LEN; i++) {
		k_fifo_put(pfifo, (void *)&data[i]);
8000101c:	800085b7          	lui	a1,0x80008
{
80001020:	00912223          	sw	s1,4(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80001024:	acc58493          	addi	s1,a1,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
80001028:	acc58593          	addi	a1,a1,-1332
{
8000102c:	00112623          	sw	ra,12(sp)
80001030:	00812423          	sw	s0,8(sp)
80001034:	00050413          	mv	s0,a0
		k_fifo_put(pfifo, (void *)&data[i]);
80001038:	4d8020ef          	jal	ra,80003510 <k_queue_append>
8000103c:	00848593          	addi	a1,s1,8
80001040:	00040513          	mv	a0,s0
80001044:	4cc020ef          	jal	ra,80003510 <k_queue_append>
80001048:	01048593          	addi	a1,s1,16
8000104c:	00040513          	mv	a0,s0
80001050:	4c0020ef          	jal	ra,80003510 <k_queue_append>
80001054:	00040513          	mv	a0,s0
	}
}
80001058:	00812403          	lw	s0,8(sp)
8000105c:	00c12083          	lw	ra,12(sp)
		k_fifo_put(pfifo, (void *)&data[i]);
80001060:	01848593          	addi	a1,s1,24
}
80001064:	00412483          	lw	s1,4(sp)
80001068:	01010113          	addi	sp,sp,16
		k_fifo_put(pfifo, (void *)&data[i]);
8000106c:	4a40206f          	j	80003510 <k_queue_append>

80001070 <z_zassert.constprop.1>:
static inline void z_zassert(int cond,
80001070:	fd010113          	addi	sp,sp,-48
80001074:	00112e23          	sw	ra,28(sp)
80001078:	03012423          	sw	a6,40(sp)
8000107c:	03112623          	sw	a7,44(sp)
	if (!(cond)) {
80001080:	04051a63          	bnez	a0,800010d4 <z_zassert.constprop.1+0x64>
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80001084:	80007737          	lui	a4,0x80007
80001088:	800076b7          	lui	a3,0x80007
8000108c:	800075b7          	lui	a1,0x80007
80001090:	80007537          	lui	a0,0x80007
		va_start(vargs, msg);
80001094:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80001098:	b8070713          	addi	a4,a4,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
8000109c:	d1068693          	addi	a3,a3,-752 # 80006d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d11>
800010a0:	02300613          	li	a2,35
800010a4:	db058593          	addi	a1,a1,-592 # 80006db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006db1>
800010a8:	a8450513          	addi	a0,a0,-1404 # 80006a84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a85>
		va_start(vargs, msg);
800010ac:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800010b0:	42c010ef          	jal	ra,800024dc <printk>
		vprintk(msg, vargs);
800010b4:	00c12583          	lw	a1,12(sp)
800010b8:	80007537          	lui	a0,0x80007
800010bc:	e3850513          	addi	a0,a0,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
800010c0:	3ec010ef          	jal	ra,800024ac <vprintk>
		printk("\n");
800010c4:	80007537          	lui	a0,0x80007
800010c8:	f3850513          	addi	a0,a0,-200 # 80006f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f39>
800010cc:	410010ef          	jal	ra,800024dc <printk>
		ztest_test_fail();
800010d0:	375010ef          	jal	ra,80002c44 <ztest_test_fail>
}
800010d4:	01c12083          	lw	ra,28(sp)
800010d8:	03010113          	addi	sp,sp,48
800010dc:	00008067          	ret

800010e0 <tfifo_get>:

static void tfifo_get(struct k_fifo *pfifo)
{
800010e0:	fe010113          	addi	sp,sp,-32
800010e4:	00812c23          	sw	s0,24(sp)
800010e8:	80008437          	lui	s0,0x80008
800010ec:	acc40413          	addi	s0,s0,-1332 # 80007acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007acd>
800010f0:	00912a23          	sw	s1,20(sp)
800010f4:	01212823          	sw	s2,16(sp)
800010f8:	01312623          	sw	s3,12(sp)
800010fc:	01412423          	sw	s4,8(sp)
80001100:	01512223          	sw	s5,4(sp)
80001104:	01612023          	sw	s6,0(sp)
80001108:	00112e23          	sw	ra,28(sp)
8000110c:	00050b13          	mv	s6,a0
80001110:	02040493          	addi	s1,s0,32

	/*get fifo data from "fifo_put"*/
	for (int i = 0; i < LIST_LEN; i++) {
		/**TESTPOINT: fifo get*/
		rx_data = k_fifo_get(pfifo, K_NO_WAIT);
		zassert_equal(rx_data, (void *)&data[i], NULL);
80001114:	80007a37          	lui	s4,0x80007
80001118:	80007ab7          	lui	s5,0x80007
8000111c:	800079b7          	lui	s3,0x80007
80001120:	80007937          	lui	s2,0x80007
80001124:	00000593          	li	a1,0
80001128:	000b0513          	mv	a0,s6
8000112c:	5c8020ef          	jal	ra,800036f4 <z_impl_k_queue_get>
80001130:	40850533          	sub	a0,a0,s0
80001134:	e38a8793          	addi	a5,s5,-456 # 80006e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e39>
80001138:	d10a0713          	addi	a4,s4,-752 # 80006d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d11>
8000113c:	02300693          	li	a3,35
80001140:	db098613          	addi	a2,s3,-592 # 80006db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006db1>
80001144:	b8090593          	addi	a1,s2,-1152 # 80006b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b81>
80001148:	00153513          	seqz	a0,a0
8000114c:	00840413          	addi	s0,s0,8
80001150:	f21ff0ef          	jal	ra,80001070 <z_zassert.constprop.1>
	for (int i = 0; i < LIST_LEN; i++) {
80001154:	fc9418e3          	bne	s0,s1,80001124 <tfifo_get+0x44>
	}
}
80001158:	01c12083          	lw	ra,28(sp)
8000115c:	01812403          	lw	s0,24(sp)
80001160:	01412483          	lw	s1,20(sp)
80001164:	01012903          	lw	s2,16(sp)
80001168:	00c12983          	lw	s3,12(sp)
8000116c:	00812a03          	lw	s4,8(sp)
80001170:	00412a83          	lw	s5,4(sp)
80001174:	00012b03          	lw	s6,0(sp)
80001178:	02010113          	addi	sp,sp,32
8000117c:	00008067          	ret

80001180 <tIsr_entry>:

/*entry of contexts*/
static void tIsr_entry(void *p)
{
80001180:	ff010113          	addi	sp,sp,-16
80001184:	00812423          	sw	s0,8(sp)
80001188:	00050413          	mv	s0,a0
	TC_PRINT("isr fifo get\n");
8000118c:	80007537          	lui	a0,0x80007
80001190:	d1c50513          	addi	a0,a0,-740 # 80006d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d1d>
{
80001194:	00112623          	sw	ra,12(sp)
	TC_PRINT("isr fifo get\n");
80001198:	344010ef          	jal	ra,800024dc <printk>
	tfifo_get((struct k_fifo *)p);
8000119c:	00040513          	mv	a0,s0
800011a0:	f41ff0ef          	jal	ra,800010e0 <tfifo_get>
	TC_PRINT("isr fifo put ---> ");
800011a4:	80007537          	lui	a0,0x80007
800011a8:	d2c50513          	addi	a0,a0,-724 # 80006d2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d2d>
800011ac:	330010ef          	jal	ra,800024dc <printk>
	tfifo_put((struct k_fifo *)p);
800011b0:	00040513          	mv	a0,s0
}
800011b4:	00812403          	lw	s0,8(sp)
800011b8:	00c12083          	lw	ra,12(sp)
800011bc:	01010113          	addi	sp,sp,16
	tfifo_put((struct k_fifo *)p);
800011c0:	e59ff06f          	j	80001018 <tfifo_put>

800011c4 <tThread_entry>:

static void tThread_entry(void *p1, void *p2, void *p3)
{
800011c4:	ff010113          	addi	sp,sp,-16
800011c8:	00912223          	sw	s1,4(sp)
800011cc:	00050493          	mv	s1,a0
	TC_PRINT("thread fifo get\n");
800011d0:	80007537          	lui	a0,0x80007
800011d4:	d4050513          	addi	a0,a0,-704 # 80006d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d41>
{
800011d8:	00112623          	sw	ra,12(sp)
800011dc:	00812423          	sw	s0,8(sp)
	TC_PRINT("thread fifo get\n");
800011e0:	2fc010ef          	jal	ra,800024dc <printk>
	tfifo_get((struct k_fifo *)p1);
800011e4:	00048513          	mv	a0,s1
800011e8:	ef9ff0ef          	jal	ra,800010e0 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800011ec:	80008437          	lui	s0,0x80008
800011f0:	aec40513          	addi	a0,s0,-1300 # 80007aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007aed>
800011f4:	6ed030ef          	jal	ra,800050e0 <z_impl_k_sem_give>
	k_sem_give(&end_sema);
	TC_PRINT("thread fifo put ---> ");
800011f8:	80007537          	lui	a0,0x80007
800011fc:	d5450513          	addi	a0,a0,-684 # 80006d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d55>
80001200:	2dc010ef          	jal	ra,800024dc <printk>
	tfifo_put((struct k_fifo *)p1);
80001204:	00048513          	mv	a0,s1
80001208:	e11ff0ef          	jal	ra,80001018 <tfifo_put>
8000120c:	aec40513          	addi	a0,s0,-1300
	k_sem_give(&end_sema);
}
80001210:	00812403          	lw	s0,8(sp)
80001214:	00c12083          	lw	ra,12(sp)
80001218:	00412483          	lw	s1,4(sp)
8000121c:	01010113          	addi	sp,sp,16
80001220:	6c10306f          	j	800050e0 <z_impl_k_sem_give>

80001224 <test_fifo_loop>:
 *   -# fifo data pass correctly and stably across contexts
 *
 * @see k_fifo_init(), k_fifo_put(), k_fifo_get()
 */
void test_fifo_loop(void)
{
80001224:	fc010113          	addi	sp,sp,-64
80001228:	02812c23          	sw	s0,56(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_QUEUE_INIT, k_queue_init, struct k_queue *, queue)
8000122c:	80008437          	lui	s0,0x80008
80001230:	afc40513          	addi	a0,s0,-1284 # 80007afc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007afd>
80001234:	02912a23          	sw	s1,52(sp)
80001238:	03212823          	sw	s2,48(sp)
8000123c:	03412423          	sw	s4,40(sp)
80001240:	03512223          	sw	s5,36(sp)
80001244:	03612023          	sw	s6,32(sp)
80001248:	01712e23          	sw	s7,28(sp)
8000124c:	01812c23          	sw	s8,24(sp)
80001250:	01912a23          	sw	s9,20(sp)
80001254:	01a12823          	sw	s10,16(sp)
80001258:	02112e23          	sw	ra,60(sp)
8000125c:	03312623          	sw	s3,44(sp)
	k_fifo_init(&fifo);
	for (int i = 0; i < LOOPS; i++) {
80001260:	00000493          	li	s1,0
80001264:	1e0020ef          	jal	ra,80003444 <z_impl_k_queue_init>
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
80001268:	80007d37          	lui	s10,0x80007
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
8000126c:	80008937          	lui	s2,0x80008
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001270:	80008c37          	lui	s8,0x80008
80001274:	80008bb7          	lui	s7,0x80008
80001278:	80001cb7          	lui	s9,0x80001
	TC_PRINT("main fifo put ---> ");
8000127c:	80007b37          	lui	s6,0x80007
	irq_offload(tIsr_entry, pfifo);
80001280:	80001ab7          	lui	s5,0x80001
	TC_PRINT("main fifo get\n");
80001284:	80007a37          	lui	s4,0x80007
		TC_PRINT("* Pass data by fifo in loop %d\n", i);
80001288:	00048593          	mv	a1,s1
8000128c:	d6cd0513          	addi	a0,s10,-660 # 80006d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d6d>
80001290:	24c010ef          	jal	ra,800024dc <printk>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001294:	00100613          	li	a2,1
80001298:	00000593          	li	a1,0
8000129c:	aec90513          	addi	a0,s2,-1300 # 80007aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007aed>
800012a0:	579030ef          	jal	ra,80005018 <z_impl_k_sem_init>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800012a4:	00000793          	li	a5,0
800012a8:	00000893          	li	a7,0
800012ac:	00000813          	li	a6,0
800012b0:	afc40713          	addi	a4,s0,-1284
800012b4:	1c4c8693          	addi	a3,s9,452 # 800011c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800011c5>
800012b8:	20000613          	li	a2,512
800012bc:	110c0593          	addi	a1,s8,272 # 80008110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008111>
800012c0:	00012223          	sw	zero,4(sp)
800012c4:	00012023          	sw	zero,0(sp)
800012c8:	b10b8513          	addi	a0,s7,-1264 # 80007b10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b11>
800012cc:	394040ef          	jal	ra,80005660 <z_impl_k_thread_create>
800012d0:	00050993          	mv	s3,a0
	TC_PRINT("main fifo put ---> ");
800012d4:	d8cb0513          	addi	a0,s6,-628 # 80006d8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d8d>
800012d8:	204010ef          	jal	ra,800024dc <printk>
	tfifo_put(pfifo);
800012dc:	afc40513          	addi	a0,s0,-1284
800012e0:	d39ff0ef          	jal	ra,80001018 <tfifo_put>
	irq_offload(tIsr_entry, pfifo);
800012e4:	afc40593          	addi	a1,s0,-1284
800012e8:	180a8513          	addi	a0,s5,384 # 80001180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001181>
800012ec:	2c0000ef          	jal	ra,800015ac <irq_offload>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800012f0:	fff00593          	li	a1,-1
800012f4:	aec90513          	addi	a0,s2,-1300
800012f8:	6cd030ef          	jal	ra,800051c4 <z_impl_k_sem_take>
800012fc:	fff00593          	li	a1,-1
80001300:	aec90513          	addi	a0,s2,-1300
80001304:	6c1030ef          	jal	ra,800051c4 <z_impl_k_sem_take>
	TC_PRINT("main fifo get\n");
80001308:	da0a0513          	addi	a0,s4,-608 # 80006da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da1>
8000130c:	1d0010ef          	jal	ra,800024dc <printk>
	tfifo_get(pfifo);
80001310:	afc40513          	addi	a0,s0,-1284
80001314:	dcdff0ef          	jal	ra,800010e0 <tfifo_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001318:	00098513          	mv	a0,s3
8000131c:	4e8040ef          	jal	ra,80005804 <z_impl_k_thread_abort>
	TC_PRINT("\n");
80001320:	80007537          	lui	a0,0x80007
80001324:	f3850513          	addi	a0,a0,-200 # 80006f38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f39>
80001328:	1b4010ef          	jal	ra,800024dc <printk>
	for (int i = 0; i < LOOPS; i++) {
8000132c:	00148493          	addi	s1,s1,1
80001330:	02000793          	li	a5,32
80001334:	f4f49ae3          	bne	s1,a5,80001288 <test_fifo_loop+0x64>
		tfifo_read_write(&fifo);
	}
}
80001338:	03c12083          	lw	ra,60(sp)
8000133c:	03812403          	lw	s0,56(sp)
80001340:	03412483          	lw	s1,52(sp)
80001344:	03012903          	lw	s2,48(sp)
80001348:	02c12983          	lw	s3,44(sp)
8000134c:	02812a03          	lw	s4,40(sp)
80001350:	02412a83          	lw	s5,36(sp)
80001354:	02012b03          	lw	s6,32(sp)
80001358:	01c12b83          	lw	s7,28(sp)
8000135c:	01812c03          	lw	s8,24(sp)
80001360:	01412c83          	lw	s9,20(sp)
80001364:	01012d03          	lw	s10,16(sp)
80001368:	04010113          	addi	sp,sp,64
8000136c:	00008067          	ret

80001370 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80001370:	ff010113          	addi	sp,sp,-16
80001374:	00112623          	sw	ra,12(sp)
80001378:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
8000137c:	00600793          	li	a5,6
80001380:	02f50463          	beq	a0,a5,800013a8 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80001384:	028040ef          	jal	ra,800053ac <k_is_in_isr>
80001388:	02050463          	beqz	a0,800013b0 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
8000138c:	020040ef          	jal	ra,800053ac <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001390:	04051663          	bnez	a0,800013dc <z_SysFatalErrorHandler+0x6c>
80001394:	800075b7          	lui	a1,0x80007
80001398:	09458593          	addi	a1,a1,148 # 80007094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007095>
8000139c:	80007537          	lui	a0,0x80007
800013a0:	0a850513          	addi	a0,a0,168 # 800070a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070a9>
800013a4:	138010ef          	jal	ra,800024dc <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
800013a8:	1a4010ef          	jal	ra,8000254c <k_cpu_idle>
800013ac:	ffdff06f          	j	800013a8 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
800013b0:	00c040ef          	jal	ra,800053bc <z_is_thread_essential>
800013b4:	fc051ce3          	bnez	a0,8000138c <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
800013b8:	80008437          	lui	s0,0x80008
800013bc:	ce040413          	addi	s0,s0,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
800013c0:	00842583          	lw	a1,8(s0)
800013c4:	80007537          	lui	a0,0x80007
800013c8:	0c850513          	addi	a0,a0,200 # 800070c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070c9>
800013cc:	110010ef          	jal	ra,800024dc <printk>
800013d0:	00842503          	lw	a0,8(s0)
800013d4:	430040ef          	jal	ra,80005804 <z_impl_k_thread_abort>
800013d8:	fd1ff06f          	j	800013a8 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
800013dc:	800075b7          	lui	a1,0x80007
800013e0:	09058593          	addi	a1,a1,144 # 80007090 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007091>
800013e4:	fb9ff06f          	j	8000139c <z_SysFatalErrorHandler+0x2c>

800013e8 <z_NanoFatalErrorHandler>:
{
800013e8:	fb010113          	addi	sp,sp,-80
800013ec:	04812423          	sw	s0,72(sp)
800013f0:	04912223          	sw	s1,68(sp)
800013f4:	04112623          	sw	ra,76(sp)
	switch (reason) {
800013f8:	00600793          	li	a5,6
{
800013fc:	00050493          	mv	s1,a0
80001400:	00058413          	mv	s0,a1
	switch (reason) {
80001404:	0ea7e063          	bltu	a5,a0,800014e4 <z_NanoFatalErrorHandler+0xfc>
80001408:	80007737          	lui	a4,0x80007
8000140c:	00251793          	slli	a5,a0,0x2
80001410:	de470713          	addi	a4,a4,-540 # 80006de4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006de5>
80001414:	00e787b3          	add	a5,a5,a4
80001418:	0007a783          	lw	a5,0(a5)
8000141c:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001420:	80007537          	lui	a0,0x80007
80001424:	f1450513          	addi	a0,a0,-236 # 80006f14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f15>
		printk("***** Kernel OOPS! *****\n");
80001428:	0b4010ef          	jal	ra,800024dc <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
8000142c:	3e1030ef          	jal	ra,8000500c <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001430:	04442783          	lw	a5,68(s0)
80001434:	01042883          	lw	a7,16(s0)
80001438:	00c42803          	lw	a6,12(s0)
8000143c:	02f12823          	sw	a5,48(sp)
80001440:	04042783          	lw	a5,64(s0)
80001444:	00442703          	lw	a4,4(s0)
80001448:	00042683          	lw	a3,0(s0)
8000144c:	02f12623          	sw	a5,44(sp)
80001450:	03c42783          	lw	a5,60(s0)
80001454:	04842603          	lw	a2,72(s0)
80001458:	00050593          	mv	a1,a0
8000145c:	02f12423          	sw	a5,40(sp)
80001460:	03842783          	lw	a5,56(s0)
80001464:	80007537          	lui	a0,0x80007
80001468:	f9850513          	addi	a0,a0,-104 # 80006f98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f99>
8000146c:	02f12223          	sw	a5,36(sp)
80001470:	03442783          	lw	a5,52(s0)
80001474:	02f12023          	sw	a5,32(sp)
80001478:	03042783          	lw	a5,48(s0)
8000147c:	00f12e23          	sw	a5,28(sp)
80001480:	02c42783          	lw	a5,44(s0)
80001484:	00f12c23          	sw	a5,24(sp)
80001488:	02842783          	lw	a5,40(s0)
8000148c:	00f12a23          	sw	a5,20(sp)
80001490:	02442783          	lw	a5,36(s0)
80001494:	00f12823          	sw	a5,16(sp)
80001498:	02042783          	lw	a5,32(s0)
8000149c:	00f12623          	sw	a5,12(sp)
800014a0:	01c42783          	lw	a5,28(s0)
800014a4:	00f12423          	sw	a5,8(sp)
800014a8:	01842783          	lw	a5,24(s0)
800014ac:	00f12223          	sw	a5,4(sp)
800014b0:	01442783          	lw	a5,20(s0)
800014b4:	00f12023          	sw	a5,0(sp)
800014b8:	00842783          	lw	a5,8(s0)
800014bc:	020010ef          	jal	ra,800024dc <printk>
	z_SysFatalErrorHandler(reason, esf);
800014c0:	00040593          	mv	a1,s0
800014c4:	00048513          	mv	a0,s1
800014c8:	ea9ff0ef          	jal	ra,80001370 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
800014cc:	80007537          	lui	a0,0x80007
800014d0:	f3c50513          	addi	a0,a0,-196 # 80006f3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f3d>
800014d4:	f55ff06f          	j	80001428 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
800014d8:	80007537          	lui	a0,0x80007
800014dc:	f5850513          	addi	a0,a0,-168 # 80006f58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f59>
800014e0:	f49ff06f          	j	80001428 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
800014e4:	80007537          	lui	a0,0x80007
800014e8:	00048593          	mv	a1,s1
800014ec:	f7450513          	addi	a0,a0,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800014f0:	7ed000ef          	jal	ra,800024dc <printk>
		break;
800014f4:	f39ff06f          	j	8000142c <z_NanoFatalErrorHandler+0x44>

800014f8 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
800014f8:	ff010113          	addi	sp,sp,-16
800014fc:	00812423          	sw	s0,8(sp)
80001500:	00112623          	sw	ra,12(sp)
80001504:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001508:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
8000150c:	00161613          	slli	a2,a2,0x1
80001510:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001514:	00500793          	li	a5,5
80001518:	02c7e863          	bltu	a5,a2,80001548 <_Fault+0x50>
8000151c:	80007737          	lui	a4,0x80007
80001520:	00261793          	slli	a5,a2,0x2
80001524:	e0070713          	addi	a4,a4,-512 # 80006e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e01>
80001528:	00f707b3          	add	a5,a4,a5
8000152c:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001530:	80007537          	lui	a0,0x80007
80001534:	e2050513          	addi	a0,a0,-480 # 80006e20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e21>
80001538:	7a5000ef          	jal	ra,800024dc <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
8000153c:	00040593          	mv	a1,s0
80001540:	00000513          	li	a0,0
80001544:	ea5ff0ef          	jal	ra,800013e8 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001548:	800075b7          	lui	a1,0x80007
8000154c:	e1858593          	addi	a1,a1,-488 # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
80001550:	fe1ff06f          	j	80001530 <_Fault+0x38>

80001554 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001554:	ff010113          	addi	sp,sp,-16
80001558:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
8000155c:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001560:	80007537          	lui	a0,0x80007
	mcause &= SOC_MCAUSE_EXP_MASK;
80001564:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001568:	0015d593          	srli	a1,a1,0x1
8000156c:	0f050513          	addi	a0,a0,240 # 800070f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070f1>
80001570:	76d000ef          	jal	ra,800024dc <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80001574:	800075b7          	lui	a1,0x80007
80001578:	e3c58593          	addi	a1,a1,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
8000157c:	00400513          	li	a0,4
80001580:	e69ff0ef          	jal	ra,800013e8 <z_NanoFatalErrorHandler>

80001584 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80001584:	800087b7          	lui	a5,0x80008
80001588:	94878793          	addi	a5,a5,-1720 # 80007948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007949>
8000158c:	0007a703          	lw	a4,0(a5)
80001590:	00070c63          	beqz	a4,800015a8 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80001594:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001598:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
8000159c:	800087b7          	lui	a5,0x80008
800015a0:	94c7a503          	lw	a0,-1716(a5) # 8000794c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000794d>
800015a4:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
800015a8:	00008067          	ret

800015ac <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
800015ac:	00800793          	li	a5,8
800015b0:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
800015b4:	80008737          	lui	a4,0x80008
800015b8:	94a72423          	sw	a0,-1720(a4) # 80007948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007949>
	offload_param = parameter;
800015bc:	80008737          	lui	a4,0x80008
800015c0:	94b72623          	sw	a1,-1716(a4) # 8000794c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000794d>

	__asm__ volatile ("ecall");
800015c4:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
800015c8:	0087f793          	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800015cc:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
800015d0:	00008067          	ret

800015d4 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
800015d4:	ff010113          	addi	sp,sp,-16
800015d8:	00112623          	sw	ra,12(sp)
	z_bss_zero();
800015dc:	24d010ef          	jal	ra,80003028 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
800015e0:	78d000ef          	jal	ra,8000256c <soc_interrupt_init>
#endif
	z_cstart();
800015e4:	2b1010ef          	jal	ra,80003094 <z_cstart>

800015e8 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
800015e8:	00007117          	auipc	sp,0x7
800015ec:	52810113          	addi	sp,sp,1320 # 80008b10 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
800015f0:	000012b7          	lui	t0,0x1
800015f4:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
800015f8:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
800015fc:	fd9ff0ef          	jal	ra,800015d4 <_PrepC>

80001600 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001600:	0890006f          	j	80001e88 <z_thread_entry>

80001604 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001604:	fd010113          	addi	sp,sp,-48
80001608:	02812423          	sw	s0,40(sp)
8000160c:	02912223          	sw	s1,36(sp)
80001610:	03212023          	sw	s2,32(sp)
80001614:	01312e23          	sw	s3,28(sp)
80001618:	01412c23          	sw	s4,24(sp)
8000161c:	01512a23          	sw	s5,20(sp)
80001620:	01612823          	sw	s6,16(sp)
80001624:	01712623          	sw	s7,12(sp)
80001628:	00078b13          	mv	s6,a5
8000162c:	02112623          	sw	ra,44(sp)
80001630:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001634:	00f00793          	li	a5,15
{
80001638:	00050493          	mv	s1,a0
8000163c:	00058413          	mv	s0,a1
80001640:	00060993          	mv	s3,a2
80001644:	00068a13          	mv	s4,a3
80001648:	00070b93          	mv	s7,a4
8000164c:	00080a93          	mv	s5,a6
80001650:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001654:	08f89a63          	bne	a7,a5,800016e8 <z_new_thread+0xe4>
80001658:	800037b7          	lui	a5,0x80003
8000165c:	ff078793          	addi	a5,a5,-16 # 80002ff0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002ff1>
80001660:	08f69a63          	bne	a3,a5,800016f4 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001664:	03012683          	lw	a3,48(sp)
80001668:	00090593          	mv	a1,s2
8000166c:	00048513          	mv	a0,s1
80001670:	00400613          	li	a2,4
80001674:	60d030ef          	jal	ra,80005480 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001678:	fb098593          	addi	a1,s3,-80
8000167c:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001680:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001684:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001688:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
8000168c:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001690:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001694:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001698:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
8000169c:	02c12083          	lw	ra,44(sp)
800016a0:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800016a4:	60078793          	addi	a5,a5,1536 # 80001600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001601>
	stack_init->a0 = (u32_t)thread_func;
800016a8:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
800016ac:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
800016b0:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
800016b4:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
800016b8:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
800016bc:	02b4a423          	sw	a1,40(s1)
}
800016c0:	02012903          	lw	s2,32(sp)
800016c4:	02412483          	lw	s1,36(sp)
800016c8:	01c12983          	lw	s3,28(sp)
800016cc:	01812a03          	lw	s4,24(sp)
800016d0:	01412a83          	lw	s5,20(sp)
800016d4:	01012b03          	lw	s6,16(sp)
800016d8:	00c12b83          	lw	s7,12(sp)
800016dc:	00812c03          	lw	s8,8(sp)
800016e0:	03010113          	addi	sp,sp,48
800016e4:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
800016e8:	01088693          	addi	a3,a7,16
800016ec:	01e00793          	li	a5,30
800016f0:	f6d7fae3          	bgeu	a5,a3,80001664 <z_new_thread+0x60>
800016f4:	80007c37          	lui	s8,0x80007
800016f8:	800075b7          	lui	a1,0x80007
800016fc:	80007537          	lui	a0,0x80007
80001700:	118c0613          	addi	a2,s8,280 # 80007118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007119>
80001704:	01800693          	li	a3,24
80001708:	13858593          	addi	a1,a1,312 # 80007138 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007139>
8000170c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80001710:	5cd000ef          	jal	ra,800024dc <printk>
80001714:	80007537          	lui	a0,0x80007
80001718:	00090593          	mv	a1,s2
8000171c:	ff000693          	li	a3,-16
80001720:	00e00613          	li	a2,14
80001724:	1e450513          	addi	a0,a0,484 # 800071e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071e5>
80001728:	5b5000ef          	jal	ra,800024dc <printk>
8000172c:	01800593          	li	a1,24
80001730:	118c0513          	addi	a0,s8,280
80001734:	5e5000ef          	jal	ra,80002518 <assert_post_action>
80001738:	f2dff06f          	j	80001664 <z_new_thread+0x60>

8000173c <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
8000173c:	00c00793          	li	a5,12
80001740:	02f58733          	mul	a4,a1,a5
80001744:	00c52783          	lw	a5,12(a0)
80001748:	00e787b3          	add	a5,a5,a4
8000174c:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001750:	00b75463          	bge	a4,a1,80001758 <get_bit_ptr+0x1c>
80001754:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001758:	02000713          	li	a4,32
8000175c:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80001760:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80001764:	00271713          	slli	a4,a4,0x2
80001768:	00e787b3          	add	a5,a5,a4
8000176c:	00f6a023          	sw	a5,0(a3)
}
80001770:	00008067          	ret

80001774 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001774:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001778:	00c10693          	addi	a3,sp,12
{
8000177c:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001780:	fbdff0ef          	jal	ra,8000173c <get_bit_ptr>

	*word |= (1<<bit);
80001784:	00c12703          	lw	a4,12(sp)
80001788:	00100793          	li	a5,1
8000178c:	00a79533          	sll	a0,a5,a0
80001790:	00072783          	lw	a5,0(a4)
}
80001794:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001798:	00a7e7b3          	or	a5,a5,a0
8000179c:	00f72023          	sw	a5,0(a4)
}
800017a0:	02010113          	addi	sp,sp,32
800017a4:	00008067          	ret

800017a8 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
800017a8:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
800017ac:	00c10693          	addi	a3,sp,12
{
800017b0:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
800017b4:	f89ff0ef          	jal	ra,8000173c <get_bit_ptr>

	*word &= ~(1<<bit);
800017b8:	00c12703          	lw	a4,12(sp)
800017bc:	00100793          	li	a5,1
800017c0:	00a79533          	sll	a0,a5,a0
800017c4:	00072783          	lw	a5,0(a4)
}
800017c8:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
800017cc:	fff54513          	not	a0,a0
800017d0:	00a7f533          	and	a0,a5,a0
800017d4:	00a72023          	sw	a0,0(a4)
}
800017d8:	02010113          	addi	sp,sp,32
800017dc:	00008067          	ret

800017e0 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800017e0:	00452783          	lw	a5,4(a0)
800017e4:	00855803          	lhu	a6,8(a0)
{
800017e8:	ff010113          	addi	sp,sp,-16
800017ec:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
800017f0:	02f80833          	mul	a6,a6,a5
{
800017f4:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
800017f8:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
800017fc:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80001800:	fff00713          	li	a4,-1
{
80001804:	00112623          	sw	ra,12(sp)
80001808:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
8000180c:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001810:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80001814:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001818:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
8000181c:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80001820:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80001824:	0315c263          	blt	a1,a7,80001848 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001828:	00000493          	li	s1,0
8000182c:	00845783          	lhu	a5,8(s0)
80001830:	06f4c463          	blt	s1,a5,80001898 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001834:	00c12083          	lw	ra,12(sp)
80001838:	00812403          	lw	s0,8(sp)
8000183c:	00412483          	lw	s1,4(sp)
80001840:	01010113          	addi	sp,sp,16
80001844:	00008067          	ret
		int nblocks = buflen / sz;
80001848:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
8000184c:	00c42603          	lw	a2,12(s0)
80001850:	026586b3          	mul	a3,a1,t1
80001854:	00d606b3          	add	a3,a2,a3
80001858:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
8000185c:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80001860:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80001864:	00ee4e63          	blt	t3,a4,80001880 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80001868:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
8000186c:	0027d793          	srli	a5,a5,0x2
80001870:	00378793          	addi	a5,a5,3
80001874:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80001878:	00158593          	addi	a1,a1,1
8000187c:	fa9ff06f          	j	80001824 <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80001880:	01f70713          	addi	a4,a4,31
80001884:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80001888:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
8000188c:	00271713          	slli	a4,a4,0x2
80001890:	00e50533          	add	a0,a0,a4
80001894:	fd9ff06f          	j	8000186c <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80001898:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
8000189c:	00048613          	mv	a2,s1
800018a0:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
800018a4:	02f48733          	mul	a4,s1,a5
800018a8:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
800018ac:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
800018b0:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
800018b4:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
800018b8:	00c42703          	lw	a4,12(s0)
800018bc:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
800018c0:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
800018c4:	00872683          	lw	a3,8(a4)
800018c8:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
800018cc:	00872683          	lw	a3,8(a4)
800018d0:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
800018d4:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
800018d8:	e9dff0ef          	jal	ra,80001774 <set_free_bit>
800018dc:	f51ff06f          	j	8000182c <z_sys_mem_pool_base_init+0x4c>

800018e0 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
800018e0:	fb010113          	addi	sp,sp,-80
800018e4:	04812423          	sw	s0,72(sp)
800018e8:	03712623          	sw	s7,44(sp)
800018ec:	04112623          	sw	ra,76(sp)
800018f0:	04912223          	sw	s1,68(sp)
800018f4:	05212023          	sw	s2,64(sp)
800018f8:	03312e23          	sw	s3,60(sp)
800018fc:	03412c23          	sw	s4,56(sp)
80001900:	03512a23          	sw	s5,52(sp)
80001904:	03612823          	sw	s6,48(sp)
80001908:	03812423          	sw	s8,40(sp)
8000190c:	03912223          	sw	s9,36(sp)
80001910:	03a12023          	sw	s10,32(sp)
80001914:	01b12e23          	sw	s11,28(sp)
80001918:	05010413          	addi	s0,sp,80
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000191c:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001920:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001924:	002e1793          	slli	a5,t3,0x2
80001928:	00f78793          	addi	a5,a5,15
8000192c:	7f07f793          	andi	a5,a5,2032
80001930:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80001934:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001938:	00010b93          	mv	s7,sp
	lsizes[0] = _ALIGN4(p->max_sz);
8000193c:	000b8313          	mv	t1,s7
80001940:	00378793          	addi	a5,a5,3
80001944:	ffc7f793          	andi	a5,a5,-4
80001948:	00fba023          	sw	a5,0(s7)
	for (i = 0; i < p->n_levels; i++) {
8000194c:	fff88c13          	addi	s8,a7,-1
80001950:	03c8d463          	bge	a7,t3,80001978 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80001954:	00088c63          	beqz	a7,8000196c <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001958:	ffc32783          	lw	a5,-4(t1)
8000195c:	0027d793          	srli	a5,a5,0x2
80001960:	00378793          	addi	a5,a5,3
80001964:	ffc7f793          	andi	a5,a5,-4
80001968:	00f32023          	sw	a5,0(t1)
		}

		if (lsizes[i] < size) {
8000196c:	00430313          	addi	t1,t1,4
80001970:	ffc32783          	lw	a5,-4(t1)
80001974:	04b7fa63          	bgeu	a5,a1,800019c8 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80001978:	fff00793          	li	a5,-1
8000197c:	04fc1a63          	bne	s8,a5,800019d0 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80001980:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80001984:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80001988:	fb040113          	addi	sp,s0,-80
8000198c:	04c12083          	lw	ra,76(sp)
80001990:	04812403          	lw	s0,72(sp)
80001994:	04412483          	lw	s1,68(sp)
80001998:	04012903          	lw	s2,64(sp)
8000199c:	03c12983          	lw	s3,60(sp)
800019a0:	03812a03          	lw	s4,56(sp)
800019a4:	03412a83          	lw	s5,52(sp)
800019a8:	03012b03          	lw	s6,48(sp)
800019ac:	02c12b83          	lw	s7,44(sp)
800019b0:	02812c03          	lw	s8,40(sp)
800019b4:	02412c83          	lw	s9,36(sp)
800019b8:	02012d03          	lw	s10,32(sp)
800019bc:	01c12d83          	lw	s11,28(sp)
800019c0:	05010113          	addi	sp,sp,80
800019c4:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
800019c8:	00188893          	addi	a7,a7,1
800019cc:	f81ff06f          	j	8000194c <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800019d0:	01054783          	lbu	a5,16(a0)
		return 0;
800019d4:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800019d8:	0017f793          	andi	a5,a5,1
800019dc:	00078863          	beqz	a5,800019ec <z_sys_mem_pool_block_alloc+0x10c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800019e0:	00800913          	li	s2,8
800019e4:	30093973          	csrrc	s2,mstatus,s2
	key = (mstatus & SOC_MSTATUS_IEN);
800019e8:	00897913          	andi	s2,s2,8
800019ec:	00c00793          	li	a5,12
800019f0:	02fc07b3          	mul	a5,s8,a5
800019f4:	fae42e23          	sw	a4,-68(s0)
800019f8:	00068d13          	mv	s10,a3
800019fc:	00060c93          	mv	s9,a2
80001a00:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80001a04:	000c0a13          	mv	s4,s8
80001a08:	00478713          	addi	a4,a5,4
80001a0c:	00c52783          	lw	a5,12(a0)
80001a10:	00e787b3          	add	a5,a5,a4
	for (i = alloc_l; i >= 0; i--) {
80001a14:	fff00713          	li	a4,-1
	return list->head == list;
80001a18:	0007a983          	lw	s3,0(a5)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001a1c:	17378c63          	beq	a5,s3,80001b94 <z_sys_mem_pool_block_alloc+0x2b4>
	node->prev->next = node->next;
80001a20:	0009a783          	lw	a5,0(s3)
80001a24:	0049a703          	lw	a4,4(s3)
		data = block_alloc(p, i, lsizes[i]);
80001a28:	002a1a93          	slli	s5,s4,0x2
80001a2c:	015b8ab3          	add	s5,s7,s5
80001a30:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80001a34:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80001a38:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001a3c:	0009a223          	sw	zero,4(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a40:	0004a783          	lw	a5,0(s1)
		data = block_alloc(p, i, lsizes[i]);
80001a44:	000aa603          	lw	a2,0(s5)
		clear_free_bit(p, l, block_num(p, block, lsz));
80001a48:	000a0593          	mv	a1,s4
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a4c:	40f987b3          	sub	a5,s3,a5
		clear_free_bit(p, l, block_num(p, block, lsz));
80001a50:	02c7c633          	div	a2,a5,a2
80001a54:	00048513          	mv	a0,s1
80001a58:	001a0a13          	addi	s4,s4,1
80001a5c:	d4dff0ef          	jal	ra,800017a8 <clear_free_bit>
		if (data != NULL) {
80001a60:	00c00693          	li	a3,12
			for (from_l = i; from_l < alloc_l; from_l++) {
80001a64:	fffa0793          	addi	a5,s4,-1
80001a68:	0587c663          	blt	a5,s8,80001ab4 <z_sys_mem_pool_block_alloc+0x1d4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001a6c:	0104c783          	lbu	a5,16(s1)
80001a70:	0017f793          	andi	a5,a5,1
80001a74:	00078463          	beqz	a5,80001a7c <z_sys_mem_pool_block_alloc+0x19c>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001a78:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80001a7c:	fbc42783          	lw	a5,-68(s0)
		return -ENOMEM;
80001a80:	ff400513          	li	a0,-12
	*data_p = data;
80001a84:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80001a88:	f00980e3          	beqz	s3,80001988 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a8c:	0004a783          	lw	a5,0(s1)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001a90:	002c1813          	slli	a6,s8,0x2
80001a94:	010b8bb3          	add	s7,s7,a6
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001a98:	40f989b3          	sub	s3,s3,a5
80001a9c:	000ba783          	lw	a5,0(s7)
	*level_p = alloc_l;
80001aa0:	018ca023          	sw	s8,0(s9)
	return 0;
80001aa4:	00000513          	li	a0,0
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001aa8:	02f9c9b3          	div	s3,s3,a5
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001aac:	013d2023          	sw	s3,0(s10)
	return 0;
80001ab0:	ed9ff06f          	j	80001988 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001ab4:	0004ad83          	lw	s11,0(s1)
80001ab8:	000aa783          	lw	a5,0(s5)
80001abc:	02da0eb3          	mul	t4,s4,a3
80001ac0:	41b98db3          	sub	s11,s3,s11
	for (i = 1; i < 4; i++) {
80001ac4:	00100713          	li	a4,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001ac8:	02fdcdb3          	div	s11,s11,a5
		int lbn = 4*bn + i;
80001acc:	002d9d93          	slli	s11,s11,0x2
		int lsz = lsizes[l + 1];
80001ad0:	004aab03          	lw	s6,4(s5)
		set_free_bit(p, l + 1, lbn);
80001ad4:	01b70633          	add	a2,a4,s11
80001ad8:	000a0593          	mv	a1,s4
		void *block2 = (lsz * i) + (char *)block;
80001adc:	02eb0e33          	mul	t3,s6,a4
		set_free_bit(p, l + 1, lbn);
80001ae0:	00048513          	mv	a0,s1
80001ae4:	fbd42823          	sw	t4,-80(s0)
80001ae8:	fae42c23          	sw	a4,-72(s0)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001aec:	fffb0b13          	addi	s6,s6,-1
		void *block2 = (lsz * i) + (char *)block;
80001af0:	01c98e33          	add	t3,s3,t3
80001af4:	fbc42a23          	sw	t3,-76(s0)
		set_free_bit(p, l + 1, lbn);
80001af8:	c7dff0ef          	jal	ra,80001774 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001afc:	fb442e03          	lw	t3,-76(s0)
80001b00:	0004a783          	lw	a5,0(s1)
	return p->n_max * p->max_sz;
80001b04:	0044a603          	lw	a2,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001b08:	016e0b33          	add	s6,t3,s6
80001b0c:	40fb0b33          	sub	s6,s6,a5
	return p->n_max * p->max_sz;
80001b10:	0084d783          	lhu	a5,8(s1)
		if (block_fits(p, block2, lsz)) {
80001b14:	fb842703          	lw	a4,-72(s0)
80001b18:	fb042e83          	lw	t4,-80(s0)
	return p->n_max * p->max_sz;
80001b1c:	02c787b3          	mul	a5,a5,a2
		if (block_fits(p, block2, lsz)) {
80001b20:	00c00693          	li	a3,12
80001b24:	00400893          	li	a7,4
80001b28:	00800313          	li	t1,8
80001b2c:	02fb7463          	bgeu	s6,a5,80001b54 <z_sys_mem_pool_block_alloc+0x274>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001b30:	00c4a783          	lw	a5,12(s1)
80001b34:	01d787b3          	add	a5,a5,t4
80001b38:	00478613          	addi	a2,a5,4
	node->next = list;
80001b3c:	00ce2023          	sw	a2,0(t3)
	node->prev = list->tail;
80001b40:	0087a603          	lw	a2,8(a5)
80001b44:	00ce2223          	sw	a2,4(t3)
	list->tail->next = node;
80001b48:	0087a603          	lw	a2,8(a5)
80001b4c:	01c62023          	sw	t3,0(a2)
	list->tail = node;
80001b50:	01c7a423          	sw	t3,8(a5)
	for (i = 1; i < 4; i++) {
80001b54:	00170713          	addi	a4,a4,1
80001b58:	f7171ce3          	bne	a4,a7,80001ad0 <z_sys_mem_pool_block_alloc+0x1f0>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b5c:	0104c783          	lbu	a5,16(s1)
80001b60:	0017f793          	andi	a5,a5,1
80001b64:	00079a63          	bnez	a5,80001b78 <z_sys_mem_pool_block_alloc+0x298>
		return 0;
80001b68:	00000913          	li	s2,0
80001b6c:	001a0a13          	addi	s4,s4,1
80001b70:	004a8a93          	addi	s5,s5,4
80001b74:	ef1ff06f          	j	80001a64 <z_sys_mem_pool_block_alloc+0x184>
80001b78:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001b7c:	0104c783          	lbu	a5,16(s1)
80001b80:	0017f793          	andi	a5,a5,1
80001b84:	fe0782e3          	beqz	a5,80001b68 <z_sys_mem_pool_block_alloc+0x288>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001b88:	30033973          	csrrc	s2,mstatus,t1
	key = (mstatus & SOC_MSTATUS_IEN);
80001b8c:	00897913          	andi	s2,s2,8
80001b90:	fddff06f          	j	80001b6c <z_sys_mem_pool_block_alloc+0x28c>
	for (i = alloc_l; i >= 0; i--) {
80001b94:	fffa0a13          	addi	s4,s4,-1
80001b98:	ff498793          	addi	a5,s3,-12
80001b9c:	e6ea1ee3          	bne	s4,a4,80001a18 <z_sys_mem_pool_block_alloc+0x138>
80001ba0:	00000993          	li	s3,0
80001ba4:	ec9ff06f          	j	80001a6c <z_sys_mem_pool_block_alloc+0x18c>

80001ba8 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001ba8:	fa010113          	addi	sp,sp,-96
80001bac:	04812c23          	sw	s0,88(sp)
80001bb0:	05312623          	sw	s3,76(sp)
80001bb4:	03712e23          	sw	s7,60(sp)
80001bb8:	04112e23          	sw	ra,92(sp)
80001bbc:	04912a23          	sw	s1,84(sp)
80001bc0:	05212823          	sw	s2,80(sp)
80001bc4:	05412423          	sw	s4,72(sp)
80001bc8:	05512223          	sw	s5,68(sp)
80001bcc:	05612023          	sw	s6,64(sp)
80001bd0:	03812c23          	sw	s8,56(sp)
80001bd4:	03912a23          	sw	s9,52(sp)
80001bd8:	03a12823          	sw	s10,48(sp)
80001bdc:	03b12623          	sw	s11,44(sp)
80001be0:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001be4:	00a54683          	lbu	a3,10(a0)
{
80001be8:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80001bec:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001bf0:	00269693          	slli	a3,a3,0x2
80001bf4:	00f68693          	addi	a3,a3,15
80001bf8:	7f06f693          	andi	a3,a3,2032
80001bfc:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80001c00:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001c04:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001c08:	00098513          	mv	a0,s3
80001c0c:	00368693          	addi	a3,a3,3
80001c10:	ffc6f693          	andi	a3,a3,-4
80001c14:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
80001c18:	00450513          	addi	a0,a0,4
80001c1c:	0d05f463          	bgeu	a1,a6,80001ce4 <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c20:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001c24:	00058c13          	mv	s8,a1
80001c28:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c2c:	0016f693          	andi	a3,a3,1
		return 0;
80001c30:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c34:	00068863          	beqz	a3,80001c44 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c38:	00800493          	li	s1,8
80001c3c:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
80001c40:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80001c44:	80007ab7          	lui	s5,0x80007
		sys_dlist_append(&p->levels[level].free_list, block);
80001c48:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001c4c:	00800d93          	li	s11,8
	while (level >= 0) {
80001c50:	0a0c5863          	bgez	s8,80001d00 <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
80001c54:	800074b7          	lui	s1,0x80007
80001c58:	800075b7          	lui	a1,0x80007
80001c5c:	80007537          	lui	a0,0x80007
80001c60:	21848613          	addi	a2,s1,536 # 80007218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007219>
80001c64:	0c000693          	li	a3,192
80001c68:	28058593          	addi	a1,a1,640 # 80007280 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007281>
80001c6c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80001c70:	06d000ef          	jal	ra,800024dc <printk>
80001c74:	80007537          	lui	a0,0x80007
80001c78:	24c50513          	addi	a0,a0,588 # 8000724c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000724d>
80001c7c:	061000ef          	jal	ra,800024dc <printk>
80001c80:	21848513          	addi	a0,s1,536
80001c84:	0c000593          	li	a1,192
80001c88:	091000ef          	jal	ra,80002518 <assert_post_action>
	return -1;
80001c8c:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001c90:	010bc783          	lbu	a5,16(s7)
80001c94:	0017f793          	andi	a5,a5,1
80001c98:	00078663          	beqz	a5,80001ca4 <z_sys_mem_pool_block_free+0xfc>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001c9c:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ca0:	3004a4f3          	csrrs	s1,mstatus,s1
}
80001ca4:	fa040113          	addi	sp,s0,-96
80001ca8:	05c12083          	lw	ra,92(sp)
80001cac:	05812403          	lw	s0,88(sp)
80001cb0:	05412483          	lw	s1,84(sp)
80001cb4:	05012903          	lw	s2,80(sp)
80001cb8:	04c12983          	lw	s3,76(sp)
80001cbc:	04812a03          	lw	s4,72(sp)
80001cc0:	04412a83          	lw	s5,68(sp)
80001cc4:	04012b03          	lw	s6,64(sp)
80001cc8:	03c12b83          	lw	s7,60(sp)
80001ccc:	03812c03          	lw	s8,56(sp)
80001cd0:	03412c83          	lw	s9,52(sp)
80001cd4:	03012d03          	lw	s10,48(sp)
80001cd8:	02c12d83          	lw	s11,44(sp)
80001cdc:	06010113          	addi	sp,sp,96
80001ce0:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001ce4:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
80001ce8:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001cec:	0026d693          	srli	a3,a3,0x2
80001cf0:	00368693          	addi	a3,a3,3
80001cf4:	ffc6f693          	andi	a3,a3,-4
80001cf8:	00d52023          	sw	a3,0(a0)
80001cfc:	f1dff06f          	j	80001c18 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001d00:	002c1693          	slli	a3,s8,0x2
80001d04:	00d986b3          	add	a3,s3,a3
80001d08:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
80001d0c:	008bd603          	lhu	a2,8(s7)
80001d10:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
80001d14:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
80001d18:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001d1c:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
80001d20:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001d24:	00d80cb3          	add	s9,a6,a3
80001d28:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
80001d2c:	02c6ec63          	bltu	a3,a2,80001d64 <z_sys_mem_pool_block_free+0x1bc>
80001d30:	800077b7          	lui	a5,0x80007
80001d34:	22c78593          	addi	a1,a5,556 # 8000722c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000722d>
80001d38:	800077b7          	lui	a5,0x80007
80001d3c:	1c478513          	addi	a0,a5,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80001d40:	0a400693          	li	a3,164
80001d44:	218a8613          	addi	a2,s5,536 # 80007218 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007219>
80001d48:	794000ef          	jal	ra,800024dc <printk>
80001d4c:	800077b7          	lui	a5,0x80007
80001d50:	24878513          	addi	a0,a5,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80001d54:	788000ef          	jal	ra,800024dc <printk>
80001d58:	0a400593          	li	a1,164
80001d5c:	218a8513          	addi	a0,s5,536
80001d60:	7b8000ef          	jal	ra,80002518 <assert_post_action>
		set_free_bit(p, level, bn);
80001d64:	00090613          	mv	a2,s2
80001d68:	000c0593          	mv	a1,s8
80001d6c:	000b8513          	mv	a0,s7
80001d70:	a05ff0ef          	jal	ra,80001774 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
80001d74:	03ac06b3          	mul	a3,s8,s10
80001d78:	00cba603          	lw	a2,12(s7)
80001d7c:	00d606b3          	add	a3,a2,a3
80001d80:	00468613          	addi	a2,a3,4
	node->next = list;
80001d84:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
80001d88:	0086a603          	lw	a2,8(a3)
80001d8c:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
80001d90:	0086a603          	lw	a2,8(a3)
80001d94:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001d98:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001d9c:	010bc683          	lbu	a3,16(s7)
80001da0:	0016f693          	andi	a3,a3,1
80001da4:	0c069463          	bnez	a3,80001e6c <z_sys_mem_pool_block_free+0x2c4>
		return 0;
80001da8:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001dac:	ee0c02e3          	beqz	s8,80001c90 <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
80001db0:	fbc40693          	addi	a3,s0,-68
80001db4:	00090613          	mv	a2,s2
80001db8:	000c0593          	mv	a1,s8
80001dbc:	000b8513          	mv	a0,s7
80001dc0:	97dff0ef          	jal	ra,8000173c <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
80001dc4:	00400693          	li	a3,4
80001dc8:	02d546b3          	div	a3,a0,a3
80001dcc:	fbc42603          	lw	a2,-68(s0)
80001dd0:	00062503          	lw	a0,0(a2)
80001dd4:	00269693          	slli	a3,a3,0x2
80001dd8:	00d55533          	srl	a0,a0,a3
80001ddc:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001de0:	00f00693          	li	a3,15
80001de4:	ead516e3          	bne	a0,a3,80001c90 <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
80001de8:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
80001dec:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
80001df0:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
80001df4:	008bd583          	lhu	a1,8(s7)
80001df8:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
80001dfc:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
80001e00:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
80001e04:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001e08:	016886b3          	add	a3,a7,s6
80001e0c:	04b6f663          	bgeu	a3,a1,80001e58 <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
80001e10:	000c0593          	mv	a1,s8
80001e14:	000b8513          	mv	a0,s7
80001e18:	fbc42223          	sw	t3,-92(s0)
80001e1c:	fb042423          	sw	a6,-88(s0)
80001e20:	fb142623          	sw	a7,-84(s0)
80001e24:	985ff0ef          	jal	ra,800017a8 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001e28:	000ba683          	lw	a3,0(s7)
80001e2c:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
80001e30:	fa442e03          	lw	t3,-92(s0)
80001e34:	fa842803          	lw	a6,-88(s0)
80001e38:	011686b3          	add	a3,a3,a7
	node->prev->next = node->next;
80001e3c:	0046a583          	lw	a1,4(a3)
80001e40:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
80001e44:	00400313          	li	t1,4
	node->prev->next = node->next;
80001e48:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
80001e4c:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
80001e50:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
80001e54:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
80001e58:	00180813          	addi	a6,a6,1
80001e5c:	f8681ce3          	bne	a6,t1,80001df4 <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
80001e60:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
80001e64:	03094933          	div	s2,s2,a6
80001e68:	de9ff06f          	j	80001c50 <z_sys_mem_pool_block_free+0xa8>
80001e6c:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001e70:	010bc683          	lbu	a3,16(s7)
80001e74:	0016f693          	andi	a3,a3,1
80001e78:	f20688e3          	beqz	a3,80001da8 <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e7c:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
80001e80:	0084f493          	andi	s1,s1,8
80001e84:	f29ff06f          	j	80001dac <z_sys_mem_pool_block_free+0x204>

80001e88 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001e88:	ff010113          	addi	sp,sp,-16
80001e8c:	00050793          	mv	a5,a0
80001e90:	00058513          	mv	a0,a1
80001e94:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001e98:	00068613          	mv	a2,a3
{
80001e9c:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001ea0:	000780e7          	jalr	a5
80001ea4:	168030ef          	jal	ra,8000500c <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001ea8:	15d030ef          	jal	ra,80005804 <z_impl_k_thread_abort>

80001eac <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001eac:	00000513          	li	a0,0
80001eb0:	00008067          	ret

80001eb4 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001eb4:	ff010113          	addi	sp,sp,-16
80001eb8:	00812423          	sw	s0,8(sp)
80001ebc:	00050413          	mv	s0,a0
	out('E', ctx);
80001ec0:	04500513          	li	a0,69
{
80001ec4:	00112623          	sw	ra,12(sp)
80001ec8:	00912223          	sw	s1,4(sp)
80001ecc:	00058493          	mv	s1,a1
	out('E', ctx);
80001ed0:	000400e7          	jalr	s0
	out('R', ctx);
80001ed4:	00048593          	mv	a1,s1
80001ed8:	05200513          	li	a0,82
80001edc:	000400e7          	jalr	s0
	out('R', ctx);
80001ee0:	00040313          	mv	t1,s0
}
80001ee4:	00812403          	lw	s0,8(sp)
80001ee8:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001eec:	00048593          	mv	a1,s1
}
80001ef0:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001ef4:	05200513          	li	a0,82
}
80001ef8:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001efc:	00030067          	jr	t1

80001f00 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001f00:	0005a783          	lw	a5,0(a1)
80001f04:	00178793          	addi	a5,a5,1
80001f08:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001f0c:	800087b7          	lui	a5,0x80008
80001f10:	8ac7a303          	lw	t1,-1876(a5) # 800078ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078ad>
80001f14:	00030067          	jr	t1

80001f18 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001f18:	fb010113          	addi	sp,sp,-80
80001f1c:	04812423          	sw	s0,72(sp)
80001f20:	03312e23          	sw	s3,60(sp)
80001f24:	03412c23          	sw	s4,56(sp)
80001f28:	03512a23          	sw	s5,52(sp)
80001f2c:	03612823          	sw	s6,48(sp)
80001f30:	04112623          	sw	ra,76(sp)
80001f34:	04912223          	sw	s1,68(sp)
80001f38:	05212023          	sw	s2,64(sp)
80001f3c:	03712623          	sw	s7,44(sp)
80001f40:	03812423          	sw	s8,40(sp)
80001f44:	03912223          	sw	s9,36(sp)
80001f48:	03a12023          	sw	s10,32(sp)
80001f4c:	01b12e23          	sw	s11,28(sp)
80001f50:	00050a13          	mv	s4,a0
80001f54:	00058a93          	mv	s5,a1
80001f58:	00060993          	mv	s3,a2
80001f5c:	00068b13          	mv	s6,a3
80001f60:	00100413          	li	s0,1
80001f64:	00e05463          	blez	a4,80001f6c <_printk_dec_ulong+0x54>
80001f68:	00070413          	mv	s0,a4
80001f6c:	00100793          	li	a5,1
80001f70:	02000c13          	li	s8,32
80001f74:	00fb1463          	bne	s6,a5,80001f7c <_printk_dec_ulong+0x64>
80001f78:	03000c13          	li	s8,48
80001f7c:	3b9ad4b7          	lui	s1,0x3b9ad
80001f80:	00100913          	li	s2,1
80001f84:	00a00c93          	li	s9,10
80001f88:	00000713          	li	a4,0
80001f8c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80001f90:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
80001f94:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001f98:	00148b93          	addi	s7,s1,1
80001f9c:	00071463          	bnez	a4,80001fa4 <_printk_dec_ulong+0x8c>
80001fa0:	0934f263          	bgeu	s1,s3,80002024 <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001fa4:	0379d533          	divu	a0,s3,s7
80001fa8:	000a8593          	mv	a1,s5
			digits++;
80001fac:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001fb0:	03050513          	addi	a0,a0,48
80001fb4:	000a00e7          	jalr	s4
			found_largest_digit = 1;
80001fb8:	00100713          	li	a4,1
		remaining--;
80001fbc:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
80001fc0:	00100793          	li	a5,1
		remainder %= (pos + 1);
80001fc4:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
80001fc8:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80001fcc:	fcfc96e3          	bne	s9,a5,80001f98 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80001fd0:	000a8593          	mv	a1,s5
80001fd4:	03098513          	addi	a0,s3,48
80001fd8:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80001fdc:	00300793          	li	a5,3
		remaining = min_width - digits;
80001fe0:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001fe4:	06fb0a63          	beq	s6,a5,80002058 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001fe8:	04c12083          	lw	ra,76(sp)
80001fec:	04812403          	lw	s0,72(sp)
80001ff0:	04412483          	lw	s1,68(sp)
80001ff4:	04012903          	lw	s2,64(sp)
80001ff8:	03c12983          	lw	s3,60(sp)
80001ffc:	03812a03          	lw	s4,56(sp)
80002000:	03412a83          	lw	s5,52(sp)
80002004:	03012b03          	lw	s6,48(sp)
80002008:	02c12b83          	lw	s7,44(sp)
8000200c:	02812c03          	lw	s8,40(sp)
80002010:	02412c83          	lw	s9,36(sp)
80002014:	02012d03          	lw	s10,32(sp)
80002018:	01c12d83          	lw	s11,28(sp)
8000201c:	05010113          	addi	sp,sp,80
80002020:	00008067          	ret
		} else if (remaining <= min_width
80002024:	f9944ce3          	blt	s0,s9,80001fbc <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80002028:	f96deae3          	bltu	s11,s6,80001fbc <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
8000202c:	000a8593          	mv	a1,s5
80002030:	000c0513          	mv	a0,s8
80002034:	00e12623          	sw	a4,12(sp)
80002038:	000a00e7          	jalr	s4
			digits++;
8000203c:	00190913          	addi	s2,s2,1
80002040:	00c12703          	lw	a4,12(sp)
80002044:	f79ff06f          	j	80001fbc <_printk_dec_ulong+0xa4>
			out(' ', ctx);
80002048:	000a8593          	mv	a1,s5
8000204c:	02000513          	li	a0,32
80002050:	000a00e7          	jalr	s4
80002054:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
80002058:	fe8048e3          	bgtz	s0,80002048 <_printk_dec_ulong+0x130>
8000205c:	f8dff06f          	j	80001fe8 <_printk_dec_ulong+0xd0>

80002060 <__printk_hook_install>:
	_char_out = fn;
80002060:	800087b7          	lui	a5,0x80008
80002064:	8aa7a623          	sw	a0,-1876(a5) # 800078ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078ad>
}
80002068:	00008067          	ret

8000206c <z_vprintk>:
{
8000206c:	fb010113          	addi	sp,sp,-80
80002070:	04812423          	sw	s0,72(sp)
80002074:	04912223          	sw	s1,68(sp)
80002078:	05212023          	sw	s2,64(sp)
8000207c:	03312e23          	sw	s3,60(sp)
80002080:	03412c23          	sw	s4,56(sp)
80002084:	03512a23          	sw	s5,52(sp)
80002088:	03912223          	sw	s9,36(sp)
8000208c:	03a12023          	sw	s10,32(sp)
80002090:	01b12e23          	sw	s11,28(sp)
80002094:	04112623          	sw	ra,76(sp)
80002098:	03612823          	sw	s6,48(sp)
8000209c:	03712623          	sw	s7,44(sp)
800020a0:	03812423          	sw	s8,40(sp)
800020a4:	00050413          	mv	s0,a0
800020a8:	00058493          	mv	s1,a1
800020ac:	00060a93          	mv	s5,a2
800020b0:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800020b4:	00000a13          	li	s4,0
	int min_width = -1;
800020b8:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800020bc:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800020c0:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800020c4:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800020c8:	000ac503          	lbu	a0,0(s5)
800020cc:	04051063          	bnez	a0,8000210c <z_vprintk+0xa0>
}
800020d0:	04c12083          	lw	ra,76(sp)
800020d4:	04812403          	lw	s0,72(sp)
800020d8:	04412483          	lw	s1,68(sp)
800020dc:	04012903          	lw	s2,64(sp)
800020e0:	03c12983          	lw	s3,60(sp)
800020e4:	03812a03          	lw	s4,56(sp)
800020e8:	03412a83          	lw	s5,52(sp)
800020ec:	03012b03          	lw	s6,48(sp)
800020f0:	02c12b83          	lw	s7,44(sp)
800020f4:	02812c03          	lw	s8,40(sp)
800020f8:	02412c83          	lw	s9,36(sp)
800020fc:	02012d03          	lw	s10,32(sp)
80002100:	01c12d83          	lw	s11,28(sp)
80002104:	05010113          	addi	sp,sp,80
80002108:	00008067          	ret
		if (!might_format) {
8000210c:	000c9e63          	bnez	s9,80002128 <z_vprintk+0xbc>
			if (*fmt != '%') {
80002110:	02500693          	li	a3,37
80002114:	36d50a63          	beq	a0,a3,80002488 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80002118:	00048593          	mv	a1,s1
8000211c:	000400e7          	jalr	s0
		++fmt;
80002120:	001a8a93          	addi	s5,s5,1
80002124:	fa5ff06f          	j	800020c8 <z_vprintk+0x5c>
			switch (*fmt) {
80002128:	06400693          	li	a3,100
8000212c:	10d50e63          	beq	a0,a3,80002248 <z_vprintk+0x1dc>
80002130:	06a6e263          	bltu	a3,a0,80002194 <z_vprintk+0x128>
80002134:	03900693          	li	a3,57
80002138:	02a6ea63          	bltu	a3,a0,8000216c <z_vprintk+0x100>
8000213c:	03100693          	li	a3,49
80002140:	0ed57463          	bgeu	a0,a3,80002228 <z_vprintk+0x1bc>
80002144:	02d00693          	li	a3,45
80002148:	34d50a63          	beq	a0,a3,8000249c <z_vprintk+0x430>
8000214c:	03000793          	li	a5,48
80002150:	0cf50063          	beq	a0,a5,80002210 <z_vprintk+0x1a4>
80002154:	02500713          	li	a4,37
80002158:	02e51263          	bne	a0,a4,8000217c <z_vprintk+0x110>
				out((int)'%', ctx);
8000215c:	00048593          	mv	a1,s1
80002160:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80002164:	000400e7          	jalr	s0
				break;
80002168:	15c0006f          	j	800022c4 <z_vprintk+0x258>
8000216c:	05800693          	li	a3,88
80002170:	1ad50e63          	beq	a0,a3,8000232c <z_vprintk+0x2c0>
80002174:	06300713          	li	a4,99
80002178:	2ee50e63          	beq	a0,a4,80002474 <z_vprintk+0x408>
				out((int)'%', ctx);
8000217c:	00048593          	mv	a1,s1
80002180:	02500513          	li	a0,37
80002184:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80002188:	00048593          	mv	a1,s1
8000218c:	000ac503          	lbu	a0,0(s5)
80002190:	fd5ff06f          	j	80002164 <z_vprintk+0xf8>
80002194:	07000693          	li	a3,112
80002198:	16d50a63          	beq	a0,a3,8000230c <z_vprintk+0x2a0>
8000219c:	02a6e063          	bltu	a3,a0,800021bc <z_vprintk+0x150>
800021a0:	06900693          	li	a3,105
800021a4:	0ad50263          	beq	a0,a3,80002248 <z_vprintk+0x1dc>
800021a8:	06c00693          	li	a3,108
800021ac:	08d50a63          	beq	a0,a3,80002240 <z_vprintk+0x1d4>
800021b0:	06800693          	li	a3,104
800021b4:	f6d506e3          	beq	a0,a3,80002120 <z_vprintk+0xb4>
800021b8:	fc5ff06f          	j	8000217c <z_vprintk+0x110>
800021bc:	07500693          	li	a3,117
800021c0:	10d50663          	beq	a0,a3,800022cc <z_vprintk+0x260>
800021c4:	02a6ee63          	bltu	a3,a0,80002200 <z_vprintk+0x194>
800021c8:	07300713          	li	a4,115
800021cc:	fae518e3          	bne	a0,a4,8000217c <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800021d0:	000d2c03          	lw	s8,0(s10)
800021d4:	004d0b13          	addi	s6,s10,4
800021d8:	000c0b93          	mv	s7,s8
				while (*s)
800021dc:	000bc503          	lbu	a0,0(s7)
800021e0:	26051863          	bnez	a0,80002450 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
800021e4:	00300793          	li	a5,3
800021e8:	00f99863          	bne	s3,a5,800021f8 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800021ec:	418b8bb3          	sub	s7,s7,s8
800021f0:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800021f4:	27704663          	bgtz	s7,80002460 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
800021f8:	000b0d13          	mv	s10,s6
800021fc:	0c80006f          	j	800022c4 <z_vprintk+0x258>
80002200:	07800693          	li	a3,120
80002204:	12d50463          	beq	a0,a3,8000232c <z_vprintk+0x2c0>
80002208:	07a00693          	li	a3,122
8000220c:	fa9ff06f          	j	800021b4 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80002210:	00095e63          	bgez	s2,8000222c <z_vprintk+0x1c0>
80002214:	28098863          	beqz	s3,800024a4 <z_vprintk+0x438>
					min_width = *fmt - '0';
80002218:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
8000221c:	f00992e3          	bnez	s3,80002120 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80002220:	00200993          	li	s3,2
80002224:	efdff06f          	j	80002120 <z_vprintk+0xb4>
				if (min_width < 0) {
80002228:	fe0948e3          	bltz	s2,80002218 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
8000222c:	00a00693          	li	a3,10
80002230:	02d90933          	mul	s2,s2,a3
80002234:	fd090913          	addi	s2,s2,-48
80002238:	01250933          	add	s2,a0,s2
8000223c:	fe1ff06f          	j	8000221c <z_vprintk+0x1b0>
				long_ctr++;
80002240:	001a0a13          	addi	s4,s4,1
80002244:	eddff06f          	j	80002120 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80002248:	040a1263          	bnez	s4,8000228c <z_vprintk+0x220>
					long ld = va_arg(ap, long);
8000224c:	000d2603          	lw	a2,0(s10)
80002250:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80002254:	02065063          	bgez	a2,80002274 <z_vprintk+0x208>
					out((int)'-', ctx);
80002258:	00048593          	mv	a1,s1
8000225c:	02d00513          	li	a0,45
80002260:	00c12023          	sw	a2,0(sp)
80002264:	000400e7          	jalr	s0
					d = -d;
80002268:	00012603          	lw	a2,0(sp)
					min_width--;
8000226c:	fff90913          	addi	s2,s2,-1
					d = -d;
80002270:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80002274:	00090713          	mv	a4,s2
80002278:	00098693          	mv	a3,s3
8000227c:	00048593          	mv	a1,s1
80002280:	00040513          	mv	a0,s0
80002284:	c95ff0ef          	jal	ra,80001f18 <_printk_dec_ulong>
				break;
80002288:	03c0006f          	j	800022c4 <z_vprintk+0x258>
				} else if (long_ctr == 1) {
8000228c:	00100713          	li	a4,1
80002290:	faea0ee3          	beq	s4,a4,8000224c <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
80002294:	007d0793          	addi	a5,s10,7
80002298:	ff87f713          	andi	a4,a5,-8
8000229c:	00072603          	lw	a2,0(a4)
800022a0:	00472683          	lw	a3,4(a4)
800022a4:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800022a8:	01b60733          	add	a4,a2,s11
800022ac:	00c73733          	sltu	a4,a4,a2
800022b0:	00d70733          	add	a4,a4,a3
800022b4:	fa0700e3          	beqz	a4,80002254 <z_vprintk+0x1e8>
						print_err(out, ctx);
800022b8:	00048593          	mv	a1,s1
800022bc:	00040513          	mv	a0,s0
800022c0:	bf5ff0ef          	jal	ra,80001eb4 <print_err>
			might_format = 0;
800022c4:	00000c93          	li	s9,0
800022c8:	e59ff06f          	j	80002120 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800022cc:	000a1863          	bnez	s4,800022dc <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
800022d0:	000d2603          	lw	a2,0(s10)
800022d4:	004d0d13          	addi	s10,s10,4
800022d8:	f9dff06f          	j	80002274 <z_vprintk+0x208>
				} else if (long_ctr == 1) {
800022dc:	00100713          	li	a4,1
800022e0:	feea08e3          	beq	s4,a4,800022d0 <z_vprintk+0x264>
					unsigned long long llu =
800022e4:	007d0793          	addi	a5,s10,7
800022e8:	ff87f713          	andi	a4,a5,-8
800022ec:	00870d13          	addi	s10,a4,8
800022f0:	00072603          	lw	a2,0(a4)
800022f4:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
800022f8:	fc0710e3          	bnez	a4,800022b8 <z_vprintk+0x24c>
800022fc:	800007b7          	lui	a5,0x80000
80002300:	fff7c793          	not	a5,a5
80002304:	f6c7f8e3          	bgeu	a5,a2,80002274 <z_vprintk+0x208>
80002308:	fb1ff06f          	j	800022b8 <z_vprintk+0x24c>
				  out('0', ctx);
8000230c:	00048593          	mv	a1,s1
80002310:	03000513          	li	a0,48
80002314:	000400e7          	jalr	s0
				  out('x', ctx);
80002318:	00048593          	mv	a1,s1
8000231c:	07800513          	li	a0,120
80002320:	000400e7          	jalr	s0
				  min_width = 8;
80002324:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80002328:	00100993          	li	s3,1
				if (long_ctr < 2) {
8000232c:	00100693          	li	a3,1
80002330:	0b46c263          	blt	a3,s4,800023d4 <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
80002334:	000d2783          	lw	a5,0(s10)
80002338:	00012423          	sw	zero,8(sp)
8000233c:	004d0d13          	addi	s10,s10,4
80002340:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80002344:	01000c13          	li	s8,16
	int digits = 0;
80002348:	00000b93          	li	s7,0
	int found_largest_digit = 0;
8000234c:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80002350:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002354:	00412503          	lw	a0,4(sp)
80002358:	00812583          	lw	a1,8(sp)
8000235c:	fff88b13          	addi	s6,a7,-1
80002360:	002b1613          	slli	a2,s6,0x2
80002364:	01112623          	sw	a7,12(sp)
80002368:	f21fd0ef          	jal	ra,80000288 <__lshrdi3>
8000236c:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002370:	08051863          	bnez	a0,80002400 <z_vprintk+0x394>
80002374:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002378:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000237c:	00079863          	bnez	a5,8000238c <z_vprintk+0x320>
80002380:	00c12883          	lw	a7,12(sp)
80002384:	00100793          	li	a5,1
80002388:	08f89663          	bne	a7,a5,80002414 <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
8000238c:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002390:	01851513          	slli	a0,a0,0x18
80002394:	00048593          	mv	a1,s1
80002398:	41855513          	srai	a0,a0,0x18
8000239c:	000400e7          	jalr	s0
			digits++;
800023a0:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
800023a4:	040b1863          	bnez	s6,800023f4 <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
800023a8:	00300693          	li	a3,3
			might_format = 0;
800023ac:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800023b0:	d6d998e3          	bne	s3,a3,80002120 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
800023b4:	00191713          	slli	a4,s2,0x1
800023b8:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800023bc:	f17054e3          	blez	s7,800022c4 <z_vprintk+0x258>
			out(' ', ctx);
800023c0:	00048593          	mv	a1,s1
800023c4:	02000513          	li	a0,32
800023c8:	000400e7          	jalr	s0
800023cc:	fffb8b93          	addi	s7,s7,-1
800023d0:	fedff06f          	j	800023bc <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
800023d4:	007d0793          	addi	a5,s10,7
800023d8:	ff87f693          	andi	a3,a5,-8
800023dc:	0006a783          	lw	a5,0(a3)
800023e0:	00868d13          	addi	s10,a3,8
800023e4:	00f12223          	sw	a5,4(sp)
800023e8:	0046a783          	lw	a5,4(a3)
800023ec:	00f12423          	sw	a5,8(sp)
800023f0:	f55ff06f          	j	80002344 <z_vprintk+0x2d8>
			found_largest_digit = 1;
800023f4:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800023f8:	000b0893          	mv	a7,s6
800023fc:	f59ff06f          	j	80002354 <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80002400:	00900793          	li	a5,9
80002404:	05700693          	li	a3,87
80002408:	f8a7e2e3          	bltu	a5,a0,8000238c <z_vprintk+0x320>
8000240c:	03000693          	li	a3,48
80002410:	f7dff06f          	j	8000238c <z_vprintk+0x320>
		if (remaining-- <= min_width) {
80002414:	fffc0793          	addi	a5,s8,-1
80002418:	00f12623          	sw	a5,12(sp)
8000241c:	01894c63          	blt	s2,s8,80002434 <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80002420:	00100793          	li	a5,1
80002424:	00f99c63          	bne	s3,a5,8000243c <z_vprintk+0x3d0>
				out('0', ctx);
80002428:	00048593          	mv	a1,s1
8000242c:	03000513          	li	a0,48
				out(' ', ctx);
80002430:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80002434:	00c12c03          	lw	s8,12(sp)
80002438:	fc1ff06f          	j	800023f8 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
8000243c:	00200793          	li	a5,2
80002440:	fef99ae3          	bne	s3,a5,80002434 <z_vprintk+0x3c8>
				out(' ', ctx);
80002444:	00048593          	mv	a1,s1
80002448:	02000513          	li	a0,32
8000244c:	fe5ff06f          	j	80002430 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
80002450:	00048593          	mv	a1,s1
80002454:	001b8b93          	addi	s7,s7,1
80002458:	000400e7          	jalr	s0
8000245c:	d81ff06f          	j	800021dc <z_vprintk+0x170>
						out(' ', ctx);
80002460:	00048593          	mv	a1,s1
80002464:	02000513          	li	a0,32
80002468:	000400e7          	jalr	s0
8000246c:	fffb8b93          	addi	s7,s7,-1
80002470:	d85ff06f          	j	800021f4 <z_vprintk+0x188>
				out(c, ctx);
80002474:	000d2503          	lw	a0,0(s10)
80002478:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
8000247c:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002480:	000400e7          	jalr	s0
				break;
80002484:	d75ff06f          	j	800021f8 <z_vprintk+0x18c>
				long_ctr = 0;
80002488:	00000a13          	li	s4,0
				min_width = -1;
8000248c:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002490:	00000993          	li	s3,0
				might_format = 1;
80002494:	00100c93          	li	s9,1
80002498:	c89ff06f          	j	80002120 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
8000249c:	00300993          	li	s3,3
800024a0:	c81ff06f          	j	80002120 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
800024a4:	00100993          	li	s3,1
800024a8:	c79ff06f          	j	80002120 <z_vprintk+0xb4>

800024ac <vprintk>:
{
800024ac:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800024b0:	00050613          	mv	a2,a0
800024b4:	80002537          	lui	a0,0x80002
800024b8:	00058693          	mv	a3,a1
800024bc:	f0050513          	addi	a0,a0,-256 # 80001f00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001f01>
800024c0:	00c10593          	addi	a1,sp,12
{
800024c4:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800024c8:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800024cc:	ba1ff0ef          	jal	ra,8000206c <z_vprintk>
}
800024d0:	01c12083          	lw	ra,28(sp)
800024d4:	02010113          	addi	sp,sp,32
800024d8:	00008067          	ret

800024dc <printk>:
{
800024dc:	fc010113          	addi	sp,sp,-64
800024e0:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
800024e4:	02410593          	addi	a1,sp,36
{
800024e8:	00112e23          	sw	ra,28(sp)
800024ec:	02c12423          	sw	a2,40(sp)
800024f0:	02d12623          	sw	a3,44(sp)
800024f4:	02e12823          	sw	a4,48(sp)
800024f8:	02f12a23          	sw	a5,52(sp)
800024fc:	03012c23          	sw	a6,56(sp)
80002500:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80002504:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80002508:	fa5ff0ef          	jal	ra,800024ac <vprintk>
}
8000250c:	01c12083          	lw	ra,28(sp)
80002510:	04010113          	addi	sp,sp,64
80002514:	00008067          	ret

80002518 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80002518:	800075b7          	lui	a1,0x80007
8000251c:	80007537          	lui	a0,0x80007
{
80002520:	ff010113          	addi	sp,sp,-16
  k_panic();
80002524:	25c58593          	addi	a1,a1,604 # 8000725c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000725d>
80002528:	27050513          	addi	a0,a0,624 # 80007270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007271>
8000252c:	01e00613          	li	a2,30
{
80002530:	00112623          	sw	ra,12(sp)
  k_panic();
80002534:	fa9ff0ef          	jal	ra,800024dc <printk>
80002538:	800075b7          	lui	a1,0x80007
8000253c:	e3c58593          	addi	a1,a1,-452 # 80006e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e3d>
80002540:	00600513          	li	a0,6
80002544:	ea5fe0ef          	jal	ra,800013e8 <z_NanoFatalErrorHandler>

80002548 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80002548:	00008067          	ret

8000254c <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000254c:	00800793          	li	a5,8
80002550:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80002554:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80002558:	00008067          	ret

8000255c <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
8000255c:	00100793          	li	a5,1
80002560:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80002564:	30452573          	csrrs	a0,mie,a0
}
80002568:	00008067          	ret

8000256c <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000256c:	00800793          	li	a5,8
80002570:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80002574:	30405073          	csrwi	mie,0
80002578:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
8000257c:	00008067          	ret

80002580 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002580:	ff010113          	addi	sp,sp,-16
80002584:	00812423          	sw	s0,8(sp)
80002588:	00912223          	sw	s1,4(sp)
8000258c:	80008437          	lui	s0,0x80008
80002590:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80002594:	00a00793          	li	a5,10
{
80002598:	00050493          	mv	s1,a0
8000259c:	95040413          	addi	s0,s0,-1712 # 80007950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007951>
	if ('\n' == c) {
800025a0:	00f51c63          	bne	a0,a5,800025b8 <console_out+0x38>
800025a4:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800025a8:	00d00593          	li	a1,13
800025ac:	00452783          	lw	a5,4(a0)
800025b0:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
800025b4:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800025b8:	00042503          	lw	a0,0(s0)
800025bc:	0ff4f593          	andi	a1,s1,255
800025c0:	00452783          	lw	a5,4(a0)
800025c4:	0047a783          	lw	a5,4(a5)
800025c8:	000780e7          	jalr	a5

	return c;
}
800025cc:	00c12083          	lw	ra,12(sp)
800025d0:	00812403          	lw	s0,8(sp)
800025d4:	00048513          	mv	a0,s1
800025d8:	00412483          	lw	s1,4(sp)
800025dc:	01010113          	addi	sp,sp,16
800025e0:	00008067          	ret

800025e4 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
800025e4:	ff010113          	addi	sp,sp,-16
800025e8:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
800025ec:	80002437          	lui	s0,0x80002
800025f0:	58040513          	addi	a0,s0,1408 # 80002580 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002581>
{
800025f4:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
800025f8:	5b4000ef          	jal	ra,80002bac <__stdout_hook_install>
	__printk_hook_install(console_out);
800025fc:	58040513          	addi	a0,s0,1408
}
80002600:	00812403          	lw	s0,8(sp)
80002604:	00c12083          	lw	ra,12(sp)
80002608:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
8000260c:	a55ff06f          	j	80002060 <__printk_hook_install>

80002610 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80002610:	80007537          	lui	a0,0x80007
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80002614:	ff010113          	addi	sp,sp,-16
80002618:	27c50513          	addi	a0,a0,636 # 8000727c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000727d>
8000261c:	00112623          	sw	ra,12(sp)
80002620:	135000ef          	jal	ra,80002f54 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80002624:	800087b7          	lui	a5,0x80008
80002628:	94a7a823          	sw	a0,-1712(a5) # 80007950 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007951>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
8000262c:	fb9ff0ef          	jal	ra,800025e4 <uart_console_hook_install>

	return 0;
}
80002630:	00c12083          	lw	ra,12(sp)
80002634:	00000513          	li	a0,0
80002638:	01010113          	addi	sp,sp,16
8000263c:	00008067          	ret

80002640 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80002640:	f01007b7          	lui	a5,0xf0100
80002644:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80002648:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
8000264c:	f447a583          	lw	a1,-188(a5)
80002650:	fee59ae3          	bne	a1,a4,80002644 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80002654:	00008067          	ret

80002658 <timer_isr>:

static void timer_isr(void *arg)
{
80002658:	fe010113          	addi	sp,sp,-32
8000265c:	00812c23          	sw	s0,24(sp)
80002660:	00112e23          	sw	ra,28(sp)
80002664:	00912a23          	sw	s1,20(sp)
80002668:	01212823          	sw	s2,16(sp)
8000266c:	01312623          	sw	s3,12(sp)
80002670:	01412423          	sw	s4,8(sp)
80002674:	01512223          	sw	s5,4(sp)
80002678:	00800413          	li	s0,8
8000267c:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002680:	80008937          	lui	s2,0x80008
80002684:	95490513          	addi	a0,s2,-1708 # 80007954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007955>
	key = (mstatus & SOC_MSTATUS_IEN);
80002688:	00847413          	andi	s0,s0,8
8000268c:	611020ef          	jal	ra,8000549c <z_spin_lock_valid>
80002690:	02051e63          	bnez	a0,800026cc <timer_isr+0x74>
80002694:	800074b7          	lui	s1,0x80007
80002698:	800075b7          	lui	a1,0x80007
8000269c:	80007537          	lui	a0,0x80007
800026a0:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800026a4:	04e00693          	li	a3,78
800026a8:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800026ac:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800026b0:	e2dff0ef          	jal	ra,800024dc <printk>
800026b4:	80007537          	lui	a0,0x80007
800026b8:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800026bc:	e21ff0ef          	jal	ra,800024dc <printk>
800026c0:	04e00593          	li	a1,78
800026c4:	29048513          	addi	a0,s1,656
800026c8:	e51ff0ef          	jal	ra,80002518 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
800026cc:	95490513          	addi	a0,s2,-1708
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800026d0:	800084b7          	lui	s1,0x80008
800026d4:	621020ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
800026d8:	93848493          	addi	s1,s1,-1736 # 80007938 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007939>
	u64_t now = mtime();
800026dc:	f65ff0ef          	jal	ra,80002640 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800026e0:	0004a983          	lw	s3,0(s1)
800026e4:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
800026e8:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800026ec:	41350533          	sub	a0,a0,s3
800026f0:	00a73733          	sltu	a4,a4,a0
800026f4:	415585b3          	sub	a1,a1,s5
800026f8:	0001d637          	lui	a2,0x1d
800026fc:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002700:	00000693          	li	a3,0
80002704:	40e585b3          	sub	a1,a1,a4
80002708:	bb9fd0ef          	jal	ra,800002c0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
8000270c:	0001d7b7          	lui	a5,0x1d
80002710:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002714:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80002718:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000271c:	95490513          	addi	a0,s2,-1708
	last_count += dticks * CYC_PER_TICK;
80002720:	013789b3          	add	s3,a5,s3
80002724:	00f9b7b3          	sltu	a5,s3,a5
80002728:	015787b3          	add	a5,a5,s5
8000272c:	0134a023          	sw	s3,0(s1)
80002730:	00f4a223          	sw	a5,4(s1)
80002734:	591020ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80002738:	02051e63          	bnez	a0,80002774 <timer_isr+0x11c>
8000273c:	800074b7          	lui	s1,0x80007
80002740:	800075b7          	lui	a1,0x80007
80002744:	80007537          	lui	a0,0x80007
80002748:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
8000274c:	06100693          	li	a3,97
80002750:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80002754:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80002758:	d85ff0ef          	jal	ra,800024dc <printk>
8000275c:	80007537          	lui	a0,0x80007
80002760:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80002764:	d79ff0ef          	jal	ra,800024dc <printk>
80002768:	06100593          	li	a1,97
8000276c:	29048513          	addi	a0,s1,656
80002770:	da9ff0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002774:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002778:	01812403          	lw	s0,24(sp)
8000277c:	01c12083          	lw	ra,28(sp)
80002780:	01412483          	lw	s1,20(sp)
80002784:	01012903          	lw	s2,16(sp)
80002788:	00c12983          	lw	s3,12(sp)
8000278c:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002790:	000a0513          	mv	a0,s4
}
80002794:	00812a03          	lw	s4,8(sp)
80002798:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000279c:	72c0306f          	j	80005ec8 <z_clock_announce>

800027a0 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800027a0:	ff010113          	addi	sp,sp,-16
800027a4:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800027a8:	e99ff0ef          	jal	ra,80002640 <mtime>
800027ac:	0001d7b7          	lui	a5,0x1d
800027b0:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800027b4:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800027b8:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
800027bc:	fff00693          	li	a3,-1
800027c0:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
800027c4:	00a7b533          	sltu	a0,a5,a0
800027c8:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
800027cc:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800027d0:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800027d4:	00700513          	li	a0,7
800027d8:	d85ff0ef          	jal	ra,8000255c <z_arch_irq_enable>
	return 0;
}
800027dc:	00c12083          	lw	ra,12(sp)
800027e0:	00000513          	li	a0,0
800027e4:	01010113          	addi	sp,sp,16
800027e8:	00008067          	ret

800027ec <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800027ec:	16059c63          	bnez	a1,80002964 <z_clock_set_timeout+0x178>
{
800027f0:	fe010113          	addi	sp,sp,-32
800027f4:	00112e23          	sw	ra,28(sp)
800027f8:	00812c23          	sw	s0,24(sp)
800027fc:	00912a23          	sw	s1,20(sp)
80002800:	01212823          	sw	s2,16(sp)
80002804:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002808:	fff00793          	li	a5,-1
8000280c:	00f51663          	bne	a0,a5,80002818 <z_clock_set_timeout+0x2c>
80002810:	00009537          	lui	a0,0x9
80002814:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002818:	000097b7          	lui	a5,0x9
8000281c:	fff50413          	addi	s0,a0,-1
80002820:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80002824:	1287da63          	bge	a5,s0,80002958 <z_clock_set_timeout+0x16c>
80002828:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000282c:	00800493          	li	s1,8
80002830:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002834:	80008937          	lui	s2,0x80008
80002838:	95490513          	addi	a0,s2,-1708 # 80007954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007955>
	key = (mstatus & SOC_MSTATUS_IEN);
8000283c:	0084f493          	andi	s1,s1,8
80002840:	45d020ef          	jal	ra,8000549c <z_spin_lock_valid>
80002844:	02051e63          	bnez	a0,80002880 <z_clock_set_timeout+0x94>
80002848:	800079b7          	lui	s3,0x80007
8000284c:	800075b7          	lui	a1,0x80007
80002850:	80007537          	lui	a0,0x80007
80002854:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80002858:	04e00693          	li	a3,78
8000285c:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80002860:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80002864:	c79ff0ef          	jal	ra,800024dc <printk>
80002868:	80007537          	lui	a0,0x80007
8000286c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80002870:	c6dff0ef          	jal	ra,800024dc <printk>
80002874:	04e00593          	li	a1,78
80002878:	29098513          	addi	a0,s3,656
8000287c:	c9dff0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80002880:	95490513          	addi	a0,s2,-1708
80002884:	471020ef          	jal	ra,800054f4 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80002888:	db9ff0ef          	jal	ra,80002640 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
8000288c:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002890:	800087b7          	lui	a5,0x80008
	u32_t cyc = ticks * CYC_PER_TICK;
80002894:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002898:	93878793          	addi	a5,a5,-1736 # 80007938 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007939>
8000289c:	0007a703          	lw	a4,0(a5)
800028a0:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
800028a4:	02c407b3          	mul	a5,s0,a2
800028a8:	4bf68693          	addi	a3,a3,1215
800028ac:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800028b0:	3e700693          	li	a3,999
800028b4:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800028b8:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
800028bc:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800028c0:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
800028c4:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800028c8:	00f50533          	add	a0,a0,a5
800028cc:	00a6c463          	blt	a3,a0,800028d4 <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
800028d0:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
800028d4:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
800028d8:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
800028dc:	fff00613          	li	a2,-1
800028e0:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
800028e4:	00f737b3          	sltu	a5,a4,a5
800028e8:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
800028ec:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
800028f0:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800028f4:	95490513          	addi	a0,s2,-1708
800028f8:	3cd020ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800028fc:	02051e63          	bnez	a0,80002938 <z_clock_set_timeout+0x14c>
80002900:	80007437          	lui	s0,0x80007
80002904:	800075b7          	lui	a1,0x80007
80002908:	80007537          	lui	a0,0x80007
8000290c:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80002910:	06100693          	li	a3,97
80002914:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80002918:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000291c:	bc1ff0ef          	jal	ra,800024dc <printk>
80002920:	80007537          	lui	a0,0x80007
80002924:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80002928:	bb5ff0ef          	jal	ra,800024dc <printk>
8000292c:	06100593          	li	a1,97
80002930:	29040513          	addi	a0,s0,656
80002934:	be5ff0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002938:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
8000293c:	01c12083          	lw	ra,28(sp)
80002940:	01812403          	lw	s0,24(sp)
80002944:	01412483          	lw	s1,20(sp)
80002948:	01012903          	lw	s2,16(sp)
8000294c:	00c12983          	lw	s3,12(sp)
80002950:	02010113          	addi	sp,sp,32
80002954:	00008067          	ret
80002958:	ec045ae3          	bgez	s0,8000282c <z_clock_set_timeout+0x40>
8000295c:	00000413          	li	s0,0
80002960:	ecdff06f          	j	8000282c <z_clock_set_timeout+0x40>
80002964:	00008067          	ret

80002968 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002968:	ff010113          	addi	sp,sp,-16
8000296c:	00812423          	sw	s0,8(sp)
80002970:	00112623          	sw	ra,12(sp)
80002974:	00912223          	sw	s1,4(sp)
80002978:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000297c:	00800413          	li	s0,8
80002980:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002984:	80008937          	lui	s2,0x80008
80002988:	95490513          	addi	a0,s2,-1708 # 80007954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007955>
	key = (mstatus & SOC_MSTATUS_IEN);
8000298c:	00847413          	andi	s0,s0,8
80002990:	30d020ef          	jal	ra,8000549c <z_spin_lock_valid>
80002994:	02051e63          	bnez	a0,800029d0 <z_clock_elapsed+0x68>
80002998:	800074b7          	lui	s1,0x80007
8000299c:	800075b7          	lui	a1,0x80007
800029a0:	80007537          	lui	a0,0x80007
800029a4:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800029a8:	04e00693          	li	a3,78
800029ac:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800029b0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800029b4:	b29ff0ef          	jal	ra,800024dc <printk>
800029b8:	80007537          	lui	a0,0x80007
800029bc:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800029c0:	b1dff0ef          	jal	ra,800024dc <printk>
800029c4:	04e00593          	li	a1,78
800029c8:	29048513          	addi	a0,s1,656
800029cc:	b4dff0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800029d0:	95490513          	addi	a0,s2,-1708
800029d4:	321020ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
800029d8:	c69ff0ef          	jal	ra,80002640 <mtime>
800029dc:	800087b7          	lui	a5,0x80008
800029e0:	9387a483          	lw	s1,-1736(a5) # 80007938 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007939>
800029e4:	409504b3          	sub	s1,a0,s1
800029e8:	0001d537          	lui	a0,0x1d
800029ec:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800029f0:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800029f4:	95490513          	addi	a0,s2,-1708
800029f8:	2cd020ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800029fc:	02051e63          	bnez	a0,80002a38 <z_clock_elapsed+0xd0>
80002a00:	80007937          	lui	s2,0x80007
80002a04:	800075b7          	lui	a1,0x80007
80002a08:	80007537          	lui	a0,0x80007
80002a0c:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80002a10:	06100693          	li	a3,97
80002a14:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80002a18:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80002a1c:	ac1ff0ef          	jal	ra,800024dc <printk>
80002a20:	80007537          	lui	a0,0x80007
80002a24:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80002a28:	ab5ff0ef          	jal	ra,800024dc <printk>
80002a2c:	06100593          	li	a1,97
80002a30:	29090513          	addi	a0,s2,656
80002a34:	ae5ff0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002a38:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002a3c:	00c12083          	lw	ra,12(sp)
80002a40:	00812403          	lw	s0,8(sp)
80002a44:	00048513          	mv	a0,s1
80002a48:	00012903          	lw	s2,0(sp)
80002a4c:	00412483          	lw	s1,4(sp)
80002a50:	01010113          	addi	sp,sp,16
80002a54:	00008067          	ret

80002a58 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002a58:	00054783          	lbu	a5,0(a0)
80002a5c:	0005c703          	lbu	a4,0(a1)
80002a60:	00e79463          	bne	a5,a4,80002a68 <strcmp+0x10>
80002a64:	00079663          	bnez	a5,80002a70 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002a68:	40e78533          	sub	a0,a5,a4
80002a6c:	00008067          	ret
		s1++;
80002a70:	00150513          	addi	a0,a0,1
		s2++;
80002a74:	00158593          	addi	a1,a1,1
80002a78:	fe1ff06f          	j	80002a58 <strcmp>

80002a7c <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80002a7c:	00b547b3          	xor	a5,a0,a1
80002a80:	0037f793          	andi	a5,a5,3
80002a84:	06078063          	beqz	a5,80002ae4 <memcpy+0x68>
	unsigned char *d_byte = (unsigned char *)d;
80002a88:	00050793          	mv	a5,a0
80002a8c:	00000713          	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80002a90:	06e61a63          	bne	a2,a4,80002b04 <memcpy+0x88>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80002a94:	00008067          	ret
			if (n == 0) {
80002a98:	fe060ee3          	beqz	a2,80002a94 <memcpy+0x18>
			*(d_byte++) = *(s_byte++);
80002a9c:	00158593          	addi	a1,a1,1
80002aa0:	fff5c703          	lbu	a4,-1(a1)
80002aa4:	00178793          	addi	a5,a5,1
			n--;
80002aa8:	fff60613          	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80002aac:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80002ab0:	0037f713          	andi	a4,a5,3
80002ab4:	fe0712e3          	bnez	a4,80002a98 <memcpy+0x1c>
		while (n >= sizeof(unsigned int)) {
80002ab8:	00300693          	li	a3,3
80002abc:	40e60833          	sub	a6,a2,a4
80002ac0:	0306e663          	bltu	a3,a6,80002aec <memcpy+0x70>
80002ac4:	00265713          	srli	a4,a2,0x2
80002ac8:	ffc00693          	li	a3,-4
80002acc:	02d706b3          	mul	a3,a4,a3
80002ad0:	00271713          	slli	a4,a4,0x2
80002ad4:	00e787b3          	add	a5,a5,a4
80002ad8:	00e585b3          	add	a1,a1,a4
80002adc:	00d60633          	add	a2,a2,a3
80002ae0:	fadff06f          	j	80002a8c <memcpy+0x10>
	unsigned char *d_byte = (unsigned char *)d;
80002ae4:	00050793          	mv	a5,a0
80002ae8:	fc9ff06f          	j	80002ab0 <memcpy+0x34>
			*(d_word++) = *(s_word++);
80002aec:	00e588b3          	add	a7,a1,a4
80002af0:	0008a883          	lw	a7,0(a7)
80002af4:	00e78833          	add	a6,a5,a4
80002af8:	00470713          	addi	a4,a4,4
80002afc:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80002b00:	fbdff06f          	j	80002abc <memcpy+0x40>
		*(d_byte++) = *(s_byte++);
80002b04:	00e58833          	add	a6,a1,a4
80002b08:	00084803          	lbu	a6,0(a6)
80002b0c:	00e786b3          	add	a3,a5,a4
80002b10:	00170713          	addi	a4,a4,1
80002b14:	01068023          	sb	a6,0(a3)
		n--;
80002b18:	f79ff06f          	j	80002a90 <memcpy+0x14>

80002b1c <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002b1c:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002b20:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002b24:	0037f713          	andi	a4,a5,3
80002b28:	04071863          	bnez	a4,80002b78 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002b2c:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002b30:	00859713          	slli	a4,a1,0x8
80002b34:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002b38:	01059713          	slli	a4,a1,0x10
80002b3c:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002b40:	00c78333          	add	t1,a5,a2
80002b44:	00078713          	mv	a4,a5
80002b48:	00300813          	li	a6,3
80002b4c:	40e308b3          	sub	a7,t1,a4
80002b50:	03186e63          	bltu	a6,a7,80002b8c <memset+0x70>
80002b54:	00265713          	srli	a4,a2,0x2
80002b58:	00271593          	slli	a1,a4,0x2
80002b5c:	00b787b3          	add	a5,a5,a1
80002b60:	ffc00593          	li	a1,-4
80002b64:	02b70733          	mul	a4,a4,a1
80002b68:	00c70733          	add	a4,a4,a2
80002b6c:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002b70:	02e79463          	bne	a5,a4,80002b98 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002b74:	00008067          	ret
		if (n == 0) {
80002b78:	fe060ee3          	beqz	a2,80002b74 <memset+0x58>
		*(d_byte++) = c_byte;
80002b7c:	00178793          	addi	a5,a5,1
80002b80:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002b84:	fff60613          	addi	a2,a2,-1
80002b88:	f9dff06f          	j	80002b24 <memset+0x8>
		*(d_word++) = c_word;
80002b8c:	00470713          	addi	a4,a4,4
80002b90:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002b94:	fb9ff06f          	j	80002b4c <memset+0x30>
		*(d_byte++) = c_byte;
80002b98:	00178793          	addi	a5,a5,1
80002b9c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002ba0:	fd1ff06f          	j	80002b70 <memset+0x54>

80002ba4 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002ba4:	fff00513          	li	a0,-1
80002ba8:	00008067          	ret

80002bac <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002bac:	800087b7          	lui	a5,0x80008
80002bb0:	8aa7a823          	sw	a0,-1872(a5) # 800078b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b1>
}
80002bb4:	00008067          	ret

80002bb8 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002bb8:	fe010113          	addi	sp,sp,-32
80002bbc:	00812c23          	sw	s0,24(sp)
	test->setup();
80002bc0:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002bc4:	80008437          	lui	s0,0x80008
{
80002bc8:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002bcc:	8b440413          	addi	s0,s0,-1868 # 800078b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b5>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002bd0:	800084b7          	lui	s1,0x80008
{
80002bd4:	00112e23          	sw	ra,28(sp)
80002bd8:	01212823          	sw	s2,16(sp)
80002bdc:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002be0:	95848493          	addi	s1,s1,-1704 # 80007958 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007959>
80002be4:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002be8:	00042023          	sw	zero,0(s0)
{
80002bec:	00050913          	mv	s2,a0
	test_result = 1;
80002bf0:	0134a023          	sw	s3,0(s1)
	test->setup();
80002bf4:	000780e7          	jalr	a5
	test->test();
80002bf8:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002bfc:	01342023          	sw	s3,0(s0)
	test->test();
80002c00:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002c04:	00200793          	li	a5,2
80002c08:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002c0c:	00c92783          	lw	a5,12(s2)
80002c10:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002c14:	00300793          	li	a5,3
80002c18:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002c1c:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002c20:	0004a023          	sw	zero,0(s1)
}
80002c24:	01c12083          	lw	ra,28(sp)
80002c28:	01412483          	lw	s1,20(sp)
80002c2c:	01012903          	lw	s2,16(sp)
80002c30:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002c34:	80008537          	lui	a0,0x80008
80002c38:	b8050513          	addi	a0,a0,-1152 # 80007b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b81>
80002c3c:	02010113          	addi	sp,sp,32
80002c40:	4a00206f          	j	800050e0 <z_impl_k_sem_give>

80002c44 <ztest_test_fail>:
80002c44:	80008537          	lui	a0,0x80008
{
80002c48:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002c4c:	800087b7          	lui	a5,0x80008
80002c50:	fff00713          	li	a4,-1
80002c54:	b8050513          	addi	a0,a0,-1152 # 80007b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b81>
{
80002c58:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002c5c:	94e7ac23          	sw	a4,-1704(a5) # 80007958 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007959>
80002c60:	480020ef          	jal	ra,800050e0 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002c64:	3a8020ef          	jal	ra,8000500c <z_impl_k_current_get>
}
80002c68:	00c12083          	lw	ra,12(sp)
80002c6c:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002c70:	3950206f          	j	80005804 <z_impl_k_thread_abort>

80002c74 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002c74:	fa010113          	addi	sp,sp,-96
80002c78:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002c7c:	800084b7          	lui	s1,0x80008
80002c80:	95c4a783          	lw	a5,-1700(s1) # 8000795c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000795d>
{
80002c84:	04112e23          	sw	ra,92(sp)
80002c88:	04812c23          	sw	s0,88(sp)
80002c8c:	05212823          	sw	s2,80(sp)
80002c90:	05312623          	sw	s3,76(sp)
80002c94:	05412423          	sw	s4,72(sp)
80002c98:	05512223          	sw	s5,68(sp)
80002c9c:	05612023          	sw	s6,64(sp)
80002ca0:	03712e23          	sw	s7,60(sp)
80002ca4:	03812c23          	sw	s8,56(sp)
80002ca8:	03912a23          	sw	s9,52(sp)
80002cac:	03a12823          	sw	s10,48(sp)
80002cb0:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80002cb4:	0807c463          	bltz	a5,80002d3c <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002cb8:	80008437          	lui	s0,0x80008
80002cbc:	00100613          	li	a2,1
80002cc0:	00050993          	mv	s3,a0
80002cc4:	00058c13          	mv	s8,a1
80002cc8:	b8040513          	addi	a0,s0,-1152 # 80007b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b81>
80002ccc:	00000593          	li	a1,0
80002cd0:	348020ef          	jal	ra,80005018 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80002cd4:	80007537          	lui	a0,0x80007
80002cd8:	00098593          	mv	a1,s3
80002cdc:	34c50513          	addi	a0,a0,844 # 8000734c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000734d>
80002ce0:	ffcff0ef          	jal	ra,800024dc <printk>
	PRINT_LINE;
80002ce4:	80007937          	lui	s2,0x80007
80002ce8:	36490513          	addi	a0,s2,868 # 80007364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007365>
		Z_TC_END_RESULT(ret, test->name);
80002cec:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
80002cf0:	fecff0ef          	jal	ra,800024dc <printk>
80002cf4:	95c48493          	addi	s1,s1,-1700
	int fail = 0;
80002cf8:	00000a13          	li	s4,0
80002cfc:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002d00:	80008cb7          	lui	s9,0x80008
80002d04:	80008b37          	lui	s6,0x80008
80002d08:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
80002d0c:	80008db7          	lui	s11,0x80008
80002d10:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
80002d14:	304a8a93          	addi	s5,s5,772 # 80007304 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007305>
	while (suite->test) {
80002d18:	004c2783          	lw	a5,4(s8)
80002d1c:	04079e63          	bnez	a5,80002d78 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002d20:	00098593          	mv	a1,s3
	if (fail) {
80002d24:	100a0663          	beqz	s4,80002e30 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002d28:	80007537          	lui	a0,0x80007
80002d2c:	3d450513          	addi	a0,a0,980 # 800073d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073d5>
80002d30:	facff0ef          	jal	ra,800024dc <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002d34:	00100793          	li	a5,1
80002d38:	00f4a023          	sw	a5,0(s1)
}
80002d3c:	05c12083          	lw	ra,92(sp)
80002d40:	05812403          	lw	s0,88(sp)
80002d44:	05412483          	lw	s1,84(sp)
80002d48:	05012903          	lw	s2,80(sp)
80002d4c:	04c12983          	lw	s3,76(sp)
80002d50:	04812a03          	lw	s4,72(sp)
80002d54:	04412a83          	lw	s5,68(sp)
80002d58:	04012b03          	lw	s6,64(sp)
80002d5c:	03c12b83          	lw	s7,60(sp)
80002d60:	03812c03          	lw	s8,56(sp)
80002d64:	03412c83          	lw	s9,52(sp)
80002d68:	03012d03          	lw	s10,48(sp)
80002d6c:	02c12d83          	lw	s11,44(sp)
80002d70:	06010113          	addi	sp,sp,96
80002d74:	00008067          	ret
	TC_START(test->name);
80002d78:	000c2583          	lw	a1,0(s8)
80002d7c:	800077b7          	lui	a5,0x80007
80002d80:	3ac78513          	addi	a0,a5,940 # 800073ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ad>
80002d84:	f58ff0ef          	jal	ra,800024dc <printk>
80002d88:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002d8c:	010c2783          	lw	a5,16(s8)
80002d90:	000c0713          	mv	a4,s8
80002d94:	40000613          	li	a2,1024
80002d98:	0087e793          	ori	a5,a5,8
80002d9c:	fff00893          	li	a7,-1
80002da0:	00000813          	li	a6,0
80002da4:	bb8d0693          	addi	a3,s10,-1096 # 80002bb8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002bb9>
80002da8:	00f12023          	sw	a5,0(sp)
80002dac:	310c8593          	addi	a1,s9,784 # 80008310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008311>
80002db0:	00000793          	li	a5,0
80002db4:	b90b0513          	addi	a0,s6,-1136 # 80007b90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007b91>
80002db8:	0a9020ef          	jal	ra,80005660 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002dbc:	01c12783          	lw	a5,28(sp)
80002dc0:	fff00593          	li	a1,-1
80002dc4:	b8078513          	addi	a0,a5,-1152
80002dc8:	3fc020ef          	jal	ra,800051c4 <z_impl_k_sem_take>
	if (test_result == -1) {
80002dcc:	958d8793          	addi	a5,s11,-1704 # 80007958 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007959>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002dd0:	b90b0513          	addi	a0,s6,-1136
80002dd4:	0007a403          	lw	s0,0(a5)
80002dd8:	22d020ef          	jal	ra,80005804 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002ddc:	800087b7          	lui	a5,0x80008
80002de0:	95878793          	addi	a5,a5,-1704 # 80007958 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007959>
80002de4:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002de8:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002dec:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002df0:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002df4:	000c2603          	lw	a2,0(s8)
80002df8:	02f71463          	bne	a4,a5,80002e20 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002dfc:	800075b7          	lui	a1,0x80007
80002e00:	3c058593          	addi	a1,a1,960 # 800073c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073c1>
		Z_TC_END_RESULT(ret, test->name);
80002e04:	3c8b8513          	addi	a0,s7,968 # 800073c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073c9>
80002e08:	ed4ff0ef          	jal	ra,800024dc <printk>
80002e0c:	36490513          	addi	a0,s2,868
80002e10:	eccff0ef          	jal	ra,800024dc <printk>
		fail += run_test(suite);
80002e14:	008a0a33          	add	s4,s4,s0
		suite++;
80002e18:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002e1c:	efdff06f          	j	80002d18 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002e20:	00241793          	slli	a5,s0,0x2
80002e24:	00fa87b3          	add	a5,s5,a5
80002e28:	0007a583          	lw	a1,0(a5)
80002e2c:	fd9ff06f          	j	80002e04 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002e30:	80007537          	lui	a0,0x80007
80002e34:	3ec50513          	addi	a0,a0,1004 # 800073ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073ed>
80002e38:	ea4ff0ef          	jal	ra,800024dc <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002e3c:	0004a783          	lw	a5,0(s1)
80002e40:	00f037b3          	snez	a5,a5
80002e44:	ef5ff06f          	j	80002d38 <z_ztest_run_test_suite+0xc4>

80002e48 <end_report>:

void end_report(void)
{
	if (test_status) {
80002e48:	800087b7          	lui	a5,0x80008
80002e4c:	95c7a783          	lw	a5,-1700(a5) # 8000795c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000795d>
{
80002e50:	ff010113          	addi	sp,sp,-16
80002e54:	00812423          	sw	s0,8(sp)
80002e58:	80007537          	lui	a0,0x80007
80002e5c:	00112623          	sw	ra,12(sp)
80002e60:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80002e64:	36450513          	addi	a0,a0,868 # 80007364 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007365>
	if (test_status) {
80002e68:	02078263          	beqz	a5,80002e8c <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002e6c:	e70ff0ef          	jal	ra,800024dc <printk>
80002e70:	800075b7          	lui	a1,0x80007
80002e74:	31058593          	addi	a1,a1,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
	} else {
		TC_END_REPORT(TC_PASS);
80002e78:	31840513          	addi	a0,s0,792 # 80007318 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007319>
	}
}
80002e7c:	00812403          	lw	s0,8(sp)
80002e80:	00c12083          	lw	ra,12(sp)
80002e84:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002e88:	e54ff06f          	j	800024dc <printk>
80002e8c:	e50ff0ef          	jal	ra,800024dc <printk>
80002e90:	800075b7          	lui	a1,0x80007
80002e94:	33058593          	addi	a1,a1,816 # 80007330 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007331>
80002e98:	fe1ff06f          	j	80002e78 <end_report+0x30>

80002e9c <main>:

	return test_status;
}
#else
void main(void)
{
80002e9c:	ff010113          	addi	sp,sp,-16
80002ea0:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002ea4:	855fd0ef          	jal	ra,800006f8 <test_main>
	end_report();
}
80002ea8:	00c12083          	lw	ra,12(sp)
80002eac:	01010113          	addi	sp,sp,16
	end_report();
80002eb0:	f99ff06f          	j	80002e48 <end_report>

80002eb4 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002eb4:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002eb8:	00012623          	sw	zero,12(sp)
    i++;
80002ebc:	00c12783          	lw	a5,12(sp)
80002ec0:	00178793          	addi	a5,a5,1
80002ec4:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002ec8:	f00107b7          	lui	a5,0xf0010
80002ecc:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002ed0:	01010113          	addi	sp,sp,16
80002ed4:	00008067          	ret

80002ed8 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002ed8:	fff00513          	li	a0,-1
80002edc:	00008067          	ret

80002ee0 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002ee0:	00000513          	li	a0,0
80002ee4:	00008067          	ret

80002ee8 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002ee8:	00251713          	slli	a4,a0,0x2
80002eec:	800077b7          	lui	a5,0x80007
80002ef0:	00150513          	addi	a0,a0,1
80002ef4:	41c78793          	addi	a5,a5,1052 # 8000741c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000741d>
80002ef8:	00251513          	slli	a0,a0,0x2
{
80002efc:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002f00:	00e78733          	add	a4,a5,a4
80002f04:	00a787b3          	add	a5,a5,a0
{
80002f08:	00812423          	sw	s0,8(sp)
80002f0c:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002f10:	00072403          	lw	s0,0(a4)
80002f14:	0007a483          	lw	s1,0(a5)
{
80002f18:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002f1c:	00946c63          	bltu	s0,s1,80002f34 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002f20:	00c12083          	lw	ra,12(sp)
80002f24:	00812403          	lw	s0,8(sp)
80002f28:	00412483          	lw	s1,4(sp)
80002f2c:	01010113          	addi	sp,sp,16
80002f30:	00008067          	ret
		retval = device_conf->init(info);
80002f34:	00042783          	lw	a5,0(s0)
80002f38:	00040513          	mv	a0,s0
80002f3c:	0047a783          	lw	a5,4(a5)
80002f40:	000780e7          	jalr	a5
		if (retval != 0) {
80002f44:	00050463          	beqz	a0,80002f4c <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002f48:	00042223          	sw	zero,4(s0)
								info++) {
80002f4c:	00c40413          	addi	s0,s0,12
80002f50:	fcdff06f          	j	80002f1c <z_sys_device_do_config_level+0x34>

80002f54 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002f54:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002f58:	800087b7          	lui	a5,0x80008
{
80002f5c:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002f60:	800084b7          	lui	s1,0x80008
{
80002f64:	00812423          	sw	s0,8(sp)
80002f68:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002f6c:	8c878413          	addi	s0,a5,-1848 # 800078c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c9>
{
80002f70:	01212023          	sw	s2,0(sp)
80002f74:	8c878793          	addi	a5,a5,-1848
80002f78:	8f848493          	addi	s1,s1,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002f7c:	00941c63          	bne	s0,s1,80002f94 <z_impl_device_get_binding+0x40>
80002f80:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002f84:	00078413          	mv	s0,a5
80002f88:	02941463          	bne	s0,s1,80002fb0 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002f8c:	00000413          	li	s0,0
80002f90:	0440006f          	j	80002fd4 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002f94:	00442703          	lw	a4,4(s0)
80002f98:	00070863          	beqz	a4,80002fa8 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002f9c:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002fa0:	00072703          	lw	a4,0(a4)
80002fa4:	02a70863          	beq	a4,a0,80002fd4 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002fa8:	00c40413          	addi	s0,s0,12
80002fac:	fd1ff06f          	j	80002f7c <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002fb0:	00442783          	lw	a5,4(s0)
80002fb4:	00079663          	bnez	a5,80002fc0 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002fb8:	00c40413          	addi	s0,s0,12
80002fbc:	fcdff06f          	j	80002f88 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002fc0:	00042783          	lw	a5,0(s0)
80002fc4:	00090513          	mv	a0,s2
80002fc8:	0007a583          	lw	a1,0(a5)
80002fcc:	a8dff0ef          	jal	ra,80002a58 <strcmp>
80002fd0:	fe0514e3          	bnez	a0,80002fb8 <z_impl_device_get_binding+0x64>
}
80002fd4:	00040513          	mv	a0,s0
80002fd8:	00c12083          	lw	ra,12(sp)
80002fdc:	00812403          	lw	s0,8(sp)
80002fe0:	00412483          	lw	s1,4(sp)
80002fe4:	00012903          	lw	s2,0(sp)
80002fe8:	01010113          	addi	sp,sp,16
80002fec:	00008067          	ret

80002ff0 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002ff0:	ff010113          	addi	sp,sp,-16
80002ff4:	00812423          	sw	s0,8(sp)
80002ff8:	00912223          	sw	s1,4(sp)
80002ffc:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003000:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80003004:	00200493          	li	s1,2
80003008:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
8000300c:	4dd020ef          	jal	ra,80005ce8 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80003010:	00a4c463          	blt	s1,a0,80003018 <idle+0x28>
80003014:	00100513          	li	a0,1
80003018:	00100593          	li	a1,1
8000301c:	5a9020ef          	jal	ra,80005dc4 <z_set_timeout_expiry>
	k_cpu_idle();
80003020:	d2cff0ef          	jal	ra,8000254c <k_cpu_idle>
80003024:	fe5ff06f          	j	80003008 <idle+0x18>

80003028 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80003028:	80008537          	lui	a0,0x80008
8000302c:	800087b7          	lui	a5,0x80008
80003030:	93850613          	addi	a2,a0,-1736 # 80007938 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007939>
80003034:	d0c78793          	addi	a5,a5,-756 # 80007d0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d0d>
80003038:	40c78633          	sub	a2,a5,a2
8000303c:	00000593          	li	a1,0
80003040:	93850513          	addi	a0,a0,-1736
80003044:	ad9ff06f          	j	80002b1c <memset>

80003048 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80003048:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
8000304c:	00200513          	li	a0,2
{
80003050:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80003054:	e95ff0ef          	jal	ra,80002ee8 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80003058:	80007537          	lui	a0,0x80007
8000305c:	43050513          	addi	a0,a0,1072 # 80007430 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007431>
80003060:	c7cff0ef          	jal	ra,800024dc <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80003064:	00300513          	li	a0,3
80003068:	e81ff0ef          	jal	ra,80002ee8 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
8000306c:	6e8020ef          	jal	ra,80005754 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80003070:	e2dff0ef          	jal	ra,80002e9c <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80003074:	800087b7          	lui	a5,0x80008
80003078:	c7078793          	addi	a5,a5,-912 # 80007c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c71>
8000307c:	00c7c703          	lbu	a4,12(a5)
80003080:	ffe77713          	andi	a4,a4,-2
80003084:	00e78623          	sb	a4,12(a5)
}
80003088:	00c12083          	lw	ra,12(sp)
8000308c:	01010113          	addi	sp,sp,16
80003090:	00008067          	ret

80003094 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80003094:	f6010113          	addi	sp,sp,-160
80003098:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
8000309c:	800097b7          	lui	a5,0x80009
800030a0:	80008437          	lui	s0,0x80008
800030a4:	09312623          	sw	s3,140(sp)
800030a8:	31078793          	addi	a5,a5,784 # 80009310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80009311>
800030ac:	ce040993          	addi	s3,s0,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
800030b0:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800030b4:	01010793          	addi	a5,sp,16
800030b8:	07000613          	li	a2,112
800030bc:	00000593          	li	a1,0
800030c0:	00078513          	mv	a0,a5
{
800030c4:	08112e23          	sw	ra,156(sp)
800030c8:	08912a23          	sw	s1,148(sp)
800030cc:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800030d0:	a4dff0ef          	jal	ra,80002b1c <memset>
800030d4:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800030d8:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800030dc:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
800030e0:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800030e4:	e05ff0ef          	jal	ra,80002ee8 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800030e8:	00100513          	li	a0,1
800030ec:	dfdff0ef          	jal	ra,80002ee8 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800030f0:	10100793          	li	a5,257
800030f4:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800030f8:	2c1010ef          	jal	ra,80004bb8 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800030fc:	800077b7          	lui	a5,0x80007
80003100:	47478793          	addi	a5,a5,1140 # 80007474 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007475>
	_kernel.ready_q.cache = _main_thread;
80003104:	80008937          	lui	s2,0x80008
	z_setup_new_thread(_main_thread, _main_stack,
80003108:	00f12223          	sw	a5,4(sp)
8000310c:	800036b7          	lui	a3,0x80003
80003110:	00100793          	li	a5,1
80003114:	800085b7          	lui	a1,0x80008
	_kernel.ready_q.cache = _main_thread;
80003118:	c7090493          	addi	s1,s2,-912 # 80007c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c71>
	z_setup_new_thread(_main_thread, _main_stack,
8000311c:	00f12023          	sw	a5,0(sp)
80003120:	00000713          	li	a4,0
80003124:	00000793          	li	a5,0
80003128:	00000893          	li	a7,0
8000312c:	00000813          	li	a6,0
80003130:	04868693          	addi	a3,a3,72 # 80003048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003049>
80003134:	20000613          	li	a2,512
80003138:	71058593          	addi	a1,a1,1808 # 80008710 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008711>
8000313c:	c7090513          	addi	a0,s2,-912
	_kernel.ready_q.cache = _main_thread;
80003140:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80003144:	28c020ef          	jal	ra,800053d0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003148:	00d4c783          	lbu	a5,13(s1)
8000314c:	ce040413          	addi	s0,s0,-800
80003150:	ffb7f713          	andi	a4,a5,-5
80003154:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003158:	01b7f793          	andi	a5,a5,27
8000315c:	00079a63          	bnez	a5,80003170 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80003160:	0184a783          	lw	a5,24(s1)
80003164:	00079663          	bnez	a5,80003170 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80003168:	c7090513          	addi	a0,s2,-912
8000316c:	02c010ef          	jal	ra,80004198 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80003170:	800077b7          	lui	a5,0x80007
80003174:	47c78793          	addi	a5,a5,1148 # 8000747c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000747d>
80003178:	00f12223          	sw	a5,4(sp)
8000317c:	80008537          	lui	a0,0x80008
80003180:	00100793          	li	a5,1
80003184:	800036b7          	lui	a3,0x80003
80003188:	800095b7          	lui	a1,0x80009
8000318c:	c0050493          	addi	s1,a0,-1024 # 80007c00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007c01>
80003190:	00f12023          	sw	a5,0(sp)
80003194:	00f00893          	li	a7,15
80003198:	00000813          	li	a6,0
8000319c:	00000793          	li	a5,0
800031a0:	00000713          	li	a4,0
800031a4:	ff068693          	addi	a3,a3,-16 # 80002ff0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002ff1>
800031a8:	20000613          	li	a2,512
800031ac:	91058593          	addi	a1,a1,-1776 # 80008910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80008911>
800031b0:	c0050513          	addi	a0,a0,-1024
800031b4:	21c020ef          	jal	ra,800053d0 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800031b8:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800031bc:	00942623          	sw	s1,12(s0)
800031c0:	00800513          	li	a0,8
800031c4:	ffb7f793          	andi	a5,a5,-5
800031c8:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800031cc:	800087b7          	lui	a5,0x80008
800031d0:	cf878793          	addi	a5,a5,-776 # 80007cf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf9>
800031d4:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800031d8:	00f42e23          	sw	a5,28(s0)
800031dc:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800031e0:	00857513          	andi	a0,a0,8
800031e4:	854fd0ef          	jal	ra,80000238 <__swap>

800031e8 <prepare_thread_to_run>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800031e8:	00d54783          	lbu	a5,13(a0)
}
#endif

#if !defined(CONFIG_POLL)
static void prepare_thread_to_run(struct k_thread *thread, void *data)
{
800031ec:	fe010113          	addi	sp,sp,-32
800031f0:	00812c23          	sw	s0,24(sp)
800031f4:	00112e23          	sw	ra,28(sp)
800031f8:	01f7f793          	andi	a5,a5,31
800031fc:	00050413          	mv	s0,a0
80003200:	00079c63          	bnez	a5,80003218 <prepare_thread_to_run+0x30>
	if (z_is_thread_ready(thread)) {
80003204:	01852783          	lw	a5,24(a0)
80003208:	00079863          	bnez	a5,80003218 <prepare_thread_to_run+0x30>
8000320c:	00b12623          	sw	a1,12(sp)
		z_add_thread_to_ready_q(thread);
80003210:	789000ef          	jal	ra,80004198 <z_add_thread_to_ready_q>
80003214:	00c12583          	lw	a1,12(sp)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80003218:	06042623          	sw	zero,108(s0)
	thread->base.swap_data = data;
8000321c:	00b42a23          	sw	a1,20(s0)
	z_ready_thread(thread);
	z_set_thread_return_value_with_data(thread, 0, data);
}
80003220:	01c12083          	lw	ra,28(sp)
80003224:	01812403          	lw	s0,24(sp)
80003228:	02010113          	addi	sp,sp,32
8000322c:	00008067          	ret

80003230 <queue_insert>:
			       struct k_queue *);
#endif

static s32_t queue_insert(struct k_queue *queue, void *prev, void *data,
			  bool alloc)
{
80003230:	fe010113          	addi	sp,sp,-32
80003234:	00812c23          	sw	s0,24(sp)
80003238:	00912a23          	sw	s1,20(sp)
8000323c:	01212823          	sw	s2,16(sp)
80003240:	01312623          	sw	s3,12(sp)
80003244:	01412423          	sw	s4,8(sp)
80003248:	01612023          	sw	s6,0(sp)
8000324c:	00112e23          	sw	ra,28(sp)
80003250:	01512223          	sw	s5,4(sp)
80003254:	00050413          	mv	s0,a0
80003258:	00058993          	mv	s3,a1
8000325c:	00060a13          	mv	s4,a2
80003260:	00068b13          	mv	s6,a3
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003264:	00850913          	addi	s2,a0,8
80003268:	00800493          	li	s1,8
8000326c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003270:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003274:	0084f493          	andi	s1,s1,8
80003278:	224020ef          	jal	ra,8000549c <z_spin_lock_valid>
8000327c:	02051e63          	bnez	a0,800032b8 <queue_insert+0x88>
80003280:	80007ab7          	lui	s5,0x80007
80003284:	800075b7          	lui	a1,0x80007
80003288:	80007537          	lui	a0,0x80007
8000328c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003290:	04e00693          	li	a3,78
80003294:	290a8613          	addi	a2,s5,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003298:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000329c:	a40ff0ef          	jal	ra,800024dc <printk>
800032a0:	80007537          	lui	a0,0x80007
800032a4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800032a8:	a34ff0ef          	jal	ra,800024dc <printk>
800032ac:	04e00593          	li	a1,78
800032b0:	290a8513          	addi	a0,s5,656
800032b4:	a64ff0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800032b8:	00090513          	mv	a0,s2
800032bc:	238020ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *first_pending_thread;

	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
800032c0:	00c40513          	addi	a0,s0,12
800032c4:	6d4010ef          	jal	ra,80004998 <z_unpend_first_thread>

	if (first_pending_thread != NULL) {
800032c8:	02050063          	beqz	a0,800032e8 <queue_insert+0xb8>
		prepare_thread_to_run(first_pending_thread, data);
800032cc:	000a0593          	mv	a1,s4
800032d0:	f19ff0ef          	jal	ra,800031e8 <prepare_thread_to_run>

#if defined(CONFIG_POLL)
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* CONFIG_POLL */

	z_reschedule(&queue->lock, key);
800032d4:	00090513          	mv	a0,s2
800032d8:	00048593          	mv	a1,s1
800032dc:	071000ef          	jal	ra,80003b4c <z_reschedule>
	return 0;
800032e0:	00000513          	li	a0,0
800032e4:	0600006f          	j	80003344 <queue_insert+0x114>
	if (alloc) {
800032e8:	0a0b0e63          	beqz	s6,800033a4 <queue_insert+0x174>
		anode = z_thread_malloc(sizeof(*anode));
800032ec:	00800513          	li	a0,8
800032f0:	354030ef          	jal	ra,80006644 <z_thread_malloc>
		if (anode == NULL) {
800032f4:	06051c63          	bnez	a0,8000336c <queue_insert+0x13c>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032f8:	00090513          	mv	a0,s2
800032fc:	1c8020ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003300:	02051e63          	bnez	a0,8000333c <queue_insert+0x10c>
80003304:	80007437          	lui	s0,0x80007
80003308:	800075b7          	lui	a1,0x80007
8000330c:	80007537          	lui	a0,0x80007
80003310:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003314:	06100693          	li	a3,97
80003318:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
8000331c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003320:	9bcff0ef          	jal	ra,800024dc <printk>
80003324:	80007537          	lui	a0,0x80007
80003328:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
8000332c:	9b0ff0ef          	jal	ra,800024dc <printk>
80003330:	06100593          	li	a1,97
80003334:	29040513          	addi	a0,s0,656
80003338:	9e0ff0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000333c:	3004a4f3          	csrrs	s1,mstatus,s1
			return -ENOMEM;
80003340:	ff400513          	li	a0,-12
}
80003344:	01c12083          	lw	ra,28(sp)
80003348:	01812403          	lw	s0,24(sp)
8000334c:	01412483          	lw	s1,20(sp)
80003350:	01012903          	lw	s2,16(sp)
80003354:	00c12983          	lw	s3,12(sp)
80003358:	00812a03          	lw	s4,8(sp)
8000335c:	00412a83          	lw	s5,4(sp)
80003360:	00012b03          	lw	s6,0(sp)
80003364:	02010113          	addi	sp,sp,32
80003368:	00008067          	ret
	node->next_and_flags = flags;
8000336c:	00100793          	li	a5,1
		anode->data = data;
80003370:	01452223          	sw	s4,4(a0)
80003374:	00f52023          	sw	a5,0(a0)
 */
static inline void sys_sflist_insert(sys_sflist_t *list,
				     sys_sfnode_t *prev,
				     sys_sfnode_t *node);

Z_GENLIST_INSERT(sflist, sfnode)
80003378:	00052783          	lw	a5,0(a0)
8000337c:	0037f793          	andi	a5,a5,3
80003380:	02099863          	bnez	s3,800033b0 <queue_insert+0x180>
	parent->next_and_flags = cur_flags | (unative_t)child;
80003384:	00042703          	lw	a4,0(s0)
80003388:	00f767b3          	or	a5,a4,a5
8000338c:	00f52023          	sw	a5,0(a0)
Z_GENLIST_PREPEND(sflist, sfnode)
80003390:	00442783          	lw	a5,4(s0)
	list->head = node;
80003394:	00a42023          	sw	a0,0(s0)
Z_GENLIST_PREPEND(sflist, sfnode)
80003398:	f2079ee3          	bnez	a5,800032d4 <queue_insert+0xa4>
	list->tail = node;
8000339c:	00a42223          	sw	a0,4(s0)
800033a0:	f35ff06f          	j	800032d4 <queue_insert+0xa4>
	node->next_and_flags = flags;
800033a4:	000a2023          	sw	zero,0(s4)
800033a8:	000a0513          	mv	a0,s4
800033ac:	fcdff06f          	j	80003378 <queue_insert+0x148>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
800033b0:	0009a703          	lw	a4,0(s3)
800033b4:	ffc77713          	andi	a4,a4,-4
Z_GENLIST_INSERT(sflist, sfnode)
800033b8:	02071863          	bnez	a4,800033e8 <queue_insert+0x1b8>
Z_GENLIST_APPEND(sflist, sfnode)
800033bc:	00442703          	lw	a4,4(s0)
	parent->next_and_flags = cur_flags | (unative_t)child;
800033c0:	00f52023          	sw	a5,0(a0)
Z_GENLIST_APPEND(sflist, sfnode)
800033c4:	00071863          	bnez	a4,800033d4 <queue_insert+0x1a4>
	list->tail = node;
800033c8:	00a42223          	sw	a0,4(s0)
	list->head = node;
800033cc:	00a42023          	sw	a0,0(s0)
800033d0:	f05ff06f          	j	800032d4 <queue_insert+0xa4>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800033d4:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
800033d8:	0037f793          	andi	a5,a5,3
800033dc:	00f567b3          	or	a5,a0,a5
800033e0:	00f72023          	sw	a5,0(a4)
800033e4:	fb9ff06f          	j	8000339c <queue_insert+0x16c>
800033e8:	00e7e7b3          	or	a5,a5,a4
800033ec:	00f52023          	sw	a5,0(a0)
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
800033f0:	0009a783          	lw	a5,0(s3)
	parent->next_and_flags = cur_flags | (unative_t)child;
800033f4:	0037f793          	andi	a5,a5,3
800033f8:	00f56533          	or	a0,a0,a5
800033fc:	00a9a023          	sw	a0,0(s3)
80003400:	ed5ff06f          	j	800032d4 <queue_insert+0xa4>

80003404 <z_queue_node_peek>:
{
80003404:	ff010113          	addi	sp,sp,-16
80003408:	00812423          	sw	s0,8(sp)
8000340c:	00112623          	sw	ra,12(sp)
80003410:	00050413          	mv	s0,a0
	if ((node != NULL) && (sys_sfnode_flags_get(node) != (u8_t)0)) {
80003414:	00050e63          	beqz	a0,80003430 <z_queue_node_peek+0x2c>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003418:	00052783          	lw	a5,0(a0)
8000341c:	0037f793          	andi	a5,a5,3
80003420:	00078863          	beqz	a5,80003430 <z_queue_node_peek+0x2c>
		ret = anode->data;
80003424:	00452403          	lw	s0,4(a0)
		if (needs_free) {
80003428:	00058463          	beqz	a1,80003430 <z_queue_node_peek+0x2c>
			k_free(anode);
8000342c:	208030ef          	jal	ra,80006634 <k_free>
}
80003430:	00040513          	mv	a0,s0
80003434:	00c12083          	lw	ra,12(sp)
80003438:	00812403          	lw	s0,8(sp)
8000343c:	01010113          	addi	sp,sp,16
80003440:	00008067          	ret

80003444 <z_impl_k_queue_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80003444:	00c50793          	addi	a5,a0,12
	list->head = NULL;
80003448:	00052023          	sw	zero,0(a0)
	list->tail = NULL;
8000344c:	00052223          	sw	zero,4(a0)
	queue->lock = (struct k_spinlock) {};
80003450:	00052423          	sw	zero,8(a0)
	list->head = (sys_dnode_t *)list;
80003454:	00f52623          	sw	a5,12(a0)
	list->tail = (sys_dnode_t *)list;
80003458:	00f52823          	sw	a5,16(a0)
}
8000345c:	00008067          	ret

80003460 <z_impl_k_queue_cancel_wait>:
{
80003460:	fe010113          	addi	sp,sp,-32
80003464:	00812c23          	sw	s0,24(sp)
80003468:	00912a23          	sw	s1,20(sp)
8000346c:	01212823          	sw	s2,16(sp)
80003470:	00112e23          	sw	ra,28(sp)
80003474:	01312623          	sw	s3,12(sp)
80003478:	00050913          	mv	s2,a0
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
8000347c:	00850493          	addi	s1,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003480:	00800413          	li	s0,8
80003484:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003488:	00048513          	mv	a0,s1
	key = (mstatus & SOC_MSTATUS_IEN);
8000348c:	00847413          	andi	s0,s0,8
80003490:	00c020ef          	jal	ra,8000549c <z_spin_lock_valid>
80003494:	02051e63          	bnez	a0,800034d0 <z_impl_k_queue_cancel_wait+0x70>
80003498:	800079b7          	lui	s3,0x80007
8000349c:	800075b7          	lui	a1,0x80007
800034a0:	80007537          	lui	a0,0x80007
800034a4:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800034a8:	04e00693          	li	a3,78
800034ac:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800034b0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800034b4:	828ff0ef          	jal	ra,800024dc <printk>
800034b8:	80007537          	lui	a0,0x80007
800034bc:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800034c0:	81cff0ef          	jal	ra,800024dc <printk>
800034c4:	04e00593          	li	a1,78
800034c8:	29098513          	addi	a0,s3,656
800034cc:	84cff0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800034d0:	00048513          	mv	a0,s1
800034d4:	020020ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	first_pending_thread = z_unpend_first_thread(&queue->wait_q);
800034d8:	00c90513          	addi	a0,s2,12
800034dc:	4bc010ef          	jal	ra,80004998 <z_unpend_first_thread>
	if (first_pending_thread != NULL) {
800034e0:	00050663          	beqz	a0,800034ec <z_impl_k_queue_cancel_wait+0x8c>
		prepare_thread_to_run(first_pending_thread, NULL);
800034e4:	00000593          	li	a1,0
800034e8:	d01ff0ef          	jal	ra,800031e8 <prepare_thread_to_run>
	z_reschedule(&queue->lock, key);
800034ec:	00040593          	mv	a1,s0
}
800034f0:	01812403          	lw	s0,24(sp)
800034f4:	01c12083          	lw	ra,28(sp)
800034f8:	01012903          	lw	s2,16(sp)
800034fc:	00c12983          	lw	s3,12(sp)
	z_reschedule(&queue->lock, key);
80003500:	00048513          	mv	a0,s1
}
80003504:	01412483          	lw	s1,20(sp)
80003508:	02010113          	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
8000350c:	6400006f          	j	80003b4c <z_reschedule>

80003510 <k_queue_append>:
	(void)queue_insert(queue, prev, data, false);
}

void k_queue_append(struct k_queue *queue, void *data)
{
	(void)queue_insert(queue, sys_sflist_peek_tail(&queue->data_q),
80003510:	00058613          	mv	a2,a1
80003514:	00452583          	lw	a1,4(a0)
80003518:	00000693          	li	a3,0
8000351c:	d15ff06f          	j	80003230 <queue_insert>

80003520 <k_queue_append_list>:
					   (void *)data);
}
#endif

void k_queue_append_list(struct k_queue *queue, void *head, void *tail)
{
80003520:	fe010113          	addi	sp,sp,-32
80003524:	00812c23          	sw	s0,24(sp)
80003528:	01212823          	sw	s2,16(sp)
8000352c:	01412423          	sw	s4,8(sp)
80003530:	00112e23          	sw	ra,28(sp)
80003534:	00912a23          	sw	s1,20(sp)
80003538:	01312623          	sw	s3,12(sp)
8000353c:	01512223          	sw	s5,4(sp)
80003540:	00050913          	mv	s2,a0
80003544:	00058413          	mv	s0,a1
80003548:	00060a13          	mv	s4,a2
	__ASSERT(head && tail, "invalid head or tail");
8000354c:	00058463          	beqz	a1,80003554 <k_queue_append_list+0x34>
80003550:	02061e63          	bnez	a2,8000358c <k_queue_append_list+0x6c>
80003554:	800074b7          	lui	s1,0x80007
80003558:	800075b7          	lui	a1,0x80007
8000355c:	80007537          	lui	a0,0x80007
80003560:	49858593          	addi	a1,a1,1176 # 80007498 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007499>
80003564:	0ed00693          	li	a3,237
80003568:	48448613          	addi	a2,s1,1156 # 80007484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007485>
8000356c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003570:	f6dfe0ef          	jal	ra,800024dc <printk>
80003574:	80007537          	lui	a0,0x80007
80003578:	4a850513          	addi	a0,a0,1192 # 800074a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074a9>
8000357c:	f61fe0ef          	jal	ra,800024dc <printk>
80003580:	0ed00593          	li	a1,237
80003584:	48448513          	addi	a0,s1,1156
80003588:	f91fe0ef          	jal	ra,80002518 <assert_post_action>

	k_spinlock_key_t key = k_spin_lock(&queue->lock);
8000358c:	00890993          	addi	s3,s2,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003590:	00800493          	li	s1,8
80003594:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003598:	00098513          	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
8000359c:	0084f493          	andi	s1,s1,8
800035a0:	6fd010ef          	jal	ra,8000549c <z_spin_lock_valid>
800035a4:	02051e63          	bnez	a0,800035e0 <k_queue_append_list+0xc0>
800035a8:	80007ab7          	lui	s5,0x80007
800035ac:	800075b7          	lui	a1,0x80007
800035b0:	80007537          	lui	a0,0x80007
800035b4:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800035b8:	04e00693          	li	a3,78
800035bc:	290a8613          	addi	a2,s5,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800035c0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800035c4:	f19fe0ef          	jal	ra,800024dc <printk>
800035c8:	80007537          	lui	a0,0x80007
800035cc:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800035d0:	f0dfe0ef          	jal	ra,800024dc <printk>
800035d4:	04e00593          	li	a1,78
800035d8:	290a8513          	addi	a0,s5,656
800035dc:	f3dfe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800035e0:	00098513          	mv	a0,s3
800035e4:	711010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
#if !defined(CONFIG_POLL)
	struct k_thread *thread = NULL;

	if (head != NULL) {
800035e8:	04040063          	beqz	s0,80003628 <k_queue_append_list+0x108>
		thread = z_unpend_first_thread(&queue->wait_q);
800035ec:	00c90a93          	addi	s5,s2,12
800035f0:	000a8513          	mv	a0,s5
800035f4:	3a4010ef          	jal	ra,80004998 <z_unpend_first_thread>
	}

	while ((head != NULL) && (thread != NULL)) {
800035f8:	00051c63          	bnez	a0,80003610 <k_queue_append_list+0xf0>
Z_GENLIST_APPEND_LIST(sflist, sfnode)
800035fc:	00492703          	lw	a4,4(s2)
80003600:	04071a63          	bnez	a4,80003654 <k_queue_append_list+0x134>
	list->head = node;
80003604:	00892023          	sw	s0,0(s2)
	list->tail = node;
80003608:	01492223          	sw	s4,4(s2)
8000360c:	01c0006f          	j	80003628 <k_queue_append_list+0x108>
		prepare_thread_to_run(thread, head);
80003610:	00040593          	mv	a1,s0
80003614:	bd5ff0ef          	jal	ra,800031e8 <prepare_thread_to_run>
		head = *(void **)head;
80003618:	00042403          	lw	s0,0(s0)
		thread = z_unpend_first_thread(&queue->wait_q);
8000361c:	000a8513          	mv	a0,s5
80003620:	378010ef          	jal	ra,80004998 <z_unpend_first_thread>
	while ((head != NULL) && (thread != NULL)) {
80003624:	fc041ae3          	bnez	s0,800035f8 <k_queue_append_list+0xd8>
	sys_sflist_append_list(&queue->data_q, head, tail);
	handle_poll_events(queue, K_POLL_STATE_DATA_AVAILABLE);
#endif /* !CONFIG_POLL */

	z_reschedule(&queue->lock, key);
}
80003628:	01812403          	lw	s0,24(sp)
8000362c:	01c12083          	lw	ra,28(sp)
80003630:	01012903          	lw	s2,16(sp)
80003634:	00812a03          	lw	s4,8(sp)
80003638:	00412a83          	lw	s5,4(sp)
	z_reschedule(&queue->lock, key);
8000363c:	00048593          	mv	a1,s1
80003640:	00098513          	mv	a0,s3
}
80003644:	01412483          	lw	s1,20(sp)
80003648:	00c12983          	lw	s3,12(sp)
8000364c:	02010113          	addi	sp,sp,32
	z_reschedule(&queue->lock, key);
80003650:	4fc0006f          	j	80003b4c <z_reschedule>
	return node->next_and_flags & SYS_SFLIST_FLAGS_MASK;
80003654:	00072783          	lw	a5,0(a4)
	parent->next_and_flags = cur_flags | (unative_t)child;
80003658:	0037f793          	andi	a5,a5,3
8000365c:	00f46433          	or	s0,s0,a5
80003660:	00872023          	sw	s0,0(a4)
80003664:	fa5ff06f          	j	80003608 <k_queue_append_list+0xe8>

80003668 <k_queue_merge_slist>:

void k_queue_merge_slist(struct k_queue *queue, sys_slist_t *list)
{
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80003668:	0005a783          	lw	a5,0(a1)
{
8000366c:	ff010113          	addi	sp,sp,-16
80003670:	00812423          	sw	s0,8(sp)
80003674:	01212023          	sw	s2,0(sp)
80003678:	00112623          	sw	ra,12(sp)
8000367c:	00912223          	sw	s1,4(sp)
80003680:	00050913          	mv	s2,a0
80003684:	00058413          	mv	s0,a1
	__ASSERT(!sys_slist_is_empty(list), "list must not be empty");
80003688:	02079e63          	bnez	a5,800036c4 <k_queue_merge_slist+0x5c>
8000368c:	800074b7          	lui	s1,0x80007
80003690:	800075b7          	lui	a1,0x80007
80003694:	80007537          	lui	a0,0x80007
80003698:	4c058593          	addi	a1,a1,1216 # 800074c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074c1>
8000369c:	10b00693          	li	a3,267
800036a0:	48448613          	addi	a2,s1,1156 # 80007484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007485>
800036a4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800036a8:	e35fe0ef          	jal	ra,800024dc <printk>
800036ac:	80007537          	lui	a0,0x80007
800036b0:	4dc50513          	addi	a0,a0,1244 # 800074dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074dd>
800036b4:	e29fe0ef          	jal	ra,800024dc <printk>
800036b8:	10b00593          	li	a1,267
800036bc:	48448513          	addi	a0,s1,1156
800036c0:	e59fe0ef          	jal	ra,80002518 <assert_post_action>
	 * - list->tail->next = NULL.
	 * - sflist implementation only differs from slist by stuffing
	 *   flag bytes in the lower order bits of the data pointer
	 * - source list is really an slist and not an sflist with flags set
	 */
	k_queue_append_list(queue, list->head, list->tail);
800036c4:	00442603          	lw	a2,4(s0)
800036c8:	00042583          	lw	a1,0(s0)
800036cc:	00090513          	mv	a0,s2
800036d0:	e51ff0ef          	jal	ra,80003520 <k_queue_append_list>
	sys_slist_init(list);
}
800036d4:	00c12083          	lw	ra,12(sp)
	list->head = NULL;
800036d8:	00042023          	sw	zero,0(s0)
	list->tail = NULL;
800036dc:	00042223          	sw	zero,4(s0)
800036e0:	00812403          	lw	s0,8(sp)
800036e4:	00412483          	lw	s1,4(sp)
800036e8:	00012903          	lw	s2,0(sp)
800036ec:	01010113          	addi	sp,sp,16
800036f0:	00008067          	ret

800036f4 <z_impl_k_queue_get>:
	return val;
}
#endif /* CONFIG_POLL */

void *z_impl_k_queue_get(struct k_queue *queue, s32_t timeout)
{
800036f4:	fe010113          	addi	sp,sp,-32
800036f8:	00812c23          	sw	s0,24(sp)
800036fc:	00912a23          	sw	s1,20(sp)
80003700:	01212823          	sw	s2,16(sp)
80003704:	01312623          	sw	s3,12(sp)
80003708:	00112e23          	sw	ra,28(sp)
8000370c:	01412423          	sw	s4,8(sp)
80003710:	00050493          	mv	s1,a0
80003714:	00058993          	mv	s3,a1
	k_spinlock_key_t key = k_spin_lock(&queue->lock);
80003718:	00850913          	addi	s2,a0,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000371c:	00800413          	li	s0,8
80003720:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003724:	00090513          	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80003728:	00847413          	andi	s0,s0,8
8000372c:	571010ef          	jal	ra,8000549c <z_spin_lock_valid>
80003730:	02051e63          	bnez	a0,8000376c <z_impl_k_queue_get+0x78>
80003734:	80007a37          	lui	s4,0x80007
80003738:	800075b7          	lui	a1,0x80007
8000373c:	80007537          	lui	a0,0x80007
80003740:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003744:	04e00693          	li	a3,78
80003748:	290a0613          	addi	a2,s4,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
8000374c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003750:	d8dfe0ef          	jal	ra,800024dc <printk>
80003754:	80007537          	lui	a0,0x80007
80003758:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
8000375c:	d81fe0ef          	jal	ra,800024dc <printk>
80003760:	04e00593          	li	a1,78
80003764:	290a0513          	addi	a0,s4,656
80003768:	db1fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
8000376c:	00090513          	mv	a0,s2
80003770:	585010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
Z_GENLIST_IS_EMPTY(sflist)
80003774:	0004a503          	lw	a0,0(s1)
	void *data;

	if (likely(!sys_sflist_is_empty(&queue->data_q))) {
80003778:	08050a63          	beqz	a0,8000380c <z_impl_k_queue_get+0x118>
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
8000377c:	00052783          	lw	a5,0(a0)
 *
 * @return A pointer to the first node of the list
 */
static inline sys_sfnode_t *sys_sflist_get_not_empty(sys_sflist_t *list);

Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
80003780:	0044a703          	lw	a4,4(s1)
	return (sys_sfnode_t *)(node->next_and_flags & ~SYS_SFLIST_FLAGS_MASK);
80003784:	ffc7f793          	andi	a5,a5,-4
	list->head = node;
80003788:	00f4a023          	sw	a5,0(s1)
Z_GENLIST_GET_NOT_EMPTY(sflist, sfnode)
8000378c:	00e51463          	bne	a0,a4,80003794 <z_impl_k_queue_get+0xa0>
	list->tail = node;
80003790:	00f4a223          	sw	a5,4(s1)
		sys_sfnode_t *node;

		node = sys_sflist_get_not_empty(&queue->data_q);
		data = z_queue_node_peek(node, true);
80003794:	00100593          	li	a1,1
80003798:	c6dff0ef          	jal	ra,80003404 <z_queue_node_peek>
8000379c:	00050493          	mv	s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800037a0:	00090513          	mv	a0,s2
800037a4:	521010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800037a8:	02051e63          	bnez	a0,800037e4 <z_impl_k_queue_get+0xf0>
800037ac:	80007937          	lui	s2,0x80007
800037b0:	800075b7          	lui	a1,0x80007
800037b4:	80007537          	lui	a0,0x80007
800037b8:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800037bc:	06100693          	li	a3,97
800037c0:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800037c4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800037c8:	d15fe0ef          	jal	ra,800024dc <printk>
800037cc:	80007537          	lui	a0,0x80007
800037d0:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800037d4:	d09fe0ef          	jal	ra,800024dc <printk>
800037d8:	06100593          	li	a1,97
800037dc:	29090513          	addi	a0,s2,656
800037e0:	d39fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037e4:	30042473          	csrrs	s0,mstatus,s0
#else
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);

	return (ret != 0) ? NULL : _current->base.swap_data;
#endif /* CONFIG_POLL */
}
800037e8:	01c12083          	lw	ra,28(sp)
800037ec:	01812403          	lw	s0,24(sp)
800037f0:	00048513          	mv	a0,s1
800037f4:	01012903          	lw	s2,16(sp)
800037f8:	01412483          	lw	s1,20(sp)
800037fc:	00c12983          	lw	s3,12(sp)
80003800:	00812a03          	lw	s4,8(sp)
80003804:	02010113          	addi	sp,sp,32
80003808:	00008067          	ret
	if (timeout == K_NO_WAIT) {
8000380c:	04099a63          	bnez	s3,80003860 <z_impl_k_queue_get+0x16c>
80003810:	00090513          	mv	a0,s2
80003814:	4b1010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003818:	02051e63          	bnez	a0,80003854 <z_impl_k_queue_get+0x160>
8000381c:	800074b7          	lui	s1,0x80007
80003820:	800075b7          	lui	a1,0x80007
80003824:	80007537          	lui	a0,0x80007
80003828:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
8000382c:	06100693          	li	a3,97
80003830:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003834:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003838:	ca5fe0ef          	jal	ra,800024dc <printk>
8000383c:	80007537          	lui	a0,0x80007
80003840:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003844:	c99fe0ef          	jal	ra,800024dc <printk>
80003848:	06100593          	li	a1,97
8000384c:	29048513          	addi	a0,s1,656
80003850:	cc9fe0ef          	jal	ra,80002518 <assert_post_action>
80003854:	30042473          	csrrs	s0,mstatus,s0
		return NULL;
80003858:	00000493          	li	s1,0
8000385c:	f8dff06f          	j	800037e8 <z_impl_k_queue_get+0xf4>
	int ret = z_pend_curr(&queue->lock, key, &queue->wait_q, timeout);
80003860:	00c48613          	addi	a2,s1,12
80003864:	00098693          	mv	a3,s3
80003868:	00040593          	mv	a1,s0
8000386c:	00090513          	mv	a0,s2
80003870:	0a0010ef          	jal	ra,80004910 <z_pend_curr>
	return (ret != 0) ? NULL : _current->base.swap_data;
80003874:	00000493          	li	s1,0
80003878:	f60518e3          	bnez	a0,800037e8 <z_impl_k_queue_get+0xf4>
8000387c:	800087b7          	lui	a5,0x80008
80003880:	ce87a783          	lw	a5,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
80003884:	0147a483          	lw	s1,20(a5)
80003888:	f61ff06f          	j	800037e8 <z_impl_k_queue_get+0xf4>

8000388c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000388c:	00d54783          	lbu	a5,13(a0)
80003890:	01f7f793          	andi	a5,a5,31
80003894:	00079863          	bnez	a5,800038a4 <z_is_thread_ready+0x18>
80003898:	01852503          	lw	a0,24(a0)
8000389c:	00153513          	seqz	a0,a0
800038a0:	00008067          	ret
800038a4:	00000513          	li	a0,0
}
800038a8:	00008067          	ret

800038ac <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800038ac:	ff010113          	addi	sp,sp,-16
800038b0:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800038b4:	8b4ff0ef          	jal	ra,80002968 <z_clock_elapsed>
800038b8:	800087b7          	lui	a5,0x80008
800038bc:	9687a783          	lw	a5,-1688(a5) # 80007968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007969>

	z_set_timeout_expiry(slice_time, false);
}
800038c0:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800038c4:	80008737          	lui	a4,0x80008
800038c8:	00a78533          	add	a0,a5,a0
800038cc:	cea72823          	sw	a0,-784(a4) # 80007cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf1>
	z_set_timeout_expiry(slice_time, false);
800038d0:	00000593          	li	a1,0
800038d4:	00078513          	mv	a0,a5
}
800038d8:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800038dc:	4e80206f          	j	80005dc4 <z_set_timeout_expiry>

800038e0 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800038e0:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800038e4:	ff010113          	addi	sp,sp,-16
800038e8:	00812423          	sw	s0,8(sp)
800038ec:	00112623          	sw	ra,12(sp)
800038f0:	00912223          	sw	s1,4(sp)
800038f4:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
800038f8:	02079863          	bnez	a5,80003928 <pended_on.isra.15+0x48>
800038fc:	800074b7          	lui	s1,0x80007
80003900:	800075b7          	lui	a1,0x80007
80003904:	80007537          	lui	a0,0x80007
80003908:	59058593          	addi	a1,a1,1424 # 80007590 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007591>
8000390c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003910:	18300693          	li	a3,387
80003914:	57c48613          	addi	a2,s1,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80003918:	bc5fe0ef          	jal	ra,800024dc <printk>
8000391c:	18300593          	li	a1,387
80003920:	57c48513          	addi	a0,s1,1404
80003924:	bf5fe0ef          	jal	ra,80002518 <assert_post_action>

	return thread->base.pended_on;
}
80003928:	00042503          	lw	a0,0(s0)
8000392c:	00c12083          	lw	ra,12(sp)
80003930:	00812403          	lw	s0,8(sp)
80003934:	00412483          	lw	s1,4(sp)
80003938:	01010113          	addi	sp,sp,16
8000393c:	00008067          	ret

80003940 <k_sched_time_slice_set>:
{
80003940:	fe010113          	addi	sp,sp,-32
80003944:	00812c23          	sw	s0,24(sp)
80003948:	01212823          	sw	s2,16(sp)
8000394c:	01412423          	sw	s4,8(sp)
80003950:	00112e23          	sw	ra,28(sp)
80003954:	00912a23          	sw	s1,20(sp)
80003958:	01312623          	sw	s3,12(sp)
8000395c:	00050913          	mv	s2,a0
80003960:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003964:	00800413          	li	s0,8
80003968:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000396c:	800084b7          	lui	s1,0x80008
80003970:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80003974:	00847413          	andi	s0,s0,8
80003978:	325010ef          	jal	ra,8000549c <z_spin_lock_valid>
8000397c:	02051e63          	bnez	a0,800039b8 <k_sched_time_slice_set+0x78>
80003980:	800079b7          	lui	s3,0x80007
80003984:	800075b7          	lui	a1,0x80007
80003988:	80007537          	lui	a0,0x80007
8000398c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003990:	04e00693          	li	a3,78
80003994:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003998:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000399c:	b41fe0ef          	jal	ra,800024dc <printk>
800039a0:	80007537          	lui	a0,0x80007
800039a4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800039a8:	b35fe0ef          	jal	ra,800024dc <printk>
800039ac:	04e00593          	li	a1,78
800039b0:	29098513          	addi	a0,s3,656
800039b4:	b65fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800039b8:	96048513          	addi	a0,s1,-1696
800039bc:	339010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800039c0:	800087b7          	lui	a5,0x80008
800039c4:	ce07a823          	sw	zero,-784(a5) # 80007cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf1>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800039c8:	00990913          	addi	s2,s2,9
800039cc:	00a00793          	li	a5,10
800039d0:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
800039d4:	800087b7          	lui	a5,0x80008
800039d8:	9727a423          	sw	s2,-1688(a5) # 80007968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007969>
		slice_max_prio = prio;
800039dc:	800087b7          	lui	a5,0x80008
800039e0:	9747a223          	sw	s4,-1692(a5) # 80007964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007965>
		reset_time_slice();
800039e4:	ec9ff0ef          	jal	ra,800038ac <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800039e8:	96048513          	addi	a0,s1,-1696
800039ec:	2d9010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800039f0:	02051e63          	bnez	a0,80003a2c <k_sched_time_slice_set+0xec>
800039f4:	800074b7          	lui	s1,0x80007
800039f8:	800075b7          	lui	a1,0x80007
800039fc:	80007537          	lui	a0,0x80007
80003a00:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003a04:	06100693          	li	a3,97
80003a08:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003a0c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003a10:	acdfe0ef          	jal	ra,800024dc <printk>
80003a14:	80007537          	lui	a0,0x80007
80003a18:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003a1c:	ac1fe0ef          	jal	ra,800024dc <printk>
80003a20:	06100593          	li	a1,97
80003a24:	29048513          	addi	a0,s1,656
80003a28:	af1fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003a2c:	30042473          	csrrs	s0,mstatus,s0
}
80003a30:	01c12083          	lw	ra,28(sp)
80003a34:	01812403          	lw	s0,24(sp)
80003a38:	01412483          	lw	s1,20(sp)
80003a3c:	01012903          	lw	s2,16(sp)
80003a40:	00c12983          	lw	s3,12(sp)
80003a44:	00812a03          	lw	s4,8(sp)
80003a48:	02010113          	addi	sp,sp,32
80003a4c:	00008067          	ret

80003a50 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003a50:	fe010113          	addi	sp,sp,-32
80003a54:	00812c23          	sw	s0,24(sp)
80003a58:	01212823          	sw	s2,16(sp)
80003a5c:	00112e23          	sw	ra,28(sp)
80003a60:	00912a23          	sw	s1,20(sp)
80003a64:	01312623          	sw	s3,12(sp)
80003a68:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a6c:	00800413          	li	s0,8
80003a70:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a74:	800084b7          	lui	s1,0x80008
80003a78:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a7c:	00847413          	andi	s0,s0,8
80003a80:	21d010ef          	jal	ra,8000549c <z_spin_lock_valid>
80003a84:	02051e63          	bnez	a0,80003ac0 <z_unpend_thread_no_timeout+0x70>
80003a88:	800079b7          	lui	s3,0x80007
80003a8c:	800075b7          	lui	a1,0x80007
80003a90:	80007537          	lui	a0,0x80007
80003a94:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003a98:	04e00693          	li	a3,78
80003a9c:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003aa0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003aa4:	a39fe0ef          	jal	ra,800024dc <printk>
80003aa8:	80007537          	lui	a0,0x80007
80003aac:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80003ab0:	a2dfe0ef          	jal	ra,800024dc <printk>
80003ab4:	04e00593          	li	a1,78
80003ab8:	29098513          	addi	a0,s3,656
80003abc:	a5dfe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ac0:	96048513          	addi	a0,s1,-1696
80003ac4:	231010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003ac8:	00890513          	addi	a0,s2,8
80003acc:	e15ff0ef          	jal	ra,800038e0 <pended_on.isra.15>
80003ad0:	00090593          	mv	a1,s2
80003ad4:	2f0000ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003ad8:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003adc:	96048513          	addi	a0,s1,-1696
80003ae0:	ffd7f793          	andi	a5,a5,-3
80003ae4:	00f906a3          	sb	a5,13(s2)
80003ae8:	1dd010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003aec:	02051e63          	bnez	a0,80003b28 <z_unpend_thread_no_timeout+0xd8>
80003af0:	800074b7          	lui	s1,0x80007
80003af4:	800075b7          	lui	a1,0x80007
80003af8:	80007537          	lui	a0,0x80007
80003afc:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003b00:	06100693          	li	a3,97
80003b04:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003b08:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003b0c:	9d1fe0ef          	jal	ra,800024dc <printk>
80003b10:	80007537          	lui	a0,0x80007
80003b14:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003b18:	9c5fe0ef          	jal	ra,800024dc <printk>
80003b1c:	06100593          	li	a1,97
80003b20:	29048513          	addi	a0,s1,656
80003b24:	9f5fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b28:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003b2c:	01c12083          	lw	ra,28(sp)
80003b30:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003b34:	00092423          	sw	zero,8(s2)
}
80003b38:	01412483          	lw	s1,20(sp)
80003b3c:	01012903          	lw	s2,16(sp)
80003b40:	00c12983          	lw	s3,12(sp)
80003b44:	02010113          	addi	sp,sp,32
80003b48:	00008067          	ret

80003b4c <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003b4c:	800087b7          	lui	a5,0x80008
80003b50:	ce07a783          	lw	a5,-800(a5) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
80003b54:	ff010113          	addi	sp,sp,-16
80003b58:	00812423          	sw	s0,8(sp)
80003b5c:	00112623          	sw	ra,12(sp)
80003b60:	00912223          	sw	s1,4(sp)
80003b64:	00058413          	mv	s0,a1
	if (resched()) {
80003b68:	04079e63          	bnez	a5,80003bc4 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b6c:	159010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003b70:	02051e63          	bnez	a0,80003bac <z_reschedule+0x60>
80003b74:	800074b7          	lui	s1,0x80007
80003b78:	800075b7          	lui	a1,0x80007
80003b7c:	80007537          	lui	a0,0x80007
80003b80:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003b84:	07800693          	li	a3,120
80003b88:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003b8c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003b90:	94dfe0ef          	jal	ra,800024dc <printk>
80003b94:	80007537          	lui	a0,0x80007
80003b98:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003b9c:	941fe0ef          	jal	ra,800024dc <printk>
80003ba0:	07800593          	li	a1,120
80003ba4:	29048513          	addi	a0,s1,656
80003ba8:	971fe0ef          	jal	ra,80002518 <assert_post_action>
80003bac:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80003bb0:	00812403          	lw	s0,8(sp)
80003bb4:	00c12083          	lw	ra,12(sp)
80003bb8:	00412483          	lw	s1,4(sp)
80003bbc:	01010113          	addi	sp,sp,16
80003bc0:	e78fc06f          	j	80000238 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bc4:	101010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003bc8:	02051e63          	bnez	a0,80003c04 <z_reschedule+0xb8>
80003bcc:	800074b7          	lui	s1,0x80007
80003bd0:	800075b7          	lui	a1,0x80007
80003bd4:	80007537          	lui	a0,0x80007
80003bd8:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003bdc:	06100693          	li	a3,97
80003be0:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003be4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003be8:	8f5fe0ef          	jal	ra,800024dc <printk>
80003bec:	80007537          	lui	a0,0x80007
80003bf0:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003bf4:	8e9fe0ef          	jal	ra,800024dc <printk>
80003bf8:	06100593          	li	a1,97
80003bfc:	29048513          	addi	a0,s1,656
80003c00:	919fe0ef          	jal	ra,80002518 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80003c04:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c08:	30042473          	csrrs	s0,mstatus,s0
80003c0c:	00c12083          	lw	ra,12(sp)
80003c10:	00812403          	lw	s0,8(sp)
80003c14:	00412483          	lw	s1,4(sp)
80003c18:	01010113          	addi	sp,sp,16
80003c1c:	00008067          	ret

80003c20 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003c20:	80008737          	lui	a4,0x80008
80003c24:	ce072703          	lw	a4,-800(a4) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80003c28:	00071463          	bnez	a4,80003c30 <z_reschedule_irqlock+0x10>
80003c2c:	e0cfc06f          	j	80000238 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003c30:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c34:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80003c38:	00008067          	ret

80003c3c <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c3c:	00800513          	li	a0,8
80003c40:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003c44:	00857513          	andi	a0,a0,8
80003c48:	fd9ff06f          	j	80003c20 <z_reschedule_irqlock>

80003c4c <k_sched_lock>:

void k_sched_lock(void)
{
80003c4c:	fe010113          	addi	sp,sp,-32
80003c50:	00812c23          	sw	s0,24(sp)
80003c54:	00112e23          	sw	ra,28(sp)
80003c58:	00912a23          	sw	s1,20(sp)
80003c5c:	01212823          	sw	s2,16(sp)
80003c60:	01312623          	sw	s3,12(sp)
80003c64:	00800413          	li	s0,8
80003c68:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c6c:	800084b7          	lui	s1,0x80008
80003c70:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c74:	00847413          	andi	s0,s0,8
80003c78:	025010ef          	jal	ra,8000549c <z_spin_lock_valid>
80003c7c:	02051e63          	bnez	a0,80003cb8 <k_sched_lock+0x6c>
80003c80:	80007937          	lui	s2,0x80007
80003c84:	800075b7          	lui	a1,0x80007
80003c88:	80007537          	lui	a0,0x80007
80003c8c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003c90:	04e00693          	li	a3,78
80003c94:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003c98:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003c9c:	841fe0ef          	jal	ra,800024dc <printk>
80003ca0:	80007537          	lui	a0,0x80007
80003ca4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80003ca8:	835fe0ef          	jal	ra,800024dc <printk>
80003cac:	04e00593          	li	a1,78
80003cb0:	29090513          	addi	a0,s2,656
80003cb4:	865fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80003cb8:	96048513          	addi	a0,s1,-1696
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003cbc:	80008937          	lui	s2,0x80008
80003cc0:	035010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
80003cc4:	ce092783          	lw	a5,-800(s2) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80003cc8:	ce090913          	addi	s2,s2,-800
80003ccc:	02078e63          	beqz	a5,80003d08 <k_sched_lock+0xbc>
80003cd0:	800079b7          	lui	s3,0x80007
80003cd4:	800075b7          	lui	a1,0x80007
80003cd8:	80007537          	lui	a0,0x80007
80003cdc:	51458593          	addi	a1,a1,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80003ce0:	10000693          	li	a3,256
80003ce4:	4f898613          	addi	a2,s3,1272 # 800074f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074f9>
80003ce8:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003cec:	ff0fe0ef          	jal	ra,800024dc <printk>
80003cf0:	80007537          	lui	a0,0x80007
80003cf4:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80003cf8:	fe4fe0ef          	jal	ra,800024dc <printk>
80003cfc:	10000593          	li	a1,256
80003d00:	4f898513          	addi	a0,s3,1272
80003d04:	815fe0ef          	jal	ra,80002518 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80003d08:	00892783          	lw	a5,8(s2)
80003d0c:	00f7c703          	lbu	a4,15(a5)
80003d10:	00100793          	li	a5,1
80003d14:	02f71e63          	bne	a4,a5,80003d50 <k_sched_lock+0x104>
80003d18:	800079b7          	lui	s3,0x80007
80003d1c:	800075b7          	lui	a1,0x80007
80003d20:	80007537          	lui	a0,0x80007
80003d24:	52c58593          	addi	a1,a1,1324 # 8000752c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000752d>
80003d28:	10100693          	li	a3,257
80003d2c:	4f898613          	addi	a2,s3,1272 # 800074f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800074f9>
80003d30:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003d34:	fa8fe0ef          	jal	ra,800024dc <printk>
80003d38:	80007537          	lui	a0,0x80007
80003d3c:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80003d40:	f9cfe0ef          	jal	ra,800024dc <printk>
80003d44:	10100593          	li	a1,257
80003d48:	4f898513          	addi	a0,s3,1272
80003d4c:	fccfe0ef          	jal	ra,80002518 <assert_post_action>

	--_current->base.sched_locked;
80003d50:	00892703          	lw	a4,8(s2)
80003d54:	00f74783          	lbu	a5,15(a4)
80003d58:	fff78793          	addi	a5,a5,-1
80003d5c:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d60:	96048513          	addi	a0,s1,-1696
80003d64:	760010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003d68:	02051e63          	bnez	a0,80003da4 <k_sched_lock+0x158>
80003d6c:	800074b7          	lui	s1,0x80007
80003d70:	800075b7          	lui	a1,0x80007
80003d74:	80007537          	lui	a0,0x80007
80003d78:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003d7c:	06100693          	li	a3,97
80003d80:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003d84:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003d88:	f54fe0ef          	jal	ra,800024dc <printk>
80003d8c:	80007537          	lui	a0,0x80007
80003d90:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003d94:	f48fe0ef          	jal	ra,800024dc <printk>
80003d98:	06100593          	li	a1,97
80003d9c:	29048513          	addi	a0,s1,656
80003da0:	f78fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003da4:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80003da8:	01c12083          	lw	ra,28(sp)
80003dac:	01812403          	lw	s0,24(sp)
80003db0:	01412483          	lw	s1,20(sp)
80003db4:	01012903          	lw	s2,16(sp)
80003db8:	00c12983          	lw	s3,12(sp)
80003dbc:	02010113          	addi	sp,sp,32
80003dc0:	00008067          	ret

80003dc4 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003dc4:	800087b7          	lui	a5,0x80008
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003dc8:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80003dcc:	ff010113          	addi	sp,sp,-16
80003dd0:	00812423          	sw	s0,8(sp)
80003dd4:	00112623          	sw	ra,12(sp)
80003dd8:	00912223          	sw	s1,4(sp)
80003ddc:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80003de0:	02f59863          	bne	a1,a5,80003e10 <z_priq_dumb_remove+0x4c>
80003de4:	800074b7          	lui	s1,0x80007
80003de8:	800075b7          	lui	a1,0x80007
80003dec:	80007537          	lui	a0,0x80007
80003df0:	61458593          	addi	a1,a1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
80003df4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003df8:	28c00693          	li	a3,652
80003dfc:	57c48613          	addi	a2,s1,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80003e00:	edcfe0ef          	jal	ra,800024dc <printk>
80003e04:	28c00593          	li	a1,652
80003e08:	57c48513          	addi	a0,s1,1404
80003e0c:	f0cfe0ef          	jal	ra,80002518 <assert_post_action>
	node->prev->next = node->next;
80003e10:	00442703          	lw	a4,4(s0)
80003e14:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80003e18:	00c12083          	lw	ra,12(sp)
80003e1c:	00412483          	lw	s1,4(sp)
80003e20:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003e24:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80003e28:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003e2c:	00042223          	sw	zero,4(s0)
80003e30:	00812403          	lw	s0,8(sp)
80003e34:	01010113          	addi	sp,sp,16
80003e38:	00008067          	ret

80003e3c <z_unpend_thread>:
{
80003e3c:	fe010113          	addi	sp,sp,-32
80003e40:	00812c23          	sw	s0,24(sp)
80003e44:	00912a23          	sw	s1,20(sp)
80003e48:	00112e23          	sw	ra,28(sp)
80003e4c:	01212823          	sw	s2,16(sp)
80003e50:	01312623          	sw	s3,12(sp)
80003e54:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e58:	00800493          	li	s1,8
80003e5c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e60:	80008937          	lui	s2,0x80008
80003e64:	96090513          	addi	a0,s2,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e68:	0084f493          	andi	s1,s1,8
80003e6c:	630010ef          	jal	ra,8000549c <z_spin_lock_valid>
80003e70:	02051e63          	bnez	a0,80003eac <z_unpend_thread+0x70>
80003e74:	800079b7          	lui	s3,0x80007
80003e78:	800075b7          	lui	a1,0x80007
80003e7c:	80007537          	lui	a0,0x80007
80003e80:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80003e84:	04e00693          	li	a3,78
80003e88:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003e8c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003e90:	e4cfe0ef          	jal	ra,800024dc <printk>
80003e94:	80007537          	lui	a0,0x80007
80003e98:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80003e9c:	e40fe0ef          	jal	ra,800024dc <printk>
80003ea0:	04e00593          	li	a1,78
80003ea4:	29098513          	addi	a0,s3,656
80003ea8:	e70fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80003eac:	96090513          	addi	a0,s2,-1696
80003eb0:	644010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003eb4:	00840513          	addi	a0,s0,8
80003eb8:	a29ff0ef          	jal	ra,800038e0 <pended_on.isra.15>
80003ebc:	00040593          	mv	a1,s0
80003ec0:	f05ff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003ec4:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ec8:	96090513          	addi	a0,s2,-1696
80003ecc:	ffd7f793          	andi	a5,a5,-3
80003ed0:	00f406a3          	sb	a5,13(s0)
80003ed4:	5f0010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80003ed8:	02051e63          	bnez	a0,80003f14 <z_unpend_thread+0xd8>
80003edc:	80007937          	lui	s2,0x80007
80003ee0:	800075b7          	lui	a1,0x80007
80003ee4:	80007537          	lui	a0,0x80007
80003ee8:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80003eec:	06100693          	li	a3,97
80003ef0:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80003ef4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003ef8:	de4fe0ef          	jal	ra,800024dc <printk>
80003efc:	80007537          	lui	a0,0x80007
80003f00:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80003f04:	dd8fe0ef          	jal	ra,800024dc <printk>
80003f08:	06100593          	li	a1,97
80003f0c:	29090513          	addi	a0,s2,656
80003f10:	e08fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f14:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003f18:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003f1c:	01840513          	addi	a0,s0,24
}
80003f20:	01812403          	lw	s0,24(sp)
80003f24:	01c12083          	lw	ra,28(sp)
80003f28:	01412483          	lw	s1,20(sp)
80003f2c:	01012903          	lw	s2,16(sp)
80003f30:	00c12983          	lw	s3,12(sp)
80003f34:	02010113          	addi	sp,sp,32
80003f38:	4b90106f          	j	80005bf0 <z_abort_timeout>

80003f3c <z_priq_dumb_best>:
	return list->head == list;
80003f3c:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f40:	00f51463          	bne	a0,a5,80003f48 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003f44:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003f48:	00078513          	mv	a0,a5
80003f4c:	00008067          	ret

80003f50 <update_cache>:
{
80003f50:	ff010113          	addi	sp,sp,-16
80003f54:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f58:	80008437          	lui	s0,0x80008
{
80003f5c:	01212023          	sw	s2,0(sp)
80003f60:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f64:	ce040513          	addi	a0,s0,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80003f68:	02450513          	addi	a0,a0,36
{
80003f6c:	00912223          	sw	s1,4(sp)
80003f70:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003f74:	fc9ff0ef          	jal	ra,80003f3c <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003f78:	ce040413          	addi	s0,s0,-800
80003f7c:	00050493          	mv	s1,a0
80003f80:	00051463          	bnez	a0,80003f88 <update_cache+0x38>
80003f84:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80003f88:	06091e63          	bnez	s2,80004004 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003f8c:	00842783          	lw	a5,8(s0)
80003f90:	02079e63          	bnez	a5,80003fcc <update_cache+0x7c>
80003f94:	80007937          	lui	s2,0x80007
80003f98:	800075b7          	lui	a1,0x80007
80003f9c:	80007537          	lui	a0,0x80007
80003fa0:	5a858593          	addi	a1,a1,1448 # 800075a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a9>
80003fa4:	07f00693          	li	a3,127
80003fa8:	57c90613          	addi	a2,s2,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80003fac:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80003fb0:	d2cfe0ef          	jal	ra,800024dc <printk>
80003fb4:	80007537          	lui	a0,0x80007
80003fb8:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80003fbc:	d20fe0ef          	jal	ra,800024dc <printk>
80003fc0:	07f00593          	li	a1,127
80003fc4:	57c90513          	addi	a0,s2,1404
80003fc8:	d50fe0ef          	jal	ra,80002518 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003fcc:	00842783          	lw	a5,8(s0)
80003fd0:	00d7c703          	lbu	a4,13(a5)
80003fd4:	01f77713          	andi	a4,a4,31
80003fd8:	02071663          	bnez	a4,80004004 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003fdc:	00e7d683          	lhu	a3,14(a5)
80003fe0:	07f00713          	li	a4,127
80003fe4:	02d77063          	bgeu	a4,a3,80004004 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003fe8:	02f42023          	sw	a5,32(s0)
}
80003fec:	00c12083          	lw	ra,12(sp)
80003ff0:	00812403          	lw	s0,8(sp)
80003ff4:	00412483          	lw	s1,4(sp)
80003ff8:	00012903          	lw	s2,0(sp)
80003ffc:	01010113          	addi	sp,sp,16
80004000:	00008067          	ret
		if (th != _current) {
80004004:	00842783          	lw	a5,8(s0)
80004008:	00978463          	beq	a5,s1,80004010 <update_cache+0xc0>
			reset_time_slice();
8000400c:	8a1ff0ef          	jal	ra,800038ac <reset_time_slice>
		_kernel.ready_q.cache = th;
80004010:	02942023          	sw	s1,32(s0)
}
80004014:	fd9ff06f          	j	80003fec <update_cache+0x9c>

80004018 <k_sched_unlock>:
{
80004018:	fe010113          	addi	sp,sp,-32
8000401c:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004020:	80008937          	lui	s2,0x80008
80004024:	ce090793          	addi	a5,s2,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80004028:	0087a783          	lw	a5,8(a5)
{
8000402c:	00112e23          	sw	ra,28(sp)
80004030:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80004034:	00f7c783          	lbu	a5,15(a5)
{
80004038:	00912a23          	sw	s1,20(sp)
8000403c:	01312623          	sw	s3,12(sp)
80004040:	ce090913          	addi	s2,s2,-800
	__ASSERT(_current->base.sched_locked != 0, "");
80004044:	02079e63          	bnez	a5,80004080 <k_sched_unlock+0x68>
80004048:	80007437          	lui	s0,0x80007
8000404c:	800075b7          	lui	a1,0x80007
80004050:	80007537          	lui	a0,0x80007
80004054:	55458593          	addi	a1,a1,1364 # 80007554 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007555>
80004058:	22100693          	li	a3,545
8000405c:	57c40613          	addi	a2,s0,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004060:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004064:	c78fe0ef          	jal	ra,800024dc <printk>
80004068:	80007537          	lui	a0,0x80007
8000406c:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80004070:	c6cfe0ef          	jal	ra,800024dc <printk>
80004074:	22100593          	li	a1,545
80004078:	57c40513          	addi	a0,s0,1404
8000407c:	c9cfe0ef          	jal	ra,80002518 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80004080:	00092783          	lw	a5,0(s2)
80004084:	02078e63          	beqz	a5,800040c0 <k_sched_unlock+0xa8>
80004088:	80007437          	lui	s0,0x80007
8000408c:	800075b7          	lui	a1,0x80007
80004090:	80007537          	lui	a0,0x80007
80004094:	51458593          	addi	a1,a1,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80004098:	22200693          	li	a3,546
8000409c:	57c40613          	addi	a2,s0,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
800040a0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800040a4:	c38fe0ef          	jal	ra,800024dc <printk>
800040a8:	80007537          	lui	a0,0x80007
800040ac:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
800040b0:	c2cfe0ef          	jal	ra,800024dc <printk>
800040b4:	22200593          	li	a1,546
800040b8:	57c40513          	addi	a0,s0,1404
800040bc:	c5cfe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040c0:	00800413          	li	s0,8
800040c4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040c8:	800084b7          	lui	s1,0x80008
800040cc:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
800040d0:	00847413          	andi	s0,s0,8
800040d4:	3c8010ef          	jal	ra,8000549c <z_spin_lock_valid>
800040d8:	02051e63          	bnez	a0,80004114 <k_sched_unlock+0xfc>
800040dc:	800079b7          	lui	s3,0x80007
800040e0:	800075b7          	lui	a1,0x80007
800040e4:	80007537          	lui	a0,0x80007
800040e8:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800040ec:	04e00693          	li	a3,78
800040f0:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800040f4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800040f8:	be4fe0ef          	jal	ra,800024dc <printk>
800040fc:	80007537          	lui	a0,0x80007
80004100:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004104:	bd8fe0ef          	jal	ra,800024dc <printk>
80004108:	04e00593          	li	a1,78
8000410c:	29098513          	addi	a0,s3,656
80004110:	c08fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004114:	96048513          	addi	a0,s1,-1696
80004118:	3dc010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
8000411c:	00892703          	lw	a4,8(s2)
		update_cache(1);
80004120:	00100513          	li	a0,1
		++_current->base.sched_locked;
80004124:	00f74783          	lbu	a5,15(a4)
80004128:	00178793          	addi	a5,a5,1
8000412c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80004130:	e21ff0ef          	jal	ra,80003f50 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004134:	96048513          	addi	a0,s1,-1696
80004138:	38c010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
8000413c:	02051e63          	bnez	a0,80004178 <k_sched_unlock+0x160>
80004140:	800074b7          	lui	s1,0x80007
80004144:	800075b7          	lui	a1,0x80007
80004148:	80007537          	lui	a0,0x80007
8000414c:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004150:	06100693          	li	a3,97
80004154:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004158:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000415c:	b80fe0ef          	jal	ra,800024dc <printk>
80004160:	80007537          	lui	a0,0x80007
80004164:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004168:	b74fe0ef          	jal	ra,800024dc <printk>
8000416c:	06100593          	li	a1,97
80004170:	29048513          	addi	a0,s1,656
80004174:	ba4fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004178:	30042473          	csrrs	s0,mstatus,s0
}
8000417c:	01812403          	lw	s0,24(sp)
80004180:	01c12083          	lw	ra,28(sp)
80004184:	01412483          	lw	s1,20(sp)
80004188:	01012903          	lw	s2,16(sp)
8000418c:	00c12983          	lw	s3,12(sp)
80004190:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80004194:	aa9ff06f          	j	80003c3c <z_reschedule_unlocked>

80004198 <z_add_thread_to_ready_q>:
{
80004198:	fe010113          	addi	sp,sp,-32
8000419c:	00812c23          	sw	s0,24(sp)
800041a0:	00912a23          	sw	s1,20(sp)
800041a4:	00112e23          	sw	ra,28(sp)
800041a8:	01212823          	sw	s2,16(sp)
800041ac:	01312623          	sw	s3,12(sp)
800041b0:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041b4:	00800493          	li	s1,8
800041b8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041bc:	80008937          	lui	s2,0x80008
800041c0:	96090513          	addi	a0,s2,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
800041c4:	0084f493          	andi	s1,s1,8
800041c8:	2d4010ef          	jal	ra,8000549c <z_spin_lock_valid>
800041cc:	02051e63          	bnez	a0,80004208 <z_add_thread_to_ready_q+0x70>
800041d0:	800079b7          	lui	s3,0x80007
800041d4:	800075b7          	lui	a1,0x80007
800041d8:	80007537          	lui	a0,0x80007
800041dc:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800041e0:	04e00693          	li	a3,78
800041e4:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800041e8:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800041ec:	af0fe0ef          	jal	ra,800024dc <printk>
800041f0:	80007537          	lui	a0,0x80007
800041f4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800041f8:	ae4fe0ef          	jal	ra,800024dc <printk>
800041fc:	04e00593          	li	a1,78
80004200:	29098513          	addi	a0,s3,656
80004204:	b14fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004208:	96090513          	addi	a0,s2,-1696
8000420c:	2e8010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80004210:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
80004214:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004218:	02f41863          	bne	s0,a5,80004248 <z_add_thread_to_ready_q+0xb0>
8000421c:	800079b7          	lui	s3,0x80007
80004220:	800075b7          	lui	a1,0x80007
80004224:	80007537          	lui	a0,0x80007
80004228:	61458593          	addi	a1,a1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
8000422c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004230:	27600693          	li	a3,630
80004234:	57c98613          	addi	a2,s3,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004238:	aa4fe0ef          	jal	ra,800024dc <printk>
8000423c:	27600593          	li	a1,630
80004240:	57c98513          	addi	a0,s3,1404
80004244:	ad4fe0ef          	jal	ra,80002518 <assert_post_action>
	return list->head == list;
80004248:	80008737          	lui	a4,0x80008
8000424c:	ce070693          	addi	a3,a4,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80004250:	0246a783          	lw	a5,36(a3)
80004254:	0286a603          	lw	a2,40(a3)
80004258:	800086b7          	lui	a3,0x80008
8000425c:	d0468693          	addi	a3,a3,-764 # 80007d04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d05>
80004260:	ce070713          	addi	a4,a4,-800
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004264:	0ad78663          	beq	a5,a3,80004310 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004268:	0a078463          	beqz	a5,80004310 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
8000426c:	00e40583          	lb	a1,14(s0)
80004270:	00e78503          	lb	a0,14(a5)
80004274:	08a5d863          	bge	a1,a0,80004304 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80004278:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000427c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004280:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004284:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004288:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
8000428c:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80004290:	00000513          	li	a0,0
80004294:	0407e793          	ori	a5,a5,64
80004298:	00f406a3          	sb	a5,13(s0)
8000429c:	cb5ff0ef          	jal	ra,80003f50 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042a0:	96090513          	addi	a0,s2,-1696
800042a4:	220010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800042a8:	02051e63          	bnez	a0,800042e4 <z_add_thread_to_ready_q+0x14c>
800042ac:	80007437          	lui	s0,0x80007
800042b0:	800075b7          	lui	a1,0x80007
800042b4:	80007537          	lui	a0,0x80007
800042b8:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800042bc:	06100693          	li	a3,97
800042c0:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800042c4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800042c8:	a14fe0ef          	jal	ra,800024dc <printk>
800042cc:	80007537          	lui	a0,0x80007
800042d0:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800042d4:	a08fe0ef          	jal	ra,800024dc <printk>
800042d8:	06100593          	li	a1,97
800042dc:	29040513          	addi	a0,s0,656
800042e0:	a38fe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042e4:	3004a4f3          	csrrs	s1,mstatus,s1
}
800042e8:	01c12083          	lw	ra,28(sp)
800042ec:	01812403          	lw	s0,24(sp)
800042f0:	01412483          	lw	s1,20(sp)
800042f4:	01012903          	lw	s2,16(sp)
800042f8:	00c12983          	lw	s3,12(sp)
800042fc:	02010113          	addi	sp,sp,32
80004300:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80004304:	00f60663          	beq	a2,a5,80004310 <z_add_thread_to_ready_q+0x178>
80004308:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000430c:	f60792e3          	bnez	a5,80004270 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80004310:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80004314:	02872783          	lw	a5,40(a4)
	node->next = list;
80004318:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
8000431c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004320:	02872423          	sw	s0,40(a4)
80004324:	f69ff06f          	j	8000428c <z_add_thread_to_ready_q+0xf4>

80004328 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80004328:	ff052783          	lw	a5,-16(a0)
{
8000432c:	fe010113          	addi	sp,sp,-32
80004330:	00812c23          	sw	s0,24(sp)
80004334:	01312623          	sw	s3,12(sp)
80004338:	00112e23          	sw	ra,28(sp)
8000433c:	00912a23          	sw	s1,20(sp)
80004340:	01212823          	sw	s2,16(sp)
80004344:	01412423          	sw	s4,8(sp)
80004348:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
8000434c:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80004350:	0c078463          	beqz	a5,80004418 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004354:	00800493          	li	s1,8
80004358:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000435c:	80008937          	lui	s2,0x80008
80004360:	96090513          	addi	a0,s2,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80004364:	0084f493          	andi	s1,s1,8
80004368:	134010ef          	jal	ra,8000549c <z_spin_lock_valid>
8000436c:	02051e63          	bnez	a0,800043a8 <z_thread_timeout+0x80>
80004370:	80007a37          	lui	s4,0x80007
80004374:	800075b7          	lui	a1,0x80007
80004378:	80007537          	lui	a0,0x80007
8000437c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80004380:	04e00693          	li	a3,78
80004384:	290a0613          	addi	a2,s4,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004388:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000438c:	950fe0ef          	jal	ra,800024dc <printk>
80004390:	80007537          	lui	a0,0x80007
80004394:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004398:	944fe0ef          	jal	ra,800024dc <printk>
8000439c:	04e00593          	li	a1,78
800043a0:	290a0513          	addi	a0,s4,656
800043a4:	974fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800043a8:	96090513          	addi	a0,s2,-1696
800043ac:	148010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800043b0:	ff040513          	addi	a0,s0,-16
800043b4:	d2cff0ef          	jal	ra,800038e0 <pended_on.isra.15>
800043b8:	00098593          	mv	a1,s3
800043bc:	a09ff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800043c0:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800043c4:	96090513          	addi	a0,s2,-1696
800043c8:	ffd7f793          	andi	a5,a5,-3
800043cc:	fef40aa3          	sb	a5,-11(s0)
800043d0:	0f4010ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800043d4:	02051e63          	bnez	a0,80004410 <z_thread_timeout+0xe8>
800043d8:	80007937          	lui	s2,0x80007
800043dc:	800075b7          	lui	a1,0x80007
800043e0:	80007537          	lui	a0,0x80007
800043e4:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800043e8:	06100693          	li	a3,97
800043ec:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800043f0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800043f4:	8e8fe0ef          	jal	ra,800024dc <printk>
800043f8:	80007537          	lui	a0,0x80007
800043fc:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004400:	8dcfe0ef          	jal	ra,800024dc <printk>
80004404:	06100593          	li	a1,97
80004408:	29090513          	addi	a0,s2,656
8000440c:	90cfe0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004410:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80004414:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004418:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000441c:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80004420:	feb7f793          	andi	a5,a5,-21
80004424:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80004428:	c64ff0ef          	jal	ra,8000388c <z_is_thread_ready>
8000442c:	02050463          	beqz	a0,80004454 <z_thread_timeout+0x12c>
}
80004430:	01812403          	lw	s0,24(sp)
80004434:	01c12083          	lw	ra,28(sp)
80004438:	01412483          	lw	s1,20(sp)
8000443c:	01012903          	lw	s2,16(sp)
80004440:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80004444:	00098513          	mv	a0,s3
80004448:	00c12983          	lw	s3,12(sp)
8000444c:	02010113          	addi	sp,sp,32
80004450:	d49ff06f          	j	80004198 <z_add_thread_to_ready_q>
80004454:	01c12083          	lw	ra,28(sp)
80004458:	01812403          	lw	s0,24(sp)
8000445c:	01412483          	lw	s1,20(sp)
80004460:	01012903          	lw	s2,16(sp)
80004464:	00c12983          	lw	s3,12(sp)
80004468:	00812a03          	lw	s4,8(sp)
8000446c:	02010113          	addi	sp,sp,32
80004470:	00008067          	ret

80004474 <z_move_thread_to_end_of_prio_q>:
{
80004474:	fe010113          	addi	sp,sp,-32
80004478:	00812c23          	sw	s0,24(sp)
8000447c:	01212823          	sw	s2,16(sp)
80004480:	00112e23          	sw	ra,28(sp)
80004484:	00912a23          	sw	s1,20(sp)
80004488:	01312623          	sw	s3,12(sp)
8000448c:	01412423          	sw	s4,8(sp)
80004490:	01512223          	sw	s5,4(sp)
80004494:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004498:	00800913          	li	s2,8
8000449c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800044a0:	800089b7          	lui	s3,0x80008
800044a4:	96098513          	addi	a0,s3,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
800044a8:	00897913          	andi	s2,s2,8
800044ac:	7f1000ef          	jal	ra,8000549c <z_spin_lock_valid>
800044b0:	02051e63          	bnez	a0,800044ec <z_move_thread_to_end_of_prio_q+0x78>
800044b4:	800074b7          	lui	s1,0x80007
800044b8:	800075b7          	lui	a1,0x80007
800044bc:	80007537          	lui	a0,0x80007
800044c0:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800044c4:	04e00693          	li	a3,78
800044c8:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800044cc:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800044d0:	80cfe0ef          	jal	ra,800024dc <printk>
800044d4:	80007537          	lui	a0,0x80007
800044d8:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800044dc:	800fe0ef          	jal	ra,800024dc <printk>
800044e0:	04e00593          	li	a1,78
800044e4:	29048513          	addi	a0,s1,656
800044e8:	830fe0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
800044ec:	96098513          	addi	a0,s3,-1696
800044f0:	004010ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800044f4:	800084b7          	lui	s1,0x80008
800044f8:	ce048513          	addi	a0,s1,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
800044fc:	00040593          	mv	a1,s0
80004500:	02450513          	addi	a0,a0,36
80004504:	8c1ff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	return thread == _idle_thread;
80004508:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
8000450c:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004510:	80008a37          	lui	s4,0x80008
80004514:	ce048493          	addi	s1,s1,-800
80004518:	d04a0a13          	addi	s4,s4,-764 # 80007d04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d05>
8000451c:	02f41863          	bne	s0,a5,8000454c <z_move_thread_to_end_of_prio_q+0xd8>
80004520:	80007ab7          	lui	s5,0x80007
80004524:	800075b7          	lui	a1,0x80007
80004528:	80007537          	lui	a0,0x80007
8000452c:	61458593          	addi	a1,a1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
80004530:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004534:	27600693          	li	a3,630
80004538:	57ca8613          	addi	a2,s5,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
8000453c:	fa1fd0ef          	jal	ra,800024dc <printk>
80004540:	27600593          	li	a1,630
80004544:	57ca8513          	addi	a0,s5,1404
80004548:	fd1fd0ef          	jal	ra,80002518 <assert_post_action>
	return list->head == list;
8000454c:	0244a783          	lw	a5,36(s1)
80004550:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004554:	0b478e63          	beq	a5,s4,80004610 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004558:	0a078c63          	beqz	a5,80004610 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
8000455c:	00e40683          	lb	a3,14(s0)
80004560:	00e78603          	lb	a2,14(a5)
80004564:	0ac6d063          	bge	a3,a2,80004604 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80004568:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000456c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004570:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004574:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004578:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
8000457c:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80004580:	0084a503          	lw	a0,8(s1)
80004584:	0407e793          	ori	a5,a5,64
80004588:	40850533          	sub	a0,a0,s0
8000458c:	00153513          	seqz	a0,a0
80004590:	00f406a3          	sb	a5,13(s0)
80004594:	9bdff0ef          	jal	ra,80003f50 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004598:	96098513          	addi	a0,s3,-1696
8000459c:	729000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800045a0:	02051e63          	bnez	a0,800045dc <z_move_thread_to_end_of_prio_q+0x168>
800045a4:	80007437          	lui	s0,0x80007
800045a8:	800075b7          	lui	a1,0x80007
800045ac:	80007537          	lui	a0,0x80007
800045b0:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800045b4:	06100693          	li	a3,97
800045b8:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800045bc:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800045c0:	f1dfd0ef          	jal	ra,800024dc <printk>
800045c4:	80007537          	lui	a0,0x80007
800045c8:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800045cc:	f11fd0ef          	jal	ra,800024dc <printk>
800045d0:	06100593          	li	a1,97
800045d4:	29040513          	addi	a0,s0,656
800045d8:	f41fd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800045dc:	30092973          	csrrs	s2,mstatus,s2
}
800045e0:	01c12083          	lw	ra,28(sp)
800045e4:	01812403          	lw	s0,24(sp)
800045e8:	01412483          	lw	s1,20(sp)
800045ec:	01012903          	lw	s2,16(sp)
800045f0:	00c12983          	lw	s3,12(sp)
800045f4:	00812a03          	lw	s4,8(sp)
800045f8:	00412a83          	lw	s5,4(sp)
800045fc:	02010113          	addi	sp,sp,32
80004600:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80004604:	00e78663          	beq	a5,a4,80004610 <z_move_thread_to_end_of_prio_q+0x19c>
80004608:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000460c:	f4079ae3          	bnez	a5,80004560 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80004610:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80004614:	0284a783          	lw	a5,40(s1)
	node->next = list;
80004618:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
8000461c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004620:	0284a423          	sw	s0,40(s1)
80004624:	f59ff06f          	j	8000457c <z_move_thread_to_end_of_prio_q+0x108>

80004628 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80004628:	800087b7          	lui	a5,0x80008
8000462c:	9687a783          	lw	a5,-1688(a5) # 80007968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007969>
80004630:	06078663          	beqz	a5,8000469c <z_time_slice+0x74>
80004634:	800087b7          	lui	a5,0x80008
80004638:	ce078793          	addi	a5,a5,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
8000463c:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80004640:	07f00693          	li	a3,127
80004644:	00e75603          	lhu	a2,14(a4)
80004648:	04c6ea63          	bltu	a3,a2,8000469c <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
8000464c:	800086b7          	lui	a3,0x80008
80004650:	00e70603          	lb	a2,14(a4)
80004654:	9646a683          	lw	a3,-1692(a3) # 80007964 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007965>
80004658:	04d64263          	blt	a2,a3,8000469c <z_time_slice+0x74>
	return thread == _idle_thread;
8000465c:	800086b7          	lui	a3,0x80008
		&& !is_idle(t)
80004660:	8c46a683          	lw	a3,-1852(a3) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004664:	02d70c63          	beq	a4,a3,8000469c <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80004668:	01872683          	lw	a3,24(a4)
8000466c:	02069863          	bnez	a3,8000469c <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80004670:	0107a683          	lw	a3,16(a5)
80004674:	02d54063          	blt	a0,a3,80004694 <z_time_slice+0x6c>
{
80004678:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
8000467c:	00070513          	mv	a0,a4
{
80004680:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80004684:	df1ff0ef          	jal	ra,80004474 <z_move_thread_to_end_of_prio_q>
}
80004688:	00c12083          	lw	ra,12(sp)
8000468c:	01010113          	addi	sp,sp,16
			reset_time_slice();
80004690:	a1cff06f          	j	800038ac <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80004694:	40a686b3          	sub	a3,a3,a0
80004698:	00d7a823          	sw	a3,16(a5)
8000469c:	00008067          	ret

800046a0 <z_remove_thread_from_ready_q>:
{
800046a0:	fe010113          	addi	sp,sp,-32
800046a4:	00812c23          	sw	s0,24(sp)
800046a8:	01312623          	sw	s3,12(sp)
800046ac:	00112e23          	sw	ra,28(sp)
800046b0:	00912a23          	sw	s1,20(sp)
800046b4:	01212823          	sw	s2,16(sp)
800046b8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046bc:	00800413          	li	s0,8
800046c0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800046c4:	800084b7          	lui	s1,0x80008
800046c8:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
800046cc:	00847413          	andi	s0,s0,8
800046d0:	5cd000ef          	jal	ra,8000549c <z_spin_lock_valid>
800046d4:	02051e63          	bnez	a0,80004710 <z_remove_thread_from_ready_q+0x70>
800046d8:	80007937          	lui	s2,0x80007
800046dc:	800075b7          	lui	a1,0x80007
800046e0:	80007537          	lui	a0,0x80007
800046e4:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800046e8:	04e00693          	li	a3,78
800046ec:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800046f0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800046f4:	de9fd0ef          	jal	ra,800024dc <printk>
800046f8:	80007537          	lui	a0,0x80007
800046fc:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004700:	dddfd0ef          	jal	ra,800024dc <printk>
80004704:	04e00593          	li	a1,78
80004708:	29090513          	addi	a0,s2,656
8000470c:	e0dfd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004710:	96048513          	addi	a0,s1,-1696
80004714:	5e1000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80004718:	00d9c783          	lbu	a5,13(s3)
8000471c:	80008937          	lui	s2,0x80008
80004720:	ce090913          	addi	s2,s2,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80004724:	0407f793          	andi	a5,a5,64
80004728:	00078e63          	beqz	a5,80004744 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
8000472c:	00098593          	mv	a1,s3
80004730:	02490513          	addi	a0,s2,36
80004734:	e90ff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80004738:	00d9c783          	lbu	a5,13(s3)
8000473c:	fbf7f793          	andi	a5,a5,-65
80004740:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80004744:	00892503          	lw	a0,8(s2)
80004748:	41350533          	sub	a0,a0,s3
8000474c:	00153513          	seqz	a0,a0
80004750:	801ff0ef          	jal	ra,80003f50 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004754:	96048513          	addi	a0,s1,-1696
80004758:	56d000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
8000475c:	02051e63          	bnez	a0,80004798 <z_remove_thread_from_ready_q+0xf8>
80004760:	800074b7          	lui	s1,0x80007
80004764:	800075b7          	lui	a1,0x80007
80004768:	80007537          	lui	a0,0x80007
8000476c:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004770:	06100693          	li	a3,97
80004774:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004778:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000477c:	d61fd0ef          	jal	ra,800024dc <printk>
80004780:	80007537          	lui	a0,0x80007
80004784:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004788:	d55fd0ef          	jal	ra,800024dc <printk>
8000478c:	06100593          	li	a1,97
80004790:	29048513          	addi	a0,s1,656
80004794:	d85fd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004798:	30042473          	csrrs	s0,mstatus,s0
}
8000479c:	01c12083          	lw	ra,28(sp)
800047a0:	01812403          	lw	s0,24(sp)
800047a4:	01412483          	lw	s1,20(sp)
800047a8:	01012903          	lw	s2,16(sp)
800047ac:	00c12983          	lw	s3,12(sp)
800047b0:	02010113          	addi	sp,sp,32
800047b4:	00008067          	ret

800047b8 <pend>:
{
800047b8:	fe010113          	addi	sp,sp,-32
800047bc:	00812c23          	sw	s0,24(sp)
800047c0:	00912a23          	sw	s1,20(sp)
800047c4:	00050413          	mv	s0,a0
800047c8:	01212823          	sw	s2,16(sp)
800047cc:	00112e23          	sw	ra,28(sp)
800047d0:	01312623          	sw	s3,12(sp)
800047d4:	00058493          	mv	s1,a1
800047d8:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
800047dc:	ec5ff0ef          	jal	ra,800046a0 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
800047e0:	00d44783          	lbu	a5,13(s0)
800047e4:	0027e793          	ori	a5,a5,2
800047e8:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
800047ec:	06048663          	beqz	s1,80004858 <pend+0xa0>
	return thread == _idle_thread;
800047f0:	800087b7          	lui	a5,0x80008
	__ASSERT_NO_MSG(!is_idle(thread));
800047f4:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
		thread->base.pended_on = wait_q;
800047f8:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
800047fc:	02f41863          	bne	s0,a5,8000482c <pend+0x74>
80004800:	800079b7          	lui	s3,0x80007
80004804:	800075b7          	lui	a1,0x80007
80004808:	80007537          	lui	a0,0x80007
8000480c:	61458593          	addi	a1,a1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
80004810:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004814:	27600693          	li	a3,630
80004818:	57c98613          	addi	a2,s3,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
8000481c:	cc1fd0ef          	jal	ra,800024dc <printk>
80004820:	27600593          	li	a1,630
80004824:	57c98513          	addi	a0,s3,1404
80004828:	cf1fd0ef          	jal	ra,80002518 <assert_post_action>
	return list->head == list;
8000482c:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004830:	06f48c63          	beq	s1,a5,800048a8 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004834:	06078a63          	beqz	a5,800048a8 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80004838:	00e40703          	lb	a4,14(s0)
8000483c:	00e78683          	lb	a3,14(a5)
80004840:	04d75c63          	bge	a4,a3,80004898 <pend+0xe0>
	node->prev = successor->prev;
80004844:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004848:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000484c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004850:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004854:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80004858:	fff00793          	li	a5,-1
8000485c:	06f90463          	beq	s2,a5,800048c4 <pend+0x10c>
80004860:	00990913          	addi	s2,s2,9
80004864:	00a00613          	li	a2,10
80004868:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000486c:	01840513          	addi	a0,s0,24
}
80004870:	01812403          	lw	s0,24(sp)
80004874:	01c12083          	lw	ra,28(sp)
80004878:	01412483          	lw	s1,20(sp)
8000487c:	01012903          	lw	s2,16(sp)
80004880:	00c12983          	lw	s3,12(sp)
80004884:	800045b7          	lui	a1,0x80004
80004888:	32858593          	addi	a1,a1,808 # 80004328 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004329>
8000488c:	02010113          	addi	sp,sp,32
80004890:	00160613          	addi	a2,a2,1
80004894:	1300106f          	j	800059c4 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80004898:	0044a683          	lw	a3,4(s1)
8000489c:	00d78663          	beq	a5,a3,800048a8 <pend+0xf0>
800048a0:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800048a4:	f8079ce3          	bnez	a5,8000483c <pend+0x84>
	node->prev = list->tail;
800048a8:	0044a783          	lw	a5,4(s1)
	node->next = list;
800048ac:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800048b0:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800048b4:	0044a783          	lw	a5,4(s1)
800048b8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800048bc:	0084a223          	sw	s0,4(s1)
800048c0:	f99ff06f          	j	80004858 <pend+0xa0>
}
800048c4:	01c12083          	lw	ra,28(sp)
800048c8:	01812403          	lw	s0,24(sp)
800048cc:	01412483          	lw	s1,20(sp)
800048d0:	01012903          	lw	s2,16(sp)
800048d4:	00c12983          	lw	s3,12(sp)
800048d8:	02010113          	addi	sp,sp,32
800048dc:	00008067          	ret

800048e0 <z_pend_curr_irqlock>:
{
800048e0:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800048e4:	800087b7          	lui	a5,0x80008
{
800048e8:	00812423          	sw	s0,8(sp)
800048ec:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
800048f0:	ce87a503          	lw	a0,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
{
800048f4:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
800048f8:	ec1ff0ef          	jal	ra,800047b8 <pend>
800048fc:	00040513          	mv	a0,s0
}
80004900:	00812403          	lw	s0,8(sp)
80004904:	00c12083          	lw	ra,12(sp)
80004908:	01010113          	addi	sp,sp,16
8000490c:	92dfb06f          	j	80000238 <__swap>

80004910 <z_pend_curr>:
{
80004910:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80004914:	800087b7          	lui	a5,0x80008
{
80004918:	00812423          	sw	s0,8(sp)
8000491c:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80004920:	ce87a503          	lw	a0,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
{
80004924:	00912223          	sw	s1,4(sp)
80004928:	00058493          	mv	s1,a1
8000492c:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80004930:	00068613          	mv	a2,a3
{
80004934:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80004938:	e81ff0ef          	jal	ra,800047b8 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000493c:	00040513          	mv	a0,s0
80004940:	385000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80004944:	02051e63          	bnez	a0,80004980 <z_pend_curr+0x70>
80004948:	80007437          	lui	s0,0x80007
8000494c:	800075b7          	lui	a1,0x80007
80004950:	80007537          	lui	a0,0x80007
80004954:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004958:	07800693          	li	a3,120
8000495c:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004960:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004964:	b79fd0ef          	jal	ra,800024dc <printk>
80004968:	80007537          	lui	a0,0x80007
8000496c:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004970:	b6dfd0ef          	jal	ra,800024dc <printk>
80004974:	07800593          	li	a1,120
80004978:	29040513          	addi	a0,s0,656
8000497c:	b9dfd0ef          	jal	ra,80002518 <assert_post_action>
}
80004980:	00812403          	lw	s0,8(sp)
80004984:	00c12083          	lw	ra,12(sp)
80004988:	00048513          	mv	a0,s1
8000498c:	00412483          	lw	s1,4(sp)
80004990:	01010113          	addi	sp,sp,16
80004994:	8a5fb06f          	j	80000238 <__swap>

80004998 <z_unpend_first_thread>:
{
80004998:	fe010113          	addi	sp,sp,-32
8000499c:	01212823          	sw	s2,16(sp)
800049a0:	01312623          	sw	s3,12(sp)
800049a4:	00112e23          	sw	ra,28(sp)
800049a8:	00812c23          	sw	s0,24(sp)
800049ac:	00912a23          	sw	s1,20(sp)
800049b0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800049b4:	00800913          	li	s2,8
800049b8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800049bc:	800084b7          	lui	s1,0x80008
800049c0:	96048513          	addi	a0,s1,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
800049c4:	00897913          	andi	s2,s2,8
800049c8:	2d5000ef          	jal	ra,8000549c <z_spin_lock_valid>
800049cc:	02051e63          	bnez	a0,80004a08 <z_unpend_first_thread+0x70>
800049d0:	80007437          	lui	s0,0x80007
800049d4:	800075b7          	lui	a1,0x80007
800049d8:	80007537          	lui	a0,0x80007
800049dc:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800049e0:	04e00693          	li	a3,78
800049e4:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800049e8:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800049ec:	af1fd0ef          	jal	ra,800024dc <printk>
800049f0:	80007537          	lui	a0,0x80007
800049f4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
800049f8:	ae5fd0ef          	jal	ra,800024dc <printk>
800049fc:	04e00593          	li	a1,78
80004a00:	29040513          	addi	a0,s0,656
80004a04:	b15fd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004a08:	96048513          	addi	a0,s1,-1696
80004a0c:	2e9000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80004a10:	00098513          	mv	a0,s3
80004a14:	d28ff0ef          	jal	ra,80003f3c <z_priq_dumb_best>
80004a18:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004a1c:	96048513          	addi	a0,s1,-1696
80004a20:	2a5000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80004a24:	02051e63          	bnez	a0,80004a60 <z_unpend_first_thread+0xc8>
80004a28:	800079b7          	lui	s3,0x80007
80004a2c:	800075b7          	lui	a1,0x80007
80004a30:	80007537          	lui	a0,0x80007
80004a34:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004a38:	06100693          	li	a3,97
80004a3c:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004a40:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004a44:	a99fd0ef          	jal	ra,800024dc <printk>
80004a48:	80007537          	lui	a0,0x80007
80004a4c:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004a50:	a8dfd0ef          	jal	ra,800024dc <printk>
80004a54:	06100593          	li	a1,97
80004a58:	29098513          	addi	a0,s3,656
80004a5c:	abdfd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004a60:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004a64:	0c040663          	beqz	s0,80004b30 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a68:	00800913          	li	s2,8
80004a6c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a70:	96048513          	addi	a0,s1,-1696
	key = (mstatus & SOC_MSTATUS_IEN);
80004a74:	00897913          	andi	s2,s2,8
80004a78:	225000ef          	jal	ra,8000549c <z_spin_lock_valid>
80004a7c:	02051e63          	bnez	a0,80004ab8 <z_unpend_first_thread+0x120>
80004a80:	800079b7          	lui	s3,0x80007
80004a84:	800075b7          	lui	a1,0x80007
80004a88:	80007537          	lui	a0,0x80007
80004a8c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80004a90:	04e00693          	li	a3,78
80004a94:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004a98:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004a9c:	a41fd0ef          	jal	ra,800024dc <printk>
80004aa0:	80007537          	lui	a0,0x80007
80004aa4:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004aa8:	a35fd0ef          	jal	ra,800024dc <printk>
80004aac:	04e00593          	li	a1,78
80004ab0:	29098513          	addi	a0,s3,656
80004ab4:	a65fd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ab8:	96048513          	addi	a0,s1,-1696
80004abc:	239000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004ac0:	00840513          	addi	a0,s0,8
80004ac4:	e1dfe0ef          	jal	ra,800038e0 <pended_on.isra.15>
80004ac8:	00040593          	mv	a1,s0
80004acc:	af8ff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004ad0:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ad4:	96048513          	addi	a0,s1,-1696
80004ad8:	ffd7f793          	andi	a5,a5,-3
80004adc:	00f406a3          	sb	a5,13(s0)
80004ae0:	1e5000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80004ae4:	02051e63          	bnez	a0,80004b20 <z_unpend_first_thread+0x188>
80004ae8:	800074b7          	lui	s1,0x80007
80004aec:	800075b7          	lui	a1,0x80007
80004af0:	80007537          	lui	a0,0x80007
80004af4:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004af8:	06100693          	li	a3,97
80004afc:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004b00:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004b04:	9d9fd0ef          	jal	ra,800024dc <printk>
80004b08:	80007537          	lui	a0,0x80007
80004b0c:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004b10:	9cdfd0ef          	jal	ra,800024dc <printk>
80004b14:	06100593          	li	a1,97
80004b18:	29048513          	addi	a0,s1,656
80004b1c:	9fdfd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004b20:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80004b24:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80004b28:	01840513          	addi	a0,s0,24
80004b2c:	0c4010ef          	jal	ra,80005bf0 <z_abort_timeout>
}
80004b30:	00040513          	mv	a0,s0
80004b34:	01c12083          	lw	ra,28(sp)
80004b38:	01812403          	lw	s0,24(sp)
80004b3c:	01412483          	lw	s1,20(sp)
80004b40:	01012903          	lw	s2,16(sp)
80004b44:	00c12983          	lw	s3,12(sp)
80004b48:	02010113          	addi	sp,sp,32
80004b4c:	00008067          	ret

80004b50 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80004b50:	ff010113          	addi	sp,sp,-16
80004b54:	00912223          	sw	s1,4(sp)
80004b58:	01212023          	sw	s2,0(sp)
80004b5c:	00112623          	sw	ra,12(sp)
80004b60:	00812423          	sw	s0,8(sp)
80004b64:	00050913          	mv	s2,a0
	int need_sched = 0;
80004b68:	00000493          	li	s1,0
	return list->head == list;
80004b6c:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004b70:	00890463          	beq	s2,s0,80004b78 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004b74:	02041063          	bnez	s0,80004b94 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80004b78:	00c12083          	lw	ra,12(sp)
80004b7c:	00812403          	lw	s0,8(sp)
80004b80:	00048513          	mv	a0,s1
80004b84:	00012903          	lw	s2,0(sp)
80004b88:	00412483          	lw	s1,4(sp)
80004b8c:	01010113          	addi	sp,sp,16
80004b90:	00008067          	ret
		z_unpend_thread(th);
80004b94:	00040513          	mv	a0,s0
80004b98:	aa4ff0ef          	jal	ra,80003e3c <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004b9c:	00040513          	mv	a0,s0
80004ba0:	cedfe0ef          	jal	ra,8000388c <z_is_thread_ready>
		need_sched = 1;
80004ba4:	00100493          	li	s1,1
80004ba8:	fc0502e3          	beqz	a0,80004b6c <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004bac:	00040513          	mv	a0,s0
80004bb0:	de8ff0ef          	jal	ra,80004198 <z_add_thread_to_ready_q>
80004bb4:	fb9ff06f          	j	80004b6c <z_unpend_all+0x1c>

80004bb8 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004bb8:	800087b7          	lui	a5,0x80008
80004bbc:	ce078793          	addi	a5,a5,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
80004bc0:	02478713          	addi	a4,a5,36
80004bc4:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004bc8:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004bcc:	00000593          	li	a1,0
80004bd0:	00000513          	li	a0,0
80004bd4:	d6dfe06f          	j	80003940 <k_sched_time_slice_set>

80004bd8 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004bd8:	fe010113          	addi	sp,sp,-32
80004bdc:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80004be0:	80008437          	lui	s0,0x80008
80004be4:	ce042783          	lw	a5,-800(s0) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
80004be8:	00112e23          	sw	ra,28(sp)
80004bec:	00912a23          	sw	s1,20(sp)
80004bf0:	01212823          	sw	s2,16(sp)
80004bf4:	01312623          	sw	s3,12(sp)
80004bf8:	01412423          	sw	s4,8(sp)
80004bfc:	01512223          	sw	s5,4(sp)
80004c00:	ce040413          	addi	s0,s0,-800
	__ASSERT(!z_is_in_isr(), "");
80004c04:	02078e63          	beqz	a5,80004c40 <z_impl_k_yield+0x68>
80004c08:	800074b7          	lui	s1,0x80007
80004c0c:	800075b7          	lui	a1,0x80007
80004c10:	80007537          	lui	a0,0x80007
80004c14:	51458593          	addi	a1,a1,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80004c18:	37e00693          	li	a3,894
80004c1c:	57c48613          	addi	a2,s1,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004c20:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004c24:	8b9fd0ef          	jal	ra,800024dc <printk>
80004c28:	80007537          	lui	a0,0x80007
80004c2c:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80004c30:	8adfd0ef          	jal	ra,800024dc <printk>
80004c34:	37e00593          	li	a1,894
80004c38:	57c48513          	addi	a0,s1,1404
80004c3c:	8ddfd0ef          	jal	ra,80002518 <assert_post_action>
	return thread == _idle_thread;
80004c40:	800087b7          	lui	a5,0x80008

	if (!is_idle(_current)) {
80004c44:	00842683          	lw	a3,8(s0)
80004c48:	8c47a703          	lw	a4,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004c4c:	00078a13          	mv	s4,a5
80004c50:	12e68663          	beq	a3,a4,80004d7c <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004c54:	00800913          	li	s2,8
80004c58:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c5c:	800089b7          	lui	s3,0x80008
80004c60:	96098513          	addi	a0,s3,-1696 # 80007960 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007961>
	key = (mstatus & SOC_MSTATUS_IEN);
80004c64:	00897913          	andi	s2,s2,8
80004c68:	035000ef          	jal	ra,8000549c <z_spin_lock_valid>
80004c6c:	02051e63          	bnez	a0,80004ca8 <z_impl_k_yield+0xd0>
80004c70:	800074b7          	lui	s1,0x80007
80004c74:	800075b7          	lui	a1,0x80007
80004c78:	80007537          	lui	a0,0x80007
80004c7c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80004c80:	04e00693          	li	a3,78
80004c84:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004c88:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004c8c:	851fd0ef          	jal	ra,800024dc <printk>
80004c90:	80007537          	lui	a0,0x80007
80004c94:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004c98:	845fd0ef          	jal	ra,800024dc <printk>
80004c9c:	04e00593          	li	a1,78
80004ca0:	29048513          	addi	a0,s1,656
80004ca4:	875fd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ca8:	96098513          	addi	a0,s3,-1696
80004cac:	049000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80004cb0:	00842583          	lw	a1,8(s0)
80004cb4:	02440513          	addi	a0,s0,36
80004cb8:	90cff0ef          	jal	ra,80003dc4 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004cbc:	8c4a2783          	lw	a5,-1852(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
80004cc0:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80004cc4:	80008a37          	lui	s4,0x80008
80004cc8:	d04a0a13          	addi	s4,s4,-764 # 80007d04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007d05>
	__ASSERT_NO_MSG(!is_idle(thread));
80004ccc:	02f49863          	bne	s1,a5,80004cfc <z_impl_k_yield+0x124>
80004cd0:	80007ab7          	lui	s5,0x80007
80004cd4:	800075b7          	lui	a1,0x80007
80004cd8:	80007537          	lui	a0,0x80007
80004cdc:	61458593          	addi	a1,a1,1556 # 80007614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007615>
80004ce0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004ce4:	27600693          	li	a3,630
80004ce8:	57ca8613          	addi	a2,s5,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004cec:	ff0fd0ef          	jal	ra,800024dc <printk>
80004cf0:	27600593          	li	a1,630
80004cf4:	57ca8513          	addi	a0,s5,1404
80004cf8:	821fd0ef          	jal	ra,80002518 <assert_post_action>
	return list->head == list;
80004cfc:	02442783          	lw	a5,36(s0)
80004d00:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004d04:	0b478a63          	beq	a5,s4,80004db8 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004d08:	0a078863          	beqz	a5,80004db8 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80004d0c:	00e48683          	lb	a3,14(s1)
80004d10:	00e78603          	lb	a2,14(a5)
80004d14:	08c6dc63          	bge	a3,a2,80004dac <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80004d18:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004d1c:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
80004d20:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
80004d24:	00972023          	sw	s1,0(a4)
	successor->prev = node;
80004d28:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80004d2c:	00100513          	li	a0,1
80004d30:	a20ff0ef          	jal	ra,80003f50 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d34:	96098513          	addi	a0,s3,-1696
80004d38:	78c000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80004d3c:	02051e63          	bnez	a0,80004d78 <z_impl_k_yield+0x1a0>
80004d40:	80007437          	lui	s0,0x80007
80004d44:	800075b7          	lui	a1,0x80007
80004d48:	80007537          	lui	a0,0x80007
80004d4c:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004d50:	06100693          	li	a3,97
80004d54:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004d58:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004d5c:	f80fd0ef          	jal	ra,800024dc <printk>
80004d60:	80007537          	lui	a0,0x80007
80004d64:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004d68:	f74fd0ef          	jal	ra,800024dc <printk>
80004d6c:	06100593          	li	a1,97
80004d70:	29040513          	addi	a0,s0,656
80004d74:	fa4fd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d78:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004d7c:	00800513          	li	a0,8
80004d80:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
80004d84:	01812403          	lw	s0,24(sp)
80004d88:	01c12083          	lw	ra,28(sp)
80004d8c:	01412483          	lw	s1,20(sp)
80004d90:	01012903          	lw	s2,16(sp)
80004d94:	00c12983          	lw	s3,12(sp)
80004d98:	00812a03          	lw	s4,8(sp)
80004d9c:	00412a83          	lw	s5,4(sp)
80004da0:	00857513          	andi	a0,a0,8
80004da4:	02010113          	addi	sp,sp,32
80004da8:	c90fb06f          	j	80000238 <__swap>
	return (node == list->tail) ? NULL : node->next;
80004dac:	00e78663          	beq	a5,a4,80004db8 <z_impl_k_yield+0x1e0>
80004db0:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004db4:	f4079ee3          	bnez	a5,80004d10 <z_impl_k_yield+0x138>
	node->prev = list->tail;
80004db8:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80004dbc:	02842783          	lw	a5,40(s0)
	node->next = list;
80004dc0:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80004dc4:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80004dc8:	02942423          	sw	s1,40(s0)
80004dcc:	f61ff06f          	j	80004d2c <z_impl_k_yield+0x154>

80004dd0 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
80004dd0:	fd010113          	addi	sp,sp,-48
80004dd4:	02912223          	sw	s1,36(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80004dd8:	800084b7          	lui	s1,0x80008
80004ddc:	ce04a783          	lw	a5,-800(s1) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
80004de0:	02812423          	sw	s0,40(sp)
80004de4:	02112623          	sw	ra,44(sp)
80004de8:	03212023          	sw	s2,32(sp)
80004dec:	01312e23          	sw	s3,28(sp)
80004df0:	01412c23          	sw	s4,24(sp)
80004df4:	00050413          	mv	s0,a0
80004df8:	ce048493          	addi	s1,s1,-800
	__ASSERT(!z_is_in_isr(), "");
80004dfc:	02078e63          	beqz	a5,80004e38 <z_impl_k_sleep+0x68>
80004e00:	80007937          	lui	s2,0x80007
80004e04:	800075b7          	lui	a1,0x80007
80004e08:	80007537          	lui	a0,0x80007
80004e0c:	51458593          	addi	a1,a1,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
80004e10:	39900693          	li	a3,921
80004e14:	57c90613          	addi	a2,s2,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004e18:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004e1c:	ec0fd0ef          	jal	ra,800024dc <printk>
80004e20:	80007537          	lui	a0,0x80007
80004e24:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80004e28:	eb4fd0ef          	jal	ra,800024dc <printk>
80004e2c:	39900593          	li	a1,921
80004e30:	57c90513          	addi	a0,s2,1404
80004e34:	ee4fd0ef          	jal	ra,80002518 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80004e38:	fff00793          	li	a5,-1
80004e3c:	1af41263          	bne	s0,a5,80004fe0 <z_impl_k_sleep+0x210>
80004e40:	80007937          	lui	s2,0x80007
80004e44:	800075b7          	lui	a1,0x80007
80004e48:	80007537          	lui	a0,0x80007
80004e4c:	5c858593          	addi	a1,a1,1480 # 800075c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075c9>
80004e50:	39a00693          	li	a3,922
80004e54:	57c90613          	addi	a2,s2,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004e58:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004e5c:	e80fd0ef          	jal	ra,800024dc <printk>
80004e60:	80007537          	lui	a0,0x80007
80004e64:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80004e68:	e74fd0ef          	jal	ra,800024dc <printk>
80004e6c:	39a00593          	li	a1,922
80004e70:	57c90513          	addi	a0,s2,1404
80004e74:	ea4fd0ef          	jal	ra,80002518 <assert_post_action>
80004e78:	00a00793          	li	a5,10
80004e7c:	00940413          	addi	s0,s0,9
80004e80:	02f44433          	div	s0,s0,a5
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
	expected_wakeup_time = ticks + z_tick_get_32();
80004e84:	3a4010ef          	jal	ra,80006228 <z_tick_get_32>
80004e88:	00800993          	li	s3,8

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
80004e8c:	00012623          	sw	zero,12(sp)
	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80004e90:	00140413          	addi	s0,s0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80004e94:	00a40933          	add	s2,s0,a0
80004e98:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e9c:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004ea0:	0089f993          	andi	s3,s3,8
80004ea4:	5f8000ef          	jal	ra,8000549c <z_spin_lock_valid>
80004ea8:	02051e63          	bnez	a0,80004ee4 <z_impl_k_sleep+0x114>
80004eac:	80007a37          	lui	s4,0x80007
80004eb0:	800075b7          	lui	a1,0x80007
80004eb4:	80007537          	lui	a0,0x80007
80004eb8:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80004ebc:	04e00693          	li	a3,78
80004ec0:	290a0613          	addi	a2,s4,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004ec4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004ec8:	e14fd0ef          	jal	ra,800024dc <printk>
80004ecc:	80007537          	lui	a0,0x80007
80004ed0:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80004ed4:	e08fd0ef          	jal	ra,800024dc <printk>
80004ed8:	04e00593          	li	a1,78
80004edc:	290a0513          	addi	a0,s4,656
80004ee0:	e38fd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ee4:	00c10513          	addi	a0,sp,12
80004ee8:	60c000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80004eec:	0084a503          	lw	a0,8(s1)
80004ef0:	fb0ff0ef          	jal	ra,800046a0 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004ef4:	0084a503          	lw	a0,8(s1)
80004ef8:	800045b7          	lui	a1,0x80004
80004efc:	00040613          	mv	a2,s0
80004f00:	01850513          	addi	a0,a0,24
80004f04:	32858593          	addi	a1,a1,808 # 80004328 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004329>
80004f08:	2bd000ef          	jal	ra,800059c4 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
80004f0c:	0084a703          	lw	a4,8(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f10:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80004f14:	00d74783          	lbu	a5,13(a4)
80004f18:	0107e793          	ori	a5,a5,16
80004f1c:	00f706a3          	sb	a5,13(a4)
80004f20:	5a4000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80004f24:	02051e63          	bnez	a0,80004f60 <z_impl_k_sleep+0x190>
80004f28:	80007437          	lui	s0,0x80007
80004f2c:	800075b7          	lui	a1,0x80007
80004f30:	80007537          	lui	a0,0x80007
80004f34:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80004f38:	07800693          	li	a3,120
80004f3c:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80004f40:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004f44:	d98fd0ef          	jal	ra,800024dc <printk>
80004f48:	80007537          	lui	a0,0x80007
80004f4c:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80004f50:	d8cfd0ef          	jal	ra,800024dc <printk>
80004f54:	07800593          	li	a1,120
80004f58:	29040513          	addi	a0,s0,656
80004f5c:	dbcfd0ef          	jal	ra,80002518 <assert_post_action>
80004f60:	00098513          	mv	a0,s3
80004f64:	ad4fb0ef          	jal	ra,80000238 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80004f68:	0084a783          	lw	a5,8(s1)
80004f6c:	00d7c783          	lbu	a5,13(a5)
80004f70:	0107f793          	andi	a5,a5,16
80004f74:	02078e63          	beqz	a5,80004fb0 <z_impl_k_sleep+0x1e0>
80004f78:	80007437          	lui	s0,0x80007
80004f7c:	800075b7          	lui	a1,0x80007
80004f80:	80007537          	lui	a0,0x80007
80004f84:	5dc58593          	addi	a1,a1,1500 # 800075dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075dd>
80004f88:	3b700693          	li	a3,951
80004f8c:	57c40613          	addi	a2,s0,1404 # 8000757c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000757d>
80004f90:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80004f94:	d48fd0ef          	jal	ra,800024dc <printk>
80004f98:	80007537          	lui	a0,0x80007
80004f9c:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80004fa0:	d3cfd0ef          	jal	ra,800024dc <printk>
80004fa4:	3b700593          	li	a1,951
80004fa8:	57c40513          	addi	a0,s0,1404
80004fac:	d6cfd0ef          	jal	ra,80002518 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80004fb0:	278010ef          	jal	ra,80006228 <z_tick_get_32>
80004fb4:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80004fb8:	00000413          	li	s0,0
	if (ticks > 0) {
80004fbc:	02a05663          	blez	a0,80004fe8 <z_impl_k_sleep+0x218>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80004fc0:	3e800793          	li	a5,1000
80004fc4:	02f515b3          	mulh	a1,a0,a5
80004fc8:	06400613          	li	a2,100
80004fcc:	00000693          	li	a3,0
80004fd0:	02f50533          	mul	a0,a0,a5
80004fd4:	aecfb0ef          	jal	ra,800002c0 <__udivdi3>
80004fd8:	00050413          	mv	s0,a0
		return __ticks_to_ms(ticks);
80004fdc:	00c0006f          	j	80004fe8 <z_impl_k_sleep+0x218>
	if (duration == 0) {
80004fe0:	e8041ce3          	bnez	s0,80004e78 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80004fe4:	bf5ff0ef          	jal	ra,80004bd8 <z_impl_k_yield>
}
80004fe8:	00040513          	mv	a0,s0
80004fec:	02c12083          	lw	ra,44(sp)
80004ff0:	02812403          	lw	s0,40(sp)
80004ff4:	02412483          	lw	s1,36(sp)
80004ff8:	02012903          	lw	s2,32(sp)
80004ffc:	01c12983          	lw	s3,28(sp)
80005000:	01812a03          	lw	s4,24(sp)
80005004:	03010113          	addi	sp,sp,48
80005008:	00008067          	ret

8000500c <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
8000500c:	800087b7          	lui	a5,0x80008
80005010:	ce87a503          	lw	a0,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
80005014:	00008067          	ret

80005018 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80005018:	fe010113          	addi	sp,sp,-32
8000501c:	00812c23          	sw	s0,24(sp)
80005020:	00912a23          	sw	s1,20(sp)
80005024:	01212823          	sw	s2,16(sp)
80005028:	00112e23          	sw	ra,28(sp)
8000502c:	01312623          	sw	s3,12(sp)
80005030:	00050413          	mv	s0,a0
80005034:	00058913          	mv	s2,a1
80005038:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
8000503c:	02061e63          	bnez	a2,80005078 <z_impl_k_sem_init+0x60>
80005040:	800079b7          	lui	s3,0x80007
80005044:	800075b7          	lui	a1,0x80007
80005048:	80007537          	lui	a0,0x80007
8000504c:	63858593          	addi	a1,a1,1592 # 80007638 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007639>
80005050:	04600693          	li	a3,70
80005054:	62898613          	addi	a2,s3,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
80005058:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000505c:	c80fd0ef          	jal	ra,800024dc <printk>
80005060:	80007537          	lui	a0,0x80007
80005064:	64450513          	addi	a0,a0,1604 # 80007644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007645>
80005068:	c74fd0ef          	jal	ra,800024dc <printk>
8000506c:	04600593          	li	a1,70
80005070:	62898513          	addi	a0,s3,1576
80005074:	ca4fd0ef          	jal	ra,80002518 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80005078:	0324fe63          	bgeu	s1,s2,800050b4 <z_impl_k_sem_init+0x9c>
8000507c:	800079b7          	lui	s3,0x80007
80005080:	800075b7          	lui	a1,0x80007
80005084:	80007537          	lui	a0,0x80007
80005088:	65c58593          	addi	a1,a1,1628 # 8000765c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000765d>
8000508c:	04700693          	li	a3,71
80005090:	62898613          	addi	a2,s3,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
80005094:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005098:	c44fd0ef          	jal	ra,800024dc <printk>
8000509c:	80007537          	lui	a0,0x80007
800050a0:	67450513          	addi	a0,a0,1652 # 80007674 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007675>
800050a4:	c38fd0ef          	jal	ra,800024dc <printk>
800050a8:	04700593          	li	a1,71
800050ac:	62898513          	addi	a0,s3,1576
800050b0:	c68fd0ef          	jal	ra,80002518 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800050b4:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800050b8:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800050bc:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800050c0:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800050c4:	01c12083          	lw	ra,28(sp)
800050c8:	01812403          	lw	s0,24(sp)
800050cc:	01412483          	lw	s1,20(sp)
800050d0:	01012903          	lw	s2,16(sp)
800050d4:	00c12983          	lw	s3,12(sp)
800050d8:	02010113          	addi	sp,sp,32
800050dc:	00008067          	ret

800050e0 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800050e0:	fe010113          	addi	sp,sp,-32
800050e4:	00912a23          	sw	s1,20(sp)
800050e8:	01312623          	sw	s3,12(sp)
800050ec:	00112e23          	sw	ra,28(sp)
800050f0:	00812c23          	sw	s0,24(sp)
800050f4:	01212823          	sw	s2,16(sp)
800050f8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800050fc:	00800493          	li	s1,8
80005100:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005104:	80008437          	lui	s0,0x80008
80005108:	96c40513          	addi	a0,s0,-1684 # 8000796c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000796d>
	key = (mstatus & SOC_MSTATUS_IEN);
8000510c:	0084f493          	andi	s1,s1,8
80005110:	38c000ef          	jal	ra,8000549c <z_spin_lock_valid>
80005114:	02051e63          	bnez	a0,80005150 <z_impl_k_sem_give+0x70>
80005118:	80007937          	lui	s2,0x80007
8000511c:	800075b7          	lui	a1,0x80007
80005120:	80007537          	lui	a0,0x80007
80005124:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005128:	04e00693          	li	a3,78
8000512c:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005130:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005134:	ba8fd0ef          	jal	ra,800024dc <printk>
80005138:	80007537          	lui	a0,0x80007
8000513c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005140:	b9cfd0ef          	jal	ra,800024dc <printk>
80005144:	04e00593          	li	a1,78
80005148:	29090513          	addi	a0,s2,656
8000514c:	bccfd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005150:	96c40513          	addi	a0,s0,-1684
80005154:	3a0000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80005158:	00098513          	mv	a0,s3
8000515c:	83dff0ef          	jal	ra,80004998 <z_unpend_first_thread>
80005160:	00050913          	mv	s2,a0
	if (thread != NULL) {
80005164:	04050263          	beqz	a0,800051a8 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005168:	00d54783          	lbu	a5,13(a0)
8000516c:	01f7f793          	andi	a5,a5,31
80005170:	00079863          	bnez	a5,80005180 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80005174:	01852783          	lw	a5,24(a0)
80005178:	00079463          	bnez	a5,80005180 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
8000517c:	81cff0ef          	jal	ra,80004198 <z_add_thread_to_ready_q>
80005180:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80005184:	96c40513          	addi	a0,s0,-1684
}
80005188:	01812403          	lw	s0,24(sp)
8000518c:	01c12083          	lw	ra,28(sp)
80005190:	01012903          	lw	s2,16(sp)
80005194:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005198:	00048593          	mv	a1,s1
}
8000519c:	01412483          	lw	s1,20(sp)
800051a0:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
800051a4:	9a9fe06f          	j	80003b4c <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
800051a8:	0089a703          	lw	a4,8(s3)
800051ac:	00c9a783          	lw	a5,12(s3)
800051b0:	40e787b3          	sub	a5,a5,a4
800051b4:	00f037b3          	snez	a5,a5
800051b8:	00e787b3          	add	a5,a5,a4
800051bc:	00f9a423          	sw	a5,8(s3)
800051c0:	fc5ff06f          	j	80005184 <z_impl_k_sem_give+0xa4>

800051c4 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800051c4:	800087b7          	lui	a5,0x80008
800051c8:	ce07a783          	lw	a5,-800(a5) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
800051cc:	fe010113          	addi	sp,sp,-32
800051d0:	01212823          	sw	s2,16(sp)
800051d4:	01312623          	sw	s3,12(sp)
800051d8:	00112e23          	sw	ra,28(sp)
800051dc:	00812c23          	sw	s0,24(sp)
800051e0:	00912a23          	sw	s1,20(sp)
800051e4:	01412423          	sw	s4,8(sp)
800051e8:	00050913          	mv	s2,a0
800051ec:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
800051f0:	04078063          	beqz	a5,80005230 <z_impl_k_sem_take+0x6c>
800051f4:	02058e63          	beqz	a1,80005230 <z_impl_k_sem_take+0x6c>
800051f8:	80007437          	lui	s0,0x80007
800051fc:	800075b7          	lui	a1,0x80007
80005200:	80007537          	lui	a0,0x80007
80005204:	69c58593          	addi	a1,a1,1692 # 8000769c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000769d>
80005208:	08c00693          	li	a3,140
8000520c:	62840613          	addi	a2,s0,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
80005210:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005214:	ac8fd0ef          	jal	ra,800024dc <printk>
80005218:	80007537          	lui	a0,0x80007
8000521c:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80005220:	abcfd0ef          	jal	ra,800024dc <printk>
80005224:	08c00593          	li	a1,140
80005228:	62840513          	addi	a0,s0,1576
8000522c:	aecfd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005230:	00800413          	li	s0,8
80005234:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005238:	800084b7          	lui	s1,0x80008
8000523c:	96c48513          	addi	a0,s1,-1684 # 8000796c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000796d>
	key = (mstatus & SOC_MSTATUS_IEN);
80005240:	00847413          	andi	s0,s0,8
80005244:	258000ef          	jal	ra,8000549c <z_spin_lock_valid>
80005248:	02051e63          	bnez	a0,80005284 <z_impl_k_sem_take+0xc0>
8000524c:	80007a37          	lui	s4,0x80007
80005250:	800075b7          	lui	a1,0x80007
80005254:	80007537          	lui	a0,0x80007
80005258:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
8000525c:	04e00693          	li	a3,78
80005260:	290a0613          	addi	a2,s4,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005264:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005268:	a74fd0ef          	jal	ra,800024dc <printk>
8000526c:	80007537          	lui	a0,0x80007
80005270:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005274:	a68fd0ef          	jal	ra,800024dc <printk>
80005278:	04e00593          	li	a1,78
8000527c:	290a0513          	addi	a0,s4,656
80005280:	a98fd0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005284:	96c48513          	addi	a0,s1,-1684
80005288:	26c000ef          	jal	ra,800054f4 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
8000528c:	00892783          	lw	a5,8(s2)
80005290:	06078c63          	beqz	a5,80005308 <z_impl_k_sem_take+0x144>
		sem->count--;
80005294:	fff78793          	addi	a5,a5,-1
80005298:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000529c:	96c48513          	addi	a0,s1,-1684
800052a0:	224000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800052a4:	02051e63          	bnez	a0,800052e0 <z_impl_k_sem_take+0x11c>
800052a8:	800074b7          	lui	s1,0x80007
800052ac:	800075b7          	lui	a1,0x80007
800052b0:	80007537          	lui	a0,0x80007
800052b4:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800052b8:	06100693          	li	a3,97
800052bc:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800052c0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800052c4:	a18fd0ef          	jal	ra,800024dc <printk>
800052c8:	80007537          	lui	a0,0x80007
800052cc:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800052d0:	a0cfd0ef          	jal	ra,800024dc <printk>
800052d4:	06100593          	li	a1,97
800052d8:	29048513          	addi	a0,s1,656
800052dc:	a3cfd0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800052e0:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
800052e4:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
800052e8:	01c12083          	lw	ra,28(sp)
800052ec:	01812403          	lw	s0,24(sp)
800052f0:	01412483          	lw	s1,20(sp)
800052f4:	01012903          	lw	s2,16(sp)
800052f8:	00c12983          	lw	s3,12(sp)
800052fc:	00812a03          	lw	s4,8(sp)
80005300:	02010113          	addi	sp,sp,32
80005304:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80005308:	04099a63          	bnez	s3,8000535c <z_impl_k_sem_take+0x198>
8000530c:	96c48513          	addi	a0,s1,-1684
80005310:	1b4000ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005314:	02051e63          	bnez	a0,80005350 <z_impl_k_sem_take+0x18c>
80005318:	800074b7          	lui	s1,0x80007
8000531c:	800075b7          	lui	a1,0x80007
80005320:	80007537          	lui	a0,0x80007
80005324:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80005328:	06100693          	li	a3,97
8000532c:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005330:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005334:	9a8fd0ef          	jal	ra,800024dc <printk>
80005338:	80007537          	lui	a0,0x80007
8000533c:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80005340:	99cfd0ef          	jal	ra,800024dc <printk>
80005344:	06100593          	li	a1,97
80005348:	29048513          	addi	a0,s1,656
8000534c:	9ccfd0ef          	jal	ra,80002518 <assert_post_action>
80005350:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80005354:	ff000513          	li	a0,-16
80005358:	f91ff06f          	j	800052e8 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000535c:	00040593          	mv	a1,s0
}
80005360:	01812403          	lw	s0,24(sp)
80005364:	01c12083          	lw	ra,28(sp)
80005368:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000536c:	00098693          	mv	a3,s3
80005370:	00090613          	mv	a2,s2
}
80005374:	00c12983          	lw	s3,12(sp)
80005378:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
8000537c:	96c48513          	addi	a0,s1,-1684
}
80005380:	01412483          	lw	s1,20(sp)
80005384:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80005388:	d88ff06f          	j	80004910 <z_pend_curr>

8000538c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000538c:	00d54783          	lbu	a5,13(a0)
80005390:	01f7f793          	andi	a5,a5,31
80005394:	00079863          	bnez	a5,800053a4 <z_is_thread_ready+0x18>
80005398:	01852503          	lw	a0,24(a0)
8000539c:	00153513          	seqz	a0,a0
800053a0:	00008067          	ret
800053a4:	00000513          	li	a0,0
}
800053a8:	00008067          	ret

800053ac <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800053ac:	800087b7          	lui	a5,0x80008
800053b0:	ce07a503          	lw	a0,-800(a5) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
}
800053b4:	00a03533          	snez	a0,a0
800053b8:	00008067          	ret

800053bc <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800053bc:	800087b7          	lui	a5,0x80008
800053c0:	ce87a783          	lw	a5,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
800053c4:	00c7c503          	lbu	a0,12(a5)
}
800053c8:	00157513          	andi	a0,a0,1
800053cc:	00008067          	ret

800053d0 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
800053d0:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800053d4:	02012303          	lw	t1,32(sp)
{
800053d8:	00812c23          	sw	s0,24(sp)
800053dc:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800053e0:	00612023          	sw	t1,0(sp)
{
800053e4:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800053e8:	a1cfc0ef          	jal	ra,80001604 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
800053ec:	800087b7          	lui	a5,0x80008
800053f0:	ce87a783          	lw	a5,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
	sys_trace_thread_create(new_thread);
}
800053f4:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
800053f8:	0687a783          	lw	a5,104(a5)
800053fc:	06f42423          	sw	a5,104(s0)
}
80005400:	01812403          	lw	s0,24(sp)
80005404:	02010113          	addi	sp,sp,32
80005408:	00008067          	ret

8000540c <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
8000540c:	06052783          	lw	a5,96(a0)
{
80005410:	ff010113          	addi	sp,sp,-16
80005414:	00812423          	sw	s0,8(sp)
80005418:	00112623          	sw	ra,12(sp)
8000541c:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80005420:	00078463          	beqz	a5,80005428 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80005424:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80005428:	00040513          	mv	a0,s0
8000542c:	f61ff0ef          	jal	ra,8000538c <z_is_thread_ready>
80005430:	02050463          	beqz	a0,80005458 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80005434:	00040513          	mv	a0,s0
80005438:	a68ff0ef          	jal	ra,800046a0 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
8000543c:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80005440:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80005444:	0087e793          	ori	a5,a5,8
80005448:	00f406a3          	sb	a5,13(s0)
}
8000544c:	00812403          	lw	s0,8(sp)
80005450:	01010113          	addi	sp,sp,16
80005454:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80005458:	00d44783          	lbu	a5,13(s0)
8000545c:	0027f793          	andi	a5,a5,2
80005460:	00078663          	beqz	a5,8000546c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80005464:	00040513          	mv	a0,s0
80005468:	de8fe0ef          	jal	ra,80003a50 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000546c:	01842783          	lw	a5,24(s0)
80005470:	fc0786e3          	beqz	a5,8000543c <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
80005474:	01840513          	addi	a0,s0,24
80005478:	778000ef          	jal	ra,80005bf0 <z_abort_timeout>
8000547c:	fc1ff06f          	j	8000543c <z_thread_single_abort+0x30>

80005480 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80005480:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80005484:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80005488:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
8000548c:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80005490:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80005494:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80005498:	00008067          	ret

8000549c <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
8000549c:	00052503          	lw	a0,0(a0)
800054a0:	00050e63          	beqz	a0,800054bc <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800054a4:	800087b7          	lui	a5,0x80008
800054a8:	cf47c783          	lbu	a5,-780(a5) # 80007cf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf5>
800054ac:	00357513          	andi	a0,a0,3
800054b0:	40f50533          	sub	a0,a0,a5
800054b4:	00a03533          	snez	a0,a0
800054b8:	00008067          	ret
			return false;
		}
	}
	return true;
800054bc:	00100513          	li	a0,1
}
800054c0:	00008067          	ret

800054c4 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800054c4:	800087b7          	lui	a5,0x80008
800054c8:	ce078793          	addi	a5,a5,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
800054cc:	0147c703          	lbu	a4,20(a5)
800054d0:	0087a783          	lw	a5,8(a5)
800054d4:	00e7e7b3          	or	a5,a5,a4
800054d8:	00052703          	lw	a4,0(a0)
800054dc:	00f71863          	bne	a4,a5,800054ec <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
800054e0:	00052023          	sw	zero,0(a0)
	return true;
800054e4:	00100513          	li	a0,1
800054e8:	00008067          	ret
		return false;
800054ec:	00000513          	li	a0,0
}
800054f0:	00008067          	ret

800054f4 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800054f4:	800087b7          	lui	a5,0x80008
800054f8:	ce078793          	addi	a5,a5,-800 # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
800054fc:	0147c703          	lbu	a4,20(a5)
80005500:	0087a783          	lw	a5,8(a5)
80005504:	00e7e7b3          	or	a5,a5,a4
80005508:	00f52023          	sw	a5,0(a0)
}
8000550c:	00008067          	ret

80005510 <z_impl_k_thread_start>:
{
80005510:	fe010113          	addi	sp,sp,-32
80005514:	00812c23          	sw	s0,24(sp)
80005518:	01212823          	sw	s2,16(sp)
8000551c:	00112e23          	sw	ra,28(sp)
80005520:	00912a23          	sw	s1,20(sp)
80005524:	01312623          	sw	s3,12(sp)
80005528:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000552c:	00800413          	li	s0,8
80005530:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005534:	800084b7          	lui	s1,0x80008
80005538:	97048513          	addi	a0,s1,-1680 # 80007970 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007971>
	key = (mstatus & SOC_MSTATUS_IEN);
8000553c:	00847413          	andi	s0,s0,8
80005540:	f5dff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005544:	02051e63          	bnez	a0,80005580 <z_impl_k_thread_start+0x70>
80005548:	800079b7          	lui	s3,0x80007
8000554c:	800075b7          	lui	a1,0x80007
80005550:	80007537          	lui	a0,0x80007
80005554:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005558:	04e00693          	li	a3,78
8000555c:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005560:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005564:	f79fc0ef          	jal	ra,800024dc <printk>
80005568:	80007537          	lui	a0,0x80007
8000556c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005570:	f6dfc0ef          	jal	ra,800024dc <printk>
80005574:	04e00593          	li	a1,78
80005578:	29098513          	addi	a0,s3,656
8000557c:	f9dfc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005580:	97048513          	addi	a0,s1,-1680
80005584:	f71ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80005588:	00d94783          	lbu	a5,13(s2)
8000558c:	0047f713          	andi	a4,a5,4
80005590:	06071463          	bnez	a4,800055f8 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005594:	97048513          	addi	a0,s1,-1680
80005598:	f2dff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
8000559c:	02051e63          	bnez	a0,800055d8 <z_impl_k_thread_start+0xc8>
800055a0:	800074b7          	lui	s1,0x80007
800055a4:	800075b7          	lui	a1,0x80007
800055a8:	80007537          	lui	a0,0x80007
800055ac:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800055b0:	06100693          	li	a3,97
800055b4:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800055b8:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800055bc:	f21fc0ef          	jal	ra,800024dc <printk>
800055c0:	80007537          	lui	a0,0x80007
800055c4:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800055c8:	f15fc0ef          	jal	ra,800024dc <printk>
800055cc:	06100593          	li	a1,97
800055d0:	29048513          	addi	a0,s1,656
800055d4:	f45fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800055d8:	30042473          	csrrs	s0,mstatus,s0
}
800055dc:	01c12083          	lw	ra,28(sp)
800055e0:	01812403          	lw	s0,24(sp)
800055e4:	01412483          	lw	s1,20(sp)
800055e8:	01012903          	lw	s2,16(sp)
800055ec:	00c12983          	lw	s3,12(sp)
800055f0:	02010113          	addi	sp,sp,32
800055f4:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800055f8:	ffb7f793          	andi	a5,a5,-5
800055fc:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80005600:	00090513          	mv	a0,s2
80005604:	d89ff0ef          	jal	ra,8000538c <z_is_thread_ready>
80005608:	00050663          	beqz	a0,80005614 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
8000560c:	00090513          	mv	a0,s2
80005610:	b89fe0ef          	jal	ra,80004198 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80005614:	00040593          	mv	a1,s0
}
80005618:	01812403          	lw	s0,24(sp)
8000561c:	01c12083          	lw	ra,28(sp)
80005620:	01012903          	lw	s2,16(sp)
80005624:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80005628:	97048513          	addi	a0,s1,-1680
}
8000562c:	01412483          	lw	s1,20(sp)
80005630:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80005634:	d18fe06f          	j	80003b4c <z_reschedule>

80005638 <schedule_new_thread>:
	if (delay == 0) {
80005638:	00059463          	bnez	a1,80005640 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
8000563c:	ed5ff06f          	j	80005510 <z_impl_k_thread_start>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005640:	00958593          	addi	a1,a1,9
80005644:	00a00613          	li	a2,10
80005648:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
8000564c:	800045b7          	lui	a1,0x80004
80005650:	32858593          	addi	a1,a1,808 # 80004328 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004329>
80005654:	01850513          	addi	a0,a0,24
80005658:	00160613          	addi	a2,a2,1
8000565c:	3680006f          	j	800059c4 <z_add_timeout>

80005660 <z_impl_k_thread_create>:
{
80005660:	fc010113          	addi	sp,sp,-64
80005664:	03512223          	sw	s5,36(sp)
80005668:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000566c:	800086b7          	lui	a3,0x80008
80005670:	ce06a683          	lw	a3,-800(a3) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
80005674:	02812c23          	sw	s0,56(sp)
80005678:	02912a23          	sw	s1,52(sp)
8000567c:	03312623          	sw	s3,44(sp)
80005680:	03412423          	sw	s4,40(sp)
80005684:	02112e23          	sw	ra,60(sp)
80005688:	03212823          	sw	s2,48(sp)
8000568c:	00050413          	mv	s0,a0
80005690:	00058993          	mv	s3,a1
80005694:	00060a13          	mv	s4,a2
80005698:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000569c:	04068e63          	beqz	a3,800056f8 <z_impl_k_thread_create+0x98>
800056a0:	80007937          	lui	s2,0x80007
800056a4:	800075b7          	lui	a1,0x80007
800056a8:	80007537          	lui	a0,0x80007
800056ac:	1b200693          	li	a3,434
800056b0:	6d090613          	addi	a2,s2,1744 # 800076d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d1>
800056b4:	51458593          	addi	a1,a1,1300 # 80007514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007515>
800056b8:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800056bc:	01112e23          	sw	a7,28(sp)
800056c0:	01012c23          	sw	a6,24(sp)
800056c4:	00f12a23          	sw	a5,20(sp)
800056c8:	00e12823          	sw	a4,16(sp)
800056cc:	e11fc0ef          	jal	ra,800024dc <printk>
800056d0:	80007537          	lui	a0,0x80007
800056d4:	6e450513          	addi	a0,a0,1764 # 800076e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e5>
800056d8:	e05fc0ef          	jal	ra,800024dc <printk>
800056dc:	1b200593          	li	a1,434
800056e0:	6d090513          	addi	a0,s2,1744
800056e4:	e35fc0ef          	jal	ra,80002518 <assert_post_action>
800056e8:	01c12883          	lw	a7,28(sp)
800056ec:	01812803          	lw	a6,24(sp)
800056f0:	01412783          	lw	a5,20(sp)
800056f4:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800056f8:	04012683          	lw	a3,64(sp)
800056fc:	00012223          	sw	zero,4(sp)
80005700:	000a0613          	mv	a2,s4
80005704:	00d12023          	sw	a3,0(sp)
80005708:	00098593          	mv	a1,s3
8000570c:	000a8693          	mv	a3,s5
80005710:	00040513          	mv	a0,s0
80005714:	cbdff0ef          	jal	ra,800053d0 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80005718:	fff00793          	li	a5,-1
8000571c:	00f48863          	beq	s1,a5,8000572c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80005720:	00048593          	mv	a1,s1
80005724:	00040513          	mv	a0,s0
80005728:	f11ff0ef          	jal	ra,80005638 <schedule_new_thread>
}
8000572c:	00040513          	mv	a0,s0
80005730:	03c12083          	lw	ra,60(sp)
80005734:	03812403          	lw	s0,56(sp)
80005738:	03412483          	lw	s1,52(sp)
8000573c:	03012903          	lw	s2,48(sp)
80005740:	02c12983          	lw	s3,44(sp)
80005744:	02812a03          	lw	s4,40(sp)
80005748:	02412a83          	lw	s5,36(sp)
8000574c:	04010113          	addi	sp,sp,64
80005750:	00008067          	ret

80005754 <z_init_static_threads>:
{
80005754:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80005758:	800087b7          	lui	a5,0x80008
{
8000575c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005760:	80008937          	lui	s2,0x80008
{
80005764:	00812c23          	sw	s0,24(sp)
80005768:	00912a23          	sw	s1,20(sp)
8000576c:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005770:	8f878413          	addi	s0,a5,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
80005774:	8f878493          	addi	s1,a5,-1800
80005778:	8f890913          	addi	s2,s2,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
8000577c:	03246663          	bltu	s0,s2,800057a8 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80005780:	00048413          	mv	s0,s1
	k_sched_lock();
80005784:	cc8fe0ef          	jal	ra,80003c4c <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80005788:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
8000578c:	07246063          	bltu	s0,s2,800057ec <z_init_static_threads+0x98>
}
80005790:	01812403          	lw	s0,24(sp)
80005794:	01c12083          	lw	ra,28(sp)
80005798:	01412483          	lw	s1,20(sp)
8000579c:	01012903          	lw	s2,16(sp)
800057a0:	02010113          	addi	sp,sp,32
	k_sched_unlock();
800057a4:	875fe06f          	j	80004018 <k_sched_unlock>
		z_setup_new_thread(
800057a8:	02c42783          	lw	a5,44(s0)
800057ac:	00f12223          	sw	a5,4(sp)
800057b0:	02042783          	lw	a5,32(s0)
800057b4:	00f12023          	sw	a5,0(sp)
800057b8:	01442783          	lw	a5,20(s0)
800057bc:	01c42883          	lw	a7,28(s0)
800057c0:	01842803          	lw	a6,24(s0)
800057c4:	01042703          	lw	a4,16(s0)
800057c8:	00c42683          	lw	a3,12(s0)
800057cc:	00842603          	lw	a2,8(s0)
800057d0:	00442583          	lw	a1,4(s0)
800057d4:	00042503          	lw	a0,0(s0)
800057d8:	bf9ff0ef          	jal	ra,800053d0 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800057dc:	00042783          	lw	a5,0(s0)
800057e0:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800057e4:	03040413          	addi	s0,s0,48
800057e8:	f95ff06f          	j	8000577c <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
800057ec:	02442583          	lw	a1,36(s0)
800057f0:	00958663          	beq	a1,s1,800057fc <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
800057f4:	00042503          	lw	a0,0(s0)
800057f8:	e41ff0ef          	jal	ra,80005638 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800057fc:	03040413          	addi	s0,s0,48
80005800:	f8dff06f          	j	8000578c <z_init_static_threads+0x38>

80005804 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80005804:	fe010113          	addi	sp,sp,-32
80005808:	00812c23          	sw	s0,24(sp)
8000580c:	00912a23          	sw	s1,20(sp)
80005810:	00112e23          	sw	ra,28(sp)
80005814:	01212823          	sw	s2,16(sp)
80005818:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
8000581c:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005820:	00800413          	li	s0,8
80005824:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005828:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
8000582c:	00847413          	andi	s0,s0,8
80005830:	c6dff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005834:	02051e63          	bnez	a0,80005870 <z_impl_k_thread_abort+0x6c>
80005838:	80007937          	lui	s2,0x80007
8000583c:	800075b7          	lui	a1,0x80007
80005840:	80007537          	lui	a0,0x80007
80005844:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005848:	04e00693          	li	a3,78
8000584c:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005850:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005854:	c89fc0ef          	jal	ra,800024dc <printk>
80005858:	80007537          	lui	a0,0x80007
8000585c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005860:	c7dfc0ef          	jal	ra,800024dc <printk>
80005864:	04e00593          	li	a1,78
80005868:	29090513          	addi	a0,s2,656
8000586c:	cadfc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005870:	00c10513          	addi	a0,sp,12
80005874:	c81ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80005878:	00c4c783          	lbu	a5,12(s1)
8000587c:	0017f793          	andi	a5,a5,1
80005880:	02078e63          	beqz	a5,800058bc <z_impl_k_thread_abort+0xb8>
80005884:	80007937          	lui	s2,0x80007
80005888:	800075b7          	lui	a1,0x80007
8000588c:	80007537          	lui	a0,0x80007
80005890:	72458593          	addi	a1,a1,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80005894:	02900693          	li	a3,41
80005898:	70c90613          	addi	a2,s2,1804 # 8000770c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000770d>
8000589c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800058a0:	c3dfc0ef          	jal	ra,800024dc <printk>
800058a4:	80007537          	lui	a0,0x80007
800058a8:	75850513          	addi	a0,a0,1880 # 80007758 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007759>
800058ac:	c31fc0ef          	jal	ra,800024dc <printk>
800058b0:	02900593          	li	a1,41
800058b4:	70c90513          	addi	a0,s2,1804
800058b8:	c61fc0ef          	jal	ra,80002518 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
800058bc:	00048513          	mv	a0,s1
800058c0:	b4dff0ef          	jal	ra,8000540c <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
800058c4:	00040593          	mv	a1,s0
800058c8:	00c10513          	addi	a0,sp,12
800058cc:	a80fe0ef          	jal	ra,80003b4c <z_reschedule>
}
800058d0:	01c12083          	lw	ra,28(sp)
800058d4:	01812403          	lw	s0,24(sp)
800058d8:	01412483          	lw	s1,20(sp)
800058dc:	01012903          	lw	s2,16(sp)
800058e0:	02010113          	addi	sp,sp,32
800058e4:	00008067          	ret

800058e8 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
800058e8:	800087b7          	lui	a5,0x80008
800058ec:	9747a783          	lw	a5,-1676(a5) # 80007974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007975>
800058f0:	00079463          	bnez	a5,800058f8 <elapsed+0x10>
800058f4:	874fd06f          	j	80002968 <z_clock_elapsed>
}
800058f8:	00000513          	li	a0,0
800058fc:	00008067          	ret

80005900 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80005900:	00052783          	lw	a5,0(a0)
80005904:	02050263          	beqz	a0,80005928 <remove_timeout+0x28>
80005908:	80008737          	lui	a4,0x80008
	return (node == list->tail) ? NULL : node->next;
8000590c:	8bc72703          	lw	a4,-1860(a4) # 800078bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078bd>
80005910:	00e50c63          	beq	a0,a4,80005928 <remove_timeout+0x28>
	if (next(t) != NULL) {
80005914:	00078a63          	beqz	a5,80005928 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80005918:	0087a703          	lw	a4,8(a5)
8000591c:	00852683          	lw	a3,8(a0)
80005920:	00d70733          	add	a4,a4,a3
80005924:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80005928:	00452703          	lw	a4,4(a0)
8000592c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80005930:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80005934:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005938:	00052223          	sw	zero,4(a0)
}
8000593c:	00008067          	ret

80005940 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005940:	800087b7          	lui	a5,0x80008
80005944:	9807c783          	lbu	a5,-1664(a5) # 80007980 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007981>
{
80005948:	ff010113          	addi	sp,sp,-16
8000594c:	00112623          	sw	ra,12(sp)
80005950:	00812423          	sw	s0,8(sp)
80005954:	00912223          	sw	s1,4(sp)
80005958:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
8000595c:	00079663          	bnez	a5,80005968 <next_timeout+0x28>
80005960:	80000537          	lui	a0,0x80000
80005964:	fff54513          	not	a0,a0
	return list->head == list;
80005968:	800087b7          	lui	a5,0x80008
8000596c:	8b878793          	addi	a5,a5,-1864 # 800078b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b9>
80005970:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005974:	02f40463          	beq	s0,a5,8000599c <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80005978:	02040263          	beqz	s0,8000599c <next_timeout+0x5c>
8000597c:	00842483          	lw	s1,8(s0)
80005980:	f69ff0ef          	jal	ra,800058e8 <elapsed>
80005984:	40a484b3          	sub	s1,s1,a0
80005988:	00000513          	li	a0,0
8000598c:	0004c863          	bltz	s1,8000599c <next_timeout+0x5c>
80005990:	00842403          	lw	s0,8(s0)
80005994:	f55ff0ef          	jal	ra,800058e8 <elapsed>
80005998:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000599c:	800087b7          	lui	a5,0x80008
800059a0:	cf07a783          	lw	a5,-784(a5) # 80007cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf1>
800059a4:	00078663          	beqz	a5,800059b0 <next_timeout+0x70>
800059a8:	00a7d463          	bge	a5,a0,800059b0 <next_timeout+0x70>
800059ac:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
800059b0:	00c12083          	lw	ra,12(sp)
800059b4:	00812403          	lw	s0,8(sp)
800059b8:	00412483          	lw	s1,4(sp)
800059bc:	01010113          	addi	sp,sp,16
800059c0:	00008067          	ret

800059c4 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
800059c4:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
800059c8:	fd010113          	addi	sp,sp,-48
800059cc:	02812423          	sw	s0,40(sp)
800059d0:	02912223          	sw	s1,36(sp)
800059d4:	01312e23          	sw	s3,28(sp)
800059d8:	02112623          	sw	ra,44(sp)
800059dc:	03212023          	sw	s2,32(sp)
800059e0:	01412c23          	sw	s4,24(sp)
800059e4:	01512a23          	sw	s5,20(sp)
800059e8:	01612823          	sw	s6,16(sp)
800059ec:	01712623          	sw	s7,12(sp)
800059f0:	01812423          	sw	s8,8(sp)
800059f4:	00050413          	mv	s0,a0
800059f8:	00058993          	mv	s3,a1
800059fc:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80005a00:	02078e63          	beqz	a5,80005a3c <z_add_timeout+0x78>
80005a04:	80007937          	lui	s2,0x80007
80005a08:	800075b7          	lui	a1,0x80007
80005a0c:	80007537          	lui	a0,0x80007
80005a10:	78858593          	addi	a1,a1,1928 # 80007788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007789>
80005a14:	04d00693          	li	a3,77
80005a18:	77490613          	addi	a2,s2,1908 # 80007774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007775>
80005a1c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005a20:	abdfc0ef          	jal	ra,800024dc <printk>
80005a24:	80007537          	lui	a0,0x80007
80005a28:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80005a2c:	ab1fc0ef          	jal	ra,800024dc <printk>
80005a30:	04d00593          	li	a1,77
80005a34:	77490513          	addi	a0,s2,1908
80005a38:	ae1fc0ef          	jal	ra,80002518 <assert_post_action>
	to->fn = fn;
80005a3c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005a40:	00904463          	bgtz	s1,80005a48 <z_add_timeout+0x84>
80005a44:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005a48:	00800993          	li	s3,8
80005a4c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005a50:	80008a37          	lui	s4,0x80008
80005a54:	978a0513          	addi	a0,s4,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80005a58:	0089f993          	andi	s3,s3,8
80005a5c:	a41ff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005a60:	02051e63          	bnez	a0,80005a9c <z_add_timeout+0xd8>
80005a64:	80007937          	lui	s2,0x80007
80005a68:	800075b7          	lui	a1,0x80007
80005a6c:	80007537          	lui	a0,0x80007
80005a70:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005a74:	04e00693          	li	a3,78
80005a78:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005a7c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005a80:	a5dfc0ef          	jal	ra,800024dc <printk>
80005a84:	80007537          	lui	a0,0x80007
80005a88:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005a8c:	a51fc0ef          	jal	ra,800024dc <printk>
80005a90:	04e00593          	li	a1,78
80005a94:	29090513          	addi	a0,s2,656
80005a98:	a81fc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005a9c:	978a0513          	addi	a0,s4,-1672
80005aa0:	a55ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005aa4:	e45ff0ef          	jal	ra,800058e8 <elapsed>
80005aa8:	00950533          	add	a0,a0,s1
	return list->head == list;
80005aac:	800084b7          	lui	s1,0x80008
80005ab0:	8b84a903          	lw	s2,-1864(s1) # 800078b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b9>
80005ab4:	00a42423          	sw	a0,8(s0)
80005ab8:	8b848493          	addi	s1,s1,-1864
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005abc:	00990c63          	beq	s2,s1,80005ad4 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80005ac0:	80007ab7          	lui	s5,0x80007
80005ac4:	80007b37          	lui	s6,0x80007
80005ac8:	80007bb7          	lui	s7,0x80007
80005acc:	80007c37          	lui	s8,0x80007
		for (t = first(); t != NULL; t = next(t)) {
80005ad0:	02091063          	bnez	s2,80005af0 <z_add_timeout+0x12c>
	node->prev = list->tail;
80005ad4:	0044a783          	lw	a5,4(s1)
	node->next = list;
80005ad8:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80005adc:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80005ae0:	0044a783          	lw	a5,4(s1)
80005ae4:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80005ae8:	0084a223          	sw	s0,4(s1)
80005aec:	05c0006f          	j	80005b48 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80005af0:	00892783          	lw	a5,8(s2)
80005af4:	0207d663          	bgez	a5,80005b20 <z_add_timeout+0x15c>
80005af8:	7a8b0593          	addi	a1,s6,1960 # 800077a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077a9>
80005afc:	05600693          	li	a3,86
80005b00:	774a8613          	addi	a2,s5,1908 # 80007774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007775>
80005b04:	1c4b8513          	addi	a0,s7,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005b08:	9d5fc0ef          	jal	ra,800024dc <printk>
80005b0c:	248c0513          	addi	a0,s8,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
80005b10:	9cdfc0ef          	jal	ra,800024dc <printk>
80005b14:	05600593          	li	a1,86
80005b18:	774a8513          	addi	a0,s5,1908
80005b1c:	9fdfc0ef          	jal	ra,80002518 <assert_post_action>

			if (t->dticks > to->dticks) {
80005b20:	00892703          	lw	a4,8(s2)
80005b24:	00842783          	lw	a5,8(s0)
80005b28:	0ae7d863          	bge	a5,a4,80005bd8 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80005b2c:	40f707b3          	sub	a5,a4,a5
80005b30:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005b34:	00492783          	lw	a5,4(s2)
	node->next = successor;
80005b38:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80005b3c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005b40:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005b44:	00892223          	sw	s0,4(s2)
	return list->head == list;
80005b48:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005b4c:	00978a63          	beq	a5,s1,80005b60 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80005b50:	00f41863          	bne	s0,a5,80005b60 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80005b54:	dedff0ef          	jal	ra,80005940 <next_timeout>
80005b58:	00000593          	li	a1,0
80005b5c:	c91fc0ef          	jal	ra,800027ec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005b60:	978a0513          	addi	a0,s4,-1672
80005b64:	961ff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005b68:	02051e63          	bnez	a0,80005ba4 <z_add_timeout+0x1e0>
80005b6c:	80007437          	lui	s0,0x80007
80005b70:	800075b7          	lui	a1,0x80007
80005b74:	80007537          	lui	a0,0x80007
80005b78:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80005b7c:	06100693          	li	a3,97
80005b80:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005b84:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005b88:	955fc0ef          	jal	ra,800024dc <printk>
80005b8c:	80007537          	lui	a0,0x80007
80005b90:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80005b94:	949fc0ef          	jal	ra,800024dc <printk>
80005b98:	06100593          	li	a1,97
80005b9c:	29040513          	addi	a0,s0,656
80005ba0:	979fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005ba4:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005ba8:	02c12083          	lw	ra,44(sp)
80005bac:	02812403          	lw	s0,40(sp)
80005bb0:	02412483          	lw	s1,36(sp)
80005bb4:	02012903          	lw	s2,32(sp)
80005bb8:	01c12983          	lw	s3,28(sp)
80005bbc:	01812a03          	lw	s4,24(sp)
80005bc0:	01412a83          	lw	s5,20(sp)
80005bc4:	01012b03          	lw	s6,16(sp)
80005bc8:	00c12b83          	lw	s7,12(sp)
80005bcc:	00812c03          	lw	s8,8(sp)
80005bd0:	03010113          	addi	sp,sp,48
80005bd4:	00008067          	ret
			to->dticks -= t->dticks;
80005bd8:	40e787b3          	sub	a5,a5,a4
80005bdc:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80005be0:	0044a783          	lw	a5,4(s1)
80005be4:	ef2788e3          	beq	a5,s2,80005ad4 <z_add_timeout+0x110>
80005be8:	00092903          	lw	s2,0(s2)
80005bec:	ee5ff06f          	j	80005ad0 <z_add_timeout+0x10c>

80005bf0 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80005bf0:	fe010113          	addi	sp,sp,-32
80005bf4:	00812c23          	sw	s0,24(sp)
80005bf8:	01312623          	sw	s3,12(sp)
80005bfc:	00112e23          	sw	ra,28(sp)
80005c00:	00912a23          	sw	s1,20(sp)
80005c04:	01212823          	sw	s2,16(sp)
80005c08:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005c0c:	00800413          	li	s0,8
80005c10:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005c14:	800084b7          	lui	s1,0x80008
80005c18:	97848513          	addi	a0,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80005c1c:	00847413          	andi	s0,s0,8
80005c20:	87dff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005c24:	02051e63          	bnez	a0,80005c60 <z_abort_timeout+0x70>
80005c28:	80007937          	lui	s2,0x80007
80005c2c:	800075b7          	lui	a1,0x80007
80005c30:	80007537          	lui	a0,0x80007
80005c34:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005c38:	04e00693          	li	a3,78
80005c3c:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005c40:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005c44:	899fc0ef          	jal	ra,800024dc <printk>
80005c48:	80007537          	lui	a0,0x80007
80005c4c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005c50:	88dfc0ef          	jal	ra,800024dc <printk>
80005c54:	04e00593          	li	a1,78
80005c58:	29090513          	addi	a0,s2,656
80005c5c:	8bdfc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005c60:	97848513          	addi	a0,s1,-1672
80005c64:	891ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80005c68:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80005c6c:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005c70:	00078863          	beqz	a5,80005c80 <z_abort_timeout+0x90>
			remove_timeout(to);
80005c74:	00098513          	mv	a0,s3
80005c78:	c89ff0ef          	jal	ra,80005900 <remove_timeout>
			ret = 0;
80005c7c:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005c80:	97848513          	addi	a0,s1,-1672
80005c84:	841ff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005c88:	02051e63          	bnez	a0,80005cc4 <z_abort_timeout+0xd4>
80005c8c:	800074b7          	lui	s1,0x80007
80005c90:	800075b7          	lui	a1,0x80007
80005c94:	80007537          	lui	a0,0x80007
80005c98:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80005c9c:	06100693          	li	a3,97
80005ca0:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005ca4:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005ca8:	835fc0ef          	jal	ra,800024dc <printk>
80005cac:	80007537          	lui	a0,0x80007
80005cb0:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80005cb4:	829fc0ef          	jal	ra,800024dc <printk>
80005cb8:	06100593          	li	a1,97
80005cbc:	29048513          	addi	a0,s1,656
80005cc0:	859fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005cc4:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80005cc8:	01c12083          	lw	ra,28(sp)
80005ccc:	01812403          	lw	s0,24(sp)
80005cd0:	00090513          	mv	a0,s2
80005cd4:	01412483          	lw	s1,20(sp)
80005cd8:	01012903          	lw	s2,16(sp)
80005cdc:	00c12983          	lw	s3,12(sp)
80005ce0:	02010113          	addi	sp,sp,32
80005ce4:	00008067          	ret

80005ce8 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80005ce8:	ff010113          	addi	sp,sp,-16
80005cec:	00812423          	sw	s0,8(sp)
80005cf0:	00112623          	sw	ra,12(sp)
80005cf4:	00912223          	sw	s1,4(sp)
80005cf8:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005cfc:	00800413          	li	s0,8
80005d00:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005d04:	800084b7          	lui	s1,0x80008
80005d08:	97848513          	addi	a0,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80005d0c:	00847413          	andi	s0,s0,8
80005d10:	f8cff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005d14:	02051e63          	bnez	a0,80005d50 <z_get_next_timeout_expiry+0x68>
80005d18:	80007937          	lui	s2,0x80007
80005d1c:	800075b7          	lui	a1,0x80007
80005d20:	80007537          	lui	a0,0x80007
80005d24:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005d28:	04e00693          	li	a3,78
80005d2c:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005d30:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005d34:	fa8fc0ef          	jal	ra,800024dc <printk>
80005d38:	80007537          	lui	a0,0x80007
80005d3c:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005d40:	f9cfc0ef          	jal	ra,800024dc <printk>
80005d44:	04e00593          	li	a1,78
80005d48:	29090513          	addi	a0,s2,656
80005d4c:	fccfc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005d50:	97848513          	addi	a0,s1,-1672
80005d54:	fa0ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80005d58:	be9ff0ef          	jal	ra,80005940 <next_timeout>
80005d5c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005d60:	97848513          	addi	a0,s1,-1672
80005d64:	f60ff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005d68:	02051e63          	bnez	a0,80005da4 <z_get_next_timeout_expiry+0xbc>
80005d6c:	800074b7          	lui	s1,0x80007
80005d70:	800075b7          	lui	a1,0x80007
80005d74:	80007537          	lui	a0,0x80007
80005d78:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80005d7c:	06100693          	li	a3,97
80005d80:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005d84:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005d88:	f54fc0ef          	jal	ra,800024dc <printk>
80005d8c:	80007537          	lui	a0,0x80007
80005d90:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80005d94:	f48fc0ef          	jal	ra,800024dc <printk>
80005d98:	06100593          	li	a1,97
80005d9c:	29048513          	addi	a0,s1,656
80005da0:	f78fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005da4:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80005da8:	00c12083          	lw	ra,12(sp)
80005dac:	00812403          	lw	s0,8(sp)
80005db0:	00090513          	mv	a0,s2
80005db4:	00412483          	lw	s1,4(sp)
80005db8:	00012903          	lw	s2,0(sp)
80005dbc:	01010113          	addi	sp,sp,16
80005dc0:	00008067          	ret

80005dc4 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80005dc4:	fe010113          	addi	sp,sp,-32
80005dc8:	00812c23          	sw	s0,24(sp)
80005dcc:	01212823          	sw	s2,16(sp)
80005dd0:	01412423          	sw	s4,8(sp)
80005dd4:	00112e23          	sw	ra,28(sp)
80005dd8:	00912a23          	sw	s1,20(sp)
80005ddc:	01312623          	sw	s3,12(sp)
80005de0:	00050913          	mv	s2,a0
80005de4:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005de8:	00800413          	li	s0,8
80005dec:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005df0:	800084b7          	lui	s1,0x80008
80005df4:	97848513          	addi	a0,s1,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80005df8:	00847413          	andi	s0,s0,8
80005dfc:	ea0ff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005e00:	02051e63          	bnez	a0,80005e3c <z_set_timeout_expiry+0x78>
80005e04:	800079b7          	lui	s3,0x80007
80005e08:	800075b7          	lui	a1,0x80007
80005e0c:	80007537          	lui	a0,0x80007
80005e10:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005e14:	04e00693          	li	a3,78
80005e18:	29098613          	addi	a2,s3,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005e1c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005e20:	ebcfc0ef          	jal	ra,800024dc <printk>
80005e24:	80007537          	lui	a0,0x80007
80005e28:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005e2c:	eb0fc0ef          	jal	ra,800024dc <printk>
80005e30:	04e00593          	li	a1,78
80005e34:	29098513          	addi	a0,s3,656
80005e38:	ee0fc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80005e3c:	97848513          	addi	a0,s1,-1672
80005e40:	eb4ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80005e44:	afdff0ef          	jal	ra,80005940 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80005e48:	00a95c63          	bge	s2,a0,80005e60 <z_set_timeout_expiry+0x9c>
80005e4c:	00100793          	li	a5,1
80005e50:	00a7d863          	bge	a5,a0,80005e60 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80005e54:	000a0593          	mv	a1,s4
80005e58:	00090513          	mv	a0,s2
80005e5c:	991fc0ef          	jal	ra,800027ec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005e60:	97848513          	addi	a0,s1,-1672
80005e64:	e60ff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005e68:	02051e63          	bnez	a0,80005ea4 <z_set_timeout_expiry+0xe0>
80005e6c:	800074b7          	lui	s1,0x80007
80005e70:	800075b7          	lui	a1,0x80007
80005e74:	80007537          	lui	a0,0x80007
80005e78:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80005e7c:	06100693          	li	a3,97
80005e80:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005e84:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005e88:	e54fc0ef          	jal	ra,800024dc <printk>
80005e8c:	80007537          	lui	a0,0x80007
80005e90:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80005e94:	e48fc0ef          	jal	ra,800024dc <printk>
80005e98:	06100593          	li	a1,97
80005e9c:	29048513          	addi	a0,s1,656
80005ea0:	e78fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005ea4:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80005ea8:	01c12083          	lw	ra,28(sp)
80005eac:	01812403          	lw	s0,24(sp)
80005eb0:	01412483          	lw	s1,20(sp)
80005eb4:	01012903          	lw	s2,16(sp)
80005eb8:	00c12983          	lw	s3,12(sp)
80005ebc:	00812a03          	lw	s4,8(sp)
80005ec0:	02010113          	addi	sp,sp,32
80005ec4:	00008067          	ret

80005ec8 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80005ec8:	fd010113          	addi	sp,sp,-48
80005ecc:	02812423          	sw	s0,40(sp)
80005ed0:	01412c23          	sw	s4,24(sp)
80005ed4:	02112623          	sw	ra,44(sp)
80005ed8:	02912223          	sw	s1,36(sp)
80005edc:	03212023          	sw	s2,32(sp)
80005ee0:	01312e23          	sw	s3,28(sp)
80005ee4:	01512a23          	sw	s5,20(sp)
80005ee8:	01612823          	sw	s6,16(sp)
80005eec:	01712623          	sw	s7,12(sp)
80005ef0:	01812423          	sw	s8,8(sp)
80005ef4:	01912223          	sw	s9,4(sp)
80005ef8:	01a12023          	sw	s10,0(sp)
80005efc:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005f00:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005f04:	f24fe0ef          	jal	ra,80004628 <z_time_slice>
80005f08:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005f0c:	80008937          	lui	s2,0x80008
80005f10:	97890513          	addi	a0,s2,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80005f14:	00847413          	andi	s0,s0,8
80005f18:	d84ff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80005f1c:	02051e63          	bnez	a0,80005f58 <z_clock_announce+0x90>
80005f20:	800074b7          	lui	s1,0x80007
80005f24:	800075b7          	lui	a1,0x80007
80005f28:	80007537          	lui	a0,0x80007
80005f2c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80005f30:	04e00693          	li	a3,78
80005f34:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80005f38:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80005f3c:	da0fc0ef          	jal	ra,800024dc <printk>
80005f40:	80007537          	lui	a0,0x80007
80005f44:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80005f48:	d94fc0ef          	jal	ra,800024dc <printk>
80005f4c:	04e00593          	li	a1,78
80005f50:	29048513          	addi	a0,s1,656
80005f54:	dc4fc0ef          	jal	ra,80002518 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005f58:	800089b7          	lui	s3,0x80008
	z_spin_lock_set_owner(l);
80005f5c:	97890513          	addi	a0,s2,-1672
80005f60:	d94ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
80005f64:	800084b7          	lui	s1,0x80008
80005f68:	9749aa23          	sw	s4,-1676(s3) # 80007974 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007975>
	return list->head == list;
80005f6c:	80008a37          	lui	s4,0x80008
80005f70:	97498993          	addi	s3,s3,-1676
80005f74:	8b8a0a13          	addi	s4,s4,-1864 # 800078b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078b9>
80005f78:	94048493          	addi	s1,s1,-1728 # 80007940 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007941>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005f7c:	80007ab7          	lui	s5,0x80007
80005f80:	80007bb7          	lui	s7,0x80007
80005f84:	80007b37          	lui	s6,0x80007
80005f88:	80007c37          	lui	s8,0x80007
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005f8c:	80007cb7          	lui	s9,0x80007
80005f90:	000a2d03          	lw	s10,0(s4)
80005f94:	0009a783          	lw	a5,0(s3)
80005f98:	0004a683          	lw	a3,0(s1)
80005f9c:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005fa0:	014d0c63          	beq	s10,s4,80005fb8 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005fa4:	000d0a63          	beqz	s10,80005fb8 <z_clock_announce+0xf0>
80005fa8:	008d2703          	lw	a4,8(s10)
80005fac:	0ae7dc63          	bge	a5,a4,80006064 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005fb0:	40f70733          	sub	a4,a4,a5
80005fb4:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005fb8:	00d786b3          	add	a3,a5,a3
80005fbc:	41f7d713          	srai	a4,a5,0x1f
80005fc0:	00a70733          	add	a4,a4,a0
80005fc4:	00f6b7b3          	sltu	a5,a3,a5
80005fc8:	00e787b3          	add	a5,a5,a4
80005fcc:	00d4a023          	sw	a3,0(s1)
80005fd0:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005fd4:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005fd8:	969ff0ef          	jal	ra,80005940 <next_timeout>
80005fdc:	00000593          	li	a1,0
80005fe0:	80dfc0ef          	jal	ra,800027ec <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005fe4:	97890513          	addi	a0,s2,-1672
80005fe8:	cdcff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80005fec:	02051e63          	bnez	a0,80006028 <z_clock_announce+0x160>
80005ff0:	800074b7          	lui	s1,0x80007
80005ff4:	800075b7          	lui	a1,0x80007
80005ff8:	80007537          	lui	a0,0x80007
80005ffc:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80006000:	06100693          	li	a3,97
80006004:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80006008:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000600c:	cd0fc0ef          	jal	ra,800024dc <printk>
80006010:	80007537          	lui	a0,0x80007
80006014:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
80006018:	cc4fc0ef          	jal	ra,800024dc <printk>
8000601c:	06100593          	li	a1,97
80006020:	29048513          	addi	a0,s1,656
80006024:	cf4fc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006028:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
8000602c:	02c12083          	lw	ra,44(sp)
80006030:	02812403          	lw	s0,40(sp)
80006034:	02412483          	lw	s1,36(sp)
80006038:	02012903          	lw	s2,32(sp)
8000603c:	01c12983          	lw	s3,28(sp)
80006040:	01812a03          	lw	s4,24(sp)
80006044:	01412a83          	lw	s5,20(sp)
80006048:	01012b03          	lw	s6,16(sp)
8000604c:	00c12b83          	lw	s7,12(sp)
80006050:	00812c03          	lw	s8,8(sp)
80006054:	00412c83          	lw	s9,4(sp)
80006058:	00012d03          	lw	s10,0(sp)
8000605c:	03010113          	addi	sp,sp,48
80006060:	00008067          	ret
		curr_tick += dt;
80006064:	00d706b3          	add	a3,a4,a3
80006068:	41f75593          	srai	a1,a4,0x1f
8000606c:	00a585b3          	add	a1,a1,a0
80006070:	00e6b633          	sltu	a2,a3,a4
80006074:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80006078:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
8000607c:	000d0513          	mv	a0,s10
		t->dticks = 0;
80006080:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80006084:	00d4a023          	sw	a3,0(s1)
80006088:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
8000608c:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80006090:	871ff0ef          	jal	ra,80005900 <remove_timeout>
80006094:	97890513          	addi	a0,s2,-1672
80006098:	c2cff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
8000609c:	02051663          	bnez	a0,800060c8 <z_clock_announce+0x200>
800060a0:	2d8b8593          	addi	a1,s7,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800060a4:	06100693          	li	a3,97
800060a8:	290a8613          	addi	a2,s5,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800060ac:	1c4b0513          	addi	a0,s6,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800060b0:	c2cfc0ef          	jal	ra,800024dc <printk>
800060b4:	2f0c0513          	addi	a0,s8,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800060b8:	c24fc0ef          	jal	ra,800024dc <printk>
800060bc:	06100593          	li	a1,97
800060c0:	290a8513          	addi	a0,s5,656
800060c4:	c54fc0ef          	jal	ra,80002518 <assert_post_action>
800060c8:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
800060cc:	00cd2783          	lw	a5,12(s10)
800060d0:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
800060d4:	00800413          	li	s0,8
800060d8:	000780e7          	jalr	a5
800060dc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800060e0:	97890513          	addi	a0,s2,-1672
	key = (mstatus & SOC_MSTATUS_IEN);
800060e4:	00847413          	andi	s0,s0,8
800060e8:	bb4ff0ef          	jal	ra,8000549c <z_spin_lock_valid>
800060ec:	02051863          	bnez	a0,8000611c <z_clock_announce+0x254>
800060f0:	2a8c8593          	addi	a1,s9,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
800060f4:	04e00693          	li	a3,78
800060f8:	290a8613          	addi	a2,s5,656
800060fc:	1c4b0513          	addi	a0,s6,452
80006100:	bdcfc0ef          	jal	ra,800024dc <printk>
80006104:	80007537          	lui	a0,0x80007
80006108:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
8000610c:	bd0fc0ef          	jal	ra,800024dc <printk>
80006110:	04e00593          	li	a1,78
80006114:	290a8513          	addi	a0,s5,656
80006118:	c00fc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
8000611c:	97890513          	addi	a0,s2,-1672
80006120:	bd4ff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	return k;
80006124:	e6dff06f          	j	80005f90 <z_clock_announce+0xc8>

80006128 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80006128:	fe010113          	addi	sp,sp,-32
8000612c:	00912a23          	sw	s1,20(sp)
80006130:	00112e23          	sw	ra,28(sp)
80006134:	00812c23          	sw	s0,24(sp)
80006138:	01212823          	sw	s2,16(sp)
8000613c:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006140:	00800493          	li	s1,8
80006144:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006148:	80008937          	lui	s2,0x80008
8000614c:	97890513          	addi	a0,s2,-1672 # 80007978 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007979>
	key = (mstatus & SOC_MSTATUS_IEN);
80006150:	0084f493          	andi	s1,s1,8
80006154:	b48ff0ef          	jal	ra,8000549c <z_spin_lock_valid>
80006158:	02051e63          	bnez	a0,80006194 <z_tick_get+0x6c>
8000615c:	80007437          	lui	s0,0x80007
80006160:	800075b7          	lui	a1,0x80007
80006164:	80007537          	lui	a0,0x80007
80006168:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
8000616c:	04e00693          	li	a3,78
80006170:	29040613          	addi	a2,s0,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80006174:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80006178:	b64fc0ef          	jal	ra,800024dc <printk>
8000617c:	80007537          	lui	a0,0x80007
80006180:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80006184:	b58fc0ef          	jal	ra,800024dc <printk>
80006188:	04e00593          	li	a1,78
8000618c:	29040513          	addi	a0,s0,656
80006190:	b88fc0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80006194:	97890513          	addi	a0,s2,-1672
80006198:	b5cff0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
8000619c:	fccfc0ef          	jal	ra,80002968 <z_clock_elapsed>
800061a0:	800087b7          	lui	a5,0x80008
800061a4:	94078793          	addi	a5,a5,-1728 # 80007940 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007941>
800061a8:	0007a983          	lw	s3,0(a5)
800061ac:	0047a403          	lw	s0,4(a5)
800061b0:	013509b3          	add	s3,a0,s3
800061b4:	00a9b533          	sltu	a0,s3,a0
800061b8:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800061bc:	97890513          	addi	a0,s2,-1672
800061c0:	b04ff0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
800061c4:	02051e63          	bnez	a0,80006200 <z_tick_get+0xd8>
800061c8:	80007937          	lui	s2,0x80007
800061cc:	800075b7          	lui	a1,0x80007
800061d0:	80007537          	lui	a0,0x80007
800061d4:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
800061d8:	06100693          	li	a3,97
800061dc:	29090613          	addi	a2,s2,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
800061e0:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800061e4:	af8fc0ef          	jal	ra,800024dc <printk>
800061e8:	80007537          	lui	a0,0x80007
800061ec:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800061f0:	aecfc0ef          	jal	ra,800024dc <printk>
800061f4:	06100593          	li	a1,97
800061f8:	29090513          	addi	a0,s2,656
800061fc:	b1cfc0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80006200:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80006204:	00040593          	mv	a1,s0
80006208:	01c12083          	lw	ra,28(sp)
8000620c:	01812403          	lw	s0,24(sp)
80006210:	00098513          	mv	a0,s3
80006214:	01412483          	lw	s1,20(sp)
80006218:	01012903          	lw	s2,16(sp)
8000621c:	00c12983          	lw	s3,12(sp)
80006220:	02010113          	addi	sp,sp,32
80006224:	00008067          	ret

80006228 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80006228:	ff010113          	addi	sp,sp,-16
8000622c:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80006230:	ef9ff0ef          	jal	ra,80006128 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80006234:	00c12083          	lw	ra,12(sp)
80006238:	01010113          	addi	sp,sp,16
8000623c:	00008067          	ret

80006240 <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
80006240:	ff010113          	addi	sp,sp,-16
80006244:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
80006248:	fe1ff0ef          	jal	ra,80006228 <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000624c:	3e800793          	li	a5,1000
80006250:	02f535b3          	mulhu	a1,a0,a5
80006254:	06400613          	li	a2,100
80006258:	00000693          	li	a3,0
8000625c:	02f50533          	mul	a0,a0,a5
80006260:	860fa0ef          	jal	ra,800002c0 <__udivdi3>
}
80006264:	00c12083          	lw	ra,12(sp)
80006268:	01010113          	addi	sp,sp,16
8000626c:	00008067          	ret

80006270 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80006270:	ff010113          	addi	sp,sp,-16
80006274:	00812423          	sw	s0,8(sp)
80006278:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000627c:	80008437          	lui	s0,0x80008
80006280:	800084b7          	lui	s1,0x80008
{
80006284:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006288:	8f840413          	addi	s0,s0,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
8000628c:	8f848493          	addi	s1,s1,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
80006290:	00946e63          	bltu	s0,s1,800062ac <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
80006294:	00c12083          	lw	ra,12(sp)
80006298:	00812403          	lw	s0,8(sp)
8000629c:	00412483          	lw	s1,4(sp)
800062a0:	00000513          	li	a0,0
800062a4:	01010113          	addi	sp,sp,16
800062a8:	00008067          	ret
800062ac:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800062b0:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800062b4:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800062b8:	00f42c23          	sw	a5,24(s0)
800062bc:	d24fb0ef          	jal	ra,800017e0 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800062c0:	01c40413          	addi	s0,s0,28
800062c4:	fcdff06f          	j	80006290 <init_static_pools+0x20>

800062c8 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800062c8:	800087b7          	lui	a5,0x80008
800062cc:	ce07a783          	lw	a5,-800(a5) # 80007ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce1>
{
800062d0:	fb010113          	addi	sp,sp,-80
800062d4:	04912223          	sw	s1,68(sp)
800062d8:	03312e23          	sw	s3,60(sp)
800062dc:	03412c23          	sw	s4,56(sp)
800062e0:	03712623          	sw	s7,44(sp)
800062e4:	04112623          	sw	ra,76(sp)
800062e8:	04812423          	sw	s0,72(sp)
800062ec:	05212023          	sw	s2,64(sp)
800062f0:	03512a23          	sw	s5,52(sp)
800062f4:	03612823          	sw	s6,48(sp)
800062f8:	03812423          	sw	s8,40(sp)
800062fc:	03912223          	sw	s9,36(sp)
80006300:	03a12023          	sw	s10,32(sp)
80006304:	01b12e23          	sw	s11,28(sp)
80006308:	00050a13          	mv	s4,a0
8000630c:	00058993          	mv	s3,a1
80006310:	00060b93          	mv	s7,a2
80006314:	00068493          	mv	s1,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006318:	16078263          	beqz	a5,8000647c <k_mem_pool_alloc+0x1b4>
8000631c:	12069463          	bnez	a3,80006444 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80006320:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80006324:	80008437          	lui	s0,0x80008
80006328:	8f840413          	addi	s0,s0,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
8000632c:	408a0433          	sub	s0,s4,s0
80006330:	b6db77b7          	lui	a5,0xb6db7
80006334:	40245413          	srai	s0,s0,0x2
80006338:	db778793          	addi	a5,a5,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
8000633c:	02f40433          	mul	s0,s0,a5
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80006340:	fffffab7          	lui	s5,0xfffff
		block->id.block = block_num;
80006344:	00001b37          	lui	s6,0x1
			if (ret != -EAGAIN) {
80006348:	ff500c13          	li	s8,-11
			ret = -ENOMEM;
8000634c:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80006350:	0ffa8a93          	addi	s5,s5,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80006354:	fffb0b13          	addi	s6,s6,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006358:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
8000635c:	014a0d93          	addi	s11,s4,20
		block->id.pool = pool_id(p);
80006360:	0ff47413          	andi	s0,s0,255
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006364:	00098713          	mv	a4,s3
80006368:	00c10693          	addi	a3,sp,12
8000636c:	00810613          	addi	a2,sp,8
80006370:	000b8593          	mv	a1,s7
80006374:	000a0513          	mv	a0,s4
80006378:	d68fb0ef          	jal	ra,800018e0 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000637c:	03851263          	bne	a0,s8,800063a0 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80006380:	00098713          	mv	a4,s3
80006384:	00c10693          	addi	a3,sp,12
80006388:	00810613          	addi	a2,sp,8
8000638c:	000b8593          	mv	a1,s7
80006390:	000a0513          	mv	a0,s4
80006394:	d4cfb0ef          	jal	ra,800018e0 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80006398:	01851463          	bne	a0,s8,800063a0 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
8000639c:	ff400513          	li	a0,-12
		block->id.level = level_num;
800063a0:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
800063a4:	00898223          	sb	s0,4(s3)
		block->id.level = level_num;
800063a8:	00f7f793          	andi	a5,a5,15
800063ac:	00879713          	slli	a4,a5,0x8
800063b0:	0049a783          	lw	a5,4(s3)
800063b4:	0157f7b3          	and	a5,a5,s5
800063b8:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
800063bc:	00c12703          	lw	a4,12(sp)
800063c0:	0167f7b3          	and	a5,a5,s6
800063c4:	00c71713          	slli	a4,a4,0xc
800063c8:	00e7e7b3          	or	a5,a5,a4
800063cc:	00f9a223          	sw	a5,4(s3)
		if (ret == 0 || timeout == K_NO_WAIT ||
800063d0:	02050c63          	beqz	a0,80006408 <k_mem_pool_alloc+0x140>
800063d4:	02048a63          	beqz	s1,80006408 <k_mem_pool_alloc+0x140>
800063d8:	03951863          	bne	a0,s9,80006408 <k_mem_pool_alloc+0x140>
800063dc:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800063e0:	00048613          	mv	a2,s1
800063e4:	000d8593          	mv	a1,s11
800063e8:	00857513          	andi	a0,a0,8
800063ec:	cf4fe0ef          	jal	ra,800048e0 <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
800063f0:	fff00793          	li	a5,-1
800063f4:	f6f488e3          	beq	s1,a5,80006364 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
800063f8:	d31ff0ef          	jal	ra,80006128 <z_tick_get>
800063fc:	40a904b3          	sub	s1,s2,a0

			if (timeout < 0) {
80006400:	f604d2e3          	bgez	s1,80006364 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80006404:	ff500513          	li	a0,-11
}
80006408:	04c12083          	lw	ra,76(sp)
8000640c:	04812403          	lw	s0,72(sp)
80006410:	04412483          	lw	s1,68(sp)
80006414:	04012903          	lw	s2,64(sp)
80006418:	03c12983          	lw	s3,60(sp)
8000641c:	03812a03          	lw	s4,56(sp)
80006420:	03412a83          	lw	s5,52(sp)
80006424:	03012b03          	lw	s6,48(sp)
80006428:	02c12b83          	lw	s7,44(sp)
8000642c:	02812c03          	lw	s8,40(sp)
80006430:	02412c83          	lw	s9,36(sp)
80006434:	02012d03          	lw	s10,32(sp)
80006438:	01c12d83          	lw	s11,28(sp)
8000643c:	05010113          	addi	sp,sp,80
80006440:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80006444:	80007437          	lui	s0,0x80007
80006448:	800075b7          	lui	a1,0x80007
8000644c:	80007537          	lui	a0,0x80007
80006450:	7cc58593          	addi	a1,a1,1996 # 800077cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077cd>
80006454:	03900693          	li	a3,57
80006458:	7b840613          	addi	a2,s0,1976 # 800077b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077b9>
8000645c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
80006460:	87cfc0ef          	jal	ra,800024dc <printk>
80006464:	80007537          	lui	a0,0x80007
80006468:	24850513          	addi	a0,a0,584 # 80007248 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007249>
8000646c:	870fc0ef          	jal	ra,800024dc <printk>
80006470:	03900593          	li	a1,57
80006474:	7b840513          	addi	a0,s0,1976
80006478:	8a0fc0ef          	jal	ra,80002518 <assert_post_action>
	if (timeout > 0) {
8000647c:	ea9052e3          	blez	s1,80006320 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80006480:	ca9ff0ef          	jal	ra,80006128 <z_tick_get>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80006484:	00948913          	addi	s2,s1,9
80006488:	00a00793          	li	a5,10
8000648c:	02f94933          	div	s2,s2,a5
80006490:	00a90933          	add	s2,s2,a0
80006494:	e91ff06f          	j	80006324 <k_mem_pool_alloc+0x5c>

80006498 <k_mem_pool_free_id>:

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
80006498:	fe010113          	addi	sp,sp,-32
8000649c:	01212823          	sw	s2,16(sp)
800064a0:	00054903          	lbu	s2,0(a0)
800064a4:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800064a8:	00052603          	lw	a2,0(a0)
800064ac:	02f90933          	mul	s2,s2,a5
{
800064b0:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800064b4:	800089b7          	lui	s3,0x80008
800064b8:	00865593          	srli	a1,a2,0x8
800064bc:	8f898513          	addi	a0,s3,-1800 # 800078f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f9>
800064c0:	00c65613          	srli	a2,a2,0xc
800064c4:	00f5f593          	andi	a1,a1,15
{
800064c8:	00812c23          	sw	s0,24(sp)
800064cc:	00112e23          	sw	ra,28(sp)
800064d0:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800064d4:	01250533          	add	a0,a0,s2
{
800064d8:	01412423          	sw	s4,8(sp)
800064dc:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800064e0:	ec8fb0ef          	jal	ra,80001ba8 <z_sys_mem_pool_block_free>
800064e4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800064e8:	800084b7          	lui	s1,0x80008
800064ec:	97c48513          	addi	a0,s1,-1668 # 8000797c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000797d>
800064f0:	fadfe0ef          	jal	ra,8000549c <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
800064f4:	00847413          	andi	s0,s0,8
800064f8:	8f898993          	addi	s3,s3,-1800
800064fc:	02051e63          	bnez	a0,80006538 <k_mem_pool_free_id+0xa0>
80006500:	80007a37          	lui	s4,0x80007
80006504:	800075b7          	lui	a1,0x80007
80006508:	80007537          	lui	a0,0x80007
8000650c:	2a858593          	addi	a1,a1,680 # 800072a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a9>
80006510:	04e00693          	li	a3,78
80006514:	290a0613          	addi	a2,s4,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
80006518:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
8000651c:	fc1fb0ef          	jal	ra,800024dc <printk>
80006520:	80007537          	lui	a0,0x80007
80006524:	2c050513          	addi	a0,a0,704 # 800072c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c1>
80006528:	fb5fb0ef          	jal	ra,800024dc <printk>
8000652c:	04e00593          	li	a1,78
80006530:	290a0513          	addi	a0,s4,656
80006534:	fe5fb0ef          	jal	ra,80002518 <assert_post_action>
	z_spin_lock_set_owner(l);
80006538:	97c48513          	addi	a0,s1,-1668
8000653c:	fb9fe0ef          	jal	ra,800054f4 <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80006540:	01490513          	addi	a0,s2,20
80006544:	00a98533          	add	a0,s3,a0
80006548:	e08fe0ef          	jal	ra,80004b50 <z_unpend_all>

	if (need_sched != 0) {
8000654c:	02050663          	beqz	a0,80006578 <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
80006550:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
80006554:	01812403          	lw	s0,24(sp)
80006558:	01c12083          	lw	ra,28(sp)
8000655c:	01012903          	lw	s2,16(sp)
80006560:	00c12983          	lw	s3,12(sp)
80006564:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80006568:	97c48513          	addi	a0,s1,-1668
}
8000656c:	01412483          	lw	s1,20(sp)
80006570:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80006574:	dd8fd06f          	j	80003b4c <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006578:	97c48513          	addi	a0,s1,-1668
8000657c:	f49fe0ef          	jal	ra,800054c4 <z_spin_unlock_valid>
80006580:	02051e63          	bnez	a0,800065bc <k_mem_pool_free_id+0x124>
80006584:	800074b7          	lui	s1,0x80007
80006588:	800075b7          	lui	a1,0x80007
8000658c:	80007537          	lui	a0,0x80007
80006590:	2d858593          	addi	a1,a1,728 # 800072d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072d9>
80006594:	06100693          	li	a3,97
80006598:	29048613          	addi	a2,s1,656 # 80007290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007291>
8000659c:	1c450513          	addi	a0,a0,452 # 800071c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071c5>
800065a0:	f3dfb0ef          	jal	ra,800024dc <printk>
800065a4:	80007537          	lui	a0,0x80007
800065a8:	2f050513          	addi	a0,a0,752 # 800072f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072f1>
800065ac:	f31fb0ef          	jal	ra,800024dc <printk>
800065b0:	06100593          	li	a1,97
800065b4:	29048513          	addi	a0,s1,656
800065b8:	f61fb0ef          	jal	ra,80002518 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800065bc:	30042473          	csrrs	s0,mstatus,s0
}
800065c0:	01c12083          	lw	ra,28(sp)
800065c4:	01812403          	lw	s0,24(sp)
800065c8:	01412483          	lw	s1,20(sp)
800065cc:	01012903          	lw	s2,16(sp)
800065d0:	00c12983          	lw	s3,12(sp)
800065d4:	00812a03          	lw	s4,8(sp)
800065d8:	02010113          	addi	sp,sp,32
800065dc:	00008067          	ret

800065e0 <k_mem_pool_malloc>:

	/*
	 * get a block large enough to hold an initial (hidden) block
	 * descriptor, as well as the space the caller requested
	 */
	if (__builtin_add_overflow(size, sizeof(struct k_mem_block_id),
800065e0:	00458613          	addi	a2,a1,4
800065e4:	00b67e63          	bgeu	a2,a1,80006600 <k_mem_pool_malloc+0x20>
				   &size)) {
		return NULL;
800065e8:	00000513          	li	a0,0
	/* save the block descriptor info at the start of the actual block */
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));

	/* return address of the user area part of the block to the caller */
	return (char *)block.data + sizeof(struct k_mem_block_id);
}
800065ec:	00008067          	ret
		return NULL;
800065f0:	00000513          	li	a0,0
}
800065f4:	01c12083          	lw	ra,28(sp)
800065f8:	02010113          	addi	sp,sp,32
800065fc:	00008067          	ret
{
80006600:	fe010113          	addi	sp,sp,-32
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006604:	00000693          	li	a3,0
80006608:	00810593          	addi	a1,sp,8
{
8000660c:	00112e23          	sw	ra,28(sp)
	if (k_mem_pool_alloc(pool, &block, size, K_NO_WAIT) != 0) {
80006610:	cb9ff0ef          	jal	ra,800062c8 <k_mem_pool_alloc>
80006614:	fc051ee3          	bnez	a0,800065f0 <k_mem_pool_malloc+0x10>
	(void)memcpy(block.data, &block.id, sizeof(struct k_mem_block_id));
80006618:	00812503          	lw	a0,8(sp)
8000661c:	00400613          	li	a2,4
80006620:	00c10593          	addi	a1,sp,12
80006624:	c58fc0ef          	jal	ra,80002a7c <memcpy>
	return (char *)block.data + sizeof(struct k_mem_block_id);
80006628:	00812503          	lw	a0,8(sp)
8000662c:	00450513          	addi	a0,a0,4
80006630:	fc5ff06f          	j	800065f4 <k_mem_pool_malloc+0x14>

80006634 <k_free>:

void k_free(void *ptr)
{
	if (ptr != NULL) {
80006634:	00050663          	beqz	a0,80006640 <k_free+0xc>
		/* point to hidden block descriptor at start of block */
		ptr = (char *)ptr - sizeof(struct k_mem_block_id);

		/* return block to the heap memory pool */
		k_mem_pool_free_id(ptr);
80006638:	ffc50513          	addi	a0,a0,-4
8000663c:	e5dff06f          	j	80006498 <k_mem_pool_free_id>
	}
}
80006640:	00008067          	ret

80006644 <z_thread_malloc>:

void *z_thread_malloc(size_t size)
{
	void *ret;

	if (_current->resource_pool != NULL) {
80006644:	800087b7          	lui	a5,0x80008
80006648:	ce87a783          	lw	a5,-792(a5) # 80007ce8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ce9>
{
8000664c:	00050593          	mv	a1,a0
	if (_current->resource_pool != NULL) {
80006650:	0687a503          	lw	a0,104(a5)
80006654:	00050463          	beqz	a0,8000665c <z_thread_malloc+0x18>
		ret = k_mem_pool_malloc(_current->resource_pool, size);
80006658:	f89ff06f          	j	800065e0 <k_mem_pool_malloc>
	} else {
		ret = NULL;
	}

	return ret;
}
8000665c:	00000513          	li	a0,0
80006660:	00008067          	ret

80006664 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80006664:	00008067          	ret
