
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	0e90006f          	j	800008f4 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1ae000ef          	jal	ra,800001f4 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e905                	bnez	a0,8000007e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	11e08093          	addi	ra,ra,286 # 80000188 <no_reschedule>
	tail _Fault
80000072:	4410006f          	j	80000cb2 <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000007c:	a041                	j	800000fc <reschedule>

8000007e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000007e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000082:	00005397          	auipc	t2,0x5
80000086:	50238393          	addi	t2,t2,1282 # 80005584 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000008a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000008e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
80000090:	c016                	sw	t0,0(sp)

80000092 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
80000092:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
80000096:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
80000098:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
8000009c:	00030863          	beqz	t1,800000ac <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000a0:	00000097          	auipc	ra,0x0
800000a4:	03808093          	addi	ra,ra,56 # 800000d8 <on_thread_stack>
	tail z_irq_do_offload
800000a8:	4710006f          	j	80000d18 <z_irq_do_offload>

800000ac <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000ac:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000b0:	800002b7          	lui	t0,0x80000
800000b4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000b8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000bc:	128000ef          	jal	ra,800001e4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000c0:	00004297          	auipc	t0,0x4
800000c4:	2e828293          	addi	t0,t0,744 # 800043a8 <_image_text_end>
	slli a0, a0, 3
800000c8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000ca:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000cc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000d0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000d4:	000300e7          	jalr	t1

800000d8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000d8:	00005317          	auipc	t1,0x5
800000dc:	4ac30313          	addi	t1,t1,1196 # 80005584 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000e0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000e4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000e6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000ea:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000ec:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
800000f0:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
800000f4:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
800000f8:	087e0863          	beq	t3,t2,80000188 <no_reschedule>

800000fc <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
800000fc:	00005297          	auipc	t0,0x5
80000100:	48828293          	addi	t0,t0,1160 # 80005584 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000104:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000108:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000010c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000110:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000114:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000118:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000011c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000120:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000124:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000128:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000012c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000130:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000134:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000138:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000013c:	00005397          	auipc	t2,0x5
80000140:	0a038393          	addi	t2,t2,160 # 800051dc <_k_neg_eagain>
	lw t3, 0x00(t2)
80000144:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000148:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000014c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000150:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000154:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000158:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000015c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000160:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000164:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000168:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000016c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000170:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000174:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000178:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000017c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000180:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000184:	05832d83          	lw	s11,88(t1)

80000188 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000188:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000018a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000018e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
80000190:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
80000194:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
80000196:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
80000198:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
8000019a:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
8000019c:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
8000019e:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001a0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001a2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001a4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001a6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001a8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001aa:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001ac:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001ae:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001b0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001b2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001b4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001b6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001b8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ba:	30200073          	mret
	...

800001c0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001c0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001c4:	00005297          	auipc	t0,0x5
800001c8:	3c028293          	addi	t0,t0,960 # 80005584 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001cc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001d0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001d4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001d6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001da:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001de:	00008067          	ret
	...

800001e4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001e4:	4305                	li	t1,1
	sll t0, t1, a0
800001e6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001ea:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
800001f4:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
800001f8:	80000337          	lui	t1,0x80000
	and t0, t0, t1
800001fc:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000200:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000204:	00028363          	beqz	t0,8000020a <not_interrupt>
	addi a0, a0, 1
80000208:	0505                	addi	a0,a0,1

8000020a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000020a:	00008067          	ret

Disassembly of section text:

80000210 <__lshrdi3>:
80000210:	02060063          	beqz	a2,80000230 <__lshrdi3+0x20>
80000214:	02000793          	li	a5,32
80000218:	40c787b3          	sub	a5,a5,a2
8000021c:	00f04c63          	bgtz	a5,80000234 <__lshrdi3+0x24>
80000220:	fe060513          	addi	a0,a2,-32
80000224:	00000713          	li	a4,0
80000228:	00a5d533          	srl	a0,a1,a0
8000022c:	00070593          	mv	a1,a4
80000230:	00008067          	ret
80000234:	00c5d733          	srl	a4,a1,a2
80000238:	00c55533          	srl	a0,a0,a2
8000023c:	00f595b3          	sll	a1,a1,a5
80000240:	00b56533          	or	a0,a0,a1
80000244:	fe9ff06f          	j	8000022c <__lshrdi3+0x1c>

80000248 <__udivdi3>:
80000248:	fd010113          	addi	sp,sp,-48
8000024c:	02912223          	sw	s1,36(sp)
80000250:	01612823          	sw	s6,16(sp)
80000254:	02112623          	sw	ra,44(sp)
80000258:	02812423          	sw	s0,40(sp)
8000025c:	03212023          	sw	s2,32(sp)
80000260:	01312e23          	sw	s3,28(sp)
80000264:	01412c23          	sw	s4,24(sp)
80000268:	01512a23          	sw	s5,20(sp)
8000026c:	01712623          	sw	s7,12(sp)
80000270:	01812423          	sw	s8,8(sp)
80000274:	01912223          	sw	s9,4(sp)
80000278:	00050b13          	mv	s6,a0
8000027c:	00058493          	mv	s1,a1
80000280:	38069c63          	bnez	a3,80000618 <__udivdi3+0x3d0>
80000284:	00060413          	mv	s0,a2
80000288:	00050993          	mv	s3,a0
8000028c:	00004917          	auipc	s2,0x4
80000290:	2a890913          	addi	s2,s2,680 # 80004534 <__devconfig_end>
80000294:	12c5f863          	bgeu	a1,a2,800003c4 <__udivdi3+0x17c>
80000298:	000107b7          	lui	a5,0x10
8000029c:	00058a93          	mv	s5,a1
800002a0:	10f67863          	bgeu	a2,a5,800003b0 <__udivdi3+0x168>
800002a4:	0ff00693          	li	a3,255
800002a8:	00c6b6b3          	sltu	a3,a3,a2
800002ac:	00369693          	slli	a3,a3,0x3
800002b0:	00d657b3          	srl	a5,a2,a3
800002b4:	00f90933          	add	s2,s2,a5
800002b8:	00094703          	lbu	a4,0(s2)
800002bc:	00d706b3          	add	a3,a4,a3
800002c0:	02000713          	li	a4,32
800002c4:	40d70733          	sub	a4,a4,a3
800002c8:	00070c63          	beqz	a4,800002e0 <__udivdi3+0x98>
800002cc:	00e494b3          	sll	s1,s1,a4
800002d0:	00db56b3          	srl	a3,s6,a3
800002d4:	00e61433          	sll	s0,a2,a4
800002d8:	0096eab3          	or	s5,a3,s1
800002dc:	00eb19b3          	sll	s3,s6,a4
800002e0:	01045b13          	srli	s6,s0,0x10
800002e4:	000b0593          	mv	a1,s6
800002e8:	000a8513          	mv	a0,s5
800002ec:	5a4000ef          	jal	ra,80000890 <__umodsi3>
800002f0:	00050913          	mv	s2,a0
800002f4:	000b0593          	mv	a1,s6
800002f8:	01041b93          	slli	s7,s0,0x10
800002fc:	000a8513          	mv	a0,s5
80000300:	548000ef          	jal	ra,80000848 <__udivsi3>
80000304:	010bdb93          	srli	s7,s7,0x10
80000308:	00050493          	mv	s1,a0
8000030c:	00050593          	mv	a1,a0
80000310:	000b8513          	mv	a0,s7
80000314:	508000ef          	jal	ra,8000081c <__mulsi3>
80000318:	01091913          	slli	s2,s2,0x10
8000031c:	0109d713          	srli	a4,s3,0x10
80000320:	00e96733          	or	a4,s2,a4
80000324:	00048a13          	mv	s4,s1
80000328:	00a77e63          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000032c:	00870733          	add	a4,a4,s0
80000330:	fff48a13          	addi	s4,s1,-1
80000334:	00876863          	bltu	a4,s0,80000344 <__udivdi3+0xfc>
80000338:	00a77663          	bgeu	a4,a0,80000344 <__udivdi3+0xfc>
8000033c:	ffe48a13          	addi	s4,s1,-2
80000340:	00870733          	add	a4,a4,s0
80000344:	40a704b3          	sub	s1,a4,a0
80000348:	000b0593          	mv	a1,s6
8000034c:	00048513          	mv	a0,s1
80000350:	540000ef          	jal	ra,80000890 <__umodsi3>
80000354:	00050913          	mv	s2,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	4e8000ef          	jal	ra,80000848 <__udivsi3>
80000364:	01099993          	slli	s3,s3,0x10
80000368:	00050493          	mv	s1,a0
8000036c:	00050593          	mv	a1,a0
80000370:	01091913          	slli	s2,s2,0x10
80000374:	000b8513          	mv	a0,s7
80000378:	0109d993          	srli	s3,s3,0x10
8000037c:	4a0000ef          	jal	ra,8000081c <__mulsi3>
80000380:	013969b3          	or	s3,s2,s3
80000384:	00048613          	mv	a2,s1
80000388:	00a9fc63          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000038c:	013409b3          	add	s3,s0,s3
80000390:	fff48613          	addi	a2,s1,-1
80000394:	0089e663          	bltu	s3,s0,800003a0 <__udivdi3+0x158>
80000398:	00a9f463          	bgeu	s3,a0,800003a0 <__udivdi3+0x158>
8000039c:	ffe48613          	addi	a2,s1,-2
800003a0:	010a1793          	slli	a5,s4,0x10
800003a4:	00c7e7b3          	or	a5,a5,a2
800003a8:	00000a13          	li	s4,0
800003ac:	1300006f          	j	800004dc <__udivdi3+0x294>
800003b0:	010007b7          	lui	a5,0x1000
800003b4:	01000693          	li	a3,16
800003b8:	eef66ce3          	bltu	a2,a5,800002b0 <__udivdi3+0x68>
800003bc:	01800693          	li	a3,24
800003c0:	ef1ff06f          	j	800002b0 <__udivdi3+0x68>
800003c4:	00068a13          	mv	s4,a3
800003c8:	00061a63          	bnez	a2,800003dc <__udivdi3+0x194>
800003cc:	00000593          	li	a1,0
800003d0:	00100513          	li	a0,1
800003d4:	474000ef          	jal	ra,80000848 <__udivsi3>
800003d8:	00050413          	mv	s0,a0
800003dc:	000107b7          	lui	a5,0x10
800003e0:	12f47c63          	bgeu	s0,a5,80000518 <__udivdi3+0x2d0>
800003e4:	0ff00793          	li	a5,255
800003e8:	0087f463          	bgeu	a5,s0,800003f0 <__udivdi3+0x1a8>
800003ec:	00800a13          	li	s4,8
800003f0:	014457b3          	srl	a5,s0,s4
800003f4:	00f90933          	add	s2,s2,a5
800003f8:	00094683          	lbu	a3,0(s2)
800003fc:	02000613          	li	a2,32
80000400:	014686b3          	add	a3,a3,s4
80000404:	40d60633          	sub	a2,a2,a3
80000408:	12061263          	bnez	a2,8000052c <__udivdi3+0x2e4>
8000040c:	408484b3          	sub	s1,s1,s0
80000410:	00100a13          	li	s4,1
80000414:	01045b13          	srli	s6,s0,0x10
80000418:	000b0593          	mv	a1,s6
8000041c:	00048513          	mv	a0,s1
80000420:	470000ef          	jal	ra,80000890 <__umodsi3>
80000424:	00050913          	mv	s2,a0
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	01041b93          	slli	s7,s0,0x10
80000434:	414000ef          	jal	ra,80000848 <__udivsi3>
80000438:	010bdb93          	srli	s7,s7,0x10
8000043c:	00050493          	mv	s1,a0
80000440:	00050593          	mv	a1,a0
80000444:	000b8513          	mv	a0,s7
80000448:	3d4000ef          	jal	ra,8000081c <__mulsi3>
8000044c:	01091913          	slli	s2,s2,0x10
80000450:	0109d713          	srli	a4,s3,0x10
80000454:	00e96733          	or	a4,s2,a4
80000458:	00048a93          	mv	s5,s1
8000045c:	00a77e63          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000460:	00870733          	add	a4,a4,s0
80000464:	fff48a93          	addi	s5,s1,-1
80000468:	00876863          	bltu	a4,s0,80000478 <__udivdi3+0x230>
8000046c:	00a77663          	bgeu	a4,a0,80000478 <__udivdi3+0x230>
80000470:	ffe48a93          	addi	s5,s1,-2
80000474:	00870733          	add	a4,a4,s0
80000478:	40a704b3          	sub	s1,a4,a0
8000047c:	000b0593          	mv	a1,s6
80000480:	00048513          	mv	a0,s1
80000484:	40c000ef          	jal	ra,80000890 <__umodsi3>
80000488:	00050913          	mv	s2,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	3b4000ef          	jal	ra,80000848 <__udivsi3>
80000498:	01099993          	slli	s3,s3,0x10
8000049c:	00050493          	mv	s1,a0
800004a0:	00050593          	mv	a1,a0
800004a4:	01091913          	slli	s2,s2,0x10
800004a8:	000b8513          	mv	a0,s7
800004ac:	0109d993          	srli	s3,s3,0x10
800004b0:	36c000ef          	jal	ra,8000081c <__mulsi3>
800004b4:	013969b3          	or	s3,s2,s3
800004b8:	00048613          	mv	a2,s1
800004bc:	00a9fc63          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004c0:	013409b3          	add	s3,s0,s3
800004c4:	fff48613          	addi	a2,s1,-1
800004c8:	0089e663          	bltu	s3,s0,800004d4 <__udivdi3+0x28c>
800004cc:	00a9f463          	bgeu	s3,a0,800004d4 <__udivdi3+0x28c>
800004d0:	ffe48613          	addi	a2,s1,-2
800004d4:	010a9793          	slli	a5,s5,0x10
800004d8:	00c7e7b3          	or	a5,a5,a2
800004dc:	00078513          	mv	a0,a5
800004e0:	000a0593          	mv	a1,s4
800004e4:	02c12083          	lw	ra,44(sp)
800004e8:	02812403          	lw	s0,40(sp)
800004ec:	02412483          	lw	s1,36(sp)
800004f0:	02012903          	lw	s2,32(sp)
800004f4:	01c12983          	lw	s3,28(sp)
800004f8:	01812a03          	lw	s4,24(sp)
800004fc:	01412a83          	lw	s5,20(sp)
80000500:	01012b03          	lw	s6,16(sp)
80000504:	00c12b83          	lw	s7,12(sp)
80000508:	00812c03          	lw	s8,8(sp)
8000050c:	00412c83          	lw	s9,4(sp)
80000510:	03010113          	addi	sp,sp,48
80000514:	00008067          	ret
80000518:	010007b7          	lui	a5,0x1000
8000051c:	01000a13          	li	s4,16
80000520:	ecf468e3          	bltu	s0,a5,800003f0 <__udivdi3+0x1a8>
80000524:	01800a13          	li	s4,24
80000528:	ec9ff06f          	j	800003f0 <__udivdi3+0x1a8>
8000052c:	00c41433          	sll	s0,s0,a2
80000530:	00d4da33          	srl	s4,s1,a3
80000534:	00cb19b3          	sll	s3,s6,a2
80000538:	00db56b3          	srl	a3,s6,a3
8000053c:	01045b13          	srli	s6,s0,0x10
80000540:	00c494b3          	sll	s1,s1,a2
80000544:	000b0593          	mv	a1,s6
80000548:	000a0513          	mv	a0,s4
8000054c:	0096eab3          	or	s5,a3,s1
80000550:	340000ef          	jal	ra,80000890 <__umodsi3>
80000554:	00050913          	mv	s2,a0
80000558:	000b0593          	mv	a1,s6
8000055c:	000a0513          	mv	a0,s4
80000560:	01041b93          	slli	s7,s0,0x10
80000564:	2e4000ef          	jal	ra,80000848 <__udivsi3>
80000568:	010bdb93          	srli	s7,s7,0x10
8000056c:	00050493          	mv	s1,a0
80000570:	00050593          	mv	a1,a0
80000574:	000b8513          	mv	a0,s7
80000578:	2a4000ef          	jal	ra,8000081c <__mulsi3>
8000057c:	01091913          	slli	s2,s2,0x10
80000580:	010ad713          	srli	a4,s5,0x10
80000584:	00e96733          	or	a4,s2,a4
80000588:	00048a13          	mv	s4,s1
8000058c:	00a77e63          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
80000590:	00870733          	add	a4,a4,s0
80000594:	fff48a13          	addi	s4,s1,-1
80000598:	00876863          	bltu	a4,s0,800005a8 <__udivdi3+0x360>
8000059c:	00a77663          	bgeu	a4,a0,800005a8 <__udivdi3+0x360>
800005a0:	ffe48a13          	addi	s4,s1,-2
800005a4:	00870733          	add	a4,a4,s0
800005a8:	40a704b3          	sub	s1,a4,a0
800005ac:	000b0593          	mv	a1,s6
800005b0:	00048513          	mv	a0,s1
800005b4:	2dc000ef          	jal	ra,80000890 <__umodsi3>
800005b8:	00050913          	mv	s2,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	284000ef          	jal	ra,80000848 <__udivsi3>
800005c8:	00050493          	mv	s1,a0
800005cc:	00050593          	mv	a1,a0
800005d0:	000b8513          	mv	a0,s7
800005d4:	248000ef          	jal	ra,8000081c <__mulsi3>
800005d8:	010a9693          	slli	a3,s5,0x10
800005dc:	01091913          	slli	s2,s2,0x10
800005e0:	0106d693          	srli	a3,a3,0x10
800005e4:	00d967b3          	or	a5,s2,a3
800005e8:	00048713          	mv	a4,s1
800005ec:	00a7fe63          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
800005f0:	008787b3          	add	a5,a5,s0
800005f4:	fff48713          	addi	a4,s1,-1
800005f8:	0087e863          	bltu	a5,s0,80000608 <__udivdi3+0x3c0>
800005fc:	00a7f663          	bgeu	a5,a0,80000608 <__udivdi3+0x3c0>
80000600:	ffe48713          	addi	a4,s1,-2
80000604:	008787b3          	add	a5,a5,s0
80000608:	010a1a13          	slli	s4,s4,0x10
8000060c:	40a784b3          	sub	s1,a5,a0
80000610:	00ea6a33          	or	s4,s4,a4
80000614:	e01ff06f          	j	80000414 <__udivdi3+0x1cc>
80000618:	1ed5ec63          	bltu	a1,a3,80000810 <__udivdi3+0x5c8>
8000061c:	000107b7          	lui	a5,0x10
80000620:	04f6f463          	bgeu	a3,a5,80000668 <__udivdi3+0x420>
80000624:	0ff00593          	li	a1,255
80000628:	00d5b533          	sltu	a0,a1,a3
8000062c:	00351513          	slli	a0,a0,0x3
80000630:	00a6d733          	srl	a4,a3,a0
80000634:	00004797          	auipc	a5,0x4
80000638:	f0078793          	addi	a5,a5,-256 # 80004534 <__devconfig_end>
8000063c:	00e787b3          	add	a5,a5,a4
80000640:	0007c583          	lbu	a1,0(a5)
80000644:	02000a13          	li	s4,32
80000648:	00a585b3          	add	a1,a1,a0
8000064c:	40ba0a33          	sub	s4,s4,a1
80000650:	020a1663          	bnez	s4,8000067c <__udivdi3+0x434>
80000654:	00100793          	li	a5,1
80000658:	e896e2e3          	bltu	a3,s1,800004dc <__udivdi3+0x294>
8000065c:	00cb3633          	sltu	a2,s6,a2
80000660:	00164793          	xori	a5,a2,1
80000664:	e79ff06f          	j	800004dc <__udivdi3+0x294>
80000668:	010007b7          	lui	a5,0x1000
8000066c:	01000513          	li	a0,16
80000670:	fcf6e0e3          	bltu	a3,a5,80000630 <__udivdi3+0x3e8>
80000674:	01800513          	li	a0,24
80000678:	fb9ff06f          	j	80000630 <__udivdi3+0x3e8>
8000067c:	00b65ab3          	srl	s5,a2,a1
80000680:	014696b3          	sll	a3,a3,s4
80000684:	00daeab3          	or	s5,s5,a3
80000688:	00b4d933          	srl	s2,s1,a1
8000068c:	014497b3          	sll	a5,s1,s4
80000690:	00bb55b3          	srl	a1,s6,a1
80000694:	010adb93          	srli	s7,s5,0x10
80000698:	00f5e4b3          	or	s1,a1,a5
8000069c:	00090513          	mv	a0,s2
800006a0:	000b8593          	mv	a1,s7
800006a4:	014619b3          	sll	s3,a2,s4
800006a8:	1e8000ef          	jal	ra,80000890 <__umodsi3>
800006ac:	00050413          	mv	s0,a0
800006b0:	000b8593          	mv	a1,s7
800006b4:	00090513          	mv	a0,s2
800006b8:	010a9c13          	slli	s8,s5,0x10
800006bc:	18c000ef          	jal	ra,80000848 <__udivsi3>
800006c0:	010c5c13          	srli	s8,s8,0x10
800006c4:	00050913          	mv	s2,a0
800006c8:	00050593          	mv	a1,a0
800006cc:	000c0513          	mv	a0,s8
800006d0:	14c000ef          	jal	ra,8000081c <__mulsi3>
800006d4:	01041413          	slli	s0,s0,0x10
800006d8:	0104d713          	srli	a4,s1,0x10
800006dc:	00e46733          	or	a4,s0,a4
800006e0:	00090c93          	mv	s9,s2
800006e4:	00a77e63          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006e8:	01570733          	add	a4,a4,s5
800006ec:	fff90c93          	addi	s9,s2,-1
800006f0:	01576863          	bltu	a4,s5,80000700 <__udivdi3+0x4b8>
800006f4:	00a77663          	bgeu	a4,a0,80000700 <__udivdi3+0x4b8>
800006f8:	ffe90c93          	addi	s9,s2,-2
800006fc:	01570733          	add	a4,a4,s5
80000700:	40a70933          	sub	s2,a4,a0
80000704:	000b8593          	mv	a1,s7
80000708:	00090513          	mv	a0,s2
8000070c:	184000ef          	jal	ra,80000890 <__umodsi3>
80000710:	00050413          	mv	s0,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	12c000ef          	jal	ra,80000848 <__udivsi3>
80000720:	00050913          	mv	s2,a0
80000724:	00050593          	mv	a1,a0
80000728:	000c0513          	mv	a0,s8
8000072c:	0f0000ef          	jal	ra,8000081c <__mulsi3>
80000730:	01049793          	slli	a5,s1,0x10
80000734:	01041413          	slli	s0,s0,0x10
80000738:	0107d793          	srli	a5,a5,0x10
8000073c:	00f46733          	or	a4,s0,a5
80000740:	00090613          	mv	a2,s2
80000744:	00a77e63          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000748:	01570733          	add	a4,a4,s5
8000074c:	fff90613          	addi	a2,s2,-1
80000750:	01576863          	bltu	a4,s5,80000760 <__udivdi3+0x518>
80000754:	00a77663          	bgeu	a4,a0,80000760 <__udivdi3+0x518>
80000758:	ffe90613          	addi	a2,s2,-2
8000075c:	01570733          	add	a4,a4,s5
80000760:	010c9793          	slli	a5,s9,0x10
80000764:	00010e37          	lui	t3,0x10
80000768:	00c7e7b3          	or	a5,a5,a2
8000076c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000770:	0107f333          	and	t1,a5,a6
80000774:	0109f833          	and	a6,s3,a6
80000778:	40a70733          	sub	a4,a4,a0
8000077c:	0107de93          	srli	t4,a5,0x10
80000780:	0109d993          	srli	s3,s3,0x10
80000784:	00030513          	mv	a0,t1
80000788:	00080593          	mv	a1,a6
8000078c:	090000ef          	jal	ra,8000081c <__mulsi3>
80000790:	00050893          	mv	a7,a0
80000794:	00098593          	mv	a1,s3
80000798:	00030513          	mv	a0,t1
8000079c:	080000ef          	jal	ra,8000081c <__mulsi3>
800007a0:	00050313          	mv	t1,a0
800007a4:	00080593          	mv	a1,a6
800007a8:	000e8513          	mv	a0,t4
800007ac:	070000ef          	jal	ra,8000081c <__mulsi3>
800007b0:	00050813          	mv	a6,a0
800007b4:	00098593          	mv	a1,s3
800007b8:	000e8513          	mv	a0,t4
800007bc:	060000ef          	jal	ra,8000081c <__mulsi3>
800007c0:	0108d693          	srli	a3,a7,0x10
800007c4:	01030333          	add	t1,t1,a6
800007c8:	006686b3          	add	a3,a3,t1
800007cc:	0106f463          	bgeu	a3,a6,800007d4 <__udivdi3+0x58c>
800007d0:	01c50533          	add	a0,a0,t3
800007d4:	0106d613          	srli	a2,a3,0x10
800007d8:	00a60533          	add	a0,a2,a0
800007dc:	02a76663          	bltu	a4,a0,80000808 <__udivdi3+0x5c0>
800007e0:	bca714e3          	bne	a4,a0,800003a8 <__udivdi3+0x160>
800007e4:	00010737          	lui	a4,0x10
800007e8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007ec:	00e6f6b3          	and	a3,a3,a4
800007f0:	01069693          	slli	a3,a3,0x10
800007f4:	00e8f8b3          	and	a7,a7,a4
800007f8:	014b1633          	sll	a2,s6,s4
800007fc:	011686b3          	add	a3,a3,a7
80000800:	00000a13          	li	s4,0
80000804:	ccd67ce3          	bgeu	a2,a3,800004dc <__udivdi3+0x294>
80000808:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000080c:	b9dff06f          	j	800003a8 <__udivdi3+0x160>
80000810:	00000a13          	li	s4,0
80000814:	00000793          	li	a5,0
80000818:	cc5ff06f          	j	800004dc <__udivdi3+0x294>

8000081c <__mulsi3>:
8000081c:	00050613          	mv	a2,a0
80000820:	00000513          	li	a0,0
80000824:	0015f693          	andi	a3,a1,1
80000828:	00068463          	beqz	a3,80000830 <__mulsi3+0x14>
8000082c:	00c50533          	add	a0,a0,a2
80000830:	0015d593          	srli	a1,a1,0x1
80000834:	00161613          	slli	a2,a2,0x1
80000838:	fe0596e3          	bnez	a1,80000824 <__mulsi3+0x8>
8000083c:	00008067          	ret

80000840 <__divsi3>:
80000840:	06054063          	bltz	a0,800008a0 <__umodsi3+0x10>
80000844:	0605c663          	bltz	a1,800008b0 <__umodsi3+0x20>

80000848 <__udivsi3>:
80000848:	00058613          	mv	a2,a1
8000084c:	00050593          	mv	a1,a0
80000850:	fff00513          	li	a0,-1
80000854:	02060c63          	beqz	a2,8000088c <__udivsi3+0x44>
80000858:	00100693          	li	a3,1
8000085c:	00b67a63          	bgeu	a2,a1,80000870 <__udivsi3+0x28>
80000860:	00c05863          	blez	a2,80000870 <__udivsi3+0x28>
80000864:	00161613          	slli	a2,a2,0x1
80000868:	00169693          	slli	a3,a3,0x1
8000086c:	feb66ae3          	bltu	a2,a1,80000860 <__udivsi3+0x18>
80000870:	00000513          	li	a0,0
80000874:	00c5e663          	bltu	a1,a2,80000880 <__udivsi3+0x38>
80000878:	40c585b3          	sub	a1,a1,a2
8000087c:	00d56533          	or	a0,a0,a3
80000880:	0016d693          	srli	a3,a3,0x1
80000884:	00165613          	srli	a2,a2,0x1
80000888:	fe0696e3          	bnez	a3,80000874 <__udivsi3+0x2c>
8000088c:	00008067          	ret

80000890 <__umodsi3>:
80000890:	00008293          	mv	t0,ra
80000894:	fb5ff0ef          	jal	ra,80000848 <__udivsi3>
80000898:	00058513          	mv	a0,a1
8000089c:	00028067          	jr	t0
800008a0:	40a00533          	neg	a0,a0
800008a4:	0005d863          	bgez	a1,800008b4 <__umodsi3+0x24>
800008a8:	40b005b3          	neg	a1,a1
800008ac:	f9dff06f          	j	80000848 <__udivsi3>
800008b0:	40b005b3          	neg	a1,a1
800008b4:	00008293          	mv	t0,ra
800008b8:	f91ff0ef          	jal	ra,80000848 <__udivsi3>
800008bc:	40a00533          	neg	a0,a0
800008c0:	00028067          	jr	t0

800008c4 <__modsi3>:
800008c4:	00008293          	mv	t0,ra
800008c8:	0005ca63          	bltz	a1,800008dc <__modsi3+0x18>
800008cc:	00054c63          	bltz	a0,800008e4 <__modsi3+0x20>
800008d0:	f79ff0ef          	jal	ra,80000848 <__udivsi3>
800008d4:	00058513          	mv	a0,a1
800008d8:	00028067          	jr	t0
800008dc:	40b005b3          	neg	a1,a1
800008e0:	fe0558e3          	bgez	a0,800008d0 <__modsi3+0xc>
800008e4:	40a00533          	neg	a0,a0
800008e8:	f61ff0ef          	jal	ra,80000848 <__udivsi3>
800008ec:	40b00533          	neg	a0,a1
800008f0:	00028067          	jr	t0

800008f4 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
800008f4:	00005117          	auipc	sp,0x5
800008f8:	6bc10113          	addi	sp,sp,1724 # 80005fb0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
800008fc:	000012b7          	lui	t0,0x1
80000900:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000904:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000906:	290d                	jal	80000d38 <_PrepC>

80000908 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000908:	0670006f          	j	8000116e <z_thread_entry>
	...

8000090e <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000090e:	8082                	ret

80000910 <z_zassert.constprop.3>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000910:	7179                	addi	sp,sp,-48
80000912:	ce06                	sw	ra,28(sp)
80000914:	d442                	sw	a6,40(sp)
80000916:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000918:	e131                	bnez	a0,8000095c <z_zassert.constprop.3+0x4c>
8000091a:	8636                	mv	a2,a3
8000091c:	872e                	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000091e:	800046b7          	lui	a3,0x80004
80000922:	800045b7          	lui	a1,0x80004
80000926:	80004537          	lui	a0,0x80004
		va_start(vargs, msg);
8000092a:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000092c:	63468693          	addi	a3,a3,1588 # 80004634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004635>
80000930:	74058593          	addi	a1,a1,1856 # 80004740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004741>
80000934:	76c50513          	addi	a0,a0,1900 # 8000476c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000476d>
		va_start(vargs, msg);
80000938:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
8000093a:	481000ef          	jal	ra,800015ba <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
8000093e:	45b2                	lw	a1,12(sp)
80000940:	80004537          	lui	a0,0x80004
80000944:	7e850513          	addi	a0,a0,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80000948:	457000ef          	jal	ra,8000159e <vprintk>
		printk("\n");
8000094c:	80005537          	lui	a0,0x80005
80000950:	8e850513          	addi	a0,a0,-1816 # 800048e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048e9>
80000954:	467000ef          	jal	ra,800015ba <printk>
		va_end(vargs);
		ztest_test_fail();
80000958:	1ee010ef          	jal	ra,80001b46 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
8000095c:	40f2                	lw	ra,28(sp)
8000095e:	6145                	addi	sp,sp,48
80000960:	8082                	ret

80000962 <test_send>:

	k_sem_init(&sync_sema, 0, 1);
}

void test_send(void *p1, void *p2, void *p3)
{
80000962:	7139                	addi	sp,sp,-64
80000964:	dc22                	sw	s0,56(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
80000966:	02c00613          	li	a2,44
{
8000096a:	842a                	mv	s0,a0
	(void)memset(&mmsg, 0, sizeof(mmsg));
8000096c:	4581                	li	a1,0
8000096e:	0048                	addi	a0,sp,4
{
80000970:	de06                	sw	ra,60(sp)
	(void)memset(&mmsg, 0, sizeof(mmsg));
80000972:	10a010ef          	jal	ra,80001a7c <memset>
	switch (info_type) {
80000976:	800057b7          	lui	a5,0x80005
8000097a:	2987a783          	lw	a5,664(a5) # 80005298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005299>
8000097e:	eb89                	bnez	a5,80000990 <test_send+0x2e>
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
80000980:	4601                	li	a2,0
80000982:	004c                	addi	a1,sp,4
80000984:	8522                	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
80000986:	c602                	sw	zero,12(sp)
		mmsg.size = 0;
80000988:	c402                	sw	zero,8(sp)
		mmsg.tx_data = NULL;
8000098a:	c802                	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_NO_WAIT);
8000098c:	0a1010ef          	jal	ra,8000222c <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_NO_WAIT);
}
80000990:	50f2                	lw	ra,60(sp)
80000992:	5462                	lw	s0,56(sp)
80000994:	6121                	addi	sp,sp,64
80000996:	8082                	ret

80000998 <test_send_un>:
	msg_receiver(&mbox, K_ANY, 2);
	k_thread_abort(tid);
}

void test_send_un(void *p1, void *p2, void *p3)
{
80000998:	7139                	addi	sp,sp,-64
8000099a:	dc22                	sw	s0,56(sp)
8000099c:	842a                	mv	s0,a0
	TC_PRINT("Sender UNLIMITED\n");
8000099e:	80004537          	lui	a0,0x80004
800009a2:	72c50513          	addi	a0,a0,1836 # 8000472c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000472d>
{
800009a6:	de06                	sw	ra,60(sp)
	TC_PRINT("Sender UNLIMITED\n");
800009a8:	413000ef          	jal	ra,800015ba <printk>
	(void)memset(&mmsg, 0, sizeof(mmsg));
800009ac:	02c00613          	li	a2,44
800009b0:	4581                	li	a1,0
800009b2:	0048                	addi	a0,sp,4
800009b4:	0c8010ef          	jal	ra,80001a7c <memset>
	switch (info_type) {
800009b8:	800057b7          	lui	a5,0x80005
800009bc:	2987a783          	lw	a5,664(a5) # 80005298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005299>
800009c0:	eb89                	bnez	a5,800009d2 <test_send_un+0x3a>
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
800009c2:	567d                	li	a2,-1
800009c4:	004c                	addi	a1,sp,4
800009c6:	8522                	mv	a0,s0
		mmsg.info = PUT_GET_NULL;
800009c8:	c602                	sw	zero,12(sp)
		mmsg.size = 0;
800009ca:	c402                	sw	zero,8(sp)
		mmsg.tx_data = NULL;
800009cc:	c802                	sw	zero,16(sp)
			k_mbox_put(pmbox, &mmsg, K_FOREVER);
800009ce:	05f010ef          	jal	ra,8000222c <k_mbox_put>
	msg_sender((struct k_mbox *)p1, K_FOREVER);
}
800009d2:	50f2                	lw	ra,60(sp)
800009d4:	5462                	lw	s0,56(sp)
800009d6:	6121                	addi	sp,sp,64
800009d8:	8082                	ret

800009da <msg_receiver_unlimited>:

/* Receive message from thread tid1 */
void msg_receiver_unlimited(void)
{
800009da:	7175                	addi	sp,sp,-144
800009dc:	c522                	sw	s0,136(sp)
	info_type = PUT_GET_NULL;
800009de:	80005437          	lui	s0,0x80005
{
800009e2:	c706                	sw	ra,140(sp)
800009e4:	c326                	sw	s1,132(sp)
	info_type = PUT_GET_NULL;
800009e6:	29840413          	addi	s0,s0,664 # 80005298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005299>
800009ea:	00042023          	sw	zero,0(s0)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)

K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800009ee:	31f020ef          	jal	ra,8000350c <z_impl_k_current_get>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800009f2:	800054b7          	lui	s1,0x80005
800009f6:	800016b7          	lui	a3,0x80001
800009fa:	800055b7          	lui	a1,0x80005
800009fe:	80005537          	lui	a0,0x80005
80000a02:	4781                	li	a5,0
80000a04:	39048713          	addi	a4,s1,912 # 80005390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005391>
80000a08:	c202                	sw	zero,4(sp)
80000a0a:	c002                	sw	zero,0(sp)
80000a0c:	4881                	li	a7,0
80000a0e:	4801                	li	a6,0
80000a10:	99868693          	addi	a3,a3,-1640 # 80000998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000999>
80000a14:	20000613          	li	a2,512
80000a18:	5b058593          	addi	a1,a1,1456 # 800055b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b1>
80000a1c:	3b450513          	addi	a0,a0,948 # 800053b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b5>
80000a20:	10c030ef          	jal	ra,80003b2c <z_impl_k_thread_create>
	switch (info_type) {
80000a24:	4018                	lw	a4,0(s0)

	receiver_tid = k_current_get();
	tid1 = k_thread_create(&tdata, tstack, STACK_SIZE,
80000a26:	800057b7          	lui	a5,0x80005
80000a2a:	2aa7a023          	sw	a0,672(a5) # 800052a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a1>
	switch (info_type) {
80000a2e:	2a078413          	addi	s0,a5,672
80000a32:	e329                	bnez	a4,80000a74 <msg_receiver_unlimited+0x9a>
		mmsg.size = sizeof(rxdata);
80000a34:	04000793          	li	a5,64
		mmsg.rx_source_thread = thd_id;
80000a38:	d82a                	sw	a0,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000a3a:	56fd                	li	a3,-1
80000a3c:	0090                	addi	a2,sp,64
80000a3e:	084c                	addi	a1,sp,20
80000a40:	39048513          	addi	a0,s1,912
		mmsg.size = sizeof(rxdata);
80000a44:	cc3e                	sw	a5,24(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000a46:	01b010ef          	jal	ra,80002260 <k_mbox_get>
80000a4a:	800047b7          	lui	a5,0x80004
80000a4e:	80004737          	lui	a4,0x80004
80000a52:	80004637          	lui	a2,0x80004
80000a56:	800045b7          	lui	a1,0x80004
80000a5a:	7e878793          	addi	a5,a5,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80000a5e:	63470713          	addi	a4,a4,1588 # 80004634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004635>
80000a62:	04300693          	li	a3,67
80000a66:	74060613          	addi	a2,a2,1856 # 80004740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004741>
80000a6a:	64458593          	addi	a1,a1,1604 # 80004644 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004645>
80000a6e:	00153513          	seqz	a0,a0
80000a72:	3d79                	jal	80000910 <z_zassert.constprop.3>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000a74:	4008                	lw	a0,0(s0)
80000a76:	1ce030ef          	jal	ra,80003c44 <z_impl_k_thread_abort>
			      test_send_un, &mbox, NULL, NULL,
			      K_PRIO_PREEMPT(0), 0, K_NO_WAIT);

	msg_receiver(&mbox, tid1, K_FOREVER);
	k_thread_abort(tid1);
}
80000a7a:	40ba                	lw	ra,140(sp)
80000a7c:	442a                	lw	s0,136(sp)
80000a7e:	449a                	lw	s1,132(sp)
80000a80:	6149                	addi	sp,sp,144
80000a82:	8082                	ret

80000a84 <test_msg_receiver>:
{
80000a84:	7135                	addi	sp,sp,-160
80000a86:	cd22                	sw	s0,152(sp)
80000a88:	cb26                	sw	s1,148(sp)
	info_type = PUT_GET_NULL;
80000a8a:	80005437          	lui	s0,0x80005
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000a8e:	800054b7          	lui	s1,0x80005
{
80000a92:	cf06                	sw	ra,156(sp)
80000a94:	c94a                	sw	s2,144(sp)
80000a96:	c74e                	sw	s3,140(sp)
80000a98:	c552                	sw	s4,136(sp)
80000a9a:	c356                	sw	s5,132(sp)
	info_type = PUT_GET_NULL;
80000a9c:	29840413          	addi	s0,s0,664 # 80005298 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005299>
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000aa0:	4681                	li	a3,0
80000aa2:	0090                	addi	a2,sp,64
80000aa4:	084c                	addi	a1,sp,20
		mmsg.size = sizeof(rxdata);
80000aa6:	04000a93          	li	s5,64
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000aaa:	39048513          	addi	a0,s1,912 # 80005390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005391>
	info_type = PUT_GET_NULL;
80000aae:	00042023          	sw	zero,0(s0)
		mmsg.size = sizeof(rxdata);
80000ab2:	cc56                	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
80000ab4:	d802                	sw	zero,48(sp)
			zassert_false(k_mbox_get(pmbox, &mmsg,
80000ab6:	7aa010ef          	jal	ra,80002260 <k_mbox_get>
80000aba:	800049b7          	lui	s3,0x80004
80000abe:	80004a37          	lui	s4,0x80004
80000ac2:	80004937          	lui	s2,0x80004
80000ac6:	800045b7          	lui	a1,0x80004
80000aca:	7e8a0793          	addi	a5,s4,2024 # 800047e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047e9>
80000ace:	63498713          	addi	a4,s3,1588 # 80004634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004635>
80000ad2:	04600693          	li	a3,70
80000ad6:	74090613          	addi	a2,s2,1856 # 80004740 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004741>
80000ada:	6b858593          	addi	a1,a1,1720 # 800046b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046b9>
80000ade:	00a03533          	snez	a0,a0
80000ae2:	353d                	jal	80000910 <z_zassert.constprop.3>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000ae4:	800016b7          	lui	a3,0x80001
80000ae8:	800055b7          	lui	a1,0x80005
80000aec:	80005537          	lui	a0,0x80005
80000af0:	4781                	li	a5,0
80000af2:	39048713          	addi	a4,s1,912
80000af6:	c202                	sw	zero,4(sp)
80000af8:	c002                	sw	zero,0(sp)
80000afa:	4881                	li	a7,0
80000afc:	4801                	li	a6,0
80000afe:	96268693          	addi	a3,a3,-1694 # 80000962 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000963>
80000b02:	20000613          	li	a2,512
80000b06:	5b058593          	addi	a1,a1,1456 # 800055b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b1>
80000b0a:	3b450513          	addi	a0,a0,948 # 800053b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053b5>
80000b0e:	01e030ef          	jal	ra,80003b2c <z_impl_k_thread_create>
	switch (info_type) {
80000b12:	4018                	lw	a4,0(s0)
	tid = k_thread_create(&tdata, tstack, STACK_SIZE,
80000b14:	800057b7          	lui	a5,0x80005
80000b18:	28a7ae23          	sw	a0,668(a5) # 8000529c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000529d>
	switch (info_type) {
80000b1c:	29c78413          	addi	s0,a5,668
80000b20:	eb0d                	bnez	a4,80000b52 <test_msg_receiver+0xce>
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000b22:	4689                	li	a3,2
80000b24:	0090                	addi	a2,sp,64
80000b26:	084c                	addi	a1,sp,20
80000b28:	39048513          	addi	a0,s1,912
		mmsg.size = sizeof(rxdata);
80000b2c:	cc56                	sw	s5,24(sp)
		mmsg.rx_source_thread = thd_id;
80000b2e:	d802                	sw	zero,48(sp)
			zassert_true(k_mbox_get(pmbox, &mmsg,
80000b30:	730010ef          	jal	ra,80002260 <k_mbox_get>
80000b34:	800045b7          	lui	a1,0x80004
80000b38:	7e8a0793          	addi	a5,s4,2024
80000b3c:	63498713          	addi	a4,s3,1588
80000b40:	04900693          	li	a3,73
80000b44:	74090613          	addi	a2,s2,1856
80000b48:	6f458593          	addi	a1,a1,1780 # 800046f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046f5>
80000b4c:	00153513          	seqz	a0,a0
80000b50:	33c1                	jal	80000910 <z_zassert.constprop.3>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000b52:	4008                	lw	a0,0(s0)
80000b54:	0f0030ef          	jal	ra,80003c44 <z_impl_k_thread_abort>
}
80000b58:	40fa                	lw	ra,156(sp)
80000b5a:	446a                	lw	s0,152(sp)
80000b5c:	44da                	lw	s1,148(sp)
80000b5e:	494a                	lw	s2,144(sp)
80000b60:	49ba                	lw	s3,140(sp)
80000b62:	4a2a                	lw	s4,136(sp)
80000b64:	4a9a                	lw	s5,132(sp)
80000b66:	610d                	addi	sp,sp,160
80000b68:	8082                	ret

80000b6a <test_main>:
	k_mbox_init(&mbox);
80000b6a:	80005537          	lui	a0,0x80005

/*test case main entry*/
void test_main(void)
{
80000b6e:	1141                	addi	sp,sp,-16
	k_mbox_init(&mbox);
80000b70:	39050513          	addi	a0,a0,912 # 80005390 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005391>
{
80000b74:	c606                	sw	ra,12(sp)
	k_mbox_init(&mbox);
80000b76:	6a4010ef          	jal	ra,8000221a <k_mbox_init>

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000b7a:	80005537          	lui	a0,0x80005
80000b7e:	4581                	li	a1,0
80000b80:	3a450513          	addi	a0,a0,932 # 800053a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053a5>
80000b84:	4605                	li	a2,1
80000b86:	191020ef          	jal	ra,80003516 <z_impl_k_sem_init>
	test_mbox_init();
	ztest_test_suite(test_mbox,
			 ztest_unit_test(test_msg_receiver),
			 ztest_unit_test(msg_receiver_unlimited));
	ztest_run_test_suite(test_mbox);
}
80000b8a:	40b2                	lw	ra,12(sp)
	ztest_run_test_suite(test_mbox);
80000b8c:	800055b7          	lui	a1,0x80005
80000b90:	80004537          	lui	a0,0x80004
80000b94:	18c58593          	addi	a1,a1,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
80000b98:	6ac50513          	addi	a0,a0,1708 # 800046ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046ad>
}
80000b9c:	0141                	addi	sp,sp,16
	ztest_run_test_suite(test_mbox);
80000b9e:	7cf0006f          	j	80001b6c <z_ztest_run_test_suite>

80000ba2 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000ba2:	1141                	addi	sp,sp,-16
80000ba4:	c606                	sw	ra,12(sp)
80000ba6:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000ba8:	4799                	li	a5,6
80000baa:	02f50263          	beq	a0,a5,80000bce <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000bae:	56d020ef          	jal	ra,8000391a <k_is_in_isr>
80000bb2:	c10d                	beqz	a0,80000bd4 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000bb4:	567020ef          	jal	ra,8000391a <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000bb8:	e121                	bnez	a0,80000bf8 <z_SysFatalErrorHandler+0x56>
80000bba:	800055b7          	lui	a1,0x80005
80000bbe:	a4458593          	addi	a1,a1,-1468 # 80004a44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a45>
80000bc2:	80005537          	lui	a0,0x80005
80000bc6:	a5850513          	addi	a0,a0,-1448 # 80004a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a59>
80000bca:	1f1000ef          	jal	ra,800015ba <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000bce:	233000ef          	jal	ra,80001600 <k_cpu_idle>
80000bd2:	bff5                	j	80000bce <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000bd4:	555020ef          	jal	ra,80003928 <z_is_thread_essential>
80000bd8:	fd71                	bnez	a0,80000bb4 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000bda:	80005437          	lui	s0,0x80005
80000bde:	58440413          	addi	s0,s0,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80000be2:	440c                	lw	a1,8(s0)
80000be4:	80005537          	lui	a0,0x80005
80000be8:	a7850513          	addi	a0,a0,-1416 # 80004a78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a79>
80000bec:	1cf000ef          	jal	ra,800015ba <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000bf0:	4408                	lw	a0,8(s0)
80000bf2:	052030ef          	jal	ra,80003c44 <z_impl_k_thread_abort>
80000bf6:	bfe1                	j	80000bce <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80000bf8:	800055b7          	lui	a1,0x80005
80000bfc:	a4058593          	addi	a1,a1,-1472 # 80004a40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a41>
80000c00:	b7c9                	j	80000bc2 <z_SysFatalErrorHandler+0x20>

80000c02 <z_NanoFatalErrorHandler>:
{
80000c02:	715d                	addi	sp,sp,-80
80000c04:	c4a2                	sw	s0,72(sp)
80000c06:	c2a6                	sw	s1,68(sp)
80000c08:	c686                	sw	ra,76(sp)
	switch (reason) {
80000c0a:	4799                	li	a5,6
{
80000c0c:	84aa                	mv	s1,a0
80000c0e:	842e                	mv	s0,a1
	switch (reason) {
80000c10:	08a7e963          	bltu	a5,a0,80000ca2 <z_NanoFatalErrorHandler+0xa0>
80000c14:	80004737          	lui	a4,0x80004
80000c18:	00251793          	slli	a5,a0,0x2
80000c1c:	79470713          	addi	a4,a4,1940 # 80004794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004795>
80000c20:	97ba                	add	a5,a5,a4
80000c22:	439c                	lw	a5,0(a5)
80000c24:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000c26:	80005537          	lui	a0,0x80005
80000c2a:	8c450513          	addi	a0,a0,-1852 # 800048c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048c5>
		printk("***** Kernel OOPS! *****\n");
80000c2e:	18d000ef          	jal	ra,800015ba <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000c32:	0db020ef          	jal	ra,8000350c <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000c36:	407c                	lw	a5,68(s0)
80000c38:	01042883          	lw	a7,16(s0)
80000c3c:	00c42803          	lw	a6,12(s0)
80000c40:	d83e                	sw	a5,48(sp)
80000c42:	403c                	lw	a5,64(s0)
80000c44:	4058                	lw	a4,4(s0)
80000c46:	4014                	lw	a3,0(s0)
80000c48:	d63e                	sw	a5,44(sp)
80000c4a:	5c5c                	lw	a5,60(s0)
80000c4c:	4430                	lw	a2,72(s0)
80000c4e:	85aa                	mv	a1,a0
80000c50:	d43e                	sw	a5,40(sp)
80000c52:	5c1c                	lw	a5,56(s0)
80000c54:	80005537          	lui	a0,0x80005
80000c58:	94850513          	addi	a0,a0,-1720 # 80004948 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004949>
80000c5c:	d23e                	sw	a5,36(sp)
80000c5e:	585c                	lw	a5,52(s0)
80000c60:	d03e                	sw	a5,32(sp)
80000c62:	581c                	lw	a5,48(s0)
80000c64:	ce3e                	sw	a5,28(sp)
80000c66:	545c                	lw	a5,44(s0)
80000c68:	cc3e                	sw	a5,24(sp)
80000c6a:	541c                	lw	a5,40(s0)
80000c6c:	ca3e                	sw	a5,20(sp)
80000c6e:	505c                	lw	a5,36(s0)
80000c70:	c83e                	sw	a5,16(sp)
80000c72:	501c                	lw	a5,32(s0)
80000c74:	c63e                	sw	a5,12(sp)
80000c76:	4c5c                	lw	a5,28(s0)
80000c78:	c43e                	sw	a5,8(sp)
80000c7a:	4c1c                	lw	a5,24(s0)
80000c7c:	c23e                	sw	a5,4(sp)
80000c7e:	485c                	lw	a5,20(s0)
80000c80:	c03e                	sw	a5,0(sp)
80000c82:	441c                	lw	a5,8(s0)
80000c84:	137000ef          	jal	ra,800015ba <printk>
	z_SysFatalErrorHandler(reason, esf);
80000c88:	85a2                	mv	a1,s0
80000c8a:	8526                	mv	a0,s1
80000c8c:	3f19                	jal	80000ba2 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000c8e:	80005537          	lui	a0,0x80005
80000c92:	8ec50513          	addi	a0,a0,-1812 # 800048ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048ed>
80000c96:	bf61                	j	80000c2e <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80000c98:	80005537          	lui	a0,0x80005
80000c9c:	90850513          	addi	a0,a0,-1784 # 80004908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004909>
80000ca0:	b779                	j	80000c2e <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000ca2:	80005537          	lui	a0,0x80005
80000ca6:	85a6                	mv	a1,s1
80000ca8:	92450513          	addi	a0,a0,-1756 # 80004924 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004925>
80000cac:	10f000ef          	jal	ra,800015ba <printk>
		break;
80000cb0:	b749                	j	80000c32 <z_NanoFatalErrorHandler+0x30>

80000cb2 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000cb2:	1141                	addi	sp,sp,-16
80000cb4:	c422                	sw	s0,8(sp)
80000cb6:	c606                	sw	ra,12(sp)
80000cb8:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000cba:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000cbe:	0606                	slli	a2,a2,0x1
80000cc0:	8205                	srli	a2,a2,0x1
	switch (cause) {
80000cc2:	4795                	li	a5,5
80000cc4:	02c7e363          	bltu	a5,a2,80000cea <_Fault+0x38>
80000cc8:	80004737          	lui	a4,0x80004
80000ccc:	00261793          	slli	a5,a2,0x2
80000cd0:	7b070713          	addi	a4,a4,1968 # 800047b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047b1>
80000cd4:	97ba                	add	a5,a5,a4
80000cd6:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000cd8:	80004537          	lui	a0,0x80004
80000cdc:	7d050513          	addi	a0,a0,2000 # 800047d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047d1>
80000ce0:	0db000ef          	jal	ra,800015ba <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000ce4:	85a2                	mv	a1,s0
80000ce6:	4501                	li	a0,0
80000ce8:	3f29                	jal	80000c02 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000cea:	800045b7          	lui	a1,0x80004
80000cee:	7c858593          	addi	a1,a1,1992 # 800047c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047c9>
80000cf2:	b7dd                	j	80000cd8 <_Fault+0x26>

80000cf4 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000cf4:	1141                	addi	sp,sp,-16
80000cf6:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000cf8:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000cfc:	80005537          	lui	a0,0x80005
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d00:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d02:	8185                	srli	a1,a1,0x1
80000d04:	aa050513          	addi	a0,a0,-1376 # 80004aa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004aa1>
80000d08:	0b3000ef          	jal	ra,800015ba <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000d0c:	800045b7          	lui	a1,0x80004
80000d10:	7ec58593          	addi	a1,a1,2028 # 800047ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047ed>
80000d14:	4511                	li	a0,4
80000d16:	35f5                	jal	80000c02 <z_NanoFatalErrorHandler>

80000d18 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000d18:	800057b7          	lui	a5,0x80005
80000d1c:	2a478793          	addi	a5,a5,676 # 800052a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a5>
80000d20:	4398                	lw	a4,0(a5)
80000d22:	cb11                	beqz	a4,80000d36 <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80000d24:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000d28:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000d2c:	800057b7          	lui	a5,0x80005
80000d30:	2a87a503          	lw	a0,680(a5) # 800052a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052a9>
80000d34:	8302                	jr	t1
}
80000d36:	8082                	ret

80000d38 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000d38:	1141                	addi	sp,sp,-16
80000d3a:	c606                	sw	ra,12(sp)
	z_bss_zero();
80000d3c:	0be010ef          	jal	ra,80001dfa <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000d40:	0d9000ef          	jal	ra,80001618 <soc_interrupt_init>
#endif
	z_cstart();
80000d44:	108010ef          	jal	ra,80001e4c <z_cstart>

80000d48 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000d48:	7179                	addi	sp,sp,-48
80000d4a:	d422                	sw	s0,40(sp)
80000d4c:	d226                	sw	s1,36(sp)
80000d4e:	d04a                	sw	s2,32(sp)
80000d50:	ce4e                	sw	s3,28(sp)
80000d52:	cc52                	sw	s4,24(sp)
80000d54:	ca56                	sw	s5,20(sp)
80000d56:	c85a                	sw	s6,16(sp)
80000d58:	c65e                	sw	s7,12(sp)
80000d5a:	8b3e                	mv	s6,a5
80000d5c:	d606                	sw	ra,44(sp)
80000d5e:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000d60:	47bd                	li	a5,15
{
80000d62:	84aa                	mv	s1,a0
80000d64:	842e                	mv	s0,a1
80000d66:	89b2                	mv	s3,a2
80000d68:	8a36                	mv	s4,a3
80000d6a:	8bba                	mv	s7,a4
80000d6c:	8ac2                	mv	s5,a6
80000d6e:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000d70:	06f89463          	bne	a7,a5,80000dd8 <z_new_thread+0x90>
80000d74:	800027b7          	lui	a5,0x80002
80000d78:	dd478793          	addi	a5,a5,-556 # 80001dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001dd5>
80000d7c:	06f69363          	bne	a3,a5,80000de2 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000d80:	56c2                	lw	a3,48(sp)
80000d82:	85ca                	mv	a1,s2
80000d84:	8526                	mv	a0,s1
80000d86:	4611                	li	a2,4
80000d88:	41f020ef          	jal	ra,800039a6 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000d8c:	fb098593          	addi	a1,s3,-80
80000d90:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000d92:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000d94:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000d98:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000d9c:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000d9e:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000da2:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000da4:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000da8:	50b2                	lw	ra,44(sp)
80000daa:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000dac:	90878793          	addi	a5,a5,-1784 # 80000908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000909>
	stack_init->a0 = (u32_t)thread_func;
80000db0:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000db4:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000db8:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000dbc:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000dc0:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000dc2:	d48c                	sw	a1,40(s1)
}
80000dc4:	5902                	lw	s2,32(sp)
80000dc6:	5492                	lw	s1,36(sp)
80000dc8:	49f2                	lw	s3,28(sp)
80000dca:	4a62                	lw	s4,24(sp)
80000dcc:	4ad2                	lw	s5,20(sp)
80000dce:	4b42                	lw	s6,16(sp)
80000dd0:	4bb2                	lw	s7,12(sp)
80000dd2:	4c22                	lw	s8,8(sp)
80000dd4:	6145                	addi	sp,sp,48
80000dd6:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000dd8:	01088693          	addi	a3,a7,16
80000ddc:	47f9                	li	a5,30
80000dde:	fad7f1e3          	bgeu	a5,a3,80000d80 <z_new_thread+0x38>
80000de2:	80005c37          	lui	s8,0x80005
80000de6:	800055b7          	lui	a1,0x80005
80000dea:	80005537          	lui	a0,0x80005
80000dee:	ac8c0613          	addi	a2,s8,-1336 # 80004ac8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ac9>
80000df2:	46e1                	li	a3,24
80000df4:	ae858593          	addi	a1,a1,-1304 # 80004ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ae9>
80000df8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80000dfc:	7be000ef          	jal	ra,800015ba <printk>
80000e00:	80005537          	lui	a0,0x80005
80000e04:	85ca                	mv	a1,s2
80000e06:	56c1                	li	a3,-16
80000e08:	4639                	li	a2,14
80000e0a:	b9450513          	addi	a0,a0,-1132 # 80004b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b95>
80000e0e:	7ac000ef          	jal	ra,800015ba <printk>
80000e12:	45e1                	li	a1,24
80000e14:	ac8c0513          	addi	a0,s8,-1336
80000e18:	7c0000ef          	jal	ra,800015d8 <assert_post_action>
80000e1c:	b795                	j	80000d80 <z_new_thread+0x38>

80000e1e <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000e1e:	00159793          	slli	a5,a1,0x1
80000e22:	97ae                	add	a5,a5,a1
80000e24:	00279713          	slli	a4,a5,0x2
80000e28:	455c                	lw	a5,12(a0)
80000e2a:	97ba                	add	a5,a5,a4
80000e2c:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000e30:	00b75363          	bge	a4,a1,80000e36 <get_bit_ptr+0x18>
80000e34:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000e36:	41f65713          	srai	a4,a2,0x1f
80000e3a:	8b7d                	andi	a4,a4,31
80000e3c:	9732                	add	a4,a4,a2
80000e3e:	8715                	srai	a4,a4,0x5
80000e40:	070a                	slli	a4,a4,0x2
80000e42:	97ba                	add	a5,a5,a4
80000e44:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80000e46:	01f67513          	andi	a0,a2,31
80000e4a:	8082                	ret

80000e4c <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000e4c:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000e4e:	0074                	addi	a3,sp,12
{
80000e50:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000e52:	37f1                	jal	80000e1e <get_bit_ptr>

	*word |= (1<<bit);
80000e54:	4732                	lw	a4,12(sp)
80000e56:	4785                	li	a5,1
80000e58:	00a79533          	sll	a0,a5,a0
80000e5c:	431c                	lw	a5,0(a4)
}
80000e5e:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
80000e60:	8fc9                	or	a5,a5,a0
80000e62:	c31c                	sw	a5,0(a4)
}
80000e64:	6105                	addi	sp,sp,32
80000e66:	8082                	ret

80000e68 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000e68:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000e6a:	0074                	addi	a3,sp,12
{
80000e6c:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000e6e:	3f45                	jal	80000e1e <get_bit_ptr>

	*word &= ~(1<<bit);
80000e70:	4732                	lw	a4,12(sp)
80000e72:	4785                	li	a5,1
80000e74:	00a79533          	sll	a0,a5,a0
80000e78:	431c                	lw	a5,0(a4)
}
80000e7a:	40f2                	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000e7c:	fff54513          	not	a0,a0
80000e80:	8d7d                	and	a0,a0,a5
80000e82:	c308                	sw	a0,0(a4)
}
80000e84:	6105                	addi	sp,sp,32
80000e86:	8082                	ret

80000e88 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80000e88:	1101                	addi	sp,sp,-32
80000e8a:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000e8c:	4144                	lw	s1,4(a0)
{
80000e8e:	cc22                	sw	s0,24(sp)
80000e90:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000e92:	00855503          	lhu	a0,8(a0)
80000e96:	85a6                	mv	a1,s1
{
80000e98:	c84a                	sw	s2,16(sp)
80000e9a:	c64e                	sw	s3,12(sp)
80000e9c:	c452                	sw	s4,8(sp)
80000e9e:	c256                	sw	s5,4(sp)
80000ea0:	c05a                	sw	s6,0(sp)
80000ea2:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000ea4:	3aa5                	jal	8000081c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000ea6:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000eaa:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80000eae:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000eb0:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000eb2:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80000eb4:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000eb8:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80000eba:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80000ebc:	03594163          	blt	s2,s5,80000ede <z_sys_mem_pool_base_init+0x56>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000ec0:	4481                	li	s1,0
80000ec2:	00845783          	lhu	a5,8(s0)
80000ec6:	04f4ce63          	blt	s1,a5,80000f22 <z_sys_mem_pool_base_init+0x9a>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80000eca:	40f2                	lw	ra,28(sp)
80000ecc:	4462                	lw	s0,24(sp)
80000ece:	44d2                	lw	s1,20(sp)
80000ed0:	4942                	lw	s2,16(sp)
80000ed2:	49b2                	lw	s3,12(sp)
80000ed4:	4a22                	lw	s4,8(sp)
80000ed6:	4a92                	lw	s5,4(sp)
80000ed8:	4b02                	lw	s6,0(sp)
80000eda:	6105                	addi	sp,sp,32
80000edc:	8082                	ret
		int nblocks = buflen / sz;
80000ede:	85a6                	mv	a1,s1
80000ee0:	8552                	mv	a0,s4
80000ee2:	329d                	jal	80000848 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80000ee4:	00191713          	slli	a4,s2,0x1
80000ee8:	974a                	add	a4,a4,s2
80000eea:	00271793          	slli	a5,a4,0x2
80000eee:	4458                	lw	a4,12(s0)
80000ef0:	973e                	add	a4,a4,a5
80000ef2:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80000ef6:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80000ef8:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
80000efa:	00ab4963          	blt	s6,a0,80000f0c <z_sys_mem_pool_base_init+0x84>
			p->max_inline_level = i;
80000efe:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80000f02:	8089                	srli	s1,s1,0x2
80000f04:	048d                	addi	s1,s1,3
80000f06:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80000f08:	0905                	addi	s2,s2,1
80000f0a:	bf4d                	j	80000ebc <z_sys_mem_pool_base_init+0x34>
			bits += (nblocks + 31)/32;
80000f0c:	057d                	addi	a0,a0,31
80000f0e:	41f55793          	srai	a5,a0,0x1f
80000f12:	8bfd                	andi	a5,a5,31
80000f14:	97aa                	add	a5,a5,a0
80000f16:	8795                	srai	a5,a5,0x5
80000f18:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80000f1a:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80000f1e:	99be                	add	s3,s3,a5
80000f20:	b7cd                	j	80000f02 <z_sys_mem_pool_base_init+0x7a>
	return (u8_t *)p->buf + lsz * block;
80000f22:	404c                	lw	a1,4(s0)
80000f24:	8526                	mv	a0,s1
80000f26:	8f7ff0ef          	jal	ra,8000081c <__mulsi3>
80000f2a:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80000f2c:	8626                	mv	a2,s1
80000f2e:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80000f30:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80000f32:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80000f34:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80000f36:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80000f3a:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
80000f3c:	4798                	lw	a4,8(a5)
80000f3e:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80000f40:	4798                	lw	a4,8(a5)
80000f42:	c308                	sw	a0,0(a4)
	list->tail = node;
80000f44:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80000f46:	8522                	mv	a0,s0
80000f48:	3711                	jal	80000e4c <set_free_bit>
80000f4a:	bfa5                	j	80000ec2 <z_sys_mem_pool_base_init+0x3a>

80000f4c <z_sys_mem_pool_block_free>:
	return 0;
}

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80000f4c:	711d                	addi	sp,sp,-96
80000f4e:	cca2                	sw	s0,88(sp)
80000f50:	c4d2                	sw	s4,72(sp)
80000f52:	da66                	sw	s9,52(sp)
80000f54:	ce86                	sw	ra,92(sp)
80000f56:	caa6                	sw	s1,84(sp)
80000f58:	c8ca                	sw	s2,80(sp)
80000f5a:	c6ce                	sw	s3,76(sp)
80000f5c:	c2d6                	sw	s5,68(sp)
80000f5e:	c0da                	sw	s6,64(sp)
80000f60:	de5e                	sw	s7,60(sp)
80000f62:	dc62                	sw	s8,56(sp)
80000f64:	d86a                	sw	s10,48(sp)
80000f66:	d66e                	sw	s11,44(sp)
80000f68:	1080                	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000f6a:	00a54703          	lbu	a4,10(a0)
{
80000f6e:	8caa                	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000f70:	070a                	slli	a4,a4,0x2
80000f72:	073d                	addi	a4,a4,15
80000f74:	7f077713          	andi	a4,a4,2032
80000f78:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
80000f7c:	4158                	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000f7e:	8a0a                	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80000f80:	86d2                	mv	a3,s4
80000f82:	070d                	addi	a4,a4,3
80000f84:	9b71                	andi	a4,a4,-4
80000f86:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80000f8a:	4505                	li	a0,1
80000f8c:	0691                	addi	a3,a3,4
80000f8e:	08a5f363          	bgeu	a1,a0,80001014 <z_sys_mem_pool_block_free+0xc8>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f92:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80000f96:	892e                	mv	s2,a1
80000f98:	89b2                	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f9a:	8b05                	andi	a4,a4,1
		return 0;
80000f9c:	4481                	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f9e:	c709                	beqz	a4,80000fa8 <z_sys_mem_pool_block_free+0x5c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000fa0:	44a1                	li	s1,8
80000fa2:	3004b4f3          	csrrc	s1,mstatus,s1
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000fa6:	88a1                	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
80000fa8:	80005b37          	lui	s6,0x80005
	while (level >= 0) {
80000fac:	06095c63          	bgez	s2,80001024 <z_sys_mem_pool_block_free+0xd8>
	__ASSERT(0, "out of levels");
80000fb0:	800054b7          	lui	s1,0x80005
80000fb4:	800055b7          	lui	a1,0x80005
80000fb8:	80005537          	lui	a0,0x80005
80000fbc:	bc848613          	addi	a2,s1,-1080 # 80004bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bc9>
80000fc0:	0c000693          	li	a3,192
80000fc4:	c3058593          	addi	a1,a1,-976 # 80004c30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c31>
80000fc8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80000fcc:	23fd                	jal	800015ba <printk>
80000fce:	80005537          	lui	a0,0x80005
80000fd2:	bfc50513          	addi	a0,a0,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80000fd6:	23d5                	jal	800015ba <printk>
80000fd8:	bc848513          	addi	a0,s1,-1080
80000fdc:	0c000593          	li	a1,192
80000fe0:	2be5                	jal	800015d8 <assert_post_action>
	return -1;
80000fe2:	54fd                	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000fe4:	010cc783          	lbu	a5,16(s9)
80000fe8:	8b85                	andi	a5,a5,1
80000fea:	c781                	beqz	a5,80000ff2 <z_sys_mem_pool_block_free+0xa6>
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80000fec:	88a1                	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80000fee:	3004a4f3          	csrrs	s1,mstatus,s1
}
80000ff2:	fa040113          	addi	sp,s0,-96
80000ff6:	40f6                	lw	ra,92(sp)
80000ff8:	4466                	lw	s0,88(sp)
80000ffa:	44d6                	lw	s1,84(sp)
80000ffc:	4946                	lw	s2,80(sp)
80000ffe:	49b6                	lw	s3,76(sp)
80001000:	4a26                	lw	s4,72(sp)
80001002:	4a96                	lw	s5,68(sp)
80001004:	4b06                	lw	s6,64(sp)
80001006:	5bf2                	lw	s7,60(sp)
80001008:	5c62                	lw	s8,56(sp)
8000100a:	5cd2                	lw	s9,52(sp)
8000100c:	5d42                	lw	s10,48(sp)
8000100e:	5db2                	lw	s11,44(sp)
80001010:	6125                	addi	sp,sp,96
80001012:	8082                	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001014:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001018:	0505                	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000101a:	8309                	srli	a4,a4,0x2
8000101c:	070d                	addi	a4,a4,3
8000101e:	9b71                	andi	a4,a4,-4
80001020:	c298                	sw	a4,0(a3)
80001022:	b7ad                	j	80000f8c <z_sys_mem_pool_block_free+0x40>
		int i, lsz = lsizes[level];
80001024:	00291713          	slli	a4,s2,0x2
80001028:	9752                	add	a4,a4,s4
8000102a:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
8000102e:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001032:	854e                	mv	a0,s3
80001034:	85d6                	mv	a1,s5
80001036:	fe6ff0ef          	jal	ra,8000081c <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000103a:	fffa8b93          	addi	s7,s5,-1
8000103e:	01750d33          	add	s10,a0,s7
80001042:	9c2a                	add	s8,s8,a0
	return p->n_max * p->max_sz;
80001044:	004ca583          	lw	a1,4(s9)
80001048:	008cd503          	lhu	a0,8(s9)
8000104c:	fd0ff0ef          	jal	ra,8000081c <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
80001050:	02ad6963          	bltu	s10,a0,80001082 <z_sys_mem_pool_block_free+0x136>
80001054:	800057b7          	lui	a5,0x80005
80001058:	bdc78593          	addi	a1,a5,-1060 # 80004bdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bdd>
8000105c:	800057b7          	lui	a5,0x80005
80001060:	b7478513          	addi	a0,a5,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80001064:	0a400693          	li	a3,164
80001068:	bc8b0613          	addi	a2,s6,-1080 # 80004bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bc9>
8000106c:	23b9                	jal	800015ba <printk>
8000106e:	800057b7          	lui	a5,0x80005
80001072:	bf878513          	addi	a0,a5,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80001076:	2391                	jal	800015ba <printk>
80001078:	0a400593          	li	a1,164
8000107c:	bc8b0513          	addi	a0,s6,-1080
80001080:	2ba1                	jal	800015d8 <assert_post_action>
		set_free_bit(p, level, bn);
80001082:	864e                	mv	a2,s3
80001084:	85ca                	mv	a1,s2
80001086:	8566                	mv	a0,s9
80001088:	33d1                	jal	80000e4c <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
8000108a:	00191713          	slli	a4,s2,0x1
8000108e:	974a                	add	a4,a4,s2
80001090:	00271693          	slli	a3,a4,0x2
80001094:	00cca703          	lw	a4,12(s9)
80001098:	9736                	add	a4,a4,a3
8000109a:	00470693          	addi	a3,a4,4
	node->next = list;
8000109e:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
800010a2:	4714                	lw	a3,8(a4)
800010a4:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800010a8:	4714                	lw	a3,8(a4)
800010aa:	0186a023          	sw	s8,0(a3)
	list->tail = node;
800010ae:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800010b2:	010cc703          	lbu	a4,16(s9)
800010b6:	8b05                	andi	a4,a4,1
800010b8:	e345                	bnez	a4,80001158 <z_sys_mem_pool_block_free+0x20c>
		return 0;
800010ba:	4481                	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800010bc:	f20904e3          	beqz	s2,80000fe4 <z_sys_mem_pool_block_free+0x98>
	int bit = get_bit_ptr(p, level, bn, &word);
800010c0:	fbc40693          	addi	a3,s0,-68
800010c4:	864e                	mv	a2,s3
800010c6:	85ca                	mv	a1,s2
800010c8:	8566                	mv	a0,s9
800010ca:	3b91                	jal	80000e1e <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
800010cc:	fbc42683          	lw	a3,-68(s0)
800010d0:	41f55713          	srai	a4,a0,0x1f
800010d4:	8b0d                	andi	a4,a4,3
800010d6:	972a                	add	a4,a4,a0
800010d8:	4288                	lw	a0,0(a3)
800010da:	9b71                	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800010dc:	47bd                	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
800010de:	00e55733          	srl	a4,a0,a4
800010e2:	8b3d                	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
800010e4:	f0f710e3          	bne	a4,a5,80000fe4 <z_sys_mem_pool_block_free+0x98>
		for (i = 0; i < 4; i++) {
800010e8:	4d01                	li	s10,0
			int b = (bn & ~3) + i;
800010ea:	ffc9fd93          	andi	s11,s3,-4
800010ee:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
800010f2:	8532                	mv	a0,a2
800010f4:	85d6                	mv	a1,s5
800010f6:	fac42423          	sw	a2,-88(s0)
800010fa:	f22ff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
800010fe:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001102:	8c2a                	mv	s8,a0
	return p->n_max * p->max_sz;
80001104:	004ca583          	lw	a1,4(s9)
80001108:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
8000110c:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001110:	f0cff0ef          	jal	ra,8000081c <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001114:	fac42703          	lw	a4,-84(s0)
80001118:	fa842603          	lw	a2,-88(s0)
8000111c:	02a77263          	bgeu	a4,a0,80001140 <z_sys_mem_pool_block_free+0x1f4>
				clear_free_bit(p, level, b);
80001120:	85ca                	mv	a1,s2
80001122:	8566                	mv	a0,s9
80001124:	3391                	jal	80000e68 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001126:	000ca703          	lw	a4,0(s9)
8000112a:	9c3a                	add	s8,s8,a4
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
8000112c:	004c2603          	lw	a2,4(s8)
80001130:	000c2703          	lw	a4,0(s8)
80001134:	c218                	sw	a4,0(a2)
	node->next->prev = node->prev;
80001136:	c350                	sw	a2,4(a4)
	node->next = NULL;
80001138:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
8000113c:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
80001140:	0d05                	addi	s10,s10,1
80001142:	4791                	li	a5,4
80001144:	fafd15e3          	bne	s10,a5,800010ee <z_sys_mem_pool_block_free+0x1a2>
		bn = bn / 4;
80001148:	41f9d613          	srai	a2,s3,0x1f
8000114c:	8a0d                	andi	a2,a2,3
8000114e:	99b2                	add	s3,s3,a2
		level = level - 1;
80001150:	197d                	addi	s2,s2,-1
		bn = bn / 4;
80001152:	4029d993          	srai	s3,s3,0x2
80001156:	bd99                	j	80000fac <z_sys_mem_pool_block_free+0x60>
80001158:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000115c:	010cc703          	lbu	a4,16(s9)
80001160:	8b05                	andi	a4,a4,1
80001162:	df21                	beqz	a4,800010ba <z_sys_mem_pool_block_free+0x16e>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001164:	47a1                	li	a5,8
80001166:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
8000116a:	88a1                	andi	s1,s1,8
8000116c:	bf81                	j	800010bc <z_sys_mem_pool_block_free+0x170>

8000116e <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
8000116e:	1141                	addi	sp,sp,-16
80001170:	87aa                	mv	a5,a0
80001172:	852e                	mv	a0,a1
80001174:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
80001176:	8636                	mv	a2,a3
{
80001178:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
8000117a:	9782                	jalr	a5
8000117c:	390020ef          	jal	ra,8000350c <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001180:	2c5020ef          	jal	ra,80003c44 <z_impl_k_thread_abort>

80001184 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001184:	4501                	li	a0,0
80001186:	8082                	ret

80001188 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001188:	1141                	addi	sp,sp,-16
8000118a:	c422                	sw	s0,8(sp)
8000118c:	842a                	mv	s0,a0
	out('E', ctx);
8000118e:	04500513          	li	a0,69
{
80001192:	c606                	sw	ra,12(sp)
80001194:	c226                	sw	s1,4(sp)
80001196:	84ae                	mv	s1,a1
	out('E', ctx);
80001198:	9402                	jalr	s0
	out('R', ctx);
8000119a:	85a6                	mv	a1,s1
8000119c:	05200513          	li	a0,82
800011a0:	9402                	jalr	s0
	out('R', ctx);
800011a2:	8322                	mv	t1,s0
}
800011a4:	4422                	lw	s0,8(sp)
800011a6:	40b2                	lw	ra,12(sp)
	out('R', ctx);
800011a8:	85a6                	mv	a1,s1
}
800011aa:	4492                	lw	s1,4(sp)
	out('R', ctx);
800011ac:	05200513          	li	a0,82
}
800011b0:	0141                	addi	sp,sp,16
	out('R', ctx);
800011b2:	8302                	jr	t1

800011b4 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
800011b4:	419c                	lw	a5,0(a1)
800011b6:	0785                	addi	a5,a5,1
800011b8:	c19c                	sw	a5,0(a1)
	return _char_out(c);
800011ba:	800057b7          	lui	a5,0x80005
800011be:	1c87a303          	lw	t1,456(a5) # 800051c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051c9>
800011c2:	8302                	jr	t1

800011c4 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
800011c4:	7139                	addi	sp,sp,-64
800011c6:	dc22                	sw	s0,56(sp)
800011c8:	d64e                	sw	s3,44(sp)
800011ca:	d452                	sw	s4,40(sp)
800011cc:	d05a                	sw	s6,32(sp)
800011ce:	c86a                	sw	s10,16(sp)
800011d0:	de06                	sw	ra,60(sp)
800011d2:	da26                	sw	s1,52(sp)
800011d4:	d84a                	sw	s2,48(sp)
800011d6:	d256                	sw	s5,36(sp)
800011d8:	ce5e                	sw	s7,28(sp)
800011da:	cc62                	sw	s8,24(sp)
800011dc:	ca66                	sw	s9,20(sp)
800011de:	c66e                	sw	s11,12(sp)
800011e0:	89aa                	mv	s3,a0
800011e2:	8a2e                	mv	s4,a1
800011e4:	8d32                	mv	s10,a2
800011e6:	8b36                	mv	s6,a3
800011e8:	4405                	li	s0,1
800011ea:	00e05363          	blez	a4,800011f0 <_printk_dec_ulong+0x2c>
800011ee:	843a                	mv	s0,a4
800011f0:	4785                	li	a5,1
800011f2:	02000c93          	li	s9,32
800011f6:	00fb1463          	bne	s6,a5,800011fe <_printk_dec_ulong+0x3a>
800011fa:	03000c93          	li	s9,48
800011fe:	3b9ad4b7          	lui	s1,0x3b9ad
80001202:	4905                	li	s2,1
80001204:	4aa9                	li	s5,10
80001206:	4c01                	li	s8,0
80001208:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
8000120c:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
8000120e:	00148b93          	addi	s7,s1,1
80001212:	000c1463          	bnez	s8,8000121a <_printk_dec_ulong+0x56>
80001216:	07a4f263          	bgeu	s1,s10,8000127a <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000121a:	85de                	mv	a1,s7
8000121c:	856a                	mv	a0,s10
8000121e:	e2aff0ef          	jal	ra,80000848 <__udivsi3>
80001222:	85d2                	mv	a1,s4
80001224:	03050513          	addi	a0,a0,48
80001228:	9982                	jalr	s3
			digits++;
8000122a:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
8000122c:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
8000122e:	85de                	mv	a1,s7
80001230:	856a                	mv	a0,s10
80001232:	e5eff0ef          	jal	ra,80000890 <__umodsi3>
80001236:	8d2a                	mv	s10,a0
		pos /= 10;
80001238:	45a9                	li	a1,10
8000123a:	8526                	mv	a0,s1
8000123c:	e0cff0ef          	jal	ra,80000848 <__udivsi3>
		remaining--;
80001240:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
80001242:	4785                	li	a5,1
		pos /= 10;
80001244:	84aa                	mv	s1,a0
	while (pos >= 9) {
80001246:	fcfa94e3          	bne	s5,a5,8000120e <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
8000124a:	85d2                	mv	a1,s4
8000124c:	030d0513          	addi	a0,s10,48
80001250:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001252:	478d                	li	a5,3
		remaining = min_width - digits;
80001254:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001258:	02fb0f63          	beq	s6,a5,80001296 <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
8000125c:	50f2                	lw	ra,60(sp)
8000125e:	5462                	lw	s0,56(sp)
80001260:	54d2                	lw	s1,52(sp)
80001262:	5942                	lw	s2,48(sp)
80001264:	59b2                	lw	s3,44(sp)
80001266:	5a22                	lw	s4,40(sp)
80001268:	5a92                	lw	s5,36(sp)
8000126a:	5b02                	lw	s6,32(sp)
8000126c:	4bf2                	lw	s7,28(sp)
8000126e:	4c62                	lw	s8,24(sp)
80001270:	4cd2                	lw	s9,20(sp)
80001272:	4d42                	lw	s10,16(sp)
80001274:	4db2                	lw	s11,12(sp)
80001276:	6121                	addi	sp,sp,64
80001278:	8082                	ret
		} else if (remaining <= min_width
8000127a:	fb544ae3          	blt	s0,s5,8000122e <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
8000127e:	fb6de8e3          	bltu	s11,s6,8000122e <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001282:	85d2                	mv	a1,s4
80001284:	8566                	mv	a0,s9
80001286:	9982                	jalr	s3
			digits++;
80001288:	0905                	addi	s2,s2,1
8000128a:	b755                	j	8000122e <_printk_dec_ulong+0x6a>
			out(' ', ctx);
8000128c:	85d2                	mv	a1,s4
8000128e:	02000513          	li	a0,32
80001292:	9982                	jalr	s3
80001294:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001296:	fe804be3          	bgtz	s0,8000128c <_printk_dec_ulong+0xc8>
8000129a:	b7c9                	j	8000125c <_printk_dec_ulong+0x98>

8000129c <__printk_hook_install>:
	_char_out = fn;
8000129c:	800057b7          	lui	a5,0x80005
800012a0:	1ca7a423          	sw	a0,456(a5) # 800051c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051c9>
}
800012a4:	8082                	ret

800012a6 <z_vprintk>:
{
800012a6:	715d                	addi	sp,sp,-80
800012a8:	c4a2                	sw	s0,72(sp)
800012aa:	c2a6                	sw	s1,68(sp)
800012ac:	c0ca                	sw	s2,64(sp)
800012ae:	de4e                	sw	s3,60(sp)
800012b0:	dc52                	sw	s4,56(sp)
800012b2:	da56                	sw	s5,52(sp)
800012b4:	d266                	sw	s9,36(sp)
800012b6:	d06a                	sw	s10,32(sp)
800012b8:	ce6e                	sw	s11,28(sp)
800012ba:	c686                	sw	ra,76(sp)
800012bc:	d85a                	sw	s6,48(sp)
800012be:	d65e                	sw	s7,44(sp)
800012c0:	d462                	sw	s8,40(sp)
800012c2:	842a                	mv	s0,a0
800012c4:	84ae                	mv	s1,a1
800012c6:	8ab2                	mv	s5,a2
800012c8:	8d36                	mv	s10,a3
	int long_ctr = 0;
800012ca:	4a01                	li	s4,0
	int min_width = -1;
800012cc:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
800012ce:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800012d0:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
800012d2:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800012d6:	000ac503          	lbu	a0,0(s5)
800012da:	e105                	bnez	a0,800012fa <z_vprintk+0x54>
}
800012dc:	40b6                	lw	ra,76(sp)
800012de:	4426                	lw	s0,72(sp)
800012e0:	4496                	lw	s1,68(sp)
800012e2:	4906                	lw	s2,64(sp)
800012e4:	59f2                	lw	s3,60(sp)
800012e6:	5a62                	lw	s4,56(sp)
800012e8:	5ad2                	lw	s5,52(sp)
800012ea:	5b42                	lw	s6,48(sp)
800012ec:	5bb2                	lw	s7,44(sp)
800012ee:	5c22                	lw	s8,40(sp)
800012f0:	5c92                	lw	s9,36(sp)
800012f2:	5d02                	lw	s10,32(sp)
800012f4:	4df2                	lw	s11,28(sp)
800012f6:	6161                	addi	sp,sp,80
800012f8:	8082                	ret
		if (!might_format) {
800012fa:	000c9a63          	bnez	s9,8000130e <z_vprintk+0x68>
			if (*fmt != '%') {
800012fe:	02500693          	li	a3,37
80001302:	28d50563          	beq	a0,a3,8000158c <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
80001306:	85a6                	mv	a1,s1
80001308:	9402                	jalr	s0
		++fmt;
8000130a:	0a85                	addi	s5,s5,1
8000130c:	b7e9                	j	800012d6 <z_vprintk+0x30>
			switch (*fmt) {
8000130e:	06400693          	li	a3,100
80001312:	0ed50b63          	beq	a0,a3,80001408 <z_vprintk+0x162>
80001316:	04a6eb63          	bltu	a3,a0,8000136c <z_vprintk+0xc6>
8000131a:	03900693          	li	a3,57
8000131e:	02a6e763          	bltu	a3,a0,8000134c <z_vprintk+0xa6>
80001322:	03100693          	li	a3,49
80001326:	0cd57563          	bgeu	a0,a3,800013f0 <z_vprintk+0x14a>
8000132a:	02d00693          	li	a3,45
8000132e:	26d50463          	beq	a0,a3,80001596 <z_vprintk+0x2f0>
80001332:	03000793          	li	a5,48
80001336:	0af50363          	beq	a0,a5,800013dc <z_vprintk+0x136>
8000133a:	02500713          	li	a4,37
8000133e:	00e51f63          	bne	a0,a4,8000135c <z_vprintk+0xb6>
				out((int)'%', ctx);
80001342:	85a6                	mv	a1,s1
80001344:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80001348:	9402                	jalr	s0
				break;
8000134a:	aa09                	j	8000145c <z_vprintk+0x1b6>
8000134c:	05800693          	li	a3,88
80001350:	14d50b63          	beq	a0,a3,800014a6 <z_vprintk+0x200>
80001354:	06300713          	li	a4,99
80001358:	22e50363          	beq	a0,a4,8000157e <z_vprintk+0x2d8>
				out((int)'%', ctx);
8000135c:	85a6                	mv	a1,s1
8000135e:	02500513          	li	a0,37
80001362:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001364:	85a6                	mv	a1,s1
80001366:	000ac503          	lbu	a0,0(s5)
8000136a:	bff9                	j	80001348 <z_vprintk+0xa2>
8000136c:	07000693          	li	a3,112
80001370:	12d50163          	beq	a0,a3,80001492 <z_vprintk+0x1ec>
80001374:	00a6ef63          	bltu	a3,a0,80001392 <z_vprintk+0xec>
80001378:	06900693          	li	a3,105
8000137c:	08d50663          	beq	a0,a3,80001408 <z_vprintk+0x162>
80001380:	06c00693          	li	a3,108
80001384:	08d50063          	beq	a0,a3,80001404 <z_vprintk+0x15e>
80001388:	06800693          	li	a3,104
8000138c:	f6d50fe3          	beq	a0,a3,8000130a <z_vprintk+0x64>
80001390:	b7f1                	j	8000135c <z_vprintk+0xb6>
80001392:	07500693          	li	a3,117
80001396:	0cd50563          	beq	a0,a3,80001460 <z_vprintk+0x1ba>
8000139a:	02a6ea63          	bltu	a3,a0,800013ce <z_vprintk+0x128>
8000139e:	07300713          	li	a4,115
800013a2:	fae51de3          	bne	a0,a4,8000135c <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
800013a6:	000d2c03          	lw	s8,0(s10)
800013aa:	004d0b13          	addi	s6,s10,4
800013ae:	8be2                	mv	s7,s8
				while (*s)
800013b0:	000bc503          	lbu	a0,0(s7)
800013b4:	1a051b63          	bnez	a0,8000156a <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
800013b8:	478d                	li	a5,3
800013ba:	00f99863          	bne	s3,a5,800013ca <z_vprintk+0x124>
					int remaining = min_width - (s - start);
800013be:	418b8bb3          	sub	s7,s7,s8
800013c2:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800013c6:	1b704663          	bgtz	s7,80001572 <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
800013ca:	8d5a                	mv	s10,s6
800013cc:	a841                	j	8000145c <z_vprintk+0x1b6>
800013ce:	07800693          	li	a3,120
800013d2:	0cd50a63          	beq	a0,a3,800014a6 <z_vprintk+0x200>
800013d6:	07a00693          	li	a3,122
800013da:	bf4d                	j	8000138c <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
800013dc:	00095c63          	bgez	s2,800013f4 <z_vprintk+0x14e>
800013e0:	1a098d63          	beqz	s3,8000159a <z_vprintk+0x2f4>
					min_width = *fmt - '0';
800013e4:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
800013e8:	f20991e3          	bnez	s3,8000130a <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
800013ec:	4989                	li	s3,2
800013ee:	bf31                	j	8000130a <z_vprintk+0x64>
				if (min_width < 0) {
800013f0:	fe094ae3          	bltz	s2,800013e4 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
800013f4:	00291693          	slli	a3,s2,0x2
800013f8:	9936                	add	s2,s2,a3
800013fa:	0906                	slli	s2,s2,0x1
800013fc:	fd090913          	addi	s2,s2,-48
80001400:	992a                	add	s2,s2,a0
80001402:	b7dd                	j	800013e8 <z_vprintk+0x142>
				long_ctr++;
80001404:	0a05                	addi	s4,s4,1
80001406:	b711                	j	8000130a <z_vprintk+0x64>
				if (long_ctr == 0) {
80001408:	020a1663          	bnez	s4,80001434 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
8000140c:	000d2603          	lw	a2,0(s10)
80001410:	0d11                	addi	s10,s10,4
				if (d < 0) {
80001412:	00065b63          	bgez	a2,80001428 <z_vprintk+0x182>
					out((int)'-', ctx);
80001416:	85a6                	mv	a1,s1
80001418:	02d00513          	li	a0,45
8000141c:	c032                	sw	a2,0(sp)
8000141e:	9402                	jalr	s0
					d = -d;
80001420:	4602                	lw	a2,0(sp)
					min_width--;
80001422:	197d                	addi	s2,s2,-1
					d = -d;
80001424:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001428:	874a                	mv	a4,s2
8000142a:	86ce                	mv	a3,s3
8000142c:	85a6                	mv	a1,s1
8000142e:	8522                	mv	a0,s0
80001430:	3b51                	jal	800011c4 <_printk_dec_ulong>
				break;
80001432:	a02d                	j	8000145c <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
80001434:	4705                	li	a4,1
80001436:	fcea0be3          	beq	s4,a4,8000140c <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
8000143a:	007d0793          	addi	a5,s10,7
8000143e:	ff87f713          	andi	a4,a5,-8
80001442:	4310                	lw	a2,0(a4)
80001444:	4354                	lw	a3,4(a4)
80001446:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
8000144a:	01b60733          	add	a4,a2,s11
8000144e:	00c73733          	sltu	a4,a4,a2
80001452:	9736                	add	a4,a4,a3
80001454:	df5d                	beqz	a4,80001412 <z_vprintk+0x16c>
						print_err(out, ctx);
80001456:	85a6                	mv	a1,s1
80001458:	8522                	mv	a0,s0
8000145a:	333d                	jal	80001188 <print_err>
			might_format = 0;
8000145c:	4c81                	li	s9,0
8000145e:	b575                	j	8000130a <z_vprintk+0x64>
				if (long_ctr == 0) {
80001460:	000a1663          	bnez	s4,8000146c <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80001464:	000d2603          	lw	a2,0(s10)
80001468:	0d11                	addi	s10,s10,4
8000146a:	bf7d                	j	80001428 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
8000146c:	4705                	li	a4,1
8000146e:	feea0be3          	beq	s4,a4,80001464 <z_vprintk+0x1be>
					unsigned long long llu =
80001472:	007d0793          	addi	a5,s10,7
80001476:	ff87f713          	andi	a4,a5,-8
8000147a:	00870d13          	addi	s10,a4,8
8000147e:	4310                	lw	a2,0(a4)
80001480:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001482:	fb71                	bnez	a4,80001456 <z_vprintk+0x1b0>
80001484:	800007b7          	lui	a5,0x80000
80001488:	fff7c793          	not	a5,a5
8000148c:	f8c7fee3          	bgeu	a5,a2,80001428 <z_vprintk+0x182>
80001490:	b7d9                	j	80001456 <z_vprintk+0x1b0>
				  out('0', ctx);
80001492:	85a6                	mv	a1,s1
80001494:	03000513          	li	a0,48
80001498:	9402                	jalr	s0
				  out('x', ctx);
8000149a:	85a6                	mv	a1,s1
8000149c:	07800513          	li	a0,120
800014a0:	9402                	jalr	s0
				  min_width = 8;
800014a2:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
800014a4:	4985                	li	s3,1
				if (long_ctr < 2) {
800014a6:	4685                	li	a3,1
800014a8:	0746c663          	blt	a3,s4,80001514 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
800014ac:	000d2783          	lw	a5,0(s10)
800014b0:	c402                	sw	zero,8(sp)
800014b2:	0d11                	addi	s10,s10,4
800014b4:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800014b6:	4c41                	li	s8,16
	int digits = 0;
800014b8:	4b81                	li	s7,0
	int found_largest_digit = 0;
800014ba:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800014bc:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800014be:	4512                	lw	a0,4(sp)
800014c0:	45a2                	lw	a1,8(sp)
800014c2:	fff88b13          	addi	s6,a7,-1
800014c6:	002b1613          	slli	a2,s6,0x2
800014ca:	c646                	sw	a7,12(sp)
800014cc:	d45fe0ef          	jal	ra,80000210 <__lshrdi3>
800014d0:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800014d2:	ed39                	bnez	a0,80001530 <z_vprintk+0x28a>
800014d4:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800014d6:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800014da:	e789                	bnez	a5,800014e4 <z_vprintk+0x23e>
800014dc:	48b2                	lw	a7,12(sp)
800014de:	4785                	li	a5,1
800014e0:	06f89063          	bne	a7,a5,80001540 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
800014e4:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
800014e6:	0562                	slli	a0,a0,0x18
800014e8:	85a6                	mv	a1,s1
800014ea:	8561                	srai	a0,a0,0x18
800014ec:	9402                	jalr	s0
			digits++;
800014ee:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
800014f0:	020b1d63          	bnez	s6,8000152a <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
800014f4:	468d                	li	a3,3
			might_format = 0;
800014f6:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800014f8:	e0d999e3          	bne	s3,a3,8000130a <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
800014fc:	00191713          	slli	a4,s2,0x1
80001500:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001504:	f5705ce3          	blez	s7,8000145c <z_vprintk+0x1b6>
			out(' ', ctx);
80001508:	85a6                	mv	a1,s1
8000150a:	02000513          	li	a0,32
8000150e:	9402                	jalr	s0
80001510:	1bfd                	addi	s7,s7,-1
80001512:	bfcd                	j	80001504 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
80001514:	007d0793          	addi	a5,s10,7
80001518:	ff87f693          	andi	a3,a5,-8
8000151c:	429c                	lw	a5,0(a3)
8000151e:	00868d13          	addi	s10,a3,8
80001522:	c23e                	sw	a5,4(sp)
80001524:	42dc                	lw	a5,4(a3)
80001526:	c43e                	sw	a5,8(sp)
80001528:	b779                	j	800014b6 <z_vprintk+0x210>
			found_largest_digit = 1;
8000152a:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
8000152c:	88da                	mv	a7,s6
8000152e:	bf41                	j	800014be <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
80001530:	47a5                	li	a5,9
80001532:	05700693          	li	a3,87
80001536:	faa7e7e3          	bltu	a5,a0,800014e4 <z_vprintk+0x23e>
8000153a:	03000693          	li	a3,48
8000153e:	b75d                	j	800014e4 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
80001540:	fffc0793          	addi	a5,s8,-1
80001544:	c63e                	sw	a5,12(sp)
80001546:	01894963          	blt	s2,s8,80001558 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
8000154a:	4785                	li	a5,1
8000154c:	00f99863          	bne	s3,a5,8000155c <z_vprintk+0x2b6>
				out('0', ctx);
80001550:	85a6                	mv	a1,s1
80001552:	03000513          	li	a0,48
				out(' ', ctx);
80001556:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
80001558:	4c32                	lw	s8,12(sp)
8000155a:	bfc9                	j	8000152c <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
8000155c:	4789                	li	a5,2
8000155e:	fef99de3          	bne	s3,a5,80001558 <z_vprintk+0x2b2>
				out(' ', ctx);
80001562:	85a6                	mv	a1,s1
80001564:	02000513          	li	a0,32
80001568:	b7fd                	j	80001556 <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
8000156a:	85a6                	mv	a1,s1
8000156c:	0b85                	addi	s7,s7,1
8000156e:	9402                	jalr	s0
80001570:	b581                	j	800013b0 <z_vprintk+0x10a>
						out(' ', ctx);
80001572:	85a6                	mv	a1,s1
80001574:	02000513          	li	a0,32
80001578:	9402                	jalr	s0
8000157a:	1bfd                	addi	s7,s7,-1
8000157c:	b5a9                	j	800013c6 <z_vprintk+0x120>
				out(c, ctx);
8000157e:	000d2503          	lw	a0,0(s10)
80001582:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80001584:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001588:	9402                	jalr	s0
				break;
8000158a:	b581                	j	800013ca <z_vprintk+0x124>
				long_ctr = 0;
8000158c:	4a01                	li	s4,0
				min_width = -1;
8000158e:	597d                	li	s2,-1
				padding = PAD_NONE;
80001590:	4981                	li	s3,0
				might_format = 1;
80001592:	4c85                	li	s9,1
80001594:	bb9d                	j	8000130a <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
80001596:	498d                	li	s3,3
80001598:	bb8d                	j	8000130a <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
8000159a:	4985                	li	s3,1
8000159c:	b3bd                	j	8000130a <z_vprintk+0x64>

8000159e <vprintk>:
{
8000159e:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800015a0:	862a                	mv	a2,a0
800015a2:	80001537          	lui	a0,0x80001
800015a6:	86ae                	mv	a3,a1
800015a8:	1b450513          	addi	a0,a0,436 # 800011b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800011b5>
800015ac:	006c                	addi	a1,sp,12
{
800015ae:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800015b0:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800015b2:	39d5                	jal	800012a6 <z_vprintk>
}
800015b4:	40f2                	lw	ra,28(sp)
800015b6:	6105                	addi	sp,sp,32
800015b8:	8082                	ret

800015ba <printk>:
{
800015ba:	7139                	addi	sp,sp,-64
800015bc:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
800015be:	104c                	addi	a1,sp,36
{
800015c0:	ce06                	sw	ra,28(sp)
800015c2:	d432                	sw	a2,40(sp)
800015c4:	d636                	sw	a3,44(sp)
800015c6:	d83a                	sw	a4,48(sp)
800015c8:	da3e                	sw	a5,52(sp)
800015ca:	dc42                	sw	a6,56(sp)
800015cc:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
800015ce:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
800015d0:	37f9                	jal	8000159e <vprintk>
}
800015d2:	40f2                	lw	ra,28(sp)
800015d4:	6121                	addi	sp,sp,64
800015d6:	8082                	ret

800015d8 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
800015d8:	800055b7          	lui	a1,0x80005
800015dc:	80005537          	lui	a0,0x80005
{
800015e0:	1141                	addi	sp,sp,-16
  k_panic();
800015e2:	c0c58593          	addi	a1,a1,-1012 # 80004c0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c0d>
800015e6:	c2050513          	addi	a0,a0,-992 # 80004c20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c21>
800015ea:	4679                	li	a2,30
{
800015ec:	c606                	sw	ra,12(sp)
  k_panic();
800015ee:	37f1                	jal	800015ba <printk>
800015f0:	800045b7          	lui	a1,0x80004
800015f4:	7ec58593          	addi	a1,a1,2028 # 800047ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047ed>
800015f8:	4519                	li	a0,6
800015fa:	e08ff0ef          	jal	ra,80000c02 <z_NanoFatalErrorHandler>

800015fe <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800015fe:	8082                	ret

80001600 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001600:	47a1                	li	a5,8
80001602:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001606:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
8000160a:	8082                	ret

8000160c <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
8000160c:	4785                	li	a5,1
8000160e:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001612:	30452573          	csrrs	a0,mie,a0
}
80001616:	8082                	ret

80001618 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001618:	47a1                	li	a5,8
8000161a:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
8000161e:	30405073          	csrwi	mie,0
80001622:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001626:	8082                	ret

80001628 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001628:	1141                	addi	sp,sp,-16
8000162a:	c422                	sw	s0,8(sp)
8000162c:	c226                	sw	s1,4(sp)
8000162e:	80005437          	lui	s0,0x80005
80001632:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001634:	47a9                	li	a5,10
{
80001636:	84aa                	mv	s1,a0
80001638:	2ac40413          	addi	s0,s0,684 # 800052ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052ad>
	if ('\n' == c) {
8000163c:	00f51763          	bne	a0,a5,8000164a <console_out+0x22>
80001640:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001642:	45b5                	li	a1,13
80001644:	415c                	lw	a5,4(a0)
80001646:	43dc                	lw	a5,4(a5)
80001648:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
8000164a:	4008                	lw	a0,0(s0)
8000164c:	0ff4f593          	andi	a1,s1,255
80001650:	415c                	lw	a5,4(a0)
80001652:	43dc                	lw	a5,4(a5)
80001654:	9782                	jalr	a5

	return c;
}
80001656:	40b2                	lw	ra,12(sp)
80001658:	4422                	lw	s0,8(sp)
8000165a:	8526                	mv	a0,s1
8000165c:	4492                	lw	s1,4(sp)
8000165e:	0141                	addi	sp,sp,16
80001660:	8082                	ret

80001662 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001662:	1141                	addi	sp,sp,-16
80001664:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001666:	80001437          	lui	s0,0x80001
8000166a:	62840513          	addi	a0,s0,1576 # 80001628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001629>
{
8000166e:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001670:	21b5                	jal	80001adc <__stdout_hook_install>
	__printk_hook_install(console_out);
80001672:	62840513          	addi	a0,s0,1576
}
80001676:	4422                	lw	s0,8(sp)
80001678:	40b2                	lw	ra,12(sp)
8000167a:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
8000167c:	b105                	j	8000129c <__printk_hook_install>

8000167e <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
8000167e:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001682:	1141                	addi	sp,sp,-16
80001684:	c2c50513          	addi	a0,a0,-980 # 80004c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c2d>
80001688:	c606                	sw	ra,12(sp)
8000168a:	6ec000ef          	jal	ra,80001d76 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000168e:	800057b7          	lui	a5,0x80005
80001692:	2aa7a623          	sw	a0,684(a5) # 800052ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052ad>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001696:	37f1                	jal	80001662 <uart_console_hook_install>

	return 0;
}
80001698:	40b2                	lw	ra,12(sp)
8000169a:	4501                	li	a0,0
8000169c:	0141                	addi	sp,sp,16
8000169e:	8082                	ret

800016a0 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
800016a0:	f01007b7          	lui	a5,0xf0100
800016a4:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
800016a8:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
800016ac:	f447a583          	lw	a1,-188(a5)
800016b0:	fee59ae3          	bne	a1,a4,800016a4 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
800016b4:	8082                	ret

800016b6 <timer_isr>:

static void timer_isr(void *arg)
{
800016b6:	1101                	addi	sp,sp,-32
800016b8:	cc22                	sw	s0,24(sp)
800016ba:	ce06                	sw	ra,28(sp)
800016bc:	ca26                	sw	s1,20(sp)
800016be:	c84a                	sw	s2,16(sp)
800016c0:	c64e                	sw	s3,12(sp)
800016c2:	c452                	sw	s4,8(sp)
800016c4:	c256                	sw	s5,4(sp)
800016c6:	4421                	li	s0,8
800016c8:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800016cc:	80005937          	lui	s2,0x80005
800016d0:	2b090513          	addi	a0,s2,688 # 800052b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b1>
	key = (mstatus & SOC_MSTATUS_IEN);
800016d4:	8821                	andi	s0,s0,8
800016d6:	2ea020ef          	jal	ra,800039c0 <z_spin_lock_valid>
800016da:	e915                	bnez	a0,8000170e <timer_isr+0x58>
800016dc:	800054b7          	lui	s1,0x80005
800016e0:	800055b7          	lui	a1,0x80005
800016e4:	80005537          	lui	a0,0x80005
800016e8:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800016ec:	04e00693          	li	a3,78
800016f0:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800016f4:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800016f8:	35c9                	jal	800015ba <printk>
800016fa:	80005537          	lui	a0,0x80005
800016fe:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80001702:	3d65                	jal	800015ba <printk>
80001704:	04e00593          	li	a1,78
80001708:	c4048513          	addi	a0,s1,-960
8000170c:	35f1                	jal	800015d8 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
8000170e:	2b090513          	addi	a0,s2,688
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001712:	800054b7          	lui	s1,0x80005
80001716:	2e6020ef          	jal	ra,800039fc <z_spin_lock_set_owner>
8000171a:	28848493          	addi	s1,s1,648 # 80005288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005289>
	u64_t now = mtime();
8000171e:	3749                	jal	800016a0 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001720:	0004a983          	lw	s3,0(s1)
80001724:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001728:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
8000172a:	41350533          	sub	a0,a0,s3
8000172e:	00a7b7b3          	sltu	a5,a5,a0
80001732:	415585b3          	sub	a1,a1,s5
80001736:	6675                	lui	a2,0x1d
80001738:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000173c:	4681                	li	a3,0
8000173e:	8d9d                	sub	a1,a1,a5
80001740:	b09fe0ef          	jal	ra,80000248 <__udivdi3>
80001744:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001746:	65f5                	lui	a1,0x1d
80001748:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000174c:	8552                	mv	a0,s4
8000174e:	8ceff0ef          	jal	ra,8000081c <__mulsi3>
80001752:	99aa                	add	s3,s3,a0
80001754:	00a9b533          	sltu	a0,s3,a0
80001758:	9556                	add	a0,a0,s5
8000175a:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000175c:	2b090513          	addi	a0,s2,688
80001760:	0134a023          	sw	s3,0(s1)
80001764:	276020ef          	jal	ra,800039da <z_spin_unlock_valid>
80001768:	e915                	bnez	a0,8000179c <timer_isr+0xe6>
8000176a:	800054b7          	lui	s1,0x80005
8000176e:	800055b7          	lui	a1,0x80005
80001772:	80005537          	lui	a0,0x80005
80001776:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
8000177a:	06100693          	li	a3,97
8000177e:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80001782:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80001786:	3d15                	jal	800015ba <printk>
80001788:	80005537          	lui	a0,0x80005
8000178c:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80001790:	352d                	jal	800015ba <printk>
80001792:	06100593          	li	a1,97
80001796:	c4048513          	addi	a0,s1,-960
8000179a:	3d3d                	jal	800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000179c:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
800017a0:	4462                	lw	s0,24(sp)
800017a2:	40f2                	lw	ra,28(sp)
800017a4:	44d2                	lw	s1,20(sp)
800017a6:	4942                	lw	s2,16(sp)
800017a8:	49b2                	lw	s3,12(sp)
800017aa:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800017ac:	8552                	mv	a0,s4
}
800017ae:	4a22                	lw	s4,8(sp)
800017b0:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800017b2:	2030206f          	j	800041b4 <z_clock_announce>

800017b6 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800017b6:	1141                	addi	sp,sp,-16
800017b8:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800017ba:	35dd                	jal	800016a0 <mtime>
800017bc:	67f5                	lui	a5,0x1d
800017be:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800017c2:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800017c6:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
800017c8:	56fd                	li	a3,-1
800017ca:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
800017ce:	00a7b533          	sltu	a0,a5,a0
800017d2:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
800017d4:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800017d8:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800017dc:	451d                	li	a0,7
800017de:	353d                	jal	8000160c <z_arch_irq_enable>
	return 0;
}
800017e0:	40b2                	lw	ra,12(sp)
800017e2:	4501                	li	a0,0
800017e4:	0141                	addi	sp,sp,16
800017e6:	8082                	ret

800017e8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800017e8:	14059563          	bnez	a1,80001932 <z_clock_set_timeout+0x14a>
{
800017ec:	1101                	addi	sp,sp,-32
800017ee:	ce06                	sw	ra,28(sp)
800017f0:	cc22                	sw	s0,24(sp)
800017f2:	ca26                	sw	s1,20(sp)
800017f4:	c84a                	sw	s2,16(sp)
800017f6:	c64e                	sw	s3,12(sp)
800017f8:	c452                	sw	s4,8(sp)
800017fa:	c256                	sw	s5,4(sp)
800017fc:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800017fe:	57fd                	li	a5,-1
80001800:	00f51563          	bne	a0,a5,8000180a <z_clock_set_timeout+0x22>
80001804:	6525                	lui	a0,0x9
80001806:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
8000180a:	67a5                	lui	a5,0x9
8000180c:	fff50413          	addi	s0,a0,-1
80001810:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001814:	1087db63          	bge	a5,s0,8000192a <z_clock_set_timeout+0x142>
80001818:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000181a:	4921                	li	s2,8
8000181c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001820:	80005ab7          	lui	s5,0x80005
80001824:	2b0a8513          	addi	a0,s5,688 # 800052b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b1>
	key = (mstatus & SOC_MSTATUS_IEN);
80001828:	00897913          	andi	s2,s2,8
8000182c:	194020ef          	jal	ra,800039c0 <z_spin_lock_valid>
80001830:	e915                	bnez	a0,80001864 <z_clock_set_timeout+0x7c>
80001832:	800054b7          	lui	s1,0x80005
80001836:	800055b7          	lui	a1,0x80005
8000183a:	80005537          	lui	a0,0x80005
8000183e:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80001842:	04e00693          	li	a3,78
80001846:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000184a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000184e:	33b5                	jal	800015ba <printk>
80001850:	80005537          	lui	a0,0x80005
80001854:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80001858:	338d                	jal	800015ba <printk>
8000185a:	04e00593          	li	a1,78
8000185e:	c4048513          	addi	a0,s1,-960
80001862:	3b9d                	jal	800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80001864:	2b0a8513          	addi	a0,s5,688
80001868:	194020ef          	jal	ra,800039fc <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
8000186c:	3d15                	jal	800016a0 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000186e:	800057b7          	lui	a5,0x80005
80001872:	28878793          	addi	a5,a5,648 # 80005288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005289>
	u32_t cyc = ticks * CYC_PER_TICK;
80001876:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001878:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
8000187c:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
8000187e:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001882:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001884:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001888:	f95fe0ef          	jal	ra,8000081c <__mulsi3>
8000188c:	4bf48793          	addi	a5,s1,1215
80001890:	413787b3          	sub	a5,a5,s3
80001894:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001896:	4c048593          	addi	a1,s1,1216
8000189a:	9552                	add	a0,a0,s4
8000189c:	fadfe0ef          	jal	ra,80000848 <__udivsi3>
800018a0:	4c048593          	addi	a1,s1,1216
800018a4:	f79fe0ef          	jal	ra,8000081c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800018a8:	41498a33          	sub	s4,s3,s4
800018ac:	9a2a                	add	s4,s4,a0
800018ae:	3e700793          	li	a5,999
800018b2:	0147c563          	blt	a5,s4,800018bc <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
800018b6:	4c048493          	addi	s1,s1,1216
800018ba:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
800018bc:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
800018c0:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
800018c2:	577d                	li	a4,-1
800018c4:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
800018c8:	00a9b533          	sltu	a0,s3,a0
800018cc:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
800018ce:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800018d2:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800018d6:	2b0a8513          	addi	a0,s5,688
800018da:	100020ef          	jal	ra,800039da <z_spin_unlock_valid>
800018de:	e915                	bnez	a0,80001912 <z_clock_set_timeout+0x12a>
800018e0:	80005437          	lui	s0,0x80005
800018e4:	800055b7          	lui	a1,0x80005
800018e8:	80005537          	lui	a0,0x80005
800018ec:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800018f0:	06100693          	li	a3,97
800018f4:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800018f8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800018fc:	397d                	jal	800015ba <printk>
800018fe:	80005537          	lui	a0,0x80005
80001902:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80001906:	3955                	jal	800015ba <printk>
80001908:	06100593          	li	a1,97
8000190c:	c4040513          	addi	a0,s0,-960
80001910:	31e1                	jal	800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001912:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80001916:	40f2                	lw	ra,28(sp)
80001918:	4462                	lw	s0,24(sp)
8000191a:	44d2                	lw	s1,20(sp)
8000191c:	4942                	lw	s2,16(sp)
8000191e:	49b2                	lw	s3,12(sp)
80001920:	4a22                	lw	s4,8(sp)
80001922:	4a92                	lw	s5,4(sp)
80001924:	4b02                	lw	s6,0(sp)
80001926:	6105                	addi	sp,sp,32
80001928:	8082                	ret
8000192a:	ee0458e3          	bgez	s0,8000181a <z_clock_set_timeout+0x32>
8000192e:	4401                	li	s0,0
80001930:	b5ed                	j	8000181a <z_clock_set_timeout+0x32>
80001932:	8082                	ret

80001934 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001934:	1141                	addi	sp,sp,-16
80001936:	c422                	sw	s0,8(sp)
80001938:	c606                	sw	ra,12(sp)
8000193a:	c226                	sw	s1,4(sp)
8000193c:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000193e:	4421                	li	s0,8
80001940:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001944:	800054b7          	lui	s1,0x80005
80001948:	2b048513          	addi	a0,s1,688 # 800052b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000194c:	8821                	andi	s0,s0,8
8000194e:	072020ef          	jal	ra,800039c0 <z_spin_lock_valid>
80001952:	e915                	bnez	a0,80001986 <z_clock_elapsed+0x52>
80001954:	80005937          	lui	s2,0x80005
80001958:	800055b7          	lui	a1,0x80005
8000195c:	80005537          	lui	a0,0x80005
80001960:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80001964:	04e00693          	li	a3,78
80001968:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000196c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80001970:	31a9                	jal	800015ba <printk>
80001972:	80005537          	lui	a0,0x80005
80001976:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
8000197a:	3181                	jal	800015ba <printk>
8000197c:	04e00593          	li	a1,78
80001980:	c4090513          	addi	a0,s2,-960
80001984:	3991                	jal	800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80001986:	2b048513          	addi	a0,s1,688
8000198a:	072020ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000198e:	3b09                	jal	800016a0 <mtime>
80001990:	800057b7          	lui	a5,0x80005
80001994:	2887a783          	lw	a5,648(a5) # 80005288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005289>
80001998:	65f5                	lui	a1,0x1d
8000199a:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000199e:	8d1d                	sub	a0,a0,a5
800019a0:	ea9fe0ef          	jal	ra,80000848 <__udivsi3>
800019a4:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800019a6:	2b048513          	addi	a0,s1,688
800019aa:	030020ef          	jal	ra,800039da <z_spin_unlock_valid>
800019ae:	e915                	bnez	a0,800019e2 <z_clock_elapsed+0xae>
800019b0:	800054b7          	lui	s1,0x80005
800019b4:	800055b7          	lui	a1,0x80005
800019b8:	80005537          	lui	a0,0x80005
800019bc:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800019c0:	06100693          	li	a3,97
800019c4:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800019c8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800019cc:	36fd                	jal	800015ba <printk>
800019ce:	80005537          	lui	a0,0x80005
800019d2:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800019d6:	36d5                	jal	800015ba <printk>
800019d8:	06100593          	li	a1,97
800019dc:	c4048513          	addi	a0,s1,-960
800019e0:	3ee5                	jal	800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800019e2:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
800019e6:	40b2                	lw	ra,12(sp)
800019e8:	4422                	lw	s0,8(sp)
800019ea:	854a                	mv	a0,s2
800019ec:	4492                	lw	s1,4(sp)
800019ee:	4902                	lw	s2,0(sp)
800019f0:	0141                	addi	sp,sp,16
800019f2:	8082                	ret

800019f4 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
800019f4:	00054783          	lbu	a5,0(a0)
800019f8:	0005c703          	lbu	a4,0(a1)
800019fc:	00e79363          	bne	a5,a4,80001a02 <strcmp+0xe>
80001a00:	e781                	bnez	a5,80001a08 <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001a02:	40e78533          	sub	a0,a5,a4
80001a06:	8082                	ret
		s1++;
80001a08:	0505                	addi	a0,a0,1
		s2++;
80001a0a:	0585                	addi	a1,a1,1
80001a0c:	b7e5                	j	800019f4 <strcmp>

80001a0e <memcpy>:
	/* attempt word-sized copying only if buffers have identical alignment */

	unsigned char *d_byte = (unsigned char *)d;
	const unsigned char *s_byte = (const unsigned char *)s;

	if ((((unsigned int)d ^ (unsigned int)s_byte) & 0x3) == 0U) {
80001a0e:	00b547b3          	xor	a5,a0,a1
80001a12:	8b8d                	andi	a5,a5,3
80001a14:	cf95                	beqz	a5,80001a50 <memcpy+0x42>
	unsigned char *d_byte = (unsigned char *)d;
80001a16:	87aa                	mv	a5,a0
80001a18:	4701                	li	a4,0
		s_byte = (unsigned char *)s_word;
	}

	/* do byte-sized copying until finished */

	while (n > 0) {
80001a1a:	04e61763          	bne	a2,a4,80001a68 <memcpy+0x5a>
		*(d_byte++) = *(s_byte++);
		n--;
	}

	return d;
}
80001a1e:	8082                	ret
			if (n == 0) {
80001a20:	de7d                	beqz	a2,80001a1e <memcpy+0x10>
			*(d_byte++) = *(s_byte++);
80001a22:	0585                	addi	a1,a1,1
80001a24:	fff5c703          	lbu	a4,-1(a1)
80001a28:	0785                	addi	a5,a5,1
			n--;
80001a2a:	167d                	addi	a2,a2,-1
			*(d_byte++) = *(s_byte++);
80001a2c:	fee78fa3          	sb	a4,-1(a5)
		while (((unsigned int)d_byte) & 0x3) {
80001a30:	0037f713          	andi	a4,a5,3
80001a34:	f775                	bnez	a4,80001a20 <memcpy+0x12>
		while (n >= sizeof(unsigned int)) {
80001a36:	468d                	li	a3,3
80001a38:	40e60833          	sub	a6,a2,a4
80001a3c:	0106ec63          	bltu	a3,a6,80001a54 <memcpy+0x46>
80001a40:	00265713          	srli	a4,a2,0x2
80001a44:	00271693          	slli	a3,a4,0x2
80001a48:	8e15                	sub	a2,a2,a3
80001a4a:	97b6                	add	a5,a5,a3
80001a4c:	95b6                	add	a1,a1,a3
80001a4e:	b7e9                	j	80001a18 <memcpy+0xa>
	unsigned char *d_byte = (unsigned char *)d;
80001a50:	87aa                	mv	a5,a0
80001a52:	bff9                	j	80001a30 <memcpy+0x22>
			*(d_word++) = *(s_word++);
80001a54:	00e588b3          	add	a7,a1,a4
80001a58:	0008a883          	lw	a7,0(a7)
80001a5c:	00e78833          	add	a6,a5,a4
80001a60:	0711                	addi	a4,a4,4
80001a62:	01182023          	sw	a7,0(a6)
			n -= sizeof(unsigned int);
80001a66:	bfc9                	j	80001a38 <memcpy+0x2a>
		*(d_byte++) = *(s_byte++);
80001a68:	00e58833          	add	a6,a1,a4
80001a6c:	00084803          	lbu	a6,0(a6)
80001a70:	00e786b3          	add	a3,a5,a4
80001a74:	0705                	addi	a4,a4,1
80001a76:	01068023          	sb	a6,0(a3)
		n--;
80001a7a:	b745                	j	80001a1a <memcpy+0xc>

80001a7c <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001a7c:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001a80:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001a82:	0037f713          	andi	a4,a5,3
80001a86:	eb1d                	bnez	a4,80001abc <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001a88:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001a8c:	00859713          	slli	a4,a1,0x8
80001a90:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
80001a92:	01059713          	slli	a4,a1,0x10
80001a96:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
80001a98:	00c78333          	add	t1,a5,a2
80001a9c:	873e                	mv	a4,a5
80001a9e:	480d                	li	a6,3
80001aa0:	40e308b3          	sub	a7,t1,a4
80001aa4:	03186263          	bltu	a6,a7,80001ac8 <memset+0x4c>
80001aa8:	00265713          	srli	a4,a2,0x2
80001aac:	00271593          	slli	a1,a4,0x2
80001ab0:	97ae                	add	a5,a5,a1
80001ab2:	8e0d                	sub	a2,a2,a1
80001ab4:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80001ab6:	00c79d63          	bne	a5,a2,80001ad0 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80001aba:	8082                	ret
		if (n == 0) {
80001abc:	de7d                	beqz	a2,80001aba <memset+0x3e>
		*(d_byte++) = c_byte;
80001abe:	0785                	addi	a5,a5,1
80001ac0:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001ac4:	167d                	addi	a2,a2,-1
80001ac6:	bf75                	j	80001a82 <memset+0x6>
		*(d_word++) = c_word;
80001ac8:	0711                	addi	a4,a4,4
80001aca:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001ace:	bfc9                	j	80001aa0 <memset+0x24>
		*(d_byte++) = c_byte;
80001ad0:	0785                	addi	a5,a5,1
80001ad2:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001ad6:	b7c5                	j	80001ab6 <memset+0x3a>

80001ad8 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001ad8:	557d                	li	a0,-1
80001ada:	8082                	ret

80001adc <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001adc:	800057b7          	lui	a5,0x80005
80001ae0:	1ca7a623          	sw	a0,460(a5) # 800051cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051cd>
}
80001ae4:	8082                	ret

80001ae6 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001ae6:	1101                	addi	sp,sp,-32
80001ae8:	cc22                	sw	s0,24(sp)
	test->setup();
80001aea:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001aec:	80005437          	lui	s0,0x80005
{
80001af0:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001af2:	1d040413          	addi	s0,s0,464 # 800051d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051d1>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001af6:	800054b7          	lui	s1,0x80005
{
80001afa:	ce06                	sw	ra,28(sp)
80001afc:	c84a                	sw	s2,16(sp)
80001afe:	c64e                	sw	s3,12(sp)
	test_result = 1;
80001b00:	2b448493          	addi	s1,s1,692 # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
80001b04:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80001b06:	00042023          	sw	zero,0(s0)
{
80001b0a:	892a                	mv	s2,a0
	test_result = 1;
80001b0c:	0134a023          	sw	s3,0(s1)
	test->setup();
80001b10:	9782                	jalr	a5
	test->test();
80001b12:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001b16:	01342023          	sw	s3,0(s0)
	test->test();
80001b1a:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001b1c:	4789                	li	a5,2
80001b1e:	c01c                	sw	a5,0(s0)
	test->teardown();
80001b20:	00c92783          	lw	a5,12(s2)
80001b24:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001b26:	478d                	li	a5,3
80001b28:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001b2a:	4462                	lw	s0,24(sp)
	test_result = 0;
80001b2c:	0004a023          	sw	zero,0(s1)
}
80001b30:	40f2                	lw	ra,28(sp)
80001b32:	44d2                	lw	s1,20(sp)
80001b34:	4942                	lw	s2,16(sp)
80001b36:	49b2                	lw	s3,12(sp)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001b38:	80005537          	lui	a0,0x80005
80001b3c:	42450513          	addi	a0,a0,1060 # 80005424 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005425>
80001b40:	6105                	addi	sp,sp,32
80001b42:	2750106f          	j	800035b6 <z_impl_k_sem_give>

80001b46 <ztest_test_fail>:
80001b46:	80005537          	lui	a0,0x80005
{
80001b4a:	1141                	addi	sp,sp,-16
	test_result = -1;
80001b4c:	800057b7          	lui	a5,0x80005
80001b50:	577d                	li	a4,-1
80001b52:	42450513          	addi	a0,a0,1060 # 80005424 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005425>
{
80001b56:	c606                	sw	ra,12(sp)
	test_result = -1;
80001b58:	2ae7aa23          	sw	a4,692(a5) # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
80001b5c:	25b010ef          	jal	ra,800035b6 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001b60:	1ad010ef          	jal	ra,8000350c <z_impl_k_current_get>
}
80001b64:	40b2                	lw	ra,12(sp)
80001b66:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001b68:	0dc0206f          	j	80003c44 <z_impl_k_thread_abort>

80001b6c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001b6c:	711d                	addi	sp,sp,-96
80001b6e:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001b70:	800054b7          	lui	s1,0x80005
80001b74:	2b84a783          	lw	a5,696(s1) # 800052b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b9>
{
80001b78:	ce86                	sw	ra,92(sp)
80001b7a:	cca2                	sw	s0,88(sp)
80001b7c:	c8ca                	sw	s2,80(sp)
80001b7e:	c6ce                	sw	s3,76(sp)
80001b80:	c4d2                	sw	s4,72(sp)
80001b82:	c2d6                	sw	s5,68(sp)
80001b84:	c0da                	sw	s6,64(sp)
80001b86:	de5e                	sw	s7,60(sp)
80001b88:	dc62                	sw	s8,56(sp)
80001b8a:	da66                	sw	s9,52(sp)
80001b8c:	d86a                	sw	s10,48(sp)
80001b8e:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80001b90:	0607c963          	bltz	a5,80001c02 <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001b94:	80005437          	lui	s0,0x80005
80001b98:	4605                	li	a2,1
80001b9a:	89aa                	mv	s3,a0
80001b9c:	8c2e                	mv	s8,a1
80001b9e:	42440513          	addi	a0,s0,1060 # 80005424 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005425>
80001ba2:	4581                	li	a1,0
80001ba4:	173010ef          	jal	ra,80003516 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001ba8:	80005537          	lui	a0,0x80005
80001bac:	85ce                	mv	a1,s3
80001bae:	cfc50513          	addi	a0,a0,-772 # 80004cfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cfd>
80001bb2:	a09ff0ef          	jal	ra,800015ba <printk>
	PRINT_LINE;
80001bb6:	80005937          	lui	s2,0x80005
80001bba:	d1490513          	addi	a0,s2,-748 # 80004d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d15>
		Z_TC_END_RESULT(ret, test->name);
80001bbe:	80005ab7          	lui	s5,0x80005
	PRINT_LINE;
80001bc2:	9f9ff0ef          	jal	ra,800015ba <printk>
80001bc6:	2b848493          	addi	s1,s1,696
	int fail = 0;
80001bca:	4a01                	li	s4,0
80001bcc:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001bce:	80005cb7          	lui	s9,0x80005
80001bd2:	80005b37          	lui	s6,0x80005
80001bd6:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80001bda:	80005db7          	lui	s11,0x80005
80001bde:	80005bb7          	lui	s7,0x80005
		Z_TC_END_RESULT(ret, test->name);
80001be2:	cb4a8a93          	addi	s5,s5,-844 # 80004cb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cb5>
	while (suite->test) {
80001be6:	004c2783          	lw	a5,4(s8)
80001bea:	eb9d                	bnez	a5,80001c20 <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80001bec:	85ce                	mv	a1,s3
	if (fail) {
80001bee:	0c0a0363          	beqz	s4,80001cb4 <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
80001bf2:	80005537          	lui	a0,0x80005
80001bf6:	d8450513          	addi	a0,a0,-636 # 80004d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d85>
80001bfa:	9c1ff0ef          	jal	ra,800015ba <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80001bfe:	4785                	li	a5,1
80001c00:	c09c                	sw	a5,0(s1)
}
80001c02:	40f6                	lw	ra,92(sp)
80001c04:	4466                	lw	s0,88(sp)
80001c06:	44d6                	lw	s1,84(sp)
80001c08:	4946                	lw	s2,80(sp)
80001c0a:	49b6                	lw	s3,76(sp)
80001c0c:	4a26                	lw	s4,72(sp)
80001c0e:	4a96                	lw	s5,68(sp)
80001c10:	4b06                	lw	s6,64(sp)
80001c12:	5bf2                	lw	s7,60(sp)
80001c14:	5c62                	lw	s8,56(sp)
80001c16:	5cd2                	lw	s9,52(sp)
80001c18:	5d42                	lw	s10,48(sp)
80001c1a:	5db2                	lw	s11,44(sp)
80001c1c:	6125                	addi	sp,sp,96
80001c1e:	8082                	ret
	TC_START(test->name);
80001c20:	000c2583          	lw	a1,0(s8)
80001c24:	800057b7          	lui	a5,0x80005
80001c28:	d5c78513          	addi	a0,a5,-676 # 80004d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d5d>
80001c2c:	98fff0ef          	jal	ra,800015ba <printk>
80001c30:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80001c32:	010c2783          	lw	a5,16(s8)
80001c36:	8762                	mv	a4,s8
80001c38:	40000613          	li	a2,1024
80001c3c:	0087e793          	ori	a5,a5,8
80001c40:	58fd                	li	a7,-1
80001c42:	4801                	li	a6,0
80001c44:	ae6d0693          	addi	a3,s10,-1306 # 80001ae6 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001ae7>
80001c48:	c03e                	sw	a5,0(sp)
80001c4a:	7b0c8593          	addi	a1,s9,1968 # 800057b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b1>
80001c4e:	4781                	li	a5,0
80001c50:	434b0513          	addi	a0,s6,1076 # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
80001c54:	6d9010ef          	jal	ra,80003b2c <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001c58:	47f2                	lw	a5,28(sp)
80001c5a:	55fd                	li	a1,-1
80001c5c:	42478513          	addi	a0,a5,1060
80001c60:	201010ef          	jal	ra,80003660 <z_impl_k_sem_take>
	if (test_result == -1) {
80001c64:	2b4d8793          	addi	a5,s11,692 # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001c68:	434b0513          	addi	a0,s6,1076
80001c6c:	4380                	lw	s0,0(a5)
80001c6e:	7d7010ef          	jal	ra,80003c44 <z_impl_k_thread_abort>
	if (test_result == -2) {
80001c72:	800057b7          	lui	a5,0x80005
80001c76:	2b478793          	addi	a5,a5,692 # 800052b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b5>
80001c7a:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
80001c7c:	0405                	addi	s0,s0,1
	if (test_result == -2) {
80001c7e:	57f9                	li	a5,-2
	if (test_result == -1) {
80001c80:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80001c84:	000c2603          	lw	a2,0(s8)
80001c88:	02f71163          	bne	a4,a5,80001caa <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80001c8c:	800055b7          	lui	a1,0x80005
80001c90:	d7058593          	addi	a1,a1,-656 # 80004d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d71>
		Z_TC_END_RESULT(ret, test->name);
80001c94:	d78b8513          	addi	a0,s7,-648 # 80004d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d79>
80001c98:	923ff0ef          	jal	ra,800015ba <printk>
80001c9c:	d1490513          	addi	a0,s2,-748
80001ca0:	91bff0ef          	jal	ra,800015ba <printk>
		fail += run_test(suite);
80001ca4:	9a22                	add	s4,s4,s0
		suite++;
80001ca6:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80001ca8:	bf3d                	j	80001be6 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
80001caa:	00241793          	slli	a5,s0,0x2
80001cae:	97d6                	add	a5,a5,s5
80001cb0:	438c                	lw	a1,0(a5)
80001cb2:	b7cd                	j	80001c94 <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
80001cb4:	80005537          	lui	a0,0x80005
80001cb8:	d9c50513          	addi	a0,a0,-612 # 80004d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d9d>
80001cbc:	8ffff0ef          	jal	ra,800015ba <printk>
	test_status = (test_status || fail) ? 1 : 0;
80001cc0:	409c                	lw	a5,0(s1)
80001cc2:	00f037b3          	snez	a5,a5
80001cc6:	bf2d                	j	80001c00 <z_ztest_run_test_suite+0x94>

80001cc8 <end_report>:

void end_report(void)
{
	if (test_status) {
80001cc8:	800057b7          	lui	a5,0x80005
80001ccc:	2b87a783          	lw	a5,696(a5) # 800052b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052b9>
{
80001cd0:	1141                	addi	sp,sp,-16
80001cd2:	c422                	sw	s0,8(sp)
80001cd4:	80005537          	lui	a0,0x80005
80001cd8:	c606                	sw	ra,12(sp)
80001cda:	80005437          	lui	s0,0x80005
		TC_END_REPORT(TC_FAIL);
80001cde:	d1450513          	addi	a0,a0,-748 # 80004d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d15>
	if (test_status) {
80001ce2:	cf91                	beqz	a5,80001cfe <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
80001ce4:	8d7ff0ef          	jal	ra,800015ba <printk>
80001ce8:	800055b7          	lui	a1,0x80005
80001cec:	cc058593          	addi	a1,a1,-832 # 80004cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cc1>
	} else {
		TC_END_REPORT(TC_PASS);
80001cf0:	cc840513          	addi	a0,s0,-824 # 80004cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cc9>
	}
}
80001cf4:	4422                	lw	s0,8(sp)
80001cf6:	40b2                	lw	ra,12(sp)
80001cf8:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80001cfa:	8c1ff06f          	j	800015ba <printk>
80001cfe:	8bdff0ef          	jal	ra,800015ba <printk>
80001d02:	800055b7          	lui	a1,0x80005
80001d06:	ce058593          	addi	a1,a1,-800 # 80004ce0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ce1>
80001d0a:	b7dd                	j	80001cf0 <end_report+0x28>

80001d0c <main>:

	return test_status;
}
#else
void main(void)
{
80001d0c:	1141                	addi	sp,sp,-16
80001d0e:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80001d10:	e5bfe0ef          	jal	ra,80000b6a <test_main>
	end_report();
}
80001d14:	40b2                	lw	ra,12(sp)
80001d16:	0141                	addi	sp,sp,16
	end_report();
80001d18:	bf45                	j	80001cc8 <end_report>

80001d1a <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80001d1a:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80001d1c:	c602                	sw	zero,12(sp)
    i++;
80001d1e:	47b2                	lw	a5,12(sp)
80001d20:	0785                	addi	a5,a5,1
80001d22:	c63e                	sw	a5,12(sp)
    uart[0] = c;
80001d24:	f00107b7          	lui	a5,0xf0010
80001d28:	c38c                	sw	a1,0(a5)
}
80001d2a:	0141                	addi	sp,sp,16
80001d2c:	8082                	ret

80001d2e <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80001d2e:	557d                	li	a0,-1
80001d30:	8082                	ret

80001d32 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80001d32:	4501                	li	a0,0
80001d34:	8082                	ret

80001d36 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80001d36:	00251713          	slli	a4,a0,0x2
80001d3a:	800057b7          	lui	a5,0x80005
80001d3e:	0505                	addi	a0,a0,1
80001d40:	dcc78793          	addi	a5,a5,-564 # 80004dcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dcd>
80001d44:	050a                	slli	a0,a0,0x2
{
80001d46:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80001d48:	973e                	add	a4,a4,a5
80001d4a:	97aa                	add	a5,a5,a0
{
80001d4c:	c422                	sw	s0,8(sp)
80001d4e:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001d50:	4300                	lw	s0,0(a4)
80001d52:	4384                	lw	s1,0(a5)
{
80001d54:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001d56:	00946763          	bltu	s0,s1,80001d64 <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80001d5a:	40b2                	lw	ra,12(sp)
80001d5c:	4422                	lw	s0,8(sp)
80001d5e:	4492                	lw	s1,4(sp)
80001d60:	0141                	addi	sp,sp,16
80001d62:	8082                	ret
		retval = device_conf->init(info);
80001d64:	401c                	lw	a5,0(s0)
80001d66:	8522                	mv	a0,s0
80001d68:	43dc                	lw	a5,4(a5)
80001d6a:	9782                	jalr	a5
		if (retval != 0) {
80001d6c:	c119                	beqz	a0,80001d72 <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
80001d6e:	00042223          	sw	zero,4(s0)
								info++) {
80001d72:	0431                	addi	s0,s0,12
80001d74:	b7cd                	j	80001d56 <z_sys_device_do_config_level+0x20>

80001d76 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80001d76:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80001d78:	800057b7          	lui	a5,0x80005
{
80001d7c:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001d7e:	800054b7          	lui	s1,0x80005
{
80001d82:	c422                	sw	s0,8(sp)
80001d84:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001d86:	1e478413          	addi	s0,a5,484 # 800051e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e5>
{
80001d8a:	c04a                	sw	s2,0(sp)
80001d8c:	1e478793          	addi	a5,a5,484
80001d90:	22048493          	addi	s1,s1,544 # 80005220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005221>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001d94:	00941863          	bne	s0,s1,80001da4 <z_impl_device_get_binding+0x2e>
80001d98:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80001d9a:	843e                	mv	s0,a5
80001d9c:	00941c63          	bne	s0,s1,80001db4 <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80001da0:	4401                	li	s0,0
80001da2:	a015                	j	80001dc6 <z_impl_device_get_binding+0x50>
		if ((info->driver_api != NULL) &&
80001da4:	4058                	lw	a4,4(s0)
80001da6:	c709                	beqz	a4,80001db0 <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
80001da8:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80001daa:	4318                	lw	a4,0(a4)
80001dac:	00a70d63          	beq	a4,a0,80001dc6 <z_impl_device_get_binding+0x50>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001db0:	0431                	addi	s0,s0,12
80001db2:	b7cd                	j	80001d94 <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
80001db4:	405c                	lw	a5,4(s0)
80001db6:	e399                	bnez	a5,80001dbc <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001db8:	0431                	addi	s0,s0,12
80001dba:	b7cd                	j	80001d9c <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80001dbc:	401c                	lw	a5,0(s0)
80001dbe:	854a                	mv	a0,s2
80001dc0:	438c                	lw	a1,0(a5)
80001dc2:	390d                	jal	800019f4 <strcmp>
80001dc4:	f975                	bnez	a0,80001db8 <z_impl_device_get_binding+0x42>
}
80001dc6:	8522                	mv	a0,s0
80001dc8:	40b2                	lw	ra,12(sp)
80001dca:	4422                	lw	s0,8(sp)
80001dcc:	4492                	lw	s1,4(sp)
80001dce:	4902                	lw	s2,0(sp)
80001dd0:	0141                	addi	sp,sp,16
80001dd2:	8082                	ret

80001dd4 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80001dd4:	1141                	addi	sp,sp,-16
80001dd6:	c422                	sw	s0,8(sp)
80001dd8:	c226                	sw	s1,4(sp)
80001dda:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ddc:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001dde:	4489                	li	s1,2
80001de0:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80001de4:	242020ef          	jal	ra,80004026 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001de8:	00a4c363          	blt	s1,a0,80001dee <idle+0x1a>
80001dec:	4505                	li	a0,1
80001dee:	4585                	li	a1,1
80001df0:	2f0020ef          	jal	ra,800040e0 <z_set_timeout_expiry>
	k_cpu_idle();
80001df4:	80dff0ef          	jal	ra,80001600 <k_cpu_idle>
80001df8:	b7e5                	j	80001de0 <idle+0xc>

80001dfa <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80001dfa:	80005537          	lui	a0,0x80005
80001dfe:	800057b7          	lui	a5,0x80005
80001e02:	28850613          	addi	a2,a0,648 # 80005288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005289>
80001e06:	5b078793          	addi	a5,a5,1456 # 800055b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b1>
80001e0a:	40c78633          	sub	a2,a5,a2
80001e0e:	4581                	li	a1,0
80001e10:	28850513          	addi	a0,a0,648
80001e14:	b1a5                	j	80001a7c <memset>

80001e16 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80001e16:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001e18:	4509                	li	a0,2
{
80001e1a:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001e1c:	3f29                	jal	80001d36 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80001e1e:	80005537          	lui	a0,0x80005
80001e22:	de050513          	addi	a0,a0,-544 # 80004de0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004de1>
80001e26:	f94ff0ef          	jal	ra,800015ba <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80001e2a:	450d                	li	a0,3
80001e2c:	3729                	jal	80001d36 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80001e2e:	59f010ef          	jal	ra,80003bcc <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80001e32:	3de9                	jal	80001d0c <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80001e34:	800057b7          	lui	a5,0x80005
80001e38:	51478793          	addi	a5,a5,1300 # 80005514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005515>
80001e3c:	00c7c703          	lbu	a4,12(a5)
80001e40:	9b79                	andi	a4,a4,-2
80001e42:	00e78623          	sb	a4,12(a5)
}
80001e46:	40b2                	lw	ra,12(sp)
80001e48:	0141                	addi	sp,sp,16
80001e4a:	8082                	ret

80001e4c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80001e4c:	7135                	addi	sp,sp,-160
80001e4e:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80001e50:	800067b7          	lui	a5,0x80006
80001e54:	80005437          	lui	s0,0x80005
80001e58:	c74e                	sw	s3,140(sp)
80001e5a:	7b078793          	addi	a5,a5,1968 # 800067b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067b1>
80001e5e:	58440993          	addi	s3,s0,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80001e62:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80001e66:	081c                	addi	a5,sp,16
80001e68:	07000613          	li	a2,112
80001e6c:	4581                	li	a1,0
80001e6e:	853e                	mv	a0,a5
{
80001e70:	cf06                	sw	ra,156(sp)
80001e72:	cb26                	sw	s1,148(sp)
80001e74:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80001e76:	3119                	jal	80001a7c <memset>
80001e78:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80001e7a:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001e7e:	4501                	li	a0,0
	struct k_thread dummy_thread = {
80001e80:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001e84:	3d4d                	jal	80001d36 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80001e86:	4505                	li	a0,1
80001e88:	357d                	jal	80001d36 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80001e8a:	10100793          	li	a5,257
80001e8e:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80001e92:	662010ef          	jal	ra,800034f4 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80001e96:	800057b7          	lui	a5,0x80005
80001e9a:	e2478793          	addi	a5,a5,-476 # 80004e24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e25>
	_kernel.ready_q.cache = _main_thread;
80001e9e:	80005937          	lui	s2,0x80005
	z_setup_new_thread(_main_thread, _main_stack,
80001ea2:	c23e                	sw	a5,4(sp)
80001ea4:	800026b7          	lui	a3,0x80002
80001ea8:	4785                	li	a5,1
80001eaa:	800065b7          	lui	a1,0x80006
	_kernel.ready_q.cache = _main_thread;
80001eae:	51490493          	addi	s1,s2,1300 # 80005514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005515>
	z_setup_new_thread(_main_thread, _main_stack,
80001eb2:	c03e                	sw	a5,0(sp)
80001eb4:	4701                	li	a4,0
80001eb6:	4781                	li	a5,0
80001eb8:	4881                	li	a7,0
80001eba:	4801                	li	a6,0
80001ebc:	e1668693          	addi	a3,a3,-490 # 80001e16 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e17>
80001ec0:	20000613          	li	a2,512
80001ec4:	bb058593          	addi	a1,a1,-1104 # 80005bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bb1>
80001ec8:	51490513          	addi	a0,s2,1300
	_kernel.ready_q.cache = _main_thread;
80001ecc:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80001ed0:	269010ef          	jal	ra,80003938 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001ed4:	00d4c783          	lbu	a5,13(s1)
80001ed8:	58440413          	addi	s0,s0,1412
80001edc:	ffb7f713          	andi	a4,a5,-5
80001ee0:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80001ee4:	8bed                	andi	a5,a5,27
80001ee6:	e799                	bnez	a5,80001ef4 <z_cstart+0xa8>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80001ee8:	4c9c                	lw	a5,24(s1)
80001eea:	e789                	bnez	a5,80001ef4 <z_cstart+0xa8>
		z_add_thread_to_ready_q(thread);
80001eec:	51490513          	addi	a0,s2,1300
80001ef0:	5a9000ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80001ef4:	800057b7          	lui	a5,0x80005
80001ef8:	e2c78793          	addi	a5,a5,-468 # 80004e2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e2d>
80001efc:	c23e                	sw	a5,4(sp)
80001efe:	80005537          	lui	a0,0x80005
80001f02:	4785                	li	a5,1
80001f04:	800026b7          	lui	a3,0x80002
80001f08:	800065b7          	lui	a1,0x80006
80001f0c:	4a450493          	addi	s1,a0,1188 # 800054a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054a5>
80001f10:	c03e                	sw	a5,0(sp)
80001f12:	48bd                	li	a7,15
80001f14:	4801                	li	a6,0
80001f16:	4781                	li	a5,0
80001f18:	4701                	li	a4,0
80001f1a:	dd468693          	addi	a3,a3,-556 # 80001dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001dd5>
80001f1e:	20000613          	li	a2,512
80001f22:	db058593          	addi	a1,a1,-592 # 80005db0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005db1>
80001f26:	4a450513          	addi	a0,a0,1188
80001f2a:	20f010ef          	jal	ra,80003938 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001f2e:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80001f32:	c444                	sw	s1,12(s0)
80001f34:	4521                	li	a0,8
80001f36:	9bed                	andi	a5,a5,-5
80001f38:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80001f3c:	800057b7          	lui	a5,0x80005
80001f40:	59c78793          	addi	a5,a5,1436 # 8000559c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000559d>
80001f44:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80001f46:	cc5c                	sw	a5,28(s0)
80001f48:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80001f4c:	8921                	andi	a0,a0,8
80001f4e:	a72fe0ef          	jal	ra,800001c0 <__swap>

80001f52 <mbox_message_match>:
static int mbox_message_match(struct k_mbox_msg *tx_msg,
			       struct k_mbox_msg *rx_msg)
{
	u32_t temp_info;

	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
80001f52:	5118                	lw	a4,32(a0)
{
80001f54:	87aa                	mv	a5,a0
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
80001f56:	c709                	beqz	a4,80001f60 <mbox_message_match+0xe>
80001f58:	5194                	lw	a3,32(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;

		return 0;
	}

	return -1;
80001f5a:	557d                	li	a0,-1
	if (((tx_msg->tx_target_thread == (k_tid_t)K_ANY) ||
80001f5c:	04d71063          	bne	a4,a3,80001f9c <mbox_message_match+0x4a>
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
80001f60:	4dd4                	lw	a3,28(a1)
80001f62:	4fd8                	lw	a4,28(a5)
	     (tx_msg->tx_target_thread == rx_msg->tx_target_thread)) &&
80001f64:	c681                	beqz	a3,80001f6c <mbox_message_match+0x1a>
	return -1;
80001f66:	557d                	li	a0,-1
	    ((rx_msg->rx_source_thread == (k_tid_t)K_ANY) ||
80001f68:	02e69a63          	bne	a3,a4,80001f9c <mbox_message_match+0x4a>
		rx_msg->rx_source_thread = tx_msg->rx_source_thread;
80001f6c:	cdd8                	sw	a4,28(a1)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
80001f6e:	5198                	lw	a4,32(a1)
		rx_msg->info = tx_msg->info;
80001f70:	4794                	lw	a3,8(a5)
		tx_msg->tx_target_thread = rx_msg->tx_target_thread;
80001f72:	d398                	sw	a4,32(a5)
		temp_info = rx_msg->info;
80001f74:	4598                	lw	a4,8(a1)
		rx_msg->info = tx_msg->info;
80001f76:	c594                	sw	a3,8(a1)
		if (rx_msg->size > tx_msg->size) {
80001f78:	41d4                	lw	a3,4(a1)
		tx_msg->info = temp_info;
80001f7a:	c798                	sw	a4,8(a5)
		if (rx_msg->size > tx_msg->size) {
80001f7c:	43d8                	lw	a4,4(a5)
80001f7e:	00d77363          	bgeu	a4,a3,80001f84 <mbox_message_match+0x32>
			rx_msg->size = tx_msg->size;
80001f82:	c1d8                	sw	a4,4(a1)
		rx_msg->tx_block = tx_msg->tx_block;
80001f84:	4bd8                	lw	a4,20(a5)
		rx_msg->tx_data = tx_msg->tx_data;
80001f86:	47d4                	lw	a3,12(a5)
		rx_msg->tx_block = tx_msg->tx_block;
80001f88:	c9d8                	sw	a4,20(a1)
80001f8a:	4f90                	lw	a2,24(a5)
		rx_msg->tx_data = tx_msg->tx_data;
80001f8c:	c5d4                	sw	a3,12(a1)
		rx_msg->tx_block = tx_msg->tx_block;
80001f8e:	cd90                	sw	a2,24(a1)
		if (rx_msg->tx_data != NULL) {
80001f90:	c699                	beqz	a3,80001f9e <mbox_message_match+0x4c>
			rx_msg->tx_block.data = NULL;
80001f92:	0005aa23          	sw	zero,20(a1)
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
80001f96:	53dc                	lw	a5,36(a5)
		return 0;
80001f98:	4501                	li	a0,0
		rx_msg->_syncing_thread = tx_msg->_syncing_thread;
80001f9a:	d1dc                	sw	a5,36(a1)
}
80001f9c:	8082                	ret
		} else if (rx_msg->tx_block.data != NULL) {
80001f9e:	df65                	beqz	a4,80001f96 <mbox_message_match+0x44>
			rx_msg->tx_data = rx_msg->tx_block.data;
80001fa0:	c5d8                	sw	a4,12(a1)
80001fa2:	bfd5                	j	80001f96 <mbox_message_match+0x44>

80001fa4 <init_mbox_module>:
{
80001fa4:	1141                	addi	sp,sp,-16
80001fa6:	c422                	sw	s0,8(sp)
80001fa8:	80006437          	lui	s0,0x80006
80001fac:	7d840413          	addi	s0,s0,2008 # 800067d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067d9>
80001fb0:	c226                	sw	s1,4(sp)
80001fb2:	c04a                	sw	s2,0(sp)
80001fb4:	c606                	sw	ra,12(sp)
80001fb6:	34840493          	addi	s1,s0,840
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_STACK_PUSH, k_stack_push, struct k_stack *, stack, u32_t, data)
80001fba:	80005937          	lui	s2,0x80005
		z_init_thread_base(&async_msg[i].thread, 0, _THREAD_DUMMY, 0);
80001fbe:	8522                	mv	a0,s0
80001fc0:	4681                	li	a3,0
80001fc2:	4605                	li	a2,1
80001fc4:	4581                	li	a1,0
80001fc6:	1e1010ef          	jal	ra,800039a6 <z_init_thread_base>
80001fca:	85a2                	mv	a1,s0
80001fcc:	26c90513          	addi	a0,s2,620 # 8000526c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000526d>
80001fd0:	05440413          	addi	s0,s0,84
80001fd4:	7fe010ef          	jal	ra,800037d2 <z_impl_k_stack_push>
	for (i = 0; i < CONFIG_NUM_MBOX_ASYNC_MSGS; i++) {
80001fd8:	fe9413e3          	bne	s0,s1,80001fbe <init_mbox_module+0x1a>
}
80001fdc:	40b2                	lw	ra,12(sp)
80001fde:	4422                	lw	s0,8(sp)
80001fe0:	4492                	lw	s1,4(sp)
80001fe2:	4902                	lw	s2,0(sp)
80001fe4:	4501                	li	a0,0
80001fe6:	0141                	addi	sp,sp,16
80001fe8:	8082                	ret

80001fea <mbox_message_put>:
	struct k_thread *receiving_thread;
	struct k_mbox_msg *rx_msg;
	k_spinlock_key_t key;

	/* save sender id so it can be used during message matching */
	tx_msg->rx_source_thread = _current;
80001fea:	800057b7          	lui	a5,0x80005
{
80001fee:	7179                	addi	sp,sp,-48
	tx_msg->rx_source_thread = _current;
80001ff0:	58c7a783          	lw	a5,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
{
80001ff4:	ca56                	sw	s5,20(sp)

	/* finish readying sending thread (actual or dummy) for send */
	sending_thread = tx_msg->_syncing_thread;
80001ff6:	0245aa83          	lw	s5,36(a1)
{
80001ffa:	d226                	sw	s1,36(sp)
80001ffc:	d04a                	sw	s2,32(sp)
80001ffe:	ce4e                	sw	s3,28(sp)
80002000:	c85a                	sw	s6,16(sp)
80002002:	c65e                	sw	s7,12(sp)
80002004:	d606                	sw	ra,44(sp)
80002006:	d422                	sw	s0,40(sp)
80002008:	cc52                	sw	s4,24(sp)
	tx_msg->rx_source_thread = _current;
8000200a:	cddc                	sw	a5,28(a1)
{
8000200c:	89aa                	mv	s3,a0
8000200e:	8b2e                	mv	s6,a1
80002010:	8bb2                	mv	s7,a2
	sending_thread->base.swap_data = tx_msg;
80002012:	00baaa23          	sw	a1,20(s5)

	/* search mailbox's rx queue for a compatible receiver */
	key = k_spin_lock(&mbox->lock);
80002016:	01050913          	addi	s2,a0,16
8000201a:	44a1                	li	s1,8
8000201c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002020:	854a                	mv	a0,s2
	key = (mstatus & SOC_MSTATUS_IEN);
80002022:	88a1                	andi	s1,s1,8
80002024:	19d010ef          	jal	ra,800039c0 <z_spin_lock_valid>
80002028:	ed0d                	bnez	a0,80002062 <mbox_message_put+0x78>
8000202a:	80005437          	lui	s0,0x80005
8000202e:	800055b7          	lui	a1,0x80005
80002032:	80005537          	lui	a0,0x80005
80002036:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
8000203a:	04e00693          	li	a3,78
8000203e:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002042:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002046:	d74ff0ef          	jal	ra,800015ba <printk>
8000204a:	80005537          	lui	a0,0x80005
8000204e:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002052:	d68ff0ef          	jal	ra,800015ba <printk>
80002056:	04e00593          	li	a1,78
8000205a:	c4040513          	addi	a0,s0,-960
8000205e:	d7aff0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002062:	854a                	mv	a0,s2
80002064:	199010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	return list->head == list;
80002068:	0089a403          	lw	s0,8(s3)

	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
8000206c:	00898793          	addi	a5,s3,8
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002070:	06f41e63          	bne	s0,a5,800020ec <mbox_message_put+0x102>

		}
	}

	/* didn't find a matching receiver: don't wait for one */
	if (timeout == K_NO_WAIT) {
80002074:	0c0b9363          	bnez	s7,8000213a <mbox_message_put+0x150>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002078:	854a                	mv	a0,s2
8000207a:	161010ef          	jal	ra,800039da <z_spin_unlock_valid>
8000207e:	ed0d                	bnez	a0,800020b8 <mbox_message_put+0xce>
80002080:	80005437          	lui	s0,0x80005
80002084:	800055b7          	lui	a1,0x80005
80002088:	80005537          	lui	a0,0x80005
8000208c:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002090:	06100693          	li	a3,97
80002094:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002098:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000209c:	d1eff0ef          	jal	ra,800015ba <printk>
800020a0:	80005537          	lui	a0,0x80005
800020a4:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800020a8:	d12ff0ef          	jal	ra,800015ba <printk>
800020ac:	06100593          	li	a1,97
800020b0:	c4040513          	addi	a0,s0,-960
800020b4:	d24ff0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800020b8:	3004a4f3          	csrrs	s1,mstatus,s1
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
800020bc:	fb000a13          	li	s4,-80
800020c0:	a08d                	j	80002122 <mbox_message_put+0x138>
			return z_pend_curr(&mbox->lock, key, NULL, K_FOREVER);
800020c2:	56fd                	li	a3,-1
800020c4:	4601                	li	a2,0
	}
#endif

	/* synchronous send: sender waits on tx queue for receiver or timeout */
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
}
800020c6:	5422                	lw	s0,40(sp)
800020c8:	50b2                	lw	ra,44(sp)
800020ca:	49f2                	lw	s3,28(sp)
800020cc:	4a62                	lw	s4,24(sp)
800020ce:	4ad2                	lw	s5,20(sp)
800020d0:	4b42                	lw	s6,16(sp)
800020d2:	4bb2                	lw	s7,12(sp)
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
800020d4:	85a6                	mv	a1,s1
800020d6:	854a                	mv	a0,s2
}
800020d8:	5492                	lw	s1,36(sp)
800020da:	5902                	lw	s2,32(sp)
800020dc:	6145                	addi	sp,sp,48
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
800020de:	1f60106f          	j	800032d4 <z_pend_curr>
	return (node == list->tail) ? NULL : node->next;
800020e2:	00c9a783          	lw	a5,12(s3)
800020e6:	f8f407e3          	beq	s0,a5,80002074 <mbox_message_put+0x8a>
800020ea:	4000                	lw	s0,0(s0)
	_WAIT_Q_FOR_EACH(&mbox->rx_msg_queue, receiving_thread) {
800020ec:	d441                	beqz	s0,80002074 <mbox_message_put+0x8a>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
800020ee:	484c                	lw	a1,20(s0)
800020f0:	855a                	mv	a0,s6
800020f2:	3585                	jal	80001f52 <mbox_message_match>
800020f4:	8a2a                	mv	s4,a0
800020f6:	f575                	bnez	a0,800020e2 <mbox_message_put+0xf8>
			z_unpend_thread(receiving_thread);
800020f8:	8522                	mv	a0,s0
800020fa:	0d1000ef          	jal	ra,800029ca <z_unpend_thread>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800020fe:	00d44783          	lbu	a5,13(s0)
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80002102:	06042623          	sw	zero,108(s0)
80002106:	8bfd                	andi	a5,a5,31
80002108:	e791                	bnez	a5,80002114 <mbox_message_put+0x12a>
	if (z_is_thread_ready(thread)) {
8000210a:	4c1c                	lw	a5,24(s0)
8000210c:	e781                	bnez	a5,80002114 <mbox_message_put+0x12a>
		z_add_thread_to_ready_q(thread);
8000210e:	8522                	mv	a0,s0
80002110:	389000ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
			if ((sending_thread->base.thread_state & _THREAD_DUMMY)
80002114:	00dac783          	lbu	a5,13(s5)
80002118:	8b85                	andi	a5,a5,1
8000211a:	d7c5                	beqz	a5,800020c2 <mbox_message_put+0xd8>
				z_reschedule(&mbox->lock, key);
8000211c:	85a6                	mv	a1,s1
8000211e:	854a                	mv	a0,s2
80002120:	253d                	jal	8000274e <z_reschedule>
}
80002122:	50b2                	lw	ra,44(sp)
80002124:	5422                	lw	s0,40(sp)
80002126:	8552                	mv	a0,s4
80002128:	5492                	lw	s1,36(sp)
8000212a:	5902                	lw	s2,32(sp)
8000212c:	49f2                	lw	s3,28(sp)
8000212e:	4a62                	lw	s4,24(sp)
80002130:	4ad2                	lw	s5,20(sp)
80002132:	4b42                	lw	s6,16(sp)
80002134:	4bb2                	lw	s7,12(sp)
80002136:	6145                	addi	sp,sp,48
80002138:	8082                	ret
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
8000213a:	00dac783          	lbu	a5,13(s5)
8000213e:	8b85                	andi	a5,a5,1
80002140:	cbb1                	beqz	a5,80002194 <mbox_message_put+0x1aa>
		z_pend_thread(sending_thread, &mbox->tx_msg_queue, K_FOREVER);
80002142:	8556                	mv	a0,s5
80002144:	567d                	li	a2,-1
80002146:	85ce                	mv	a1,s3
80002148:	126010ef          	jal	ra,8000326e <z_pend_thread>
8000214c:	854a                	mv	a0,s2
8000214e:	08d010ef          	jal	ra,800039da <z_spin_unlock_valid>
80002152:	ed0d                	bnez	a0,8000218c <mbox_message_put+0x1a2>
80002154:	80005437          	lui	s0,0x80005
80002158:	800055b7          	lui	a1,0x80005
8000215c:	80005537          	lui	a0,0x80005
80002160:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002164:	06100693          	li	a3,97
80002168:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000216c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002170:	c4aff0ef          	jal	ra,800015ba <printk>
80002174:	80005537          	lui	a0,0x80005
80002178:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000217c:	c3eff0ef          	jal	ra,800015ba <printk>
80002180:	06100593          	li	a1,97
80002184:	c4040513          	addi	a0,s0,-960
80002188:	c50ff0ef          	jal	ra,800015d8 <assert_post_action>
8000218c:	3004a4f3          	csrrs	s1,mstatus,s1
		return 0;
80002190:	4a01                	li	s4,0
80002192:	bf41                	j	80002122 <mbox_message_put+0x138>
	return z_pend_curr(&mbox->lock, key, &mbox->tx_msg_queue, timeout);
80002194:	86de                	mv	a3,s7
80002196:	864e                	mv	a2,s3
80002198:	b73d                	j	800020c6 <mbox_message_put+0xdc>

8000219a <mbox_message_dispose>:
	if (rx_msg->_syncing_thread == NULL) {
8000219a:	515c                	lw	a5,36(a0)
8000219c:	cfb5                	beqz	a5,80002218 <mbox_message_dispose+0x7e>
	if (rx_msg->tx_block.data != NULL) {
8000219e:	495c                	lw	a5,20(a0)
{
800021a0:	1141                	addi	sp,sp,-16
800021a2:	c422                	sw	s0,8(sp)
800021a4:	c606                	sw	ra,12(sp)
800021a6:	842a                	mv	s0,a0
	if (rx_msg->tx_block.data != NULL) {
800021a8:	c789                	beqz	a5,800021b2 <mbox_message_dispose+0x18>
		k_mem_pool_free(&rx_msg->tx_block);
800021aa:	0551                	addi	a0,a0,20
800021ac:	26b5                	jal	80002518 <k_mem_pool_free>
		rx_msg->tx_block.data = NULL;
800021ae:	00042a23          	sw	zero,20(s0)
	sending_thread = rx_msg->_syncing_thread;
800021b2:	504c                	lw	a1,36(s0)
	tx_msg->size = rx_msg->size;
800021b4:	405c                	lw	a5,4(s0)
	rx_msg->_syncing_thread = NULL;
800021b6:	02042223          	sw	zero,36(s0)
	tx_msg = (struct k_mbox_msg *)sending_thread->base.swap_data;
800021ba:	49d8                	lw	a4,20(a1)
	tx_msg->size = rx_msg->size;
800021bc:	c35c                	sw	a5,4(a4)
	if ((sending_thread->base.thread_state & _THREAD_DUMMY) != 0U) {
800021be:	00d5c783          	lbu	a5,13(a1)
800021c2:	8b85                	andi	a5,a5,1
800021c4:	cf99                	beqz	a5,800021e2 <mbox_message_dispose+0x48>
		struct k_sem *async_sem = tx_msg->_async_sem;
800021c6:	5700                	lw	s0,40(a4)
800021c8:	80005537          	lui	a0,0x80005
800021cc:	26c50513          	addi	a0,a0,620 # 8000526c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000526d>
800021d0:	602010ef          	jal	ra,800037d2 <z_impl_k_stack_push>
		if (async_sem != NULL) {
800021d4:	cc15                	beqz	s0,80002210 <mbox_message_dispose+0x76>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800021d6:	8522                	mv	a0,s0
}
800021d8:	4422                	lw	s0,8(sp)
800021da:	40b2                	lw	ra,12(sp)
800021dc:	0141                	addi	sp,sp,16
800021de:	3d80106f          	j	800035b6 <z_impl_k_sem_give>
800021e2:	00d5c783          	lbu	a5,13(a1)
800021e6:	0605a623          	sw	zero,108(a1)
	thread->base.thread_state &= ~_THREAD_PENDING;
800021ea:	ffd7f713          	andi	a4,a5,-3
800021ee:	00e586a3          	sb	a4,13(a1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800021f2:	8bf5                	andi	a5,a5,29
800021f4:	e791                	bnez	a5,80002200 <mbox_message_dispose+0x66>
	if (z_is_thread_ready(thread)) {
800021f6:	4d9c                	lw	a5,24(a1)
800021f8:	e781                	bnez	a5,80002200 <mbox_message_dispose+0x66>
		z_add_thread_to_ready_q(thread);
800021fa:	852e                	mv	a0,a1
800021fc:	29d000ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002200:	4521                	li	a0,8
80002202:	30053573          	csrrc	a0,mstatus,a0
80002206:	4422                	lw	s0,8(sp)
80002208:	40b2                	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
8000220a:	8921                	andi	a0,a0,8
8000220c:	0141                	addi	sp,sp,16
8000220e:	a3fd                	j	800027fc <z_reschedule_irqlock>
80002210:	40b2                	lw	ra,12(sp)
80002212:	4422                	lw	s0,8(sp)
80002214:	0141                	addi	sp,sp,16
80002216:	8082                	ret
80002218:	8082                	ret

8000221a <k_mbox_init>:
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
8000221a:	00850793          	addi	a5,a0,8
	list->head = (sys_dnode_t *)list;
8000221e:	c108                	sw	a0,0(a0)
	list->tail = (sys_dnode_t *)list;
80002220:	c148                	sw	a0,4(a0)
	list->head = (sys_dnode_t *)list;
80002222:	c51c                	sw	a5,8(a0)
	list->tail = (sys_dnode_t *)list;
80002224:	c55c                	sw	a5,12(a0)
	mbox_ptr->lock = (struct k_spinlock) {};
80002226:	00052823          	sw	zero,16(a0)
}
8000222a:	8082                	ret

8000222c <k_mbox_put>:

int k_mbox_put(struct k_mbox *mbox, struct k_mbox_msg *tx_msg, s32_t timeout)
{
	/* configure things for a synchronous send, then send the message */
	tx_msg->_syncing_thread = _current;
8000222c:	800057b7          	lui	a5,0x80005
80002230:	58c7a783          	lw	a5,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
80002234:	d1dc                	sw	a5,36(a1)

	return mbox_message_put(mbox, tx_msg, timeout);
80002236:	bb55                	j	80001fea <mbox_message_put>

80002238 <k_mbox_data_get>:
	(void)mbox_message_put(mbox, &async->tx_msg, K_FOREVER);
}
#endif

void k_mbox_data_get(struct k_mbox_msg *rx_msg, void *buffer)
{
80002238:	1141                	addi	sp,sp,-16
8000223a:	c422                	sw	s0,8(sp)
8000223c:	c606                	sw	ra,12(sp)
8000223e:	842a                	mv	s0,a0
	/* handle case where data is to be discarded */
	if (buffer == NULL) {
80002240:	e599                	bnez	a1,8000224e <k_mbox_data_get+0x16>
		rx_msg->size = 0;
80002242:	00052223          	sw	zero,4(a0)
	/* copy message data to buffer, then dispose of message */
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
	}
	mbox_message_dispose(rx_msg);
}
80002246:	4422                	lw	s0,8(sp)
80002248:	40b2                	lw	ra,12(sp)
8000224a:	0141                	addi	sp,sp,16
	mbox_message_dispose(rx_msg);
8000224c:	b7b9                	j	8000219a <mbox_message_dispose>
8000224e:	852e                	mv	a0,a1
	if ((rx_msg->tx_data != NULL) && (rx_msg->size > 0)) {
80002250:	444c                	lw	a1,12(s0)
80002252:	c589                	beqz	a1,8000225c <k_mbox_data_get+0x24>
80002254:	4050                	lw	a2,4(s0)
80002256:	c219                	beqz	a2,8000225c <k_mbox_data_get+0x24>
		(void)memcpy(buffer, rx_msg->tx_data, rx_msg->size);
80002258:	fb6ff0ef          	jal	ra,80001a0e <memcpy>
	mbox_message_dispose(rx_msg);
8000225c:	8522                	mv	a0,s0
8000225e:	b7e5                	j	80002246 <k_mbox_data_get+0xe>

80002260 <k_mbox_get>:
	return 0;
}

int k_mbox_get(struct k_mbox *mbox, struct k_mbox_msg *rx_msg, void *buffer,
	       s32_t timeout)
{
80002260:	7179                	addi	sp,sp,-48
80002262:	c85a                	sw	s6,16(sp)
	struct k_mbox_msg *tx_msg;
	k_spinlock_key_t key;
	int result;

	/* save receiver id so it can be used during message matching */
	rx_msg->tx_target_thread = _current;
80002264:	80005b37          	lui	s6,0x80005
80002268:	584b0793          	addi	a5,s6,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
8000226c:	479c                	lw	a5,8(a5)
{
8000226e:	d422                	sw	s0,40(sp)
80002270:	d04a                	sw	s2,32(sp)
80002272:	ce4e                	sw	s3,28(sp)
80002274:	cc52                	sw	s4,24(sp)
80002276:	ca56                	sw	s5,20(sp)
80002278:	c65e                	sw	s7,12(sp)
8000227a:	d606                	sw	ra,44(sp)
8000227c:	d226                	sw	s1,36(sp)
8000227e:	8a2a                	mv	s4,a0
80002280:	892e                	mv	s2,a1
80002282:	8ab2                	mv	s5,a2
80002284:	8bb6                	mv	s7,a3
	rx_msg->tx_target_thread = _current;
80002286:	d19c                	sw	a5,32(a1)

	/* search mailbox's tx queue for a compatible sender */
	key = k_spin_lock(&mbox->lock);
80002288:	01050993          	addi	s3,a0,16
8000228c:	4421                	li	s0,8
8000228e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002292:	854e                	mv	a0,s3
80002294:	72c010ef          	jal	ra,800039c0 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80002298:	8821                	andi	s0,s0,8
8000229a:	584b0b13          	addi	s6,s6,1412
8000229e:	ed0d                	bnez	a0,800022d8 <k_mbox_get+0x78>
800022a0:	800054b7          	lui	s1,0x80005
800022a4:	800055b7          	lui	a1,0x80005
800022a8:	80005537          	lui	a0,0x80005
800022ac:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800022b0:	04e00693          	li	a3,78
800022b4:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800022b8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800022bc:	afeff0ef          	jal	ra,800015ba <printk>
800022c0:	80005537          	lui	a0,0x80005
800022c4:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
800022c8:	af2ff0ef          	jal	ra,800015ba <printk>
800022cc:	04e00593          	li	a1,78
800022d0:	c4048513          	addi	a0,s1,-960
800022d4:	b04ff0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
800022d8:	854e                	mv	a0,s3
800022da:	722010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	return list->head == list;
800022de:	000a2483          	lw	s1,0(s4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800022e2:	069a1463          	bne	s4,s1,8000234a <k_mbox_get+0xea>
		}
	}

	/* didn't find a matching sender */

	if (timeout == K_NO_WAIT) {
800022e6:	0c0b9c63          	bnez	s7,800023be <k_mbox_get+0x15e>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800022ea:	854e                	mv	a0,s3
800022ec:	6ee010ef          	jal	ra,800039da <z_spin_unlock_valid>
800022f0:	ed0d                	bnez	a0,8000232a <k_mbox_get+0xca>
800022f2:	800054b7          	lui	s1,0x80005
800022f6:	800055b7          	lui	a1,0x80005
800022fa:	80005537          	lui	a0,0x80005
800022fe:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002302:	06100693          	li	a3,97
80002306:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000230a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000230e:	aacff0ef          	jal	ra,800015ba <printk>
80002312:	80005537          	lui	a0,0x80005
80002316:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000231a:	aa0ff0ef          	jal	ra,800015ba <printk>
8000231e:	06100593          	li	a1,97
80002322:	c4048513          	addi	a0,s1,-960
80002326:	ab2ff0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000232a:	30042473          	csrrs	s0,mstatus,s0
		/* don't wait for a matching sender to appear */
		k_spin_unlock(&mbox->lock, key);
		return -ENOMSG;
8000232e:	fb000513          	li	a0,-80
80002332:	a89d                	j	800023a8 <k_mbox_get+0x148>
	} else if (rx_msg->size == 0) {
80002334:	00492783          	lw	a5,4(s2)
80002338:	e7bd                	bnez	a5,800023a6 <k_mbox_get+0x146>
		mbox_message_dispose(rx_msg);
8000233a:	854a                	mv	a0,s2
8000233c:	3db9                	jal	8000219a <mbox_message_dispose>
8000233e:	a0a5                	j	800023a6 <k_mbox_get+0x146>
	return (node == list->tail) ? NULL : node->next;
80002340:	004a2783          	lw	a5,4(s4)
80002344:	faf481e3          	beq	s1,a5,800022e6 <k_mbox_get+0x86>
80002348:	4084                	lw	s1,0(s1)
	_WAIT_Q_FOR_EACH(&mbox->tx_msg_queue, sending_thread) {
8000234a:	dcd1                	beqz	s1,800022e6 <k_mbox_get+0x86>
		if (mbox_message_match(tx_msg, rx_msg) == 0) {
8000234c:	48c8                	lw	a0,20(s1)
8000234e:	85ca                	mv	a1,s2
80002350:	3109                	jal	80001f52 <mbox_message_match>
80002352:	f57d                	bnez	a0,80002340 <k_mbox_get+0xe0>
			z_unpend_thread(sending_thread);
80002354:	8526                	mv	a0,s1
80002356:	2d95                	jal	800029ca <z_unpend_thread>
80002358:	854e                	mv	a0,s3
8000235a:	680010ef          	jal	ra,800039da <z_spin_unlock_valid>
8000235e:	ed0d                	bnez	a0,80002398 <k_mbox_get+0x138>
80002360:	800054b7          	lui	s1,0x80005
80002364:	800055b7          	lui	a1,0x80005
80002368:	80005537          	lui	a0,0x80005
8000236c:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002370:	06100693          	li	a3,97
80002374:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002378:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000237c:	a3eff0ef          	jal	ra,800015ba <printk>
80002380:	80005537          	lui	a0,0x80005
80002384:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002388:	a32ff0ef          	jal	ra,800015ba <printk>
8000238c:	06100593          	li	a1,97
80002390:	c4048513          	addi	a0,s1,-960
80002394:	a44ff0ef          	jal	ra,800015d8 <assert_post_action>
80002398:	30042473          	csrrs	s0,mstatus,s0
	if (buffer != NULL) {
8000239c:	f80a8ce3          	beqz	s5,80002334 <k_mbox_get+0xd4>
		k_mbox_data_get(rx_msg, buffer);
800023a0:	85d6                	mv	a1,s5
800023a2:	854a                	mv	a0,s2
800023a4:	3d51                	jal	80002238 <k_mbox_data_get>
			return mbox_message_data_check(rx_msg, buffer);
800023a6:	4501                	li	a0,0
	if (result == 0) {
		result = mbox_message_data_check(rx_msg, buffer);
	}

	return result;
}
800023a8:	50b2                	lw	ra,44(sp)
800023aa:	5422                	lw	s0,40(sp)
800023ac:	5492                	lw	s1,36(sp)
800023ae:	5902                	lw	s2,32(sp)
800023b0:	49f2                	lw	s3,28(sp)
800023b2:	4a62                	lw	s4,24(sp)
800023b4:	4ad2                	lw	s5,20(sp)
800023b6:	4b42                	lw	s6,16(sp)
800023b8:	4bb2                	lw	s7,12(sp)
800023ba:	6145                	addi	sp,sp,48
800023bc:	8082                	ret
	_current->base.swap_data = rx_msg;
800023be:	008b2783          	lw	a5,8(s6)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
800023c2:	86de                	mv	a3,s7
800023c4:	008a0613          	addi	a2,s4,8
	_current->base.swap_data = rx_msg;
800023c8:	0127aa23          	sw	s2,20(a5)
	result = z_pend_curr(&mbox->lock, key, &mbox->rx_msg_queue, timeout);
800023cc:	85a2                	mv	a1,s0
800023ce:	854e                	mv	a0,s3
800023d0:	705000ef          	jal	ra,800032d4 <z_pend_curr>
	if (result == 0) {
800023d4:	f971                	bnez	a0,800023a8 <k_mbox_get+0x148>
800023d6:	b7d9                	j	8000239c <k_mbox_get+0x13c>

800023d8 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800023d8:	1141                	addi	sp,sp,-16
800023da:	c422                	sw	s0,8(sp)
800023dc:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800023de:	80005437          	lui	s0,0x80005
800023e2:	800054b7          	lui	s1,0x80005
{
800023e6:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800023e8:	22040413          	addi	s0,s0,544 # 80005220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005221>
800023ec:	25848493          	addi	s1,s1,600 # 80005258 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005259>
800023f0:	00946863          	bltu	s0,s1,80002400 <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
800023f4:	40b2                	lw	ra,12(sp)
800023f6:	4422                	lw	s0,8(sp)
800023f8:	4492                	lw	s1,4(sp)
800023fa:	4501                	li	a0,0
800023fc:	0141                	addi	sp,sp,16
800023fe:	8082                	ret
80002400:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80002404:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80002406:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80002408:	cc1c                	sw	a5,24(s0)
8000240a:	a7ffe0ef          	jal	ra,80000e88 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000240e:	0471                	addi	s0,s0,28
80002410:	b7c5                	j	800023f0 <init_static_pools+0x18>

80002412 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002412:	00054783          	lbu	a5,0(a0)
{
80002416:	1101                	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002418:	4110                	lw	a2,0(a0)
{
8000241a:	cc22                	sw	s0,24(sp)
8000241c:	00379413          	slli	s0,a5,0x3
80002420:	c84a                	sw	s2,16(sp)
80002422:	8c1d                	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002424:	80005937          	lui	s2,0x80005
80002428:	040a                	slli	s0,s0,0x2
8000242a:	00865593          	srli	a1,a2,0x8
8000242e:	22090513          	addi	a0,s2,544 # 80005220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005221>
80002432:	8231                	srli	a2,a2,0xc
80002434:	89bd                	andi	a1,a1,15
80002436:	9522                	add	a0,a0,s0
{
80002438:	ce06                	sw	ra,28(sp)
8000243a:	ca26                	sw	s1,20(sp)
8000243c:	c64e                	sw	s3,12(sp)
8000243e:	c452                	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002440:	b0dfe0ef          	jal	ra,80000f4c <z_sys_mem_pool_block_free>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002444:	45a1                	li	a1,8
80002446:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000244a:	800054b7          	lui	s1,0x80005
8000244e:	2bc48513          	addi	a0,s1,700 # 800052bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052bd>
	key = (mstatus & SOC_MSTATUS_IEN);
80002452:	0085f993          	andi	s3,a1,8
80002456:	56a010ef          	jal	ra,800039c0 <z_spin_lock_valid>
8000245a:	22090913          	addi	s2,s2,544
8000245e:	ed0d                	bnez	a0,80002498 <k_mem_pool_free_id+0x86>
80002460:	80005a37          	lui	s4,0x80005
80002464:	800055b7          	lui	a1,0x80005
80002468:	80005537          	lui	a0,0x80005
8000246c:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002470:	04e00693          	li	a3,78
80002474:	c40a0613          	addi	a2,s4,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002478:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000247c:	93eff0ef          	jal	ra,800015ba <printk>
80002480:	80005537          	lui	a0,0x80005
80002484:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002488:	932ff0ef          	jal	ra,800015ba <printk>
8000248c:	04e00593          	li	a1,78
80002490:	c40a0513          	addi	a0,s4,-960
80002494:	944ff0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002498:	2bc48513          	addi	a0,s1,700
8000249c:	560010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
800024a0:	01440513          	addi	a0,s0,20
800024a4:	954a                	add	a0,a0,s2
800024a6:	010010ef          	jal	ra,800034b6 <z_unpend_all>

	if (need_sched != 0) {
800024aa:	cd01                	beqz	a0,800024c2 <k_mem_pool_free_id+0xb0>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
800024ac:	4462                	lw	s0,24(sp)
800024ae:	40f2                	lw	ra,28(sp)
800024b0:	4942                	lw	s2,16(sp)
800024b2:	4a22                	lw	s4,8(sp)
		z_reschedule(&lock, key);
800024b4:	85ce                	mv	a1,s3
800024b6:	2bc48513          	addi	a0,s1,700
}
800024ba:	49b2                	lw	s3,12(sp)
800024bc:	44d2                	lw	s1,20(sp)
800024be:	6105                	addi	sp,sp,32
		z_reschedule(&lock, key);
800024c0:	a479                	j	8000274e <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024c2:	2bc48513          	addi	a0,s1,700
800024c6:	514010ef          	jal	ra,800039da <z_spin_unlock_valid>
800024ca:	ed0d                	bnez	a0,80002504 <k_mem_pool_free_id+0xf2>
800024cc:	80005437          	lui	s0,0x80005
800024d0:	800055b7          	lui	a1,0x80005
800024d4:	80005537          	lui	a0,0x80005
800024d8:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800024dc:	06100693          	li	a3,97
800024e0:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800024e4:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800024e8:	8d2ff0ef          	jal	ra,800015ba <printk>
800024ec:	80005537          	lui	a0,0x80005
800024f0:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800024f4:	8c6ff0ef          	jal	ra,800015ba <printk>
800024f8:	06100593          	li	a1,97
800024fc:	c4040513          	addi	a0,s0,-960
80002500:	8d8ff0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002504:	3009a5f3          	csrrs	a1,mstatus,s3
}
80002508:	40f2                	lw	ra,28(sp)
8000250a:	4462                	lw	s0,24(sp)
8000250c:	44d2                	lw	s1,20(sp)
8000250e:	4942                	lw	s2,16(sp)
80002510:	49b2                	lw	s3,12(sp)
80002512:	4a22                	lw	s4,8(sp)
80002514:	6105                	addi	sp,sp,32
80002516:	8082                	ret

80002518 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
80002518:	0511                	addi	a0,a0,4
8000251a:	bde5                	j	80002412 <k_mem_pool_free_id>

8000251c <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000251c:	00d54783          	lbu	a5,13(a0)
80002520:	8bfd                	andi	a5,a5,31
80002522:	e789                	bnez	a5,8000252c <z_is_thread_ready+0x10>
80002524:	4d08                	lw	a0,24(a0)
80002526:	00153513          	seqz	a0,a0
8000252a:	8082                	ret
8000252c:	4501                	li	a0,0
}
8000252e:	8082                	ret

80002530 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002530:	1141                	addi	sp,sp,-16
80002532:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002534:	c00ff0ef          	jal	ra,80001934 <z_clock_elapsed>
80002538:	800057b7          	lui	a5,0x80005
8000253c:	2c87a783          	lw	a5,712(a5) # 800052c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c9>

	z_set_timeout_expiry(slice_time, false);
}
80002540:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002542:	80005737          	lui	a4,0x80005
80002546:	953e                	add	a0,a0,a5
80002548:	58a72a23          	sw	a0,1428(a4) # 80005594 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005595>
	z_set_timeout_expiry(slice_time, false);
8000254c:	4581                	li	a1,0
8000254e:	853e                	mv	a0,a5
}
80002550:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002552:	38f0106f          	j	800040e0 <z_set_timeout_expiry>

80002556 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002556:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002558:	1141                	addi	sp,sp,-16
8000255a:	c422                	sw	s0,8(sp)
8000255c:	c606                	sw	ra,12(sp)
8000255e:	c226                	sw	s1,4(sp)
80002560:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002562:	e79d                	bnez	a5,80002590 <pended_on.isra.15+0x3a>
80002564:	800054b7          	lui	s1,0x80005
80002568:	800055b7          	lui	a1,0x80005
8000256c:	80005537          	lui	a0,0x80005
80002570:	f0c58593          	addi	a1,a1,-244 # 80004f0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f0d>
80002574:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002578:	18300693          	li	a3,387
8000257c:	ef848613          	addi	a2,s1,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002580:	83aff0ef          	jal	ra,800015ba <printk>
80002584:	18300593          	li	a1,387
80002588:	ef848513          	addi	a0,s1,-264
8000258c:	84cff0ef          	jal	ra,800015d8 <assert_post_action>

	return thread->base.pended_on;
}
80002590:	4008                	lw	a0,0(s0)
80002592:	40b2                	lw	ra,12(sp)
80002594:	4422                	lw	s0,8(sp)
80002596:	4492                	lw	s1,4(sp)
80002598:	0141                	addi	sp,sp,16
8000259a:	8082                	ret

8000259c <k_sched_time_slice_set>:
{
8000259c:	1101                	addi	sp,sp,-32
8000259e:	cc22                	sw	s0,24(sp)
800025a0:	c64e                	sw	s3,12(sp)
800025a2:	c452                	sw	s4,8(sp)
800025a4:	ce06                	sw	ra,28(sp)
800025a6:	ca26                	sw	s1,20(sp)
800025a8:	c84a                	sw	s2,16(sp)
800025aa:	8a2a                	mv	s4,a0
800025ac:	89ae                	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800025ae:	4421                	li	s0,8
800025b0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800025b4:	800054b7          	lui	s1,0x80005
800025b8:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800025bc:	8821                	andi	s0,s0,8
800025be:	402010ef          	jal	ra,800039c0 <z_spin_lock_valid>
800025c2:	ed0d                	bnez	a0,800025fc <k_sched_time_slice_set+0x60>
800025c4:	80005937          	lui	s2,0x80005
800025c8:	800055b7          	lui	a1,0x80005
800025cc:	80005537          	lui	a0,0x80005
800025d0:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800025d4:	04e00693          	li	a3,78
800025d8:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800025dc:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800025e0:	fdbfe0ef          	jal	ra,800015ba <printk>
800025e4:	80005537          	lui	a0,0x80005
800025e8:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
800025ec:	fcffe0ef          	jal	ra,800015ba <printk>
800025f0:	04e00593          	li	a1,78
800025f4:	c4090513          	addi	a0,s2,-960
800025f8:	fe1fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
800025fc:	2c048513          	addi	a0,s1,704
80002600:	3fc010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002604:	800057b7          	lui	a5,0x80005
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002608:	45a9                	li	a1,10
8000260a:	009a0513          	addi	a0,s4,9
8000260e:	5807aa23          	sw	zero,1428(a5) # 80005594 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005595>
80002612:	a2efe0ef          	jal	ra,80000840 <__divsi3>
		slice_max_prio = prio;
80002616:	800057b7          	lui	a5,0x80005
		slice_time = z_ms_to_ticks(slice);
8000261a:	80005937          	lui	s2,0x80005
8000261e:	2ca92423          	sw	a0,712(s2) # 800052c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c9>
		slice_max_prio = prio;
80002622:	2d37a223          	sw	s3,708(a5) # 800052c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c5>
		reset_time_slice();
80002626:	3729                	jal	80002530 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002628:	2c048513          	addi	a0,s1,704
8000262c:	3ae010ef          	jal	ra,800039da <z_spin_unlock_valid>
80002630:	ed0d                	bnez	a0,8000266a <k_sched_time_slice_set+0xce>
80002632:	800054b7          	lui	s1,0x80005
80002636:	800055b7          	lui	a1,0x80005
8000263a:	80005537          	lui	a0,0x80005
8000263e:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002642:	06100693          	li	a3,97
80002646:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000264a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000264e:	f6dfe0ef          	jal	ra,800015ba <printk>
80002652:	80005537          	lui	a0,0x80005
80002656:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000265a:	f61fe0ef          	jal	ra,800015ba <printk>
8000265e:	06100593          	li	a1,97
80002662:	c4048513          	addi	a0,s1,-960
80002666:	f73fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000266a:	30042473          	csrrs	s0,mstatus,s0
}
8000266e:	40f2                	lw	ra,28(sp)
80002670:	4462                	lw	s0,24(sp)
80002672:	44d2                	lw	s1,20(sp)
80002674:	4942                	lw	s2,16(sp)
80002676:	49b2                	lw	s3,12(sp)
80002678:	4a22                	lw	s4,8(sp)
8000267a:	6105                	addi	sp,sp,32
8000267c:	8082                	ret

8000267e <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
8000267e:	1101                	addi	sp,sp,-32
80002680:	cc22                	sw	s0,24(sp)
80002682:	c84a                	sw	s2,16(sp)
80002684:	ce06                	sw	ra,28(sp)
80002686:	ca26                	sw	s1,20(sp)
80002688:	c64e                	sw	s3,12(sp)
8000268a:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000268c:	4421                	li	s0,8
8000268e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002692:	800054b7          	lui	s1,0x80005
80002696:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000269a:	8821                	andi	s0,s0,8
8000269c:	324010ef          	jal	ra,800039c0 <z_spin_lock_valid>
800026a0:	ed0d                	bnez	a0,800026da <z_unpend_thread_no_timeout+0x5c>
800026a2:	800059b7          	lui	s3,0x80005
800026a6:	800055b7          	lui	a1,0x80005
800026aa:	80005537          	lui	a0,0x80005
800026ae:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800026b2:	04e00693          	li	a3,78
800026b6:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800026ba:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800026be:	efdfe0ef          	jal	ra,800015ba <printk>
800026c2:	80005537          	lui	a0,0x80005
800026c6:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
800026ca:	ef1fe0ef          	jal	ra,800015ba <printk>
800026ce:	04e00593          	li	a1,78
800026d2:	c4098513          	addi	a0,s3,-960
800026d6:	f03fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
800026da:	2c048513          	addi	a0,s1,704
800026de:	31e010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800026e2:	00890513          	addi	a0,s2,8
800026e6:	3d85                	jal	80002556 <pended_on.isra.15>
800026e8:	85ca                	mv	a1,s2
800026ea:	2451                	jal	8000296e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800026ec:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800026f0:	2c048513          	addi	a0,s1,704
800026f4:	9bf5                	andi	a5,a5,-3
800026f6:	00f906a3          	sb	a5,13(s2)
800026fa:	2e0010ef          	jal	ra,800039da <z_spin_unlock_valid>
800026fe:	ed0d                	bnez	a0,80002738 <z_unpend_thread_no_timeout+0xba>
80002700:	800054b7          	lui	s1,0x80005
80002704:	800055b7          	lui	a1,0x80005
80002708:	80005537          	lui	a0,0x80005
8000270c:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002710:	06100693          	li	a3,97
80002714:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002718:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000271c:	e9ffe0ef          	jal	ra,800015ba <printk>
80002720:	80005537          	lui	a0,0x80005
80002724:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002728:	e93fe0ef          	jal	ra,800015ba <printk>
8000272c:	06100593          	li	a1,97
80002730:	c4048513          	addi	a0,s1,-960
80002734:	ea5fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002738:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
8000273c:	40f2                	lw	ra,28(sp)
8000273e:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002740:	00092423          	sw	zero,8(s2)
}
80002744:	44d2                	lw	s1,20(sp)
80002746:	4942                	lw	s2,16(sp)
80002748:	49b2                	lw	s3,12(sp)
8000274a:	6105                	addi	sp,sp,32
8000274c:	8082                	ret

8000274e <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
8000274e:	800057b7          	lui	a5,0x80005
80002752:	5847a783          	lw	a5,1412(a5) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
{
80002756:	1141                	addi	sp,sp,-16
80002758:	c422                	sw	s0,8(sp)
8000275a:	c606                	sw	ra,12(sp)
8000275c:	c226                	sw	s1,4(sp)
8000275e:	842e                	mv	s0,a1
	if (resched()) {
80002760:	e7b9                	bnez	a5,800027ae <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002762:	278010ef          	jal	ra,800039da <z_spin_unlock_valid>
80002766:	ed0d                	bnez	a0,800027a0 <z_reschedule+0x52>
80002768:	800054b7          	lui	s1,0x80005
8000276c:	800055b7          	lui	a1,0x80005
80002770:	80005537          	lui	a0,0x80005
80002774:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002778:	07800693          	li	a3,120
8000277c:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002780:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002784:	e37fe0ef          	jal	ra,800015ba <printk>
80002788:	80005537          	lui	a0,0x80005
8000278c:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002790:	e2bfe0ef          	jal	ra,800015ba <printk>
80002794:	07800593          	li	a1,120
80002798:	c4048513          	addi	a0,s1,-960
8000279c:	e3dfe0ef          	jal	ra,800015d8 <assert_post_action>
800027a0:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800027a2:	4422                	lw	s0,8(sp)
800027a4:	40b2                	lw	ra,12(sp)
800027a6:	4492                	lw	s1,4(sp)
800027a8:	0141                	addi	sp,sp,16
800027aa:	a17fd06f          	j	800001c0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800027ae:	22c010ef          	jal	ra,800039da <z_spin_unlock_valid>
800027b2:	ed0d                	bnez	a0,800027ec <z_reschedule+0x9e>
800027b4:	800054b7          	lui	s1,0x80005
800027b8:	800055b7          	lui	a1,0x80005
800027bc:	80005537          	lui	a0,0x80005
800027c0:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800027c4:	06100693          	li	a3,97
800027c8:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800027cc:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800027d0:	debfe0ef          	jal	ra,800015ba <printk>
800027d4:	80005537          	lui	a0,0x80005
800027d8:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800027dc:	ddffe0ef          	jal	ra,800015ba <printk>
800027e0:	06100593          	li	a1,97
800027e4:	c4048513          	addi	a0,s1,-960
800027e8:	df1fe0ef          	jal	ra,800015d8 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
800027ec:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800027ee:	30042473          	csrrs	s0,mstatus,s0
800027f2:	40b2                	lw	ra,12(sp)
800027f4:	4422                	lw	s0,8(sp)
800027f6:	4492                	lw	s1,4(sp)
800027f8:	0141                	addi	sp,sp,16
800027fa:	8082                	ret

800027fc <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
800027fc:	80005737          	lui	a4,0x80005
80002800:	58472703          	lw	a4,1412(a4) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002804:	e319                	bnez	a4,8000280a <z_reschedule_irqlock+0xe>
80002806:	9bbfd06f          	j	800001c0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
8000280a:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000280e:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002812:	8082                	ret

80002814 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002814:	4521                	li	a0,8
80002816:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
8000281a:	8921                	andi	a0,a0,8
8000281c:	b7c5                	j	800027fc <z_reschedule_irqlock>

8000281e <k_sched_lock>:

void k_sched_lock(void)
{
8000281e:	1101                	addi	sp,sp,-32
80002820:	cc22                	sw	s0,24(sp)
80002822:	ce06                	sw	ra,28(sp)
80002824:	ca26                	sw	s1,20(sp)
80002826:	c84a                	sw	s2,16(sp)
80002828:	c64e                	sw	s3,12(sp)
8000282a:	4421                	li	s0,8
8000282c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002830:	800054b7          	lui	s1,0x80005
80002834:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002838:	8821                	andi	s0,s0,8
8000283a:	186010ef          	jal	ra,800039c0 <z_spin_lock_valid>
8000283e:	ed0d                	bnez	a0,80002878 <k_sched_lock+0x5a>
80002840:	80005937          	lui	s2,0x80005
80002844:	800055b7          	lui	a1,0x80005
80002848:	80005537          	lui	a0,0x80005
8000284c:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002850:	04e00693          	li	a3,78
80002854:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002858:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000285c:	d5ffe0ef          	jal	ra,800015ba <printk>
80002860:	80005537          	lui	a0,0x80005
80002864:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002868:	d53fe0ef          	jal	ra,800015ba <printk>
8000286c:	04e00593          	li	a1,78
80002870:	c4090513          	addi	a0,s2,-960
80002874:	d65fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002878:	2c048513          	addi	a0,s1,704
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
8000287c:	80005937          	lui	s2,0x80005
80002880:	17c010ef          	jal	ra,800039fc <z_spin_lock_set_owner>
80002884:	58492783          	lw	a5,1412(s2) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002888:	58490913          	addi	s2,s2,1412
8000288c:	cf8d                	beqz	a5,800028c6 <k_sched_lock+0xa8>
8000288e:	800059b7          	lui	s3,0x80005
80002892:	800055b7          	lui	a1,0x80005
80002896:	80005537          	lui	a0,0x80005
8000289a:	e9058593          	addi	a1,a1,-368 # 80004e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e91>
8000289e:	10000693          	li	a3,256
800028a2:	e7498613          	addi	a2,s3,-396 # 80004e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e75>
800028a6:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800028aa:	d11fe0ef          	jal	ra,800015ba <printk>
800028ae:	80005537          	lui	a0,0x80005
800028b2:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
800028b6:	d05fe0ef          	jal	ra,800015ba <printk>
800028ba:	10000593          	li	a1,256
800028be:	e7498513          	addi	a0,s3,-396
800028c2:	d17fe0ef          	jal	ra,800015d8 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800028c6:	00892783          	lw	a5,8(s2)
800028ca:	00f7c703          	lbu	a4,15(a5)
800028ce:	4785                	li	a5,1
800028d0:	02f71e63          	bne	a4,a5,8000290c <k_sched_lock+0xee>
800028d4:	800059b7          	lui	s3,0x80005
800028d8:	800055b7          	lui	a1,0x80005
800028dc:	80005537          	lui	a0,0x80005
800028e0:	ea858593          	addi	a1,a1,-344 # 80004ea8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ea9>
800028e4:	10100693          	li	a3,257
800028e8:	e7498613          	addi	a2,s3,-396 # 80004e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e75>
800028ec:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800028f0:	ccbfe0ef          	jal	ra,800015ba <printk>
800028f4:	80005537          	lui	a0,0x80005
800028f8:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
800028fc:	cbffe0ef          	jal	ra,800015ba <printk>
80002900:	10100593          	li	a1,257
80002904:	e7498513          	addi	a0,s3,-396
80002908:	cd1fe0ef          	jal	ra,800015d8 <assert_post_action>

	--_current->base.sched_locked;
8000290c:	00892703          	lw	a4,8(s2)
80002910:	00f74783          	lbu	a5,15(a4)
80002914:	17fd                	addi	a5,a5,-1
80002916:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000291a:	2c048513          	addi	a0,s1,704
8000291e:	0bc010ef          	jal	ra,800039da <z_spin_unlock_valid>
80002922:	ed0d                	bnez	a0,8000295c <k_sched_lock+0x13e>
80002924:	800054b7          	lui	s1,0x80005
80002928:	800055b7          	lui	a1,0x80005
8000292c:	80005537          	lui	a0,0x80005
80002930:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002934:	06100693          	li	a3,97
80002938:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000293c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002940:	c7bfe0ef          	jal	ra,800015ba <printk>
80002944:	80005537          	lui	a0,0x80005
80002948:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000294c:	c6ffe0ef          	jal	ra,800015ba <printk>
80002950:	06100593          	li	a1,97
80002954:	c4048513          	addi	a0,s1,-960
80002958:	c81fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000295c:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80002960:	40f2                	lw	ra,28(sp)
80002962:	4462                	lw	s0,24(sp)
80002964:	44d2                	lw	s1,20(sp)
80002966:	4942                	lw	s2,16(sp)
80002968:	49b2                	lw	s3,12(sp)
8000296a:	6105                	addi	sp,sp,32
8000296c:	8082                	ret

8000296e <z_priq_dumb_remove>:
	return thread == _idle_thread;
8000296e:	800057b7          	lui	a5,0x80005
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002972:	1e07a783          	lw	a5,480(a5) # 800051e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e1>
{
80002976:	1141                	addi	sp,sp,-16
80002978:	c422                	sw	s0,8(sp)
8000297a:	c606                	sw	ra,12(sp)
8000297c:	c226                	sw	s1,4(sp)
8000297e:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80002980:	02f59863          	bne	a1,a5,800029b0 <z_priq_dumb_remove+0x42>
80002984:	800054b7          	lui	s1,0x80005
80002988:	800055b7          	lui	a1,0x80005
8000298c:	80005537          	lui	a0,0x80005
80002990:	f7c58593          	addi	a1,a1,-132 # 80004f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f7d>
80002994:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002998:	28c00693          	li	a3,652
8000299c:	ef848613          	addi	a2,s1,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
800029a0:	c1bfe0ef          	jal	ra,800015ba <printk>
800029a4:	28c00593          	li	a1,652
800029a8:	ef848513          	addi	a0,s1,-264
800029ac:	c2dfe0ef          	jal	ra,800015d8 <assert_post_action>
	node->prev->next = node->next;
800029b0:	4058                	lw	a4,4(s0)
800029b2:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800029b4:	40b2                	lw	ra,12(sp)
800029b6:	4492                	lw	s1,4(sp)
800029b8:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
800029ba:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
800029bc:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800029c0:	00042223          	sw	zero,4(s0)
800029c4:	4422                	lw	s0,8(sp)
800029c6:	0141                	addi	sp,sp,16
800029c8:	8082                	ret

800029ca <z_unpend_thread>:
{
800029ca:	1101                	addi	sp,sp,-32
800029cc:	cc22                	sw	s0,24(sp)
800029ce:	ca26                	sw	s1,20(sp)
800029d0:	ce06                	sw	ra,28(sp)
800029d2:	c84a                	sw	s2,16(sp)
800029d4:	c64e                	sw	s3,12(sp)
800029d6:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800029d8:	44a1                	li	s1,8
800029da:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800029de:	80005937          	lui	s2,0x80005
800029e2:	2c090513          	addi	a0,s2,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800029e6:	88a1                	andi	s1,s1,8
800029e8:	7d9000ef          	jal	ra,800039c0 <z_spin_lock_valid>
800029ec:	ed0d                	bnez	a0,80002a26 <z_unpend_thread+0x5c>
800029ee:	800059b7          	lui	s3,0x80005
800029f2:	800055b7          	lui	a1,0x80005
800029f6:	80005537          	lui	a0,0x80005
800029fa:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800029fe:	04e00693          	li	a3,78
80002a02:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002a06:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002a0a:	bb1fe0ef          	jal	ra,800015ba <printk>
80002a0e:	80005537          	lui	a0,0x80005
80002a12:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002a16:	ba5fe0ef          	jal	ra,800015ba <printk>
80002a1a:	04e00593          	li	a1,78
80002a1e:	c4098513          	addi	a0,s3,-960
80002a22:	bb7fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002a26:	2c090513          	addi	a0,s2,704
80002a2a:	7d3000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002a2e:	00840513          	addi	a0,s0,8
80002a32:	b25ff0ef          	jal	ra,80002556 <pended_on.isra.15>
80002a36:	85a2                	mv	a1,s0
80002a38:	3f1d                	jal	8000296e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002a3a:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a3e:	2c090513          	addi	a0,s2,704
80002a42:	9bf5                	andi	a5,a5,-3
80002a44:	00f406a3          	sb	a5,13(s0)
80002a48:	793000ef          	jal	ra,800039da <z_spin_unlock_valid>
80002a4c:	ed0d                	bnez	a0,80002a86 <z_unpend_thread+0xbc>
80002a4e:	80005937          	lui	s2,0x80005
80002a52:	800055b7          	lui	a1,0x80005
80002a56:	80005537          	lui	a0,0x80005
80002a5a:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002a5e:	06100693          	li	a3,97
80002a62:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002a66:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002a6a:	b51fe0ef          	jal	ra,800015ba <printk>
80002a6e:	80005537          	lui	a0,0x80005
80002a72:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002a76:	b45fe0ef          	jal	ra,800015ba <printk>
80002a7a:	06100593          	li	a1,97
80002a7e:	c4090513          	addi	a0,s2,-960
80002a82:	b57fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002a86:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002a8a:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80002a8e:	01840513          	addi	a0,s0,24
}
80002a92:	4462                	lw	s0,24(sp)
80002a94:	40f2                	lw	ra,28(sp)
80002a96:	44d2                	lw	s1,20(sp)
80002a98:	4942                	lw	s2,16(sp)
80002a9a:	49b2                	lw	s3,12(sp)
80002a9c:	6105                	addi	sp,sp,32
80002a9e:	4be0106f          	j	80003f5c <z_abort_timeout>

80002aa2 <z_priq_dumb_best>:
	return list->head == list;
80002aa2:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002aa4:	00f51363          	bne	a0,a5,80002aaa <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002aa8:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80002aaa:	853e                	mv	a0,a5
80002aac:	8082                	ret

80002aae <update_cache>:
{
80002aae:	1141                	addi	sp,sp,-16
80002ab0:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002ab2:	80005437          	lui	s0,0x80005
{
80002ab6:	c04a                	sw	s2,0(sp)
80002ab8:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002aba:	58440513          	addi	a0,s0,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002abe:	02450513          	addi	a0,a0,36
{
80002ac2:	c226                	sw	s1,4(sp)
80002ac4:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002ac6:	3ff1                	jal	80002aa2 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80002ac8:	58440413          	addi	s0,s0,1412
80002acc:	84aa                	mv	s1,a0
80002ace:	e111                	bnez	a0,80002ad2 <update_cache+0x24>
80002ad0:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002ad2:	06091263          	bnez	s2,80002b36 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80002ad6:	441c                	lw	a5,8(s0)
80002ad8:	ef8d                	bnez	a5,80002b12 <update_cache+0x64>
80002ada:	80005937          	lui	s2,0x80005
80002ade:	800055b7          	lui	a1,0x80005
80002ae2:	80005537          	lui	a0,0x80005
80002ae6:	f2458593          	addi	a1,a1,-220 # 80004f24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f25>
80002aea:	07f00693          	li	a3,127
80002aee:	ef890613          	addi	a2,s2,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002af2:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002af6:	ac5fe0ef          	jal	ra,800015ba <printk>
80002afa:	80005537          	lui	a0,0x80005
80002afe:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80002b02:	ab9fe0ef          	jal	ra,800015ba <printk>
80002b06:	07f00593          	li	a1,127
80002b0a:	ef890513          	addi	a0,s2,-264
80002b0e:	acbfe0ef          	jal	ra,800015d8 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80002b12:	441c                	lw	a5,8(s0)
80002b14:	00d7c703          	lbu	a4,13(a5)
80002b18:	8b7d                	andi	a4,a4,31
80002b1a:	ef11                	bnez	a4,80002b36 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
80002b1c:	00e7d683          	lhu	a3,14(a5)
80002b20:	07f00713          	li	a4,127
80002b24:	00d77963          	bgeu	a4,a3,80002b36 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
80002b28:	d01c                	sw	a5,32(s0)
}
80002b2a:	40b2                	lw	ra,12(sp)
80002b2c:	4422                	lw	s0,8(sp)
80002b2e:	4492                	lw	s1,4(sp)
80002b30:	4902                	lw	s2,0(sp)
80002b32:	0141                	addi	sp,sp,16
80002b34:	8082                	ret
		if (th != _current) {
80002b36:	441c                	lw	a5,8(s0)
80002b38:	00978463          	beq	a5,s1,80002b40 <update_cache+0x92>
			reset_time_slice();
80002b3c:	9f5ff0ef          	jal	ra,80002530 <reset_time_slice>
		_kernel.ready_q.cache = th;
80002b40:	d004                	sw	s1,32(s0)
}
80002b42:	b7e5                	j	80002b2a <update_cache+0x7c>

80002b44 <k_sched_unlock>:
{
80002b44:	1101                	addi	sp,sp,-32
80002b46:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002b48:	80005937          	lui	s2,0x80005
80002b4c:	58490793          	addi	a5,s2,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002b50:	479c                	lw	a5,8(a5)
{
80002b52:	ce06                	sw	ra,28(sp)
80002b54:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80002b56:	00f7c783          	lbu	a5,15(a5)
{
80002b5a:	ca26                	sw	s1,20(sp)
80002b5c:	c64e                	sw	s3,12(sp)
80002b5e:	58490913          	addi	s2,s2,1412
	__ASSERT(_current->base.sched_locked != 0, "");
80002b62:	ef8d                	bnez	a5,80002b9c <k_sched_unlock+0x58>
80002b64:	80005437          	lui	s0,0x80005
80002b68:	800055b7          	lui	a1,0x80005
80002b6c:	80005537          	lui	a0,0x80005
80002b70:	ed058593          	addi	a1,a1,-304 # 80004ed0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ed1>
80002b74:	22100693          	li	a3,545
80002b78:	ef840613          	addi	a2,s0,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002b7c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002b80:	a3bfe0ef          	jal	ra,800015ba <printk>
80002b84:	80005537          	lui	a0,0x80005
80002b88:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80002b8c:	a2ffe0ef          	jal	ra,800015ba <printk>
80002b90:	22100593          	li	a1,545
80002b94:	ef840513          	addi	a0,s0,-264
80002b98:	a41fe0ef          	jal	ra,800015d8 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002b9c:	00092783          	lw	a5,0(s2)
80002ba0:	cf8d                	beqz	a5,80002bda <k_sched_unlock+0x96>
80002ba2:	80005437          	lui	s0,0x80005
80002ba6:	800055b7          	lui	a1,0x80005
80002baa:	80005537          	lui	a0,0x80005
80002bae:	e9058593          	addi	a1,a1,-368 # 80004e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e91>
80002bb2:	22200693          	li	a3,546
80002bb6:	ef840613          	addi	a2,s0,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002bba:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002bbe:	9fdfe0ef          	jal	ra,800015ba <printk>
80002bc2:	80005537          	lui	a0,0x80005
80002bc6:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80002bca:	9f1fe0ef          	jal	ra,800015ba <printk>
80002bce:	22200593          	li	a1,546
80002bd2:	ef840513          	addi	a0,s0,-264
80002bd6:	a03fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002bda:	4421                	li	s0,8
80002bdc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002be0:	800054b7          	lui	s1,0x80005
80002be4:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002be8:	8821                	andi	s0,s0,8
80002bea:	5d7000ef          	jal	ra,800039c0 <z_spin_lock_valid>
80002bee:	ed0d                	bnez	a0,80002c28 <k_sched_unlock+0xe4>
80002bf0:	800059b7          	lui	s3,0x80005
80002bf4:	800055b7          	lui	a1,0x80005
80002bf8:	80005537          	lui	a0,0x80005
80002bfc:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002c00:	04e00693          	li	a3,78
80002c04:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002c08:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002c0c:	9affe0ef          	jal	ra,800015ba <printk>
80002c10:	80005537          	lui	a0,0x80005
80002c14:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002c18:	9a3fe0ef          	jal	ra,800015ba <printk>
80002c1c:	04e00593          	li	a1,78
80002c20:	c4098513          	addi	a0,s3,-960
80002c24:	9b5fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002c28:	2c048513          	addi	a0,s1,704
80002c2c:	5d1000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80002c30:	00892703          	lw	a4,8(s2)
		update_cache(1);
80002c34:	4505                	li	a0,1
		++_current->base.sched_locked;
80002c36:	00f74783          	lbu	a5,15(a4)
80002c3a:	0785                	addi	a5,a5,1
80002c3c:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80002c40:	35bd                	jal	80002aae <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c42:	2c048513          	addi	a0,s1,704
80002c46:	595000ef          	jal	ra,800039da <z_spin_unlock_valid>
80002c4a:	ed0d                	bnez	a0,80002c84 <k_sched_unlock+0x140>
80002c4c:	800054b7          	lui	s1,0x80005
80002c50:	800055b7          	lui	a1,0x80005
80002c54:	80005537          	lui	a0,0x80005
80002c58:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002c5c:	06100693          	li	a3,97
80002c60:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002c64:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002c68:	953fe0ef          	jal	ra,800015ba <printk>
80002c6c:	80005537          	lui	a0,0x80005
80002c70:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002c74:	947fe0ef          	jal	ra,800015ba <printk>
80002c78:	06100593          	li	a1,97
80002c7c:	c4048513          	addi	a0,s1,-960
80002c80:	959fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c84:	30042473          	csrrs	s0,mstatus,s0
}
80002c88:	4462                	lw	s0,24(sp)
80002c8a:	40f2                	lw	ra,28(sp)
80002c8c:	44d2                	lw	s1,20(sp)
80002c8e:	4942                	lw	s2,16(sp)
80002c90:	49b2                	lw	s3,12(sp)
80002c92:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80002c94:	b81ff06f          	j	80002814 <z_reschedule_unlocked>

80002c98 <z_add_thread_to_ready_q>:
{
80002c98:	1101                	addi	sp,sp,-32
80002c9a:	cc22                	sw	s0,24(sp)
80002c9c:	ca26                	sw	s1,20(sp)
80002c9e:	ce06                	sw	ra,28(sp)
80002ca0:	c84a                	sw	s2,16(sp)
80002ca2:	c64e                	sw	s3,12(sp)
80002ca4:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ca6:	44a1                	li	s1,8
80002ca8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002cac:	80005937          	lui	s2,0x80005
80002cb0:	2c090513          	addi	a0,s2,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002cb4:	88a1                	andi	s1,s1,8
80002cb6:	50b000ef          	jal	ra,800039c0 <z_spin_lock_valid>
80002cba:	ed0d                	bnez	a0,80002cf4 <z_add_thread_to_ready_q+0x5c>
80002cbc:	800059b7          	lui	s3,0x80005
80002cc0:	800055b7          	lui	a1,0x80005
80002cc4:	80005537          	lui	a0,0x80005
80002cc8:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002ccc:	04e00693          	li	a3,78
80002cd0:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002cd4:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002cd8:	8e3fe0ef          	jal	ra,800015ba <printk>
80002cdc:	80005537          	lui	a0,0x80005
80002ce0:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002ce4:	8d7fe0ef          	jal	ra,800015ba <printk>
80002ce8:	04e00593          	li	a1,78
80002cec:	c4098513          	addi	a0,s3,-960
80002cf0:	8e9fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002cf4:	2c090513          	addi	a0,s2,704
80002cf8:	505000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	return thread == _idle_thread;
80002cfc:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002d00:	1e07a783          	lw	a5,480(a5) # 800051e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e1>
80002d04:	02f41863          	bne	s0,a5,80002d34 <z_add_thread_to_ready_q+0x9c>
80002d08:	800059b7          	lui	s3,0x80005
80002d0c:	800055b7          	lui	a1,0x80005
80002d10:	80005537          	lui	a0,0x80005
80002d14:	f7c58593          	addi	a1,a1,-132 # 80004f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f7d>
80002d18:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002d1c:	27600693          	li	a3,630
80002d20:	ef898613          	addi	a2,s3,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002d24:	897fe0ef          	jal	ra,800015ba <printk>
80002d28:	27600593          	li	a1,630
80002d2c:	ef898513          	addi	a0,s3,-264
80002d30:	8a9fe0ef          	jal	ra,800015d8 <assert_post_action>
	return list->head == list;
80002d34:	80005737          	lui	a4,0x80005
80002d38:	58470693          	addi	a3,a4,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002d3c:	52dc                	lw	a5,36(a3)
80002d3e:	5690                	lw	a2,40(a3)
80002d40:	800056b7          	lui	a3,0x80005
80002d44:	5a868693          	addi	a3,a3,1448 # 800055a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055a9>
80002d48:	58470713          	addi	a4,a4,1412
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002d4c:	08d78563          	beq	a5,a3,80002dd6 <z_add_thread_to_ready_q+0x13e>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002d50:	c3d9                	beqz	a5,80002dd6 <z_add_thread_to_ready_q+0x13e>
	if (t1->base.prio < t2->base.prio) {
80002d52:	00e40583          	lb	a1,14(s0)
80002d56:	00e78503          	lb	a0,14(a5)
80002d5a:	06a5da63          	bge	a1,a0,80002dce <z_add_thread_to_ready_q+0x136>
	node->prev = successor->prev;
80002d5e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002d60:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002d62:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002d64:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002d66:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002d68:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80002d6c:	4501                	li	a0,0
80002d6e:	0407e793          	ori	a5,a5,64
80002d72:	00f406a3          	sb	a5,13(s0)
80002d76:	d39ff0ef          	jal	ra,80002aae <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d7a:	2c090513          	addi	a0,s2,704
80002d7e:	45d000ef          	jal	ra,800039da <z_spin_unlock_valid>
80002d82:	ed0d                	bnez	a0,80002dbc <z_add_thread_to_ready_q+0x124>
80002d84:	80005437          	lui	s0,0x80005
80002d88:	800055b7          	lui	a1,0x80005
80002d8c:	80005537          	lui	a0,0x80005
80002d90:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002d94:	06100693          	li	a3,97
80002d98:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002d9c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002da0:	81bfe0ef          	jal	ra,800015ba <printk>
80002da4:	80005537          	lui	a0,0x80005
80002da8:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002dac:	80ffe0ef          	jal	ra,800015ba <printk>
80002db0:	06100593          	li	a1,97
80002db4:	c4040513          	addi	a0,s0,-960
80002db8:	821fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002dbc:	3004a4f3          	csrrs	s1,mstatus,s1
}
80002dc0:	40f2                	lw	ra,28(sp)
80002dc2:	4462                	lw	s0,24(sp)
80002dc4:	44d2                	lw	s1,20(sp)
80002dc6:	4942                	lw	s2,16(sp)
80002dc8:	49b2                	lw	s3,12(sp)
80002dca:	6105                	addi	sp,sp,32
80002dcc:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
80002dce:	00f60463          	beq	a2,a5,80002dd6 <z_add_thread_to_ready_q+0x13e>
80002dd2:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002dd4:	f3c9                	bnez	a5,80002d56 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80002dd6:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80002dd8:	571c                	lw	a5,40(a4)
	node->next = list;
80002dda:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80002ddc:	c380                	sw	s0,0(a5)
	list->tail = node;
80002dde:	d700                	sw	s0,40(a4)
80002de0:	b761                	j	80002d68 <z_add_thread_to_ready_q+0xd0>

80002de2 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80002de2:	ff052783          	lw	a5,-16(a0)
{
80002de6:	1101                	addi	sp,sp,-32
80002de8:	cc22                	sw	s0,24(sp)
80002dea:	c64e                	sw	s3,12(sp)
80002dec:	ce06                	sw	ra,28(sp)
80002dee:	ca26                	sw	s1,20(sp)
80002df0:	c84a                	sw	s2,16(sp)
80002df2:	c452                	sw	s4,8(sp)
80002df4:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002df6:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002dfa:	cfcd                	beqz	a5,80002eb4 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002dfc:	44a1                	li	s1,8
80002dfe:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e02:	80005937          	lui	s2,0x80005
80002e06:	2c090513          	addi	a0,s2,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e0a:	88a1                	andi	s1,s1,8
80002e0c:	3b5000ef          	jal	ra,800039c0 <z_spin_lock_valid>
80002e10:	ed0d                	bnez	a0,80002e4a <z_thread_timeout+0x68>
80002e12:	80005a37          	lui	s4,0x80005
80002e16:	800055b7          	lui	a1,0x80005
80002e1a:	80005537          	lui	a0,0x80005
80002e1e:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002e22:	04e00693          	li	a3,78
80002e26:	c40a0613          	addi	a2,s4,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002e2a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002e2e:	f8cfe0ef          	jal	ra,800015ba <printk>
80002e32:	80005537          	lui	a0,0x80005
80002e36:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002e3a:	f80fe0ef          	jal	ra,800015ba <printk>
80002e3e:	04e00593          	li	a1,78
80002e42:	c40a0513          	addi	a0,s4,-960
80002e46:	f92fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e4a:	2c090513          	addi	a0,s2,704
80002e4e:	3af000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002e52:	ff040513          	addi	a0,s0,-16
80002e56:	f00ff0ef          	jal	ra,80002556 <pended_on.isra.15>
80002e5a:	85ce                	mv	a1,s3
80002e5c:	b13ff0ef          	jal	ra,8000296e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002e60:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e64:	2c090513          	addi	a0,s2,704
80002e68:	9bf5                	andi	a5,a5,-3
80002e6a:	fef40aa3          	sb	a5,-11(s0)
80002e6e:	36d000ef          	jal	ra,800039da <z_spin_unlock_valid>
80002e72:	ed0d                	bnez	a0,80002eac <z_thread_timeout+0xca>
80002e74:	80005937          	lui	s2,0x80005
80002e78:	800055b7          	lui	a1,0x80005
80002e7c:	80005537          	lui	a0,0x80005
80002e80:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002e84:	06100693          	li	a3,97
80002e88:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002e8c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002e90:	f2afe0ef          	jal	ra,800015ba <printk>
80002e94:	80005537          	lui	a0,0x80005
80002e98:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80002e9c:	f1efe0ef          	jal	ra,800015ba <printk>
80002ea0:	06100593          	li	a1,97
80002ea4:	c4090513          	addi	a0,s2,-960
80002ea8:	f30fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002eac:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80002eb0:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002eb4:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002eb8:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002eba:	9bad                	andi	a5,a5,-21
80002ebc:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002ec0:	e5cff0ef          	jal	ra,8000251c <z_is_thread_ready>
80002ec4:	c919                	beqz	a0,80002eda <z_thread_timeout+0xf8>
}
80002ec6:	4462                	lw	s0,24(sp)
80002ec8:	40f2                	lw	ra,28(sp)
80002eca:	44d2                	lw	s1,20(sp)
80002ecc:	4942                	lw	s2,16(sp)
80002ece:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80002ed0:	854e                	mv	a0,s3
80002ed2:	49b2                	lw	s3,12(sp)
80002ed4:	6105                	addi	sp,sp,32
80002ed6:	dc3ff06f          	j	80002c98 <z_add_thread_to_ready_q>
80002eda:	40f2                	lw	ra,28(sp)
80002edc:	4462                	lw	s0,24(sp)
80002ede:	44d2                	lw	s1,20(sp)
80002ee0:	4942                	lw	s2,16(sp)
80002ee2:	49b2                	lw	s3,12(sp)
80002ee4:	4a22                	lw	s4,8(sp)
80002ee6:	6105                	addi	sp,sp,32
80002ee8:	8082                	ret

80002eea <z_move_thread_to_end_of_prio_q>:
{
80002eea:	1101                	addi	sp,sp,-32
80002eec:	cc22                	sw	s0,24(sp)
80002eee:	c84a                	sw	s2,16(sp)
80002ef0:	ce06                	sw	ra,28(sp)
80002ef2:	ca26                	sw	s1,20(sp)
80002ef4:	c64e                	sw	s3,12(sp)
80002ef6:	c452                	sw	s4,8(sp)
80002ef8:	c256                	sw	s5,4(sp)
80002efa:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002efc:	4921                	li	s2,8
80002efe:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f02:	800059b7          	lui	s3,0x80005
80002f06:	2c098513          	addi	a0,s3,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f0a:	00897913          	andi	s2,s2,8
80002f0e:	2b3000ef          	jal	ra,800039c0 <z_spin_lock_valid>
80002f12:	ed0d                	bnez	a0,80002f4c <z_move_thread_to_end_of_prio_q+0x62>
80002f14:	800054b7          	lui	s1,0x80005
80002f18:	800055b7          	lui	a1,0x80005
80002f1c:	80005537          	lui	a0,0x80005
80002f20:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80002f24:	04e00693          	li	a3,78
80002f28:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80002f2c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002f30:	e8afe0ef          	jal	ra,800015ba <printk>
80002f34:	80005537          	lui	a0,0x80005
80002f38:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80002f3c:	e7efe0ef          	jal	ra,800015ba <printk>
80002f40:	04e00593          	li	a1,78
80002f44:	c4048513          	addi	a0,s1,-960
80002f48:	e90fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80002f4c:	2c098513          	addi	a0,s3,704
80002f50:	2ad000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80002f54:	800054b7          	lui	s1,0x80005
80002f58:	58448513          	addi	a0,s1,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80002f5c:	85a2                	mv	a1,s0
80002f5e:	02450513          	addi	a0,a0,36
80002f62:	a0dff0ef          	jal	ra,8000296e <z_priq_dumb_remove>
	return thread == _idle_thread;
80002f66:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002f6a:	1e07a783          	lw	a5,480(a5) # 800051e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e1>
80002f6e:	80005a37          	lui	s4,0x80005
80002f72:	58448493          	addi	s1,s1,1412
80002f76:	5a8a0a13          	addi	s4,s4,1448 # 800055a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055a9>
80002f7a:	02f41863          	bne	s0,a5,80002faa <z_move_thread_to_end_of_prio_q+0xc0>
80002f7e:	80005ab7          	lui	s5,0x80005
80002f82:	800055b7          	lui	a1,0x80005
80002f86:	80005537          	lui	a0,0x80005
80002f8a:	f7c58593          	addi	a1,a1,-132 # 80004f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f7d>
80002f8e:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80002f92:	27600693          	li	a3,630
80002f96:	ef8a8613          	addi	a2,s5,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
80002f9a:	e20fe0ef          	jal	ra,800015ba <printk>
80002f9e:	27600593          	li	a1,630
80002fa2:	ef8a8513          	addi	a0,s5,-264
80002fa6:	e32fe0ef          	jal	ra,800015d8 <assert_post_action>
	return list->head == list;
80002faa:	50dc                	lw	a5,36(s1)
80002fac:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002fae:	09478a63          	beq	a5,s4,80003042 <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002fb2:	cbc1                	beqz	a5,80003042 <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
80002fb4:	00e40683          	lb	a3,14(s0)
80002fb8:	00e78603          	lb	a2,14(a5)
80002fbc:	06c6df63          	bge	a3,a2,8000303a <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
80002fc0:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002fc2:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002fc4:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002fc6:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002fc8:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002fca:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80002fce:	4488                	lw	a0,8(s1)
80002fd0:	0407e793          	ori	a5,a5,64
80002fd4:	8d01                	sub	a0,a0,s0
80002fd6:	00153513          	seqz	a0,a0
80002fda:	00f406a3          	sb	a5,13(s0)
80002fde:	ad1ff0ef          	jal	ra,80002aae <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fe2:	2c098513          	addi	a0,s3,704
80002fe6:	1f5000ef          	jal	ra,800039da <z_spin_unlock_valid>
80002fea:	ed0d                	bnez	a0,80003024 <z_move_thread_to_end_of_prio_q+0x13a>
80002fec:	80005437          	lui	s0,0x80005
80002ff0:	800055b7          	lui	a1,0x80005
80002ff4:	80005537          	lui	a0,0x80005
80002ff8:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80002ffc:	06100693          	li	a3,97
80003000:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003004:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003008:	db2fe0ef          	jal	ra,800015ba <printk>
8000300c:	80005537          	lui	a0,0x80005
80003010:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003014:	da6fe0ef          	jal	ra,800015ba <printk>
80003018:	06100593          	li	a1,97
8000301c:	c4040513          	addi	a0,s0,-960
80003020:	db8fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003024:	30092973          	csrrs	s2,mstatus,s2
}
80003028:	40f2                	lw	ra,28(sp)
8000302a:	4462                	lw	s0,24(sp)
8000302c:	44d2                	lw	s1,20(sp)
8000302e:	4942                	lw	s2,16(sp)
80003030:	49b2                	lw	s3,12(sp)
80003032:	4a22                	lw	s4,8(sp)
80003034:	4a92                	lw	s5,4(sp)
80003036:	6105                	addi	sp,sp,32
80003038:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
8000303a:	00e78463          	beq	a5,a4,80003042 <z_move_thread_to_end_of_prio_q+0x158>
8000303e:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003040:	ffa5                	bnez	a5,80002fb8 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
80003042:	c058                	sw	a4,4(s0)
	list->tail->next = node;
80003044:	549c                	lw	a5,40(s1)
	node->next = list;
80003046:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
8000304a:	c380                	sw	s0,0(a5)
	list->tail = node;
8000304c:	d480                	sw	s0,40(s1)
8000304e:	bfb5                	j	80002fca <z_move_thread_to_end_of_prio_q+0xe0>

80003050 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003050:	800057b7          	lui	a5,0x80005
80003054:	2c87a783          	lw	a5,712(a5) # 800052c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c9>
80003058:	cbb1                	beqz	a5,800030ac <z_time_slice+0x5c>
8000305a:	800057b7          	lui	a5,0x80005
8000305e:	58478793          	addi	a5,a5,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80003062:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003064:	07f00693          	li	a3,127
80003068:	00e75603          	lhu	a2,14(a4)
8000306c:	04c6e063          	bltu	a3,a2,800030ac <z_time_slice+0x5c>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003070:	800056b7          	lui	a3,0x80005
80003074:	00e70603          	lb	a2,14(a4)
80003078:	2c46a683          	lw	a3,708(a3) # 800052c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c5>
8000307c:	02d64863          	blt	a2,a3,800030ac <z_time_slice+0x5c>
	return thread == _idle_thread;
80003080:	800056b7          	lui	a3,0x80005
		&& !is_idle(t)
80003084:	1e06a683          	lw	a3,480(a3) # 800051e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e1>
80003088:	02d70263          	beq	a4,a3,800030ac <z_time_slice+0x5c>
		&& !z_is_thread_timeout_active(t);
8000308c:	4f14                	lw	a3,24(a4)
8000308e:	ee99                	bnez	a3,800030ac <z_time_slice+0x5c>
		if (ticks >= _current_cpu->slice_ticks) {
80003090:	4b94                	lw	a3,16(a5)
80003092:	00d54b63          	blt	a0,a3,800030a8 <z_time_slice+0x58>
{
80003096:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003098:	853a                	mv	a0,a4
{
8000309a:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
8000309c:	e4fff0ef          	jal	ra,80002eea <z_move_thread_to_end_of_prio_q>
}
800030a0:	40b2                	lw	ra,12(sp)
800030a2:	0141                	addi	sp,sp,16
			reset_time_slice();
800030a4:	c8cff06f          	j	80002530 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
800030a8:	8e89                	sub	a3,a3,a0
800030aa:	cb94                	sw	a3,16(a5)
800030ac:	8082                	ret

800030ae <z_remove_thread_from_ready_q>:
{
800030ae:	1101                	addi	sp,sp,-32
800030b0:	cc22                	sw	s0,24(sp)
800030b2:	c64e                	sw	s3,12(sp)
800030b4:	ce06                	sw	ra,28(sp)
800030b6:	ca26                	sw	s1,20(sp)
800030b8:	c84a                	sw	s2,16(sp)
800030ba:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030bc:	4421                	li	s0,8
800030be:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800030c2:	800054b7          	lui	s1,0x80005
800030c6:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800030ca:	8821                	andi	s0,s0,8
800030cc:	0f5000ef          	jal	ra,800039c0 <z_spin_lock_valid>
800030d0:	ed0d                	bnez	a0,8000310a <z_remove_thread_from_ready_q+0x5c>
800030d2:	80005937          	lui	s2,0x80005
800030d6:	800055b7          	lui	a1,0x80005
800030da:	80005537          	lui	a0,0x80005
800030de:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800030e2:	04e00693          	li	a3,78
800030e6:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800030ea:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800030ee:	cccfe0ef          	jal	ra,800015ba <printk>
800030f2:	80005537          	lui	a0,0x80005
800030f6:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
800030fa:	cc0fe0ef          	jal	ra,800015ba <printk>
800030fe:	04e00593          	li	a1,78
80003102:	c4090513          	addi	a0,s2,-960
80003106:	cd2fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000310a:	2c048513          	addi	a0,s1,704
8000310e:	0ef000ef          	jal	ra,800039fc <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003112:	00d9c783          	lbu	a5,13(s3)
80003116:	80005937          	lui	s2,0x80005
8000311a:	58490913          	addi	s2,s2,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
8000311e:	0407f793          	andi	a5,a5,64
80003122:	cf81                	beqz	a5,8000313a <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003124:	85ce                	mv	a1,s3
80003126:	02490513          	addi	a0,s2,36
8000312a:	845ff0ef          	jal	ra,8000296e <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
8000312e:	00d9c783          	lbu	a5,13(s3)
80003132:	fbf7f793          	andi	a5,a5,-65
80003136:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
8000313a:	00892503          	lw	a0,8(s2)
8000313e:	41350533          	sub	a0,a0,s3
80003142:	00153513          	seqz	a0,a0
80003146:	969ff0ef          	jal	ra,80002aae <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000314a:	2c048513          	addi	a0,s1,704
8000314e:	08d000ef          	jal	ra,800039da <z_spin_unlock_valid>
80003152:	ed0d                	bnez	a0,8000318c <z_remove_thread_from_ready_q+0xde>
80003154:	800054b7          	lui	s1,0x80005
80003158:	800055b7          	lui	a1,0x80005
8000315c:	80005537          	lui	a0,0x80005
80003160:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003164:	06100693          	li	a3,97
80003168:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000316c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003170:	c4afe0ef          	jal	ra,800015ba <printk>
80003174:	80005537          	lui	a0,0x80005
80003178:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000317c:	c3efe0ef          	jal	ra,800015ba <printk>
80003180:	06100593          	li	a1,97
80003184:	c4048513          	addi	a0,s1,-960
80003188:	c50fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000318c:	30042473          	csrrs	s0,mstatus,s0
}
80003190:	40f2                	lw	ra,28(sp)
80003192:	4462                	lw	s0,24(sp)
80003194:	44d2                	lw	s1,20(sp)
80003196:	4942                	lw	s2,16(sp)
80003198:	49b2                	lw	s3,12(sp)
8000319a:	6105                	addi	sp,sp,32
8000319c:	8082                	ret

8000319e <pend>:
{
8000319e:	1101                	addi	sp,sp,-32
800031a0:	cc22                	sw	s0,24(sp)
800031a2:	ca26                	sw	s1,20(sp)
800031a4:	842a                	mv	s0,a0
800031a6:	c84a                	sw	s2,16(sp)
800031a8:	ce06                	sw	ra,28(sp)
800031aa:	c64e                	sw	s3,12(sp)
800031ac:	84ae                	mv	s1,a1
800031ae:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
800031b0:	3dfd                	jal	800030ae <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
800031b2:	00d44783          	lbu	a5,13(s0)
800031b6:	0027e793          	ori	a5,a5,2
800031ba:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
800031be:	cca9                	beqz	s1,80003218 <pend+0x7a>
	return thread == _idle_thread;
800031c0:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
800031c4:	1e07a783          	lw	a5,480(a5) # 800051e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051e1>
		thread->base.pended_on = wait_q;
800031c8:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
800031ca:	02f41863          	bne	s0,a5,800031fa <pend+0x5c>
800031ce:	800059b7          	lui	s3,0x80005
800031d2:	800055b7          	lui	a1,0x80005
800031d6:	80005537          	lui	a0,0x80005
800031da:	f7c58593          	addi	a1,a1,-132 # 80004f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f7d>
800031de:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800031e2:	27600693          	li	a3,630
800031e6:	ef898613          	addi	a2,s3,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
800031ea:	bd0fe0ef          	jal	ra,800015ba <printk>
800031ee:	27600593          	li	a1,630
800031f2:	ef898513          	addi	a0,s3,-264
800031f6:	be2fe0ef          	jal	ra,800015d8 <assert_post_action>
	return list->head == list;
800031fa:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800031fc:	04f48b63          	beq	s1,a5,80003252 <pend+0xb4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003200:	cba9                	beqz	a5,80003252 <pend+0xb4>
	if (t1->base.prio < t2->base.prio) {
80003202:	00e40703          	lb	a4,14(s0)
80003206:	00e78683          	lb	a3,14(a5)
8000320a:	02d75f63          	bge	a4,a3,80003248 <pend+0xaa>
	node->prev = successor->prev;
8000320e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003210:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80003212:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80003214:	c300                	sw	s0,0(a4)
	successor->prev = node;
80003216:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003218:	57fd                	li	a5,-1
8000321a:	04f90363          	beq	s2,a5,80003260 <pend+0xc2>
8000321e:	45a9                	li	a1,10
80003220:	00990513          	addi	a0,s2,9
80003224:	e1cfd0ef          	jal	ra,80000840 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003228:	00150613          	addi	a2,a0,1
8000322c:	01840513          	addi	a0,s0,24
}
80003230:	4462                	lw	s0,24(sp)
80003232:	40f2                	lw	ra,28(sp)
80003234:	44d2                	lw	s1,20(sp)
80003236:	4942                	lw	s2,16(sp)
80003238:	49b2                	lw	s3,12(sp)
8000323a:	800035b7          	lui	a1,0x80003
8000323e:	de258593          	addi	a1,a1,-542 # 80002de2 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002de3>
80003242:	6105                	addi	sp,sp,32
80003244:	3510006f          	j	80003d94 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003248:	40d4                	lw	a3,4(s1)
8000324a:	00d78463          	beq	a5,a3,80003252 <pend+0xb4>
8000324e:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003250:	fbdd                	bnez	a5,80003206 <pend+0x68>
	node->prev = list->tail;
80003252:	40dc                	lw	a5,4(s1)
	node->next = list;
80003254:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003256:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003258:	40dc                	lw	a5,4(s1)
8000325a:	c380                	sw	s0,0(a5)
	list->tail = node;
8000325c:	c0c0                	sw	s0,4(s1)
8000325e:	bf6d                	j	80003218 <pend+0x7a>
}
80003260:	40f2                	lw	ra,28(sp)
80003262:	4462                	lw	s0,24(sp)
80003264:	44d2                	lw	s1,20(sp)
80003266:	4942                	lw	s2,16(sp)
80003268:	49b2                	lw	s3,12(sp)
8000326a:	6105                	addi	sp,sp,32
8000326c:	8082                	ret

8000326e <z_pend_thread>:
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
8000326e:	800057b7          	lui	a5,0x80005
80003272:	58c7a783          	lw	a5,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
{
80003276:	1101                	addi	sp,sp,-32
80003278:	cc22                	sw	s0,24(sp)
8000327a:	c84a                	sw	s2,16(sp)
8000327c:	c64e                	sw	s3,12(sp)
8000327e:	ce06                	sw	ra,28(sp)
80003280:	ca26                	sw	s1,20(sp)
80003282:	842a                	mv	s0,a0
80003284:	892e                	mv	s2,a1
80003286:	89b2                	mv	s3,a2
	__ASSERT_NO_MSG(thread == _current || is_thread_dummy(thread));
80003288:	02a78c63          	beq	a5,a0,800032c0 <z_pend_thread+0x52>
8000328c:	00d54783          	lbu	a5,13(a0)
80003290:	8b85                	andi	a5,a5,1
80003292:	e79d                	bnez	a5,800032c0 <z_pend_thread+0x52>
80003294:	800054b7          	lui	s1,0x80005
80003298:	800055b7          	lui	a1,0x80005
8000329c:	80005537          	lui	a0,0x80005
800032a0:	f4458593          	addi	a1,a1,-188 # 80004f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f45>
800032a4:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800032a8:	17d00693          	li	a3,381
800032ac:	ef848613          	addi	a2,s1,-264 # 80004ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ef9>
800032b0:	b0afe0ef          	jal	ra,800015ba <printk>
800032b4:	17d00593          	li	a1,381
800032b8:	ef848513          	addi	a0,s1,-264
800032bc:	b1cfe0ef          	jal	ra,800015d8 <assert_post_action>
	pend(thread, wait_q, timeout);
800032c0:	8522                	mv	a0,s0
}
800032c2:	4462                	lw	s0,24(sp)
800032c4:	40f2                	lw	ra,28(sp)
800032c6:	44d2                	lw	s1,20(sp)
	pend(thread, wait_q, timeout);
800032c8:	864e                	mv	a2,s3
800032ca:	85ca                	mv	a1,s2
}
800032cc:	49b2                	lw	s3,12(sp)
800032ce:	4942                	lw	s2,16(sp)
800032d0:	6105                	addi	sp,sp,32
	pend(thread, wait_q, timeout);
800032d2:	b5f1                	j	8000319e <pend>

800032d4 <z_pend_curr>:
{
800032d4:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800032d6:	800057b7          	lui	a5,0x80005
{
800032da:	c422                	sw	s0,8(sp)
800032dc:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
800032de:	58c7a503          	lw	a0,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
{
800032e2:	c226                	sw	s1,4(sp)
800032e4:	84ae                	mv	s1,a1
800032e6:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
800032e8:	8636                	mv	a2,a3
{
800032ea:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
800032ec:	eb3ff0ef          	jal	ra,8000319e <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032f0:	8522                	mv	a0,s0
800032f2:	6e8000ef          	jal	ra,800039da <z_spin_unlock_valid>
800032f6:	ed0d                	bnez	a0,80003330 <z_pend_curr+0x5c>
800032f8:	80005437          	lui	s0,0x80005
800032fc:	800055b7          	lui	a1,0x80005
80003300:	80005537          	lui	a0,0x80005
80003304:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003308:	07800693          	li	a3,120
8000330c:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003310:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003314:	aa6fe0ef          	jal	ra,800015ba <printk>
80003318:	80005537          	lui	a0,0x80005
8000331c:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003320:	a9afe0ef          	jal	ra,800015ba <printk>
80003324:	07800593          	li	a1,120
80003328:	c4040513          	addi	a0,s0,-960
8000332c:	aacfe0ef          	jal	ra,800015d8 <assert_post_action>
}
80003330:	4422                	lw	s0,8(sp)
80003332:	40b2                	lw	ra,12(sp)
80003334:	8526                	mv	a0,s1
80003336:	4492                	lw	s1,4(sp)
80003338:	0141                	addi	sp,sp,16
8000333a:	e87fc06f          	j	800001c0 <__swap>

8000333e <z_unpend_first_thread>:
{
8000333e:	1101                	addi	sp,sp,-32
80003340:	c84a                	sw	s2,16(sp)
80003342:	c64e                	sw	s3,12(sp)
80003344:	ce06                	sw	ra,28(sp)
80003346:	cc22                	sw	s0,24(sp)
80003348:	ca26                	sw	s1,20(sp)
8000334a:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000334c:	4921                	li	s2,8
8000334e:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003352:	800054b7          	lui	s1,0x80005
80003356:	2c048513          	addi	a0,s1,704 # 800052c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000335a:	00897913          	andi	s2,s2,8
8000335e:	258d                	jal	800039c0 <z_spin_lock_valid>
80003360:	ed0d                	bnez	a0,8000339a <z_unpend_first_thread+0x5c>
80003362:	80005437          	lui	s0,0x80005
80003366:	800055b7          	lui	a1,0x80005
8000336a:	80005537          	lui	a0,0x80005
8000336e:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003372:	04e00693          	li	a3,78
80003376:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000337a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000337e:	a3cfe0ef          	jal	ra,800015ba <printk>
80003382:	80005537          	lui	a0,0x80005
80003386:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
8000338a:	a30fe0ef          	jal	ra,800015ba <printk>
8000338e:	04e00593          	li	a1,78
80003392:	c4040513          	addi	a0,s0,-960
80003396:	a42fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000339a:	2c048513          	addi	a0,s1,704
8000339e:	2db9                	jal	800039fc <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800033a0:	854e                	mv	a0,s3
800033a2:	f00ff0ef          	jal	ra,80002aa2 <z_priq_dumb_best>
800033a6:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033a8:	2c048513          	addi	a0,s1,704
800033ac:	253d                	jal	800039da <z_spin_unlock_valid>
800033ae:	ed0d                	bnez	a0,800033e8 <z_unpend_first_thread+0xaa>
800033b0:	800059b7          	lui	s3,0x80005
800033b4:	800055b7          	lui	a1,0x80005
800033b8:	80005537          	lui	a0,0x80005
800033bc:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800033c0:	06100693          	li	a3,97
800033c4:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800033c8:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800033cc:	9eefe0ef          	jal	ra,800015ba <printk>
800033d0:	80005537          	lui	a0,0x80005
800033d4:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800033d8:	9e2fe0ef          	jal	ra,800015ba <printk>
800033dc:	06100593          	li	a1,97
800033e0:	c4098513          	addi	a0,s3,-960
800033e4:	9f4fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800033e8:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
800033ec:	cc4d                	beqz	s0,800034a6 <z_unpend_first_thread+0x168>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033ee:	4921                	li	s2,8
800033f0:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033f4:	2c048513          	addi	a0,s1,704
	key = (mstatus & SOC_MSTATUS_IEN);
800033f8:	00897913          	andi	s2,s2,8
800033fc:	23d1                	jal	800039c0 <z_spin_lock_valid>
800033fe:	ed0d                	bnez	a0,80003438 <z_unpend_first_thread+0xfa>
80003400:	800059b7          	lui	s3,0x80005
80003404:	800055b7          	lui	a1,0x80005
80003408:	80005537          	lui	a0,0x80005
8000340c:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003410:	04e00693          	li	a3,78
80003414:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003418:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000341c:	99efe0ef          	jal	ra,800015ba <printk>
80003420:	80005537          	lui	a0,0x80005
80003424:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003428:	992fe0ef          	jal	ra,800015ba <printk>
8000342c:	04e00593          	li	a1,78
80003430:	c4098513          	addi	a0,s3,-960
80003434:	9a4fe0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003438:	2c048513          	addi	a0,s1,704
8000343c:	23c1                	jal	800039fc <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000343e:	00840513          	addi	a0,s0,8
80003442:	914ff0ef          	jal	ra,80002556 <pended_on.isra.15>
80003446:	85a2                	mv	a1,s0
80003448:	d26ff0ef          	jal	ra,8000296e <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000344c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003450:	2c048513          	addi	a0,s1,704
80003454:	9bf5                	andi	a5,a5,-3
80003456:	00f406a3          	sb	a5,13(s0)
8000345a:	2341                	jal	800039da <z_spin_unlock_valid>
8000345c:	ed0d                	bnez	a0,80003496 <z_unpend_first_thread+0x158>
8000345e:	800054b7          	lui	s1,0x80005
80003462:	800055b7          	lui	a1,0x80005
80003466:	80005537          	lui	a0,0x80005
8000346a:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
8000346e:	06100693          	li	a3,97
80003472:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003476:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000347a:	940fe0ef          	jal	ra,800015ba <printk>
8000347e:	80005537          	lui	a0,0x80005
80003482:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003486:	934fe0ef          	jal	ra,800015ba <printk>
8000348a:	06100593          	li	a1,97
8000348e:	c4048513          	addi	a0,s1,-960
80003492:	946fe0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003496:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
8000349a:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
8000349e:	01840513          	addi	a0,s0,24
800034a2:	2bb000ef          	jal	ra,80003f5c <z_abort_timeout>
}
800034a6:	8522                	mv	a0,s0
800034a8:	40f2                	lw	ra,28(sp)
800034aa:	4462                	lw	s0,24(sp)
800034ac:	44d2                	lw	s1,20(sp)
800034ae:	4942                	lw	s2,16(sp)
800034b0:	49b2                	lw	s3,12(sp)
800034b2:	6105                	addi	sp,sp,32
800034b4:	8082                	ret

800034b6 <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
800034b6:	1141                	addi	sp,sp,-16
800034b8:	c226                	sw	s1,4(sp)
800034ba:	c04a                	sw	s2,0(sp)
800034bc:	c606                	sw	ra,12(sp)
800034be:	c422                	sw	s0,8(sp)
800034c0:	892a                	mv	s2,a0
	int need_sched = 0;
800034c2:	4481                	li	s1,0
	return list->head == list;
800034c4:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800034c8:	00890363          	beq	s2,s0,800034ce <z_unpend_all+0x18>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
800034cc:	e801                	bnez	s0,800034dc <z_unpend_all+0x26>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
800034ce:	40b2                	lw	ra,12(sp)
800034d0:	4422                	lw	s0,8(sp)
800034d2:	8526                	mv	a0,s1
800034d4:	4902                	lw	s2,0(sp)
800034d6:	4492                	lw	s1,4(sp)
800034d8:	0141                	addi	sp,sp,16
800034da:	8082                	ret
		z_unpend_thread(th);
800034dc:	8522                	mv	a0,s0
800034de:	cecff0ef          	jal	ra,800029ca <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
800034e2:	8522                	mv	a0,s0
800034e4:	838ff0ef          	jal	ra,8000251c <z_is_thread_ready>
		need_sched = 1;
800034e8:	4485                	li	s1,1
800034ea:	dd69                	beqz	a0,800034c4 <z_unpend_all+0xe>
		z_add_thread_to_ready_q(thread);
800034ec:	8522                	mv	a0,s0
800034ee:	faaff0ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
800034f2:	bfc9                	j	800034c4 <z_unpend_all+0xe>

800034f4 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
800034f4:	800057b7          	lui	a5,0x80005
800034f8:	58478793          	addi	a5,a5,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
800034fc:	02478713          	addi	a4,a5,36
80003500:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003502:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003504:	4581                	li	a1,0
80003506:	4501                	li	a0,0
80003508:	894ff06f          	j	8000259c <k_sched_time_slice_set>

8000350c <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
8000350c:	800057b7          	lui	a5,0x80005
80003510:	58c7a503          	lw	a0,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
80003514:	8082                	ret

80003516 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003516:	1101                	addi	sp,sp,-32
80003518:	cc22                	sw	s0,24(sp)
8000351a:	ca26                	sw	s1,20(sp)
8000351c:	c84a                	sw	s2,16(sp)
8000351e:	ce06                	sw	ra,28(sp)
80003520:	c64e                	sw	s3,12(sp)
80003522:	842a                	mv	s0,a0
80003524:	892e                	mv	s2,a1
80003526:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003528:	ee0d                	bnez	a2,80003562 <z_impl_k_sem_init+0x4c>
8000352a:	800059b7          	lui	s3,0x80005
8000352e:	800055b7          	lui	a1,0x80005
80003532:	80005537          	lui	a0,0x80005
80003536:	fa058593          	addi	a1,a1,-96 # 80004fa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fa1>
8000353a:	04600693          	li	a3,70
8000353e:	f9098613          	addi	a2,s3,-112 # 80004f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f91>
80003542:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003546:	874fe0ef          	jal	ra,800015ba <printk>
8000354a:	80005537          	lui	a0,0x80005
8000354e:	fac50513          	addi	a0,a0,-84 # 80004fac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fad>
80003552:	868fe0ef          	jal	ra,800015ba <printk>
80003556:	04600593          	li	a1,70
8000355a:	f9098513          	addi	a0,s3,-112
8000355e:	87afe0ef          	jal	ra,800015d8 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003562:	0324fe63          	bgeu	s1,s2,8000359e <z_impl_k_sem_init+0x88>
80003566:	800059b7          	lui	s3,0x80005
8000356a:	800055b7          	lui	a1,0x80005
8000356e:	80005537          	lui	a0,0x80005
80003572:	fc458593          	addi	a1,a1,-60 # 80004fc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fc5>
80003576:	04700693          	li	a3,71
8000357a:	f9098613          	addi	a2,s3,-112 # 80004f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f91>
8000357e:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003582:	838fe0ef          	jal	ra,800015ba <printk>
80003586:	80005537          	lui	a0,0x80005
8000358a:	fdc50513          	addi	a0,a0,-36 # 80004fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fdd>
8000358e:	82cfe0ef          	jal	ra,800015ba <printk>
80003592:	04700593          	li	a1,71
80003596:	f9098513          	addi	a0,s3,-112
8000359a:	83efe0ef          	jal	ra,800015d8 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000359e:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800035a2:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800035a4:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800035a6:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800035a8:	40f2                	lw	ra,28(sp)
800035aa:	4462                	lw	s0,24(sp)
800035ac:	44d2                	lw	s1,20(sp)
800035ae:	4942                	lw	s2,16(sp)
800035b0:	49b2                	lw	s3,12(sp)
800035b2:	6105                	addi	sp,sp,32
800035b4:	8082                	ret

800035b6 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800035b6:	1101                	addi	sp,sp,-32
800035b8:	ca26                	sw	s1,20(sp)
800035ba:	c64e                	sw	s3,12(sp)
800035bc:	ce06                	sw	ra,28(sp)
800035be:	cc22                	sw	s0,24(sp)
800035c0:	c84a                	sw	s2,16(sp)
800035c2:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800035c4:	44a1                	li	s1,8
800035c6:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800035ca:	80005437          	lui	s0,0x80005
800035ce:	2cc40513          	addi	a0,s0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
	key = (mstatus & SOC_MSTATUS_IEN);
800035d2:	88a1                	andi	s1,s1,8
800035d4:	26f5                	jal	800039c0 <z_spin_lock_valid>
800035d6:	ed0d                	bnez	a0,80003610 <z_impl_k_sem_give+0x5a>
800035d8:	80005937          	lui	s2,0x80005
800035dc:	800055b7          	lui	a1,0x80005
800035e0:	80005537          	lui	a0,0x80005
800035e4:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800035e8:	04e00693          	li	a3,78
800035ec:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800035f0:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800035f4:	fc7fd0ef          	jal	ra,800015ba <printk>
800035f8:	80005537          	lui	a0,0x80005
800035fc:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003600:	fbbfd0ef          	jal	ra,800015ba <printk>
80003604:	04e00593          	li	a1,78
80003608:	c4090513          	addi	a0,s2,-960
8000360c:	fcdfd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003610:	2cc40513          	addi	a0,s0,716
80003614:	26e5                	jal	800039fc <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003616:	854e                	mv	a0,s3
80003618:	d27ff0ef          	jal	ra,8000333e <z_unpend_first_thread>
8000361c:	892a                	mv	s2,a0
	if (thread != NULL) {
8000361e:	c515                	beqz	a0,8000364a <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003620:	00d54783          	lbu	a5,13(a0)
80003624:	8bfd                	andi	a5,a5,31
80003626:	e789                	bnez	a5,80003630 <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
80003628:	4d1c                	lw	a5,24(a0)
8000362a:	e399                	bnez	a5,80003630 <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
8000362c:	e6cff0ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
80003630:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003634:	2cc40513          	addi	a0,s0,716
}
80003638:	4462                	lw	s0,24(sp)
8000363a:	40f2                	lw	ra,28(sp)
8000363c:	4942                	lw	s2,16(sp)
8000363e:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003640:	85a6                	mv	a1,s1
}
80003642:	44d2                	lw	s1,20(sp)
80003644:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003646:	908ff06f          	j	8000274e <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
8000364a:	0089a703          	lw	a4,8(s3)
8000364e:	00c9a783          	lw	a5,12(s3)
80003652:	8f99                	sub	a5,a5,a4
80003654:	00f037b3          	snez	a5,a5
80003658:	97ba                	add	a5,a5,a4
8000365a:	00f9a423          	sw	a5,8(s3)
8000365e:	bfd9                	j	80003634 <z_impl_k_sem_give+0x7e>

80003660 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003660:	800057b7          	lui	a5,0x80005
80003664:	5847a783          	lw	a5,1412(a5) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
{
80003668:	1101                	addi	sp,sp,-32
8000366a:	c84a                	sw	s2,16(sp)
8000366c:	c64e                	sw	s3,12(sp)
8000366e:	ce06                	sw	ra,28(sp)
80003670:	cc22                	sw	s0,24(sp)
80003672:	ca26                	sw	s1,20(sp)
80003674:	c452                	sw	s4,8(sp)
80003676:	892a                	mv	s2,a0
80003678:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000367a:	cf95                	beqz	a5,800036b6 <z_impl_k_sem_take+0x56>
8000367c:	cd8d                	beqz	a1,800036b6 <z_impl_k_sem_take+0x56>
8000367e:	80005437          	lui	s0,0x80005
80003682:	800055b7          	lui	a1,0x80005
80003686:	80005537          	lui	a0,0x80005
8000368a:	00458593          	addi	a1,a1,4 # 80005004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005005>
8000368e:	08c00693          	li	a3,140
80003692:	f9040613          	addi	a2,s0,-112 # 80004f90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f91>
80003696:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000369a:	f21fd0ef          	jal	ra,800015ba <printk>
8000369e:	80005537          	lui	a0,0x80005
800036a2:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
800036a6:	f15fd0ef          	jal	ra,800015ba <printk>
800036aa:	08c00593          	li	a1,140
800036ae:	f9040513          	addi	a0,s0,-112
800036b2:	f27fd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800036b6:	4421                	li	s0,8
800036b8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800036bc:	800054b7          	lui	s1,0x80005
800036c0:	2cc48513          	addi	a0,s1,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
	key = (mstatus & SOC_MSTATUS_IEN);
800036c4:	8821                	andi	s0,s0,8
800036c6:	2ced                	jal	800039c0 <z_spin_lock_valid>
800036c8:	ed0d                	bnez	a0,80003702 <z_impl_k_sem_take+0xa2>
800036ca:	80005a37          	lui	s4,0x80005
800036ce:	800055b7          	lui	a1,0x80005
800036d2:	80005537          	lui	a0,0x80005
800036d6:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800036da:	04e00693          	li	a3,78
800036de:	c40a0613          	addi	a2,s4,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800036e2:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800036e6:	ed5fd0ef          	jal	ra,800015ba <printk>
800036ea:	80005537          	lui	a0,0x80005
800036ee:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
800036f2:	ec9fd0ef          	jal	ra,800015ba <printk>
800036f6:	04e00593          	li	a1,78
800036fa:	c40a0513          	addi	a0,s4,-960
800036fe:	edbfd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003702:	2cc48513          	addi	a0,s1,716
80003706:	2cdd                	jal	800039fc <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80003708:	00892783          	lw	a5,8(s2)
8000370c:	cfb9                	beqz	a5,8000376a <z_impl_k_sem_take+0x10a>
		sem->count--;
8000370e:	17fd                	addi	a5,a5,-1
80003710:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003714:	2cc48513          	addi	a0,s1,716
80003718:	24c9                	jal	800039da <z_spin_unlock_valid>
8000371a:	ed0d                	bnez	a0,80003754 <z_impl_k_sem_take+0xf4>
8000371c:	800054b7          	lui	s1,0x80005
80003720:	800055b7          	lui	a1,0x80005
80003724:	80005537          	lui	a0,0x80005
80003728:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
8000372c:	06100693          	li	a3,97
80003730:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003734:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003738:	e83fd0ef          	jal	ra,800015ba <printk>
8000373c:	80005537          	lui	a0,0x80005
80003740:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003744:	e77fd0ef          	jal	ra,800015ba <printk>
80003748:	06100593          	li	a1,97
8000374c:	c4048513          	addi	a0,s1,-960
80003750:	e89fd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003754:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003758:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
8000375a:	40f2                	lw	ra,28(sp)
8000375c:	4462                	lw	s0,24(sp)
8000375e:	44d2                	lw	s1,20(sp)
80003760:	4942                	lw	s2,16(sp)
80003762:	49b2                	lw	s3,12(sp)
80003764:	4a22                	lw	s4,8(sp)
80003766:	6105                	addi	sp,sp,32
80003768:	8082                	ret
	if (timeout == K_NO_WAIT) {
8000376a:	04099663          	bnez	s3,800037b6 <z_impl_k_sem_take+0x156>
8000376e:	2cc48513          	addi	a0,s1,716
80003772:	24a5                	jal	800039da <z_spin_unlock_valid>
80003774:	ed0d                	bnez	a0,800037ae <z_impl_k_sem_take+0x14e>
80003776:	800054b7          	lui	s1,0x80005
8000377a:	800055b7          	lui	a1,0x80005
8000377e:	80005537          	lui	a0,0x80005
80003782:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003786:	06100693          	li	a3,97
8000378a:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000378e:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003792:	e29fd0ef          	jal	ra,800015ba <printk>
80003796:	80005537          	lui	a0,0x80005
8000379a:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
8000379e:	e1dfd0ef          	jal	ra,800015ba <printk>
800037a2:	06100593          	li	a1,97
800037a6:	c4048513          	addi	a0,s1,-960
800037aa:	e2ffd0ef          	jal	ra,800015d8 <assert_post_action>
800037ae:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800037b2:	5541                	li	a0,-16
800037b4:	b75d                	j	8000375a <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800037b6:	85a2                	mv	a1,s0
}
800037b8:	4462                	lw	s0,24(sp)
800037ba:	40f2                	lw	ra,28(sp)
800037bc:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800037be:	86ce                	mv	a3,s3
800037c0:	864a                	mv	a2,s2
}
800037c2:	49b2                	lw	s3,12(sp)
800037c4:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800037c6:	2cc48513          	addi	a0,s1,716
}
800037ca:	44d2                	lw	s1,20(sp)
800037cc:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800037ce:	b07ff06f          	j	800032d4 <z_pend_curr>

800037d2 <z_impl_k_stack_push>:
void z_impl_k_stack_push(struct k_stack *stack, u32_t data)
{
	struct k_thread *first_pending_thread;
	k_spinlock_key_t key;

	__ASSERT(stack->next != stack->top, "stack is full");
800037d2:	4918                	lw	a4,16(a0)
800037d4:	495c                	lw	a5,20(a0)
{
800037d6:	1101                	addi	sp,sp,-32
800037d8:	ca26                	sw	s1,20(sp)
800037da:	c452                	sw	s4,8(sp)
800037dc:	ce06                	sw	ra,28(sp)
800037de:	cc22                	sw	s0,24(sp)
800037e0:	c84a                	sw	s2,16(sp)
800037e2:	c64e                	sw	s3,12(sp)
800037e4:	84aa                	mv	s1,a0
800037e6:	8a2e                	mv	s4,a1
	__ASSERT(stack->next != stack->top, "stack is full");
800037e8:	02f71e63          	bne	a4,a5,80003824 <z_impl_k_stack_push+0x52>
800037ec:	80005437          	lui	s0,0x80005
800037f0:	800055b7          	lui	a1,0x80005
800037f4:	80005537          	lui	a0,0x80005
800037f8:	07858593          	addi	a1,a1,120 # 80005078 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005079>
800037fc:	06800693          	li	a3,104
80003800:	03840613          	addi	a2,s0,56 # 80005038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005039>
80003804:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003808:	db3fd0ef          	jal	ra,800015ba <printk>
8000380c:	80005537          	lui	a0,0x80005
80003810:	09450513          	addi	a0,a0,148 # 80005094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005095>
80003814:	da7fd0ef          	jal	ra,800015ba <printk>
80003818:	06800593          	li	a1,104
8000381c:	03840513          	addi	a0,s0,56
80003820:	db9fd0ef          	jal	ra,800015d8 <assert_post_action>

	key = k_spin_lock(&stack->lock);
80003824:	00848993          	addi	s3,s1,8
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003828:	4421                	li	s0,8
8000382a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000382e:	854e                	mv	a0,s3
	key = (mstatus & SOC_MSTATUS_IEN);
80003830:	8821                	andi	s0,s0,8
80003832:	2279                	jal	800039c0 <z_spin_lock_valid>
80003834:	ed0d                	bnez	a0,8000386e <z_impl_k_stack_push+0x9c>
80003836:	80005937          	lui	s2,0x80005
8000383a:	800055b7          	lui	a1,0x80005
8000383e:	80005537          	lui	a0,0x80005
80003842:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003846:	04e00693          	li	a3,78
8000384a:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000384e:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003852:	d69fd0ef          	jal	ra,800015ba <printk>
80003856:	80005537          	lui	a0,0x80005
8000385a:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
8000385e:	d5dfd0ef          	jal	ra,800015ba <printk>
80003862:	04e00593          	li	a1,78
80003866:	c4090513          	addi	a0,s2,-960
8000386a:	d6ffd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000386e:	854e                	mv	a0,s3
80003870:	2271                	jal	800039fc <z_spin_lock_set_owner>

	first_pending_thread = z_unpend_first_thread(&stack->wait_q);
80003872:	8526                	mv	a0,s1
80003874:	acbff0ef          	jal	ra,8000333e <z_unpend_first_thread>
80003878:	892a                	mv	s2,a0

	if (first_pending_thread != NULL) {
8000387a:	c905                	beqz	a0,800038aa <z_impl_k_stack_push+0xd8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000387c:	00d54783          	lbu	a5,13(a0)
80003880:	8bfd                	andi	a5,a5,31
80003882:	e789                	bnez	a5,8000388c <z_impl_k_stack_push+0xba>
	if (z_is_thread_ready(thread)) {
80003884:	4d1c                	lw	a5,24(a0)
80003886:	e399                	bnez	a5,8000388c <z_impl_k_stack_push+0xba>
		z_add_thread_to_ready_q(thread);
80003888:	c10ff0ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
		z_ready_thread(first_pending_thread);

		z_set_thread_return_value_with_data(first_pending_thread,
						   0, (void *)data);
		z_reschedule(&stack->lock, key);
8000388c:	85a2                	mv	a1,s0
		*(stack->next) = data;
		stack->next++;
		k_spin_unlock(&stack->lock, key);
	}

}
8000388e:	4462                	lw	s0,24(sp)
	thread->base.swap_data = data;
80003890:	01492a23          	sw	s4,20(s2)
80003894:	06092623          	sw	zero,108(s2)
80003898:	40f2                	lw	ra,28(sp)
8000389a:	44d2                	lw	s1,20(sp)
8000389c:	4942                	lw	s2,16(sp)
8000389e:	4a22                	lw	s4,8(sp)
		z_reschedule(&stack->lock, key);
800038a0:	854e                	mv	a0,s3
}
800038a2:	49b2                	lw	s3,12(sp)
800038a4:	6105                	addi	sp,sp,32
		z_reschedule(&stack->lock, key);
800038a6:	ea9fe06f          	j	8000274e <z_reschedule>
		*(stack->next) = data;
800038aa:	489c                	lw	a5,16(s1)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800038ac:	854e                	mv	a0,s3
800038ae:	0147a023          	sw	s4,0(a5)
		stack->next++;
800038b2:	0791                	addi	a5,a5,4
800038b4:	c89c                	sw	a5,16(s1)
800038b6:	2215                	jal	800039da <z_spin_unlock_valid>
800038b8:	ed0d                	bnez	a0,800038f2 <z_impl_k_stack_push+0x120>
800038ba:	800054b7          	lui	s1,0x80005
800038be:	800055b7          	lui	a1,0x80005
800038c2:	80005537          	lui	a0,0x80005
800038c6:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800038ca:	06100693          	li	a3,97
800038ce:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800038d2:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800038d6:	ce5fd0ef          	jal	ra,800015ba <printk>
800038da:	80005537          	lui	a0,0x80005
800038de:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800038e2:	cd9fd0ef          	jal	ra,800015ba <printk>
800038e6:	06100593          	li	a1,97
800038ea:	c4048513          	addi	a0,s1,-960
800038ee:	cebfd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800038f2:	30042473          	csrrs	s0,mstatus,s0
}
800038f6:	40f2                	lw	ra,28(sp)
800038f8:	4462                	lw	s0,24(sp)
800038fa:	44d2                	lw	s1,20(sp)
800038fc:	4942                	lw	s2,16(sp)
800038fe:	49b2                	lw	s3,12(sp)
80003900:	4a22                	lw	s4,8(sp)
80003902:	6105                	addi	sp,sp,32
80003904:	8082                	ret

80003906 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003906:	00d54783          	lbu	a5,13(a0)
8000390a:	8bfd                	andi	a5,a5,31
8000390c:	e789                	bnez	a5,80003916 <z_is_thread_ready+0x10>
8000390e:	4d08                	lw	a0,24(a0)
80003910:	00153513          	seqz	a0,a0
80003914:	8082                	ret
80003916:	4501                	li	a0,0
}
80003918:	8082                	ret

8000391a <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
8000391a:	800057b7          	lui	a5,0x80005
8000391e:	5847a503          	lw	a0,1412(a5) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
}
80003922:	00a03533          	snez	a0,a0
80003926:	8082                	ret

80003928 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80003928:	800057b7          	lui	a5,0x80005
8000392c:	58c7a783          	lw	a5,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
80003930:	00c7c503          	lbu	a0,12(a5)
}
80003934:	8905                	andi	a0,a0,1
80003936:	8082                	ret

80003938 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80003938:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000393a:	5302                	lw	t1,32(sp)
{
8000393c:	cc22                	sw	s0,24(sp)
8000393e:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003940:	c01a                	sw	t1,0(sp)
{
80003942:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003944:	c04fd0ef          	jal	ra,80000d48 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80003948:	800057b7          	lui	a5,0x80005
8000394c:	58c7a783          	lw	a5,1420(a5) # 8000558c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000558d>
	sys_trace_thread_create(new_thread);
}
80003950:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80003952:	57bc                	lw	a5,104(a5)
80003954:	d43c                	sw	a5,104(s0)
}
80003956:	4462                	lw	s0,24(sp)
80003958:	6105                	addi	sp,sp,32
8000395a:	8082                	ret

8000395c <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
8000395c:	513c                	lw	a5,96(a0)
{
8000395e:	1141                	addi	sp,sp,-16
80003960:	c422                	sw	s0,8(sp)
80003962:	c606                	sw	ra,12(sp)
80003964:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003966:	c391                	beqz	a5,8000396a <z_thread_single_abort+0xe>
		thread->fn_abort();
80003968:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
8000396a:	8522                	mv	a0,s0
8000396c:	f9bff0ef          	jal	ra,80003906 <z_is_thread_ready>
80003970:	cd11                	beqz	a0,8000398c <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
80003972:	8522                	mv	a0,s0
80003974:	f3aff0ef          	jal	ra,800030ae <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003978:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
8000397c:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
8000397e:	0087e793          	ori	a5,a5,8
80003982:	00f406a3          	sb	a5,13(s0)
}
80003986:	4422                	lw	s0,8(sp)
80003988:	0141                	addi	sp,sp,16
8000398a:	8082                	ret
		if (z_is_thread_pending(thread)) {
8000398c:	00d44783          	lbu	a5,13(s0)
80003990:	8b89                	andi	a5,a5,2
80003992:	c781                	beqz	a5,8000399a <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
80003994:	8522                	mv	a0,s0
80003996:	ce9fe0ef          	jal	ra,8000267e <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
8000399a:	4c1c                	lw	a5,24(s0)
8000399c:	dff1                	beqz	a5,80003978 <z_thread_single_abort+0x1c>
8000399e:	01840513          	addi	a0,s0,24
800039a2:	2b6d                	jal	80003f5c <z_abort_timeout>
800039a4:	bfd1                	j	80003978 <z_thread_single_abort+0x1c>

800039a6 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800039a6:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800039aa:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800039ae:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800039b2:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800039b6:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800039ba:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800039be:	8082                	ret

800039c0 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800039c0:	4108                	lw	a0,0(a0)
800039c2:	c911                	beqz	a0,800039d6 <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800039c4:	800057b7          	lui	a5,0x80005
800039c8:	5987c783          	lbu	a5,1432(a5) # 80005598 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005599>
800039cc:	890d                	andi	a0,a0,3
800039ce:	8d1d                	sub	a0,a0,a5
800039d0:	00a03533          	snez	a0,a0
800039d4:	8082                	ret
			return false;
		}
	}
	return true;
800039d6:	4505                	li	a0,1
}
800039d8:	8082                	ret

800039da <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800039da:	800057b7          	lui	a5,0x80005
800039de:	58478793          	addi	a5,a5,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
800039e2:	0147c703          	lbu	a4,20(a5)
800039e6:	479c                	lw	a5,8(a5)
800039e8:	8fd9                	or	a5,a5,a4
800039ea:	4118                	lw	a4,0(a0)
800039ec:	00f71663          	bne	a4,a5,800039f8 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
800039f0:	00052023          	sw	zero,0(a0)
	return true;
800039f4:	4505                	li	a0,1
800039f6:	8082                	ret
		return false;
800039f8:	4501                	li	a0,0
}
800039fa:	8082                	ret

800039fc <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800039fc:	800057b7          	lui	a5,0x80005
80003a00:	58478793          	addi	a5,a5,1412 # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
80003a04:	0147c703          	lbu	a4,20(a5)
80003a08:	479c                	lw	a5,8(a5)
80003a0a:	8fd9                	or	a5,a5,a4
80003a0c:	c11c                	sw	a5,0(a0)
}
80003a0e:	8082                	ret

80003a10 <z_impl_k_thread_start>:
{
80003a10:	1101                	addi	sp,sp,-32
80003a12:	cc22                	sw	s0,24(sp)
80003a14:	c84a                	sw	s2,16(sp)
80003a16:	ce06                	sw	ra,28(sp)
80003a18:	ca26                	sw	s1,20(sp)
80003a1a:	c64e                	sw	s3,12(sp)
80003a1c:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003a1e:	4421                	li	s0,8
80003a20:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003a24:	800054b7          	lui	s1,0x80005
80003a28:	2d048513          	addi	a0,s1,720 # 800052d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003a2c:	8821                	andi	s0,s0,8
80003a2e:	f93ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80003a32:	ed0d                	bnez	a0,80003a6c <z_impl_k_thread_start+0x5c>
80003a34:	800059b7          	lui	s3,0x80005
80003a38:	800055b7          	lui	a1,0x80005
80003a3c:	80005537          	lui	a0,0x80005
80003a40:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003a44:	04e00693          	li	a3,78
80003a48:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003a4c:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003a50:	b6bfd0ef          	jal	ra,800015ba <printk>
80003a54:	80005537          	lui	a0,0x80005
80003a58:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003a5c:	b5ffd0ef          	jal	ra,800015ba <printk>
80003a60:	04e00593          	li	a1,78
80003a64:	c4098513          	addi	a0,s3,-960
80003a68:	b71fd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003a6c:	2d048513          	addi	a0,s1,720
80003a70:	f8dff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80003a74:	00d94783          	lbu	a5,13(s2)
80003a78:	0047f713          	andi	a4,a5,4
80003a7c:	eb39                	bnez	a4,80003ad2 <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a7e:	2d048513          	addi	a0,s1,720
80003a82:	f59ff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80003a86:	ed0d                	bnez	a0,80003ac0 <z_impl_k_thread_start+0xb0>
80003a88:	800054b7          	lui	s1,0x80005
80003a8c:	800055b7          	lui	a1,0x80005
80003a90:	80005537          	lui	a0,0x80005
80003a94:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003a98:	06100693          	li	a3,97
80003a9c:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003aa0:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003aa4:	b17fd0ef          	jal	ra,800015ba <printk>
80003aa8:	80005537          	lui	a0,0x80005
80003aac:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003ab0:	b0bfd0ef          	jal	ra,800015ba <printk>
80003ab4:	06100593          	li	a1,97
80003ab8:	c4048513          	addi	a0,s1,-960
80003abc:	b1dfd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003ac0:	30042473          	csrrs	s0,mstatus,s0
}
80003ac4:	40f2                	lw	ra,28(sp)
80003ac6:	4462                	lw	s0,24(sp)
80003ac8:	44d2                	lw	s1,20(sp)
80003aca:	4942                	lw	s2,16(sp)
80003acc:	49b2                	lw	s3,12(sp)
80003ace:	6105                	addi	sp,sp,32
80003ad0:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003ad2:	9bed                	andi	a5,a5,-5
80003ad4:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80003ad8:	854a                	mv	a0,s2
80003ada:	e2dff0ef          	jal	ra,80003906 <z_is_thread_ready>
80003ade:	c501                	beqz	a0,80003ae6 <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
80003ae0:	854a                	mv	a0,s2
80003ae2:	9b6ff0ef          	jal	ra,80002c98 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80003ae6:	85a2                	mv	a1,s0
}
80003ae8:	4462                	lw	s0,24(sp)
80003aea:	40f2                	lw	ra,28(sp)
80003aec:	4942                	lw	s2,16(sp)
80003aee:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003af0:	2d048513          	addi	a0,s1,720
}
80003af4:	44d2                	lw	s1,20(sp)
80003af6:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003af8:	c57fe06f          	j	8000274e <z_reschedule>

80003afc <schedule_new_thread>:
	if (delay == 0) {
80003afc:	e199                	bnez	a1,80003b02 <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80003afe:	f13ff06f          	j	80003a10 <z_impl_k_thread_start>
{
80003b02:	1141                	addi	sp,sp,-16
80003b04:	c422                	sw	s0,8(sp)
80003b06:	842a                	mv	s0,a0
80003b08:	852e                	mv	a0,a1
80003b0a:	0525                	addi	a0,a0,9
80003b0c:	45a9                	li	a1,10
80003b0e:	c606                	sw	ra,12(sp)
80003b10:	d31fc0ef          	jal	ra,80000840 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003b14:	00150613          	addi	a2,a0,1
80003b18:	01840513          	addi	a0,s0,24
}
80003b1c:	4422                	lw	s0,8(sp)
80003b1e:	40b2                	lw	ra,12(sp)
80003b20:	800035b7          	lui	a1,0x80003
80003b24:	de258593          	addi	a1,a1,-542 # 80002de2 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002de3>
80003b28:	0141                	addi	sp,sp,16
80003b2a:	a4ad                	j	80003d94 <z_add_timeout>

80003b2c <z_impl_k_thread_create>:
{
80003b2c:	7139                	addi	sp,sp,-64
80003b2e:	d256                	sw	s5,36(sp)
80003b30:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003b32:	800056b7          	lui	a3,0x80005
80003b36:	5846a683          	lw	a3,1412(a3) # 80005584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005585>
{
80003b3a:	dc22                	sw	s0,56(sp)
80003b3c:	da26                	sw	s1,52(sp)
80003b3e:	d64e                	sw	s3,44(sp)
80003b40:	d452                	sw	s4,40(sp)
80003b42:	de06                	sw	ra,60(sp)
80003b44:	d84a                	sw	s2,48(sp)
80003b46:	842a                	mv	s0,a0
80003b48:	89ae                	mv	s3,a1
80003b4a:	8a32                	mv	s4,a2
80003b4c:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003b4e:	c6a9                	beqz	a3,80003b98 <z_impl_k_thread_create+0x6c>
80003b50:	80005937          	lui	s2,0x80005
80003b54:	800055b7          	lui	a1,0x80005
80003b58:	80005537          	lui	a0,0x80005
80003b5c:	1b200693          	li	a3,434
80003b60:	0a490613          	addi	a2,s2,164 # 800050a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050a5>
80003b64:	e9058593          	addi	a1,a1,-368 # 80004e90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e91>
80003b68:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003b6c:	ce46                	sw	a7,28(sp)
80003b6e:	cc42                	sw	a6,24(sp)
80003b70:	ca3e                	sw	a5,20(sp)
80003b72:	c83a                	sw	a4,16(sp)
80003b74:	a47fd0ef          	jal	ra,800015ba <printk>
80003b78:	80005537          	lui	a0,0x80005
80003b7c:	0b850513          	addi	a0,a0,184 # 800050b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b9>
80003b80:	a3bfd0ef          	jal	ra,800015ba <printk>
80003b84:	1b200593          	li	a1,434
80003b88:	0a490513          	addi	a0,s2,164
80003b8c:	a4dfd0ef          	jal	ra,800015d8 <assert_post_action>
80003b90:	48f2                	lw	a7,28(sp)
80003b92:	4862                	lw	a6,24(sp)
80003b94:	47d2                	lw	a5,20(sp)
80003b96:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003b98:	4686                	lw	a3,64(sp)
80003b9a:	c202                	sw	zero,4(sp)
80003b9c:	8652                	mv	a2,s4
80003b9e:	c036                	sw	a3,0(sp)
80003ba0:	85ce                	mv	a1,s3
80003ba2:	86d6                	mv	a3,s5
80003ba4:	8522                	mv	a0,s0
80003ba6:	d93ff0ef          	jal	ra,80003938 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80003baa:	57fd                	li	a5,-1
80003bac:	00f48663          	beq	s1,a5,80003bb8 <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
80003bb0:	85a6                	mv	a1,s1
80003bb2:	8522                	mv	a0,s0
80003bb4:	f49ff0ef          	jal	ra,80003afc <schedule_new_thread>
}
80003bb8:	8522                	mv	a0,s0
80003bba:	50f2                	lw	ra,60(sp)
80003bbc:	5462                	lw	s0,56(sp)
80003bbe:	54d2                	lw	s1,52(sp)
80003bc0:	5942                	lw	s2,48(sp)
80003bc2:	59b2                	lw	s3,44(sp)
80003bc4:	5a22                	lw	s4,40(sp)
80003bc6:	5a92                	lw	s5,36(sp)
80003bc8:	6121                	addi	sp,sp,64
80003bca:	8082                	ret

80003bcc <z_init_static_threads>:
{
80003bcc:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80003bce:	800057b7          	lui	a5,0x80005
{
80003bd2:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003bd4:	80005937          	lui	s2,0x80005
{
80003bd8:	cc22                	sw	s0,24(sp)
80003bda:	ca26                	sw	s1,20(sp)
80003bdc:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80003bde:	22078413          	addi	s0,a5,544 # 80005220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005221>
80003be2:	22078493          	addi	s1,a5,544
80003be6:	22090913          	addi	s2,s2,544 # 80005220 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005221>
80003bea:	01246f63          	bltu	s0,s2,80003c08 <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
80003bee:	8426                	mv	s0,s1
	k_sched_lock();
80003bf0:	c2ffe0ef          	jal	ra,8000281e <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80003bf4:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80003bf6:	03246e63          	bltu	s0,s2,80003c32 <z_init_static_threads+0x66>
}
80003bfa:	4462                	lw	s0,24(sp)
80003bfc:	40f2                	lw	ra,28(sp)
80003bfe:	44d2                	lw	s1,20(sp)
80003c00:	4942                	lw	s2,16(sp)
80003c02:	6105                	addi	sp,sp,32
	k_sched_unlock();
80003c04:	f41fe06f          	j	80002b44 <k_sched_unlock>
		z_setup_new_thread(
80003c08:	545c                	lw	a5,44(s0)
80003c0a:	c23e                	sw	a5,4(sp)
80003c0c:	501c                	lw	a5,32(s0)
80003c0e:	c03e                	sw	a5,0(sp)
80003c10:	485c                	lw	a5,20(s0)
80003c12:	01c42883          	lw	a7,28(s0)
80003c16:	01842803          	lw	a6,24(s0)
80003c1a:	4818                	lw	a4,16(s0)
80003c1c:	4454                	lw	a3,12(s0)
80003c1e:	4410                	lw	a2,8(s0)
80003c20:	404c                	lw	a1,4(s0)
80003c22:	4008                	lw	a0,0(s0)
80003c24:	d15ff0ef          	jal	ra,80003938 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80003c28:	401c                	lw	a5,0(s0)
80003c2a:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80003c2c:	03040413          	addi	s0,s0,48
80003c30:	bf6d                	j	80003bea <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
80003c32:	504c                	lw	a1,36(s0)
80003c34:	00958563          	beq	a1,s1,80003c3e <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
80003c38:	4008                	lw	a0,0(s0)
80003c3a:	ec3ff0ef          	jal	ra,80003afc <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80003c3e:	03040413          	addi	s0,s0,48
80003c42:	bf55                	j	80003bf6 <z_init_static_threads+0x2a>

80003c44 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
80003c44:	1101                	addi	sp,sp,-32
80003c46:	cc22                	sw	s0,24(sp)
80003c48:	ca26                	sw	s1,20(sp)
80003c4a:	ce06                	sw	ra,28(sp)
80003c4c:	c84a                	sw	s2,16(sp)
80003c4e:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80003c50:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c52:	4421                	li	s0,8
80003c54:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c58:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003c5a:	8821                	andi	s0,s0,8
80003c5c:	d65ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80003c60:	ed0d                	bnez	a0,80003c9a <z_impl_k_thread_abort+0x56>
80003c62:	80005937          	lui	s2,0x80005
80003c66:	800055b7          	lui	a1,0x80005
80003c6a:	80005537          	lui	a0,0x80005
80003c6e:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003c72:	04e00693          	li	a3,78
80003c76:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003c7a:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003c7e:	93dfd0ef          	jal	ra,800015ba <printk>
80003c82:	80005537          	lui	a0,0x80005
80003c86:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003c8a:	931fd0ef          	jal	ra,800015ba <printk>
80003c8e:	04e00593          	li	a1,78
80003c92:	c4090513          	addi	a0,s2,-960
80003c96:	943fd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c9a:	0068                	addi	a0,sp,12
80003c9c:	d61ff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80003ca0:	00c4c783          	lbu	a5,12(s1)
80003ca4:	8b85                	andi	a5,a5,1
80003ca6:	cf8d                	beqz	a5,80003ce0 <z_impl_k_thread_abort+0x9c>
80003ca8:	80005937          	lui	s2,0x80005
80003cac:	800055b7          	lui	a1,0x80005
80003cb0:	80005537          	lui	a0,0x80005
80003cb4:	0f858593          	addi	a1,a1,248 # 800050f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050f9>
80003cb8:	02900693          	li	a3,41
80003cbc:	0e090613          	addi	a2,s2,224 # 800050e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e1>
80003cc0:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003cc4:	8f7fd0ef          	jal	ra,800015ba <printk>
80003cc8:	80005537          	lui	a0,0x80005
80003ccc:	12c50513          	addi	a0,a0,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
80003cd0:	8ebfd0ef          	jal	ra,800015ba <printk>
80003cd4:	02900593          	li	a1,41
80003cd8:	0e090513          	addi	a0,s2,224
80003cdc:	8fdfd0ef          	jal	ra,800015d8 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80003ce0:	8526                	mv	a0,s1
80003ce2:	c7bff0ef          	jal	ra,8000395c <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
80003ce6:	85a2                	mv	a1,s0
80003ce8:	0068                	addi	a0,sp,12
80003cea:	a65fe0ef          	jal	ra,8000274e <z_reschedule>
}
80003cee:	40f2                	lw	ra,28(sp)
80003cf0:	4462                	lw	s0,24(sp)
80003cf2:	44d2                	lw	s1,20(sp)
80003cf4:	4942                	lw	s2,16(sp)
80003cf6:	6105                	addi	sp,sp,32
80003cf8:	8082                	ret

80003cfa <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80003cfa:	800057b7          	lui	a5,0x80005
80003cfe:	2d47a783          	lw	a5,724(a5) # 800052d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d5>
80003d02:	e399                	bnez	a5,80003d08 <elapsed+0xe>
80003d04:	c31fd06f          	j	80001934 <z_clock_elapsed>
}
80003d08:	4501                	li	a0,0
80003d0a:	8082                	ret

80003d0c <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80003d0c:	411c                	lw	a5,0(a0)
80003d0e:	cd01                	beqz	a0,80003d26 <remove_timeout+0x1a>
80003d10:	80005737          	lui	a4,0x80005
	return (node == list->tail) ? NULL : node->next;
80003d14:	1d872703          	lw	a4,472(a4) # 800051d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051d9>
80003d18:	00e50763          	beq	a0,a4,80003d26 <remove_timeout+0x1a>
	if (next(t) != NULL) {
80003d1c:	c789                	beqz	a5,80003d26 <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
80003d1e:	4798                	lw	a4,8(a5)
80003d20:	4514                	lw	a3,8(a0)
80003d22:	9736                	add	a4,a4,a3
80003d24:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
80003d26:	4158                	lw	a4,4(a0)
80003d28:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003d2a:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003d2c:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80003d30:	00052223          	sw	zero,4(a0)
}
80003d34:	8082                	ret

80003d36 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003d36:	800057b7          	lui	a5,0x80005
80003d3a:	2dc7c783          	lbu	a5,732(a5) # 800052dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052dd>
{
80003d3e:	1141                	addi	sp,sp,-16
80003d40:	c606                	sw	ra,12(sp)
80003d42:	c422                	sw	s0,8(sp)
80003d44:	c226                	sw	s1,4(sp)
80003d46:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003d48:	e789                	bnez	a5,80003d52 <next_timeout+0x1c>
80003d4a:	80000537          	lui	a0,0x80000
80003d4e:	fff54513          	not	a0,a0
	return list->head == list;
80003d52:	800057b7          	lui	a5,0x80005
80003d56:	1d478793          	addi	a5,a5,468 # 800051d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051d5>
80003d5a:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003d5c:	00f40f63          	beq	s0,a5,80003d7a <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80003d60:	cc09                	beqz	s0,80003d7a <next_timeout+0x44>
80003d62:	4404                	lw	s1,8(s0)
80003d64:	f97ff0ef          	jal	ra,80003cfa <elapsed>
80003d68:	8c89                	sub	s1,s1,a0
80003d6a:	4501                	li	a0,0
80003d6c:	0004c763          	bltz	s1,80003d7a <next_timeout+0x44>
80003d70:	4400                	lw	s0,8(s0)
80003d72:	f89ff0ef          	jal	ra,80003cfa <elapsed>
80003d76:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80003d7a:	800057b7          	lui	a5,0x80005
80003d7e:	5947a783          	lw	a5,1428(a5) # 80005594 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005595>
80003d82:	c781                	beqz	a5,80003d8a <next_timeout+0x54>
80003d84:	00a7d363          	bge	a5,a0,80003d8a <next_timeout+0x54>
80003d88:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80003d8a:	40b2                	lw	ra,12(sp)
80003d8c:	4422                	lw	s0,8(sp)
80003d8e:	4492                	lw	s1,4(sp)
80003d90:	0141                	addi	sp,sp,16
80003d92:	8082                	ret

80003d94 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003d94:	411c                	lw	a5,0(a0)
{
80003d96:	7179                	addi	sp,sp,-48
80003d98:	d422                	sw	s0,40(sp)
80003d9a:	d226                	sw	s1,36(sp)
80003d9c:	ce4e                	sw	s3,28(sp)
80003d9e:	d606                	sw	ra,44(sp)
80003da0:	d04a                	sw	s2,32(sp)
80003da2:	cc52                	sw	s4,24(sp)
80003da4:	ca56                	sw	s5,20(sp)
80003da6:	c85a                	sw	s6,16(sp)
80003da8:	c65e                	sw	s7,12(sp)
80003daa:	c462                	sw	s8,8(sp)
80003dac:	842a                	mv	s0,a0
80003dae:	89ae                	mv	s3,a1
80003db0:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003db2:	cf8d                	beqz	a5,80003dec <z_add_timeout+0x58>
80003db4:	80005937          	lui	s2,0x80005
80003db8:	800055b7          	lui	a1,0x80005
80003dbc:	80005537          	lui	a0,0x80005
80003dc0:	15c58593          	addi	a1,a1,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
80003dc4:	04d00693          	li	a3,77
80003dc8:	14890613          	addi	a2,s2,328 # 80005148 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005149>
80003dcc:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003dd0:	feafd0ef          	jal	ra,800015ba <printk>
80003dd4:	80005537          	lui	a0,0x80005
80003dd8:	bf850513          	addi	a0,a0,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80003ddc:	fdefd0ef          	jal	ra,800015ba <printk>
80003de0:	04d00593          	li	a1,77
80003de4:	14890513          	addi	a0,s2,328
80003de8:	ff0fd0ef          	jal	ra,800015d8 <assert_post_action>
	to->fn = fn;
80003dec:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80003df0:	00904363          	bgtz	s1,80003df6 <z_add_timeout+0x62>
80003df4:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003df6:	49a1                	li	s3,8
80003df8:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003dfc:	80005a37          	lui	s4,0x80005
80003e00:	2d8a0513          	addi	a0,s4,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e04:	0089f993          	andi	s3,s3,8
80003e08:	bb9ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80003e0c:	ed0d                	bnez	a0,80003e46 <z_add_timeout+0xb2>
80003e0e:	80005937          	lui	s2,0x80005
80003e12:	800055b7          	lui	a1,0x80005
80003e16:	80005537          	lui	a0,0x80005
80003e1a:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003e1e:	04e00693          	li	a3,78
80003e22:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003e26:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003e2a:	f90fd0ef          	jal	ra,800015ba <printk>
80003e2e:	80005537          	lui	a0,0x80005
80003e32:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003e36:	f84fd0ef          	jal	ra,800015ba <printk>
80003e3a:	04e00593          	li	a1,78
80003e3e:	c4090513          	addi	a0,s2,-960
80003e42:	f96fd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e46:	2d8a0513          	addi	a0,s4,728
80003e4a:	bb3ff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80003e4e:	eadff0ef          	jal	ra,80003cfa <elapsed>
80003e52:	9526                	add	a0,a0,s1
	return list->head == list;
80003e54:	800054b7          	lui	s1,0x80005
80003e58:	1d44a903          	lw	s2,468(s1) # 800051d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051d5>
80003e5c:	c408                	sw	a0,8(s0)
80003e5e:	1d448493          	addi	s1,s1,468
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003e62:	00990c63          	beq	s2,s1,80003e7a <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80003e66:	80005ab7          	lui	s5,0x80005
80003e6a:	80005b37          	lui	s6,0x80005
80003e6e:	80005bb7          	lui	s7,0x80005
80003e72:	80005c37          	lui	s8,0x80005
		for (t = first(); t != NULL; t = next(t)) {
80003e76:	00091963          	bnez	s2,80003e88 <z_add_timeout+0xf4>
	node->prev = list->tail;
80003e7a:	40dc                	lw	a5,4(s1)
	node->next = list;
80003e7c:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003e7e:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003e80:	40dc                	lw	a5,4(s1)
80003e82:	c380                	sw	s0,0(a5)
	list->tail = node;
80003e84:	c0c0                	sw	s0,4(s1)
80003e86:	a891                	j	80003eda <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80003e88:	00892783          	lw	a5,8(s2)
80003e8c:	0207d663          	bgez	a5,80003eb8 <z_add_timeout+0x124>
80003e90:	17cb0593          	addi	a1,s6,380 # 8000517c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000517d>
80003e94:	05600693          	li	a3,86
80003e98:	148a8613          	addi	a2,s5,328 # 80005148 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005149>
80003e9c:	b74b8513          	addi	a0,s7,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003ea0:	f1afd0ef          	jal	ra,800015ba <printk>
80003ea4:	bf8c0513          	addi	a0,s8,-1032 # 80004bf8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bf9>
80003ea8:	f12fd0ef          	jal	ra,800015ba <printk>
80003eac:	05600593          	li	a1,86
80003eb0:	148a8513          	addi	a0,s5,328
80003eb4:	f24fd0ef          	jal	ra,800015d8 <assert_post_action>

			if (t->dticks > to->dticks) {
80003eb8:	00892703          	lw	a4,8(s2)
80003ebc:	441c                	lw	a5,8(s0)
80003ebe:	08e7d763          	bge	a5,a4,80003f4c <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80003ec2:	40f707b3          	sub	a5,a4,a5
80003ec6:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80003eca:	00492783          	lw	a5,4(s2)
	node->next = successor;
80003ece:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80003ed2:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80003ed4:	c380                	sw	s0,0(a5)
	successor->prev = node;
80003ed6:	00892223          	sw	s0,4(s2)
	return list->head == list;
80003eda:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003edc:	00978963          	beq	a5,s1,80003eee <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80003ee0:	00f41763          	bne	s0,a5,80003eee <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80003ee4:	e53ff0ef          	jal	ra,80003d36 <next_timeout>
80003ee8:	4581                	li	a1,0
80003eea:	8fffd0ef          	jal	ra,800017e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003eee:	2d8a0513          	addi	a0,s4,728
80003ef2:	ae9ff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80003ef6:	ed0d                	bnez	a0,80003f30 <z_add_timeout+0x19c>
80003ef8:	80005437          	lui	s0,0x80005
80003efc:	800055b7          	lui	a1,0x80005
80003f00:	80005537          	lui	a0,0x80005
80003f04:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003f08:	06100693          	li	a3,97
80003f0c:	c4040613          	addi	a2,s0,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003f10:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003f14:	ea6fd0ef          	jal	ra,800015ba <printk>
80003f18:	80005537          	lui	a0,0x80005
80003f1c:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80003f20:	e9afd0ef          	jal	ra,800015ba <printk>
80003f24:	06100593          	li	a1,97
80003f28:	c4040513          	addi	a0,s0,-960
80003f2c:	eacfd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f30:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80003f34:	50b2                	lw	ra,44(sp)
80003f36:	5422                	lw	s0,40(sp)
80003f38:	5492                	lw	s1,36(sp)
80003f3a:	5902                	lw	s2,32(sp)
80003f3c:	49f2                	lw	s3,28(sp)
80003f3e:	4a62                	lw	s4,24(sp)
80003f40:	4ad2                	lw	s5,20(sp)
80003f42:	4b42                	lw	s6,16(sp)
80003f44:	4bb2                	lw	s7,12(sp)
80003f46:	4c22                	lw	s8,8(sp)
80003f48:	6145                	addi	sp,sp,48
80003f4a:	8082                	ret
			to->dticks -= t->dticks;
80003f4c:	8f99                	sub	a5,a5,a4
80003f4e:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80003f50:	40dc                	lw	a5,4(s1)
80003f52:	f32784e3          	beq	a5,s2,80003e7a <z_add_timeout+0xe6>
80003f56:	00092903          	lw	s2,0(s2)
80003f5a:	bf31                	j	80003e76 <z_add_timeout+0xe2>

80003f5c <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80003f5c:	1101                	addi	sp,sp,-32
80003f5e:	cc22                	sw	s0,24(sp)
80003f60:	c64e                	sw	s3,12(sp)
80003f62:	ce06                	sw	ra,28(sp)
80003f64:	ca26                	sw	s1,20(sp)
80003f66:	c84a                	sw	s2,16(sp)
80003f68:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f6a:	4421                	li	s0,8
80003f6c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f70:	800054b7          	lui	s1,0x80005
80003f74:	2d848513          	addi	a0,s1,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f78:	8821                	andi	s0,s0,8
80003f7a:	a47ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80003f7e:	ed0d                	bnez	a0,80003fb8 <z_abort_timeout+0x5c>
80003f80:	80005937          	lui	s2,0x80005
80003f84:	800055b7          	lui	a1,0x80005
80003f88:	80005537          	lui	a0,0x80005
80003f8c:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80003f90:	04e00693          	li	a3,78
80003f94:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003f98:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003f9c:	e1efd0ef          	jal	ra,800015ba <printk>
80003fa0:	80005537          	lui	a0,0x80005
80003fa4:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80003fa8:	e12fd0ef          	jal	ra,800015ba <printk>
80003fac:	04e00593          	li	a1,78
80003fb0:	c4090513          	addi	a0,s2,-960
80003fb4:	e24fd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80003fb8:	2d848513          	addi	a0,s1,728
80003fbc:	a41ff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80003fc0:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80003fc4:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80003fc6:	c789                	beqz	a5,80003fd0 <z_abort_timeout+0x74>
			remove_timeout(to);
80003fc8:	854e                	mv	a0,s3
80003fca:	d43ff0ef          	jal	ra,80003d0c <remove_timeout>
			ret = 0;
80003fce:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fd0:	2d848513          	addi	a0,s1,728
80003fd4:	a07ff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80003fd8:	ed0d                	bnez	a0,80004012 <z_abort_timeout+0xb6>
80003fda:	800054b7          	lui	s1,0x80005
80003fde:	800055b7          	lui	a1,0x80005
80003fe2:	80005537          	lui	a0,0x80005
80003fe6:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80003fea:	06100693          	li	a3,97
80003fee:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80003ff2:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80003ff6:	dc4fd0ef          	jal	ra,800015ba <printk>
80003ffa:	80005537          	lui	a0,0x80005
80003ffe:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80004002:	db8fd0ef          	jal	ra,800015ba <printk>
80004006:	06100593          	li	a1,97
8000400a:	c4048513          	addi	a0,s1,-960
8000400e:	dcafd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004012:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004016:	40f2                	lw	ra,28(sp)
80004018:	4462                	lw	s0,24(sp)
8000401a:	854a                	mv	a0,s2
8000401c:	44d2                	lw	s1,20(sp)
8000401e:	4942                	lw	s2,16(sp)
80004020:	49b2                	lw	s3,12(sp)
80004022:	6105                	addi	sp,sp,32
80004024:	8082                	ret

80004026 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004026:	1141                	addi	sp,sp,-16
80004028:	c422                	sw	s0,8(sp)
8000402a:	c606                	sw	ra,12(sp)
8000402c:	c226                	sw	s1,4(sp)
8000402e:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004030:	4421                	li	s0,8
80004032:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004036:	800054b7          	lui	s1,0x80005
8000403a:	2d848513          	addi	a0,s1,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000403e:	8821                	andi	s0,s0,8
80004040:	981ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80004044:	ed0d                	bnez	a0,8000407e <z_get_next_timeout_expiry+0x58>
80004046:	80005937          	lui	s2,0x80005
8000404a:	800055b7          	lui	a1,0x80005
8000404e:	80005537          	lui	a0,0x80005
80004052:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80004056:	04e00693          	li	a3,78
8000405a:	c4090613          	addi	a2,s2,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
8000405e:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80004062:	d58fd0ef          	jal	ra,800015ba <printk>
80004066:	80005537          	lui	a0,0x80005
8000406a:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
8000406e:	d4cfd0ef          	jal	ra,800015ba <printk>
80004072:	04e00593          	li	a1,78
80004076:	c4090513          	addi	a0,s2,-960
8000407a:	d5efd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000407e:	2d848513          	addi	a0,s1,728
80004082:	97bff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004086:	cb1ff0ef          	jal	ra,80003d36 <next_timeout>
8000408a:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000408c:	2d848513          	addi	a0,s1,728
80004090:	94bff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80004094:	ed0d                	bnez	a0,800040ce <z_get_next_timeout_expiry+0xa8>
80004096:	800054b7          	lui	s1,0x80005
8000409a:	800055b7          	lui	a1,0x80005
8000409e:	80005537          	lui	a0,0x80005
800040a2:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800040a6:	06100693          	li	a3,97
800040aa:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800040ae:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800040b2:	d08fd0ef          	jal	ra,800015ba <printk>
800040b6:	80005537          	lui	a0,0x80005
800040ba:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800040be:	cfcfd0ef          	jal	ra,800015ba <printk>
800040c2:	06100593          	li	a1,97
800040c6:	c4048513          	addi	a0,s1,-960
800040ca:	d0efd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800040ce:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800040d2:	40b2                	lw	ra,12(sp)
800040d4:	4422                	lw	s0,8(sp)
800040d6:	854a                	mv	a0,s2
800040d8:	4492                	lw	s1,4(sp)
800040da:	4902                	lw	s2,0(sp)
800040dc:	0141                	addi	sp,sp,16
800040de:	8082                	ret

800040e0 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800040e0:	1101                	addi	sp,sp,-32
800040e2:	cc22                	sw	s0,24(sp)
800040e4:	c84a                	sw	s2,16(sp)
800040e6:	c452                	sw	s4,8(sp)
800040e8:	ce06                	sw	ra,28(sp)
800040ea:	ca26                	sw	s1,20(sp)
800040ec:	c64e                	sw	s3,12(sp)
800040ee:	892a                	mv	s2,a0
800040f0:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040f2:	4421                	li	s0,8
800040f4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040f8:	800054b7          	lui	s1,0x80005
800040fc:	2d848513          	addi	a0,s1,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80004100:	8821                	andi	s0,s0,8
80004102:	8bfff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
80004106:	ed0d                	bnez	a0,80004140 <z_set_timeout_expiry+0x60>
80004108:	800059b7          	lui	s3,0x80005
8000410c:	800055b7          	lui	a1,0x80005
80004110:	80005537          	lui	a0,0x80005
80004114:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80004118:	04e00693          	li	a3,78
8000411c:	c4098613          	addi	a2,s3,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80004120:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80004124:	c96fd0ef          	jal	ra,800015ba <printk>
80004128:	80005537          	lui	a0,0x80005
8000412c:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80004130:	c8afd0ef          	jal	ra,800015ba <printk>
80004134:	04e00593          	li	a1,78
80004138:	c4098513          	addi	a0,s3,-960
8000413c:	c9cfd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
80004140:	2d848513          	addi	a0,s1,728
80004144:	8b9ff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004148:	befff0ef          	jal	ra,80003d36 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
8000414c:	00a95963          	bge	s2,a0,8000415e <z_set_timeout_expiry+0x7e>
80004150:	4785                	li	a5,1
80004152:	00a7d663          	bge	a5,a0,8000415e <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80004156:	85d2                	mv	a1,s4
80004158:	854a                	mv	a0,s2
8000415a:	e8efd0ef          	jal	ra,800017e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000415e:	2d848513          	addi	a0,s1,728
80004162:	879ff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80004166:	ed0d                	bnez	a0,800041a0 <z_set_timeout_expiry+0xc0>
80004168:	800054b7          	lui	s1,0x80005
8000416c:	800055b7          	lui	a1,0x80005
80004170:	80005537          	lui	a0,0x80005
80004174:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
80004178:	06100693          	li	a3,97
8000417c:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80004180:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80004184:	c36fd0ef          	jal	ra,800015ba <printk>
80004188:	80005537          	lui	a0,0x80005
8000418c:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80004190:	c2afd0ef          	jal	ra,800015ba <printk>
80004194:	06100593          	li	a1,97
80004198:	c4048513          	addi	a0,s1,-960
8000419c:	c3cfd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800041a0:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800041a4:	40f2                	lw	ra,28(sp)
800041a6:	4462                	lw	s0,24(sp)
800041a8:	44d2                	lw	s1,20(sp)
800041aa:	4942                	lw	s2,16(sp)
800041ac:	49b2                	lw	s3,12(sp)
800041ae:	4a22                	lw	s4,8(sp)
800041b0:	6105                	addi	sp,sp,32
800041b2:	8082                	ret

800041b4 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800041b4:	7179                	addi	sp,sp,-48
800041b6:	d422                	sw	s0,40(sp)
800041b8:	cc52                	sw	s4,24(sp)
800041ba:	d606                	sw	ra,44(sp)
800041bc:	d226                	sw	s1,36(sp)
800041be:	d04a                	sw	s2,32(sp)
800041c0:	ce4e                	sw	s3,28(sp)
800041c2:	ca56                	sw	s5,20(sp)
800041c4:	c85a                	sw	s6,16(sp)
800041c6:	c65e                	sw	s7,12(sp)
800041c8:	c462                	sw	s8,8(sp)
800041ca:	c266                	sw	s9,4(sp)
800041cc:	c06a                	sw	s10,0(sp)
800041ce:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800041d0:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
800041d2:	e7ffe0ef          	jal	ra,80003050 <z_time_slice>
800041d6:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800041da:	80005937          	lui	s2,0x80005
800041de:	2d890513          	addi	a0,s2,728 # 800052d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800041e2:	8821                	andi	s0,s0,8
800041e4:	fdcff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
800041e8:	ed0d                	bnez	a0,80004222 <z_clock_announce+0x6e>
800041ea:	800054b7          	lui	s1,0x80005
800041ee:	800055b7          	lui	a1,0x80005
800041f2:	80005537          	lui	a0,0x80005
800041f6:	c5858593          	addi	a1,a1,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
800041fa:	04e00693          	li	a3,78
800041fe:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80004202:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
80004206:	bb4fd0ef          	jal	ra,800015ba <printk>
8000420a:	80005537          	lui	a0,0x80005
8000420e:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
80004212:	ba8fd0ef          	jal	ra,800015ba <printk>
80004216:	04e00593          	li	a1,78
8000421a:	c4048513          	addi	a0,s1,-960
8000421e:	bbafd0ef          	jal	ra,800015d8 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80004222:	800059b7          	lui	s3,0x80005
	z_spin_lock_set_owner(l);
80004226:	2d890513          	addi	a0,s2,728
8000422a:	fd2ff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
8000422e:	800054b7          	lui	s1,0x80005
80004232:	2d49aa23          	sw	s4,724(s3) # 800052d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052d5>
	return list->head == list;
80004236:	80005a37          	lui	s4,0x80005
8000423a:	2d498993          	addi	s3,s3,724
8000423e:	1d4a0a13          	addi	s4,s4,468 # 800051d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051d5>
80004242:	29048493          	addi	s1,s1,656 # 80005290 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005291>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004246:	80005ab7          	lui	s5,0x80005
8000424a:	80005bb7          	lui	s7,0x80005
8000424e:	80005b37          	lui	s6,0x80005
80004252:	80005c37          	lui	s8,0x80005
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004256:	80005cb7          	lui	s9,0x80005
8000425a:	000a2d03          	lw	s10,0(s4)
8000425e:	0009a783          	lw	a5,0(s3)
80004262:	4094                	lw	a3,0(s1)
80004264:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004266:	014d0b63          	beq	s10,s4,8000427c <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
8000426a:	000d0963          	beqz	s10,8000427c <z_clock_announce+0xc8>
8000426e:	008d2703          	lw	a4,8(s10)
80004272:	08e7d663          	bge	a5,a4,800042fe <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80004276:	8f1d                	sub	a4,a4,a5
80004278:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
8000427c:	96be                	add	a3,a3,a5
8000427e:	41f7d713          	srai	a4,a5,0x1f
80004282:	972a                	add	a4,a4,a0
80004284:	00f6b7b3          	sltu	a5,a3,a5
80004288:	97ba                	add	a5,a5,a4
8000428a:	c094                	sw	a3,0(s1)
8000428c:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
8000428e:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80004292:	aa5ff0ef          	jal	ra,80003d36 <next_timeout>
80004296:	4581                	li	a1,0
80004298:	d50fd0ef          	jal	ra,800017e8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000429c:	2d890513          	addi	a0,s2,728
800042a0:	f3aff0ef          	jal	ra,800039da <z_spin_unlock_valid>
800042a4:	ed0d                	bnez	a0,800042de <z_clock_announce+0x12a>
800042a6:	800054b7          	lui	s1,0x80005
800042aa:	800055b7          	lui	a1,0x80005
800042ae:	80005537          	lui	a0,0x80005
800042b2:	c8858593          	addi	a1,a1,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
800042b6:	06100693          	li	a3,97
800042ba:	c4048613          	addi	a2,s1,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
800042be:	b7450513          	addi	a0,a0,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
800042c2:	af8fd0ef          	jal	ra,800015ba <printk>
800042c6:	80005537          	lui	a0,0x80005
800042ca:	ca050513          	addi	a0,a0,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
800042ce:	aecfd0ef          	jal	ra,800015ba <printk>
800042d2:	06100593          	li	a1,97
800042d6:	c4048513          	addi	a0,s1,-960
800042da:	afefd0ef          	jal	ra,800015d8 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800042de:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800042e2:	50b2                	lw	ra,44(sp)
800042e4:	5422                	lw	s0,40(sp)
800042e6:	5492                	lw	s1,36(sp)
800042e8:	5902                	lw	s2,32(sp)
800042ea:	49f2                	lw	s3,28(sp)
800042ec:	4a62                	lw	s4,24(sp)
800042ee:	4ad2                	lw	s5,20(sp)
800042f0:	4b42                	lw	s6,16(sp)
800042f2:	4bb2                	lw	s7,12(sp)
800042f4:	4c22                	lw	s8,8(sp)
800042f6:	4c92                	lw	s9,4(sp)
800042f8:	4d02                	lw	s10,0(sp)
800042fa:	6145                	addi	sp,sp,48
800042fc:	8082                	ret
		curr_tick += dt;
800042fe:	96ba                	add	a3,a3,a4
80004300:	41f75593          	srai	a1,a4,0x1f
80004304:	95aa                	add	a1,a1,a0
80004306:	00e6b633          	sltu	a2,a3,a4
8000430a:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
8000430c:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
8000430e:	856a                	mv	a0,s10
		t->dticks = 0;
80004310:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80004314:	c094                	sw	a3,0(s1)
80004316:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80004318:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
8000431c:	9f1ff0ef          	jal	ra,80003d0c <remove_timeout>
80004320:	2d890513          	addi	a0,s2,728
80004324:	eb6ff0ef          	jal	ra,800039da <z_spin_unlock_valid>
80004328:	e50d                	bnez	a0,80004352 <z_clock_announce+0x19e>
8000432a:	c88b8593          	addi	a1,s7,-888 # 80004c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c89>
8000432e:	06100693          	li	a3,97
80004332:	c40a8613          	addi	a2,s5,-960 # 80004c40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c41>
80004336:	b74b0513          	addi	a0,s6,-1164 # 80004b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b75>
8000433a:	a80fd0ef          	jal	ra,800015ba <printk>
8000433e:	ca0c0513          	addi	a0,s8,-864 # 80004ca0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ca1>
80004342:	a78fd0ef          	jal	ra,800015ba <printk>
80004346:	06100593          	li	a1,97
8000434a:	c40a8513          	addi	a0,s5,-960
8000434e:	a8afd0ef          	jal	ra,800015d8 <assert_post_action>
80004352:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004356:	00cd2783          	lw	a5,12(s10)
8000435a:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000435c:	4421                	li	s0,8
8000435e:	9782                	jalr	a5
80004360:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004364:	2d890513          	addi	a0,s2,728
	key = (mstatus & SOC_MSTATUS_IEN);
80004368:	8821                	andi	s0,s0,8
8000436a:	e56ff0ef          	jal	ra,800039c0 <z_spin_lock_valid>
8000436e:	e51d                	bnez	a0,8000439c <z_clock_announce+0x1e8>
80004370:	c58c8593          	addi	a1,s9,-936 # 80004c58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c59>
80004374:	04e00693          	li	a3,78
80004378:	c40a8613          	addi	a2,s5,-960
8000437c:	b74b0513          	addi	a0,s6,-1164
80004380:	a3afd0ef          	jal	ra,800015ba <printk>
80004384:	80005537          	lui	a0,0x80005
80004388:	c7050513          	addi	a0,a0,-912 # 80004c70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c71>
8000438c:	a2efd0ef          	jal	ra,800015ba <printk>
80004390:	04e00593          	li	a1,78
80004394:	c40a8513          	addi	a0,s5,-960
80004398:	a40fd0ef          	jal	ra,800015d8 <assert_post_action>
	z_spin_lock_set_owner(l);
8000439c:	2d890513          	addi	a0,s2,728
800043a0:	e5cff0ef          	jal	ra,800039fc <z_spin_lock_set_owner>
	return k;
800043a4:	bd5d                	j	8000425a <z_clock_announce+0xa6>

800043a6 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800043a6:	8082                	ret
