
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	5d10006f          	j	80000ddc <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	4790006f          	j	80000d14 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00006397          	auipc	t2,0x6
800000b8:	3d038393          	addi	t2,t2,976 # 80006484 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	4c10006f          	j	80000da0 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00005297          	auipc	t0,0x5
800000fc:	2e428293          	addi	t0,t0,740 # 800053dc <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00006317          	auipc	t1,0x6
80000118:	37030313          	addi	t1,t1,880 # 80006484 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00006297          	auipc	t0,0x6
80000140:	34828293          	addi	t0,t0,840 # 80006484 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00006397          	auipc	t2,0x6
80000180:	ea438393          	addi	t2,t2,-348 # 80006020 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00006297          	auipc	t0,0x6
80000230:	25828293          	addi	t0,t0,600 # 80006484 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	fd010113          	addi	sp,sp,-48
800002b4:	02912223          	sw	s1,36(sp)
800002b8:	01612823          	sw	s6,16(sp)
800002bc:	02112623          	sw	ra,44(sp)
800002c0:	02812423          	sw	s0,40(sp)
800002c4:	03212023          	sw	s2,32(sp)
800002c8:	01312e23          	sw	s3,28(sp)
800002cc:	01412c23          	sw	s4,24(sp)
800002d0:	01512a23          	sw	s5,20(sp)
800002d4:	01712623          	sw	s7,12(sp)
800002d8:	01812423          	sw	s8,8(sp)
800002dc:	01912223          	sw	s9,4(sp)
800002e0:	00050b13          	mv	s6,a0
800002e4:	00058493          	mv	s1,a1
800002e8:	38069c63          	bnez	a3,80000680 <__udivdi3+0x3d0>
800002ec:	00060413          	mv	s0,a2
800002f0:	00050993          	mv	s3,a0
800002f4:	00005917          	auipc	s2,0x5
800002f8:	26890913          	addi	s2,s2,616 # 8000555c <__devconfig_end>
800002fc:	12c5f863          	bgeu	a1,a2,8000042c <__udivdi3+0x17c>
80000300:	000107b7          	lui	a5,0x10
80000304:	00058a93          	mv	s5,a1
80000308:	10f67863          	bgeu	a2,a5,80000418 <__udivdi3+0x168>
8000030c:	0ff00693          	li	a3,255
80000310:	00c6b6b3          	sltu	a3,a3,a2
80000314:	00369693          	slli	a3,a3,0x3
80000318:	00d657b3          	srl	a5,a2,a3
8000031c:	00f90933          	add	s2,s2,a5
80000320:	00094703          	lbu	a4,0(s2)
80000324:	00d706b3          	add	a3,a4,a3
80000328:	02000713          	li	a4,32
8000032c:	40d70733          	sub	a4,a4,a3
80000330:	00070c63          	beqz	a4,80000348 <__udivdi3+0x98>
80000334:	00e494b3          	sll	s1,s1,a4
80000338:	00db56b3          	srl	a3,s6,a3
8000033c:	00e61433          	sll	s0,a2,a4
80000340:	0096eab3          	or	s5,a3,s1
80000344:	00eb19b3          	sll	s3,s6,a4
80000348:	01045b13          	srli	s6,s0,0x10
8000034c:	000b0593          	mv	a1,s6
80000350:	000a8513          	mv	a0,s5
80000354:	5a4000ef          	jal	ra,800008f8 <__umodsi3>
80000358:	00050913          	mv	s2,a0
8000035c:	000b0593          	mv	a1,s6
80000360:	01041b93          	slli	s7,s0,0x10
80000364:	000a8513          	mv	a0,s5
80000368:	548000ef          	jal	ra,800008b0 <__udivsi3>
8000036c:	010bdb93          	srli	s7,s7,0x10
80000370:	00050493          	mv	s1,a0
80000374:	00050593          	mv	a1,a0
80000378:	000b8513          	mv	a0,s7
8000037c:	508000ef          	jal	ra,80000884 <__mulsi3>
80000380:	01091913          	slli	s2,s2,0x10
80000384:	0109d713          	srli	a4,s3,0x10
80000388:	00e96733          	or	a4,s2,a4
8000038c:	00048a13          	mv	s4,s1
80000390:	00a77e63          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
80000394:	00870733          	add	a4,a4,s0
80000398:	fff48a13          	addi	s4,s1,-1
8000039c:	00876863          	bltu	a4,s0,800003ac <__udivdi3+0xfc>
800003a0:	00a77663          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
800003a4:	ffe48a13          	addi	s4,s1,-2
800003a8:	00870733          	add	a4,a4,s0
800003ac:	40a704b3          	sub	s1,a4,a0
800003b0:	000b0593          	mv	a1,s6
800003b4:	00048513          	mv	a0,s1
800003b8:	540000ef          	jal	ra,800008f8 <__umodsi3>
800003bc:	00050913          	mv	s2,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	4e8000ef          	jal	ra,800008b0 <__udivsi3>
800003cc:	01099993          	slli	s3,s3,0x10
800003d0:	00050493          	mv	s1,a0
800003d4:	00050593          	mv	a1,a0
800003d8:	01091913          	slli	s2,s2,0x10
800003dc:	000b8513          	mv	a0,s7
800003e0:	0109d993          	srli	s3,s3,0x10
800003e4:	4a0000ef          	jal	ra,80000884 <__mulsi3>
800003e8:	013969b3          	or	s3,s2,s3
800003ec:	00048613          	mv	a2,s1
800003f0:	00a9fc63          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
800003f4:	013409b3          	add	s3,s0,s3
800003f8:	fff48613          	addi	a2,s1,-1
800003fc:	0089e663          	bltu	s3,s0,80000408 <__udivdi3+0x158>
80000400:	00a9f463          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
80000404:	ffe48613          	addi	a2,s1,-2
80000408:	010a1793          	slli	a5,s4,0x10
8000040c:	00c7e7b3          	or	a5,a5,a2
80000410:	00000a13          	li	s4,0
80000414:	1300006f          	j	80000544 <__udivdi3+0x294>
80000418:	010007b7          	lui	a5,0x1000
8000041c:	01000693          	li	a3,16
80000420:	eef66ce3          	bltu	a2,a5,80000318 <__udivdi3+0x68>
80000424:	01800693          	li	a3,24
80000428:	ef1ff06f          	j	80000318 <__udivdi3+0x68>
8000042c:	00068a13          	mv	s4,a3
80000430:	00061a63          	bnez	a2,80000444 <__udivdi3+0x194>
80000434:	00000593          	li	a1,0
80000438:	00100513          	li	a0,1
8000043c:	474000ef          	jal	ra,800008b0 <__udivsi3>
80000440:	00050413          	mv	s0,a0
80000444:	000107b7          	lui	a5,0x10
80000448:	12f47c63          	bgeu	s0,a5,80000580 <__udivdi3+0x2d0>
8000044c:	0ff00793          	li	a5,255
80000450:	0087f463          	bgeu	a5,s0,80000458 <__udivdi3+0x1a8>
80000454:	00800a13          	li	s4,8
80000458:	014457b3          	srl	a5,s0,s4
8000045c:	00f90933          	add	s2,s2,a5
80000460:	00094683          	lbu	a3,0(s2)
80000464:	02000613          	li	a2,32
80000468:	014686b3          	add	a3,a3,s4
8000046c:	40d60633          	sub	a2,a2,a3
80000470:	12061263          	bnez	a2,80000594 <__udivdi3+0x2e4>
80000474:	408484b3          	sub	s1,s1,s0
80000478:	00100a13          	li	s4,1
8000047c:	01045b13          	srli	s6,s0,0x10
80000480:	000b0593          	mv	a1,s6
80000484:	00048513          	mv	a0,s1
80000488:	470000ef          	jal	ra,800008f8 <__umodsi3>
8000048c:	00050913          	mv	s2,a0
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	01041b93          	slli	s7,s0,0x10
8000049c:	414000ef          	jal	ra,800008b0 <__udivsi3>
800004a0:	010bdb93          	srli	s7,s7,0x10
800004a4:	00050493          	mv	s1,a0
800004a8:	00050593          	mv	a1,a0
800004ac:	000b8513          	mv	a0,s7
800004b0:	3d4000ef          	jal	ra,80000884 <__mulsi3>
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	0109d713          	srli	a4,s3,0x10
800004bc:	00e96733          	or	a4,s2,a4
800004c0:	00048a93          	mv	s5,s1
800004c4:	00a77e63          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004c8:	00870733          	add	a4,a4,s0
800004cc:	fff48a93          	addi	s5,s1,-1
800004d0:	00876863          	bltu	a4,s0,800004e0 <__udivdi3+0x230>
800004d4:	00a77663          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004d8:	ffe48a93          	addi	s5,s1,-2
800004dc:	00870733          	add	a4,a4,s0
800004e0:	40a704b3          	sub	s1,a4,a0
800004e4:	000b0593          	mv	a1,s6
800004e8:	00048513          	mv	a0,s1
800004ec:	40c000ef          	jal	ra,800008f8 <__umodsi3>
800004f0:	00050913          	mv	s2,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	3b4000ef          	jal	ra,800008b0 <__udivsi3>
80000500:	01099993          	slli	s3,s3,0x10
80000504:	00050493          	mv	s1,a0
80000508:	00050593          	mv	a1,a0
8000050c:	01091913          	slli	s2,s2,0x10
80000510:	000b8513          	mv	a0,s7
80000514:	0109d993          	srli	s3,s3,0x10
80000518:	36c000ef          	jal	ra,80000884 <__mulsi3>
8000051c:	013969b3          	or	s3,s2,s3
80000520:	00048613          	mv	a2,s1
80000524:	00a9fc63          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000528:	013409b3          	add	s3,s0,s3
8000052c:	fff48613          	addi	a2,s1,-1
80000530:	0089e663          	bltu	s3,s0,8000053c <__udivdi3+0x28c>
80000534:	00a9f463          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000538:	ffe48613          	addi	a2,s1,-2
8000053c:	010a9793          	slli	a5,s5,0x10
80000540:	00c7e7b3          	or	a5,a5,a2
80000544:	00078513          	mv	a0,a5
80000548:	000a0593          	mv	a1,s4
8000054c:	02c12083          	lw	ra,44(sp)
80000550:	02812403          	lw	s0,40(sp)
80000554:	02412483          	lw	s1,36(sp)
80000558:	02012903          	lw	s2,32(sp)
8000055c:	01c12983          	lw	s3,28(sp)
80000560:	01812a03          	lw	s4,24(sp)
80000564:	01412a83          	lw	s5,20(sp)
80000568:	01012b03          	lw	s6,16(sp)
8000056c:	00c12b83          	lw	s7,12(sp)
80000570:	00812c03          	lw	s8,8(sp)
80000574:	00412c83          	lw	s9,4(sp)
80000578:	03010113          	addi	sp,sp,48
8000057c:	00008067          	ret
80000580:	010007b7          	lui	a5,0x1000
80000584:	01000a13          	li	s4,16
80000588:	ecf468e3          	bltu	s0,a5,80000458 <__udivdi3+0x1a8>
8000058c:	01800a13          	li	s4,24
80000590:	ec9ff06f          	j	80000458 <__udivdi3+0x1a8>
80000594:	00c41433          	sll	s0,s0,a2
80000598:	00d4da33          	srl	s4,s1,a3
8000059c:	00cb19b3          	sll	s3,s6,a2
800005a0:	00db56b3          	srl	a3,s6,a3
800005a4:	01045b13          	srli	s6,s0,0x10
800005a8:	00c494b3          	sll	s1,s1,a2
800005ac:	000b0593          	mv	a1,s6
800005b0:	000a0513          	mv	a0,s4
800005b4:	0096eab3          	or	s5,a3,s1
800005b8:	340000ef          	jal	ra,800008f8 <__umodsi3>
800005bc:	00050913          	mv	s2,a0
800005c0:	000b0593          	mv	a1,s6
800005c4:	000a0513          	mv	a0,s4
800005c8:	01041b93          	slli	s7,s0,0x10
800005cc:	2e4000ef          	jal	ra,800008b0 <__udivsi3>
800005d0:	010bdb93          	srli	s7,s7,0x10
800005d4:	00050493          	mv	s1,a0
800005d8:	00050593          	mv	a1,a0
800005dc:	000b8513          	mv	a0,s7
800005e0:	2a4000ef          	jal	ra,80000884 <__mulsi3>
800005e4:	01091913          	slli	s2,s2,0x10
800005e8:	010ad713          	srli	a4,s5,0x10
800005ec:	00e96733          	or	a4,s2,a4
800005f0:	00048a13          	mv	s4,s1
800005f4:	00a77e63          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
800005f8:	00870733          	add	a4,a4,s0
800005fc:	fff48a13          	addi	s4,s1,-1
80000600:	00876863          	bltu	a4,s0,80000610 <__udivdi3+0x360>
80000604:	00a77663          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
80000608:	ffe48a13          	addi	s4,s1,-2
8000060c:	00870733          	add	a4,a4,s0
80000610:	40a704b3          	sub	s1,a4,a0
80000614:	000b0593          	mv	a1,s6
80000618:	00048513          	mv	a0,s1
8000061c:	2dc000ef          	jal	ra,800008f8 <__umodsi3>
80000620:	00050913          	mv	s2,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	284000ef          	jal	ra,800008b0 <__udivsi3>
80000630:	00050493          	mv	s1,a0
80000634:	00050593          	mv	a1,a0
80000638:	000b8513          	mv	a0,s7
8000063c:	248000ef          	jal	ra,80000884 <__mulsi3>
80000640:	010a9693          	slli	a3,s5,0x10
80000644:	01091913          	slli	s2,s2,0x10
80000648:	0106d693          	srli	a3,a3,0x10
8000064c:	00d967b3          	or	a5,s2,a3
80000650:	00048713          	mv	a4,s1
80000654:	00a7fe63          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000658:	008787b3          	add	a5,a5,s0
8000065c:	fff48713          	addi	a4,s1,-1
80000660:	0087e863          	bltu	a5,s0,80000670 <__udivdi3+0x3c0>
80000664:	00a7f663          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000668:	ffe48713          	addi	a4,s1,-2
8000066c:	008787b3          	add	a5,a5,s0
80000670:	010a1a13          	slli	s4,s4,0x10
80000674:	40a784b3          	sub	s1,a5,a0
80000678:	00ea6a33          	or	s4,s4,a4
8000067c:	e01ff06f          	j	8000047c <__udivdi3+0x1cc>
80000680:	1ed5ec63          	bltu	a1,a3,80000878 <__udivdi3+0x5c8>
80000684:	000107b7          	lui	a5,0x10
80000688:	04f6f463          	bgeu	a3,a5,800006d0 <__udivdi3+0x420>
8000068c:	0ff00593          	li	a1,255
80000690:	00d5b533          	sltu	a0,a1,a3
80000694:	00351513          	slli	a0,a0,0x3
80000698:	00a6d733          	srl	a4,a3,a0
8000069c:	00005797          	auipc	a5,0x5
800006a0:	ec078793          	addi	a5,a5,-320 # 8000555c <__devconfig_end>
800006a4:	00e787b3          	add	a5,a5,a4
800006a8:	0007c583          	lbu	a1,0(a5)
800006ac:	02000a13          	li	s4,32
800006b0:	00a585b3          	add	a1,a1,a0
800006b4:	40ba0a33          	sub	s4,s4,a1
800006b8:	020a1663          	bnez	s4,800006e4 <__udivdi3+0x434>
800006bc:	00100793          	li	a5,1
800006c0:	e896e2e3          	bltu	a3,s1,80000544 <__udivdi3+0x294>
800006c4:	00cb3633          	sltu	a2,s6,a2
800006c8:	00164793          	xori	a5,a2,1
800006cc:	e79ff06f          	j	80000544 <__udivdi3+0x294>
800006d0:	010007b7          	lui	a5,0x1000
800006d4:	01000513          	li	a0,16
800006d8:	fcf6e0e3          	bltu	a3,a5,80000698 <__udivdi3+0x3e8>
800006dc:	01800513          	li	a0,24
800006e0:	fb9ff06f          	j	80000698 <__udivdi3+0x3e8>
800006e4:	00b65ab3          	srl	s5,a2,a1
800006e8:	014696b3          	sll	a3,a3,s4
800006ec:	00daeab3          	or	s5,s5,a3
800006f0:	00b4d933          	srl	s2,s1,a1
800006f4:	014497b3          	sll	a5,s1,s4
800006f8:	00bb55b3          	srl	a1,s6,a1
800006fc:	010adb93          	srli	s7,s5,0x10
80000700:	00f5e4b3          	or	s1,a1,a5
80000704:	00090513          	mv	a0,s2
80000708:	000b8593          	mv	a1,s7
8000070c:	014619b3          	sll	s3,a2,s4
80000710:	1e8000ef          	jal	ra,800008f8 <__umodsi3>
80000714:	00050413          	mv	s0,a0
80000718:	000b8593          	mv	a1,s7
8000071c:	00090513          	mv	a0,s2
80000720:	010a9c13          	slli	s8,s5,0x10
80000724:	18c000ef          	jal	ra,800008b0 <__udivsi3>
80000728:	010c5c13          	srli	s8,s8,0x10
8000072c:	00050913          	mv	s2,a0
80000730:	00050593          	mv	a1,a0
80000734:	000c0513          	mv	a0,s8
80000738:	14c000ef          	jal	ra,80000884 <__mulsi3>
8000073c:	01041413          	slli	s0,s0,0x10
80000740:	0104d713          	srli	a4,s1,0x10
80000744:	00e46733          	or	a4,s0,a4
80000748:	00090c93          	mv	s9,s2
8000074c:	00a77e63          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000750:	01570733          	add	a4,a4,s5
80000754:	fff90c93          	addi	s9,s2,-1
80000758:	01576863          	bltu	a4,s5,80000768 <__udivdi3+0x4b8>
8000075c:	00a77663          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000760:	ffe90c93          	addi	s9,s2,-2
80000764:	01570733          	add	a4,a4,s5
80000768:	40a70933          	sub	s2,a4,a0
8000076c:	000b8593          	mv	a1,s7
80000770:	00090513          	mv	a0,s2
80000774:	184000ef          	jal	ra,800008f8 <__umodsi3>
80000778:	00050413          	mv	s0,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	12c000ef          	jal	ra,800008b0 <__udivsi3>
80000788:	00050913          	mv	s2,a0
8000078c:	00050593          	mv	a1,a0
80000790:	000c0513          	mv	a0,s8
80000794:	0f0000ef          	jal	ra,80000884 <__mulsi3>
80000798:	01049793          	slli	a5,s1,0x10
8000079c:	01041413          	slli	s0,s0,0x10
800007a0:	0107d793          	srli	a5,a5,0x10
800007a4:	00f46733          	or	a4,s0,a5
800007a8:	00090613          	mv	a2,s2
800007ac:	00a77e63          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007b0:	01570733          	add	a4,a4,s5
800007b4:	fff90613          	addi	a2,s2,-1
800007b8:	01576863          	bltu	a4,s5,800007c8 <__udivdi3+0x518>
800007bc:	00a77663          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007c0:	ffe90613          	addi	a2,s2,-2
800007c4:	01570733          	add	a4,a4,s5
800007c8:	010c9793          	slli	a5,s9,0x10
800007cc:	00010e37          	lui	t3,0x10
800007d0:	00c7e7b3          	or	a5,a5,a2
800007d4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007d8:	0107f333          	and	t1,a5,a6
800007dc:	0109f833          	and	a6,s3,a6
800007e0:	40a70733          	sub	a4,a4,a0
800007e4:	0107de93          	srli	t4,a5,0x10
800007e8:	0109d993          	srli	s3,s3,0x10
800007ec:	00030513          	mv	a0,t1
800007f0:	00080593          	mv	a1,a6
800007f4:	090000ef          	jal	ra,80000884 <__mulsi3>
800007f8:	00050893          	mv	a7,a0
800007fc:	00098593          	mv	a1,s3
80000800:	00030513          	mv	a0,t1
80000804:	080000ef          	jal	ra,80000884 <__mulsi3>
80000808:	00050313          	mv	t1,a0
8000080c:	00080593          	mv	a1,a6
80000810:	000e8513          	mv	a0,t4
80000814:	070000ef          	jal	ra,80000884 <__mulsi3>
80000818:	00050813          	mv	a6,a0
8000081c:	00098593          	mv	a1,s3
80000820:	000e8513          	mv	a0,t4
80000824:	060000ef          	jal	ra,80000884 <__mulsi3>
80000828:	0108d693          	srli	a3,a7,0x10
8000082c:	01030333          	add	t1,t1,a6
80000830:	006686b3          	add	a3,a3,t1
80000834:	0106f463          	bgeu	a3,a6,8000083c <__udivdi3+0x58c>
80000838:	01c50533          	add	a0,a0,t3
8000083c:	0106d613          	srli	a2,a3,0x10
80000840:	00a60533          	add	a0,a2,a0
80000844:	02a76663          	bltu	a4,a0,80000870 <__udivdi3+0x5c0>
80000848:	bca714e3          	bne	a4,a0,80000410 <__udivdi3+0x160>
8000084c:	00010737          	lui	a4,0x10
80000850:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000854:	00e6f6b3          	and	a3,a3,a4
80000858:	01069693          	slli	a3,a3,0x10
8000085c:	00e8f8b3          	and	a7,a7,a4
80000860:	014b1633          	sll	a2,s6,s4
80000864:	011686b3          	add	a3,a3,a7
80000868:	00000a13          	li	s4,0
8000086c:	ccd67ce3          	bgeu	a2,a3,80000544 <__udivdi3+0x294>
80000870:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000874:	b9dff06f          	j	80000410 <__udivdi3+0x160>
80000878:	00000a13          	li	s4,0
8000087c:	00000793          	li	a5,0
80000880:	cc5ff06f          	j	80000544 <__udivdi3+0x294>

80000884 <__mulsi3>:
80000884:	00050613          	mv	a2,a0
80000888:	00000513          	li	a0,0
8000088c:	0015f693          	andi	a3,a1,1
80000890:	00068463          	beqz	a3,80000898 <__mulsi3+0x14>
80000894:	00c50533          	add	a0,a0,a2
80000898:	0015d593          	srli	a1,a1,0x1
8000089c:	00161613          	slli	a2,a2,0x1
800008a0:	fe0596e3          	bnez	a1,8000088c <__mulsi3+0x8>
800008a4:	00008067          	ret

800008a8 <__divsi3>:
800008a8:	06054063          	bltz	a0,80000908 <__umodsi3+0x10>
800008ac:	0605c663          	bltz	a1,80000918 <__umodsi3+0x20>

800008b0 <__udivsi3>:
800008b0:	00058613          	mv	a2,a1
800008b4:	00050593          	mv	a1,a0
800008b8:	fff00513          	li	a0,-1
800008bc:	02060c63          	beqz	a2,800008f4 <__udivsi3+0x44>
800008c0:	00100693          	li	a3,1
800008c4:	00b67a63          	bgeu	a2,a1,800008d8 <__udivsi3+0x28>
800008c8:	00c05863          	blez	a2,800008d8 <__udivsi3+0x28>
800008cc:	00161613          	slli	a2,a2,0x1
800008d0:	00169693          	slli	a3,a3,0x1
800008d4:	feb66ae3          	bltu	a2,a1,800008c8 <__udivsi3+0x18>
800008d8:	00000513          	li	a0,0
800008dc:	00c5e663          	bltu	a1,a2,800008e8 <__udivsi3+0x38>
800008e0:	40c585b3          	sub	a1,a1,a2
800008e4:	00d56533          	or	a0,a0,a3
800008e8:	0016d693          	srli	a3,a3,0x1
800008ec:	00165613          	srli	a2,a2,0x1
800008f0:	fe0696e3          	bnez	a3,800008dc <__udivsi3+0x2c>
800008f4:	00008067          	ret

800008f8 <__umodsi3>:
800008f8:	00008293          	mv	t0,ra
800008fc:	fb5ff0ef          	jal	ra,800008b0 <__udivsi3>
80000900:	00058513          	mv	a0,a1
80000904:	00028067          	jr	t0
80000908:	40a00533          	neg	a0,a0
8000090c:	0005d863          	bgez	a1,8000091c <__umodsi3+0x24>
80000910:	40b005b3          	neg	a1,a1
80000914:	f9dff06f          	j	800008b0 <__udivsi3>
80000918:	40b005b3          	neg	a1,a1
8000091c:	00008293          	mv	t0,ra
80000920:	f91ff0ef          	jal	ra,800008b0 <__udivsi3>
80000924:	40a00533          	neg	a0,a0
80000928:	00028067          	jr	t0

8000092c <__modsi3>:
8000092c:	00008293          	mv	t0,ra
80000930:	0005ca63          	bltz	a1,80000944 <__modsi3+0x18>
80000934:	00054c63          	bltz	a0,8000094c <__modsi3+0x20>
80000938:	f79ff0ef          	jal	ra,800008b0 <__udivsi3>
8000093c:	00058513          	mv	a0,a1
80000940:	00028067          	jr	t0
80000944:	40b005b3          	neg	a1,a1
80000948:	fe0558e3          	bgez	a0,80000938 <__modsi3+0xc>
8000094c:	40a00533          	neg	a0,a0
80000950:	f61ff0ef          	jal	ra,800008b0 <__udivsi3>
80000954:	40b00533          	neg	a0,a1
80000958:	00028067          	jr	t0

8000095c <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
8000095c:	00008067          	ret

80000960 <test_mpool_threadsafe>:
 * Each thread allocates 4 blocks of size 4 bytes (all blocks
 * in memory pool) with timeout of 200 ms and frees up all the
 * blocks
 */
void test_mpool_threadsafe(void)
{
80000960:	fc010113          	addi	sp,sp,-64
80000964:	02812c23          	sw	s0,56(sp)
80000968:	03312623          	sw	s3,44(sp)
8000096c:	80006437          	lui	s0,0x80006

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000970:	800069b7          	lui	s3,0x80006
80000974:	02912a23          	sw	s1,52(sp)
80000978:	03212823          	sw	s2,48(sp)
8000097c:	00400613          	li	a2,4
80000980:	00000593          	li	a1,0
80000984:	15498513          	addi	a0,s3,340 # 80006154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006155>
80000988:	16440413          	addi	s0,s0,356 # 80006164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006165>
8000098c:	80006937          	lui	s2,0x80006
80000990:	01010493          	addi	s1,sp,16
80000994:	03412423          	sw	s4,40(sp)
80000998:	03512223          	sw	s5,36(sp)
8000099c:	03612023          	sw	s6,32(sp)
800009a0:	02112e23          	sw	ra,60(sp)
800009a4:	4b090913          	addi	s2,s2,1200 # 800064b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064b1>
800009a8:	708030ef          	jal	ra,800040b0 <z_impl_k_sem_init>
	k_tid_t tid[THREAD_NUM];

	k_sem_init(&sync_sema, 0, THREAD_NUM);

	/* create multiple threads to invoke same memory pool APIs*/
	for (int i = 0; i < THREAD_NUM; i++) {
800009ac:	1c040a93          	addi	s5,s0,448
800009b0:	00048a13          	mv	s4,s1
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800009b4:	80001b37          	lui	s6,0x80001
800009b8:	00090593          	mv	a1,s2
800009bc:	00040513          	mv	a0,s0
800009c0:	00012223          	sw	zero,4(sp)
800009c4:	00012023          	sw	zero,0(sp)
800009c8:	00100893          	li	a7,1
800009cc:	00000813          	li	a6,0
800009d0:	00000793          	li	a5,0
800009d4:	00000713          	li	a4,0
800009d8:	a4cb0693          	addi	a3,s6,-1460 # 80000a4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a4d>
800009dc:	20000613          	li	a2,512
800009e0:	539030ef          	jal	ra,80004718 <z_impl_k_thread_create>
		tid[i] = k_thread_create(&tdata[i], tstack[i], STACK_SIZE,
800009e4:	00aa2023          	sw	a0,0(s4)
800009e8:	07040413          	addi	s0,s0,112
800009ec:	20090913          	addi	s2,s2,512
800009f0:	004a0a13          	addi	s4,s4,4
	for (int i = 0; i < THREAD_NUM; i++) {
800009f4:	fd5412e3          	bne	s0,s5,800009b8 <test_mpool_threadsafe+0x58>
800009f8:	00400413          	li	s0,4

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800009fc:	fff00593          	li	a1,-1
80000a00:	15498513          	addi	a0,s3,340
80000a04:	fff40413          	addi	s0,s0,-1
80000a08:	055030ef          	jal	ra,8000425c <z_impl_k_sem_take>
					 tmpool_api, NULL, NULL, NULL,
					 K_PRIO_PREEMPT(1), 0, 0);
	}
	/* TESTPOINT: all threads complete and exit the entry function*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000a0c:	fe0418e3          	bnez	s0,800009fc <test_mpool_threadsafe+0x9c>
80000a10:	01048413          	addi	s0,s1,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000a14:	0004a503          	lw	a0,0(s1)
80000a18:	00448493          	addi	s1,s1,4
80000a1c:	6a1030ef          	jal	ra,800048bc <z_impl_k_thread_abort>
		k_sem_take(&sync_sema, K_FOREVER);
	}

	/* test case tear down*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000a20:	fe849ae3          	bne	s1,s0,80000a14 <test_mpool_threadsafe+0xb4>
		k_thread_abort(tid[i]);
	}
}
80000a24:	03c12083          	lw	ra,60(sp)
80000a28:	03812403          	lw	s0,56(sp)
80000a2c:	03412483          	lw	s1,52(sp)
80000a30:	03012903          	lw	s2,48(sp)
80000a34:	02c12983          	lw	s3,44(sp)
80000a38:	02812a03          	lw	s4,40(sp)
80000a3c:	02412a83          	lw	s5,36(sp)
80000a40:	02012b03          	lw	s6,32(sp)
80000a44:	04010113          	addi	sp,sp,64
80000a48:	00008067          	ret

80000a4c <tmpool_api>:
extern "C" {
#endif

K_SYSCALL_DECLARE3(K_SYSCALL_ATOMIC_CAS, atomic_cas, int, atomic_t *, target, atomic_val_t, old_value, atomic_val_t, new_value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_ADD, atomic_add, atomic_val_t, atomic_t *, target, atomic_val_t, value)
80000a4c:	80006537          	lui	a0,0x80006
{
80000a50:	f8010113          	addi	sp,sp,-128
80000a54:	00100593          	li	a1,1
80000a58:	0b850513          	addi	a0,a0,184 # 800060b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b9>
80000a5c:	06112e23          	sw	ra,124(sp)
80000a60:	06812c23          	sw	s0,120(sp)
80000a64:	06912a23          	sw	s1,116(sp)
80000a68:	07212823          	sw	s2,112(sp)
80000a6c:	07312623          	sw	s3,108(sp)
80000a70:	07412423          	sw	s4,104(sp)
80000a74:	07512223          	sw	s5,100(sp)
80000a78:	07612023          	sw	s6,96(sp)
80000a7c:	065040ef          	jal	ra,800052e0 <z_impl_atomic_add>
	struct k_mem_pool *pool = pools[atomic_inc(&pool_id) % POOL_NUM];
80000a80:	800007b7          	lui	a5,0x80000
80000a84:	00178793          	addi	a5,a5,1 # 80000001 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000002>
80000a88:	00f57533          	and	a0,a0,a5
80000a8c:	00055863          	bgez	a0,80000a9c <tmpool_api+0x50>
80000a90:	fff50513          	addi	a0,a0,-1
80000a94:	ffe56513          	ori	a0,a0,-2
80000a98:	00150513          	addi	a0,a0,1
80000a9c:	800067b7          	lui	a5,0x80006
80000aa0:	01878793          	addi	a5,a5,24 # 80006018 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006019>
80000aa4:	00251513          	slli	a0,a0,0x2
80000aa8:	00a78533          	add	a0,a5,a0
80000aac:	00052a03          	lw	s4,0(a0)
	(void)memset(block, 0, sizeof(block));
80000ab0:	04000613          	li	a2,64
80000ab4:	00000593          	li	a1,0
80000ab8:	02010513          	addi	a0,sp,32
80000abc:	089010ef          	jal	ra,80002344 <memset>
80000ac0:	00a00993          	li	s3,10
80000ac4:	04010a93          	addi	s5,sp,64
		for (int i = 0; i < 5; i++) {
80000ac8:	00500b13          	li	s6,5
80000acc:	00010493          	mv	s1,sp
{
80000ad0:	00048913          	mv	s2,s1
80000ad4:	02010413          	addi	s0,sp,32
			ret[i] = k_mem_pool_alloc(pool, &block[i],
80000ad8:	00040593          	mv	a1,s0
80000adc:	0c800693          	li	a3,200
80000ae0:	00400613          	li	a2,4
80000ae4:	000a0513          	mv	a0,s4
80000ae8:	749010ef          	jal	ra,80002a30 <k_mem_pool_alloc>
80000aec:	00a92023          	sw	a0,0(s2)
80000af0:	00840413          	addi	s0,s0,8
80000af4:	00490913          	addi	s2,s2,4
		for (int i = 0; i < 4; i++) {
80000af8:	ff5410e3          	bne	s0,s5,80000ad8 <tmpool_api+0x8c>
		ret[4] = k_mem_pool_alloc(pool, &block[4], BLK_SIZE_MAX,
80000afc:	0c800693          	li	a3,200
80000b00:	01000613          	li	a2,16
80000b04:	000a8593          	mv	a1,s5
80000b08:	000a0513          	mv	a0,s4
80000b0c:	725010ef          	jal	ra,80002a30 <k_mem_pool_alloc>
80000b10:	00a12823          	sw	a0,16(sp)
		for (int i = 0; i < 5; i++) {
80000b14:	00000413          	li	s0,0
			if (ret[i] == 0) {
80000b18:	0004a783          	lw	a5,0(s1)
80000b1c:	00079a63          	bnez	a5,80000b30 <tmpool_api+0xe4>
				k_mem_pool_free(&block[i]);
80000b20:	00341513          	slli	a0,s0,0x3
80000b24:	02010793          	addi	a5,sp,32
80000b28:	00a78533          	add	a0,a5,a0
80000b2c:	224020ef          	jal	ra,80002d50 <k_mem_pool_free>
		for (int i = 0; i < 5; i++) {
80000b30:	00140413          	addi	s0,s0,1
80000b34:	00448493          	addi	s1,s1,4
80000b38:	ff6410e3          	bne	s0,s6,80000b18 <tmpool_api+0xcc>
80000b3c:	fff98993          	addi	s3,s3,-1
	for (int loops = 0; loops < LOOPS; loops++) {
80000b40:	f80996e3          	bnez	s3,80000acc <tmpool_api+0x80>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b44:	80006537          	lui	a0,0x80006
80000b48:	15450513          	addi	a0,a0,340 # 80006154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006155>
80000b4c:	62c030ef          	jal	ra,80004178 <z_impl_k_sem_give>
}
80000b50:	07c12083          	lw	ra,124(sp)
80000b54:	07812403          	lw	s0,120(sp)
80000b58:	07412483          	lw	s1,116(sp)
80000b5c:	07012903          	lw	s2,112(sp)
80000b60:	06c12983          	lw	s3,108(sp)
80000b64:	06812a03          	lw	s4,104(sp)
80000b68:	06412a83          	lw	s5,100(sp)
80000b6c:	06012b03          	lw	s6,96(sp)
80000b70:	08010113          	addi	sp,sp,128
80000b74:	00008067          	ret

80000b78 <test_main>:

void test_main(void)
{
	ztest_test_suite(mpool_threadsafe,
			 ztest_unit_test(test_mpool_threadsafe));
	ztest_run_test_suite(mpool_threadsafe);
80000b78:	800065b7          	lui	a1,0x80006
80000b7c:	80005537          	lui	a0,0x80005
80000b80:	fdc58593          	addi	a1,a1,-36 # 80005fdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fdd>
80000b84:	67450513          	addi	a0,a0,1652 # 80005674 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005675>
80000b88:	0dd0106f          	j	80002464 <z_ztest_run_test_suite>

80000b8c <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000b8c:	ff010113          	addi	sp,sp,-16
80000b90:	00112623          	sw	ra,12(sp)
80000b94:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000b98:	00600793          	li	a5,6
80000b9c:	02f50463          	beq	a0,a5,80000bc4 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000ba0:	0a5030ef          	jal	ra,80004444 <k_is_in_isr>
80000ba4:	02050463          	beqz	a0,80000bcc <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000ba8:	09d030ef          	jal	ra,80004444 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000bac:	04051663          	bnez	a0,80000bf8 <z_SysFatalErrorHandler+0x6c>
80000bb0:	800065b7          	lui	a1,0x80006
80000bb4:	93858593          	addi	a1,a1,-1736 # 80005938 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005939>
80000bb8:	80006537          	lui	a0,0x80006
80000bbc:	94c50513          	addi	a0,a0,-1716 # 8000594c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000594d>
80000bc0:	1b0010ef          	jal	ra,80001d70 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000bc4:	21c010ef          	jal	ra,80001de0 <k_cpu_idle>
80000bc8:	ffdff06f          	j	80000bc4 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000bcc:	089030ef          	jal	ra,80004454 <z_is_thread_essential>
80000bd0:	fc051ce3          	bnez	a0,80000ba8 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000bd4:	80006437          	lui	s0,0x80006
80000bd8:	48440413          	addi	s0,s0,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80000bdc:	00842583          	lw	a1,8(s0)
80000be0:	80006537          	lui	a0,0x80006
80000be4:	96c50513          	addi	a0,a0,-1684 # 8000596c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000596d>
80000be8:	188010ef          	jal	ra,80001d70 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000bec:	00842503          	lw	a0,8(s0)
80000bf0:	4cd030ef          	jal	ra,800048bc <z_impl_k_thread_abort>
80000bf4:	fd1ff06f          	j	80000bc4 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80000bf8:	800065b7          	lui	a1,0x80006
80000bfc:	93458593          	addi	a1,a1,-1740 # 80005934 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005935>
80000c00:	fb9ff06f          	j	80000bb8 <z_SysFatalErrorHandler+0x2c>

80000c04 <z_NanoFatalErrorHandler>:
{
80000c04:	fb010113          	addi	sp,sp,-80
80000c08:	04812423          	sw	s0,72(sp)
80000c0c:	04912223          	sw	s1,68(sp)
80000c10:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000c14:	00600793          	li	a5,6
{
80000c18:	00050493          	mv	s1,a0
80000c1c:	00058413          	mv	s0,a1
	switch (reason) {
80000c20:	0ea7e063          	bltu	a5,a0,80000d00 <z_NanoFatalErrorHandler+0xfc>
80000c24:	80005737          	lui	a4,0x80005
80000c28:	00251793          	slli	a5,a0,0x2
80000c2c:	68870713          	addi	a4,a4,1672 # 80005688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005689>
80000c30:	00e787b3          	add	a5,a5,a4
80000c34:	0007a783          	lw	a5,0(a5)
80000c38:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000c3c:	80005537          	lui	a0,0x80005
80000c40:	7b850513          	addi	a0,a0,1976 # 800057b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b9>
		printk("***** Kernel OOPS! *****\n");
80000c44:	12c010ef          	jal	ra,80001d70 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000c48:	45c030ef          	jal	ra,800040a4 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000c4c:	04442783          	lw	a5,68(s0)
80000c50:	01042883          	lw	a7,16(s0)
80000c54:	00c42803          	lw	a6,12(s0)
80000c58:	02f12823          	sw	a5,48(sp)
80000c5c:	04042783          	lw	a5,64(s0)
80000c60:	00442703          	lw	a4,4(s0)
80000c64:	00042683          	lw	a3,0(s0)
80000c68:	02f12623          	sw	a5,44(sp)
80000c6c:	03c42783          	lw	a5,60(s0)
80000c70:	04842603          	lw	a2,72(s0)
80000c74:	00050593          	mv	a1,a0
80000c78:	02f12423          	sw	a5,40(sp)
80000c7c:	03842783          	lw	a5,56(s0)
80000c80:	80006537          	lui	a0,0x80006
80000c84:	83c50513          	addi	a0,a0,-1988 # 8000583c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000583d>
80000c88:	02f12223          	sw	a5,36(sp)
80000c8c:	03442783          	lw	a5,52(s0)
80000c90:	02f12023          	sw	a5,32(sp)
80000c94:	03042783          	lw	a5,48(s0)
80000c98:	00f12e23          	sw	a5,28(sp)
80000c9c:	02c42783          	lw	a5,44(s0)
80000ca0:	00f12c23          	sw	a5,24(sp)
80000ca4:	02842783          	lw	a5,40(s0)
80000ca8:	00f12a23          	sw	a5,20(sp)
80000cac:	02442783          	lw	a5,36(s0)
80000cb0:	00f12823          	sw	a5,16(sp)
80000cb4:	02042783          	lw	a5,32(s0)
80000cb8:	00f12623          	sw	a5,12(sp)
80000cbc:	01c42783          	lw	a5,28(s0)
80000cc0:	00f12423          	sw	a5,8(sp)
80000cc4:	01842783          	lw	a5,24(s0)
80000cc8:	00f12223          	sw	a5,4(sp)
80000ccc:	01442783          	lw	a5,20(s0)
80000cd0:	00f12023          	sw	a5,0(sp)
80000cd4:	00842783          	lw	a5,8(s0)
80000cd8:	098010ef          	jal	ra,80001d70 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000cdc:	00040593          	mv	a1,s0
80000ce0:	00048513          	mv	a0,s1
80000ce4:	ea9ff0ef          	jal	ra,80000b8c <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000ce8:	80005537          	lui	a0,0x80005
80000cec:	7e050513          	addi	a0,a0,2016 # 800057e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e1>
80000cf0:	f55ff06f          	j	80000c44 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000cf4:	80005537          	lui	a0,0x80005
80000cf8:	7fc50513          	addi	a0,a0,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80000cfc:	f49ff06f          	j	80000c44 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000d00:	80006537          	lui	a0,0x80006
80000d04:	00048593          	mv	a1,s1
80000d08:	81850513          	addi	a0,a0,-2024 # 80005818 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005819>
80000d0c:	064010ef          	jal	ra,80001d70 <printk>
		break;
80000d10:	f39ff06f          	j	80000c48 <z_NanoFatalErrorHandler+0x44>

80000d14 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000d14:	ff010113          	addi	sp,sp,-16
80000d18:	00812423          	sw	s0,8(sp)
80000d1c:	00112623          	sw	ra,12(sp)
80000d20:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000d24:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000d28:	00161613          	slli	a2,a2,0x1
80000d2c:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000d30:	00500793          	li	a5,5
80000d34:	02c7e863          	bltu	a5,a2,80000d64 <_Fault+0x50>
80000d38:	80005737          	lui	a4,0x80005
80000d3c:	00261793          	slli	a5,a2,0x2
80000d40:	6a470713          	addi	a4,a4,1700 # 800056a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056a5>
80000d44:	00f707b3          	add	a5,a4,a5
80000d48:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000d4c:	80005537          	lui	a0,0x80005
80000d50:	6c450513          	addi	a0,a0,1732 # 800056c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056c5>
80000d54:	01c010ef          	jal	ra,80001d70 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000d58:	00040593          	mv	a1,s0
80000d5c:	00000513          	li	a0,0
80000d60:	ea5ff0ef          	jal	ra,80000c04 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d64:	800055b7          	lui	a1,0x80005
80000d68:	6bc58593          	addi	a1,a1,1724 # 800056bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056bd>
80000d6c:	fe1ff06f          	j	80000d4c <_Fault+0x38>

80000d70 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000d70:	ff010113          	addi	sp,sp,-16
80000d74:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000d78:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d7c:	80006537          	lui	a0,0x80006
	mcause &= SOC_MCAUSE_EXP_MASK;
80000d80:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000d84:	0015d593          	srli	a1,a1,0x1
80000d88:	99450513          	addi	a0,a0,-1644 # 80005994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005995>
80000d8c:	7e5000ef          	jal	ra,80001d70 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000d90:	800055b7          	lui	a1,0x80005
80000d94:	6e058593          	addi	a1,a1,1760 # 800056e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e1>
80000d98:	00400513          	li	a0,4
80000d9c:	e69ff0ef          	jal	ra,80000c04 <z_NanoFatalErrorHandler>

80000da0 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000da0:	800067b7          	lui	a5,0x80006
80000da4:	0bc78793          	addi	a5,a5,188 # 800060bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060bd>
80000da8:	0007a703          	lw	a4,0(a5)
80000dac:	00070c63          	beqz	a4,80000dc4 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000db0:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000db4:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000db8:	800067b7          	lui	a5,0x80006
80000dbc:	0c07a503          	lw	a0,192(a5) # 800060c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c1>
80000dc0:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000dc4:	00008067          	ret

80000dc8 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000dc8:	ff010113          	addi	sp,sp,-16
80000dcc:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000dd0:	249010ef          	jal	ra,80002818 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000dd4:	02c010ef          	jal	ra,80001e00 <soc_interrupt_init>
#endif
	z_cstart();
80000dd8:	2ad010ef          	jal	ra,80002884 <z_cstart>

80000ddc <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000ddc:	00006117          	auipc	sp,0x6
80000de0:	6d410113          	addi	sp,sp,1748 # 800074b0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000de4:	000012b7          	lui	t0,0x1
80000de8:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000dec:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000df0:	fd9ff0ef          	jal	ra,80000dc8 <_PrepC>

80000df4 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000df4:	1110006f          	j	80001704 <z_thread_entry>

80000df8 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000df8:	fd010113          	addi	sp,sp,-48
80000dfc:	02812423          	sw	s0,40(sp)
80000e00:	02912223          	sw	s1,36(sp)
80000e04:	03212023          	sw	s2,32(sp)
80000e08:	01312e23          	sw	s3,28(sp)
80000e0c:	01412c23          	sw	s4,24(sp)
80000e10:	01512a23          	sw	s5,20(sp)
80000e14:	01612823          	sw	s6,16(sp)
80000e18:	01712623          	sw	s7,12(sp)
80000e1c:	00078b13          	mv	s6,a5
80000e20:	02112623          	sw	ra,44(sp)
80000e24:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e28:	00f00793          	li	a5,15
{
80000e2c:	00050493          	mv	s1,a0
80000e30:	00058413          	mv	s0,a1
80000e34:	00060993          	mv	s3,a2
80000e38:	00068a13          	mv	s4,a3
80000e3c:	00070b93          	mv	s7,a4
80000e40:	00080a93          	mv	s5,a6
80000e44:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000e48:	08f89a63          	bne	a7,a5,80000edc <z_new_thread+0xe4>
80000e4c:	800027b7          	lui	a5,0x80002
80000e50:	7e078793          	addi	a5,a5,2016 # 800027e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027e1>
80000e54:	08f69a63          	bne	a3,a5,80000ee8 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000e58:	03012683          	lw	a3,48(sp)
80000e5c:	00090593          	mv	a1,s2
80000e60:	00048513          	mv	a0,s1
80000e64:	00400613          	li	a2,4
80000e68:	6b0030ef          	jal	ra,80004518 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000e6c:	fb098593          	addi	a1,s3,-80
80000e70:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000e74:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000e78:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000e7c:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000e80:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000e84:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000e88:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000e8c:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000e90:	02c12083          	lw	ra,44(sp)
80000e94:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000e98:	df478793          	addi	a5,a5,-524 # 80000df4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000df5>
	stack_init->a0 = (u32_t)thread_func;
80000e9c:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000ea0:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000ea4:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000ea8:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000eac:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000eb0:	02b4a423          	sw	a1,40(s1)
}
80000eb4:	02012903          	lw	s2,32(sp)
80000eb8:	02412483          	lw	s1,36(sp)
80000ebc:	01c12983          	lw	s3,28(sp)
80000ec0:	01812a03          	lw	s4,24(sp)
80000ec4:	01412a83          	lw	s5,20(sp)
80000ec8:	01012b03          	lw	s6,16(sp)
80000ecc:	00c12b83          	lw	s7,12(sp)
80000ed0:	00812c03          	lw	s8,8(sp)
80000ed4:	03010113          	addi	sp,sp,48
80000ed8:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000edc:	01088693          	addi	a3,a7,16
80000ee0:	01e00793          	li	a5,30
80000ee4:	f6d7fae3          	bgeu	a5,a3,80000e58 <z_new_thread+0x60>
80000ee8:	80006c37          	lui	s8,0x80006
80000eec:	800065b7          	lui	a1,0x80006
80000ef0:	80006537          	lui	a0,0x80006
80000ef4:	9bcc0613          	addi	a2,s8,-1604 # 800059bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059bd>
80000ef8:	01800693          	li	a3,24
80000efc:	9dc58593          	addi	a1,a1,-1572 # 800059dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059dd>
80000f00:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80000f04:	66d000ef          	jal	ra,80001d70 <printk>
80000f08:	80006537          	lui	a0,0x80006
80000f0c:	00090593          	mv	a1,s2
80000f10:	ff000693          	li	a3,-16
80000f14:	00e00613          	li	a2,14
80000f18:	a8850513          	addi	a0,a0,-1400 # 80005a88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a89>
80000f1c:	655000ef          	jal	ra,80001d70 <printk>
80000f20:	01800593          	li	a1,24
80000f24:	9bcc0513          	addi	a0,s8,-1604
80000f28:	685000ef          	jal	ra,80001dac <assert_post_action>
80000f2c:	f2dff06f          	j	80000e58 <z_new_thread+0x60>

80000f30 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000f30:	00159793          	slli	a5,a1,0x1
80000f34:	00b787b3          	add	a5,a5,a1
80000f38:	00279713          	slli	a4,a5,0x2
80000f3c:	00c52783          	lw	a5,12(a0)
80000f40:	00e787b3          	add	a5,a5,a4
80000f44:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000f48:	00b75463          	bge	a4,a1,80000f50 <get_bit_ptr+0x20>
80000f4c:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000f50:	41f65713          	srai	a4,a2,0x1f
80000f54:	01f77713          	andi	a4,a4,31
80000f58:	00c70733          	add	a4,a4,a2
80000f5c:	40575713          	srai	a4,a4,0x5
80000f60:	00271713          	slli	a4,a4,0x2
80000f64:	00e787b3          	add	a5,a5,a4
80000f68:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80000f6c:	01f67513          	andi	a0,a2,31
80000f70:	00008067          	ret

80000f74 <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000f74:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000f78:	00c10693          	addi	a3,sp,12
{
80000f7c:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000f80:	fb1ff0ef          	jal	ra,80000f30 <get_bit_ptr>

	*word |= (1<<bit);
80000f84:	00c12703          	lw	a4,12(sp)
80000f88:	00100793          	li	a5,1
80000f8c:	00a79533          	sll	a0,a5,a0
80000f90:	00072783          	lw	a5,0(a4)
}
80000f94:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80000f98:	00a7e7b3          	or	a5,a5,a0
80000f9c:	00f72023          	sw	a5,0(a4)
}
80000fa0:	02010113          	addi	sp,sp,32
80000fa4:	00008067          	ret

80000fa8 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000fa8:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000fac:	00c10693          	addi	a3,sp,12
{
80000fb0:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000fb4:	f7dff0ef          	jal	ra,80000f30 <get_bit_ptr>

	*word &= ~(1<<bit);
80000fb8:	00c12703          	lw	a4,12(sp)
80000fbc:	00100793          	li	a5,1
80000fc0:	00a79533          	sll	a0,a5,a0
80000fc4:	00072783          	lw	a5,0(a4)
}
80000fc8:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000fcc:	fff54513          	not	a0,a0
80000fd0:	00a7f533          	and	a0,a5,a0
80000fd4:	00a72023          	sw	a0,0(a4)
}
80000fd8:	02010113          	addi	sp,sp,32
80000fdc:	00008067          	ret

80000fe0 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80000fe0:	fe010113          	addi	sp,sp,-32
80000fe4:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000fe8:	00452483          	lw	s1,4(a0)
{
80000fec:	00812c23          	sw	s0,24(sp)
80000ff0:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000ff4:	00855503          	lhu	a0,8(a0)
80000ff8:	00048593          	mv	a1,s1
{
80000ffc:	01212823          	sw	s2,16(sp)
80001000:	01312623          	sw	s3,12(sp)
80001004:	01412423          	sw	s4,8(sp)
80001008:	01512223          	sw	s5,4(sp)
8000100c:	01612023          	sw	s6,0(sp)
80001010:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001014:	871ff0ef          	jal	ra,80000884 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001018:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
8000101c:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001020:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001024:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001028:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
8000102c:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001030:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001034:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001038:	03594c63          	blt	s2,s5,80001070 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
8000103c:	00000493          	li	s1,0
80001040:	00845783          	lhu	a5,8(s0)
80001044:	08f4cc63          	blt	s1,a5,800010dc <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001048:	01c12083          	lw	ra,28(sp)
8000104c:	01812403          	lw	s0,24(sp)
80001050:	01412483          	lw	s1,20(sp)
80001054:	01012903          	lw	s2,16(sp)
80001058:	00c12983          	lw	s3,12(sp)
8000105c:	00812a03          	lw	s4,8(sp)
80001060:	00412a83          	lw	s5,4(sp)
80001064:	00012b03          	lw	s6,0(sp)
80001068:	02010113          	addi	sp,sp,32
8000106c:	00008067          	ret
		int nblocks = buflen / sz;
80001070:	00048593          	mv	a1,s1
80001074:	000a0513          	mv	a0,s4
80001078:	839ff0ef          	jal	ra,800008b0 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
8000107c:	00191713          	slli	a4,s2,0x1
80001080:	01270733          	add	a4,a4,s2
80001084:	00271793          	slli	a5,a4,0x2
80001088:	00c42703          	lw	a4,12(s0)
8000108c:	00f70733          	add	a4,a4,a5
80001090:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001094:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001098:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
8000109c:	00ab4e63          	blt	s6,a0,800010b8 <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
800010a0:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800010a4:	0024d493          	srli	s1,s1,0x2
800010a8:	00348493          	addi	s1,s1,3
800010ac:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800010b0:	00190913          	addi	s2,s2,1
800010b4:	f85ff06f          	j	80001038 <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
800010b8:	01f50513          	addi	a0,a0,31
800010bc:	41f55793          	srai	a5,a0,0x1f
800010c0:	01f7f793          	andi	a5,a5,31
800010c4:	00a787b3          	add	a5,a5,a0
800010c8:	4057d793          	srai	a5,a5,0x5
800010cc:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
800010d0:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
800010d4:	00f989b3          	add	s3,s3,a5
800010d8:	fcdff06f          	j	800010a4 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
800010dc:	00442583          	lw	a1,4(s0)
800010e0:	00048513          	mv	a0,s1
800010e4:	fa0ff0ef          	jal	ra,80000884 <__mulsi3>
800010e8:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
800010ec:	00048613          	mv	a2,s1
800010f0:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
800010f4:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
800010f8:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
800010fc:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001100:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001104:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001108:	0087a703          	lw	a4,8(a5)
8000110c:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001110:	0087a703          	lw	a4,8(a5)
80001114:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001118:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
8000111c:	00040513          	mv	a0,s0
80001120:	e55ff0ef          	jal	ra,80000f74 <set_free_bit>
80001124:	f1dff06f          	j	80001040 <z_sys_mem_pool_base_init+0x60>

80001128 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80001128:	fa010113          	addi	sp,sp,-96
8000112c:	04812c23          	sw	s0,88(sp)
80001130:	05512223          	sw	s5,68(sp)
80001134:	04112e23          	sw	ra,92(sp)
80001138:	04912a23          	sw	s1,84(sp)
8000113c:	05212823          	sw	s2,80(sp)
80001140:	05312623          	sw	s3,76(sp)
80001144:	05412423          	sw	s4,72(sp)
80001148:	05612023          	sw	s6,64(sp)
8000114c:	03712e23          	sw	s7,60(sp)
80001150:	03812c23          	sw	s8,56(sp)
80001154:	03912a23          	sw	s9,52(sp)
80001158:	03a12823          	sw	s10,48(sp)
8000115c:	03b12623          	sw	s11,44(sp)
80001160:	06010413          	addi	s0,sp,96
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001164:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80001168:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000116c:	002e1793          	slli	a5,t3,0x2
80001170:	00f78793          	addi	a5,a5,15
80001174:	7f07f793          	andi	a5,a5,2032
80001178:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
8000117c:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001180:	00010a93          	mv	s5,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001184:	000a8313          	mv	t1,s5
80001188:	00378793          	addi	a5,a5,3
8000118c:	ffc7f793          	andi	a5,a5,-4
80001190:	00faa023          	sw	a5,0(s5)
	for (i = 0; i < p->n_levels; i++) {
80001194:	fff88b13          	addi	s6,a7,-1
80001198:	03c8d463          	bge	a7,t3,800011c0 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
8000119c:	00088c63          	beqz	a7,800011b4 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
800011a0:	ffc32803          	lw	a6,-4(t1)
800011a4:	00285813          	srli	a6,a6,0x2
800011a8:	00380813          	addi	a6,a6,3
800011ac:	ffc87813          	andi	a6,a6,-4
800011b0:	01032023          	sw	a6,0(t1)
		}

		if (lsizes[i] < size) {
800011b4:	00430313          	addi	t1,t1,4
800011b8:	ffc32803          	lw	a6,-4(t1)
800011bc:	04b87a63          	bgeu	a6,a1,80001210 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
800011c0:	fff00593          	li	a1,-1
800011c4:	04bb1a63          	bne	s6,a1,80001218 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
800011c8:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
800011cc:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
800011d0:	fa040113          	addi	sp,s0,-96
800011d4:	05c12083          	lw	ra,92(sp)
800011d8:	05812403          	lw	s0,88(sp)
800011dc:	05412483          	lw	s1,84(sp)
800011e0:	05012903          	lw	s2,80(sp)
800011e4:	04c12983          	lw	s3,76(sp)
800011e8:	04812a03          	lw	s4,72(sp)
800011ec:	04412a83          	lw	s5,68(sp)
800011f0:	04012b03          	lw	s6,64(sp)
800011f4:	03c12b83          	lw	s7,60(sp)
800011f8:	03812c03          	lw	s8,56(sp)
800011fc:	03412c83          	lw	s9,52(sp)
80001200:	03012d03          	lw	s10,48(sp)
80001204:	02c12d83          	lw	s11,44(sp)
80001208:	06010113          	addi	sp,sp,96
8000120c:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80001210:	00188893          	addi	a7,a7,1
80001214:	f81ff06f          	j	80001194 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001218:	01054583          	lbu	a1,16(a0)
		return 0;
8000121c:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001220:	0015f593          	andi	a1,a1,1
80001224:	00058863          	beqz	a1,80001234 <z_sys_mem_pool_block_alloc+0x10c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80001228:	00800913          	li	s2,8
8000122c:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80001230:	00897913          	andi	s2,s2,8
80001234:	fae42a23          	sw	a4,-76(s0)
80001238:	001b1713          	slli	a4,s6,0x1
8000123c:	fad42c23          	sw	a3,-72(s0)
80001240:	01670733          	add	a4,a4,s6
80001244:	00c52683          	lw	a3,12(a0)
80001248:	00271713          	slli	a4,a4,0x2
8000124c:	00470713          	addi	a4,a4,4
80001250:	00e68733          	add	a4,a3,a4
80001254:	fac42e23          	sw	a2,-68(s0)
80001258:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
8000125c:	000b0a13          	mv	s4,s6
	for (i = alloc_l; i >= 0; i--) {
80001260:	fff00693          	li	a3,-1
	return list->head == list;
80001264:	00072983          	lw	s3,0(a4)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80001268:	19370663          	beq	a4,s3,800013f4 <z_sys_mem_pool_block_alloc+0x2cc>
		data = block_alloc(p, i, lsizes[i]);
8000126c:	002a1713          	slli	a4,s4,0x2
	node->prev->next = node->next;
80001270:	0049a683          	lw	a3,4(s3)
80001274:	00ea8cb3          	add	s9,s5,a4
80001278:	0009a703          	lw	a4,0(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000127c:	000ca583          	lw	a1,0(s9)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001280:	00800d13          	li	s10,8
80001284:	00e6a023          	sw	a4,0(a3)
	node->next->prev = node->prev;
80001288:	00d72223          	sw	a3,4(a4)
	node->next = NULL;
8000128c:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80001290:	0009a223          	sw	zero,4(s3)
80001294:	0004a503          	lw	a0,0(s1)
80001298:	40a98533          	sub	a0,s3,a0
8000129c:	e0cff0ef          	jal	ra,800008a8 <__divsi3>
		clear_free_bit(p, l, block_num(p, block, lsz));
800012a0:	00050613          	mv	a2,a0
800012a4:	000a0593          	mv	a1,s4
800012a8:	00048513          	mv	a0,s1
800012ac:	cfdff0ef          	jal	ra,80000fa8 <clear_free_bit>
		if (data != NULL) {
800012b0:	001a0a13          	addi	s4,s4,1
			for (from_l = i; from_l < alloc_l; from_l++) {
800012b4:	fffa0693          	addi	a3,s4,-1
800012b8:	0566ca63          	blt	a3,s6,8000130c <z_sys_mem_pool_block_alloc+0x1e4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800012bc:	0104c703          	lbu	a4,16(s1)
800012c0:	00177713          	andi	a4,a4,1
800012c4:	00070463          	beqz	a4,800012cc <z_sys_mem_pool_block_alloc+0x1a4>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
800012c8:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
800012cc:	fb442783          	lw	a5,-76(s0)
		return -ENOMEM;
800012d0:	ff400513          	li	a0,-12
	*data_p = data;
800012d4:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
800012d8:	ee098ce3          	beqz	s3,800011d0 <z_sys_mem_pool_block_alloc+0xa8>
	*level_p = alloc_l;
800012dc:	fbc42783          	lw	a5,-68(s0)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800012e0:	0004a503          	lw	a0,0(s1)
	*level_p = alloc_l;
800012e4:	0167a023          	sw	s6,0(a5)
	*block_p = block_num(p, data, lsizes[alloc_l]);
800012e8:	002b1793          	slli	a5,s6,0x2
800012ec:	00fa8ab3          	add	s5,s5,a5
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
800012f0:	000aa583          	lw	a1,0(s5)
800012f4:	40a98533          	sub	a0,s3,a0
800012f8:	db0ff0ef          	jal	ra,800008a8 <__divsi3>
	*block_p = block_num(p, data, lsizes[alloc_l]);
800012fc:	fb842783          	lw	a5,-72(s0)
80001300:	00a7a023          	sw	a0,0(a5)
	return 0;
80001304:	00000513          	li	a0,0
80001308:	ec9ff06f          	j	800011d0 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000130c:	0004a503          	lw	a0,0(s1)
80001310:	000ca583          	lw	a1,0(s9)
	for (i = 1; i < 4; i++) {
80001314:	00100b93          	li	s7,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001318:	40a98533          	sub	a0,s3,a0
8000131c:	d8cff0ef          	jal	ra,800008a8 <__divsi3>
80001320:	001a1893          	slli	a7,s4,0x1
80001324:	014888b3          	add	a7,a7,s4
		int lbn = 4*bn + i;
80001328:	00251d93          	slli	s11,a0,0x2
8000132c:	00289893          	slli	a7,a7,0x2
		int lsz = lsizes[l + 1];
80001330:	004ca683          	lw	a3,4(s9)
		void *block2 = (lsz * i) + (char *)block;
80001334:	000b8593          	mv	a1,s7
80001338:	fb142623          	sw	a7,-84(s0)
8000133c:	00068513          	mv	a0,a3
80001340:	fad42823          	sw	a3,-80(s0)
80001344:	d40ff0ef          	jal	ra,80000884 <__mulsi3>
80001348:	00a98c33          	add	s8,s3,a0
		set_free_bit(p, l + 1, lbn);
8000134c:	01bb8633          	add	a2,s7,s11
80001350:	000a0593          	mv	a1,s4
80001354:	00048513          	mv	a0,s1
80001358:	c1dff0ef          	jal	ra,80000f74 <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000135c:	fb042683          	lw	a3,-80(s0)
80001360:	0004a603          	lw	a2,0(s1)
	return p->n_max * p->max_sz;
80001364:	0044a583          	lw	a1,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001368:	fff68693          	addi	a3,a3,-1
	return p->n_max * p->max_sz;
8000136c:	0084d503          	lhu	a0,8(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001370:	00dc06b3          	add	a3,s8,a3
80001374:	40c686b3          	sub	a3,a3,a2
80001378:	fad42823          	sw	a3,-80(s0)
	return p->n_max * p->max_sz;
8000137c:	d08ff0ef          	jal	ra,80000884 <__mulsi3>
		if (block_fits(p, block2, lsz)) {
80001380:	fb042683          	lw	a3,-80(s0)
80001384:	fac42883          	lw	a7,-84(s0)
80001388:	02a6f463          	bgeu	a3,a0,800013b0 <z_sys_mem_pool_block_alloc+0x288>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
8000138c:	00c4a683          	lw	a3,12(s1)
80001390:	011686b3          	add	a3,a3,a7
80001394:	00468613          	addi	a2,a3,4
	node->next = list;
80001398:	00cc2023          	sw	a2,0(s8)
	node->prev = list->tail;
8000139c:	0086a603          	lw	a2,8(a3)
800013a0:	00cc2223          	sw	a2,4(s8)
	list->tail->next = node;
800013a4:	0086a603          	lw	a2,8(a3)
800013a8:	01862023          	sw	s8,0(a2)
	list->tail = node;
800013ac:	0186a423          	sw	s8,8(a3)
	for (i = 1; i < 4; i++) {
800013b0:	001b8b93          	addi	s7,s7,1
800013b4:	00400793          	li	a5,4
800013b8:	f6fb9ce3          	bne	s7,a5,80001330 <z_sys_mem_pool_block_alloc+0x208>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013bc:	0104c683          	lbu	a3,16(s1)
800013c0:	0016f693          	andi	a3,a3,1
800013c4:	00069a63          	bnez	a3,800013d8 <z_sys_mem_pool_block_alloc+0x2b0>
		return 0;
800013c8:	00000913          	li	s2,0
800013cc:	001a0a13          	addi	s4,s4,1
800013d0:	004c8c93          	addi	s9,s9,4
800013d4:	ee1ff06f          	j	800012b4 <z_sys_mem_pool_block_alloc+0x18c>
800013d8:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013dc:	0104c683          	lbu	a3,16(s1)
800013e0:	0016f693          	andi	a3,a3,1
800013e4:	fe0682e3          	beqz	a3,800013c8 <z_sys_mem_pool_block_alloc+0x2a0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800013e8:	300d3973          	csrrc	s2,mstatus,s10
	key = (mstatus & SOC_MSTATUS_IEN);
800013ec:	00897913          	andi	s2,s2,8
800013f0:	fddff06f          	j	800013cc <z_sys_mem_pool_block_alloc+0x2a4>
	for (i = alloc_l; i >= 0; i--) {
800013f4:	fffa0a13          	addi	s4,s4,-1
800013f8:	ff498713          	addi	a4,s3,-12
800013fc:	e6da14e3          	bne	s4,a3,80001264 <z_sys_mem_pool_block_alloc+0x13c>
80001400:	00000993          	li	s3,0
80001404:	eb9ff06f          	j	800012bc <z_sys_mem_pool_block_alloc+0x194>

80001408 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001408:	fa010113          	addi	sp,sp,-96
8000140c:	04812c23          	sw	s0,88(sp)
80001410:	05412423          	sw	s4,72(sp)
80001414:	03912a23          	sw	s9,52(sp)
80001418:	04112e23          	sw	ra,92(sp)
8000141c:	04912a23          	sw	s1,84(sp)
80001420:	05212823          	sw	s2,80(sp)
80001424:	05312623          	sw	s3,76(sp)
80001428:	05512223          	sw	s5,68(sp)
8000142c:	05612023          	sw	s6,64(sp)
80001430:	03712e23          	sw	s7,60(sp)
80001434:	03812c23          	sw	s8,56(sp)
80001438:	03a12823          	sw	s10,48(sp)
8000143c:	03b12623          	sw	s11,44(sp)
80001440:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001444:	00a54703          	lbu	a4,10(a0)
{
80001448:	00050c93          	mv	s9,a0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000144c:	00271713          	slli	a4,a4,0x2
80001450:	00f70713          	addi	a4,a4,15
80001454:	7f077713          	andi	a4,a4,2032
80001458:	40e10133          	sub	sp,sp,a4
	 * to avoid having to store it in precious RAM bytes.
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
8000145c:	00452703          	lw	a4,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001460:	00010a13          	mv	s4,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001464:	000a0693          	mv	a3,s4
80001468:	00370713          	addi	a4,a4,3
8000146c:	ffc77713          	andi	a4,a4,-4
80001470:	00ea2023          	sw	a4,0(s4)
	for (i = 1; i <= level; i++) {
80001474:	00100513          	li	a0,1
80001478:	00468693          	addi	a3,a3,4
8000147c:	0ca5f063          	bgeu	a1,a0,8000153c <z_sys_mem_pool_block_free+0x134>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001480:	010cc703          	lbu	a4,16(s9)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
80001484:	00058913          	mv	s2,a1
80001488:	00060993          	mv	s3,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000148c:	00177713          	andi	a4,a4,1
		return 0;
80001490:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001494:	00070863          	beqz	a4,800014a4 <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001498:	00800493          	li	s1,8
8000149c:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800014a0:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800014a4:	80006b37          	lui	s6,0x80006
	while (level >= 0) {
800014a8:	0a095863          	bgez	s2,80001558 <z_sys_mem_pool_block_free+0x150>
	__ASSERT(0, "out of levels");
800014ac:	800064b7          	lui	s1,0x80006
800014b0:	800065b7          	lui	a1,0x80006
800014b4:	80006537          	lui	a0,0x80006
800014b8:	abc48613          	addi	a2,s1,-1348 # 80005abc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005abd>
800014bc:	0c000693          	li	a3,192
800014c0:	b2458593          	addi	a1,a1,-1244 # 80005b24 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b25>
800014c4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800014c8:	0a9000ef          	jal	ra,80001d70 <printk>
800014cc:	80006537          	lui	a0,0x80006
800014d0:	af050513          	addi	a0,a0,-1296 # 80005af0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005af1>
800014d4:	09d000ef          	jal	ra,80001d70 <printk>
800014d8:	abc48513          	addi	a0,s1,-1348
800014dc:	0c000593          	li	a1,192
800014e0:	0cd000ef          	jal	ra,80001dac <assert_post_action>
	return -1;
800014e4:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800014e8:	010cc783          	lbu	a5,16(s9)
800014ec:	0017f793          	andi	a5,a5,1
800014f0:	00078663          	beqz	a5,800014fc <z_sys_mem_pool_block_free+0xf4>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800014f4:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800014f8:	3004a4f3          	csrrs	s1,mstatus,s1
}
800014fc:	fa040113          	addi	sp,s0,-96
80001500:	05c12083          	lw	ra,92(sp)
80001504:	05812403          	lw	s0,88(sp)
80001508:	05412483          	lw	s1,84(sp)
8000150c:	05012903          	lw	s2,80(sp)
80001510:	04c12983          	lw	s3,76(sp)
80001514:	04812a03          	lw	s4,72(sp)
80001518:	04412a83          	lw	s5,68(sp)
8000151c:	04012b03          	lw	s6,64(sp)
80001520:	03c12b83          	lw	s7,60(sp)
80001524:	03812c03          	lw	s8,56(sp)
80001528:	03412c83          	lw	s9,52(sp)
8000152c:	03012d03          	lw	s10,48(sp)
80001530:	02c12d83          	lw	s11,44(sp)
80001534:	06010113          	addi	sp,sp,96
80001538:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000153c:	ffc6a703          	lw	a4,-4(a3)
	for (i = 1; i <= level; i++) {
80001540:	00150513          	addi	a0,a0,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001544:	00275713          	srli	a4,a4,0x2
80001548:	00370713          	addi	a4,a4,3
8000154c:	ffc77713          	andi	a4,a4,-4
80001550:	00e6a023          	sw	a4,0(a3)
80001554:	f25ff06f          	j	80001478 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001558:	00291713          	slli	a4,s2,0x2
8000155c:	00ea0733          	add	a4,s4,a4
80001560:	00072a83          	lw	s5,0(a4)
		void *block = block_ptr(p, lsz, bn);
80001564:	000cac03          	lw	s8,0(s9)
	return (u8_t *)p->buf + lsz * block;
80001568:	00098513          	mv	a0,s3
8000156c:	000a8593          	mv	a1,s5
80001570:	b14ff0ef          	jal	ra,80000884 <__mulsi3>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001574:	fffa8b93          	addi	s7,s5,-1
80001578:	01750d33          	add	s10,a0,s7
8000157c:	00ac0c33          	add	s8,s8,a0
	return p->n_max * p->max_sz;
80001580:	004ca583          	lw	a1,4(s9)
80001584:	008cd503          	lhu	a0,8(s9)
80001588:	afcff0ef          	jal	ra,80000884 <__mulsi3>
		__ASSERT(block_fits(p, block, lsz), "");
8000158c:	02ad6c63          	bltu	s10,a0,800015c4 <z_sys_mem_pool_block_free+0x1bc>
80001590:	800067b7          	lui	a5,0x80006
80001594:	ad078593          	addi	a1,a5,-1328 # 80005ad0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ad1>
80001598:	800067b7          	lui	a5,0x80006
8000159c:	a6878513          	addi	a0,a5,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800015a0:	0a400693          	li	a3,164
800015a4:	abcb0613          	addi	a2,s6,-1348 # 80005abc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005abd>
800015a8:	7c8000ef          	jal	ra,80001d70 <printk>
800015ac:	800067b7          	lui	a5,0x80006
800015b0:	aec78513          	addi	a0,a5,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800015b4:	7bc000ef          	jal	ra,80001d70 <printk>
800015b8:	0a400593          	li	a1,164
800015bc:	abcb0513          	addi	a0,s6,-1348
800015c0:	7ec000ef          	jal	ra,80001dac <assert_post_action>
		set_free_bit(p, level, bn);
800015c4:	00098613          	mv	a2,s3
800015c8:	00090593          	mv	a1,s2
800015cc:	000c8513          	mv	a0,s9
800015d0:	9a5ff0ef          	jal	ra,80000f74 <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800015d4:	00191713          	slli	a4,s2,0x1
800015d8:	01270733          	add	a4,a4,s2
800015dc:	00271693          	slli	a3,a4,0x2
800015e0:	00cca703          	lw	a4,12(s9)
800015e4:	00d70733          	add	a4,a4,a3
800015e8:	00470693          	addi	a3,a4,4
	node->next = list;
800015ec:	00dc2023          	sw	a3,0(s8)
	node->prev = list->tail;
800015f0:	00872683          	lw	a3,8(a4)
800015f4:	00dc2223          	sw	a3,4(s8)
	list->tail->next = node;
800015f8:	00872683          	lw	a3,8(a4)
800015fc:	0186a023          	sw	s8,0(a3)
	list->tail = node;
80001600:	01872423          	sw	s8,8(a4)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001604:	010cc703          	lbu	a4,16(s9)
80001608:	00177713          	andi	a4,a4,1
8000160c:	0c071c63          	bnez	a4,800016e4 <z_sys_mem_pool_block_free+0x2dc>
		return 0;
80001610:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001614:	ec090ae3          	beqz	s2,800014e8 <z_sys_mem_pool_block_free+0xe0>
	int bit = get_bit_ptr(p, level, bn, &word);
80001618:	fbc40693          	addi	a3,s0,-68
8000161c:	00098613          	mv	a2,s3
80001620:	00090593          	mv	a1,s2
80001624:	000c8513          	mv	a0,s9
80001628:	909ff0ef          	jal	ra,80000f30 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
8000162c:	fbc42683          	lw	a3,-68(s0)
80001630:	41f55713          	srai	a4,a0,0x1f
80001634:	00377713          	andi	a4,a4,3
80001638:	00a70733          	add	a4,a4,a0
8000163c:	0006a503          	lw	a0,0(a3)
80001640:	ffc77713          	andi	a4,a4,-4
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001644:	00f00793          	li	a5,15
	return (*word >> (4*(bit / 4))) & 0xf;
80001648:	00e55733          	srl	a4,a0,a4
8000164c:	00f77713          	andi	a4,a4,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001650:	e8f71ce3          	bne	a4,a5,800014e8 <z_sys_mem_pool_block_free+0xe0>
		for (i = 0; i < 4; i++) {
80001654:	00000d13          	li	s10,0
			int b = (bn & ~3) + i;
80001658:	ffc9fd93          	andi	s11,s3,-4
8000165c:	01ad8633          	add	a2,s11,s10
	return (u8_t *)p->buf + lsz * block;
80001660:	00060513          	mv	a0,a2
80001664:	000a8593          	mv	a1,s5
80001668:	fac42423          	sw	a2,-88(s0)
8000166c:	a18ff0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001670:	01750733          	add	a4,a0,s7
	return (u8_t *)p->buf + lsz * block;
80001674:	00050c13          	mv	s8,a0
	return p->n_max * p->max_sz;
80001678:	004ca583          	lw	a1,4(s9)
8000167c:	008cd503          	lhu	a0,8(s9)
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001680:	fae42623          	sw	a4,-84(s0)
	return p->n_max * p->max_sz;
80001684:	a00ff0ef          	jal	ra,80000884 <__mulsi3>
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001688:	fac42703          	lw	a4,-84(s0)
8000168c:	fa842603          	lw	a2,-88(s0)
80001690:	02a77863          	bgeu	a4,a0,800016c0 <z_sys_mem_pool_block_free+0x2b8>
				clear_free_bit(p, level, b);
80001694:	00090593          	mv	a1,s2
80001698:	000c8513          	mv	a0,s9
8000169c:	90dff0ef          	jal	ra,80000fa8 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
800016a0:	000ca703          	lw	a4,0(s9)
800016a4:	01870c33          	add	s8,a4,s8
	node->prev->next = node->next;
800016a8:	004c2603          	lw	a2,4(s8)
800016ac:	000c2703          	lw	a4,0(s8)
800016b0:	00e62023          	sw	a4,0(a2)
	node->next->prev = node->prev;
800016b4:	00c72223          	sw	a2,4(a4)
	node->next = NULL;
800016b8:	000c2023          	sw	zero,0(s8)
	node->prev = NULL;
800016bc:	000c2223          	sw	zero,4(s8)
		for (i = 0; i < 4; i++) {
800016c0:	001d0d13          	addi	s10,s10,1
800016c4:	00400793          	li	a5,4
800016c8:	f8fd1ae3          	bne	s10,a5,8000165c <z_sys_mem_pool_block_free+0x254>
		bn = bn / 4;
800016cc:	41f9d613          	srai	a2,s3,0x1f
800016d0:	00367613          	andi	a2,a2,3
800016d4:	013609b3          	add	s3,a2,s3
		level = level - 1;
800016d8:	fff90913          	addi	s2,s2,-1
		bn = bn / 4;
800016dc:	4029d993          	srai	s3,s3,0x2
800016e0:	dc9ff06f          	j	800014a8 <z_sys_mem_pool_block_free+0xa0>
800016e4:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800016e8:	010cc703          	lbu	a4,16(s9)
800016ec:	00177713          	andi	a4,a4,1
800016f0:	f20700e3          	beqz	a4,80001610 <z_sys_mem_pool_block_free+0x208>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800016f4:	00800793          	li	a5,8
800016f8:	3007b4f3          	csrrc	s1,mstatus,a5
	key = (mstatus & SOC_MSTATUS_IEN);
800016fc:	0084f493          	andi	s1,s1,8
80001700:	f15ff06f          	j	80001614 <z_sys_mem_pool_block_free+0x20c>

80001704 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001704:	ff010113          	addi	sp,sp,-16
80001708:	00050793          	mv	a5,a0
8000170c:	00058513          	mv	a0,a1
80001710:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001714:	00068613          	mv	a2,a3
{
80001718:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
8000171c:	000780e7          	jalr	a5
80001720:	185020ef          	jal	ra,800040a4 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001724:	198030ef          	jal	ra,800048bc <z_impl_k_thread_abort>

80001728 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001728:	00000513          	li	a0,0
8000172c:	00008067          	ret

80001730 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001730:	ff010113          	addi	sp,sp,-16
80001734:	00812423          	sw	s0,8(sp)
80001738:	00050413          	mv	s0,a0
	out('E', ctx);
8000173c:	04500513          	li	a0,69
{
80001740:	00112623          	sw	ra,12(sp)
80001744:	00912223          	sw	s1,4(sp)
80001748:	00058493          	mv	s1,a1
	out('E', ctx);
8000174c:	000400e7          	jalr	s0
	out('R', ctx);
80001750:	00048593          	mv	a1,s1
80001754:	05200513          	li	a0,82
80001758:	000400e7          	jalr	s0
	out('R', ctx);
8000175c:	00040313          	mv	t1,s0
}
80001760:	00812403          	lw	s0,8(sp)
80001764:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001768:	00048593          	mv	a1,s1
}
8000176c:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001770:	05200513          	li	a0,82
}
80001774:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001778:	00030067          	jr	t1

8000177c <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
8000177c:	0005a783          	lw	a5,0(a1)
80001780:	00178793          	addi	a5,a5,1
80001784:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001788:	800067b7          	lui	a5,0x80006
8000178c:	0047a303          	lw	t1,4(a5) # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
80001790:	00030067          	jr	t1

80001794 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001794:	fc010113          	addi	sp,sp,-64
80001798:	02812c23          	sw	s0,56(sp)
8000179c:	03312623          	sw	s3,44(sp)
800017a0:	03412423          	sw	s4,40(sp)
800017a4:	03612023          	sw	s6,32(sp)
800017a8:	01a12823          	sw	s10,16(sp)
800017ac:	02112e23          	sw	ra,60(sp)
800017b0:	02912a23          	sw	s1,52(sp)
800017b4:	03212823          	sw	s2,48(sp)
800017b8:	03512223          	sw	s5,36(sp)
800017bc:	01712e23          	sw	s7,28(sp)
800017c0:	01812c23          	sw	s8,24(sp)
800017c4:	01912a23          	sw	s9,20(sp)
800017c8:	01b12623          	sw	s11,12(sp)
800017cc:	00050993          	mv	s3,a0
800017d0:	00058a13          	mv	s4,a1
800017d4:	00060d13          	mv	s10,a2
800017d8:	00068b13          	mv	s6,a3
800017dc:	00100413          	li	s0,1
800017e0:	00e05463          	blez	a4,800017e8 <_printk_dec_ulong+0x54>
800017e4:	00070413          	mv	s0,a4
800017e8:	00100793          	li	a5,1
800017ec:	02000c93          	li	s9,32
800017f0:	00fb1463          	bne	s6,a5,800017f8 <_printk_dec_ulong+0x64>
800017f4:	03000c93          	li	s9,48
800017f8:	3b9ad4b7          	lui	s1,0x3b9ad
800017fc:	00100913          	li	s2,1
80001800:	00a00a93          	li	s5,10
80001804:	00000c13          	li	s8,0
80001808:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
8000180c:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80001810:	00148b93          	addi	s7,s1,1
80001814:	000c1463          	bnez	s8,8000181c <_printk_dec_ulong+0x88>
80001818:	0ba4f263          	bgeu	s1,s10,800018bc <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000181c:	000b8593          	mv	a1,s7
80001820:	000d0513          	mv	a0,s10
80001824:	88cff0ef          	jal	ra,800008b0 <__udivsi3>
80001828:	000a0593          	mv	a1,s4
8000182c:	03050513          	addi	a0,a0,48
80001830:	000980e7          	jalr	s3
			digits++;
80001834:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
80001838:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
8000183c:	000b8593          	mv	a1,s7
80001840:	000d0513          	mv	a0,s10
80001844:	8b4ff0ef          	jal	ra,800008f8 <__umodsi3>
80001848:	00050d13          	mv	s10,a0
		pos /= 10;
8000184c:	00a00593          	li	a1,10
80001850:	00048513          	mv	a0,s1
80001854:	85cff0ef          	jal	ra,800008b0 <__udivsi3>
		remaining--;
80001858:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
8000185c:	00100793          	li	a5,1
		pos /= 10;
80001860:	00050493          	mv	s1,a0
	while (pos >= 9) {
80001864:	fafa96e3          	bne	s5,a5,80001810 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
80001868:	000a0593          	mv	a1,s4
8000186c:	030d0513          	addi	a0,s10,48
80001870:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001874:	00300793          	li	a5,3
		remaining = min_width - digits;
80001878:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
8000187c:	06fb0663          	beq	s6,a5,800018e8 <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001880:	03c12083          	lw	ra,60(sp)
80001884:	03812403          	lw	s0,56(sp)
80001888:	03412483          	lw	s1,52(sp)
8000188c:	03012903          	lw	s2,48(sp)
80001890:	02c12983          	lw	s3,44(sp)
80001894:	02812a03          	lw	s4,40(sp)
80001898:	02412a83          	lw	s5,36(sp)
8000189c:	02012b03          	lw	s6,32(sp)
800018a0:	01c12b83          	lw	s7,28(sp)
800018a4:	01812c03          	lw	s8,24(sp)
800018a8:	01412c83          	lw	s9,20(sp)
800018ac:	01012d03          	lw	s10,16(sp)
800018b0:	00c12d83          	lw	s11,12(sp)
800018b4:	04010113          	addi	sp,sp,64
800018b8:	00008067          	ret
		} else if (remaining <= min_width
800018bc:	f95440e3          	blt	s0,s5,8000183c <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
800018c0:	f76deee3          	bltu	s11,s6,8000183c <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
800018c4:	000a0593          	mv	a1,s4
800018c8:	000c8513          	mv	a0,s9
800018cc:	000980e7          	jalr	s3
			digits++;
800018d0:	00190913          	addi	s2,s2,1
800018d4:	f69ff06f          	j	8000183c <_printk_dec_ulong+0xa8>
			out(' ', ctx);
800018d8:	000a0593          	mv	a1,s4
800018dc:	02000513          	li	a0,32
800018e0:	000980e7          	jalr	s3
800018e4:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
800018e8:	fe8048e3          	bgtz	s0,800018d8 <_printk_dec_ulong+0x144>
800018ec:	f95ff06f          	j	80001880 <_printk_dec_ulong+0xec>

800018f0 <__printk_hook_install>:
	_char_out = fn;
800018f0:	800067b7          	lui	a5,0x80006
800018f4:	00a7a223          	sw	a0,4(a5) # 80006004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006005>
}
800018f8:	00008067          	ret

800018fc <z_vprintk>:
{
800018fc:	fb010113          	addi	sp,sp,-80
80001900:	04812423          	sw	s0,72(sp)
80001904:	04912223          	sw	s1,68(sp)
80001908:	05212023          	sw	s2,64(sp)
8000190c:	03312e23          	sw	s3,60(sp)
80001910:	03412c23          	sw	s4,56(sp)
80001914:	03512a23          	sw	s5,52(sp)
80001918:	03912223          	sw	s9,36(sp)
8000191c:	03a12023          	sw	s10,32(sp)
80001920:	01b12e23          	sw	s11,28(sp)
80001924:	04112623          	sw	ra,76(sp)
80001928:	03612823          	sw	s6,48(sp)
8000192c:	03712623          	sw	s7,44(sp)
80001930:	03812423          	sw	s8,40(sp)
80001934:	00050413          	mv	s0,a0
80001938:	00058493          	mv	s1,a1
8000193c:	00060a93          	mv	s5,a2
80001940:	00068d13          	mv	s10,a3
	int long_ctr = 0;
80001944:	00000a13          	li	s4,0
	int min_width = -1;
80001948:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
8000194c:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001950:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
80001954:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001958:	000ac503          	lbu	a0,0(s5)
8000195c:	04051063          	bnez	a0,8000199c <z_vprintk+0xa0>
}
80001960:	04c12083          	lw	ra,76(sp)
80001964:	04812403          	lw	s0,72(sp)
80001968:	04412483          	lw	s1,68(sp)
8000196c:	04012903          	lw	s2,64(sp)
80001970:	03c12983          	lw	s3,60(sp)
80001974:	03812a03          	lw	s4,56(sp)
80001978:	03412a83          	lw	s5,52(sp)
8000197c:	03012b03          	lw	s6,48(sp)
80001980:	02c12b83          	lw	s7,44(sp)
80001984:	02812c03          	lw	s8,40(sp)
80001988:	02412c83          	lw	s9,36(sp)
8000198c:	02012d03          	lw	s10,32(sp)
80001990:	01c12d83          	lw	s11,28(sp)
80001994:	05010113          	addi	sp,sp,80
80001998:	00008067          	ret
		if (!might_format) {
8000199c:	000c9e63          	bnez	s9,800019b8 <z_vprintk+0xbc>
			if (*fmt != '%') {
800019a0:	02500693          	li	a3,37
800019a4:	36d50c63          	beq	a0,a3,80001d1c <z_vprintk+0x420>
				out((int)*fmt, ctx);
800019a8:	00048593          	mv	a1,s1
800019ac:	000400e7          	jalr	s0
		++fmt;
800019b0:	001a8a93          	addi	s5,s5,1
800019b4:	fa5ff06f          	j	80001958 <z_vprintk+0x5c>
			switch (*fmt) {
800019b8:	06400693          	li	a3,100
800019bc:	12d50063          	beq	a0,a3,80001adc <z_vprintk+0x1e0>
800019c0:	06a6e263          	bltu	a3,a0,80001a24 <z_vprintk+0x128>
800019c4:	03900693          	li	a3,57
800019c8:	02a6ea63          	bltu	a3,a0,800019fc <z_vprintk+0x100>
800019cc:	03100693          	li	a3,49
800019d0:	0ed57463          	bgeu	a0,a3,80001ab8 <z_vprintk+0x1bc>
800019d4:	02d00693          	li	a3,45
800019d8:	34d50c63          	beq	a0,a3,80001d30 <z_vprintk+0x434>
800019dc:	03000793          	li	a5,48
800019e0:	0cf50063          	beq	a0,a5,80001aa0 <z_vprintk+0x1a4>
800019e4:	02500713          	li	a4,37
800019e8:	02e51263          	bne	a0,a4,80001a0c <z_vprintk+0x110>
				out((int)'%', ctx);
800019ec:	00048593          	mv	a1,s1
800019f0:	02500513          	li	a0,37
				out((int)*fmt, ctx);
800019f4:	000400e7          	jalr	s0
				break;
800019f8:	1600006f          	j	80001b58 <z_vprintk+0x25c>
800019fc:	05800693          	li	a3,88
80001a00:	1cd50063          	beq	a0,a3,80001bc0 <z_vprintk+0x2c4>
80001a04:	06300713          	li	a4,99
80001a08:	30e50063          	beq	a0,a4,80001d08 <z_vprintk+0x40c>
				out((int)'%', ctx);
80001a0c:	00048593          	mv	a1,s1
80001a10:	02500513          	li	a0,37
80001a14:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
80001a18:	00048593          	mv	a1,s1
80001a1c:	000ac503          	lbu	a0,0(s5)
80001a20:	fd5ff06f          	j	800019f4 <z_vprintk+0xf8>
80001a24:	07000693          	li	a3,112
80001a28:	16d50c63          	beq	a0,a3,80001ba0 <z_vprintk+0x2a4>
80001a2c:	02a6e063          	bltu	a3,a0,80001a4c <z_vprintk+0x150>
80001a30:	06900693          	li	a3,105
80001a34:	0ad50463          	beq	a0,a3,80001adc <z_vprintk+0x1e0>
80001a38:	06c00693          	li	a3,108
80001a3c:	08d50c63          	beq	a0,a3,80001ad4 <z_vprintk+0x1d8>
80001a40:	06800693          	li	a3,104
80001a44:	f6d506e3          	beq	a0,a3,800019b0 <z_vprintk+0xb4>
80001a48:	fc5ff06f          	j	80001a0c <z_vprintk+0x110>
80001a4c:	07500693          	li	a3,117
80001a50:	10d50863          	beq	a0,a3,80001b60 <z_vprintk+0x264>
80001a54:	02a6ee63          	bltu	a3,a0,80001a90 <z_vprintk+0x194>
80001a58:	07300713          	li	a4,115
80001a5c:	fae518e3          	bne	a0,a4,80001a0c <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001a60:	000d2c03          	lw	s8,0(s10)
80001a64:	004d0b13          	addi	s6,s10,4
80001a68:	000c0b93          	mv	s7,s8
				while (*s)
80001a6c:	000bc503          	lbu	a0,0(s7)
80001a70:	26051a63          	bnez	a0,80001ce4 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
80001a74:	00300793          	li	a5,3
80001a78:	00f99863          	bne	s3,a5,80001a88 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001a7c:	418b8bb3          	sub	s7,s7,s8
80001a80:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001a84:	27704863          	bgtz	s7,80001cf4 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
80001a88:	000b0d13          	mv	s10,s6
80001a8c:	0cc0006f          	j	80001b58 <z_vprintk+0x25c>
80001a90:	07800693          	li	a3,120
80001a94:	12d50663          	beq	a0,a3,80001bc0 <z_vprintk+0x2c4>
80001a98:	07a00693          	li	a3,122
80001a9c:	fa9ff06f          	j	80001a44 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001aa0:	00095e63          	bgez	s2,80001abc <z_vprintk+0x1c0>
80001aa4:	28098a63          	beqz	s3,80001d38 <z_vprintk+0x43c>
					min_width = *fmt - '0';
80001aa8:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001aac:	f00992e3          	bnez	s3,800019b0 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001ab0:	00200993          	li	s3,2
80001ab4:	efdff06f          	j	800019b0 <z_vprintk+0xb4>
				if (min_width < 0) {
80001ab8:	fe0948e3          	bltz	s2,80001aa8 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001abc:	00291693          	slli	a3,s2,0x2
80001ac0:	01268933          	add	s2,a3,s2
80001ac4:	00191913          	slli	s2,s2,0x1
80001ac8:	fd090913          	addi	s2,s2,-48
80001acc:	01250933          	add	s2,a0,s2
80001ad0:	fddff06f          	j	80001aac <z_vprintk+0x1b0>
				long_ctr++;
80001ad4:	001a0a13          	addi	s4,s4,1
80001ad8:	ed9ff06f          	j	800019b0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001adc:	040a1263          	bnez	s4,80001b20 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80001ae0:	000d2603          	lw	a2,0(s10)
80001ae4:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
80001ae8:	02065063          	bgez	a2,80001b08 <z_vprintk+0x20c>
					out((int)'-', ctx);
80001aec:	00048593          	mv	a1,s1
80001af0:	02d00513          	li	a0,45
80001af4:	00c12023          	sw	a2,0(sp)
80001af8:	000400e7          	jalr	s0
					d = -d;
80001afc:	00012603          	lw	a2,0(sp)
					min_width--;
80001b00:	fff90913          	addi	s2,s2,-1
					d = -d;
80001b04:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
80001b08:	00090713          	mv	a4,s2
80001b0c:	00098693          	mv	a3,s3
80001b10:	00048593          	mv	a1,s1
80001b14:	00040513          	mv	a0,s0
80001b18:	c7dff0ef          	jal	ra,80001794 <_printk_dec_ulong>
				break;
80001b1c:	03c0006f          	j	80001b58 <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80001b20:	00100713          	li	a4,1
80001b24:	faea0ee3          	beq	s4,a4,80001ae0 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
80001b28:	007d0793          	addi	a5,s10,7
80001b2c:	ff87f713          	andi	a4,a5,-8
80001b30:	00072603          	lw	a2,0(a4)
80001b34:	00472683          	lw	a3,4(a4)
80001b38:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001b3c:	01b60733          	add	a4,a2,s11
80001b40:	00c73733          	sltu	a4,a4,a2
80001b44:	00d70733          	add	a4,a4,a3
80001b48:	fa0700e3          	beqz	a4,80001ae8 <z_vprintk+0x1ec>
						print_err(out, ctx);
80001b4c:	00048593          	mv	a1,s1
80001b50:	00040513          	mv	a0,s0
80001b54:	bddff0ef          	jal	ra,80001730 <print_err>
			might_format = 0;
80001b58:	00000c93          	li	s9,0
80001b5c:	e55ff06f          	j	800019b0 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001b60:	000a1863          	bnez	s4,80001b70 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
80001b64:	000d2603          	lw	a2,0(s10)
80001b68:	004d0d13          	addi	s10,s10,4
80001b6c:	f9dff06f          	j	80001b08 <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
80001b70:	00100713          	li	a4,1
80001b74:	feea08e3          	beq	s4,a4,80001b64 <z_vprintk+0x268>
					unsigned long long llu =
80001b78:	007d0793          	addi	a5,s10,7
80001b7c:	ff87f713          	andi	a4,a5,-8
80001b80:	00870d13          	addi	s10,a4,8
80001b84:	00072603          	lw	a2,0(a4)
80001b88:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001b8c:	fc0710e3          	bnez	a4,80001b4c <z_vprintk+0x250>
80001b90:	800007b7          	lui	a5,0x80000
80001b94:	fff7c793          	not	a5,a5
80001b98:	f6c7f8e3          	bgeu	a5,a2,80001b08 <z_vprintk+0x20c>
80001b9c:	fb1ff06f          	j	80001b4c <z_vprintk+0x250>
				  out('0', ctx);
80001ba0:	00048593          	mv	a1,s1
80001ba4:	03000513          	li	a0,48
80001ba8:	000400e7          	jalr	s0
				  out('x', ctx);
80001bac:	00048593          	mv	a1,s1
80001bb0:	07800513          	li	a0,120
80001bb4:	000400e7          	jalr	s0
				  min_width = 8;
80001bb8:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001bbc:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001bc0:	00100693          	li	a3,1
80001bc4:	0b46c263          	blt	a3,s4,80001c68 <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
80001bc8:	000d2783          	lw	a5,0(s10)
80001bcc:	00012423          	sw	zero,8(sp)
80001bd0:	004d0d13          	addi	s10,s10,4
80001bd4:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001bd8:	01000c13          	li	s8,16
	int digits = 0;
80001bdc:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80001be0:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80001be4:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001be8:	00412503          	lw	a0,4(sp)
80001bec:	00812583          	lw	a1,8(sp)
80001bf0:	fff88b13          	addi	s6,a7,-1
80001bf4:	002b1613          	slli	a2,s6,0x2
80001bf8:	01112623          	sw	a7,12(sp)
80001bfc:	e7cfe0ef          	jal	ra,80000278 <__lshrdi3>
80001c00:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001c04:	08051863          	bnez	a0,80001c94 <z_vprintk+0x398>
80001c08:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001c0c:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001c10:	00079863          	bnez	a5,80001c20 <z_vprintk+0x324>
80001c14:	00c12883          	lw	a7,12(sp)
80001c18:	00100793          	li	a5,1
80001c1c:	08f89663          	bne	a7,a5,80001ca8 <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80001c20:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80001c24:	01851513          	slli	a0,a0,0x18
80001c28:	00048593          	mv	a1,s1
80001c2c:	41855513          	srai	a0,a0,0x18
80001c30:	000400e7          	jalr	s0
			digits++;
80001c34:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
80001c38:	040b1863          	bnez	s6,80001c88 <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
80001c3c:	00300693          	li	a3,3
			might_format = 0;
80001c40:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001c44:	d6d996e3          	bne	s3,a3,800019b0 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
80001c48:	00191713          	slli	a4,s2,0x1
80001c4c:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001c50:	f17054e3          	blez	s7,80001b58 <z_vprintk+0x25c>
			out(' ', ctx);
80001c54:	00048593          	mv	a1,s1
80001c58:	02000513          	li	a0,32
80001c5c:	000400e7          	jalr	s0
80001c60:	fffb8b93          	addi	s7,s7,-1
80001c64:	fedff06f          	j	80001c50 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
80001c68:	007d0793          	addi	a5,s10,7
80001c6c:	ff87f693          	andi	a3,a5,-8
80001c70:	0006a783          	lw	a5,0(a3)
80001c74:	00868d13          	addi	s10,a3,8
80001c78:	00f12223          	sw	a5,4(sp)
80001c7c:	0046a783          	lw	a5,4(a3)
80001c80:	00f12423          	sw	a5,8(sp)
80001c84:	f55ff06f          	j	80001bd8 <z_vprintk+0x2dc>
			found_largest_digit = 1;
80001c88:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001c8c:	000b0893          	mv	a7,s6
80001c90:	f59ff06f          	j	80001be8 <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
80001c94:	00900793          	li	a5,9
80001c98:	05700693          	li	a3,87
80001c9c:	f8a7e2e3          	bltu	a5,a0,80001c20 <z_vprintk+0x324>
80001ca0:	03000693          	li	a3,48
80001ca4:	f7dff06f          	j	80001c20 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
80001ca8:	fffc0793          	addi	a5,s8,-1
80001cac:	00f12623          	sw	a5,12(sp)
80001cb0:	01894c63          	blt	s2,s8,80001cc8 <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
80001cb4:	00100793          	li	a5,1
80001cb8:	00f99c63          	bne	s3,a5,80001cd0 <z_vprintk+0x3d4>
				out('0', ctx);
80001cbc:	00048593          	mv	a1,s1
80001cc0:	03000513          	li	a0,48
				out(' ', ctx);
80001cc4:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
80001cc8:	00c12c03          	lw	s8,12(sp)
80001ccc:	fc1ff06f          	j	80001c8c <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80001cd0:	00200793          	li	a5,2
80001cd4:	fef99ae3          	bne	s3,a5,80001cc8 <z_vprintk+0x3cc>
				out(' ', ctx);
80001cd8:	00048593          	mv	a1,s1
80001cdc:	02000513          	li	a0,32
80001ce0:	fe5ff06f          	j	80001cc4 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80001ce4:	00048593          	mv	a1,s1
80001ce8:	001b8b93          	addi	s7,s7,1
80001cec:	000400e7          	jalr	s0
80001cf0:	d7dff06f          	j	80001a6c <z_vprintk+0x170>
						out(' ', ctx);
80001cf4:	00048593          	mv	a1,s1
80001cf8:	02000513          	li	a0,32
80001cfc:	000400e7          	jalr	s0
80001d00:	fffb8b93          	addi	s7,s7,-1
80001d04:	d81ff06f          	j	80001a84 <z_vprintk+0x188>
				out(c, ctx);
80001d08:	000d2503          	lw	a0,0(s10)
80001d0c:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80001d10:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001d14:	000400e7          	jalr	s0
				break;
80001d18:	d71ff06f          	j	80001a88 <z_vprintk+0x18c>
				long_ctr = 0;
80001d1c:	00000a13          	li	s4,0
				min_width = -1;
80001d20:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80001d24:	00000993          	li	s3,0
				might_format = 1;
80001d28:	00100c93          	li	s9,1
80001d2c:	c85ff06f          	j	800019b0 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001d30:	00300993          	li	s3,3
80001d34:	c7dff06f          	j	800019b0 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001d38:	00100993          	li	s3,1
80001d3c:	c75ff06f          	j	800019b0 <z_vprintk+0xb4>

80001d40 <vprintk>:
{
80001d40:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001d44:	00050613          	mv	a2,a0
80001d48:	80001537          	lui	a0,0x80001
80001d4c:	00058693          	mv	a3,a1
80001d50:	77c50513          	addi	a0,a0,1916 # 8000177c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000177d>
80001d54:	00c10593          	addi	a1,sp,12
{
80001d58:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001d5c:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001d60:	b9dff0ef          	jal	ra,800018fc <z_vprintk>
}
80001d64:	01c12083          	lw	ra,28(sp)
80001d68:	02010113          	addi	sp,sp,32
80001d6c:	00008067          	ret

80001d70 <printk>:
{
80001d70:	fc010113          	addi	sp,sp,-64
80001d74:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001d78:	02410593          	addi	a1,sp,36
{
80001d7c:	00112e23          	sw	ra,28(sp)
80001d80:	02c12423          	sw	a2,40(sp)
80001d84:	02d12623          	sw	a3,44(sp)
80001d88:	02e12823          	sw	a4,48(sp)
80001d8c:	02f12a23          	sw	a5,52(sp)
80001d90:	03012c23          	sw	a6,56(sp)
80001d94:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001d98:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001d9c:	fa5ff0ef          	jal	ra,80001d40 <vprintk>
}
80001da0:	01c12083          	lw	ra,28(sp)
80001da4:	04010113          	addi	sp,sp,64
80001da8:	00008067          	ret

80001dac <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001dac:	800065b7          	lui	a1,0x80006
80001db0:	80006537          	lui	a0,0x80006
{
80001db4:	ff010113          	addi	sp,sp,-16
  k_panic();
80001db8:	b0058593          	addi	a1,a1,-1280 # 80005b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b01>
80001dbc:	b1450513          	addi	a0,a0,-1260 # 80005b14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b15>
80001dc0:	01e00613          	li	a2,30
{
80001dc4:	00112623          	sw	ra,12(sp)
  k_panic();
80001dc8:	fa9ff0ef          	jal	ra,80001d70 <printk>
80001dcc:	800055b7          	lui	a1,0x80005
80001dd0:	6e058593          	addi	a1,a1,1760 # 800056e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e1>
80001dd4:	00600513          	li	a0,6
80001dd8:	e2dfe0ef          	jal	ra,80000c04 <z_NanoFatalErrorHandler>

80001ddc <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001ddc:	00008067          	ret

80001de0 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001de0:	00800793          	li	a5,8
80001de4:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001de8:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001dec:	00008067          	ret

80001df0 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001df0:	00100793          	li	a5,1
80001df4:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001df8:	30452573          	csrrs	a0,mie,a0
}
80001dfc:	00008067          	ret

80001e00 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001e00:	00800793          	li	a5,8
80001e04:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001e08:	30405073          	csrwi	mie,0
80001e0c:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001e10:	00008067          	ret

80001e14 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001e14:	ff010113          	addi	sp,sp,-16
80001e18:	00812423          	sw	s0,8(sp)
80001e1c:	00912223          	sw	s1,4(sp)
80001e20:	80006437          	lui	s0,0x80006
80001e24:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001e28:	00a00793          	li	a5,10
{
80001e2c:	00050493          	mv	s1,a0
80001e30:	0c440413          	addi	s0,s0,196 # 800060c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c5>
	if ('\n' == c) {
80001e34:	00f51c63          	bne	a0,a5,80001e4c <console_out+0x38>
80001e38:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001e3c:	00d00593          	li	a1,13
80001e40:	00452783          	lw	a5,4(a0)
80001e44:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001e48:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001e4c:	00042503          	lw	a0,0(s0)
80001e50:	0ff4f593          	andi	a1,s1,255
80001e54:	00452783          	lw	a5,4(a0)
80001e58:	0047a783          	lw	a5,4(a5)
80001e5c:	000780e7          	jalr	a5

	return c;
}
80001e60:	00c12083          	lw	ra,12(sp)
80001e64:	00812403          	lw	s0,8(sp)
80001e68:	00048513          	mv	a0,s1
80001e6c:	00412483          	lw	s1,4(sp)
80001e70:	01010113          	addi	sp,sp,16
80001e74:	00008067          	ret

80001e78 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001e78:	ff010113          	addi	sp,sp,-16
80001e7c:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001e80:	80002437          	lui	s0,0x80002
80001e84:	e1440513          	addi	a0,s0,-492 # 80001e14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001e15>
{
80001e88:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001e8c:	540000ef          	jal	ra,800023cc <__stdout_hook_install>
	__printk_hook_install(console_out);
80001e90:	e1440513          	addi	a0,s0,-492
}
80001e94:	00812403          	lw	s0,8(sp)
80001e98:	00c12083          	lw	ra,12(sp)
80001e9c:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001ea0:	a51ff06f          	j	800018f0 <__printk_hook_install>

80001ea4 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001ea4:	80006537          	lui	a0,0x80006
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001ea8:	ff010113          	addi	sp,sp,-16
80001eac:	b2050513          	addi	a0,a0,-1248 # 80005b20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b21>
80001eb0:	00112623          	sw	ra,12(sp)
80001eb4:	091000ef          	jal	ra,80002744 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001eb8:	800067b7          	lui	a5,0x80006
80001ebc:	0ca7a223          	sw	a0,196(a5) # 800060c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c5>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001ec0:	fb9ff0ef          	jal	ra,80001e78 <uart_console_hook_install>

	return 0;
}
80001ec4:	00c12083          	lw	ra,12(sp)
80001ec8:	00000513          	li	a0,0
80001ecc:	01010113          	addi	sp,sp,16
80001ed0:	00008067          	ret

80001ed4 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001ed4:	f01007b7          	lui	a5,0xf0100
80001ed8:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001edc:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001ee0:	f447a583          	lw	a1,-188(a5)
80001ee4:	fee59ae3          	bne	a1,a4,80001ed8 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001ee8:	00008067          	ret

80001eec <timer_isr>:

static void timer_isr(void *arg)
{
80001eec:	fe010113          	addi	sp,sp,-32
80001ef0:	00812c23          	sw	s0,24(sp)
80001ef4:	00112e23          	sw	ra,28(sp)
80001ef8:	00912a23          	sw	s1,20(sp)
80001efc:	01212823          	sw	s2,16(sp)
80001f00:	01312623          	sw	s3,12(sp)
80001f04:	01412423          	sw	s4,8(sp)
80001f08:	01512223          	sw	s5,4(sp)
80001f0c:	00800413          	li	s0,8
80001f10:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001f14:	80006937          	lui	s2,0x80006
80001f18:	0c890513          	addi	a0,s2,200 # 800060c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c9>
	key = (mstatus & SOC_MSTATUS_IEN);
80001f1c:	00847413          	andi	s0,s0,8
80001f20:	614020ef          	jal	ra,80004534 <z_spin_lock_valid>
80001f24:	02051e63          	bnez	a0,80001f60 <timer_isr+0x74>
80001f28:	800064b7          	lui	s1,0x80006
80001f2c:	800065b7          	lui	a1,0x80006
80001f30:	80006537          	lui	a0,0x80006
80001f34:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80001f38:	04e00693          	li	a3,78
80001f3c:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80001f40:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80001f44:	e2dff0ef          	jal	ra,80001d70 <printk>
80001f48:	80006537          	lui	a0,0x80006
80001f4c:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80001f50:	e21ff0ef          	jal	ra,80001d70 <printk>
80001f54:	04e00593          	li	a1,78
80001f58:	b3448513          	addi	a0,s1,-1228
80001f5c:	e51ff0ef          	jal	ra,80001dac <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001f60:	0c890513          	addi	a0,s2,200
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001f64:	800064b7          	lui	s1,0x80006
80001f68:	624020ef          	jal	ra,8000458c <z_spin_lock_set_owner>
80001f6c:	0a848493          	addi	s1,s1,168 # 800060a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a9>
	u64_t now = mtime();
80001f70:	f65ff0ef          	jal	ra,80001ed4 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001f74:	0004a983          	lw	s3,0(s1)
80001f78:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001f7c:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001f80:	41350533          	sub	a0,a0,s3
80001f84:	00a7b7b3          	sltu	a5,a5,a0
80001f88:	415585b3          	sub	a1,a1,s5
80001f8c:	0001d637          	lui	a2,0x1d
80001f90:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001f94:	00000693          	li	a3,0
80001f98:	40f585b3          	sub	a1,a1,a5
80001f9c:	b14fe0ef          	jal	ra,800002b0 <__udivdi3>
80001fa0:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80001fa4:	0001d5b7          	lui	a1,0x1d
80001fa8:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001fac:	000a0513          	mv	a0,s4
80001fb0:	8d5fe0ef          	jal	ra,80000884 <__mulsi3>
80001fb4:	013509b3          	add	s3,a0,s3
80001fb8:	00a9b533          	sltu	a0,s3,a0
80001fbc:	01550533          	add	a0,a0,s5
80001fc0:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001fc4:	0c890513          	addi	a0,s2,200
80001fc8:	0134a023          	sw	s3,0(s1)
80001fcc:	590020ef          	jal	ra,8000455c <z_spin_unlock_valid>
80001fd0:	02051e63          	bnez	a0,8000200c <timer_isr+0x120>
80001fd4:	800064b7          	lui	s1,0x80006
80001fd8:	800065b7          	lui	a1,0x80006
80001fdc:	80006537          	lui	a0,0x80006
80001fe0:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80001fe4:	06100693          	li	a3,97
80001fe8:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80001fec:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80001ff0:	d81ff0ef          	jal	ra,80001d70 <printk>
80001ff4:	80006537          	lui	a0,0x80006
80001ff8:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80001ffc:	d75ff0ef          	jal	ra,80001d70 <printk>
80002000:	06100593          	li	a1,97
80002004:	b3448513          	addi	a0,s1,-1228
80002008:	da5ff0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000200c:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002010:	01812403          	lw	s0,24(sp)
80002014:	01c12083          	lw	ra,28(sp)
80002018:	01412483          	lw	s1,20(sp)
8000201c:	01012903          	lw	s2,16(sp)
80002020:	00c12983          	lw	s3,12(sp)
80002024:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002028:	000a0513          	mv	a0,s4
}
8000202c:	00812a03          	lw	s4,8(sp)
80002030:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80002034:	74d0206f          	j	80004f80 <z_clock_announce>

80002038 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80002038:	ff010113          	addi	sp,sp,-16
8000203c:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002040:	e95ff0ef          	jal	ra,80001ed4 <mtime>
80002044:	0001d7b7          	lui	a5,0x1d
80002048:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
8000204c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80002050:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80002054:	fff00693          	li	a3,-1
80002058:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000205c:	00a7b533          	sltu	a0,a5,a0
80002060:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80002064:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80002068:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
8000206c:	00700513          	li	a0,7
80002070:	d81ff0ef          	jal	ra,80001df0 <z_arch_irq_enable>
	return 0;
}
80002074:	00c12083          	lw	ra,12(sp)
80002078:	00000513          	li	a0,0
8000207c:	01010113          	addi	sp,sp,16
80002080:	00008067          	ret

80002084 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80002084:	1a059263          	bnez	a1,80002228 <z_clock_set_timeout+0x1a4>
{
80002088:	fe010113          	addi	sp,sp,-32
8000208c:	00112e23          	sw	ra,28(sp)
80002090:	00812c23          	sw	s0,24(sp)
80002094:	00912a23          	sw	s1,20(sp)
80002098:	01212823          	sw	s2,16(sp)
8000209c:	01312623          	sw	s3,12(sp)
800020a0:	01412423          	sw	s4,8(sp)
800020a4:	01512223          	sw	s5,4(sp)
800020a8:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800020ac:	fff00793          	li	a5,-1
800020b0:	00f51663          	bne	a0,a5,800020bc <z_clock_set_timeout+0x38>
800020b4:	00009537          	lui	a0,0x9
800020b8:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800020bc:	000097b7          	lui	a5,0x9
800020c0:	fff50413          	addi	s0,a0,-1
800020c4:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800020c8:	1487da63          	bge	a5,s0,8000221c <z_clock_set_timeout+0x198>
800020cc:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800020d0:	00800913          	li	s2,8
800020d4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800020d8:	80006ab7          	lui	s5,0x80006
800020dc:	0c8a8513          	addi	a0,s5,200 # 800060c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c9>
	key = (mstatus & SOC_MSTATUS_IEN);
800020e0:	00897913          	andi	s2,s2,8
800020e4:	450020ef          	jal	ra,80004534 <z_spin_lock_valid>
800020e8:	02051e63          	bnez	a0,80002124 <z_clock_set_timeout+0xa0>
800020ec:	800064b7          	lui	s1,0x80006
800020f0:	800065b7          	lui	a1,0x80006
800020f4:	80006537          	lui	a0,0x80006
800020f8:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800020fc:	04e00693          	li	a3,78
80002100:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002104:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002108:	c69ff0ef          	jal	ra,80001d70 <printk>
8000210c:	80006537          	lui	a0,0x80006
80002110:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80002114:	c5dff0ef          	jal	ra,80001d70 <printk>
80002118:	04e00593          	li	a1,78
8000211c:	b3448513          	addi	a0,s1,-1228
80002120:	c8dff0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80002124:	0c8a8513          	addi	a0,s5,200
80002128:	464020ef          	jal	ra,8000458c <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
8000212c:	da9ff0ef          	jal	ra,80001ed4 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80002130:	800067b7          	lui	a5,0x80006
80002134:	0a878793          	addi	a5,a5,168 # 800060a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a9>
	u32_t cyc = ticks * CYC_PER_TICK;
80002138:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000213c:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
80002140:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
80002144:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002148:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000214c:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80002150:	f34fe0ef          	jal	ra,80000884 <__mulsi3>
80002154:	4bf48793          	addi	a5,s1,1215
80002158:	413787b3          	sub	a5,a5,s3
8000215c:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80002160:	4c048593          	addi	a1,s1,1216
80002164:	00aa0533          	add	a0,s4,a0
80002168:	f48fe0ef          	jal	ra,800008b0 <__udivsi3>
8000216c:	4c048593          	addi	a1,s1,1216
80002170:	f14fe0ef          	jal	ra,80000884 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80002174:	41498a33          	sub	s4,s3,s4
80002178:	00aa0a33          	add	s4,s4,a0
8000217c:	3e700793          	li	a5,999
80002180:	0147c663          	blt	a5,s4,8000218c <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
80002184:	4c048493          	addi	s1,s1,1216
80002188:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
8000218c:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002190:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002194:	fff00713          	li	a4,-1
80002198:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
8000219c:	00a9b533          	sltu	a0,s3,a0
800021a0:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
800021a4:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
800021a8:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800021ac:	0c8a8513          	addi	a0,s5,200
800021b0:	3ac020ef          	jal	ra,8000455c <z_spin_unlock_valid>
800021b4:	02051e63          	bnez	a0,800021f0 <z_clock_set_timeout+0x16c>
800021b8:	80006437          	lui	s0,0x80006
800021bc:	800065b7          	lui	a1,0x80006
800021c0:	80006537          	lui	a0,0x80006
800021c4:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800021c8:	06100693          	li	a3,97
800021cc:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800021d0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800021d4:	b9dff0ef          	jal	ra,80001d70 <printk>
800021d8:	80006537          	lui	a0,0x80006
800021dc:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800021e0:	b91ff0ef          	jal	ra,80001d70 <printk>
800021e4:	06100593          	li	a1,97
800021e8:	b3440513          	addi	a0,s0,-1228
800021ec:	bc1ff0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800021f0:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
800021f4:	01c12083          	lw	ra,28(sp)
800021f8:	01812403          	lw	s0,24(sp)
800021fc:	01412483          	lw	s1,20(sp)
80002200:	01012903          	lw	s2,16(sp)
80002204:	00c12983          	lw	s3,12(sp)
80002208:	00812a03          	lw	s4,8(sp)
8000220c:	00412a83          	lw	s5,4(sp)
80002210:	00012b03          	lw	s6,0(sp)
80002214:	02010113          	addi	sp,sp,32
80002218:	00008067          	ret
8000221c:	ea045ae3          	bgez	s0,800020d0 <z_clock_set_timeout+0x4c>
80002220:	00000413          	li	s0,0
80002224:	eadff06f          	j	800020d0 <z_clock_set_timeout+0x4c>
80002228:	00008067          	ret

8000222c <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
8000222c:	ff010113          	addi	sp,sp,-16
80002230:	00812423          	sw	s0,8(sp)
80002234:	00112623          	sw	ra,12(sp)
80002238:	00912223          	sw	s1,4(sp)
8000223c:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002240:	00800413          	li	s0,8
80002244:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002248:	800064b7          	lui	s1,0x80006
8000224c:	0c848513          	addi	a0,s1,200 # 800060c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060c9>
	key = (mstatus & SOC_MSTATUS_IEN);
80002250:	00847413          	andi	s0,s0,8
80002254:	2e0020ef          	jal	ra,80004534 <z_spin_lock_valid>
80002258:	02051e63          	bnez	a0,80002294 <z_clock_elapsed+0x68>
8000225c:	80006937          	lui	s2,0x80006
80002260:	800065b7          	lui	a1,0x80006
80002264:	80006537          	lui	a0,0x80006
80002268:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
8000226c:	04e00693          	li	a3,78
80002270:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002274:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002278:	af9ff0ef          	jal	ra,80001d70 <printk>
8000227c:	80006537          	lui	a0,0x80006
80002280:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80002284:	aedff0ef          	jal	ra,80001d70 <printk>
80002288:	04e00593          	li	a1,78
8000228c:	b3490513          	addi	a0,s2,-1228
80002290:	b1dff0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80002294:	0c848513          	addi	a0,s1,200
80002298:	2f4020ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000229c:	c39ff0ef          	jal	ra,80001ed4 <mtime>
800022a0:	800067b7          	lui	a5,0x80006
800022a4:	0a87a783          	lw	a5,168(a5) # 800060a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a9>
800022a8:	0001d5b7          	lui	a1,0x1d
800022ac:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800022b0:	40f50533          	sub	a0,a0,a5
800022b4:	dfcfe0ef          	jal	ra,800008b0 <__udivsi3>
800022b8:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800022bc:	0c848513          	addi	a0,s1,200
800022c0:	29c020ef          	jal	ra,8000455c <z_spin_unlock_valid>
800022c4:	02051e63          	bnez	a0,80002300 <z_clock_elapsed+0xd4>
800022c8:	800064b7          	lui	s1,0x80006
800022cc:	800065b7          	lui	a1,0x80006
800022d0:	80006537          	lui	a0,0x80006
800022d4:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800022d8:	06100693          	li	a3,97
800022dc:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800022e0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800022e4:	a8dff0ef          	jal	ra,80001d70 <printk>
800022e8:	80006537          	lui	a0,0x80006
800022ec:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800022f0:	a81ff0ef          	jal	ra,80001d70 <printk>
800022f4:	06100593          	li	a1,97
800022f8:	b3448513          	addi	a0,s1,-1228
800022fc:	ab1ff0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002300:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002304:	00c12083          	lw	ra,12(sp)
80002308:	00812403          	lw	s0,8(sp)
8000230c:	00090513          	mv	a0,s2
80002310:	00412483          	lw	s1,4(sp)
80002314:	00012903          	lw	s2,0(sp)
80002318:	01010113          	addi	sp,sp,16
8000231c:	00008067          	ret

80002320 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002320:	00054783          	lbu	a5,0(a0)
80002324:	0005c703          	lbu	a4,0(a1)
80002328:	00e79463          	bne	a5,a4,80002330 <strcmp+0x10>
8000232c:	00079663          	bnez	a5,80002338 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002330:	40e78533          	sub	a0,a5,a4
80002334:	00008067          	ret
		s1++;
80002338:	00150513          	addi	a0,a0,1
		s2++;
8000233c:	00158593          	addi	a1,a1,1
80002340:	fe1ff06f          	j	80002320 <strcmp>

80002344 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002344:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002348:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
8000234c:	0037f713          	andi	a4,a5,3
80002350:	04071463          	bnez	a4,80002398 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002354:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002358:	00859713          	slli	a4,a1,0x8
8000235c:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002360:	01059713          	slli	a4,a1,0x10
80002364:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002368:	00c78333          	add	t1,a5,a2
8000236c:	00078713          	mv	a4,a5
80002370:	00300813          	li	a6,3
80002374:	40e308b3          	sub	a7,t1,a4
80002378:	03186a63          	bltu	a6,a7,800023ac <memset+0x68>
8000237c:	00265713          	srli	a4,a2,0x2
80002380:	00271593          	slli	a1,a4,0x2
80002384:	00b787b3          	add	a5,a5,a1
80002388:	40b60633          	sub	a2,a2,a1
8000238c:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002390:	02c79463          	bne	a5,a2,800023b8 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002394:	00008067          	ret
		if (n == 0) {
80002398:	fe060ee3          	beqz	a2,80002394 <memset+0x50>
		*(d_byte++) = c_byte;
8000239c:	00178793          	addi	a5,a5,1
800023a0:	fed78fa3          	sb	a3,-1(a5)
		n--;
800023a4:	fff60613          	addi	a2,a2,-1
800023a8:	fa5ff06f          	j	8000234c <memset+0x8>
		*(d_word++) = c_word;
800023ac:	00470713          	addi	a4,a4,4
800023b0:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
800023b4:	fc1ff06f          	j	80002374 <memset+0x30>
		*(d_byte++) = c_byte;
800023b8:	00178793          	addi	a5,a5,1
800023bc:	fed78fa3          	sb	a3,-1(a5)
		n--;
800023c0:	fd1ff06f          	j	80002390 <memset+0x4c>

800023c4 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
800023c4:	fff00513          	li	a0,-1
800023c8:	00008067          	ret

800023cc <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
800023cc:	800067b7          	lui	a5,0x80006
800023d0:	00a7a423          	sw	a0,8(a5) # 80006008 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006009>
}
800023d4:	00008067          	ret

800023d8 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
800023d8:	fe010113          	addi	sp,sp,-32
800023dc:	00812c23          	sw	s0,24(sp)
	test->setup();
800023e0:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
800023e4:	80006437          	lui	s0,0x80006
{
800023e8:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
800023ec:	00c40413          	addi	s0,s0,12 # 8000600c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000600d>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
800023f0:	800064b7          	lui	s1,0x80006
{
800023f4:	00112e23          	sw	ra,28(sp)
800023f8:	01212823          	sw	s2,16(sp)
800023fc:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002400:	0cc48493          	addi	s1,s1,204 # 800060cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060cd>
80002404:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002408:	00042023          	sw	zero,0(s0)
{
8000240c:	00050913          	mv	s2,a0
	test_result = 1;
80002410:	0134a023          	sw	s3,0(s1)
	test->setup();
80002414:	000780e7          	jalr	a5
	test->test();
80002418:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
8000241c:	01342023          	sw	s3,0(s0)
	test->test();
80002420:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002424:	00200793          	li	a5,2
80002428:	00f42023          	sw	a5,0(s0)
	test->teardown();
8000242c:	00c92783          	lw	a5,12(s2)
80002430:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002434:	00300793          	li	a5,3
80002438:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
8000243c:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002440:	0004a023          	sw	zero,0(s1)
}
80002444:	01c12083          	lw	ra,28(sp)
80002448:	01412483          	lw	s1,20(sp)
8000244c:	01012903          	lw	s2,16(sp)
80002450:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002454:	80006537          	lui	a0,0x80006
80002458:	32450513          	addi	a0,a0,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
8000245c:	02010113          	addi	sp,sp,32
80002460:	5190106f          	j	80004178 <z_impl_k_sem_give>

80002464 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002464:	fa010113          	addi	sp,sp,-96
80002468:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
8000246c:	800064b7          	lui	s1,0x80006
80002470:	0d04a783          	lw	a5,208(s1) # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
{
80002474:	04112e23          	sw	ra,92(sp)
80002478:	04812c23          	sw	s0,88(sp)
8000247c:	05212823          	sw	s2,80(sp)
80002480:	05312623          	sw	s3,76(sp)
80002484:	05412423          	sw	s4,72(sp)
80002488:	05512223          	sw	s5,68(sp)
8000248c:	05612023          	sw	s6,64(sp)
80002490:	03712e23          	sw	s7,60(sp)
80002494:	03812c23          	sw	s8,56(sp)
80002498:	03912a23          	sw	s9,52(sp)
8000249c:	03a12823          	sw	s10,48(sp)
800024a0:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
800024a4:	0807c463          	bltz	a5,8000252c <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800024a8:	80006437          	lui	s0,0x80006
800024ac:	00100613          	li	a2,1
800024b0:	00050993          	mv	s3,a0
800024b4:	00058c13          	mv	s8,a1
800024b8:	32440513          	addi	a0,s0,804 # 80006324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006325>
800024bc:	00000593          	li	a1,0
800024c0:	3f1010ef          	jal	ra,800040b0 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
800024c4:	80006537          	lui	a0,0x80006
800024c8:	00098593          	mv	a1,s3
800024cc:	bf050513          	addi	a0,a0,-1040 # 80005bf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bf1>
800024d0:	8a1ff0ef          	jal	ra,80001d70 <printk>
	PRINT_LINE;
800024d4:	80006937          	lui	s2,0x80006
800024d8:	c0890513          	addi	a0,s2,-1016 # 80005c08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c09>
		Z_TC_END_RESULT(ret, test->name);
800024dc:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
800024e0:	891ff0ef          	jal	ra,80001d70 <printk>
800024e4:	0d048493          	addi	s1,s1,208
	int fail = 0;
800024e8:	00000a13          	li	s4,0
800024ec:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
800024f0:	80007cb7          	lui	s9,0x80007
800024f4:	80006b37          	lui	s6,0x80006
800024f8:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
800024fc:	80006db7          	lui	s11,0x80006
80002500:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
80002504:	ba8a8a93          	addi	s5,s5,-1112 # 80005ba8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ba9>
	while (suite->test) {
80002508:	004c2783          	lw	a5,4(s8)
8000250c:	04079e63          	bnez	a5,80002568 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002510:	00098593          	mv	a1,s3
	if (fail) {
80002514:	100a0663          	beqz	s4,80002620 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002518:	80006537          	lui	a0,0x80006
8000251c:	c7850513          	addi	a0,a0,-904 # 80005c78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c79>
80002520:	851ff0ef          	jal	ra,80001d70 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002524:	00100793          	li	a5,1
80002528:	00f4a023          	sw	a5,0(s1)
}
8000252c:	05c12083          	lw	ra,92(sp)
80002530:	05812403          	lw	s0,88(sp)
80002534:	05412483          	lw	s1,84(sp)
80002538:	05012903          	lw	s2,80(sp)
8000253c:	04c12983          	lw	s3,76(sp)
80002540:	04812a03          	lw	s4,72(sp)
80002544:	04412a83          	lw	s5,68(sp)
80002548:	04012b03          	lw	s6,64(sp)
8000254c:	03c12b83          	lw	s7,60(sp)
80002550:	03812c03          	lw	s8,56(sp)
80002554:	03412c83          	lw	s9,52(sp)
80002558:	03012d03          	lw	s10,48(sp)
8000255c:	02c12d83          	lw	s11,44(sp)
80002560:	06010113          	addi	sp,sp,96
80002564:	00008067          	ret
	TC_START(test->name);
80002568:	000c2583          	lw	a1,0(s8)
8000256c:	800067b7          	lui	a5,0x80006
80002570:	c5078513          	addi	a0,a5,-944 # 80005c50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c51>
80002574:	ffcff0ef          	jal	ra,80001d70 <printk>
80002578:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
8000257c:	010c2783          	lw	a5,16(s8)
80002580:	000c0713          	mv	a4,s8
80002584:	40000613          	li	a2,1024
80002588:	0087e793          	ori	a5,a5,8
8000258c:	fff00893          	li	a7,-1
80002590:	00000813          	li	a6,0
80002594:	3d8d0693          	addi	a3,s10,984 # 800023d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800023d9>
80002598:	00f12023          	sw	a5,0(sp)
8000259c:	cb0c8593          	addi	a1,s9,-848 # 80006cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006cb1>
800025a0:	00000793          	li	a5,0
800025a4:	334b0513          	addi	a0,s6,820 # 80006334 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006335>
800025a8:	170020ef          	jal	ra,80004718 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
800025ac:	01c12783          	lw	a5,28(sp)
800025b0:	fff00593          	li	a1,-1
800025b4:	32478513          	addi	a0,a5,804
800025b8:	4a5010ef          	jal	ra,8000425c <z_impl_k_sem_take>
	if (test_result == -1) {
800025bc:	0ccd8793          	addi	a5,s11,204 # 800060cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060cd>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
800025c0:	334b0513          	addi	a0,s6,820
800025c4:	0007a403          	lw	s0,0(a5)
800025c8:	2f4020ef          	jal	ra,800048bc <z_impl_k_thread_abort>
	if (test_result == -2) {
800025cc:	800067b7          	lui	a5,0x80006
800025d0:	0cc78793          	addi	a5,a5,204 # 800060cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060cd>
800025d4:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
800025d8:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
800025dc:	ffe00793          	li	a5,-2
	if (test_result == -1) {
800025e0:	00143413          	seqz	s0,s0
	if (test_result == -2) {
800025e4:	000c2603          	lw	a2,0(s8)
800025e8:	02f71463          	bne	a4,a5,80002610 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
800025ec:	800065b7          	lui	a1,0x80006
800025f0:	c6458593          	addi	a1,a1,-924 # 80005c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c65>
		Z_TC_END_RESULT(ret, test->name);
800025f4:	c6cb8513          	addi	a0,s7,-916 # 80005c6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c6d>
800025f8:	f78ff0ef          	jal	ra,80001d70 <printk>
800025fc:	c0890513          	addi	a0,s2,-1016
80002600:	f70ff0ef          	jal	ra,80001d70 <printk>
		fail += run_test(suite);
80002604:	008a0a33          	add	s4,s4,s0
		suite++;
80002608:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
8000260c:	efdff06f          	j	80002508 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002610:	00241793          	slli	a5,s0,0x2
80002614:	00fa87b3          	add	a5,s5,a5
80002618:	0007a583          	lw	a1,0(a5)
8000261c:	fd9ff06f          	j	800025f4 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002620:	80006537          	lui	a0,0x80006
80002624:	c9050513          	addi	a0,a0,-880 # 80005c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c91>
80002628:	f48ff0ef          	jal	ra,80001d70 <printk>
	test_status = (test_status || fail) ? 1 : 0;
8000262c:	0004a783          	lw	a5,0(s1)
80002630:	00f037b3          	snez	a5,a5
80002634:	ef5ff06f          	j	80002528 <z_ztest_run_test_suite+0xc4>

80002638 <end_report>:

void end_report(void)
{
	if (test_status) {
80002638:	800067b7          	lui	a5,0x80006
8000263c:	0d07a783          	lw	a5,208(a5) # 800060d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d1>
{
80002640:	ff010113          	addi	sp,sp,-16
80002644:	00812423          	sw	s0,8(sp)
80002648:	80006537          	lui	a0,0x80006
8000264c:	00112623          	sw	ra,12(sp)
80002650:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
80002654:	c0850513          	addi	a0,a0,-1016 # 80005c08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c09>
	if (test_status) {
80002658:	02078263          	beqz	a5,8000267c <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
8000265c:	f14ff0ef          	jal	ra,80001d70 <printk>
80002660:	800065b7          	lui	a1,0x80006
80002664:	bb458593          	addi	a1,a1,-1100 # 80005bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bb5>
	} else {
		TC_END_REPORT(TC_PASS);
80002668:	bbc40513          	addi	a0,s0,-1092 # 80005bbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bbd>
	}
}
8000266c:	00812403          	lw	s0,8(sp)
80002670:	00c12083          	lw	ra,12(sp)
80002674:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002678:	ef8ff06f          	j	80001d70 <printk>
8000267c:	ef4ff0ef          	jal	ra,80001d70 <printk>
80002680:	800065b7          	lui	a1,0x80006
80002684:	bd458593          	addi	a1,a1,-1068 # 80005bd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bd5>
80002688:	fe1ff06f          	j	80002668 <end_report+0x30>

8000268c <main>:

	return test_status;
}
#else
void main(void)
{
8000268c:	ff010113          	addi	sp,sp,-16
80002690:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002694:	ce4fe0ef          	jal	ra,80000b78 <test_main>
	end_report();
}
80002698:	00c12083          	lw	ra,12(sp)
8000269c:	01010113          	addi	sp,sp,16
	end_report();
800026a0:	f99ff06f          	j	80002638 <end_report>

800026a4 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
800026a4:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
800026a8:	00012623          	sw	zero,12(sp)
    i++;
800026ac:	00c12783          	lw	a5,12(sp)
800026b0:	00178793          	addi	a5,a5,1
800026b4:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
800026b8:	f00107b7          	lui	a5,0xf0010
800026bc:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
800026c0:	01010113          	addi	sp,sp,16
800026c4:	00008067          	ret

800026c8 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
800026c8:	fff00513          	li	a0,-1
800026cc:	00008067          	ret

800026d0 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
800026d0:	00000513          	li	a0,0
800026d4:	00008067          	ret

800026d8 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
800026d8:	00251713          	slli	a4,a0,0x2
800026dc:	800067b7          	lui	a5,0x80006
800026e0:	00150513          	addi	a0,a0,1
800026e4:	cc078793          	addi	a5,a5,-832 # 80005cc0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cc1>
800026e8:	00251513          	slli	a0,a0,0x2
{
800026ec:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
800026f0:	00e78733          	add	a4,a5,a4
800026f4:	00a787b3          	add	a5,a5,a0
{
800026f8:	00812423          	sw	s0,8(sp)
800026fc:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002700:	00072403          	lw	s0,0(a4)
80002704:	0007a483          	lw	s1,0(a5)
{
80002708:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
8000270c:	00946c63          	bltu	s0,s1,80002724 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002710:	00c12083          	lw	ra,12(sp)
80002714:	00812403          	lw	s0,8(sp)
80002718:	00412483          	lw	s1,4(sp)
8000271c:	01010113          	addi	sp,sp,16
80002720:	00008067          	ret
		retval = device_conf->init(info);
80002724:	00042783          	lw	a5,0(s0)
80002728:	00040513          	mv	a0,s0
8000272c:	0047a783          	lw	a5,4(a5)
80002730:	000780e7          	jalr	a5
		if (retval != 0) {
80002734:	00050463          	beqz	a0,8000273c <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002738:	00042223          	sw	zero,4(s0)
								info++) {
8000273c:	00c40413          	addi	s0,s0,12
80002740:	fcdff06f          	j	8000270c <z_sys_device_do_config_level+0x34>

80002744 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80002744:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80002748:	800067b7          	lui	a5,0x80006
{
8000274c:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002750:	800064b7          	lui	s1,0x80006
{
80002754:	00812423          	sw	s0,8(sp)
80002758:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000275c:	02878413          	addi	s0,a5,40 # 80006028 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006029>
{
80002760:	01212023          	sw	s2,0(sp)
80002764:	02878793          	addi	a5,a5,40
80002768:	05848493          	addi	s1,s1,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
	for (info = __device_init_start; info != __device_init_end; info++) {
8000276c:	00941c63          	bne	s0,s1,80002784 <z_impl_device_get_binding+0x40>
80002770:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80002774:	00078413          	mv	s0,a5
80002778:	02941463          	bne	s0,s1,800027a0 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
8000277c:	00000413          	li	s0,0
80002780:	0440006f          	j	800027c4 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80002784:	00442703          	lw	a4,4(s0)
80002788:	00070863          	beqz	a4,80002798 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
8000278c:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002790:	00072703          	lw	a4,0(a4)
80002794:	02a70863          	beq	a4,a0,800027c4 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002798:	00c40413          	addi	s0,s0,12
8000279c:	fd1ff06f          	j	8000276c <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
800027a0:	00442783          	lw	a5,4(s0)
800027a4:	00079663          	bnez	a5,800027b0 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
800027a8:	00c40413          	addi	s0,s0,12
800027ac:	fcdff06f          	j	80002778 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
800027b0:	00042783          	lw	a5,0(s0)
800027b4:	00090513          	mv	a0,s2
800027b8:	0007a583          	lw	a1,0(a5)
800027bc:	b65ff0ef          	jal	ra,80002320 <strcmp>
800027c0:	fe0514e3          	bnez	a0,800027a8 <z_impl_device_get_binding+0x64>
}
800027c4:	00040513          	mv	a0,s0
800027c8:	00c12083          	lw	ra,12(sp)
800027cc:	00812403          	lw	s0,8(sp)
800027d0:	00412483          	lw	s1,4(sp)
800027d4:	00012903          	lw	s2,0(sp)
800027d8:	01010113          	addi	sp,sp,16
800027dc:	00008067          	ret

800027e0 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
800027e0:	ff010113          	addi	sp,sp,-16
800027e4:	00812423          	sw	s0,8(sp)
800027e8:	00912223          	sw	s1,4(sp)
800027ec:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800027f0:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800027f4:	00200493          	li	s1,2
800027f8:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800027fc:	5a4020ef          	jal	ra,80004da0 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80002800:	00a4c463          	blt	s1,a0,80002808 <idle+0x28>
80002804:	00100513          	li	a0,1
80002808:	00100593          	li	a1,1
8000280c:	670020ef          	jal	ra,80004e7c <z_set_timeout_expiry>
	k_cpu_idle();
80002810:	dd0ff0ef          	jal	ra,80001de0 <k_cpu_idle>
80002814:	fe5ff06f          	j	800027f8 <idle+0x18>

80002818 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80002818:	80006537          	lui	a0,0x80006
8000281c:	800067b7          	lui	a5,0x80006
80002820:	0a850613          	addi	a2,a0,168 # 800060a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060a9>
80002824:	4b078793          	addi	a5,a5,1200 # 800064b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064b1>
80002828:	40c78633          	sub	a2,a5,a2
8000282c:	00000593          	li	a1,0
80002830:	0a850513          	addi	a0,a0,168
80002834:	b11ff06f          	j	80002344 <memset>

80002838 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80002838:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
8000283c:	00200513          	li	a0,2
{
80002840:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80002844:	e95ff0ef          	jal	ra,800026d8 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80002848:	80006537          	lui	a0,0x80006
8000284c:	cd450513          	addi	a0,a0,-812 # 80005cd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd5>
80002850:	d20ff0ef          	jal	ra,80001d70 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80002854:	00300513          	li	a0,3
80002858:	e81ff0ef          	jal	ra,800026d8 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
8000285c:	7b1010ef          	jal	ra,8000480c <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002860:	e2dff0ef          	jal	ra,8000268c <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80002864:	800067b7          	lui	a5,0x80006
80002868:	41478793          	addi	a5,a5,1044 # 80006414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006415>
8000286c:	00c7c703          	lbu	a4,12(a5)
80002870:	ffe77713          	andi	a4,a4,-2
80002874:	00e78623          	sb	a4,12(a5)
}
80002878:	00c12083          	lw	ra,12(sp)
8000287c:	01010113          	addi	sp,sp,16
80002880:	00008067          	ret

80002884 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80002884:	f6010113          	addi	sp,sp,-160
80002888:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
8000288c:	800087b7          	lui	a5,0x80008
80002890:	80006437          	lui	s0,0x80006
80002894:	09312623          	sw	s3,140(sp)
80002898:	cb078793          	addi	a5,a5,-848 # 80007cb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cb1>
8000289c:	48440993          	addi	s3,s0,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
800028a0:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
800028a4:	01010793          	addi	a5,sp,16
800028a8:	07000613          	li	a2,112
800028ac:	00000593          	li	a1,0
800028b0:	00078513          	mv	a0,a5
{
800028b4:	08112e23          	sw	ra,156(sp)
800028b8:	08912a23          	sw	s1,148(sp)
800028bc:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
800028c0:	a85ff0ef          	jal	ra,80002344 <memset>
800028c4:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
800028c8:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800028cc:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
800028d0:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
800028d4:	e05ff0ef          	jal	ra,800026d8 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
800028d8:	00100513          	li	a0,1
800028dc:	dfdff0ef          	jal	ra,800026d8 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
800028e0:	10100793          	li	a5,257
800028e4:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800028e8:	79c010ef          	jal	ra,80004084 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800028ec:	800067b7          	lui	a5,0x80006
800028f0:	d1878793          	addi	a5,a5,-744 # 80005d18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d19>
	_kernel.ready_q.cache = _main_thread;
800028f4:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
800028f8:	00f12223          	sw	a5,4(sp)
800028fc:	800036b7          	lui	a3,0x80003
80002900:	00100793          	li	a5,1
80002904:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
80002908:	41490493          	addi	s1,s2,1044 # 80006414 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006415>
	z_setup_new_thread(_main_thread, _main_stack,
8000290c:	00f12023          	sw	a5,0(sp)
80002910:	00000713          	li	a4,0
80002914:	00000793          	li	a5,0
80002918:	00000893          	li	a7,0
8000291c:	00000813          	li	a6,0
80002920:	83868693          	addi	a3,a3,-1992 # 80002838 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002839>
80002924:	20000613          	li	a2,512
80002928:	0b058593          	addi	a1,a1,176 # 800070b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070b1>
8000292c:	41490513          	addi	a0,s2,1044
	_kernel.ready_q.cache = _main_thread;
80002930:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80002934:	335010ef          	jal	ra,80004468 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002938:	00d4c783          	lbu	a5,13(s1)
8000293c:	48440413          	addi	s0,s0,1156
80002940:	ffb7f713          	andi	a4,a5,-5
80002944:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002948:	01b7f793          	andi	a5,a5,27
8000294c:	00079a63          	bnez	a5,80002960 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80002950:	0184a783          	lw	a5,24(s1)
80002954:	00079663          	bnez	a5,80002960 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002958:	41490513          	addi	a0,s2,1044
8000295c:	509000ef          	jal	ra,80003664 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002960:	800067b7          	lui	a5,0x80006
80002964:	d2078793          	addi	a5,a5,-736 # 80005d20 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d21>
80002968:	00f12223          	sw	a5,4(sp)
8000296c:	80006537          	lui	a0,0x80006
80002970:	00100793          	li	a5,1
80002974:	800026b7          	lui	a3,0x80002
80002978:	800075b7          	lui	a1,0x80007
8000297c:	3a450493          	addi	s1,a0,932 # 800063a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800063a5>
80002980:	00f12023          	sw	a5,0(sp)
80002984:	00f00893          	li	a7,15
80002988:	00000813          	li	a6,0
8000298c:	00000793          	li	a5,0
80002990:	00000713          	li	a4,0
80002994:	7e068693          	addi	a3,a3,2016 # 800027e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800027e1>
80002998:	20000613          	li	a2,512
8000299c:	2b058593          	addi	a1,a1,688 # 800072b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072b1>
800029a0:	3a450513          	addi	a0,a0,932
800029a4:	2c5010ef          	jal	ra,80004468 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
800029a8:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
800029ac:	00942623          	sw	s1,12(s0)
800029b0:	00800513          	li	a0,8
800029b4:	ffb7f793          	andi	a5,a5,-5
800029b8:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
800029bc:	800067b7          	lui	a5,0x80006
800029c0:	49c78793          	addi	a5,a5,1180 # 8000649c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000649d>
800029c4:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
800029c8:	00f42e23          	sw	a5,28(s0)
800029cc:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
800029d0:	00857513          	andi	a0,a0,8
800029d4:	855fd0ef          	jal	ra,80000228 <__swap>

800029d8 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
800029d8:	ff010113          	addi	sp,sp,-16
800029dc:	00812423          	sw	s0,8(sp)
800029e0:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800029e4:	80006437          	lui	s0,0x80006
800029e8:	800064b7          	lui	s1,0x80006
{
800029ec:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800029f0:	05840413          	addi	s0,s0,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
800029f4:	09048493          	addi	s1,s1,144 # 80006090 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006091>
800029f8:	00946e63          	bltu	s0,s1,80002a14 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
800029fc:	00c12083          	lw	ra,12(sp)
80002a00:	00812403          	lw	s0,8(sp)
80002a04:	00412483          	lw	s1,4(sp)
80002a08:	00000513          	li	a0,0
80002a0c:	01010113          	addi	sp,sp,16
80002a10:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
80002a14:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80002a18:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
80002a1c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80002a20:	00f42c23          	sw	a5,24(s0)
80002a24:	dbcfe0ef          	jal	ra,80000fe0 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002a28:	01c40413          	addi	s0,s0,28
80002a2c:	fcdff06f          	j	800029f8 <init_static_pools+0x20>

80002a30 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80002a30:	800067b7          	lui	a5,0x80006
80002a34:	4847a783          	lw	a5,1156(a5) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
{
80002a38:	fb010113          	addi	sp,sp,-80
80002a3c:	04812423          	sw	s0,72(sp)
80002a40:	04912223          	sw	s1,68(sp)
80002a44:	03312e23          	sw	s3,60(sp)
80002a48:	03612823          	sw	s6,48(sp)
80002a4c:	04112623          	sw	ra,76(sp)
80002a50:	05212023          	sw	s2,64(sp)
80002a54:	03412c23          	sw	s4,56(sp)
80002a58:	03512a23          	sw	s5,52(sp)
80002a5c:	03712623          	sw	s7,44(sp)
80002a60:	03812423          	sw	s8,40(sp)
80002a64:	03912223          	sw	s9,36(sp)
80002a68:	03a12023          	sw	s10,32(sp)
80002a6c:	01b12e23          	sw	s11,28(sp)
80002a70:	00050993          	mv	s3,a0
80002a74:	00058493          	mv	s1,a1
80002a78:	00060b13          	mv	s6,a2
80002a7c:	00068413          	mv	s0,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80002a80:	16078263          	beqz	a5,80002be4 <k_mem_pool_alloc+0x1b4>
80002a84:	12069463          	bnez	a3,80002bac <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80002a88:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80002a8c:	80006537          	lui	a0,0x80006
80002a90:	05850513          	addi	a0,a0,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80002a94:	40a98533          	sub	a0,s3,a0
80002a98:	b6db75b7          	lui	a1,0xb6db7
80002a9c:	db758593          	addi	a1,a1,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
80002aa0:	40255513          	srai	a0,a0,0x2
80002aa4:	de1fd0ef          	jal	ra,80000884 <__mulsi3>
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80002aa8:	fffffa37          	lui	s4,0xfffff
		block->id.block = block_num;
80002aac:	00001ab7          	lui	s5,0x1
		block->id.pool = pool_id(p);
80002ab0:	0ff57c13          	andi	s8,a0,255
			if (ret != -EAGAIN) {
80002ab4:	ff500b93          	li	s7,-11
			ret = -ENOMEM;
80002ab8:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80002abc:	0ffa0a13          	addi	s4,s4,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80002ac0:	fffa8a93          	addi	s5,s5,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
80002ac4:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
80002ac8:	01498d93          	addi	s11,s3,20
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002acc:	00048713          	mv	a4,s1
80002ad0:	00c10693          	addi	a3,sp,12
80002ad4:	00810613          	addi	a2,sp,8
80002ad8:	000b0593          	mv	a1,s6
80002adc:	00098513          	mv	a0,s3
80002ae0:	e48fe0ef          	jal	ra,80001128 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80002ae4:	03751263          	bne	a0,s7,80002b08 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002ae8:	00048713          	mv	a4,s1
80002aec:	00c10693          	addi	a3,sp,12
80002af0:	00810613          	addi	a2,sp,8
80002af4:	000b0593          	mv	a1,s6
80002af8:	00098513          	mv	a0,s3
80002afc:	e2cfe0ef          	jal	ra,80001128 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
80002b00:	01751463          	bne	a0,s7,80002b08 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
80002b04:	ff400513          	li	a0,-12
		block->id.level = level_num;
80002b08:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
80002b0c:	01848223          	sb	s8,4(s1)
		block->id.level = level_num;
80002b10:	00f7f793          	andi	a5,a5,15
80002b14:	00879713          	slli	a4,a5,0x8
80002b18:	0044a783          	lw	a5,4(s1)
80002b1c:	0147f7b3          	and	a5,a5,s4
80002b20:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
80002b24:	00c12703          	lw	a4,12(sp)
80002b28:	0157f7b3          	and	a5,a5,s5
80002b2c:	00c71713          	slli	a4,a4,0xc
80002b30:	00e7e7b3          	or	a5,a5,a4
80002b34:	00f4a223          	sw	a5,4(s1)
		if (ret == 0 || timeout == K_NO_WAIT ||
80002b38:	02050c63          	beqz	a0,80002b70 <k_mem_pool_alloc+0x140>
80002b3c:	02040a63          	beqz	s0,80002b70 <k_mem_pool_alloc+0x140>
80002b40:	03951863          	bne	a0,s9,80002b70 <k_mem_pool_alloc+0x140>
80002b44:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
80002b48:	00040613          	mv	a2,s0
80002b4c:	000d8593          	mv	a1,s11
80002b50:	00857513          	andi	a0,a0,8
80002b54:	258010ef          	jal	ra,80003dac <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80002b58:	fff00793          	li	a5,-1
80002b5c:	f6f408e3          	beq	s0,a5,80002acc <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80002b60:	680020ef          	jal	ra,800051e0 <z_tick_get>
80002b64:	40a90433          	sub	s0,s2,a0

			if (timeout < 0) {
80002b68:	f60452e3          	bgez	s0,80002acc <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80002b6c:	ff500513          	li	a0,-11
}
80002b70:	04c12083          	lw	ra,76(sp)
80002b74:	04812403          	lw	s0,72(sp)
80002b78:	04412483          	lw	s1,68(sp)
80002b7c:	04012903          	lw	s2,64(sp)
80002b80:	03c12983          	lw	s3,60(sp)
80002b84:	03812a03          	lw	s4,56(sp)
80002b88:	03412a83          	lw	s5,52(sp)
80002b8c:	03012b03          	lw	s6,48(sp)
80002b90:	02c12b83          	lw	s7,44(sp)
80002b94:	02812c03          	lw	s8,40(sp)
80002b98:	02412c83          	lw	s9,36(sp)
80002b9c:	02012d03          	lw	s10,32(sp)
80002ba0:	01c12d83          	lw	s11,28(sp)
80002ba4:	05010113          	addi	sp,sp,80
80002ba8:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80002bac:	80006937          	lui	s2,0x80006
80002bb0:	800065b7          	lui	a1,0x80006
80002bb4:	80006537          	lui	a0,0x80006
80002bb8:	d3c58593          	addi	a1,a1,-708 # 80005d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d3d>
80002bbc:	03900693          	li	a3,57
80002bc0:	d2890613          	addi	a2,s2,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80002bc4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002bc8:	9a8ff0ef          	jal	ra,80001d70 <printk>
80002bcc:	80006537          	lui	a0,0x80006
80002bd0:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80002bd4:	99cff0ef          	jal	ra,80001d70 <printk>
80002bd8:	03900593          	li	a1,57
80002bdc:	d2890513          	addi	a0,s2,-728
80002be0:	9ccff0ef          	jal	ra,80001dac <assert_post_action>
	if (timeout > 0) {
80002be4:	ea8052e3          	blez	s0,80002a88 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80002be8:	5f8020ef          	jal	ra,800051e0 <z_tick_get>
80002bec:	00050913          	mv	s2,a0
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002bf0:	00a00593          	li	a1,10
80002bf4:	00940513          	addi	a0,s0,9
80002bf8:	cb1fd0ef          	jal	ra,800008a8 <__divsi3>
80002bfc:	01250933          	add	s2,a0,s2
80002c00:	e8dff06f          	j	80002a8c <k_mem_pool_alloc+0x5c>

80002c04 <k_mem_pool_free_id>:
void k_mem_pool_free_id(struct k_mem_block_id *id)
{
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002c04:	00054783          	lbu	a5,0(a0)
{
80002c08:	fe010113          	addi	sp,sp,-32
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002c0c:	00052603          	lw	a2,0(a0)
{
80002c10:	00812c23          	sw	s0,24(sp)
80002c14:	00379413          	slli	s0,a5,0x3
80002c18:	01212823          	sw	s2,16(sp)
80002c1c:	40f40433          	sub	s0,s0,a5
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002c20:	80006937          	lui	s2,0x80006
80002c24:	00241413          	slli	s0,s0,0x2
80002c28:	00865593          	srli	a1,a2,0x8
80002c2c:	05890513          	addi	a0,s2,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80002c30:	00c65613          	srli	a2,a2,0xc
80002c34:	00f5f593          	andi	a1,a1,15
80002c38:	00850533          	add	a0,a0,s0
{
80002c3c:	00112e23          	sw	ra,28(sp)
80002c40:	00912a23          	sw	s1,20(sp)
80002c44:	01312623          	sw	s3,12(sp)
80002c48:	01412423          	sw	s4,8(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
80002c4c:	fbcfe0ef          	jal	ra,80001408 <z_sys_mem_pool_block_free>
80002c50:	00800593          	li	a1,8
80002c54:	3005b5f3          	csrrc	a1,mstatus,a1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002c58:	800064b7          	lui	s1,0x80006
80002c5c:	0d448513          	addi	a0,s1,212 # 800060d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d5>
	key = (mstatus & SOC_MSTATUS_IEN);
80002c60:	0085f993          	andi	s3,a1,8
80002c64:	0d1010ef          	jal	ra,80004534 <z_spin_lock_valid>
80002c68:	05890913          	addi	s2,s2,88
80002c6c:	02051e63          	bnez	a0,80002ca8 <k_mem_pool_free_id+0xa4>
80002c70:	80006a37          	lui	s4,0x80006
80002c74:	800065b7          	lui	a1,0x80006
80002c78:	80006537          	lui	a0,0x80006
80002c7c:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80002c80:	04e00693          	li	a3,78
80002c84:	b34a0613          	addi	a2,s4,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002c88:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002c8c:	8e4ff0ef          	jal	ra,80001d70 <printk>
80002c90:	80006537          	lui	a0,0x80006
80002c94:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80002c98:	8d8ff0ef          	jal	ra,80001d70 <printk>
80002c9c:	04e00593          	li	a1,78
80002ca0:	b34a0513          	addi	a0,s4,-1228
80002ca4:	908ff0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80002ca8:	0d448513          	addi	a0,s1,212
80002cac:	0e1010ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80002cb0:	01440513          	addi	a0,s0,20
80002cb4:	00a90533          	add	a0,s2,a0
80002cb8:	364010ef          	jal	ra,8000401c <z_unpend_all>

	if (need_sched != 0) {
80002cbc:	02050663          	beqz	a0,80002ce8 <k_mem_pool_free_id+0xe4>
		z_reschedule(&lock, key);
	} else {
		k_spin_unlock(&lock, key);
	}
}
80002cc0:	01812403          	lw	s0,24(sp)
80002cc4:	01c12083          	lw	ra,28(sp)
80002cc8:	01012903          	lw	s2,16(sp)
80002ccc:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80002cd0:	00098593          	mv	a1,s3
80002cd4:	0d448513          	addi	a0,s1,212
}
80002cd8:	00c12983          	lw	s3,12(sp)
80002cdc:	01412483          	lw	s1,20(sp)
80002ce0:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80002ce4:	3340006f          	j	80003018 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ce8:	0d448513          	addi	a0,s1,212
80002cec:	071010ef          	jal	ra,8000455c <z_spin_unlock_valid>
80002cf0:	02051e63          	bnez	a0,80002d2c <k_mem_pool_free_id+0x128>
80002cf4:	80006437          	lui	s0,0x80006
80002cf8:	800065b7          	lui	a1,0x80006
80002cfc:	80006537          	lui	a0,0x80006
80002d00:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80002d04:	06100693          	li	a3,97
80002d08:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002d0c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002d10:	860ff0ef          	jal	ra,80001d70 <printk>
80002d14:	80006537          	lui	a0,0x80006
80002d18:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80002d1c:	854ff0ef          	jal	ra,80001d70 <printk>
80002d20:	06100593          	li	a1,97
80002d24:	b3440513          	addi	a0,s0,-1228
80002d28:	884ff0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d2c:	3009a5f3          	csrrs	a1,mstatus,s3
}
80002d30:	01c12083          	lw	ra,28(sp)
80002d34:	01812403          	lw	s0,24(sp)
80002d38:	01412483          	lw	s1,20(sp)
80002d3c:	01012903          	lw	s2,16(sp)
80002d40:	00c12983          	lw	s3,12(sp)
80002d44:	00812a03          	lw	s4,8(sp)
80002d48:	02010113          	addi	sp,sp,32
80002d4c:	00008067          	ret

80002d50 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
80002d50:	00450513          	addi	a0,a0,4
80002d54:	eb1ff06f          	j	80002c04 <k_mem_pool_free_id>

80002d58 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80002d58:	00d54783          	lbu	a5,13(a0)
80002d5c:	01f7f793          	andi	a5,a5,31
80002d60:	00079863          	bnez	a5,80002d70 <z_is_thread_ready+0x18>
80002d64:	01852503          	lw	a0,24(a0)
80002d68:	00153513          	seqz	a0,a0
80002d6c:	00008067          	ret
80002d70:	00000513          	li	a0,0
}
80002d74:	00008067          	ret

80002d78 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002d78:	ff010113          	addi	sp,sp,-16
80002d7c:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002d80:	cacff0ef          	jal	ra,8000222c <z_clock_elapsed>
80002d84:	800067b7          	lui	a5,0x80006
80002d88:	0e07a783          	lw	a5,224(a5) # 800060e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e1>

	z_set_timeout_expiry(slice_time, false);
}
80002d8c:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002d90:	80006737          	lui	a4,0x80006
80002d94:	00a78533          	add	a0,a5,a0
80002d98:	48a72a23          	sw	a0,1172(a4) # 80006494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006495>
	z_set_timeout_expiry(slice_time, false);
80002d9c:	00000593          	li	a1,0
80002da0:	00078513          	mv	a0,a5
}
80002da4:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002da8:	0d40206f          	j	80004e7c <z_set_timeout_expiry>

80002dac <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002dac:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002db0:	ff010113          	addi	sp,sp,-16
80002db4:	00812423          	sw	s0,8(sp)
80002db8:	00112623          	sw	ra,12(sp)
80002dbc:	00912223          	sw	s1,4(sp)
80002dc0:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002dc4:	02079863          	bnez	a5,80002df4 <pended_on.isra.15+0x48>
80002dc8:	800064b7          	lui	s1,0x80006
80002dcc:	800065b7          	lui	a1,0x80006
80002dd0:	80006537          	lui	a0,0x80006
80002dd4:	e0058593          	addi	a1,a1,-512 # 80005e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e01>
80002dd8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002ddc:	18300693          	li	a3,387
80002de0:	dec48613          	addi	a2,s1,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80002de4:	f8dfe0ef          	jal	ra,80001d70 <printk>
80002de8:	18300593          	li	a1,387
80002dec:	dec48513          	addi	a0,s1,-532
80002df0:	fbdfe0ef          	jal	ra,80001dac <assert_post_action>

	return thread->base.pended_on;
}
80002df4:	00042503          	lw	a0,0(s0)
80002df8:	00c12083          	lw	ra,12(sp)
80002dfc:	00812403          	lw	s0,8(sp)
80002e00:	00412483          	lw	s1,4(sp)
80002e04:	01010113          	addi	sp,sp,16
80002e08:	00008067          	ret

80002e0c <k_sched_time_slice_set>:
{
80002e0c:	fe010113          	addi	sp,sp,-32
80002e10:	00812c23          	sw	s0,24(sp)
80002e14:	01312623          	sw	s3,12(sp)
80002e18:	01412423          	sw	s4,8(sp)
80002e1c:	00112e23          	sw	ra,28(sp)
80002e20:	00912a23          	sw	s1,20(sp)
80002e24:	01212823          	sw	s2,16(sp)
80002e28:	00050a13          	mv	s4,a0
80002e2c:	00058993          	mv	s3,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002e30:	00800413          	li	s0,8
80002e34:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002e38:	800064b7          	lui	s1,0x80006
80002e3c:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80002e40:	00847413          	andi	s0,s0,8
80002e44:	6f0010ef          	jal	ra,80004534 <z_spin_lock_valid>
80002e48:	02051e63          	bnez	a0,80002e84 <k_sched_time_slice_set+0x78>
80002e4c:	80006937          	lui	s2,0x80006
80002e50:	800065b7          	lui	a1,0x80006
80002e54:	80006537          	lui	a0,0x80006
80002e58:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80002e5c:	04e00693          	li	a3,78
80002e60:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002e64:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002e68:	f09fe0ef          	jal	ra,80001d70 <printk>
80002e6c:	80006537          	lui	a0,0x80006
80002e70:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80002e74:	efdfe0ef          	jal	ra,80001d70 <printk>
80002e78:	04e00593          	li	a1,78
80002e7c:	b3490513          	addi	a0,s2,-1228
80002e80:	f2dfe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80002e84:	0d848513          	addi	a0,s1,216
80002e88:	704010ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002e8c:	800067b7          	lui	a5,0x80006
80002e90:	00a00593          	li	a1,10
80002e94:	009a0513          	addi	a0,s4,9
80002e98:	4807aa23          	sw	zero,1172(a5) # 80006494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006495>
80002e9c:	a0dfd0ef          	jal	ra,800008a8 <__divsi3>
		slice_max_prio = prio;
80002ea0:	800067b7          	lui	a5,0x80006
		slice_time = z_ms_to_ticks(slice);
80002ea4:	80006937          	lui	s2,0x80006
80002ea8:	0ea92023          	sw	a0,224(s2) # 800060e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e1>
		slice_max_prio = prio;
80002eac:	0d37ae23          	sw	s3,220(a5) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
		reset_time_slice();
80002eb0:	ec9ff0ef          	jal	ra,80002d78 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002eb4:	0d848513          	addi	a0,s1,216
80002eb8:	6a4010ef          	jal	ra,8000455c <z_spin_unlock_valid>
80002ebc:	02051e63          	bnez	a0,80002ef8 <k_sched_time_slice_set+0xec>
80002ec0:	800064b7          	lui	s1,0x80006
80002ec4:	800065b7          	lui	a1,0x80006
80002ec8:	80006537          	lui	a0,0x80006
80002ecc:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80002ed0:	06100693          	li	a3,97
80002ed4:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002ed8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002edc:	e95fe0ef          	jal	ra,80001d70 <printk>
80002ee0:	80006537          	lui	a0,0x80006
80002ee4:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80002ee8:	e89fe0ef          	jal	ra,80001d70 <printk>
80002eec:	06100593          	li	a1,97
80002ef0:	b3448513          	addi	a0,s1,-1228
80002ef4:	eb9fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ef8:	30042473          	csrrs	s0,mstatus,s0
}
80002efc:	01c12083          	lw	ra,28(sp)
80002f00:	01812403          	lw	s0,24(sp)
80002f04:	01412483          	lw	s1,20(sp)
80002f08:	01012903          	lw	s2,16(sp)
80002f0c:	00c12983          	lw	s3,12(sp)
80002f10:	00812a03          	lw	s4,8(sp)
80002f14:	02010113          	addi	sp,sp,32
80002f18:	00008067          	ret

80002f1c <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002f1c:	fe010113          	addi	sp,sp,-32
80002f20:	00812c23          	sw	s0,24(sp)
80002f24:	01212823          	sw	s2,16(sp)
80002f28:	00112e23          	sw	ra,28(sp)
80002f2c:	00912a23          	sw	s1,20(sp)
80002f30:	01312623          	sw	s3,12(sp)
80002f34:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002f38:	00800413          	li	s0,8
80002f3c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002f40:	800064b7          	lui	s1,0x80006
80002f44:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80002f48:	00847413          	andi	s0,s0,8
80002f4c:	5e8010ef          	jal	ra,80004534 <z_spin_lock_valid>
80002f50:	02051e63          	bnez	a0,80002f8c <z_unpend_thread_no_timeout+0x70>
80002f54:	800069b7          	lui	s3,0x80006
80002f58:	800065b7          	lui	a1,0x80006
80002f5c:	80006537          	lui	a0,0x80006
80002f60:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80002f64:	04e00693          	li	a3,78
80002f68:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002f6c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002f70:	e01fe0ef          	jal	ra,80001d70 <printk>
80002f74:	80006537          	lui	a0,0x80006
80002f78:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80002f7c:	df5fe0ef          	jal	ra,80001d70 <printk>
80002f80:	04e00593          	li	a1,78
80002f84:	b3498513          	addi	a0,s3,-1228
80002f88:	e25fe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80002f8c:	0d848513          	addi	a0,s1,216
80002f90:	5fc010ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002f94:	00890513          	addi	a0,s2,8
80002f98:	e15ff0ef          	jal	ra,80002dac <pended_on.isra.15>
80002f9c:	00090593          	mv	a1,s2
80002fa0:	2f0000ef          	jal	ra,80003290 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002fa4:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002fa8:	0d848513          	addi	a0,s1,216
80002fac:	ffd7f793          	andi	a5,a5,-3
80002fb0:	00f906a3          	sb	a5,13(s2)
80002fb4:	5a8010ef          	jal	ra,8000455c <z_spin_unlock_valid>
80002fb8:	02051e63          	bnez	a0,80002ff4 <z_unpend_thread_no_timeout+0xd8>
80002fbc:	800064b7          	lui	s1,0x80006
80002fc0:	800065b7          	lui	a1,0x80006
80002fc4:	80006537          	lui	a0,0x80006
80002fc8:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80002fcc:	06100693          	li	a3,97
80002fd0:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80002fd4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80002fd8:	d99fe0ef          	jal	ra,80001d70 <printk>
80002fdc:	80006537          	lui	a0,0x80006
80002fe0:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80002fe4:	d8dfe0ef          	jal	ra,80001d70 <printk>
80002fe8:	06100593          	li	a1,97
80002fec:	b3448513          	addi	a0,s1,-1228
80002ff0:	dbdfe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002ff4:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002ff8:	01c12083          	lw	ra,28(sp)
80002ffc:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003000:	00092423          	sw	zero,8(s2)
}
80003004:	01412483          	lw	s1,20(sp)
80003008:	01012903          	lw	s2,16(sp)
8000300c:	00c12983          	lw	s3,12(sp)
80003010:	02010113          	addi	sp,sp,32
80003014:	00008067          	ret

80003018 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003018:	800067b7          	lui	a5,0x80006
8000301c:	4847a783          	lw	a5,1156(a5) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
{
80003020:	ff010113          	addi	sp,sp,-16
80003024:	00812423          	sw	s0,8(sp)
80003028:	00112623          	sw	ra,12(sp)
8000302c:	00912223          	sw	s1,4(sp)
80003030:	00058413          	mv	s0,a1
	if (resched()) {
80003034:	04079e63          	bnez	a5,80003090 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003038:	524010ef          	jal	ra,8000455c <z_spin_unlock_valid>
8000303c:	02051e63          	bnez	a0,80003078 <z_reschedule+0x60>
80003040:	800064b7          	lui	s1,0x80006
80003044:	800065b7          	lui	a1,0x80006
80003048:	80006537          	lui	a0,0x80006
8000304c:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003050:	07800693          	li	a3,120
80003054:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003058:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000305c:	d15fe0ef          	jal	ra,80001d70 <printk>
80003060:	80006537          	lui	a0,0x80006
80003064:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003068:	d09fe0ef          	jal	ra,80001d70 <printk>
8000306c:	07800593          	li	a1,120
80003070:	b3448513          	addi	a0,s1,-1228
80003074:	d39fe0ef          	jal	ra,80001dac <assert_post_action>
80003078:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
8000307c:	00812403          	lw	s0,8(sp)
80003080:	00c12083          	lw	ra,12(sp)
80003084:	00412483          	lw	s1,4(sp)
80003088:	01010113          	addi	sp,sp,16
8000308c:	99cfd06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003090:	4cc010ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003094:	02051e63          	bnez	a0,800030d0 <z_reschedule+0xb8>
80003098:	800064b7          	lui	s1,0x80006
8000309c:	800065b7          	lui	a1,0x80006
800030a0:	80006537          	lui	a0,0x80006
800030a4:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800030a8:	06100693          	li	a3,97
800030ac:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800030b0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800030b4:	cbdfe0ef          	jal	ra,80001d70 <printk>
800030b8:	80006537          	lui	a0,0x80006
800030bc:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800030c0:	cb1fe0ef          	jal	ra,80001d70 <printk>
800030c4:	06100593          	li	a1,97
800030c8:	b3448513          	addi	a0,s1,-1228
800030cc:	ce1fe0ef          	jal	ra,80001dac <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
800030d0:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030d4:	30042473          	csrrs	s0,mstatus,s0
800030d8:	00c12083          	lw	ra,12(sp)
800030dc:	00812403          	lw	s0,8(sp)
800030e0:	00412483          	lw	s1,4(sp)
800030e4:	01010113          	addi	sp,sp,16
800030e8:	00008067          	ret

800030ec <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
800030ec:	80006737          	lui	a4,0x80006
800030f0:	48472703          	lw	a4,1156(a4) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
800030f4:	00071463          	bnez	a4,800030fc <z_reschedule_irqlock+0x10>
800030f8:	930fd06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
800030fc:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003100:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80003104:	00008067          	ret

80003108 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003108:	00800513          	li	a0,8
8000310c:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003110:	00857513          	andi	a0,a0,8
80003114:	fd9ff06f          	j	800030ec <z_reschedule_irqlock>

80003118 <k_sched_lock>:

void k_sched_lock(void)
{
80003118:	fe010113          	addi	sp,sp,-32
8000311c:	00812c23          	sw	s0,24(sp)
80003120:	00112e23          	sw	ra,28(sp)
80003124:	00912a23          	sw	s1,20(sp)
80003128:	01212823          	sw	s2,16(sp)
8000312c:	01312623          	sw	s3,12(sp)
80003130:	00800413          	li	s0,8
80003134:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003138:	800064b7          	lui	s1,0x80006
8000313c:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003140:	00847413          	andi	s0,s0,8
80003144:	3f0010ef          	jal	ra,80004534 <z_spin_lock_valid>
80003148:	02051e63          	bnez	a0,80003184 <k_sched_lock+0x6c>
8000314c:	80006937          	lui	s2,0x80006
80003150:	800065b7          	lui	a1,0x80006
80003154:	80006537          	lui	a0,0x80006
80003158:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
8000315c:	04e00693          	li	a3,78
80003160:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003164:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003168:	c09fe0ef          	jal	ra,80001d70 <printk>
8000316c:	80006537          	lui	a0,0x80006
80003170:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003174:	bfdfe0ef          	jal	ra,80001d70 <printk>
80003178:	04e00593          	li	a1,78
8000317c:	b3490513          	addi	a0,s2,-1228
80003180:	c2dfe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003184:	0d848513          	addi	a0,s1,216
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80003188:	80006937          	lui	s2,0x80006
8000318c:	400010ef          	jal	ra,8000458c <z_spin_lock_set_owner>
80003190:	48492783          	lw	a5,1156(s2) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80003194:	48490913          	addi	s2,s2,1156
80003198:	02078e63          	beqz	a5,800031d4 <k_sched_lock+0xbc>
8000319c:	800069b7          	lui	s3,0x80006
800031a0:	800065b7          	lui	a1,0x80006
800031a4:	80006537          	lui	a0,0x80006
800031a8:	d8458593          	addi	a1,a1,-636 # 80005d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d85>
800031ac:	10000693          	li	a3,256
800031b0:	d6898613          	addi	a2,s3,-664 # 80005d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d69>
800031b4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800031b8:	bb9fe0ef          	jal	ra,80001d70 <printk>
800031bc:	80006537          	lui	a0,0x80006
800031c0:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800031c4:	badfe0ef          	jal	ra,80001d70 <printk>
800031c8:	10000593          	li	a1,256
800031cc:	d6898513          	addi	a0,s3,-664
800031d0:	bddfe0ef          	jal	ra,80001dac <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800031d4:	00892783          	lw	a5,8(s2)
800031d8:	00f7c703          	lbu	a4,15(a5)
800031dc:	00100793          	li	a5,1
800031e0:	02f71e63          	bne	a4,a5,8000321c <k_sched_lock+0x104>
800031e4:	800069b7          	lui	s3,0x80006
800031e8:	800065b7          	lui	a1,0x80006
800031ec:	80006537          	lui	a0,0x80006
800031f0:	d9c58593          	addi	a1,a1,-612 # 80005d9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d9d>
800031f4:	10100693          	li	a3,257
800031f8:	d6898613          	addi	a2,s3,-664 # 80005d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d69>
800031fc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003200:	b71fe0ef          	jal	ra,80001d70 <printk>
80003204:	80006537          	lui	a0,0x80006
80003208:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
8000320c:	b65fe0ef          	jal	ra,80001d70 <printk>
80003210:	10100593          	li	a1,257
80003214:	d6898513          	addi	a0,s3,-664
80003218:	b95fe0ef          	jal	ra,80001dac <assert_post_action>

	--_current->base.sched_locked;
8000321c:	00892703          	lw	a4,8(s2)
80003220:	00f74783          	lbu	a5,15(a4)
80003224:	fff78793          	addi	a5,a5,-1
80003228:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000322c:	0d848513          	addi	a0,s1,216
80003230:	32c010ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003234:	02051e63          	bnez	a0,80003270 <k_sched_lock+0x158>
80003238:	800064b7          	lui	s1,0x80006
8000323c:	800065b7          	lui	a1,0x80006
80003240:	80006537          	lui	a0,0x80006
80003244:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003248:	06100693          	li	a3,97
8000324c:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003250:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003254:	b1dfe0ef          	jal	ra,80001d70 <printk>
80003258:	80006537          	lui	a0,0x80006
8000325c:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003260:	b11fe0ef          	jal	ra,80001d70 <printk>
80003264:	06100593          	li	a1,97
80003268:	b3448513          	addi	a0,s1,-1228
8000326c:	b41fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003270:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80003274:	01c12083          	lw	ra,28(sp)
80003278:	01812403          	lw	s0,24(sp)
8000327c:	01412483          	lw	s1,20(sp)
80003280:	01012903          	lw	s2,16(sp)
80003284:	00c12983          	lw	s3,12(sp)
80003288:	02010113          	addi	sp,sp,32
8000328c:	00008067          	ret

80003290 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80003290:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80003294:	0247a783          	lw	a5,36(a5) # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
{
80003298:	ff010113          	addi	sp,sp,-16
8000329c:	00812423          	sw	s0,8(sp)
800032a0:	00112623          	sw	ra,12(sp)
800032a4:	00912223          	sw	s1,4(sp)
800032a8:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800032ac:	02f59863          	bne	a1,a5,800032dc <z_priq_dumb_remove+0x4c>
800032b0:	800064b7          	lui	s1,0x80006
800032b4:	800065b7          	lui	a1,0x80006
800032b8:	80006537          	lui	a0,0x80006
800032bc:	e3858593          	addi	a1,a1,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
800032c0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800032c4:	28c00693          	li	a3,652
800032c8:	dec48613          	addi	a2,s1,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
800032cc:	aa5fe0ef          	jal	ra,80001d70 <printk>
800032d0:	28c00593          	li	a1,652
800032d4:	dec48513          	addi	a0,s1,-532
800032d8:	ad5fe0ef          	jal	ra,80001dac <assert_post_action>
	node->prev->next = node->next;
800032dc:	00442703          	lw	a4,4(s0)
800032e0:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
800032e4:	00c12083          	lw	ra,12(sp)
800032e8:	00412483          	lw	s1,4(sp)
800032ec:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800032f0:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800032f4:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
800032f8:	00042223          	sw	zero,4(s0)
800032fc:	00812403          	lw	s0,8(sp)
80003300:	01010113          	addi	sp,sp,16
80003304:	00008067          	ret

80003308 <z_unpend_thread>:
{
80003308:	fe010113          	addi	sp,sp,-32
8000330c:	00812c23          	sw	s0,24(sp)
80003310:	00912a23          	sw	s1,20(sp)
80003314:	00112e23          	sw	ra,28(sp)
80003318:	01212823          	sw	s2,16(sp)
8000331c:	01312623          	sw	s3,12(sp)
80003320:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003324:	00800493          	li	s1,8
80003328:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000332c:	80006937          	lui	s2,0x80006
80003330:	0d890513          	addi	a0,s2,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003334:	0084f493          	andi	s1,s1,8
80003338:	1fc010ef          	jal	ra,80004534 <z_spin_lock_valid>
8000333c:	02051e63          	bnez	a0,80003378 <z_unpend_thread+0x70>
80003340:	800069b7          	lui	s3,0x80006
80003344:	800065b7          	lui	a1,0x80006
80003348:	80006537          	lui	a0,0x80006
8000334c:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80003350:	04e00693          	li	a3,78
80003354:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003358:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000335c:	a15fe0ef          	jal	ra,80001d70 <printk>
80003360:	80006537          	lui	a0,0x80006
80003364:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003368:	a09fe0ef          	jal	ra,80001d70 <printk>
8000336c:	04e00593          	li	a1,78
80003370:	b3498513          	addi	a0,s3,-1228
80003374:	a39fe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003378:	0d890513          	addi	a0,s2,216
8000337c:	210010ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003380:	00840513          	addi	a0,s0,8
80003384:	a29ff0ef          	jal	ra,80002dac <pended_on.isra.15>
80003388:	00040593          	mv	a1,s0
8000338c:	f05ff0ef          	jal	ra,80003290 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003390:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003394:	0d890513          	addi	a0,s2,216
80003398:	ffd7f793          	andi	a5,a5,-3
8000339c:	00f406a3          	sb	a5,13(s0)
800033a0:	1bc010ef          	jal	ra,8000455c <z_spin_unlock_valid>
800033a4:	02051e63          	bnez	a0,800033e0 <z_unpend_thread+0xd8>
800033a8:	80006937          	lui	s2,0x80006
800033ac:	800065b7          	lui	a1,0x80006
800033b0:	80006537          	lui	a0,0x80006
800033b4:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800033b8:	06100693          	li	a3,97
800033bc:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800033c0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800033c4:	9adfe0ef          	jal	ra,80001d70 <printk>
800033c8:	80006537          	lui	a0,0x80006
800033cc:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800033d0:	9a1fe0ef          	jal	ra,80001d70 <printk>
800033d4:	06100593          	li	a1,97
800033d8:	b3490513          	addi	a0,s2,-1228
800033dc:	9d1fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800033e0:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800033e4:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800033e8:	01840513          	addi	a0,s0,24
}
800033ec:	01812403          	lw	s0,24(sp)
800033f0:	01c12083          	lw	ra,28(sp)
800033f4:	01412483          	lw	s1,20(sp)
800033f8:	01012903          	lw	s2,16(sp)
800033fc:	00c12983          	lw	s3,12(sp)
80003400:	02010113          	addi	sp,sp,32
80003404:	0a50106f          	j	80004ca8 <z_abort_timeout>

80003408 <z_priq_dumb_best>:
	return list->head == list;
80003408:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000340c:	00f51463          	bne	a0,a5,80003414 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003410:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80003414:	00078513          	mv	a0,a5
80003418:	00008067          	ret

8000341c <update_cache>:
{
8000341c:	ff010113          	addi	sp,sp,-16
80003420:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003424:	80006437          	lui	s0,0x80006
{
80003428:	01212023          	sw	s2,0(sp)
8000342c:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003430:	48440513          	addi	a0,s0,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80003434:	02450513          	addi	a0,a0,36
{
80003438:	00912223          	sw	s1,4(sp)
8000343c:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003440:	fc9ff0ef          	jal	ra,80003408 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80003444:	48440413          	addi	s0,s0,1156
80003448:	00050493          	mv	s1,a0
8000344c:	00051463          	bnez	a0,80003454 <update_cache+0x38>
80003450:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
80003454:	06091e63          	bnez	s2,800034d0 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003458:	00842783          	lw	a5,8(s0)
8000345c:	02079e63          	bnez	a5,80003498 <update_cache+0x7c>
80003460:	80006937          	lui	s2,0x80006
80003464:	800065b7          	lui	a1,0x80006
80003468:	80006537          	lui	a0,0x80006
8000346c:	e1858593          	addi	a1,a1,-488 # 80005e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e19>
80003470:	07f00693          	li	a3,127
80003474:	dec90613          	addi	a2,s2,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003478:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000347c:	8f5fe0ef          	jal	ra,80001d70 <printk>
80003480:	80006537          	lui	a0,0x80006
80003484:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80003488:	8e9fe0ef          	jal	ra,80001d70 <printk>
8000348c:	07f00593          	li	a1,127
80003490:	dec90513          	addi	a0,s2,-532
80003494:	919fe0ef          	jal	ra,80001dac <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003498:	00842783          	lw	a5,8(s0)
8000349c:	00d7c703          	lbu	a4,13(a5)
800034a0:	01f77713          	andi	a4,a4,31
800034a4:	02071663          	bnez	a4,800034d0 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800034a8:	00e7d683          	lhu	a3,14(a5)
800034ac:	07f00713          	li	a4,127
800034b0:	02d77063          	bgeu	a4,a3,800034d0 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800034b4:	02f42023          	sw	a5,32(s0)
}
800034b8:	00c12083          	lw	ra,12(sp)
800034bc:	00812403          	lw	s0,8(sp)
800034c0:	00412483          	lw	s1,4(sp)
800034c4:	00012903          	lw	s2,0(sp)
800034c8:	01010113          	addi	sp,sp,16
800034cc:	00008067          	ret
		if (th != _current) {
800034d0:	00842783          	lw	a5,8(s0)
800034d4:	00978463          	beq	a5,s1,800034dc <update_cache+0xc0>
			reset_time_slice();
800034d8:	8a1ff0ef          	jal	ra,80002d78 <reset_time_slice>
		_kernel.ready_q.cache = th;
800034dc:	02942023          	sw	s1,32(s0)
}
800034e0:	fd9ff06f          	j	800034b8 <update_cache+0x9c>

800034e4 <k_sched_unlock>:
{
800034e4:	fe010113          	addi	sp,sp,-32
800034e8:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800034ec:	80006937          	lui	s2,0x80006
800034f0:	48490793          	addi	a5,s2,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
800034f4:	0087a783          	lw	a5,8(a5)
{
800034f8:	00112e23          	sw	ra,28(sp)
800034fc:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003500:	00f7c783          	lbu	a5,15(a5)
{
80003504:	00912a23          	sw	s1,20(sp)
80003508:	01312623          	sw	s3,12(sp)
8000350c:	48490913          	addi	s2,s2,1156
	__ASSERT(_current->base.sched_locked != 0, "");
80003510:	02079e63          	bnez	a5,8000354c <k_sched_unlock+0x68>
80003514:	80006437          	lui	s0,0x80006
80003518:	800065b7          	lui	a1,0x80006
8000351c:	80006537          	lui	a0,0x80006
80003520:	dc458593          	addi	a1,a1,-572 # 80005dc4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dc5>
80003524:	22100693          	li	a3,545
80003528:	dec40613          	addi	a2,s0,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
8000352c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003530:	841fe0ef          	jal	ra,80001d70 <printk>
80003534:	80006537          	lui	a0,0x80006
80003538:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
8000353c:	835fe0ef          	jal	ra,80001d70 <printk>
80003540:	22100593          	li	a1,545
80003544:	dec40513          	addi	a0,s0,-532
80003548:	865fe0ef          	jal	ra,80001dac <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
8000354c:	00092783          	lw	a5,0(s2)
80003550:	02078e63          	beqz	a5,8000358c <k_sched_unlock+0xa8>
80003554:	80006437          	lui	s0,0x80006
80003558:	800065b7          	lui	a1,0x80006
8000355c:	80006537          	lui	a0,0x80006
80003560:	d8458593          	addi	a1,a1,-636 # 80005d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d85>
80003564:	22200693          	li	a3,546
80003568:	dec40613          	addi	a2,s0,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
8000356c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003570:	801fe0ef          	jal	ra,80001d70 <printk>
80003574:	80006537          	lui	a0,0x80006
80003578:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
8000357c:	ff4fe0ef          	jal	ra,80001d70 <printk>
80003580:	22200593          	li	a1,546
80003584:	dec40513          	addi	a0,s0,-532
80003588:	825fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000358c:	00800413          	li	s0,8
80003590:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003594:	800064b7          	lui	s1,0x80006
80003598:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
8000359c:	00847413          	andi	s0,s0,8
800035a0:	795000ef          	jal	ra,80004534 <z_spin_lock_valid>
800035a4:	02051e63          	bnez	a0,800035e0 <k_sched_unlock+0xfc>
800035a8:	800069b7          	lui	s3,0x80006
800035ac:	800065b7          	lui	a1,0x80006
800035b0:	80006537          	lui	a0,0x80006
800035b4:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800035b8:	04e00693          	li	a3,78
800035bc:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800035c0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800035c4:	facfe0ef          	jal	ra,80001d70 <printk>
800035c8:	80006537          	lui	a0,0x80006
800035cc:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
800035d0:	fa0fe0ef          	jal	ra,80001d70 <printk>
800035d4:	04e00593          	li	a1,78
800035d8:	b3498513          	addi	a0,s3,-1228
800035dc:	fd0fe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
800035e0:	0d848513          	addi	a0,s1,216
800035e4:	7a9000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800035e8:	00892703          	lw	a4,8(s2)
		update_cache(1);
800035ec:	00100513          	li	a0,1
		++_current->base.sched_locked;
800035f0:	00f74783          	lbu	a5,15(a4)
800035f4:	00178793          	addi	a5,a5,1
800035f8:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800035fc:	e21ff0ef          	jal	ra,8000341c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003600:	0d848513          	addi	a0,s1,216
80003604:	759000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003608:	02051e63          	bnez	a0,80003644 <k_sched_unlock+0x160>
8000360c:	800064b7          	lui	s1,0x80006
80003610:	800065b7          	lui	a1,0x80006
80003614:	80006537          	lui	a0,0x80006
80003618:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
8000361c:	06100693          	li	a3,97
80003620:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003624:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003628:	f48fe0ef          	jal	ra,80001d70 <printk>
8000362c:	80006537          	lui	a0,0x80006
80003630:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003634:	f3cfe0ef          	jal	ra,80001d70 <printk>
80003638:	06100593          	li	a1,97
8000363c:	b3448513          	addi	a0,s1,-1228
80003640:	f6cfe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003644:	30042473          	csrrs	s0,mstatus,s0
}
80003648:	01812403          	lw	s0,24(sp)
8000364c:	01c12083          	lw	ra,28(sp)
80003650:	01412483          	lw	s1,20(sp)
80003654:	01012903          	lw	s2,16(sp)
80003658:	00c12983          	lw	s3,12(sp)
8000365c:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003660:	aa9ff06f          	j	80003108 <z_reschedule_unlocked>

80003664 <z_add_thread_to_ready_q>:
{
80003664:	fe010113          	addi	sp,sp,-32
80003668:	00812c23          	sw	s0,24(sp)
8000366c:	00912a23          	sw	s1,20(sp)
80003670:	00112e23          	sw	ra,28(sp)
80003674:	01212823          	sw	s2,16(sp)
80003678:	01312623          	sw	s3,12(sp)
8000367c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003680:	00800493          	li	s1,8
80003684:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003688:	80006937          	lui	s2,0x80006
8000368c:	0d890513          	addi	a0,s2,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003690:	0084f493          	andi	s1,s1,8
80003694:	6a1000ef          	jal	ra,80004534 <z_spin_lock_valid>
80003698:	02051e63          	bnez	a0,800036d4 <z_add_thread_to_ready_q+0x70>
8000369c:	800069b7          	lui	s3,0x80006
800036a0:	800065b7          	lui	a1,0x80006
800036a4:	80006537          	lui	a0,0x80006
800036a8:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800036ac:	04e00693          	li	a3,78
800036b0:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800036b4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800036b8:	eb8fe0ef          	jal	ra,80001d70 <printk>
800036bc:	80006537          	lui	a0,0x80006
800036c0:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
800036c4:	eacfe0ef          	jal	ra,80001d70 <printk>
800036c8:	04e00593          	li	a1,78
800036cc:	b3498513          	addi	a0,s3,-1228
800036d0:	edcfe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
800036d4:	0d890513          	addi	a0,s2,216
800036d8:	6b5000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	return thread == _idle_thread;
800036dc:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800036e0:	0247a783          	lw	a5,36(a5) # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
800036e4:	02f41863          	bne	s0,a5,80003714 <z_add_thread_to_ready_q+0xb0>
800036e8:	800069b7          	lui	s3,0x80006
800036ec:	800065b7          	lui	a1,0x80006
800036f0:	80006537          	lui	a0,0x80006
800036f4:	e3858593          	addi	a1,a1,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
800036f8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800036fc:	27600693          	li	a3,630
80003700:	dec98613          	addi	a2,s3,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003704:	e6cfe0ef          	jal	ra,80001d70 <printk>
80003708:	27600593          	li	a1,630
8000370c:	dec98513          	addi	a0,s3,-532
80003710:	e9cfe0ef          	jal	ra,80001dac <assert_post_action>
	return list->head == list;
80003714:	80006737          	lui	a4,0x80006
80003718:	48470693          	addi	a3,a4,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
8000371c:	0246a783          	lw	a5,36(a3)
80003720:	0286a603          	lw	a2,40(a3)
80003724:	800066b7          	lui	a3,0x80006
80003728:	4a868693          	addi	a3,a3,1192 # 800064a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a9>
8000372c:	48470713          	addi	a4,a4,1156
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003730:	0ad78663          	beq	a5,a3,800037dc <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003734:	0a078463          	beqz	a5,800037dc <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003738:	00e40583          	lb	a1,14(s0)
8000373c:	00e78503          	lb	a0,14(a5)
80003740:	08a5d863          	bge	a1,a0,800037d0 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80003744:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003748:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
8000374c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003750:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003754:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003758:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
8000375c:	00000513          	li	a0,0
80003760:	0407e793          	ori	a5,a5,64
80003764:	00f406a3          	sb	a5,13(s0)
80003768:	cb5ff0ef          	jal	ra,8000341c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000376c:	0d890513          	addi	a0,s2,216
80003770:	5ed000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003774:	02051e63          	bnez	a0,800037b0 <z_add_thread_to_ready_q+0x14c>
80003778:	80006437          	lui	s0,0x80006
8000377c:	800065b7          	lui	a1,0x80006
80003780:	80006537          	lui	a0,0x80006
80003784:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003788:	06100693          	li	a3,97
8000378c:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003790:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003794:	ddcfe0ef          	jal	ra,80001d70 <printk>
80003798:	80006537          	lui	a0,0x80006
8000379c:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800037a0:	dd0fe0ef          	jal	ra,80001d70 <printk>
800037a4:	06100593          	li	a1,97
800037a8:	b3440513          	addi	a0,s0,-1228
800037ac:	e00fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037b0:	3004a4f3          	csrrs	s1,mstatus,s1
}
800037b4:	01c12083          	lw	ra,28(sp)
800037b8:	01812403          	lw	s0,24(sp)
800037bc:	01412483          	lw	s1,20(sp)
800037c0:	01012903          	lw	s2,16(sp)
800037c4:	00c12983          	lw	s3,12(sp)
800037c8:	02010113          	addi	sp,sp,32
800037cc:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
800037d0:	00f60663          	beq	a2,a5,800037dc <z_add_thread_to_ready_q+0x178>
800037d4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800037d8:	f60792e3          	bnez	a5,8000373c <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
800037dc:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
800037e0:	02872783          	lw	a5,40(a4)
	node->next = list;
800037e4:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
800037e8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800037ec:	02872423          	sw	s0,40(a4)
800037f0:	f69ff06f          	j	80003758 <z_add_thread_to_ready_q+0xf4>

800037f4 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
800037f4:	ff052783          	lw	a5,-16(a0)
{
800037f8:	fe010113          	addi	sp,sp,-32
800037fc:	00812c23          	sw	s0,24(sp)
80003800:	01312623          	sw	s3,12(sp)
80003804:	00112e23          	sw	ra,28(sp)
80003808:	00912a23          	sw	s1,20(sp)
8000380c:	01212823          	sw	s2,16(sp)
80003810:	01412423          	sw	s4,8(sp)
80003814:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003818:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
8000381c:	0c078463          	beqz	a5,800038e4 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003820:	00800493          	li	s1,8
80003824:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003828:	80006937          	lui	s2,0x80006
8000382c:	0d890513          	addi	a0,s2,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003830:	0084f493          	andi	s1,s1,8
80003834:	501000ef          	jal	ra,80004534 <z_spin_lock_valid>
80003838:	02051e63          	bnez	a0,80003874 <z_thread_timeout+0x80>
8000383c:	80006a37          	lui	s4,0x80006
80003840:	800065b7          	lui	a1,0x80006
80003844:	80006537          	lui	a0,0x80006
80003848:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
8000384c:	04e00693          	li	a3,78
80003850:	b34a0613          	addi	a2,s4,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003854:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003858:	d18fe0ef          	jal	ra,80001d70 <printk>
8000385c:	80006537          	lui	a0,0x80006
80003860:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003864:	d0cfe0ef          	jal	ra,80001d70 <printk>
80003868:	04e00593          	li	a1,78
8000386c:	b34a0513          	addi	a0,s4,-1228
80003870:	d3cfe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003874:	0d890513          	addi	a0,s2,216
80003878:	515000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000387c:	ff040513          	addi	a0,s0,-16
80003880:	d2cff0ef          	jal	ra,80002dac <pended_on.isra.15>
80003884:	00098593          	mv	a1,s3
80003888:	a09ff0ef          	jal	ra,80003290 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000388c:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003890:	0d890513          	addi	a0,s2,216
80003894:	ffd7f793          	andi	a5,a5,-3
80003898:	fef40aa3          	sb	a5,-11(s0)
8000389c:	4c1000ef          	jal	ra,8000455c <z_spin_unlock_valid>
800038a0:	02051e63          	bnez	a0,800038dc <z_thread_timeout+0xe8>
800038a4:	80006937          	lui	s2,0x80006
800038a8:	800065b7          	lui	a1,0x80006
800038ac:	80006537          	lui	a0,0x80006
800038b0:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800038b4:	06100693          	li	a3,97
800038b8:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800038bc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800038c0:	cb0fe0ef          	jal	ra,80001d70 <printk>
800038c4:	80006537          	lui	a0,0x80006
800038c8:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800038cc:	ca4fe0ef          	jal	ra,80001d70 <printk>
800038d0:	06100593          	li	a1,97
800038d4:	b3490513          	addi	a0,s2,-1228
800038d8:	cd4fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800038dc:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
800038e0:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800038e4:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800038e8:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800038ec:	feb7f793          	andi	a5,a5,-21
800038f0:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
800038f4:	c64ff0ef          	jal	ra,80002d58 <z_is_thread_ready>
800038f8:	02050463          	beqz	a0,80003920 <z_thread_timeout+0x12c>
}
800038fc:	01812403          	lw	s0,24(sp)
80003900:	01c12083          	lw	ra,28(sp)
80003904:	01412483          	lw	s1,20(sp)
80003908:	01012903          	lw	s2,16(sp)
8000390c:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003910:	00098513          	mv	a0,s3
80003914:	00c12983          	lw	s3,12(sp)
80003918:	02010113          	addi	sp,sp,32
8000391c:	d49ff06f          	j	80003664 <z_add_thread_to_ready_q>
80003920:	01c12083          	lw	ra,28(sp)
80003924:	01812403          	lw	s0,24(sp)
80003928:	01412483          	lw	s1,20(sp)
8000392c:	01012903          	lw	s2,16(sp)
80003930:	00c12983          	lw	s3,12(sp)
80003934:	00812a03          	lw	s4,8(sp)
80003938:	02010113          	addi	sp,sp,32
8000393c:	00008067          	ret

80003940 <z_move_thread_to_end_of_prio_q>:
{
80003940:	fe010113          	addi	sp,sp,-32
80003944:	00812c23          	sw	s0,24(sp)
80003948:	01212823          	sw	s2,16(sp)
8000394c:	00112e23          	sw	ra,28(sp)
80003950:	00912a23          	sw	s1,20(sp)
80003954:	01312623          	sw	s3,12(sp)
80003958:	01412423          	sw	s4,8(sp)
8000395c:	01512223          	sw	s5,4(sp)
80003960:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003964:	00800913          	li	s2,8
80003968:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000396c:	800069b7          	lui	s3,0x80006
80003970:	0d898513          	addi	a0,s3,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003974:	00897913          	andi	s2,s2,8
80003978:	3bd000ef          	jal	ra,80004534 <z_spin_lock_valid>
8000397c:	02051e63          	bnez	a0,800039b8 <z_move_thread_to_end_of_prio_q+0x78>
80003980:	800064b7          	lui	s1,0x80006
80003984:	800065b7          	lui	a1,0x80006
80003988:	80006537          	lui	a0,0x80006
8000398c:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80003990:	04e00693          	li	a3,78
80003994:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003998:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000399c:	bd4fe0ef          	jal	ra,80001d70 <printk>
800039a0:	80006537          	lui	a0,0x80006
800039a4:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
800039a8:	bc8fe0ef          	jal	ra,80001d70 <printk>
800039ac:	04e00593          	li	a1,78
800039b0:	b3448513          	addi	a0,s1,-1228
800039b4:	bf8fe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
800039b8:	0d898513          	addi	a0,s3,216
800039bc:	3d1000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800039c0:	800064b7          	lui	s1,0x80006
800039c4:	48448513          	addi	a0,s1,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
800039c8:	00040593          	mv	a1,s0
800039cc:	02450513          	addi	a0,a0,36
800039d0:	8c1ff0ef          	jal	ra,80003290 <z_priq_dumb_remove>
	return thread == _idle_thread;
800039d4:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
800039d8:	0247a783          	lw	a5,36(a5) # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
800039dc:	80006a37          	lui	s4,0x80006
800039e0:	48448493          	addi	s1,s1,1156
800039e4:	4a8a0a13          	addi	s4,s4,1192 # 800064a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064a9>
800039e8:	02f41863          	bne	s0,a5,80003a18 <z_move_thread_to_end_of_prio_q+0xd8>
800039ec:	80006ab7          	lui	s5,0x80006
800039f0:	800065b7          	lui	a1,0x80006
800039f4:	80006537          	lui	a0,0x80006
800039f8:	e3858593          	addi	a1,a1,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
800039fc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003a00:	27600693          	li	a3,630
80003a04:	deca8613          	addi	a2,s5,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003a08:	b68fe0ef          	jal	ra,80001d70 <printk>
80003a0c:	27600593          	li	a1,630
80003a10:	deca8513          	addi	a0,s5,-532
80003a14:	b98fe0ef          	jal	ra,80001dac <assert_post_action>
	return list->head == list;
80003a18:	0244a783          	lw	a5,36(s1)
80003a1c:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003a20:	0b478e63          	beq	a5,s4,80003adc <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003a24:	0a078c63          	beqz	a5,80003adc <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003a28:	00e40683          	lb	a3,14(s0)
80003a2c:	00e78603          	lb	a2,14(a5)
80003a30:	0ac6d063          	bge	a3,a2,80003ad0 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003a34:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003a38:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003a3c:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003a40:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003a44:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003a48:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003a4c:	0084a503          	lw	a0,8(s1)
80003a50:	0407e793          	ori	a5,a5,64
80003a54:	40850533          	sub	a0,a0,s0
80003a58:	00153513          	seqz	a0,a0
80003a5c:	00f406a3          	sb	a5,13(s0)
80003a60:	9bdff0ef          	jal	ra,8000341c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003a64:	0d898513          	addi	a0,s3,216
80003a68:	2f5000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003a6c:	02051e63          	bnez	a0,80003aa8 <z_move_thread_to_end_of_prio_q+0x168>
80003a70:	80006437          	lui	s0,0x80006
80003a74:	800065b7          	lui	a1,0x80006
80003a78:	80006537          	lui	a0,0x80006
80003a7c:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003a80:	06100693          	li	a3,97
80003a84:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003a88:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003a8c:	ae4fe0ef          	jal	ra,80001d70 <printk>
80003a90:	80006537          	lui	a0,0x80006
80003a94:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003a98:	ad8fe0ef          	jal	ra,80001d70 <printk>
80003a9c:	06100593          	li	a1,97
80003aa0:	b3440513          	addi	a0,s0,-1228
80003aa4:	b08fe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003aa8:	30092973          	csrrs	s2,mstatus,s2
}
80003aac:	01c12083          	lw	ra,28(sp)
80003ab0:	01812403          	lw	s0,24(sp)
80003ab4:	01412483          	lw	s1,20(sp)
80003ab8:	01012903          	lw	s2,16(sp)
80003abc:	00c12983          	lw	s3,12(sp)
80003ac0:	00812a03          	lw	s4,8(sp)
80003ac4:	00412a83          	lw	s5,4(sp)
80003ac8:	02010113          	addi	sp,sp,32
80003acc:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003ad0:	00e78663          	beq	a5,a4,80003adc <z_move_thread_to_end_of_prio_q+0x19c>
80003ad4:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003ad8:	f4079ae3          	bnez	a5,80003a2c <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80003adc:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003ae0:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003ae4:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003ae8:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003aec:	0284a423          	sw	s0,40(s1)
80003af0:	f59ff06f          	j	80003a48 <z_move_thread_to_end_of_prio_q+0x108>

80003af4 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003af4:	800067b7          	lui	a5,0x80006
80003af8:	0e07a783          	lw	a5,224(a5) # 800060e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e1>
80003afc:	06078663          	beqz	a5,80003b68 <z_time_slice+0x74>
80003b00:	800067b7          	lui	a5,0x80006
80003b04:	48478793          	addi	a5,a5,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80003b08:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80003b0c:	07f00693          	li	a3,127
80003b10:	00e75603          	lhu	a2,14(a4)
80003b14:	04c6ea63          	bltu	a3,a2,80003b68 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80003b18:	800066b7          	lui	a3,0x80006
80003b1c:	00e70603          	lb	a2,14(a4)
80003b20:	0dc6a683          	lw	a3,220(a3) # 800060dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060dd>
80003b24:	04d64263          	blt	a2,a3,80003b68 <z_time_slice+0x74>
	return thread == _idle_thread;
80003b28:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
80003b2c:	0246a683          	lw	a3,36(a3) # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
80003b30:	02d70c63          	beq	a4,a3,80003b68 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
80003b34:	01872683          	lw	a3,24(a4)
80003b38:	02069863          	bnez	a3,80003b68 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80003b3c:	0107a683          	lw	a3,16(a5)
80003b40:	02d54063          	blt	a0,a3,80003b60 <z_time_slice+0x6c>
{
80003b44:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80003b48:	00070513          	mv	a0,a4
{
80003b4c:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80003b50:	df1ff0ef          	jal	ra,80003940 <z_move_thread_to_end_of_prio_q>
}
80003b54:	00c12083          	lw	ra,12(sp)
80003b58:	01010113          	addi	sp,sp,16
			reset_time_slice();
80003b5c:	a1cff06f          	j	80002d78 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003b60:	40a686b3          	sub	a3,a3,a0
80003b64:	00d7a823          	sw	a3,16(a5)
80003b68:	00008067          	ret

80003b6c <z_remove_thread_from_ready_q>:
{
80003b6c:	fe010113          	addi	sp,sp,-32
80003b70:	00812c23          	sw	s0,24(sp)
80003b74:	01312623          	sw	s3,12(sp)
80003b78:	00112e23          	sw	ra,28(sp)
80003b7c:	00912a23          	sw	s1,20(sp)
80003b80:	01212823          	sw	s2,16(sp)
80003b84:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003b88:	00800413          	li	s0,8
80003b8c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b90:	800064b7          	lui	s1,0x80006
80003b94:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003b98:	00847413          	andi	s0,s0,8
80003b9c:	199000ef          	jal	ra,80004534 <z_spin_lock_valid>
80003ba0:	02051e63          	bnez	a0,80003bdc <z_remove_thread_from_ready_q+0x70>
80003ba4:	80006937          	lui	s2,0x80006
80003ba8:	800065b7          	lui	a1,0x80006
80003bac:	80006537          	lui	a0,0x80006
80003bb0:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80003bb4:	04e00693          	li	a3,78
80003bb8:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003bbc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003bc0:	9b0fe0ef          	jal	ra,80001d70 <printk>
80003bc4:	80006537          	lui	a0,0x80006
80003bc8:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003bcc:	9a4fe0ef          	jal	ra,80001d70 <printk>
80003bd0:	04e00593          	li	a1,78
80003bd4:	b3490513          	addi	a0,s2,-1228
80003bd8:	9d4fe0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003bdc:	0d848513          	addi	a0,s1,216
80003be0:	1ad000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003be4:	00d9c783          	lbu	a5,13(s3)
80003be8:	80006937          	lui	s2,0x80006
80003bec:	48490913          	addi	s2,s2,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80003bf0:	0407f793          	andi	a5,a5,64
80003bf4:	00078e63          	beqz	a5,80003c10 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003bf8:	00098593          	mv	a1,s3
80003bfc:	02490513          	addi	a0,s2,36
80003c00:	e90ff0ef          	jal	ra,80003290 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
80003c04:	00d9c783          	lbu	a5,13(s3)
80003c08:	fbf7f793          	andi	a5,a5,-65
80003c0c:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80003c10:	00892503          	lw	a0,8(s2)
80003c14:	41350533          	sub	a0,a0,s3
80003c18:	00153513          	seqz	a0,a0
80003c1c:	801ff0ef          	jal	ra,8000341c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c20:	0d848513          	addi	a0,s1,216
80003c24:	139000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003c28:	02051e63          	bnez	a0,80003c64 <z_remove_thread_from_ready_q+0xf8>
80003c2c:	800064b7          	lui	s1,0x80006
80003c30:	800065b7          	lui	a1,0x80006
80003c34:	80006537          	lui	a0,0x80006
80003c38:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003c3c:	06100693          	li	a3,97
80003c40:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003c44:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003c48:	928fe0ef          	jal	ra,80001d70 <printk>
80003c4c:	80006537          	lui	a0,0x80006
80003c50:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003c54:	91cfe0ef          	jal	ra,80001d70 <printk>
80003c58:	06100593          	li	a1,97
80003c5c:	b3448513          	addi	a0,s1,-1228
80003c60:	94cfe0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c64:	30042473          	csrrs	s0,mstatus,s0
}
80003c68:	01c12083          	lw	ra,28(sp)
80003c6c:	01812403          	lw	s0,24(sp)
80003c70:	01412483          	lw	s1,20(sp)
80003c74:	01012903          	lw	s2,16(sp)
80003c78:	00c12983          	lw	s3,12(sp)
80003c7c:	02010113          	addi	sp,sp,32
80003c80:	00008067          	ret

80003c84 <pend>:
{
80003c84:	fe010113          	addi	sp,sp,-32
80003c88:	00812c23          	sw	s0,24(sp)
80003c8c:	00912a23          	sw	s1,20(sp)
80003c90:	00050413          	mv	s0,a0
80003c94:	01212823          	sw	s2,16(sp)
80003c98:	00112e23          	sw	ra,28(sp)
80003c9c:	01312623          	sw	s3,12(sp)
80003ca0:	00058493          	mv	s1,a1
80003ca4:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003ca8:	ec5ff0ef          	jal	ra,80003b6c <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80003cac:	00d44783          	lbu	a5,13(s0)
80003cb0:	0027e793          	ori	a5,a5,2
80003cb4:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003cb8:	06048663          	beqz	s1,80003d24 <pend+0xa0>
	return thread == _idle_thread;
80003cbc:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003cc0:	0247a783          	lw	a5,36(a5) # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
		thread->base.pended_on = wait_q;
80003cc4:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003cc8:	02f41863          	bne	s0,a5,80003cf8 <pend+0x74>
80003ccc:	800069b7          	lui	s3,0x80006
80003cd0:	800065b7          	lui	a1,0x80006
80003cd4:	80006537          	lui	a0,0x80006
80003cd8:	e3858593          	addi	a1,a1,-456 # 80005e38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e39>
80003cdc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003ce0:	27600693          	li	a3,630
80003ce4:	dec98613          	addi	a2,s3,-532 # 80005dec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ded>
80003ce8:	888fe0ef          	jal	ra,80001d70 <printk>
80003cec:	27600593          	li	a1,630
80003cf0:	dec98513          	addi	a0,s3,-532
80003cf4:	8b8fe0ef          	jal	ra,80001dac <assert_post_action>
	return list->head == list;
80003cf8:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003cfc:	06f48c63          	beq	s1,a5,80003d74 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d00:	06078a63          	beqz	a5,80003d74 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
80003d04:	00e40703          	lb	a4,14(s0)
80003d08:	00e78683          	lb	a3,14(a5)
80003d0c:	04d75c63          	bge	a4,a3,80003d64 <pend+0xe0>
	node->prev = successor->prev;
80003d10:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003d14:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003d18:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003d1c:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003d20:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80003d24:	fff00793          	li	a5,-1
80003d28:	06f90463          	beq	s2,a5,80003d90 <pend+0x10c>
80003d2c:	00a00593          	li	a1,10
80003d30:	00990513          	addi	a0,s2,9
80003d34:	b75fc0ef          	jal	ra,800008a8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80003d38:	00150613          	addi	a2,a0,1
80003d3c:	01840513          	addi	a0,s0,24
}
80003d40:	01812403          	lw	s0,24(sp)
80003d44:	01c12083          	lw	ra,28(sp)
80003d48:	01412483          	lw	s1,20(sp)
80003d4c:	01012903          	lw	s2,16(sp)
80003d50:	00c12983          	lw	s3,12(sp)
80003d54:	800035b7          	lui	a1,0x80003
80003d58:	7f458593          	addi	a1,a1,2036 # 800037f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800037f5>
80003d5c:	02010113          	addi	sp,sp,32
80003d60:	51d0006f          	j	80004a7c <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003d64:	0044a683          	lw	a3,4(s1)
80003d68:	00d78663          	beq	a5,a3,80003d74 <pend+0xf0>
80003d6c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d70:	f8079ce3          	bnez	a5,80003d08 <pend+0x84>
	node->prev = list->tail;
80003d74:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003d78:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003d7c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003d80:	0044a783          	lw	a5,4(s1)
80003d84:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003d88:	0084a223          	sw	s0,4(s1)
80003d8c:	f99ff06f          	j	80003d24 <pend+0xa0>
}
80003d90:	01c12083          	lw	ra,28(sp)
80003d94:	01812403          	lw	s0,24(sp)
80003d98:	01412483          	lw	s1,20(sp)
80003d9c:	01012903          	lw	s2,16(sp)
80003da0:	00c12983          	lw	s3,12(sp)
80003da4:	02010113          	addi	sp,sp,32
80003da8:	00008067          	ret

80003dac <z_pend_curr_irqlock>:
{
80003dac:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003db0:	800067b7          	lui	a5,0x80006
{
80003db4:	00812423          	sw	s0,8(sp)
80003db8:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003dbc:	48c7a503          	lw	a0,1164(a5) # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
{
80003dc0:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003dc4:	ec1ff0ef          	jal	ra,80003c84 <pend>
80003dc8:	00040513          	mv	a0,s0
}
80003dcc:	00812403          	lw	s0,8(sp)
80003dd0:	00c12083          	lw	ra,12(sp)
80003dd4:	01010113          	addi	sp,sp,16
80003dd8:	c50fc06f          	j	80000228 <__swap>

80003ddc <z_pend_curr>:
{
80003ddc:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003de0:	800067b7          	lui	a5,0x80006
{
80003de4:	00812423          	sw	s0,8(sp)
80003de8:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003dec:	48c7a503          	lw	a0,1164(a5) # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
{
80003df0:	00912223          	sw	s1,4(sp)
80003df4:	00058493          	mv	s1,a1
80003df8:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003dfc:	00068613          	mv	a2,a3
{
80003e00:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003e04:	e81ff0ef          	jal	ra,80003c84 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e08:	00040513          	mv	a0,s0
80003e0c:	750000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003e10:	02051e63          	bnez	a0,80003e4c <z_pend_curr+0x70>
80003e14:	80006437          	lui	s0,0x80006
80003e18:	800065b7          	lui	a1,0x80006
80003e1c:	80006537          	lui	a0,0x80006
80003e20:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003e24:	07800693          	li	a3,120
80003e28:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003e2c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003e30:	f41fd0ef          	jal	ra,80001d70 <printk>
80003e34:	80006537          	lui	a0,0x80006
80003e38:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003e3c:	f35fd0ef          	jal	ra,80001d70 <printk>
80003e40:	07800593          	li	a1,120
80003e44:	b3440513          	addi	a0,s0,-1228
80003e48:	f65fd0ef          	jal	ra,80001dac <assert_post_action>
}
80003e4c:	00812403          	lw	s0,8(sp)
80003e50:	00c12083          	lw	ra,12(sp)
80003e54:	00048513          	mv	a0,s1
80003e58:	00412483          	lw	s1,4(sp)
80003e5c:	01010113          	addi	sp,sp,16
80003e60:	bc8fc06f          	j	80000228 <__swap>

80003e64 <z_unpend_first_thread>:
{
80003e64:	fe010113          	addi	sp,sp,-32
80003e68:	01212823          	sw	s2,16(sp)
80003e6c:	01312623          	sw	s3,12(sp)
80003e70:	00112e23          	sw	ra,28(sp)
80003e74:	00812c23          	sw	s0,24(sp)
80003e78:	00912a23          	sw	s1,20(sp)
80003e7c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e80:	00800913          	li	s2,8
80003e84:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e88:	800064b7          	lui	s1,0x80006
80003e8c:	0d848513          	addi	a0,s1,216 # 800060d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e90:	00897913          	andi	s2,s2,8
80003e94:	6a0000ef          	jal	ra,80004534 <z_spin_lock_valid>
80003e98:	02051e63          	bnez	a0,80003ed4 <z_unpend_first_thread+0x70>
80003e9c:	80006437          	lui	s0,0x80006
80003ea0:	800065b7          	lui	a1,0x80006
80003ea4:	80006537          	lui	a0,0x80006
80003ea8:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80003eac:	04e00693          	li	a3,78
80003eb0:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003eb4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003eb8:	eb9fd0ef          	jal	ra,80001d70 <printk>
80003ebc:	80006537          	lui	a0,0x80006
80003ec0:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003ec4:	eadfd0ef          	jal	ra,80001d70 <printk>
80003ec8:	04e00593          	li	a1,78
80003ecc:	b3440513          	addi	a0,s0,-1228
80003ed0:	eddfd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003ed4:	0d848513          	addi	a0,s1,216
80003ed8:	6b4000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003edc:	00098513          	mv	a0,s3
80003ee0:	d28ff0ef          	jal	ra,80003408 <z_priq_dumb_best>
80003ee4:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003ee8:	0d848513          	addi	a0,s1,216
80003eec:	670000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003ef0:	02051e63          	bnez	a0,80003f2c <z_unpend_first_thread+0xc8>
80003ef4:	800069b7          	lui	s3,0x80006
80003ef8:	800065b7          	lui	a1,0x80006
80003efc:	80006537          	lui	a0,0x80006
80003f00:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003f04:	06100693          	li	a3,97
80003f08:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003f0c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003f10:	e61fd0ef          	jal	ra,80001d70 <printk>
80003f14:	80006537          	lui	a0,0x80006
80003f18:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003f1c:	e55fd0ef          	jal	ra,80001d70 <printk>
80003f20:	06100593          	li	a1,97
80003f24:	b3498513          	addi	a0,s3,-1228
80003f28:	e85fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003f2c:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003f30:	0c040663          	beqz	s0,80003ffc <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f34:	00800913          	li	s2,8
80003f38:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f3c:	0d848513          	addi	a0,s1,216
	key = (mstatus & SOC_MSTATUS_IEN);
80003f40:	00897913          	andi	s2,s2,8
80003f44:	5f0000ef          	jal	ra,80004534 <z_spin_lock_valid>
80003f48:	02051e63          	bnez	a0,80003f84 <z_unpend_first_thread+0x120>
80003f4c:	800069b7          	lui	s3,0x80006
80003f50:	800065b7          	lui	a1,0x80006
80003f54:	80006537          	lui	a0,0x80006
80003f58:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80003f5c:	04e00693          	li	a3,78
80003f60:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003f64:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003f68:	e09fd0ef          	jal	ra,80001d70 <printk>
80003f6c:	80006537          	lui	a0,0x80006
80003f70:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80003f74:	dfdfd0ef          	jal	ra,80001d70 <printk>
80003f78:	04e00593          	li	a1,78
80003f7c:	b3498513          	addi	a0,s3,-1228
80003f80:	e2dfd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80003f84:	0d848513          	addi	a0,s1,216
80003f88:	604000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003f8c:	00840513          	addi	a0,s0,8
80003f90:	e1dfe0ef          	jal	ra,80002dac <pended_on.isra.15>
80003f94:	00040593          	mv	a1,s0
80003f98:	af8ff0ef          	jal	ra,80003290 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003f9c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fa0:	0d848513          	addi	a0,s1,216
80003fa4:	ffd7f793          	andi	a5,a5,-3
80003fa8:	00f406a3          	sb	a5,13(s0)
80003fac:	5b0000ef          	jal	ra,8000455c <z_spin_unlock_valid>
80003fb0:	02051e63          	bnez	a0,80003fec <z_unpend_first_thread+0x188>
80003fb4:	800064b7          	lui	s1,0x80006
80003fb8:	800065b7          	lui	a1,0x80006
80003fbc:	80006537          	lui	a0,0x80006
80003fc0:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80003fc4:	06100693          	li	a3,97
80003fc8:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80003fcc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80003fd0:	da1fd0ef          	jal	ra,80001d70 <printk>
80003fd4:	80006537          	lui	a0,0x80006
80003fd8:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80003fdc:	d95fd0ef          	jal	ra,80001d70 <printk>
80003fe0:	06100593          	li	a1,97
80003fe4:	b3448513          	addi	a0,s1,-1228
80003fe8:	dc5fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fec:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003ff0:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80003ff4:	01840513          	addi	a0,s0,24
80003ff8:	4b1000ef          	jal	ra,80004ca8 <z_abort_timeout>
}
80003ffc:	00040513          	mv	a0,s0
80004000:	01c12083          	lw	ra,28(sp)
80004004:	01812403          	lw	s0,24(sp)
80004008:	01412483          	lw	s1,20(sp)
8000400c:	01012903          	lw	s2,16(sp)
80004010:	00c12983          	lw	s3,12(sp)
80004014:	02010113          	addi	sp,sp,32
80004018:	00008067          	ret

8000401c <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
8000401c:	ff010113          	addi	sp,sp,-16
80004020:	00912223          	sw	s1,4(sp)
80004024:	01212023          	sw	s2,0(sp)
80004028:	00112623          	sw	ra,12(sp)
8000402c:	00812423          	sw	s0,8(sp)
80004030:	00050913          	mv	s2,a0
	int need_sched = 0;
80004034:	00000493          	li	s1,0
	return list->head == list;
80004038:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000403c:	00890463          	beq	s2,s0,80004044 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80004040:	02041063          	bnez	s0,80004060 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80004044:	00c12083          	lw	ra,12(sp)
80004048:	00812403          	lw	s0,8(sp)
8000404c:	00048513          	mv	a0,s1
80004050:	00012903          	lw	s2,0(sp)
80004054:	00412483          	lw	s1,4(sp)
80004058:	01010113          	addi	sp,sp,16
8000405c:	00008067          	ret
		z_unpend_thread(th);
80004060:	00040513          	mv	a0,s0
80004064:	aa4ff0ef          	jal	ra,80003308 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80004068:	00040513          	mv	a0,s0
8000406c:	cedfe0ef          	jal	ra,80002d58 <z_is_thread_ready>
		need_sched = 1;
80004070:	00100493          	li	s1,1
80004074:	fc0502e3          	beqz	a0,80004038 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80004078:	00040513          	mv	a0,s0
8000407c:	de8ff0ef          	jal	ra,80003664 <z_add_thread_to_ready_q>
80004080:	fb9ff06f          	j	80004038 <z_unpend_all+0x1c>

80004084 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004084:	800067b7          	lui	a5,0x80006
80004088:	48478793          	addi	a5,a5,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
8000408c:	02478713          	addi	a4,a5,36
80004090:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004094:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004098:	00000593          	li	a1,0
8000409c:	00100513          	li	a0,1
800040a0:	d6dfe06f          	j	80002e0c <k_sched_time_slice_set>

800040a4 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
800040a4:	800067b7          	lui	a5,0x80006
800040a8:	48c7a503          	lw	a0,1164(a5) # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
800040ac:	00008067          	ret

800040b0 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
800040b0:	fe010113          	addi	sp,sp,-32
800040b4:	00812c23          	sw	s0,24(sp)
800040b8:	00912a23          	sw	s1,20(sp)
800040bc:	01212823          	sw	s2,16(sp)
800040c0:	00112e23          	sw	ra,28(sp)
800040c4:	01312623          	sw	s3,12(sp)
800040c8:	00050413          	mv	s0,a0
800040cc:	00058913          	mv	s2,a1
800040d0:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
800040d4:	02061e63          	bnez	a2,80004110 <z_impl_k_sem_init+0x60>
800040d8:	800069b7          	lui	s3,0x80006
800040dc:	800065b7          	lui	a1,0x80006
800040e0:	80006537          	lui	a0,0x80006
800040e4:	e5c58593          	addi	a1,a1,-420 # 80005e5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e5d>
800040e8:	04600693          	li	a3,70
800040ec:	e4c98613          	addi	a2,s3,-436 # 80005e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e4d>
800040f0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800040f4:	c7dfd0ef          	jal	ra,80001d70 <printk>
800040f8:	80006537          	lui	a0,0x80006
800040fc:	e6850513          	addi	a0,a0,-408 # 80005e68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e69>
80004100:	c71fd0ef          	jal	ra,80001d70 <printk>
80004104:	04600593          	li	a1,70
80004108:	e4c98513          	addi	a0,s3,-436
8000410c:	ca1fd0ef          	jal	ra,80001dac <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80004110:	0324fe63          	bgeu	s1,s2,8000414c <z_impl_k_sem_init+0x9c>
80004114:	800069b7          	lui	s3,0x80006
80004118:	800065b7          	lui	a1,0x80006
8000411c:	80006537          	lui	a0,0x80006
80004120:	e8058593          	addi	a1,a1,-384 # 80005e80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e81>
80004124:	04700693          	li	a3,71
80004128:	e4c98613          	addi	a2,s3,-436 # 80005e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e4d>
8000412c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004130:	c41fd0ef          	jal	ra,80001d70 <printk>
80004134:	80006537          	lui	a0,0x80006
80004138:	e9850513          	addi	a0,a0,-360 # 80005e98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e99>
8000413c:	c35fd0ef          	jal	ra,80001d70 <printk>
80004140:	04700593          	li	a1,71
80004144:	e4c98513          	addi	a0,s3,-436
80004148:	c65fd0ef          	jal	ra,80001dac <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
8000414c:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004150:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80004154:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004158:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
8000415c:	01c12083          	lw	ra,28(sp)
80004160:	01812403          	lw	s0,24(sp)
80004164:	01412483          	lw	s1,20(sp)
80004168:	01012903          	lw	s2,16(sp)
8000416c:	00c12983          	lw	s3,12(sp)
80004170:	02010113          	addi	sp,sp,32
80004174:	00008067          	ret

80004178 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80004178:	fe010113          	addi	sp,sp,-32
8000417c:	00912a23          	sw	s1,20(sp)
80004180:	01312623          	sw	s3,12(sp)
80004184:	00112e23          	sw	ra,28(sp)
80004188:	00812c23          	sw	s0,24(sp)
8000418c:	01212823          	sw	s2,16(sp)
80004190:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004194:	00800493          	li	s1,8
80004198:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000419c:	80006437          	lui	s0,0x80006
800041a0:	0e440513          	addi	a0,s0,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
	key = (mstatus & SOC_MSTATUS_IEN);
800041a4:	0084f493          	andi	s1,s1,8
800041a8:	38c000ef          	jal	ra,80004534 <z_spin_lock_valid>
800041ac:	02051e63          	bnez	a0,800041e8 <z_impl_k_sem_give+0x70>
800041b0:	80006937          	lui	s2,0x80006
800041b4:	800065b7          	lui	a1,0x80006
800041b8:	80006537          	lui	a0,0x80006
800041bc:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800041c0:	04e00693          	li	a3,78
800041c4:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800041c8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800041cc:	ba5fd0ef          	jal	ra,80001d70 <printk>
800041d0:	80006537          	lui	a0,0x80006
800041d4:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
800041d8:	b99fd0ef          	jal	ra,80001d70 <printk>
800041dc:	04e00593          	li	a1,78
800041e0:	b3490513          	addi	a0,s2,-1228
800041e4:	bc9fd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
800041e8:	0e440513          	addi	a0,s0,228
800041ec:	3a0000ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
800041f0:	00098513          	mv	a0,s3
800041f4:	c71ff0ef          	jal	ra,80003e64 <z_unpend_first_thread>
800041f8:	00050913          	mv	s2,a0
	if (thread != NULL) {
800041fc:	04050263          	beqz	a0,80004240 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004200:	00d54783          	lbu	a5,13(a0)
80004204:	01f7f793          	andi	a5,a5,31
80004208:	00079863          	bnez	a5,80004218 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
8000420c:	01852783          	lw	a5,24(a0)
80004210:	00079463          	bnez	a5,80004218 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004214:	c50ff0ef          	jal	ra,80003664 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80004218:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
8000421c:	0e440513          	addi	a0,s0,228
}
80004220:	01812403          	lw	s0,24(sp)
80004224:	01c12083          	lw	ra,28(sp)
80004228:	01012903          	lw	s2,16(sp)
8000422c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004230:	00048593          	mv	a1,s1
}
80004234:	01412483          	lw	s1,20(sp)
80004238:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000423c:	dddfe06f          	j	80003018 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004240:	0089a703          	lw	a4,8(s3)
80004244:	00c9a783          	lw	a5,12(s3)
80004248:	40e787b3          	sub	a5,a5,a4
8000424c:	00f037b3          	snez	a5,a5
80004250:	00e787b3          	add	a5,a5,a4
80004254:	00f9a423          	sw	a5,8(s3)
80004258:	fc5ff06f          	j	8000421c <z_impl_k_sem_give+0xa4>

8000425c <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000425c:	800067b7          	lui	a5,0x80006
80004260:	4847a783          	lw	a5,1156(a5) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
{
80004264:	fe010113          	addi	sp,sp,-32
80004268:	01212823          	sw	s2,16(sp)
8000426c:	01312623          	sw	s3,12(sp)
80004270:	00112e23          	sw	ra,28(sp)
80004274:	00812c23          	sw	s0,24(sp)
80004278:	00912a23          	sw	s1,20(sp)
8000427c:	01412423          	sw	s4,8(sp)
80004280:	00050913          	mv	s2,a0
80004284:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004288:	04078063          	beqz	a5,800042c8 <z_impl_k_sem_take+0x6c>
8000428c:	02058e63          	beqz	a1,800042c8 <z_impl_k_sem_take+0x6c>
80004290:	80006437          	lui	s0,0x80006
80004294:	800065b7          	lui	a1,0x80006
80004298:	80006537          	lui	a0,0x80006
8000429c:	ec058593          	addi	a1,a1,-320 # 80005ec0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ec1>
800042a0:	08c00693          	li	a3,140
800042a4:	e4c40613          	addi	a2,s0,-436 # 80005e4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005e4d>
800042a8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800042ac:	ac5fd0ef          	jal	ra,80001d70 <printk>
800042b0:	80006537          	lui	a0,0x80006
800042b4:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
800042b8:	ab9fd0ef          	jal	ra,80001d70 <printk>
800042bc:	08c00593          	li	a1,140
800042c0:	e4c40513          	addi	a0,s0,-436
800042c4:	ae9fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800042c8:	00800413          	li	s0,8
800042cc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800042d0:	800064b7          	lui	s1,0x80006
800042d4:	0e448513          	addi	a0,s1,228 # 800060e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e5>
	key = (mstatus & SOC_MSTATUS_IEN);
800042d8:	00847413          	andi	s0,s0,8
800042dc:	258000ef          	jal	ra,80004534 <z_spin_lock_valid>
800042e0:	02051e63          	bnez	a0,8000431c <z_impl_k_sem_take+0xc0>
800042e4:	80006a37          	lui	s4,0x80006
800042e8:	800065b7          	lui	a1,0x80006
800042ec:	80006537          	lui	a0,0x80006
800042f0:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800042f4:	04e00693          	li	a3,78
800042f8:	b34a0613          	addi	a2,s4,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800042fc:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004300:	a71fd0ef          	jal	ra,80001d70 <printk>
80004304:	80006537          	lui	a0,0x80006
80004308:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
8000430c:	a65fd0ef          	jal	ra,80001d70 <printk>
80004310:	04e00593          	li	a1,78
80004314:	b34a0513          	addi	a0,s4,-1228
80004318:	a95fd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
8000431c:	0e448513          	addi	a0,s1,228
80004320:	26c000ef          	jal	ra,8000458c <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004324:	00892783          	lw	a5,8(s2)
80004328:	06078c63          	beqz	a5,800043a0 <z_impl_k_sem_take+0x144>
		sem->count--;
8000432c:	fff78793          	addi	a5,a5,-1
80004330:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004334:	0e448513          	addi	a0,s1,228
80004338:	224000ef          	jal	ra,8000455c <z_spin_unlock_valid>
8000433c:	02051e63          	bnez	a0,80004378 <z_impl_k_sem_take+0x11c>
80004340:	800064b7          	lui	s1,0x80006
80004344:	800065b7          	lui	a1,0x80006
80004348:	80006537          	lui	a0,0x80006
8000434c:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004350:	06100693          	li	a3,97
80004354:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004358:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000435c:	a15fd0ef          	jal	ra,80001d70 <printk>
80004360:	80006537          	lui	a0,0x80006
80004364:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004368:	a09fd0ef          	jal	ra,80001d70 <printk>
8000436c:	06100593          	li	a1,97
80004370:	b3448513          	addi	a0,s1,-1228
80004374:	a39fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004378:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
8000437c:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004380:	01c12083          	lw	ra,28(sp)
80004384:	01812403          	lw	s0,24(sp)
80004388:	01412483          	lw	s1,20(sp)
8000438c:	01012903          	lw	s2,16(sp)
80004390:	00c12983          	lw	s3,12(sp)
80004394:	00812a03          	lw	s4,8(sp)
80004398:	02010113          	addi	sp,sp,32
8000439c:	00008067          	ret
	if (timeout == K_NO_WAIT) {
800043a0:	04099a63          	bnez	s3,800043f4 <z_impl_k_sem_take+0x198>
800043a4:	0e448513          	addi	a0,s1,228
800043a8:	1b4000ef          	jal	ra,8000455c <z_spin_unlock_valid>
800043ac:	02051e63          	bnez	a0,800043e8 <z_impl_k_sem_take+0x18c>
800043b0:	800064b7          	lui	s1,0x80006
800043b4:	800065b7          	lui	a1,0x80006
800043b8:	80006537          	lui	a0,0x80006
800043bc:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800043c0:	06100693          	li	a3,97
800043c4:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800043c8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800043cc:	9a5fd0ef          	jal	ra,80001d70 <printk>
800043d0:	80006537          	lui	a0,0x80006
800043d4:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800043d8:	999fd0ef          	jal	ra,80001d70 <printk>
800043dc:	06100593          	li	a1,97
800043e0:	b3448513          	addi	a0,s1,-1228
800043e4:	9c9fd0ef          	jal	ra,80001dac <assert_post_action>
800043e8:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800043ec:	ff000513          	li	a0,-16
800043f0:	f91ff06f          	j	80004380 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800043f4:	00040593          	mv	a1,s0
}
800043f8:	01812403          	lw	s0,24(sp)
800043fc:	01c12083          	lw	ra,28(sp)
80004400:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004404:	00098693          	mv	a3,s3
80004408:	00090613          	mv	a2,s2
}
8000440c:	00c12983          	lw	s3,12(sp)
80004410:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004414:	0e448513          	addi	a0,s1,228
}
80004418:	01412483          	lw	s1,20(sp)
8000441c:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004420:	9bdff06f          	j	80003ddc <z_pend_curr>

80004424 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004424:	00d54783          	lbu	a5,13(a0)
80004428:	01f7f793          	andi	a5,a5,31
8000442c:	00079863          	bnez	a5,8000443c <z_is_thread_ready+0x18>
80004430:	01852503          	lw	a0,24(a0)
80004434:	00153513          	seqz	a0,a0
80004438:	00008067          	ret
8000443c:	00000513          	li	a0,0
}
80004440:	00008067          	ret

80004444 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004444:	800067b7          	lui	a5,0x80006
80004448:	4847a503          	lw	a0,1156(a5) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
}
8000444c:	00a03533          	snez	a0,a0
80004450:	00008067          	ret

80004454 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004454:	800067b7          	lui	a5,0x80006
80004458:	48c7a783          	lw	a5,1164(a5) # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
8000445c:	00c7c503          	lbu	a0,12(a5)
}
80004460:	00157513          	andi	a0,a0,1
80004464:	00008067          	ret

80004468 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004468:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000446c:	02012303          	lw	t1,32(sp)
{
80004470:	00812c23          	sw	s0,24(sp)
80004474:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004478:	00612023          	sw	t1,0(sp)
{
8000447c:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004480:	979fc0ef          	jal	ra,80000df8 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004484:	800067b7          	lui	a5,0x80006
80004488:	48c7a783          	lw	a5,1164(a5) # 8000648c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000648d>
	sys_trace_thread_create(new_thread);
}
8000448c:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004490:	0687a783          	lw	a5,104(a5)
80004494:	06f42423          	sw	a5,104(s0)
}
80004498:	01812403          	lw	s0,24(sp)
8000449c:	02010113          	addi	sp,sp,32
800044a0:	00008067          	ret

800044a4 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
800044a4:	06052783          	lw	a5,96(a0)
{
800044a8:	ff010113          	addi	sp,sp,-16
800044ac:	00812423          	sw	s0,8(sp)
800044b0:	00112623          	sw	ra,12(sp)
800044b4:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
800044b8:	00078463          	beqz	a5,800044c0 <z_thread_single_abort+0x1c>
		thread->fn_abort();
800044bc:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
800044c0:	00040513          	mv	a0,s0
800044c4:	f61ff0ef          	jal	ra,80004424 <z_is_thread_ready>
800044c8:	02050463          	beqz	a0,800044f0 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
800044cc:	00040513          	mv	a0,s0
800044d0:	e9cff0ef          	jal	ra,80003b6c <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
800044d4:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
800044d8:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
800044dc:	0087e793          	ori	a5,a5,8
800044e0:	00f406a3          	sb	a5,13(s0)
}
800044e4:	00812403          	lw	s0,8(sp)
800044e8:	01010113          	addi	sp,sp,16
800044ec:	00008067          	ret
		if (z_is_thread_pending(thread)) {
800044f0:	00d44783          	lbu	a5,13(s0)
800044f4:	0027f793          	andi	a5,a5,2
800044f8:	00078663          	beqz	a5,80004504 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
800044fc:	00040513          	mv	a0,s0
80004500:	a1dfe0ef          	jal	ra,80002f1c <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004504:	01842783          	lw	a5,24(s0)
80004508:	fc0786e3          	beqz	a5,800044d4 <z_thread_single_abort+0x30>
8000450c:	01840513          	addi	a0,s0,24
80004510:	798000ef          	jal	ra,80004ca8 <z_abort_timeout>
80004514:	fc1ff06f          	j	800044d4 <z_thread_single_abort+0x30>

80004518 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004518:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
8000451c:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004520:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004524:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004528:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
8000452c:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004530:	00008067          	ret

80004534 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004534:	00052503          	lw	a0,0(a0)
80004538:	00050e63          	beqz	a0,80004554 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
8000453c:	800067b7          	lui	a5,0x80006
80004540:	4987c783          	lbu	a5,1176(a5) # 80006498 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006499>
80004544:	00357513          	andi	a0,a0,3
80004548:	40f50533          	sub	a0,a0,a5
8000454c:	00a03533          	snez	a0,a0
80004550:	00008067          	ret
			return false;
		}
	}
	return true;
80004554:	00100513          	li	a0,1
}
80004558:	00008067          	ret

8000455c <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
8000455c:	800067b7          	lui	a5,0x80006
80004560:	48478793          	addi	a5,a5,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80004564:	0147c703          	lbu	a4,20(a5)
80004568:	0087a783          	lw	a5,8(a5)
8000456c:	00e7e7b3          	or	a5,a5,a4
80004570:	00052703          	lw	a4,0(a0)
80004574:	00f71863          	bne	a4,a5,80004584 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004578:	00052023          	sw	zero,0(a0)
	return true;
8000457c:	00100513          	li	a0,1
80004580:	00008067          	ret
		return false;
80004584:	00000513          	li	a0,0
}
80004588:	00008067          	ret

8000458c <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
8000458c:	800067b7          	lui	a5,0x80006
80004590:	48478793          	addi	a5,a5,1156 # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
80004594:	0147c703          	lbu	a4,20(a5)
80004598:	0087a783          	lw	a5,8(a5)
8000459c:	00e7e7b3          	or	a5,a5,a4
800045a0:	00f52023          	sw	a5,0(a0)
}
800045a4:	00008067          	ret

800045a8 <z_impl_k_thread_start>:
{
800045a8:	fe010113          	addi	sp,sp,-32
800045ac:	00812c23          	sw	s0,24(sp)
800045b0:	01212823          	sw	s2,16(sp)
800045b4:	00112e23          	sw	ra,28(sp)
800045b8:	00912a23          	sw	s1,20(sp)
800045bc:	01312623          	sw	s3,12(sp)
800045c0:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045c4:	00800413          	li	s0,8
800045c8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045cc:	800064b7          	lui	s1,0x80006
800045d0:	0e848513          	addi	a0,s1,232 # 800060e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060e9>
	key = (mstatus & SOC_MSTATUS_IEN);
800045d4:	00847413          	andi	s0,s0,8
800045d8:	f5dff0ef          	jal	ra,80004534 <z_spin_lock_valid>
800045dc:	02051e63          	bnez	a0,80004618 <z_impl_k_thread_start+0x70>
800045e0:	800069b7          	lui	s3,0x80006
800045e4:	800065b7          	lui	a1,0x80006
800045e8:	80006537          	lui	a0,0x80006
800045ec:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800045f0:	04e00693          	li	a3,78
800045f4:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800045f8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800045fc:	f74fd0ef          	jal	ra,80001d70 <printk>
80004600:	80006537          	lui	a0,0x80006
80004604:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004608:	f68fd0ef          	jal	ra,80001d70 <printk>
8000460c:	04e00593          	li	a1,78
80004610:	b3498513          	addi	a0,s3,-1228
80004614:	f98fd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004618:	0e848513          	addi	a0,s1,232
8000461c:	f71ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004620:	00d94783          	lbu	a5,13(s2)
80004624:	0047f713          	andi	a4,a5,4
80004628:	06071463          	bnez	a4,80004690 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000462c:	0e848513          	addi	a0,s1,232
80004630:	f2dff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80004634:	02051e63          	bnez	a0,80004670 <z_impl_k_thread_start+0xc8>
80004638:	800064b7          	lui	s1,0x80006
8000463c:	800065b7          	lui	a1,0x80006
80004640:	80006537          	lui	a0,0x80006
80004644:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004648:	06100693          	li	a3,97
8000464c:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004650:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004654:	f1cfd0ef          	jal	ra,80001d70 <printk>
80004658:	80006537          	lui	a0,0x80006
8000465c:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004660:	f10fd0ef          	jal	ra,80001d70 <printk>
80004664:	06100593          	li	a1,97
80004668:	b3448513          	addi	a0,s1,-1228
8000466c:	f40fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004670:	30042473          	csrrs	s0,mstatus,s0
}
80004674:	01c12083          	lw	ra,28(sp)
80004678:	01812403          	lw	s0,24(sp)
8000467c:	01412483          	lw	s1,20(sp)
80004680:	01012903          	lw	s2,16(sp)
80004684:	00c12983          	lw	s3,12(sp)
80004688:	02010113          	addi	sp,sp,32
8000468c:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004690:	ffb7f793          	andi	a5,a5,-5
80004694:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004698:	00090513          	mv	a0,s2
8000469c:	d89ff0ef          	jal	ra,80004424 <z_is_thread_ready>
800046a0:	00050663          	beqz	a0,800046ac <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
800046a4:	00090513          	mv	a0,s2
800046a8:	fbdfe0ef          	jal	ra,80003664 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
800046ac:	00040593          	mv	a1,s0
}
800046b0:	01812403          	lw	s0,24(sp)
800046b4:	01c12083          	lw	ra,28(sp)
800046b8:	01012903          	lw	s2,16(sp)
800046bc:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
800046c0:	0e848513          	addi	a0,s1,232
}
800046c4:	01412483          	lw	s1,20(sp)
800046c8:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
800046cc:	94dfe06f          	j	80003018 <z_reschedule>

800046d0 <schedule_new_thread>:
	if (delay == 0) {
800046d0:	00059463          	bnez	a1,800046d8 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
800046d4:	ed5ff06f          	j	800045a8 <z_impl_k_thread_start>
{
800046d8:	ff010113          	addi	sp,sp,-16
800046dc:	00812423          	sw	s0,8(sp)
800046e0:	00050413          	mv	s0,a0
800046e4:	00058513          	mv	a0,a1
800046e8:	00950513          	addi	a0,a0,9
800046ec:	00a00593          	li	a1,10
800046f0:	00112623          	sw	ra,12(sp)
800046f4:	9b4fc0ef          	jal	ra,800008a8 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800046f8:	00150613          	addi	a2,a0,1
800046fc:	01840513          	addi	a0,s0,24
}
80004700:	00812403          	lw	s0,8(sp)
80004704:	00c12083          	lw	ra,12(sp)
80004708:	800035b7          	lui	a1,0x80003
8000470c:	7f458593          	addi	a1,a1,2036 # 800037f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800037f5>
80004710:	01010113          	addi	sp,sp,16
80004714:	3680006f          	j	80004a7c <z_add_timeout>

80004718 <z_impl_k_thread_create>:
{
80004718:	fc010113          	addi	sp,sp,-64
8000471c:	03512223          	sw	s5,36(sp)
80004720:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004724:	800066b7          	lui	a3,0x80006
80004728:	4846a683          	lw	a3,1156(a3) # 80006484 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006485>
{
8000472c:	02812c23          	sw	s0,56(sp)
80004730:	02912a23          	sw	s1,52(sp)
80004734:	03312623          	sw	s3,44(sp)
80004738:	03412423          	sw	s4,40(sp)
8000473c:	02112e23          	sw	ra,60(sp)
80004740:	03212823          	sw	s2,48(sp)
80004744:	00050413          	mv	s0,a0
80004748:	00058993          	mv	s3,a1
8000474c:	00060a13          	mv	s4,a2
80004750:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80004754:	04068e63          	beqz	a3,800047b0 <z_impl_k_thread_create+0x98>
80004758:	80006937          	lui	s2,0x80006
8000475c:	800065b7          	lui	a1,0x80006
80004760:	80006537          	lui	a0,0x80006
80004764:	1b200693          	li	a3,434
80004768:	ef490613          	addi	a2,s2,-268 # 80005ef4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ef5>
8000476c:	d8458593          	addi	a1,a1,-636 # 80005d84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d85>
80004770:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004774:	01112e23          	sw	a7,28(sp)
80004778:	01012c23          	sw	a6,24(sp)
8000477c:	00f12a23          	sw	a5,20(sp)
80004780:	00e12823          	sw	a4,16(sp)
80004784:	decfd0ef          	jal	ra,80001d70 <printk>
80004788:	80006537          	lui	a0,0x80006
8000478c:	f0850513          	addi	a0,a0,-248 # 80005f08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f09>
80004790:	de0fd0ef          	jal	ra,80001d70 <printk>
80004794:	1b200593          	li	a1,434
80004798:	ef490513          	addi	a0,s2,-268
8000479c:	e10fd0ef          	jal	ra,80001dac <assert_post_action>
800047a0:	01c12883          	lw	a7,28(sp)
800047a4:	01812803          	lw	a6,24(sp)
800047a8:	01412783          	lw	a5,20(sp)
800047ac:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800047b0:	04012683          	lw	a3,64(sp)
800047b4:	00012223          	sw	zero,4(sp)
800047b8:	000a0613          	mv	a2,s4
800047bc:	00d12023          	sw	a3,0(sp)
800047c0:	00098593          	mv	a1,s3
800047c4:	000a8693          	mv	a3,s5
800047c8:	00040513          	mv	a0,s0
800047cc:	c9dff0ef          	jal	ra,80004468 <z_setup_new_thread>
	if (delay != K_FOREVER) {
800047d0:	fff00793          	li	a5,-1
800047d4:	00f48863          	beq	s1,a5,800047e4 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
800047d8:	00048593          	mv	a1,s1
800047dc:	00040513          	mv	a0,s0
800047e0:	ef1ff0ef          	jal	ra,800046d0 <schedule_new_thread>
}
800047e4:	00040513          	mv	a0,s0
800047e8:	03c12083          	lw	ra,60(sp)
800047ec:	03812403          	lw	s0,56(sp)
800047f0:	03412483          	lw	s1,52(sp)
800047f4:	03012903          	lw	s2,48(sp)
800047f8:	02c12983          	lw	s3,44(sp)
800047fc:	02812a03          	lw	s4,40(sp)
80004800:	02412a83          	lw	s5,36(sp)
80004804:	04010113          	addi	sp,sp,64
80004808:	00008067          	ret

8000480c <z_init_static_threads>:
{
8000480c:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004810:	800067b7          	lui	a5,0x80006
{
80004814:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004818:	80006937          	lui	s2,0x80006
{
8000481c:	00812c23          	sw	s0,24(sp)
80004820:	00912a23          	sw	s1,20(sp)
80004824:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004828:	05878413          	addi	s0,a5,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
8000482c:	05878493          	addi	s1,a5,88
80004830:	05890913          	addi	s2,s2,88 # 80006058 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006059>
80004834:	03246663          	bltu	s0,s2,80004860 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80004838:	00048413          	mv	s0,s1
	k_sched_lock();
8000483c:	8ddfe0ef          	jal	ra,80003118 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80004840:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
80004844:	07246063          	bltu	s0,s2,800048a4 <z_init_static_threads+0x98>
}
80004848:	01812403          	lw	s0,24(sp)
8000484c:	01c12083          	lw	ra,28(sp)
80004850:	01412483          	lw	s1,20(sp)
80004854:	01012903          	lw	s2,16(sp)
80004858:	02010113          	addi	sp,sp,32
	k_sched_unlock();
8000485c:	c89fe06f          	j	800034e4 <k_sched_unlock>
		z_setup_new_thread(
80004860:	02c42783          	lw	a5,44(s0)
80004864:	00f12223          	sw	a5,4(sp)
80004868:	02042783          	lw	a5,32(s0)
8000486c:	00f12023          	sw	a5,0(sp)
80004870:	01442783          	lw	a5,20(s0)
80004874:	01c42883          	lw	a7,28(s0)
80004878:	01842803          	lw	a6,24(s0)
8000487c:	01042703          	lw	a4,16(s0)
80004880:	00c42683          	lw	a3,12(s0)
80004884:	00842603          	lw	a2,8(s0)
80004888:	00442583          	lw	a1,4(s0)
8000488c:	00042503          	lw	a0,0(s0)
80004890:	bd9ff0ef          	jal	ra,80004468 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004894:	00042783          	lw	a5,0(s0)
80004898:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
8000489c:	03040413          	addi	s0,s0,48
800048a0:	f95ff06f          	j	80004834 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
800048a4:	02442583          	lw	a1,36(s0)
800048a8:	00958663          	beq	a1,s1,800048b4 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
800048ac:	00042503          	lw	a0,0(s0)
800048b0:	e21ff0ef          	jal	ra,800046d0 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800048b4:	03040413          	addi	s0,s0,48
800048b8:	f8dff06f          	j	80004844 <z_init_static_threads+0x38>

800048bc <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800048bc:	fe010113          	addi	sp,sp,-32
800048c0:	00812c23          	sw	s0,24(sp)
800048c4:	00912a23          	sw	s1,20(sp)
800048c8:	00112e23          	sw	ra,28(sp)
800048cc:	01212823          	sw	s2,16(sp)
800048d0:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800048d4:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800048d8:	00800413          	li	s0,8
800048dc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800048e0:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800048e4:	00847413          	andi	s0,s0,8
800048e8:	c4dff0ef          	jal	ra,80004534 <z_spin_lock_valid>
800048ec:	02051e63          	bnez	a0,80004928 <z_impl_k_thread_abort+0x6c>
800048f0:	80006937          	lui	s2,0x80006
800048f4:	800065b7          	lui	a1,0x80006
800048f8:	80006537          	lui	a0,0x80006
800048fc:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004900:	04e00693          	li	a3,78
80004904:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004908:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000490c:	c64fd0ef          	jal	ra,80001d70 <printk>
80004910:	80006537          	lui	a0,0x80006
80004914:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004918:	c58fd0ef          	jal	ra,80001d70 <printk>
8000491c:	04e00593          	li	a1,78
80004920:	b3490513          	addi	a0,s2,-1228
80004924:	c88fd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004928:	00c10513          	addi	a0,sp,12
8000492c:	c61ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80004930:	00c4c783          	lbu	a5,12(s1)
80004934:	0017f793          	andi	a5,a5,1
80004938:	02078e63          	beqz	a5,80004974 <z_impl_k_thread_abort+0xb8>
8000493c:	80006937          	lui	s2,0x80006
80004940:	800065b7          	lui	a1,0x80006
80004944:	80006537          	lui	a0,0x80006
80004948:	f4858593          	addi	a1,a1,-184 # 80005f48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f49>
8000494c:	02900693          	li	a3,41
80004950:	f3090613          	addi	a2,s2,-208 # 80005f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f31>
80004954:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004958:	c18fd0ef          	jal	ra,80001d70 <printk>
8000495c:	80006537          	lui	a0,0x80006
80004960:	f7c50513          	addi	a0,a0,-132 # 80005f7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f7d>
80004964:	c0cfd0ef          	jal	ra,80001d70 <printk>
80004968:	02900593          	li	a1,41
8000496c:	f3090513          	addi	a0,s2,-208
80004970:	c3cfd0ef          	jal	ra,80001dac <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
80004974:	00048513          	mv	a0,s1
80004978:	b2dff0ef          	jal	ra,800044a4 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
8000497c:	00040593          	mv	a1,s0
80004980:	00c10513          	addi	a0,sp,12
80004984:	e94fe0ef          	jal	ra,80003018 <z_reschedule>
}
80004988:	01c12083          	lw	ra,28(sp)
8000498c:	01812403          	lw	s0,24(sp)
80004990:	01412483          	lw	s1,20(sp)
80004994:	01012903          	lw	s2,16(sp)
80004998:	02010113          	addi	sp,sp,32
8000499c:	00008067          	ret

800049a0 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
800049a0:	800067b7          	lui	a5,0x80006
800049a4:	0ec7a783          	lw	a5,236(a5) # 800060ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060ed>
800049a8:	00079463          	bnez	a5,800049b0 <elapsed+0x10>
800049ac:	881fd06f          	j	8000222c <z_clock_elapsed>
}
800049b0:	00000513          	li	a0,0
800049b4:	00008067          	ret

800049b8 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800049b8:	00052783          	lw	a5,0(a0)
800049bc:	02050263          	beqz	a0,800049e0 <remove_timeout+0x28>
800049c0:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
800049c4:	01472703          	lw	a4,20(a4) # 80006014 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006015>
800049c8:	00e50c63          	beq	a0,a4,800049e0 <remove_timeout+0x28>
	if (next(t) != NULL) {
800049cc:	00078a63          	beqz	a5,800049e0 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
800049d0:	0087a703          	lw	a4,8(a5)
800049d4:	00852683          	lw	a3,8(a0)
800049d8:	00d70733          	add	a4,a4,a3
800049dc:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
800049e0:	00452703          	lw	a4,4(a0)
800049e4:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
800049e8:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
800049ec:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
800049f0:	00052223          	sw	zero,4(a0)
}
800049f4:	00008067          	ret

800049f8 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
800049f8:	800067b7          	lui	a5,0x80006
800049fc:	0f87c783          	lbu	a5,248(a5) # 800060f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f9>
{
80004a00:	ff010113          	addi	sp,sp,-16
80004a04:	00112623          	sw	ra,12(sp)
80004a08:	00812423          	sw	s0,8(sp)
80004a0c:	00912223          	sw	s1,4(sp)
80004a10:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004a14:	00079663          	bnez	a5,80004a20 <next_timeout+0x28>
80004a18:	80000537          	lui	a0,0x80000
80004a1c:	fff54513          	not	a0,a0
	return list->head == list;
80004a20:	800067b7          	lui	a5,0x80006
80004a24:	01078793          	addi	a5,a5,16 # 80006010 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006011>
80004a28:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004a2c:	02f40463          	beq	s0,a5,80004a54 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80004a30:	02040263          	beqz	s0,80004a54 <next_timeout+0x5c>
80004a34:	00842483          	lw	s1,8(s0)
80004a38:	f69ff0ef          	jal	ra,800049a0 <elapsed>
80004a3c:	40a484b3          	sub	s1,s1,a0
80004a40:	00000513          	li	a0,0
80004a44:	0004c863          	bltz	s1,80004a54 <next_timeout+0x5c>
80004a48:	00842403          	lw	s0,8(s0)
80004a4c:	f55ff0ef          	jal	ra,800049a0 <elapsed>
80004a50:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80004a54:	800067b7          	lui	a5,0x80006
80004a58:	4947a783          	lw	a5,1172(a5) # 80006494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006495>
80004a5c:	00078663          	beqz	a5,80004a68 <next_timeout+0x70>
80004a60:	00a7d463          	bge	a5,a0,80004a68 <next_timeout+0x70>
80004a64:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80004a68:	00c12083          	lw	ra,12(sp)
80004a6c:	00812403          	lw	s0,8(sp)
80004a70:	00412483          	lw	s1,4(sp)
80004a74:	01010113          	addi	sp,sp,16
80004a78:	00008067          	ret

80004a7c <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004a7c:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004a80:	fd010113          	addi	sp,sp,-48
80004a84:	02812423          	sw	s0,40(sp)
80004a88:	02912223          	sw	s1,36(sp)
80004a8c:	01312e23          	sw	s3,28(sp)
80004a90:	02112623          	sw	ra,44(sp)
80004a94:	03212023          	sw	s2,32(sp)
80004a98:	01412c23          	sw	s4,24(sp)
80004a9c:	01512a23          	sw	s5,20(sp)
80004aa0:	01612823          	sw	s6,16(sp)
80004aa4:	01712623          	sw	s7,12(sp)
80004aa8:	01812423          	sw	s8,8(sp)
80004aac:	00050413          	mv	s0,a0
80004ab0:	00058993          	mv	s3,a1
80004ab4:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004ab8:	02078e63          	beqz	a5,80004af4 <z_add_timeout+0x78>
80004abc:	80006937          	lui	s2,0x80006
80004ac0:	800065b7          	lui	a1,0x80006
80004ac4:	80006537          	lui	a0,0x80006
80004ac8:	fac58593          	addi	a1,a1,-84 # 80005fac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fad>
80004acc:	04d00693          	li	a3,77
80004ad0:	f9890613          	addi	a2,s2,-104 # 80005f98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f99>
80004ad4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004ad8:	a98fd0ef          	jal	ra,80001d70 <printk>
80004adc:	80006537          	lui	a0,0x80006
80004ae0:	aec50513          	addi	a0,a0,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80004ae4:	a8cfd0ef          	jal	ra,80001d70 <printk>
80004ae8:	04d00593          	li	a1,77
80004aec:	f9890513          	addi	a0,s2,-104
80004af0:	abcfd0ef          	jal	ra,80001dac <assert_post_action>
	to->fn = fn;
80004af4:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004af8:	00904463          	bgtz	s1,80004b00 <z_add_timeout+0x84>
80004afc:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b00:	00800993          	li	s3,8
80004b04:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b08:	80006a37          	lui	s4,0x80006
80004b0c:	0f0a0513          	addi	a0,s4,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004b10:	0089f993          	andi	s3,s3,8
80004b14:	a21ff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80004b18:	02051e63          	bnez	a0,80004b54 <z_add_timeout+0xd8>
80004b1c:	80006937          	lui	s2,0x80006
80004b20:	800065b7          	lui	a1,0x80006
80004b24:	80006537          	lui	a0,0x80006
80004b28:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004b2c:	04e00693          	li	a3,78
80004b30:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004b34:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004b38:	a38fd0ef          	jal	ra,80001d70 <printk>
80004b3c:	80006537          	lui	a0,0x80006
80004b40:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004b44:	a2cfd0ef          	jal	ra,80001d70 <printk>
80004b48:	04e00593          	li	a1,78
80004b4c:	b3490513          	addi	a0,s2,-1228
80004b50:	a5cfd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004b54:	0f0a0513          	addi	a0,s4,240
80004b58:	a35ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80004b5c:	e45ff0ef          	jal	ra,800049a0 <elapsed>
80004b60:	00950533          	add	a0,a0,s1
	return list->head == list;
80004b64:	800064b7          	lui	s1,0x80006
80004b68:	0104a903          	lw	s2,16(s1) # 80006010 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006011>
80004b6c:	00a42423          	sw	a0,8(s0)
80004b70:	01048493          	addi	s1,s1,16
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004b74:	00990c63          	beq	s2,s1,80004b8c <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80004b78:	80006ab7          	lui	s5,0x80006
80004b7c:	80006b37          	lui	s6,0x80006
80004b80:	80006bb7          	lui	s7,0x80006
80004b84:	80006c37          	lui	s8,0x80006
		for (t = first(); t != NULL; t = next(t)) {
80004b88:	02091063          	bnez	s2,80004ba8 <z_add_timeout+0x12c>
	node->prev = list->tail;
80004b8c:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004b90:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004b94:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004b98:	0044a783          	lw	a5,4(s1)
80004b9c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004ba0:	0084a223          	sw	s0,4(s1)
80004ba4:	05c0006f          	j	80004c00 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004ba8:	00892783          	lw	a5,8(s2)
80004bac:	0207d663          	bgez	a5,80004bd8 <z_add_timeout+0x15c>
80004bb0:	fccb0593          	addi	a1,s6,-52 # 80005fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fcd>
80004bb4:	05600693          	li	a3,86
80004bb8:	f98a8613          	addi	a2,s5,-104 # 80005f98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005f99>
80004bbc:	a68b8513          	addi	a0,s7,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004bc0:	9b0fd0ef          	jal	ra,80001d70 <printk>
80004bc4:	aecc0513          	addi	a0,s8,-1300 # 80005aec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005aed>
80004bc8:	9a8fd0ef          	jal	ra,80001d70 <printk>
80004bcc:	05600593          	li	a1,86
80004bd0:	f98a8513          	addi	a0,s5,-104
80004bd4:	9d8fd0ef          	jal	ra,80001dac <assert_post_action>

			if (t->dticks > to->dticks) {
80004bd8:	00892703          	lw	a4,8(s2)
80004bdc:	00842783          	lw	a5,8(s0)
80004be0:	0ae7d863          	bge	a5,a4,80004c90 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004be4:	40f707b3          	sub	a5,a4,a5
80004be8:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80004bec:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004bf0:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004bf4:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004bf8:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80004bfc:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004c00:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004c04:	00978a63          	beq	a5,s1,80004c18 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004c08:	00f41863          	bne	s0,a5,80004c18 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80004c0c:	dedff0ef          	jal	ra,800049f8 <next_timeout>
80004c10:	00000593          	li	a1,0
80004c14:	c70fd0ef          	jal	ra,80002084 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004c18:	0f0a0513          	addi	a0,s4,240
80004c1c:	941ff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80004c20:	02051e63          	bnez	a0,80004c5c <z_add_timeout+0x1e0>
80004c24:	80006437          	lui	s0,0x80006
80004c28:	800065b7          	lui	a1,0x80006
80004c2c:	80006537          	lui	a0,0x80006
80004c30:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004c34:	06100693          	li	a3,97
80004c38:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004c3c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004c40:	930fd0ef          	jal	ra,80001d70 <printk>
80004c44:	80006537          	lui	a0,0x80006
80004c48:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004c4c:	924fd0ef          	jal	ra,80001d70 <printk>
80004c50:	06100593          	li	a1,97
80004c54:	b3440513          	addi	a0,s0,-1228
80004c58:	954fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c5c:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80004c60:	02c12083          	lw	ra,44(sp)
80004c64:	02812403          	lw	s0,40(sp)
80004c68:	02412483          	lw	s1,36(sp)
80004c6c:	02012903          	lw	s2,32(sp)
80004c70:	01c12983          	lw	s3,28(sp)
80004c74:	01812a03          	lw	s4,24(sp)
80004c78:	01412a83          	lw	s5,20(sp)
80004c7c:	01012b03          	lw	s6,16(sp)
80004c80:	00c12b83          	lw	s7,12(sp)
80004c84:	00812c03          	lw	s8,8(sp)
80004c88:	03010113          	addi	sp,sp,48
80004c8c:	00008067          	ret
			to->dticks -= t->dticks;
80004c90:	40e787b3          	sub	a5,a5,a4
80004c94:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004c98:	0044a783          	lw	a5,4(s1)
80004c9c:	ef2788e3          	beq	a5,s2,80004b8c <z_add_timeout+0x110>
80004ca0:	00092903          	lw	s2,0(s2)
80004ca4:	ee5ff06f          	j	80004b88 <z_add_timeout+0x10c>

80004ca8 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004ca8:	fe010113          	addi	sp,sp,-32
80004cac:	00812c23          	sw	s0,24(sp)
80004cb0:	01312623          	sw	s3,12(sp)
80004cb4:	00112e23          	sw	ra,28(sp)
80004cb8:	00912a23          	sw	s1,20(sp)
80004cbc:	01212823          	sw	s2,16(sp)
80004cc0:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004cc4:	00800413          	li	s0,8
80004cc8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ccc:	800064b7          	lui	s1,0x80006
80004cd0:	0f048513          	addi	a0,s1,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004cd4:	00847413          	andi	s0,s0,8
80004cd8:	85dff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80004cdc:	02051e63          	bnez	a0,80004d18 <z_abort_timeout+0x70>
80004ce0:	80006937          	lui	s2,0x80006
80004ce4:	800065b7          	lui	a1,0x80006
80004ce8:	80006537          	lui	a0,0x80006
80004cec:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004cf0:	04e00693          	li	a3,78
80004cf4:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004cf8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004cfc:	874fd0ef          	jal	ra,80001d70 <printk>
80004d00:	80006537          	lui	a0,0x80006
80004d04:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004d08:	868fd0ef          	jal	ra,80001d70 <printk>
80004d0c:	04e00593          	li	a1,78
80004d10:	b3490513          	addi	a0,s2,-1228
80004d14:	898fd0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004d18:	0f048513          	addi	a0,s1,240
80004d1c:	871ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80004d20:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80004d24:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80004d28:	00078863          	beqz	a5,80004d38 <z_abort_timeout+0x90>
			remove_timeout(to);
80004d2c:	00098513          	mv	a0,s3
80004d30:	c89ff0ef          	jal	ra,800049b8 <remove_timeout>
			ret = 0;
80004d34:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d38:	0f048513          	addi	a0,s1,240
80004d3c:	821ff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80004d40:	02051e63          	bnez	a0,80004d7c <z_abort_timeout+0xd4>
80004d44:	800064b7          	lui	s1,0x80006
80004d48:	800065b7          	lui	a1,0x80006
80004d4c:	80006537          	lui	a0,0x80006
80004d50:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004d54:	06100693          	li	a3,97
80004d58:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004d5c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004d60:	810fd0ef          	jal	ra,80001d70 <printk>
80004d64:	80006537          	lui	a0,0x80006
80004d68:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004d6c:	804fd0ef          	jal	ra,80001d70 <printk>
80004d70:	06100593          	li	a1,97
80004d74:	b3448513          	addi	a0,s1,-1228
80004d78:	834fd0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d7c:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004d80:	01c12083          	lw	ra,28(sp)
80004d84:	01812403          	lw	s0,24(sp)
80004d88:	00090513          	mv	a0,s2
80004d8c:	01412483          	lw	s1,20(sp)
80004d90:	01012903          	lw	s2,16(sp)
80004d94:	00c12983          	lw	s3,12(sp)
80004d98:	02010113          	addi	sp,sp,32
80004d9c:	00008067          	ret

80004da0 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004da0:	ff010113          	addi	sp,sp,-16
80004da4:	00812423          	sw	s0,8(sp)
80004da8:	00112623          	sw	ra,12(sp)
80004dac:	00912223          	sw	s1,4(sp)
80004db0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004db4:	00800413          	li	s0,8
80004db8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004dbc:	800064b7          	lui	s1,0x80006
80004dc0:	0f048513          	addi	a0,s1,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004dc4:	00847413          	andi	s0,s0,8
80004dc8:	f6cff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80004dcc:	02051e63          	bnez	a0,80004e08 <z_get_next_timeout_expiry+0x68>
80004dd0:	80006937          	lui	s2,0x80006
80004dd4:	800065b7          	lui	a1,0x80006
80004dd8:	80006537          	lui	a0,0x80006
80004ddc:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004de0:	04e00693          	li	a3,78
80004de4:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004de8:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004dec:	f85fc0ef          	jal	ra,80001d70 <printk>
80004df0:	80006537          	lui	a0,0x80006
80004df4:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004df8:	f79fc0ef          	jal	ra,80001d70 <printk>
80004dfc:	04e00593          	li	a1,78
80004e00:	b3490513          	addi	a0,s2,-1228
80004e04:	fa9fc0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004e08:	0f048513          	addi	a0,s1,240
80004e0c:	f80ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004e10:	be9ff0ef          	jal	ra,800049f8 <next_timeout>
80004e14:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004e18:	0f048513          	addi	a0,s1,240
80004e1c:	f40ff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80004e20:	02051e63          	bnez	a0,80004e5c <z_get_next_timeout_expiry+0xbc>
80004e24:	800064b7          	lui	s1,0x80006
80004e28:	800065b7          	lui	a1,0x80006
80004e2c:	80006537          	lui	a0,0x80006
80004e30:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004e34:	06100693          	li	a3,97
80004e38:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004e3c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004e40:	f31fc0ef          	jal	ra,80001d70 <printk>
80004e44:	80006537          	lui	a0,0x80006
80004e48:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004e4c:	f25fc0ef          	jal	ra,80001d70 <printk>
80004e50:	06100593          	li	a1,97
80004e54:	b3448513          	addi	a0,s1,-1228
80004e58:	f55fc0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004e5c:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004e60:	00c12083          	lw	ra,12(sp)
80004e64:	00812403          	lw	s0,8(sp)
80004e68:	00090513          	mv	a0,s2
80004e6c:	00412483          	lw	s1,4(sp)
80004e70:	00012903          	lw	s2,0(sp)
80004e74:	01010113          	addi	sp,sp,16
80004e78:	00008067          	ret

80004e7c <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004e7c:	fe010113          	addi	sp,sp,-32
80004e80:	00812c23          	sw	s0,24(sp)
80004e84:	01212823          	sw	s2,16(sp)
80004e88:	01412423          	sw	s4,8(sp)
80004e8c:	00112e23          	sw	ra,28(sp)
80004e90:	00912a23          	sw	s1,20(sp)
80004e94:	01312623          	sw	s3,12(sp)
80004e98:	00050913          	mv	s2,a0
80004e9c:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004ea0:	00800413          	li	s0,8
80004ea4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ea8:	800064b7          	lui	s1,0x80006
80004eac:	0f048513          	addi	a0,s1,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004eb0:	00847413          	andi	s0,s0,8
80004eb4:	e80ff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80004eb8:	02051e63          	bnez	a0,80004ef4 <z_set_timeout_expiry+0x78>
80004ebc:	800069b7          	lui	s3,0x80006
80004ec0:	800065b7          	lui	a1,0x80006
80004ec4:	80006537          	lui	a0,0x80006
80004ec8:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004ecc:	04e00693          	li	a3,78
80004ed0:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004ed4:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004ed8:	e99fc0ef          	jal	ra,80001d70 <printk>
80004edc:	80006537          	lui	a0,0x80006
80004ee0:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80004ee4:	e8dfc0ef          	jal	ra,80001d70 <printk>
80004ee8:	04e00593          	li	a1,78
80004eec:	b3498513          	addi	a0,s3,-1228
80004ef0:	ebdfc0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80004ef4:	0f048513          	addi	a0,s1,240
80004ef8:	e94ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004efc:	afdff0ef          	jal	ra,800049f8 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004f00:	00a95c63          	bge	s2,a0,80004f18 <z_set_timeout_expiry+0x9c>
80004f04:	00100793          	li	a5,1
80004f08:	00a7d863          	bge	a5,a0,80004f18 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80004f0c:	000a0593          	mv	a1,s4
80004f10:	00090513          	mv	a0,s2
80004f14:	970fd0ef          	jal	ra,80002084 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f18:	0f048513          	addi	a0,s1,240
80004f1c:	e40ff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80004f20:	02051e63          	bnez	a0,80004f5c <z_set_timeout_expiry+0xe0>
80004f24:	800064b7          	lui	s1,0x80006
80004f28:	800065b7          	lui	a1,0x80006
80004f2c:	80006537          	lui	a0,0x80006
80004f30:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80004f34:	06100693          	li	a3,97
80004f38:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004f3c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004f40:	e31fc0ef          	jal	ra,80001d70 <printk>
80004f44:	80006537          	lui	a0,0x80006
80004f48:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80004f4c:	e25fc0ef          	jal	ra,80001d70 <printk>
80004f50:	06100593          	li	a1,97
80004f54:	b3448513          	addi	a0,s1,-1228
80004f58:	e55fc0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f5c:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004f60:	01c12083          	lw	ra,28(sp)
80004f64:	01812403          	lw	s0,24(sp)
80004f68:	01412483          	lw	s1,20(sp)
80004f6c:	01012903          	lw	s2,16(sp)
80004f70:	00c12983          	lw	s3,12(sp)
80004f74:	00812a03          	lw	s4,8(sp)
80004f78:	02010113          	addi	sp,sp,32
80004f7c:	00008067          	ret

80004f80 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004f80:	fd010113          	addi	sp,sp,-48
80004f84:	02812423          	sw	s0,40(sp)
80004f88:	01412c23          	sw	s4,24(sp)
80004f8c:	02112623          	sw	ra,44(sp)
80004f90:	02912223          	sw	s1,36(sp)
80004f94:	03212023          	sw	s2,32(sp)
80004f98:	01312e23          	sw	s3,28(sp)
80004f9c:	01512a23          	sw	s5,20(sp)
80004fa0:	01612823          	sw	s6,16(sp)
80004fa4:	01712623          	sw	s7,12(sp)
80004fa8:	01812423          	sw	s8,8(sp)
80004fac:	01912223          	sw	s9,4(sp)
80004fb0:	01a12023          	sw	s10,0(sp)
80004fb4:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004fb8:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004fbc:	b39fe0ef          	jal	ra,80003af4 <z_time_slice>
80004fc0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004fc4:	80006937          	lui	s2,0x80006
80004fc8:	0f090513          	addi	a0,s2,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004fcc:	00847413          	andi	s0,s0,8
80004fd0:	d64ff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80004fd4:	02051e63          	bnez	a0,80005010 <z_clock_announce+0x90>
80004fd8:	800064b7          	lui	s1,0x80006
80004fdc:	800065b7          	lui	a1,0x80006
80004fe0:	80006537          	lui	a0,0x80006
80004fe4:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80004fe8:	04e00693          	li	a3,78
80004fec:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80004ff0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80004ff4:	d7dfc0ef          	jal	ra,80001d70 <printk>
80004ff8:	80006537          	lui	a0,0x80006
80004ffc:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80005000:	d71fc0ef          	jal	ra,80001d70 <printk>
80005004:	04e00593          	li	a1,78
80005008:	b3448513          	addi	a0,s1,-1228
8000500c:	da1fc0ef          	jal	ra,80001dac <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005010:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80005014:	0f090513          	addi	a0,s2,240
80005018:	d74ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
8000501c:	800064b7          	lui	s1,0x80006
80005020:	0f49a623          	sw	s4,236(s3) # 800060ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060ed>
	return list->head == list;
80005024:	80006a37          	lui	s4,0x80006
80005028:	0ec98993          	addi	s3,s3,236
8000502c:	010a0a13          	addi	s4,s4,16 # 80006010 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006011>
80005030:	0b048493          	addi	s1,s1,176 # 800060b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b1>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005034:	80006ab7          	lui	s5,0x80006
80005038:	80006bb7          	lui	s7,0x80006
8000503c:	80006b37          	lui	s6,0x80006
80005040:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005044:	80006cb7          	lui	s9,0x80006
80005048:	000a2d03          	lw	s10,0(s4)
8000504c:	0009a783          	lw	a5,0(s3)
80005050:	0004a683          	lw	a3,0(s1)
80005054:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005058:	014d0c63          	beq	s10,s4,80005070 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
8000505c:	000d0a63          	beqz	s10,80005070 <z_clock_announce+0xf0>
80005060:	008d2703          	lw	a4,8(s10)
80005064:	0ae7dc63          	bge	a5,a4,8000511c <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005068:	40f70733          	sub	a4,a4,a5
8000506c:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005070:	00d786b3          	add	a3,a5,a3
80005074:	41f7d713          	srai	a4,a5,0x1f
80005078:	00a70733          	add	a4,a4,a0
8000507c:	00f6b7b3          	sltu	a5,a3,a5
80005080:	00e787b3          	add	a5,a5,a4
80005084:	00d4a023          	sw	a3,0(s1)
80005088:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
8000508c:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005090:	969ff0ef          	jal	ra,800049f8 <next_timeout>
80005094:	00000593          	li	a1,0
80005098:	fedfc0ef          	jal	ra,80002084 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000509c:	0f090513          	addi	a0,s2,240
800050a0:	cbcff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
800050a4:	02051e63          	bnez	a0,800050e0 <z_clock_announce+0x160>
800050a8:	800064b7          	lui	s1,0x80006
800050ac:	800065b7          	lui	a1,0x80006
800050b0:	80006537          	lui	a0,0x80006
800050b4:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
800050b8:	06100693          	li	a3,97
800050bc:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
800050c0:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
800050c4:	cadfc0ef          	jal	ra,80001d70 <printk>
800050c8:	80006537          	lui	a0,0x80006
800050cc:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800050d0:	ca1fc0ef          	jal	ra,80001d70 <printk>
800050d4:	06100593          	li	a1,97
800050d8:	b3448513          	addi	a0,s1,-1228
800050dc:	cd1fc0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800050e0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
800050e4:	02c12083          	lw	ra,44(sp)
800050e8:	02812403          	lw	s0,40(sp)
800050ec:	02412483          	lw	s1,36(sp)
800050f0:	02012903          	lw	s2,32(sp)
800050f4:	01c12983          	lw	s3,28(sp)
800050f8:	01812a03          	lw	s4,24(sp)
800050fc:	01412a83          	lw	s5,20(sp)
80005100:	01012b03          	lw	s6,16(sp)
80005104:	00c12b83          	lw	s7,12(sp)
80005108:	00812c03          	lw	s8,8(sp)
8000510c:	00412c83          	lw	s9,4(sp)
80005110:	00012d03          	lw	s10,0(sp)
80005114:	03010113          	addi	sp,sp,48
80005118:	00008067          	ret
		curr_tick += dt;
8000511c:	00d706b3          	add	a3,a4,a3
80005120:	41f75593          	srai	a1,a4,0x1f
80005124:	00a585b3          	add	a1,a1,a0
80005128:	00e6b633          	sltu	a2,a3,a4
8000512c:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80005130:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80005134:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005138:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
8000513c:	00d4a023          	sw	a3,0(s1)
80005140:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005144:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005148:	871ff0ef          	jal	ra,800049b8 <remove_timeout>
8000514c:	0f090513          	addi	a0,s2,240
80005150:	c0cff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80005154:	02051663          	bnez	a0,80005180 <z_clock_announce+0x200>
80005158:	b7cb8593          	addi	a1,s7,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
8000515c:	06100693          	li	a3,97
80005160:	b34a8613          	addi	a2,s5,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80005164:	a68b0513          	addi	a0,s6,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80005168:	c09fc0ef          	jal	ra,80001d70 <printk>
8000516c:	b94c0513          	addi	a0,s8,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
80005170:	c01fc0ef          	jal	ra,80001d70 <printk>
80005174:	06100593          	li	a1,97
80005178:	b34a8513          	addi	a0,s5,-1228
8000517c:	c31fc0ef          	jal	ra,80001dac <assert_post_action>
80005180:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005184:	00cd2783          	lw	a5,12(s10)
80005188:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000518c:	00800413          	li	s0,8
80005190:	000780e7          	jalr	a5
80005194:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005198:	0f090513          	addi	a0,s2,240
	key = (mstatus & SOC_MSTATUS_IEN);
8000519c:	00847413          	andi	s0,s0,8
800051a0:	b94ff0ef          	jal	ra,80004534 <z_spin_lock_valid>
800051a4:	02051863          	bnez	a0,800051d4 <z_clock_announce+0x254>
800051a8:	b4cc8593          	addi	a1,s9,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
800051ac:	04e00693          	li	a3,78
800051b0:	b34a8613          	addi	a2,s5,-1228
800051b4:	a68b0513          	addi	a0,s6,-1432
800051b8:	bb9fc0ef          	jal	ra,80001d70 <printk>
800051bc:	80006537          	lui	a0,0x80006
800051c0:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
800051c4:	badfc0ef          	jal	ra,80001d70 <printk>
800051c8:	04e00593          	li	a1,78
800051cc:	b34a8513          	addi	a0,s5,-1228
800051d0:	bddfc0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
800051d4:	0f090513          	addi	a0,s2,240
800051d8:	bb4ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	return k;
800051dc:	e6dff06f          	j	80005048 <z_clock_announce+0xc8>

800051e0 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
800051e0:	fe010113          	addi	sp,sp,-32
800051e4:	00912a23          	sw	s1,20(sp)
800051e8:	00112e23          	sw	ra,28(sp)
800051ec:	00812c23          	sw	s0,24(sp)
800051f0:	01212823          	sw	s2,16(sp)
800051f4:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800051f8:	00800493          	li	s1,8
800051fc:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005200:	80006937          	lui	s2,0x80006
80005204:	0f090513          	addi	a0,s2,240 # 800060f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f1>
	key = (mstatus & SOC_MSTATUS_IEN);
80005208:	0084f493          	andi	s1,s1,8
8000520c:	b28ff0ef          	jal	ra,80004534 <z_spin_lock_valid>
80005210:	02051e63          	bnez	a0,8000524c <z_tick_get+0x6c>
80005214:	80006437          	lui	s0,0x80006
80005218:	800065b7          	lui	a1,0x80006
8000521c:	80006537          	lui	a0,0x80006
80005220:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80005224:	04e00693          	li	a3,78
80005228:	b3440613          	addi	a2,s0,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
8000522c:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80005230:	b41fc0ef          	jal	ra,80001d70 <printk>
80005234:	80006537          	lui	a0,0x80006
80005238:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
8000523c:	b35fc0ef          	jal	ra,80001d70 <printk>
80005240:	04e00593          	li	a1,78
80005244:	b3440513          	addi	a0,s0,-1228
80005248:	b65fc0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
8000524c:	0f090513          	addi	a0,s2,240
80005250:	b3cff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80005254:	fd9fc0ef          	jal	ra,8000222c <z_clock_elapsed>
80005258:	800067b7          	lui	a5,0x80006
8000525c:	0b078793          	addi	a5,a5,176 # 800060b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060b1>
80005260:	0007a983          	lw	s3,0(a5)
80005264:	0047a403          	lw	s0,4(a5)
80005268:	013509b3          	add	s3,a0,s3
8000526c:	00a9b533          	sltu	a0,s3,a0
80005270:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005274:	0f090513          	addi	a0,s2,240
80005278:	ae4ff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
8000527c:	02051e63          	bnez	a0,800052b8 <z_tick_get+0xd8>
80005280:	80006937          	lui	s2,0x80006
80005284:	800065b7          	lui	a1,0x80006
80005288:	80006537          	lui	a0,0x80006
8000528c:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80005290:	06100693          	li	a3,97
80005294:	b3490613          	addi	a2,s2,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80005298:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000529c:	ad5fc0ef          	jal	ra,80001d70 <printk>
800052a0:	80006537          	lui	a0,0x80006
800052a4:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800052a8:	ac9fc0ef          	jal	ra,80001d70 <printk>
800052ac:	06100593          	li	a1,97
800052b0:	b3490513          	addi	a0,s2,-1228
800052b4:	af9fc0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800052b8:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
800052bc:	00040593          	mv	a1,s0
800052c0:	01c12083          	lw	ra,28(sp)
800052c4:	01812403          	lw	s0,24(sp)
800052c8:	00098513          	mv	a0,s3
800052cc:	01412483          	lw	s1,20(sp)
800052d0:	01012903          	lw	s2,16(sp)
800052d4:	00c12983          	lw	s3,12(sp)
800052d8:	02010113          	addi	sp,sp,32
800052dc:	00008067          	ret

800052e0 <z_impl_atomic_add>:
 * @param value the value to add
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_add(atomic_t *target, atomic_val_t value)
{
800052e0:	fe010113          	addi	sp,sp,-32
800052e4:	00812c23          	sw	s0,24(sp)
800052e8:	01212823          	sw	s2,16(sp)
800052ec:	01412423          	sw	s4,8(sp)
800052f0:	00112e23          	sw	ra,28(sp)
800052f4:	00912a23          	sw	s1,20(sp)
800052f8:	01312623          	sw	s3,12(sp)
800052fc:	00050a13          	mv	s4,a0
80005300:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005304:	00800413          	li	s0,8
80005308:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000530c:	800064b7          	lui	s1,0x80006
80005310:	0f448513          	addi	a0,s1,244 # 800060f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800060f5>
	key = (mstatus & SOC_MSTATUS_IEN);
80005314:	00847413          	andi	s0,s0,8
80005318:	a1cff0ef          	jal	ra,80004534 <z_spin_lock_valid>
8000531c:	02051e63          	bnez	a0,80005358 <z_impl_atomic_add+0x78>
80005320:	800069b7          	lui	s3,0x80006
80005324:	800065b7          	lui	a1,0x80006
80005328:	80006537          	lui	a0,0x80006
8000532c:	b4c58593          	addi	a1,a1,-1204 # 80005b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b4d>
80005330:	04e00693          	li	a3,78
80005334:	b3498613          	addi	a2,s3,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80005338:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
8000533c:	a35fc0ef          	jal	ra,80001d70 <printk>
80005340:	80006537          	lui	a0,0x80006
80005344:	b6450513          	addi	a0,a0,-1180 # 80005b64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b65>
80005348:	a29fc0ef          	jal	ra,80001d70 <printk>
8000534c:	04e00593          	li	a1,78
80005350:	b3498513          	addi	a0,s3,-1228
80005354:	a59fc0ef          	jal	ra,80001dac <assert_post_action>
	z_spin_lock_set_owner(l);
80005358:	0f448513          	addi	a0,s1,244
8000535c:	a30ff0ef          	jal	ra,8000458c <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80005360:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005364:	0f448513          	addi	a0,s1,244
	*target += value;
80005368:	01298933          	add	s2,s3,s2
8000536c:	012a2023          	sw	s2,0(s4)
80005370:	9ecff0ef          	jal	ra,8000455c <z_spin_unlock_valid>
80005374:	02051e63          	bnez	a0,800053b0 <z_impl_atomic_add+0xd0>
80005378:	800064b7          	lui	s1,0x80006
8000537c:	800065b7          	lui	a1,0x80006
80005380:	80006537          	lui	a0,0x80006
80005384:	b7c58593          	addi	a1,a1,-1156 # 80005b7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b7d>
80005388:	06100693          	li	a3,97
8000538c:	b3448613          	addi	a2,s1,-1228 # 80005b34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b35>
80005390:	a6850513          	addi	a0,a0,-1432 # 80005a68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a69>
80005394:	9ddfc0ef          	jal	ra,80001d70 <printk>
80005398:	80006537          	lui	a0,0x80006
8000539c:	b9450513          	addi	a0,a0,-1132 # 80005b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b95>
800053a0:	9d1fc0ef          	jal	ra,80001d70 <printk>
800053a4:	06100593          	li	a1,97
800053a8:	b3448513          	addi	a0,s1,-1228
800053ac:	a01fc0ef          	jal	ra,80001dac <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800053b0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
800053b4:	01c12083          	lw	ra,28(sp)
800053b8:	01812403          	lw	s0,24(sp)
800053bc:	00098513          	mv	a0,s3
800053c0:	01412483          	lw	s1,20(sp)
800053c4:	01012903          	lw	s2,16(sp)
800053c8:	00c12983          	lw	s3,12(sp)
800053cc:	00812a03          	lw	s4,8(sp)
800053d0:	02010113          	addi	sp,sp,32
800053d4:	00008067          	ret

800053d8 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800053d8:	00008067          	ret
