
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	3450006f          	j	80000b50 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	1ed0006f          	j	80000a88 <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00006397          	auipc	t2,0x6
800000b8:	05038393          	addi	t2,t2,80 # 80006104 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	2350006f          	j	80000b14 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00005297          	auipc	t0,0x5
800000fc:	f6428293          	addi	t0,t0,-156 # 8000505c <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00006317          	auipc	t1,0x6
80000118:	ff030313          	addi	t1,t1,-16 # 80006104 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00006297          	auipc	t0,0x6
80000140:	fc828293          	addi	t0,t0,-56 # 80006104 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00006397          	auipc	t2,0x6
80000180:	b2438393          	addi	t2,t2,-1244 # 80005ca0 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00006297          	auipc	t0,0x6
80000230:	ed828293          	addi	t0,t0,-296 # 80006104 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	00058793          	mv	a5,a1
800002b4:	00060813          	mv	a6,a2
800002b8:	00068713          	mv	a4,a3
800002bc:	00050313          	mv	t1,a0
800002c0:	28069663          	bnez	a3,8000054c <__udivdi3+0x29c>
800002c4:	00005897          	auipc	a7,0x5
800002c8:	f1888893          	addi	a7,a7,-232 # 800051dc <__devconfig_end>
800002cc:	0ec5f663          	bgeu	a1,a2,800003b8 <__udivdi3+0x108>
800002d0:	00010737          	lui	a4,0x10
800002d4:	0ce67863          	bgeu	a2,a4,800003a4 <__udivdi3+0xf4>
800002d8:	0ff00713          	li	a4,255
800002dc:	00c73733          	sltu	a4,a4,a2
800002e0:	00371713          	slli	a4,a4,0x3
800002e4:	00e656b3          	srl	a3,a2,a4
800002e8:	00d888b3          	add	a7,a7,a3
800002ec:	0008c683          	lbu	a3,0(a7)
800002f0:	00e68733          	add	a4,a3,a4
800002f4:	02000693          	li	a3,32
800002f8:	40e686b3          	sub	a3,a3,a4
800002fc:	00068c63          	beqz	a3,80000314 <__udivdi3+0x64>
80000300:	00d797b3          	sll	a5,a5,a3
80000304:	00e55733          	srl	a4,a0,a4
80000308:	00d61833          	sll	a6,a2,a3
8000030c:	00f765b3          	or	a1,a4,a5
80000310:	00d51333          	sll	t1,a0,a3
80000314:	01085513          	srli	a0,a6,0x10
80000318:	02a5f733          	remu	a4,a1,a0
8000031c:	01081613          	slli	a2,a6,0x10
80000320:	01065613          	srli	a2,a2,0x10
80000324:	01035693          	srli	a3,t1,0x10
80000328:	02a5d5b3          	divu	a1,a1,a0
8000032c:	01071713          	slli	a4,a4,0x10
80000330:	00d766b3          	or	a3,a4,a3
80000334:	02b607b3          	mul	a5,a2,a1
80000338:	00058713          	mv	a4,a1
8000033c:	00f6fe63          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000340:	010686b3          	add	a3,a3,a6
80000344:	fff58713          	addi	a4,a1,-1
80000348:	0106e863          	bltu	a3,a6,80000358 <__udivdi3+0xa8>
8000034c:	00f6f663          	bgeu	a3,a5,80000358 <__udivdi3+0xa8>
80000350:	ffe58713          	addi	a4,a1,-2
80000354:	010686b3          	add	a3,a3,a6
80000358:	40f686b3          	sub	a3,a3,a5
8000035c:	02a6f7b3          	remu	a5,a3,a0
80000360:	01031313          	slli	t1,t1,0x10
80000364:	01035313          	srli	t1,t1,0x10
80000368:	02a6d6b3          	divu	a3,a3,a0
8000036c:	01079793          	slli	a5,a5,0x10
80000370:	0067e333          	or	t1,a5,t1
80000374:	02d605b3          	mul	a1,a2,a3
80000378:	00068513          	mv	a0,a3
8000037c:	00b37c63          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000380:	00680333          	add	t1,a6,t1
80000384:	fff68513          	addi	a0,a3,-1
80000388:	01036663          	bltu	t1,a6,80000394 <__udivdi3+0xe4>
8000038c:	00b37463          	bgeu	t1,a1,80000394 <__udivdi3+0xe4>
80000390:	ffe68513          	addi	a0,a3,-2
80000394:	01071713          	slli	a4,a4,0x10
80000398:	00a76733          	or	a4,a4,a0
8000039c:	00000593          	li	a1,0
800003a0:	0e40006f          	j	80000484 <__udivdi3+0x1d4>
800003a4:	010006b7          	lui	a3,0x1000
800003a8:	01000713          	li	a4,16
800003ac:	f2d66ce3          	bltu	a2,a3,800002e4 <__udivdi3+0x34>
800003b0:	01800713          	li	a4,24
800003b4:	f31ff06f          	j	800002e4 <__udivdi3+0x34>
800003b8:	00061663          	bnez	a2,800003c4 <__udivdi3+0x114>
800003bc:	00100693          	li	a3,1
800003c0:	02c6d833          	divu	a6,a3,a2
800003c4:	000106b7          	lui	a3,0x10
800003c8:	0cd87263          	bgeu	a6,a3,8000048c <__udivdi3+0x1dc>
800003cc:	0ff00693          	li	a3,255
800003d0:	0106f463          	bgeu	a3,a6,800003d8 <__udivdi3+0x128>
800003d4:	00800713          	li	a4,8
800003d8:	00e856b3          	srl	a3,a6,a4
800003dc:	00d888b3          	add	a7,a7,a3
800003e0:	0008c683          	lbu	a3,0(a7)
800003e4:	00e686b3          	add	a3,a3,a4
800003e8:	02000713          	li	a4,32
800003ec:	40d70733          	sub	a4,a4,a3
800003f0:	0a071863          	bnez	a4,800004a0 <__udivdi3+0x1f0>
800003f4:	410787b3          	sub	a5,a5,a6
800003f8:	00100593          	li	a1,1
800003fc:	01085613          	srli	a2,a6,0x10
80000400:	01081893          	slli	a7,a6,0x10
80000404:	0108d893          	srli	a7,a7,0x10
80000408:	01035693          	srli	a3,t1,0x10
8000040c:	02c7f733          	remu	a4,a5,a2
80000410:	02c7d7b3          	divu	a5,a5,a2
80000414:	01071713          	slli	a4,a4,0x10
80000418:	00d766b3          	or	a3,a4,a3
8000041c:	02f88533          	mul	a0,a7,a5
80000420:	00078713          	mv	a4,a5
80000424:	00a6fe63          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000428:	010686b3          	add	a3,a3,a6
8000042c:	fff78713          	addi	a4,a5,-1
80000430:	0106e863          	bltu	a3,a6,80000440 <__udivdi3+0x190>
80000434:	00a6f663          	bgeu	a3,a0,80000440 <__udivdi3+0x190>
80000438:	ffe78713          	addi	a4,a5,-2
8000043c:	010686b3          	add	a3,a3,a6
80000440:	40a686b3          	sub	a3,a3,a0
80000444:	02c6f7b3          	remu	a5,a3,a2
80000448:	01031313          	slli	t1,t1,0x10
8000044c:	01035313          	srli	t1,t1,0x10
80000450:	02c6d6b3          	divu	a3,a3,a2
80000454:	01079793          	slli	a5,a5,0x10
80000458:	0067e333          	or	t1,a5,t1
8000045c:	02d888b3          	mul	a7,a7,a3
80000460:	00068513          	mv	a0,a3
80000464:	01137c63          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000468:	00680333          	add	t1,a6,t1
8000046c:	fff68513          	addi	a0,a3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000470:	01036663          	bltu	t1,a6,8000047c <__udivdi3+0x1cc>
80000474:	01137463          	bgeu	t1,a7,8000047c <__udivdi3+0x1cc>
80000478:	ffe68513          	addi	a0,a3,-2
8000047c:	01071713          	slli	a4,a4,0x10
80000480:	00a76733          	or	a4,a4,a0
80000484:	00070513          	mv	a0,a4
80000488:	00008067          	ret
8000048c:	010006b7          	lui	a3,0x1000
80000490:	01000713          	li	a4,16
80000494:	f4d862e3          	bltu	a6,a3,800003d8 <__udivdi3+0x128>
80000498:	01800713          	li	a4,24
8000049c:	f3dff06f          	j	800003d8 <__udivdi3+0x128>
800004a0:	00e81833          	sll	a6,a6,a4
800004a4:	00d7d5b3          	srl	a1,a5,a3
800004a8:	00e51333          	sll	t1,a0,a4
800004ac:	00d556b3          	srl	a3,a0,a3
800004b0:	01085513          	srli	a0,a6,0x10
800004b4:	00e797b3          	sll	a5,a5,a4
800004b8:	02a5f733          	remu	a4,a1,a0
800004bc:	00f6e8b3          	or	a7,a3,a5
800004c0:	01081793          	slli	a5,a6,0x10
800004c4:	0107d793          	srli	a5,a5,0x10
800004c8:	0108d613          	srli	a2,a7,0x10
800004cc:	02a5d5b3          	divu	a1,a1,a0
800004d0:	01071713          	slli	a4,a4,0x10
800004d4:	00c76733          	or	a4,a4,a2
800004d8:	02b786b3          	mul	a3,a5,a1
800004dc:	00058613          	mv	a2,a1
800004e0:	00d77e63          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004e4:	01070733          	add	a4,a4,a6
800004e8:	fff58613          	addi	a2,a1,-1
800004ec:	01076863          	bltu	a4,a6,800004fc <__udivdi3+0x24c>
800004f0:	00d77663          	bgeu	a4,a3,800004fc <__udivdi3+0x24c>
800004f4:	ffe58613          	addi	a2,a1,-2
800004f8:	01070733          	add	a4,a4,a6
800004fc:	40d706b3          	sub	a3,a4,a3
80000500:	02a6f733          	remu	a4,a3,a0
80000504:	01089893          	slli	a7,a7,0x10
80000508:	0108d893          	srli	a7,a7,0x10
8000050c:	02a6d6b3          	divu	a3,a3,a0
80000510:	01071713          	slli	a4,a4,0x10
80000514:	02d785b3          	mul	a1,a5,a3
80000518:	011767b3          	or	a5,a4,a7
8000051c:	00068713          	mv	a4,a3
80000520:	00b7fe63          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000524:	010787b3          	add	a5,a5,a6
80000528:	fff68713          	addi	a4,a3,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000052c:	0107e863          	bltu	a5,a6,8000053c <__udivdi3+0x28c>
80000530:	00b7f663          	bgeu	a5,a1,8000053c <__udivdi3+0x28c>
80000534:	ffe68713          	addi	a4,a3,-2
80000538:	010787b3          	add	a5,a5,a6
8000053c:	40b787b3          	sub	a5,a5,a1
80000540:	01061593          	slli	a1,a2,0x10
80000544:	00e5e5b3          	or	a1,a1,a4
80000548:	eb5ff06f          	j	800003fc <__udivdi3+0x14c>
8000054c:	18d5e663          	bltu	a1,a3,800006d8 <__udivdi3+0x428>
80000550:	00010737          	lui	a4,0x10
80000554:	04e6f463          	bgeu	a3,a4,8000059c <__udivdi3+0x2ec>
80000558:	0ff00813          	li	a6,255
8000055c:	00d83733          	sltu	a4,a6,a3
80000560:	00371713          	slli	a4,a4,0x3
80000564:	00e6d833          	srl	a6,a3,a4
80000568:	00005597          	auipc	a1,0x5
8000056c:	c7458593          	addi	a1,a1,-908 # 800051dc <__devconfig_end>
80000570:	010585b3          	add	a1,a1,a6
80000574:	0005c803          	lbu	a6,0(a1)
80000578:	02000593          	li	a1,32
8000057c:	00e80833          	add	a6,a6,a4
80000580:	410585b3          	sub	a1,a1,a6
80000584:	02059663          	bnez	a1,800005b0 <__udivdi3+0x300>
80000588:	00100713          	li	a4,1
8000058c:	eef6ece3          	bltu	a3,a5,80000484 <__udivdi3+0x1d4>
80000590:	00c53533          	sltu	a0,a0,a2
80000594:	00154713          	xori	a4,a0,1
80000598:	eedff06f          	j	80000484 <__udivdi3+0x1d4>
8000059c:	010005b7          	lui	a1,0x1000
800005a0:	01000713          	li	a4,16
800005a4:	fcb6e0e3          	bltu	a3,a1,80000564 <__udivdi3+0x2b4>
800005a8:	01800713          	li	a4,24
800005ac:	fb9ff06f          	j	80000564 <__udivdi3+0x2b4>
800005b0:	01065733          	srl	a4,a2,a6
800005b4:	00b696b3          	sll	a3,a3,a1
800005b8:	00d766b3          	or	a3,a4,a3
800005bc:	0106de93          	srli	t4,a3,0x10
800005c0:	0107d733          	srl	a4,a5,a6
800005c4:	03d778b3          	remu	a7,a4,t4
800005c8:	00b797b3          	sll	a5,a5,a1
800005cc:	01055833          	srl	a6,a0,a6
800005d0:	00f86333          	or	t1,a6,a5
800005d4:	01069793          	slli	a5,a3,0x10
800005d8:	0107d793          	srli	a5,a5,0x10
800005dc:	01035813          	srli	a6,t1,0x10
800005e0:	00b61633          	sll	a2,a2,a1
800005e4:	03d75733          	divu	a4,a4,t4
800005e8:	01089893          	slli	a7,a7,0x10
800005ec:	0108e833          	or	a6,a7,a6
800005f0:	02e78f33          	mul	t5,a5,a4
800005f4:	00070e13          	mv	t3,a4
800005f8:	01e87e63          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
800005fc:	00d80833          	add	a6,a6,a3
80000600:	fff70e13          	addi	t3,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000604:	00d86863          	bltu	a6,a3,80000614 <__udivdi3+0x364>
80000608:	01e87663          	bgeu	a6,t5,80000614 <__udivdi3+0x364>
8000060c:	ffe70e13          	addi	t3,a4,-2
80000610:	00d80833          	add	a6,a6,a3
80000614:	41e80833          	sub	a6,a6,t5
80000618:	03d878b3          	remu	a7,a6,t4
8000061c:	03d85833          	divu	a6,a6,t4
80000620:	01089893          	slli	a7,a7,0x10
80000624:	03078eb3          	mul	t4,a5,a6
80000628:	01031793          	slli	a5,t1,0x10
8000062c:	0107d793          	srli	a5,a5,0x10
80000630:	00f8e7b3          	or	a5,a7,a5
80000634:	00080713          	mv	a4,a6
80000638:	01d7fe63          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000063c:	00d787b3          	add	a5,a5,a3
80000640:	fff80713          	addi	a4,a6,-1
80000644:	00d7e863          	bltu	a5,a3,80000654 <__udivdi3+0x3a4>
80000648:	01d7f663          	bgeu	a5,t4,80000654 <__udivdi3+0x3a4>
8000064c:	ffe80713          	addi	a4,a6,-2
80000650:	00d787b3          	add	a5,a5,a3
80000654:	010e1e13          	slli	t3,t3,0x10
80000658:	41d787b3          	sub	a5,a5,t4
8000065c:	00010eb7          	lui	t4,0x10
80000660:	00ee6733          	or	a4,t3,a4
80000664:	fffe8813          	addi	a6,t4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000668:	01077333          	and	t1,a4,a6
8000066c:	01075893          	srli	a7,a4,0x10
80000670:	01067833          	and	a6,a2,a6
80000674:	01065613          	srli	a2,a2,0x10
80000678:	03030e33          	mul	t3,t1,a6
8000067c:	03088833          	mul	a6,a7,a6
80000680:	010e5693          	srli	a3,t3,0x10
80000684:	02c30333          	mul	t1,t1,a2
80000688:	01030333          	add	t1,t1,a6
8000068c:	006686b3          	add	a3,a3,t1
80000690:	02c888b3          	mul	a7,a7,a2
80000694:	0106f463          	bgeu	a3,a6,8000069c <__udivdi3+0x3ec>
80000698:	01d888b3          	add	a7,a7,t4
8000069c:	0106d613          	srli	a2,a3,0x10
800006a0:	011608b3          	add	a7,a2,a7
800006a4:	0317e663          	bltu	a5,a7,800006d0 <__udivdi3+0x420>
800006a8:	cf179ae3          	bne	a5,a7,8000039c <__udivdi3+0xec>
800006ac:	000107b7          	lui	a5,0x10
800006b0:	fff78793          	addi	a5,a5,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800006b4:	00f6f6b3          	and	a3,a3,a5
800006b8:	01069693          	slli	a3,a3,0x10
800006bc:	00fe7e33          	and	t3,t3,a5
800006c0:	00b51533          	sll	a0,a0,a1
800006c4:	01c686b3          	add	a3,a3,t3
800006c8:	00000593          	li	a1,0
800006cc:	dad57ce3          	bgeu	a0,a3,80000484 <__udivdi3+0x1d4>
800006d0:	fff70713          	addi	a4,a4,-1
800006d4:	cc9ff06f          	j	8000039c <__udivdi3+0xec>
800006d8:	00000593          	li	a1,0
800006dc:	00000713          	li	a4,0
800006e0:	da5ff06f          	j	80000484 <__udivdi3+0x1d4>

800006e4 <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800006e4:	00008067          	ret

800006e8 <test_mpool_threadsafe>:
 * Each thread allocates 4 blocks of size 4 bytes (all blocks
 * in memory pool) with timeout of 200 ms and frees up all the
 * blocks
 */
void test_mpool_threadsafe(void)
{
800006e8:	fc010113          	addi	sp,sp,-64
800006ec:	02812c23          	sw	s0,56(sp)
800006f0:	03312623          	sw	s3,44(sp)
800006f4:	80006437          	lui	s0,0x80006

K_SYSCALL_DECLARE2(K_SYSCALL_K_MUTEX_LOCK, k_mutex_lock, int, struct k_mutex *, mutex, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
800006f8:	800069b7          	lui	s3,0x80006
800006fc:	02912a23          	sw	s1,52(sp)
80000700:	03212823          	sw	s2,48(sp)
80000704:	00400613          	li	a2,4
80000708:	00000593          	li	a1,0
8000070c:	dd498513          	addi	a0,s3,-556 # 80005dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd5>
80000710:	de440413          	addi	s0,s0,-540 # 80005de4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005de5>
80000714:	80006937          	lui	s2,0x80006
80000718:	01010493          	addi	s1,sp,16
8000071c:	03412423          	sw	s4,40(sp)
80000720:	03512223          	sw	s5,36(sp)
80000724:	03612023          	sw	s6,32(sp)
80000728:	02112e23          	sw	ra,60(sp)
8000072c:	13090913          	addi	s2,s2,304 # 80006130 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006131>
80000730:	620030ef          	jal	ra,80003d50 <z_impl_k_sem_init>
	k_tid_t tid[THREAD_NUM];

	k_sem_init(&sync_sema, 0, THREAD_NUM);

	/* create multiple threads to invoke same memory pool APIs*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000734:	1c040a93          	addi	s5,s0,448
80000738:	00048a13          	mv	s4,s1
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
8000073c:	80000b37          	lui	s6,0x80000
80000740:	00090593          	mv	a1,s2
80000744:	00040513          	mv	a0,s0
80000748:	00012223          	sw	zero,4(sp)
8000074c:	00012023          	sw	zero,0(sp)
80000750:	00100893          	li	a7,1
80000754:	00000813          	li	a6,0
80000758:	00000793          	li	a5,0
8000075c:	00000713          	li	a4,0
80000760:	7d4b0693          	addi	a3,s6,2004 # 800007d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800007d5>
80000764:	20000613          	li	a2,512
80000768:	431030ef          	jal	ra,80004398 <z_impl_k_thread_create>
		tid[i] = k_thread_create(&tdata[i], tstack[i], STACK_SIZE,
8000076c:	00aa2023          	sw	a0,0(s4)
80000770:	07040413          	addi	s0,s0,112
80000774:	20090913          	addi	s2,s2,512
80000778:	004a0a13          	addi	s4,s4,4
	for (int i = 0; i < THREAD_NUM; i++) {
8000077c:	fd5412e3          	bne	s0,s5,80000740 <test_mpool_threadsafe+0x58>
80000780:	00400413          	li	s0,4

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000784:	fff00593          	li	a1,-1
80000788:	dd498513          	addi	a0,s3,-556
8000078c:	fff40413          	addi	s0,s0,-1
80000790:	76c030ef          	jal	ra,80003efc <z_impl_k_sem_take>
					 tmpool_api, NULL, NULL, NULL,
					 K_PRIO_PREEMPT(1), 0, 0);
	}
	/* TESTPOINT: all threads complete and exit the entry function*/
	for (int i = 0; i < THREAD_NUM; i++) {
80000794:	fe0418e3          	bnez	s0,80000784 <test_mpool_threadsafe+0x9c>
80000798:	01048413          	addi	s0,s1,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
8000079c:	0004a503          	lw	a0,0(s1)
800007a0:	00448493          	addi	s1,s1,4
800007a4:	599030ef          	jal	ra,8000453c <z_impl_k_thread_abort>
		k_sem_take(&sync_sema, K_FOREVER);
	}

	/* test case tear down*/
	for (int i = 0; i < THREAD_NUM; i++) {
800007a8:	fe849ae3          	bne	s1,s0,8000079c <test_mpool_threadsafe+0xb4>
		k_thread_abort(tid[i]);
	}
}
800007ac:	03c12083          	lw	ra,60(sp)
800007b0:	03812403          	lw	s0,56(sp)
800007b4:	03412483          	lw	s1,52(sp)
800007b8:	03012903          	lw	s2,48(sp)
800007bc:	02c12983          	lw	s3,44(sp)
800007c0:	02812a03          	lw	s4,40(sp)
800007c4:	02412a83          	lw	s5,36(sp)
800007c8:	02012b03          	lw	s6,32(sp)
800007cc:	04010113          	addi	sp,sp,64
800007d0:	00008067          	ret

800007d4 <tmpool_api>:
extern "C" {
#endif

K_SYSCALL_DECLARE3(K_SYSCALL_ATOMIC_CAS, atomic_cas, int, atomic_t *, target, atomic_val_t, old_value, atomic_val_t, new_value)

K_SYSCALL_DECLARE2(K_SYSCALL_ATOMIC_ADD, atomic_add, atomic_val_t, atomic_t *, target, atomic_val_t, value)
800007d4:	80006537          	lui	a0,0x80006
{
800007d8:	f8010113          	addi	sp,sp,-128
800007dc:	00100593          	li	a1,1
800007e0:	d3850513          	addi	a0,a0,-712 # 80005d38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d39>
800007e4:	06112e23          	sw	ra,124(sp)
800007e8:	07312623          	sw	s3,108(sp)
800007ec:	07412423          	sw	s4,104(sp)
800007f0:	07512223          	sw	s5,100(sp)
800007f4:	07612023          	sw	s6,96(sp)
800007f8:	06812c23          	sw	s0,120(sp)
800007fc:	06912a23          	sw	s1,116(sp)
80000800:	07212823          	sw	s2,112(sp)
80000804:	75c040ef          	jal	ra,80004f60 <z_impl_atomic_add>
	struct k_mem_pool *pool = pools[atomic_inc(&pool_id) % POOL_NUM];
80000808:	00200793          	li	a5,2
8000080c:	02f567b3          	rem	a5,a0,a5
80000810:	80006537          	lui	a0,0x80006
80000814:	c9850513          	addi	a0,a0,-872 # 80005c98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c99>
	(void)memset(block, 0, sizeof(block));
80000818:	04000613          	li	a2,64
8000081c:	00000593          	li	a1,0
80000820:	00a00993          	li	s3,10
80000824:	04010a93          	addi	s5,sp,64
		for (int i = 0; i < 5; i++) {
80000828:	00500b13          	li	s6,5
	struct k_mem_pool *pool = pools[atomic_inc(&pool_id) % POOL_NUM];
8000082c:	00279793          	slli	a5,a5,0x2
80000830:	00f50533          	add	a0,a0,a5
80000834:	00052a03          	lw	s4,0(a0)
	(void)memset(block, 0, sizeof(block));
80000838:	02010513          	addi	a0,sp,32
8000083c:	7a8010ef          	jal	ra,80001fe4 <memset>
	for (int loops = 0; loops < LOOPS; loops++) {
80000840:	00010493          	mv	s1,sp
{
80000844:	00048913          	mv	s2,s1
80000848:	02010413          	addi	s0,sp,32
			ret[i] = k_mem_pool_alloc(pool, &block[i],
8000084c:	00040593          	mv	a1,s0
80000850:	0c800693          	li	a3,200
80000854:	00400613          	li	a2,4
80000858:	000a0513          	mv	a0,s4
8000085c:	67d010ef          	jal	ra,800026d8 <k_mem_pool_alloc>
80000860:	00a92023          	sw	a0,0(s2)
80000864:	00840413          	addi	s0,s0,8
80000868:	00490913          	addi	s2,s2,4
		for (int i = 0; i < 4; i++) {
8000086c:	ff5410e3          	bne	s0,s5,8000084c <tmpool_api+0x78>
		ret[4] = k_mem_pool_alloc(pool, &block[4], BLK_SIZE_MAX,
80000870:	0c800693          	li	a3,200
80000874:	01000613          	li	a2,16
80000878:	000a8593          	mv	a1,s5
8000087c:	000a0513          	mv	a0,s4
80000880:	659010ef          	jal	ra,800026d8 <k_mem_pool_alloc>
80000884:	00a12823          	sw	a0,16(sp)
		for (int i = 0; i < 5; i++) {
80000888:	00000413          	li	s0,0
			if (ret[i] == 0) {
8000088c:	0004a783          	lw	a5,0(s1)
80000890:	00079a63          	bnez	a5,800008a4 <tmpool_api+0xd0>
				k_mem_pool_free(&block[i]);
80000894:	00341513          	slli	a0,s0,0x3
80000898:	02010793          	addi	a5,sp,32
8000089c:	00a78533          	add	a0,a5,a0
800008a0:	150020ef          	jal	ra,800029f0 <k_mem_pool_free>
		for (int i = 0; i < 5; i++) {
800008a4:	00140413          	addi	s0,s0,1
800008a8:	00448493          	addi	s1,s1,4
800008ac:	ff6410e3          	bne	s0,s6,8000088c <tmpool_api+0xb8>
800008b0:	fff98993          	addi	s3,s3,-1
	for (int loops = 0; loops < LOOPS; loops++) {
800008b4:	f80996e3          	bnez	s3,80000840 <tmpool_api+0x6c>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800008b8:	80006537          	lui	a0,0x80006
800008bc:	dd450513          	addi	a0,a0,-556 # 80005dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005dd5>
800008c0:	558030ef          	jal	ra,80003e18 <z_impl_k_sem_give>
}
800008c4:	07c12083          	lw	ra,124(sp)
800008c8:	07812403          	lw	s0,120(sp)
800008cc:	07412483          	lw	s1,116(sp)
800008d0:	07012903          	lw	s2,112(sp)
800008d4:	06c12983          	lw	s3,108(sp)
800008d8:	06812a03          	lw	s4,104(sp)
800008dc:	06412a83          	lw	s5,100(sp)
800008e0:	06012b03          	lw	s6,96(sp)
800008e4:	08010113          	addi	sp,sp,128
800008e8:	00008067          	ret

800008ec <test_main>:

void test_main(void)
{
	ztest_test_suite(mpool_threadsafe,
			 ztest_unit_test(test_mpool_threadsafe));
	ztest_run_test_suite(mpool_threadsafe);
800008ec:	800065b7          	lui	a1,0x80006
800008f0:	80005537          	lui	a0,0x80005
800008f4:	c5c58593          	addi	a1,a1,-932 # 80005c5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c5d>
800008f8:	2f450513          	addi	a0,a0,756 # 800052f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052f5>
800008fc:	0110106f          	j	8000210c <z_ztest_run_test_suite>

80000900 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000900:	ff010113          	addi	sp,sp,-16
80000904:	00112623          	sw	ra,12(sp)
80000908:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
8000090c:	00600793          	li	a5,6
80000910:	02f50463          	beq	a0,a5,80000938 <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000914:	7d0030ef          	jal	ra,800040e4 <k_is_in_isr>
80000918:	02050463          	beqz	a0,80000940 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
8000091c:	7c8030ef          	jal	ra,800040e4 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000920:	04051663          	bnez	a0,8000096c <z_SysFatalErrorHandler+0x6c>
80000924:	800055b7          	lui	a1,0x80005
80000928:	5b858593          	addi	a1,a1,1464 # 800055b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b9>
8000092c:	80005537          	lui	a0,0x80005
80000930:	5cc50513          	addi	a0,a0,1484 # 800055cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055cd>
80000934:	110010ef          	jal	ra,80001a44 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000938:	17c010ef          	jal	ra,80001ab4 <k_cpu_idle>
8000093c:	ffdff06f          	j	80000938 <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000940:	7b4030ef          	jal	ra,800040f4 <z_is_thread_essential>
80000944:	fc051ce3          	bnez	a0,8000091c <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000948:	80006437          	lui	s0,0x80006
8000094c:	10440413          	addi	s0,s0,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80000950:	00842583          	lw	a1,8(s0)
80000954:	80005537          	lui	a0,0x80005
80000958:	5ec50513          	addi	a0,a0,1516 # 800055ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055ed>
8000095c:	0e8010ef          	jal	ra,80001a44 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000960:	00842503          	lw	a0,8(s0)
80000964:	3d9030ef          	jal	ra,8000453c <z_impl_k_thread_abort>
80000968:	fd1ff06f          	j	80000938 <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
8000096c:	800055b7          	lui	a1,0x80005
80000970:	5b458593          	addi	a1,a1,1460 # 800055b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055b5>
80000974:	fb9ff06f          	j	8000092c <z_SysFatalErrorHandler+0x2c>

80000978 <z_NanoFatalErrorHandler>:
{
80000978:	fb010113          	addi	sp,sp,-80
8000097c:	04812423          	sw	s0,72(sp)
80000980:	04912223          	sw	s1,68(sp)
80000984:	04112623          	sw	ra,76(sp)
	switch (reason) {
80000988:	00600793          	li	a5,6
{
8000098c:	00050493          	mv	s1,a0
80000990:	00058413          	mv	s0,a1
	switch (reason) {
80000994:	0ea7e063          	bltu	a5,a0,80000a74 <z_NanoFatalErrorHandler+0xfc>
80000998:	80005737          	lui	a4,0x80005
8000099c:	00251793          	slli	a5,a0,0x2
800009a0:	30870713          	addi	a4,a4,776 # 80005308 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005309>
800009a4:	00e787b3          	add	a5,a5,a4
800009a8:	0007a783          	lw	a5,0(a5)
800009ac:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
800009b0:	80005537          	lui	a0,0x80005
800009b4:	43850513          	addi	a0,a0,1080 # 80005438 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005439>
		printk("***** Kernel OOPS! *****\n");
800009b8:	08c010ef          	jal	ra,80001a44 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
800009bc:	388030ef          	jal	ra,80003d44 <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
800009c0:	04442783          	lw	a5,68(s0)
800009c4:	01042883          	lw	a7,16(s0)
800009c8:	00c42803          	lw	a6,12(s0)
800009cc:	02f12823          	sw	a5,48(sp)
800009d0:	04042783          	lw	a5,64(s0)
800009d4:	00442703          	lw	a4,4(s0)
800009d8:	00042683          	lw	a3,0(s0)
800009dc:	02f12623          	sw	a5,44(sp)
800009e0:	03c42783          	lw	a5,60(s0)
800009e4:	04842603          	lw	a2,72(s0)
800009e8:	00050593          	mv	a1,a0
800009ec:	02f12423          	sw	a5,40(sp)
800009f0:	03842783          	lw	a5,56(s0)
800009f4:	80005537          	lui	a0,0x80005
800009f8:	4bc50513          	addi	a0,a0,1212 # 800054bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800054bd>
800009fc:	02f12223          	sw	a5,36(sp)
80000a00:	03442783          	lw	a5,52(s0)
80000a04:	02f12023          	sw	a5,32(sp)
80000a08:	03042783          	lw	a5,48(s0)
80000a0c:	00f12e23          	sw	a5,28(sp)
80000a10:	02c42783          	lw	a5,44(s0)
80000a14:	00f12c23          	sw	a5,24(sp)
80000a18:	02842783          	lw	a5,40(s0)
80000a1c:	00f12a23          	sw	a5,20(sp)
80000a20:	02442783          	lw	a5,36(s0)
80000a24:	00f12823          	sw	a5,16(sp)
80000a28:	02042783          	lw	a5,32(s0)
80000a2c:	00f12623          	sw	a5,12(sp)
80000a30:	01c42783          	lw	a5,28(s0)
80000a34:	00f12423          	sw	a5,8(sp)
80000a38:	01842783          	lw	a5,24(s0)
80000a3c:	00f12223          	sw	a5,4(sp)
80000a40:	01442783          	lw	a5,20(s0)
80000a44:	00f12023          	sw	a5,0(sp)
80000a48:	00842783          	lw	a5,8(s0)
80000a4c:	7f9000ef          	jal	ra,80001a44 <printk>
	z_SysFatalErrorHandler(reason, esf);
80000a50:	00040593          	mv	a1,s0
80000a54:	00048513          	mv	a0,s1
80000a58:	ea9ff0ef          	jal	ra,80000900 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000a5c:	80005537          	lui	a0,0x80005
80000a60:	46050513          	addi	a0,a0,1120 # 80005460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005461>
80000a64:	f55ff06f          	j	800009b8 <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80000a68:	80005537          	lui	a0,0x80005
80000a6c:	47c50513          	addi	a0,a0,1148 # 8000547c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000547d>
80000a70:	f49ff06f          	j	800009b8 <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000a74:	80005537          	lui	a0,0x80005
80000a78:	00048593          	mv	a1,s1
80000a7c:	49850513          	addi	a0,a0,1176 # 80005498 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005499>
80000a80:	7c5000ef          	jal	ra,80001a44 <printk>
		break;
80000a84:	f39ff06f          	j	800009bc <z_NanoFatalErrorHandler+0x44>

80000a88 <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000a88:	ff010113          	addi	sp,sp,-16
80000a8c:	00812423          	sw	s0,8(sp)
80000a90:	00112623          	sw	ra,12(sp)
80000a94:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000a98:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000a9c:	00161613          	slli	a2,a2,0x1
80000aa0:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80000aa4:	00500793          	li	a5,5
80000aa8:	02c7e863          	bltu	a5,a2,80000ad8 <_Fault+0x50>
80000aac:	80005737          	lui	a4,0x80005
80000ab0:	00261793          	slli	a5,a2,0x2
80000ab4:	32470713          	addi	a4,a4,804 # 80005324 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005325>
80000ab8:	00f707b3          	add	a5,a4,a5
80000abc:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000ac0:	80005537          	lui	a0,0x80005
80000ac4:	34450513          	addi	a0,a0,836 # 80005344 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005345>
80000ac8:	77d000ef          	jal	ra,80001a44 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000acc:	00040593          	mv	a1,s0
80000ad0:	00000513          	li	a0,0
80000ad4:	ea5ff0ef          	jal	ra,80000978 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ad8:	800055b7          	lui	a1,0x80005
80000adc:	33c58593          	addi	a1,a1,828 # 8000533c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000533d>
80000ae0:	fe1ff06f          	j	80000ac0 <_Fault+0x38>

80000ae4 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000ae4:	ff010113          	addi	sp,sp,-16
80000ae8:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000aec:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000af0:	80005537          	lui	a0,0x80005
	mcause &= SOC_MCAUSE_EXP_MASK;
80000af4:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000af8:	0015d593          	srli	a1,a1,0x1
80000afc:	61450513          	addi	a0,a0,1556 # 80005614 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005615>
80000b00:	745000ef          	jal	ra,80001a44 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000b04:	800055b7          	lui	a1,0x80005
80000b08:	36058593          	addi	a1,a1,864 # 80005360 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005361>
80000b0c:	00400513          	li	a0,4
80000b10:	e69ff0ef          	jal	ra,80000978 <z_NanoFatalErrorHandler>

80000b14 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000b14:	800067b7          	lui	a5,0x80006
80000b18:	d3c78793          	addi	a5,a5,-708 # 80005d3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d3d>
80000b1c:	0007a703          	lw	a4,0(a5)
80000b20:	00070c63          	beqz	a4,80000b38 <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80000b24:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000b28:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000b2c:	800067b7          	lui	a5,0x80006
80000b30:	d407a503          	lw	a0,-704(a5) # 80005d40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d41>
80000b34:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80000b38:	00008067          	ret

80000b3c <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000b3c:	ff010113          	addi	sp,sp,-16
80000b40:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80000b44:	17d010ef          	jal	ra,800024c0 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000b48:	78d000ef          	jal	ra,80001ad4 <soc_interrupt_init>
#endif
	z_cstart();
80000b4c:	1e1010ef          	jal	ra,8000252c <z_cstart>

80000b50 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000b50:	00006117          	auipc	sp,0x6
80000b54:	5e010113          	addi	sp,sp,1504 # 80007130 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80000b58:	000012b7          	lui	t0,0x1
80000b5c:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80000b60:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80000b64:	fd9ff0ef          	jal	ra,80000b3c <_PrepC>

80000b68 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80000b68:	0890006f          	j	800013f0 <z_thread_entry>

80000b6c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000b6c:	fd010113          	addi	sp,sp,-48
80000b70:	02812423          	sw	s0,40(sp)
80000b74:	02912223          	sw	s1,36(sp)
80000b78:	03212023          	sw	s2,32(sp)
80000b7c:	01312e23          	sw	s3,28(sp)
80000b80:	01412c23          	sw	s4,24(sp)
80000b84:	01512a23          	sw	s5,20(sp)
80000b88:	01612823          	sw	s6,16(sp)
80000b8c:	01712623          	sw	s7,12(sp)
80000b90:	00078b13          	mv	s6,a5
80000b94:	02112623          	sw	ra,44(sp)
80000b98:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000b9c:	00f00793          	li	a5,15
{
80000ba0:	00050493          	mv	s1,a0
80000ba4:	00058413          	mv	s0,a1
80000ba8:	00060993          	mv	s3,a2
80000bac:	00068a13          	mv	s4,a3
80000bb0:	00070b93          	mv	s7,a4
80000bb4:	00080a93          	mv	s5,a6
80000bb8:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000bbc:	08f89a63          	bne	a7,a5,80000c50 <z_new_thread+0xe4>
80000bc0:	800027b7          	lui	a5,0x80002
80000bc4:	48878793          	addi	a5,a5,1160 # 80002488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002489>
80000bc8:	08f69a63          	bne	a3,a5,80000c5c <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000bcc:	03012683          	lw	a3,48(sp)
80000bd0:	00090593          	mv	a1,s2
80000bd4:	00048513          	mv	a0,s1
80000bd8:	00400613          	li	a2,4
80000bdc:	5dc030ef          	jal	ra,800041b8 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000be0:	fb098593          	addi	a1,s3,-80
80000be4:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000be8:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000bec:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000bf0:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000bf4:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000bf8:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000bfc:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000c00:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000c04:	02c12083          	lw	ra,44(sp)
80000c08:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000c0c:	b6878793          	addi	a5,a5,-1176 # 80000b68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000b69>
	stack_init->a0 = (u32_t)thread_func;
80000c10:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000c14:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000c18:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000c1c:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000c20:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000c24:	02b4a423          	sw	a1,40(s1)
}
80000c28:	02012903          	lw	s2,32(sp)
80000c2c:	02412483          	lw	s1,36(sp)
80000c30:	01c12983          	lw	s3,28(sp)
80000c34:	01812a03          	lw	s4,24(sp)
80000c38:	01412a83          	lw	s5,20(sp)
80000c3c:	01012b03          	lw	s6,16(sp)
80000c40:	00c12b83          	lw	s7,12(sp)
80000c44:	00812c03          	lw	s8,8(sp)
80000c48:	03010113          	addi	sp,sp,48
80000c4c:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000c50:	01088693          	addi	a3,a7,16
80000c54:	01e00793          	li	a5,30
80000c58:	f6d7fae3          	bgeu	a5,a3,80000bcc <z_new_thread+0x60>
80000c5c:	80005c37          	lui	s8,0x80005
80000c60:	800055b7          	lui	a1,0x80005
80000c64:	80005537          	lui	a0,0x80005
80000c68:	63cc0613          	addi	a2,s8,1596 # 8000563c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000563d>
80000c6c:	01800693          	li	a3,24
80000c70:	65c58593          	addi	a1,a1,1628 # 8000565c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000565d>
80000c74:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80000c78:	5cd000ef          	jal	ra,80001a44 <printk>
80000c7c:	80005537          	lui	a0,0x80005
80000c80:	00090593          	mv	a1,s2
80000c84:	ff000693          	li	a3,-16
80000c88:	00e00613          	li	a2,14
80000c8c:	70850513          	addi	a0,a0,1800 # 80005708 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005709>
80000c90:	5b5000ef          	jal	ra,80001a44 <printk>
80000c94:	01800593          	li	a1,24
80000c98:	63cc0513          	addi	a0,s8,1596
80000c9c:	5e5000ef          	jal	ra,80001a80 <assert_post_action>
80000ca0:	f2dff06f          	j	80000bcc <z_new_thread+0x60>

80000ca4 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80000ca4:	00c00793          	li	a5,12
80000ca8:	02f58733          	mul	a4,a1,a5
80000cac:	00c52783          	lw	a5,12(a0)
80000cb0:	00e787b3          	add	a5,a5,a4
80000cb4:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80000cb8:	00b75463          	bge	a4,a1,80000cc0 <get_bit_ptr+0x1c>
80000cbc:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80000cc0:	02000713          	li	a4,32
80000cc4:	02e64733          	div	a4,a2,a4

	return bn & 0x1f;
}
80000cc8:	01f67513          	andi	a0,a2,31
	*word = &bitarray[bn / 32];
80000ccc:	00271713          	slli	a4,a4,0x2
80000cd0:	00e787b3          	add	a5,a5,a4
80000cd4:	00f6a023          	sw	a5,0(a3)
}
80000cd8:	00008067          	ret

80000cdc <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000cdc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000ce0:	00c10693          	addi	a3,sp,12
{
80000ce4:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000ce8:	fbdff0ef          	jal	ra,80000ca4 <get_bit_ptr>

	*word |= (1<<bit);
80000cec:	00c12703          	lw	a4,12(sp)
80000cf0:	00100793          	li	a5,1
80000cf4:	00a79533          	sll	a0,a5,a0
80000cf8:	00072783          	lw	a5,0(a4)
}
80000cfc:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80000d00:	00a7e7b3          	or	a5,a5,a0
80000d04:	00f72023          	sw	a5,0(a4)
}
80000d08:	02010113          	addi	sp,sp,32
80000d0c:	00008067          	ret

80000d10 <clear_free_bit>:

static void clear_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80000d10:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80000d14:	00c10693          	addi	a3,sp,12
{
80000d18:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80000d1c:	f89ff0ef          	jal	ra,80000ca4 <get_bit_ptr>

	*word &= ~(1<<bit);
80000d20:	00c12703          	lw	a4,12(sp)
80000d24:	00100793          	li	a5,1
80000d28:	00a79533          	sll	a0,a5,a0
80000d2c:	00072783          	lw	a5,0(a4)
}
80000d30:	01c12083          	lw	ra,28(sp)
	*word &= ~(1<<bit);
80000d34:	fff54513          	not	a0,a0
80000d38:	00a7f533          	and	a0,a5,a0
80000d3c:	00a72023          	sw	a0,0(a4)
}
80000d40:	02010113          	addi	sp,sp,32
80000d44:	00008067          	ret

80000d48 <z_sys_mem_pool_base_init>:
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d48:	00452783          	lw	a5,4(a0)
80000d4c:	00855803          	lhu	a6,8(a0)
{
80000d50:	ff010113          	addi	sp,sp,-16
80000d54:	00812423          	sw	s0,8(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80000d58:	02f80833          	mul	a6,a6,a5
{
80000d5c:	00050413          	mv	s0,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000d60:	00052503          	lw	a0,0(a0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80000d64:	00a44883          	lbu	a7,10(s0)
	p->max_inline_level = -1;
80000d68:	fff00713          	li	a4,-1
{
80000d6c:	00112623          	sw	ra,12(sp)
80000d70:	00912223          	sw	s1,4(sp)
	p->max_inline_level = -1;
80000d74:	00e405a3          	sb	a4,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80000d78:	00000593          	li	a1,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);
80000d7c:	00c00313          	li	t1,12
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80000d80:	01050533          	add	a0,a0,a6

		if (nblocks < 32) {
80000d84:	01f00e13          	li	t3,31
			p->max_inline_level = i;
		} else {
			p->levels[i].bits_p = bits;
			bits += (nblocks + 31)/32;
80000d88:	02000e93          	li	t4,32
	for (i = 0; i < p->n_levels; i++) {
80000d8c:	0315c263          	blt	a1,a7,80000db0 <z_sys_mem_pool_base_init+0x68>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80000d90:	00000493          	li	s1,0
80000d94:	00845783          	lhu	a5,8(s0)
80000d98:	06f4c463          	blt	s1,a5,80000e00 <z_sys_mem_pool_base_init+0xb8>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80000d9c:	00c12083          	lw	ra,12(sp)
80000da0:	00812403          	lw	s0,8(sp)
80000da4:	00412483          	lw	s1,4(sp)
80000da8:	01010113          	addi	sp,sp,16
80000dac:	00008067          	ret
		int nblocks = buflen / sz;
80000db0:	02f85733          	divu	a4,a6,a5
		sys_dlist_init(&p->levels[i].free_list);
80000db4:	00c42603          	lw	a2,12(s0)
80000db8:	026586b3          	mul	a3,a1,t1
80000dbc:	00d606b3          	add	a3,a2,a3
80000dc0:	00468613          	addi	a2,a3,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80000dc4:	00c6a223          	sw	a2,4(a3)
	list->tail = (sys_dnode_t *)list;
80000dc8:	00c6a423          	sw	a2,8(a3)
		if (nblocks < 32) {
80000dcc:	00ee4e63          	blt	t3,a4,80000de8 <z_sys_mem_pool_base_init+0xa0>
			p->max_inline_level = i;
80000dd0:	00b405a3          	sb	a1,11(s0)
		sz = _ALIGN4(sz / 4);
80000dd4:	0027d793          	srli	a5,a5,0x2
80000dd8:	00378793          	addi	a5,a5,3
80000ddc:	ffc7f793          	andi	a5,a5,-4
	for (i = 0; i < p->n_levels; i++) {
80000de0:	00158593          	addi	a1,a1,1
80000de4:	fa9ff06f          	j	80000d8c <z_sys_mem_pool_base_init+0x44>
			bits += (nblocks + 31)/32;
80000de8:	01f70713          	addi	a4,a4,31
80000dec:	03d74733          	div	a4,a4,t4
			p->levels[i].bits_p = bits;
80000df0:	00a6a023          	sw	a0,0(a3)
			bits += (nblocks + 31)/32;
80000df4:	00271713          	slli	a4,a4,0x2
80000df8:	00e50533          	add	a0,a0,a4
80000dfc:	fd9ff06f          	j	80000dd4 <z_sys_mem_pool_base_init+0x8c>
	return (u8_t *)p->buf + lsz * block;
80000e00:	00442783          	lw	a5,4(s0)
		set_free_bit(p, 0, i);
80000e04:	00048613          	mv	a2,s1
80000e08:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80000e0c:	02f48733          	mul	a4,s1,a5
80000e10:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80000e14:	00040513          	mv	a0,s0
	for (i = 0; i < p->n_max; i++) {
80000e18:	00148493          	addi	s1,s1,1
	return (u8_t *)p->buf + lsz * block;
80000e1c:	00e787b3          	add	a5,a5,a4
		sys_dlist_append(&p->levels[0].free_list, block);
80000e20:	00c42703          	lw	a4,12(s0)
80000e24:	00470693          	addi	a3,a4,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80000e28:	00d7a023          	sw	a3,0(a5)
	node->prev = list->tail;
80000e2c:	00872683          	lw	a3,8(a4)
80000e30:	00d7a223          	sw	a3,4(a5)

	list->tail->next = node;
80000e34:	00872683          	lw	a3,8(a4)
80000e38:	00f6a023          	sw	a5,0(a3)
	list->tail = node;
80000e3c:	00f72423          	sw	a5,8(a4)
		set_free_bit(p, 0, i);
80000e40:	e9dff0ef          	jal	ra,80000cdc <set_free_bit>
80000e44:	f51ff06f          	j	80000d94 <z_sys_mem_pool_base_init+0x4c>

80000e48 <z_sys_mem_pool_block_alloc>:
	return block;
}

int z_sys_mem_pool_block_alloc(struct sys_mem_pool_base *p, size_t size,
			      u32_t *level_p, u32_t *block_p, void **data_p)
{
80000e48:	fb010113          	addi	sp,sp,-80
80000e4c:	04812423          	sw	s0,72(sp)
80000e50:	03712623          	sw	s7,44(sp)
80000e54:	04112623          	sw	ra,76(sp)
80000e58:	04912223          	sw	s1,68(sp)
80000e5c:	05212023          	sw	s2,64(sp)
80000e60:	03312e23          	sw	s3,60(sp)
80000e64:	03412c23          	sw	s4,56(sp)
80000e68:	03512a23          	sw	s5,52(sp)
80000e6c:	03612823          	sw	s6,48(sp)
80000e70:	03812423          	sw	s8,40(sp)
80000e74:	03912223          	sw	s9,36(sp)
80000e78:	03a12023          	sw	s10,32(sp)
80000e7c:	01b12e23          	sw	s11,28(sp)
80000e80:	05010413          	addi	s0,sp,80
	int i, from_l, alloc_l = -1;
	unsigned int key;
	void *data = NULL;
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000e84:	00a54e03          	lbu	t3,10(a0)
	 * from which we can split an allocation if needed.  Along the
	 * way, we populate an array of sizes for each level so we
	 * don't need to waste RAM storing it.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 0; i < p->n_levels; i++) {
80000e88:	00000893          	li	a7,0
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000e8c:	002e1793          	slli	a5,t3,0x2
80000e90:	00f78793          	addi	a5,a5,15
80000e94:	7f07f793          	andi	a5,a5,2032
80000e98:	40f10133          	sub	sp,sp,a5
	lsizes[0] = _ALIGN4(p->max_sz);
80000e9c:	00452783          	lw	a5,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80000ea0:	00010b93          	mv	s7,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80000ea4:	000b8313          	mv	t1,s7
80000ea8:	00378793          	addi	a5,a5,3
80000eac:	ffc7f793          	andi	a5,a5,-4
80000eb0:	00fba023          	sw	a5,0(s7)
	for (i = 0; i < p->n_levels; i++) {
80000eb4:	fff88c13          	addi	s8,a7,-1
80000eb8:	03c8d463          	bge	a7,t3,80000ee0 <z_sys_mem_pool_block_alloc+0x98>
		if (i > 0) {
80000ebc:	00088c63          	beqz	a7,80000ed4 <z_sys_mem_pool_block_alloc+0x8c>
			lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80000ec0:	ffc32783          	lw	a5,-4(t1)
80000ec4:	0027d793          	srli	a5,a5,0x2
80000ec8:	00378793          	addi	a5,a5,3
80000ecc:	ffc7f793          	andi	a5,a5,-4
80000ed0:	00f32023          	sw	a5,0(t1)
		}

		if (lsizes[i] < size) {
80000ed4:	00430313          	addi	t1,t1,4
80000ed8:	ffc32783          	lw	a5,-4(t1)
80000edc:	04b7fa63          	bgeu	a5,a1,80000f30 <z_sys_mem_pool_block_alloc+0xe8>
		}

		alloc_l = i;
	}

	if (alloc_l < 0) {
80000ee0:	fff00793          	li	a5,-1
80000ee4:	04fc1a63          	bne	s8,a5,80000f38 <z_sys_mem_pool_block_alloc+0xf0>
		*data_p = NULL;
80000ee8:	00072023          	sw	zero,0(a4)
		return -ENOMEM;
80000eec:	ff400513          	li	a0,-12

	*level_p = alloc_l;
	*block_p = block_num(p, data, lsizes[alloc_l]);

	return 0;
}
80000ef0:	fb040113          	addi	sp,s0,-80
80000ef4:	04c12083          	lw	ra,76(sp)
80000ef8:	04812403          	lw	s0,72(sp)
80000efc:	04412483          	lw	s1,68(sp)
80000f00:	04012903          	lw	s2,64(sp)
80000f04:	03c12983          	lw	s3,60(sp)
80000f08:	03812a03          	lw	s4,56(sp)
80000f0c:	03412a83          	lw	s5,52(sp)
80000f10:	03012b03          	lw	s6,48(sp)
80000f14:	02c12b83          	lw	s7,44(sp)
80000f18:	02812c03          	lw	s8,40(sp)
80000f1c:	02412c83          	lw	s9,36(sp)
80000f20:	02012d03          	lw	s10,32(sp)
80000f24:	01c12d83          	lw	s11,28(sp)
80000f28:	05010113          	addi	sp,sp,80
80000f2c:	00008067          	ret
	for (i = 0; i < p->n_levels; i++) {
80000f30:	00188893          	addi	a7,a7,1
80000f34:	f81ff06f          	j	80000eb4 <z_sys_mem_pool_block_alloc+0x6c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f38:	01054783          	lbu	a5,16(a0)
		return 0;
80000f3c:	00000913          	li	s2,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000f40:	0017f793          	andi	a5,a5,1
80000f44:	00078863          	beqz	a5,80000f54 <z_sys_mem_pool_block_alloc+0x10c>
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000f48:	00800913          	li	s2,8
80000f4c:	30093973          	csrrc	s2,mstatus,s2
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000f50:	00897913          	andi	s2,s2,8
80000f54:	00c00793          	li	a5,12
80000f58:	02fc07b3          	mul	a5,s8,a5
80000f5c:	fae42e23          	sw	a4,-68(s0)
80000f60:	00068d13          	mv	s10,a3
80000f64:	00060c93          	mv	s9,a2
80000f68:	00050493          	mv	s1,a0
	block = sys_dlist_get(&p->levels[l].free_list);
80000f6c:	000c0a13          	mv	s4,s8
80000f70:	00478713          	addi	a4,a5,4
80000f74:	00c52783          	lw	a5,12(a0)
80000f78:	00e787b3          	add	a5,a5,a4
	for (i = alloc_l; i >= 0; i--) {
80000f7c:	fff00713          	li	a4,-1
	return list->head == list;
80000f80:	0007a983          	lw	s3,0(a5)

static inline sys_dnode_t *sys_dlist_get(sys_dlist_t *list)
{
	sys_dnode_t *node = NULL;

	if (!sys_dlist_is_empty(list)) {
80000f84:	17378c63          	beq	a5,s3,800010fc <z_sys_mem_pool_block_alloc+0x2b4>
	node->prev->next = node->next;
80000f88:	0009a783          	lw	a5,0(s3)
80000f8c:	0049a703          	lw	a4,4(s3)
		data = block_alloc(p, i, lsizes[i]);
80000f90:	002a1a93          	slli	s5,s4,0x2
80000f94:	015b8ab3          	add	s5,s7,s5
80000f98:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80000f9c:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80000fa0:	0009a023          	sw	zero,0(s3)
	node->prev = NULL;
80000fa4:	0009a223          	sw	zero,4(s3)
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000fa8:	0004a783          	lw	a5,0(s1)
		data = block_alloc(p, i, lsizes[i]);
80000fac:	000aa603          	lw	a2,0(s5)
		clear_free_bit(p, l, block_num(p, block, lsz));
80000fb0:	000a0593          	mv	a1,s4
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000fb4:	40f987b3          	sub	a5,s3,a5
		clear_free_bit(p, l, block_num(p, block, lsz));
80000fb8:	02c7c633          	div	a2,a5,a2
80000fbc:	00048513          	mv	a0,s1
80000fc0:	001a0a13          	addi	s4,s4,1
80000fc4:	d4dff0ef          	jal	ra,80000d10 <clear_free_bit>
		if (data != NULL) {
80000fc8:	00c00693          	li	a3,12
			for (from_l = i; from_l < alloc_l; from_l++) {
80000fcc:	fffa0793          	addi	a5,s4,-1
80000fd0:	0587c663          	blt	a5,s8,8000101c <z_sys_mem_pool_block_alloc+0x1d4>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80000fd4:	0104c783          	lbu	a5,16(s1)
80000fd8:	0017f793          	andi	a5,a5,1
80000fdc:	00078463          	beqz	a5,80000fe4 <z_sys_mem_pool_block_alloc+0x19c>
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000fe0:	30092973          	csrrs	s2,mstatus,s2
	*data_p = data;
80000fe4:	fbc42783          	lw	a5,-68(s0)
		return -ENOMEM;
80000fe8:	ff400513          	li	a0,-12
	*data_p = data;
80000fec:	0137a023          	sw	s3,0(a5)
	if (data == NULL) {
80000ff0:	f00980e3          	beqz	s3,80000ef0 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80000ff4:	0004a783          	lw	a5,0(s1)
	*block_p = block_num(p, data, lsizes[alloc_l]);
80000ff8:	002c1813          	slli	a6,s8,0x2
80000ffc:	010b8bb3          	add	s7,s7,a6
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001000:	40f989b3          	sub	s3,s3,a5
80001004:	000ba783          	lw	a5,0(s7)
	*level_p = alloc_l;
80001008:	018ca023          	sw	s8,0(s9)
	return 0;
8000100c:	00000513          	li	a0,0
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001010:	02f9c9b3          	div	s3,s3,a5
	*block_p = block_num(p, data, lsizes[alloc_l]);
80001014:	013d2023          	sw	s3,0(s10)
	return 0;
80001018:	ed9ff06f          	j	80000ef0 <z_sys_mem_pool_block_alloc+0xa8>
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
8000101c:	0004ad83          	lw	s11,0(s1)
80001020:	000aa783          	lw	a5,0(s5)
80001024:	02da0eb3          	mul	t4,s4,a3
80001028:	41b98db3          	sub	s11,s3,s11
	for (i = 1; i < 4; i++) {
8000102c:	00100713          	li	a4,1
	return ((u8_t *)block - (u8_t *)p->buf) / sz;
80001030:	02fdcdb3          	div	s11,s11,a5
		int lbn = 4*bn + i;
80001034:	002d9d93          	slli	s11,s11,0x2
		int lsz = lsizes[l + 1];
80001038:	004aab03          	lw	s6,4(s5)
		set_free_bit(p, l + 1, lbn);
8000103c:	01b70633          	add	a2,a4,s11
80001040:	000a0593          	mv	a1,s4
		void *block2 = (lsz * i) + (char *)block;
80001044:	02eb0e33          	mul	t3,s6,a4
		set_free_bit(p, l + 1, lbn);
80001048:	00048513          	mv	a0,s1
8000104c:	fbd42823          	sw	t4,-80(s0)
80001050:	fae42c23          	sw	a4,-72(s0)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001054:	fffb0b13          	addi	s6,s6,-1
		void *block2 = (lsz * i) + (char *)block;
80001058:	01c98e33          	add	t3,s3,t3
8000105c:	fbc42a23          	sw	t3,-76(s0)
		set_free_bit(p, l + 1, lbn);
80001060:	c7dff0ef          	jal	ra,80000cdc <set_free_bit>
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001064:	fb442e03          	lw	t3,-76(s0)
80001068:	0004a783          	lw	a5,0(s1)
	return p->n_max * p->max_sz;
8000106c:	0044a603          	lw	a2,4(s1)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001070:	016e0b33          	add	s6,t3,s6
80001074:	40fb0b33          	sub	s6,s6,a5
	return p->n_max * p->max_sz;
80001078:	0084d783          	lhu	a5,8(s1)
		if (block_fits(p, block2, lsz)) {
8000107c:	fb842703          	lw	a4,-72(s0)
80001080:	fb042e83          	lw	t4,-80(s0)
	return p->n_max * p->max_sz;
80001084:	02c787b3          	mul	a5,a5,a2
		if (block_fits(p, block2, lsz)) {
80001088:	00c00693          	li	a3,12
8000108c:	00400893          	li	a7,4
80001090:	00800313          	li	t1,8
80001094:	02fb7463          	bgeu	s6,a5,800010bc <z_sys_mem_pool_block_alloc+0x274>
			sys_dlist_append(&p->levels[l + 1].free_list, block2);
80001098:	00c4a783          	lw	a5,12(s1)
8000109c:	01d787b3          	add	a5,a5,t4
800010a0:	00478613          	addi	a2,a5,4
	node->next = list;
800010a4:	00ce2023          	sw	a2,0(t3)
	node->prev = list->tail;
800010a8:	0087a603          	lw	a2,8(a5)
800010ac:	00ce2223          	sw	a2,4(t3)
	list->tail->next = node;
800010b0:	0087a603          	lw	a2,8(a5)
800010b4:	01c62023          	sw	t3,0(a2)
	list->tail = node;
800010b8:	01c7a423          	sw	t3,8(a5)
	for (i = 1; i < 4; i++) {
800010bc:	00170713          	addi	a4,a4,1
800010c0:	f7171ce3          	bne	a4,a7,80001038 <z_sys_mem_pool_block_alloc+0x1f0>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800010c4:	0104c783          	lbu	a5,16(s1)
800010c8:	0017f793          	andi	a5,a5,1
800010cc:	00079a63          	bnez	a5,800010e0 <z_sys_mem_pool_block_alloc+0x298>
		return 0;
800010d0:	00000913          	li	s2,0
800010d4:	001a0a13          	addi	s4,s4,1
800010d8:	004a8a93          	addi	s5,s5,4
800010dc:	ef1ff06f          	j	80000fcc <z_sys_mem_pool_block_alloc+0x184>
800010e0:	30092973          	csrrs	s2,mstatus,s2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800010e4:	0104c783          	lbu	a5,16(s1)
800010e8:	0017f793          	andi	a5,a5,1
800010ec:	fe0782e3          	beqz	a5,800010d0 <z_sys_mem_pool_block_alloc+0x288>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800010f0:	30033973          	csrrc	s2,mstatus,t1
	key = (mstatus & SOC_MSTATUS_IEN);
800010f4:	00897913          	andi	s2,s2,8
800010f8:	fddff06f          	j	800010d4 <z_sys_mem_pool_block_alloc+0x28c>
	for (i = alloc_l; i >= 0; i--) {
800010fc:	fffa0a13          	addi	s4,s4,-1
80001100:	ff498793          	addi	a5,s3,-12
80001104:	e6ea1ee3          	bne	s4,a4,80000f80 <z_sys_mem_pool_block_alloc+0x138>
80001108:	00000993          	li	s3,0
8000110c:	ec9ff06f          	j	80000fd4 <z_sys_mem_pool_block_alloc+0x18c>

80001110 <z_sys_mem_pool_block_free>:

void z_sys_mem_pool_block_free(struct sys_mem_pool_base *p, u32_t level,
			      u32_t block)
{
80001110:	fa010113          	addi	sp,sp,-96
80001114:	04812c23          	sw	s0,88(sp)
80001118:	05312623          	sw	s3,76(sp)
8000111c:	03712e23          	sw	s7,60(sp)
80001120:	04112e23          	sw	ra,92(sp)
80001124:	04912a23          	sw	s1,84(sp)
80001128:	05212823          	sw	s2,80(sp)
8000112c:	05412423          	sw	s4,72(sp)
80001130:	05512223          	sw	s5,68(sp)
80001134:	05612023          	sw	s6,64(sp)
80001138:	03812c23          	sw	s8,56(sp)
8000113c:	03912a23          	sw	s9,52(sp)
80001140:	03a12823          	sw	s10,48(sp)
80001144:	03b12623          	sw	s11,44(sp)
80001148:	06010413          	addi	s0,sp,96
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000114c:	00a54683          	lbu	a3,10(a0)
{
80001150:	00050b93          	mv	s7,a0
	 * Overhead here is somewhat higher because block_free()
	 * doesn't inherently need to traverse all the larger
	 * sublevels.
	 */
	lsizes[0] = _ALIGN4(p->max_sz);
	for (i = 1; i <= level; i++) {
80001154:	00100813          	li	a6,1
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
80001158:	00269693          	slli	a3,a3,0x2
8000115c:	00f68693          	addi	a3,a3,15
80001160:	7f06f693          	andi	a3,a3,2032
80001164:	40d10133          	sub	sp,sp,a3
	lsizes[0] = _ALIGN4(p->max_sz);
80001168:	00452683          	lw	a3,4(a0)
	size_t lsizes[LVL_ARRAY_SZ(p->n_levels)];
8000116c:	00010993          	mv	s3,sp
	lsizes[0] = _ALIGN4(p->max_sz);
80001170:	00098513          	mv	a0,s3
80001174:	00368693          	addi	a3,a3,3
80001178:	ffc6f693          	andi	a3,a3,-4
8000117c:	00d9a023          	sw	a3,0(s3)
	for (i = 1; i <= level; i++) {
80001180:	00450513          	addi	a0,a0,4
80001184:	0d05f463          	bgeu	a1,a6,8000124c <z_sys_mem_pool_block_free+0x13c>
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001188:	010bc683          	lbu	a3,16(s7)
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
	}

	block_free(p, level, lsizes, block);
8000118c:	00058c13          	mv	s8,a1
80001190:	00060913          	mv	s2,a2
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001194:	0016f693          	andi	a3,a3,1
		return 0;
80001198:	00000493          	li	s1,0
	if (p->flags & SYS_MEM_POOL_KERNEL) {
8000119c:	00068863          	beqz	a3,800011ac <z_sys_mem_pool_block_free+0x9c>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800011a0:	00800493          	li	s1,8
800011a4:	3004b4f3          	csrrc	s1,mstatus,s1
	key = (mstatus & SOC_MSTATUS_IEN);
800011a8:	0084f493          	andi	s1,s1,8
		__ASSERT(block_fits(p, block, lsz), "");
800011ac:	80005ab7          	lui	s5,0x80005
		sys_dlist_append(&p->levels[level].free_list, block);
800011b0:	00c00d13          	li	s10,12
	__asm__ volatile ("csrrc %0, mstatus, %1"
800011b4:	00800d93          	li	s11,8
	while (level >= 0) {
800011b8:	0a0c5863          	bgez	s8,80001268 <z_sys_mem_pool_block_free+0x158>
	__ASSERT(0, "out of levels");
800011bc:	800054b7          	lui	s1,0x80005
800011c0:	800055b7          	lui	a1,0x80005
800011c4:	80005537          	lui	a0,0x80005
800011c8:	73c48613          	addi	a2,s1,1852 # 8000573c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000573d>
800011cc:	0c000693          	li	a3,192
800011d0:	7a458593          	addi	a1,a1,1956 # 800057a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057a5>
800011d4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800011d8:	06d000ef          	jal	ra,80001a44 <printk>
800011dc:	80005537          	lui	a0,0x80005
800011e0:	77050513          	addi	a0,a0,1904 # 80005770 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005771>
800011e4:	061000ef          	jal	ra,80001a44 <printk>
800011e8:	73c48513          	addi	a0,s1,1852
800011ec:	0c000593          	li	a1,192
800011f0:	091000ef          	jal	ra,80001a80 <assert_post_action>
	return -1;
800011f4:	fff00493          	li	s1,-1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800011f8:	010bc783          	lbu	a5,16(s7)
800011fc:	0017f793          	andi	a5,a5,1
80001200:	00078663          	beqz	a5,8000120c <z_sys_mem_pool_block_free+0xfc>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80001204:	0084f493          	andi	s1,s1,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001208:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000120c:	fa040113          	addi	sp,s0,-96
80001210:	05c12083          	lw	ra,92(sp)
80001214:	05812403          	lw	s0,88(sp)
80001218:	05412483          	lw	s1,84(sp)
8000121c:	05012903          	lw	s2,80(sp)
80001220:	04c12983          	lw	s3,76(sp)
80001224:	04812a03          	lw	s4,72(sp)
80001228:	04412a83          	lw	s5,68(sp)
8000122c:	04012b03          	lw	s6,64(sp)
80001230:	03c12b83          	lw	s7,60(sp)
80001234:	03812c03          	lw	s8,56(sp)
80001238:	03412c83          	lw	s9,52(sp)
8000123c:	03012d03          	lw	s10,48(sp)
80001240:	02c12d83          	lw	s11,44(sp)
80001244:	06010113          	addi	sp,sp,96
80001248:	00008067          	ret
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
8000124c:	ffc52683          	lw	a3,-4(a0)
	for (i = 1; i <= level; i++) {
80001250:	00180813          	addi	a6,a6,1
		lsizes[i] = _ALIGN4(lsizes[i-1] / 4);
80001254:	0026d693          	srli	a3,a3,0x2
80001258:	00368693          	addi	a3,a3,3
8000125c:	ffc6f693          	andi	a3,a3,-4
80001260:	00d52023          	sw	a3,0(a0)
80001264:	f1dff06f          	j	80001180 <z_sys_mem_pool_block_free+0x70>
		int i, lsz = lsizes[level];
80001268:	002c1693          	slli	a3,s8,0x2
8000126c:	00d986b3          	add	a3,s3,a3
80001270:	0006aa03          	lw	s4,0(a3)
	return p->n_max * p->max_sz;
80001274:	008bd603          	lhu	a2,8(s7)
80001278:	004ba583          	lw	a1,4(s7)
	return (u8_t *)p->buf + lsz * block;
8000127c:	034906b3          	mul	a3,s2,s4
		void *block = block_ptr(p, lsz, bn);
80001280:	000ba803          	lw	a6,0(s7)
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
80001284:	fffa0b13          	addi	s6,s4,-1
	return p->n_max * p->max_sz;
80001288:	02b60633          	mul	a2,a2,a1
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
8000128c:	00d80cb3          	add	s9,a6,a3
80001290:	00db06b3          	add	a3,s6,a3
		__ASSERT(block_fits(p, block, lsz), "");
80001294:	02c6ec63          	bltu	a3,a2,800012cc <z_sys_mem_pool_block_free+0x1bc>
80001298:	800057b7          	lui	a5,0x80005
8000129c:	75078593          	addi	a1,a5,1872 # 80005750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005751>
800012a0:	800057b7          	lui	a5,0x80005
800012a4:	6e878513          	addi	a0,a5,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800012a8:	0a400693          	li	a3,164
800012ac:	73ca8613          	addi	a2,s5,1852 # 8000573c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000573d>
800012b0:	794000ef          	jal	ra,80001a44 <printk>
800012b4:	800057b7          	lui	a5,0x80005
800012b8:	76c78513          	addi	a0,a5,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
800012bc:	788000ef          	jal	ra,80001a44 <printk>
800012c0:	0a400593          	li	a1,164
800012c4:	73ca8513          	addi	a0,s5,1852
800012c8:	7b8000ef          	jal	ra,80001a80 <assert_post_action>
		set_free_bit(p, level, bn);
800012cc:	00090613          	mv	a2,s2
800012d0:	000c0593          	mv	a1,s8
800012d4:	000b8513          	mv	a0,s7
800012d8:	a05ff0ef          	jal	ra,80000cdc <set_free_bit>
		sys_dlist_append(&p->levels[level].free_list, block);
800012dc:	03ac06b3          	mul	a3,s8,s10
800012e0:	00cba603          	lw	a2,12(s7)
800012e4:	00d606b3          	add	a3,a2,a3
800012e8:	00468613          	addi	a2,a3,4
	node->next = list;
800012ec:	00cca023          	sw	a2,0(s9)
	node->prev = list->tail;
800012f0:	0086a603          	lw	a2,8(a3)
800012f4:	00cca223          	sw	a2,4(s9)
	list->tail->next = node;
800012f8:	0086a603          	lw	a2,8(a3)
800012fc:	01962023          	sw	s9,0(a2)
	list->tail = node;
80001300:	0196a423          	sw	s9,8(a3)
	if (p->flags & SYS_MEM_POOL_KERNEL) {
80001304:	010bc683          	lbu	a3,16(s7)
80001308:	0016f693          	andi	a3,a3,1
8000130c:	0c069463          	bnez	a3,800013d4 <z_sys_mem_pool_block_free+0x2c4>
		return 0;
80001310:	00000493          	li	s1,0
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001314:	ee0c02e3          	beqz	s8,800011f8 <z_sys_mem_pool_block_free+0xe8>
	int bit = get_bit_ptr(p, level, bn, &word);
80001318:	fbc40693          	addi	a3,s0,-68
8000131c:	00090613          	mv	a2,s2
80001320:	000c0593          	mv	a1,s8
80001324:	000b8513          	mv	a0,s7
80001328:	97dff0ef          	jal	ra,80000ca4 <get_bit_ptr>
	return (*word >> (4*(bit / 4))) & 0xf;
8000132c:	00400693          	li	a3,4
80001330:	02d546b3          	div	a3,a0,a3
80001334:	fbc42603          	lw	a2,-68(s0)
80001338:	00062503          	lw	a0,0(a2)
8000133c:	00269693          	slli	a3,a3,0x2
80001340:	00d55533          	srl	a0,a0,a3
80001344:	00f57513          	andi	a0,a0,15
		if (level == 0 || partner_bits(p, level, bn) != 0xf) {
80001348:	00f00693          	li	a3,15
8000134c:	ead516e3          	bne	a0,a3,800011f8 <z_sys_mem_pool_block_free+0xe8>
		for (i = 0; i < 4; i++) {
80001350:	00000813          	li	a6,0
			int b = (bn & ~3) + i;
80001354:	ffc97e13          	andi	t3,s2,-4
		for (i = 0; i < 4; i++) {
80001358:	00400313          	li	t1,4
	return p->n_max * p->max_sz;
8000135c:	008bd583          	lhu	a1,8(s7)
80001360:	004ba503          	lw	a0,4(s7)
			int b = (bn & ~3) + i;
80001364:	010e0633          	add	a2,t3,a6
	return (u8_t *)p->buf + lsz * block;
80001368:	034608b3          	mul	a7,a2,s4
	return p->n_max * p->max_sz;
8000136c:	02a585b3          	mul	a1,a1,a0
			if (block_fits(p, block_ptr(p, lsz, b), lsz)) {
80001370:	016886b3          	add	a3,a7,s6
80001374:	04b6f663          	bgeu	a3,a1,800013c0 <z_sys_mem_pool_block_free+0x2b0>
				clear_free_bit(p, level, b);
80001378:	000c0593          	mv	a1,s8
8000137c:	000b8513          	mv	a0,s7
80001380:	fbc42223          	sw	t3,-92(s0)
80001384:	fb042423          	sw	a6,-88(s0)
80001388:	fb142623          	sw	a7,-84(s0)
8000138c:	985ff0ef          	jal	ra,80000d10 <clear_free_bit>
	return (u8_t *)p->buf + lsz * block;
80001390:	000ba683          	lw	a3,0(s7)
80001394:	fac42883          	lw	a7,-84(s0)
	node->prev = NULL;
80001398:	fa442e03          	lw	t3,-92(s0)
8000139c:	fa842803          	lw	a6,-88(s0)
800013a0:	011686b3          	add	a3,a3,a7
	node->prev->next = node->next;
800013a4:	0046a583          	lw	a1,4(a3)
800013a8:	0006a603          	lw	a2,0(a3)
	node->prev = NULL;
800013ac:	00400313          	li	t1,4
	node->prev->next = node->next;
800013b0:	00c5a023          	sw	a2,0(a1)
	node->next->prev = node->prev;
800013b4:	00b62223          	sw	a1,4(a2)
	node->next = NULL;
800013b8:	0006a023          	sw	zero,0(a3)
	node->prev = NULL;
800013bc:	0006a223          	sw	zero,4(a3)
		for (i = 0; i < 4; i++) {
800013c0:	00180813          	addi	a6,a6,1
800013c4:	f8681ce3          	bne	a6,t1,8000135c <z_sys_mem_pool_block_free+0x24c>
		level = level - 1;
800013c8:	fffc0c13          	addi	s8,s8,-1
		bn = bn / 4;
800013cc:	03094933          	div	s2,s2,a6
800013d0:	de9ff06f          	j	800011b8 <z_sys_mem_pool_block_free+0xa8>
800013d4:	3004a4f3          	csrrs	s1,mstatus,s1
	if (p->flags & SYS_MEM_POOL_KERNEL) {
800013d8:	010bc683          	lbu	a3,16(s7)
800013dc:	0016f693          	andi	a3,a3,1
800013e0:	f20688e3          	beqz	a3,80001310 <z_sys_mem_pool_block_free+0x200>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800013e4:	300db4f3          	csrrc	s1,mstatus,s11
	key = (mstatus & SOC_MSTATUS_IEN);
800013e8:	0084f493          	andi	s1,s1,8
800013ec:	f29ff06f          	j	80001314 <z_sys_mem_pool_block_free+0x204>

800013f0 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
800013f0:	ff010113          	addi	sp,sp,-16
800013f4:	00050793          	mv	a5,a0
800013f8:	00058513          	mv	a0,a1
800013fc:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001400:	00068613          	mv	a2,a3
{
80001404:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001408:	000780e7          	jalr	a5
8000140c:	139020ef          	jal	ra,80003d44 <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001410:	12c030ef          	jal	ra,8000453c <z_impl_k_thread_abort>

80001414 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001414:	00000513          	li	a0,0
80001418:	00008067          	ret

8000141c <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
8000141c:	ff010113          	addi	sp,sp,-16
80001420:	00812423          	sw	s0,8(sp)
80001424:	00050413          	mv	s0,a0
	out('E', ctx);
80001428:	04500513          	li	a0,69
{
8000142c:	00112623          	sw	ra,12(sp)
80001430:	00912223          	sw	s1,4(sp)
80001434:	00058493          	mv	s1,a1
	out('E', ctx);
80001438:	000400e7          	jalr	s0
	out('R', ctx);
8000143c:	00048593          	mv	a1,s1
80001440:	05200513          	li	a0,82
80001444:	000400e7          	jalr	s0
	out('R', ctx);
80001448:	00040313          	mv	t1,s0
}
8000144c:	00812403          	lw	s0,8(sp)
80001450:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001454:	00048593          	mv	a1,s1
}
80001458:	00412483          	lw	s1,4(sp)
	out('R', ctx);
8000145c:	05200513          	li	a0,82
}
80001460:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001464:	00030067          	jr	t1

80001468 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001468:	0005a783          	lw	a5,0(a1)
8000146c:	00178793          	addi	a5,a5,1
80001470:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001474:	800067b7          	lui	a5,0x80006
80001478:	c847a303          	lw	t1,-892(a5) # 80005c84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c85>
8000147c:	00030067          	jr	t1

80001480 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001480:	fb010113          	addi	sp,sp,-80
80001484:	04812423          	sw	s0,72(sp)
80001488:	03312e23          	sw	s3,60(sp)
8000148c:	03412c23          	sw	s4,56(sp)
80001490:	03512a23          	sw	s5,52(sp)
80001494:	03612823          	sw	s6,48(sp)
80001498:	04112623          	sw	ra,76(sp)
8000149c:	04912223          	sw	s1,68(sp)
800014a0:	05212023          	sw	s2,64(sp)
800014a4:	03712623          	sw	s7,44(sp)
800014a8:	03812423          	sw	s8,40(sp)
800014ac:	03912223          	sw	s9,36(sp)
800014b0:	03a12023          	sw	s10,32(sp)
800014b4:	01b12e23          	sw	s11,28(sp)
800014b8:	00050a13          	mv	s4,a0
800014bc:	00058a93          	mv	s5,a1
800014c0:	00060993          	mv	s3,a2
800014c4:	00068b13          	mv	s6,a3
800014c8:	00100413          	li	s0,1
800014cc:	00e05463          	blez	a4,800014d4 <_printk_dec_ulong+0x54>
800014d0:	00070413          	mv	s0,a4
800014d4:	00100793          	li	a5,1
800014d8:	02000c13          	li	s8,32
800014dc:	00fb1463          	bne	s6,a5,800014e4 <_printk_dec_ulong+0x64>
800014e0:	03000c13          	li	s8,48
800014e4:	3b9ad4b7          	lui	s1,0x3b9ad
800014e8:	00100913          	li	s2,1
800014ec:	00a00c93          	li	s9,10
800014f0:	00000713          	li	a4,0
800014f4:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
800014f8:	00200d93          	li	s11,2
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
		pos /= 10;
800014fc:	00a00d13          	li	s10,10
		if (found_largest_digit != 0 || remainder > pos) {
80001500:	00148b93          	addi	s7,s1,1
80001504:	00071463          	bnez	a4,8000150c <_printk_dec_ulong+0x8c>
80001508:	0934f263          	bgeu	s1,s3,8000158c <_printk_dec_ulong+0x10c>
			out((int)((remainder / (pos + 1)) + 48), ctx);
8000150c:	0379d533          	divu	a0,s3,s7
80001510:	000a8593          	mv	a1,s5
			digits++;
80001514:	00190913          	addi	s2,s2,1
			out((int)((remainder / (pos + 1)) + 48), ctx);
80001518:	03050513          	addi	a0,a0,48
8000151c:	000a00e7          	jalr	s4
			found_largest_digit = 1;
80001520:	00100713          	li	a4,1
		remaining--;
80001524:	fffc8c93          	addi	s9,s9,-1
	while (pos >= 9) {
80001528:	00100793          	li	a5,1
		remainder %= (pos + 1);
8000152c:	0379f9b3          	remu	s3,s3,s7
		pos /= 10;
80001530:	03a4d4b3          	divu	s1,s1,s10
	while (pos >= 9) {
80001534:	fcfc96e3          	bne	s9,a5,80001500 <_printk_dec_ulong+0x80>
	}
	out((int)(remainder + 48), ctx);
80001538:	000a8593          	mv	a1,s5
8000153c:	03098513          	addi	a0,s3,48
80001540:	000a00e7          	jalr	s4

	if (padding == PAD_SPACE_AFTER) {
80001544:	00300793          	li	a5,3
		remaining = min_width - digits;
80001548:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
8000154c:	06fb0a63          	beq	s6,a5,800015c0 <_printk_dec_ulong+0x140>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
80001550:	04c12083          	lw	ra,76(sp)
80001554:	04812403          	lw	s0,72(sp)
80001558:	04412483          	lw	s1,68(sp)
8000155c:	04012903          	lw	s2,64(sp)
80001560:	03c12983          	lw	s3,60(sp)
80001564:	03812a03          	lw	s4,56(sp)
80001568:	03412a83          	lw	s5,52(sp)
8000156c:	03012b03          	lw	s6,48(sp)
80001570:	02c12b83          	lw	s7,44(sp)
80001574:	02812c03          	lw	s8,40(sp)
80001578:	02412c83          	lw	s9,36(sp)
8000157c:	02012d03          	lw	s10,32(sp)
80001580:	01c12d83          	lw	s11,28(sp)
80001584:	05010113          	addi	sp,sp,80
80001588:	00008067          	ret
		} else if (remaining <= min_width
8000158c:	f9944ce3          	blt	s0,s9,80001524 <_printk_dec_ulong+0xa4>
				&& padding < PAD_SPACE_AFTER) {
80001590:	f96deae3          	bltu	s11,s6,80001524 <_printk_dec_ulong+0xa4>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001594:	000a8593          	mv	a1,s5
80001598:	000c0513          	mv	a0,s8
8000159c:	00e12623          	sw	a4,12(sp)
800015a0:	000a00e7          	jalr	s4
			digits++;
800015a4:	00190913          	addi	s2,s2,1
800015a8:	00c12703          	lw	a4,12(sp)
800015ac:	f79ff06f          	j	80001524 <_printk_dec_ulong+0xa4>
			out(' ', ctx);
800015b0:	000a8593          	mv	a1,s5
800015b4:	02000513          	li	a0,32
800015b8:	000a00e7          	jalr	s4
800015bc:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
800015c0:	fe8048e3          	bgtz	s0,800015b0 <_printk_dec_ulong+0x130>
800015c4:	f8dff06f          	j	80001550 <_printk_dec_ulong+0xd0>

800015c8 <__printk_hook_install>:
	_char_out = fn;
800015c8:	800067b7          	lui	a5,0x80006
800015cc:	c8a7a223          	sw	a0,-892(a5) # 80005c84 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c85>
}
800015d0:	00008067          	ret

800015d4 <z_vprintk>:
{
800015d4:	fb010113          	addi	sp,sp,-80
800015d8:	04812423          	sw	s0,72(sp)
800015dc:	04912223          	sw	s1,68(sp)
800015e0:	05212023          	sw	s2,64(sp)
800015e4:	03312e23          	sw	s3,60(sp)
800015e8:	03412c23          	sw	s4,56(sp)
800015ec:	03512a23          	sw	s5,52(sp)
800015f0:	03912223          	sw	s9,36(sp)
800015f4:	03a12023          	sw	s10,32(sp)
800015f8:	01b12e23          	sw	s11,28(sp)
800015fc:	04112623          	sw	ra,76(sp)
80001600:	03612823          	sw	s6,48(sp)
80001604:	03712623          	sw	s7,44(sp)
80001608:	03812423          	sw	s8,40(sp)
8000160c:	00050413          	mv	s0,a0
80001610:	00058493          	mv	s1,a1
80001614:	00060a93          	mv	s5,a2
80001618:	00068d13          	mv	s10,a3
	int long_ctr = 0;
8000161c:	00000a13          	li	s4,0
	int min_width = -1;
80001620:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
80001624:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001628:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
8000162c:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001630:	000ac503          	lbu	a0,0(s5)
80001634:	04051063          	bnez	a0,80001674 <z_vprintk+0xa0>
}
80001638:	04c12083          	lw	ra,76(sp)
8000163c:	04812403          	lw	s0,72(sp)
80001640:	04412483          	lw	s1,68(sp)
80001644:	04012903          	lw	s2,64(sp)
80001648:	03c12983          	lw	s3,60(sp)
8000164c:	03812a03          	lw	s4,56(sp)
80001650:	03412a83          	lw	s5,52(sp)
80001654:	03012b03          	lw	s6,48(sp)
80001658:	02c12b83          	lw	s7,44(sp)
8000165c:	02812c03          	lw	s8,40(sp)
80001660:	02412c83          	lw	s9,36(sp)
80001664:	02012d03          	lw	s10,32(sp)
80001668:	01c12d83          	lw	s11,28(sp)
8000166c:	05010113          	addi	sp,sp,80
80001670:	00008067          	ret
		if (!might_format) {
80001674:	000c9e63          	bnez	s9,80001690 <z_vprintk+0xbc>
			if (*fmt != '%') {
80001678:	02500693          	li	a3,37
8000167c:	36d50a63          	beq	a0,a3,800019f0 <z_vprintk+0x41c>
				out((int)*fmt, ctx);
80001680:	00048593          	mv	a1,s1
80001684:	000400e7          	jalr	s0
		++fmt;
80001688:	001a8a93          	addi	s5,s5,1
8000168c:	fa5ff06f          	j	80001630 <z_vprintk+0x5c>
			switch (*fmt) {
80001690:	06400693          	li	a3,100
80001694:	10d50e63          	beq	a0,a3,800017b0 <z_vprintk+0x1dc>
80001698:	06a6e263          	bltu	a3,a0,800016fc <z_vprintk+0x128>
8000169c:	03900693          	li	a3,57
800016a0:	02a6ea63          	bltu	a3,a0,800016d4 <z_vprintk+0x100>
800016a4:	03100693          	li	a3,49
800016a8:	0ed57463          	bgeu	a0,a3,80001790 <z_vprintk+0x1bc>
800016ac:	02d00693          	li	a3,45
800016b0:	34d50a63          	beq	a0,a3,80001a04 <z_vprintk+0x430>
800016b4:	03000793          	li	a5,48
800016b8:	0cf50063          	beq	a0,a5,80001778 <z_vprintk+0x1a4>
800016bc:	02500713          	li	a4,37
800016c0:	02e51263          	bne	a0,a4,800016e4 <z_vprintk+0x110>
				out((int)'%', ctx);
800016c4:	00048593          	mv	a1,s1
800016c8:	02500513          	li	a0,37
				out((int)*fmt, ctx);
800016cc:	000400e7          	jalr	s0
				break;
800016d0:	15c0006f          	j	8000182c <z_vprintk+0x258>
800016d4:	05800693          	li	a3,88
800016d8:	1ad50e63          	beq	a0,a3,80001894 <z_vprintk+0x2c0>
800016dc:	06300713          	li	a4,99
800016e0:	2ee50e63          	beq	a0,a4,800019dc <z_vprintk+0x408>
				out((int)'%', ctx);
800016e4:	00048593          	mv	a1,s1
800016e8:	02500513          	li	a0,37
800016ec:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
800016f0:	00048593          	mv	a1,s1
800016f4:	000ac503          	lbu	a0,0(s5)
800016f8:	fd5ff06f          	j	800016cc <z_vprintk+0xf8>
800016fc:	07000693          	li	a3,112
80001700:	16d50a63          	beq	a0,a3,80001874 <z_vprintk+0x2a0>
80001704:	02a6e063          	bltu	a3,a0,80001724 <z_vprintk+0x150>
80001708:	06900693          	li	a3,105
8000170c:	0ad50263          	beq	a0,a3,800017b0 <z_vprintk+0x1dc>
80001710:	06c00693          	li	a3,108
80001714:	08d50a63          	beq	a0,a3,800017a8 <z_vprintk+0x1d4>
80001718:	06800693          	li	a3,104
8000171c:	f6d506e3          	beq	a0,a3,80001688 <z_vprintk+0xb4>
80001720:	fc5ff06f          	j	800016e4 <z_vprintk+0x110>
80001724:	07500693          	li	a3,117
80001728:	10d50663          	beq	a0,a3,80001834 <z_vprintk+0x260>
8000172c:	02a6ee63          	bltu	a3,a0,80001768 <z_vprintk+0x194>
80001730:	07300713          	li	a4,115
80001734:	fae518e3          	bne	a0,a4,800016e4 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
80001738:	000d2c03          	lw	s8,0(s10)
8000173c:	004d0b13          	addi	s6,s10,4
80001740:	000c0b93          	mv	s7,s8
				while (*s)
80001744:	000bc503          	lbu	a0,0(s7)
80001748:	26051863          	bnez	a0,800019b8 <z_vprintk+0x3e4>
				if (padding == PAD_SPACE_AFTER) {
8000174c:	00300793          	li	a5,3
80001750:	00f99863          	bne	s3,a5,80001760 <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
80001754:	418b8bb3          	sub	s7,s7,s8
80001758:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
8000175c:	27704663          	bgtz	s7,800019c8 <z_vprintk+0x3f4>
				char *s = va_arg(ap, char *);
80001760:	000b0d13          	mv	s10,s6
80001764:	0c80006f          	j	8000182c <z_vprintk+0x258>
80001768:	07800693          	li	a3,120
8000176c:	12d50463          	beq	a0,a3,80001894 <z_vprintk+0x2c0>
80001770:	07a00693          	li	a3,122
80001774:	fa9ff06f          	j	8000171c <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80001778:	00095e63          	bgez	s2,80001794 <z_vprintk+0x1c0>
8000177c:	28098863          	beqz	s3,80001a0c <z_vprintk+0x438>
					min_width = *fmt - '0';
80001780:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001784:	f00992e3          	bnez	s3,80001688 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80001788:	00200993          	li	s3,2
8000178c:	efdff06f          	j	80001688 <z_vprintk+0xb4>
				if (min_width < 0) {
80001790:	fe0948e3          	bltz	s2,80001780 <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80001794:	00a00693          	li	a3,10
80001798:	02d90933          	mul	s2,s2,a3
8000179c:	fd090913          	addi	s2,s2,-48
800017a0:	01250933          	add	s2,a0,s2
800017a4:	fe1ff06f          	j	80001784 <z_vprintk+0x1b0>
				long_ctr++;
800017a8:	001a0a13          	addi	s4,s4,1
800017ac:	eddff06f          	j	80001688 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800017b0:	040a1263          	bnez	s4,800017f4 <z_vprintk+0x220>
					long ld = va_arg(ap, long);
800017b4:	000d2603          	lw	a2,0(s10)
800017b8:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
800017bc:	02065063          	bgez	a2,800017dc <z_vprintk+0x208>
					out((int)'-', ctx);
800017c0:	00048593          	mv	a1,s1
800017c4:	02d00513          	li	a0,45
800017c8:	00c12023          	sw	a2,0(sp)
800017cc:	000400e7          	jalr	s0
					d = -d;
800017d0:	00012603          	lw	a2,0(sp)
					min_width--;
800017d4:	fff90913          	addi	s2,s2,-1
					d = -d;
800017d8:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
800017dc:	00090713          	mv	a4,s2
800017e0:	00098693          	mv	a3,s3
800017e4:	00048593          	mv	a1,s1
800017e8:	00040513          	mv	a0,s0
800017ec:	c95ff0ef          	jal	ra,80001480 <_printk_dec_ulong>
				break;
800017f0:	03c0006f          	j	8000182c <z_vprintk+0x258>
				} else if (long_ctr == 1) {
800017f4:	00100713          	li	a4,1
800017f8:	faea0ee3          	beq	s4,a4,800017b4 <z_vprintk+0x1e0>
					long long lld = va_arg(ap, long long);
800017fc:	007d0793          	addi	a5,s10,7
80001800:	ff87f713          	andi	a4,a5,-8
80001804:	00072603          	lw	a2,0(a4)
80001808:	00472683          	lw	a3,4(a4)
8000180c:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
80001810:	01b60733          	add	a4,a2,s11
80001814:	00c73733          	sltu	a4,a4,a2
80001818:	00d70733          	add	a4,a4,a3
8000181c:	fa0700e3          	beqz	a4,800017bc <z_vprintk+0x1e8>
						print_err(out, ctx);
80001820:	00048593          	mv	a1,s1
80001824:	00040513          	mv	a0,s0
80001828:	bf5ff0ef          	jal	ra,8000141c <print_err>
			might_format = 0;
8000182c:	00000c93          	li	s9,0
80001830:	e59ff06f          	j	80001688 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80001834:	000a1863          	bnez	s4,80001844 <z_vprintk+0x270>
					long lu = va_arg(ap, unsigned long);
80001838:	000d2603          	lw	a2,0(s10)
8000183c:	004d0d13          	addi	s10,s10,4
80001840:	f9dff06f          	j	800017dc <z_vprintk+0x208>
				} else if (long_ctr == 1) {
80001844:	00100713          	li	a4,1
80001848:	feea08e3          	beq	s4,a4,80001838 <z_vprintk+0x264>
					unsigned long long llu =
8000184c:	007d0793          	addi	a5,s10,7
80001850:	ff87f713          	andi	a4,a5,-8
80001854:	00870d13          	addi	s10,a4,8
80001858:	00072603          	lw	a2,0(a4)
8000185c:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001860:	fc0710e3          	bnez	a4,80001820 <z_vprintk+0x24c>
80001864:	800007b7          	lui	a5,0x80000
80001868:	fff7c793          	not	a5,a5
8000186c:	f6c7f8e3          	bgeu	a5,a2,800017dc <z_vprintk+0x208>
80001870:	fb1ff06f          	j	80001820 <z_vprintk+0x24c>
				  out('0', ctx);
80001874:	00048593          	mv	a1,s1
80001878:	03000513          	li	a0,48
8000187c:	000400e7          	jalr	s0
				  out('x', ctx);
80001880:	00048593          	mv	a1,s1
80001884:	07800513          	li	a0,120
80001888:	000400e7          	jalr	s0
				  min_width = 8;
8000188c:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001890:	00100993          	li	s3,1
				if (long_ctr < 2) {
80001894:	00100693          	li	a3,1
80001898:	0b46c263          	blt	a3,s4,8000193c <z_vprintk+0x368>
					x = va_arg(ap, unsigned long);
8000189c:	000d2783          	lw	a5,0(s10)
800018a0:	00012423          	sw	zero,8(sp)
800018a4:	004d0d13          	addi	s10,s10,4
800018a8:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
800018ac:	01000c13          	li	s8,16
	int digits = 0;
800018b0:	00000b93          	li	s7,0
	int found_largest_digit = 0;
800018b4:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
800018b8:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800018bc:	00412503          	lw	a0,4(sp)
800018c0:	00812583          	lw	a1,8(sp)
800018c4:	fff88b13          	addi	s6,a7,-1
800018c8:	002b1613          	slli	a2,s6,0x2
800018cc:	01112623          	sw	a7,12(sp)
800018d0:	9a9fe0ef          	jal	ra,80000278 <__lshrdi3>
800018d4:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800018d8:	08051863          	bnez	a0,80001968 <z_vprintk+0x394>
800018dc:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
800018e0:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
800018e4:	00079863          	bnez	a5,800018f4 <z_vprintk+0x320>
800018e8:	00c12883          	lw	a7,12(sp)
800018ec:	00100793          	li	a5,1
800018f0:	08f89663          	bne	a7,a5,8000197c <z_vprintk+0x3a8>
			nibble += nibble > 9 ? 87 : 48;
800018f4:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
800018f8:	01851513          	slli	a0,a0,0x18
800018fc:	00048593          	mv	a1,s1
80001900:	41855513          	srai	a0,a0,0x18
80001904:	000400e7          	jalr	s0
			digits++;
80001908:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
8000190c:	040b1863          	bnez	s6,8000195c <z_vprintk+0x388>
	if (padding == PAD_SPACE_AFTER) {
80001910:	00300693          	li	a3,3
			might_format = 0;
80001914:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
80001918:	d6d998e3          	bne	s3,a3,80001688 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
8000191c:	00191713          	slli	a4,s2,0x1
80001920:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
80001924:	f17054e3          	blez	s7,8000182c <z_vprintk+0x258>
			out(' ', ctx);
80001928:	00048593          	mv	a1,s1
8000192c:	02000513          	li	a0,32
80001930:	000400e7          	jalr	s0
80001934:	fffb8b93          	addi	s7,s7,-1
80001938:	fedff06f          	j	80001924 <z_vprintk+0x350>
					x = va_arg(ap, unsigned long long);
8000193c:	007d0793          	addi	a5,s10,7
80001940:	ff87f693          	andi	a3,a5,-8
80001944:	0006a783          	lw	a5,0(a3)
80001948:	00868d13          	addi	s10,a3,8
8000194c:	00f12223          	sw	a5,4(sp)
80001950:	0046a783          	lw	a5,4(a3)
80001954:	00f12423          	sw	a5,8(sp)
80001958:	f55ff06f          	j	800018ac <z_vprintk+0x2d8>
			found_largest_digit = 1;
8000195c:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80001960:	000b0893          	mv	a7,s6
80001964:	f59ff06f          	j	800018bc <z_vprintk+0x2e8>
			nibble += nibble > 9 ? 87 : 48;
80001968:	00900793          	li	a5,9
8000196c:	05700693          	li	a3,87
80001970:	f8a7e2e3          	bltu	a5,a0,800018f4 <z_vprintk+0x320>
80001974:	03000693          	li	a3,48
80001978:	f7dff06f          	j	800018f4 <z_vprintk+0x320>
		if (remaining-- <= min_width) {
8000197c:	fffc0793          	addi	a5,s8,-1
80001980:	00f12623          	sw	a5,12(sp)
80001984:	01894c63          	blt	s2,s8,8000199c <z_vprintk+0x3c8>
			if (padding == PAD_ZERO_BEFORE) {
80001988:	00100793          	li	a5,1
8000198c:	00f99c63          	bne	s3,a5,800019a4 <z_vprintk+0x3d0>
				out('0', ctx);
80001990:	00048593          	mv	a1,s1
80001994:	03000513          	li	a0,48
				out(' ', ctx);
80001998:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
8000199c:	00c12c03          	lw	s8,12(sp)
800019a0:	fc1ff06f          	j	80001960 <z_vprintk+0x38c>
			} else if (padding == PAD_SPACE_BEFORE) {
800019a4:	00200793          	li	a5,2
800019a8:	fef99ae3          	bne	s3,a5,8000199c <z_vprintk+0x3c8>
				out(' ', ctx);
800019ac:	00048593          	mv	a1,s1
800019b0:	02000513          	li	a0,32
800019b4:	fe5ff06f          	j	80001998 <z_vprintk+0x3c4>
					out((int)(*s++), ctx);
800019b8:	00048593          	mv	a1,s1
800019bc:	001b8b93          	addi	s7,s7,1
800019c0:	000400e7          	jalr	s0
800019c4:	d81ff06f          	j	80001744 <z_vprintk+0x170>
						out(' ', ctx);
800019c8:	00048593          	mv	a1,s1
800019cc:	02000513          	li	a0,32
800019d0:	000400e7          	jalr	s0
800019d4:	fffb8b93          	addi	s7,s7,-1
800019d8:	d85ff06f          	j	8000175c <z_vprintk+0x188>
				out(c, ctx);
800019dc:	000d2503          	lw	a0,0(s10)
800019e0:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
800019e4:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
800019e8:	000400e7          	jalr	s0
				break;
800019ec:	d75ff06f          	j	80001760 <z_vprintk+0x18c>
				long_ctr = 0;
800019f0:	00000a13          	li	s4,0
				min_width = -1;
800019f4:	fff00913          	li	s2,-1
				padding = PAD_NONE;
800019f8:	00000993          	li	s3,0
				might_format = 1;
800019fc:	00100c93          	li	s9,1
80001a00:	c89ff06f          	j	80001688 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
80001a04:	00300993          	li	s3,3
80001a08:	c81ff06f          	j	80001688 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
80001a0c:	00100993          	li	s3,1
80001a10:	c79ff06f          	j	80001688 <z_vprintk+0xb4>

80001a14 <vprintk>:
{
80001a14:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001a18:	00050613          	mv	a2,a0
80001a1c:	80001537          	lui	a0,0x80001
80001a20:	00058693          	mv	a3,a1
80001a24:	46850513          	addi	a0,a0,1128 # 80001468 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001469>
80001a28:	00c10593          	addi	a1,sp,12
{
80001a2c:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001a30:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001a34:	ba1ff0ef          	jal	ra,800015d4 <z_vprintk>
}
80001a38:	01c12083          	lw	ra,28(sp)
80001a3c:	02010113          	addi	sp,sp,32
80001a40:	00008067          	ret

80001a44 <printk>:
{
80001a44:	fc010113          	addi	sp,sp,-64
80001a48:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
80001a4c:	02410593          	addi	a1,sp,36
{
80001a50:	00112e23          	sw	ra,28(sp)
80001a54:	02c12423          	sw	a2,40(sp)
80001a58:	02d12623          	sw	a3,44(sp)
80001a5c:	02e12823          	sw	a4,48(sp)
80001a60:	02f12a23          	sw	a5,52(sp)
80001a64:	03012c23          	sw	a6,56(sp)
80001a68:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
80001a6c:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80001a70:	fa5ff0ef          	jal	ra,80001a14 <vprintk>
}
80001a74:	01c12083          	lw	ra,28(sp)
80001a78:	04010113          	addi	sp,sp,64
80001a7c:	00008067          	ret

80001a80 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001a80:	800055b7          	lui	a1,0x80005
80001a84:	80005537          	lui	a0,0x80005
{
80001a88:	ff010113          	addi	sp,sp,-16
  k_panic();
80001a8c:	78058593          	addi	a1,a1,1920 # 80005780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005781>
80001a90:	79450513          	addi	a0,a0,1940 # 80005794 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005795>
80001a94:	01e00613          	li	a2,30
{
80001a98:	00112623          	sw	ra,12(sp)
  k_panic();
80001a9c:	fa9ff0ef          	jal	ra,80001a44 <printk>
80001aa0:	800055b7          	lui	a1,0x80005
80001aa4:	36058593          	addi	a1,a1,864 # 80005360 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005361>
80001aa8:	00600513          	li	a0,6
80001aac:	ecdfe0ef          	jal	ra,80000978 <z_NanoFatalErrorHandler>

80001ab0 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80001ab0:	00008067          	ret

80001ab4 <k_cpu_idle>:
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ab4:	00800793          	li	a5,8
80001ab8:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
80001abc:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80001ac0:	00008067          	ret

80001ac4 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80001ac4:	00100793          	li	a5,1
80001ac8:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
80001acc:	30452573          	csrrs	a0,mie,a0
}
80001ad0:	00008067          	ret

80001ad4 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ad4:	00800793          	li	a5,8
80001ad8:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
80001adc:	30405073          	csrwi	mie,0
80001ae0:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80001ae4:	00008067          	ret

80001ae8 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80001ae8:	ff010113          	addi	sp,sp,-16
80001aec:	00812423          	sw	s0,8(sp)
80001af0:	00912223          	sw	s1,4(sp)
80001af4:	80006437          	lui	s0,0x80006
80001af8:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
80001afc:	00a00793          	li	a5,10
{
80001b00:	00050493          	mv	s1,a0
80001b04:	d4440413          	addi	s0,s0,-700 # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
	if ('\n' == c) {
80001b08:	00f51c63          	bne	a0,a5,80001b20 <console_out+0x38>
80001b0c:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
80001b10:	00d00593          	li	a1,13
80001b14:	00452783          	lw	a5,4(a0)
80001b18:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
80001b1c:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
80001b20:	00042503          	lw	a0,0(s0)
80001b24:	0ff4f593          	andi	a1,s1,255
80001b28:	00452783          	lw	a5,4(a0)
80001b2c:	0047a783          	lw	a5,4(a5)
80001b30:	000780e7          	jalr	a5

	return c;
}
80001b34:	00c12083          	lw	ra,12(sp)
80001b38:	00812403          	lw	s0,8(sp)
80001b3c:	00048513          	mv	a0,s1
80001b40:	00412483          	lw	s1,4(sp)
80001b44:	01010113          	addi	sp,sp,16
80001b48:	00008067          	ret

80001b4c <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001b4c:	ff010113          	addi	sp,sp,-16
80001b50:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001b54:	80002437          	lui	s0,0x80002
80001b58:	ae840513          	addi	a0,s0,-1304 # 80001ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001ae9>
{
80001b5c:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001b60:	514000ef          	jal	ra,80002074 <__stdout_hook_install>
	__printk_hook_install(console_out);
80001b64:	ae840513          	addi	a0,s0,-1304
}
80001b68:	00812403          	lw	s0,8(sp)
80001b6c:	00c12083          	lw	ra,12(sp)
80001b70:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80001b74:	a55ff06f          	j	800015c8 <__printk_hook_install>

80001b78 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80001b78:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001b7c:	ff010113          	addi	sp,sp,-16
80001b80:	7a050513          	addi	a0,a0,1952 # 800057a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057a1>
80001b84:	00112623          	sw	ra,12(sp)
80001b88:	065000ef          	jal	ra,800023ec <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
80001b8c:	800067b7          	lui	a5,0x80006
80001b90:	d4a7a223          	sw	a0,-700(a5) # 80005d44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d45>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001b94:	fb9ff0ef          	jal	ra,80001b4c <uart_console_hook_install>

	return 0;
}
80001b98:	00c12083          	lw	ra,12(sp)
80001b9c:	00000513          	li	a0,0
80001ba0:	01010113          	addi	sp,sp,16
80001ba4:	00008067          	ret

80001ba8 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80001ba8:	f01007b7          	lui	a5,0xf0100
80001bac:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001bb0:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80001bb4:	f447a583          	lw	a1,-188(a5)
80001bb8:	fee59ae3          	bne	a1,a4,80001bac <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001bbc:	00008067          	ret

80001bc0 <timer_isr>:

static void timer_isr(void *arg)
{
80001bc0:	fe010113          	addi	sp,sp,-32
80001bc4:	00812c23          	sw	s0,24(sp)
80001bc8:	00112e23          	sw	ra,28(sp)
80001bcc:	00912a23          	sw	s1,20(sp)
80001bd0:	01212823          	sw	s2,16(sp)
80001bd4:	01312623          	sw	s3,12(sp)
80001bd8:	01412423          	sw	s4,8(sp)
80001bdc:	01512223          	sw	s5,4(sp)
80001be0:	00800413          	li	s0,8
80001be4:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001be8:	80006937          	lui	s2,0x80006
80001bec:	d4890513          	addi	a0,s2,-696 # 80005d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d49>
	key = (mstatus & SOC_MSTATUS_IEN);
80001bf0:	00847413          	andi	s0,s0,8
80001bf4:	5e0020ef          	jal	ra,800041d4 <z_spin_lock_valid>
80001bf8:	02051e63          	bnez	a0,80001c34 <timer_isr+0x74>
80001bfc:	800054b7          	lui	s1,0x80005
80001c00:	800055b7          	lui	a1,0x80005
80001c04:	80005537          	lui	a0,0x80005
80001c08:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80001c0c:	04e00693          	li	a3,78
80001c10:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001c14:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001c18:	e2dff0ef          	jal	ra,80001a44 <printk>
80001c1c:	80005537          	lui	a0,0x80005
80001c20:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80001c24:	e21ff0ef          	jal	ra,80001a44 <printk>
80001c28:	04e00593          	li	a1,78
80001c2c:	7b448513          	addi	a0,s1,1972
80001c30:	e51ff0ef          	jal	ra,80001a80 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
80001c34:	d4890513          	addi	a0,s2,-696
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001c38:	800064b7          	lui	s1,0x80006
80001c3c:	5f0020ef          	jal	ra,8000422c <z_spin_lock_set_owner>
80001c40:	d2848493          	addi	s1,s1,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
	u64_t now = mtime();
80001c44:	f65ff0ef          	jal	ra,80001ba8 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001c48:	0004a983          	lw	s3,0(s1)
80001c4c:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
80001c50:	00050713          	mv	a4,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001c54:	41350533          	sub	a0,a0,s3
80001c58:	00a73733          	sltu	a4,a4,a0
80001c5c:	415585b3          	sub	a1,a1,s5
80001c60:	0001d637          	lui	a2,0x1d
80001c64:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001c68:	00000693          	li	a3,0
80001c6c:	40e585b3          	sub	a1,a1,a4
80001c70:	e40fe0ef          	jal	ra,800002b0 <__udivdi3>

	last_count += dticks * CYC_PER_TICK;
80001c74:	0001d7b7          	lui	a5,0x1d
80001c78:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001c7c:	02a787b3          	mul	a5,a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
80001c80:	00050a13          	mv	s4,a0
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001c84:	d4890513          	addi	a0,s2,-696
	last_count += dticks * CYC_PER_TICK;
80001c88:	013789b3          	add	s3,a5,s3
80001c8c:	00f9b7b3          	sltu	a5,s3,a5
80001c90:	015787b3          	add	a5,a5,s5
80001c94:	0134a023          	sw	s3,0(s1)
80001c98:	00f4a223          	sw	a5,4(s1)
80001c9c:	560020ef          	jal	ra,800041fc <z_spin_unlock_valid>
80001ca0:	02051e63          	bnez	a0,80001cdc <timer_isr+0x11c>
80001ca4:	800054b7          	lui	s1,0x80005
80001ca8:	800055b7          	lui	a1,0x80005
80001cac:	80005537          	lui	a0,0x80005
80001cb0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80001cb4:	06100693          	li	a3,97
80001cb8:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001cbc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001cc0:	d85ff0ef          	jal	ra,80001a44 <printk>
80001cc4:	80006537          	lui	a0,0x80006
80001cc8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80001ccc:	d79ff0ef          	jal	ra,80001a44 <printk>
80001cd0:	06100593          	li	a1,97
80001cd4:	7b448513          	addi	a0,s1,1972
80001cd8:	da9ff0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001cdc:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80001ce0:	01812403          	lw	s0,24(sp)
80001ce4:	01c12083          	lw	ra,28(sp)
80001ce8:	01412483          	lw	s1,20(sp)
80001cec:	01012903          	lw	s2,16(sp)
80001cf0:	00c12983          	lw	s3,12(sp)
80001cf4:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001cf8:	000a0513          	mv	a0,s4
}
80001cfc:	00812a03          	lw	s4,8(sp)
80001d00:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001d04:	6fd0206f          	j	80004c00 <z_clock_announce>

80001d08 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001d08:	ff010113          	addi	sp,sp,-16
80001d0c:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d10:	e99ff0ef          	jal	ra,80001ba8 <mtime>
80001d14:	0001d7b7          	lui	a5,0x1d
80001d18:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001d1c:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d20:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
80001d24:	fff00693          	li	a3,-1
80001d28:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001d2c:	00a7b533          	sltu	a0,a5,a0
80001d30:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
80001d34:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001d38:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
80001d3c:	00700513          	li	a0,7
80001d40:	d85ff0ef          	jal	ra,80001ac4 <z_arch_irq_enable>
	return 0;
}
80001d44:	00c12083          	lw	ra,12(sp)
80001d48:	00000513          	li	a0,0
80001d4c:	01010113          	addi	sp,sp,16
80001d50:	00008067          	ret

80001d54 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001d54:	16059c63          	bnez	a1,80001ecc <z_clock_set_timeout+0x178>
{
80001d58:	fe010113          	addi	sp,sp,-32
80001d5c:	00112e23          	sw	ra,28(sp)
80001d60:	00812c23          	sw	s0,24(sp)
80001d64:	00912a23          	sw	s1,20(sp)
80001d68:	01212823          	sw	s2,16(sp)
80001d6c:	01312623          	sw	s3,12(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80001d70:	fff00793          	li	a5,-1
80001d74:	00f51663          	bne	a0,a5,80001d80 <z_clock_set_timeout+0x2c>
80001d78:	00009537          	lui	a0,0x9
80001d7c:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80001d80:	000097b7          	lui	a5,0x9
80001d84:	fff50413          	addi	s0,a0,-1
80001d88:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
80001d8c:	1287da63          	bge	a5,s0,80001ec0 <z_clock_set_timeout+0x16c>
80001d90:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d94:	00800493          	li	s1,8
80001d98:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001d9c:	80006937          	lui	s2,0x80006
80001da0:	d4890513          	addi	a0,s2,-696 # 80005d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d49>
	key = (mstatus & SOC_MSTATUS_IEN);
80001da4:	0084f493          	andi	s1,s1,8
80001da8:	42c020ef          	jal	ra,800041d4 <z_spin_lock_valid>
80001dac:	02051e63          	bnez	a0,80001de8 <z_clock_set_timeout+0x94>
80001db0:	800059b7          	lui	s3,0x80005
80001db4:	800055b7          	lui	a1,0x80005
80001db8:	80005537          	lui	a0,0x80005
80001dbc:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80001dc0:	04e00693          	li	a3,78
80001dc4:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001dc8:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001dcc:	c79ff0ef          	jal	ra,80001a44 <printk>
80001dd0:	80005537          	lui	a0,0x80005
80001dd4:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80001dd8:	c6dff0ef          	jal	ra,80001a44 <printk>
80001ddc:	04e00593          	li	a1,78
80001de0:	7b498513          	addi	a0,s3,1972
80001de4:	c9dff0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80001de8:	d4890513          	addi	a0,s2,-696
80001dec:	440020ef          	jal	ra,8000422c <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
80001df0:	db9ff0ef          	jal	ra,80001ba8 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;
80001df4:	0001d6b7          	lui	a3,0x1d

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001df8:	800067b7          	lui	a5,0x80006
	u32_t cyc = ticks * CYC_PER_TICK;
80001dfc:	4c068613          	addi	a2,a3,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001e00:	d2878793          	addi	a5,a5,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80001e04:	0007a703          	lw	a4,0(a5)
80001e08:	0047a583          	lw	a1,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001e0c:	02c407b3          	mul	a5,s0,a2
80001e10:	4bf68693          	addi	a3,a3,1215
80001e14:	40e68433          	sub	s0,a3,a4
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001e18:	3e700693          	li	a3,999
80001e1c:	008787b3          	add	a5,a5,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001e20:	00f507b3          	add	a5,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001e24:	02c7d7b3          	divu	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001e28:	40a70533          	sub	a0,a4,a0
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001e2c:	02c787b3          	mul	a5,a5,a2
	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001e30:	00f50533          	add	a0,a0,a5
80001e34:	00a6c463          	blt	a3,a0,80001e3c <z_clock_set_timeout+0xe8>
		cyc += CYC_PER_TICK;
80001e38:	00c787b3          	add	a5,a5,a2
	r[1] = 0xffffffff;
80001e3c:	f01006b7          	lui	a3,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80001e40:	00e78733          	add	a4,a5,a4
	r[1] = 0xffffffff;
80001e44:	fff00613          	li	a2,-1
80001e48:	f4c6a623          	sw	a2,-180(a3) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001e4c:	00f737b3          	sltu	a5,a4,a5
80001e50:	00b787b3          	add	a5,a5,a1
	r[0] = (u32_t)time;
80001e54:	f4e6a423          	sw	a4,-184(a3)
	r[1] = (u32_t)(time >> 32);
80001e58:	f4f6a623          	sw	a5,-180(a3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001e5c:	d4890513          	addi	a0,s2,-696
80001e60:	39c020ef          	jal	ra,800041fc <z_spin_unlock_valid>
80001e64:	02051e63          	bnez	a0,80001ea0 <z_clock_set_timeout+0x14c>
80001e68:	80005437          	lui	s0,0x80005
80001e6c:	800055b7          	lui	a1,0x80005
80001e70:	80005537          	lui	a0,0x80005
80001e74:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80001e78:	06100693          	li	a3,97
80001e7c:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001e80:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001e84:	bc1ff0ef          	jal	ra,80001a44 <printk>
80001e88:	80006537          	lui	a0,0x80006
80001e8c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80001e90:	bb5ff0ef          	jal	ra,80001a44 <printk>
80001e94:	06100593          	li	a1,97
80001e98:	7b440513          	addi	a0,s0,1972
80001e9c:	be5ff0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001ea0:	3004a4f3          	csrrs	s1,mstatus,s1
	k_spin_unlock(&lock, key);
#endif
}
80001ea4:	01c12083          	lw	ra,28(sp)
80001ea8:	01812403          	lw	s0,24(sp)
80001eac:	01412483          	lw	s1,20(sp)
80001eb0:	01012903          	lw	s2,16(sp)
80001eb4:	00c12983          	lw	s3,12(sp)
80001eb8:	02010113          	addi	sp,sp,32
80001ebc:	00008067          	ret
80001ec0:	ec045ae3          	bgez	s0,80001d94 <z_clock_set_timeout+0x40>
80001ec4:	00000413          	li	s0,0
80001ec8:	ecdff06f          	j	80001d94 <z_clock_set_timeout+0x40>
80001ecc:	00008067          	ret

80001ed0 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80001ed0:	ff010113          	addi	sp,sp,-16
80001ed4:	00812423          	sw	s0,8(sp)
80001ed8:	00112623          	sw	ra,12(sp)
80001edc:	00912223          	sw	s1,4(sp)
80001ee0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001ee4:	00800413          	li	s0,8
80001ee8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001eec:	80006937          	lui	s2,0x80006
80001ef0:	d4890513          	addi	a0,s2,-696 # 80005d48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d49>
	key = (mstatus & SOC_MSTATUS_IEN);
80001ef4:	00847413          	andi	s0,s0,8
80001ef8:	2dc020ef          	jal	ra,800041d4 <z_spin_lock_valid>
80001efc:	02051e63          	bnez	a0,80001f38 <z_clock_elapsed+0x68>
80001f00:	800054b7          	lui	s1,0x80005
80001f04:	800055b7          	lui	a1,0x80005
80001f08:	80005537          	lui	a0,0x80005
80001f0c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80001f10:	04e00693          	li	a3,78
80001f14:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001f18:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001f1c:	b29ff0ef          	jal	ra,80001a44 <printk>
80001f20:	80005537          	lui	a0,0x80005
80001f24:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80001f28:	b1dff0ef          	jal	ra,80001a44 <printk>
80001f2c:	04e00593          	li	a1,78
80001f30:	7b448513          	addi	a0,s1,1972
80001f34:	b4dff0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80001f38:	d4890513          	addi	a0,s2,-696
80001f3c:	2f0020ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80001f40:	c69ff0ef          	jal	ra,80001ba8 <mtime>
80001f44:	800067b7          	lui	a5,0x80006
80001f48:	d287a483          	lw	s1,-728(a5) # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
80001f4c:	409504b3          	sub	s1,a0,s1
80001f50:	0001d537          	lui	a0,0x1d
80001f54:	4c050513          	addi	a0,a0,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001f58:	02a4d4b3          	divu	s1,s1,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001f5c:	d4890513          	addi	a0,s2,-696
80001f60:	29c020ef          	jal	ra,800041fc <z_spin_unlock_valid>
80001f64:	02051e63          	bnez	a0,80001fa0 <z_clock_elapsed+0xd0>
80001f68:	80005937          	lui	s2,0x80005
80001f6c:	800055b7          	lui	a1,0x80005
80001f70:	80005537          	lui	a0,0x80005
80001f74:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80001f78:	06100693          	li	a3,97
80001f7c:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80001f80:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80001f84:	ac1ff0ef          	jal	ra,80001a44 <printk>
80001f88:	80006537          	lui	a0,0x80006
80001f8c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80001f90:	ab5ff0ef          	jal	ra,80001a44 <printk>
80001f94:	06100593          	li	a1,97
80001f98:	7b490513          	addi	a0,s2,1972
80001f9c:	ae5ff0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001fa0:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001fa4:	00c12083          	lw	ra,12(sp)
80001fa8:	00812403          	lw	s0,8(sp)
80001fac:	00048513          	mv	a0,s1
80001fb0:	00012903          	lw	s2,0(sp)
80001fb4:	00412483          	lw	s1,4(sp)
80001fb8:	01010113          	addi	sp,sp,16
80001fbc:	00008067          	ret

80001fc0 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80001fc0:	00054783          	lbu	a5,0(a0)
80001fc4:	0005c703          	lbu	a4,0(a1)
80001fc8:	00e79463          	bne	a5,a4,80001fd0 <strcmp+0x10>
80001fcc:	00079663          	bnez	a5,80001fd8 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80001fd0:	40e78533          	sub	a0,a5,a4
80001fd4:	00008067          	ret
		s1++;
80001fd8:	00150513          	addi	a0,a0,1
		s2++;
80001fdc:	00158593          	addi	a1,a1,1
80001fe0:	fe1ff06f          	j	80001fc0 <strcmp>

80001fe4 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80001fe4:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80001fe8:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80001fec:	0037f713          	andi	a4,a5,3
80001ff0:	04071863          	bnez	a4,80002040 <memset+0x5c>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80001ff4:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80001ff8:	00859713          	slli	a4,a1,0x8
80001ffc:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002000:	01059713          	slli	a4,a1,0x10
80002004:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002008:	00c78333          	add	t1,a5,a2
8000200c:	00078713          	mv	a4,a5
80002010:	00300813          	li	a6,3
80002014:	40e308b3          	sub	a7,t1,a4
80002018:	03186e63          	bltu	a6,a7,80002054 <memset+0x70>
8000201c:	00265713          	srli	a4,a2,0x2
80002020:	00271593          	slli	a1,a4,0x2
80002024:	00b787b3          	add	a5,a5,a1
80002028:	ffc00593          	li	a1,-4
8000202c:	02b70733          	mul	a4,a4,a1
80002030:	00c70733          	add	a4,a4,a2
80002034:	00e78733          	add	a4,a5,a4

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002038:	02e79463          	bne	a5,a4,80002060 <memset+0x7c>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
8000203c:	00008067          	ret
		if (n == 0) {
80002040:	fe060ee3          	beqz	a2,8000203c <memset+0x58>
		*(d_byte++) = c_byte;
80002044:	00178793          	addi	a5,a5,1
80002048:	fed78fa3          	sb	a3,-1(a5)
		n--;
8000204c:	fff60613          	addi	a2,a2,-1
80002050:	f9dff06f          	j	80001fec <memset+0x8>
		*(d_word++) = c_word;
80002054:	00470713          	addi	a4,a4,4
80002058:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
8000205c:	fb9ff06f          	j	80002014 <memset+0x30>
		*(d_byte++) = c_byte;
80002060:	00178793          	addi	a5,a5,1
80002064:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002068:	fd1ff06f          	j	80002038 <memset+0x54>

8000206c <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
8000206c:	fff00513          	li	a0,-1
80002070:	00008067          	ret

80002074 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002074:	800067b7          	lui	a5,0x80006
80002078:	c8a7a423          	sw	a0,-888(a5) # 80005c88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c89>
}
8000207c:	00008067          	ret

80002080 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002080:	fe010113          	addi	sp,sp,-32
80002084:	00812c23          	sw	s0,24(sp)
	test->setup();
80002088:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
8000208c:	80006437          	lui	s0,0x80006
{
80002090:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002094:	c8c40413          	addi	s0,s0,-884 # 80005c8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c8d>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002098:	800064b7          	lui	s1,0x80006
{
8000209c:	00112e23          	sw	ra,28(sp)
800020a0:	01212823          	sw	s2,16(sp)
800020a4:	01312623          	sw	s3,12(sp)
	test_result = 1;
800020a8:	d4c48493          	addi	s1,s1,-692 # 80005d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d4d>
800020ac:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
800020b0:	00042023          	sw	zero,0(s0)
{
800020b4:	00050913          	mv	s2,a0
	test_result = 1;
800020b8:	0134a023          	sw	s3,0(s1)
	test->setup();
800020bc:	000780e7          	jalr	a5
	test->test();
800020c0:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
800020c4:	01342023          	sw	s3,0(s0)
	test->test();
800020c8:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
800020cc:	00200793          	li	a5,2
800020d0:	00f42023          	sw	a5,0(s0)
	test->teardown();
800020d4:	00c92783          	lw	a5,12(s2)
800020d8:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
800020dc:	00300793          	li	a5,3
800020e0:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
800020e4:	01812403          	lw	s0,24(sp)
	test_result = 0;
800020e8:	0004a023          	sw	zero,0(s1)
}
800020ec:	01c12083          	lw	ra,28(sp)
800020f0:	01412483          	lw	s1,20(sp)
800020f4:	01012903          	lw	s2,16(sp)
800020f8:	00c12983          	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
800020fc:	80006537          	lui	a0,0x80006
80002100:	fa450513          	addi	a0,a0,-92 # 80005fa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fa5>
80002104:	02010113          	addi	sp,sp,32
80002108:	5110106f          	j	80003e18 <z_impl_k_sem_give>

8000210c <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
8000210c:	fa010113          	addi	sp,sp,-96
80002110:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002114:	800064b7          	lui	s1,0x80006
80002118:	d504a783          	lw	a5,-688(s1) # 80005d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d51>
{
8000211c:	04112e23          	sw	ra,92(sp)
80002120:	04812c23          	sw	s0,88(sp)
80002124:	05212823          	sw	s2,80(sp)
80002128:	05312623          	sw	s3,76(sp)
8000212c:	05412423          	sw	s4,72(sp)
80002130:	05512223          	sw	s5,68(sp)
80002134:	05612023          	sw	s6,64(sp)
80002138:	03712e23          	sw	s7,60(sp)
8000213c:	03812c23          	sw	s8,56(sp)
80002140:	03912a23          	sw	s9,52(sp)
80002144:	03a12823          	sw	s10,48(sp)
80002148:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
8000214c:	0807c463          	bltz	a5,800021d4 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002150:	80006437          	lui	s0,0x80006
80002154:	00100613          	li	a2,1
80002158:	00050993          	mv	s3,a0
8000215c:	00058c13          	mv	s8,a1
80002160:	fa440513          	addi	a0,s0,-92 # 80005fa4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fa5>
80002164:	00000593          	li	a1,0
80002168:	3e9010ef          	jal	ra,80003d50 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
8000216c:	80006537          	lui	a0,0x80006
80002170:	00098593          	mv	a1,s3
80002174:	87050513          	addi	a0,a0,-1936 # 80005870 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005871>
80002178:	8cdff0ef          	jal	ra,80001a44 <printk>
	PRINT_LINE;
8000217c:	80006937          	lui	s2,0x80006
80002180:	88890513          	addi	a0,s2,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
		Z_TC_END_RESULT(ret, test->name);
80002184:	80006ab7          	lui	s5,0x80006
	PRINT_LINE;
80002188:	8bdff0ef          	jal	ra,80001a44 <printk>
8000218c:	d5048493          	addi	s1,s1,-688
	int fail = 0;
80002190:	00000a13          	li	s4,0
80002194:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002198:	80007cb7          	lui	s9,0x80007
8000219c:	80006b37          	lui	s6,0x80006
800021a0:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
800021a4:	80006db7          	lui	s11,0x80006
800021a8:	80006bb7          	lui	s7,0x80006
		Z_TC_END_RESULT(ret, test->name);
800021ac:	828a8a93          	addi	s5,s5,-2008 # 80005828 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005829>
	while (suite->test) {
800021b0:	004c2783          	lw	a5,4(s8)
800021b4:	04079e63          	bnez	a5,80002210 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
800021b8:	00098593          	mv	a1,s3
	if (fail) {
800021bc:	100a0663          	beqz	s4,800022c8 <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
800021c0:	80006537          	lui	a0,0x80006
800021c4:	8f850513          	addi	a0,a0,-1800 # 800058f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058f9>
800021c8:	87dff0ef          	jal	ra,80001a44 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
800021cc:	00100793          	li	a5,1
800021d0:	00f4a023          	sw	a5,0(s1)
}
800021d4:	05c12083          	lw	ra,92(sp)
800021d8:	05812403          	lw	s0,88(sp)
800021dc:	05412483          	lw	s1,84(sp)
800021e0:	05012903          	lw	s2,80(sp)
800021e4:	04c12983          	lw	s3,76(sp)
800021e8:	04812a03          	lw	s4,72(sp)
800021ec:	04412a83          	lw	s5,68(sp)
800021f0:	04012b03          	lw	s6,64(sp)
800021f4:	03c12b83          	lw	s7,60(sp)
800021f8:	03812c03          	lw	s8,56(sp)
800021fc:	03412c83          	lw	s9,52(sp)
80002200:	03012d03          	lw	s10,48(sp)
80002204:	02c12d83          	lw	s11,44(sp)
80002208:	06010113          	addi	sp,sp,96
8000220c:	00008067          	ret
	TC_START(test->name);
80002210:	000c2583          	lw	a1,0(s8)
80002214:	800067b7          	lui	a5,0x80006
80002218:	8d078513          	addi	a0,a5,-1840 # 800058d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058d1>
8000221c:	829ff0ef          	jal	ra,80001a44 <printk>
80002220:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002224:	010c2783          	lw	a5,16(s8)
80002228:	000c0713          	mv	a4,s8
8000222c:	40000613          	li	a2,1024
80002230:	0087e793          	ori	a5,a5,8
80002234:	fff00893          	li	a7,-1
80002238:	00000813          	li	a6,0
8000223c:	080d0693          	addi	a3,s10,128 # 80002080 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002081>
80002240:	00f12023          	sw	a5,0(sp)
80002244:	930c8593          	addi	a1,s9,-1744 # 80006930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006931>
80002248:	00000793          	li	a5,0
8000224c:	fb4b0513          	addi	a0,s6,-76 # 80005fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005fb5>
80002250:	148020ef          	jal	ra,80004398 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002254:	01c12783          	lw	a5,28(sp)
80002258:	fff00593          	li	a1,-1
8000225c:	fa478513          	addi	a0,a5,-92
80002260:	49d010ef          	jal	ra,80003efc <z_impl_k_sem_take>
	if (test_result == -1) {
80002264:	d4cd8793          	addi	a5,s11,-692 # 80005d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d4d>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002268:	fb4b0513          	addi	a0,s6,-76
8000226c:	0007a403          	lw	s0,0(a5)
80002270:	2cc020ef          	jal	ra,8000453c <z_impl_k_thread_abort>
	if (test_result == -2) {
80002274:	800067b7          	lui	a5,0x80006
80002278:	d4c78793          	addi	a5,a5,-692 # 80005d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d4d>
8000227c:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002280:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002284:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002288:	00143413          	seqz	s0,s0
	if (test_result == -2) {
8000228c:	000c2603          	lw	a2,0(s8)
80002290:	02f71463          	bne	a4,a5,800022b8 <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002294:	800065b7          	lui	a1,0x80006
80002298:	8e458593          	addi	a1,a1,-1820 # 800058e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058e5>
		Z_TC_END_RESULT(ret, test->name);
8000229c:	8ecb8513          	addi	a0,s7,-1812 # 800058ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800058ed>
800022a0:	fa4ff0ef          	jal	ra,80001a44 <printk>
800022a4:	88890513          	addi	a0,s2,-1912
800022a8:	f9cff0ef          	jal	ra,80001a44 <printk>
		fail += run_test(suite);
800022ac:	008a0a33          	add	s4,s4,s0
		suite++;
800022b0:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
800022b4:	efdff06f          	j	800021b0 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
800022b8:	00241793          	slli	a5,s0,0x2
800022bc:	00fa87b3          	add	a5,s5,a5
800022c0:	0007a583          	lw	a1,0(a5)
800022c4:	fd9ff06f          	j	8000229c <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
800022c8:	80006537          	lui	a0,0x80006
800022cc:	91050513          	addi	a0,a0,-1776 # 80005910 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005911>
800022d0:	f74ff0ef          	jal	ra,80001a44 <printk>
	test_status = (test_status || fail) ? 1 : 0;
800022d4:	0004a783          	lw	a5,0(s1)
800022d8:	00f037b3          	snez	a5,a5
800022dc:	ef5ff06f          	j	800021d0 <z_ztest_run_test_suite+0xc4>

800022e0 <end_report>:

void end_report(void)
{
	if (test_status) {
800022e0:	800067b7          	lui	a5,0x80006
800022e4:	d507a783          	lw	a5,-688(a5) # 80005d50 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d51>
{
800022e8:	ff010113          	addi	sp,sp,-16
800022ec:	00812423          	sw	s0,8(sp)
800022f0:	80006537          	lui	a0,0x80006
800022f4:	00112623          	sw	ra,12(sp)
800022f8:	80006437          	lui	s0,0x80006
		TC_END_REPORT(TC_FAIL);
800022fc:	88850513          	addi	a0,a0,-1912 # 80005888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005889>
	if (test_status) {
80002300:	02078263          	beqz	a5,80002324 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002304:	f40ff0ef          	jal	ra,80001a44 <printk>
80002308:	800065b7          	lui	a1,0x80006
8000230c:	83458593          	addi	a1,a1,-1996 # 80005834 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005835>
	} else {
		TC_END_REPORT(TC_PASS);
80002310:	83c40513          	addi	a0,s0,-1988 # 8000583c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000583d>
	}
}
80002314:	00812403          	lw	s0,8(sp)
80002318:	00c12083          	lw	ra,12(sp)
8000231c:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002320:	f24ff06f          	j	80001a44 <printk>
80002324:	f20ff0ef          	jal	ra,80001a44 <printk>
80002328:	800065b7          	lui	a1,0x80006
8000232c:	85458593          	addi	a1,a1,-1964 # 80005854 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005855>
80002330:	fe1ff06f          	j	80002310 <end_report+0x30>

80002334 <main>:

	return test_status;
}
#else
void main(void)
{
80002334:	ff010113          	addi	sp,sp,-16
80002338:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
8000233c:	db0fe0ef          	jal	ra,800008ec <test_main>
	end_report();
}
80002340:	00c12083          	lw	ra,12(sp)
80002344:	01010113          	addi	sp,sp,16
	end_report();
80002348:	f99ff06f          	j	800022e0 <end_report>

8000234c <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
8000234c:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002350:	00012623          	sw	zero,12(sp)
    i++;
80002354:	00c12783          	lw	a5,12(sp)
80002358:	00178793          	addi	a5,a5,1
8000235c:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002360:	f00107b7          	lui	a5,0xf0010
80002364:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002368:	01010113          	addi	sp,sp,16
8000236c:	00008067          	ret

80002370 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002370:	fff00513          	li	a0,-1
80002374:	00008067          	ret

80002378 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002378:	00000513          	li	a0,0
8000237c:	00008067          	ret

80002380 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002380:	00251713          	slli	a4,a0,0x2
80002384:	800067b7          	lui	a5,0x80006
80002388:	00150513          	addi	a0,a0,1
8000238c:	94078793          	addi	a5,a5,-1728 # 80005940 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005941>
80002390:	00251513          	slli	a0,a0,0x2
{
80002394:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002398:	00e78733          	add	a4,a5,a4
8000239c:	00a787b3          	add	a5,a5,a0
{
800023a0:	00812423          	sw	s0,8(sp)
800023a4:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800023a8:	00072403          	lw	s0,0(a4)
800023ac:	0007a483          	lw	s1,0(a5)
{
800023b0:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
800023b4:	00946c63          	bltu	s0,s1,800023cc <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
800023b8:	00c12083          	lw	ra,12(sp)
800023bc:	00812403          	lw	s0,8(sp)
800023c0:	00412483          	lw	s1,4(sp)
800023c4:	01010113          	addi	sp,sp,16
800023c8:	00008067          	ret
		retval = device_conf->init(info);
800023cc:	00042783          	lw	a5,0(s0)
800023d0:	00040513          	mv	a0,s0
800023d4:	0047a783          	lw	a5,4(a5)
800023d8:	000780e7          	jalr	a5
		if (retval != 0) {
800023dc:	00050463          	beqz	a0,800023e4 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
800023e0:	00042223          	sw	zero,4(s0)
								info++) {
800023e4:	00c40413          	addi	s0,s0,12
800023e8:	fcdff06f          	j	800023b4 <z_sys_device_do_config_level+0x34>

800023ec <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
800023ec:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
800023f0:	800067b7          	lui	a5,0x80006
{
800023f4:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
800023f8:	800064b7          	lui	s1,0x80006
{
800023fc:	00812423          	sw	s0,8(sp)
80002400:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80002404:	ca878413          	addi	s0,a5,-856 # 80005ca8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca9>
{
80002408:	01212023          	sw	s2,0(sp)
8000240c:	ca878793          	addi	a5,a5,-856
80002410:	cd848493          	addi	s1,s1,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002414:	00941c63          	bne	s0,s1,8000242c <z_impl_device_get_binding+0x40>
80002418:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
8000241c:	00078413          	mv	s0,a5
80002420:	02941463          	bne	s0,s1,80002448 <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80002424:	00000413          	li	s0,0
80002428:	0440006f          	j	8000246c <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
8000242c:	00442703          	lw	a4,4(s0)
80002430:	00070863          	beqz	a4,80002440 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80002434:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80002438:	00072703          	lw	a4,0(a4)
8000243c:	02a70863          	beq	a4,a0,8000246c <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002440:	00c40413          	addi	s0,s0,12
80002444:	fd1ff06f          	j	80002414 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
80002448:	00442783          	lw	a5,4(s0)
8000244c:	00079663          	bnez	a5,80002458 <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80002450:	00c40413          	addi	s0,s0,12
80002454:	fcdff06f          	j	80002420 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
80002458:	00042783          	lw	a5,0(s0)
8000245c:	00090513          	mv	a0,s2
80002460:	0007a583          	lw	a1,0(a5)
80002464:	b5dff0ef          	jal	ra,80001fc0 <strcmp>
80002468:	fe0514e3          	bnez	a0,80002450 <z_impl_device_get_binding+0x64>
}
8000246c:	00040513          	mv	a0,s0
80002470:	00c12083          	lw	ra,12(sp)
80002474:	00812403          	lw	s0,8(sp)
80002478:	00412483          	lw	s1,4(sp)
8000247c:	00012903          	lw	s2,0(sp)
80002480:	01010113          	addi	sp,sp,16
80002484:	00008067          	ret

80002488 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80002488:	ff010113          	addi	sp,sp,-16
8000248c:	00812423          	sw	s0,8(sp)
80002490:	00912223          	sw	s1,4(sp)
80002494:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002498:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
8000249c:	00200493          	li	s1,2
800024a0:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800024a4:	57c020ef          	jal	ra,80004a20 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800024a8:	00a4c463          	blt	s1,a0,800024b0 <idle+0x28>
800024ac:	00100513          	li	a0,1
800024b0:	00100593          	li	a1,1
800024b4:	648020ef          	jal	ra,80004afc <z_set_timeout_expiry>
	k_cpu_idle();
800024b8:	dfcff0ef          	jal	ra,80001ab4 <k_cpu_idle>
800024bc:	fe5ff06f          	j	800024a0 <idle+0x18>

800024c0 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800024c0:	80006537          	lui	a0,0x80006
800024c4:	800067b7          	lui	a5,0x80006
800024c8:	d2850613          	addi	a2,a0,-728 # 80005d28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d29>
800024cc:	13078793          	addi	a5,a5,304 # 80006130 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006131>
800024d0:	40c78633          	sub	a2,a5,a2
800024d4:	00000593          	li	a1,0
800024d8:	d2850513          	addi	a0,a0,-728
800024dc:	b09ff06f          	j	80001fe4 <memset>

800024e0 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800024e0:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800024e4:	00200513          	li	a0,2
{
800024e8:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800024ec:	e95ff0ef          	jal	ra,80002380 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
800024f0:	80006537          	lui	a0,0x80006
800024f4:	95450513          	addi	a0,a0,-1708 # 80005954 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005955>
800024f8:	d4cff0ef          	jal	ra,80001a44 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
800024fc:	00300513          	li	a0,3
80002500:	e81ff0ef          	jal	ra,80002380 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80002504:	789010ef          	jal	ra,8000448c <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80002508:	e2dff0ef          	jal	ra,80002334 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
8000250c:	800067b7          	lui	a5,0x80006
80002510:	09478793          	addi	a5,a5,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
80002514:	00c7c703          	lbu	a4,12(a5)
80002518:	ffe77713          	andi	a4,a4,-2
8000251c:	00e78623          	sb	a4,12(a5)
}
80002520:	00c12083          	lw	ra,12(sp)
80002524:	01010113          	addi	sp,sp,16
80002528:	00008067          	ret

8000252c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
8000252c:	f6010113          	addi	sp,sp,-160
80002530:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80002534:	800087b7          	lui	a5,0x80008
80002538:	80006437          	lui	s0,0x80006
8000253c:	09312623          	sw	s3,140(sp)
80002540:	93078793          	addi	a5,a5,-1744 # 80007930 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007931>
80002544:	10440993          	addi	s3,s0,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80002548:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
8000254c:	01010793          	addi	a5,sp,16
80002550:	07000613          	li	a2,112
80002554:	00000593          	li	a1,0
80002558:	00078513          	mv	a0,a5
{
8000255c:	08112e23          	sw	ra,156(sp)
80002560:	08912a23          	sw	s1,148(sp)
80002564:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80002568:	a7dff0ef          	jal	ra,80001fe4 <memset>
8000256c:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80002570:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80002574:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
80002578:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
8000257c:	e05ff0ef          	jal	ra,80002380 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80002580:	00100513          	li	a0,1
80002584:	dfdff0ef          	jal	ra,80002380 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80002588:	10100793          	li	a5,257
8000258c:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80002590:	794010ef          	jal	ra,80003d24 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80002594:	800067b7          	lui	a5,0x80006
80002598:	99878793          	addi	a5,a5,-1640 # 80005998 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005999>
	_kernel.ready_q.cache = _main_thread;
8000259c:	80006937          	lui	s2,0x80006
	z_setup_new_thread(_main_thread, _main_stack,
800025a0:	00f12223          	sw	a5,4(sp)
800025a4:	800026b7          	lui	a3,0x80002
800025a8:	00100793          	li	a5,1
800025ac:	800075b7          	lui	a1,0x80007
	_kernel.ready_q.cache = _main_thread;
800025b0:	09490493          	addi	s1,s2,148 # 80006094 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006095>
	z_setup_new_thread(_main_thread, _main_stack,
800025b4:	00f12023          	sw	a5,0(sp)
800025b8:	00000713          	li	a4,0
800025bc:	00000793          	li	a5,0
800025c0:	00000893          	li	a7,0
800025c4:	00000813          	li	a6,0
800025c8:	4e068693          	addi	a3,a3,1248 # 800024e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800024e1>
800025cc:	20000613          	li	a2,512
800025d0:	d3058593          	addi	a1,a1,-720 # 80006d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d31>
800025d4:	09490513          	addi	a0,s2,148
	_kernel.ready_q.cache = _main_thread;
800025d8:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800025dc:	32d010ef          	jal	ra,80004108 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
800025e0:	00d4c783          	lbu	a5,13(s1)
800025e4:	10440413          	addi	s0,s0,260
800025e8:	ffb7f713          	andi	a4,a5,-5
800025ec:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800025f0:	01b7f793          	andi	a5,a5,27
800025f4:	00079a63          	bnez	a5,80002608 <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
800025f8:	0184a783          	lw	a5,24(s1)
800025fc:	00079663          	bnez	a5,80002608 <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80002600:	09490513          	addi	a0,s2,148
80002604:	501000ef          	jal	ra,80003304 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80002608:	800067b7          	lui	a5,0x80006
8000260c:	9a078793          	addi	a5,a5,-1632 # 800059a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a1>
80002610:	00f12223          	sw	a5,4(sp)
80002614:	80006537          	lui	a0,0x80006
80002618:	00100793          	li	a5,1
8000261c:	800026b7          	lui	a3,0x80002
80002620:	800075b7          	lui	a1,0x80007
80002624:	02450493          	addi	s1,a0,36 # 80006024 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006025>
80002628:	00f12023          	sw	a5,0(sp)
8000262c:	00f00893          	li	a7,15
80002630:	00000813          	li	a6,0
80002634:	00000793          	li	a5,0
80002638:	00000713          	li	a4,0
8000263c:	48868693          	addi	a3,a3,1160 # 80002488 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002489>
80002640:	20000613          	li	a2,512
80002644:	f3058593          	addi	a1,a1,-208 # 80006f30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f31>
80002648:	02450513          	addi	a0,a0,36
8000264c:	2bd010ef          	jal	ra,80004108 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80002650:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80002654:	00942623          	sw	s1,12(s0)
80002658:	00800513          	li	a0,8
8000265c:	ffb7f793          	andi	a5,a5,-5
80002660:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80002664:	800067b7          	lui	a5,0x80006
80002668:	11c78793          	addi	a5,a5,284 # 8000611c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000611d>
8000266c:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80002670:	00f42e23          	sw	a5,28(s0)
80002674:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80002678:	00857513          	andi	a0,a0,8
8000267c:	badfd0ef          	jal	ra,80000228 <__swap>

80002680 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80002680:	ff010113          	addi	sp,sp,-16
80002684:	00812423          	sw	s0,8(sp)
80002688:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000268c:	80006437          	lui	s0,0x80006
80002690:	800064b7          	lui	s1,0x80006
{
80002694:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80002698:	cd840413          	addi	s0,s0,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
8000269c:	d1048493          	addi	s1,s1,-752 # 80005d10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d11>
800026a0:	00946e63          	bltu	s0,s1,800026bc <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
800026a4:	00c12083          	lw	ra,12(sp)
800026a8:	00812403          	lw	s0,8(sp)
800026ac:	00412483          	lw	s1,4(sp)
800026b0:	00000513          	li	a0,0
800026b4:	01010113          	addi	sp,sp,16
800026b8:	00008067          	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800026bc:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800026c0:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800026c4:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800026c8:	00f42c23          	sw	a5,24(s0)
800026cc:	e7cfe0ef          	jal	ra,80000d48 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800026d0:	01c40413          	addi	s0,s0,28
800026d4:	fcdff06f          	j	800026a0 <init_static_pools+0x20>

800026d8 <k_mem_pool_alloc>:
		     size_t size, s32_t timeout)
{
	int ret;
	s64_t end = 0;

	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
800026d8:	800067b7          	lui	a5,0x80006
800026dc:	1047a783          	lw	a5,260(a5) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
{
800026e0:	fb010113          	addi	sp,sp,-80
800026e4:	04912223          	sw	s1,68(sp)
800026e8:	03312e23          	sw	s3,60(sp)
800026ec:	03412c23          	sw	s4,56(sp)
800026f0:	03712623          	sw	s7,44(sp)
800026f4:	04112623          	sw	ra,76(sp)
800026f8:	04812423          	sw	s0,72(sp)
800026fc:	05212023          	sw	s2,64(sp)
80002700:	03512a23          	sw	s5,52(sp)
80002704:	03612823          	sw	s6,48(sp)
80002708:	03812423          	sw	s8,40(sp)
8000270c:	03912223          	sw	s9,36(sp)
80002710:	03a12023          	sw	s10,32(sp)
80002714:	01b12e23          	sw	s11,28(sp)
80002718:	00050a13          	mv	s4,a0
8000271c:	00058993          	mv	s3,a1
80002720:	00060b93          	mv	s7,a2
80002724:	00068493          	mv	s1,a3
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80002728:	16078263          	beqz	a5,8000288c <k_mem_pool_alloc+0x1b4>
8000272c:	12069463          	bnez	a3,80002854 <k_mem_pool_alloc+0x17c>
	s64_t end = 0;
80002730:	00000913          	li	s2,0
	return pool - &_k_mem_pool_list_start[0];
80002734:	80006437          	lui	s0,0x80006
80002738:	cd840413          	addi	s0,s0,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
8000273c:	408a0433          	sub	s0,s4,s0
80002740:	b6db77b7          	lui	a5,0xb6db7
80002744:	40245413          	srai	s0,s0,0x2
80002748:	db778793          	addi	a5,a5,-585 # b6db6db7 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xb6db6db8>
8000274c:	02f40433          	mul	s0,s0,a5
		if (ret == -EAGAIN) {
			ret = -ENOMEM;
		}

		block->id.pool = pool_id(p);
		block->id.level = level_num;
80002750:	fffffab7          	lui	s5,0xfffff
		block->id.block = block_num;
80002754:	00001b37          	lui	s6,0x1
			if (ret != -EAGAIN) {
80002758:	ff500c13          	li	s8,-11
			ret = -ENOMEM;
8000275c:	ff400c93          	li	s9,-12
		block->id.level = level_num;
80002760:	0ffa8a93          	addi	s5,s5,255 # fffff0ff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xfffff100>
		block->id.block = block_num;
80002764:	fffb0b13          	addi	s6,s6,-1 # fff <CONFIG_ISR_STACK_SIZE+0x7ff>
80002768:	00800d13          	li	s10,8
		if (ret == 0 || timeout == K_NO_WAIT ||
		    ret != -ENOMEM) {
			return ret;
		}

		z_pend_curr_unlocked(&p->wait_q, timeout);
8000276c:	014a0d93          	addi	s11,s4,20
		block->id.pool = pool_id(p);
80002770:	0ff47413          	andi	s0,s0,255
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002774:	00098713          	mv	a4,s3
80002778:	00c10693          	addi	a3,sp,12
8000277c:	00810613          	addi	a2,sp,8
80002780:	000b8593          	mv	a1,s7
80002784:	000a0513          	mv	a0,s4
80002788:	ec0fe0ef          	jal	ra,80000e48 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
8000278c:	03851263          	bne	a0,s8,800027b0 <k_mem_pool_alloc+0xd8>
			ret = z_sys_mem_pool_block_alloc(&p->base, size,
80002790:	00098713          	mv	a4,s3
80002794:	00c10693          	addi	a3,sp,12
80002798:	00810613          	addi	a2,sp,8
8000279c:	000b8593          	mv	a1,s7
800027a0:	000a0513          	mv	a0,s4
800027a4:	ea4fe0ef          	jal	ra,80000e48 <z_sys_mem_pool_block_alloc>
			if (ret != -EAGAIN) {
800027a8:	01851463          	bne	a0,s8,800027b0 <k_mem_pool_alloc+0xd8>
			ret = -ENOMEM;
800027ac:	ff400513          	li	a0,-12
		block->id.level = level_num;
800027b0:	00812783          	lw	a5,8(sp)
		block->id.pool = pool_id(p);
800027b4:	00898223          	sb	s0,4(s3)
		block->id.level = level_num;
800027b8:	00f7f793          	andi	a5,a5,15
800027bc:	00879713          	slli	a4,a5,0x8
800027c0:	0049a783          	lw	a5,4(s3)
800027c4:	0157f7b3          	and	a5,a5,s5
800027c8:	00e7e7b3          	or	a5,a5,a4
		block->id.block = block_num;
800027cc:	00c12703          	lw	a4,12(sp)
800027d0:	0167f7b3          	and	a5,a5,s6
800027d4:	00c71713          	slli	a4,a4,0xc
800027d8:	00e7e7b3          	or	a5,a5,a4
800027dc:	00f9a223          	sw	a5,4(s3)
		if (ret == 0 || timeout == K_NO_WAIT ||
800027e0:	02050c63          	beqz	a0,80002818 <k_mem_pool_alloc+0x140>
800027e4:	02048a63          	beqz	s1,80002818 <k_mem_pool_alloc+0x140>
800027e8:	03951863          	bne	a0,s9,80002818 <k_mem_pool_alloc+0x140>
800027ec:	300d3573          	csrrc	a0,mstatus,s10
	(void) z_pend_curr_irqlock(z_arch_irq_lock(), wait_q, timeout);
800027f0:	00048613          	mv	a2,s1
800027f4:	000d8593          	mv	a1,s11
800027f8:	00857513          	andi	a0,a0,8
800027fc:	250010ef          	jal	ra,80003a4c <z_pend_curr_irqlock>

		if (timeout != K_FOREVER) {
80002800:	fff00793          	li	a5,-1
80002804:	f6f488e3          	beq	s1,a5,80002774 <k_mem_pool_alloc+0x9c>
			timeout = end - z_tick_get();
80002808:	658020ef          	jal	ra,80004e60 <z_tick_get>
8000280c:	40a904b3          	sub	s1,s2,a0

			if (timeout < 0) {
80002810:	f604d2e3          	bgez	s1,80002774 <k_mem_pool_alloc+0x9c>
				break;
			}
		}
	}

	return -EAGAIN;
80002814:	ff500513          	li	a0,-11
}
80002818:	04c12083          	lw	ra,76(sp)
8000281c:	04812403          	lw	s0,72(sp)
80002820:	04412483          	lw	s1,68(sp)
80002824:	04012903          	lw	s2,64(sp)
80002828:	03c12983          	lw	s3,60(sp)
8000282c:	03812a03          	lw	s4,56(sp)
80002830:	03412a83          	lw	s5,52(sp)
80002834:	03012b03          	lw	s6,48(sp)
80002838:	02c12b83          	lw	s7,44(sp)
8000283c:	02812c03          	lw	s8,40(sp)
80002840:	02412c83          	lw	s9,36(sp)
80002844:	02012d03          	lw	s10,32(sp)
80002848:	01c12d83          	lw	s11,28(sp)
8000284c:	05010113          	addi	sp,sp,80
80002850:	00008067          	ret
	__ASSERT(!(z_is_in_isr() && timeout != K_NO_WAIT), "");
80002854:	80006437          	lui	s0,0x80006
80002858:	800065b7          	lui	a1,0x80006
8000285c:	80005537          	lui	a0,0x80005
80002860:	9bc58593          	addi	a1,a1,-1604 # 800059bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059bd>
80002864:	03900693          	li	a3,57
80002868:	9a840613          	addi	a2,s0,-1624 # 800059a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059a9>
8000286c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002870:	9d4ff0ef          	jal	ra,80001a44 <printk>
80002874:	80005537          	lui	a0,0x80005
80002878:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
8000287c:	9c8ff0ef          	jal	ra,80001a44 <printk>
80002880:	03900593          	li	a1,57
80002884:	9a840513          	addi	a0,s0,-1624
80002888:	9f8ff0ef          	jal	ra,80001a80 <assert_post_action>
	if (timeout > 0) {
8000288c:	ea9052e3          	blez	s1,80002730 <k_mem_pool_alloc+0x58>
		end = z_tick_get() + z_ms_to_ticks(timeout);
80002890:	5d0020ef          	jal	ra,80004e60 <z_tick_get>
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80002894:	00948913          	addi	s2,s1,9
80002898:	00a00793          	li	a5,10
8000289c:	02f94933          	div	s2,s2,a5
800028a0:	00a90933          	add	s2,s2,a0
800028a4:	e91ff06f          	j	80002734 <k_mem_pool_alloc+0x5c>

800028a8 <k_mem_pool_free_id>:

void k_mem_pool_free_id(struct k_mem_block_id *id)
{
800028a8:	fe010113          	addi	sp,sp,-32
800028ac:	01212823          	sw	s2,16(sp)
800028b0:	00054903          	lbu	s2,0(a0)
800028b4:	01c00793          	li	a5,28
	int need_sched = 0;
	struct k_mem_pool *p = get_pool(id->pool);

	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800028b8:	00052603          	lw	a2,0(a0)
800028bc:	02f90933          	mul	s2,s2,a5
{
800028c0:	01312623          	sw	s3,12(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800028c4:	800069b7          	lui	s3,0x80006
800028c8:	00865593          	srli	a1,a2,0x8
800028cc:	cd898513          	addi	a0,s3,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
800028d0:	00c65613          	srli	a2,a2,0xc
800028d4:	00f5f593          	andi	a1,a1,15
{
800028d8:	00812c23          	sw	s0,24(sp)
800028dc:	00112e23          	sw	ra,28(sp)
800028e0:	00912a23          	sw	s1,20(sp)
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800028e4:	01250533          	add	a0,a0,s2
{
800028e8:	01412423          	sw	s4,8(sp)
800028ec:	00800413          	li	s0,8
	z_sys_mem_pool_block_free(&p->base, id->level, id->block);
800028f0:	821fe0ef          	jal	ra,80001110 <z_sys_mem_pool_block_free>
800028f4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800028f8:	800064b7          	lui	s1,0x80006
800028fc:	d5448513          	addi	a0,s1,-684 # 80005d54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d55>
80002900:	0d5010ef          	jal	ra,800041d4 <z_spin_lock_valid>
	key = (mstatus & SOC_MSTATUS_IEN);
80002904:	00847413          	andi	s0,s0,8
80002908:	cd898993          	addi	s3,s3,-808
8000290c:	02051e63          	bnez	a0,80002948 <k_mem_pool_free_id+0xa0>
80002910:	80005a37          	lui	s4,0x80005
80002914:	800055b7          	lui	a1,0x80005
80002918:	80005537          	lui	a0,0x80005
8000291c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80002920:	04e00693          	li	a3,78
80002924:	7b4a0613          	addi	a2,s4,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002928:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000292c:	918ff0ef          	jal	ra,80001a44 <printk>
80002930:	80005537          	lui	a0,0x80005
80002934:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80002938:	90cff0ef          	jal	ra,80001a44 <printk>
8000293c:	04e00593          	li	a1,78
80002940:	7b4a0513          	addi	a0,s4,1972
80002944:	93cff0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80002948:	d5448513          	addi	a0,s1,-684
8000294c:	0e1010ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	 * is unsynchronized.  Maybe we want to put the lock into the
	 * wait_q instead and make the API safe?)
	 */
	k_spinlock_key_t key = k_spin_lock(&lock);

	need_sched = z_unpend_all(&p->wait_q);
80002950:	01490513          	addi	a0,s2,20
80002954:	00a98533          	add	a0,s3,a0
80002958:	364010ef          	jal	ra,80003cbc <z_unpend_all>

	if (need_sched != 0) {
8000295c:	02050663          	beqz	a0,80002988 <k_mem_pool_free_id+0xe0>
		z_reschedule(&lock, key);
80002960:	00040593          	mv	a1,s0
	} else {
		k_spin_unlock(&lock, key);
	}
}
80002964:	01812403          	lw	s0,24(sp)
80002968:	01c12083          	lw	ra,28(sp)
8000296c:	01012903          	lw	s2,16(sp)
80002970:	00c12983          	lw	s3,12(sp)
80002974:	00812a03          	lw	s4,8(sp)
		z_reschedule(&lock, key);
80002978:	d5448513          	addi	a0,s1,-684
}
8000297c:	01412483          	lw	s1,20(sp)
80002980:	02010113          	addi	sp,sp,32
		z_reschedule(&lock, key);
80002984:	3340006f          	j	80002cb8 <z_reschedule>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002988:	d5448513          	addi	a0,s1,-684
8000298c:	071010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002990:	02051e63          	bnez	a0,800029cc <k_mem_pool_free_id+0x124>
80002994:	800054b7          	lui	s1,0x80005
80002998:	800055b7          	lui	a1,0x80005
8000299c:	80005537          	lui	a0,0x80005
800029a0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800029a4:	06100693          	li	a3,97
800029a8:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800029ac:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800029b0:	894ff0ef          	jal	ra,80001a44 <printk>
800029b4:	80006537          	lui	a0,0x80006
800029b8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
800029bc:	888ff0ef          	jal	ra,80001a44 <printk>
800029c0:	06100593          	li	a1,97
800029c4:	7b448513          	addi	a0,s1,1972
800029c8:	8b8ff0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800029cc:	30042473          	csrrs	s0,mstatus,s0
}
800029d0:	01c12083          	lw	ra,28(sp)
800029d4:	01812403          	lw	s0,24(sp)
800029d8:	01412483          	lw	s1,20(sp)
800029dc:	01012903          	lw	s2,16(sp)
800029e0:	00c12983          	lw	s3,12(sp)
800029e4:	00812a03          	lw	s4,8(sp)
800029e8:	02010113          	addi	sp,sp,32
800029ec:	00008067          	ret

800029f0 <k_mem_pool_free>:

void k_mem_pool_free(struct k_mem_block *block)
{
	k_mem_pool_free_id(&block->id);
800029f0:	00450513          	addi	a0,a0,4
800029f4:	eb5ff06f          	j	800028a8 <k_mem_pool_free_id>

800029f8 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800029f8:	00d54783          	lbu	a5,13(a0)
800029fc:	01f7f793          	andi	a5,a5,31
80002a00:	00079863          	bnez	a5,80002a10 <z_is_thread_ready+0x18>
80002a04:	01852503          	lw	a0,24(a0)
80002a08:	00153513          	seqz	a0,a0
80002a0c:	00008067          	ret
80002a10:	00000513          	li	a0,0
}
80002a14:	00008067          	ret

80002a18 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80002a18:	ff010113          	addi	sp,sp,-16
80002a1c:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002a20:	cb0ff0ef          	jal	ra,80001ed0 <z_clock_elapsed>
80002a24:	800067b7          	lui	a5,0x80006
80002a28:	d607a783          	lw	a5,-672(a5) # 80005d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d61>

	z_set_timeout_expiry(slice_time, false);
}
80002a2c:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80002a30:	80006737          	lui	a4,0x80006
80002a34:	00a78533          	add	a0,a5,a0
80002a38:	10a72a23          	sw	a0,276(a4) # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
	z_set_timeout_expiry(slice_time, false);
80002a3c:	00000593          	li	a1,0
80002a40:	00078513          	mv	a0,a5
}
80002a44:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80002a48:	0b40206f          	j	80004afc <z_set_timeout_expiry>

80002a4c <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80002a4c:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80002a50:	ff010113          	addi	sp,sp,-16
80002a54:	00812423          	sw	s0,8(sp)
80002a58:	00112623          	sw	ra,12(sp)
80002a5c:	00912223          	sw	s1,4(sp)
80002a60:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80002a64:	02079863          	bnez	a5,80002a94 <pended_on.isra.15+0x48>
80002a68:	800064b7          	lui	s1,0x80006
80002a6c:	800065b7          	lui	a1,0x80006
80002a70:	80005537          	lui	a0,0x80005
80002a74:	a8058593          	addi	a1,a1,-1408 # 80005a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a81>
80002a78:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002a7c:	18300693          	li	a3,387
80002a80:	a6c48613          	addi	a2,s1,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
80002a84:	fc1fe0ef          	jal	ra,80001a44 <printk>
80002a88:	18300593          	li	a1,387
80002a8c:	a6c48513          	addi	a0,s1,-1428
80002a90:	ff1fe0ef          	jal	ra,80001a80 <assert_post_action>

	return thread->base.pended_on;
}
80002a94:	00042503          	lw	a0,0(s0)
80002a98:	00c12083          	lw	ra,12(sp)
80002a9c:	00812403          	lw	s0,8(sp)
80002aa0:	00412483          	lw	s1,4(sp)
80002aa4:	01010113          	addi	sp,sp,16
80002aa8:	00008067          	ret

80002aac <k_sched_time_slice_set>:
{
80002aac:	fe010113          	addi	sp,sp,-32
80002ab0:	00812c23          	sw	s0,24(sp)
80002ab4:	01212823          	sw	s2,16(sp)
80002ab8:	01412423          	sw	s4,8(sp)
80002abc:	00112e23          	sw	ra,28(sp)
80002ac0:	00912a23          	sw	s1,20(sp)
80002ac4:	01312623          	sw	s3,12(sp)
80002ac8:	00050913          	mv	s2,a0
80002acc:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ad0:	00800413          	li	s0,8
80002ad4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002ad8:	800064b7          	lui	s1,0x80006
80002adc:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ae0:	00847413          	andi	s0,s0,8
80002ae4:	6f0010ef          	jal	ra,800041d4 <z_spin_lock_valid>
80002ae8:	02051e63          	bnez	a0,80002b24 <k_sched_time_slice_set+0x78>
80002aec:	800059b7          	lui	s3,0x80005
80002af0:	800055b7          	lui	a1,0x80005
80002af4:	80005537          	lui	a0,0x80005
80002af8:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80002afc:	04e00693          	li	a3,78
80002b00:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002b04:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002b08:	f3dfe0ef          	jal	ra,80001a44 <printk>
80002b0c:	80005537          	lui	a0,0x80005
80002b10:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80002b14:	f31fe0ef          	jal	ra,80001a44 <printk>
80002b18:	04e00593          	li	a1,78
80002b1c:	7b498513          	addi	a0,s3,1972
80002b20:	f61fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b24:	d5848513          	addi	a0,s1,-680
80002b28:	704010ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80002b2c:	800067b7          	lui	a5,0x80006
80002b30:	1007aa23          	sw	zero,276(a5) # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
80002b34:	00990913          	addi	s2,s2,9
80002b38:	00a00793          	li	a5,10
80002b3c:	02f94933          	div	s2,s2,a5
		slice_time = z_ms_to_ticks(slice);
80002b40:	800067b7          	lui	a5,0x80006
80002b44:	d727a023          	sw	s2,-672(a5) # 80005d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d61>
		slice_max_prio = prio;
80002b48:	800067b7          	lui	a5,0x80006
80002b4c:	d547ae23          	sw	s4,-676(a5) # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
		reset_time_slice();
80002b50:	ec9ff0ef          	jal	ra,80002a18 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b54:	d5848513          	addi	a0,s1,-680
80002b58:	6a4010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002b5c:	02051e63          	bnez	a0,80002b98 <k_sched_time_slice_set+0xec>
80002b60:	800054b7          	lui	s1,0x80005
80002b64:	800055b7          	lui	a1,0x80005
80002b68:	80005537          	lui	a0,0x80005
80002b6c:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80002b70:	06100693          	li	a3,97
80002b74:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002b78:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002b7c:	ec9fe0ef          	jal	ra,80001a44 <printk>
80002b80:	80006537          	lui	a0,0x80006
80002b84:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80002b88:	ebdfe0ef          	jal	ra,80001a44 <printk>
80002b8c:	06100593          	li	a1,97
80002b90:	7b448513          	addi	a0,s1,1972
80002b94:	eedfe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b98:	30042473          	csrrs	s0,mstatus,s0
}
80002b9c:	01c12083          	lw	ra,28(sp)
80002ba0:	01812403          	lw	s0,24(sp)
80002ba4:	01412483          	lw	s1,20(sp)
80002ba8:	01012903          	lw	s2,16(sp)
80002bac:	00c12983          	lw	s3,12(sp)
80002bb0:	00812a03          	lw	s4,8(sp)
80002bb4:	02010113          	addi	sp,sp,32
80002bb8:	00008067          	ret

80002bbc <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80002bbc:	fe010113          	addi	sp,sp,-32
80002bc0:	00812c23          	sw	s0,24(sp)
80002bc4:	01212823          	sw	s2,16(sp)
80002bc8:	00112e23          	sw	ra,28(sp)
80002bcc:	00912a23          	sw	s1,20(sp)
80002bd0:	01312623          	sw	s3,12(sp)
80002bd4:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002bd8:	00800413          	li	s0,8
80002bdc:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002be0:	800064b7          	lui	s1,0x80006
80002be4:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002be8:	00847413          	andi	s0,s0,8
80002bec:	5e8010ef          	jal	ra,800041d4 <z_spin_lock_valid>
80002bf0:	02051e63          	bnez	a0,80002c2c <z_unpend_thread_no_timeout+0x70>
80002bf4:	800059b7          	lui	s3,0x80005
80002bf8:	800055b7          	lui	a1,0x80005
80002bfc:	80005537          	lui	a0,0x80005
80002c00:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80002c04:	04e00693          	li	a3,78
80002c08:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002c0c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002c10:	e35fe0ef          	jal	ra,80001a44 <printk>
80002c14:	80005537          	lui	a0,0x80005
80002c18:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80002c1c:	e29fe0ef          	jal	ra,80001a44 <printk>
80002c20:	04e00593          	li	a1,78
80002c24:	7b498513          	addi	a0,s3,1972
80002c28:	e59fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80002c2c:	d5848513          	addi	a0,s1,-680
80002c30:	5fc010ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002c34:	00890513          	addi	a0,s2,8
80002c38:	e15ff0ef          	jal	ra,80002a4c <pended_on.isra.15>
80002c3c:	00090593          	mv	a1,s2
80002c40:	2f0000ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002c44:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c48:	d5848513          	addi	a0,s1,-680
80002c4c:	ffd7f793          	andi	a5,a5,-3
80002c50:	00f906a3          	sb	a5,13(s2)
80002c54:	5a8010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002c58:	02051e63          	bnez	a0,80002c94 <z_unpend_thread_no_timeout+0xd8>
80002c5c:	800054b7          	lui	s1,0x80005
80002c60:	800055b7          	lui	a1,0x80005
80002c64:	80005537          	lui	a0,0x80005
80002c68:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80002c6c:	06100693          	li	a3,97
80002c70:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002c74:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002c78:	dcdfe0ef          	jal	ra,80001a44 <printk>
80002c7c:	80006537          	lui	a0,0x80006
80002c80:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80002c84:	dc1fe0ef          	jal	ra,80001a44 <printk>
80002c88:	06100593          	li	a1,97
80002c8c:	7b448513          	addi	a0,s1,1972
80002c90:	df1fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002c94:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80002c98:	01c12083          	lw	ra,28(sp)
80002c9c:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80002ca0:	00092423          	sw	zero,8(s2)
}
80002ca4:	01412483          	lw	s1,20(sp)
80002ca8:	01012903          	lw	s2,16(sp)
80002cac:	00c12983          	lw	s3,12(sp)
80002cb0:	02010113          	addi	sp,sp,32
80002cb4:	00008067          	ret

80002cb8 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80002cb8:	800067b7          	lui	a5,0x80006
80002cbc:	1047a783          	lw	a5,260(a5) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
{
80002cc0:	ff010113          	addi	sp,sp,-16
80002cc4:	00812423          	sw	s0,8(sp)
80002cc8:	00112623          	sw	ra,12(sp)
80002ccc:	00912223          	sw	s1,4(sp)
80002cd0:	00058413          	mv	s0,a1
	if (resched()) {
80002cd4:	04079e63          	bnez	a5,80002d30 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002cd8:	524010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002cdc:	02051e63          	bnez	a0,80002d18 <z_reschedule+0x60>
80002ce0:	800054b7          	lui	s1,0x80005
80002ce4:	800055b7          	lui	a1,0x80005
80002ce8:	80005537          	lui	a0,0x80005
80002cec:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80002cf0:	07800693          	li	a3,120
80002cf4:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002cf8:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002cfc:	d49fe0ef          	jal	ra,80001a44 <printk>
80002d00:	80006537          	lui	a0,0x80006
80002d04:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80002d08:	d3dfe0ef          	jal	ra,80001a44 <printk>
80002d0c:	07800593          	li	a1,120
80002d10:	7b448513          	addi	a0,s1,1972
80002d14:	d6dfe0ef          	jal	ra,80001a80 <assert_post_action>
80002d18:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002d1c:	00812403          	lw	s0,8(sp)
80002d20:	00c12083          	lw	ra,12(sp)
80002d24:	00412483          	lw	s1,4(sp)
80002d28:	01010113          	addi	sp,sp,16
80002d2c:	cfcfd06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d30:	4cc010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002d34:	02051e63          	bnez	a0,80002d70 <z_reschedule+0xb8>
80002d38:	800054b7          	lui	s1,0x80005
80002d3c:	800055b7          	lui	a1,0x80005
80002d40:	80005537          	lui	a0,0x80005
80002d44:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80002d48:	06100693          	li	a3,97
80002d4c:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002d50:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002d54:	cf1fe0ef          	jal	ra,80001a44 <printk>
80002d58:	80006537          	lui	a0,0x80006
80002d5c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80002d60:	ce5fe0ef          	jal	ra,80001a44 <printk>
80002d64:	06100593          	li	a1,97
80002d68:	7b448513          	addi	a0,s1,1972
80002d6c:	d15fe0ef          	jal	ra,80001a80 <assert_post_action>
			  : "r" (key & SOC_MSTATUS_IEN)
80002d70:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002d74:	30042473          	csrrs	s0,mstatus,s0
80002d78:	00c12083          	lw	ra,12(sp)
80002d7c:	00812403          	lw	s0,8(sp)
80002d80:	00412483          	lw	s1,4(sp)
80002d84:	01010113          	addi	sp,sp,16
80002d88:	00008067          	ret

80002d8c <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002d8c:	80006737          	lui	a4,0x80006
80002d90:	10472703          	lw	a4,260(a4) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80002d94:	00071463          	bnez	a4,80002d9c <z_reschedule_irqlock+0x10>
80002d98:	c90fd06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002d9c:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002da0:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002da4:	00008067          	ret

80002da8 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002da8:	00800513          	li	a0,8
80002dac:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002db0:	00857513          	andi	a0,a0,8
80002db4:	fd9ff06f          	j	80002d8c <z_reschedule_irqlock>

80002db8 <k_sched_lock>:

void k_sched_lock(void)
{
80002db8:	fe010113          	addi	sp,sp,-32
80002dbc:	00812c23          	sw	s0,24(sp)
80002dc0:	00112e23          	sw	ra,28(sp)
80002dc4:	00912a23          	sw	s1,20(sp)
80002dc8:	01212823          	sw	s2,16(sp)
80002dcc:	01312623          	sw	s3,12(sp)
80002dd0:	00800413          	li	s0,8
80002dd4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002dd8:	800064b7          	lui	s1,0x80006
80002ddc:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002de0:	00847413          	andi	s0,s0,8
80002de4:	3f0010ef          	jal	ra,800041d4 <z_spin_lock_valid>
80002de8:	02051e63          	bnez	a0,80002e24 <k_sched_lock+0x6c>
80002dec:	80005937          	lui	s2,0x80005
80002df0:	800055b7          	lui	a1,0x80005
80002df4:	80005537          	lui	a0,0x80005
80002df8:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80002dfc:	04e00693          	li	a3,78
80002e00:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002e04:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002e08:	c3dfe0ef          	jal	ra,80001a44 <printk>
80002e0c:	80005537          	lui	a0,0x80005
80002e10:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80002e14:	c31fe0ef          	jal	ra,80001a44 <printk>
80002e18:	04e00593          	li	a1,78
80002e1c:	7b490513          	addi	a0,s2,1972
80002e20:	c61fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e24:	d5848513          	addi	a0,s1,-680
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
80002e28:	80006937          	lui	s2,0x80006
80002e2c:	400010ef          	jal	ra,8000422c <z_spin_lock_set_owner>
80002e30:	10492783          	lw	a5,260(s2) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80002e34:	10490913          	addi	s2,s2,260
80002e38:	02078e63          	beqz	a5,80002e74 <k_sched_lock+0xbc>
80002e3c:	800069b7          	lui	s3,0x80006
80002e40:	800065b7          	lui	a1,0x80006
80002e44:	80005537          	lui	a0,0x80005
80002e48:	a0458593          	addi	a1,a1,-1532 # 80005a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a05>
80002e4c:	10000693          	li	a3,256
80002e50:	9e898613          	addi	a2,s3,-1560 # 800059e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059e9>
80002e54:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002e58:	bedfe0ef          	jal	ra,80001a44 <printk>
80002e5c:	80005537          	lui	a0,0x80005
80002e60:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80002e64:	be1fe0ef          	jal	ra,80001a44 <printk>
80002e68:	10000593          	li	a1,256
80002e6c:	9e898513          	addi	a0,s3,-1560
80002e70:	c11fe0ef          	jal	ra,80001a80 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
80002e74:	00892783          	lw	a5,8(s2)
80002e78:	00f7c703          	lbu	a4,15(a5)
80002e7c:	00100793          	li	a5,1
80002e80:	02f71e63          	bne	a4,a5,80002ebc <k_sched_lock+0x104>
80002e84:	800069b7          	lui	s3,0x80006
80002e88:	800065b7          	lui	a1,0x80006
80002e8c:	80005537          	lui	a0,0x80005
80002e90:	a1c58593          	addi	a1,a1,-1508 # 80005a1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a1d>
80002e94:	10100693          	li	a3,257
80002e98:	9e898613          	addi	a2,s3,-1560 # 800059e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800059e9>
80002e9c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002ea0:	ba5fe0ef          	jal	ra,80001a44 <printk>
80002ea4:	80005537          	lui	a0,0x80005
80002ea8:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80002eac:	b99fe0ef          	jal	ra,80001a44 <printk>
80002eb0:	10100593          	li	a1,257
80002eb4:	9e898513          	addi	a0,s3,-1560
80002eb8:	bc9fe0ef          	jal	ra,80001a80 <assert_post_action>

	--_current->base.sched_locked;
80002ebc:	00892703          	lw	a4,8(s2)
80002ec0:	00f74783          	lbu	a5,15(a4)
80002ec4:	fff78793          	addi	a5,a5,-1
80002ec8:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002ecc:	d5848513          	addi	a0,s1,-680
80002ed0:	32c010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80002ed4:	02051e63          	bnez	a0,80002f10 <k_sched_lock+0x158>
80002ed8:	800054b7          	lui	s1,0x80005
80002edc:	800055b7          	lui	a1,0x80005
80002ee0:	80005537          	lui	a0,0x80005
80002ee4:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80002ee8:	06100693          	li	a3,97
80002eec:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002ef0:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002ef4:	b51fe0ef          	jal	ra,80001a44 <printk>
80002ef8:	80006537          	lui	a0,0x80006
80002efc:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80002f00:	b45fe0ef          	jal	ra,80001a44 <printk>
80002f04:	06100593          	li	a1,97
80002f08:	7b448513          	addi	a0,s1,1972
80002f0c:	b75fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002f10:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
80002f14:	01c12083          	lw	ra,28(sp)
80002f18:	01812403          	lw	s0,24(sp)
80002f1c:	01412483          	lw	s1,20(sp)
80002f20:	01012903          	lw	s2,16(sp)
80002f24:	00c12983          	lw	s3,12(sp)
80002f28:	02010113          	addi	sp,sp,32
80002f2c:	00008067          	ret

80002f30 <z_priq_dumb_remove>:
	return thread == _idle_thread;
80002f30:	800067b7          	lui	a5,0x80006
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
80002f34:	ca47a783          	lw	a5,-860(a5) # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
{
80002f38:	ff010113          	addi	sp,sp,-16
80002f3c:	00812423          	sw	s0,8(sp)
80002f40:	00112623          	sw	ra,12(sp)
80002f44:	00912223          	sw	s1,4(sp)
80002f48:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
80002f4c:	02f59863          	bne	a1,a5,80002f7c <z_priq_dumb_remove+0x4c>
80002f50:	800064b7          	lui	s1,0x80006
80002f54:	800065b7          	lui	a1,0x80006
80002f58:	80005537          	lui	a0,0x80005
80002f5c:	ab858593          	addi	a1,a1,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
80002f60:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002f64:	28c00693          	li	a3,652
80002f68:	a6c48613          	addi	a2,s1,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
80002f6c:	ad9fe0ef          	jal	ra,80001a44 <printk>
80002f70:	28c00593          	li	a1,652
80002f74:	a6c48513          	addi	a0,s1,-1428
80002f78:	b09fe0ef          	jal	ra,80001a80 <assert_post_action>
	node->prev->next = node->next;
80002f7c:	00442703          	lw	a4,4(s0)
80002f80:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
80002f84:	00c12083          	lw	ra,12(sp)
80002f88:	00412483          	lw	s1,4(sp)
80002f8c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80002f90:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80002f94:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002f98:	00042223          	sw	zero,4(s0)
80002f9c:	00812403          	lw	s0,8(sp)
80002fa0:	01010113          	addi	sp,sp,16
80002fa4:	00008067          	ret

80002fa8 <z_unpend_thread>:
{
80002fa8:	fe010113          	addi	sp,sp,-32
80002fac:	00812c23          	sw	s0,24(sp)
80002fb0:	00912a23          	sw	s1,20(sp)
80002fb4:	00112e23          	sw	ra,28(sp)
80002fb8:	01212823          	sw	s2,16(sp)
80002fbc:	01312623          	sw	s3,12(sp)
80002fc0:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fc4:	00800493          	li	s1,8
80002fc8:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fcc:	80006937          	lui	s2,0x80006
80002fd0:	d5890513          	addi	a0,s2,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fd4:	0084f493          	andi	s1,s1,8
80002fd8:	1fc010ef          	jal	ra,800041d4 <z_spin_lock_valid>
80002fdc:	02051e63          	bnez	a0,80003018 <z_unpend_thread+0x70>
80002fe0:	800059b7          	lui	s3,0x80005
80002fe4:	800055b7          	lui	a1,0x80005
80002fe8:	80005537          	lui	a0,0x80005
80002fec:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80002ff0:	04e00693          	li	a3,78
80002ff4:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80002ff8:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80002ffc:	a49fe0ef          	jal	ra,80001a44 <printk>
80003000:	80005537          	lui	a0,0x80005
80003004:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003008:	a3dfe0ef          	jal	ra,80001a44 <printk>
8000300c:	04e00593          	li	a1,78
80003010:	7b498513          	addi	a0,s3,1972
80003014:	a6dfe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003018:	d5890513          	addi	a0,s2,-680
8000301c:	210010ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003020:	00840513          	addi	a0,s0,8
80003024:	a29ff0ef          	jal	ra,80002a4c <pended_on.isra.15>
80003028:	00040593          	mv	a1,s0
8000302c:	f05ff0ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003030:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003034:	d5890513          	addi	a0,s2,-680
80003038:	ffd7f793          	andi	a5,a5,-3
8000303c:	00f406a3          	sb	a5,13(s0)
80003040:	1bc010ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003044:	02051e63          	bnez	a0,80003080 <z_unpend_thread+0xd8>
80003048:	80005937          	lui	s2,0x80005
8000304c:	800055b7          	lui	a1,0x80005
80003050:	80005537          	lui	a0,0x80005
80003054:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003058:	06100693          	li	a3,97
8000305c:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003060:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003064:	9e1fe0ef          	jal	ra,80001a44 <printk>
80003068:	80006537          	lui	a0,0x80006
8000306c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003070:	9d5fe0ef          	jal	ra,80001a44 <printk>
80003074:	06100593          	li	a1,97
80003078:	7b490513          	addi	a0,s2,1972
8000307c:	a05fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003080:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003084:	00042423          	sw	zero,8(s0)
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80003088:	01840513          	addi	a0,s0,24
}
8000308c:	01812403          	lw	s0,24(sp)
80003090:	01c12083          	lw	ra,28(sp)
80003094:	01412483          	lw	s1,20(sp)
80003098:	01012903          	lw	s2,16(sp)
8000309c:	00c12983          	lw	s3,12(sp)
800030a0:	02010113          	addi	sp,sp,32
800030a4:	0850106f          	j	80004928 <z_abort_timeout>

800030a8 <z_priq_dumb_best>:
	return list->head == list;
800030a8:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800030ac:	00f51463          	bne	a0,a5,800030b4 <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
800030b0:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
800030b4:	00078513          	mv	a0,a5
800030b8:	00008067          	ret

800030bc <update_cache>:
{
800030bc:	ff010113          	addi	sp,sp,-16
800030c0:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800030c4:	80006437          	lui	s0,0x80006
{
800030c8:	01212023          	sw	s2,0(sp)
800030cc:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800030d0:	10440513          	addi	a0,s0,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
800030d4:	02450513          	addi	a0,a0,36
{
800030d8:	00912223          	sw	s1,4(sp)
800030dc:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
800030e0:	fc9ff0ef          	jal	ra,800030a8 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
800030e4:	10440413          	addi	s0,s0,260
800030e8:	00050493          	mv	s1,a0
800030ec:	00051463          	bnez	a0,800030f4 <update_cache+0x38>
800030f0:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
800030f4:	06091e63          	bnez	s2,80003170 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
800030f8:	00842783          	lw	a5,8(s0)
800030fc:	02079e63          	bnez	a5,80003138 <update_cache+0x7c>
80003100:	80006937          	lui	s2,0x80006
80003104:	800065b7          	lui	a1,0x80006
80003108:	80005537          	lui	a0,0x80005
8000310c:	a9858593          	addi	a1,a1,-1384 # 80005a98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a99>
80003110:	07f00693          	li	a3,127
80003114:	a6c90613          	addi	a2,s2,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
80003118:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000311c:	929fe0ef          	jal	ra,80001a44 <printk>
80003120:	80005537          	lui	a0,0x80005
80003124:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80003128:	91dfe0ef          	jal	ra,80001a44 <printk>
8000312c:	07f00593          	li	a1,127
80003130:	a6c90513          	addi	a0,s2,-1428
80003134:	94dfe0ef          	jal	ra,80001a80 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
80003138:	00842783          	lw	a5,8(s0)
8000313c:	00d7c703          	lbu	a4,13(a5)
80003140:	01f77713          	andi	a4,a4,31
80003144:	02071663          	bnez	a4,80003170 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
80003148:	00e7d683          	lhu	a3,14(a5)
8000314c:	07f00713          	li	a4,127
80003150:	02d77063          	bgeu	a4,a3,80003170 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
80003154:	02f42023          	sw	a5,32(s0)
}
80003158:	00c12083          	lw	ra,12(sp)
8000315c:	00812403          	lw	s0,8(sp)
80003160:	00412483          	lw	s1,4(sp)
80003164:	00012903          	lw	s2,0(sp)
80003168:	01010113          	addi	sp,sp,16
8000316c:	00008067          	ret
		if (th != _current) {
80003170:	00842783          	lw	a5,8(s0)
80003174:	00978463          	beq	a5,s1,8000317c <update_cache+0xc0>
			reset_time_slice();
80003178:	8a1ff0ef          	jal	ra,80002a18 <reset_time_slice>
		_kernel.ready_q.cache = th;
8000317c:	02942023          	sw	s1,32(s0)
}
80003180:	fd9ff06f          	j	80003158 <update_cache+0x9c>

80003184 <k_sched_unlock>:
{
80003184:	fe010113          	addi	sp,sp,-32
80003188:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
8000318c:	80006937          	lui	s2,0x80006
80003190:	10490793          	addi	a5,s2,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80003194:	0087a783          	lw	a5,8(a5)
{
80003198:	00112e23          	sw	ra,28(sp)
8000319c:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800031a0:	00f7c783          	lbu	a5,15(a5)
{
800031a4:	00912a23          	sw	s1,20(sp)
800031a8:	01312623          	sw	s3,12(sp)
800031ac:	10490913          	addi	s2,s2,260
	__ASSERT(_current->base.sched_locked != 0, "");
800031b0:	02079e63          	bnez	a5,800031ec <k_sched_unlock+0x68>
800031b4:	80006437          	lui	s0,0x80006
800031b8:	800065b7          	lui	a1,0x80006
800031bc:	80005537          	lui	a0,0x80005
800031c0:	a4458593          	addi	a1,a1,-1468 # 80005a44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a45>
800031c4:	22100693          	li	a3,545
800031c8:	a6c40613          	addi	a2,s0,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
800031cc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800031d0:	875fe0ef          	jal	ra,80001a44 <printk>
800031d4:	80005537          	lui	a0,0x80005
800031d8:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
800031dc:	869fe0ef          	jal	ra,80001a44 <printk>
800031e0:	22100593          	li	a1,545
800031e4:	a6c40513          	addi	a0,s0,-1428
800031e8:	899fe0ef          	jal	ra,80001a80 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
800031ec:	00092783          	lw	a5,0(s2)
800031f0:	02078e63          	beqz	a5,8000322c <k_sched_unlock+0xa8>
800031f4:	80006437          	lui	s0,0x80006
800031f8:	800065b7          	lui	a1,0x80006
800031fc:	80005537          	lui	a0,0x80005
80003200:	a0458593          	addi	a1,a1,-1532 # 80005a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a05>
80003204:	22200693          	li	a3,546
80003208:	a6c40613          	addi	a2,s0,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
8000320c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003210:	835fe0ef          	jal	ra,80001a44 <printk>
80003214:	80005537          	lui	a0,0x80005
80003218:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
8000321c:	829fe0ef          	jal	ra,80001a44 <printk>
80003220:	22200593          	li	a1,546
80003224:	a6c40513          	addi	a0,s0,-1428
80003228:	859fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000322c:	00800413          	li	s0,8
80003230:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003234:	800064b7          	lui	s1,0x80006
80003238:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
8000323c:	00847413          	andi	s0,s0,8
80003240:	795000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003244:	02051e63          	bnez	a0,80003280 <k_sched_unlock+0xfc>
80003248:	800059b7          	lui	s3,0x80005
8000324c:	800055b7          	lui	a1,0x80005
80003250:	80005537          	lui	a0,0x80005
80003254:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003258:	04e00693          	li	a3,78
8000325c:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003260:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003264:	fe0fe0ef          	jal	ra,80001a44 <printk>
80003268:	80005537          	lui	a0,0x80005
8000326c:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003270:	fd4fe0ef          	jal	ra,80001a44 <printk>
80003274:	04e00593          	li	a1,78
80003278:	7b498513          	addi	a0,s3,1972
8000327c:	805fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003280:	d5848513          	addi	a0,s1,-680
80003284:	7a9000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003288:	00892703          	lw	a4,8(s2)
		update_cache(1);
8000328c:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003290:	00f74783          	lbu	a5,15(a4)
80003294:	00178793          	addi	a5,a5,1
80003298:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
8000329c:	e21ff0ef          	jal	ra,800030bc <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800032a0:	d5848513          	addi	a0,s1,-680
800032a4:	759000ef          	jal	ra,800041fc <z_spin_unlock_valid>
800032a8:	02051e63          	bnez	a0,800032e4 <k_sched_unlock+0x160>
800032ac:	800054b7          	lui	s1,0x80005
800032b0:	800055b7          	lui	a1,0x80005
800032b4:	80005537          	lui	a0,0x80005
800032b8:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800032bc:	06100693          	li	a3,97
800032c0:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800032c4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800032c8:	f7cfe0ef          	jal	ra,80001a44 <printk>
800032cc:	80006537          	lui	a0,0x80006
800032d0:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
800032d4:	f70fe0ef          	jal	ra,80001a44 <printk>
800032d8:	06100593          	li	a1,97
800032dc:	7b448513          	addi	a0,s1,1972
800032e0:	fa0fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800032e4:	30042473          	csrrs	s0,mstatus,s0
}
800032e8:	01812403          	lw	s0,24(sp)
800032ec:	01c12083          	lw	ra,28(sp)
800032f0:	01412483          	lw	s1,20(sp)
800032f4:	01012903          	lw	s2,16(sp)
800032f8:	00c12983          	lw	s3,12(sp)
800032fc:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003300:	aa9ff06f          	j	80002da8 <z_reschedule_unlocked>

80003304 <z_add_thread_to_ready_q>:
{
80003304:	fe010113          	addi	sp,sp,-32
80003308:	00812c23          	sw	s0,24(sp)
8000330c:	00912a23          	sw	s1,20(sp)
80003310:	00112e23          	sw	ra,28(sp)
80003314:	01212823          	sw	s2,16(sp)
80003318:	01312623          	sw	s3,12(sp)
8000331c:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003320:	00800493          	li	s1,8
80003324:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003328:	80006937          	lui	s2,0x80006
8000332c:	d5890513          	addi	a0,s2,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003330:	0084f493          	andi	s1,s1,8
80003334:	6a1000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003338:	02051e63          	bnez	a0,80003374 <z_add_thread_to_ready_q+0x70>
8000333c:	800059b7          	lui	s3,0x80005
80003340:	800055b7          	lui	a1,0x80005
80003344:	80005537          	lui	a0,0x80005
80003348:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
8000334c:	04e00693          	li	a3,78
80003350:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003354:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003358:	eecfe0ef          	jal	ra,80001a44 <printk>
8000335c:	80005537          	lui	a0,0x80005
80003360:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003364:	ee0fe0ef          	jal	ra,80001a44 <printk>
80003368:	04e00593          	li	a1,78
8000336c:	7b498513          	addi	a0,s3,1972
80003370:	f10fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003374:	d5890513          	addi	a0,s2,-680
80003378:	6b5000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	return thread == _idle_thread;
8000337c:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003380:	ca47a783          	lw	a5,-860(a5) # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
80003384:	02f41863          	bne	s0,a5,800033b4 <z_add_thread_to_ready_q+0xb0>
80003388:	800069b7          	lui	s3,0x80006
8000338c:	800065b7          	lui	a1,0x80006
80003390:	80005537          	lui	a0,0x80005
80003394:	ab858593          	addi	a1,a1,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
80003398:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000339c:	27600693          	li	a3,630
800033a0:	a6c98613          	addi	a2,s3,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
800033a4:	ea0fe0ef          	jal	ra,80001a44 <printk>
800033a8:	27600593          	li	a1,630
800033ac:	a6c98513          	addi	a0,s3,-1428
800033b0:	ed0fe0ef          	jal	ra,80001a80 <assert_post_action>
	return list->head == list;
800033b4:	80006737          	lui	a4,0x80006
800033b8:	10470693          	addi	a3,a4,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
800033bc:	0246a783          	lw	a5,36(a3)
800033c0:	0286a603          	lw	a2,40(a3)
800033c4:	800066b7          	lui	a3,0x80006
800033c8:	12868693          	addi	a3,a3,296 # 80006128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006129>
800033cc:	10470713          	addi	a4,a4,260
	return sys_dlist_is_empty(list) ? NULL : list->head;
800033d0:	0ad78663          	beq	a5,a3,8000347c <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800033d4:	0a078463          	beqz	a5,8000347c <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
800033d8:	00e40583          	lb	a1,14(s0)
800033dc:	00e78503          	lb	a0,14(a5)
800033e0:	08a5d863          	bge	a1,a0,80003470 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
800033e4:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800033e8:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800033ec:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800033f0:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800033f4:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
800033f8:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
800033fc:	00000513          	li	a0,0
80003400:	0407e793          	ori	a5,a5,64
80003404:	00f406a3          	sb	a5,13(s0)
80003408:	cb5ff0ef          	jal	ra,800030bc <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000340c:	d5890513          	addi	a0,s2,-680
80003410:	5ed000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003414:	02051e63          	bnez	a0,80003450 <z_add_thread_to_ready_q+0x14c>
80003418:	80005437          	lui	s0,0x80005
8000341c:	800055b7          	lui	a1,0x80005
80003420:	80005537          	lui	a0,0x80005
80003424:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003428:	06100693          	li	a3,97
8000342c:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003430:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003434:	e10fe0ef          	jal	ra,80001a44 <printk>
80003438:	80006537          	lui	a0,0x80006
8000343c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003440:	e04fe0ef          	jal	ra,80001a44 <printk>
80003444:	06100593          	li	a1,97
80003448:	7b440513          	addi	a0,s0,1972
8000344c:	e34fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003450:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003454:	01c12083          	lw	ra,28(sp)
80003458:	01812403          	lw	s0,24(sp)
8000345c:	01412483          	lw	s1,20(sp)
80003460:	01012903          	lw	s2,16(sp)
80003464:	00c12983          	lw	s3,12(sp)
80003468:	02010113          	addi	sp,sp,32
8000346c:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003470:	00f60663          	beq	a2,a5,8000347c <z_add_thread_to_ready_q+0x178>
80003474:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003478:	f60792e3          	bnez	a5,800033dc <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
8000347c:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003480:	02872783          	lw	a5,40(a4)
	node->next = list;
80003484:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003488:	0087a023          	sw	s0,0(a5)
	list->tail = node;
8000348c:	02872423          	sw	s0,40(a4)
80003490:	f69ff06f          	j	800033f8 <z_add_thread_to_ready_q+0xf4>

80003494 <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003494:	ff052783          	lw	a5,-16(a0)
{
80003498:	fe010113          	addi	sp,sp,-32
8000349c:	00812c23          	sw	s0,24(sp)
800034a0:	01312623          	sw	s3,12(sp)
800034a4:	00112e23          	sw	ra,28(sp)
800034a8:	00912a23          	sw	s1,20(sp)
800034ac:	01212823          	sw	s2,16(sp)
800034b0:	01412423          	sw	s4,8(sp)
800034b4:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
800034b8:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
800034bc:	0c078463          	beqz	a5,80003584 <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800034c0:	00800493          	li	s1,8
800034c4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034c8:	80006937          	lui	s2,0x80006
800034cc:	d5890513          	addi	a0,s2,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
800034d0:	0084f493          	andi	s1,s1,8
800034d4:	501000ef          	jal	ra,800041d4 <z_spin_lock_valid>
800034d8:	02051e63          	bnez	a0,80003514 <z_thread_timeout+0x80>
800034dc:	80005a37          	lui	s4,0x80005
800034e0:	800055b7          	lui	a1,0x80005
800034e4:	80005537          	lui	a0,0x80005
800034e8:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
800034ec:	04e00693          	li	a3,78
800034f0:	7b4a0613          	addi	a2,s4,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800034f4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800034f8:	d4cfe0ef          	jal	ra,80001a44 <printk>
800034fc:	80005537          	lui	a0,0x80005
80003500:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003504:	d40fe0ef          	jal	ra,80001a44 <printk>
80003508:	04e00593          	li	a1,78
8000350c:	7b4a0513          	addi	a0,s4,1972
80003510:	d70fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003514:	d5890513          	addi	a0,s2,-680
80003518:	515000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
8000351c:	ff040513          	addi	a0,s0,-16
80003520:	d2cff0ef          	jal	ra,80002a4c <pended_on.isra.15>
80003524:	00098593          	mv	a1,s3
80003528:	a09ff0ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
8000352c:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003530:	d5890513          	addi	a0,s2,-680
80003534:	ffd7f793          	andi	a5,a5,-3
80003538:	fef40aa3          	sb	a5,-11(s0)
8000353c:	4c1000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003540:	02051e63          	bnez	a0,8000357c <z_thread_timeout+0xe8>
80003544:	80005937          	lui	s2,0x80005
80003548:	800055b7          	lui	a1,0x80005
8000354c:	80005537          	lui	a0,0x80005
80003550:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003554:	06100693          	li	a3,97
80003558:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
8000355c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003560:	ce4fe0ef          	jal	ra,80001a44 <printk>
80003564:	80006537          	lui	a0,0x80006
80003568:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
8000356c:	cd8fe0ef          	jal	ra,80001a44 <printk>
80003570:	06100593          	li	a1,97
80003574:	7b490513          	addi	a0,s2,1972
80003578:	d08fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000357c:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003580:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003584:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003588:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
8000358c:	feb7f793          	andi	a5,a5,-21
80003590:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003594:	c64ff0ef          	jal	ra,800029f8 <z_is_thread_ready>
80003598:	02050463          	beqz	a0,800035c0 <z_thread_timeout+0x12c>
}
8000359c:	01812403          	lw	s0,24(sp)
800035a0:	01c12083          	lw	ra,28(sp)
800035a4:	01412483          	lw	s1,20(sp)
800035a8:	01012903          	lw	s2,16(sp)
800035ac:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
800035b0:	00098513          	mv	a0,s3
800035b4:	00c12983          	lw	s3,12(sp)
800035b8:	02010113          	addi	sp,sp,32
800035bc:	d49ff06f          	j	80003304 <z_add_thread_to_ready_q>
800035c0:	01c12083          	lw	ra,28(sp)
800035c4:	01812403          	lw	s0,24(sp)
800035c8:	01412483          	lw	s1,20(sp)
800035cc:	01012903          	lw	s2,16(sp)
800035d0:	00c12983          	lw	s3,12(sp)
800035d4:	00812a03          	lw	s4,8(sp)
800035d8:	02010113          	addi	sp,sp,32
800035dc:	00008067          	ret

800035e0 <z_move_thread_to_end_of_prio_q>:
{
800035e0:	fe010113          	addi	sp,sp,-32
800035e4:	00812c23          	sw	s0,24(sp)
800035e8:	01212823          	sw	s2,16(sp)
800035ec:	00112e23          	sw	ra,28(sp)
800035f0:	00912a23          	sw	s1,20(sp)
800035f4:	01312623          	sw	s3,12(sp)
800035f8:	01412423          	sw	s4,8(sp)
800035fc:	01512223          	sw	s5,4(sp)
80003600:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003604:	00800913          	li	s2,8
80003608:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000360c:	800069b7          	lui	s3,0x80006
80003610:	d5898513          	addi	a0,s3,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003614:	00897913          	andi	s2,s2,8
80003618:	3bd000ef          	jal	ra,800041d4 <z_spin_lock_valid>
8000361c:	02051e63          	bnez	a0,80003658 <z_move_thread_to_end_of_prio_q+0x78>
80003620:	800054b7          	lui	s1,0x80005
80003624:	800055b7          	lui	a1,0x80005
80003628:	80005537          	lui	a0,0x80005
8000362c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003630:	04e00693          	li	a3,78
80003634:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003638:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000363c:	c08fe0ef          	jal	ra,80001a44 <printk>
80003640:	80005537          	lui	a0,0x80005
80003644:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003648:	bfcfe0ef          	jal	ra,80001a44 <printk>
8000364c:	04e00593          	li	a1,78
80003650:	7b448513          	addi	a0,s1,1972
80003654:	c2cfe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003658:	d5898513          	addi	a0,s3,-680
8000365c:	3d1000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003660:	800064b7          	lui	s1,0x80006
80003664:	10448513          	addi	a0,s1,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80003668:	00040593          	mv	a1,s0
8000366c:	02450513          	addi	a0,a0,36
80003670:	8c1ff0ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003674:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003678:	ca47a783          	lw	a5,-860(a5) # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
8000367c:	80006a37          	lui	s4,0x80006
80003680:	10448493          	addi	s1,s1,260
80003684:	128a0a13          	addi	s4,s4,296 # 80006128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006129>
80003688:	02f41863          	bne	s0,a5,800036b8 <z_move_thread_to_end_of_prio_q+0xd8>
8000368c:	80006ab7          	lui	s5,0x80006
80003690:	800065b7          	lui	a1,0x80006
80003694:	80005537          	lui	a0,0x80005
80003698:	ab858593          	addi	a1,a1,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
8000369c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800036a0:	27600693          	li	a3,630
800036a4:	a6ca8613          	addi	a2,s5,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
800036a8:	b9cfe0ef          	jal	ra,80001a44 <printk>
800036ac:	27600593          	li	a1,630
800036b0:	a6ca8513          	addi	a0,s5,-1428
800036b4:	bccfe0ef          	jal	ra,80001a80 <assert_post_action>
	return list->head == list;
800036b8:	0244a783          	lw	a5,36(s1)
800036bc:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800036c0:	0b478e63          	beq	a5,s4,8000377c <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800036c4:	0a078c63          	beqz	a5,8000377c <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
800036c8:	00e40683          	lb	a3,14(s0)
800036cc:	00e78603          	lb	a2,14(a5)
800036d0:	0ac6d063          	bge	a3,a2,80003770 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
800036d4:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800036d8:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800036dc:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800036e0:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800036e4:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
800036e8:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
800036ec:	0084a503          	lw	a0,8(s1)
800036f0:	0407e793          	ori	a5,a5,64
800036f4:	40850533          	sub	a0,a0,s0
800036f8:	00153513          	seqz	a0,a0
800036fc:	00f406a3          	sb	a5,13(s0)
80003700:	9bdff0ef          	jal	ra,800030bc <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003704:	d5898513          	addi	a0,s3,-680
80003708:	2f5000ef          	jal	ra,800041fc <z_spin_unlock_valid>
8000370c:	02051e63          	bnez	a0,80003748 <z_move_thread_to_end_of_prio_q+0x168>
80003710:	80005437          	lui	s0,0x80005
80003714:	800055b7          	lui	a1,0x80005
80003718:	80005537          	lui	a0,0x80005
8000371c:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003720:	06100693          	li	a3,97
80003724:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003728:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000372c:	b18fe0ef          	jal	ra,80001a44 <printk>
80003730:	80006537          	lui	a0,0x80006
80003734:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003738:	b0cfe0ef          	jal	ra,80001a44 <printk>
8000373c:	06100593          	li	a1,97
80003740:	7b440513          	addi	a0,s0,1972
80003744:	b3cfe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003748:	30092973          	csrrs	s2,mstatus,s2
}
8000374c:	01c12083          	lw	ra,28(sp)
80003750:	01812403          	lw	s0,24(sp)
80003754:	01412483          	lw	s1,20(sp)
80003758:	01012903          	lw	s2,16(sp)
8000375c:	00c12983          	lw	s3,12(sp)
80003760:	00812a03          	lw	s4,8(sp)
80003764:	00412a83          	lw	s5,4(sp)
80003768:	02010113          	addi	sp,sp,32
8000376c:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003770:	00e78663          	beq	a5,a4,8000377c <z_move_thread_to_end_of_prio_q+0x19c>
80003774:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003778:	f4079ae3          	bnez	a5,800036cc <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
8000377c:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80003780:	0284a783          	lw	a5,40(s1)
	node->next = list;
80003784:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80003788:	0087a023          	sw	s0,0(a5)
	list->tail = node;
8000378c:	0284a423          	sw	s0,40(s1)
80003790:	f59ff06f          	j	800036e8 <z_move_thread_to_end_of_prio_q+0x108>

80003794 <z_time_slice>:
	if (slice_time && sliceable(_current)) {
80003794:	800067b7          	lui	a5,0x80006
80003798:	d607a783          	lw	a5,-672(a5) # 80005d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d61>
8000379c:	06078663          	beqz	a5,80003808 <z_time_slice+0x74>
800037a0:	800067b7          	lui	a5,0x80006
800037a4:	10478793          	addi	a5,a5,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
800037a8:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800037ac:	07f00693          	li	a3,127
800037b0:	00e75603          	lhu	a2,14(a4)
800037b4:	04c6ea63          	bltu	a3,a2,80003808 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
800037b8:	800066b7          	lui	a3,0x80006
800037bc:	00e70603          	lb	a2,14(a4)
800037c0:	d5c6a683          	lw	a3,-676(a3) # 80005d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d5d>
800037c4:	04d64263          	blt	a2,a3,80003808 <z_time_slice+0x74>
	return thread == _idle_thread;
800037c8:	800066b7          	lui	a3,0x80006
		&& !is_idle(t)
800037cc:	ca46a683          	lw	a3,-860(a3) # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
800037d0:	02d70c63          	beq	a4,a3,80003808 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
800037d4:	01872683          	lw	a3,24(a4)
800037d8:	02069863          	bnez	a3,80003808 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
800037dc:	0107a683          	lw	a3,16(a5)
800037e0:	02d54063          	blt	a0,a3,80003800 <z_time_slice+0x6c>
{
800037e4:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
800037e8:	00070513          	mv	a0,a4
{
800037ec:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
800037f0:	df1ff0ef          	jal	ra,800035e0 <z_move_thread_to_end_of_prio_q>
}
800037f4:	00c12083          	lw	ra,12(sp)
800037f8:	01010113          	addi	sp,sp,16
			reset_time_slice();
800037fc:	a1cff06f          	j	80002a18 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80003800:	40a686b3          	sub	a3,a3,a0
80003804:	00d7a823          	sw	a3,16(a5)
80003808:	00008067          	ret

8000380c <z_remove_thread_from_ready_q>:
{
8000380c:	fe010113          	addi	sp,sp,-32
80003810:	00812c23          	sw	s0,24(sp)
80003814:	01312623          	sw	s3,12(sp)
80003818:	00112e23          	sw	ra,28(sp)
8000381c:	00912a23          	sw	s1,20(sp)
80003820:	01212823          	sw	s2,16(sp)
80003824:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003828:	00800413          	li	s0,8
8000382c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003830:	800064b7          	lui	s1,0x80006
80003834:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003838:	00847413          	andi	s0,s0,8
8000383c:	199000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003840:	02051e63          	bnez	a0,8000387c <z_remove_thread_from_ready_q+0x70>
80003844:	80005937          	lui	s2,0x80005
80003848:	800055b7          	lui	a1,0x80005
8000384c:	80005537          	lui	a0,0x80005
80003850:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003854:	04e00693          	li	a3,78
80003858:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
8000385c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003860:	9e4fe0ef          	jal	ra,80001a44 <printk>
80003864:	80005537          	lui	a0,0x80005
80003868:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
8000386c:	9d8fe0ef          	jal	ra,80001a44 <printk>
80003870:	04e00593          	li	a1,78
80003874:	7b490513          	addi	a0,s2,1972
80003878:	a08fe0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
8000387c:	d5848513          	addi	a0,s1,-680
80003880:	1ad000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
80003884:	00d9c783          	lbu	a5,13(s3)
80003888:	80006937          	lui	s2,0x80006
8000388c:	10490913          	addi	s2,s2,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80003890:	0407f793          	andi	a5,a5,64
80003894:	00078e63          	beqz	a5,800038b0 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80003898:	00098593          	mv	a1,s3
8000389c:	02490513          	addi	a0,s2,36
800038a0:	e90ff0ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800038a4:	00d9c783          	lbu	a5,13(s3)
800038a8:	fbf7f793          	andi	a5,a5,-65
800038ac:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800038b0:	00892503          	lw	a0,8(s2)
800038b4:	41350533          	sub	a0,a0,s3
800038b8:	00153513          	seqz	a0,a0
800038bc:	801ff0ef          	jal	ra,800030bc <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800038c0:	d5848513          	addi	a0,s1,-680
800038c4:	139000ef          	jal	ra,800041fc <z_spin_unlock_valid>
800038c8:	02051e63          	bnez	a0,80003904 <z_remove_thread_from_ready_q+0xf8>
800038cc:	800054b7          	lui	s1,0x80005
800038d0:	800055b7          	lui	a1,0x80005
800038d4:	80005537          	lui	a0,0x80005
800038d8:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800038dc:	06100693          	li	a3,97
800038e0:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800038e4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800038e8:	95cfe0ef          	jal	ra,80001a44 <printk>
800038ec:	80006537          	lui	a0,0x80006
800038f0:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
800038f4:	950fe0ef          	jal	ra,80001a44 <printk>
800038f8:	06100593          	li	a1,97
800038fc:	7b448513          	addi	a0,s1,1972
80003900:	980fe0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003904:	30042473          	csrrs	s0,mstatus,s0
}
80003908:	01c12083          	lw	ra,28(sp)
8000390c:	01812403          	lw	s0,24(sp)
80003910:	01412483          	lw	s1,20(sp)
80003914:	01012903          	lw	s2,16(sp)
80003918:	00c12983          	lw	s3,12(sp)
8000391c:	02010113          	addi	sp,sp,32
80003920:	00008067          	ret

80003924 <pend>:
{
80003924:	fe010113          	addi	sp,sp,-32
80003928:	00812c23          	sw	s0,24(sp)
8000392c:	00912a23          	sw	s1,20(sp)
80003930:	00050413          	mv	s0,a0
80003934:	01212823          	sw	s2,16(sp)
80003938:	00112e23          	sw	ra,28(sp)
8000393c:	01312623          	sw	s3,12(sp)
80003940:	00058493          	mv	s1,a1
80003944:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80003948:	ec5ff0ef          	jal	ra,8000380c <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
8000394c:	00d44783          	lbu	a5,13(s0)
80003950:	0027e793          	ori	a5,a5,2
80003954:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80003958:	06048663          	beqz	s1,800039c4 <pend+0xa0>
	return thread == _idle_thread;
8000395c:	800067b7          	lui	a5,0x80006
	__ASSERT_NO_MSG(!is_idle(thread));
80003960:	ca47a783          	lw	a5,-860(a5) # 80005ca4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ca5>
		thread->base.pended_on = wait_q;
80003964:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80003968:	02f41863          	bne	s0,a5,80003998 <pend+0x74>
8000396c:	800069b7          	lui	s3,0x80006
80003970:	800065b7          	lui	a1,0x80006
80003974:	80005537          	lui	a0,0x80005
80003978:	ab858593          	addi	a1,a1,-1352 # 80005ab8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ab9>
8000397c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003980:	27600693          	li	a3,630
80003984:	a6c98613          	addi	a2,s3,-1428 # 80005a6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a6d>
80003988:	8bcfe0ef          	jal	ra,80001a44 <printk>
8000398c:	27600593          	li	a1,630
80003990:	a6c98513          	addi	a0,s3,-1428
80003994:	8ecfe0ef          	jal	ra,80001a80 <assert_post_action>
	return list->head == list;
80003998:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000399c:	06f48c63          	beq	s1,a5,80003a14 <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800039a0:	06078a63          	beqz	a5,80003a14 <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
800039a4:	00e40703          	lb	a4,14(s0)
800039a8:	00e78683          	lb	a3,14(a5)
800039ac:	04d75c63          	bge	a4,a3,80003a04 <pend+0xe0>
	node->prev = successor->prev;
800039b0:	0047a703          	lw	a4,4(a5)
	node->next = successor;
800039b4:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
800039b8:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
800039bc:	00872023          	sw	s0,0(a4)
	successor->prev = node;
800039c0:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
800039c4:	fff00793          	li	a5,-1
800039c8:	06f90463          	beq	s2,a5,80003a30 <pend+0x10c>
800039cc:	00990913          	addi	s2,s2,9
800039d0:	00a00613          	li	a2,10
800039d4:	02c94633          	div	a2,s2,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800039d8:	01840513          	addi	a0,s0,24
}
800039dc:	01812403          	lw	s0,24(sp)
800039e0:	01c12083          	lw	ra,28(sp)
800039e4:	01412483          	lw	s1,20(sp)
800039e8:	01012903          	lw	s2,16(sp)
800039ec:	00c12983          	lw	s3,12(sp)
800039f0:	800035b7          	lui	a1,0x80003
800039f4:	49458593          	addi	a1,a1,1172 # 80003494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003495>
800039f8:	02010113          	addi	sp,sp,32
800039fc:	00160613          	addi	a2,a2,1
80003a00:	4fd0006f          	j	800046fc <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80003a04:	0044a683          	lw	a3,4(s1)
80003a08:	00d78663          	beq	a5,a3,80003a14 <pend+0xf0>
80003a0c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003a10:	f8079ce3          	bnez	a5,800039a8 <pend+0x84>
	node->prev = list->tail;
80003a14:	0044a783          	lw	a5,4(s1)
	node->next = list;
80003a18:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80003a1c:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80003a20:	0044a783          	lw	a5,4(s1)
80003a24:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003a28:	0084a223          	sw	s0,4(s1)
80003a2c:	f99ff06f          	j	800039c4 <pend+0xa0>
}
80003a30:	01c12083          	lw	ra,28(sp)
80003a34:	01812403          	lw	s0,24(sp)
80003a38:	01412483          	lw	s1,20(sp)
80003a3c:	01012903          	lw	s2,16(sp)
80003a40:	00c12983          	lw	s3,12(sp)
80003a44:	02010113          	addi	sp,sp,32
80003a48:	00008067          	ret

80003a4c <z_pend_curr_irqlock>:
{
80003a4c:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003a50:	800067b7          	lui	a5,0x80006
{
80003a54:	00812423          	sw	s0,8(sp)
80003a58:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003a5c:	10c7a503          	lw	a0,268(a5) # 8000610c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000610d>
{
80003a60:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003a64:	ec1ff0ef          	jal	ra,80003924 <pend>
80003a68:	00040513          	mv	a0,s0
}
80003a6c:	00812403          	lw	s0,8(sp)
80003a70:	00c12083          	lw	ra,12(sp)
80003a74:	01010113          	addi	sp,sp,16
80003a78:	fb0fc06f          	j	80000228 <__swap>

80003a7c <z_pend_curr>:
{
80003a7c:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80003a80:	800067b7          	lui	a5,0x80006
{
80003a84:	00812423          	sw	s0,8(sp)
80003a88:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
80003a8c:	10c7a503          	lw	a0,268(a5) # 8000610c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000610d>
{
80003a90:	00912223          	sw	s1,4(sp)
80003a94:	00058493          	mv	s1,a1
80003a98:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
80003a9c:	00068613          	mv	a2,a3
{
80003aa0:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80003aa4:	e81ff0ef          	jal	ra,80003924 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003aa8:	00040513          	mv	a0,s0
80003aac:	750000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003ab0:	02051e63          	bnez	a0,80003aec <z_pend_curr+0x70>
80003ab4:	80005437          	lui	s0,0x80005
80003ab8:	800055b7          	lui	a1,0x80005
80003abc:	80005537          	lui	a0,0x80005
80003ac0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003ac4:	07800693          	li	a3,120
80003ac8:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003acc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003ad0:	f75fd0ef          	jal	ra,80001a44 <printk>
80003ad4:	80006537          	lui	a0,0x80006
80003ad8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003adc:	f69fd0ef          	jal	ra,80001a44 <printk>
80003ae0:	07800593          	li	a1,120
80003ae4:	7b440513          	addi	a0,s0,1972
80003ae8:	f99fd0ef          	jal	ra,80001a80 <assert_post_action>
}
80003aec:	00812403          	lw	s0,8(sp)
80003af0:	00c12083          	lw	ra,12(sp)
80003af4:	00048513          	mv	a0,s1
80003af8:	00412483          	lw	s1,4(sp)
80003afc:	01010113          	addi	sp,sp,16
80003b00:	f28fc06f          	j	80000228 <__swap>

80003b04 <z_unpend_first_thread>:
{
80003b04:	fe010113          	addi	sp,sp,-32
80003b08:	01212823          	sw	s2,16(sp)
80003b0c:	01312623          	sw	s3,12(sp)
80003b10:	00112e23          	sw	ra,28(sp)
80003b14:	00812c23          	sw	s0,24(sp)
80003b18:	00912a23          	sw	s1,20(sp)
80003b1c:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003b20:	00800913          	li	s2,8
80003b24:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003b28:	800064b7          	lui	s1,0x80006
80003b2c:	d5848513          	addi	a0,s1,-680 # 80005d58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d59>
	key = (mstatus & SOC_MSTATUS_IEN);
80003b30:	00897913          	andi	s2,s2,8
80003b34:	6a0000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003b38:	02051e63          	bnez	a0,80003b74 <z_unpend_first_thread+0x70>
80003b3c:	80005437          	lui	s0,0x80005
80003b40:	800055b7          	lui	a1,0x80005
80003b44:	80005537          	lui	a0,0x80005
80003b48:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003b4c:	04e00693          	li	a3,78
80003b50:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003b54:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003b58:	eedfd0ef          	jal	ra,80001a44 <printk>
80003b5c:	80005537          	lui	a0,0x80005
80003b60:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003b64:	ee1fd0ef          	jal	ra,80001a44 <printk>
80003b68:	04e00593          	li	a1,78
80003b6c:	7b440513          	addi	a0,s0,1972
80003b70:	f11fd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b74:	d5848513          	addi	a0,s1,-680
80003b78:	6b4000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80003b7c:	00098513          	mv	a0,s3
80003b80:	d28ff0ef          	jal	ra,800030a8 <z_priq_dumb_best>
80003b84:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b88:	d5848513          	addi	a0,s1,-680
80003b8c:	670000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003b90:	02051e63          	bnez	a0,80003bcc <z_unpend_first_thread+0xc8>
80003b94:	800059b7          	lui	s3,0x80005
80003b98:	800055b7          	lui	a1,0x80005
80003b9c:	80005537          	lui	a0,0x80005
80003ba0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003ba4:	06100693          	li	a3,97
80003ba8:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003bac:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003bb0:	e95fd0ef          	jal	ra,80001a44 <printk>
80003bb4:	80006537          	lui	a0,0x80006
80003bb8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003bbc:	e89fd0ef          	jal	ra,80001a44 <printk>
80003bc0:	06100593          	li	a1,97
80003bc4:	7b498513          	addi	a0,s3,1972
80003bc8:	eb9fd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003bcc:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80003bd0:	0c040663          	beqz	s0,80003c9c <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003bd4:	00800913          	li	s2,8
80003bd8:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003bdc:	d5848513          	addi	a0,s1,-680
	key = (mstatus & SOC_MSTATUS_IEN);
80003be0:	00897913          	andi	s2,s2,8
80003be4:	5f0000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003be8:	02051e63          	bnez	a0,80003c24 <z_unpend_first_thread+0x120>
80003bec:	800059b7          	lui	s3,0x80005
80003bf0:	800055b7          	lui	a1,0x80005
80003bf4:	80005537          	lui	a0,0x80005
80003bf8:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003bfc:	04e00693          	li	a3,78
80003c00:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003c04:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003c08:	e3dfd0ef          	jal	ra,80001a44 <printk>
80003c0c:	80005537          	lui	a0,0x80005
80003c10:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003c14:	e31fd0ef          	jal	ra,80001a44 <printk>
80003c18:	04e00593          	li	a1,78
80003c1c:	7b498513          	addi	a0,s3,1972
80003c20:	e61fd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003c24:	d5848513          	addi	a0,s1,-680
80003c28:	604000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003c2c:	00840513          	addi	a0,s0,8
80003c30:	e1dfe0ef          	jal	ra,80002a4c <pended_on.isra.15>
80003c34:	00040593          	mv	a1,s0
80003c38:	af8ff0ef          	jal	ra,80002f30 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003c3c:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c40:	d5848513          	addi	a0,s1,-680
80003c44:	ffd7f793          	andi	a5,a5,-3
80003c48:	00f406a3          	sb	a5,13(s0)
80003c4c:	5b0000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003c50:	02051e63          	bnez	a0,80003c8c <z_unpend_first_thread+0x188>
80003c54:	800054b7          	lui	s1,0x80005
80003c58:	800055b7          	lui	a1,0x80005
80003c5c:	80005537          	lui	a0,0x80005
80003c60:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003c64:	06100693          	li	a3,97
80003c68:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003c6c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003c70:	dd5fd0ef          	jal	ra,80001a44 <printk>
80003c74:	80006537          	lui	a0,0x80006
80003c78:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80003c7c:	dc9fd0ef          	jal	ra,80001a44 <printk>
80003c80:	06100593          	li	a1,97
80003c84:	7b448513          	addi	a0,s1,1972
80003c88:	df9fd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c8c:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80003c90:	00042423          	sw	zero,8(s0)
	return z_abort_timeout(&thread->base.timeout);
80003c94:	01840513          	addi	a0,s0,24
80003c98:	491000ef          	jal	ra,80004928 <z_abort_timeout>
}
80003c9c:	00040513          	mv	a0,s0
80003ca0:	01c12083          	lw	ra,28(sp)
80003ca4:	01812403          	lw	s0,24(sp)
80003ca8:	01412483          	lw	s1,20(sp)
80003cac:	01012903          	lw	s2,16(sp)
80003cb0:	00c12983          	lw	s3,12(sp)
80003cb4:	02010113          	addi	sp,sp,32
80003cb8:	00008067          	ret

80003cbc <z_unpend_all>:
	}
	return t;
}

int z_unpend_all(_wait_q_t *wait_q)
{
80003cbc:	ff010113          	addi	sp,sp,-16
80003cc0:	00912223          	sw	s1,4(sp)
80003cc4:	01212023          	sw	s2,0(sp)
80003cc8:	00112623          	sw	ra,12(sp)
80003ccc:	00812423          	sw	s0,8(sp)
80003cd0:	00050913          	mv	s2,a0
	int need_sched = 0;
80003cd4:	00000493          	li	s1,0
	return list->head == list;
80003cd8:	00092403          	lw	s0,0(s2)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003cdc:	00890463          	beq	s2,s0,80003ce4 <z_unpend_all+0x28>
	struct k_thread *th;

	while ((th = z_waitq_head(wait_q)) != NULL) {
80003ce0:	02041063          	bnez	s0,80003d00 <z_unpend_all+0x44>
		z_ready_thread(th);
		need_sched = 1;
	}

	return need_sched;
}
80003ce4:	00c12083          	lw	ra,12(sp)
80003ce8:	00812403          	lw	s0,8(sp)
80003cec:	00048513          	mv	a0,s1
80003cf0:	00012903          	lw	s2,0(sp)
80003cf4:	00412483          	lw	s1,4(sp)
80003cf8:	01010113          	addi	sp,sp,16
80003cfc:	00008067          	ret
		z_unpend_thread(th);
80003d00:	00040513          	mv	a0,s0
80003d04:	aa4ff0ef          	jal	ra,80002fa8 <z_unpend_thread>
	if (z_is_thread_ready(thread)) {
80003d08:	00040513          	mv	a0,s0
80003d0c:	cedfe0ef          	jal	ra,800029f8 <z_is_thread_ready>
		need_sched = 1;
80003d10:	00100493          	li	s1,1
80003d14:	fc0502e3          	beqz	a0,80003cd8 <z_unpend_all+0x1c>
		z_add_thread_to_ready_q(thread);
80003d18:	00040513          	mv	a0,s0
80003d1c:	de8ff0ef          	jal	ra,80003304 <z_add_thread_to_ready_q>
80003d20:	fb9ff06f          	j	80003cd8 <z_unpend_all+0x1c>

80003d24 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80003d24:	800067b7          	lui	a5,0x80006
80003d28:	10478793          	addi	a5,a5,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80003d2c:	02478713          	addi	a4,a5,36
80003d30:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80003d34:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80003d38:	00000593          	li	a1,0
80003d3c:	00100513          	li	a0,1
80003d40:	d6dfe06f          	j	80002aac <k_sched_time_slice_set>

80003d44 <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
80003d44:	800067b7          	lui	a5,0x80006
80003d48:	10c7a503          	lw	a0,268(a5) # 8000610c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000610d>
80003d4c:	00008067          	ret

80003d50 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003d50:	fe010113          	addi	sp,sp,-32
80003d54:	00812c23          	sw	s0,24(sp)
80003d58:	00912a23          	sw	s1,20(sp)
80003d5c:	01212823          	sw	s2,16(sp)
80003d60:	00112e23          	sw	ra,28(sp)
80003d64:	01312623          	sw	s3,12(sp)
80003d68:	00050413          	mv	s0,a0
80003d6c:	00058913          	mv	s2,a1
80003d70:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003d74:	02061e63          	bnez	a2,80003db0 <z_impl_k_sem_init+0x60>
80003d78:	800069b7          	lui	s3,0x80006
80003d7c:	800065b7          	lui	a1,0x80006
80003d80:	80005537          	lui	a0,0x80005
80003d84:	adc58593          	addi	a1,a1,-1316 # 80005adc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005add>
80003d88:	04600693          	li	a3,70
80003d8c:	acc98613          	addi	a2,s3,-1332 # 80005acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005acd>
80003d90:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003d94:	cb1fd0ef          	jal	ra,80001a44 <printk>
80003d98:	80006537          	lui	a0,0x80006
80003d9c:	ae850513          	addi	a0,a0,-1304 # 80005ae8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005ae9>
80003da0:	ca5fd0ef          	jal	ra,80001a44 <printk>
80003da4:	04600593          	li	a1,70
80003da8:	acc98513          	addi	a0,s3,-1332
80003dac:	cd5fd0ef          	jal	ra,80001a80 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003db0:	0324fe63          	bgeu	s1,s2,80003dec <z_impl_k_sem_init+0x9c>
80003db4:	800069b7          	lui	s3,0x80006
80003db8:	800065b7          	lui	a1,0x80006
80003dbc:	80005537          	lui	a0,0x80005
80003dc0:	b0058593          	addi	a1,a1,-1280 # 80005b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b01>
80003dc4:	04700693          	li	a3,71
80003dc8:	acc98613          	addi	a2,s3,-1332 # 80005acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005acd>
80003dcc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003dd0:	c75fd0ef          	jal	ra,80001a44 <printk>
80003dd4:	80006537          	lui	a0,0x80006
80003dd8:	b1850513          	addi	a0,a0,-1256 # 80005b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b19>
80003ddc:	c69fd0ef          	jal	ra,80001a44 <printk>
80003de0:	04700593          	li	a1,71
80003de4:	acc98513          	addi	a0,s3,-1332
80003de8:	c99fd0ef          	jal	ra,80001a80 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80003dec:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80003df0:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80003df4:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80003df8:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80003dfc:	01c12083          	lw	ra,28(sp)
80003e00:	01812403          	lw	s0,24(sp)
80003e04:	01412483          	lw	s1,20(sp)
80003e08:	01012903          	lw	s2,16(sp)
80003e0c:	00c12983          	lw	s3,12(sp)
80003e10:	02010113          	addi	sp,sp,32
80003e14:	00008067          	ret

80003e18 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80003e18:	fe010113          	addi	sp,sp,-32
80003e1c:	00912a23          	sw	s1,20(sp)
80003e20:	01312623          	sw	s3,12(sp)
80003e24:	00112e23          	sw	ra,28(sp)
80003e28:	00812c23          	sw	s0,24(sp)
80003e2c:	01212823          	sw	s2,16(sp)
80003e30:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e34:	00800493          	li	s1,8
80003e38:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e3c:	80006437          	lui	s0,0x80006
80003e40:	d6440513          	addi	a0,s0,-668 # 80005d64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d65>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e44:	0084f493          	andi	s1,s1,8
80003e48:	38c000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003e4c:	02051e63          	bnez	a0,80003e88 <z_impl_k_sem_give+0x70>
80003e50:	80005937          	lui	s2,0x80005
80003e54:	800055b7          	lui	a1,0x80005
80003e58:	80005537          	lui	a0,0x80005
80003e5c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003e60:	04e00693          	li	a3,78
80003e64:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003e68:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003e6c:	bd9fd0ef          	jal	ra,80001a44 <printk>
80003e70:	80005537          	lui	a0,0x80005
80003e74:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003e78:	bcdfd0ef          	jal	ra,80001a44 <printk>
80003e7c:	04e00593          	li	a1,78
80003e80:	7b490513          	addi	a0,s2,1972
80003e84:	bfdfd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e88:	d6440513          	addi	a0,s0,-668
80003e8c:	3a0000ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003e90:	00098513          	mv	a0,s3
80003e94:	c71ff0ef          	jal	ra,80003b04 <z_unpend_first_thread>
80003e98:	00050913          	mv	s2,a0
	if (thread != NULL) {
80003e9c:	04050263          	beqz	a0,80003ee0 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003ea0:	00d54783          	lbu	a5,13(a0)
80003ea4:	01f7f793          	andi	a5,a5,31
80003ea8:	00079863          	bnez	a5,80003eb8 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80003eac:	01852783          	lw	a5,24(a0)
80003eb0:	00079463          	bnez	a5,80003eb8 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80003eb4:	c50ff0ef          	jal	ra,80003304 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80003eb8:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003ebc:	d6440513          	addi	a0,s0,-668
}
80003ec0:	01812403          	lw	s0,24(sp)
80003ec4:	01c12083          	lw	ra,28(sp)
80003ec8:	01012903          	lw	s2,16(sp)
80003ecc:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80003ed0:	00048593          	mv	a1,s1
}
80003ed4:	01412483          	lw	s1,20(sp)
80003ed8:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80003edc:	dddfe06f          	j	80002cb8 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80003ee0:	0089a703          	lw	a4,8(s3)
80003ee4:	00c9a783          	lw	a5,12(s3)
80003ee8:	40e787b3          	sub	a5,a5,a4
80003eec:	00f037b3          	snez	a5,a5
80003ef0:	00e787b3          	add	a5,a5,a4
80003ef4:	00f9a423          	sw	a5,8(s3)
80003ef8:	fc5ff06f          	j	80003ebc <z_impl_k_sem_give+0xa4>

80003efc <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003efc:	800067b7          	lui	a5,0x80006
80003f00:	1047a783          	lw	a5,260(a5) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
{
80003f04:	fe010113          	addi	sp,sp,-32
80003f08:	01212823          	sw	s2,16(sp)
80003f0c:	01312623          	sw	s3,12(sp)
80003f10:	00112e23          	sw	ra,28(sp)
80003f14:	00812c23          	sw	s0,24(sp)
80003f18:	00912a23          	sw	s1,20(sp)
80003f1c:	01412423          	sw	s4,8(sp)
80003f20:	00050913          	mv	s2,a0
80003f24:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003f28:	04078063          	beqz	a5,80003f68 <z_impl_k_sem_take+0x6c>
80003f2c:	02058e63          	beqz	a1,80003f68 <z_impl_k_sem_take+0x6c>
80003f30:	80006437          	lui	s0,0x80006
80003f34:	800065b7          	lui	a1,0x80006
80003f38:	80005537          	lui	a0,0x80005
80003f3c:	b4058593          	addi	a1,a1,-1216 # 80005b40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b41>
80003f40:	08c00693          	li	a3,140
80003f44:	acc40613          	addi	a2,s0,-1332 # 80005acc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005acd>
80003f48:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003f4c:	af9fd0ef          	jal	ra,80001a44 <printk>
80003f50:	80005537          	lui	a0,0x80005
80003f54:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80003f58:	aedfd0ef          	jal	ra,80001a44 <printk>
80003f5c:	08c00593          	li	a1,140
80003f60:	acc40513          	addi	a0,s0,-1332
80003f64:	b1dfd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003f68:	00800413          	li	s0,8
80003f6c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f70:	800064b7          	lui	s1,0x80006
80003f74:	d6448513          	addi	a0,s1,-668 # 80005d64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d65>
	key = (mstatus & SOC_MSTATUS_IEN);
80003f78:	00847413          	andi	s0,s0,8
80003f7c:	258000ef          	jal	ra,800041d4 <z_spin_lock_valid>
80003f80:	02051e63          	bnez	a0,80003fbc <z_impl_k_sem_take+0xc0>
80003f84:	80005a37          	lui	s4,0x80005
80003f88:	800055b7          	lui	a1,0x80005
80003f8c:	80005537          	lui	a0,0x80005
80003f90:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80003f94:	04e00693          	li	a3,78
80003f98:	7b4a0613          	addi	a2,s4,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003f9c:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003fa0:	aa5fd0ef          	jal	ra,80001a44 <printk>
80003fa4:	80005537          	lui	a0,0x80005
80003fa8:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80003fac:	a99fd0ef          	jal	ra,80001a44 <printk>
80003fb0:	04e00593          	li	a1,78
80003fb4:	7b4a0513          	addi	a0,s4,1972
80003fb8:	ac9fd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80003fbc:	d6448513          	addi	a0,s1,-668
80003fc0:	26c000ef          	jal	ra,8000422c <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80003fc4:	00892783          	lw	a5,8(s2)
80003fc8:	06078c63          	beqz	a5,80004040 <z_impl_k_sem_take+0x144>
		sem->count--;
80003fcc:	fff78793          	addi	a5,a5,-1
80003fd0:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003fd4:	d6448513          	addi	a0,s1,-668
80003fd8:	224000ef          	jal	ra,800041fc <z_spin_unlock_valid>
80003fdc:	02051e63          	bnez	a0,80004018 <z_impl_k_sem_take+0x11c>
80003fe0:	800054b7          	lui	s1,0x80005
80003fe4:	800055b7          	lui	a1,0x80005
80003fe8:	80005537          	lui	a0,0x80005
80003fec:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80003ff0:	06100693          	li	a3,97
80003ff4:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80003ff8:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80003ffc:	a49fd0ef          	jal	ra,80001a44 <printk>
80004000:	80006537          	lui	a0,0x80006
80004004:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004008:	a3dfd0ef          	jal	ra,80001a44 <printk>
8000400c:	06100593          	li	a1,97
80004010:	7b448513          	addi	a0,s1,1972
80004014:	a6dfd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004018:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
8000401c:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004020:	01c12083          	lw	ra,28(sp)
80004024:	01812403          	lw	s0,24(sp)
80004028:	01412483          	lw	s1,20(sp)
8000402c:	01012903          	lw	s2,16(sp)
80004030:	00c12983          	lw	s3,12(sp)
80004034:	00812a03          	lw	s4,8(sp)
80004038:	02010113          	addi	sp,sp,32
8000403c:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80004040:	04099a63          	bnez	s3,80004094 <z_impl_k_sem_take+0x198>
80004044:	d6448513          	addi	a0,s1,-668
80004048:	1b4000ef          	jal	ra,800041fc <z_spin_unlock_valid>
8000404c:	02051e63          	bnez	a0,80004088 <z_impl_k_sem_take+0x18c>
80004050:	800054b7          	lui	s1,0x80005
80004054:	800055b7          	lui	a1,0x80005
80004058:	80005537          	lui	a0,0x80005
8000405c:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004060:	06100693          	li	a3,97
80004064:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004068:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000406c:	9d9fd0ef          	jal	ra,80001a44 <printk>
80004070:	80006537          	lui	a0,0x80006
80004074:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004078:	9cdfd0ef          	jal	ra,80001a44 <printk>
8000407c:	06100593          	li	a1,97
80004080:	7b448513          	addi	a0,s1,1972
80004084:	9fdfd0ef          	jal	ra,80001a80 <assert_post_action>
80004088:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
8000408c:	ff000513          	li	a0,-16
80004090:	f91ff06f          	j	80004020 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004094:	00040593          	mv	a1,s0
}
80004098:	01812403          	lw	s0,24(sp)
8000409c:	01c12083          	lw	ra,28(sp)
800040a0:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800040a4:	00098693          	mv	a3,s3
800040a8:	00090613          	mv	a2,s2
}
800040ac:	00c12983          	lw	s3,12(sp)
800040b0:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800040b4:	d6448513          	addi	a0,s1,-668
}
800040b8:	01412483          	lw	s1,20(sp)
800040bc:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800040c0:	9bdff06f          	j	80003a7c <z_pend_curr>

800040c4 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800040c4:	00d54783          	lbu	a5,13(a0)
800040c8:	01f7f793          	andi	a5,a5,31
800040cc:	00079863          	bnez	a5,800040dc <z_is_thread_ready+0x18>
800040d0:	01852503          	lw	a0,24(a0)
800040d4:	00153513          	seqz	a0,a0
800040d8:	00008067          	ret
800040dc:	00000513          	li	a0,0
}
800040e0:	00008067          	ret

800040e4 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
800040e4:	800067b7          	lui	a5,0x80006
800040e8:	1047a503          	lw	a0,260(a5) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
}
800040ec:	00a03533          	snez	a0,a0
800040f0:	00008067          	ret

800040f4 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
800040f4:	800067b7          	lui	a5,0x80006
800040f8:	10c7a783          	lw	a5,268(a5) # 8000610c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000610d>
800040fc:	00c7c503          	lbu	a0,12(a5)
}
80004100:	00157513          	andi	a0,a0,1
80004104:	00008067          	ret

80004108 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004108:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000410c:	02012303          	lw	t1,32(sp)
{
80004110:	00812c23          	sw	s0,24(sp)
80004114:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004118:	00612023          	sw	t1,0(sp)
{
8000411c:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004120:	a4dfc0ef          	jal	ra,80000b6c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004124:	800067b7          	lui	a5,0x80006
80004128:	10c7a783          	lw	a5,268(a5) # 8000610c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000610d>
	sys_trace_thread_create(new_thread);
}
8000412c:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004130:	0687a783          	lw	a5,104(a5)
80004134:	06f42423          	sw	a5,104(s0)
}
80004138:	01812403          	lw	s0,24(sp)
8000413c:	02010113          	addi	sp,sp,32
80004140:	00008067          	ret

80004144 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004144:	06052783          	lw	a5,96(a0)
{
80004148:	ff010113          	addi	sp,sp,-16
8000414c:	00812423          	sw	s0,8(sp)
80004150:	00112623          	sw	ra,12(sp)
80004154:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004158:	00078463          	beqz	a5,80004160 <z_thread_single_abort+0x1c>
		thread->fn_abort();
8000415c:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004160:	00040513          	mv	a0,s0
80004164:	f61ff0ef          	jal	ra,800040c4 <z_is_thread_ready>
80004168:	02050463          	beqz	a0,80004190 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
8000416c:	00040513          	mv	a0,s0
80004170:	e9cff0ef          	jal	ra,8000380c <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004174:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004178:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
8000417c:	0087e793          	ori	a5,a5,8
80004180:	00f406a3          	sb	a5,13(s0)
}
80004184:	00812403          	lw	s0,8(sp)
80004188:	01010113          	addi	sp,sp,16
8000418c:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004190:	00d44783          	lbu	a5,13(s0)
80004194:	0027f793          	andi	a5,a5,2
80004198:	00078663          	beqz	a5,800041a4 <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
8000419c:	00040513          	mv	a0,s0
800041a0:	a1dfe0ef          	jal	ra,80002bbc <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
800041a4:	01842783          	lw	a5,24(s0)
800041a8:	fc0786e3          	beqz	a5,80004174 <z_thread_single_abort+0x30>
800041ac:	01840513          	addi	a0,s0,24
800041b0:	778000ef          	jal	ra,80004928 <z_abort_timeout>
800041b4:	fc1ff06f          	j	80004174 <z_thread_single_abort+0x30>

800041b8 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
800041b8:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
800041bc:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
800041c0:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
800041c4:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800041c8:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800041cc:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800041d0:	00008067          	ret

800041d4 <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800041d4:	00052503          	lw	a0,0(a0)
800041d8:	00050e63          	beqz	a0,800041f4 <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800041dc:	800067b7          	lui	a5,0x80006
800041e0:	1187c783          	lbu	a5,280(a5) # 80006118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006119>
800041e4:	00357513          	andi	a0,a0,3
800041e8:	40f50533          	sub	a0,a0,a5
800041ec:	00a03533          	snez	a0,a0
800041f0:	00008067          	ret
			return false;
		}
	}
	return true;
800041f4:	00100513          	li	a0,1
}
800041f8:	00008067          	ret

800041fc <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800041fc:	800067b7          	lui	a5,0x80006
80004200:	10478793          	addi	a5,a5,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80004204:	0147c703          	lbu	a4,20(a5)
80004208:	0087a783          	lw	a5,8(a5)
8000420c:	00e7e7b3          	or	a5,a5,a4
80004210:	00052703          	lw	a4,0(a0)
80004214:	00f71863          	bne	a4,a5,80004224 <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004218:	00052023          	sw	zero,0(a0)
	return true;
8000421c:	00100513          	li	a0,1
80004220:	00008067          	ret
		return false;
80004224:	00000513          	li	a0,0
}
80004228:	00008067          	ret

8000422c <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
8000422c:	800067b7          	lui	a5,0x80006
80004230:	10478793          	addi	a5,a5,260 # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
80004234:	0147c703          	lbu	a4,20(a5)
80004238:	0087a783          	lw	a5,8(a5)
8000423c:	00e7e7b3          	or	a5,a5,a4
80004240:	00f52023          	sw	a5,0(a0)
}
80004244:	00008067          	ret

80004248 <z_impl_k_thread_start>:
{
80004248:	fe010113          	addi	sp,sp,-32
8000424c:	00812c23          	sw	s0,24(sp)
80004250:	01212823          	sw	s2,16(sp)
80004254:	00112e23          	sw	ra,28(sp)
80004258:	00912a23          	sw	s1,20(sp)
8000425c:	01312623          	sw	s3,12(sp)
80004260:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004264:	00800413          	li	s0,8
80004268:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000426c:	800064b7          	lui	s1,0x80006
80004270:	d6848513          	addi	a0,s1,-664 # 80005d68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d69>
	key = (mstatus & SOC_MSTATUS_IEN);
80004274:	00847413          	andi	s0,s0,8
80004278:	f5dff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
8000427c:	02051e63          	bnez	a0,800042b8 <z_impl_k_thread_start+0x70>
80004280:	800059b7          	lui	s3,0x80005
80004284:	800055b7          	lui	a1,0x80005
80004288:	80005537          	lui	a0,0x80005
8000428c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004290:	04e00693          	li	a3,78
80004294:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004298:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000429c:	fa8fd0ef          	jal	ra,80001a44 <printk>
800042a0:	80005537          	lui	a0,0x80005
800042a4:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
800042a8:	f9cfd0ef          	jal	ra,80001a44 <printk>
800042ac:	04e00593          	li	a1,78
800042b0:	7b498513          	addi	a0,s3,1972
800042b4:	fccfd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
800042b8:	d6848513          	addi	a0,s1,-664
800042bc:	f71ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
800042c0:	00d94783          	lbu	a5,13(s2)
800042c4:	0047f713          	andi	a4,a5,4
800042c8:	06071463          	bnez	a4,80004330 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800042cc:	d6848513          	addi	a0,s1,-664
800042d0:	f2dff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
800042d4:	02051e63          	bnez	a0,80004310 <z_impl_k_thread_start+0xc8>
800042d8:	800054b7          	lui	s1,0x80005
800042dc:	800055b7          	lui	a1,0x80005
800042e0:	80005537          	lui	a0,0x80005
800042e4:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800042e8:	06100693          	li	a3,97
800042ec:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800042f0:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800042f4:	f50fd0ef          	jal	ra,80001a44 <printk>
800042f8:	80006537          	lui	a0,0x80006
800042fc:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004300:	f44fd0ef          	jal	ra,80001a44 <printk>
80004304:	06100593          	li	a1,97
80004308:	7b448513          	addi	a0,s1,1972
8000430c:	f74fd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004310:	30042473          	csrrs	s0,mstatus,s0
}
80004314:	01c12083          	lw	ra,28(sp)
80004318:	01812403          	lw	s0,24(sp)
8000431c:	01412483          	lw	s1,20(sp)
80004320:	01012903          	lw	s2,16(sp)
80004324:	00c12983          	lw	s3,12(sp)
80004328:	02010113          	addi	sp,sp,32
8000432c:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004330:	ffb7f793          	andi	a5,a5,-5
80004334:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004338:	00090513          	mv	a0,s2
8000433c:	d89ff0ef          	jal	ra,800040c4 <z_is_thread_ready>
80004340:	00050663          	beqz	a0,8000434c <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004344:	00090513          	mv	a0,s2
80004348:	fbdfe0ef          	jal	ra,80003304 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
8000434c:	00040593          	mv	a1,s0
}
80004350:	01812403          	lw	s0,24(sp)
80004354:	01c12083          	lw	ra,28(sp)
80004358:	01012903          	lw	s2,16(sp)
8000435c:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004360:	d6848513          	addi	a0,s1,-664
}
80004364:	01412483          	lw	s1,20(sp)
80004368:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
8000436c:	94dfe06f          	j	80002cb8 <z_reschedule>

80004370 <schedule_new_thread>:
	if (delay == 0) {
80004370:	00059463          	bnez	a1,80004378 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004374:	ed5ff06f          	j	80004248 <z_impl_k_thread_start>
80004378:	00958593          	addi	a1,a1,9
8000437c:	00a00613          	li	a2,10
80004380:	02c5c633          	div	a2,a1,a2
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004384:	800035b7          	lui	a1,0x80003
80004388:	49458593          	addi	a1,a1,1172 # 80003494 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003495>
8000438c:	01850513          	addi	a0,a0,24
80004390:	00160613          	addi	a2,a2,1
80004394:	3680006f          	j	800046fc <z_add_timeout>

80004398 <z_impl_k_thread_create>:
{
80004398:	fc010113          	addi	sp,sp,-64
8000439c:	03512223          	sw	s5,36(sp)
800043a0:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800043a4:	800066b7          	lui	a3,0x80006
800043a8:	1046a683          	lw	a3,260(a3) # 80006104 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006105>
{
800043ac:	02812c23          	sw	s0,56(sp)
800043b0:	02912a23          	sw	s1,52(sp)
800043b4:	03312623          	sw	s3,44(sp)
800043b8:	03412423          	sw	s4,40(sp)
800043bc:	02112e23          	sw	ra,60(sp)
800043c0:	03212823          	sw	s2,48(sp)
800043c4:	00050413          	mv	s0,a0
800043c8:	00058993          	mv	s3,a1
800043cc:	00060a13          	mv	s4,a2
800043d0:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
800043d4:	04068e63          	beqz	a3,80004430 <z_impl_k_thread_create+0x98>
800043d8:	80006937          	lui	s2,0x80006
800043dc:	800065b7          	lui	a1,0x80006
800043e0:	80005537          	lui	a0,0x80005
800043e4:	1b200693          	li	a3,434
800043e8:	b7490613          	addi	a2,s2,-1164 # 80005b74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b75>
800043ec:	a0458593          	addi	a1,a1,-1532 # 80005a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005a05>
800043f0:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800043f4:	01112e23          	sw	a7,28(sp)
800043f8:	01012c23          	sw	a6,24(sp)
800043fc:	00f12a23          	sw	a5,20(sp)
80004400:	00e12823          	sw	a4,16(sp)
80004404:	e40fd0ef          	jal	ra,80001a44 <printk>
80004408:	80006537          	lui	a0,0x80006
8000440c:	b8850513          	addi	a0,a0,-1144 # 80005b88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b89>
80004410:	e34fd0ef          	jal	ra,80001a44 <printk>
80004414:	1b200593          	li	a1,434
80004418:	b7490513          	addi	a0,s2,-1164
8000441c:	e64fd0ef          	jal	ra,80001a80 <assert_post_action>
80004420:	01c12883          	lw	a7,28(sp)
80004424:	01812803          	lw	a6,24(sp)
80004428:	01412783          	lw	a5,20(sp)
8000442c:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004430:	04012683          	lw	a3,64(sp)
80004434:	00012223          	sw	zero,4(sp)
80004438:	000a0613          	mv	a2,s4
8000443c:	00d12023          	sw	a3,0(sp)
80004440:	00098593          	mv	a1,s3
80004444:	000a8693          	mv	a3,s5
80004448:	00040513          	mv	a0,s0
8000444c:	cbdff0ef          	jal	ra,80004108 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80004450:	fff00793          	li	a5,-1
80004454:	00f48863          	beq	s1,a5,80004464 <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80004458:	00048593          	mv	a1,s1
8000445c:	00040513          	mv	a0,s0
80004460:	f11ff0ef          	jal	ra,80004370 <schedule_new_thread>
}
80004464:	00040513          	mv	a0,s0
80004468:	03c12083          	lw	ra,60(sp)
8000446c:	03812403          	lw	s0,56(sp)
80004470:	03412483          	lw	s1,52(sp)
80004474:	03012903          	lw	s2,48(sp)
80004478:	02c12983          	lw	s3,44(sp)
8000447c:	02812a03          	lw	s4,40(sp)
80004480:	02412a83          	lw	s5,36(sp)
80004484:	04010113          	addi	sp,sp,64
80004488:	00008067          	ret

8000448c <z_init_static_threads>:
{
8000448c:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80004490:	800067b7          	lui	a5,0x80006
{
80004494:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80004498:	80006937          	lui	s2,0x80006
{
8000449c:	00812c23          	sw	s0,24(sp)
800044a0:	00912a23          	sw	s1,20(sp)
800044a4:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800044a8:	cd878413          	addi	s0,a5,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
800044ac:	cd878493          	addi	s1,a5,-808
800044b0:	cd890913          	addi	s2,s2,-808 # 80005cd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005cd9>
800044b4:	03246663          	bltu	s0,s2,800044e0 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
800044b8:	00048413          	mv	s0,s1
	k_sched_lock();
800044bc:	8fdfe0ef          	jal	ra,80002db8 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
800044c0:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
800044c4:	07246063          	bltu	s0,s2,80004524 <z_init_static_threads+0x98>
}
800044c8:	01812403          	lw	s0,24(sp)
800044cc:	01c12083          	lw	ra,28(sp)
800044d0:	01412483          	lw	s1,20(sp)
800044d4:	01012903          	lw	s2,16(sp)
800044d8:	02010113          	addi	sp,sp,32
	k_sched_unlock();
800044dc:	ca9fe06f          	j	80003184 <k_sched_unlock>
		z_setup_new_thread(
800044e0:	02c42783          	lw	a5,44(s0)
800044e4:	00f12223          	sw	a5,4(sp)
800044e8:	02042783          	lw	a5,32(s0)
800044ec:	00f12023          	sw	a5,0(sp)
800044f0:	01442783          	lw	a5,20(s0)
800044f4:	01c42883          	lw	a7,28(s0)
800044f8:	01842803          	lw	a6,24(s0)
800044fc:	01042703          	lw	a4,16(s0)
80004500:	00c42683          	lw	a3,12(s0)
80004504:	00842603          	lw	a2,8(s0)
80004508:	00442583          	lw	a1,4(s0)
8000450c:	00042503          	lw	a0,0(s0)
80004510:	bf9ff0ef          	jal	ra,80004108 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80004514:	00042783          	lw	a5,0(s0)
80004518:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
8000451c:	03040413          	addi	s0,s0,48
80004520:	f95ff06f          	j	800044b4 <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
80004524:	02442583          	lw	a1,36(s0)
80004528:	00958663          	beq	a1,s1,80004534 <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
8000452c:	00042503          	lw	a0,0(s0)
80004530:	e41ff0ef          	jal	ra,80004370 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80004534:	03040413          	addi	s0,s0,48
80004538:	f8dff06f          	j	800044c4 <z_init_static_threads+0x38>

8000453c <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
8000453c:	fe010113          	addi	sp,sp,-32
80004540:	00812c23          	sw	s0,24(sp)
80004544:	00912a23          	sw	s1,20(sp)
80004548:	00112e23          	sw	ra,28(sp)
8000454c:	01212823          	sw	s2,16(sp)
80004550:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
80004554:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004558:	00800413          	li	s0,8
8000455c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004560:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80004564:	00847413          	andi	s0,s0,8
80004568:	c6dff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
8000456c:	02051e63          	bnez	a0,800045a8 <z_impl_k_thread_abort+0x6c>
80004570:	80005937          	lui	s2,0x80005
80004574:	800055b7          	lui	a1,0x80005
80004578:	80005537          	lui	a0,0x80005
8000457c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004580:	04e00693          	li	a3,78
80004584:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004588:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000458c:	cb8fd0ef          	jal	ra,80001a44 <printk>
80004590:	80005537          	lui	a0,0x80005
80004594:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004598:	cacfd0ef          	jal	ra,80001a44 <printk>
8000459c:	04e00593          	li	a1,78
800045a0:	7b490513          	addi	a0,s2,1972
800045a4:	cdcfd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
800045a8:	00c10513          	addi	a0,sp,12
800045ac:	c81ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
800045b0:	00c4c783          	lbu	a5,12(s1)
800045b4:	0017f793          	andi	a5,a5,1
800045b8:	02078e63          	beqz	a5,800045f4 <z_impl_k_thread_abort+0xb8>
800045bc:	80006937          	lui	s2,0x80006
800045c0:	800065b7          	lui	a1,0x80006
800045c4:	80005537          	lui	a0,0x80005
800045c8:	bc858593          	addi	a1,a1,-1080 # 80005bc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bc9>
800045cc:	02900693          	li	a3,41
800045d0:	bb090613          	addi	a2,s2,-1104 # 80005bb0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bb1>
800045d4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800045d8:	c6cfd0ef          	jal	ra,80001a44 <printk>
800045dc:	80006537          	lui	a0,0x80006
800045e0:	bfc50513          	addi	a0,a0,-1028 # 80005bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005bfd>
800045e4:	c60fd0ef          	jal	ra,80001a44 <printk>
800045e8:	02900593          	li	a1,41
800045ec:	bb090513          	addi	a0,s2,-1104
800045f0:	c90fd0ef          	jal	ra,80001a80 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
800045f4:	00048513          	mv	a0,s1
800045f8:	b4dff0ef          	jal	ra,80004144 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
800045fc:	00040593          	mv	a1,s0
80004600:	00c10513          	addi	a0,sp,12
80004604:	eb4fe0ef          	jal	ra,80002cb8 <z_reschedule>
}
80004608:	01c12083          	lw	ra,28(sp)
8000460c:	01812403          	lw	s0,24(sp)
80004610:	01412483          	lw	s1,20(sp)
80004614:	01012903          	lw	s2,16(sp)
80004618:	02010113          	addi	sp,sp,32
8000461c:	00008067          	ret

80004620 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
80004620:	800067b7          	lui	a5,0x80006
80004624:	d6c7a783          	lw	a5,-660(a5) # 80005d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d6d>
80004628:	00079463          	bnez	a5,80004630 <elapsed+0x10>
8000462c:	8a5fd06f          	j	80001ed0 <z_clock_elapsed>
}
80004630:	00000513          	li	a0,0
80004634:	00008067          	ret

80004638 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
80004638:	00052783          	lw	a5,0(a0)
8000463c:	02050263          	beqz	a0,80004660 <remove_timeout+0x28>
80004640:	80006737          	lui	a4,0x80006
	return (node == list->tail) ? NULL : node->next;
80004644:	c9472703          	lw	a4,-876(a4) # 80005c94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c95>
80004648:	00e50c63          	beq	a0,a4,80004660 <remove_timeout+0x28>
	if (next(t) != NULL) {
8000464c:	00078a63          	beqz	a5,80004660 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
80004650:	0087a703          	lw	a4,8(a5)
80004654:	00852683          	lw	a3,8(a0)
80004658:	00d70733          	add	a4,a4,a3
8000465c:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80004660:	00452703          	lw	a4,4(a0)
80004664:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80004668:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000466c:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80004670:	00052223          	sw	zero,4(a0)
}
80004674:	00008067          	ret

80004678 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004678:	800067b7          	lui	a5,0x80006
8000467c:	d787c783          	lbu	a5,-648(a5) # 80005d78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d79>
{
80004680:	ff010113          	addi	sp,sp,-16
80004684:	00112623          	sw	ra,12(sp)
80004688:	00812423          	sw	s0,8(sp)
8000468c:	00912223          	sw	s1,4(sp)
80004690:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80004694:	00079663          	bnez	a5,800046a0 <next_timeout+0x28>
80004698:	80000537          	lui	a0,0x80000
8000469c:	fff54513          	not	a0,a0
	return list->head == list;
800046a0:	800067b7          	lui	a5,0x80006
800046a4:	c9078793          	addi	a5,a5,-880 # 80005c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c91>
800046a8:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
800046ac:	02f40463          	beq	s0,a5,800046d4 <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
800046b0:	02040263          	beqz	s0,800046d4 <next_timeout+0x5c>
800046b4:	00842483          	lw	s1,8(s0)
800046b8:	f69ff0ef          	jal	ra,80004620 <elapsed>
800046bc:	40a484b3          	sub	s1,s1,a0
800046c0:	00000513          	li	a0,0
800046c4:	0004c863          	bltz	s1,800046d4 <next_timeout+0x5c>
800046c8:	00842403          	lw	s0,8(s0)
800046cc:	f55ff0ef          	jal	ra,80004620 <elapsed>
800046d0:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
800046d4:	800067b7          	lui	a5,0x80006
800046d8:	1147a783          	lw	a5,276(a5) # 80006114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006115>
800046dc:	00078663          	beqz	a5,800046e8 <next_timeout+0x70>
800046e0:	00a7d463          	bge	a5,a0,800046e8 <next_timeout+0x70>
800046e4:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
800046e8:	00c12083          	lw	ra,12(sp)
800046ec:	00812403          	lw	s0,8(sp)
800046f0:	00412483          	lw	s1,4(sp)
800046f4:	01010113          	addi	sp,sp,16
800046f8:	00008067          	ret

800046fc <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
800046fc:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
80004700:	fd010113          	addi	sp,sp,-48
80004704:	02812423          	sw	s0,40(sp)
80004708:	02912223          	sw	s1,36(sp)
8000470c:	01312e23          	sw	s3,28(sp)
80004710:	02112623          	sw	ra,44(sp)
80004714:	03212023          	sw	s2,32(sp)
80004718:	01412c23          	sw	s4,24(sp)
8000471c:	01512a23          	sw	s5,20(sp)
80004720:	01612823          	sw	s6,16(sp)
80004724:	01712623          	sw	s7,12(sp)
80004728:	01812423          	sw	s8,8(sp)
8000472c:	00050413          	mv	s0,a0
80004730:	00058993          	mv	s3,a1
80004734:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80004738:	02078e63          	beqz	a5,80004774 <z_add_timeout+0x78>
8000473c:	80006937          	lui	s2,0x80006
80004740:	800065b7          	lui	a1,0x80006
80004744:	80005537          	lui	a0,0x80005
80004748:	c2c58593          	addi	a1,a1,-980 # 80005c2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c2d>
8000474c:	04d00693          	li	a3,77
80004750:	c1890613          	addi	a2,s2,-1000 # 80005c18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c19>
80004754:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004758:	aecfd0ef          	jal	ra,80001a44 <printk>
8000475c:	80005537          	lui	a0,0x80005
80004760:	76c50513          	addi	a0,a0,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80004764:	ae0fd0ef          	jal	ra,80001a44 <printk>
80004768:	04d00593          	li	a1,77
8000476c:	c1890513          	addi	a0,s2,-1000
80004770:	b10fd0ef          	jal	ra,80001a80 <assert_post_action>
	to->fn = fn;
80004774:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80004778:	00904463          	bgtz	s1,80004780 <z_add_timeout+0x84>
8000477c:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004780:	00800993          	li	s3,8
80004784:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004788:	80006a37          	lui	s4,0x80006
8000478c:	d70a0513          	addi	a0,s4,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004790:	0089f993          	andi	s3,s3,8
80004794:	a41ff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004798:	02051e63          	bnez	a0,800047d4 <z_add_timeout+0xd8>
8000479c:	80005937          	lui	s2,0x80005
800047a0:	800055b7          	lui	a1,0x80005
800047a4:	80005537          	lui	a0,0x80005
800047a8:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
800047ac:	04e00693          	li	a3,78
800047b0:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800047b4:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800047b8:	a8cfd0ef          	jal	ra,80001a44 <printk>
800047bc:	80005537          	lui	a0,0x80005
800047c0:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
800047c4:	a80fd0ef          	jal	ra,80001a44 <printk>
800047c8:	04e00593          	li	a1,78
800047cc:	7b490513          	addi	a0,s2,1972
800047d0:	ab0fd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
800047d4:	d70a0513          	addi	a0,s4,-656
800047d8:	a55ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
800047dc:	e45ff0ef          	jal	ra,80004620 <elapsed>
800047e0:	00950533          	add	a0,a0,s1
	return list->head == list;
800047e4:	800064b7          	lui	s1,0x80006
800047e8:	c904a903          	lw	s2,-880(s1) # 80005c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c91>
800047ec:	00a42423          	sw	a0,8(s0)
800047f0:	c9048493          	addi	s1,s1,-880
	return sys_dlist_is_empty(list) ? NULL : list->head;
800047f4:	00990c63          	beq	s2,s1,8000480c <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
800047f8:	80006ab7          	lui	s5,0x80006
800047fc:	80006b37          	lui	s6,0x80006
80004800:	80005bb7          	lui	s7,0x80005
80004804:	80005c37          	lui	s8,0x80005
		for (t = first(); t != NULL; t = next(t)) {
80004808:	02091063          	bnez	s2,80004828 <z_add_timeout+0x12c>
	node->prev = list->tail;
8000480c:	0044a783          	lw	a5,4(s1)
	node->next = list;
80004810:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
80004814:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
80004818:	0044a783          	lw	a5,4(s1)
8000481c:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004820:	0084a223          	sw	s0,4(s1)
80004824:	05c0006f          	j	80004880 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
80004828:	00892783          	lw	a5,8(s2)
8000482c:	0207d663          	bgez	a5,80004858 <z_add_timeout+0x15c>
80004830:	c4cb0593          	addi	a1,s6,-948 # 80005c4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c4d>
80004834:	05600693          	li	a3,86
80004838:	c18a8613          	addi	a2,s5,-1000 # 80005c18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c19>
8000483c:	6e8b8513          	addi	a0,s7,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004840:	a04fd0ef          	jal	ra,80001a44 <printk>
80004844:	76cc0513          	addi	a0,s8,1900 # 8000576c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000576d>
80004848:	9fcfd0ef          	jal	ra,80001a44 <printk>
8000484c:	05600593          	li	a1,86
80004850:	c18a8513          	addi	a0,s5,-1000
80004854:	a2cfd0ef          	jal	ra,80001a80 <assert_post_action>

			if (t->dticks > to->dticks) {
80004858:	00892703          	lw	a4,8(s2)
8000485c:	00842783          	lw	a5,8(s0)
80004860:	0ae7d863          	bge	a5,a4,80004910 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
80004864:	40f707b3          	sub	a5,a4,a5
80004868:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
8000486c:	00492783          	lw	a5,4(s2)
	node->next = successor;
80004870:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80004874:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80004878:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
8000487c:	00892223          	sw	s0,4(s2)
	return list->head == list;
80004880:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004884:	00978a63          	beq	a5,s1,80004898 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80004888:	00f41863          	bne	s0,a5,80004898 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
8000488c:	dedff0ef          	jal	ra,80004678 <next_timeout>
80004890:	00000593          	li	a1,0
80004894:	cc0fd0ef          	jal	ra,80001d54 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004898:	d70a0513          	addi	a0,s4,-656
8000489c:	961ff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
800048a0:	02051e63          	bnez	a0,800048dc <z_add_timeout+0x1e0>
800048a4:	80005437          	lui	s0,0x80005
800048a8:	800055b7          	lui	a1,0x80005
800048ac:	80005537          	lui	a0,0x80005
800048b0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800048b4:	06100693          	li	a3,97
800048b8:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800048bc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800048c0:	984fd0ef          	jal	ra,80001a44 <printk>
800048c4:	80006537          	lui	a0,0x80006
800048c8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
800048cc:	978fd0ef          	jal	ra,80001a44 <printk>
800048d0:	06100593          	li	a1,97
800048d4:	7b440513          	addi	a0,s0,1972
800048d8:	9a8fd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800048dc:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
800048e0:	02c12083          	lw	ra,44(sp)
800048e4:	02812403          	lw	s0,40(sp)
800048e8:	02412483          	lw	s1,36(sp)
800048ec:	02012903          	lw	s2,32(sp)
800048f0:	01c12983          	lw	s3,28(sp)
800048f4:	01812a03          	lw	s4,24(sp)
800048f8:	01412a83          	lw	s5,20(sp)
800048fc:	01012b03          	lw	s6,16(sp)
80004900:	00c12b83          	lw	s7,12(sp)
80004904:	00812c03          	lw	s8,8(sp)
80004908:	03010113          	addi	sp,sp,48
8000490c:	00008067          	ret
			to->dticks -= t->dticks;
80004910:	40e787b3          	sub	a5,a5,a4
80004914:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80004918:	0044a783          	lw	a5,4(s1)
8000491c:	ef2788e3          	beq	a5,s2,8000480c <z_add_timeout+0x110>
80004920:	00092903          	lw	s2,0(s2)
80004924:	ee5ff06f          	j	80004808 <z_add_timeout+0x10c>

80004928 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80004928:	fe010113          	addi	sp,sp,-32
8000492c:	00812c23          	sw	s0,24(sp)
80004930:	01312623          	sw	s3,12(sp)
80004934:	00112e23          	sw	ra,28(sp)
80004938:	00912a23          	sw	s1,20(sp)
8000493c:	01212823          	sw	s2,16(sp)
80004940:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004944:	00800413          	li	s0,8
80004948:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000494c:	800064b7          	lui	s1,0x80006
80004950:	d7048513          	addi	a0,s1,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004954:	00847413          	andi	s0,s0,8
80004958:	87dff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
8000495c:	02051e63          	bnez	a0,80004998 <z_abort_timeout+0x70>
80004960:	80005937          	lui	s2,0x80005
80004964:	800055b7          	lui	a1,0x80005
80004968:	80005537          	lui	a0,0x80005
8000496c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004970:	04e00693          	li	a3,78
80004974:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004978:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
8000497c:	8c8fd0ef          	jal	ra,80001a44 <printk>
80004980:	80005537          	lui	a0,0x80005
80004984:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004988:	8bcfd0ef          	jal	ra,80001a44 <printk>
8000498c:	04e00593          	li	a1,78
80004990:	7b490513          	addi	a0,s2,1972
80004994:	8ecfd0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004998:	d7048513          	addi	a0,s1,-656
8000499c:	891ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
800049a0:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
800049a4:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
800049a8:	00078863          	beqz	a5,800049b8 <z_abort_timeout+0x90>
			remove_timeout(to);
800049ac:	00098513          	mv	a0,s3
800049b0:	c89ff0ef          	jal	ra,80004638 <remove_timeout>
			ret = 0;
800049b4:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800049b8:	d7048513          	addi	a0,s1,-656
800049bc:	841ff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
800049c0:	02051e63          	bnez	a0,800049fc <z_abort_timeout+0xd4>
800049c4:	800054b7          	lui	s1,0x80005
800049c8:	800055b7          	lui	a1,0x80005
800049cc:	80005537          	lui	a0,0x80005
800049d0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
800049d4:	06100693          	li	a3,97
800049d8:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
800049dc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
800049e0:	864fd0ef          	jal	ra,80001a44 <printk>
800049e4:	80006537          	lui	a0,0x80006
800049e8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
800049ec:	858fd0ef          	jal	ra,80001a44 <printk>
800049f0:	06100593          	li	a1,97
800049f4:	7b448513          	addi	a0,s1,1972
800049f8:	888fd0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800049fc:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80004a00:	01c12083          	lw	ra,28(sp)
80004a04:	01812403          	lw	s0,24(sp)
80004a08:	00090513          	mv	a0,s2
80004a0c:	01412483          	lw	s1,20(sp)
80004a10:	01012903          	lw	s2,16(sp)
80004a14:	00c12983          	lw	s3,12(sp)
80004a18:	02010113          	addi	sp,sp,32
80004a1c:	00008067          	ret

80004a20 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80004a20:	ff010113          	addi	sp,sp,-16
80004a24:	00812423          	sw	s0,8(sp)
80004a28:	00112623          	sw	ra,12(sp)
80004a2c:	00912223          	sw	s1,4(sp)
80004a30:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a34:	00800413          	li	s0,8
80004a38:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a3c:	800064b7          	lui	s1,0x80006
80004a40:	d7048513          	addi	a0,s1,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004a44:	00847413          	andi	s0,s0,8
80004a48:	f8cff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004a4c:	02051e63          	bnez	a0,80004a88 <z_get_next_timeout_expiry+0x68>
80004a50:	80005937          	lui	s2,0x80005
80004a54:	800055b7          	lui	a1,0x80005
80004a58:	80005537          	lui	a0,0x80005
80004a5c:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004a60:	04e00693          	li	a3,78
80004a64:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004a68:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004a6c:	fd9fc0ef          	jal	ra,80001a44 <printk>
80004a70:	80005537          	lui	a0,0x80005
80004a74:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004a78:	fcdfc0ef          	jal	ra,80001a44 <printk>
80004a7c:	04e00593          	li	a1,78
80004a80:	7b490513          	addi	a0,s2,1972
80004a84:	ffdfc0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004a88:	d7048513          	addi	a0,s1,-656
80004a8c:	fa0ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80004a90:	be9ff0ef          	jal	ra,80004678 <next_timeout>
80004a94:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004a98:	d7048513          	addi	a0,s1,-656
80004a9c:	f60ff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004aa0:	02051e63          	bnez	a0,80004adc <z_get_next_timeout_expiry+0xbc>
80004aa4:	800054b7          	lui	s1,0x80005
80004aa8:	800055b7          	lui	a1,0x80005
80004aac:	80005537          	lui	a0,0x80005
80004ab0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004ab4:	06100693          	li	a3,97
80004ab8:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004abc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004ac0:	f85fc0ef          	jal	ra,80001a44 <printk>
80004ac4:	80006537          	lui	a0,0x80006
80004ac8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004acc:	f79fc0ef          	jal	ra,80001a44 <printk>
80004ad0:	06100593          	li	a1,97
80004ad4:	7b448513          	addi	a0,s1,1972
80004ad8:	fa9fc0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004adc:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80004ae0:	00c12083          	lw	ra,12(sp)
80004ae4:	00812403          	lw	s0,8(sp)
80004ae8:	00090513          	mv	a0,s2
80004aec:	00412483          	lw	s1,4(sp)
80004af0:	00012903          	lw	s2,0(sp)
80004af4:	01010113          	addi	sp,sp,16
80004af8:	00008067          	ret

80004afc <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80004afc:	fe010113          	addi	sp,sp,-32
80004b00:	00812c23          	sw	s0,24(sp)
80004b04:	01212823          	sw	s2,16(sp)
80004b08:	01412423          	sw	s4,8(sp)
80004b0c:	00112e23          	sw	ra,28(sp)
80004b10:	00912a23          	sw	s1,20(sp)
80004b14:	01312623          	sw	s3,12(sp)
80004b18:	00050913          	mv	s2,a0
80004b1c:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b20:	00800413          	li	s0,8
80004b24:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b28:	800064b7          	lui	s1,0x80006
80004b2c:	d7048513          	addi	a0,s1,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004b30:	00847413          	andi	s0,s0,8
80004b34:	ea0ff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004b38:	02051e63          	bnez	a0,80004b74 <z_set_timeout_expiry+0x78>
80004b3c:	800059b7          	lui	s3,0x80005
80004b40:	800055b7          	lui	a1,0x80005
80004b44:	80005537          	lui	a0,0x80005
80004b48:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004b4c:	04e00693          	li	a3,78
80004b50:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004b54:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004b58:	eedfc0ef          	jal	ra,80001a44 <printk>
80004b5c:	80005537          	lui	a0,0x80005
80004b60:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004b64:	ee1fc0ef          	jal	ra,80001a44 <printk>
80004b68:	04e00593          	li	a1,78
80004b6c:	7b498513          	addi	a0,s3,1972
80004b70:	f11fc0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004b74:	d7048513          	addi	a0,s1,-656
80004b78:	eb4ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80004b7c:	afdff0ef          	jal	ra,80004678 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80004b80:	00a95c63          	bge	s2,a0,80004b98 <z_set_timeout_expiry+0x9c>
80004b84:	00100793          	li	a5,1
80004b88:	00a7d863          	bge	a5,a0,80004b98 <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80004b8c:	000a0593          	mv	a1,s4
80004b90:	00090513          	mv	a0,s2
80004b94:	9c0fd0ef          	jal	ra,80001d54 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004b98:	d7048513          	addi	a0,s1,-656
80004b9c:	e60ff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004ba0:	02051e63          	bnez	a0,80004bdc <z_set_timeout_expiry+0xe0>
80004ba4:	800054b7          	lui	s1,0x80005
80004ba8:	800055b7          	lui	a1,0x80005
80004bac:	80005537          	lui	a0,0x80005
80004bb0:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004bb4:	06100693          	li	a3,97
80004bb8:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004bbc:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004bc0:	e85fc0ef          	jal	ra,80001a44 <printk>
80004bc4:	80006537          	lui	a0,0x80006
80004bc8:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004bcc:	e79fc0ef          	jal	ra,80001a44 <printk>
80004bd0:	06100593          	li	a1,97
80004bd4:	7b448513          	addi	a0,s1,1972
80004bd8:	ea9fc0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004bdc:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80004be0:	01c12083          	lw	ra,28(sp)
80004be4:	01812403          	lw	s0,24(sp)
80004be8:	01412483          	lw	s1,20(sp)
80004bec:	01012903          	lw	s2,16(sp)
80004bf0:	00c12983          	lw	s3,12(sp)
80004bf4:	00812a03          	lw	s4,8(sp)
80004bf8:	02010113          	addi	sp,sp,32
80004bfc:	00008067          	ret

80004c00 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80004c00:	fd010113          	addi	sp,sp,-48
80004c04:	02812423          	sw	s0,40(sp)
80004c08:	01412c23          	sw	s4,24(sp)
80004c0c:	02112623          	sw	ra,44(sp)
80004c10:	02912223          	sw	s1,36(sp)
80004c14:	03212023          	sw	s2,32(sp)
80004c18:	01312e23          	sw	s3,28(sp)
80004c1c:	01512a23          	sw	s5,20(sp)
80004c20:	01612823          	sw	s6,16(sp)
80004c24:	01712623          	sw	s7,12(sp)
80004c28:	01812423          	sw	s8,8(sp)
80004c2c:	01912223          	sw	s9,4(sp)
80004c30:	01a12023          	sw	s10,0(sp)
80004c34:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004c38:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80004c3c:	b59fe0ef          	jal	ra,80003794 <z_time_slice>
80004c40:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004c44:	80006937          	lui	s2,0x80006
80004c48:	d7090513          	addi	a0,s2,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004c4c:	00847413          	andi	s0,s0,8
80004c50:	d84ff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004c54:	02051e63          	bnez	a0,80004c90 <z_clock_announce+0x90>
80004c58:	800054b7          	lui	s1,0x80005
80004c5c:	800055b7          	lui	a1,0x80005
80004c60:	80005537          	lui	a0,0x80005
80004c64:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004c68:	04e00693          	li	a3,78
80004c6c:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004c70:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004c74:	dd1fc0ef          	jal	ra,80001a44 <printk>
80004c78:	80005537          	lui	a0,0x80005
80004c7c:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004c80:	dc5fc0ef          	jal	ra,80001a44 <printk>
80004c84:	04e00593          	li	a1,78
80004c88:	7b448513          	addi	a0,s1,1972
80004c8c:	df5fc0ef          	jal	ra,80001a80 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80004c90:	800069b7          	lui	s3,0x80006
	z_spin_lock_set_owner(l);
80004c94:	d7090513          	addi	a0,s2,-656
80004c98:	d94ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
80004c9c:	800064b7          	lui	s1,0x80006
80004ca0:	d749a623          	sw	s4,-660(s3) # 80005d6c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d6d>
	return list->head == list;
80004ca4:	80006a37          	lui	s4,0x80006
80004ca8:	d6c98993          	addi	s3,s3,-660
80004cac:	c90a0a13          	addi	s4,s4,-880 # 80005c90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005c91>
80004cb0:	d3048493          	addi	s1,s1,-720 # 80005d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d31>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004cb4:	80005ab7          	lui	s5,0x80005
80004cb8:	80005bb7          	lui	s7,0x80005
80004cbc:	80005b37          	lui	s6,0x80005
80004cc0:	80006c37          	lui	s8,0x80006
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004cc4:	80005cb7          	lui	s9,0x80005
80004cc8:	000a2d03          	lw	s10,0(s4)
80004ccc:	0009a783          	lw	a5,0(s3)
80004cd0:	0004a683          	lw	a3,0(s1)
80004cd4:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004cd8:	014d0c63          	beq	s10,s4,80004cf0 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80004cdc:	000d0a63          	beqz	s10,80004cf0 <z_clock_announce+0xf0>
80004ce0:	008d2703          	lw	a4,8(s10)
80004ce4:	0ae7dc63          	bge	a5,a4,80004d9c <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80004ce8:	40f70733          	sub	a4,a4,a5
80004cec:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80004cf0:	00d786b3          	add	a3,a5,a3
80004cf4:	41f7d713          	srai	a4,a5,0x1f
80004cf8:	00a70733          	add	a4,a4,a0
80004cfc:	00f6b7b3          	sltu	a5,a3,a5
80004d00:	00e787b3          	add	a5,a5,a4
80004d04:	00d4a023          	sw	a3,0(s1)
80004d08:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80004d0c:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80004d10:	969ff0ef          	jal	ra,80004678 <next_timeout>
80004d14:	00000593          	li	a1,0
80004d18:	83cfd0ef          	jal	ra,80001d54 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004d1c:	d7090513          	addi	a0,s2,-656
80004d20:	cdcff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004d24:	02051e63          	bnez	a0,80004d60 <z_clock_announce+0x160>
80004d28:	800054b7          	lui	s1,0x80005
80004d2c:	800055b7          	lui	a1,0x80005
80004d30:	80005537          	lui	a0,0x80005
80004d34:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004d38:	06100693          	li	a3,97
80004d3c:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004d40:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004d44:	d01fc0ef          	jal	ra,80001a44 <printk>
80004d48:	80006537          	lui	a0,0x80006
80004d4c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004d50:	cf5fc0ef          	jal	ra,80001a44 <printk>
80004d54:	06100593          	li	a1,97
80004d58:	7b448513          	addi	a0,s1,1972
80004d5c:	d25fc0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004d60:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80004d64:	02c12083          	lw	ra,44(sp)
80004d68:	02812403          	lw	s0,40(sp)
80004d6c:	02412483          	lw	s1,36(sp)
80004d70:	02012903          	lw	s2,32(sp)
80004d74:	01c12983          	lw	s3,28(sp)
80004d78:	01812a03          	lw	s4,24(sp)
80004d7c:	01412a83          	lw	s5,20(sp)
80004d80:	01012b03          	lw	s6,16(sp)
80004d84:	00c12b83          	lw	s7,12(sp)
80004d88:	00812c03          	lw	s8,8(sp)
80004d8c:	00412c83          	lw	s9,4(sp)
80004d90:	00012d03          	lw	s10,0(sp)
80004d94:	03010113          	addi	sp,sp,48
80004d98:	00008067          	ret
		curr_tick += dt;
80004d9c:	00d706b3          	add	a3,a4,a3
80004da0:	41f75593          	srai	a1,a4,0x1f
80004da4:	00a585b3          	add	a1,a1,a0
80004da8:	00e6b633          	sltu	a2,a3,a4
80004dac:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80004db0:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80004db4:	000d0513          	mv	a0,s10
		t->dticks = 0;
80004db8:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80004dbc:	00d4a023          	sw	a3,0(s1)
80004dc0:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80004dc4:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004dc8:	871ff0ef          	jal	ra,80004638 <remove_timeout>
80004dcc:	d7090513          	addi	a0,s2,-656
80004dd0:	c2cff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004dd4:	02051663          	bnez	a0,80004e00 <z_clock_announce+0x200>
80004dd8:	7fcb8593          	addi	a1,s7,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004ddc:	06100693          	li	a3,97
80004de0:	7b4a8613          	addi	a2,s5,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004de4:	6e8b0513          	addi	a0,s6,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004de8:	c5dfc0ef          	jal	ra,80001a44 <printk>
80004dec:	814c0513          	addi	a0,s8,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004df0:	c55fc0ef          	jal	ra,80001a44 <printk>
80004df4:	06100593          	li	a1,97
80004df8:	7b4a8513          	addi	a0,s5,1972
80004dfc:	c85fc0ef          	jal	ra,80001a80 <assert_post_action>
80004e00:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004e04:	00cd2783          	lw	a5,12(s10)
80004e08:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e0c:	00800413          	li	s0,8
80004e10:	000780e7          	jalr	a5
80004e14:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e18:	d7090513          	addi	a0,s2,-656
	key = (mstatus & SOC_MSTATUS_IEN);
80004e1c:	00847413          	andi	s0,s0,8
80004e20:	bb4ff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004e24:	02051863          	bnez	a0,80004e54 <z_clock_announce+0x254>
80004e28:	7ccc8593          	addi	a1,s9,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004e2c:	04e00693          	li	a3,78
80004e30:	7b4a8613          	addi	a2,s5,1972
80004e34:	6e8b0513          	addi	a0,s6,1768
80004e38:	c0dfc0ef          	jal	ra,80001a44 <printk>
80004e3c:	80005537          	lui	a0,0x80005
80004e40:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004e44:	c01fc0ef          	jal	ra,80001a44 <printk>
80004e48:	04e00593          	li	a1,78
80004e4c:	7b4a8513          	addi	a0,s5,1972
80004e50:	c31fc0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004e54:	d7090513          	addi	a0,s2,-656
80004e58:	bd4ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	return k;
80004e5c:	e6dff06f          	j	80004cc8 <z_clock_announce+0xc8>

80004e60 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80004e60:	fe010113          	addi	sp,sp,-32
80004e64:	00912a23          	sw	s1,20(sp)
80004e68:	00112e23          	sw	ra,28(sp)
80004e6c:	00812c23          	sw	s0,24(sp)
80004e70:	01212823          	sw	s2,16(sp)
80004e74:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004e78:	00800493          	li	s1,8
80004e7c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004e80:	80006937          	lui	s2,0x80006
80004e84:	d7090513          	addi	a0,s2,-656 # 80005d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d71>
	key = (mstatus & SOC_MSTATUS_IEN);
80004e88:	0084f493          	andi	s1,s1,8
80004e8c:	b48ff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004e90:	02051e63          	bnez	a0,80004ecc <z_tick_get+0x6c>
80004e94:	80005437          	lui	s0,0x80005
80004e98:	800055b7          	lui	a1,0x80005
80004e9c:	80005537          	lui	a0,0x80005
80004ea0:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004ea4:	04e00693          	li	a3,78
80004ea8:	7b440613          	addi	a2,s0,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004eac:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004eb0:	b95fc0ef          	jal	ra,80001a44 <printk>
80004eb4:	80005537          	lui	a0,0x80005
80004eb8:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004ebc:	b89fc0ef          	jal	ra,80001a44 <printk>
80004ec0:	04e00593          	li	a1,78
80004ec4:	7b440513          	addi	a0,s0,1972
80004ec8:	bb9fc0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ecc:	d7090513          	addi	a0,s2,-656
80004ed0:	b5cff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80004ed4:	ffdfc0ef          	jal	ra,80001ed0 <z_clock_elapsed>
80004ed8:	800067b7          	lui	a5,0x80006
80004edc:	d3078793          	addi	a5,a5,-720 # 80005d30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d31>
80004ee0:	0007a983          	lw	s3,0(a5)
80004ee4:	0047a403          	lw	s0,4(a5)
80004ee8:	013509b3          	add	s3,a0,s3
80004eec:	00a9b533          	sltu	a0,s3,a0
80004ef0:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004ef4:	d7090513          	addi	a0,s2,-656
80004ef8:	b04ff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004efc:	02051e63          	bnez	a0,80004f38 <z_tick_get+0xd8>
80004f00:	80005937          	lui	s2,0x80005
80004f04:	800055b7          	lui	a1,0x80005
80004f08:	80005537          	lui	a0,0x80005
80004f0c:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80004f10:	06100693          	li	a3,97
80004f14:	7b490613          	addi	a2,s2,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004f18:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004f1c:	b29fc0ef          	jal	ra,80001a44 <printk>
80004f20:	80006537          	lui	a0,0x80006
80004f24:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80004f28:	b1dfc0ef          	jal	ra,80001a44 <printk>
80004f2c:	06100593          	li	a1,97
80004f30:	7b490513          	addi	a0,s2,1972
80004f34:	b4dfc0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f38:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004f3c:	00040593          	mv	a1,s0
80004f40:	01c12083          	lw	ra,28(sp)
80004f44:	01812403          	lw	s0,24(sp)
80004f48:	00098513          	mv	a0,s3
80004f4c:	01412483          	lw	s1,20(sp)
80004f50:	01012903          	lw	s2,16(sp)
80004f54:	00c12983          	lw	s3,12(sp)
80004f58:	02010113          	addi	sp,sp,32
80004f5c:	00008067          	ret

80004f60 <z_impl_atomic_add>:
 * @param value the value to add
 *
 * @return The previous value from <target>
 */
atomic_val_t z_impl_atomic_add(atomic_t *target, atomic_val_t value)
{
80004f60:	fe010113          	addi	sp,sp,-32
80004f64:	00812c23          	sw	s0,24(sp)
80004f68:	01212823          	sw	s2,16(sp)
80004f6c:	01412423          	sw	s4,8(sp)
80004f70:	00112e23          	sw	ra,28(sp)
80004f74:	00912a23          	sw	s1,20(sp)
80004f78:	01312623          	sw	s3,12(sp)
80004f7c:	00050a13          	mv	s4,a0
80004f80:	00058913          	mv	s2,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004f84:	00800413          	li	s0,8
80004f88:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004f8c:	800064b7          	lui	s1,0x80006
80004f90:	d7448513          	addi	a0,s1,-652 # 80005d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d75>
	key = (mstatus & SOC_MSTATUS_IEN);
80004f94:	00847413          	andi	s0,s0,8
80004f98:	a3cff0ef          	jal	ra,800041d4 <z_spin_lock_valid>
80004f9c:	02051e63          	bnez	a0,80004fd8 <z_impl_atomic_add+0x78>
80004fa0:	800059b7          	lui	s3,0x80005
80004fa4:	800055b7          	lui	a1,0x80005
80004fa8:	80005537          	lui	a0,0x80005
80004fac:	7cc58593          	addi	a1,a1,1996 # 800057cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057cd>
80004fb0:	04e00693          	li	a3,78
80004fb4:	7b498613          	addi	a2,s3,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80004fb8:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80004fbc:	a89fc0ef          	jal	ra,80001a44 <printk>
80004fc0:	80005537          	lui	a0,0x80005
80004fc4:	7e450513          	addi	a0,a0,2020 # 800057e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057e5>
80004fc8:	a7dfc0ef          	jal	ra,80001a44 <printk>
80004fcc:	04e00593          	li	a1,78
80004fd0:	7b498513          	addi	a0,s3,1972
80004fd4:	aadfc0ef          	jal	ra,80001a80 <assert_post_action>
	z_spin_lock_set_owner(l);
80004fd8:	d7448513          	addi	a0,s1,-652
80004fdc:	a50ff0ef          	jal	ra,8000422c <z_spin_lock_set_owner>
	k_spinlock_key_t key;
	atomic_val_t ret;

	key = k_spin_lock(&lock);

	ret = *target;
80004fe0:	000a2983          	lw	s3,0(s4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004fe4:	d7448513          	addi	a0,s1,-652
	*target += value;
80004fe8:	01298933          	add	s2,s3,s2
80004fec:	012a2023          	sw	s2,0(s4)
80004ff0:	a0cff0ef          	jal	ra,800041fc <z_spin_unlock_valid>
80004ff4:	02051e63          	bnez	a0,80005030 <z_impl_atomic_add+0xd0>
80004ff8:	800054b7          	lui	s1,0x80005
80004ffc:	800055b7          	lui	a1,0x80005
80005000:	80005537          	lui	a0,0x80005
80005004:	7fc58593          	addi	a1,a1,2044 # 800057fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057fd>
80005008:	06100693          	li	a3,97
8000500c:	7b448613          	addi	a2,s1,1972 # 800057b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800057b5>
80005010:	6e850513          	addi	a0,a0,1768 # 800056e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800056e9>
80005014:	a31fc0ef          	jal	ra,80001a44 <printk>
80005018:	80006537          	lui	a0,0x80006
8000501c:	81450513          	addi	a0,a0,-2028 # 80005814 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005815>
80005020:	a25fc0ef          	jal	ra,80001a44 <printk>
80005024:	06100593          	li	a1,97
80005028:	7b448513          	addi	a0,s1,1972
8000502c:	a55fc0ef          	jal	ra,80001a80 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005030:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);

	return ret;
}
80005034:	01c12083          	lw	ra,28(sp)
80005038:	01812403          	lw	s0,24(sp)
8000503c:	00098513          	mv	a0,s3
80005040:	01412483          	lw	s1,20(sp)
80005044:	01012903          	lw	s2,16(sp)
80005048:	00c12983          	lw	s3,12(sp)
8000504c:	00812a03          	lw	s4,8(sp)
80005050:	02010113          	addi	sp,sp,32
80005054:	00008067          	ret

80005058 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80005058:	00008067          	ret
