
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01428293          	addi	t0,t0,20 # 80000014 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	1890006f          	j	80000994 <__initialize>
	...

Disassembly of section exceptions:

80000014 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000014:	715d                	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000016:	c006                	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	c20e                	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001a:	c412                	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
8000001c:	c616                	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
8000001e:	c81a                	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000020:	ca1e                	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
80000022:	cc72                	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000024:	ce76                	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000026:	d07a                	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000028:	d27e                	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000002a:	d42a                	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
8000002c:	d62e                	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
8000002e:	d832                	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000030:	da36                	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
80000032:	dc3a                	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000034:	de3e                	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000036:	c0c2                	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000038:	c2c6                	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000003a:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000003e:	c496                	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000040:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000044:	c696                	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
80000046:	1be000ef          	jal	ra,80000204 <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
8000004a:	00000313          	li	t1,0
	bnez a0, is_interrupt
8000004e:	e121                	bnez	a0,8000008e <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000050:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
80000054:	800003b7          	lui	t2,0x80000
80000058:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
8000005c:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000060:	432d                	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
80000062:	00628a63          	beq	t0,t1,80000076 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000066:	00010513          	mv	a0,sp
	la ra, no_reschedule
8000006a:	00000097          	auipc	ra,0x0
8000006e:	12e08093          	addi	ra,ra,302 # 80000198 <no_reschedule>
	tail _Fault
80000072:	6190006f          	j	80000e8a <_Fault>

80000076 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000076:	42a6                	lw	t0,72(sp)
	addi t0, t0, 4
80000078:	0291                	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
8000007a:	c496                	sw	t0,72(sp)
	 * Determine if the system call is the result of an IRQ offloading.
	 * Done by checking if _offload_routine is not pointing to NULL.
	 * If NULL, jump to reschedule to perform a context-switch, otherwise,
	 * jump to is_interrupt to handle the IRQ offload.
	 */
	la t0, _offload_routine
8000007c:	00005297          	auipc	t0,0x5
80000080:	10828293          	addi	t0,t0,264 # 80005184 <_offload_routine>
	lw t1, 0x00(t0)
80000084:	0002a303          	lw	t1,0(t0)
	bnez t1, is_interrupt
80000088:	00031363          	bnez	t1,8000008e <is_interrupt>
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
8000008c:	a041                	j	8000010c <reschedule>

8000008e <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
8000008e:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
80000092:	00005397          	auipc	t2,0x5
80000096:	39a38393          	addi	t2,t2,922 # 8000542c <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
8000009a:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
8000009e:	1141                	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000a0:	c016                	sw	t0,0(sp)

800000a2 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000a2:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000a6:	0e05                	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000a8:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000ac:	00030863          	beqz	t1,800000bc <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000b0:	00000097          	auipc	ra,0x0
800000b4:	03808093          	addi	ra,ra,56 # 800000e8 <on_thread_stack>
	tail z_irq_do_offload
800000b8:	6350006f          	j	80000eec <z_irq_do_offload>

800000bc <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000bc:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000c0:	800002b7          	lui	t0,0x80000
800000c4:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000c8:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000cc:	128000ef          	jal	ra,800001f4 <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000d0:	00004297          	auipc	t0,0x4
800000d4:	10428293          	addi	t0,t0,260 # 800041d4 <_sw_isr_table>
	slli a0, a0, 3
800000d8:	050e                	slli	a0,a0,0x3
	add t0, t0, a0
800000da:	92aa                	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
800000dc:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
800000e0:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
800000e4:	000300e7          	jalr	t1

800000e8 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
800000e8:	00005317          	auipc	t1,0x5
800000ec:	34430313          	addi	t1,t1,836 # 8000542c <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
800000f0:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
800000f4:	13fd                	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
800000f6:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
800000fa:	4282                	lw	t0,0(sp)
	addi sp, t0, 0
800000fc:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000100:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000104:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000108:	087e0863          	beq	t3,t2,80000198 <no_reschedule>

8000010c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000010c:	00005297          	auipc	t0,0x5
80000110:	32028293          	addi	t0,t0,800 # 8000542c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000114:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000118:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000011c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000120:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000124:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000128:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000012c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000130:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000134:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000138:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000013c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000140:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000144:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000148:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000014c:	00005397          	auipc	t2,0x5
80000150:	fd838393          	addi	t2,t2,-40 # 80005124 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000154:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000158:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000015c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000160:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000164:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000168:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000016c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
80000170:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
80000174:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
80000178:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
8000017c:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
80000180:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
80000184:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
80000188:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
8000018c:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
80000190:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
80000194:	05832d83          	lw	s11,88(t1)

80000198 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
80000198:	42a6                	lw	t0,72(sp)
	csrw mepc, t0
8000019a:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
8000019e:	42b6                	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001a0:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001a4:	4082                	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001a6:	4192                	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001a8:	4222                	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001aa:	42b2                	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001ac:	4342                	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ae:	43d2                	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001b0:	4e62                	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001b2:	4ef2                	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001b4:	5f02                	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001b6:	5f92                	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
800001b8:	5522                	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
800001ba:	55b2                	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
800001bc:	5642                	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
800001be:	56d2                	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
800001c0:	5762                	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
800001c2:	57f2                	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
800001c4:	4806                	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
800001c6:	4896                	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
800001c8:	6161                	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
800001ca:	30200073          	mret
	...

800001d0 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
800001d0:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
800001d4:	00005297          	auipc	t0,0x5
800001d8:	25828293          	addi	t0,t0,600 # 8000542c <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
800001dc:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
800001e0:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
800001e4:	8921                	andi	a0,a0,8
	csrrs t0, mstatus, a0
800001e6:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
800001ea:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
800001ee:	00008067          	ret
	...

800001f4 <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
800001f4:	4305                	li	t1,1
	sll t0, t1, a0
800001f6:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
800001fa:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
800001fe:	00008067          	ret
	...

80000204 <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
80000204:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000208:	80000337          	lui	t1,0x80000
	and t0, t0, t1
8000020c:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000210:	00000513          	li	a0,0
	beqz t0, not_interrupt
80000214:	00028363          	beqz	t0,8000021a <not_interrupt>
	addi a0, a0, 1
80000218:	0505                	addi	a0,a0,1

8000021a <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
8000021a:	00008067          	ret

Disassembly of section text:

80000220 <__lshrdi3>:
80000220:	02060063          	beqz	a2,80000240 <__lshrdi3+0x20>
80000224:	02000793          	li	a5,32
80000228:	40c787b3          	sub	a5,a5,a2
8000022c:	00f04c63          	bgtz	a5,80000244 <__lshrdi3+0x24>
80000230:	fe060513          	addi	a0,a2,-32
80000234:	00000713          	li	a4,0
80000238:	00a5d533          	srl	a0,a1,a0
8000023c:	00070593          	mv	a1,a4
80000240:	00008067          	ret
80000244:	00c5d733          	srl	a4,a1,a2
80000248:	00c55533          	srl	a0,a0,a2
8000024c:	00f595b3          	sll	a1,a1,a5
80000250:	00b56533          	or	a0,a0,a1
80000254:	fe9ff06f          	j	8000023c <__lshrdi3+0x1c>

80000258 <__udivdi3>:
80000258:	fd010113          	addi	sp,sp,-48
8000025c:	02912223          	sw	s1,36(sp)
80000260:	01612823          	sw	s6,16(sp)
80000264:	02112623          	sw	ra,44(sp)
80000268:	02812423          	sw	s0,40(sp)
8000026c:	03212023          	sw	s2,32(sp)
80000270:	01312e23          	sw	s3,28(sp)
80000274:	01412c23          	sw	s4,24(sp)
80000278:	01512a23          	sw	s5,20(sp)
8000027c:	01712623          	sw	s7,12(sp)
80000280:	01812423          	sw	s8,8(sp)
80000284:	01912223          	sw	s9,4(sp)
80000288:	00050b13          	mv	s6,a0
8000028c:	00058493          	mv	s1,a1
80000290:	38069c63          	bnez	a3,80000628 <__udivdi3+0x3d0>
80000294:	00060413          	mv	s0,a2
80000298:	00050993          	mv	s3,a0
8000029c:	00004917          	auipc	s2,0x4
800002a0:	0b890913          	addi	s2,s2,184 # 80004354 <__devconfig_end>
800002a4:	12c5f863          	bgeu	a1,a2,800003d4 <__udivdi3+0x17c>
800002a8:	000107b7          	lui	a5,0x10
800002ac:	00058a93          	mv	s5,a1
800002b0:	10f67863          	bgeu	a2,a5,800003c0 <__udivdi3+0x168>
800002b4:	0ff00693          	li	a3,255
800002b8:	00c6b6b3          	sltu	a3,a3,a2
800002bc:	00369693          	slli	a3,a3,0x3
800002c0:	00d657b3          	srl	a5,a2,a3
800002c4:	00f90933          	add	s2,s2,a5
800002c8:	00094703          	lbu	a4,0(s2)
800002cc:	00d706b3          	add	a3,a4,a3
800002d0:	02000713          	li	a4,32
800002d4:	40d70733          	sub	a4,a4,a3
800002d8:	00070c63          	beqz	a4,800002f0 <__udivdi3+0x98>
800002dc:	00e494b3          	sll	s1,s1,a4
800002e0:	00db56b3          	srl	a3,s6,a3
800002e4:	00e61433          	sll	s0,a2,a4
800002e8:	0096eab3          	or	s5,a3,s1
800002ec:	00eb19b3          	sll	s3,s6,a4
800002f0:	01045b13          	srli	s6,s0,0x10
800002f4:	000b0593          	mv	a1,s6
800002f8:	000a8513          	mv	a0,s5
800002fc:	634000ef          	jal	ra,80000930 <__umodsi3>
80000300:	00050913          	mv	s2,a0
80000304:	000b0593          	mv	a1,s6
80000308:	01041b93          	slli	s7,s0,0x10
8000030c:	000a8513          	mv	a0,s5
80000310:	5d8000ef          	jal	ra,800008e8 <__udivsi3>
80000314:	010bdb93          	srli	s7,s7,0x10
80000318:	00050493          	mv	s1,a0
8000031c:	00050593          	mv	a1,a0
80000320:	000b8513          	mv	a0,s7
80000324:	508000ef          	jal	ra,8000082c <__mulsi3>
80000328:	01091913          	slli	s2,s2,0x10
8000032c:	0109d713          	srli	a4,s3,0x10
80000330:	00e96733          	or	a4,s2,a4
80000334:	00048a13          	mv	s4,s1
80000338:	00a77e63          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000033c:	00870733          	add	a4,a4,s0
80000340:	fff48a13          	addi	s4,s1,-1
80000344:	00876863          	bltu	a4,s0,80000354 <__udivdi3+0xfc>
80000348:	00a77663          	bgeu	a4,a0,80000354 <__udivdi3+0xfc>
8000034c:	ffe48a13          	addi	s4,s1,-2
80000350:	00870733          	add	a4,a4,s0
80000354:	40a704b3          	sub	s1,a4,a0
80000358:	000b0593          	mv	a1,s6
8000035c:	00048513          	mv	a0,s1
80000360:	5d0000ef          	jal	ra,80000930 <__umodsi3>
80000364:	00050913          	mv	s2,a0
80000368:	000b0593          	mv	a1,s6
8000036c:	00048513          	mv	a0,s1
80000370:	578000ef          	jal	ra,800008e8 <__udivsi3>
80000374:	01099993          	slli	s3,s3,0x10
80000378:	00050493          	mv	s1,a0
8000037c:	00050593          	mv	a1,a0
80000380:	01091913          	slli	s2,s2,0x10
80000384:	000b8513          	mv	a0,s7
80000388:	0109d993          	srli	s3,s3,0x10
8000038c:	4a0000ef          	jal	ra,8000082c <__mulsi3>
80000390:	013969b3          	or	s3,s2,s3
80000394:	00048613          	mv	a2,s1
80000398:	00a9fc63          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
8000039c:	013409b3          	add	s3,s0,s3
800003a0:	fff48613          	addi	a2,s1,-1
800003a4:	0089e663          	bltu	s3,s0,800003b0 <__udivdi3+0x158>
800003a8:	00a9f463          	bgeu	s3,a0,800003b0 <__udivdi3+0x158>
800003ac:	ffe48613          	addi	a2,s1,-2
800003b0:	010a1793          	slli	a5,s4,0x10
800003b4:	00c7e7b3          	or	a5,a5,a2
800003b8:	00000a13          	li	s4,0
800003bc:	1300006f          	j	800004ec <__udivdi3+0x294>
800003c0:	010007b7          	lui	a5,0x1000
800003c4:	01000693          	li	a3,16
800003c8:	eef66ce3          	bltu	a2,a5,800002c0 <__udivdi3+0x68>
800003cc:	01800693          	li	a3,24
800003d0:	ef1ff06f          	j	800002c0 <__udivdi3+0x68>
800003d4:	00068a13          	mv	s4,a3
800003d8:	00061a63          	bnez	a2,800003ec <__udivdi3+0x194>
800003dc:	00000593          	li	a1,0
800003e0:	00100513          	li	a0,1
800003e4:	504000ef          	jal	ra,800008e8 <__udivsi3>
800003e8:	00050413          	mv	s0,a0
800003ec:	000107b7          	lui	a5,0x10
800003f0:	12f47c63          	bgeu	s0,a5,80000528 <__udivdi3+0x2d0>
800003f4:	0ff00793          	li	a5,255
800003f8:	0087f463          	bgeu	a5,s0,80000400 <__udivdi3+0x1a8>
800003fc:	00800a13          	li	s4,8
80000400:	014457b3          	srl	a5,s0,s4
80000404:	00f90933          	add	s2,s2,a5
80000408:	00094683          	lbu	a3,0(s2)
8000040c:	02000613          	li	a2,32
80000410:	014686b3          	add	a3,a3,s4
80000414:	40d60633          	sub	a2,a2,a3
80000418:	12061263          	bnez	a2,8000053c <__udivdi3+0x2e4>
8000041c:	408484b3          	sub	s1,s1,s0
80000420:	00100a13          	li	s4,1
80000424:	01045b13          	srli	s6,s0,0x10
80000428:	000b0593          	mv	a1,s6
8000042c:	00048513          	mv	a0,s1
80000430:	500000ef          	jal	ra,80000930 <__umodsi3>
80000434:	00050913          	mv	s2,a0
80000438:	000b0593          	mv	a1,s6
8000043c:	00048513          	mv	a0,s1
80000440:	01041b93          	slli	s7,s0,0x10
80000444:	4a4000ef          	jal	ra,800008e8 <__udivsi3>
80000448:	010bdb93          	srli	s7,s7,0x10
8000044c:	00050493          	mv	s1,a0
80000450:	00050593          	mv	a1,a0
80000454:	000b8513          	mv	a0,s7
80000458:	3d4000ef          	jal	ra,8000082c <__mulsi3>
8000045c:	01091913          	slli	s2,s2,0x10
80000460:	0109d713          	srli	a4,s3,0x10
80000464:	00e96733          	or	a4,s2,a4
80000468:	00048a93          	mv	s5,s1
8000046c:	00a77e63          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000470:	00870733          	add	a4,a4,s0
80000474:	fff48a93          	addi	s5,s1,-1
80000478:	00876863          	bltu	a4,s0,80000488 <__udivdi3+0x230>
8000047c:	00a77663          	bgeu	a4,a0,80000488 <__udivdi3+0x230>
80000480:	ffe48a93          	addi	s5,s1,-2
80000484:	00870733          	add	a4,a4,s0
80000488:	40a704b3          	sub	s1,a4,a0
8000048c:	000b0593          	mv	a1,s6
80000490:	00048513          	mv	a0,s1
80000494:	49c000ef          	jal	ra,80000930 <__umodsi3>
80000498:	00050913          	mv	s2,a0
8000049c:	000b0593          	mv	a1,s6
800004a0:	00048513          	mv	a0,s1
800004a4:	444000ef          	jal	ra,800008e8 <__udivsi3>
800004a8:	01099993          	slli	s3,s3,0x10
800004ac:	00050493          	mv	s1,a0
800004b0:	00050593          	mv	a1,a0
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	000b8513          	mv	a0,s7
800004bc:	0109d993          	srli	s3,s3,0x10
800004c0:	36c000ef          	jal	ra,8000082c <__mulsi3>
800004c4:	013969b3          	or	s3,s2,s3
800004c8:	00048613          	mv	a2,s1
800004cc:	00a9fc63          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004d0:	013409b3          	add	s3,s0,s3
800004d4:	fff48613          	addi	a2,s1,-1
800004d8:	0089e663          	bltu	s3,s0,800004e4 <__udivdi3+0x28c>
800004dc:	00a9f463          	bgeu	s3,a0,800004e4 <__udivdi3+0x28c>
800004e0:	ffe48613          	addi	a2,s1,-2
800004e4:	010a9793          	slli	a5,s5,0x10
800004e8:	00c7e7b3          	or	a5,a5,a2
800004ec:	00078513          	mv	a0,a5
800004f0:	000a0593          	mv	a1,s4
800004f4:	02c12083          	lw	ra,44(sp)
800004f8:	02812403          	lw	s0,40(sp)
800004fc:	02412483          	lw	s1,36(sp)
80000500:	02012903          	lw	s2,32(sp)
80000504:	01c12983          	lw	s3,28(sp)
80000508:	01812a03          	lw	s4,24(sp)
8000050c:	01412a83          	lw	s5,20(sp)
80000510:	01012b03          	lw	s6,16(sp)
80000514:	00c12b83          	lw	s7,12(sp)
80000518:	00812c03          	lw	s8,8(sp)
8000051c:	00412c83          	lw	s9,4(sp)
80000520:	03010113          	addi	sp,sp,48
80000524:	00008067          	ret
80000528:	010007b7          	lui	a5,0x1000
8000052c:	01000a13          	li	s4,16
80000530:	ecf468e3          	bltu	s0,a5,80000400 <__udivdi3+0x1a8>
80000534:	01800a13          	li	s4,24
80000538:	ec9ff06f          	j	80000400 <__udivdi3+0x1a8>
8000053c:	00c41433          	sll	s0,s0,a2
80000540:	00d4da33          	srl	s4,s1,a3
80000544:	00cb19b3          	sll	s3,s6,a2
80000548:	00db56b3          	srl	a3,s6,a3
8000054c:	01045b13          	srli	s6,s0,0x10
80000550:	00c494b3          	sll	s1,s1,a2
80000554:	000b0593          	mv	a1,s6
80000558:	000a0513          	mv	a0,s4
8000055c:	0096eab3          	or	s5,a3,s1
80000560:	3d0000ef          	jal	ra,80000930 <__umodsi3>
80000564:	00050913          	mv	s2,a0
80000568:	000b0593          	mv	a1,s6
8000056c:	000a0513          	mv	a0,s4
80000570:	01041b93          	slli	s7,s0,0x10
80000574:	374000ef          	jal	ra,800008e8 <__udivsi3>
80000578:	010bdb93          	srli	s7,s7,0x10
8000057c:	00050493          	mv	s1,a0
80000580:	00050593          	mv	a1,a0
80000584:	000b8513          	mv	a0,s7
80000588:	2a4000ef          	jal	ra,8000082c <__mulsi3>
8000058c:	01091913          	slli	s2,s2,0x10
80000590:	010ad713          	srli	a4,s5,0x10
80000594:	00e96733          	or	a4,s2,a4
80000598:	00048a13          	mv	s4,s1
8000059c:	00a77e63          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005a0:	00870733          	add	a4,a4,s0
800005a4:	fff48a13          	addi	s4,s1,-1
800005a8:	00876863          	bltu	a4,s0,800005b8 <__udivdi3+0x360>
800005ac:	00a77663          	bgeu	a4,a0,800005b8 <__udivdi3+0x360>
800005b0:	ffe48a13          	addi	s4,s1,-2
800005b4:	00870733          	add	a4,a4,s0
800005b8:	40a704b3          	sub	s1,a4,a0
800005bc:	000b0593          	mv	a1,s6
800005c0:	00048513          	mv	a0,s1
800005c4:	36c000ef          	jal	ra,80000930 <__umodsi3>
800005c8:	00050913          	mv	s2,a0
800005cc:	000b0593          	mv	a1,s6
800005d0:	00048513          	mv	a0,s1
800005d4:	314000ef          	jal	ra,800008e8 <__udivsi3>
800005d8:	00050493          	mv	s1,a0
800005dc:	00050593          	mv	a1,a0
800005e0:	000b8513          	mv	a0,s7
800005e4:	248000ef          	jal	ra,8000082c <__mulsi3>
800005e8:	010a9693          	slli	a3,s5,0x10
800005ec:	01091913          	slli	s2,s2,0x10
800005f0:	0106d693          	srli	a3,a3,0x10
800005f4:	00d967b3          	or	a5,s2,a3
800005f8:	00048713          	mv	a4,s1
800005fc:	00a7fe63          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000600:	008787b3          	add	a5,a5,s0
80000604:	fff48713          	addi	a4,s1,-1
80000608:	0087e863          	bltu	a5,s0,80000618 <__udivdi3+0x3c0>
8000060c:	00a7f663          	bgeu	a5,a0,80000618 <__udivdi3+0x3c0>
80000610:	ffe48713          	addi	a4,s1,-2
80000614:	008787b3          	add	a5,a5,s0
80000618:	010a1a13          	slli	s4,s4,0x10
8000061c:	40a784b3          	sub	s1,a5,a0
80000620:	00ea6a33          	or	s4,s4,a4
80000624:	e01ff06f          	j	80000424 <__udivdi3+0x1cc>
80000628:	1ed5ec63          	bltu	a1,a3,80000820 <__udivdi3+0x5c8>
8000062c:	000107b7          	lui	a5,0x10
80000630:	04f6f463          	bgeu	a3,a5,80000678 <__udivdi3+0x420>
80000634:	0ff00593          	li	a1,255
80000638:	00d5b533          	sltu	a0,a1,a3
8000063c:	00351513          	slli	a0,a0,0x3
80000640:	00a6d733          	srl	a4,a3,a0
80000644:	00004797          	auipc	a5,0x4
80000648:	d1078793          	addi	a5,a5,-752 # 80004354 <__devconfig_end>
8000064c:	00e787b3          	add	a5,a5,a4
80000650:	0007c583          	lbu	a1,0(a5)
80000654:	02000a13          	li	s4,32
80000658:	00a585b3          	add	a1,a1,a0
8000065c:	40ba0a33          	sub	s4,s4,a1
80000660:	020a1663          	bnez	s4,8000068c <__udivdi3+0x434>
80000664:	00100793          	li	a5,1
80000668:	e896e2e3          	bltu	a3,s1,800004ec <__udivdi3+0x294>
8000066c:	00cb3633          	sltu	a2,s6,a2
80000670:	00164793          	xori	a5,a2,1
80000674:	e79ff06f          	j	800004ec <__udivdi3+0x294>
80000678:	010007b7          	lui	a5,0x1000
8000067c:	01000513          	li	a0,16
80000680:	fcf6e0e3          	bltu	a3,a5,80000640 <__udivdi3+0x3e8>
80000684:	01800513          	li	a0,24
80000688:	fb9ff06f          	j	80000640 <__udivdi3+0x3e8>
8000068c:	00b65ab3          	srl	s5,a2,a1
80000690:	014696b3          	sll	a3,a3,s4
80000694:	00daeab3          	or	s5,s5,a3
80000698:	00b4d933          	srl	s2,s1,a1
8000069c:	014497b3          	sll	a5,s1,s4
800006a0:	00bb55b3          	srl	a1,s6,a1
800006a4:	010adb93          	srli	s7,s5,0x10
800006a8:	00f5e4b3          	or	s1,a1,a5
800006ac:	00090513          	mv	a0,s2
800006b0:	000b8593          	mv	a1,s7
800006b4:	014619b3          	sll	s3,a2,s4
800006b8:	278000ef          	jal	ra,80000930 <__umodsi3>
800006bc:	00050413          	mv	s0,a0
800006c0:	000b8593          	mv	a1,s7
800006c4:	00090513          	mv	a0,s2
800006c8:	010a9c13          	slli	s8,s5,0x10
800006cc:	21c000ef          	jal	ra,800008e8 <__udivsi3>
800006d0:	010c5c13          	srli	s8,s8,0x10
800006d4:	00050913          	mv	s2,a0
800006d8:	00050593          	mv	a1,a0
800006dc:	000c0513          	mv	a0,s8
800006e0:	14c000ef          	jal	ra,8000082c <__mulsi3>
800006e4:	01041413          	slli	s0,s0,0x10
800006e8:	0104d713          	srli	a4,s1,0x10
800006ec:	00e46733          	or	a4,s0,a4
800006f0:	00090c93          	mv	s9,s2
800006f4:	00a77e63          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
800006f8:	01570733          	add	a4,a4,s5
800006fc:	fff90c93          	addi	s9,s2,-1
80000700:	01576863          	bltu	a4,s5,80000710 <__udivdi3+0x4b8>
80000704:	00a77663          	bgeu	a4,a0,80000710 <__udivdi3+0x4b8>
80000708:	ffe90c93          	addi	s9,s2,-2
8000070c:	01570733          	add	a4,a4,s5
80000710:	40a70933          	sub	s2,a4,a0
80000714:	000b8593          	mv	a1,s7
80000718:	00090513          	mv	a0,s2
8000071c:	214000ef          	jal	ra,80000930 <__umodsi3>
80000720:	00050413          	mv	s0,a0
80000724:	000b8593          	mv	a1,s7
80000728:	00090513          	mv	a0,s2
8000072c:	1bc000ef          	jal	ra,800008e8 <__udivsi3>
80000730:	00050913          	mv	s2,a0
80000734:	00050593          	mv	a1,a0
80000738:	000c0513          	mv	a0,s8
8000073c:	0f0000ef          	jal	ra,8000082c <__mulsi3>
80000740:	01049793          	slli	a5,s1,0x10
80000744:	01041413          	slli	s0,s0,0x10
80000748:	0107d793          	srli	a5,a5,0x10
8000074c:	00f46733          	or	a4,s0,a5
80000750:	00090613          	mv	a2,s2
80000754:	00a77e63          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000758:	01570733          	add	a4,a4,s5
8000075c:	fff90613          	addi	a2,s2,-1
80000760:	01576863          	bltu	a4,s5,80000770 <__udivdi3+0x518>
80000764:	00a77663          	bgeu	a4,a0,80000770 <__udivdi3+0x518>
80000768:	ffe90613          	addi	a2,s2,-2
8000076c:	01570733          	add	a4,a4,s5
80000770:	010c9793          	slli	a5,s9,0x10
80000774:	00010e37          	lui	t3,0x10
80000778:	00c7e7b3          	or	a5,a5,a2
8000077c:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000780:	0107f333          	and	t1,a5,a6
80000784:	0109f833          	and	a6,s3,a6
80000788:	40a70733          	sub	a4,a4,a0
8000078c:	0107de93          	srli	t4,a5,0x10
80000790:	0109d993          	srli	s3,s3,0x10
80000794:	00030513          	mv	a0,t1
80000798:	00080593          	mv	a1,a6
8000079c:	090000ef          	jal	ra,8000082c <__mulsi3>
800007a0:	00050893          	mv	a7,a0
800007a4:	00098593          	mv	a1,s3
800007a8:	00030513          	mv	a0,t1
800007ac:	080000ef          	jal	ra,8000082c <__mulsi3>
800007b0:	00050313          	mv	t1,a0
800007b4:	00080593          	mv	a1,a6
800007b8:	000e8513          	mv	a0,t4
800007bc:	070000ef          	jal	ra,8000082c <__mulsi3>
800007c0:	00050813          	mv	a6,a0
800007c4:	00098593          	mv	a1,s3
800007c8:	000e8513          	mv	a0,t4
800007cc:	060000ef          	jal	ra,8000082c <__mulsi3>
800007d0:	0108d693          	srli	a3,a7,0x10
800007d4:	01030333          	add	t1,t1,a6
800007d8:	006686b3          	add	a3,a3,t1
800007dc:	0106f463          	bgeu	a3,a6,800007e4 <__udivdi3+0x58c>
800007e0:	01c50533          	add	a0,a0,t3
800007e4:	0106d613          	srli	a2,a3,0x10
800007e8:	00a60533          	add	a0,a2,a0
800007ec:	02a76663          	bltu	a4,a0,80000818 <__udivdi3+0x5c0>
800007f0:	bca714e3          	bne	a4,a0,800003b8 <__udivdi3+0x160>
800007f4:	00010737          	lui	a4,0x10
800007f8:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007fc:	00e6f6b3          	and	a3,a3,a4
80000800:	01069693          	slli	a3,a3,0x10
80000804:	00e8f8b3          	and	a7,a7,a4
80000808:	014b1633          	sll	a2,s6,s4
8000080c:	011686b3          	add	a3,a3,a7
80000810:	00000a13          	li	s4,0
80000814:	ccd67ce3          	bgeu	a2,a3,800004ec <__udivdi3+0x294>
80000818:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
8000081c:	b9dff06f          	j	800003b8 <__udivdi3+0x160>
80000820:	00000a13          	li	s4,0
80000824:	00000793          	li	a5,0
80000828:	cc5ff06f          	j	800004ec <__udivdi3+0x294>

8000082c <__mulsi3>:
8000082c:	00050613          	mv	a2,a0
80000830:	00000513          	li	a0,0
80000834:	0015f693          	andi	a3,a1,1
80000838:	00068463          	beqz	a3,80000840 <__mulsi3+0x14>
8000083c:	00c50533          	add	a0,a0,a2
80000840:	0015d593          	srli	a1,a1,0x1
80000844:	00161613          	slli	a2,a2,0x1
80000848:	fe0596e3          	bnez	a1,80000834 <__mulsi3+0x8>
8000084c:	00008067          	ret

80000850 <__muldi3>:
80000850:	ff010113          	addi	sp,sp,-16
80000854:	00068313          	mv	t1,a3
80000858:	00112623          	sw	ra,12(sp)
8000085c:	00050e13          	mv	t3,a0
80000860:	00050893          	mv	a7,a0
80000864:	00060693          	mv	a3,a2
80000868:	00000713          	li	a4,0
8000086c:	00000793          	li	a5,0
80000870:	00000813          	li	a6,0
80000874:	0016f513          	andi	a0,a3,1
80000878:	00171e93          	slli	t4,a4,0x1
8000087c:	00050c63          	beqz	a0,80000894 <__muldi3+0x44>
80000880:	01088533          	add	a0,a7,a6
80000884:	01053833          	sltu	a6,a0,a6
80000888:	00e787b3          	add	a5,a5,a4
8000088c:	00f807b3          	add	a5,a6,a5
80000890:	00050813          	mv	a6,a0
80000894:	01f8d713          	srli	a4,a7,0x1f
80000898:	0016d693          	srli	a3,a3,0x1
8000089c:	00eee733          	or	a4,t4,a4
800008a0:	00189893          	slli	a7,a7,0x1
800008a4:	fc0698e3          	bnez	a3,80000874 <__muldi3+0x24>
800008a8:	00058863          	beqz	a1,800008b8 <__muldi3+0x68>
800008ac:	00060513          	mv	a0,a2
800008b0:	f7dff0ef          	jal	ra,8000082c <__mulsi3>
800008b4:	00a787b3          	add	a5,a5,a0
800008b8:	00030a63          	beqz	t1,800008cc <__muldi3+0x7c>
800008bc:	000e0513          	mv	a0,t3
800008c0:	00030593          	mv	a1,t1
800008c4:	f69ff0ef          	jal	ra,8000082c <__mulsi3>
800008c8:	00f507b3          	add	a5,a0,a5
800008cc:	00c12083          	lw	ra,12(sp)
800008d0:	00080513          	mv	a0,a6
800008d4:	00078593          	mv	a1,a5
800008d8:	01010113          	addi	sp,sp,16
800008dc:	00008067          	ret

800008e0 <__divsi3>:
800008e0:	06054063          	bltz	a0,80000940 <__umodsi3+0x10>
800008e4:	0605c663          	bltz	a1,80000950 <__umodsi3+0x20>

800008e8 <__udivsi3>:
800008e8:	00058613          	mv	a2,a1
800008ec:	00050593          	mv	a1,a0
800008f0:	fff00513          	li	a0,-1
800008f4:	02060c63          	beqz	a2,8000092c <__udivsi3+0x44>
800008f8:	00100693          	li	a3,1
800008fc:	00b67a63          	bgeu	a2,a1,80000910 <__udivsi3+0x28>
80000900:	00c05863          	blez	a2,80000910 <__udivsi3+0x28>
80000904:	00161613          	slli	a2,a2,0x1
80000908:	00169693          	slli	a3,a3,0x1
8000090c:	feb66ae3          	bltu	a2,a1,80000900 <__udivsi3+0x18>
80000910:	00000513          	li	a0,0
80000914:	00c5e663          	bltu	a1,a2,80000920 <__udivsi3+0x38>
80000918:	40c585b3          	sub	a1,a1,a2
8000091c:	00d56533          	or	a0,a0,a3
80000920:	0016d693          	srli	a3,a3,0x1
80000924:	00165613          	srli	a2,a2,0x1
80000928:	fe0696e3          	bnez	a3,80000914 <__udivsi3+0x2c>
8000092c:	00008067          	ret

80000930 <__umodsi3>:
80000930:	00008293          	mv	t0,ra
80000934:	fb5ff0ef          	jal	ra,800008e8 <__udivsi3>
80000938:	00058513          	mv	a0,a1
8000093c:	00028067          	jr	t0
80000940:	40a00533          	neg	a0,a0
80000944:	0005d863          	bgez	a1,80000954 <__umodsi3+0x24>
80000948:	40b005b3          	neg	a1,a1
8000094c:	f9dff06f          	j	800008e8 <__udivsi3>
80000950:	40b005b3          	neg	a1,a1
80000954:	00008293          	mv	t0,ra
80000958:	f91ff0ef          	jal	ra,800008e8 <__udivsi3>
8000095c:	40a00533          	neg	a0,a0
80000960:	00028067          	jr	t0

80000964 <__modsi3>:
80000964:	00008293          	mv	t0,ra
80000968:	0005ca63          	bltz	a1,8000097c <__modsi3+0x18>
8000096c:	00054c63          	bltz	a0,80000984 <__modsi3+0x20>
80000970:	f79ff0ef          	jal	ra,800008e8 <__udivsi3>
80000974:	00058513          	mv	a0,a1
80000978:	00028067          	jr	t0
8000097c:	40b005b3          	neg	a1,a1
80000980:	fe0558e3          	bgez	a0,80000970 <__modsi3+0xc>
80000984:	40a00533          	neg	a0,a0
80000988:	f61ff0ef          	jal	ra,800008e8 <__udivsi3>
8000098c:	40b00533          	neg	a0,a1
80000990:	00028067          	jr	t0

80000994 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80000994:	00005117          	auipc	sp,0x5
80000998:	5cc10113          	addi	sp,sp,1484 # 80005f60 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
8000099c:	000012b7          	lui	t0,0x1
800009a0:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
800009a4:	9116                	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
800009a6:	2361                	jal	80000f2e <_PrepC>

800009a8 <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
800009a8:	7760006f          	j	8000111e <z_thread_entry>
	...

800009ae <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009ae:	8082                	ret

800009b0 <irq_offload_isr>:

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)

K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
800009b0:	12b0206f          	j	800032da <z_impl_k_wakeup>

800009b4 <align_to_tick_boundary>:

	TC_PRINT("Kernel objects initialized\n");
}

static void align_to_tick_boundary(void)
{
800009b4:	1141                	addi	sp,sp,-16
800009b6:	c422                	sw	s0,8(sp)
800009b8:	c606                	sw	ra,12(sp)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)

K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
800009ba:	7b8030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
800009be:	842a                	mv	s0,a0
800009c0:	7b2030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	u32_t tick;

	tick = k_uptime_get_32();
	while (k_uptime_get_32() == tick) {
800009c4:	fea40ee3          	beq	s0,a0,800009c0 <align_to_tick_boundary+0xc>
#if defined(CONFIG_ARCH_POSIX)
		k_busy_wait(50);
#endif
	}

}
800009c8:	40b2                	lw	ra,12(sp)
800009ca:	4422                	lw	s0,8(sp)
800009cc:	0141                	addi	sp,sp,16
800009ce:	8082                	ret

800009d0 <z_zassert.constprop.2>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
800009d0:	7179                	addi	sp,sp,-48
800009d2:	ce06                	sw	ra,28(sp)
800009d4:	cc22                	sw	s0,24(sp)
800009d6:	d442                	sw	a6,40(sp)
800009d8:	d646                	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
800009da:	e121                	bnez	a0,80000a1a <z_zassert.constprop.2+0x4a>
800009dc:	8636                	mv	a2,a3
800009de:	872e                	mv	a4,a1
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009e0:	800046b7          	lui	a3,0x80004
800009e4:	800045b7          	lui	a1,0x80004
800009e8:	80004537          	lui	a0,0x80004
800009ec:	46068693          	addi	a3,a3,1120 # 80004460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004461>
800009f0:	843e                	mv	s0,a5
800009f2:	70458593          	addi	a1,a1,1796 # 80004704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004705>
		va_start(vargs, msg);
800009f6:	103c                	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009f8:	72450513          	addi	a0,a0,1828 # 80004724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004725>
		va_start(vargs, msg);
800009fc:	c63e                	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
800009fe:	36d000ef          	jal	ra,8000156a <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000a02:	45b2                	lw	a1,12(sp)
80000a04:	8522                	mv	a0,s0
80000a06:	349000ef          	jal	ra,8000154e <vprintk>
		printk("\n");
80000a0a:	80004537          	lui	a0,0x80004
80000a0e:	51c50513          	addi	a0,a0,1308 # 8000451c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000451d>
80000a12:	359000ef          	jal	ra,8000156a <printk>
		va_end(vargs);
		ztest_test_fail();
80000a16:	070010ef          	jal	ra,80001a86 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000a1a:	40f2                	lw	ra,28(sp)
80000a1c:	4462                	lw	s0,24(sp)
80000a1e:	6145                	addi	sp,sp,48
80000a20:	8082                	ret

80000a22 <helper_thread>:

	k_wakeup((k_tid_t) arg);
}

static void helper_thread(int arg1, int arg2)
{
80000a22:	1141                	addi	sp,sp,-16
80000a24:	c226                	sw	s1,4(sp)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_MUTEX_UNLOCK, k_mutex_unlock, struct k_mutex *, mutex)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000a26:	800054b7          	lui	s1,0x80005
80000a2a:	c422                	sw	s0,8(sp)
80000a2c:	55fd                	li	a1,-1
80000a2e:	22c48513          	addi	a0,s1,556 # 8000522c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000522d>

	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread */
	k_wakeup(test_thread_id);
80000a32:	80005437          	lui	s0,0x80005
{
80000a36:	c606                	sw	ra,12(sp)
	k_wakeup(test_thread_id);
80000a38:	18040413          	addi	s0,s0,384 # 80005180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005181>
80000a3c:	243020ef          	jal	ra,8000347e <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000a40:	4008                	lw	a0,0(s0)
80000a42:	099020ef          	jal	ra,800032da <z_impl_k_wakeup>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000a46:	55fd                	li	a1,-1
80000a48:	22c48513          	addi	a0,s1,556
80000a4c:	233020ef          	jal	ra,8000347e <z_impl_k_sem_take>
	k_sem_take(&helper_thread_sem, K_FOREVER);
	/* Wake the test thread from an ISR */
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000a50:	400c                	lw	a1,0(s0)
}
80000a52:	4422                	lw	s0,8(sp)
80000a54:	40b2                	lw	ra,12(sp)
80000a56:	4492                	lw	s1,4(sp)
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000a58:	80001537          	lui	a0,0x80001
80000a5c:	9b050513          	addi	a0,a0,-1616 # 800009b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009b1>
}
80000a60:	0141                	addi	sp,sp,16
	irq_offload(irq_offload_isr, (void *)test_thread_id);
80000a62:	a16d                	j	80000f0c <irq_offload>

80000a64 <test_sleep>:
 * @ingroup kernel_sleep_tests
 *
 * @see k_sleep(), k_wakeup(), k_uptime_get_32()
 */
void test_sleep(void)
{
80000a64:	1101                	addi	sp,sp,-32
80000a66:	ce06                	sw	ra,28(sp)
80000a68:	cc22                	sw	s0,24(sp)
80000a6a:	ca26                	sw	s1,20(sp)
80000a6c:	c84a                	sw	s2,16(sp)
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000a6e:	0bd020ef          	jal	ra,8000332a <z_impl_k_current_get>
K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_PRIORITY_SET, k_thread_priority_set, k_tid_t, thread, int, prio)
80000a72:	4581                	li	a1,0
80000a74:	434020ef          	jal	ra,80002ea8 <z_impl_k_thread_priority_set>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80000a78:	80005937          	lui	s2,0x80005
80000a7c:	2bc90513          	addi	a0,s2,700 # 800052bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052bd>
80000a80:	567d                	li	a2,-1
80000a82:	4581                	li	a1,0
80000a84:	0b1020ef          	jal	ra,80003334 <z_impl_k_sem_init>
80000a88:	80005537          	lui	a0,0x80005
80000a8c:	567d                	li	a2,-1
80000a8e:	4581                	li	a1,0
80000a90:	22c50513          	addi	a0,a0,556 # 8000522c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000522d>
80000a94:	0a1020ef          	jal	ra,80003334 <z_impl_k_sem_init>
80000a98:	800054b7          	lui	s1,0x80005
80000a9c:	567d                	li	a2,-1
80000a9e:	4581                	li	a1,0
80000aa0:	23c48513          	addi	a0,s1,572 # 8000523c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000523d>
80000aa4:	091020ef          	jal	ra,80003334 <z_impl_k_sem_init>
	TC_PRINT("Kernel objects initialized\n");
80000aa8:	80004537          	lui	a0,0x80004
80000aac:	48050513          	addi	a0,a0,1152 # 80004480 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004481>
80000ab0:	2bb000ef          	jal	ra,8000156a <printk>
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80000ab4:	800016b7          	lui	a3,0x80001
80000ab8:	800055b7          	lui	a1,0x80005
80000abc:	80005537          	lui	a0,0x80005
80000ac0:	58f1                	li	a7,-4
80000ac2:	4801                	li	a6,0
80000ac4:	4781                	li	a5,0
80000ac6:	4701                	li	a4,0
80000ac8:	bd468693          	addi	a3,a3,-1068 # 80000bd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000bd5>
80000acc:	18000613          	li	a2,384
80000ad0:	c202                	sw	zero,4(sp)
80000ad2:	c002                	sw	zero,0(sp)
80000ad4:	46058593          	addi	a1,a1,1120 # 80005460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005461>
80000ad8:	24c50513          	addi	a0,a0,588 # 8000524c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000524d>
	 * threads run at same priority level.
	 */
	k_thread_priority_set(k_current_get(), 0);
	test_objects_init();

	test_thread_id = k_thread_create(&test_thread_data, test_thread_stack,
80000adc:	80005437          	lui	s0,0x80005
80000ae0:	537020ef          	jal	ra,80003816 <z_impl_k_thread_create>
80000ae4:	18040413          	addi	s0,s0,384 # 80005180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005181>
80000ae8:	85aa                	mv	a1,a0
80000aea:	c008                	sw	a0,0(s0)
					 THREAD_STACK,
					 (k_thread_entry_t) test_thread,
					 0, 0, NULL, TEST_THREAD_PRIORITY,
					 0, 0);

	TC_PRINT("Test thread started: id = %p\n", test_thread_id);
80000aec:	80004537          	lui	a0,0x80004
80000af0:	49c50513          	addi	a0,a0,1180 # 8000449c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000449d>
80000af4:	277000ef          	jal	ra,8000156a <printk>
80000af8:	800016b7          	lui	a3,0x80001
80000afc:	800055b7          	lui	a1,0x80005
80000b00:	80005537          	lui	a0,0x80005
80000b04:	58d9                	li	a7,-10
80000b06:	4801                	li	a6,0
80000b08:	4781                	li	a5,0
80000b0a:	4701                	li	a4,0
80000b0c:	a2268693          	addi	a3,a3,-1502 # 80000a22 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a23>
80000b10:	18000613          	li	a2,384
80000b14:	c202                	sw	zero,4(sp)
80000b16:	c002                	sw	zero,0(sp)
80000b18:	5e058593          	addi	a1,a1,1504 # 800055e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800055e1>
80000b1c:	1bc50513          	addi	a0,a0,444 # 800051bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051bd>
80000b20:	4f7020ef          	jal	ra,80003816 <z_impl_k_thread_create>
					   helper_thread_stack, THREAD_STACK,
					   (k_thread_entry_t) helper_thread,
					   0, 0, NULL, HELPER_THREAD_PRIORITY,
					   0, 0);

	TC_PRINT("Helper thread started: id = %p\n", helper_thread_id);
80000b24:	85aa                	mv	a1,a0
80000b26:	80004537          	lui	a0,0x80004
80000b2a:	4bc50513          	addi	a0,a0,1212 # 800044bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044bd>
80000b2e:	23d000ef          	jal	ra,8000156a <printk>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000b32:	2bc90513          	addi	a0,s2,700
80000b36:	09f020ef          	jal	ra,800033d4 <z_impl_k_sem_give>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000b3a:	55fd                	li	a1,-1
80000b3c:	23c48513          	addi	a0,s1,572
80000b40:	13f020ef          	jal	ra,8000347e <z_impl_k_sem_take>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_WAKEUP, k_wakeup, k_tid_t, thread)
80000b44:	4008                	lw	a0,0(s0)
	k_sem_take(&task_sem, K_FOREVER);

	/* Wake the test thread */
	k_wakeup(test_thread_id);

	zassert_false(test_failure, "test failure");
80000b46:	80004937          	lui	s2,0x80004
80000b4a:	800044b7          	lui	s1,0x80004
80000b4e:	78c020ef          	jal	ra,800032da <z_impl_k_wakeup>
80000b52:	800057b7          	lui	a5,0x80005
80000b56:	1207c503          	lbu	a0,288(a5) # 80005120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005121>
80000b5a:	800045b7          	lui	a1,0x80004
80000b5e:	800047b7          	lui	a5,0x80004
80000b62:	46090713          	addi	a4,s2,1120 # 80004460 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004461>
80000b66:	70448613          	addi	a2,s1,1796 # 80004704 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004705>
80000b6a:	4dc78793          	addi	a5,a5,1244 # 800044dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044dd>
80000b6e:	0de00693          	li	a3,222
80000b72:	4ec58593          	addi	a1,a1,1260 # 800044ec <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800044ed>
80000b76:	00154513          	xori	a0,a0,1
80000b7a:	3d99                	jal	800009d0 <z_zassert.constprop.2>

	TC_PRINT("Testing kernel k_sleep()\n");
80000b7c:	80004537          	lui	a0,0x80004
80000b80:	50450513          	addi	a0,a0,1284 # 80004504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004505>
80000b84:	1e7000ef          	jal	ra,8000156a <printk>
	align_to_tick_boundary();
80000b88:	3535                	jal	800009b4 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000b8a:	5e8030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
80000b8e:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000b90:	3e800513          	li	a0,1000
80000b94:	560020ef          	jal	ra,800030f4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000b98:	5da030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
80000b9c:	40850833          	sub	a6,a0,s0
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
		     "k_sleep() slept for %d ticks, not %d\n",
		     end_tick - start_tick, ONE_SECOND_ALIGNED);

	status = TC_PASS;
}
80000ba0:	4462                	lw	s0,24(sp)
80000ba2:	40f2                	lw	ra,28(sp)
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000ba4:	46090713          	addi	a4,s2,1120
80000ba8:	70448613          	addi	a2,s1,1796
}
80000bac:	4942                	lw	s2,16(sp)
80000bae:	44d2                	lw	s1,20(sp)
	return dt >= dur && dt <= (dur + 1);
80000bb0:	c0e80513          	addi	a0,a6,-1010
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000bb4:	800047b7          	lui	a5,0x80004
80000bb8:	800045b7          	lui	a1,0x80004
80000bbc:	3f200893          	li	a7,1010
80000bc0:	52078793          	addi	a5,a5,1312 # 80004520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004521>
80000bc4:	0e700693          	li	a3,231
80000bc8:	54858593          	addi	a1,a1,1352 # 80004548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004549>
80000bcc:	00253513          	sltiu	a0,a0,2
}
80000bd0:	6105                	addi	sp,sp,32
	zassert_true(sleep_time_valid(start_tick, end_tick, ONE_SECOND_ALIGNED),
80000bd2:	bbfd                	j	800009d0 <z_zassert.constprop.2>

80000bd4 <test_thread>:
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80000bd4:	80005537          	lui	a0,0x80005
{
80000bd8:	1141                	addi	sp,sp,-16
80000bda:	55fd                	li	a1,-1
80000bdc:	2bc50513          	addi	a0,a0,700 # 800052bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052bd>
80000be0:	c606                	sw	ra,12(sp)
80000be2:	c422                	sw	s0,8(sp)
80000be4:	c226                	sw	s1,4(sp)
80000be6:	c04a                	sw	s2,0(sp)
80000be8:	097020ef          	jal	ra,8000347e <z_impl_k_sem_take>
	TC_PRINT("Testing normal expiration of k_sleep()\n");
80000bec:	80004537          	lui	a0,0x80004
80000bf0:	59050513          	addi	a0,a0,1424 # 80004590 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004591>
80000bf4:	177000ef          	jal	ra,8000156a <printk>
	align_to_tick_boundary();
80000bf8:	3b75                	jal	800009b4 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000bfa:	578030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
80000bfe:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000c00:	3e800513          	li	a0,1000
80000c04:	4f0020ef          	jal	ra,800030f4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000c08:	56a030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	u32_t dt = end - start;
80000c0c:	40850433          	sub	s0,a0,s0
	return dt >= dur && dt <= (dur + 1);
80000c10:	c0e40793          	addi	a5,s0,-1010
80000c14:	4485                	li	s1,1
80000c16:	06f4e863          	bltu	s1,a5,80000c86 <test_thread+0xb2>
	TC_PRINT("Testing: test thread sleep + helper thread wakeup test\n");
80000c1a:	80004537          	lui	a0,0x80004
80000c1e:	5b850513          	addi	a0,a0,1464 # 800045b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045b9>
80000c22:	149000ef          	jal	ra,8000156a <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000c26:	80005937          	lui	s2,0x80005
80000c2a:	22c90513          	addi	a0,s2,556 # 8000522c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000522d>
80000c2e:	7a6020ef          	jal	ra,800033d4 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000c32:	3349                	jal	800009b4 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000c34:	53e030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
80000c38:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000c3a:	3e800513          	li	a0,1000
80000c3e:	4b6020ef          	jal	ra,800030f4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000c42:	530030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000c46:	40850433          	sub	s0,a0,s0
80000c4a:	0684fc63          	bgeu	s1,s0,80000cc2 <test_thread+0xee>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000c4e:	07d00693          	li	a3,125
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000c52:	80004637          	lui	a2,0x80004
80000c56:	800045b7          	lui	a1,0x80004
80000c5a:	80004537          	lui	a0,0x80004
80000c5e:	5f058593          	addi	a1,a1,1520 # 800045f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f1>
80000c62:	5f850513          	addi	a0,a0,1528 # 800045f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f9>
80000c66:	45460613          	addi	a2,a2,1108 # 80004454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004455>
80000c6a:	101000ef          	jal	ra,8000156a <printk>
80000c6e:	80004537          	lui	a0,0x80004
80000c72:	85a2                	mv	a1,s0
80000c74:	63450513          	addi	a0,a0,1588 # 80004634 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004635>
}
80000c78:	4422                	lw	s0,8(sp)
80000c7a:	40b2                	lw	ra,12(sp)
80000c7c:	4492                	lw	s1,4(sp)
80000c7e:	4902                	lw	s2,0(sp)
80000c80:	0141                	addi	sp,sp,16
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000c82:	0e90006f          	j	8000156a <printk>
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000c86:	80004637          	lui	a2,0x80004
80000c8a:	800045b7          	lui	a1,0x80004
80000c8e:	80004537          	lui	a0,0x80004
80000c92:	45460613          	addi	a2,a2,1108 # 80004454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004455>
80000c96:	5f058593          	addi	a1,a1,1520 # 800045f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f1>
80000c9a:	5f850513          	addi	a0,a0,1528 # 800045f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f9>
80000c9e:	06e00693          	li	a3,110
80000ca2:	0c9000ef          	jal	ra,8000156a <printk>
80000ca6:	85a2                	mv	a1,s0
}
80000ca8:	4422                	lw	s0,8(sp)
80000caa:	40b2                	lw	ra,12(sp)
80000cac:	4492                	lw	s1,4(sp)
80000cae:	4902                	lw	s2,0(sp)
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000cb0:	80004537          	lui	a0,0x80004
80000cb4:	3f200613          	li	a2,1010
80000cb8:	60850513          	addi	a0,a0,1544 # 80004608 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004609>
}
80000cbc:	0141                	addi	sp,sp,16
		TC_ERROR(" *** k_sleep() slept for %d ticks not %d.",
80000cbe:	0ad0006f          	j	8000156a <printk>
	TC_PRINT("Testing: test thread sleep + isr offload wakeup test\n");
80000cc2:	80004537          	lui	a0,0x80004
80000cc6:	66050513          	addi	a0,a0,1632 # 80004660 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004661>
80000cca:	0a1000ef          	jal	ra,8000156a <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000cce:	22c90513          	addi	a0,s2,556
80000cd2:	702020ef          	jal	ra,800033d4 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000cd6:	39f9                	jal	800009b4 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000cd8:	49a030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
80000cdc:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000cde:	3e800513          	li	a0,1000
80000ce2:	412020ef          	jal	ra,800030f4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000ce6:	48c030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000cea:	40850433          	sub	s0,a0,s0
80000cee:	0084f563          	bgeu	s1,s0,80000cf8 <test_thread+0x124>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks)\n",
80000cf2:	08b00693          	li	a3,139
80000cf6:	bfb1                	j	80000c52 <test_thread+0x7e>
	TC_PRINT("Testing: test thread sleep + main wakeup test thread\n");
80000cf8:	80004537          	lui	a0,0x80004
80000cfc:	69850513          	addi	a0,a0,1688 # 80004698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004699>
80000d00:	06b000ef          	jal	ra,8000156a <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80000d04:	80005537          	lui	a0,0x80005
80000d08:	23c50513          	addi	a0,a0,572 # 8000523c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000523d>
80000d0c:	6c8020ef          	jal	ra,800033d4 <z_impl_k_sem_give>
	align_to_tick_boundary();
80000d10:	3155                	jal	800009b4 <align_to_tick_boundary>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000d12:	460030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
80000d16:	842a                	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000d18:	3e800513          	li	a0,1000
80000d1c:	3d8020ef          	jal	ra,800030f4 <z_impl_k_sleep>
K_SYSCALL_DECLARE0(K_SYSCALL_K_UPTIME_GET_32, k_uptime_get_32, u32_t)
80000d20:	452030ef          	jal	ra,80004172 <z_impl_k_uptime_get_32>
	if (end_tick - start_tick > 1) {
80000d24:	40850433          	sub	s0,a0,s0
80000d28:	0284f863          	bgeu	s1,s0,80000d58 <test_thread+0x184>
		TC_ERROR(" *** k_wakeup() took too long (%d ticks) at LAST\n",
80000d2c:	80004637          	lui	a2,0x80004
80000d30:	800045b7          	lui	a1,0x80004
80000d34:	80004537          	lui	a0,0x80004
80000d38:	5f058593          	addi	a1,a1,1520 # 800045f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f1>
80000d3c:	5f850513          	addi	a0,a0,1528 # 800045f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800045f9>
80000d40:	09900693          	li	a3,153
80000d44:	45460613          	addi	a2,a2,1108 # 80004454 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004455>
80000d48:	023000ef          	jal	ra,8000156a <printk>
80000d4c:	80004537          	lui	a0,0x80004
80000d50:	85a2                	mv	a1,s0
80000d52:	6d050513          	addi	a0,a0,1744 # 800046d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800046d1>
80000d56:	b70d                	j	80000c78 <test_thread+0xa4>
}
80000d58:	40b2                	lw	ra,12(sp)
80000d5a:	4422                	lw	s0,8(sp)
	test_failure = false;
80000d5c:	800057b7          	lui	a5,0x80005
80000d60:	12078023          	sb	zero,288(a5) # 80005120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005121>
}
80000d64:	4492                	lw	s1,4(sp)
80000d66:	4902                	lw	s2,0(sp)
80000d68:	0141                	addi	sp,sp,16
80000d6a:	8082                	ret

80000d6c <test_main>:
/*test case main entry*/
void test_main(void)
{
	ztest_test_suite(sleep,
			 ztest_unit_test(test_sleep));
	ztest_run_test_suite(sleep);
80000d6c:	800055b7          	lui	a1,0x80005
80000d70:	80004537          	lui	a0,0x80004
80000d74:	0e458593          	addi	a1,a1,228 # 800050e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050e5>
80000d78:	47850513          	addi	a0,a0,1144 # 80004478 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004479>
80000d7c:	5310006f          	j	80001aac <z_ztest_run_test_suite>

80000d80 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80000d80:	1141                	addi	sp,sp,-16
80000d82:	c606                	sw	ra,12(sp)
80000d84:	c422                	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80000d86:	4799                	li	a5,6
80000d88:	02f50263          	beq	a0,a5,80000dac <z_SysFatalErrorHandler+0x2c>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80000d8c:	079020ef          	jal	ra,80003604 <k_is_in_isr>
80000d90:	c10d                	beqz	a0,80000db2 <z_SysFatalErrorHandler+0x32>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80000d92:	073020ef          	jal	ra,80003604 <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80000d96:	e121                	bnez	a0,80000dd6 <z_SysFatalErrorHandler+0x56>
80000d98:	800055b7          	lui	a1,0x80005
80000d9c:	9fc58593          	addi	a1,a1,-1540 # 800049fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800049fd>
80000da0:	80005537          	lui	a0,0x80005
80000da4:	a1050513          	addi	a0,a0,-1520 # 80004a10 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a11>
80000da8:	7c2000ef          	jal	ra,8000156a <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80000dac:	005000ef          	jal	ra,800015b0 <k_cpu_idle>
80000db0:	bff5                	j	80000dac <z_SysFatalErrorHandler+0x2c>
	if (k_is_in_isr() || z_is_thread_essential()) {
80000db2:	061020ef          	jal	ra,80003612 <z_is_thread_essential>
80000db6:	fd71                	bnez	a0,80000d92 <z_SysFatalErrorHandler+0x12>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80000db8:	80005437          	lui	s0,0x80005
80000dbc:	42c40413          	addi	s0,s0,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80000dc0:	440c                	lw	a1,8(s0)
80000dc2:	80005537          	lui	a0,0x80005
80000dc6:	a3050513          	addi	a0,a0,-1488 # 80004a30 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a31>
80000dca:	7a0000ef          	jal	ra,8000156a <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80000dce:	4408                	lw	a0,8(s0)
80000dd0:	35f020ef          	jal	ra,8000392e <z_impl_k_thread_abort>
80000dd4:	bfe1                	j	80000dac <z_SysFatalErrorHandler+0x2c>
		printk("Fatal fault in %s! Spinning...\n",
80000dd6:	800055b7          	lui	a1,0x80005
80000dda:	9f858593          	addi	a1,a1,-1544 # 800049f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800049f9>
80000dde:	b7c9                	j	80000da0 <z_SysFatalErrorHandler+0x20>

80000de0 <z_NanoFatalErrorHandler>:
{
80000de0:	715d                	addi	sp,sp,-80
80000de2:	c4a2                	sw	s0,72(sp)
80000de4:	c2a6                	sw	s1,68(sp)
80000de6:	c686                	sw	ra,76(sp)
	switch (reason) {
80000de8:	4799                	li	a5,6
{
80000dea:	84aa                	mv	s1,a0
80000dec:	842e                	mv	s0,a1
	switch (reason) {
80000dee:	08a7e763          	bltu	a5,a0,80000e7c <z_NanoFatalErrorHandler+0x9c>
80000df2:	80004737          	lui	a4,0x80004
80000df6:	00251793          	slli	a5,a0,0x2
80000dfa:	74c70713          	addi	a4,a4,1868 # 8000474c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000474d>
80000dfe:	97ba                	add	a5,a5,a4
80000e00:	439c                	lw	a5,0(a5)
80000e02:	8782                	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80000e04:	80005537          	lui	a0,0x80005
80000e08:	87c50513          	addi	a0,a0,-1924 # 8000487c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000487d>
		printk("***** Kernel OOPS! *****\n");
80000e0c:	2fb9                	jal	8000156a <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80000e0e:	51c020ef          	jal	ra,8000332a <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80000e12:	407c                	lw	a5,68(s0)
80000e14:	01042883          	lw	a7,16(s0)
80000e18:	00c42803          	lw	a6,12(s0)
80000e1c:	d83e                	sw	a5,48(sp)
80000e1e:	403c                	lw	a5,64(s0)
80000e20:	4058                	lw	a4,4(s0)
80000e22:	4014                	lw	a3,0(s0)
80000e24:	d63e                	sw	a5,44(sp)
80000e26:	5c5c                	lw	a5,60(s0)
80000e28:	4430                	lw	a2,72(s0)
80000e2a:	85aa                	mv	a1,a0
80000e2c:	d43e                	sw	a5,40(sp)
80000e2e:	5c1c                	lw	a5,56(s0)
80000e30:	80005537          	lui	a0,0x80005
80000e34:	90050513          	addi	a0,a0,-1792 # 80004900 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004901>
80000e38:	d23e                	sw	a5,36(sp)
80000e3a:	585c                	lw	a5,52(s0)
80000e3c:	d03e                	sw	a5,32(sp)
80000e3e:	581c                	lw	a5,48(s0)
80000e40:	ce3e                	sw	a5,28(sp)
80000e42:	545c                	lw	a5,44(s0)
80000e44:	cc3e                	sw	a5,24(sp)
80000e46:	541c                	lw	a5,40(s0)
80000e48:	ca3e                	sw	a5,20(sp)
80000e4a:	505c                	lw	a5,36(s0)
80000e4c:	c83e                	sw	a5,16(sp)
80000e4e:	501c                	lw	a5,32(s0)
80000e50:	c63e                	sw	a5,12(sp)
80000e52:	4c5c                	lw	a5,28(s0)
80000e54:	c43e                	sw	a5,8(sp)
80000e56:	4c1c                	lw	a5,24(s0)
80000e58:	c23e                	sw	a5,4(sp)
80000e5a:	485c                	lw	a5,20(s0)
80000e5c:	c03e                	sw	a5,0(sp)
80000e5e:	441c                	lw	a5,8(s0)
80000e60:	2729                	jal	8000156a <printk>
	z_SysFatalErrorHandler(reason, esf);
80000e62:	85a2                	mv	a1,s0
80000e64:	8526                	mv	a0,s1
80000e66:	3f29                	jal	80000d80 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80000e68:	80005537          	lui	a0,0x80005
80000e6c:	8a450513          	addi	a0,a0,-1884 # 800048a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048a5>
80000e70:	bf71                	j	80000e0c <z_NanoFatalErrorHandler+0x2c>
		printk("***** Kernel Panic! *****\n");
80000e72:	80005537          	lui	a0,0x80005
80000e76:	8c050513          	addi	a0,a0,-1856 # 800048c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048c1>
80000e7a:	bf49                	j	80000e0c <z_NanoFatalErrorHandler+0x2c>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80000e7c:	80005537          	lui	a0,0x80005
80000e80:	85a6                	mv	a1,s1
80000e82:	8dc50513          	addi	a0,a0,-1828 # 800048dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800048dd>
80000e86:	25d5                	jal	8000156a <printk>
		break;
80000e88:	b759                	j	80000e0e <z_NanoFatalErrorHandler+0x2e>

80000e8a <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80000e8a:	1141                	addi	sp,sp,-16
80000e8c:	c422                	sw	s0,8(sp)
80000e8e:	c606                	sw	ra,12(sp)
80000e90:	842a                	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000e92:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80000e96:	0606                	slli	a2,a2,0x1
80000e98:	8205                	srli	a2,a2,0x1
	switch (cause) {
80000e9a:	4795                	li	a5,5
80000e9c:	02c7e263          	bltu	a5,a2,80000ec0 <_Fault+0x36>
80000ea0:	80004737          	lui	a4,0x80004
80000ea4:	00261793          	slli	a5,a2,0x2
80000ea8:	76870713          	addi	a4,a4,1896 # 80004768 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004769>
80000eac:	97ba                	add	a5,a5,a4
80000eae:	438c                	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80000eb0:	80004537          	lui	a0,0x80004
80000eb4:	78850513          	addi	a0,a0,1928 # 80004788 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004789>
80000eb8:	2d4d                	jal	8000156a <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80000eba:	85a2                	mv	a1,s0
80000ebc:	4501                	li	a0,0
80000ebe:	370d                	jal	80000de0 <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ec0:	800045b7          	lui	a1,0x80004
80000ec4:	78058593          	addi	a1,a1,1920 # 80004780 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004781>
80000ec8:	b7e5                	j	80000eb0 <_Fault+0x26>

80000eca <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80000eca:	1141                	addi	sp,sp,-16
80000ecc:	c606                	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80000ece:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ed2:	80005537          	lui	a0,0x80005
	mcause &= SOC_MCAUSE_EXP_MASK;
80000ed6:	0586                	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80000ed8:	8185                	srli	a1,a1,0x1
80000eda:	a5850513          	addi	a0,a0,-1448 # 80004a58 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a59>
80000ede:	2571                	jal	8000156a <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80000ee0:	800045b7          	lui	a1,0x80004
80000ee4:	7a458593          	addi	a1,a1,1956 # 800047a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047a5>
80000ee8:	4511                	li	a0,4
80000eea:	3ddd                	jal	80000de0 <z_NanoFatalErrorHandler>

80000eec <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80000eec:	800057b7          	lui	a5,0x80005
80000ef0:	18478793          	addi	a5,a5,388 # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
80000ef4:	4398                	lw	a4,0(a5)
80000ef6:	cb11                	beqz	a4,80000f0a <z_irq_do_offload+0x1e>
		return;

	tmp = _offload_routine;
80000ef8:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80000efc:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80000f00:	800057b7          	lui	a5,0x80005
80000f04:	1887a503          	lw	a0,392(a5) # 80005188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005189>
80000f08:	8302                	jr	t1
}
80000f0a:	8082                	ret

80000f0c <irq_offload>:
 */
static ALWAYS_INLINE unsigned int z_arch_irq_lock(void)
{
	unsigned int key, mstatus;

	__asm__ volatile ("csrrc %0, mstatus, %1"
80000f0c:	47a1                	li	a5,8
80000f0e:	3007b7f3          	csrrc	a5,mstatus,a5
void irq_offload(irq_offload_routine_t routine, void *parameter)
{
	unsigned int key;

	key = irq_lock();
	_offload_routine = routine;
80000f12:	80005737          	lui	a4,0x80005
80000f16:	18a72223          	sw	a0,388(a4) # 80005184 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005185>
	offload_param = parameter;
80000f1a:	80005737          	lui	a4,0x80005
80000f1e:	18b72423          	sw	a1,392(a4) # 80005188 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005189>

	__asm__ volatile ("ecall");
80000f22:	00000073          	ecall
			  : "=r" (mstatus)
			  : "r" (SOC_MSTATUS_IEN)
			  : "memory");

	key = (mstatus & SOC_MSTATUS_IEN);
80000f26:	8ba1                	andi	a5,a5,8
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80000f28:	3007a7f3          	csrrs	a5,mstatus,a5

	irq_unlock(key);
}
80000f2c:	8082                	ret

80000f2e <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80000f2e:	1141                	addi	sp,sp,-16
80000f30:	c606                	sw	ra,12(sp)
	z_bss_zero();
80000f32:	609000ef          	jal	ra,80001d3a <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80000f36:	2d49                	jal	800015c8 <soc_interrupt_init>
#endif
	z_cstart();
80000f38:	655000ef          	jal	ra,80001d8c <z_cstart>

80000f3c <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80000f3c:	7179                	addi	sp,sp,-48
80000f3e:	d422                	sw	s0,40(sp)
80000f40:	d226                	sw	s1,36(sp)
80000f42:	d04a                	sw	s2,32(sp)
80000f44:	ce4e                	sw	s3,28(sp)
80000f46:	cc52                	sw	s4,24(sp)
80000f48:	ca56                	sw	s5,20(sp)
80000f4a:	c85a                	sw	s6,16(sp)
80000f4c:	c65e                	sw	s7,12(sp)
80000f4e:	8b3e                	mv	s6,a5
80000f50:	d606                	sw	ra,44(sp)
80000f52:	c462                	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f54:	47bd                	li	a5,15
{
80000f56:	84aa                	mv	s1,a0
80000f58:	842e                	mv	s0,a1
80000f5a:	89b2                	mv	s3,a2
80000f5c:	8a36                	mv	s4,a3
80000f5e:	8bba                	mv	s7,a4
80000f60:	8ac2                	mv	s5,a6
80000f62:	8946                	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000f64:	06f89463          	bne	a7,a5,80000fcc <z_new_thread+0x90>
80000f68:	800027b7          	lui	a5,0x80002
80000f6c:	d1478793          	addi	a5,a5,-748 # 80001d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001d15>
80000f70:	06f69363          	bne	a3,a5,80000fd6 <z_new_thread+0x9a>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80000f74:	56c2                	lw	a3,48(sp)
80000f76:	85ca                	mv	a1,s2
80000f78:	8526                	mv	a0,s1
80000f7a:	4611                	li	a2,4
80000f7c:	714020ef          	jal	ra,80003690 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80000f80:	fb098593          	addi	a1,s3,-80
80000f84:	95a2                	add	a1,a1,s0
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000f86:	6789                	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80000f88:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80000f8c:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80000f90:	99c1                	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80000f92:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80000f96:	c5fc                	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000f98:	800017b7          	lui	a5,0x80001

	thread->callee_saved.sp = (u32_t)stack_init;
}
80000f9c:	50b2                	lw	ra,44(sp)
80000f9e:	5422                	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000fa0:	9a878793          	addi	a5,a5,-1624 # 800009a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800009a9>
	stack_init->a0 = (u32_t)thread_func;
80000fa4:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80000fa8:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80000fac:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80000fb0:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80000fb4:	c5bc                	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80000fb6:	d48c                	sw	a1,40(s1)
}
80000fb8:	5902                	lw	s2,32(sp)
80000fba:	5492                	lw	s1,36(sp)
80000fbc:	49f2                	lw	s3,28(sp)
80000fbe:	4a62                	lw	s4,24(sp)
80000fc0:	4ad2                	lw	s5,20(sp)
80000fc2:	4b42                	lw	s6,16(sp)
80000fc4:	4bb2                	lw	s7,12(sp)
80000fc6:	4c22                	lw	s8,8(sp)
80000fc8:	6145                	addi	sp,sp,48
80000fca:	8082                	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80000fcc:	01088693          	addi	a3,a7,16
80000fd0:	47f9                	li	a5,30
80000fd2:	fad7f1e3          	bgeu	a5,a3,80000f74 <z_new_thread+0x38>
80000fd6:	80005c37          	lui	s8,0x80005
80000fda:	800055b7          	lui	a1,0x80005
80000fde:	80005537          	lui	a0,0x80005
80000fe2:	a80c0613          	addi	a2,s8,-1408 # 80004a80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004a81>
80000fe6:	46e1                	li	a3,24
80000fe8:	aa058593          	addi	a1,a1,-1376 # 80004aa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004aa1>
80000fec:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80000ff0:	2bad                	jal	8000156a <printk>
80000ff2:	80005537          	lui	a0,0x80005
80000ff6:	85ca                	mv	a1,s2
80000ff8:	56c1                	li	a3,-16
80000ffa:	4639                	li	a2,14
80000ffc:	b4c50513          	addi	a0,a0,-1204 # 80004b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b4d>
80001000:	23ad                	jal	8000156a <printk>
80001002:	45e1                	li	a1,24
80001004:	a80c0513          	addi	a0,s8,-1408
80001008:	2341                	jal	80001588 <assert_post_action>
8000100a:	b7ad                	j	80000f74 <z_new_thread+0x38>

8000100c <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
8000100c:	00159793          	slli	a5,a1,0x1
80001010:	97ae                	add	a5,a5,a1
80001012:	00279713          	slli	a4,a5,0x2
80001016:	455c                	lw	a5,12(a0)
80001018:	97ba                	add	a5,a5,a4
8000101a:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
8000101e:	00b75363          	bge	a4,a1,80001024 <get_bit_ptr+0x18>
80001022:	439c                	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001024:	41f65713          	srai	a4,a2,0x1f
80001028:	8b7d                	andi	a4,a4,31
8000102a:	9732                	add	a4,a4,a2
8000102c:	8715                	srai	a4,a4,0x5
8000102e:	070a                	slli	a4,a4,0x2
80001030:	97ba                	add	a5,a5,a4
80001032:	c29c                	sw	a5,0(a3)

	return bn & 0x1f;
}
80001034:	01f67513          	andi	a0,a2,31
80001038:	8082                	ret

8000103a <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
8000103a:	1101                	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
8000103c:	0074                	addi	a3,sp,12
{
8000103e:	ce06                	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001040:	37f1                	jal	8000100c <get_bit_ptr>

	*word |= (1<<bit);
80001042:	4732                	lw	a4,12(sp)
80001044:	4785                	li	a5,1
80001046:	00a79533          	sll	a0,a5,a0
8000104a:	431c                	lw	a5,0(a4)
}
8000104c:	40f2                	lw	ra,28(sp)
	*word |= (1<<bit);
8000104e:	8fc9                	or	a5,a5,a0
80001050:	c31c                	sw	a5,0(a4)
}
80001052:	6105                	addi	sp,sp,32
80001054:	8082                	ret

80001056 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001056:	1101                	addi	sp,sp,-32
80001058:	ca26                	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
8000105a:	4144                	lw	s1,4(a0)
{
8000105c:	cc22                	sw	s0,24(sp)
8000105e:	842a                	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001060:	00855503          	lhu	a0,8(a0)
80001064:	85a6                	mv	a1,s1
{
80001066:	c84a                	sw	s2,16(sp)
80001068:	c64e                	sw	s3,12(sp)
8000106a:	c452                	sw	s4,8(sp)
8000106c:	c256                	sw	s5,4(sp)
8000106e:	c05a                	sw	s6,0(sp)
80001070:	ce06                	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001072:	fbaff0ef          	jal	ra,8000082c <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001076:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
8000107a:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
8000107e:	57fd                	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001080:	8a2a                	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001082:	99aa                	add	s3,s3,a0
	p->max_inline_level = -1;
80001084:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001088:	4901                	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
8000108a:	4b7d                	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
8000108c:	03594163          	blt	s2,s5,800010ae <z_sys_mem_pool_base_init+0x58>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001090:	4481                	li	s1,0
80001092:	00845783          	lhu	a5,8(s0)
80001096:	04f4cf63          	blt	s1,a5,800010f4 <z_sys_mem_pool_base_init+0x9e>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
8000109a:	40f2                	lw	ra,28(sp)
8000109c:	4462                	lw	s0,24(sp)
8000109e:	44d2                	lw	s1,20(sp)
800010a0:	4942                	lw	s2,16(sp)
800010a2:	49b2                	lw	s3,12(sp)
800010a4:	4a22                	lw	s4,8(sp)
800010a6:	4a92                	lw	s5,4(sp)
800010a8:	4b02                	lw	s6,0(sp)
800010aa:	6105                	addi	sp,sp,32
800010ac:	8082                	ret
		int nblocks = buflen / sz;
800010ae:	85a6                	mv	a1,s1
800010b0:	8552                	mv	a0,s4
800010b2:	837ff0ef          	jal	ra,800008e8 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
800010b6:	00191713          	slli	a4,s2,0x1
800010ba:	974a                	add	a4,a4,s2
800010bc:	00271793          	slli	a5,a4,0x2
800010c0:	4458                	lw	a4,12(s0)
800010c2:	973e                	add	a4,a4,a5
800010c4:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
800010c8:	c35c                	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
800010ca:	c71c                	sw	a5,8(a4)
		if (nblocks < 32) {
800010cc:	00ab4963          	blt	s6,a0,800010de <z_sys_mem_pool_base_init+0x88>
			p->max_inline_level = i;
800010d0:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
800010d4:	8089                	srli	s1,s1,0x2
800010d6:	048d                	addi	s1,s1,3
800010d8:	98f1                	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
800010da:	0905                	addi	s2,s2,1
800010dc:	bf45                	j	8000108c <z_sys_mem_pool_base_init+0x36>
			bits += (nblocks + 31)/32;
800010de:	057d                	addi	a0,a0,31
800010e0:	41f55793          	srai	a5,a0,0x1f
800010e4:	8bfd                	andi	a5,a5,31
800010e6:	97aa                	add	a5,a5,a0
800010e8:	8795                	srai	a5,a5,0x5
800010ea:	078a                	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
800010ec:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
800010f0:	99be                	add	s3,s3,a5
800010f2:	b7cd                	j	800010d4 <z_sys_mem_pool_base_init+0x7e>
	return (u8_t *)p->buf + lsz * block;
800010f4:	404c                	lw	a1,4(s0)
800010f6:	8526                	mv	a0,s1
800010f8:	f34ff0ef          	jal	ra,8000082c <__mulsi3>
800010fc:	401c                	lw	a5,0(s0)
		set_free_bit(p, 0, i);
800010fe:	8626                	mv	a2,s1
80001100:	4581                	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001102:	953e                	add	a0,a0,a5
		sys_dlist_append(&p->levels[0].free_list, block);
80001104:	445c                	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001106:	0485                	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001108:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
8000110c:	c118                	sw	a4,0(a0)
	node->prev = list->tail;
8000110e:	4798                	lw	a4,8(a5)
80001110:	c158                	sw	a4,4(a0)

	list->tail->next = node;
80001112:	4798                	lw	a4,8(a5)
80001114:	c308                	sw	a0,0(a4)
	list->tail = node;
80001116:	c788                	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001118:	8522                	mv	a0,s0
8000111a:	3705                	jal	8000103a <set_free_bit>
8000111c:	bf9d                	j	80001092 <z_sys_mem_pool_base_init+0x3c>

8000111e <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
8000111e:	1141                	addi	sp,sp,-16
80001120:	87aa                	mv	a5,a0
80001122:	852e                	mv	a0,a1
80001124:	85b2                	mv	a1,a2
	entry(p1, p2, p3);
80001126:	8636                	mv	a2,a3
{
80001128:	c606                	sw	ra,12(sp)
	entry(p1, p2, p3);
8000112a:	9782                	jalr	a5
8000112c:	1fe020ef          	jal	ra,8000332a <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001130:	7fe020ef          	jal	ra,8000392e <z_impl_k_thread_abort>

80001134 <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001134:	4501                	li	a0,0
80001136:	8082                	ret

80001138 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001138:	1141                	addi	sp,sp,-16
8000113a:	c422                	sw	s0,8(sp)
8000113c:	842a                	mv	s0,a0
	out('E', ctx);
8000113e:	04500513          	li	a0,69
{
80001142:	c606                	sw	ra,12(sp)
80001144:	c226                	sw	s1,4(sp)
80001146:	84ae                	mv	s1,a1
	out('E', ctx);
80001148:	9402                	jalr	s0
	out('R', ctx);
8000114a:	85a6                	mv	a1,s1
8000114c:	05200513          	li	a0,82
80001150:	9402                	jalr	s0
	out('R', ctx);
80001152:	8322                	mv	t1,s0
}
80001154:	4422                	lw	s0,8(sp)
80001156:	40b2                	lw	ra,12(sp)
	out('R', ctx);
80001158:	85a6                	mv	a1,s1
}
8000115a:	4492                	lw	s1,4(sp)
	out('R', ctx);
8000115c:	05200513          	li	a0,82
}
80001160:	0141                	addi	sp,sp,16
	out('R', ctx);
80001162:	8302                	jr	t1

80001164 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001164:	419c                	lw	a5,0(a1)
80001166:	0785                	addi	a5,a5,1
80001168:	c19c                	sw	a5,0(a1)
	return _char_out(c);
8000116a:	800057b7          	lui	a5,0x80005
8000116e:	10c7a303          	lw	t1,268(a5) # 8000510c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000510d>
80001172:	8302                	jr	t1

80001174 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80001174:	7139                	addi	sp,sp,-64
80001176:	dc22                	sw	s0,56(sp)
80001178:	d64e                	sw	s3,44(sp)
8000117a:	d452                	sw	s4,40(sp)
8000117c:	d05a                	sw	s6,32(sp)
8000117e:	c86a                	sw	s10,16(sp)
80001180:	de06                	sw	ra,60(sp)
80001182:	da26                	sw	s1,52(sp)
80001184:	d84a                	sw	s2,48(sp)
80001186:	d256                	sw	s5,36(sp)
80001188:	ce5e                	sw	s7,28(sp)
8000118a:	cc62                	sw	s8,24(sp)
8000118c:	ca66                	sw	s9,20(sp)
8000118e:	c66e                	sw	s11,12(sp)
80001190:	89aa                	mv	s3,a0
80001192:	8a2e                	mv	s4,a1
80001194:	8d32                	mv	s10,a2
80001196:	8b36                	mv	s6,a3
80001198:	4405                	li	s0,1
8000119a:	00e05363          	blez	a4,800011a0 <_printk_dec_ulong+0x2c>
8000119e:	843a                	mv	s0,a4
800011a0:	4785                	li	a5,1
800011a2:	02000c93          	li	s9,32
800011a6:	00fb1463          	bne	s6,a5,800011ae <_printk_dec_ulong+0x3a>
800011aa:	03000c93          	li	s9,48
800011ae:	3b9ad4b7          	lui	s1,0x3b9ad
800011b2:	4905                	li	s2,1
800011b4:	4aa9                	li	s5,10
800011b6:	4c01                	li	s8,0
800011b8:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
800011bc:	4d89                	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
800011be:	00148b93          	addi	s7,s1,1
800011c2:	000c1463          	bnez	s8,800011ca <_printk_dec_ulong+0x56>
800011c6:	07a4f263          	bgeu	s1,s10,8000122a <_printk_dec_ulong+0xb6>
			out((int)((remainder / (pos + 1)) + 48), ctx);
800011ca:	85de                	mv	a1,s7
800011cc:	856a                	mv	a0,s10
800011ce:	f1aff0ef          	jal	ra,800008e8 <__udivsi3>
800011d2:	85d2                	mv	a1,s4
800011d4:	03050513          	addi	a0,a0,48
800011d8:	9982                	jalr	s3
			digits++;
800011da:	0905                	addi	s2,s2,1
			found_largest_digit = 1;
800011dc:	4c05                	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
800011de:	85de                	mv	a1,s7
800011e0:	856a                	mv	a0,s10
800011e2:	f4eff0ef          	jal	ra,80000930 <__umodsi3>
800011e6:	8d2a                	mv	s10,a0
		pos /= 10;
800011e8:	45a9                	li	a1,10
800011ea:	8526                	mv	a0,s1
800011ec:	efcff0ef          	jal	ra,800008e8 <__udivsi3>
		remaining--;
800011f0:	1afd                	addi	s5,s5,-1
	while (pos >= 9) {
800011f2:	4785                	li	a5,1
		pos /= 10;
800011f4:	84aa                	mv	s1,a0
	while (pos >= 9) {
800011f6:	fcfa94e3          	bne	s5,a5,800011be <_printk_dec_ulong+0x4a>
	}
	out((int)(remainder + 48), ctx);
800011fa:	85d2                	mv	a1,s4
800011fc:	030d0513          	addi	a0,s10,48
80001200:	9982                	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
80001202:	478d                	li	a5,3
		remaining = min_width - digits;
80001204:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
80001208:	02fb0f63          	beq	s6,a5,80001246 <_printk_dec_ulong+0xd2>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
8000120c:	50f2                	lw	ra,60(sp)
8000120e:	5462                	lw	s0,56(sp)
80001210:	54d2                	lw	s1,52(sp)
80001212:	5942                	lw	s2,48(sp)
80001214:	59b2                	lw	s3,44(sp)
80001216:	5a22                	lw	s4,40(sp)
80001218:	5a92                	lw	s5,36(sp)
8000121a:	5b02                	lw	s6,32(sp)
8000121c:	4bf2                	lw	s7,28(sp)
8000121e:	4c62                	lw	s8,24(sp)
80001220:	4cd2                	lw	s9,20(sp)
80001222:	4d42                	lw	s10,16(sp)
80001224:	4db2                	lw	s11,12(sp)
80001226:	6121                	addi	sp,sp,64
80001228:	8082                	ret
		} else if (remaining <= min_width
8000122a:	fb544ae3          	blt	s0,s5,800011de <_printk_dec_ulong+0x6a>
				&& padding < PAD_SPACE_AFTER) {
8000122e:	fb6de8e3          	bltu	s11,s6,800011de <_printk_dec_ulong+0x6a>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80001232:	85d2                	mv	a1,s4
80001234:	8566                	mv	a0,s9
80001236:	9982                	jalr	s3
			digits++;
80001238:	0905                	addi	s2,s2,1
8000123a:	b755                	j	800011de <_printk_dec_ulong+0x6a>
			out(' ', ctx);
8000123c:	85d2                	mv	a1,s4
8000123e:	02000513          	li	a0,32
80001242:	9982                	jalr	s3
80001244:	147d                	addi	s0,s0,-1
		while (remaining-- > 0) {
80001246:	fe804be3          	bgtz	s0,8000123c <_printk_dec_ulong+0xc8>
8000124a:	b7c9                	j	8000120c <_printk_dec_ulong+0x98>

8000124c <__printk_hook_install>:
	_char_out = fn;
8000124c:	800057b7          	lui	a5,0x80005
80001250:	10a7a623          	sw	a0,268(a5) # 8000510c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000510d>
}
80001254:	8082                	ret

80001256 <z_vprintk>:
{
80001256:	715d                	addi	sp,sp,-80
80001258:	c4a2                	sw	s0,72(sp)
8000125a:	c2a6                	sw	s1,68(sp)
8000125c:	c0ca                	sw	s2,64(sp)
8000125e:	de4e                	sw	s3,60(sp)
80001260:	dc52                	sw	s4,56(sp)
80001262:	da56                	sw	s5,52(sp)
80001264:	d266                	sw	s9,36(sp)
80001266:	d06a                	sw	s10,32(sp)
80001268:	ce6e                	sw	s11,28(sp)
8000126a:	c686                	sw	ra,76(sp)
8000126c:	d85a                	sw	s6,48(sp)
8000126e:	d65e                	sw	s7,44(sp)
80001270:	d462                	sw	s8,40(sp)
80001272:	842a                	mv	s0,a0
80001274:	84ae                	mv	s1,a1
80001276:	8ab2                	mv	s5,a2
80001278:	8d36                	mv	s10,a3
	int long_ctr = 0;
8000127a:	4a01                	li	s4,0
	int min_width = -1;
8000127c:	597d                	li	s2,-1
	enum pad_type padding = PAD_NONE;
8000127e:	4981                	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
80001280:	4c81                	li	s9,0
					if (lld > INT32_MAX ||
80001282:	80000db7          	lui	s11,0x80000
	while (*fmt) {
80001286:	000ac503          	lbu	a0,0(s5)
8000128a:	e105                	bnez	a0,800012aa <z_vprintk+0x54>
}
8000128c:	40b6                	lw	ra,76(sp)
8000128e:	4426                	lw	s0,72(sp)
80001290:	4496                	lw	s1,68(sp)
80001292:	4906                	lw	s2,64(sp)
80001294:	59f2                	lw	s3,60(sp)
80001296:	5a62                	lw	s4,56(sp)
80001298:	5ad2                	lw	s5,52(sp)
8000129a:	5b42                	lw	s6,48(sp)
8000129c:	5bb2                	lw	s7,44(sp)
8000129e:	5c22                	lw	s8,40(sp)
800012a0:	5c92                	lw	s9,36(sp)
800012a2:	5d02                	lw	s10,32(sp)
800012a4:	4df2                	lw	s11,28(sp)
800012a6:	6161                	addi	sp,sp,80
800012a8:	8082                	ret
		if (!might_format) {
800012aa:	000c9a63          	bnez	s9,800012be <z_vprintk+0x68>
			if (*fmt != '%') {
800012ae:	02500693          	li	a3,37
800012b2:	28d50563          	beq	a0,a3,8000153c <z_vprintk+0x2e6>
				out((int)*fmt, ctx);
800012b6:	85a6                	mv	a1,s1
800012b8:	9402                	jalr	s0
		++fmt;
800012ba:	0a85                	addi	s5,s5,1
800012bc:	b7e9                	j	80001286 <z_vprintk+0x30>
			switch (*fmt) {
800012be:	06400693          	li	a3,100
800012c2:	0ed50b63          	beq	a0,a3,800013b8 <z_vprintk+0x162>
800012c6:	04a6eb63          	bltu	a3,a0,8000131c <z_vprintk+0xc6>
800012ca:	03900693          	li	a3,57
800012ce:	02a6e763          	bltu	a3,a0,800012fc <z_vprintk+0xa6>
800012d2:	03100693          	li	a3,49
800012d6:	0cd57563          	bgeu	a0,a3,800013a0 <z_vprintk+0x14a>
800012da:	02d00693          	li	a3,45
800012de:	26d50463          	beq	a0,a3,80001546 <z_vprintk+0x2f0>
800012e2:	03000793          	li	a5,48
800012e6:	0af50363          	beq	a0,a5,8000138c <z_vprintk+0x136>
800012ea:	02500713          	li	a4,37
800012ee:	00e51f63          	bne	a0,a4,8000130c <z_vprintk+0xb6>
				out((int)'%', ctx);
800012f2:	85a6                	mv	a1,s1
800012f4:	02500513          	li	a0,37
				out((int)*fmt, ctx);
800012f8:	9402                	jalr	s0
				break;
800012fa:	aa09                	j	8000140c <z_vprintk+0x1b6>
800012fc:	05800693          	li	a3,88
80001300:	14d50b63          	beq	a0,a3,80001456 <z_vprintk+0x200>
80001304:	06300713          	li	a4,99
80001308:	22e50363          	beq	a0,a4,8000152e <z_vprintk+0x2d8>
				out((int)'%', ctx);
8000130c:	85a6                	mv	a1,s1
8000130e:	02500513          	li	a0,37
80001312:	9402                	jalr	s0
				out((int)*fmt, ctx);
80001314:	85a6                	mv	a1,s1
80001316:	000ac503          	lbu	a0,0(s5)
8000131a:	bff9                	j	800012f8 <z_vprintk+0xa2>
8000131c:	07000693          	li	a3,112
80001320:	12d50163          	beq	a0,a3,80001442 <z_vprintk+0x1ec>
80001324:	00a6ef63          	bltu	a3,a0,80001342 <z_vprintk+0xec>
80001328:	06900693          	li	a3,105
8000132c:	08d50663          	beq	a0,a3,800013b8 <z_vprintk+0x162>
80001330:	06c00693          	li	a3,108
80001334:	08d50063          	beq	a0,a3,800013b4 <z_vprintk+0x15e>
80001338:	06800693          	li	a3,104
8000133c:	f6d50fe3          	beq	a0,a3,800012ba <z_vprintk+0x64>
80001340:	b7f1                	j	8000130c <z_vprintk+0xb6>
80001342:	07500693          	li	a3,117
80001346:	0cd50563          	beq	a0,a3,80001410 <z_vprintk+0x1ba>
8000134a:	02a6ea63          	bltu	a3,a0,8000137e <z_vprintk+0x128>
8000134e:	07300713          	li	a4,115
80001352:	fae51de3          	bne	a0,a4,8000130c <z_vprintk+0xb6>
				char *s = va_arg(ap, char *);
80001356:	000d2c03          	lw	s8,0(s10)
8000135a:	004d0b13          	addi	s6,s10,4
8000135e:	8be2                	mv	s7,s8
				while (*s)
80001360:	000bc503          	lbu	a0,0(s7)
80001364:	1a051b63          	bnez	a0,8000151a <z_vprintk+0x2c4>
				if (padding == PAD_SPACE_AFTER) {
80001368:	478d                	li	a5,3
8000136a:	00f99863          	bne	s3,a5,8000137a <z_vprintk+0x124>
					int remaining = min_width - (s - start);
8000136e:	418b8bb3          	sub	s7,s7,s8
80001372:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
80001376:	1b704663          	bgtz	s7,80001522 <z_vprintk+0x2cc>
				char *s = va_arg(ap, char *);
8000137a:	8d5a                	mv	s10,s6
8000137c:	a841                	j	8000140c <z_vprintk+0x1b6>
8000137e:	07800693          	li	a3,120
80001382:	0cd50a63          	beq	a0,a3,80001456 <z_vprintk+0x200>
80001386:	07a00693          	li	a3,122
8000138a:	bf4d                	j	8000133c <z_vprintk+0xe6>
				if (min_width < 0 && padding == PAD_NONE) {
8000138c:	00095c63          	bgez	s2,800013a4 <z_vprintk+0x14e>
80001390:	1a098d63          	beqz	s3,8000154a <z_vprintk+0x2f4>
					min_width = *fmt - '0';
80001394:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80001398:	f20991e3          	bnez	s3,800012ba <z_vprintk+0x64>
					padding = PAD_SPACE_BEFORE;
8000139c:	4989                	li	s3,2
8000139e:	bf31                	j	800012ba <z_vprintk+0x64>
				if (min_width < 0) {
800013a0:	fe094ae3          	bltz	s2,80001394 <z_vprintk+0x13e>
					min_width = 10 * min_width + *fmt - '0';
800013a4:	00291693          	slli	a3,s2,0x2
800013a8:	9936                	add	s2,s2,a3
800013aa:	0906                	slli	s2,s2,0x1
800013ac:	fd090913          	addi	s2,s2,-48
800013b0:	992a                	add	s2,s2,a0
800013b2:	b7dd                	j	80001398 <z_vprintk+0x142>
				long_ctr++;
800013b4:	0a05                	addi	s4,s4,1
800013b6:	b711                	j	800012ba <z_vprintk+0x64>
				if (long_ctr == 0) {
800013b8:	020a1663          	bnez	s4,800013e4 <z_vprintk+0x18e>
					long ld = va_arg(ap, long);
800013bc:	000d2603          	lw	a2,0(s10)
800013c0:	0d11                	addi	s10,s10,4
				if (d < 0) {
800013c2:	00065b63          	bgez	a2,800013d8 <z_vprintk+0x182>
					out((int)'-', ctx);
800013c6:	85a6                	mv	a1,s1
800013c8:	02d00513          	li	a0,45
800013cc:	c032                	sw	a2,0(sp)
800013ce:	9402                	jalr	s0
					d = -d;
800013d0:	4602                	lw	a2,0(sp)
					min_width--;
800013d2:	197d                	addi	s2,s2,-1
					d = -d;
800013d4:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
800013d8:	874a                	mv	a4,s2
800013da:	86ce                	mv	a3,s3
800013dc:	85a6                	mv	a1,s1
800013de:	8522                	mv	a0,s0
800013e0:	3b51                	jal	80001174 <_printk_dec_ulong>
				break;
800013e2:	a02d                	j	8000140c <z_vprintk+0x1b6>
				} else if (long_ctr == 1) {
800013e4:	4705                	li	a4,1
800013e6:	fcea0be3          	beq	s4,a4,800013bc <z_vprintk+0x166>
					long long lld = va_arg(ap, long long);
800013ea:	007d0793          	addi	a5,s10,7
800013ee:	ff87f713          	andi	a4,a5,-8
800013f2:	4310                	lw	a2,0(a4)
800013f4:	4354                	lw	a3,4(a4)
800013f6:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800013fa:	01b60733          	add	a4,a2,s11
800013fe:	00c73733          	sltu	a4,a4,a2
80001402:	9736                	add	a4,a4,a3
80001404:	df5d                	beqz	a4,800013c2 <z_vprintk+0x16c>
						print_err(out, ctx);
80001406:	85a6                	mv	a1,s1
80001408:	8522                	mv	a0,s0
8000140a:	333d                	jal	80001138 <print_err>
			might_format = 0;
8000140c:	4c81                	li	s9,0
8000140e:	b575                	j	800012ba <z_vprintk+0x64>
				if (long_ctr == 0) {
80001410:	000a1663          	bnez	s4,8000141c <z_vprintk+0x1c6>
					long lu = va_arg(ap, unsigned long);
80001414:	000d2603          	lw	a2,0(s10)
80001418:	0d11                	addi	s10,s10,4
8000141a:	bf7d                	j	800013d8 <z_vprintk+0x182>
				} else if (long_ctr == 1) {
8000141c:	4705                	li	a4,1
8000141e:	feea0be3          	beq	s4,a4,80001414 <z_vprintk+0x1be>
					unsigned long long llu =
80001422:	007d0793          	addi	a5,s10,7
80001426:	ff87f713          	andi	a4,a5,-8
8000142a:	00870d13          	addi	s10,a4,8
8000142e:	4310                	lw	a2,0(a4)
80001430:	4358                	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80001432:	fb71                	bnez	a4,80001406 <z_vprintk+0x1b0>
80001434:	800007b7          	lui	a5,0x80000
80001438:	fff7c793          	not	a5,a5
8000143c:	f8c7fee3          	bgeu	a5,a2,800013d8 <z_vprintk+0x182>
80001440:	b7d9                	j	80001406 <z_vprintk+0x1b0>
				  out('0', ctx);
80001442:	85a6                	mv	a1,s1
80001444:	03000513          	li	a0,48
80001448:	9402                	jalr	s0
				  out('x', ctx);
8000144a:	85a6                	mv	a1,s1
8000144c:	07800513          	li	a0,120
80001450:	9402                	jalr	s0
				  min_width = 8;
80001452:	4921                	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80001454:	4985                	li	s3,1
				if (long_ctr < 2) {
80001456:	4685                	li	a3,1
80001458:	0746c663          	blt	a3,s4,800014c4 <z_vprintk+0x26e>
					x = va_arg(ap, unsigned long);
8000145c:	000d2783          	lw	a5,0(s10)
80001460:	c402                	sw	zero,8(sp)
80001462:	0d11                	addi	s10,s10,4
80001464:	c23e                	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
80001466:	4c41                	li	s8,16
	int digits = 0;
80001468:	4b81                	li	s7,0
	int found_largest_digit = 0;
8000146a:	c002                	sw	zero,0(sp)
	int size = sizeof(num) * 2;
8000146c:	48c1                	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
8000146e:	4512                	lw	a0,4(sp)
80001470:	45a2                	lw	a1,8(sp)
80001472:	fff88b13          	addi	s6,a7,-1
80001476:	002b1613          	slli	a2,s6,0x2
8000147a:	c646                	sw	a7,12(sp)
8000147c:	da5fe0ef          	jal	ra,80000220 <__lshrdi3>
80001480:	893d                	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80001482:	ed39                	bnez	a0,800014e0 <z_vprintk+0x28a>
80001484:	4782                	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80001486:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
8000148a:	e789                	bnez	a5,80001494 <z_vprintk+0x23e>
8000148c:	48b2                	lw	a7,12(sp)
8000148e:	4785                	li	a5,1
80001490:	06f89063          	bne	a7,a5,800014f0 <z_vprintk+0x29a>
			nibble += nibble > 9 ? 87 : 48;
80001494:	9536                	add	a0,a0,a3
			out((int)nibble, ctx);
80001496:	0562                	slli	a0,a0,0x18
80001498:	85a6                	mv	a1,s1
8000149a:	8561                	srai	a0,a0,0x18
8000149c:	9402                	jalr	s0
			digits++;
8000149e:	0b85                	addi	s7,s7,1
	for (; size != 0; size--) {
800014a0:	020b1d63          	bnez	s6,800014da <z_vprintk+0x284>
	if (padding == PAD_SPACE_AFTER) {
800014a4:	468d                	li	a3,3
			might_format = 0;
800014a6:	4c81                	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800014a8:	e0d999e3          	bne	s3,a3,800012ba <z_vprintk+0x64>
		remaining = min_width * 2 - digits;
800014ac:	00191713          	slli	a4,s2,0x1
800014b0:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800014b4:	f5705ce3          	blez	s7,8000140c <z_vprintk+0x1b6>
			out(' ', ctx);
800014b8:	85a6                	mv	a1,s1
800014ba:	02000513          	li	a0,32
800014be:	9402                	jalr	s0
800014c0:	1bfd                	addi	s7,s7,-1
800014c2:	bfcd                	j	800014b4 <z_vprintk+0x25e>
					x = va_arg(ap, unsigned long long);
800014c4:	007d0793          	addi	a5,s10,7
800014c8:	ff87f693          	andi	a3,a5,-8
800014cc:	429c                	lw	a5,0(a3)
800014ce:	00868d13          	addi	s10,a3,8
800014d2:	c23e                	sw	a5,4(sp)
800014d4:	42dc                	lw	a5,4(a3)
800014d6:	c43e                	sw	a5,8(sp)
800014d8:	b779                	j	80001466 <z_vprintk+0x210>
			found_largest_digit = 1;
800014da:	c066                	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
800014dc:	88da                	mv	a7,s6
800014de:	bf41                	j	8000146e <z_vprintk+0x218>
			nibble += nibble > 9 ? 87 : 48;
800014e0:	47a5                	li	a5,9
800014e2:	05700693          	li	a3,87
800014e6:	faa7e7e3          	bltu	a5,a0,80001494 <z_vprintk+0x23e>
800014ea:	03000693          	li	a3,48
800014ee:	b75d                	j	80001494 <z_vprintk+0x23e>
		if (remaining-- <= min_width) {
800014f0:	fffc0793          	addi	a5,s8,-1
800014f4:	c63e                	sw	a5,12(sp)
800014f6:	01894963          	blt	s2,s8,80001508 <z_vprintk+0x2b2>
			if (padding == PAD_ZERO_BEFORE) {
800014fa:	4785                	li	a5,1
800014fc:	00f99863          	bne	s3,a5,8000150c <z_vprintk+0x2b6>
				out('0', ctx);
80001500:	85a6                	mv	a1,s1
80001502:	03000513          	li	a0,48
				out(' ', ctx);
80001506:	9402                	jalr	s0
					x = va_arg(ap, unsigned long);
80001508:	4c32                	lw	s8,12(sp)
8000150a:	bfc9                	j	800014dc <z_vprintk+0x286>
			} else if (padding == PAD_SPACE_BEFORE) {
8000150c:	4789                	li	a5,2
8000150e:	fef99de3          	bne	s3,a5,80001508 <z_vprintk+0x2b2>
				out(' ', ctx);
80001512:	85a6                	mv	a1,s1
80001514:	02000513          	li	a0,32
80001518:	b7fd                	j	80001506 <z_vprintk+0x2b0>
					out((int)(*s++), ctx);
8000151a:	85a6                	mv	a1,s1
8000151c:	0b85                	addi	s7,s7,1
8000151e:	9402                	jalr	s0
80001520:	b581                	j	80001360 <z_vprintk+0x10a>
						out(' ', ctx);
80001522:	85a6                	mv	a1,s1
80001524:	02000513          	li	a0,32
80001528:	9402                	jalr	s0
8000152a:	1bfd                	addi	s7,s7,-1
8000152c:	b5a9                	j	80001376 <z_vprintk+0x120>
				out(c, ctx);
8000152e:	000d2503          	lw	a0,0(s10)
80001532:	85a6                	mv	a1,s1
				int c = va_arg(ap, int);
80001534:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80001538:	9402                	jalr	s0
				break;
8000153a:	b581                	j	8000137a <z_vprintk+0x124>
				long_ctr = 0;
8000153c:	4a01                	li	s4,0
				min_width = -1;
8000153e:	597d                	li	s2,-1
				padding = PAD_NONE;
80001540:	4981                	li	s3,0
				might_format = 1;
80001542:	4c85                	li	s9,1
80001544:	bb9d                	j	800012ba <z_vprintk+0x64>
				padding = PAD_SPACE_AFTER;
80001546:	498d                	li	s3,3
80001548:	bb8d                	j	800012ba <z_vprintk+0x64>
					padding = PAD_ZERO_BEFORE;
8000154a:	4985                	li	s3,1
8000154c:	b3bd                	j	800012ba <z_vprintk+0x64>

8000154e <vprintk>:
{
8000154e:	1101                	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
80001550:	862a                	mv	a2,a0
80001552:	80001537          	lui	a0,0x80001
80001556:	86ae                	mv	a3,a1
80001558:	16450513          	addi	a0,a0,356 # 80001164 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001165>
8000155c:	006c                	addi	a1,sp,12
{
8000155e:	ce06                	sw	ra,28(sp)
	struct out_context ctx = { 0 };
80001560:	c602                	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
80001562:	39d5                	jal	80001256 <z_vprintk>
}
80001564:	40f2                	lw	ra,28(sp)
80001566:	6105                	addi	sp,sp,32
80001568:	8082                	ret

8000156a <printk>:
{
8000156a:	7139                	addi	sp,sp,-64
8000156c:	d22e                	sw	a1,36(sp)
	va_start(ap, fmt);
8000156e:	104c                	addi	a1,sp,36
{
80001570:	ce06                	sw	ra,28(sp)
80001572:	d432                	sw	a2,40(sp)
80001574:	d636                	sw	a3,44(sp)
80001576:	d83a                	sw	a4,48(sp)
80001578:	da3e                	sw	a5,52(sp)
8000157a:	dc42                	sw	a6,56(sp)
8000157c:	de46                	sw	a7,60(sp)
	va_start(ap, fmt);
8000157e:	c62e                	sw	a1,12(sp)
		vprintk(fmt, ap);
80001580:	37f9                	jal	8000154e <vprintk>
}
80001582:	40f2                	lw	ra,28(sp)
80001584:	6121                	addi	sp,sp,64
80001586:	8082                	ret

80001588 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80001588:	800055b7          	lui	a1,0x80005
8000158c:	80005537          	lui	a0,0x80005
{
80001590:	1141                	addi	sp,sp,-16
  k_panic();
80001592:	b8058593          	addi	a1,a1,-1152 # 80004b80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b81>
80001596:	b9450513          	addi	a0,a0,-1132 # 80004b94 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b95>
8000159a:	4679                	li	a2,30
{
8000159c:	c606                	sw	ra,12(sp)
  k_panic();
8000159e:	37f1                	jal	8000156a <printk>
800015a0:	800045b7          	lui	a1,0x80004
800015a4:	7a458593          	addi	a1,a1,1956 # 800047a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800047a5>
800015a8:	4519                	li	a0,6
800015aa:	837ff0ef          	jal	ra,80000de0 <z_NanoFatalErrorHandler>

800015ae <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
800015ae:	8082                	ret

800015b0 <k_cpu_idle>:
800015b0:	47a1                	li	a5,8
800015b2:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
800015b6:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
800015ba:	8082                	ret

800015bc <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
800015bc:	4785                	li	a5,1
800015be:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
800015c2:	30452573          	csrrs	a0,mie,a0
}
800015c6:	8082                	ret

800015c8 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
800015c8:	47a1                	li	a5,8
800015ca:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
800015ce:	30405073          	csrwi	mie,0
800015d2:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
800015d6:	8082                	ret

800015d8 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
800015d8:	1141                	addi	sp,sp,-16
800015da:	c422                	sw	s0,8(sp)
800015dc:	c226                	sw	s1,4(sp)
800015de:	80005437          	lui	s0,0x80005
800015e2:	c606                	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
800015e4:	47a9                	li	a5,10
{
800015e6:	84aa                	mv	s1,a0
800015e8:	18c40413          	addi	s0,s0,396 # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
	if ('\n' == c) {
800015ec:	00f51763          	bne	a0,a5,800015fa <console_out+0x22>
800015f0:	4008                	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800015f2:	45b5                	li	a1,13
800015f4:	415c                	lw	a5,4(a0)
800015f6:	43dc                	lw	a5,4(a5)
800015f8:	9782                	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800015fa:	4008                	lw	a0,0(s0)
800015fc:	0ff4f593          	andi	a1,s1,255
80001600:	415c                	lw	a5,4(a0)
80001602:	43dc                	lw	a5,4(a5)
80001604:	9782                	jalr	a5

	return c;
}
80001606:	40b2                	lw	ra,12(sp)
80001608:	4422                	lw	s0,8(sp)
8000160a:	8526                	mv	a0,s1
8000160c:	4492                	lw	s1,4(sp)
8000160e:	0141                	addi	sp,sp,16
80001610:	8082                	ret

80001612 <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
80001612:	1141                	addi	sp,sp,-16
80001614:	c422                	sw	s0,8(sp)
	__stdout_hook_install(console_out);
80001616:	80001437          	lui	s0,0x80001
8000161a:	5d840513          	addi	a0,s0,1496 # 800015d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800015d9>
{
8000161e:	c606                	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80001620:	2ef5                	jal	80001a1c <__stdout_hook_install>
	__printk_hook_install(console_out);
80001622:	5d840513          	addi	a0,s0,1496
}
80001626:	4422                	lw	s0,8(sp)
80001628:	40b2                	lw	ra,12(sp)
8000162a:	0141                	addi	sp,sp,16
	__printk_hook_install(console_out);
8000162c:	b105                	j	8000124c <__printk_hook_install>

8000162e <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
8000162e:	80005537          	lui	a0,0x80005
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
80001632:	1141                	addi	sp,sp,-16
80001634:	ba050513          	addi	a0,a0,-1120 # 80004ba0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ba1>
80001638:	c606                	sw	ra,12(sp)
8000163a:	2db5                	jal	80001cb6 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000163c:	800057b7          	lui	a5,0x80005
80001640:	18a7a623          	sw	a0,396(a5) # 8000518c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000518d>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80001644:	37f9                	jal	80001612 <uart_console_hook_install>

	return 0;
}
80001646:	40b2                	lw	ra,12(sp)
80001648:	4501                	li	a0,0
8000164a:	0141                	addi	sp,sp,16
8000164c:	8082                	ret

8000164e <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
8000164e:	f01007b7          	lui	a5,0xf0100
80001652:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80001656:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
8000165a:	f447a583          	lw	a1,-188(a5)
8000165e:	fee59ae3          	bne	a1,a4,80001652 <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
80001662:	8082                	ret

80001664 <timer_isr>:

static void timer_isr(void *arg)
{
80001664:	1101                	addi	sp,sp,-32
80001666:	cc22                	sw	s0,24(sp)
80001668:	ce06                	sw	ra,28(sp)
8000166a:	ca26                	sw	s1,20(sp)
8000166c:	c84a                	sw	s2,16(sp)
8000166e:	c64e                	sw	s3,12(sp)
80001670:	c452                	sw	s4,8(sp)
80001672:	c256                	sw	s5,4(sp)
80001674:	4421                	li	s0,8
80001676:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000167a:	80005937          	lui	s2,0x80005
8000167e:	19090513          	addi	a0,s2,400 # 80005190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005191>
	key = (mstatus & SOC_MSTATUS_IEN);
80001682:	8821                	andi	s0,s0,8
80001684:	026020ef          	jal	ra,800036aa <z_spin_lock_valid>
80001688:	e915                	bnez	a0,800016bc <timer_isr+0x58>
8000168a:	800054b7          	lui	s1,0x80005
8000168e:	800055b7          	lui	a1,0x80005
80001692:	80005537          	lui	a0,0x80005
80001696:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000169a:	04e00693          	li	a3,78
8000169e:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800016a2:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800016a6:	35d1                	jal	8000156a <printk>
800016a8:	80005537          	lui	a0,0x80005
800016ac:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800016b0:	3d6d                	jal	8000156a <printk>
800016b2:	04e00593          	li	a1,78
800016b6:	bb448513          	addi	a0,s1,-1100
800016ba:	35f9                	jal	80001588 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
800016bc:	19090513          	addi	a0,s2,400
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800016c0:	800054b7          	lui	s1,0x80005
800016c4:	022020ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
800016c8:	17048493          	addi	s1,s1,368 # 80005170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005171>
	u64_t now = mtime();
800016cc:	3749                	jal	8000164e <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800016ce:	0004a983          	lw	s3,0(s1)
800016d2:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
800016d6:	87aa                	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800016d8:	41350533          	sub	a0,a0,s3
800016dc:	00a7b7b3          	sltu	a5,a5,a0
800016e0:	415585b3          	sub	a1,a1,s5
800016e4:	6675                	lui	a2,0x1d
800016e6:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800016ea:	4681                	li	a3,0
800016ec:	8d9d                	sub	a1,a1,a5
800016ee:	b6bfe0ef          	jal	ra,80000258 <__udivdi3>
800016f2:	8a2a                	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
800016f4:	65f5                	lui	a1,0x1d
800016f6:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800016fa:	8552                	mv	a0,s4
800016fc:	930ff0ef          	jal	ra,8000082c <__mulsi3>
80001700:	99aa                	add	s3,s3,a0
80001702:	00a9b533          	sltu	a0,s3,a0
80001706:	9556                	add	a0,a0,s5
80001708:	c0c8                	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000170a:	19090513          	addi	a0,s2,400
8000170e:	0134a023          	sw	s3,0(s1)
80001712:	7b3010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80001716:	e915                	bnez	a0,8000174a <timer_isr+0xe6>
80001718:	800054b7          	lui	s1,0x80005
8000171c:	800055b7          	lui	a1,0x80005
80001720:	80005537          	lui	a0,0x80005
80001724:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80001728:	06100693          	li	a3,97
8000172c:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80001730:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80001734:	3d1d                	jal	8000156a <printk>
80001736:	80005537          	lui	a0,0x80005
8000173a:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000173e:	3535                	jal	8000156a <printk>
80001740:	06100593          	li	a1,97
80001744:	bb448513          	addi	a0,s1,-1100
80001748:	3581                	jal	80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000174a:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
8000174e:	4462                	lw	s0,24(sp)
80001750:	40f2                	lw	ra,28(sp)
80001752:	44d2                	lw	s1,20(sp)
80001754:	4942                	lw	s2,16(sp)
80001756:	49b2                	lw	s3,12(sp)
80001758:	4a92                	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000175a:	8552                	mv	a0,s4
}
8000175c:	4a22                	lw	s4,8(sp)
8000175e:	6105                	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
80001760:	73e0206f          	j	80003e9e <z_clock_announce>

80001764 <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
80001764:	1141                	addi	sp,sp,-16
80001766:	c606                	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001768:	35dd                	jal	8000164e <mtime>
8000176a:	67f5                	lui	a5,0x1d
8000176c:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
80001770:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
80001774:	97aa                	add	a5,a5,a0
	r[1] = 0xffffffff;
80001776:	56fd                	li	a3,-1
80001778:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
8000177c:	00a7b533          	sltu	a0,a5,a0
80001780:	952e                	add	a0,a0,a1
	r[0] = (u32_t)time;
80001782:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
80001786:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
8000178a:	451d                	li	a0,7
8000178c:	3d05                	jal	800015bc <z_arch_irq_enable>
	return 0;
}
8000178e:	40b2                	lw	ra,12(sp)
80001790:	4501                	li	a0,0
80001792:	0141                	addi	sp,sp,16
80001794:	8082                	ret

80001796 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
80001796:	14059563          	bnez	a1,800018e0 <z_clock_set_timeout+0x14a>
{
8000179a:	1101                	addi	sp,sp,-32
8000179c:	ce06                	sw	ra,28(sp)
8000179e:	cc22                	sw	s0,24(sp)
800017a0:	ca26                	sw	s1,20(sp)
800017a2:	c84a                	sw	s2,16(sp)
800017a4:	c64e                	sw	s3,12(sp)
800017a6:	c452                	sw	s4,8(sp)
800017a8:	c256                	sw	s5,4(sp)
800017aa:	c05a                	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
800017ac:	57fd                	li	a5,-1
800017ae:	00f51563          	bne	a0,a5,800017b8 <z_clock_set_timeout+0x22>
800017b2:	6525                	lui	a0,0x9
800017b4:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
800017b8:	67a5                	lui	a5,0x9
800017ba:	fff50413          	addi	s0,a0,-1
800017be:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
800017c2:	1087db63          	bge	a5,s0,800018d8 <z_clock_set_timeout+0x142>
800017c6:	843e                	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
800017c8:	4921                	li	s2,8
800017ca:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800017ce:	80005ab7          	lui	s5,0x80005
800017d2:	190a8513          	addi	a0,s5,400 # 80005190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005191>
	key = (mstatus & SOC_MSTATUS_IEN);
800017d6:	00897913          	andi	s2,s2,8
800017da:	6d1010ef          	jal	ra,800036aa <z_spin_lock_valid>
800017de:	e915                	bnez	a0,80001812 <z_clock_set_timeout+0x7c>
800017e0:	800054b7          	lui	s1,0x80005
800017e4:	800055b7          	lui	a1,0x80005
800017e8:	80005537          	lui	a0,0x80005
800017ec:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800017f0:	04e00693          	li	a3,78
800017f4:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800017f8:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800017fc:	33bd                	jal	8000156a <printk>
800017fe:	80005537          	lui	a0,0x80005
80001802:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80001806:	3395                	jal	8000156a <printk>
80001808:	04e00593          	li	a1,78
8000180c:	bb448513          	addi	a0,s1,-1100
80001810:	3ba5                	jal	80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80001812:	190a8513          	addi	a0,s5,400
80001816:	6d1010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
8000181a:	3d15                	jal	8000164e <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
8000181c:	800057b7          	lui	a5,0x80005
80001820:	17078793          	addi	a5,a5,368 # 80005170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005171>
	u32_t cyc = ticks * CYC_PER_TICK;
80001824:	64f5                	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001826:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
8000182a:	8a2a                	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
8000182c:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80001830:	8522                	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
80001832:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
80001836:	ff7fe0ef          	jal	ra,8000082c <__mulsi3>
8000183a:	4bf48793          	addi	a5,s1,1215
8000183e:	413787b3          	sub	a5,a5,s3
80001842:	953e                	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
80001844:	4c048593          	addi	a1,s1,1216
80001848:	9552                	add	a0,a0,s4
8000184a:	89eff0ef          	jal	ra,800008e8 <__udivsi3>
8000184e:	4c048593          	addi	a1,s1,1216
80001852:	fdbfe0ef          	jal	ra,8000082c <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
80001856:	41498a33          	sub	s4,s3,s4
8000185a:	9a2a                	add	s4,s4,a0
8000185c:	3e700793          	li	a5,999
80001860:	0147c563          	blt	a5,s4,8000186a <z_clock_set_timeout+0xd4>
		cyc += CYC_PER_TICK;
80001864:	4c048493          	addi	s1,s1,1216
80001868:	9526                	add	a0,a0,s1
	r[1] = 0xffffffff;
8000186a:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
8000186e:	99aa                	add	s3,s3,a0
	r[1] = 0xffffffff;
80001870:	577d                	li	a4,-1
80001872:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80001876:	00a9b533          	sltu	a0,s3,a0
8000187a:	955a                	add	a0,a0,s6
	r[0] = (u32_t)time;
8000187c:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80001880:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001884:	190a8513          	addi	a0,s5,400
80001888:	63d010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
8000188c:	e915                	bnez	a0,800018c0 <z_clock_set_timeout+0x12a>
8000188e:	80005437          	lui	s0,0x80005
80001892:	800055b7          	lui	a1,0x80005
80001896:	80005537          	lui	a0,0x80005
8000189a:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
8000189e:	06100693          	li	a3,97
800018a2:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800018a6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800018aa:	31c1                	jal	8000156a <printk>
800018ac:	80005537          	lui	a0,0x80005
800018b0:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
800018b4:	395d                	jal	8000156a <printk>
800018b6:	06100593          	li	a1,97
800018ba:	bb440513          	addi	a0,s0,-1100
800018be:	31e9                	jal	80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800018c0:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
800018c4:	40f2                	lw	ra,28(sp)
800018c6:	4462                	lw	s0,24(sp)
800018c8:	44d2                	lw	s1,20(sp)
800018ca:	4942                	lw	s2,16(sp)
800018cc:	49b2                	lw	s3,12(sp)
800018ce:	4a22                	lw	s4,8(sp)
800018d0:	4a92                	lw	s5,4(sp)
800018d2:	4b02                	lw	s6,0(sp)
800018d4:	6105                	addi	sp,sp,32
800018d6:	8082                	ret
800018d8:	ee0458e3          	bgez	s0,800017c8 <z_clock_set_timeout+0x32>
800018dc:	4401                	li	s0,0
800018de:	b5ed                	j	800017c8 <z_clock_set_timeout+0x32>
800018e0:	8082                	ret

800018e2 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
800018e2:	1141                	addi	sp,sp,-16
800018e4:	c422                	sw	s0,8(sp)
800018e6:	c606                	sw	ra,12(sp)
800018e8:	c226                	sw	s1,4(sp)
800018ea:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800018ec:	4421                	li	s0,8
800018ee:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800018f2:	800054b7          	lui	s1,0x80005
800018f6:	19048513          	addi	a0,s1,400 # 80005190 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005191>
	key = (mstatus & SOC_MSTATUS_IEN);
800018fa:	8821                	andi	s0,s0,8
800018fc:	5af010ef          	jal	ra,800036aa <z_spin_lock_valid>
80001900:	e915                	bnez	a0,80001934 <z_clock_elapsed+0x52>
80001902:	80005937          	lui	s2,0x80005
80001906:	800055b7          	lui	a1,0x80005
8000190a:	80005537          	lui	a0,0x80005
8000190e:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80001912:	04e00693          	li	a3,78
80001916:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000191a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000191e:	31b1                	jal	8000156a <printk>
80001920:	80005537          	lui	a0,0x80005
80001924:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80001928:	3189                	jal	8000156a <printk>
8000192a:	04e00593          	li	a1,78
8000192e:	bb490513          	addi	a0,s2,-1100
80001932:	3999                	jal	80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80001934:	19048513          	addi	a0,s1,400
80001938:	5af010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
8000193c:	3b09                	jal	8000164e <mtime>
8000193e:	800057b7          	lui	a5,0x80005
80001942:	1707a783          	lw	a5,368(a5) # 80005170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005171>
80001946:	65f5                	lui	a1,0x1d
80001948:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
8000194c:	8d1d                	sub	a0,a0,a5
8000194e:	f9bfe0ef          	jal	ra,800008e8 <__udivsi3>
80001952:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001954:	19048513          	addi	a0,s1,400
80001958:	56d010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
8000195c:	e915                	bnez	a0,80001990 <z_clock_elapsed+0xae>
8000195e:	800054b7          	lui	s1,0x80005
80001962:	800055b7          	lui	a1,0x80005
80001966:	80005537          	lui	a0,0x80005
8000196a:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
8000196e:	06100693          	li	a3,97
80001972:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80001976:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000197a:	3ec5                	jal	8000156a <printk>
8000197c:	80005537          	lui	a0,0x80005
80001980:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80001984:	36dd                	jal	8000156a <printk>
80001986:	06100593          	li	a1,97
8000198a:	bb448513          	addi	a0,s1,-1100
8000198e:	3eed                	jal	80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001990:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80001994:	40b2                	lw	ra,12(sp)
80001996:	4422                	lw	s0,8(sp)
80001998:	854a                	mv	a0,s2
8000199a:	4492                	lw	s1,4(sp)
8000199c:	4902                	lw	s2,0(sp)
8000199e:	0141                	addi	sp,sp,16
800019a0:	8082                	ret

800019a2 <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
800019a2:	00054783          	lbu	a5,0(a0)
800019a6:	0005c703          	lbu	a4,0(a1)
800019aa:	00e79363          	bne	a5,a4,800019b0 <strcmp+0xe>
800019ae:	e781                	bnez	a5,800019b6 <strcmp+0x14>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
800019b0:	40e78533          	sub	a0,a5,a4
800019b4:	8082                	ret
		s1++;
800019b6:	0505                	addi	a0,a0,1
		s2++;
800019b8:	0585                	addi	a1,a1,1
800019ba:	b7e5                	j	800019a2 <strcmp>

800019bc <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
800019bc:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
800019c0:	87aa                	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
800019c2:	0037f713          	andi	a4,a5,3
800019c6:	eb1d                	bnez	a4,800019fc <memset+0x40>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
800019c8:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
800019cc:	00859713          	slli	a4,a1,0x8
800019d0:	8dd9                	or	a1,a1,a4
	c_word |= c_word << 16;
800019d2:	01059713          	slli	a4,a1,0x10
800019d6:	8dd9                	or	a1,a1,a4

	while (n >= sizeof(unsigned int)) {
800019d8:	00c78333          	add	t1,a5,a2
800019dc:	873e                	mv	a4,a5
800019de:	480d                	li	a6,3
800019e0:	40e308b3          	sub	a7,t1,a4
800019e4:	03186263          	bltu	a6,a7,80001a08 <memset+0x4c>
800019e8:	00265713          	srli	a4,a2,0x2
800019ec:	00271593          	slli	a1,a4,0x2
800019f0:	97ae                	add	a5,a5,a1
800019f2:	8e0d                	sub	a2,a2,a1
800019f4:	963e                	add	a2,a2,a5

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
800019f6:	00c79d63          	bne	a5,a2,80001a10 <memset+0x54>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
800019fa:	8082                	ret
		if (n == 0) {
800019fc:	de7d                	beqz	a2,800019fa <memset+0x3e>
		*(d_byte++) = c_byte;
800019fe:	0785                	addi	a5,a5,1
80001a00:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001a04:	167d                	addi	a2,a2,-1
80001a06:	bf75                	j	800019c2 <memset+0x6>
		*(d_word++) = c_word;
80001a08:	0711                	addi	a4,a4,4
80001a0a:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80001a0e:	bfc9                	j	800019e0 <memset+0x24>
		*(d_byte++) = c_byte;
80001a10:	0785                	addi	a5,a5,1
80001a12:	fed78fa3          	sb	a3,-1(a5)
		n--;
80001a16:	b7c5                	j	800019f6 <memset+0x3a>

80001a18 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80001a18:	557d                	li	a0,-1
80001a1a:	8082                	ret

80001a1c <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80001a1c:	800057b7          	lui	a5,0x80005
80001a20:	10a7a823          	sw	a0,272(a5) # 80005110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005111>
}
80001a24:	8082                	ret

80001a26 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80001a26:	1101                	addi	sp,sp,-32
80001a28:	cc22                	sw	s0,24(sp)
	test->setup();
80001a2a:	451c                	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80001a2c:	80005437          	lui	s0,0x80005
{
80001a30:	ca26                	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80001a32:	11440413          	addi	s0,s0,276 # 80005114 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005115>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80001a36:	800054b7          	lui	s1,0x80005
{
80001a3a:	ce06                	sw	ra,28(sp)
80001a3c:	c84a                	sw	s2,16(sp)
80001a3e:	c64e                	sw	s3,12(sp)
	test_result = 1;
80001a40:	19448493          	addi	s1,s1,404 # 80005194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005195>
80001a44:	4985                	li	s3,1
	phase = TEST_PHASE_SETUP;
80001a46:	00042023          	sw	zero,0(s0)
{
80001a4a:	892a                	mv	s2,a0
	test_result = 1;
80001a4c:	0134a023          	sw	s3,0(s1)
	test->setup();
80001a50:	9782                	jalr	a5
	test->test();
80001a52:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80001a56:	01342023          	sw	s3,0(s0)
	test->test();
80001a5a:	9782                	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80001a5c:	4789                	li	a5,2
80001a5e:	c01c                	sw	a5,0(s0)
	test->teardown();
80001a60:	00c92783          	lw	a5,12(s2)
80001a64:	9782                	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80001a66:	478d                	li	a5,3
80001a68:	c01c                	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80001a6a:	4462                	lw	s0,24(sp)
	test_result = 0;
80001a6c:	0004a023          	sw	zero,0(s1)
}
80001a70:	40f2                	lw	ra,28(sp)
80001a72:	44d2                	lw	s1,20(sp)
80001a74:	4942                	lw	s2,16(sp)
80001a76:	49b2                	lw	s3,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80001a78:	80005537          	lui	a0,0x80005
80001a7c:	2cc50513          	addi	a0,a0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
80001a80:	6105                	addi	sp,sp,32
80001a82:	1530106f          	j	800033d4 <z_impl_k_sem_give>

80001a86 <ztest_test_fail>:
80001a86:	80005537          	lui	a0,0x80005
{
80001a8a:	1141                	addi	sp,sp,-16
	test_result = -1;
80001a8c:	800057b7          	lui	a5,0x80005
80001a90:	577d                	li	a4,-1
80001a92:	2cc50513          	addi	a0,a0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
{
80001a96:	c606                	sw	ra,12(sp)
	test_result = -1;
80001a98:	18e7aa23          	sw	a4,404(a5) # 80005194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005195>
80001a9c:	139010ef          	jal	ra,800033d4 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001aa0:	08b010ef          	jal	ra,8000332a <z_impl_k_current_get>
}
80001aa4:	40b2                	lw	ra,12(sp)
80001aa6:	0141                	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001aa8:	6870106f          	j	8000392e <z_impl_k_thread_abort>

80001aac <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80001aac:	711d                	addi	sp,sp,-96
80001aae:	caa6                	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80001ab0:	800054b7          	lui	s1,0x80005
80001ab4:	1984a783          	lw	a5,408(s1) # 80005198 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005199>
{
80001ab8:	ce86                	sw	ra,92(sp)
80001aba:	cca2                	sw	s0,88(sp)
80001abc:	c8ca                	sw	s2,80(sp)
80001abe:	c6ce                	sw	s3,76(sp)
80001ac0:	c4d2                	sw	s4,72(sp)
80001ac2:	c2d6                	sw	s5,68(sp)
80001ac4:	c0da                	sw	s6,64(sp)
80001ac6:	de5e                	sw	s7,60(sp)
80001ac8:	dc62                	sw	s8,56(sp)
80001aca:	da66                	sw	s9,52(sp)
80001acc:	d86a                	sw	s10,48(sp)
80001ace:	d66e                	sw	s11,44(sp)
	if (test_status < 0) {
80001ad0:	0607c963          	bltz	a5,80001b42 <z_ztest_run_test_suite+0x96>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80001ad4:	80005437          	lui	s0,0x80005
80001ad8:	4605                	li	a2,1
80001ada:	89aa                	mv	s3,a0
80001adc:	8c2e                	mv	s8,a1
80001ade:	2cc40513          	addi	a0,s0,716 # 800052cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052cd>
80001ae2:	4581                	li	a1,0
80001ae4:	051010ef          	jal	ra,80003334 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80001ae8:	80005537          	lui	a0,0x80005
80001aec:	85ce                	mv	a1,s3
80001aee:	c6850513          	addi	a0,a0,-920 # 80004c68 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c69>
80001af2:	a79ff0ef          	jal	ra,8000156a <printk>
	PRINT_LINE;
80001af6:	80005937          	lui	s2,0x80005
80001afa:	c8090513          	addi	a0,s2,-896 # 80004c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c81>
		Z_TC_END_RESULT(ret, test->name);
80001afe:	80005ab7          	lui	s5,0x80005
	PRINT_LINE;
80001b02:	a69ff0ef          	jal	ra,8000156a <printk>
80001b06:	19848493          	addi	s1,s1,408
	int fail = 0;
80001b0a:	4a01                	li	s4,0
80001b0c:	ce22                	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80001b0e:	80005cb7          	lui	s9,0x80005
80001b12:	80005b37          	lui	s6,0x80005
80001b16:	80002d37          	lui	s10,0x80002
	if (test_result == -1) {
80001b1a:	80005db7          	lui	s11,0x80005
80001b1e:	80005bb7          	lui	s7,0x80005
		Z_TC_END_RESULT(ret, test->name);
80001b22:	c28a8a93          	addi	s5,s5,-984 # 80004c28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c29>
	while (suite->test) {
80001b26:	004c2783          	lw	a5,4(s8)
80001b2a:	eb9d                	bnez	a5,80001b60 <z_ztest_run_test_suite+0xb4>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80001b2c:	85ce                	mv	a1,s3
	if (fail) {
80001b2e:	0c0a0363          	beqz	s4,80001bf4 <z_ztest_run_test_suite+0x148>
		TC_PRINT("Test suite %s failed.\n", name);
80001b32:	80005537          	lui	a0,0x80005
80001b36:	cf050513          	addi	a0,a0,-784 # 80004cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cf1>
80001b3a:	a31ff0ef          	jal	ra,8000156a <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80001b3e:	4785                	li	a5,1
80001b40:	c09c                	sw	a5,0(s1)
}
80001b42:	40f6                	lw	ra,92(sp)
80001b44:	4466                	lw	s0,88(sp)
80001b46:	44d6                	lw	s1,84(sp)
80001b48:	4946                	lw	s2,80(sp)
80001b4a:	49b6                	lw	s3,76(sp)
80001b4c:	4a26                	lw	s4,72(sp)
80001b4e:	4a96                	lw	s5,68(sp)
80001b50:	4b06                	lw	s6,64(sp)
80001b52:	5bf2                	lw	s7,60(sp)
80001b54:	5c62                	lw	s8,56(sp)
80001b56:	5cd2                	lw	s9,52(sp)
80001b58:	5d42                	lw	s10,48(sp)
80001b5a:	5db2                	lw	s11,44(sp)
80001b5c:	6125                	addi	sp,sp,96
80001b5e:	8082                	ret
	TC_START(test->name);
80001b60:	000c2583          	lw	a1,0(s8)
80001b64:	800057b7          	lui	a5,0x80005
80001b68:	cc878513          	addi	a0,a5,-824 # 80004cc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cc9>
80001b6c:	9ffff0ef          	jal	ra,8000156a <printk>
80001b70:	c202                	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80001b72:	010c2783          	lw	a5,16(s8)
80001b76:	8762                	mv	a4,s8
80001b78:	40000613          	li	a2,1024
80001b7c:	0087e793          	ori	a5,a5,8
80001b80:	58fd                	li	a7,-1
80001b82:	4801                	li	a6,0
80001b84:	a26d0693          	addi	a3,s10,-1498 # 80001a26 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001a27>
80001b88:	c03e                	sw	a5,0(sp)
80001b8a:	760c8593          	addi	a1,s9,1888 # 80005760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005761>
80001b8e:	4781                	li	a5,0
80001b90:	2dcb0513          	addi	a0,s6,732 # 800052dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800052dd>
80001b94:	483010ef          	jal	ra,80003816 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80001b98:	47f2                	lw	a5,28(sp)
80001b9a:	55fd                	li	a1,-1
80001b9c:	2cc78513          	addi	a0,a5,716
80001ba0:	0df010ef          	jal	ra,8000347e <z_impl_k_sem_take>
	if (test_result == -1) {
80001ba4:	194d8793          	addi	a5,s11,404 # 80005194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005195>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001ba8:	2dcb0513          	addi	a0,s6,732
80001bac:	4380                	lw	s0,0(a5)
80001bae:	581010ef          	jal	ra,8000392e <z_impl_k_thread_abort>
	if (test_result == -2) {
80001bb2:	800057b7          	lui	a5,0x80005
80001bb6:	19478793          	addi	a5,a5,404 # 80005194 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005195>
80001bba:	4398                	lw	a4,0(a5)
	if (test_result == -1) {
80001bbc:	0405                	addi	s0,s0,1
	if (test_result == -2) {
80001bbe:	57f9                	li	a5,-2
	if (test_result == -1) {
80001bc0:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80001bc4:	000c2603          	lw	a2,0(s8)
80001bc8:	02f71163          	bne	a4,a5,80001bea <z_ztest_run_test_suite+0x13e>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80001bcc:	800055b7          	lui	a1,0x80005
80001bd0:	cdc58593          	addi	a1,a1,-804 # 80004cdc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004cdd>
		Z_TC_END_RESULT(ret, test->name);
80001bd4:	ce4b8513          	addi	a0,s7,-796 # 80004ce4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ce5>
80001bd8:	993ff0ef          	jal	ra,8000156a <printk>
80001bdc:	c8090513          	addi	a0,s2,-896
80001be0:	98bff0ef          	jal	ra,8000156a <printk>
		fail += run_test(suite);
80001be4:	9a22                	add	s4,s4,s0
		suite++;
80001be6:	0c51                	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80001be8:	bf3d                	j	80001b26 <z_ztest_run_test_suite+0x7a>
		Z_TC_END_RESULT(ret, test->name);
80001bea:	00241793          	slli	a5,s0,0x2
80001bee:	97d6                	add	a5,a5,s5
80001bf0:	438c                	lw	a1,0(a5)
80001bf2:	b7cd                	j	80001bd4 <z_ztest_run_test_suite+0x128>
		TC_PRINT("Test suite %s succeeded\n", name);
80001bf4:	80005537          	lui	a0,0x80005
80001bf8:	d0850513          	addi	a0,a0,-760 # 80004d08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d09>
80001bfc:	96fff0ef          	jal	ra,8000156a <printk>
	test_status = (test_status || fail) ? 1 : 0;
80001c00:	409c                	lw	a5,0(s1)
80001c02:	00f037b3          	snez	a5,a5
80001c06:	bf2d                	j	80001b40 <z_ztest_run_test_suite+0x94>

80001c08 <end_report>:

void end_report(void)
{
	if (test_status) {
80001c08:	800057b7          	lui	a5,0x80005
80001c0c:	1987a783          	lw	a5,408(a5) # 80005198 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005199>
{
80001c10:	1141                	addi	sp,sp,-16
80001c12:	c422                	sw	s0,8(sp)
80001c14:	80005537          	lui	a0,0x80005
80001c18:	c606                	sw	ra,12(sp)
80001c1a:	80005437          	lui	s0,0x80005
		TC_END_REPORT(TC_FAIL);
80001c1e:	c8050513          	addi	a0,a0,-896 # 80004c80 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c81>
	if (test_status) {
80001c22:	cf91                	beqz	a5,80001c3e <end_report+0x36>
		TC_END_REPORT(TC_FAIL);
80001c24:	947ff0ef          	jal	ra,8000156a <printk>
80001c28:	800055b7          	lui	a1,0x80005
80001c2c:	c3458593          	addi	a1,a1,-972 # 80004c34 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c35>
	} else {
		TC_END_REPORT(TC_PASS);
80001c30:	c3c40513          	addi	a0,s0,-964 # 80004c3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c3d>
	}
}
80001c34:	4422                	lw	s0,8(sp)
80001c36:	40b2                	lw	ra,12(sp)
80001c38:	0141                	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80001c3a:	931ff06f          	j	8000156a <printk>
80001c3e:	92dff0ef          	jal	ra,8000156a <printk>
80001c42:	800055b7          	lui	a1,0x80005
80001c46:	c5458593          	addi	a1,a1,-940 # 80004c54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c55>
80001c4a:	b7dd                	j	80001c30 <end_report+0x28>

80001c4c <main>:

	return test_status;
}
#else
void main(void)
{
80001c4c:	1141                	addi	sp,sp,-16
80001c4e:	c606                	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80001c50:	91cff0ef          	jal	ra,80000d6c <test_main>
	end_report();
}
80001c54:	40b2                	lw	ra,12(sp)
80001c56:	0141                	addi	sp,sp,16
	end_report();
80001c58:	bf45                	j	80001c08 <end_report>

80001c5a <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80001c5a:	1141                	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80001c5c:	c602                	sw	zero,12(sp)
    i++;
80001c5e:	47b2                	lw	a5,12(sp)
80001c60:	0785                	addi	a5,a5,1
80001c62:	c63e                	sw	a5,12(sp)
    uart[0] = c;
80001c64:	f00107b7          	lui	a5,0xf0010
80001c68:	c38c                	sw	a1,0(a5)
}
80001c6a:	0141                	addi	sp,sp,16
80001c6c:	8082                	ret

80001c6e <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80001c6e:	557d                	li	a0,-1
80001c70:	8082                	ret

80001c72 <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80001c72:	4501                	li	a0,0
80001c74:	8082                	ret

80001c76 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80001c76:	00251713          	slli	a4,a0,0x2
80001c7a:	800057b7          	lui	a5,0x80005
80001c7e:	0505                	addi	a0,a0,1
80001c80:	d3878793          	addi	a5,a5,-712 # 80004d38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d39>
80001c84:	050a                	slli	a0,a0,0x2
{
80001c86:	1141                	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80001c88:	973e                	add	a4,a4,a5
80001c8a:	97aa                	add	a5,a5,a0
{
80001c8c:	c422                	sw	s0,8(sp)
80001c8e:	c226                	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001c90:	4300                	lw	s0,0(a4)
80001c92:	4384                	lw	s1,0(a5)
{
80001c94:	c606                	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80001c96:	00946763          	bltu	s0,s1,80001ca4 <z_sys_device_do_config_level+0x2e>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80001c9a:	40b2                	lw	ra,12(sp)
80001c9c:	4422                	lw	s0,8(sp)
80001c9e:	4492                	lw	s1,4(sp)
80001ca0:	0141                	addi	sp,sp,16
80001ca2:	8082                	ret
		retval = device_conf->init(info);
80001ca4:	401c                	lw	a5,0(s0)
80001ca6:	8522                	mv	a0,s0
80001ca8:	43dc                	lw	a5,4(a5)
80001caa:	9782                	jalr	a5
		if (retval != 0) {
80001cac:	c119                	beqz	a0,80001cb2 <z_sys_device_do_config_level+0x3c>
			info->driver_api = NULL;
80001cae:	00042223          	sw	zero,4(s0)
								info++) {
80001cb2:	0431                	addi	s0,s0,12
80001cb4:	b7cd                	j	80001c96 <z_sys_device_do_config_level+0x20>

80001cb6 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80001cb6:	1141                	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cb8:	800057b7          	lui	a5,0x80005
{
80001cbc:	c226                	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cbe:	800054b7          	lui	s1,0x80005
{
80001cc2:	c422                	sw	s0,8(sp)
80001cc4:	c606                	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cc6:	12c78413          	addi	s0,a5,300 # 8000512c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000512d>
{
80001cca:	c04a                	sw	s2,0(sp)
80001ccc:	12c78793          	addi	a5,a5,300
80001cd0:	15c48493          	addi	s1,s1,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cd4:	00941863          	bne	s0,s1,80001ce4 <z_impl_device_get_binding+0x2e>
80001cd8:	892a                	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80001cda:	843e                	mv	s0,a5
80001cdc:	00941c63          	bne	s0,s1,80001cf4 <z_impl_device_get_binding+0x3e>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80001ce0:	4401                	li	s0,0
80001ce2:	a015                	j	80001d06 <z_impl_device_get_binding+0x50>
		if ((info->driver_api != NULL) &&
80001ce4:	4058                	lw	a4,4(s0)
80001ce6:	c709                	beqz	a4,80001cf0 <z_impl_device_get_binding+0x3a>
		    (info->config->name == name)) {
80001ce8:	4018                	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
80001cea:	4318                	lw	a4,0(a4)
80001cec:	00a70d63          	beq	a4,a0,80001d06 <z_impl_device_get_binding+0x50>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cf0:	0431                	addi	s0,s0,12
80001cf2:	b7cd                	j	80001cd4 <z_impl_device_get_binding+0x1e>
		if (info->driver_api == NULL) {
80001cf4:	405c                	lw	a5,4(s0)
80001cf6:	e399                	bnez	a5,80001cfc <z_impl_device_get_binding+0x46>
	for (info = __device_init_start; info != __device_init_end; info++) {
80001cf8:	0431                	addi	s0,s0,12
80001cfa:	b7cd                	j	80001cdc <z_impl_device_get_binding+0x26>
		if (strcmp(name, info->config->name) == 0) {
80001cfc:	401c                	lw	a5,0(s0)
80001cfe:	854a                	mv	a0,s2
80001d00:	438c                	lw	a1,0(a5)
80001d02:	3145                	jal	800019a2 <strcmp>
80001d04:	f975                	bnez	a0,80001cf8 <z_impl_device_get_binding+0x42>
}
80001d06:	8522                	mv	a0,s0
80001d08:	40b2                	lw	ra,12(sp)
80001d0a:	4422                	lw	s0,8(sp)
80001d0c:	4492                	lw	s1,4(sp)
80001d0e:	4902                	lw	s2,0(sp)
80001d10:	0141                	addi	sp,sp,16
80001d12:	8082                	ret

80001d14 <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
80001d14:	1141                	addi	sp,sp,-16
80001d16:	c422                	sw	s0,8(sp)
80001d18:	c226                	sw	s1,4(sp)
80001d1a:	c606                	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80001d1c:	4421                	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001d1e:	4489                	li	s1,2
80001d20:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
80001d24:	7ed010ef          	jal	ra,80003d10 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
80001d28:	00a4c363          	blt	s1,a0,80001d2e <idle+0x1a>
80001d2c:	4505                	li	a0,1
80001d2e:	4585                	li	a1,1
80001d30:	09a020ef          	jal	ra,80003dca <z_set_timeout_expiry>
	k_cpu_idle();
80001d34:	87dff0ef          	jal	ra,800015b0 <k_cpu_idle>
80001d38:	b7e5                	j	80001d20 <idle+0xc>

80001d3a <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
80001d3a:	80005537          	lui	a0,0x80005
80001d3e:	800057b7          	lui	a5,0x80005
80001d42:	17050613          	addi	a2,a0,368 # 80005170 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005171>
80001d46:	45878793          	addi	a5,a5,1112 # 80005458 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005459>
80001d4a:	40c78633          	sub	a2,a5,a2
80001d4e:	4581                	li	a1,0
80001d50:	17050513          	addi	a0,a0,368
80001d54:	b1a5                	j	800019bc <memset>

80001d56 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
80001d56:	1141                	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001d58:	4509                	li	a0,2
{
80001d5a:	c606                	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80001d5c:	3f29                	jal	80001c76 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80001d5e:	80005537          	lui	a0,0x80005
80001d62:	d4c50513          	addi	a0,a0,-692 # 80004d4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d4d>
80001d66:	805ff0ef          	jal	ra,8000156a <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80001d6a:	450d                	li	a0,3
80001d6c:	3729                	jal	80001c76 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80001d6e:	349010ef          	jal	ra,800038b6 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
80001d72:	3de9                	jal	80001c4c <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80001d74:	800057b7          	lui	a5,0x80005
80001d78:	3bc78793          	addi	a5,a5,956 # 800053bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053bd>
80001d7c:	00c7c703          	lbu	a4,12(a5)
80001d80:	9b79                	andi	a4,a4,-2
80001d82:	00e78623          	sb	a4,12(a5)
}
80001d86:	40b2                	lw	ra,12(sp)
80001d88:	0141                	addi	sp,sp,16
80001d8a:	8082                	ret

80001d8c <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80001d8c:	7135                	addi	sp,sp,-160
80001d8e:	cd22                	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80001d90:	800067b7          	lui	a5,0x80006
80001d94:	80005437          	lui	s0,0x80005
80001d98:	c74e                	sw	s3,140(sp)
80001d9a:	76078793          	addi	a5,a5,1888 # 80006760 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006761>
80001d9e:	42c40993          	addi	s3,s0,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80001da2:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80001da6:	081c                	addi	a5,sp,16
80001da8:	07000613          	li	a2,112
80001dac:	4581                	li	a1,0
80001dae:	853e                	mv	a0,a5
{
80001db0:	cf06                	sw	ra,156(sp)
80001db2:	cb26                	sw	s1,148(sp)
80001db4:	c94a                	sw	s2,144(sp)
	struct k_thread dummy_thread = {
80001db6:	3119                	jal	800019bc <memset>
80001db8:	4705                	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80001dba:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001dbe:	4501                	li	a0,0
	struct k_thread dummy_thread = {
80001dc0:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80001dc4:	3d4d                	jal	80001c76 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80001dc6:	4505                	li	a0,1
80001dc8:	357d                	jal	80001c76 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
80001dca:	10100793          	li	a5,257
80001dce:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
80001dd2:	0be010ef          	jal	ra,80002e90 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
80001dd6:	800057b7          	lui	a5,0x80005
80001dda:	d9078793          	addi	a5,a5,-624 # 80004d90 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d91>
	_kernel.ready_q.cache = _main_thread;
80001dde:	80005937          	lui	s2,0x80005
	z_setup_new_thread(_main_thread, _main_stack,
80001de2:	c23e                	sw	a5,4(sp)
80001de4:	800026b7          	lui	a3,0x80002
80001de8:	4785                	li	a5,1
80001dea:	800065b7          	lui	a1,0x80006
	_kernel.ready_q.cache = _main_thread;
80001dee:	3bc90493          	addi	s1,s2,956 # 800053bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800053bd>
	z_setup_new_thread(_main_thread, _main_stack,
80001df2:	c03e                	sw	a5,0(sp)
80001df4:	4701                	li	a4,0
80001df6:	4781                	li	a5,0
80001df8:	4881                	li	a7,0
80001dfa:	4801                	li	a6,0
80001dfc:	d5668693          	addi	a3,a3,-682 # 80001d56 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001d57>
80001e00:	20000613          	li	a2,512
80001e04:	b6058593          	addi	a1,a1,-1184 # 80005b60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005b61>
80001e08:	3bc90513          	addi	a0,s2,956
	_kernel.ready_q.cache = _main_thread;
80001e0c:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
80001e10:	013010ef          	jal	ra,80003622 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001e14:	00d4c783          	lbu	a5,13(s1)
80001e18:	42c40413          	addi	s0,s0,1068
80001e1c:	ffb7f713          	andi	a4,a5,-5
80001e20:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80001e24:	8bed                	andi	a5,a5,27
80001e26:	e799                	bnez	a5,80001e34 <z_cstart+0xa8>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
80001e28:	4c9c                	lw	a5,24(s1)
80001e2a:	e789                	bnez	a5,80001e34 <z_cstart+0xa8>
		z_add_thread_to_ready_q(thread);
80001e2c:	3bc90513          	addi	a0,s2,956
80001e30:	706000ef          	jal	ra,80002536 <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
80001e34:	800057b7          	lui	a5,0x80005
80001e38:	d9878793          	addi	a5,a5,-616 # 80004d98 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004d99>
80001e3c:	c23e                	sw	a5,4(sp)
80001e3e:	80005537          	lui	a0,0x80005
80001e42:	4785                	li	a5,1
80001e44:	800026b7          	lui	a3,0x80002
80001e48:	800065b7          	lui	a1,0x80006
80001e4c:	34c50493          	addi	s1,a0,844 # 8000534c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000534d>
80001e50:	c03e                	sw	a5,0(sp)
80001e52:	48bd                	li	a7,15
80001e54:	4801                	li	a6,0
80001e56:	4781                	li	a5,0
80001e58:	4701                	li	a4,0
80001e5a:	d1468693          	addi	a3,a3,-748 # 80001d14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001d15>
80001e5e:	20000613          	li	a2,512
80001e62:	d6058593          	addi	a1,a1,-672 # 80005d60 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d61>
80001e66:	34c50513          	addi	a0,a0,844
80001e6a:	7b8010ef          	jal	ra,80003622 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80001e6e:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80001e72:	c444                	sw	s1,12(s0)
80001e74:	4521                	li	a0,8
80001e76:	9bed                	andi	a5,a5,-5
80001e78:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80001e7c:	800057b7          	lui	a5,0x80005
80001e80:	44478793          	addi	a5,a5,1092 # 80005444 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005445>
80001e84:	cc1c                	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80001e86:	cc5c                	sw	a5,28(s0)
80001e88:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
80001e8c:	8921                	andi	a0,a0,8
80001e8e:	b42fe0ef          	jal	ra,800001d0 <__swap>

80001e92 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80001e92:	00d54783          	lbu	a5,13(a0)
80001e96:	8bfd                	andi	a5,a5,31
80001e98:	e789                	bnez	a5,80001ea2 <z_is_thread_ready+0x10>
80001e9a:	4d08                	lw	a0,24(a0)
80001e9c:	00153513          	seqz	a0,a0
80001ea0:	8082                	ret
80001ea2:	4501                	li	a0,0
}
80001ea4:	8082                	ret

80001ea6 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
80001ea6:	1141                	addi	sp,sp,-16
80001ea8:	c606                	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80001eaa:	a39ff0ef          	jal	ra,800018e2 <z_clock_elapsed>
80001eae:	800057b7          	lui	a5,0x80005
80001eb2:	1a47a783          	lw	a5,420(a5) # 800051a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a5>

	z_set_timeout_expiry(slice_time, false);
}
80001eb6:	40b2                	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
80001eb8:	80005737          	lui	a4,0x80005
80001ebc:	953e                	add	a0,a0,a5
80001ebe:	42a72e23          	sw	a0,1084(a4) # 8000543c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000543d>
	z_set_timeout_expiry(slice_time, false);
80001ec2:	4581                	li	a1,0
80001ec4:	853e                	mv	a0,a5
}
80001ec6:	0141                	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
80001ec8:	7030106f          	j	80003dca <z_set_timeout_expiry>

80001ecc <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
80001ecc:	411c                	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
80001ece:	1141                	addi	sp,sp,-16
80001ed0:	c422                	sw	s0,8(sp)
80001ed2:	c606                	sw	ra,12(sp)
80001ed4:	c226                	sw	s1,4(sp)
80001ed6:	842a                	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80001ed8:	e79d                	bnez	a5,80001f06 <pended_on.isra.15+0x3a>
80001eda:	800054b7          	lui	s1,0x80005
80001ede:	800055b7          	lui	a1,0x80005
80001ee2:	80005537          	lui	a0,0x80005
80001ee6:	e3c58593          	addi	a1,a1,-452 # 80004e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e3d>
80001eea:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80001eee:	18300693          	li	a3,387
80001ef2:	e2848613          	addi	a2,s1,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80001ef6:	e74ff0ef          	jal	ra,8000156a <printk>
80001efa:	18300593          	li	a1,387
80001efe:	e2848513          	addi	a0,s1,-472
80001f02:	e86ff0ef          	jal	ra,80001588 <assert_post_action>

	return thread->base.pended_on;
}
80001f06:	4008                	lw	a0,0(s0)
80001f08:	40b2                	lw	ra,12(sp)
80001f0a:	4422                	lw	s0,8(sp)
80001f0c:	4492                	lw	s1,4(sp)
80001f0e:	0141                	addi	sp,sp,16
80001f10:	8082                	ret

80001f12 <k_sched_time_slice_set>:
{
80001f12:	1101                	addi	sp,sp,-32
80001f14:	cc22                	sw	s0,24(sp)
80001f16:	c64e                	sw	s3,12(sp)
80001f18:	c452                	sw	s4,8(sp)
80001f1a:	ce06                	sw	ra,28(sp)
80001f1c:	ca26                	sw	s1,20(sp)
80001f1e:	c84a                	sw	s2,16(sp)
80001f20:	8a2a                	mv	s4,a0
80001f22:	89ae                	mv	s3,a1
80001f24:	4421                	li	s0,8
80001f26:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80001f2a:	800054b7          	lui	s1,0x80005
80001f2e:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80001f32:	8821                	andi	s0,s0,8
80001f34:	776010ef          	jal	ra,800036aa <z_spin_lock_valid>
80001f38:	ed0d                	bnez	a0,80001f72 <k_sched_time_slice_set+0x60>
80001f3a:	80005937          	lui	s2,0x80005
80001f3e:	800055b7          	lui	a1,0x80005
80001f42:	80005537          	lui	a0,0x80005
80001f46:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80001f4a:	04e00693          	li	a3,78
80001f4e:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80001f52:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80001f56:	e14ff0ef          	jal	ra,8000156a <printk>
80001f5a:	80005537          	lui	a0,0x80005
80001f5e:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80001f62:	e08ff0ef          	jal	ra,8000156a <printk>
80001f66:	04e00593          	li	a1,78
80001f6a:	bb490513          	addi	a0,s2,-1100
80001f6e:	e1aff0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80001f72:	19c48513          	addi	a0,s1,412
80001f76:	770010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
80001f7a:	800057b7          	lui	a5,0x80005
		CONFIG_SYS_CLOCK_TICKS_PER_SEC);
#else
	/* simple division keeps precision */
	s32_t ms_per_tick = MSEC_PER_SEC / CONFIG_SYS_CLOCK_TICKS_PER_SEC;

	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80001f7e:	45a9                	li	a1,10
80001f80:	009a0513          	addi	a0,s4,9
80001f84:	4207ae23          	sw	zero,1084(a5) # 8000543c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000543d>
80001f88:	959fe0ef          	jal	ra,800008e0 <__divsi3>
		slice_max_prio = prio;
80001f8c:	800057b7          	lui	a5,0x80005
		slice_time = z_ms_to_ticks(slice);
80001f90:	80005937          	lui	s2,0x80005
80001f94:	1aa92223          	sw	a0,420(s2) # 800051a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a5>
		slice_max_prio = prio;
80001f98:	1b37a023          	sw	s3,416(a5) # 800051a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a1>
		reset_time_slice();
80001f9c:	3729                	jal	80001ea6 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80001f9e:	19c48513          	addi	a0,s1,412
80001fa2:	722010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80001fa6:	ed0d                	bnez	a0,80001fe0 <k_sched_time_slice_set+0xce>
80001fa8:	800054b7          	lui	s1,0x80005
80001fac:	800055b7          	lui	a1,0x80005
80001fb0:	80005537          	lui	a0,0x80005
80001fb4:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80001fb8:	06100693          	li	a3,97
80001fbc:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80001fc0:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80001fc4:	da6ff0ef          	jal	ra,8000156a <printk>
80001fc8:	80005537          	lui	a0,0x80005
80001fcc:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80001fd0:	d9aff0ef          	jal	ra,8000156a <printk>
80001fd4:	06100593          	li	a1,97
80001fd8:	bb448513          	addi	a0,s1,-1100
80001fdc:	dacff0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80001fe0:	30042473          	csrrs	s0,mstatus,s0
}
80001fe4:	40f2                	lw	ra,28(sp)
80001fe6:	4462                	lw	s0,24(sp)
80001fe8:	44d2                	lw	s1,20(sp)
80001fea:	4942                	lw	s2,16(sp)
80001fec:	49b2                	lw	s3,12(sp)
80001fee:	4a22                	lw	s4,8(sp)
80001ff0:	6105                	addi	sp,sp,32
80001ff2:	8082                	ret

80001ff4 <z_unpend_thread_no_timeout>:

	return ret;
}

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80001ff4:	1101                	addi	sp,sp,-32
80001ff6:	cc22                	sw	s0,24(sp)
80001ff8:	c84a                	sw	s2,16(sp)
80001ffa:	ce06                	sw	ra,28(sp)
80001ffc:	ca26                	sw	s1,20(sp)
80001ffe:	c64e                	sw	s3,12(sp)
80002000:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002002:	4421                	li	s0,8
80002004:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002008:	800054b7          	lui	s1,0x80005
8000200c:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002010:	8821                	andi	s0,s0,8
80002012:	698010ef          	jal	ra,800036aa <z_spin_lock_valid>
80002016:	ed0d                	bnez	a0,80002050 <z_unpend_thread_no_timeout+0x5c>
80002018:	800059b7          	lui	s3,0x80005
8000201c:	800055b7          	lui	a1,0x80005
80002020:	80005537          	lui	a0,0x80005
80002024:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80002028:	04e00693          	li	a3,78
8000202c:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002030:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002034:	d36ff0ef          	jal	ra,8000156a <printk>
80002038:	80005537          	lui	a0,0x80005
8000203c:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002040:	d2aff0ef          	jal	ra,8000156a <printk>
80002044:	04e00593          	li	a1,78
80002048:	bb498513          	addi	a0,s3,-1100
8000204c:	d3cff0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80002050:	19c48513          	addi	a0,s1,412
80002054:	692010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002058:	00890513          	addi	a0,s2,8
8000205c:	3d85                	jal	80001ecc <pended_on.isra.15>
8000205e:	85ca                	mv	a1,s2
80002060:	2451                	jal	800022e4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002062:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002066:	19c48513          	addi	a0,s1,412
8000206a:	9bf5                	andi	a5,a5,-3
8000206c:	00f906a3          	sb	a5,13(s2)
80002070:	654010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002074:	ed0d                	bnez	a0,800020ae <z_unpend_thread_no_timeout+0xba>
80002076:	800054b7          	lui	s1,0x80005
8000207a:	800055b7          	lui	a1,0x80005
8000207e:	80005537          	lui	a0,0x80005
80002082:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002086:	06100693          	li	a3,97
8000208a:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000208e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002092:	cd8ff0ef          	jal	ra,8000156a <printk>
80002096:	80005537          	lui	a0,0x80005
8000209a:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000209e:	cccff0ef          	jal	ra,8000156a <printk>
800020a2:	06100593          	li	a1,97
800020a6:	bb448513          	addi	a0,s1,-1100
800020aa:	cdeff0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800020ae:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
800020b2:	40f2                	lw	ra,28(sp)
800020b4:	4462                	lw	s0,24(sp)
	thread->base.pended_on = NULL;
800020b6:	00092423          	sw	zero,8(s2)
}
800020ba:	44d2                	lw	s1,20(sp)
800020bc:	4942                	lw	s2,16(sp)
800020be:	49b2                	lw	s3,12(sp)
800020c0:	6105                	addi	sp,sp,32
800020c2:	8082                	ret

800020c4 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
800020c4:	800057b7          	lui	a5,0x80005
800020c8:	42c7a783          	lw	a5,1068(a5) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
{
800020cc:	1141                	addi	sp,sp,-16
800020ce:	c422                	sw	s0,8(sp)
800020d0:	c606                	sw	ra,12(sp)
800020d2:	c226                	sw	s1,4(sp)
800020d4:	842e                	mv	s0,a1
	if (resched()) {
800020d6:	e7b9                	bnez	a5,80002124 <z_reschedule+0x60>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800020d8:	5ec010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
800020dc:	ed0d                	bnez	a0,80002116 <z_reschedule+0x52>
800020de:	800054b7          	lui	s1,0x80005
800020e2:	800055b7          	lui	a1,0x80005
800020e6:	80005537          	lui	a0,0x80005
800020ea:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
800020ee:	07800693          	li	a3,120
800020f2:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800020f6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800020fa:	c70ff0ef          	jal	ra,8000156a <printk>
800020fe:	80005537          	lui	a0,0x80005
80002102:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002106:	c64ff0ef          	jal	ra,8000156a <printk>
8000210a:	07800593          	li	a1,120
8000210e:	bb448513          	addi	a0,s1,-1100
80002112:	c76ff0ef          	jal	ra,80001588 <assert_post_action>
80002116:	8522                	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
80002118:	4422                	lw	s0,8(sp)
8000211a:	40b2                	lw	ra,12(sp)
8000211c:	4492                	lw	s1,4(sp)
8000211e:	0141                	addi	sp,sp,16
80002120:	8b0fe06f          	j	800001d0 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002124:	5a0010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002128:	ed0d                	bnez	a0,80002162 <z_reschedule+0x9e>
8000212a:	800054b7          	lui	s1,0x80005
8000212e:	800055b7          	lui	a1,0x80005
80002132:	80005537          	lui	a0,0x80005
80002136:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
8000213a:	06100693          	li	a3,97
8000213e:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002142:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002146:	c24ff0ef          	jal	ra,8000156a <printk>
8000214a:	80005537          	lui	a0,0x80005
8000214e:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002152:	c18ff0ef          	jal	ra,8000156a <printk>
80002156:	06100593          	li	a1,97
8000215a:	bb448513          	addi	a0,s1,-1100
8000215e:	c2aff0ef          	jal	ra,80001588 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
80002162:	8821                	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002164:	30042473          	csrrs	s0,mstatus,s0
80002168:	40b2                	lw	ra,12(sp)
8000216a:	4422                	lw	s0,8(sp)
8000216c:	4492                	lw	s1,4(sp)
8000216e:	0141                	addi	sp,sp,16
80002170:	8082                	ret

80002172 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80002172:	80005737          	lui	a4,0x80005
80002176:	42c72703          	lw	a4,1068(a4) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
8000217a:	e319                	bnez	a4,80002180 <z_reschedule_irqlock+0xe>
8000217c:	854fe06f          	j	800001d0 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80002180:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002184:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
80002188:	8082                	ret

8000218a <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000218a:	4521                	li	a0,8
8000218c:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80002190:	8921                	andi	a0,a0,8
80002192:	b7c5                	j	80002172 <z_reschedule_irqlock>

80002194 <k_sched_lock>:

void k_sched_lock(void)
{
80002194:	1101                	addi	sp,sp,-32
80002196:	cc22                	sw	s0,24(sp)
80002198:	ce06                	sw	ra,28(sp)
8000219a:	ca26                	sw	s1,20(sp)
8000219c:	c84a                	sw	s2,16(sp)
8000219e:	c64e                	sw	s3,12(sp)
800021a0:	4421                	li	s0,8
800021a2:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800021a6:	800054b7          	lui	s1,0x80005
800021aa:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
800021ae:	8821                	andi	s0,s0,8
800021b0:	4fa010ef          	jal	ra,800036aa <z_spin_lock_valid>
800021b4:	ed0d                	bnez	a0,800021ee <k_sched_lock+0x5a>
800021b6:	80005937          	lui	s2,0x80005
800021ba:	800055b7          	lui	a1,0x80005
800021be:	80005537          	lui	a0,0x80005
800021c2:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800021c6:	04e00693          	li	a3,78
800021ca:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800021ce:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800021d2:	b98ff0ef          	jal	ra,8000156a <printk>
800021d6:	80005537          	lui	a0,0x80005
800021da:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800021de:	b8cff0ef          	jal	ra,8000156a <printk>
800021e2:	04e00593          	li	a1,78
800021e6:	bb490513          	addi	a0,s2,-1100
800021ea:	b9eff0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800021ee:	19c48513          	addi	a0,s1,412
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800021f2:	80005937          	lui	s2,0x80005
800021f6:	4f0010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
800021fa:	42c92783          	lw	a5,1068(s2) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800021fe:	42c90913          	addi	s2,s2,1068
80002202:	cf8d                	beqz	a5,8000223c <k_sched_lock+0xa8>
80002204:	800059b7          	lui	s3,0x80005
80002208:	800055b7          	lui	a1,0x80005
8000220c:	80005537          	lui	a0,0x80005
80002210:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80002214:	10000693          	li	a3,256
80002218:	da098613          	addi	a2,s3,-608 # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
8000221c:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002220:	b4aff0ef          	jal	ra,8000156a <printk>
80002224:	80005537          	lui	a0,0x80005
80002228:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
8000222c:	b3eff0ef          	jal	ra,8000156a <printk>
80002230:	10000593          	li	a1,256
80002234:	da098513          	addi	a0,s3,-608
80002238:	b50ff0ef          	jal	ra,80001588 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
8000223c:	00892783          	lw	a5,8(s2)
80002240:	00f7c703          	lbu	a4,15(a5)
80002244:	4785                	li	a5,1
80002246:	02f71e63          	bne	a4,a5,80002282 <k_sched_lock+0xee>
8000224a:	800059b7          	lui	s3,0x80005
8000224e:	800055b7          	lui	a1,0x80005
80002252:	80005537          	lui	a0,0x80005
80002256:	dd858593          	addi	a1,a1,-552 # 80004dd8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd9>
8000225a:	10100693          	li	a3,257
8000225e:	da098613          	addi	a2,s3,-608 # 80004da0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004da1>
80002262:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002266:	b04ff0ef          	jal	ra,8000156a <printk>
8000226a:	80005537          	lui	a0,0x80005
8000226e:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80002272:	af8ff0ef          	jal	ra,8000156a <printk>
80002276:	10100593          	li	a1,257
8000227a:	da098513          	addi	a0,s3,-608
8000227e:	b0aff0ef          	jal	ra,80001588 <assert_post_action>

	--_current->base.sched_locked;
80002282:	00892703          	lw	a4,8(s2)
80002286:	00f74783          	lbu	a5,15(a4)
8000228a:	17fd                	addi	a5,a5,-1
8000228c:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002290:	19c48513          	addi	a0,s1,412
80002294:	430010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002298:	ed0d                	bnez	a0,800022d2 <k_sched_lock+0x13e>
8000229a:	800054b7          	lui	s1,0x80005
8000229e:	800055b7          	lui	a1,0x80005
800022a2:	80005537          	lui	a0,0x80005
800022a6:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
800022aa:	06100693          	li	a3,97
800022ae:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800022b2:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800022b6:	ab4ff0ef          	jal	ra,8000156a <printk>
800022ba:	80005537          	lui	a0,0x80005
800022be:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
800022c2:	aa8ff0ef          	jal	ra,8000156a <printk>
800022c6:	06100593          	li	a1,97
800022ca:	bb448513          	addi	a0,s1,-1100
800022ce:	abaff0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800022d2:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
800022d6:	40f2                	lw	ra,28(sp)
800022d8:	4462                	lw	s0,24(sp)
800022da:	44d2                	lw	s1,20(sp)
800022dc:	4942                	lw	s2,16(sp)
800022de:	49b2                	lw	s3,12(sp)
800022e0:	6105                	addi	sp,sp,32
800022e2:	8082                	ret

800022e4 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800022e4:	800057b7          	lui	a5,0x80005
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800022e8:	1287a783          	lw	a5,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
{
800022ec:	1141                	addi	sp,sp,-16
800022ee:	c422                	sw	s0,8(sp)
800022f0:	c606                	sw	ra,12(sp)
800022f2:	c226                	sw	s1,4(sp)
800022f4:	842e                	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800022f6:	02f59863          	bne	a1,a5,80002326 <z_priq_dumb_remove+0x42>
800022fa:	800054b7          	lui	s1,0x80005
800022fe:	800055b7          	lui	a1,0x80005
80002302:	80005537          	lui	a0,0x80005
80002306:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
8000230a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000230e:	28c00693          	li	a3,652
80002312:	e2848613          	addi	a2,s1,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002316:	a54ff0ef          	jal	ra,8000156a <printk>
8000231a:	28c00593          	li	a1,652
8000231e:	e2848513          	addi	a0,s1,-472
80002322:	a66ff0ef          	jal	ra,80001588 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80002326:	4058                	lw	a4,4(s0)
80002328:	401c                	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000232a:	40b2                	lw	ra,12(sp)
8000232c:	4492                	lw	s1,4(sp)
8000232e:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80002330:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80002332:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80002336:	00042223          	sw	zero,4(s0)
8000233a:	4422                	lw	s0,8(sp)
8000233c:	0141                	addi	sp,sp,16
8000233e:	8082                	ret

80002340 <z_priq_dumb_best>:
	return list->head == list;
80002340:	411c                	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002342:	00f51363          	bne	a0,a5,80002348 <z_priq_dumb_best+0x8>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80002346:	4781                	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
80002348:	853e                	mv	a0,a5
8000234a:	8082                	ret

8000234c <update_cache>:
{
8000234c:	1141                	addi	sp,sp,-16
8000234e:	c422                	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002350:	80005437          	lui	s0,0x80005
{
80002354:	c04a                	sw	s2,0(sp)
80002356:	892a                	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002358:	42c40513          	addi	a0,s0,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
8000235c:	02450513          	addi	a0,a0,36
{
80002360:	c226                	sw	s1,4(sp)
80002362:	c606                	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80002364:	3ff1                	jal	80002340 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
80002366:	42c40413          	addi	s0,s0,1068
8000236a:	84aa                	mv	s1,a0
8000236c:	e111                	bnez	a0,80002370 <update_cache+0x24>
8000236e:	4444                	lw	s1,12(s0)
	if (preempt_ok != 0) {
80002370:	06091263          	bnez	s2,800023d4 <update_cache+0x88>
	__ASSERT(_current != NULL, "");
80002374:	441c                	lw	a5,8(s0)
80002376:	ef8d                	bnez	a5,800023b0 <update_cache+0x64>
80002378:	80005937          	lui	s2,0x80005
8000237c:	800055b7          	lui	a1,0x80005
80002380:	80005537          	lui	a0,0x80005
80002384:	e5458593          	addi	a1,a1,-428 # 80004e54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e55>
80002388:	07f00693          	li	a3,127
8000238c:	e2890613          	addi	a2,s2,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002390:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002394:	9d6ff0ef          	jal	ra,8000156a <printk>
80002398:	80005537          	lui	a0,0x80005
8000239c:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
800023a0:	9caff0ef          	jal	ra,8000156a <printk>
800023a4:	07f00593          	li	a1,127
800023a8:	e2890513          	addi	a0,s2,-472
800023ac:	9dcff0ef          	jal	ra,80001588 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
800023b0:	441c                	lw	a5,8(s0)
800023b2:	00d7c703          	lbu	a4,13(a5)
800023b6:	8b7d                	andi	a4,a4,31
800023b8:	ef11                	bnez	a4,800023d4 <update_cache+0x88>
	if (is_preempt(_current) || is_metairq(th)) {
800023ba:	00e7d683          	lhu	a3,14(a5)
800023be:	07f00713          	li	a4,127
800023c2:	00d77963          	bgeu	a4,a3,800023d4 <update_cache+0x88>
		_kernel.ready_q.cache = _current;
800023c6:	d01c                	sw	a5,32(s0)
}
800023c8:	40b2                	lw	ra,12(sp)
800023ca:	4422                	lw	s0,8(sp)
800023cc:	4492                	lw	s1,4(sp)
800023ce:	4902                	lw	s2,0(sp)
800023d0:	0141                	addi	sp,sp,16
800023d2:	8082                	ret
		if (th != _current) {
800023d4:	441c                	lw	a5,8(s0)
800023d6:	00978463          	beq	a5,s1,800023de <update_cache+0x92>
			reset_time_slice();
800023da:	acdff0ef          	jal	ra,80001ea6 <reset_time_slice>
		_kernel.ready_q.cache = th;
800023de:	d004                	sw	s1,32(s0)
}
800023e0:	b7e5                	j	800023c8 <update_cache+0x7c>

800023e2 <k_sched_unlock>:
{
800023e2:	1101                	addi	sp,sp,-32
800023e4:	c84a                	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800023e6:	80005937          	lui	s2,0x80005
800023ea:	42c90793          	addi	a5,s2,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800023ee:	479c                	lw	a5,8(a5)
{
800023f0:	ce06                	sw	ra,28(sp)
800023f2:	cc22                	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
800023f4:	00f7c783          	lbu	a5,15(a5)
{
800023f8:	ca26                	sw	s1,20(sp)
800023fa:	c64e                	sw	s3,12(sp)
800023fc:	42c90913          	addi	s2,s2,1068
	__ASSERT(_current->base.sched_locked != 0, "");
80002400:	ef8d                	bnez	a5,8000243a <k_sched_unlock+0x58>
80002402:	80005437          	lui	s0,0x80005
80002406:	800055b7          	lui	a1,0x80005
8000240a:	80005537          	lui	a0,0x80005
8000240e:	e0058593          	addi	a1,a1,-512 # 80004e00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e01>
80002412:	22100693          	li	a3,545
80002416:	e2840613          	addi	a2,s0,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
8000241a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000241e:	94cff0ef          	jal	ra,8000156a <printk>
80002422:	80005537          	lui	a0,0x80005
80002426:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
8000242a:	940ff0ef          	jal	ra,8000156a <printk>
8000242e:	22100593          	li	a1,545
80002432:	e2840513          	addi	a0,s0,-472
80002436:	952ff0ef          	jal	ra,80001588 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
8000243a:	00092783          	lw	a5,0(s2)
8000243e:	cf8d                	beqz	a5,80002478 <k_sched_unlock+0x96>
80002440:	80005437          	lui	s0,0x80005
80002444:	800055b7          	lui	a1,0x80005
80002448:	80005537          	lui	a0,0x80005
8000244c:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80002450:	22200693          	li	a3,546
80002454:	e2840613          	addi	a2,s0,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002458:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000245c:	90eff0ef          	jal	ra,8000156a <printk>
80002460:	80005537          	lui	a0,0x80005
80002464:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80002468:	902ff0ef          	jal	ra,8000156a <printk>
8000246c:	22200593          	li	a1,546
80002470:	e2840513          	addi	a0,s0,-472
80002474:	914ff0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002478:	4421                	li	s0,8
8000247a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000247e:	800054b7          	lui	s1,0x80005
80002482:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002486:	8821                	andi	s0,s0,8
80002488:	222010ef          	jal	ra,800036aa <z_spin_lock_valid>
8000248c:	ed0d                	bnez	a0,800024c6 <k_sched_unlock+0xe4>
8000248e:	800059b7          	lui	s3,0x80005
80002492:	800055b7          	lui	a1,0x80005
80002496:	80005537          	lui	a0,0x80005
8000249a:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000249e:	04e00693          	li	a3,78
800024a2:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800024a6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800024aa:	8c0ff0ef          	jal	ra,8000156a <printk>
800024ae:	80005537          	lui	a0,0x80005
800024b2:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800024b6:	8b4ff0ef          	jal	ra,8000156a <printk>
800024ba:	04e00593          	li	a1,78
800024be:	bb498513          	addi	a0,s3,-1100
800024c2:	8c6ff0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800024c6:	19c48513          	addi	a0,s1,412
800024ca:	21c010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
800024ce:	00892703          	lw	a4,8(s2)
		update_cache(1);
800024d2:	4505                	li	a0,1
		++_current->base.sched_locked;
800024d4:	00f74783          	lbu	a5,15(a4)
800024d8:	0785                	addi	a5,a5,1
800024da:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
800024de:	35bd                	jal	8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800024e0:	19c48513          	addi	a0,s1,412
800024e4:	1e0010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
800024e8:	ed0d                	bnez	a0,80002522 <k_sched_unlock+0x140>
800024ea:	800054b7          	lui	s1,0x80005
800024ee:	800055b7          	lui	a1,0x80005
800024f2:	80005537          	lui	a0,0x80005
800024f6:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
800024fa:	06100693          	li	a3,97
800024fe:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002502:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002506:	864ff0ef          	jal	ra,8000156a <printk>
8000250a:	80005537          	lui	a0,0x80005
8000250e:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002512:	858ff0ef          	jal	ra,8000156a <printk>
80002516:	06100593          	li	a1,97
8000251a:	bb448513          	addi	a0,s1,-1100
8000251e:	86aff0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002522:	30042473          	csrrs	s0,mstatus,s0
}
80002526:	4462                	lw	s0,24(sp)
80002528:	40f2                	lw	ra,28(sp)
8000252a:	44d2                	lw	s1,20(sp)
8000252c:	4942                	lw	s2,16(sp)
8000252e:	49b2                	lw	s3,12(sp)
80002530:	6105                	addi	sp,sp,32
	z_reschedule_unlocked();
80002532:	c59ff06f          	j	8000218a <z_reschedule_unlocked>

80002536 <z_add_thread_to_ready_q>:
{
80002536:	1101                	addi	sp,sp,-32
80002538:	cc22                	sw	s0,24(sp)
8000253a:	ca26                	sw	s1,20(sp)
8000253c:	ce06                	sw	ra,28(sp)
8000253e:	c84a                	sw	s2,16(sp)
80002540:	c64e                	sw	s3,12(sp)
80002542:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002544:	44a1                	li	s1,8
80002546:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000254a:	80005937          	lui	s2,0x80005
8000254e:	19c90513          	addi	a0,s2,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002552:	88a1                	andi	s1,s1,8
80002554:	156010ef          	jal	ra,800036aa <z_spin_lock_valid>
80002558:	ed0d                	bnez	a0,80002592 <z_add_thread_to_ready_q+0x5c>
8000255a:	800059b7          	lui	s3,0x80005
8000255e:	800055b7          	lui	a1,0x80005
80002562:	80005537          	lui	a0,0x80005
80002566:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000256a:	04e00693          	li	a3,78
8000256e:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002572:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002576:	ff5fe0ef          	jal	ra,8000156a <printk>
8000257a:	80005537          	lui	a0,0x80005
8000257e:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002582:	fe9fe0ef          	jal	ra,8000156a <printk>
80002586:	04e00593          	li	a1,78
8000258a:	bb498513          	addi	a0,s3,-1100
8000258e:	ffbfe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80002592:	19c90513          	addi	a0,s2,412
80002596:	150010ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	return thread == _idle_thread;
8000259a:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
8000259e:	1287a783          	lw	a5,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
800025a2:	02f41863          	bne	s0,a5,800025d2 <z_add_thread_to_ready_q+0x9c>
800025a6:	800059b7          	lui	s3,0x80005
800025aa:	800055b7          	lui	a1,0x80005
800025ae:	80005537          	lui	a0,0x80005
800025b2:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
800025b6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800025ba:	27600693          	li	a3,630
800025be:	e2898613          	addi	a2,s3,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
800025c2:	fa9fe0ef          	jal	ra,8000156a <printk>
800025c6:	27600593          	li	a1,630
800025ca:	e2898513          	addi	a0,s3,-472
800025ce:	fbbfe0ef          	jal	ra,80001588 <assert_post_action>
	return list->head == list;
800025d2:	80005737          	lui	a4,0x80005
800025d6:	42c70693          	addi	a3,a4,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800025da:	52dc                	lw	a5,36(a3)
800025dc:	5690                	lw	a2,40(a3)
800025de:	800056b7          	lui	a3,0x80005
800025e2:	45068693          	addi	a3,a3,1104 # 80005450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005451>
800025e6:	42c70713          	addi	a4,a4,1068
	return sys_dlist_is_empty(list) ? NULL : list->head;
800025ea:	08d78463          	beq	a5,a3,80002672 <z_add_thread_to_ready_q+0x13c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800025ee:	c3d1                	beqz	a5,80002672 <z_add_thread_to_ready_q+0x13c>
	if (t1->base.prio < t2->base.prio) {
800025f0:	00e40583          	lb	a1,14(s0)
800025f4:	00e78503          	lb	a0,14(a5)
800025f8:	06a5d963          	bge	a1,a0,8000266a <z_add_thread_to_ready_q+0x134>
	node->prev = successor->prev;
800025fc:	43d8                	lw	a4,4(a5)
	node->next = successor;
800025fe:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002600:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002602:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002604:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002606:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
8000260a:	4501                	li	a0,0
8000260c:	0407e793          	ori	a5,a5,64
80002610:	00f406a3          	sb	a5,13(s0)
80002614:	3b25                	jal	8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002616:	19c90513          	addi	a0,s2,412
8000261a:	0aa010ef          	jal	ra,800036c4 <z_spin_unlock_valid>
8000261e:	ed0d                	bnez	a0,80002658 <z_add_thread_to_ready_q+0x122>
80002620:	80005437          	lui	s0,0x80005
80002624:	800055b7          	lui	a1,0x80005
80002628:	80005537          	lui	a0,0x80005
8000262c:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002630:	06100693          	li	a3,97
80002634:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002638:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000263c:	f2ffe0ef          	jal	ra,8000156a <printk>
80002640:	80005537          	lui	a0,0x80005
80002644:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002648:	f23fe0ef          	jal	ra,8000156a <printk>
8000264c:	06100593          	li	a1,97
80002650:	bb440513          	addi	a0,s0,-1100
80002654:	f35fe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002658:	3004a4f3          	csrrs	s1,mstatus,s1
}
8000265c:	40f2                	lw	ra,28(sp)
8000265e:	4462                	lw	s0,24(sp)
80002660:	44d2                	lw	s1,20(sp)
80002662:	4942                	lw	s2,16(sp)
80002664:	49b2                	lw	s3,12(sp)
80002666:	6105                	addi	sp,sp,32
80002668:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
8000266a:	00f60463          	beq	a2,a5,80002672 <z_add_thread_to_ready_q+0x13c>
8000266e:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002670:	f3d1                	bnez	a5,800025f4 <z_add_thread_to_ready_q+0xbe>
	node->prev = list->tail;
80002672:	c050                	sw	a2,4(s0)
	list->tail->next = node;
80002674:	571c                	lw	a5,40(a4)
	node->next = list;
80002676:	c014                	sw	a3,0(s0)
	list->tail->next = node;
80002678:	c380                	sw	s0,0(a5)
	list->tail = node;
8000267a:	d700                	sw	s0,40(a4)
8000267c:	b769                	j	80002606 <z_add_thread_to_ready_q+0xd0>

8000267e <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
8000267e:	ff052783          	lw	a5,-16(a0)
{
80002682:	1101                	addi	sp,sp,-32
80002684:	cc22                	sw	s0,24(sp)
80002686:	c64e                	sw	s3,12(sp)
80002688:	ce06                	sw	ra,28(sp)
8000268a:	ca26                	sw	s1,20(sp)
8000268c:	c84a                	sw	s2,16(sp)
8000268e:	c452                	sw	s4,8(sp)
80002690:	842a                	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80002692:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80002696:	cfcd                	beqz	a5,80002750 <z_thread_timeout+0xd2>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002698:	44a1                	li	s1,8
8000269a:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000269e:	80005937          	lui	s2,0x80005
800026a2:	19c90513          	addi	a0,s2,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
800026a6:	88a1                	andi	s1,s1,8
800026a8:	002010ef          	jal	ra,800036aa <z_spin_lock_valid>
800026ac:	ed0d                	bnez	a0,800026e6 <z_thread_timeout+0x68>
800026ae:	80005a37          	lui	s4,0x80005
800026b2:	800055b7          	lui	a1,0x80005
800026b6:	80005537          	lui	a0,0x80005
800026ba:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800026be:	04e00693          	li	a3,78
800026c2:	bb4a0613          	addi	a2,s4,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800026c6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800026ca:	ea1fe0ef          	jal	ra,8000156a <printk>
800026ce:	80005537          	lui	a0,0x80005
800026d2:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800026d6:	e95fe0ef          	jal	ra,8000156a <printk>
800026da:	04e00593          	li	a1,78
800026de:	bb4a0513          	addi	a0,s4,-1100
800026e2:	ea7fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800026e6:	19c90513          	addi	a0,s2,412
800026ea:	7fd000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800026ee:	ff040513          	addi	a0,s0,-16
800026f2:	fdaff0ef          	jal	ra,80001ecc <pended_on.isra.15>
800026f6:	85ce                	mv	a1,s3
800026f8:	bedff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800026fc:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002700:	19c90513          	addi	a0,s2,412
80002704:	9bf5                	andi	a5,a5,-3
80002706:	fef40aa3          	sb	a5,-11(s0)
8000270a:	7bb000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
8000270e:	ed0d                	bnez	a0,80002748 <z_thread_timeout+0xca>
80002710:	80005937          	lui	s2,0x80005
80002714:	800055b7          	lui	a1,0x80005
80002718:	80005537          	lui	a0,0x80005
8000271c:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002720:	06100693          	li	a3,97
80002724:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002728:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000272c:	e3ffe0ef          	jal	ra,8000156a <printk>
80002730:	80005537          	lui	a0,0x80005
80002734:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002738:	e33fe0ef          	jal	ra,8000156a <printk>
8000273c:	06100593          	li	a1,97
80002740:	bb490513          	addi	a0,s2,-1100
80002744:	e45fe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002748:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
8000274c:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002750:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80002754:	854e                	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80002756:	9bad                	andi	a5,a5,-21
80002758:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
8000275c:	f36ff0ef          	jal	ra,80001e92 <z_is_thread_ready>
80002760:	c911                	beqz	a0,80002774 <z_thread_timeout+0xf6>
}
80002762:	4462                	lw	s0,24(sp)
80002764:	40f2                	lw	ra,28(sp)
80002766:	44d2                	lw	s1,20(sp)
80002768:	4942                	lw	s2,16(sp)
8000276a:	4a22                	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
8000276c:	854e                	mv	a0,s3
8000276e:	49b2                	lw	s3,12(sp)
80002770:	6105                	addi	sp,sp,32
80002772:	b3d1                	j	80002536 <z_add_thread_to_ready_q>
80002774:	40f2                	lw	ra,28(sp)
80002776:	4462                	lw	s0,24(sp)
80002778:	44d2                	lw	s1,20(sp)
8000277a:	4942                	lw	s2,16(sp)
8000277c:	49b2                	lw	s3,12(sp)
8000277e:	4a22                	lw	s4,8(sp)
80002780:	6105                	addi	sp,sp,32
80002782:	8082                	ret

80002784 <z_move_thread_to_end_of_prio_q>:
{
80002784:	1101                	addi	sp,sp,-32
80002786:	cc22                	sw	s0,24(sp)
80002788:	c84a                	sw	s2,16(sp)
8000278a:	ce06                	sw	ra,28(sp)
8000278c:	ca26                	sw	s1,20(sp)
8000278e:	c64e                	sw	s3,12(sp)
80002790:	c452                	sw	s4,8(sp)
80002792:	c256                	sw	s5,4(sp)
80002794:	842a                	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002796:	4921                	li	s2,8
80002798:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000279c:	800059b7          	lui	s3,0x80005
800027a0:	19c98513          	addi	a0,s3,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
800027a4:	00897913          	andi	s2,s2,8
800027a8:	703000ef          	jal	ra,800036aa <z_spin_lock_valid>
800027ac:	ed0d                	bnez	a0,800027e6 <z_move_thread_to_end_of_prio_q+0x62>
800027ae:	800054b7          	lui	s1,0x80005
800027b2:	800055b7          	lui	a1,0x80005
800027b6:	80005537          	lui	a0,0x80005
800027ba:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800027be:	04e00693          	li	a3,78
800027c2:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800027c6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800027ca:	da1fe0ef          	jal	ra,8000156a <printk>
800027ce:	80005537          	lui	a0,0x80005
800027d2:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800027d6:	d95fe0ef          	jal	ra,8000156a <printk>
800027da:	04e00593          	li	a1,78
800027de:	bb448513          	addi	a0,s1,-1100
800027e2:	da7fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800027e6:	19c98513          	addi	a0,s3,412
800027ea:	6fd000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
800027ee:	800054b7          	lui	s1,0x80005
800027f2:	42c48513          	addi	a0,s1,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800027f6:	85a2                	mv	a1,s0
800027f8:	02450513          	addi	a0,a0,36
800027fc:	ae9ff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	return thread == _idle_thread;
80002800:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002804:	1287a783          	lw	a5,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
80002808:	80005a37          	lui	s4,0x80005
8000280c:	42c48493          	addi	s1,s1,1068
80002810:	450a0a13          	addi	s4,s4,1104 # 80005450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005451>
80002814:	02f41863          	bne	s0,a5,80002844 <z_move_thread_to_end_of_prio_q+0xc0>
80002818:	80005ab7          	lui	s5,0x80005
8000281c:	800055b7          	lui	a1,0x80005
80002820:	80005537          	lui	a0,0x80005
80002824:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
80002828:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000282c:	27600693          	li	a3,630
80002830:	e28a8613          	addi	a2,s5,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002834:	d37fe0ef          	jal	ra,8000156a <printk>
80002838:	27600593          	li	a1,630
8000283c:	e28a8513          	addi	a0,s5,-472
80002840:	d49fe0ef          	jal	ra,80001588 <assert_post_action>
	return list->head == list;
80002844:	50dc                	lw	a5,36(s1)
80002846:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002848:	09478a63          	beq	a5,s4,800028dc <z_move_thread_to_end_of_prio_q+0x158>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
8000284c:	cbc1                	beqz	a5,800028dc <z_move_thread_to_end_of_prio_q+0x158>
	if (t1->base.prio < t2->base.prio) {
8000284e:	00e40683          	lb	a3,14(s0)
80002852:	00e78603          	lb	a2,14(a5)
80002856:	06c6df63          	bge	a3,a2,800028d4 <z_move_thread_to_end_of_prio_q+0x150>
	node->prev = successor->prev;
8000285a:	43d8                	lw	a4,4(a5)
	node->next = successor;
8000285c:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
8000285e:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002860:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002862:	c3c0                	sw	s0,4(a5)
	thread->base.thread_state |= states;
80002864:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80002868:	4488                	lw	a0,8(s1)
8000286a:	0407e793          	ori	a5,a5,64
8000286e:	8d01                	sub	a0,a0,s0
80002870:	00153513          	seqz	a0,a0
80002874:	00f406a3          	sb	a5,13(s0)
80002878:	ad5ff0ef          	jal	ra,8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000287c:	19c98513          	addi	a0,s3,412
80002880:	645000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002884:	ed0d                	bnez	a0,800028be <z_move_thread_to_end_of_prio_q+0x13a>
80002886:	80005437          	lui	s0,0x80005
8000288a:	800055b7          	lui	a1,0x80005
8000288e:	80005537          	lui	a0,0x80005
80002892:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002896:	06100693          	li	a3,97
8000289a:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000289e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800028a2:	cc9fe0ef          	jal	ra,8000156a <printk>
800028a6:	80005537          	lui	a0,0x80005
800028aa:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
800028ae:	cbdfe0ef          	jal	ra,8000156a <printk>
800028b2:	06100593          	li	a1,97
800028b6:	bb440513          	addi	a0,s0,-1100
800028ba:	ccffe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800028be:	30092973          	csrrs	s2,mstatus,s2
}
800028c2:	40f2                	lw	ra,28(sp)
800028c4:	4462                	lw	s0,24(sp)
800028c6:	44d2                	lw	s1,20(sp)
800028c8:	4942                	lw	s2,16(sp)
800028ca:	49b2                	lw	s3,12(sp)
800028cc:	4a22                	lw	s4,8(sp)
800028ce:	4a92                	lw	s5,4(sp)
800028d0:	6105                	addi	sp,sp,32
800028d2:	8082                	ret
	return (node == list->tail) ? NULL : node->next;
800028d4:	00e78463          	beq	a5,a4,800028dc <z_move_thread_to_end_of_prio_q+0x158>
800028d8:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800028da:	ffa5                	bnez	a5,80002852 <z_move_thread_to_end_of_prio_q+0xce>
	node->prev = list->tail;
800028dc:	c058                	sw	a4,4(s0)
	list->tail->next = node;
800028de:	549c                	lw	a5,40(s1)
	node->next = list;
800028e0:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
800028e4:	c380                	sw	s0,0(a5)
	list->tail = node;
800028e6:	d480                	sw	s0,40(s1)
800028e8:	bfb5                	j	80002864 <z_move_thread_to_end_of_prio_q+0xe0>

800028ea <z_time_slice>:
	if (slice_time && sliceable(_current)) {
800028ea:	800057b7          	lui	a5,0x80005
800028ee:	1a47a783          	lw	a5,420(a5) # 800051a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a5>
800028f2:	cba9                	beqz	a5,80002944 <z_time_slice+0x5a>
800028f4:	800057b7          	lui	a5,0x80005
800028f8:	42c78793          	addi	a5,a5,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800028fc:	4798                	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
800028fe:	07f00693          	li	a3,127
80002902:	00e75603          	lhu	a2,14(a4)
80002906:	02c6ef63          	bltu	a3,a2,80002944 <z_time_slice+0x5a>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
8000290a:	800056b7          	lui	a3,0x80005
8000290e:	00e70603          	lb	a2,14(a4)
80002912:	1a06a683          	lw	a3,416(a3) # 800051a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a1>
80002916:	02d64763          	blt	a2,a3,80002944 <z_time_slice+0x5a>
	return thread == _idle_thread;
8000291a:	800056b7          	lui	a3,0x80005
		&& !is_idle(t)
8000291e:	1286a683          	lw	a3,296(a3) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
80002922:	02d70163          	beq	a4,a3,80002944 <z_time_slice+0x5a>
		&& !z_is_thread_timeout_active(t);
80002926:	4f14                	lw	a3,24(a4)
80002928:	ee91                	bnez	a3,80002944 <z_time_slice+0x5a>
		if (ticks >= _current_cpu->slice_ticks) {
8000292a:	4b94                	lw	a3,16(a5)
8000292c:	00d54a63          	blt	a0,a3,80002940 <z_time_slice+0x56>
{
80002930:	1141                	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80002932:	853a                	mv	a0,a4
{
80002934:	c606                	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80002936:	35b9                	jal	80002784 <z_move_thread_to_end_of_prio_q>
}
80002938:	40b2                	lw	ra,12(sp)
8000293a:	0141                	addi	sp,sp,16
			reset_time_slice();
8000293c:	d6aff06f          	j	80001ea6 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80002940:	8e89                	sub	a3,a3,a0
80002942:	cb94                	sw	a3,16(a5)
80002944:	8082                	ret

80002946 <z_remove_thread_from_ready_q>:
{
80002946:	1101                	addi	sp,sp,-32
80002948:	cc22                	sw	s0,24(sp)
8000294a:	c64e                	sw	s3,12(sp)
8000294c:	ce06                	sw	ra,28(sp)
8000294e:	ca26                	sw	s1,20(sp)
80002950:	c84a                	sw	s2,16(sp)
80002952:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002954:	4421                	li	s0,8
80002956:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000295a:	800054b7          	lui	s1,0x80005
8000295e:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002962:	8821                	andi	s0,s0,8
80002964:	547000ef          	jal	ra,800036aa <z_spin_lock_valid>
80002968:	ed0d                	bnez	a0,800029a2 <z_remove_thread_from_ready_q+0x5c>
8000296a:	80005937          	lui	s2,0x80005
8000296e:	800055b7          	lui	a1,0x80005
80002972:	80005537          	lui	a0,0x80005
80002976:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000297a:	04e00693          	li	a3,78
8000297e:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002982:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002986:	be5fe0ef          	jal	ra,8000156a <printk>
8000298a:	80005537          	lui	a0,0x80005
8000298e:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002992:	bd9fe0ef          	jal	ra,8000156a <printk>
80002996:	04e00593          	li	a1,78
8000299a:	bb490513          	addi	a0,s2,-1100
8000299e:	bebfe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800029a2:	19c48513          	addi	a0,s1,412
800029a6:	541000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
800029aa:	00d9c783          	lbu	a5,13(s3)
800029ae:	80005937          	lui	s2,0x80005
800029b2:	42c90913          	addi	s2,s2,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800029b6:	0407f793          	andi	a5,a5,64
800029ba:	cf81                	beqz	a5,800029d2 <z_remove_thread_from_ready_q+0x8c>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
800029bc:	85ce                	mv	a1,s3
800029be:	02490513          	addi	a0,s2,36
800029c2:	923ff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
800029c6:	00d9c783          	lbu	a5,13(s3)
800029ca:	fbf7f793          	andi	a5,a5,-65
800029ce:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
800029d2:	00892503          	lw	a0,8(s2)
800029d6:	41350533          	sub	a0,a0,s3
800029da:	00153513          	seqz	a0,a0
800029de:	96fff0ef          	jal	ra,8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800029e2:	19c48513          	addi	a0,s1,412
800029e6:	4df000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
800029ea:	ed0d                	bnez	a0,80002a24 <z_remove_thread_from_ready_q+0xde>
800029ec:	800054b7          	lui	s1,0x80005
800029f0:	800055b7          	lui	a1,0x80005
800029f4:	80005537          	lui	a0,0x80005
800029f8:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
800029fc:	06100693          	li	a3,97
80002a00:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002a04:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002a08:	b63fe0ef          	jal	ra,8000156a <printk>
80002a0c:	80005537          	lui	a0,0x80005
80002a10:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002a14:	b57fe0ef          	jal	ra,8000156a <printk>
80002a18:	06100593          	li	a1,97
80002a1c:	bb448513          	addi	a0,s1,-1100
80002a20:	b69fe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002a24:	30042473          	csrrs	s0,mstatus,s0
}
80002a28:	40f2                	lw	ra,28(sp)
80002a2a:	4462                	lw	s0,24(sp)
80002a2c:	44d2                	lw	s1,20(sp)
80002a2e:	4942                	lw	s2,16(sp)
80002a30:	49b2                	lw	s3,12(sp)
80002a32:	6105                	addi	sp,sp,32
80002a34:	8082                	ret

80002a36 <pend>:
{
80002a36:	1101                	addi	sp,sp,-32
80002a38:	cc22                	sw	s0,24(sp)
80002a3a:	ca26                	sw	s1,20(sp)
80002a3c:	842a                	mv	s0,a0
80002a3e:	c84a                	sw	s2,16(sp)
80002a40:	ce06                	sw	ra,28(sp)
80002a42:	c64e                	sw	s3,12(sp)
80002a44:	84ae                	mv	s1,a1
80002a46:	8932                	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
80002a48:	3dfd                	jal	80002946 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
80002a4a:	00d44783          	lbu	a5,13(s0)
80002a4e:	0027e793          	ori	a5,a5,2
80002a52:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
80002a56:	cca9                	beqz	s1,80002ab0 <pend+0x7a>
	return thread == _idle_thread;
80002a58:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002a5c:	1287a783          	lw	a5,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
		thread->base.pended_on = wait_q;
80002a60:	c404                	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
80002a62:	02f41863          	bne	s0,a5,80002a92 <pend+0x5c>
80002a66:	800059b7          	lui	s3,0x80005
80002a6a:	800055b7          	lui	a1,0x80005
80002a6e:	80005537          	lui	a0,0x80005
80002a72:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
80002a76:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002a7a:	27600693          	li	a3,630
80002a7e:	e2898613          	addi	a2,s3,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002a82:	ae9fe0ef          	jal	ra,8000156a <printk>
80002a86:	27600593          	li	a1,630
80002a8a:	e2898513          	addi	a0,s3,-472
80002a8e:	afbfe0ef          	jal	ra,80001588 <assert_post_action>
	return list->head == list;
80002a92:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002a94:	04f48b63          	beq	s1,a5,80002aea <pend+0xb4>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002a98:	cba9                	beqz	a5,80002aea <pend+0xb4>
	if (t1->base.prio < t2->base.prio) {
80002a9a:	00e40703          	lb	a4,14(s0)
80002a9e:	00e78683          	lb	a3,14(a5)
80002aa2:	02d75f63          	bge	a4,a3,80002ae0 <pend+0xaa>
	node->prev = successor->prev;
80002aa6:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002aa8:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002aaa:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002aac:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002aae:	c3c0                	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
80002ab0:	57fd                	li	a5,-1
80002ab2:	04f90363          	beq	s2,a5,80002af8 <pend+0xc2>
80002ab6:	45a9                	li	a1,10
80002ab8:	00990513          	addi	a0,s2,9
80002abc:	e25fd0ef          	jal	ra,800008e0 <__divsi3>

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80002ac0:	00150613          	addi	a2,a0,1
80002ac4:	01840513          	addi	a0,s0,24
}
80002ac8:	4462                	lw	s0,24(sp)
80002aca:	40f2                	lw	ra,28(sp)
80002acc:	44d2                	lw	s1,20(sp)
80002ace:	4942                	lw	s2,16(sp)
80002ad0:	49b2                	lw	s3,12(sp)
80002ad2:	800025b7          	lui	a1,0x80002
80002ad6:	67e58593          	addi	a1,a1,1662 # 8000267e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000267f>
80002ada:	6105                	addi	sp,sp,32
80002adc:	7a30006f          	j	80003a7e <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
80002ae0:	40d4                	lw	a3,4(s1)
80002ae2:	00d78463          	beq	a5,a3,80002aea <pend+0xb4>
80002ae6:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002ae8:	fbdd                	bnez	a5,80002a9e <pend+0x68>
	node->prev = list->tail;
80002aea:	40dc                	lw	a5,4(s1)
	node->next = list;
80002aec:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80002aee:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80002af0:	40dc                	lw	a5,4(s1)
80002af2:	c380                	sw	s0,0(a5)
	list->tail = node;
80002af4:	c0c0                	sw	s0,4(s1)
80002af6:	bf6d                	j	80002ab0 <pend+0x7a>
}
80002af8:	40f2                	lw	ra,28(sp)
80002afa:	4462                	lw	s0,24(sp)
80002afc:	44d2                	lw	s1,20(sp)
80002afe:	4942                	lw	s2,16(sp)
80002b00:	49b2                	lw	s3,12(sp)
80002b02:	6105                	addi	sp,sp,32
80002b04:	8082                	ret

80002b06 <z_pend_curr>:
{
80002b06:	1141                	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
80002b08:	800057b7          	lui	a5,0x80005
{
80002b0c:	c422                	sw	s0,8(sp)
80002b0e:	842a                	mv	s0,a0
	pend(_current, wait_q, timeout);
80002b10:	4347a503          	lw	a0,1076(a5) # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
{
80002b14:	c226                	sw	s1,4(sp)
80002b16:	84ae                	mv	s1,a1
80002b18:	85b2                	mv	a1,a2
	pend(_current, wait_q, timeout);
80002b1a:	8636                	mv	a2,a3
{
80002b1c:	c606                	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
80002b1e:	3f21                	jal	80002a36 <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b20:	8522                	mv	a0,s0
80002b22:	3a3000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002b26:	ed0d                	bnez	a0,80002b60 <z_pend_curr+0x5a>
80002b28:	80005437          	lui	s0,0x80005
80002b2c:	800055b7          	lui	a1,0x80005
80002b30:	80005537          	lui	a0,0x80005
80002b34:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002b38:	07800693          	li	a3,120
80002b3c:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002b40:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002b44:	a27fe0ef          	jal	ra,8000156a <printk>
80002b48:	80005537          	lui	a0,0x80005
80002b4c:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002b50:	a1bfe0ef          	jal	ra,8000156a <printk>
80002b54:	07800593          	li	a1,120
80002b58:	bb440513          	addi	a0,s0,-1100
80002b5c:	a2dfe0ef          	jal	ra,80001588 <assert_post_action>
}
80002b60:	4422                	lw	s0,8(sp)
80002b62:	40b2                	lw	ra,12(sp)
80002b64:	8526                	mv	a0,s1
80002b66:	4492                	lw	s1,4(sp)
80002b68:	0141                	addi	sp,sp,16
80002b6a:	e66fd06f          	j	800001d0 <__swap>

80002b6e <z_thread_priority_set>:
{
80002b6e:	1101                	addi	sp,sp,-32
80002b70:	cc22                	sw	s0,24(sp)
80002b72:	c84a                	sw	s2,16(sp)
80002b74:	c452                	sw	s4,8(sp)
80002b76:	ce06                	sw	ra,28(sp)
80002b78:	ca26                	sw	s1,20(sp)
80002b7a:	c64e                	sw	s3,12(sp)
80002b7c:	c256                	sw	s5,4(sp)
80002b7e:	c05a                	sw	s6,0(sp)
80002b80:	842a                	mv	s0,a0
80002b82:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002b84:	4921                	li	s2,8
80002b86:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002b8a:	800059b7          	lui	s3,0x80005
80002b8e:	19c98513          	addi	a0,s3,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002b92:	00897913          	andi	s2,s2,8
80002b96:	315000ef          	jal	ra,800036aa <z_spin_lock_valid>
80002b9a:	ed0d                	bnez	a0,80002bd4 <z_thread_priority_set+0x66>
80002b9c:	800054b7          	lui	s1,0x80005
80002ba0:	800055b7          	lui	a1,0x80005
80002ba4:	80005537          	lui	a0,0x80005
80002ba8:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80002bac:	04e00693          	li	a3,78
80002bb0:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002bb4:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002bb8:	9b3fe0ef          	jal	ra,8000156a <printk>
80002bbc:	80005537          	lui	a0,0x80005
80002bc0:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002bc4:	9a7fe0ef          	jal	ra,8000156a <printk>
80002bc8:	04e00593          	li	a1,78
80002bcc:	bb448513          	addi	a0,s1,-1100
80002bd0:	9b9fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80002bd4:	19c98513          	addi	a0,s3,412
80002bd8:	30f000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		need_sched = z_is_thread_ready(thread);
80002bdc:	8522                	mv	a0,s0
80002bde:	ab4ff0ef          	jal	ra,80001e92 <z_is_thread_ready>
80002be2:	0a62                	slli	s4,s4,0x18
80002be4:	8aaa                	mv	s5,a0
		if (need_sched) {
80002be6:	418a5a13          	srai	s4,s4,0x18
80002bea:	10050463          	beqz	a0,80002cf2 <z_thread_priority_set+0x184>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80002bee:	800054b7          	lui	s1,0x80005
80002bf2:	42c48513          	addi	a0,s1,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80002bf6:	85a2                	mv	a1,s0
80002bf8:	02450513          	addi	a0,a0,36
80002bfc:	ee8ff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	return thread == _idle_thread;
80002c00:	800057b7          	lui	a5,0x80005
	__ASSERT_NO_MSG(!is_idle(thread));
80002c04:	1287a783          	lw	a5,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
			thread->base.prio = prio;
80002c08:	01440723          	sb	s4,14(s0)
	return thread == _idle_thread;
80002c0c:	80005a37          	lui	s4,0x80005
80002c10:	42c48493          	addi	s1,s1,1068
80002c14:	450a0a13          	addi	s4,s4,1104 # 80005450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005451>
	__ASSERT_NO_MSG(!is_idle(thread));
80002c18:	02f41863          	bne	s0,a5,80002c48 <z_thread_priority_set+0xda>
80002c1c:	80005b37          	lui	s6,0x80005
80002c20:	800055b7          	lui	a1,0x80005
80002c24:	80005537          	lui	a0,0x80005
80002c28:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
80002c2c:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002c30:	27600693          	li	a3,630
80002c34:	e28b0613          	addi	a2,s6,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002c38:	933fe0ef          	jal	ra,8000156a <printk>
80002c3c:	27600593          	li	a1,630
80002c40:	e28b0513          	addi	a0,s6,-472
80002c44:	945fe0ef          	jal	ra,80001588 <assert_post_action>
	return list->head == list;
80002c48:	50dc                	lw	a5,36(s1)
80002c4a:	5498                	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80002c4c:	09478c63          	beq	a5,s4,80002ce4 <z_thread_priority_set+0x176>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002c50:	cbd1                	beqz	a5,80002ce4 <z_thread_priority_set+0x176>
	if (t1->base.prio < t2->base.prio) {
80002c52:	00e40683          	lb	a3,14(s0)
80002c56:	00e78603          	lb	a2,14(a5)
80002c5a:	08c6d163          	bge	a3,a2,80002cdc <z_thread_priority_set+0x16e>
	node->prev = successor->prev;
80002c5e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80002c60:	c01c                	sw	a5,0(s0)
	node->prev = successor->prev;
80002c62:	c058                	sw	a4,4(s0)
	successor->prev->next = node;
80002c64:	c300                	sw	s0,0(a4)
	successor->prev = node;
80002c66:	c3c0                	sw	s0,4(a5)
			update_cache(1);
80002c68:	4505                	li	a0,1
80002c6a:	ee2ff0ef          	jal	ra,8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002c6e:	19c98513          	addi	a0,s3,412
80002c72:	253000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002c76:	ed0d                	bnez	a0,80002cb0 <z_thread_priority_set+0x142>
80002c78:	80005437          	lui	s0,0x80005
80002c7c:	800055b7          	lui	a1,0x80005
80002c80:	80005537          	lui	a0,0x80005
80002c84:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002c88:	06100693          	li	a3,97
80002c8c:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002c90:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002c94:	8d7fe0ef          	jal	ra,8000156a <printk>
80002c98:	80005537          	lui	a0,0x80005
80002c9c:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002ca0:	8cbfe0ef          	jal	ra,8000156a <printk>
80002ca4:	06100593          	li	a1,97
80002ca8:	bb440513          	addi	a0,s0,-1100
80002cac:	8ddfe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002cb0:	30092973          	csrrs	s2,mstatus,s2
	if (need_sched && _current->base.sched_locked == 0) {
80002cb4:	040a8263          	beqz	s5,80002cf8 <z_thread_priority_set+0x18a>
80002cb8:	800057b7          	lui	a5,0x80005
80002cbc:	4347a783          	lw	a5,1076(a5) # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
80002cc0:	00f7c783          	lbu	a5,15(a5)
80002cc4:	eb95                	bnez	a5,80002cf8 <z_thread_priority_set+0x18a>
}
80002cc6:	4462                	lw	s0,24(sp)
80002cc8:	40f2                	lw	ra,28(sp)
80002cca:	44d2                	lw	s1,20(sp)
80002ccc:	4942                	lw	s2,16(sp)
80002cce:	49b2                	lw	s3,12(sp)
80002cd0:	4a22                	lw	s4,8(sp)
80002cd2:	4a92                	lw	s5,4(sp)
80002cd4:	4b02                	lw	s6,0(sp)
80002cd6:	6105                	addi	sp,sp,32
		z_reschedule_unlocked();
80002cd8:	cb2ff06f          	j	8000218a <z_reschedule_unlocked>
	return (node == list->tail) ? NULL : node->next;
80002cdc:	00e78463          	beq	a5,a4,80002ce4 <z_thread_priority_set+0x176>
80002ce0:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80002ce2:	fbb5                	bnez	a5,80002c56 <z_thread_priority_set+0xe8>
	node->prev = list->tail;
80002ce4:	c058                	sw	a4,4(s0)
	list->tail->next = node;
80002ce6:	549c                	lw	a5,40(s1)
	node->next = list;
80002ce8:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80002cec:	c380                	sw	s0,0(a5)
	list->tail = node;
80002cee:	d480                	sw	s0,40(s1)
80002cf0:	bfa5                	j	80002c68 <z_thread_priority_set+0xfa>
			thread->base.prio = prio;
80002cf2:	01440723          	sb	s4,14(s0)
80002cf6:	bfa5                	j	80002c6e <z_thread_priority_set+0x100>
}
80002cf8:	40f2                	lw	ra,28(sp)
80002cfa:	4462                	lw	s0,24(sp)
80002cfc:	44d2                	lw	s1,20(sp)
80002cfe:	4942                	lw	s2,16(sp)
80002d00:	49b2                	lw	s3,12(sp)
80002d02:	4a22                	lw	s4,8(sp)
80002d04:	4a92                	lw	s5,4(sp)
80002d06:	4b02                	lw	s6,0(sp)
80002d08:	6105                	addi	sp,sp,32
80002d0a:	8082                	ret

80002d0c <z_unpend_first_thread>:
{
80002d0c:	1101                	addi	sp,sp,-32
80002d0e:	c84a                	sw	s2,16(sp)
80002d10:	c64e                	sw	s3,12(sp)
80002d12:	ce06                	sw	ra,28(sp)
80002d14:	cc22                	sw	s0,24(sp)
80002d16:	ca26                	sw	s1,20(sp)
80002d18:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002d1a:	4921                	li	s2,8
80002d1c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002d20:	800054b7          	lui	s1,0x80005
80002d24:	19c48513          	addi	a0,s1,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002d28:	00897913          	andi	s2,s2,8
80002d2c:	17f000ef          	jal	ra,800036aa <z_spin_lock_valid>
80002d30:	ed0d                	bnez	a0,80002d6a <z_unpend_first_thread+0x5e>
80002d32:	80005437          	lui	s0,0x80005
80002d36:	800055b7          	lui	a1,0x80005
80002d3a:	80005537          	lui	a0,0x80005
80002d3e:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80002d42:	04e00693          	li	a3,78
80002d46:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002d4a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002d4e:	81dfe0ef          	jal	ra,8000156a <printk>
80002d52:	80005537          	lui	a0,0x80005
80002d56:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002d5a:	811fe0ef          	jal	ra,8000156a <printk>
80002d5e:	04e00593          	li	a1,78
80002d62:	bb440513          	addi	a0,s0,-1100
80002d66:	823fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80002d6a:	19c48513          	addi	a0,s1,412
80002d6e:	179000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
80002d72:	854e                	mv	a0,s3
80002d74:	dccff0ef          	jal	ra,80002340 <z_priq_dumb_best>
80002d78:	842a                	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002d7a:	19c48513          	addi	a0,s1,412
80002d7e:	147000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002d82:	ed0d                	bnez	a0,80002dbc <z_unpend_first_thread+0xb0>
80002d84:	800059b7          	lui	s3,0x80005
80002d88:	800055b7          	lui	a1,0x80005
80002d8c:	80005537          	lui	a0,0x80005
80002d90:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002d94:	06100693          	li	a3,97
80002d98:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002d9c:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002da0:	fcafe0ef          	jal	ra,8000156a <printk>
80002da4:	80005537          	lui	a0,0x80005
80002da8:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002dac:	fbefe0ef          	jal	ra,8000156a <printk>
80002db0:	06100593          	li	a1,97
80002db4:	bb498513          	addi	a0,s3,-1100
80002db8:	fd0fe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002dbc:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80002dc0:	c061                	beqz	s0,80002e80 <z_unpend_first_thread+0x174>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002dc2:	4921                	li	s2,8
80002dc4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002dc8:	19c48513          	addi	a0,s1,412
	key = (mstatus & SOC_MSTATUS_IEN);
80002dcc:	00897913          	andi	s2,s2,8
80002dd0:	0db000ef          	jal	ra,800036aa <z_spin_lock_valid>
80002dd4:	ed0d                	bnez	a0,80002e0e <z_unpend_first_thread+0x102>
80002dd6:	800059b7          	lui	s3,0x80005
80002dda:	800055b7          	lui	a1,0x80005
80002dde:	80005537          	lui	a0,0x80005
80002de2:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80002de6:	04e00693          	li	a3,78
80002dea:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002dee:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002df2:	f78fe0ef          	jal	ra,8000156a <printk>
80002df6:	80005537          	lui	a0,0x80005
80002dfa:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002dfe:	f6cfe0ef          	jal	ra,8000156a <printk>
80002e02:	04e00593          	li	a1,78
80002e06:	bb498513          	addi	a0,s3,-1100
80002e0a:	f7efe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80002e0e:	19c48513          	addi	a0,s1,412
80002e12:	0d5000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80002e16:	00840513          	addi	a0,s0,8
80002e1a:	8b2ff0ef          	jal	ra,80001ecc <pended_on.isra.15>
80002e1e:	85a2                	mv	a1,s0
80002e20:	cc4ff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80002e24:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002e28:	19c48513          	addi	a0,s1,412
80002e2c:	9bf5                	andi	a5,a5,-3
80002e2e:	00f406a3          	sb	a5,13(s0)
80002e32:	093000ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80002e36:	ed0d                	bnez	a0,80002e70 <z_unpend_first_thread+0x164>
80002e38:	800054b7          	lui	s1,0x80005
80002e3c:	800055b7          	lui	a1,0x80005
80002e40:	80005537          	lui	a0,0x80005
80002e44:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80002e48:	06100693          	li	a3,97
80002e4c:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002e50:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002e54:	f16fe0ef          	jal	ra,8000156a <printk>
80002e58:	80005537          	lui	a0,0x80005
80002e5c:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80002e60:	f0afe0ef          	jal	ra,8000156a <printk>
80002e64:	06100593          	li	a1,97
80002e68:	bb448513          	addi	a0,s1,-1100
80002e6c:	f1cfe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002e70:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
80002e74:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
80002e78:	01840513          	addi	a0,s0,24
80002e7c:	5cb000ef          	jal	ra,80003c46 <z_abort_timeout>
}
80002e80:	8522                	mv	a0,s0
80002e82:	40f2                	lw	ra,28(sp)
80002e84:	4462                	lw	s0,24(sp)
80002e86:	44d2                	lw	s1,20(sp)
80002e88:	4942                	lw	s2,16(sp)
80002e8a:	49b2                	lw	s3,12(sp)
80002e8c:	6105                	addi	sp,sp,32
80002e8e:	8082                	ret

80002e90 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80002e90:	800057b7          	lui	a5,0x80005
80002e94:	42c78793          	addi	a5,a5,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80002e98:	02478713          	addi	a4,a5,36
80002e9c:	d3d8                	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80002e9e:	d798                	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80002ea0:	4581                	li	a1,0
80002ea2:	4501                	li	a0,0
80002ea4:	86eff06f          	j	80001f12 <k_sched_time_slice_set>

80002ea8 <z_impl_k_thread_priority_set>:
Z_SYSCALL_HANDLER1_SIMPLE(k_thread_priority_get, K_OBJ_THREAD,
			  struct k_thread *);
#endif

void z_impl_k_thread_priority_set(k_tid_t tid, int prio)
{
80002ea8:	1141                	addi	sp,sp,-16
80002eaa:	c422                	sw	s0,8(sp)
80002eac:	c04a                	sw	s2,0(sp)
80002eae:	c606                	sw	ra,12(sp)
80002eb0:	c226                	sw	s1,4(sp)
	/*
	 * Use NULL, since we cannot know what the entry point is (we do not
	 * keep track of it) and idle cannot change its priority.
	 */
	Z_ASSERT_VALID_PRIO(prio, NULL);
80002eb2:	01058713          	addi	a4,a1,16
80002eb6:	47f9                	li	a5,30
{
80002eb8:	892a                	mv	s2,a0
80002eba:	842e                	mv	s0,a1
	Z_ASSERT_VALID_PRIO(prio, NULL);
80002ebc:	04e7f163          	bgeu	a5,a4,80002efe <z_impl_k_thread_priority_set+0x56>
80002ec0:	800054b7          	lui	s1,0x80005
80002ec4:	800055b7          	lui	a1,0x80005
80002ec8:	80005537          	lui	a0,0x80005
80002ecc:	34500693          	li	a3,837
80002ed0:	e2848613          	addi	a2,s1,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002ed4:	ec058593          	addi	a1,a1,-320 # 80004ec0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ec1>
80002ed8:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002edc:	e8efe0ef          	jal	ra,8000156a <printk>
80002ee0:	80005537          	lui	a0,0x80005
80002ee4:	85a2                	mv	a1,s0
80002ee6:	b4c50513          	addi	a0,a0,-1204 # 80004b4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b4d>
80002eea:	56c1                	li	a3,-16
80002eec:	4639                	li	a2,14
80002eee:	e7cfe0ef          	jal	ra,8000156a <printk>
80002ef2:	34500593          	li	a1,837
80002ef6:	e2848513          	addi	a0,s1,-472
80002efa:	e8efe0ef          	jal	ra,80001588 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80002efe:	800057b7          	lui	a5,0x80005
80002f02:	42c7a783          	lw	a5,1068(a5) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80002f06:	cf8d                	beqz	a5,80002f40 <z_impl_k_thread_priority_set+0x98>
80002f08:	800054b7          	lui	s1,0x80005
80002f0c:	800055b7          	lui	a1,0x80005
80002f10:	80005537          	lui	a0,0x80005
80002f14:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80002f18:	34600693          	li	a3,838
80002f1c:	e2848613          	addi	a2,s1,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002f20:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002f24:	e46fe0ef          	jal	ra,8000156a <printk>
80002f28:	80005537          	lui	a0,0x80005
80002f2c:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80002f30:	e3afe0ef          	jal	ra,8000156a <printk>
80002f34:	34600593          	li	a1,838
80002f38:	e2848513          	addi	a0,s1,-472
80002f3c:	e4cfe0ef          	jal	ra,80001588 <assert_post_action>

	struct k_thread *thread = (struct k_thread *)tid;

	z_thread_priority_set(thread, prio);
80002f40:	85a2                	mv	a1,s0
}
80002f42:	4422                	lw	s0,8(sp)
80002f44:	40b2                	lw	ra,12(sp)
80002f46:	4492                	lw	s1,4(sp)
	z_thread_priority_set(thread, prio);
80002f48:	854a                	mv	a0,s2
}
80002f4a:	4902                	lw	s2,0(sp)
80002f4c:	0141                	addi	sp,sp,16
	z_thread_priority_set(thread, prio);
80002f4e:	c21ff06f          	j	80002b6e <z_thread_priority_set>

80002f52 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80002f52:	1101                	addi	sp,sp,-32
80002f54:	cc22                	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
80002f56:	80005437          	lui	s0,0x80005
80002f5a:	42c42783          	lw	a5,1068(s0) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
{
80002f5e:	ce06                	sw	ra,28(sp)
80002f60:	ca26                	sw	s1,20(sp)
80002f62:	c84a                	sw	s2,16(sp)
80002f64:	c64e                	sw	s3,12(sp)
80002f66:	c452                	sw	s4,8(sp)
80002f68:	c256                	sw	s5,4(sp)
80002f6a:	42c40413          	addi	s0,s0,1068
	__ASSERT(!z_is_in_isr(), "");
80002f6e:	cf8d                	beqz	a5,80002fa8 <z_impl_k_yield+0x56>
80002f70:	800054b7          	lui	s1,0x80005
80002f74:	800055b7          	lui	a1,0x80005
80002f78:	80005537          	lui	a0,0x80005
80002f7c:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80002f80:	37e00693          	li	a3,894
80002f84:	e2848613          	addi	a2,s1,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80002f88:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002f8c:	ddefe0ef          	jal	ra,8000156a <printk>
80002f90:	80005537          	lui	a0,0x80005
80002f94:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80002f98:	dd2fe0ef          	jal	ra,8000156a <printk>
80002f9c:	37e00593          	li	a1,894
80002fa0:	e2848513          	addi	a0,s1,-472
80002fa4:	de4fe0ef          	jal	ra,80001588 <assert_post_action>
	return thread == _idle_thread;
80002fa8:	800057b7          	lui	a5,0x80005

	if (!is_idle(_current)) {
80002fac:	4414                	lw	a3,8(s0)
80002fae:	1287a703          	lw	a4,296(a5) # 80005128 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005129>
80002fb2:	8a3e                	mv	s4,a5
80002fb4:	10e68763          	beq	a3,a4,800030c2 <z_impl_k_yield+0x170>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002fb8:	4921                	li	s2,8
80002fba:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002fbe:	800059b7          	lui	s3,0x80005
80002fc2:	19c98513          	addi	a0,s3,412 # 8000519c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000519d>
	key = (mstatus & SOC_MSTATUS_IEN);
80002fc6:	00897913          	andi	s2,s2,8
80002fca:	6e0000ef          	jal	ra,800036aa <z_spin_lock_valid>
80002fce:	ed0d                	bnez	a0,80003008 <z_impl_k_yield+0xb6>
80002fd0:	800054b7          	lui	s1,0x80005
80002fd4:	800055b7          	lui	a1,0x80005
80002fd8:	80005537          	lui	a0,0x80005
80002fdc:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80002fe0:	04e00693          	li	a3,78
80002fe4:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80002fe8:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80002fec:	d7efe0ef          	jal	ra,8000156a <printk>
80002ff0:	80005537          	lui	a0,0x80005
80002ff4:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80002ff8:	d72fe0ef          	jal	ra,8000156a <printk>
80002ffc:	04e00593          	li	a1,78
80003000:	bb448513          	addi	a0,s1,-1100
80003004:	d84fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003008:	19c98513          	addi	a0,s3,412
8000300c:	6da000ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
80003010:	440c                	lw	a1,8(s0)
80003012:	02440513          	addi	a0,s0,36
80003016:	aceff0ef          	jal	ra,800022e4 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
8000301a:	128a2783          	lw	a5,296(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
8000301e:	4404                	lw	s1,8(s0)
	return thread == _idle_thread;
80003020:	80005a37          	lui	s4,0x80005
80003024:	450a0a13          	addi	s4,s4,1104 # 80005450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005451>
	__ASSERT_NO_MSG(!is_idle(thread));
80003028:	02f49863          	bne	s1,a5,80003058 <z_impl_k_yield+0x106>
8000302c:	80005ab7          	lui	s5,0x80005
80003030:	800055b7          	lui	a1,0x80005
80003034:	80005537          	lui	a0,0x80005
80003038:	f4058593          	addi	a1,a1,-192 # 80004f40 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f41>
8000303c:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003040:	27600693          	li	a3,630
80003044:	e28a8613          	addi	a2,s5,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80003048:	d22fe0ef          	jal	ra,8000156a <printk>
8000304c:	27600593          	li	a1,630
80003050:	e28a8513          	addi	a0,s5,-472
80003054:	d34fe0ef          	jal	ra,80001588 <assert_post_action>
	return list->head == list;
80003058:	505c                	lw	a5,36(s0)
8000305a:	5418                	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000305c:	09478563          	beq	a5,s4,800030e6 <z_impl_k_yield+0x194>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003060:	c3d9                	beqz	a5,800030e6 <z_impl_k_yield+0x194>
	if (t1->base.prio < t2->base.prio) {
80003062:	00e48683          	lb	a3,14(s1)
80003066:	00e78603          	lb	a2,14(a5)
8000306a:	06c6da63          	bge	a3,a2,800030de <z_impl_k_yield+0x18c>
	node->prev = successor->prev;
8000306e:	43d8                	lw	a4,4(a5)
	node->next = successor;
80003070:	c09c                	sw	a5,0(s1)
	node->prev = successor->prev;
80003072:	c0d8                	sw	a4,4(s1)
	successor->prev->next = node;
80003074:	c304                	sw	s1,0(a4)
	successor->prev = node;
80003076:	c3c4                	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80003078:	4505                	li	a0,1
8000307a:	ad2ff0ef          	jal	ra,8000234c <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000307e:	19c98513          	addi	a0,s3,412
80003082:	2589                	jal	800036c4 <z_spin_unlock_valid>
80003084:	ed0d                	bnez	a0,800030be <z_impl_k_yield+0x16c>
80003086:	80005437          	lui	s0,0x80005
8000308a:	800055b7          	lui	a1,0x80005
8000308e:	80005537          	lui	a0,0x80005
80003092:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003096:	06100693          	li	a3,97
8000309a:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000309e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800030a2:	cc8fe0ef          	jal	ra,8000156a <printk>
800030a6:	80005537          	lui	a0,0x80005
800030aa:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
800030ae:	cbcfe0ef          	jal	ra,8000156a <printk>
800030b2:	06100593          	li	a1,97
800030b6:	bb440513          	addi	a0,s0,-1100
800030ba:	ccefe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800030be:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030c2:	4521                	li	a0,8
800030c4:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800030c8:	4462                	lw	s0,24(sp)
800030ca:	40f2                	lw	ra,28(sp)
800030cc:	44d2                	lw	s1,20(sp)
800030ce:	4942                	lw	s2,16(sp)
800030d0:	49b2                	lw	s3,12(sp)
800030d2:	4a22                	lw	s4,8(sp)
800030d4:	4a92                	lw	s5,4(sp)
800030d6:	8921                	andi	a0,a0,8
800030d8:	6105                	addi	sp,sp,32
800030da:	8f6fd06f          	j	800001d0 <__swap>
	return (node == list->tail) ? NULL : node->next;
800030de:	00e78463          	beq	a5,a4,800030e6 <z_impl_k_yield+0x194>
800030e2:	439c                	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
800030e4:	f3c9                	bnez	a5,80003066 <z_impl_k_yield+0x114>
	node->prev = list->tail;
800030e6:	c0d8                	sw	a4,4(s1)
	list->tail->next = node;
800030e8:	541c                	lw	a5,40(s0)
	node->next = list;
800030ea:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
800030ee:	c384                	sw	s1,0(a5)
	list->tail = node;
800030f0:	d404                	sw	s1,40(s0)
800030f2:	b759                	j	80003078 <z_impl_k_yield+0x126>

800030f4 <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
800030f4:	7179                	addi	sp,sp,-48
800030f6:	d422                	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
800030f8:	80005437          	lui	s0,0x80005
800030fc:	42c42783          	lw	a5,1068(s0) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
{
80003100:	d226                	sw	s1,36(sp)
80003102:	d606                	sw	ra,44(sp)
80003104:	d04a                	sw	s2,32(sp)
80003106:	ce4e                	sw	s3,28(sp)
80003108:	cc52                	sw	s4,24(sp)
8000310a:	84aa                	mv	s1,a0
8000310c:	42c40413          	addi	s0,s0,1068
	__ASSERT(!z_is_in_isr(), "");
80003110:	cf8d                	beqz	a5,8000314a <z_impl_k_sleep+0x56>
80003112:	80005937          	lui	s2,0x80005
80003116:	800055b7          	lui	a1,0x80005
8000311a:	80005537          	lui	a0,0x80005
8000311e:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80003122:	39900693          	li	a3,921
80003126:	e2890613          	addi	a2,s2,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
8000312a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000312e:	c3cfe0ef          	jal	ra,8000156a <printk>
80003132:	80005537          	lui	a0,0x80005
80003136:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
8000313a:	c30fe0ef          	jal	ra,8000156a <printk>
8000313e:	39900593          	li	a1,921
80003142:	e2890513          	addi	a0,s2,-472
80003146:	c42fe0ef          	jal	ra,80001588 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
8000314a:	57fd                	li	a5,-1
8000314c:	16f49a63          	bne	s1,a5,800032c0 <z_impl_k_sleep+0x1cc>
80003150:	80005937          	lui	s2,0x80005
80003154:	800055b7          	lui	a1,0x80005
80003158:	80005537          	lui	a0,0x80005
8000315c:	e7458593          	addi	a1,a1,-396 # 80004e74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e75>
80003160:	39a00693          	li	a3,922
80003164:	e2890613          	addi	a2,s2,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80003168:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000316c:	bfefe0ef          	jal	ra,8000156a <printk>
80003170:	80005537          	lui	a0,0x80005
80003174:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80003178:	bf2fe0ef          	jal	ra,8000156a <printk>
8000317c:	39a00593          	li	a1,922
80003180:	e2890513          	addi	a0,s2,-472
80003184:	c04fe0ef          	jal	ra,80001588 <assert_post_action>
80003188:	45a9                	li	a1,10
8000318a:	00948513          	addi	a0,s1,9
8000318e:	f52fd0ef          	jal	ra,800008e0 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
80003192:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
80003196:	7cf000ef          	jal	ra,80004164 <z_tick_get_32>
8000319a:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
8000319e:	c602                	sw	zero,12(sp)
800031a0:	44a1                	li	s1,8
800031a2:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800031a6:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800031a8:	88a1                	andi	s1,s1,8
800031aa:	2301                	jal	800036aa <z_spin_lock_valid>
800031ac:	ed0d                	bnez	a0,800031e6 <z_impl_k_sleep+0xf2>
800031ae:	80005a37          	lui	s4,0x80005
800031b2:	800055b7          	lui	a1,0x80005
800031b6:	80005537          	lui	a0,0x80005
800031ba:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800031be:	04e00693          	li	a3,78
800031c2:	bb4a0613          	addi	a2,s4,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800031c6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800031ca:	ba0fe0ef          	jal	ra,8000156a <printk>
800031ce:	80005537          	lui	a0,0x80005
800031d2:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800031d6:	b94fe0ef          	jal	ra,8000156a <printk>
800031da:	04e00593          	li	a1,78
800031de:	bb4a0513          	addi	a0,s4,-1100
800031e2:	ba6fe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800031e6:	0068                	addi	a0,sp,12
800031e8:	29fd                	jal	800036e6 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
800031ea:	4408                	lw	a0,8(s0)
800031ec:	f5aff0ef          	jal	ra,80002946 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800031f0:	4408                	lw	a0,8(s0)
800031f2:	800025b7          	lui	a1,0x80002
800031f6:	864e                	mv	a2,s3
800031f8:	0561                	addi	a0,a0,24
800031fa:	67e58593          	addi	a1,a1,1662 # 8000267e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000267f>
800031fe:	081000ef          	jal	ra,80003a7e <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
80003202:	4418                	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003204:	0068                	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80003206:	00d74783          	lbu	a5,13(a4)
8000320a:	0107e793          	ori	a5,a5,16
8000320e:	00f706a3          	sb	a5,13(a4)
80003212:	294d                	jal	800036c4 <z_spin_unlock_valid>
80003214:	ed0d                	bnez	a0,8000324e <z_impl_k_sleep+0x15a>
80003216:	800059b7          	lui	s3,0x80005
8000321a:	800055b7          	lui	a1,0x80005
8000321e:	80005537          	lui	a0,0x80005
80003222:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003226:	07800693          	li	a3,120
8000322a:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000322e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003232:	b38fe0ef          	jal	ra,8000156a <printk>
80003236:	80005537          	lui	a0,0x80005
8000323a:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000323e:	b2cfe0ef          	jal	ra,8000156a <printk>
80003242:	07800593          	li	a1,120
80003246:	bb498513          	addi	a0,s3,-1100
8000324a:	b3efe0ef          	jal	ra,80001588 <assert_post_action>
8000324e:	8526                	mv	a0,s1
80003250:	f81fc0ef          	jal	ra,800001d0 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
80003254:	441c                	lw	a5,8(s0)
80003256:	00d7c783          	lbu	a5,13(a5)
8000325a:	8bc1                	andi	a5,a5,16
8000325c:	cf8d                	beqz	a5,80003296 <z_impl_k_sleep+0x1a2>
8000325e:	80005437          	lui	s0,0x80005
80003262:	800055b7          	lui	a1,0x80005
80003266:	80005537          	lui	a0,0x80005
8000326a:	e8858593          	addi	a1,a1,-376 # 80004e88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e89>
8000326e:	3b700693          	li	a3,951
80003272:	e2840613          	addi	a2,s0,-472 # 80004e28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004e29>
80003276:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000327a:	af0fe0ef          	jal	ra,8000156a <printk>
8000327e:	80005537          	lui	a0,0x80005
80003282:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80003286:	ae4fe0ef          	jal	ra,8000156a <printk>
8000328a:	3b700593          	li	a1,951
8000328e:	e2840513          	addi	a0,s0,-472
80003292:	af6fe0ef          	jal	ra,80001588 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
80003296:	6cf000ef          	jal	ra,80004164 <z_tick_get_32>
8000329a:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
8000329e:	4481                	li	s1,0
	if (ticks > 0) {
800032a0:	02a05463          	blez	a0,800032c8 <z_impl_k_sleep+0x1d4>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
800032a4:	3e800613          	li	a2,1000
800032a8:	4681                	li	a3,0
800032aa:	41f55593          	srai	a1,a0,0x1f
800032ae:	da2fd0ef          	jal	ra,80000850 <__muldi3>
800032b2:	06400613          	li	a2,100
800032b6:	4681                	li	a3,0
800032b8:	fa1fc0ef          	jal	ra,80000258 <__udivdi3>
800032bc:	84aa                	mv	s1,a0
		return __ticks_to_ms(ticks);
800032be:	a029                	j	800032c8 <z_impl_k_sleep+0x1d4>
	if (duration == 0) {
800032c0:	ec0494e3          	bnez	s1,80003188 <z_impl_k_sleep+0x94>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
800032c4:	c8fff0ef          	jal	ra,80002f52 <z_impl_k_yield>
}
800032c8:	50b2                	lw	ra,44(sp)
800032ca:	5422                	lw	s0,40(sp)
800032cc:	8526                	mv	a0,s1
800032ce:	5902                	lw	s2,32(sp)
800032d0:	5492                	lw	s1,36(sp)
800032d2:	49f2                	lw	s3,28(sp)
800032d4:	4a62                	lw	s4,24(sp)
800032d6:	6145                	addi	sp,sp,48
800032d8:	8082                	ret

800032da <z_impl_k_wakeup>:
}
#endif

void z_impl_k_wakeup(k_tid_t thread)
{
	if (z_is_thread_pending(thread)) {
800032da:	00d54783          	lbu	a5,13(a0)
800032de:	8b89                	andi	a5,a5,2
800032e0:	e7a1                	bnez	a5,80003328 <z_impl_k_wakeup+0x4e>
{
800032e2:	1141                	addi	sp,sp,-16
800032e4:	c422                	sw	s0,8(sp)
800032e6:	842a                	mv	s0,a0
	return z_abort_timeout(&thread->base.timeout);
800032e8:	0561                	addi	a0,a0,24
800032ea:	c606                	sw	ra,12(sp)
800032ec:	15b000ef          	jal	ra,80003c46 <z_abort_timeout>
		return;
	}

	if (z_abort_thread_timeout(thread) < 0) {
800032f0:	02054863          	bltz	a0,80003320 <z_impl_k_wakeup+0x46>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800032f4:	00d44783          	lbu	a5,13(s0)
	if (z_is_thread_ready(thread)) {
800032f8:	8522                	mv	a0,s0
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
800032fa:	9bbd                	andi	a5,a5,-17
800032fc:	00f406a3          	sb	a5,13(s0)
	if (z_is_thread_ready(thread)) {
80003300:	b93fe0ef          	jal	ra,80001e92 <z_is_thread_ready>
80003304:	c501                	beqz	a0,8000330c <z_impl_k_wakeup+0x32>
		z_add_thread_to_ready_q(thread);
80003306:	8522                	mv	a0,s0
80003308:	a2eff0ef          	jal	ra,80002536 <z_add_thread_to_ready_q>
	}

	z_mark_thread_as_not_suspended(thread);
	z_ready_thread(thread);

	if (!z_is_in_isr()) {
8000330c:	800057b7          	lui	a5,0x80005
80003310:	42c7a783          	lw	a5,1068(a5) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
80003314:	e791                	bnez	a5,80003320 <z_impl_k_wakeup+0x46>

	if (IS_ENABLED(CONFIG_SMP) &&
	    !IS_ENABLED(CONFIG_SCHED_IPI_SUPPORTED)) {
		z_sched_ipi();
	}
}
80003316:	4422                	lw	s0,8(sp)
80003318:	40b2                	lw	ra,12(sp)
8000331a:	0141                	addi	sp,sp,16
		z_reschedule_unlocked();
8000331c:	e6ffe06f          	j	8000218a <z_reschedule_unlocked>
}
80003320:	40b2                	lw	ra,12(sp)
80003322:	4422                	lw	s0,8(sp)
80003324:	0141                	addi	sp,sp,16
80003326:	8082                	ret
80003328:	8082                	ret

8000332a <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
8000332a:	800057b7          	lui	a5,0x80005
8000332e:	4347a503          	lw	a0,1076(a5) # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
80003332:	8082                	ret

80003334 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80003334:	1101                	addi	sp,sp,-32
80003336:	cc22                	sw	s0,24(sp)
80003338:	ca26                	sw	s1,20(sp)
8000333a:	c84a                	sw	s2,16(sp)
8000333c:	ce06                	sw	ra,28(sp)
8000333e:	c64e                	sw	s3,12(sp)
80003340:	842a                	mv	s0,a0
80003342:	892e                	mv	s2,a1
80003344:	84b2                	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
80003346:	ee0d                	bnez	a2,80003380 <z_impl_k_sem_init+0x4c>
80003348:	800059b7          	lui	s3,0x80005
8000334c:	800055b7          	lui	a1,0x80005
80003350:	80005537          	lui	a0,0x80005
80003354:	f6458593          	addi	a1,a1,-156 # 80004f64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f65>
80003358:	04600693          	li	a3,70
8000335c:	f5498613          	addi	a2,s3,-172 # 80004f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f55>
80003360:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003364:	a06fe0ef          	jal	ra,8000156a <printk>
80003368:	80005537          	lui	a0,0x80005
8000336c:	f7050513          	addi	a0,a0,-144 # 80004f70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f71>
80003370:	9fafe0ef          	jal	ra,8000156a <printk>
80003374:	04600593          	li	a1,70
80003378:	f5498513          	addi	a0,s3,-172
8000337c:	a0cfe0ef          	jal	ra,80001588 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
80003380:	0324fe63          	bgeu	s1,s2,800033bc <z_impl_k_sem_init+0x88>
80003384:	800059b7          	lui	s3,0x80005
80003388:	800055b7          	lui	a1,0x80005
8000338c:	80005537          	lui	a0,0x80005
80003390:	f8858593          	addi	a1,a1,-120 # 80004f88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f89>
80003394:	04700693          	li	a3,71
80003398:	f5498613          	addi	a2,s3,-172 # 80004f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f55>
8000339c:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800033a0:	9cafe0ef          	jal	ra,8000156a <printk>
800033a4:	80005537          	lui	a0,0x80005
800033a8:	fa050513          	addi	a0,a0,-96 # 80004fa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fa1>
800033ac:	9befe0ef          	jal	ra,8000156a <printk>
800033b0:	04700593          	li	a1,71
800033b4:	f5498513          	addi	a0,s3,-172
800033b8:	9d0fe0ef          	jal	ra,80001588 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
800033bc:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
800033c0:	c444                	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
800033c2:	c000                	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
800033c4:	c040                	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
800033c6:	40f2                	lw	ra,28(sp)
800033c8:	4462                	lw	s0,24(sp)
800033ca:	44d2                	lw	s1,20(sp)
800033cc:	4942                	lw	s2,16(sp)
800033ce:	49b2                	lw	s3,12(sp)
800033d0:	6105                	addi	sp,sp,32
800033d2:	8082                	ret

800033d4 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
800033d4:	1101                	addi	sp,sp,-32
800033d6:	ca26                	sw	s1,20(sp)
800033d8:	c64e                	sw	s3,12(sp)
800033da:	ce06                	sw	ra,28(sp)
800033dc:	cc22                	sw	s0,24(sp)
800033de:	c84a                	sw	s2,16(sp)
800033e0:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800033e2:	44a1                	li	s1,8
800033e4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800033e8:	80005437          	lui	s0,0x80005
800033ec:	1a840513          	addi	a0,s0,424 # 800051a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a9>
	key = (mstatus & SOC_MSTATUS_IEN);
800033f0:	88a1                	andi	s1,s1,8
800033f2:	2c65                	jal	800036aa <z_spin_lock_valid>
800033f4:	ed0d                	bnez	a0,8000342e <z_impl_k_sem_give+0x5a>
800033f6:	80005937          	lui	s2,0x80005
800033fa:	800055b7          	lui	a1,0x80005
800033fe:	80005537          	lui	a0,0x80005
80003402:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003406:	04e00693          	li	a3,78
8000340a:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000340e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003412:	958fe0ef          	jal	ra,8000156a <printk>
80003416:	80005537          	lui	a0,0x80005
8000341a:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
8000341e:	94cfe0ef          	jal	ra,8000156a <printk>
80003422:	04e00593          	li	a1,78
80003426:	bb490513          	addi	a0,s2,-1100
8000342a:	95efe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
8000342e:	1a840513          	addi	a0,s0,424
80003432:	2c55                	jal	800036e6 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80003434:	854e                	mv	a0,s3
80003436:	8d7ff0ef          	jal	ra,80002d0c <z_unpend_first_thread>
8000343a:	892a                	mv	s2,a0
	if (thread != NULL) {
8000343c:	c515                	beqz	a0,80003468 <z_impl_k_sem_give+0x94>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
8000343e:	00d54783          	lbu	a5,13(a0)
80003442:	8bfd                	andi	a5,a5,31
80003444:	e789                	bnez	a5,8000344e <z_impl_k_sem_give+0x7a>
	if (z_is_thread_ready(thread)) {
80003446:	4d1c                	lw	a5,24(a0)
80003448:	e399                	bnez	a5,8000344e <z_impl_k_sem_give+0x7a>
		z_add_thread_to_ready_q(thread);
8000344a:	8ecff0ef          	jal	ra,80002536 <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
8000344e:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80003452:	1a840513          	addi	a0,s0,424
}
80003456:	4462                	lw	s0,24(sp)
80003458:	40f2                	lw	ra,28(sp)
8000345a:	4942                	lw	s2,16(sp)
8000345c:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
8000345e:	85a6                	mv	a1,s1
}
80003460:	44d2                	lw	s1,20(sp)
80003462:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
80003464:	c61fe06f          	j	800020c4 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80003468:	0089a703          	lw	a4,8(s3)
8000346c:	00c9a783          	lw	a5,12(s3)
80003470:	8f99                	sub	a5,a5,a4
80003472:	00f037b3          	snez	a5,a5
80003476:	97ba                	add	a5,a5,a4
80003478:	00f9a423          	sw	a5,8(s3)
8000347c:	bfd9                	j	80003452 <z_impl_k_sem_give+0x7e>

8000347e <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
8000347e:	800057b7          	lui	a5,0x80005
80003482:	42c7a783          	lw	a5,1068(a5) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
{
80003486:	1101                	addi	sp,sp,-32
80003488:	c84a                	sw	s2,16(sp)
8000348a:	c64e                	sw	s3,12(sp)
8000348c:	ce06                	sw	ra,28(sp)
8000348e:	cc22                	sw	s0,24(sp)
80003490:	ca26                	sw	s1,20(sp)
80003492:	c452                	sw	s4,8(sp)
80003494:	892a                	mv	s2,a0
80003496:	89ae                	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80003498:	cf95                	beqz	a5,800034d4 <z_impl_k_sem_take+0x56>
8000349a:	cd8d                	beqz	a1,800034d4 <z_impl_k_sem_take+0x56>
8000349c:	80005437          	lui	s0,0x80005
800034a0:	800055b7          	lui	a1,0x80005
800034a4:	80005537          	lui	a0,0x80005
800034a8:	fc858593          	addi	a1,a1,-56 # 80004fc8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004fc9>
800034ac:	08c00693          	li	a3,140
800034b0:	f5440613          	addi	a2,s0,-172 # 80004f54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004f55>
800034b4:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800034b8:	8b2fe0ef          	jal	ra,8000156a <printk>
800034bc:	80005537          	lui	a0,0x80005
800034c0:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
800034c4:	8a6fe0ef          	jal	ra,8000156a <printk>
800034c8:	08c00593          	li	a1,140
800034cc:	f5440513          	addi	a0,s0,-172
800034d0:	8b8fe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800034d4:	4421                	li	s0,8
800034d6:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800034da:	800054b7          	lui	s1,0x80005
800034de:	1a848513          	addi	a0,s1,424 # 800051a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051a9>
	key = (mstatus & SOC_MSTATUS_IEN);
800034e2:	8821                	andi	s0,s0,8
800034e4:	22d9                	jal	800036aa <z_spin_lock_valid>
800034e6:	ed0d                	bnez	a0,80003520 <z_impl_k_sem_take+0xa2>
800034e8:	80005a37          	lui	s4,0x80005
800034ec:	800055b7          	lui	a1,0x80005
800034f0:	80005537          	lui	a0,0x80005
800034f4:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800034f8:	04e00693          	li	a3,78
800034fc:	bb4a0613          	addi	a2,s4,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003500:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003504:	866fe0ef          	jal	ra,8000156a <printk>
80003508:	80005537          	lui	a0,0x80005
8000350c:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003510:	85afe0ef          	jal	ra,8000156a <printk>
80003514:	04e00593          	li	a1,78
80003518:	bb4a0513          	addi	a0,s4,-1100
8000351c:	86cfe0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003520:	1a848513          	addi	a0,s1,424
80003524:	22c9                	jal	800036e6 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80003526:	00892783          	lw	a5,8(s2)
8000352a:	cfb9                	beqz	a5,80003588 <z_impl_k_sem_take+0x10a>
		sem->count--;
8000352c:	17fd                	addi	a5,a5,-1
8000352e:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003532:	1a848513          	addi	a0,s1,424
80003536:	2279                	jal	800036c4 <z_spin_unlock_valid>
80003538:	ed0d                	bnez	a0,80003572 <z_impl_k_sem_take+0xf4>
8000353a:	800054b7          	lui	s1,0x80005
8000353e:	800055b7          	lui	a1,0x80005
80003542:	80005537          	lui	a0,0x80005
80003546:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
8000354a:	06100693          	li	a3,97
8000354e:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003552:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003556:	814fe0ef          	jal	ra,8000156a <printk>
8000355a:	80005537          	lui	a0,0x80005
8000355e:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003562:	808fe0ef          	jal	ra,8000156a <printk>
80003566:	06100593          	li	a1,97
8000356a:	bb448513          	addi	a0,s1,-1100
8000356e:	81afe0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003572:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80003576:	4501                	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80003578:	40f2                	lw	ra,28(sp)
8000357a:	4462                	lw	s0,24(sp)
8000357c:	44d2                	lw	s1,20(sp)
8000357e:	4942                	lw	s2,16(sp)
80003580:	49b2                	lw	s3,12(sp)
80003582:	4a22                	lw	s4,8(sp)
80003584:	6105                	addi	sp,sp,32
80003586:	8082                	ret
	if (timeout == K_NO_WAIT) {
80003588:	04099663          	bnez	s3,800035d4 <z_impl_k_sem_take+0x156>
8000358c:	1a848513          	addi	a0,s1,424
80003590:	2a15                	jal	800036c4 <z_spin_unlock_valid>
80003592:	ed0d                	bnez	a0,800035cc <z_impl_k_sem_take+0x14e>
80003594:	800054b7          	lui	s1,0x80005
80003598:	800055b7          	lui	a1,0x80005
8000359c:	80005537          	lui	a0,0x80005
800035a0:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
800035a4:	06100693          	li	a3,97
800035a8:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800035ac:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800035b0:	fbbfd0ef          	jal	ra,8000156a <printk>
800035b4:	80005537          	lui	a0,0x80005
800035b8:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
800035bc:	faffd0ef          	jal	ra,8000156a <printk>
800035c0:	06100593          	li	a1,97
800035c4:	bb448513          	addi	a0,s1,-1100
800035c8:	fc1fd0ef          	jal	ra,80001588 <assert_post_action>
800035cc:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
800035d0:	5541                	li	a0,-16
800035d2:	b75d                	j	80003578 <z_impl_k_sem_take+0xfa>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035d4:	85a2                	mv	a1,s0
}
800035d6:	4462                	lw	s0,24(sp)
800035d8:	40f2                	lw	ra,28(sp)
800035da:	4a22                	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035dc:	86ce                	mv	a3,s3
800035de:	864a                	mv	a2,s2
}
800035e0:	49b2                	lw	s3,12(sp)
800035e2:	4942                	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035e4:	1a848513          	addi	a0,s1,424
}
800035e8:	44d2                	lw	s1,20(sp)
800035ea:	6105                	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
800035ec:	d1aff06f          	j	80002b06 <z_pend_curr>

800035f0 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
800035f0:	00d54783          	lbu	a5,13(a0)
800035f4:	8bfd                	andi	a5,a5,31
800035f6:	e789                	bnez	a5,80003600 <z_is_thread_ready+0x10>
800035f8:	4d08                	lw	a0,24(a0)
800035fa:	00153513          	seqz	a0,a0
800035fe:	8082                	ret
80003600:	4501                	li	a0,0
}
80003602:	8082                	ret

80003604 <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80003604:	800057b7          	lui	a5,0x80005
80003608:	42c7a503          	lw	a0,1068(a5) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
}
8000360c:	00a03533          	snez	a0,a0
80003610:	8082                	ret

80003612 <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80003612:	800057b7          	lui	a5,0x80005
80003616:	4347a783          	lw	a5,1076(a5) # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
8000361a:	00c7c503          	lbu	a0,12(a5)
}
8000361e:	8905                	andi	a0,a0,1
80003620:	8082                	ret

80003622 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80003622:	1101                	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003624:	5302                	lw	t1,32(sp)
{
80003626:	cc22                	sw	s0,24(sp)
80003628:	ce06                	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000362a:	c01a                	sw	t1,0(sp)
{
8000362c:	842a                	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
8000362e:	90ffd0ef          	jal	ra,80000f3c <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80003632:	800057b7          	lui	a5,0x80005
80003636:	4347a783          	lw	a5,1076(a5) # 80005434 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005435>
	sys_trace_thread_create(new_thread);
}
8000363a:	40f2                	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
8000363c:	57bc                	lw	a5,104(a5)
8000363e:	d43c                	sw	a5,104(s0)
}
80003640:	4462                	lw	s0,24(sp)
80003642:	6105                	addi	sp,sp,32
80003644:	8082                	ret

80003646 <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80003646:	513c                	lw	a5,96(a0)
{
80003648:	1141                	addi	sp,sp,-16
8000364a:	c422                	sw	s0,8(sp)
8000364c:	c606                	sw	ra,12(sp)
8000364e:	842a                	mv	s0,a0
	if (thread->fn_abort != NULL) {
80003650:	c391                	beqz	a5,80003654 <z_thread_single_abort+0xe>
		thread->fn_abort();
80003652:	9782                	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80003654:	8522                	mv	a0,s0
80003656:	f9bff0ef          	jal	ra,800035f0 <z_is_thread_ready>
8000365a:	cd11                	beqz	a0,80003676 <z_thread_single_abort+0x30>
		z_remove_thread_from_ready_q(thread);
8000365c:	8522                	mv	a0,s0
8000365e:	ae8ff0ef          	jal	ra,80002946 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80003662:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80003666:	40b2                	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80003668:	0087e793          	ori	a5,a5,8
8000366c:	00f406a3          	sb	a5,13(s0)
}
80003670:	4422                	lw	s0,8(sp)
80003672:	0141                	addi	sp,sp,16
80003674:	8082                	ret
		if (z_is_thread_pending(thread)) {
80003676:	00d44783          	lbu	a5,13(s0)
8000367a:	8b89                	andi	a5,a5,2
8000367c:	c781                	beqz	a5,80003684 <z_thread_single_abort+0x3e>
			z_unpend_thread_no_timeout(thread);
8000367e:	8522                	mv	a0,s0
80003680:	975fe0ef          	jal	ra,80001ff4 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80003684:	4c1c                	lw	a5,24(s0)
80003686:	dff1                	beqz	a5,80003662 <z_thread_single_abort+0x1c>
80003688:	01840513          	addi	a0,s0,24
8000368c:	2b6d                	jal	80003c46 <z_abort_timeout>
8000368e:	bfd1                	j	80003662 <z_thread_single_abort+0x1c>

80003690 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80003690:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80003694:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80003698:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
8000369c:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
800036a0:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
800036a4:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
800036a8:	8082                	ret

800036aa <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
800036aa:	4108                	lw	a0,0(a0)
800036ac:	c911                	beqz	a0,800036c0 <z_spin_lock_valid+0x16>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
800036ae:	800057b7          	lui	a5,0x80005
800036b2:	4407c783          	lbu	a5,1088(a5) # 80005440 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005441>
800036b6:	890d                	andi	a0,a0,3
800036b8:	8d1d                	sub	a0,a0,a5
800036ba:	00a03533          	snez	a0,a0
800036be:	8082                	ret
			return false;
		}
	}
	return true;
800036c0:	4505                	li	a0,1
}
800036c2:	8082                	ret

800036c4 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
800036c4:	800057b7          	lui	a5,0x80005
800036c8:	42c78793          	addi	a5,a5,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800036cc:	0147c703          	lbu	a4,20(a5)
800036d0:	479c                	lw	a5,8(a5)
800036d2:	8fd9                	or	a5,a5,a4
800036d4:	4118                	lw	a4,0(a0)
800036d6:	00f71663          	bne	a4,a5,800036e2 <z_spin_unlock_valid+0x1e>
		return false;
	}
	l->thread_cpu = 0;
800036da:	00052023          	sw	zero,0(a0)
	return true;
800036de:	4505                	li	a0,1
800036e0:	8082                	ret
		return false;
800036e2:	4501                	li	a0,0
}
800036e4:	8082                	ret

800036e6 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
800036e6:	800057b7          	lui	a5,0x80005
800036ea:	42c78793          	addi	a5,a5,1068 # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
800036ee:	0147c703          	lbu	a4,20(a5)
800036f2:	479c                	lw	a5,8(a5)
800036f4:	8fd9                	or	a5,a5,a4
800036f6:	c11c                	sw	a5,0(a0)
}
800036f8:	8082                	ret

800036fa <z_impl_k_thread_start>:
{
800036fa:	1101                	addi	sp,sp,-32
800036fc:	cc22                	sw	s0,24(sp)
800036fe:	c84a                	sw	s2,16(sp)
80003700:	ce06                	sw	ra,28(sp)
80003702:	ca26                	sw	s1,20(sp)
80003704:	c64e                	sw	s3,12(sp)
80003706:	892a                	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003708:	4421                	li	s0,8
8000370a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000370e:	800054b7          	lui	s1,0x80005
80003712:	1ac48513          	addi	a0,s1,428 # 800051ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051ad>
	key = (mstatus & SOC_MSTATUS_IEN);
80003716:	8821                	andi	s0,s0,8
80003718:	f93ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
8000371c:	ed0d                	bnez	a0,80003756 <z_impl_k_thread_start+0x5c>
8000371e:	800059b7          	lui	s3,0x80005
80003722:	800055b7          	lui	a1,0x80005
80003726:	80005537          	lui	a0,0x80005
8000372a:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000372e:	04e00693          	li	a3,78
80003732:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003736:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000373a:	e31fd0ef          	jal	ra,8000156a <printk>
8000373e:	80005537          	lui	a0,0x80005
80003742:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003746:	e25fd0ef          	jal	ra,8000156a <printk>
8000374a:	04e00593          	li	a1,78
8000374e:	bb498513          	addi	a0,s3,-1100
80003752:	e37fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003756:	1ac48513          	addi	a0,s1,428
8000375a:	f8dff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
8000375e:	00d94783          	lbu	a5,13(s2)
80003762:	0047f713          	andi	a4,a5,4
80003766:	eb39                	bnez	a4,800037bc <z_impl_k_thread_start+0xc2>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003768:	1ac48513          	addi	a0,s1,428
8000376c:	f59ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003770:	ed0d                	bnez	a0,800037aa <z_impl_k_thread_start+0xb0>
80003772:	800054b7          	lui	s1,0x80005
80003776:	800055b7          	lui	a1,0x80005
8000377a:	80005537          	lui	a0,0x80005
8000377e:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003782:	06100693          	li	a3,97
80003786:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000378a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
8000378e:	dddfd0ef          	jal	ra,8000156a <printk>
80003792:	80005537          	lui	a0,0x80005
80003796:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000379a:	dd1fd0ef          	jal	ra,8000156a <printk>
8000379e:	06100593          	li	a1,97
800037a2:	bb448513          	addi	a0,s1,-1100
800037a6:	de3fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800037aa:	30042473          	csrrs	s0,mstatus,s0
}
800037ae:	40f2                	lw	ra,28(sp)
800037b0:	4462                	lw	s0,24(sp)
800037b2:	44d2                	lw	s1,20(sp)
800037b4:	4942                	lw	s2,16(sp)
800037b6:	49b2                	lw	s3,12(sp)
800037b8:	6105                	addi	sp,sp,32
800037ba:	8082                	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
800037bc:	9bed                	andi	a5,a5,-5
800037be:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
800037c2:	854a                	mv	a0,s2
800037c4:	e2dff0ef          	jal	ra,800035f0 <z_is_thread_ready>
800037c8:	c501                	beqz	a0,800037d0 <z_impl_k_thread_start+0xd6>
		z_add_thread_to_ready_q(thread);
800037ca:	854a                	mv	a0,s2
800037cc:	d6bfe0ef          	jal	ra,80002536 <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
800037d0:	85a2                	mv	a1,s0
}
800037d2:	4462                	lw	s0,24(sp)
800037d4:	40f2                	lw	ra,28(sp)
800037d6:	4942                	lw	s2,16(sp)
800037d8:	49b2                	lw	s3,12(sp)
	z_reschedule(&lock, key);
800037da:	1ac48513          	addi	a0,s1,428
}
800037de:	44d2                	lw	s1,20(sp)
800037e0:	6105                	addi	sp,sp,32
	z_reschedule(&lock, key);
800037e2:	8e3fe06f          	j	800020c4 <z_reschedule>

800037e6 <schedule_new_thread>:
	if (delay == 0) {
800037e6:	e199                	bnez	a1,800037ec <schedule_new_thread+0x6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
800037e8:	f13ff06f          	j	800036fa <z_impl_k_thread_start>
{
800037ec:	1141                	addi	sp,sp,-16
800037ee:	c422                	sw	s0,8(sp)
800037f0:	842a                	mv	s0,a0
800037f2:	852e                	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800037f4:	0525                	addi	a0,a0,9
800037f6:	45a9                	li	a1,10
800037f8:	c606                	sw	ra,12(sp)
800037fa:	8e6fd0ef          	jal	ra,800008e0 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
800037fe:	00150613          	addi	a2,a0,1
80003802:	01840513          	addi	a0,s0,24
}
80003806:	4422                	lw	s0,8(sp)
80003808:	40b2                	lw	ra,12(sp)
8000380a:	800025b7          	lui	a1,0x80002
8000380e:	67e58593          	addi	a1,a1,1662 # 8000267e <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000267f>
80003812:	0141                	addi	sp,sp,16
80003814:	a4ad                	j	80003a7e <z_add_timeout>

80003816 <z_impl_k_thread_create>:
{
80003816:	7139                	addi	sp,sp,-64
80003818:	d256                	sw	s5,36(sp)
8000381a:	8ab6                	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000381c:	800056b7          	lui	a3,0x80005
80003820:	42c6a683          	lw	a3,1068(a3) # 8000542c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000542d>
{
80003824:	dc22                	sw	s0,56(sp)
80003826:	da26                	sw	s1,52(sp)
80003828:	d64e                	sw	s3,44(sp)
8000382a:	d452                	sw	s4,40(sp)
8000382c:	de06                	sw	ra,60(sp)
8000382e:	d84a                	sw	s2,48(sp)
80003830:	842a                	mv	s0,a0
80003832:	89ae                	mv	s3,a1
80003834:	8a32                	mv	s4,a2
80003836:	4496                	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
80003838:	c6a9                	beqz	a3,80003882 <z_impl_k_thread_create+0x6c>
8000383a:	80005937          	lui	s2,0x80005
8000383e:	800055b7          	lui	a1,0x80005
80003842:	80005537          	lui	a0,0x80005
80003846:	1b200693          	li	a3,434
8000384a:	ffc90613          	addi	a2,s2,-4 # 80004ffc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004ffd>
8000384e:	dbc58593          	addi	a1,a1,-580 # 80004dbc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dbd>
80003852:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003856:	ce46                	sw	a7,28(sp)
80003858:	cc42                	sw	a6,24(sp)
8000385a:	ca3e                	sw	a5,20(sp)
8000385c:	c83a                	sw	a4,16(sp)
8000385e:	d0dfd0ef          	jal	ra,8000156a <printk>
80003862:	80005537          	lui	a0,0x80005
80003866:	01050513          	addi	a0,a0,16 # 80005010 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005011>
8000386a:	d01fd0ef          	jal	ra,8000156a <printk>
8000386e:	1b200593          	li	a1,434
80003872:	ffc90513          	addi	a0,s2,-4
80003876:	d13fd0ef          	jal	ra,80001588 <assert_post_action>
8000387a:	48f2                	lw	a7,28(sp)
8000387c:	4862                	lw	a6,24(sp)
8000387e:	47d2                	lw	a5,20(sp)
80003880:	4742                	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80003882:	4686                	lw	a3,64(sp)
80003884:	c202                	sw	zero,4(sp)
80003886:	8652                	mv	a2,s4
80003888:	c036                	sw	a3,0(sp)
8000388a:	85ce                	mv	a1,s3
8000388c:	86d6                	mv	a3,s5
8000388e:	8522                	mv	a0,s0
80003890:	d93ff0ef          	jal	ra,80003622 <z_setup_new_thread>
	if (delay != K_FOREVER) {
80003894:	57fd                	li	a5,-1
80003896:	00f48663          	beq	s1,a5,800038a2 <z_impl_k_thread_create+0x8c>
		schedule_new_thread(new_thread, delay);
8000389a:	85a6                	mv	a1,s1
8000389c:	8522                	mv	a0,s0
8000389e:	f49ff0ef          	jal	ra,800037e6 <schedule_new_thread>
}
800038a2:	8522                	mv	a0,s0
800038a4:	50f2                	lw	ra,60(sp)
800038a6:	5462                	lw	s0,56(sp)
800038a8:	54d2                	lw	s1,52(sp)
800038aa:	5942                	lw	s2,48(sp)
800038ac:	59b2                	lw	s3,44(sp)
800038ae:	5a22                	lw	s4,40(sp)
800038b0:	5a92                	lw	s5,36(sp)
800038b2:	6121                	addi	sp,sp,64
800038b4:	8082                	ret

800038b6 <z_init_static_threads>:
{
800038b6:	1101                	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
800038b8:	800057b7          	lui	a5,0x80005
{
800038bc:	c84a                	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800038be:	80005937          	lui	s2,0x80005
{
800038c2:	cc22                	sw	s0,24(sp)
800038c4:	ca26                	sw	s1,20(sp)
800038c6:	ce06                	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
800038c8:	15c78413          	addi	s0,a5,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800038cc:	15c78493          	addi	s1,a5,348
800038d0:	15c90913          	addi	s2,s2,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800038d4:	01246f63          	bltu	s0,s2,800038f2 <z_init_static_threads+0x3c>
	_FOREACH_STATIC_THREAD(thread_data) {
800038d8:	8426                	mv	s0,s1
	k_sched_lock();
800038da:	8bbfe0ef          	jal	ra,80002194 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
800038de:	54fd                	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
800038e0:	03246e63          	bltu	s0,s2,8000391c <z_init_static_threads+0x66>
}
800038e4:	4462                	lw	s0,24(sp)
800038e6:	40f2                	lw	ra,28(sp)
800038e8:	44d2                	lw	s1,20(sp)
800038ea:	4942                	lw	s2,16(sp)
800038ec:	6105                	addi	sp,sp,32
	k_sched_unlock();
800038ee:	af5fe06f          	j	800023e2 <k_sched_unlock>
		z_setup_new_thread(
800038f2:	545c                	lw	a5,44(s0)
800038f4:	c23e                	sw	a5,4(sp)
800038f6:	501c                	lw	a5,32(s0)
800038f8:	c03e                	sw	a5,0(sp)
800038fa:	485c                	lw	a5,20(s0)
800038fc:	01c42883          	lw	a7,28(s0)
80003900:	01842803          	lw	a6,24(s0)
80003904:	4818                	lw	a4,16(s0)
80003906:	4454                	lw	a3,12(s0)
80003908:	4410                	lw	a2,8(s0)
8000390a:	404c                	lw	a1,4(s0)
8000390c:	4008                	lw	a0,0(s0)
8000390e:	d15ff0ef          	jal	ra,80003622 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
80003912:	401c                	lw	a5,0(s0)
80003914:	cfe0                	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
80003916:	03040413          	addi	s0,s0,48
8000391a:	bf6d                	j	800038d4 <z_init_static_threads+0x1e>
		if (thread_data->init_delay != K_FOREVER) {
8000391c:	504c                	lw	a1,36(s0)
8000391e:	00958563          	beq	a1,s1,80003928 <z_init_static_threads+0x72>
			schedule_new_thread(thread_data->init_thread,
80003922:	4008                	lw	a0,0(s0)
80003924:	ec3ff0ef          	jal	ra,800037e6 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
80003928:	03040413          	addi	s0,s0,48
8000392c:	bf55                	j	800038e0 <z_init_static_threads+0x2a>

8000392e <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
8000392e:	1101                	addi	sp,sp,-32
80003930:	cc22                	sw	s0,24(sp)
80003932:	ca26                	sw	s1,20(sp)
80003934:	ce06                	sw	ra,28(sp)
80003936:	c84a                	sw	s2,16(sp)
80003938:	84aa                	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
8000393a:	c602                	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000393c:	4421                	li	s0,8
8000393e:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003942:	0068                	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
80003944:	8821                	andi	s0,s0,8
80003946:	d65ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
8000394a:	ed0d                	bnez	a0,80003984 <z_impl_k_thread_abort+0x56>
8000394c:	80005937          	lui	s2,0x80005
80003950:	800055b7          	lui	a1,0x80005
80003954:	80005537          	lui	a0,0x80005
80003958:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000395c:	04e00693          	li	a3,78
80003960:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003964:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003968:	c03fd0ef          	jal	ra,8000156a <printk>
8000396c:	80005537          	lui	a0,0x80005
80003970:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003974:	bf7fd0ef          	jal	ra,8000156a <printk>
80003978:	04e00593          	li	a1,78
8000397c:	bb490513          	addi	a0,s2,-1100
80003980:	c09fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003984:	0068                	addi	a0,sp,12
80003986:	d61ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
8000398a:	00c4c783          	lbu	a5,12(s1)
8000398e:	8b85                	andi	a5,a5,1
80003990:	cf8d                	beqz	a5,800039ca <z_impl_k_thread_abort+0x9c>
80003992:	80005937          	lui	s2,0x80005
80003996:	800055b7          	lui	a1,0x80005
8000399a:	80005537          	lui	a0,0x80005
8000399e:	05058593          	addi	a1,a1,80 # 80005050 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005051>
800039a2:	02900693          	li	a3,41
800039a6:	03890613          	addi	a2,s2,56 # 80005038 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005039>
800039aa:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800039ae:	bbdfd0ef          	jal	ra,8000156a <printk>
800039b2:	80005537          	lui	a0,0x80005
800039b6:	08450513          	addi	a0,a0,132 # 80005084 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005085>
800039ba:	bb1fd0ef          	jal	ra,8000156a <printk>
800039be:	02900593          	li	a1,41
800039c2:	03890513          	addi	a0,s2,56
800039c6:	bc3fd0ef          	jal	ra,80001588 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
800039ca:	8526                	mv	a0,s1
800039cc:	c7bff0ef          	jal	ra,80003646 <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
800039d0:	85a2                	mv	a1,s0
800039d2:	0068                	addi	a0,sp,12
800039d4:	ef0fe0ef          	jal	ra,800020c4 <z_reschedule>
}
800039d8:	40f2                	lw	ra,28(sp)
800039da:	4462                	lw	s0,24(sp)
800039dc:	44d2                	lw	s1,20(sp)
800039de:	4942                	lw	s2,16(sp)
800039e0:	6105                	addi	sp,sp,32
800039e2:	8082                	ret

800039e4 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
800039e4:	800057b7          	lui	a5,0x80005
800039e8:	1b07a783          	lw	a5,432(a5) # 800051b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b1>
800039ec:	e399                	bnez	a5,800039f2 <elapsed+0xe>
800039ee:	ef5fd06f          	j	800018e2 <z_clock_elapsed>
}
800039f2:	4501                	li	a0,0
800039f4:	8082                	ret

800039f6 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800039f6:	411c                	lw	a5,0(a0)
800039f8:	cd01                	beqz	a0,80003a10 <remove_timeout+0x1a>
800039fa:	80005737          	lui	a4,0x80005
	return (node == list->tail) ? NULL : node->next;
800039fe:	11c72703          	lw	a4,284(a4) # 8000511c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000511d>
80003a02:	00e50763          	beq	a0,a4,80003a10 <remove_timeout+0x1a>
	if (next(t) != NULL) {
80003a06:	c789                	beqz	a5,80003a10 <remove_timeout+0x1a>
		next(t)->dticks += t->dticks;
80003a08:	4798                	lw	a4,8(a5)
80003a0a:	4514                	lw	a3,8(a0)
80003a0c:	9736                	add	a4,a4,a3
80003a0e:	c798                	sw	a4,8(a5)
	node->prev->next = node->next;
80003a10:	4158                	lw	a4,4(a0)
80003a12:	c31c                	sw	a5,0(a4)
	node->next->prev = node->prev;
80003a14:	c3d8                	sw	a4,4(a5)
	node->next = NULL;
80003a16:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80003a1a:	00052223          	sw	zero,4(a0)
}
80003a1e:	8082                	ret

80003a20 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003a20:	800057b7          	lui	a5,0x80005
80003a24:	1b87c783          	lbu	a5,440(a5) # 800051b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b9>
{
80003a28:	1141                	addi	sp,sp,-16
80003a2a:	c606                	sw	ra,12(sp)
80003a2c:	c422                	sw	s0,8(sp)
80003a2e:	c226                	sw	s1,4(sp)
80003a30:	557d                	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80003a32:	e789                	bnez	a5,80003a3c <next_timeout+0x1c>
80003a34:	80000537          	lui	a0,0x80000
80003a38:	fff54513          	not	a0,a0
	return list->head == list;
80003a3c:	800057b7          	lui	a5,0x80005
80003a40:	11878793          	addi	a5,a5,280 # 80005118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005119>
80003a44:	4380                	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003a46:	00f40f63          	beq	s0,a5,80003a64 <next_timeout+0x44>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80003a4a:	cc09                	beqz	s0,80003a64 <next_timeout+0x44>
80003a4c:	4404                	lw	s1,8(s0)
80003a4e:	f97ff0ef          	jal	ra,800039e4 <elapsed>
80003a52:	8c89                	sub	s1,s1,a0
80003a54:	4501                	li	a0,0
80003a56:	0004c763          	bltz	s1,80003a64 <next_timeout+0x44>
80003a5a:	4400                	lw	s0,8(s0)
80003a5c:	f89ff0ef          	jal	ra,800039e4 <elapsed>
80003a60:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
80003a64:	800057b7          	lui	a5,0x80005
80003a68:	43c7a783          	lw	a5,1084(a5) # 8000543c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000543d>
80003a6c:	c781                	beqz	a5,80003a74 <next_timeout+0x54>
80003a6e:	00a7d363          	bge	a5,a0,80003a74 <next_timeout+0x54>
80003a72:	853e                	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80003a74:	40b2                	lw	ra,12(sp)
80003a76:	4422                	lw	s0,8(sp)
80003a78:	4492                	lw	s1,4(sp)
80003a7a:	0141                	addi	sp,sp,16
80003a7c:	8082                	ret

80003a7e <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003a7e:	411c                	lw	a5,0(a0)
{
80003a80:	7179                	addi	sp,sp,-48
80003a82:	d422                	sw	s0,40(sp)
80003a84:	d226                	sw	s1,36(sp)
80003a86:	ce4e                	sw	s3,28(sp)
80003a88:	d606                	sw	ra,44(sp)
80003a8a:	d04a                	sw	s2,32(sp)
80003a8c:	cc52                	sw	s4,24(sp)
80003a8e:	ca56                	sw	s5,20(sp)
80003a90:	c85a                	sw	s6,16(sp)
80003a92:	c65e                	sw	s7,12(sp)
80003a94:	c462                	sw	s8,8(sp)
80003a96:	842a                	mv	s0,a0
80003a98:	89ae                	mv	s3,a1
80003a9a:	84b2                	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
80003a9c:	cf8d                	beqz	a5,80003ad6 <z_add_timeout+0x58>
80003a9e:	80005937          	lui	s2,0x80005
80003aa2:	800055b7          	lui	a1,0x80005
80003aa6:	80005537          	lui	a0,0x80005
80003aaa:	0b458593          	addi	a1,a1,180 # 800050b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050b5>
80003aae:	04d00693          	li	a3,77
80003ab2:	0a090613          	addi	a2,s2,160 # 800050a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050a1>
80003ab6:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003aba:	ab1fd0ef          	jal	ra,8000156a <printk>
80003abe:	80005537          	lui	a0,0x80005
80003ac2:	dd450513          	addi	a0,a0,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80003ac6:	aa5fd0ef          	jal	ra,8000156a <printk>
80003aca:	04d00593          	li	a1,77
80003ace:	0a090513          	addi	a0,s2,160
80003ad2:	ab7fd0ef          	jal	ra,80001588 <assert_post_action>
	to->fn = fn;
80003ad6:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80003ada:	00904363          	bgtz	s1,80003ae0 <z_add_timeout+0x62>
80003ade:	4485                	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ae0:	49a1                	li	s3,8
80003ae2:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ae6:	80005a37          	lui	s4,0x80005
80003aea:	1b4a0513          	addi	a0,s4,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80003aee:	0089f993          	andi	s3,s3,8
80003af2:	bb9ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80003af6:	ed0d                	bnez	a0,80003b30 <z_add_timeout+0xb2>
80003af8:	80005937          	lui	s2,0x80005
80003afc:	800055b7          	lui	a1,0x80005
80003b00:	80005537          	lui	a0,0x80005
80003b04:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003b08:	04e00693          	li	a3,78
80003b0c:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003b10:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003b14:	a57fd0ef          	jal	ra,8000156a <printk>
80003b18:	80005537          	lui	a0,0x80005
80003b1c:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003b20:	a4bfd0ef          	jal	ra,8000156a <printk>
80003b24:	04e00593          	li	a1,78
80003b28:	bb490513          	addi	a0,s2,-1100
80003b2c:	a5dfd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b30:	1b4a0513          	addi	a0,s4,436
80003b34:	bb3ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80003b38:	eadff0ef          	jal	ra,800039e4 <elapsed>
80003b3c:	9526                	add	a0,a0,s1
	return list->head == list;
80003b3e:	800054b7          	lui	s1,0x80005
80003b42:	1184a903          	lw	s2,280(s1) # 80005118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005119>
80003b46:	c408                	sw	a0,8(s0)
80003b48:	11848493          	addi	s1,s1,280
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003b4c:	00990c63          	beq	s2,s1,80003b64 <z_add_timeout+0xe6>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
80003b50:	80005ab7          	lui	s5,0x80005
80003b54:	80005b37          	lui	s6,0x80005
80003b58:	80005bb7          	lui	s7,0x80005
80003b5c:	80005c37          	lui	s8,0x80005
		for (t = first(); t != NULL; t = next(t)) {
80003b60:	00091963          	bnez	s2,80003b72 <z_add_timeout+0xf4>
	node->prev = list->tail;
80003b64:	40dc                	lw	a5,4(s1)
	node->next = list;
80003b66:	c004                	sw	s1,0(s0)
	node->prev = list->tail;
80003b68:	c05c                	sw	a5,4(s0)
	list->tail->next = node;
80003b6a:	40dc                	lw	a5,4(s1)
80003b6c:	c380                	sw	s0,0(a5)
	list->tail = node;
80003b6e:	c0c0                	sw	s0,4(s1)
80003b70:	a891                	j	80003bc4 <z_add_timeout+0x146>
			__ASSERT(t->dticks >= 0, "");
80003b72:	00892783          	lw	a5,8(s2)
80003b76:	0207d663          	bgez	a5,80003ba2 <z_add_timeout+0x124>
80003b7a:	0d4b0593          	addi	a1,s6,212 # 800050d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050d5>
80003b7e:	05600693          	li	a3,86
80003b82:	0a0a8613          	addi	a2,s5,160 # 800050a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800050a1>
80003b86:	b2cb8513          	addi	a0,s7,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003b8a:	9e1fd0ef          	jal	ra,8000156a <printk>
80003b8e:	dd4c0513          	addi	a0,s8,-556 # 80004dd4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004dd5>
80003b92:	9d9fd0ef          	jal	ra,8000156a <printk>
80003b96:	05600593          	li	a1,86
80003b9a:	0a0a8513          	addi	a0,s5,160
80003b9e:	9ebfd0ef          	jal	ra,80001588 <assert_post_action>

			if (t->dticks > to->dticks) {
80003ba2:	00892703          	lw	a4,8(s2)
80003ba6:	441c                	lw	a5,8(s0)
80003ba8:	08e7d763          	bge	a5,a4,80003c36 <z_add_timeout+0x1b8>
				t->dticks -= to->dticks;
80003bac:	40f707b3          	sub	a5,a4,a5
80003bb0:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80003bb4:	00492783          	lw	a5,4(s2)
	node->next = successor;
80003bb8:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
80003bbc:	c05c                	sw	a5,4(s0)
	successor->prev->next = node;
80003bbe:	c380                	sw	s0,0(a5)
	successor->prev = node;
80003bc0:	00892223          	sw	s0,4(s2)
	return list->head == list;
80003bc4:	409c                	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003bc6:	00978963          	beq	a5,s1,80003bd8 <z_add_timeout+0x15a>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80003bca:	00f41763          	bne	s0,a5,80003bd8 <z_add_timeout+0x15a>
			z_clock_set_timeout(next_timeout(), false);
80003bce:	e53ff0ef          	jal	ra,80003a20 <next_timeout>
80003bd2:	4581                	li	a1,0
80003bd4:	bc3fd0ef          	jal	ra,80001796 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003bd8:	1b4a0513          	addi	a0,s4,436
80003bdc:	ae9ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003be0:	ed0d                	bnez	a0,80003c1a <z_add_timeout+0x19c>
80003be2:	80005437          	lui	s0,0x80005
80003be6:	800055b7          	lui	a1,0x80005
80003bea:	80005537          	lui	a0,0x80005
80003bee:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003bf2:	06100693          	li	a3,97
80003bf6:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003bfa:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003bfe:	96dfd0ef          	jal	ra,8000156a <printk>
80003c02:	80005537          	lui	a0,0x80005
80003c06:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003c0a:	961fd0ef          	jal	ra,8000156a <printk>
80003c0e:	06100593          	li	a1,97
80003c12:	bb440513          	addi	a0,s0,-1100
80003c16:	973fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003c1a:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80003c1e:	50b2                	lw	ra,44(sp)
80003c20:	5422                	lw	s0,40(sp)
80003c22:	5492                	lw	s1,36(sp)
80003c24:	5902                	lw	s2,32(sp)
80003c26:	49f2                	lw	s3,28(sp)
80003c28:	4a62                	lw	s4,24(sp)
80003c2a:	4ad2                	lw	s5,20(sp)
80003c2c:	4b42                	lw	s6,16(sp)
80003c2e:	4bb2                	lw	s7,12(sp)
80003c30:	4c22                	lw	s8,8(sp)
80003c32:	6145                	addi	sp,sp,48
80003c34:	8082                	ret
			to->dticks -= t->dticks;
80003c36:	8f99                	sub	a5,a5,a4
80003c38:	c41c                	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
80003c3a:	40dc                	lw	a5,4(s1)
80003c3c:	f32784e3          	beq	a5,s2,80003b64 <z_add_timeout+0xe6>
80003c40:	00092903          	lw	s2,0(s2)
80003c44:	bf31                	j	80003b60 <z_add_timeout+0xe2>

80003c46 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
80003c46:	1101                	addi	sp,sp,-32
80003c48:	cc22                	sw	s0,24(sp)
80003c4a:	c64e                	sw	s3,12(sp)
80003c4c:	ce06                	sw	ra,28(sp)
80003c4e:	ca26                	sw	s1,20(sp)
80003c50:	c84a                	sw	s2,16(sp)
80003c52:	89aa                	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003c54:	4421                	li	s0,8
80003c56:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003c5a:	800054b7          	lui	s1,0x80005
80003c5e:	1b448513          	addi	a0,s1,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80003c62:	8821                	andi	s0,s0,8
80003c64:	a47ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80003c68:	ed0d                	bnez	a0,80003ca2 <z_abort_timeout+0x5c>
80003c6a:	80005937          	lui	s2,0x80005
80003c6e:	800055b7          	lui	a1,0x80005
80003c72:	80005537          	lui	a0,0x80005
80003c76:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003c7a:	04e00693          	li	a3,78
80003c7e:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003c82:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003c86:	8e5fd0ef          	jal	ra,8000156a <printk>
80003c8a:	80005537          	lui	a0,0x80005
80003c8e:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003c92:	8d9fd0ef          	jal	ra,8000156a <printk>
80003c96:	04e00593          	li	a1,78
80003c9a:	bb490513          	addi	a0,s2,-1100
80003c9e:	8ebfd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ca2:	1b448513          	addi	a0,s1,436
80003ca6:	a41ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80003caa:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
80003cae:	5929                	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80003cb0:	c789                	beqz	a5,80003cba <z_abort_timeout+0x74>
			remove_timeout(to);
80003cb2:	854e                	mv	a0,s3
80003cb4:	d43ff0ef          	jal	ra,800039f6 <remove_timeout>
			ret = 0;
80003cb8:	4901                	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003cba:	1b448513          	addi	a0,s1,436
80003cbe:	a07ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003cc2:	ed0d                	bnez	a0,80003cfc <z_abort_timeout+0xb6>
80003cc4:	800054b7          	lui	s1,0x80005
80003cc8:	800055b7          	lui	a1,0x80005
80003ccc:	80005537          	lui	a0,0x80005
80003cd0:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003cd4:	06100693          	li	a3,97
80003cd8:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003cdc:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003ce0:	88bfd0ef          	jal	ra,8000156a <printk>
80003ce4:	80005537          	lui	a0,0x80005
80003ce8:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003cec:	87ffd0ef          	jal	ra,8000156a <printk>
80003cf0:	06100593          	li	a1,97
80003cf4:	bb448513          	addi	a0,s1,-1100
80003cf8:	891fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003cfc:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
80003d00:	40f2                	lw	ra,28(sp)
80003d02:	4462                	lw	s0,24(sp)
80003d04:	854a                	mv	a0,s2
80003d06:	44d2                	lw	s1,20(sp)
80003d08:	4942                	lw	s2,16(sp)
80003d0a:	49b2                	lw	s3,12(sp)
80003d0c:	6105                	addi	sp,sp,32
80003d0e:	8082                	ret

80003d10 <z_get_next_timeout_expiry>:

	return ticks - elapsed();
}

s32_t z_get_next_timeout_expiry(void)
{
80003d10:	1141                	addi	sp,sp,-16
80003d12:	c422                	sw	s0,8(sp)
80003d14:	c606                	sw	ra,12(sp)
80003d16:	c226                	sw	s1,4(sp)
80003d18:	c04a                	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d1a:	4421                	li	s0,8
80003d1c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d20:	800054b7          	lui	s1,0x80005
80003d24:	1b448513          	addi	a0,s1,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d28:	8821                	andi	s0,s0,8
80003d2a:	981ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80003d2e:	ed0d                	bnez	a0,80003d68 <z_get_next_timeout_expiry+0x58>
80003d30:	80005937          	lui	s2,0x80005
80003d34:	800055b7          	lui	a1,0x80005
80003d38:	80005537          	lui	a0,0x80005
80003d3c:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003d40:	04e00693          	li	a3,78
80003d44:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003d48:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003d4c:	81ffd0ef          	jal	ra,8000156a <printk>
80003d50:	80005537          	lui	a0,0x80005
80003d54:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003d58:	813fd0ef          	jal	ra,8000156a <printk>
80003d5c:	04e00593          	li	a1,78
80003d60:	bb490513          	addi	a0,s2,-1100
80003d64:	825fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d68:	1b448513          	addi	a0,s1,436
80003d6c:	97bff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80003d70:	cb1ff0ef          	jal	ra,80003a20 <next_timeout>
80003d74:	892a                	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003d76:	1b448513          	addi	a0,s1,436
80003d7a:	94bff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003d7e:	ed0d                	bnez	a0,80003db8 <z_get_next_timeout_expiry+0xa8>
80003d80:	800054b7          	lui	s1,0x80005
80003d84:	800055b7          	lui	a1,0x80005
80003d88:	80005537          	lui	a0,0x80005
80003d8c:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003d90:	06100693          	li	a3,97
80003d94:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003d98:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003d9c:	fcefd0ef          	jal	ra,8000156a <printk>
80003da0:	80005537          	lui	a0,0x80005
80003da4:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003da8:	fc2fd0ef          	jal	ra,8000156a <printk>
80003dac:	06100593          	li	a1,97
80003db0:	bb448513          	addi	a0,s1,-1100
80003db4:	fd4fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003db8:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
80003dbc:	40b2                	lw	ra,12(sp)
80003dbe:	4422                	lw	s0,8(sp)
80003dc0:	854a                	mv	a0,s2
80003dc2:	4492                	lw	s1,4(sp)
80003dc4:	4902                	lw	s2,0(sp)
80003dc6:	0141                	addi	sp,sp,16
80003dc8:	8082                	ret

80003dca <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
80003dca:	1101                	addi	sp,sp,-32
80003dcc:	cc22                	sw	s0,24(sp)
80003dce:	c84a                	sw	s2,16(sp)
80003dd0:	c452                	sw	s4,8(sp)
80003dd2:	ce06                	sw	ra,28(sp)
80003dd4:	ca26                	sw	s1,20(sp)
80003dd6:	c64e                	sw	s3,12(sp)
80003dd8:	892a                	mv	s2,a0
80003dda:	8a2e                	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ddc:	4421                	li	s0,8
80003dde:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003de2:	800054b7          	lui	s1,0x80005
80003de6:	1b448513          	addi	a0,s1,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80003dea:	8821                	andi	s0,s0,8
80003dec:	8bfff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80003df0:	ed0d                	bnez	a0,80003e2a <z_set_timeout_expiry+0x60>
80003df2:	800059b7          	lui	s3,0x80005
80003df6:	800055b7          	lui	a1,0x80005
80003dfa:	80005537          	lui	a0,0x80005
80003dfe:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003e02:	04e00693          	li	a3,78
80003e06:	bb498613          	addi	a2,s3,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003e0a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003e0e:	f5cfd0ef          	jal	ra,8000156a <printk>
80003e12:	80005537          	lui	a0,0x80005
80003e16:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003e1a:	f50fd0ef          	jal	ra,8000156a <printk>
80003e1e:	04e00593          	li	a1,78
80003e22:	bb498513          	addi	a0,s3,-1100
80003e26:	f62fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80003e2a:	1b448513          	addi	a0,s1,436
80003e2e:	8b9ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80003e32:	befff0ef          	jal	ra,80003a20 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80003e36:	00a95963          	bge	s2,a0,80003e48 <z_set_timeout_expiry+0x7e>
80003e3a:	4785                	li	a5,1
80003e3c:	00a7d663          	bge	a5,a0,80003e48 <z_set_timeout_expiry+0x7e>
			z_clock_set_timeout(ticks, idle);
80003e40:	85d2                	mv	a1,s4
80003e42:	854a                	mv	a0,s2
80003e44:	953fd0ef          	jal	ra,80001796 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003e48:	1b448513          	addi	a0,s1,436
80003e4c:	879ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003e50:	ed0d                	bnez	a0,80003e8a <z_set_timeout_expiry+0xc0>
80003e52:	800054b7          	lui	s1,0x80005
80003e56:	800055b7          	lui	a1,0x80005
80003e5a:	80005537          	lui	a0,0x80005
80003e5e:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003e62:	06100693          	li	a3,97
80003e66:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003e6a:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003e6e:	efcfd0ef          	jal	ra,8000156a <printk>
80003e72:	80005537          	lui	a0,0x80005
80003e76:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003e7a:	ef0fd0ef          	jal	ra,8000156a <printk>
80003e7e:	06100593          	li	a1,97
80003e82:	bb448513          	addi	a0,s1,-1100
80003e86:	f02fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e8a:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
80003e8e:	40f2                	lw	ra,28(sp)
80003e90:	4462                	lw	s0,24(sp)
80003e92:	44d2                	lw	s1,20(sp)
80003e94:	4942                	lw	s2,16(sp)
80003e96:	49b2                	lw	s3,12(sp)
80003e98:	4a22                	lw	s4,8(sp)
80003e9a:	6105                	addi	sp,sp,32
80003e9c:	8082                	ret

80003e9e <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
80003e9e:	7179                	addi	sp,sp,-48
80003ea0:	d422                	sw	s0,40(sp)
80003ea2:	cc52                	sw	s4,24(sp)
80003ea4:	d606                	sw	ra,44(sp)
80003ea6:	d226                	sw	s1,36(sp)
80003ea8:	d04a                	sw	s2,32(sp)
80003eaa:	ce4e                	sw	s3,28(sp)
80003eac:	ca56                	sw	s5,20(sp)
80003eae:	c85a                	sw	s6,16(sp)
80003eb0:	c65e                	sw	s7,12(sp)
80003eb2:	c462                	sw	s8,8(sp)
80003eb4:	c266                	sw	s9,4(sp)
80003eb6:	c06a                	sw	s10,0(sp)
80003eb8:	8a2a                	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003eba:	4421                	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80003ebc:	a2ffe0ef          	jal	ra,800028ea <z_time_slice>
80003ec0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003ec4:	80005937          	lui	s2,0x80005
80003ec8:	1b490513          	addi	a0,s2,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ecc:	8821                	andi	s0,s0,8
80003ece:	fdcff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80003ed2:	ed0d                	bnez	a0,80003f0c <z_clock_announce+0x6e>
80003ed4:	800054b7          	lui	s1,0x80005
80003ed8:	800055b7          	lui	a1,0x80005
80003edc:	80005537          	lui	a0,0x80005
80003ee0:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
80003ee4:	04e00693          	li	a3,78
80003ee8:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003eec:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003ef0:	e7afd0ef          	jal	ra,8000156a <printk>
80003ef4:	80005537          	lui	a0,0x80005
80003ef8:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80003efc:	e6efd0ef          	jal	ra,8000156a <printk>
80003f00:	04e00593          	li	a1,78
80003f04:	bb448513          	addi	a0,s1,-1100
80003f08:	e80fd0ef          	jal	ra,80001588 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80003f0c:	800059b7          	lui	s3,0x80005
	z_spin_lock_set_owner(l);
80003f10:	1b490513          	addi	a0,s2,436
80003f14:	fd2ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
80003f18:	800054b7          	lui	s1,0x80005
80003f1c:	1b49a823          	sw	s4,432(s3) # 800051b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b1>
	return list->head == list;
80003f20:	80005a37          	lui	s4,0x80005
80003f24:	1b098993          	addi	s3,s3,432
80003f28:	118a0a13          	addi	s4,s4,280 # 80005118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005119>
80003f2c:	17848493          	addi	s1,s1,376 # 80005178 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005179>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f30:	80005ab7          	lui	s5,0x80005
80003f34:	80005bb7          	lui	s7,0x80005
80003f38:	80005b37          	lui	s6,0x80005
80003f3c:	80005c37          	lui	s8,0x80005
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003f40:	80005cb7          	lui	s9,0x80005
80003f44:	000a2d03          	lw	s10,0(s4)
80003f48:	0009a783          	lw	a5,0(s3)
80003f4c:	4094                	lw	a3,0(s1)
80003f4e:	40c8                	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f50:	014d0b63          	beq	s10,s4,80003f66 <z_clock_announce+0xc8>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80003f54:	000d0963          	beqz	s10,80003f66 <z_clock_announce+0xc8>
80003f58:	008d2703          	lw	a4,8(s10)
80003f5c:	08e7d663          	bge	a5,a4,80003fe8 <z_clock_announce+0x14a>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80003f60:	8f1d                	sub	a4,a4,a5
80003f62:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80003f66:	96be                	add	a3,a3,a5
80003f68:	41f7d713          	srai	a4,a5,0x1f
80003f6c:	972a                	add	a4,a4,a0
80003f6e:	00f6b7b3          	sltu	a5,a3,a5
80003f72:	97ba                	add	a5,a5,a4
80003f74:	c094                	sw	a3,0(s1)
80003f76:	c0dc                	sw	a5,4(s1)
	announce_remaining = 0;
80003f78:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80003f7c:	aa5ff0ef          	jal	ra,80003a20 <next_timeout>
80003f80:	4581                	li	a1,0
80003f82:	815fd0ef          	jal	ra,80001796 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f86:	1b490513          	addi	a0,s2,436
80003f8a:	f3aff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80003f8e:	ed0d                	bnez	a0,80003fc8 <z_clock_announce+0x12a>
80003f90:	800054b7          	lui	s1,0x80005
80003f94:	800055b7          	lui	a1,0x80005
80003f98:	80005537          	lui	a0,0x80005
80003f9c:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80003fa0:	06100693          	li	a3,97
80003fa4:	bb448613          	addi	a2,s1,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80003fa8:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80003fac:	dbefd0ef          	jal	ra,8000156a <printk>
80003fb0:	80005537          	lui	a0,0x80005
80003fb4:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
80003fb8:	db2fd0ef          	jal	ra,8000156a <printk>
80003fbc:	06100593          	li	a1,97
80003fc0:	bb448513          	addi	a0,s1,-1100
80003fc4:	dc4fd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fc8:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80003fcc:	50b2                	lw	ra,44(sp)
80003fce:	5422                	lw	s0,40(sp)
80003fd0:	5492                	lw	s1,36(sp)
80003fd2:	5902                	lw	s2,32(sp)
80003fd4:	49f2                	lw	s3,28(sp)
80003fd6:	4a62                	lw	s4,24(sp)
80003fd8:	4ad2                	lw	s5,20(sp)
80003fda:	4b42                	lw	s6,16(sp)
80003fdc:	4bb2                	lw	s7,12(sp)
80003fde:	4c22                	lw	s8,8(sp)
80003fe0:	4c92                	lw	s9,4(sp)
80003fe2:	4d02                	lw	s10,0(sp)
80003fe4:	6145                	addi	sp,sp,48
80003fe6:	8082                	ret
		curr_tick += dt;
80003fe8:	96ba                	add	a3,a3,a4
80003fea:	41f75593          	srai	a1,a4,0x1f
80003fee:	95aa                	add	a1,a1,a0
80003ff0:	00e6b633          	sltu	a2,a3,a4
80003ff4:	962e                	add	a2,a2,a1
		announce_remaining -= dt;
80003ff6:	8f99                	sub	a5,a5,a4
		remove_timeout(t);
80003ff8:	856a                	mv	a0,s10
		t->dticks = 0;
80003ffa:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80003ffe:	c094                	sw	a3,0(s1)
80004000:	c0d0                	sw	a2,4(s1)
		announce_remaining -= dt;
80004002:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80004006:	9f1ff0ef          	jal	ra,800039f6 <remove_timeout>
8000400a:	1b490513          	addi	a0,s2,436
8000400e:	eb6ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80004012:	e50d                	bnez	a0,8000403c <z_clock_announce+0x19e>
80004014:	bfcb8593          	addi	a1,s7,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80004018:	06100693          	li	a3,97
8000401c:	bb4a8613          	addi	a2,s5,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
80004020:	b2cb0513          	addi	a0,s6,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80004024:	d46fd0ef          	jal	ra,8000156a <printk>
80004028:	c14c0513          	addi	a0,s8,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000402c:	d3efd0ef          	jal	ra,8000156a <printk>
80004030:	06100593          	li	a1,97
80004034:	bb4a8513          	addi	a0,s5,-1100
80004038:	d50fd0ef          	jal	ra,80001588 <assert_post_action>
8000403c:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80004040:	00cd2783          	lw	a5,12(s10)
80004044:	856a                	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004046:	4421                	li	s0,8
80004048:	9782                	jalr	a5
8000404a:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000404e:	1b490513          	addi	a0,s2,436
	key = (mstatus & SOC_MSTATUS_IEN);
80004052:	8821                	andi	s0,s0,8
80004054:	e56ff0ef          	jal	ra,800036aa <z_spin_lock_valid>
80004058:	e51d                	bnez	a0,80004086 <z_clock_announce+0x1e8>
8000405a:	bccc8593          	addi	a1,s9,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
8000405e:	04e00693          	li	a3,78
80004062:	bb4a8613          	addi	a2,s5,-1100
80004066:	b2cb0513          	addi	a0,s6,-1236
8000406a:	d00fd0ef          	jal	ra,8000156a <printk>
8000406e:	80005537          	lui	a0,0x80005
80004072:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
80004076:	cf4fd0ef          	jal	ra,8000156a <printk>
8000407a:	04e00593          	li	a1,78
8000407e:	bb4a8513          	addi	a0,s5,-1100
80004082:	d06fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
80004086:	1b490513          	addi	a0,s2,436
8000408a:	e5cff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	return k;
8000408e:	bd5d                	j	80003f44 <z_clock_announce+0xa6>

80004090 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80004090:	1101                	addi	sp,sp,-32
80004092:	ca26                	sw	s1,20(sp)
80004094:	ce06                	sw	ra,28(sp)
80004096:	cc22                	sw	s0,24(sp)
80004098:	c84a                	sw	s2,16(sp)
8000409a:	c64e                	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000409c:	44a1                	li	s1,8
8000409e:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040a2:	80005937          	lui	s2,0x80005
800040a6:	1b490513          	addi	a0,s2,436 # 800051b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800051b5>
	key = (mstatus & SOC_MSTATUS_IEN);
800040aa:	88a1                	andi	s1,s1,8
800040ac:	dfeff0ef          	jal	ra,800036aa <z_spin_lock_valid>
800040b0:	ed0d                	bnez	a0,800040ea <z_tick_get+0x5a>
800040b2:	80005437          	lui	s0,0x80005
800040b6:	800055b7          	lui	a1,0x80005
800040ba:	80005537          	lui	a0,0x80005
800040be:	bcc58593          	addi	a1,a1,-1076 # 80004bcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bcd>
800040c2:	04e00693          	li	a3,78
800040c6:	bb440613          	addi	a2,s0,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
800040ca:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
800040ce:	c9cfd0ef          	jal	ra,8000156a <printk>
800040d2:	80005537          	lui	a0,0x80005
800040d6:	be450513          	addi	a0,a0,-1052 # 80004be4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004be5>
800040da:	c90fd0ef          	jal	ra,8000156a <printk>
800040de:	04e00593          	li	a1,78
800040e2:	bb440513          	addi	a0,s0,-1100
800040e6:	ca2fd0ef          	jal	ra,80001588 <assert_post_action>
	z_spin_lock_set_owner(l);
800040ea:	1b490513          	addi	a0,s2,436
800040ee:	df8ff0ef          	jal	ra,800036e6 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
800040f2:	ff0fd0ef          	jal	ra,800018e2 <z_clock_elapsed>
800040f6:	800057b7          	lui	a5,0x80005
800040fa:	17878793          	addi	a5,a5,376 # 80005178 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005179>
800040fe:	0007a983          	lw	s3,0(a5)
80004102:	43c0                	lw	s0,4(a5)
80004104:	99aa                	add	s3,s3,a0
80004106:	00a9b533          	sltu	a0,s3,a0
8000410a:	942a                	add	s0,s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000410c:	1b490513          	addi	a0,s2,436
80004110:	db4ff0ef          	jal	ra,800036c4 <z_spin_unlock_valid>
80004114:	ed0d                	bnez	a0,8000414e <z_tick_get+0xbe>
80004116:	80005937          	lui	s2,0x80005
8000411a:	800055b7          	lui	a1,0x80005
8000411e:	80005537          	lui	a0,0x80005
80004122:	bfc58593          	addi	a1,a1,-1028 # 80004bfc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bfd>
80004126:	06100693          	li	a3,97
8000412a:	bb490613          	addi	a2,s2,-1100 # 80004bb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004bb5>
8000412e:	b2c50513          	addi	a0,a0,-1236 # 80004b2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004b2d>
80004132:	c38fd0ef          	jal	ra,8000156a <printk>
80004136:	80005537          	lui	a0,0x80005
8000413a:	c1450513          	addi	a0,a0,-1004 # 80004c14 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80004c15>
8000413e:	c2cfd0ef          	jal	ra,8000156a <printk>
80004142:	06100593          	li	a1,97
80004146:	bb490513          	addi	a0,s2,-1100
8000414a:	c3efd0ef          	jal	ra,80001588 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000414e:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80004152:	85a2                	mv	a1,s0
80004154:	40f2                	lw	ra,28(sp)
80004156:	4462                	lw	s0,24(sp)
80004158:	854e                	mv	a0,s3
8000415a:	44d2                	lw	s1,20(sp)
8000415c:	4942                	lw	s2,16(sp)
8000415e:	49b2                	lw	s3,12(sp)
80004160:	6105                	addi	sp,sp,32
80004162:	8082                	ret

80004164 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80004164:	1141                	addi	sp,sp,-16
80004166:	c606                	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80004168:	f29ff0ef          	jal	ra,80004090 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
8000416c:	40b2                	lw	ra,12(sp)
8000416e:	0141                	addi	sp,sp,16
80004170:	8082                	ret

80004172 <z_impl_k_uptime_get_32>:

u32_t z_impl_k_uptime_get_32(void)
{
80004172:	1141                	addi	sp,sp,-16
80004174:	c606                	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get_32());
80004176:	fefff0ef          	jal	ra,80004164 <z_tick_get_32>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000417a:	3e800613          	li	a2,1000
8000417e:	4681                	li	a3,0
80004180:	4581                	li	a1,0
80004182:	ecefc0ef          	jal	ra,80000850 <__muldi3>
80004186:	06400613          	li	a2,100
8000418a:	4681                	li	a3,0
8000418c:	8ccfc0ef          	jal	ra,80000258 <__udivdi3>
}
80004190:	40b2                	lw	ra,12(sp)
80004192:	0141                	addi	sp,sp,16
80004194:	8082                	ret

80004196 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80004196:	1141                	addi	sp,sp,-16
80004198:	c422                	sw	s0,8(sp)
8000419a:	c226                	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
8000419c:	80005437          	lui	s0,0x80005
800041a0:	800054b7          	lui	s1,0x80005
{
800041a4:	c606                	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800041a6:	15c40413          	addi	s0,s0,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800041aa:	15c48493          	addi	s1,s1,348 # 8000515c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000515d>
800041ae:	00946863          	bltu	s0,s1,800041be <init_static_pools+0x28>
		k_mem_pool_init(p);
	}

	return 0;
}
800041b2:	40b2                	lw	ra,12(sp)
800041b4:	4422                	lw	s0,8(sp)
800041b6:	4492                	lw	s1,4(sp)
800041b8:	4501                	li	a0,0
800041ba:	0141                	addi	sp,sp,16
800041bc:	8082                	ret
	SYS_DLIST_FOR_EACH_CONTAINER(&((wq)->waitq), thread_ptr, \
				     base.qnode_dlist)

static inline void z_waitq_init(_wait_q_t *w)
{
	sys_dlist_init(&w->waitq);
800041be:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
800041c2:	8522                	mv	a0,s0
	list->head = (sys_dnode_t *)list;
800041c4:	c85c                	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
800041c6:	cc1c                	sw	a5,24(s0)
800041c8:	e8ffc0ef          	jal	ra,80001056 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
800041cc:	0471                	addi	s0,s0,28
800041ce:	b7c5                	j	800041ae <init_static_pools+0x18>

800041d0 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
800041d0:	8082                	ret
