
zephyr/zephyr.elf:     file format elf32-littleriscv


Disassembly of section vector:

80000000 <__start>:

	/*
	 * Set mtvec (Machine Trap-Vector Base-Address Register)
	 * to __irq_wrapper.
	 */
	la t0, __irq_wrapper
80000000:	00000297          	auipc	t0,0x0
80000004:	01028293          	addi	t0,t0,16 # 80000010 <__irq_wrapper>
	csrw mtvec, t0
80000008:	30529073          	csrw	mtvec,t0

	/* Jump to __initialize */
	tail __initialize
8000000c:	4590106f          	j	80001c64 <__initialize>

Disassembly of section exceptions:

80000010 <__irq_wrapper>:
 * In this architecture, system call (ECALL) is used to perform context
 * switching or IRQ offloading (when enabled).
 */
SECTION_FUNC(exception.entry, __irq_wrapper)
	/* Allocate space on thread stack to save registers */
	addi sp, sp, -__NANO_ESF_SIZEOF
80000010:	fb010113          	addi	sp,sp,-80
	 * Save caller-saved registers on current thread stack.
	 * NOTE: need to be updated to account for floating-point registers
	 * floating-point registers should be accounted for when corresponding
	 * config variable is set
	 */
	sw ra, __NANO_ESF_ra_OFFSET(sp)
80000014:	00112023          	sw	ra,0(sp)
	sw gp, __NANO_ESF_gp_OFFSET(sp)
80000018:	00312223          	sw	gp,4(sp)
	sw tp, __NANO_ESF_tp_OFFSET(sp)
8000001c:	00412423          	sw	tp,8(sp)
	sw t0, __NANO_ESF_t0_OFFSET(sp)
80000020:	00512623          	sw	t0,12(sp)
	sw t1, __NANO_ESF_t1_OFFSET(sp)
80000024:	00612823          	sw	t1,16(sp)
	sw t2, __NANO_ESF_t2_OFFSET(sp)
80000028:	00712a23          	sw	t2,20(sp)
	sw t3, __NANO_ESF_t3_OFFSET(sp)
8000002c:	01c12c23          	sw	t3,24(sp)
	sw t4, __NANO_ESF_t4_OFFSET(sp)
80000030:	01d12e23          	sw	t4,28(sp)
	sw t5, __NANO_ESF_t5_OFFSET(sp)
80000034:	03e12023          	sw	t5,32(sp)
	sw t6, __NANO_ESF_t6_OFFSET(sp)
80000038:	03f12223          	sw	t6,36(sp)
	sw a0, __NANO_ESF_a0_OFFSET(sp)
8000003c:	02a12423          	sw	a0,40(sp)
	sw a1, __NANO_ESF_a1_OFFSET(sp)
80000040:	02b12623          	sw	a1,44(sp)
	sw a2, __NANO_ESF_a2_OFFSET(sp)
80000044:	02c12823          	sw	a2,48(sp)
	sw a3, __NANO_ESF_a3_OFFSET(sp)
80000048:	02d12a23          	sw	a3,52(sp)
	sw a4, __NANO_ESF_a4_OFFSET(sp)
8000004c:	02e12c23          	sw	a4,56(sp)
	sw a5, __NANO_ESF_a5_OFFSET(sp)
80000050:	02f12e23          	sw	a5,60(sp)
	sw a6, __NANO_ESF_a6_OFFSET(sp)
80000054:	05012023          	sw	a6,64(sp)
	sw a7, __NANO_ESF_a7_OFFSET(sp)
80000058:	05112223          	sw	a7,68(sp)

	/* Save MEPC register */
	csrr t0, mepc
8000005c:	341022f3          	csrr	t0,mepc
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
80000060:	04512423          	sw	t0,72(sp)

	/* Save SOC-specific MSTATUS register */
	csrr t0, SOC_MSTATUS_REG
80000064:	300022f3          	csrr	t0,mstatus
	sw t0, __NANO_ESF_mstatus_OFFSET(sp)
80000068:	04512623          	sw	t0,76(sp)
	 * SOCs (like pulpino or riscv-qemu), the MSB is never set to indicate
	 * interrupt. Hence, check for interrupt/exception via the __soc_is_irq
	 * function (that needs to be implemented by each SOC). The result is
	 * returned via register a0 (1: interrupt, 0 exception)
	 */
	jal ra, __soc_is_irq
8000006c:	1f0000ef          	jal	ra,8000025c <__soc_is_irq>

	/* If a0 != 0, jump to is_interrupt */
	addi t1, x0, 0
80000070:	00000313          	li	t1,0
	bnez a0, is_interrupt
80000074:	02051e63          	bnez	a0,800000b0 <is_interrupt>
	/*
	 * If the exception is the result of an ECALL, check whether to
	 * perform a context-switch or an IRQ offload. Otherwise call _Fault
	 * to report the exception.
	 */
	csrr t0, mcause
80000078:	342022f3          	csrr	t0,mcause
	li t2, SOC_MCAUSE_EXP_MASK
8000007c:	800003b7          	lui	t2,0x80000
80000080:	fff38393          	addi	t2,t2,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and t0, t0, t2
80000084:	0072f2b3          	and	t0,t0,t2
	li t1, SOC_MCAUSE_ECALL_EXP
80000088:	00b00313          	li	t1,11

	/*
	 * If mcause == SOC_MCAUSE_ECALL_EXP, handle system call,
	 * otherwise handle fault
	 */
	beq t0, t1, is_syscall
8000008c:	00628a63          	beq	t0,t1,800000a0 <is_syscall>
	 * Stack pointer is pointing to a NANO_ESF structure, pass it
	 * to _Fault (via register a0).
	 * If _Fault shall return, set return address to no_reschedule
	 * to restore stack.
	 */
	addi a0, sp, 0
80000090:	00010513          	mv	a0,sp
	la ra, no_reschedule
80000094:	00000097          	auipc	ra,0x0
80000098:	13408093          	addi	ra,ra,308 # 800001c8 <no_reschedule>
	tail _Fault
8000009c:	3010106f          	j	80001b9c <_Fault>

800000a0 <is_syscall>:
	 * again upon exiting the ISR.
	 *
	 * It's safe to always increment by 4, even with compressed
	 * instructions, because the ecall instruction is always 4 bytes.
	 */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a0:	04812283          	lw	t0,72(sp)
	addi t0, t0, 4
800000a4:	00428293          	addi	t0,t0,4
	sw t0, __NANO_ESF_mepc_OFFSET(sp)
800000a8:	04512423          	sw	t0,72(sp)
#endif

	/*
	 * Go to reschedule to handle context-switch
	 */
	j reschedule
800000ac:	0900006f          	j	8000013c <reschedule>

800000b0 <is_interrupt>:
	 * Save current thread stack pointer and switch
	 * stack pointer to interrupt stack.
	 */

	/* Save thread stack pointer to temp register t0 */
	addi t0, sp, 0
800000b0:	00010293          	mv	t0,sp

	/* Switch to interrupt stack */
	la t2, _kernel
800000b4:	00008397          	auipc	t2,0x8
800000b8:	81038393          	addi	t2,t2,-2032 # 800078c4 <_kernel>
	lw sp, _kernel_offset_to_irq_stack(t2)
800000bc:	0043a103          	lw	sp,4(t2)

	/*
	 * Save thread stack pointer on interrupt stack
	 * In RISC-V, stack pointer needs to be 16-byte aligned
	 */
	addi sp, sp, -16
800000c0:	ff010113          	addi	sp,sp,-16
	sw t0, 0x00(sp)
800000c4:	00512023          	sw	t0,0(sp)

800000c8 <on_irq_stack>:

on_irq_stack:
	/* Increment _kernel.nested variable */
	lw t3, _kernel_offset_to_nested(t2)
800000c8:	0003ae03          	lw	t3,0(t2)
	addi t3, t3, 1
800000cc:	001e0e13          	addi	t3,t3,1
	sw t3, _kernel_offset_to_nested(t2)
800000d0:	01c3a023          	sw	t3,0(t2)

	/*
	 * If we are here due to a system call, t1 register should != 0.
	 * In this case, perform IRQ offloading, otherwise jump to call_irq
	 */
	beqz t1, call_irq
800000d4:	00030863          	beqz	t1,800000e4 <call_irq>
	/*
	 * Call z_irq_do_offload to handle IRQ offloading.
	 * Set return address to on_thread_stack in order to jump there
	 * upon returning from z_irq_do_offload
	 */
	la ra, on_thread_stack
800000d8:	00000097          	auipc	ra,0x0
800000dc:	03c08093          	addi	ra,ra,60 # 80000114 <on_thread_stack>
	tail z_irq_do_offload
800000e0:	3490106f          	j	80001c28 <z_irq_do_offload>

800000e4 <call_irq>:
#ifdef CONFIG_TRACING
	call z_sys_trace_isr_enter
#endif

	/* Get IRQ causing interrupt */
	csrr a0, mcause
800000e4:	34202573          	csrr	a0,mcause
	li t0, SOC_MCAUSE_EXP_MASK
800000e8:	800002b7          	lui	t0,0x80000
800000ec:	fff28293          	addi	t0,t0,-1 # 7fffffff <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000000>
	and a0, a0, t0
800000f0:	00557533          	and	a0,a0,t0

	/*
	 * Clear pending IRQ generating the interrupt at SOC level
	 * Pass IRQ number to __soc_handle_irq via register a0
	 */
	jal ra, __soc_handle_irq
800000f4:	158000ef          	jal	ra,8000024c <__soc_handle_irq>

	/*
	 * Call corresponding registered function in _sw_isr_table.
	 * (table is 8-bytes wide, we should shift index by 3)
	 */
	la t0, _sw_isr_table
800000f8:	00006297          	auipc	t0,0x6
800000fc:	17c28293          	addi	t0,t0,380 # 80006274 <_image_text_end>
	slli a0, a0, 3
80000100:	00351513          	slli	a0,a0,0x3
	add t0, t0, a0
80000104:	00a282b3          	add	t0,t0,a0

	/* Load argument in a0 register */
	lw a0, 0x00(t0)
80000108:	0002a503          	lw	a0,0(t0)

	/* Load ISR function address in register t1 */
	lw t1, 0x04(t0)
8000010c:	0042a303          	lw	t1,4(t0)
	lw t1, 0x04(sp)
	lw a0, 0x00(sp)
	addi sp, sp, 16
#endif
	/* Call ISR function */
	jalr ra, t1
80000110:	000300e7          	jalr	t1

80000114 <on_thread_stack>:

on_thread_stack:
	/* Get reference to _kernel */
	la t1, _kernel
80000114:	00007317          	auipc	t1,0x7
80000118:	7b030313          	addi	t1,t1,1968 # 800078c4 <_kernel>

	/* Decrement _kernel.nested variable */
	lw t2, _kernel_offset_to_nested(t1)
8000011c:	00032383          	lw	t2,0(t1)
	addi t2, t2, -1
80000120:	fff38393          	addi	t2,t2,-1
	sw t2, _kernel_offset_to_nested(t1)
80000124:	00732023          	sw	t2,0(t1)

	/* Restore thread stack pointer */
	lw t0, 0x00(sp)
80000128:	00012283          	lw	t0,0(sp)
	addi sp, t0, 0
8000012c:	00028113          	mv	sp,t0
	/*
	 * Check if we need to perform a reschedule
	 */

	/* Get pointer to _kernel.current */
	lw t2, _kernel_offset_to_current(t1)
80000130:	00832383          	lw	t2,8(t1)

	/*
	 * Check if next thread to schedule is current thread.
	 * If yes do not perform a reschedule
	 */
	lw t3, _kernel_offset_to_ready_q_cache(t1)
80000134:	02032e03          	lw	t3,32(t1)
	beq t3, t2, no_reschedule
80000138:	087e0863          	beq	t3,t2,800001c8 <no_reschedule>

8000013c <reschedule>:
reschedule:
#if CONFIG_TRACING
	call z_sys_trace_thread_switched_in
#endif
	/* Get reference to _kernel */
	la t0, _kernel
8000013c:	00007297          	auipc	t0,0x7
80000140:	78828293          	addi	t0,t0,1928 # 800078c4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000144:	0082a303          	lw	t1,8(t0)

	/*
	 * Save callee-saved registers of current thread
	 * prior to handle context-switching
	 */
	sw s0, _thread_offset_to_s0(t1)
80000148:	02832623          	sw	s0,44(t1)
	sw s1, _thread_offset_to_s1(t1)
8000014c:	02932823          	sw	s1,48(t1)
	sw s2, _thread_offset_to_s2(t1)
80000150:	03232a23          	sw	s2,52(t1)
	sw s3, _thread_offset_to_s3(t1)
80000154:	03332c23          	sw	s3,56(t1)
	sw s4, _thread_offset_to_s4(t1)
80000158:	03432e23          	sw	s4,60(t1)
	sw s5, _thread_offset_to_s5(t1)
8000015c:	05532023          	sw	s5,64(t1)
	sw s6, _thread_offset_to_s6(t1)
80000160:	05632223          	sw	s6,68(t1)
	sw s7, _thread_offset_to_s7(t1)
80000164:	05732423          	sw	s7,72(t1)
	sw s8, _thread_offset_to_s8(t1)
80000168:	05832623          	sw	s8,76(t1)
	sw s9, _thread_offset_to_s9(t1)
8000016c:	05932823          	sw	s9,80(t1)
	sw s10, _thread_offset_to_s10(t1)
80000170:	05a32a23          	sw	s10,84(t1)
	sw s11, _thread_offset_to_s11(t1)
80000174:	05b32c23          	sw	s11,88(t1)

	/*
	 * Save stack pointer of current thread and set the default return value
	 * of z_swap to _k_neg_eagain for the thread.
	 */
	sw sp, _thread_offset_to_sp(t1)
80000178:	02232423          	sw	sp,40(t1)
	la t2, _k_neg_eagain
8000017c:	00007397          	auipc	t2,0x7
80000180:	3c438393          	addi	t2,t2,964 # 80007540 <_k_neg_eagain>
	lw t3, 0x00(t2)
80000184:	0003ae03          	lw	t3,0(t2)
	sw t3, _thread_offset_to_swap_return_value(t1)
80000188:	07c32623          	sw	t3,108(t1)

	/* Get next thread to schedule. */
	lw t1, _kernel_offset_to_ready_q_cache(t0)
8000018c:	0202a303          	lw	t1,32(t0)

	/*
	 * Set _kernel.current to new thread loaded in t1
	 */
	sw t1, _kernel_offset_to_current(t0)
80000190:	0062a423          	sw	t1,8(t0)

	/* Switch to new thread stack */
	lw sp, _thread_offset_to_sp(t1)
80000194:	02832103          	lw	sp,40(t1)

	/* Restore callee-saved registers of new thread */
	lw s0, _thread_offset_to_s0(t1)
80000198:	02c32403          	lw	s0,44(t1)
	lw s1, _thread_offset_to_s1(t1)
8000019c:	03032483          	lw	s1,48(t1)
	lw s2, _thread_offset_to_s2(t1)
800001a0:	03432903          	lw	s2,52(t1)
	lw s3, _thread_offset_to_s3(t1)
800001a4:	03832983          	lw	s3,56(t1)
	lw s4, _thread_offset_to_s4(t1)
800001a8:	03c32a03          	lw	s4,60(t1)
	lw s5, _thread_offset_to_s5(t1)
800001ac:	04032a83          	lw	s5,64(t1)
	lw s6, _thread_offset_to_s6(t1)
800001b0:	04432b03          	lw	s6,68(t1)
	lw s7, _thread_offset_to_s7(t1)
800001b4:	04832b83          	lw	s7,72(t1)
	lw s8, _thread_offset_to_s8(t1)
800001b8:	04c32c03          	lw	s8,76(t1)
	lw s9, _thread_offset_to_s9(t1)
800001bc:	05032c83          	lw	s9,80(t1)
	lw s10, _thread_offset_to_s10(t1)
800001c0:	05432d03          	lw	s10,84(t1)
	lw s11, _thread_offset_to_s11(t1)
800001c4:	05832d83          	lw	s11,88(t1)

800001c8 <no_reschedule>:
	addi a0, sp, __NANO_ESF_soc_context_OFFSET
	jal ra, __soc_restore_context
#endif /* CONFIG_RISCV_SOC_CONTEXT_SAVE */

	/* Restore MEPC register */
	lw t0, __NANO_ESF_mepc_OFFSET(sp)
800001c8:	04812283          	lw	t0,72(sp)
	csrw mepc, t0
800001cc:	34129073          	csrw	mepc,t0

	/* Restore SOC-specific MSTATUS register */
	lw t0, __NANO_ESF_mstatus_OFFSET(sp)
800001d0:	04c12283          	lw	t0,76(sp)
	csrw SOC_MSTATUS_REG, t0
800001d4:	30029073          	csrw	mstatus,t0

	/* Restore caller-saved registers from thread stack */
	lw ra, __NANO_ESF_ra_OFFSET(sp)
800001d8:	00012083          	lw	ra,0(sp)
	lw gp, __NANO_ESF_gp_OFFSET(sp)
800001dc:	00412183          	lw	gp,4(sp)
	lw tp, __NANO_ESF_tp_OFFSET(sp)
800001e0:	00812203          	lw	tp,8(sp)
	lw t0, __NANO_ESF_t0_OFFSET(sp)
800001e4:	00c12283          	lw	t0,12(sp)
	lw t1, __NANO_ESF_t1_OFFSET(sp)
800001e8:	01012303          	lw	t1,16(sp)
	lw t2, __NANO_ESF_t2_OFFSET(sp)
800001ec:	01412383          	lw	t2,20(sp)
	lw t3, __NANO_ESF_t3_OFFSET(sp)
800001f0:	01812e03          	lw	t3,24(sp)
	lw t4, __NANO_ESF_t4_OFFSET(sp)
800001f4:	01c12e83          	lw	t4,28(sp)
	lw t5, __NANO_ESF_t5_OFFSET(sp)
800001f8:	02012f03          	lw	t5,32(sp)
	lw t6, __NANO_ESF_t6_OFFSET(sp)
800001fc:	02412f83          	lw	t6,36(sp)
	lw a0, __NANO_ESF_a0_OFFSET(sp)
80000200:	02812503          	lw	a0,40(sp)
	lw a1, __NANO_ESF_a1_OFFSET(sp)
80000204:	02c12583          	lw	a1,44(sp)
	lw a2, __NANO_ESF_a2_OFFSET(sp)
80000208:	03012603          	lw	a2,48(sp)
	lw a3, __NANO_ESF_a3_OFFSET(sp)
8000020c:	03412683          	lw	a3,52(sp)
	lw a4, __NANO_ESF_a4_OFFSET(sp)
80000210:	03812703          	lw	a4,56(sp)
	lw a5, __NANO_ESF_a5_OFFSET(sp)
80000214:	03c12783          	lw	a5,60(sp)
	lw a6, __NANO_ESF_a6_OFFSET(sp)
80000218:	04012803          	lw	a6,64(sp)
	lw a7, __NANO_ESF_a7_OFFSET(sp)
8000021c:	04412883          	lw	a7,68(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
80000220:	05010113          	addi	sp,sp,80

	/* Call SOC_ERET to exit ISR */
	SOC_ERET
80000224:	30200073          	mret

80000228 <__swap>:
	lw a7, __NANO_ESF_a7_OFFSET(sp)

	/* Release stack space */
	addi sp, sp, __NANO_ESF_SIZEOF
#endif
	ecall
80000228:	00000073          	ecall
	 * Prior to unlocking irq, load return value of
	 * __swap to temp register t2 (from
	 * _thread_offset_to_swap_return_value). Normally, it should be -EAGAIN,
	 * unless someone has previously called z_set_thread_return_value(..).
	 */
	la t0, _kernel
8000022c:	00007297          	auipc	t0,0x7
80000230:	69828293          	addi	t0,t0,1688 # 800078c4 <_kernel>

	/* Get pointer to _kernel.current */
	lw t1, _kernel_offset_to_current(t0)
80000234:	0082a303          	lw	t1,8(t0)

	/* Load return value of __swap function in temp register t2 */
	lw t2, _thread_offset_to_swap_return_value(t1)
80000238:	06c32383          	lw	t2,108(t1)

	/*
	 * Unlock irq, following IRQ lock state in a0 register.
	 * Use atomic instruction csrrs to do so.
	 */
	andi a0, a0, SOC_MSTATUS_IEN
8000023c:	00857513          	andi	a0,a0,8
	csrrs t0, mstatus, a0
80000240:	300522f3          	csrrs	t0,mstatus,a0

	/* Set value of return register a0 to value of register t2 */
	addi a0, t2, 0
80000244:	00038513          	mv	a0,t2

	/* Return */
	jalr x0, ra
80000248:	00008067          	ret

8000024c <__soc_handle_irq>:
 * SOC-specific function to handle pending IRQ number generating the interrupt.
 * Exception number is given as parameter via register a0.
 */
SECTION_FUNC(exception.other, __soc_handle_irq)
	/* Clear exception number from CSR mip register */
	li t1, 1
8000024c:	00100313          	li	t1,1
	sll t0, t1, a0
80000250:	00a312b3          	sll	t0,t1,a0
	csrrc t1, mip, t0
80000254:	3442b373          	csrrc	t1,mip,t0

	/* Return */
	jalr x0, ra
80000258:	00008067          	ret

8000025c <__soc_is_irq>:
 * return 1 (interrupt) or 0 (exception)
 *
 */
SECTION_FUNC(exception.other, __soc_is_irq)
	/* Read mcause and check if interrupt bit is set */
	csrr t0, mcause
8000025c:	342022f3          	csrr	t0,mcause
	li t1, SOC_MCAUSE_IRQ_MASK
80000260:	80000337          	lui	t1,0x80000
	and t0, t0, t1
80000264:	0062f2b3          	and	t0,t0,t1

	/* If interrupt bit is not set, return with 0 */
	addi a0, x0, 0
80000268:	00000513          	li	a0,0
	beqz t0, not_interrupt
8000026c:	00028463          	beqz	t0,80000274 <not_interrupt>
	addi a0, a0, 1
80000270:	00150513          	addi	a0,a0,1

80000274 <not_interrupt>:

not_interrupt:
	/* return */
	jalr x0, ra
80000274:	00008067          	ret

Disassembly of section text:

80000278 <__lshrdi3>:
80000278:	02060063          	beqz	a2,80000298 <__lshrdi3+0x20>
8000027c:	02000793          	li	a5,32
80000280:	40c787b3          	sub	a5,a5,a2
80000284:	00f04c63          	bgtz	a5,8000029c <__lshrdi3+0x24>
80000288:	fe060513          	addi	a0,a2,-32
8000028c:	00000713          	li	a4,0
80000290:	00a5d533          	srl	a0,a1,a0
80000294:	00070593          	mv	a1,a4
80000298:	00008067          	ret
8000029c:	00c5d733          	srl	a4,a1,a2
800002a0:	00c55533          	srl	a0,a0,a2
800002a4:	00f595b3          	sll	a1,a1,a5
800002a8:	00b56533          	or	a0,a0,a1
800002ac:	fe9ff06f          	j	80000294 <__lshrdi3+0x1c>

800002b0 <__udivdi3>:
800002b0:	fd010113          	addi	sp,sp,-48
800002b4:	02912223          	sw	s1,36(sp)
800002b8:	01612823          	sw	s6,16(sp)
800002bc:	02112623          	sw	ra,44(sp)
800002c0:	02812423          	sw	s0,40(sp)
800002c4:	03212023          	sw	s2,32(sp)
800002c8:	01312e23          	sw	s3,28(sp)
800002cc:	01412c23          	sw	s4,24(sp)
800002d0:	01512a23          	sw	s5,20(sp)
800002d4:	01712623          	sw	s7,12(sp)
800002d8:	01812423          	sw	s8,8(sp)
800002dc:	01912223          	sw	s9,4(sp)
800002e0:	00050b13          	mv	s6,a0
800002e4:	00058493          	mv	s1,a1
800002e8:	38069c63          	bnez	a3,80000680 <__udivdi3+0x3d0>
800002ec:	00060413          	mv	s0,a2
800002f0:	00050993          	mv	s3,a0
800002f4:	00006917          	auipc	s2,0x6
800002f8:	10090913          	addi	s2,s2,256 # 800063f4 <__devconfig_end>
800002fc:	12c5f863          	bgeu	a1,a2,8000042c <__udivdi3+0x17c>
80000300:	000107b7          	lui	a5,0x10
80000304:	00058a93          	mv	s5,a1
80000308:	10f67863          	bgeu	a2,a5,80000418 <__udivdi3+0x168>
8000030c:	0ff00693          	li	a3,255
80000310:	00c6b6b3          	sltu	a3,a3,a2
80000314:	00369693          	slli	a3,a3,0x3
80000318:	00d657b3          	srl	a5,a2,a3
8000031c:	00f90933          	add	s2,s2,a5
80000320:	00094703          	lbu	a4,0(s2)
80000324:	00d706b3          	add	a3,a4,a3
80000328:	02000713          	li	a4,32
8000032c:	40d70733          	sub	a4,a4,a3
80000330:	00070c63          	beqz	a4,80000348 <__udivdi3+0x98>
80000334:	00e494b3          	sll	s1,s1,a4
80000338:	00db56b3          	srl	a3,s6,a3
8000033c:	00e61433          	sll	s0,a2,a4
80000340:	0096eab3          	or	s5,a3,s1
80000344:	00eb19b3          	sll	s3,s6,a4
80000348:	01045b13          	srli	s6,s0,0x10
8000034c:	000b0593          	mv	a1,s6
80000350:	000a8513          	mv	a0,s5
80000354:	634000ef          	jal	ra,80000988 <__umodsi3>
80000358:	00050913          	mv	s2,a0
8000035c:	000b0593          	mv	a1,s6
80000360:	01041b93          	slli	s7,s0,0x10
80000364:	000a8513          	mv	a0,s5
80000368:	5d8000ef          	jal	ra,80000940 <__udivsi3>
8000036c:	010bdb93          	srli	s7,s7,0x10
80000370:	00050493          	mv	s1,a0
80000374:	00050593          	mv	a1,a0
80000378:	000b8513          	mv	a0,s7
8000037c:	508000ef          	jal	ra,80000884 <__mulsi3>
80000380:	01091913          	slli	s2,s2,0x10
80000384:	0109d713          	srli	a4,s3,0x10
80000388:	00e96733          	or	a4,s2,a4
8000038c:	00048a13          	mv	s4,s1
80000390:	00a77e63          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
80000394:	00870733          	add	a4,a4,s0
80000398:	fff48a13          	addi	s4,s1,-1
8000039c:	00876863          	bltu	a4,s0,800003ac <__udivdi3+0xfc>
800003a0:	00a77663          	bgeu	a4,a0,800003ac <__udivdi3+0xfc>
800003a4:	ffe48a13          	addi	s4,s1,-2
800003a8:	00870733          	add	a4,a4,s0
800003ac:	40a704b3          	sub	s1,a4,a0
800003b0:	000b0593          	mv	a1,s6
800003b4:	00048513          	mv	a0,s1
800003b8:	5d0000ef          	jal	ra,80000988 <__umodsi3>
800003bc:	00050913          	mv	s2,a0
800003c0:	000b0593          	mv	a1,s6
800003c4:	00048513          	mv	a0,s1
800003c8:	578000ef          	jal	ra,80000940 <__udivsi3>
800003cc:	01099993          	slli	s3,s3,0x10
800003d0:	00050493          	mv	s1,a0
800003d4:	00050593          	mv	a1,a0
800003d8:	01091913          	slli	s2,s2,0x10
800003dc:	000b8513          	mv	a0,s7
800003e0:	0109d993          	srli	s3,s3,0x10
800003e4:	4a0000ef          	jal	ra,80000884 <__mulsi3>
800003e8:	013969b3          	or	s3,s2,s3
800003ec:	00048613          	mv	a2,s1
800003f0:	00a9fc63          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
800003f4:	013409b3          	add	s3,s0,s3
800003f8:	fff48613          	addi	a2,s1,-1
800003fc:	0089e663          	bltu	s3,s0,80000408 <__udivdi3+0x158>
80000400:	00a9f463          	bgeu	s3,a0,80000408 <__udivdi3+0x158>
80000404:	ffe48613          	addi	a2,s1,-2
80000408:	010a1793          	slli	a5,s4,0x10
8000040c:	00c7e7b3          	or	a5,a5,a2
80000410:	00000a13          	li	s4,0
80000414:	1300006f          	j	80000544 <__udivdi3+0x294>
80000418:	010007b7          	lui	a5,0x1000
8000041c:	01000693          	li	a3,16
80000420:	eef66ce3          	bltu	a2,a5,80000318 <__udivdi3+0x68>
80000424:	01800693          	li	a3,24
80000428:	ef1ff06f          	j	80000318 <__udivdi3+0x68>
8000042c:	00068a13          	mv	s4,a3
80000430:	00061a63          	bnez	a2,80000444 <__udivdi3+0x194>
80000434:	00000593          	li	a1,0
80000438:	00100513          	li	a0,1
8000043c:	504000ef          	jal	ra,80000940 <__udivsi3>
80000440:	00050413          	mv	s0,a0
80000444:	000107b7          	lui	a5,0x10
80000448:	12f47c63          	bgeu	s0,a5,80000580 <__udivdi3+0x2d0>
8000044c:	0ff00793          	li	a5,255
80000450:	0087f463          	bgeu	a5,s0,80000458 <__udivdi3+0x1a8>
80000454:	00800a13          	li	s4,8
80000458:	014457b3          	srl	a5,s0,s4
8000045c:	00f90933          	add	s2,s2,a5
80000460:	00094683          	lbu	a3,0(s2)
80000464:	02000613          	li	a2,32
80000468:	014686b3          	add	a3,a3,s4
8000046c:	40d60633          	sub	a2,a2,a3
80000470:	12061263          	bnez	a2,80000594 <__udivdi3+0x2e4>
80000474:	408484b3          	sub	s1,s1,s0
80000478:	00100a13          	li	s4,1
8000047c:	01045b13          	srli	s6,s0,0x10
80000480:	000b0593          	mv	a1,s6
80000484:	00048513          	mv	a0,s1
80000488:	500000ef          	jal	ra,80000988 <__umodsi3>
8000048c:	00050913          	mv	s2,a0
80000490:	000b0593          	mv	a1,s6
80000494:	00048513          	mv	a0,s1
80000498:	01041b93          	slli	s7,s0,0x10
8000049c:	4a4000ef          	jal	ra,80000940 <__udivsi3>
800004a0:	010bdb93          	srli	s7,s7,0x10
800004a4:	00050493          	mv	s1,a0
800004a8:	00050593          	mv	a1,a0
800004ac:	000b8513          	mv	a0,s7
800004b0:	3d4000ef          	jal	ra,80000884 <__mulsi3>
800004b4:	01091913          	slli	s2,s2,0x10
800004b8:	0109d713          	srli	a4,s3,0x10
800004bc:	00e96733          	or	a4,s2,a4
800004c0:	00048a93          	mv	s5,s1
800004c4:	00a77e63          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004c8:	00870733          	add	a4,a4,s0
800004cc:	fff48a93          	addi	s5,s1,-1
800004d0:	00876863          	bltu	a4,s0,800004e0 <__udivdi3+0x230>
800004d4:	00a77663          	bgeu	a4,a0,800004e0 <__udivdi3+0x230>
800004d8:	ffe48a93          	addi	s5,s1,-2
800004dc:	00870733          	add	a4,a4,s0
800004e0:	40a704b3          	sub	s1,a4,a0
800004e4:	000b0593          	mv	a1,s6
800004e8:	00048513          	mv	a0,s1
800004ec:	49c000ef          	jal	ra,80000988 <__umodsi3>
800004f0:	00050913          	mv	s2,a0
800004f4:	000b0593          	mv	a1,s6
800004f8:	00048513          	mv	a0,s1
800004fc:	444000ef          	jal	ra,80000940 <__udivsi3>
80000500:	01099993          	slli	s3,s3,0x10
80000504:	00050493          	mv	s1,a0
80000508:	00050593          	mv	a1,a0
8000050c:	01091913          	slli	s2,s2,0x10
80000510:	000b8513          	mv	a0,s7
80000514:	0109d993          	srli	s3,s3,0x10
80000518:	36c000ef          	jal	ra,80000884 <__mulsi3>
8000051c:	013969b3          	or	s3,s2,s3
80000520:	00048613          	mv	a2,s1
80000524:	00a9fc63          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000528:	013409b3          	add	s3,s0,s3
8000052c:	fff48613          	addi	a2,s1,-1
80000530:	0089e663          	bltu	s3,s0,8000053c <__udivdi3+0x28c>
80000534:	00a9f463          	bgeu	s3,a0,8000053c <__udivdi3+0x28c>
80000538:	ffe48613          	addi	a2,s1,-2
8000053c:	010a9793          	slli	a5,s5,0x10
80000540:	00c7e7b3          	or	a5,a5,a2
80000544:	00078513          	mv	a0,a5
80000548:	000a0593          	mv	a1,s4
8000054c:	02c12083          	lw	ra,44(sp)
80000550:	02812403          	lw	s0,40(sp)
80000554:	02412483          	lw	s1,36(sp)
80000558:	02012903          	lw	s2,32(sp)
8000055c:	01c12983          	lw	s3,28(sp)
80000560:	01812a03          	lw	s4,24(sp)
80000564:	01412a83          	lw	s5,20(sp)
80000568:	01012b03          	lw	s6,16(sp)
8000056c:	00c12b83          	lw	s7,12(sp)
80000570:	00812c03          	lw	s8,8(sp)
80000574:	00412c83          	lw	s9,4(sp)
80000578:	03010113          	addi	sp,sp,48
8000057c:	00008067          	ret
80000580:	010007b7          	lui	a5,0x1000
80000584:	01000a13          	li	s4,16
80000588:	ecf468e3          	bltu	s0,a5,80000458 <__udivdi3+0x1a8>
8000058c:	01800a13          	li	s4,24
80000590:	ec9ff06f          	j	80000458 <__udivdi3+0x1a8>
80000594:	00c41433          	sll	s0,s0,a2
80000598:	00d4da33          	srl	s4,s1,a3
8000059c:	00cb19b3          	sll	s3,s6,a2
800005a0:	00db56b3          	srl	a3,s6,a3
800005a4:	01045b13          	srli	s6,s0,0x10
800005a8:	00c494b3          	sll	s1,s1,a2
800005ac:	000b0593          	mv	a1,s6
800005b0:	000a0513          	mv	a0,s4
800005b4:	0096eab3          	or	s5,a3,s1
800005b8:	3d0000ef          	jal	ra,80000988 <__umodsi3>
800005bc:	00050913          	mv	s2,a0
800005c0:	000b0593          	mv	a1,s6
800005c4:	000a0513          	mv	a0,s4
800005c8:	01041b93          	slli	s7,s0,0x10
800005cc:	374000ef          	jal	ra,80000940 <__udivsi3>
800005d0:	010bdb93          	srli	s7,s7,0x10
800005d4:	00050493          	mv	s1,a0
800005d8:	00050593          	mv	a1,a0
800005dc:	000b8513          	mv	a0,s7
800005e0:	2a4000ef          	jal	ra,80000884 <__mulsi3>
800005e4:	01091913          	slli	s2,s2,0x10
800005e8:	010ad713          	srli	a4,s5,0x10
800005ec:	00e96733          	or	a4,s2,a4
800005f0:	00048a13          	mv	s4,s1
800005f4:	00a77e63          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
800005f8:	00870733          	add	a4,a4,s0
800005fc:	fff48a13          	addi	s4,s1,-1
80000600:	00876863          	bltu	a4,s0,80000610 <__udivdi3+0x360>
80000604:	00a77663          	bgeu	a4,a0,80000610 <__udivdi3+0x360>
80000608:	ffe48a13          	addi	s4,s1,-2
8000060c:	00870733          	add	a4,a4,s0
80000610:	40a704b3          	sub	s1,a4,a0
80000614:	000b0593          	mv	a1,s6
80000618:	00048513          	mv	a0,s1
8000061c:	36c000ef          	jal	ra,80000988 <__umodsi3>
80000620:	00050913          	mv	s2,a0
80000624:	000b0593          	mv	a1,s6
80000628:	00048513          	mv	a0,s1
8000062c:	314000ef          	jal	ra,80000940 <__udivsi3>
80000630:	00050493          	mv	s1,a0
80000634:	00050593          	mv	a1,a0
80000638:	000b8513          	mv	a0,s7
8000063c:	248000ef          	jal	ra,80000884 <__mulsi3>
80000640:	010a9693          	slli	a3,s5,0x10
80000644:	01091913          	slli	s2,s2,0x10
80000648:	0106d693          	srli	a3,a3,0x10
8000064c:	00d967b3          	or	a5,s2,a3
80000650:	00048713          	mv	a4,s1
80000654:	00a7fe63          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000658:	008787b3          	add	a5,a5,s0
8000065c:	fff48713          	addi	a4,s1,-1
80000660:	0087e863          	bltu	a5,s0,80000670 <__udivdi3+0x3c0>
80000664:	00a7f663          	bgeu	a5,a0,80000670 <__udivdi3+0x3c0>
80000668:	ffe48713          	addi	a4,s1,-2
8000066c:	008787b3          	add	a5,a5,s0
80000670:	010a1a13          	slli	s4,s4,0x10
80000674:	40a784b3          	sub	s1,a5,a0
80000678:	00ea6a33          	or	s4,s4,a4
8000067c:	e01ff06f          	j	8000047c <__udivdi3+0x1cc>
80000680:	1ed5ec63          	bltu	a1,a3,80000878 <__udivdi3+0x5c8>
80000684:	000107b7          	lui	a5,0x10
80000688:	04f6f463          	bgeu	a3,a5,800006d0 <__udivdi3+0x420>
8000068c:	0ff00593          	li	a1,255
80000690:	00d5b533          	sltu	a0,a1,a3
80000694:	00351513          	slli	a0,a0,0x3
80000698:	00a6d733          	srl	a4,a3,a0
8000069c:	00006797          	auipc	a5,0x6
800006a0:	d5878793          	addi	a5,a5,-680 # 800063f4 <__devconfig_end>
800006a4:	00e787b3          	add	a5,a5,a4
800006a8:	0007c583          	lbu	a1,0(a5)
800006ac:	02000a13          	li	s4,32
800006b0:	00a585b3          	add	a1,a1,a0
800006b4:	40ba0a33          	sub	s4,s4,a1
800006b8:	020a1663          	bnez	s4,800006e4 <__udivdi3+0x434>
800006bc:	00100793          	li	a5,1
800006c0:	e896e2e3          	bltu	a3,s1,80000544 <__udivdi3+0x294>
800006c4:	00cb3633          	sltu	a2,s6,a2
800006c8:	00164793          	xori	a5,a2,1
800006cc:	e79ff06f          	j	80000544 <__udivdi3+0x294>
800006d0:	010007b7          	lui	a5,0x1000
800006d4:	01000513          	li	a0,16
800006d8:	fcf6e0e3          	bltu	a3,a5,80000698 <__udivdi3+0x3e8>
800006dc:	01800513          	li	a0,24
800006e0:	fb9ff06f          	j	80000698 <__udivdi3+0x3e8>
800006e4:	00b65ab3          	srl	s5,a2,a1
800006e8:	014696b3          	sll	a3,a3,s4
800006ec:	00daeab3          	or	s5,s5,a3
800006f0:	00b4d933          	srl	s2,s1,a1
800006f4:	014497b3          	sll	a5,s1,s4
800006f8:	00bb55b3          	srl	a1,s6,a1
800006fc:	010adb93          	srli	s7,s5,0x10
80000700:	00f5e4b3          	or	s1,a1,a5
80000704:	00090513          	mv	a0,s2
80000708:	000b8593          	mv	a1,s7
8000070c:	014619b3          	sll	s3,a2,s4
80000710:	278000ef          	jal	ra,80000988 <__umodsi3>
80000714:	00050413          	mv	s0,a0
80000718:	000b8593          	mv	a1,s7
8000071c:	00090513          	mv	a0,s2
80000720:	010a9c13          	slli	s8,s5,0x10
80000724:	21c000ef          	jal	ra,80000940 <__udivsi3>
80000728:	010c5c13          	srli	s8,s8,0x10
8000072c:	00050913          	mv	s2,a0
80000730:	00050593          	mv	a1,a0
80000734:	000c0513          	mv	a0,s8
80000738:	14c000ef          	jal	ra,80000884 <__mulsi3>
8000073c:	01041413          	slli	s0,s0,0x10
80000740:	0104d713          	srli	a4,s1,0x10
80000744:	00e46733          	or	a4,s0,a4
80000748:	00090c93          	mv	s9,s2
8000074c:	00a77e63          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000750:	01570733          	add	a4,a4,s5
80000754:	fff90c93          	addi	s9,s2,-1
80000758:	01576863          	bltu	a4,s5,80000768 <__udivdi3+0x4b8>
8000075c:	00a77663          	bgeu	a4,a0,80000768 <__udivdi3+0x4b8>
80000760:	ffe90c93          	addi	s9,s2,-2
80000764:	01570733          	add	a4,a4,s5
80000768:	40a70933          	sub	s2,a4,a0
8000076c:	000b8593          	mv	a1,s7
80000770:	00090513          	mv	a0,s2
80000774:	214000ef          	jal	ra,80000988 <__umodsi3>
80000778:	00050413          	mv	s0,a0
8000077c:	000b8593          	mv	a1,s7
80000780:	00090513          	mv	a0,s2
80000784:	1bc000ef          	jal	ra,80000940 <__udivsi3>
80000788:	00050913          	mv	s2,a0
8000078c:	00050593          	mv	a1,a0
80000790:	000c0513          	mv	a0,s8
80000794:	0f0000ef          	jal	ra,80000884 <__mulsi3>
80000798:	01049793          	slli	a5,s1,0x10
8000079c:	01041413          	slli	s0,s0,0x10
800007a0:	0107d793          	srli	a5,a5,0x10
800007a4:	00f46733          	or	a4,s0,a5
800007a8:	00090613          	mv	a2,s2
800007ac:	00a77e63          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007b0:	01570733          	add	a4,a4,s5
800007b4:	fff90613          	addi	a2,s2,-1
800007b8:	01576863          	bltu	a4,s5,800007c8 <__udivdi3+0x518>
800007bc:	00a77663          	bgeu	a4,a0,800007c8 <__udivdi3+0x518>
800007c0:	ffe90613          	addi	a2,s2,-2
800007c4:	01570733          	add	a4,a4,s5
800007c8:	010c9793          	slli	a5,s9,0x10
800007cc:	00010e37          	lui	t3,0x10
800007d0:	00c7e7b3          	or	a5,a5,a2
800007d4:	fffe0813          	addi	a6,t3,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
800007d8:	0107f333          	and	t1,a5,a6
800007dc:	0109f833          	and	a6,s3,a6
800007e0:	40a70733          	sub	a4,a4,a0
800007e4:	0107de93          	srli	t4,a5,0x10
800007e8:	0109d993          	srli	s3,s3,0x10
800007ec:	00030513          	mv	a0,t1
800007f0:	00080593          	mv	a1,a6
800007f4:	090000ef          	jal	ra,80000884 <__mulsi3>
800007f8:	00050893          	mv	a7,a0
800007fc:	00098593          	mv	a1,s3
80000800:	00030513          	mv	a0,t1
80000804:	080000ef          	jal	ra,80000884 <__mulsi3>
80000808:	00050313          	mv	t1,a0
8000080c:	00080593          	mv	a1,a6
80000810:	000e8513          	mv	a0,t4
80000814:	070000ef          	jal	ra,80000884 <__mulsi3>
80000818:	00050813          	mv	a6,a0
8000081c:	00098593          	mv	a1,s3
80000820:	000e8513          	mv	a0,t4
80000824:	060000ef          	jal	ra,80000884 <__mulsi3>
80000828:	0108d693          	srli	a3,a7,0x10
8000082c:	01030333          	add	t1,t1,a6
80000830:	006686b3          	add	a3,a3,t1
80000834:	0106f463          	bgeu	a3,a6,8000083c <__udivdi3+0x58c>
80000838:	01c50533          	add	a0,a0,t3
8000083c:	0106d613          	srli	a2,a3,0x10
80000840:	00a60533          	add	a0,a2,a0
80000844:	02a76663          	bltu	a4,a0,80000870 <__udivdi3+0x5c0>
80000848:	bca714e3          	bne	a4,a0,80000410 <__udivdi3+0x160>
8000084c:	00010737          	lui	a4,0x10
80000850:	fff70713          	addi	a4,a4,-1 # ffff <CONFIG_ISR_STACK_SIZE+0xf7ff>
80000854:	00e6f6b3          	and	a3,a3,a4
80000858:	01069693          	slli	a3,a3,0x10
8000085c:	00e8f8b3          	and	a7,a7,a4
80000860:	014b1633          	sll	a2,s6,s4
80000864:	011686b3          	add	a3,a3,a7
80000868:	00000a13          	li	s4,0
8000086c:	ccd67ce3          	bgeu	a2,a3,80000544 <__udivdi3+0x294>
80000870:	fff78793          	addi	a5,a5,-1 # ffffff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x48e4ff>
80000874:	b9dff06f          	j	80000410 <__udivdi3+0x160>
80000878:	00000a13          	li	s4,0
8000087c:	00000793          	li	a5,0
80000880:	cc5ff06f          	j	80000544 <__udivdi3+0x294>

80000884 <__mulsi3>:
80000884:	00050613          	mv	a2,a0
80000888:	00000513          	li	a0,0
8000088c:	0015f693          	andi	a3,a1,1
80000890:	00068463          	beqz	a3,80000898 <__mulsi3+0x14>
80000894:	00c50533          	add	a0,a0,a2
80000898:	0015d593          	srli	a1,a1,0x1
8000089c:	00161613          	slli	a2,a2,0x1
800008a0:	fe0596e3          	bnez	a1,8000088c <__mulsi3+0x8>
800008a4:	00008067          	ret

800008a8 <__muldi3>:
800008a8:	ff010113          	addi	sp,sp,-16
800008ac:	00068313          	mv	t1,a3
800008b0:	00112623          	sw	ra,12(sp)
800008b4:	00050e13          	mv	t3,a0
800008b8:	00050893          	mv	a7,a0
800008bc:	00060693          	mv	a3,a2
800008c0:	00000713          	li	a4,0
800008c4:	00000793          	li	a5,0
800008c8:	00000813          	li	a6,0
800008cc:	0016f513          	andi	a0,a3,1
800008d0:	00171e93          	slli	t4,a4,0x1
800008d4:	00050c63          	beqz	a0,800008ec <__muldi3+0x44>
800008d8:	01088533          	add	a0,a7,a6
800008dc:	01053833          	sltu	a6,a0,a6
800008e0:	00e787b3          	add	a5,a5,a4
800008e4:	00f807b3          	add	a5,a6,a5
800008e8:	00050813          	mv	a6,a0
800008ec:	01f8d713          	srli	a4,a7,0x1f
800008f0:	0016d693          	srli	a3,a3,0x1
800008f4:	00eee733          	or	a4,t4,a4
800008f8:	00189893          	slli	a7,a7,0x1
800008fc:	fc0698e3          	bnez	a3,800008cc <__muldi3+0x24>
80000900:	00058863          	beqz	a1,80000910 <__muldi3+0x68>
80000904:	00060513          	mv	a0,a2
80000908:	f7dff0ef          	jal	ra,80000884 <__mulsi3>
8000090c:	00a787b3          	add	a5,a5,a0
80000910:	00030a63          	beqz	t1,80000924 <__muldi3+0x7c>
80000914:	000e0513          	mv	a0,t3
80000918:	00030593          	mv	a1,t1
8000091c:	f69ff0ef          	jal	ra,80000884 <__mulsi3>
80000920:	00f507b3          	add	a5,a0,a5
80000924:	00c12083          	lw	ra,12(sp)
80000928:	00080513          	mv	a0,a6
8000092c:	00078593          	mv	a1,a5
80000930:	01010113          	addi	sp,sp,16
80000934:	00008067          	ret

80000938 <__divsi3>:
80000938:	06054063          	bltz	a0,80000998 <__umodsi3+0x10>
8000093c:	0605c663          	bltz	a1,800009a8 <__umodsi3+0x20>

80000940 <__udivsi3>:
80000940:	00058613          	mv	a2,a1
80000944:	00050593          	mv	a1,a0
80000948:	fff00513          	li	a0,-1
8000094c:	02060c63          	beqz	a2,80000984 <__udivsi3+0x44>
80000950:	00100693          	li	a3,1
80000954:	00b67a63          	bgeu	a2,a1,80000968 <__udivsi3+0x28>
80000958:	00c05863          	blez	a2,80000968 <__udivsi3+0x28>
8000095c:	00161613          	slli	a2,a2,0x1
80000960:	00169693          	slli	a3,a3,0x1
80000964:	feb66ae3          	bltu	a2,a1,80000958 <__udivsi3+0x18>
80000968:	00000513          	li	a0,0
8000096c:	00c5e663          	bltu	a1,a2,80000978 <__udivsi3+0x38>
80000970:	40c585b3          	sub	a1,a1,a2
80000974:	00d56533          	or	a0,a0,a3
80000978:	0016d693          	srli	a3,a3,0x1
8000097c:	00165613          	srli	a2,a2,0x1
80000980:	fe0696e3          	bnez	a3,8000096c <__udivsi3+0x2c>
80000984:	00008067          	ret

80000988 <__umodsi3>:
80000988:	00008293          	mv	t0,ra
8000098c:	fb5ff0ef          	jal	ra,80000940 <__udivsi3>
80000990:	00058513          	mv	a0,a1
80000994:	00028067          	jr	t0
80000998:	40a00533          	neg	a0,a0
8000099c:	0005d863          	bgez	a1,800009ac <__umodsi3+0x24>
800009a0:	40b005b3          	neg	a1,a1
800009a4:	f9dff06f          	j	80000940 <__udivsi3>
800009a8:	40b005b3          	neg	a1,a1
800009ac:	00008293          	mv	t0,ra
800009b0:	f91ff0ef          	jal	ra,80000940 <__udivsi3>
800009b4:	40a00533          	neg	a0,a0
800009b8:	00028067          	jr	t0

800009bc <__modsi3>:
800009bc:	00008293          	mv	t0,ra
800009c0:	0005ca63          	bltz	a1,800009d4 <__modsi3+0x18>
800009c4:	00054c63          	bltz	a0,800009dc <__modsi3+0x20>
800009c8:	f79ff0ef          	jal	ra,80000940 <__udivsi3>
800009cc:	00058513          	mv	a0,a1
800009d0:	00028067          	jr	t0
800009d4:	40b005b3          	neg	a1,a1
800009d8:	fe0558e3          	bgez	a0,800009c8 <__modsi3+0xc>
800009dc:	40a00533          	neg	a0,a0
800009e0:	f61ff0ef          	jal	ra,80000940 <__udivsi3>
800009e4:	40b00533          	neg	a0,a1
800009e8:	00028067          	jr	t0

800009ec <unit_test_noop>:
 * nothing, successfully. Can be used as a parameter to
 * ztest_unit_test_setup_teardown().
 */
static inline void unit_test_noop(void)
{
}
800009ec:	00008067          	ret

800009f0 <init_timer_data>:
		}				 \
	} while (0)

static void init_timer_data(void)
{
	tdata.expire_cnt = 0;
800009f0:	800077b7          	lui	a5,0x80007
800009f4:	6e878793          	addi	a5,a5,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800009f8:	0007a023          	sw	zero,0(a5)
	tdata.stop_cnt = 0;
800009fc:	0007a223          	sw	zero,4(a5)
}
80000a00:	00008067          	ret

80000a04 <duration_stop>:
	}
}

static void duration_stop(struct k_timer *timer)
{
	tdata.stop_cnt++;
80000a04:	800077b7          	lui	a5,0x80007
80000a08:	6e878793          	addi	a5,a5,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
80000a0c:	0047a703          	lw	a4,4(a5)
80000a10:	00170713          	addi	a4,a4,1
80000a14:	00e7a223          	sw	a4,4(a5)
}
80000a18:	00008067          	ret

80000a1c <period0_expire>:

static void period0_expire(struct k_timer *timer)
{
	tdata.expire_cnt++;
80000a1c:	800077b7          	lui	a5,0x80007
80000a20:	6e878793          	addi	a5,a5,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
80000a24:	0007a703          	lw	a4,0(a5)
80000a28:	00170713          	addi	a4,a4,1
80000a2c:	00e7a023          	sw	a4,0(a5)
}
80000a30:	00008067          	ret

80000a34 <user_data_timer_handler>:

static int user_data_correct[5] = { 0, 0, 0, 0, 0 };

static void user_data_timer_handler(struct k_timer *timer)
{
	int timer_num = timer == user_data_timer[0] ? 0 :
80000a34:	800077b7          	lui	a5,0x80007
80000a38:	5a478793          	addi	a5,a5,1444 # 800075a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a5>
80000a3c:	06f50663          	beq	a0,a5,80000aa8 <user_data_timer_handler+0x74>
			timer == user_data_timer[1] ? 1 :
80000a40:	800077b7          	lui	a5,0x80007
80000a44:	5d078793          	addi	a5,a5,1488 # 800075d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075d1>
80000a48:	06f50463          	beq	a0,a5,80000ab0 <user_data_timer_handler+0x7c>
			timer == user_data_timer[2] ? 2 :
80000a4c:	800077b7          	lui	a5,0x80007
80000a50:	5fc78793          	addi	a5,a5,1532 # 800075fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075fd>
80000a54:	06f50263          	beq	a0,a5,80000ab8 <user_data_timer_handler+0x84>
			timer == user_data_timer[3] ? 3 :
80000a58:	800077b7          	lui	a5,0x80007
80000a5c:	62878793          	addi	a5,a5,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
80000a60:	06f50063          	beq	a0,a5,80000ac0 <user_data_timer_handler+0x8c>
			timer == user_data_timer[4] ? 4 : -1;
80000a64:	800077b7          	lui	a5,0x80007
80000a68:	65478793          	addi	a5,a5,1620 # 80007654 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007655>
80000a6c:	02f51c63          	bne	a0,a5,80000aa4 <user_data_timer_handler+0x70>
80000a70:	00400793          	li	a5,4
	if (timer_num == -1) {
		return;
	}

	intptr_t data_retrieved = (intptr_t)k_timer_user_data_get(timer);
	user_data_correct[timer_num] = user_data[timer_num] == data_retrieved;
80000a74:	800076b7          	lui	a3,0x80007
80000a78:	00279793          	slli	a5,a5,0x2
80000a7c:	80007737          	lui	a4,0x80007
80000a80:	a4868693          	addi	a3,a3,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
80000a84:	00f686b3          	add	a3,a3,a5
80000a88:	75070713          	addi	a4,a4,1872 # 80007750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007751>
80000a8c:	00f70733          	add	a4,a4,a5
80000a90:	0006a683          	lw	a3,0(a3)
80000a94:	02852783          	lw	a5,40(a0)
80000a98:	40d787b3          	sub	a5,a5,a3
80000a9c:	0017b793          	seqz	a5,a5
80000aa0:	00f72023          	sw	a5,0(a4)
}
80000aa4:	00008067          	ret
	int timer_num = timer == user_data_timer[0] ? 0 :
80000aa8:	00000793          	li	a5,0
80000aac:	fc9ff06f          	j	80000a74 <user_data_timer_handler+0x40>
			timer == user_data_timer[1] ? 1 :
80000ab0:	00100793          	li	a5,1
80000ab4:	fc1ff06f          	j	80000a74 <user_data_timer_handler+0x40>
			timer == user_data_timer[2] ? 2 :
80000ab8:	00200793          	li	a5,2
80000abc:	fb9ff06f          	j	80000a74 <user_data_timer_handler+0x40>
			timer == user_data_timer[3] ? 3 :
80000ac0:	00300793          	li	a5,3
80000ac4:	fb1ff06f          	j	80000a74 <user_data_timer_handler+0x40>

80000ac8 <z_impl_k_timer_remaining_get>:
 * @return Remaining time (in milliseconds).
 */
__syscall u32_t k_timer_remaining_get(struct k_timer *timer);

static inline u32_t z_impl_k_timer_remaining_get(struct k_timer *timer)
{
80000ac8:	ff010113          	addi	sp,sp,-16
80000acc:	00112623          	sw	ra,12(sp)
	const s32_t ticks = z_timeout_remaining(&timer->timeout);
80000ad0:	3f9040ef          	jal	ra,800056c8 <z_timeout_remaining>
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
80000ad4:	02a05663          	blez	a0,80000b00 <z_impl_k_timer_remaining_get+0x38>
#ifdef _NEED_PRECISE_TICK_MS_CONVERSION
	/* use 64-bit math to keep precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
#else
	/* simple multiplication keeps precision */
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80000ad8:	3e800613          	li	a2,1000
80000adc:	00000693          	li	a3,0
80000ae0:	41f55593          	srai	a1,a0,0x1f
80000ae4:	dc5ff0ef          	jal	ra,800008a8 <__muldi3>
80000ae8:	06400613          	li	a2,100
80000aec:	00000693          	li	a3,0
80000af0:	fc0ff0ef          	jal	ra,800002b0 <__udivdi3>
}
80000af4:	00c12083          	lw	ra,12(sp)
80000af8:	01010113          	addi	sp,sp,16
80000afc:	00008067          	ret
	return (ticks > 0) ? (u32_t)__ticks_to_ms(ticks) : 0U;
80000b00:	00000513          	li	a0,0
80000b04:	ff1ff06f          	j	80000af4 <z_impl_k_timer_remaining_get+0x2c>

80000b08 <z_zassert.constprop.6>:
#define z_zassert(cond, default_msg, file, line, func, msg, ...)	\
	z_zassert_(cond, file, line)

#else /* CONFIG_ZTEST_ASSERT_VERBOSE != 0 */

static inline void z_zassert(int cond,
80000b08:	fd010113          	addi	sp,sp,-48
80000b0c:	00112e23          	sw	ra,28(sp)
80000b10:	03012423          	sw	a6,40(sp)
80000b14:	03112623          	sw	a7,44(sp)
			    const char *default_msg,
			    const char *file,
			    int line, const char *func,
			    const char *msg, ...)
{
	if (!(cond)) {
80000b18:	04051663          	bnez	a0,80000b64 <z_zassert.constprop.6+0x5c>
80000b1c:	00068613          	mv	a2,a3
		va_list vargs;

		va_start(vargs, msg);
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b20:	80007537          	lui	a0,0x80007
80000b24:	00070693          	mv	a3,a4
80000b28:	00058713          	mv	a4,a1
80000b2c:	800075b7          	lui	a1,0x80007
		va_start(vargs, msg);
80000b30:	02810793          	addi	a5,sp,40
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b34:	a7058593          	addi	a1,a1,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000b38:	a9c50513          	addi	a0,a0,-1380 # 80006a9c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a9d>
		va_start(vargs, msg);
80000b3c:	00f12623          	sw	a5,12(sp)
		PRINT("\n    Assertion failed at %s:%d: %s: %s\n",
80000b40:	2a5010ef          	jal	ra,800025e4 <printk>
		      file, line, func, default_msg);
		vprintk(msg, vargs);
80000b44:	00c12583          	lw	a1,12(sp)
80000b48:	80007537          	lui	a0,0x80007
80000b4c:	b1850513          	addi	a0,a0,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000b50:	265010ef          	jal	ra,800025b4 <vprintk>
		printk("\n");
80000b54:	80007537          	lui	a0,0x80007
80000b58:	44c50513          	addi	a0,a0,1100 # 8000744c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000744d>
80000b5c:	289010ef          	jal	ra,800025e4 <printk>
		va_end(vargs);
		ztest_test_fail();
80000b60:	190020ef          	jal	ra,80002cf0 <ztest_test_fail>
	else {
		PRINT("\n   Assertion succeeded at %s:%d (%s)\n",
		      file, line, func);
	}
#endif
}
80000b64:	01c12083          	lw	ra,28(sp)
80000b68:	03010113          	addi	sp,sp,48
80000b6c:	00008067          	ret

80000b70 <test_timer_user_data>:
 *
 * @see K_TIMER_DEFINE(), k_timer_user_data_set(), k_timer_start(),
 * k_timer_user_data_get(), k_timer_stop()
 */
void test_timer_user_data(void)
{
80000b70:	fd010113          	addi	sp,sp,-48
80000b74:	02812423          	sw	s0,40(sp)
80000b78:	03212023          	sw	s2,32(sp)
80000b7c:	01412c23          	sw	s4,24(sp)
80000b80:	01512a23          	sw	s5,20(sp)
	int ii;

	for (ii = 0; ii < 5; ii++) {
		intptr_t check;

		k_timer_user_data_set(user_data_timer[ii],
80000b84:	80007437          	lui	s0,0x80007
				      (void *)user_data[ii]);
80000b88:	80007937          	lui	s2,0x80007
		check = (intptr_t)k_timer_user_data_get(user_data_timer[ii]);

		zassert_true(check == user_data[ii], NULL);
80000b8c:	80006a37          	lui	s4,0x80006
80000b90:	80007ab7          	lui	s5,0x80007
{
80000b94:	02912223          	sw	s1,36(sp)
80000b98:	01312e23          	sw	s3,28(sp)
80000b9c:	01612823          	sw	s6,16(sp)
80000ba0:	01712623          	sw	s7,12(sp)
80000ba4:	02112623          	sw	ra,44(sp)
80000ba8:	00000493          	li	s1,0
		k_timer_user_data_set(user_data_timer[ii],
80000bac:	a5c40413          	addi	s0,s0,-1444 # 80006a5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a5d>
				      (void *)user_data[ii]);
80000bb0:	a4890913          	addi	s2,s2,-1464 # 80006a48 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a49>
		zassert_true(check == user_data[ii], NULL);
80000bb4:	800079b7          	lui	s3,0x80007
80000bb8:	000a0b13          	mv	s6,s4
80000bbc:	000a8b93          	mv	s7,s5
		k_timer_user_data_set(user_data_timer[ii],
80000bc0:	009407b3          	add	a5,s0,s1
				      (void *)user_data[ii]);
80000bc4:	00990733          	add	a4,s2,s1
		k_timer_user_data_set(user_data_timer[ii],
80000bc8:	0007a783          	lw	a5,0(a5)
 * @internal
 */
static inline void z_impl_k_timer_user_data_set(struct k_timer *timer,
					       void *user_data)
{
	timer->user_data = user_data;
80000bcc:	00072703          	lw	a4,0(a4)
		zassert_true(check == user_data[ii], NULL);
80000bd0:	800075b7          	lui	a1,0x80007
80000bd4:	1d500693          	li	a3,469
80000bd8:	02e7a423          	sw	a4,40(a5)
80000bdc:	a7098613          	addi	a2,s3,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000be0:	b18a8793          	addi	a5,s5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000be4:	5e8a0713          	addi	a4,s4,1512 # 800065e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065e9>
80000be8:	a0858593          	addi	a1,a1,-1528 # 80006a08 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a09>
80000bec:	00100513          	li	a0,1
80000bf0:	f19ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80000bf4:	00448493          	addi	s1,s1,4
	for (ii = 0; ii < 5; ii++) {
80000bf8:	01400793          	li	a5,20
80000bfc:	fcf492e3          	bne	s1,a5,80000bc0 <test_timer_user_data+0x50>
80000c00:	03200493          	li	s1,50
	}

	for (ii = 0; ii < 5; ii++) {
80000c04:	12c00913          	li	s2,300

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_THREAD_NAME_SET, k_thread_name_set, k_tid_t, thread_id, const char *, value)

K_SYSCALL_DECLARE1(K_SYSCALL_K_THREAD_NAME_GET, k_thread_name_get, const char *, k_tid_t, thread_id)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000c08:	00042503          	lw	a0,0(s0)
80000c0c:	00048593          	mv	a1,s1
80000c10:	00000613          	li	a2,0
80000c14:	03248493          	addi	s1,s1,50
80000c18:	21c050ef          	jal	ra,80005e34 <z_impl_k_timer_start>
80000c1c:	00440413          	addi	s0,s0,4
80000c20:	ff2494e3          	bne	s1,s2,80000c08 <test_timer_user_data+0x98>
K_SYSCALL_DECLARE1(K_SYSCALL_K_SLEEP, k_sleep, s32_t, s32_t, duration)
80000c24:	12c00513          	li	a0,300
80000c28:	305030ef          	jal	ra,8000472c <z_impl_k_sleep>

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000c2c:	80007537          	lui	a0,0x80007
80000c30:	5a450513          	addi	a0,a0,1444 # 800075a4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075a5>
80000c34:	2cc050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80000c38:	80007537          	lui	a0,0x80007
80000c3c:	5d050513          	addi	a0,a0,1488 # 800075d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075d1>
80000c40:	2c0050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80000c44:	80007537          	lui	a0,0x80007
80000c48:	5fc50513          	addi	a0,a0,1532 # 800075fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800075fd>
80000c4c:	2b4050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80000c50:	80007537          	lui	a0,0x80007
80000c54:	62850513          	addi	a0,a0,1576 # 80007628 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007629>
80000c58:	2a8050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80000c5c:	80007537          	lui	a0,0x80007
80000c60:	80007437          	lui	s0,0x80007
80000c64:	65450513          	addi	a0,a0,1620 # 80007654 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007655>
80000c68:	75040413          	addi	s0,s0,1872 # 80007750 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007751>
80000c6c:	294050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80000c70:	01440493          	addi	s1,s0,20
	for (ii = 0; ii < 5; ii++) {
		k_timer_stop(user_data_timer[ii]);
	}

	for (ii = 0; ii < 5; ii++) {
		zassert_true(user_data_correct[ii], NULL);
80000c74:	80007937          	lui	s2,0x80007
80000c78:	00042503          	lw	a0,0(s0)
80000c7c:	b18b8793          	addi	a5,s7,-1256
80000c80:	5e8b0713          	addi	a4,s6,1512
80000c84:	1e300693          	li	a3,483
80000c88:	a7098613          	addi	a2,s3,-1424
80000c8c:	a2890593          	addi	a1,s2,-1496 # 80006a28 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a29>
80000c90:	00440413          	addi	s0,s0,4
80000c94:	e75ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	for (ii = 0; ii < 5; ii++) {
80000c98:	fe8490e3          	bne	s1,s0,80000c78 <test_timer_user_data+0x108>
	}
}
80000c9c:	02c12083          	lw	ra,44(sp)
80000ca0:	02812403          	lw	s0,40(sp)
80000ca4:	02412483          	lw	s1,36(sp)
80000ca8:	02012903          	lw	s2,32(sp)
80000cac:	01c12983          	lw	s3,28(sp)
80000cb0:	01812a03          	lw	s4,24(sp)
80000cb4:	01412a83          	lw	s5,20(sp)
80000cb8:	01012b03          	lw	s6,16(sp)
80000cbc:	00c12b83          	lw	s7,12(sp)
80000cc0:	03010113          	addi	sp,sp,48
80000cc4:	00008067          	ret

80000cc8 <test_timer_remaining_get>:
 * @see k_timer_init(), k_timer_start(), k_timer_stop(),
 * k_timer_remaining_get()
 */

void test_timer_remaining_get(void)
{
80000cc8:	ff010113          	addi	sp,sp,-16
80000ccc:	00112623          	sw	ra,12(sp)
80000cd0:	00812423          	sw	s0,8(sp)
80000cd4:	00912223          	sw	s1,4(sp)
	u32_t remaining;

	init_timer_data();
	k_timer_init(&timer, NULL, NULL);
80000cd8:	80007437          	lui	s0,0x80007
	init_timer_data();
80000cdc:	d15ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80000ce0:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80000ce4:	00000613          	li	a2,0
80000ce8:	00000593          	li	a1,0
80000cec:	120050ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000cf0:	00000613          	li	a2,0
80000cf4:	06400593          	li	a1,100
80000cf8:	72440513          	addi	a0,s0,1828
80000cfc:	138050ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000d00:	0000c537          	lui	a0,0xc
80000d04:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
80000d08:	028040ef          	jal	ra,80004d30 <z_impl_k_busy_wait>

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000d0c:	72440513          	addi	a0,s0,1828
80000d10:	db9ff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
80000d14:	00050493          	mv	s1,a0
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000d18:	72440513          	addi	a0,s0,1828
80000d1c:	1e4050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
	k_timer_start(&timer, DURATION, 0);
	busy_wait_ms(DURATION / 2);
	remaining = k_timer_remaining_get(&timer);
	k_timer_stop(&timer);
	zassert_true(remaining <= (DURATION / 2), NULL);
}
80000d20:	00812403          	lw	s0,8(sp)
80000d24:	00c12083          	lw	ra,12(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000d28:	0334b513          	sltiu	a0,s1,51
}
80000d2c:	00412483          	lw	s1,4(sp)
	zassert_true(remaining <= (DURATION / 2), NULL);
80000d30:	800077b7          	lui	a5,0x80007
80000d34:	80006737          	lui	a4,0x80006
80000d38:	80007637          	lui	a2,0x80007
80000d3c:	800075b7          	lui	a1,0x80007
80000d40:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000d44:	60070713          	addi	a4,a4,1536 # 80006600 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006601>
80000d48:	20000693          	li	a3,512
80000d4c:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000d50:	8e058593          	addi	a1,a1,-1824 # 800068e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068e1>
}
80000d54:	01010113          	addi	sp,sp,16
	zassert_true(remaining <= (DURATION / 2), NULL);
80000d58:	db1ff06f          	j	80000b08 <z_zassert.constprop.6>

80000d5c <status_expire>:
{
80000d5c:	ff010113          	addi	sp,sp,-16
80000d60:	00812423          	sw	s0,8(sp)
80000d64:	00112623          	sw	ra,12(sp)
80000d68:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000d6c:	21c050ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(timer) == 1, timer);
80000d70:	00100793          	li	a5,1
80000d74:	04f50263          	beq	a0,a5,80000db8 <status_expire+0x5c>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000d78:	00040513          	mv	a0,s0
80000d7c:	184050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000d80:	00040513          	mv	a0,s0
80000d84:	204050ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
80000d88:	fff50513          	addi	a0,a0,-1
80000d8c:	800077b7          	lui	a5,0x80007
80000d90:	80006737          	lui	a4,0x80006
80000d94:	80007637          	lui	a2,0x80007
80000d98:	800065b7          	lui	a1,0x80006
80000d9c:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000da0:	50470713          	addi	a4,a4,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80000da4:	04b00693          	li	a3,75
80000da8:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000dac:	68058593          	addi	a1,a1,1664 # 80006680 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006681>
80000db0:	00153513          	seqz	a0,a0
80000db4:	d55ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000db8:	00040513          	mv	a0,s0
80000dbc:	d0dff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) >= PERIOD, timer);
80000dc0:	03100793          	li	a5,49
80000dc4:	04a7e263          	bltu	a5,a0,80000e08 <status_expire+0xac>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000dc8:	00040513          	mv	a0,s0
80000dcc:	134050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000dd0:	00040513          	mv	a0,s0
80000dd4:	cf5ff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
80000dd8:	03253513          	sltiu	a0,a0,50
80000ddc:	800077b7          	lui	a5,0x80007
80000de0:	80006737          	lui	a4,0x80006
80000de4:	80007637          	lui	a2,0x80007
80000de8:	800065b7          	lui	a1,0x80006
80000dec:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000df0:	50470713          	addi	a4,a4,1284 # 80006504 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006505>
80000df4:	04d00693          	li	a3,77
80000df8:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000dfc:	6a858593          	addi	a1,a1,1704 # 800066a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066a9>
80000e00:	00154513          	xori	a0,a0,1
80000e04:	d05ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80000e08:	800077b7          	lui	a5,0x80007
80000e0c:	6e87a703          	lw	a4,1768(a5) # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
80000e10:	00300793          	li	a5,3
80000e14:	00e7dc63          	bge	a5,a4,80000e2c <status_expire+0xd0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e18:	00040513          	mv	a0,s0
}
80000e1c:	00812403          	lw	s0,8(sp)
80000e20:	00c12083          	lw	ra,12(sp)
80000e24:	01010113          	addi	sp,sp,16
80000e28:	0d80506f          	j	80005f00 <z_impl_k_timer_stop>
80000e2c:	00c12083          	lw	ra,12(sp)
80000e30:	00812403          	lw	s0,8(sp)
80000e34:	01010113          	addi	sp,sp,16
80000e38:	00008067          	ret

80000e3c <status_stop>:
{
80000e3c:	ff010113          	addi	sp,sp,-16
80000e40:	00812423          	sw	s0,8(sp)
80000e44:	00112623          	sw	ra,12(sp)
80000e48:	00050413          	mv	s0,a0
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000e4c:	c7dff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000e50:	04050663          	beqz	a0,80000e9c <status_stop+0x60>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000e54:	00040513          	mv	a0,s0
80000e58:	0a8050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000e5c:	00040513          	mv	a0,s0
80000e60:	c69ff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
}
80000e64:	00812403          	lw	s0,8(sp)
80000e68:	00c12083          	lw	ra,12(sp)
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000e6c:	800077b7          	lui	a5,0x80007
80000e70:	80006737          	lui	a4,0x80006
80000e74:	80007637          	lui	a2,0x80007
80000e78:	800065b7          	lui	a1,0x80006
80000e7c:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000e80:	51470713          	addi	a4,a4,1300 # 80006514 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006515>
80000e84:	05c00693          	li	a3,92
80000e88:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000e8c:	6d458593          	addi	a1,a1,1748 # 800066d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800066d5>
80000e90:	00153513          	seqz	a0,a0
}
80000e94:	01010113          	addi	sp,sp,16
	TIMER_ASSERT(k_timer_remaining_get(timer) == 0, timer);
80000e98:	c71ff06f          	j	80000b08 <z_zassert.constprop.6>
}
80000e9c:	00c12083          	lw	ra,12(sp)
80000ea0:	00812403          	lw	s0,8(sp)
80000ea4:	01010113          	addi	sp,sp,16
80000ea8:	00008067          	ret

80000eac <test_timer_status_get>:
{
80000eac:	ff010113          	addi	sp,sp,-16
80000eb0:	00112623          	sw	ra,12(sp)
80000eb4:	00812423          	sw	s0,8(sp)
	init_timer_data();
80000eb8:	b39ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, status_expire, status_stop);
80000ebc:	80007437          	lui	s0,0x80007
80000ec0:	80001637          	lui	a2,0x80001
80000ec4:	800015b7          	lui	a1,0x80001
80000ec8:	e3c60613          	addi	a2,a2,-452 # 80000e3c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000e3d>
80000ecc:	d5c58593          	addi	a1,a1,-676 # 80000d5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000d5d>
80000ed0:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80000ed4:	739040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000ed8:	72440513          	addi	a0,s0,1828
80000edc:	03200613          	li	a2,50
80000ee0:	06400593          	li	a1,100
80000ee4:	751040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000ee8:	72440513          	addi	a0,s0,1828
80000eec:	09c050ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == 0, &timer);
80000ef0:	04050063          	beqz	a0,80000f30 <test_timer_status_get+0x84>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000ef4:	72440513          	addi	a0,s0,1828
80000ef8:	008050ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000efc:	72440513          	addi	a0,s0,1828
80000f00:	088050ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
80000f04:	800077b7          	lui	a5,0x80007
80000f08:	80006737          	lui	a4,0x80006
80000f0c:	80007637          	lui	a2,0x80007
80000f10:	800075b7          	lui	a1,0x80007
80000f14:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000f18:	58470713          	addi	a4,a4,1412 # 80006584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006585>
80000f1c:	11f00693          	li	a3,287
80000f20:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000f24:	90858593          	addi	a1,a1,-1784 # 80006908 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006909>
80000f28:	00153513          	seqz	a0,a0
80000f2c:	bddff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000f30:	72440513          	addi	a0,s0,1828
80000f34:	b95ff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
	TIMER_ASSERT(k_timer_remaining_get(&timer) >= DURATION / 2, &timer);
80000f38:	03100793          	li	a5,49
80000f3c:	04a7e263          	bltu	a5,a0,80000f80 <test_timer_status_get+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f40:	72440513          	addi	a0,s0,1828
80000f44:	7bd040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_REMAINING_GET, k_timer_remaining_get, u32_t, struct k_timer *, timer)
80000f48:	72440513          	addi	a0,s0,1828
80000f4c:	b7dff0ef          	jal	ra,80000ac8 <z_impl_k_timer_remaining_get>
80000f50:	03253513          	sltiu	a0,a0,50
80000f54:	800077b7          	lui	a5,0x80007
80000f58:	80006737          	lui	a4,0x80006
80000f5c:	80007637          	lui	a2,0x80007
80000f60:	800075b7          	lui	a1,0x80007
80000f64:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80000f68:	58470713          	addi	a4,a4,1412 # 80006584 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006585>
80000f6c:	12100693          	li	a3,289
80000f70:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80000f74:	93458593          	addi	a1,a1,-1740 # 80006934 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006935>
80000f78:	00154513          	xori	a0,a0,1
80000f7c:	b8dff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000f80:	72440513          	addi	a0,s0,1828
}
80000f84:	00812403          	lw	s0,8(sp)
80000f88:	00c12083          	lw	ra,12(sp)
80000f8c:	01010113          	addi	sp,sp,16
80000f90:	7710406f          	j	80005f00 <z_impl_k_timer_stop>

80000f94 <test_timer_status_get_anytime>:
{
80000f94:	ff010113          	addi	sp,sp,-16
80000f98:	00112623          	sw	ra,12(sp)
80000f9c:	00812423          	sw	s0,8(sp)
	init_timer_data();
80000fa0:	a51ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
80000fa4:	80007437          	lui	s0,0x80007
80000fa8:	00000613          	li	a2,0
80000fac:	00000593          	li	a1,0
80000fb0:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80000fb4:	659040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
80000fb8:	03200613          	li	a2,50
80000fbc:	06400593          	li	a1,100
80000fc0:	72440513          	addi	a0,s0,1828
80000fc4:	671040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
80000fc8:	00043537          	lui	a0,0x43
80000fcc:	23850513          	addi	a0,a0,568 # 43238 <CONFIG_RISCV_RAM_SIZE+0x3238>
80000fd0:	561030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000fd4:	72440513          	addi	a0,s0,1828
80000fd8:	7b1040ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
	TIMER_ASSERT(k_timer_status_get(&timer) == EXPIRE_TIMES, &timer);
80000fdc:	00400793          	li	a5,4
80000fe0:	04f50263          	beq	a0,a5,80001024 <test_timer_status_get_anytime+0x90>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80000fe4:	72440513          	addi	a0,s0,1828
80000fe8:	719040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_GET, k_timer_status_get, u32_t, struct k_timer *, timer)
80000fec:	72440513          	addi	a0,s0,1828
80000ff0:	799040ef          	jal	ra,80005f88 <z_impl_k_timer_status_get>
80000ff4:	ffc50513          	addi	a0,a0,-4
80000ff8:	800077b7          	lui	a5,0x80007
80000ffc:	80006737          	lui	a4,0x80006
80001000:	80007637          	lui	a2,0x80007
80001004:	800075b7          	lui	a1,0x80007
80001008:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
8000100c:	59c70713          	addi	a4,a4,1436 # 8000659c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000659d>
80001010:	13e00693          	li	a3,318
80001014:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001018:	96858593          	addi	a1,a1,-1688 # 80006968 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006969>
8000101c:	00153513          	seqz	a0,a0
80001020:	ae9ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001024:	72440513          	addi	a0,s0,1828
}
80001028:	00812403          	lw	s0,8(sp)
8000102c:	00c12083          	lw	ra,12(sp)
80001030:	01010113          	addi	sp,sp,16
80001034:	6cd0406f          	j	80005f00 <z_impl_k_timer_stop>

80001038 <test_timer_status_sync>:
{
80001038:	fd010113          	addi	sp,sp,-48
8000103c:	02112623          	sw	ra,44(sp)
80001040:	02812423          	sw	s0,40(sp)
80001044:	02912223          	sw	s1,36(sp)
80001048:	03212023          	sw	s2,32(sp)
8000104c:	01312e23          	sw	s3,28(sp)
80001050:	01412c23          	sw	s4,24(sp)
80001054:	01512a23          	sw	s5,20(sp)
80001058:	01612823          	sw	s6,16(sp)
8000105c:	01712623          	sw	s7,12(sp)
80001060:	01812423          	sw	s8,8(sp)
80001064:	01912223          	sw	s9,4(sp)
80001068:	01a12023          	sw	s10,0(sp)
	init_timer_data();
8000106c:	985ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
80001070:	80007437          	lui	s0,0x80007
80001074:	80001637          	lui	a2,0x80001
80001078:	800025b7          	lui	a1,0x80002
8000107c:	a0460613          	addi	a2,a2,-1532 # 80000a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a05>
80001080:	84858593          	addi	a1,a1,-1976 # 80001848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001849>
80001084:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80001088:	585040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000108c:	03200613          	li	a2,50
80001090:	06400593          	li	a1,100
80001094:	72440513          	addi	a0,s0,1828
80001098:	59d040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
8000109c:	00000493          	li	s1,0
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
800010a0:	80007ab7          	lui	s5,0x80007
800010a4:	80006937          	lui	s2,0x80006
800010a8:	800079b7          	lui	s3,0x80007
800010ac:	80007a37          	lui	s4,0x80007
800010b0:	80007bb7          	lui	s7,0x80007
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
800010b4:	00100b13          	li	s6,1
800010b8:	80007c37          	lui	s8,0x80007
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
800010bc:	80007cb7          	lui	s9,0x80007
		TIMER_ASSERT(tdata.expire_cnt == i, &timer);
800010c0:	6e8aa783          	lw	a5,1768(s5) # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800010c4:	6e8a8d13          	addi	s10,s5,1768
800010c8:	02978863          	beq	a5,s1,800010f8 <test_timer_status_sync+0xc0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800010cc:	72440513          	addi	a0,s0,1828
800010d0:	631040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800010d4:	000d2503          	lw	a0,0(s10)
800010d8:	b1898793          	addi	a5,s3,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
800010dc:	5bc90713          	addi	a4,s2,1468 # 800065bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065bd>
800010e0:	40950533          	sub	a0,a0,s1
800010e4:	15c00693          	li	a3,348
800010e8:	a70a0613          	addi	a2,s4,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
800010ec:	994b8593          	addi	a1,s7,-1644 # 80006994 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006995>
800010f0:	00153513          	seqz	a0,a0
800010f4:	a15ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
800010f8:	72440513          	addi	a0,s0,1828
800010fc:	775040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001100:	03650a63          	beq	a0,s6,80001134 <test_timer_status_sync+0xfc>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001104:	72440513          	addi	a0,s0,1828
80001108:	5f9040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
8000110c:	72440513          	addi	a0,s0,1828
80001110:	761040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
80001114:	fff50513          	addi	a0,a0,-1
80001118:	b1898793          	addi	a5,s3,-1256
8000111c:	5bc90713          	addi	a4,s2,1468
80001120:	15e00693          	li	a3,350
80001124:	a70a0613          	addi	a2,s4,-1424
80001128:	9b4c0593          	addi	a1,s8,-1612 # 800069b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b5>
8000112c:	00153513          	seqz	a0,a0
80001130:	9d9ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
		TIMER_ASSERT(tdata.expire_cnt == (i + 1), &timer);
80001134:	000d2783          	lw	a5,0(s10)
80001138:	00148493          	addi	s1,s1,1
8000113c:	02978863          	beq	a5,s1,8000116c <test_timer_status_sync+0x134>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001140:	72440513          	addi	a0,s0,1828
80001144:	5bd040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001148:	000d2503          	lw	a0,0(s10)
8000114c:	b1898793          	addi	a5,s3,-1256
80001150:	5bc90713          	addi	a4,s2,1468
80001154:	40950533          	sub	a0,a0,s1
80001158:	16000693          	li	a3,352
8000115c:	a70a0613          	addi	a2,s4,-1424
80001160:	9e0c8593          	addi	a1,s9,-1568 # 800069e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069e1>
80001164:	00153513          	seqz	a0,a0
80001168:	9a1ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	for (int i = 0; i < EXPIRE_TIMES; i++) {
8000116c:	00400793          	li	a5,4
80001170:	f4f498e3          	bne	s1,a5,800010c0 <test_timer_status_sync+0x88>
80001174:	72440513          	addi	a0,s0,1828
}
80001178:	02812403          	lw	s0,40(sp)
8000117c:	02c12083          	lw	ra,44(sp)
80001180:	02412483          	lw	s1,36(sp)
80001184:	02012903          	lw	s2,32(sp)
80001188:	01c12983          	lw	s3,28(sp)
8000118c:	01812a03          	lw	s4,24(sp)
80001190:	01412a83          	lw	s5,20(sp)
80001194:	01012b03          	lw	s6,16(sp)
80001198:	00c12b83          	lw	s7,12(sp)
8000119c:	00812c03          	lw	s8,8(sp)
800011a0:	00412c83          	lw	s9,4(sp)
800011a4:	00012d03          	lw	s10,0(sp)
800011a8:	03010113          	addi	sp,sp,48
800011ac:	5550406f          	j	80005f00 <z_impl_k_timer_stop>

800011b0 <test_timer_k_define>:
{
800011b0:	ff010113          	addi	sp,sp,-16
800011b4:	00112623          	sw	ra,12(sp)
800011b8:	00812423          	sw	s0,8(sp)
800011bc:	00912223          	sw	s1,4(sp)
800011c0:	01212023          	sw	s2,0(sp)
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800011c4:	80007437          	lui	s0,0x80007
	init_timer_data();
800011c8:	829ff0ef          	jal	ra,800009f0 <init_timer_data>
800011cc:	03200613          	li	a2,50
800011d0:	06400593          	li	a1,100
800011d4:	57840513          	addi	a0,s0,1400 # 80007578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007579>
800011d8:	45d040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
800011dc:	800074b7          	lui	s1,0x80007

K_SYSCALL_DECLARE2_VOID(K_SYSCALL_K_TIMER_USER_DATA_SET, k_timer_user_data_set, struct k_timer *, timer, void *, user_data)

K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_USER_DATA_GET, k_timer_user_data_get, void *, struct k_timer *, timer)

K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800011e0:	36d040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
800011e4:	6e848913          	addi	s2,s1,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800011e8:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800011ec:	0004f537          	lui	a0,0x4f
800011f0:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800011f4:	00b92623          	sw	a1,12(s2)
800011f8:	339030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
800011fc:	00092703          	lw	a4,0(s2)
80001200:	00400793          	li	a5,4
80001204:	6e848493          	addi	s1,s1,1768
80001208:	04f70063          	beq	a4,a5,80001248 <test_timer_k_define+0x98>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
8000120c:	57840513          	addi	a0,s0,1400
80001210:	4f1040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001214:	0004a503          	lw	a0,0(s1)
80001218:	800077b7          	lui	a5,0x80007
8000121c:	80006737          	lui	a4,0x80006
80001220:	ffc50513          	addi	a0,a0,-4
80001224:	80007637          	lui	a2,0x80007
80001228:	800075b7          	lui	a1,0x80007
8000122c:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001230:	5d470713          	addi	a4,a4,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
80001234:	17f00693          	li	a3,383
80001238:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
8000123c:	82858593          	addi	a1,a1,-2008 # 80006828 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006829>
80001240:	00153513          	seqz	a0,a0
80001244:	8c5ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
80001248:	0044a703          	lw	a4,4(s1)
8000124c:	00100793          	li	a5,1
80001250:	04f70063          	beq	a4,a5,80001290 <test_timer_k_define+0xe0>
80001254:	57840513          	addi	a0,s0,1400
80001258:	4a9040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
8000125c:	0044a503          	lw	a0,4(s1)
80001260:	800077b7          	lui	a5,0x80007
80001264:	80006737          	lui	a4,0x80006
80001268:	fff50513          	addi	a0,a0,-1
8000126c:	80007637          	lui	a2,0x80007
80001270:	800075b7          	lui	a1,0x80007
80001274:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001278:	5d470713          	addi	a4,a4,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
8000127c:	18000693          	li	a3,384
80001280:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001284:	84858593          	addi	a1,a1,-1976 # 80006848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006849>
80001288:	00153513          	seqz	a0,a0
8000128c:	87dff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80001290:	57840513          	addi	a0,s0,1400
80001294:	46d040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
	init_timer_data();
80001298:	f58ff0ef          	jal	ra,800009f0 <init_timer_data>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000129c:	03200613          	li	a2,50
800012a0:	06400593          	li	a1,100
800012a4:	57840513          	addi	a0,s0,1400
800012a8:	38d040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800012ac:	0000c537          	lui	a0,0xc
800012b0:	35050513          	addi	a0,a0,848 # c350 <CONFIG_ISR_STACK_SIZE+0xbb50>
800012b4:	27d030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800012b8:	03200613          	li	a2,50
800012bc:	06400593          	li	a1,100
800012c0:	57840513          	addi	a0,s0,1400
800012c4:	371040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800012c8:	285040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
800012cc:	00a4a423          	sw	a0,8(s1)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800012d0:	0004f537          	lui	a0,0x4f
800012d4:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800012d8:	00b4a623          	sw	a1,12(s1)
800012dc:	255030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &ktimer);
800012e0:	0004a703          	lw	a4,0(s1)
800012e4:	00400793          	li	a5,4
800012e8:	04f70063          	beq	a4,a5,80001328 <test_timer_k_define+0x178>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800012ec:	57840513          	addi	a0,s0,1400
800012f0:	411040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800012f4:	0004a503          	lw	a0,0(s1)
800012f8:	800077b7          	lui	a5,0x80007
800012fc:	80006737          	lui	a4,0x80006
80001300:	ffc50513          	addi	a0,a0,-4
80001304:	80007637          	lui	a2,0x80007
80001308:	800075b7          	lui	a1,0x80007
8000130c:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001310:	5d470713          	addi	a4,a4,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
80001314:	19300693          	li	a3,403
80001318:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
8000131c:	82858593          	addi	a1,a1,-2008 # 80006828 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006829>
80001320:	00153513          	seqz	a0,a0
80001324:	fe4ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &ktimer);
80001328:	0044a703          	lw	a4,4(s1)
8000132c:	00100793          	li	a5,1
80001330:	04f70063          	beq	a4,a5,80001370 <test_timer_k_define+0x1c0>
80001334:	57840513          	addi	a0,s0,1400
80001338:	3c9040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
8000133c:	0044a503          	lw	a0,4(s1)
80001340:	800077b7          	lui	a5,0x80007
80001344:	80006737          	lui	a4,0x80006
80001348:	fff50513          	addi	a0,a0,-1
8000134c:	80007637          	lui	a2,0x80007
80001350:	800075b7          	lui	a1,0x80007
80001354:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001358:	5d470713          	addi	a4,a4,1492 # 800065d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800065d5>
8000135c:	19400693          	li	a3,404
80001360:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001364:	84858593          	addi	a1,a1,-1976 # 80006848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006849>
80001368:	00153513          	seqz	a0,a0
8000136c:	f9cff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80001370:	57840513          	addi	a0,s0,1400
}
80001374:	00812403          	lw	s0,8(sp)
80001378:	00c12083          	lw	ra,12(sp)
8000137c:	00412483          	lw	s1,4(sp)
80001380:	00012903          	lw	s2,0(sp)
80001384:	01010113          	addi	sp,sp,16
80001388:	3790406f          	j	80005f00 <z_impl_k_timer_stop>

8000138c <test_timer_expirefn_null>:
{
8000138c:	ff010113          	addi	sp,sp,-16
80001390:	00112623          	sw	ra,12(sp)
80001394:	00812423          	sw	s0,8(sp)
80001398:	00912223          	sw	s1,4(sp)
	init_timer_data();
8000139c:	e54ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, NULL, duration_stop);
800013a0:	80007437          	lui	s0,0x80007
800013a4:	80001637          	lui	a2,0x80001
800013a8:	a0460613          	addi	a2,a2,-1532 # 80000a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a05>
800013ac:	00000593          	li	a1,0
800013b0:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
800013b4:	259040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800013b8:	03200613          	li	a2,50
800013bc:	06400593          	li	a1,100
800013c0:	72440513          	addi	a0,s0,1828
800013c4:	271040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800013c8:	0004f537          	lui	a0,0x4f
800013cc:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800013d0:	161030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800013d4:	72440513          	addi	a0,s0,1828
	TIMER_ASSERT(tdata.expire_cnt == 0, &timer);
800013d8:	800074b7          	lui	s1,0x80007
800013dc:	325040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800013e0:	6e84a783          	lw	a5,1768(s1) # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800013e4:	6e848493          	addi	s1,s1,1768
800013e8:	02078e63          	beqz	a5,80001424 <test_timer_expirefn_null+0x98>
800013ec:	72440513          	addi	a0,s0,1828
800013f0:	311040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800013f4:	0004a503          	lw	a0,0(s1)
800013f8:	800077b7          	lui	a5,0x80007
800013fc:	80006737          	lui	a4,0x80006
80001400:	80007637          	lui	a2,0x80007
80001404:	800075b7          	lui	a1,0x80007
80001408:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
8000140c:	55070713          	addi	a4,a4,1360 # 80006550 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006551>
80001410:	0bf00693          	li	a3,191
80001414:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001418:	80858593          	addi	a1,a1,-2040 # 80006808 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006809>
8000141c:	00153513          	seqz	a0,a0
80001420:	ee8ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
80001424:	0044a703          	lw	a4,4(s1)
80001428:	00100793          	li	a5,1
8000142c:	04f70063          	beq	a4,a5,8000146c <test_timer_expirefn_null+0xe0>
80001430:	72440513          	addi	a0,s0,1828
80001434:	2cd040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001438:	0044a503          	lw	a0,4(s1)
8000143c:	800077b7          	lui	a5,0x80007
80001440:	80006737          	lui	a4,0x80006
80001444:	fff50513          	addi	a0,a0,-1
80001448:	80007637          	lui	a2,0x80007
8000144c:	800075b7          	lui	a1,0x80007
80001450:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001454:	55070713          	addi	a4,a4,1360 # 80006550 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006551>
80001458:	0c100693          	li	a3,193
8000145c:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001460:	84858593          	addi	a1,a1,-1976 # 80006848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006849>
80001464:	00153513          	seqz	a0,a0
80001468:	ea0ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
8000146c:	72440513          	addi	a0,s0,1828
}
80001470:	00812403          	lw	s0,8(sp)
80001474:	00c12083          	lw	ra,12(sp)
80001478:	00412483          	lw	s1,4(sp)
8000147c:	01010113          	addi	sp,sp,16
80001480:	2810406f          	j	80005f00 <z_impl_k_timer_stop>

80001484 <test_timer_period_0>:
{
80001484:	ff010113          	addi	sp,sp,-16
80001488:	00112623          	sw	ra,12(sp)
8000148c:	00812423          	sw	s0,8(sp)
80001490:	00912223          	sw	s1,4(sp)
80001494:	01212023          	sw	s2,0(sp)
	init_timer_data();
80001498:	d58ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, period0_expire, NULL);
8000149c:	80007437          	lui	s0,0x80007
800014a0:	800015b7          	lui	a1,0x80001
800014a4:	00000613          	li	a2,0
800014a8:	a1c58593          	addi	a1,a1,-1508 # 80000a1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a1d>
800014ac:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
800014b0:	15d040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800014b4:	00000613          	li	a2,0
800014b8:	06400593          	li	a1,100
800014bc:	72440513          	addi	a0,s0,1828
800014c0:	175040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
800014c4:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800014c8:	085040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
800014cc:	6e848913          	addi	s2,s1,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800014d0:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800014d4:	00019537          	lui	a0,0x19
800014d8:	a8850513          	addi	a0,a0,-1400 # 18a88 <CONFIG_ISR_STACK_SIZE+0x18288>
800014dc:	00b92623          	sw	a1,12(s2)
800014e0:	051030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == 1, &timer);
800014e4:	00092703          	lw	a4,0(s2)
800014e8:	00100793          	li	a5,1
800014ec:	6e848493          	addi	s1,s1,1768
800014f0:	04f70063          	beq	a4,a5,80001530 <test_timer_period_0+0xac>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800014f4:	72440513          	addi	a0,s0,1828
800014f8:	209040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800014fc:	0004a503          	lw	a0,0(s1)
80001500:	800077b7          	lui	a5,0x80007
80001504:	80006737          	lui	a4,0x80006
80001508:	fff50513          	addi	a0,a0,-1
8000150c:	80007637          	lui	a2,0x80007
80001510:	800075b7          	lui	a1,0x80007
80001514:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001518:	53c70713          	addi	a4,a4,1340 # 8000653c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000653d>
8000151c:	09f00693          	li	a3,159
80001520:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001524:	86858593          	addi	a1,a1,-1944 # 80006868 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006869>
80001528:	00153513          	seqz	a0,a0
8000152c:	ddcff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 0, &timer);
80001530:	0044a783          	lw	a5,4(s1)
80001534:	02078e63          	beqz	a5,80001570 <test_timer_period_0+0xec>
80001538:	72440513          	addi	a0,s0,1828
8000153c:	1c5040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001540:	0044a503          	lw	a0,4(s1)
80001544:	800077b7          	lui	a5,0x80007
80001548:	80006737          	lui	a4,0x80006
8000154c:	80007637          	lui	a2,0x80007
80001550:	800075b7          	lui	a1,0x80007
80001554:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001558:	53c70713          	addi	a4,a4,1340 # 8000653c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000653d>
8000155c:	0a000693          	li	a3,160
80001560:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001564:	88858593          	addi	a1,a1,-1912 # 80006888 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006889>
80001568:	00153513          	seqz	a0,a0
8000156c:	d9cff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80001570:	72440513          	addi	a0,s0,1828
}
80001574:	00812403          	lw	s0,8(sp)
80001578:	00c12083          	lw	ra,12(sp)
8000157c:	00412483          	lw	s1,4(sp)
80001580:	00012903          	lw	s2,0(sp)
80001584:	01010113          	addi	sp,sp,16
80001588:	1790406f          	j	80005f00 <z_impl_k_timer_stop>

8000158c <test_timer_duration_period>:
{
8000158c:	ff010113          	addi	sp,sp,-16
80001590:	00112623          	sw	ra,12(sp)
80001594:	00812423          	sw	s0,8(sp)
80001598:	00912223          	sw	s1,4(sp)
8000159c:	01212023          	sw	s2,0(sp)
	init_timer_data();
800015a0:	c50ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, duration_expire, duration_stop);
800015a4:	80007437          	lui	s0,0x80007
800015a8:	80001637          	lui	a2,0x80001
800015ac:	800025b7          	lui	a1,0x80002
800015b0:	a0460613          	addi	a2,a2,-1532 # 80000a04 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000a05>
800015b4:	84858593          	addi	a1,a1,-1976 # 80001848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001849>
800015b8:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
800015bc:	051040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800015c0:	03200613          	li	a2,50
800015c4:	06400593          	li	a1,100
800015c8:	72440513          	addi	a0,s0,1828
800015cc:	069040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
	tdata.timestamp = k_uptime_get();
800015d0:	800074b7          	lui	s1,0x80007
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800015d4:	778040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
800015d8:	6e848913          	addi	s2,s1,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
800015dc:	00a92423          	sw	a0,8(s2)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_BUSY_WAIT, k_busy_wait, u32_t, usec_to_wait)
800015e0:	0004f537          	lui	a0,0x4f
800015e4:	58850513          	addi	a0,a0,1416 # 4f588 <CONFIG_RISCV_RAM_SIZE+0xf588>
800015e8:	00b92623          	sw	a1,12(s2)
800015ec:	744030ef          	jal	ra,80004d30 <z_impl_k_busy_wait>
	TIMER_ASSERT(tdata.expire_cnt == EXPIRE_TIMES, &timer);
800015f0:	00092703          	lw	a4,0(s2)
800015f4:	00400793          	li	a5,4
800015f8:	6e848493          	addi	s1,s1,1768
800015fc:	04f70063          	beq	a4,a5,8000163c <test_timer_duration_period+0xb0>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001600:	72440513          	addi	a0,s0,1828
80001604:	0fd040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001608:	0004a503          	lw	a0,0(s1)
8000160c:	800077b7          	lui	a5,0x80007
80001610:	80006737          	lui	a4,0x80006
80001614:	ffc50513          	addi	a0,a0,-4
80001618:	80007637          	lui	a2,0x80007
8000161c:	800075b7          	lui	a1,0x80007
80001620:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001624:	52070713          	addi	a4,a4,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
80001628:	07f00693          	li	a3,127
8000162c:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001630:	82858593          	addi	a1,a1,-2008 # 80006828 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006829>
80001634:	00153513          	seqz	a0,a0
80001638:	cd0ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
	TIMER_ASSERT(tdata.stop_cnt == 1, &timer);
8000163c:	0044a703          	lw	a4,4(s1)
80001640:	00100793          	li	a5,1
80001644:	04f70063          	beq	a4,a5,80001684 <test_timer_duration_period+0xf8>
80001648:	72440513          	addi	a0,s0,1828
8000164c:	0b5040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
80001650:	0044a503          	lw	a0,4(s1)
80001654:	800077b7          	lui	a5,0x80007
80001658:	80006737          	lui	a4,0x80006
8000165c:	fff50513          	addi	a0,a0,-1
80001660:	80007637          	lui	a2,0x80007
80001664:	800075b7          	lui	a1,0x80007
80001668:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
8000166c:	52070713          	addi	a4,a4,1312 # 80006520 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006521>
80001670:	08000693          	li	a3,128
80001674:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001678:	84858593          	addi	a1,a1,-1976 # 80006848 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006849>
8000167c:	00153513          	seqz	a0,a0
80001680:	c88ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80001684:	72440513          	addi	a0,s0,1828
}
80001688:	00812403          	lw	s0,8(sp)
8000168c:	00c12083          	lw	ra,12(sp)
80001690:	00412483          	lw	s1,4(sp)
80001694:	00012903          	lw	s2,0(sp)
80001698:	01010113          	addi	sp,sp,16
8000169c:	0650406f          	j	80005f00 <z_impl_k_timer_stop>

800016a0 <test_timer_periodicity>:
{
800016a0:	fd010113          	addi	sp,sp,-48
800016a4:	02812423          	sw	s0,40(sp)
	k_timer_init(&sync_timer, NULL, NULL);
800016a8:	80007437          	lui	s0,0x80007
800016ac:	6f840513          	addi	a0,s0,1784 # 800076f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076f9>
800016b0:	00000613          	li	a2,0
800016b4:	00000593          	li	a1,0
{
800016b8:	02112623          	sw	ra,44(sp)
800016bc:	02912223          	sw	s1,36(sp)
800016c0:	03212023          	sw	s2,32(sp)
800016c4:	01312e23          	sw	s3,28(sp)
800016c8:	01412c23          	sw	s4,24(sp)
800016cc:	01512a23          	sw	s5,20(sp)
800016d0:	01612823          	sw	s6,16(sp)
800016d4:	01712623          	sw	s7,12(sp)
800016d8:	01812423          	sw	s8,8(sp)
800016dc:	01912223          	sw	s9,4(sp)
	k_timer_init(&sync_timer, NULL, NULL);
800016e0:	72c040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
800016e4:	00100613          	li	a2,1
800016e8:	00000593          	li	a1,0
800016ec:	6f840513          	addi	a0,s0,1784
800016f0:	744040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
800016f4:	6f840513          	addi	a0,s0,1784
800016f8:	179040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800016fc:	6f840513          	addi	a0,s0,1784
80001700:	001040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
	k_timer_init(&timer, NULL, NULL);
80001704:	80007437          	lui	s0,0x80007
	init_timer_data();
80001708:	ae8ff0ef          	jal	ra,800009f0 <init_timer_data>
	k_timer_init(&timer, NULL, NULL);
8000170c:	00000613          	li	a2,0
80001710:	00000593          	li	a1,0
80001714:	72440513          	addi	a0,s0,1828 # 80007724 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007725>
80001718:	6f4040ef          	jal	ra,80005e0c <k_timer_init>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_TIMER_START, k_timer_start, struct k_timer *, timer, s32_t, duration, s32_t, period)
8000171c:	03200613          	li	a2,50
80001720:	00000593          	li	a1,0
80001724:	72440513          	addi	a0,s0,1828
80001728:	70c040ef          	jal	ra,80005e34 <z_impl_k_timer_start>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
8000172c:	72440513          	addi	a0,s0,1828
80001730:	141040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001734:	618040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	tdata.timestamp = k_uptime_get();
80001738:	800074b7          	lui	s1,0x80007
8000173c:	6e848793          	addi	a5,s1,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
80001740:	00a7a423          	sw	a0,8(a5)
80001744:	00b7a623          	sw	a1,12(a5)
80001748:	00400913          	li	s2,4
8000174c:	6e848493          	addi	s1,s1,1768
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001750:	00100993          	li	s3,1
80001754:	80006ab7          	lui	s5,0x80006
80001758:	80007b37          	lui	s6,0x80007
8000175c:	80007bb7          	lui	s7,0x80007
80001760:	80007c37          	lui	s8,0x80007
80001764:	fce00a13          	li	s4,-50
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
80001768:	80007cb7          	lui	s9,0x80007
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
8000176c:	72440513          	addi	a0,s0,1828
80001770:	101040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
		TIMER_ASSERT(k_timer_status_sync(&timer) == 1, &timer);
80001774:	03350a63          	beq	a0,s3,800017a8 <test_timer_periodicity+0x108>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001778:	72440513          	addi	a0,s0,1828
8000177c:	784040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE1(K_SYSCALL_K_TIMER_STATUS_SYNC, k_timer_status_sync, u32_t, struct k_timer *, timer)
80001780:	72440513          	addi	a0,s0,1828
80001784:	0ed040ef          	jal	ra,80006070 <z_impl_k_timer_status_sync>
80001788:	fff50513          	addi	a0,a0,-1
8000178c:	b18b0793          	addi	a5,s6,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001790:	56ca8713          	addi	a4,s5,1388 # 8000656c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000656d>
80001794:	0fc00693          	li	a3,252
80001798:	a70b8613          	addi	a2,s7,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
8000179c:	9b4c0593          	addi	a1,s8,-1612 # 800069b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800069b5>
800017a0:	00153513          	seqz	a0,a0
800017a4:	b64ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800017a8:	5a4040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
static inline s64_t k_uptime_delta(s64_t *reftime)
{
	s64_t uptime, delta;

	uptime = k_uptime_get();
	delta = uptime - *reftime;
800017ac:	0084a783          	lw	a5,8(s1)
800017b0:	00c4a703          	lw	a4,12(s1)
	*reftime = uptime;
800017b4:	00a4a423          	sw	a0,8(s1)
800017b8:	40fa07b3          	sub	a5,s4,a5
800017bc:	00fa36b3          	sltu	a3,s4,a5
800017c0:	fff74713          	not	a4,a4
800017c4:	40d70733          	sub	a4,a4,a3
		TIMER_ASSERT(WITHIN_ERROR(delta, PERIOD, 1), &timer);
800017c8:	00f507b3          	add	a5,a0,a5
800017cc:	00b4a623          	sw	a1,12(s1)
800017d0:	00a7b533          	sltu	a0,a5,a0
800017d4:	00e585b3          	add	a1,a1,a4
800017d8:	00b50533          	add	a0,a0,a1
800017dc:	00051463          	bnez	a0,800017e4 <test_timer_periodicity+0x144>
800017e0:	02f9f463          	bgeu	s3,a5,80001808 <test_timer_periodicity+0x168>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800017e4:	72440513          	addi	a0,s0,1828
800017e8:	718040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
800017ec:	b18b0793          	addi	a5,s6,-1256
800017f0:	56ca8713          	addi	a4,s5,1388
800017f4:	10300693          	li	a3,259
800017f8:	a70b8613          	addi	a2,s7,-1424
800017fc:	8a8c8593          	addi	a1,s9,-1880 # 800068a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800068a9>
80001800:	00000513          	li	a0,0
80001804:	b04ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
80001808:	fff90913          	addi	s2,s2,-1
	for (int i = 0; i < EXPIRE_TIMES; i++) {
8000180c:	f60910e3          	bnez	s2,8000176c <test_timer_periodicity+0xcc>
80001810:	72440513          	addi	a0,s0,1828
}
80001814:	02812403          	lw	s0,40(sp)
80001818:	02c12083          	lw	ra,44(sp)
8000181c:	02412483          	lw	s1,36(sp)
80001820:	02012903          	lw	s2,32(sp)
80001824:	01c12983          	lw	s3,28(sp)
80001828:	01812a03          	lw	s4,24(sp)
8000182c:	01412a83          	lw	s5,20(sp)
80001830:	01012b03          	lw	s6,16(sp)
80001834:	00c12b83          	lw	s7,12(sp)
80001838:	00812c03          	lw	s8,8(sp)
8000183c:	00412c83          	lw	s9,4(sp)
80001840:	03010113          	addi	sp,sp,48
80001844:	6bc0406f          	j	80005f00 <z_impl_k_timer_stop>

80001848 <duration_expire>:
{
80001848:	ff010113          	addi	sp,sp,-16
8000184c:	00812423          	sw	s0,8(sp)
	tdata.expire_cnt++;
80001850:	80007437          	lui	s0,0x80007
80001854:	6e840713          	addi	a4,s0,1768 # 800076e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e9>
80001858:	00072783          	lw	a5,0(a4)
{
8000185c:	00912223          	sw	s1,4(sp)
80001860:	00112623          	sw	ra,12(sp)
	tdata.expire_cnt++;
80001864:	00178793          	addi	a5,a5,1
80001868:	00f72023          	sw	a5,0(a4)
	if (tdata.expire_cnt == 1) {
8000186c:	00100713          	li	a4,1
{
80001870:	00050493          	mv	s1,a0
80001874:	6e840413          	addi	s0,s0,1768
	if (tdata.expire_cnt == 1) {
80001878:	0ce79a63          	bne	a5,a4,8000194c <duration_expire+0x104>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
8000187c:	4d0040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001880:	00842703          	lw	a4,8(s0)
80001884:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
80001888:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
8000188c:	40e50733          	sub	a4,a0,a4
80001890:	00e536b3          	sltu	a3,a0,a4
80001894:	40f587b3          	sub	a5,a1,a5
80001898:	40d787b3          	sub	a5,a5,a3
	*reftime = uptime;
8000189c:	00b42623          	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= DURATION,
800018a0:	06f04e63          	bgtz	a5,8000191c <duration_expire+0xd4>
800018a4:	00079663          	bnez	a5,800018b0 <duration_expire+0x68>
800018a8:	06300793          	li	a5,99
800018ac:	06e7e863          	bltu	a5,a4,8000191c <duration_expire+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
800018b0:	00048513          	mv	a0,s1
800018b4:	64c040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
800018b8:	494040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	delta = uptime - *reftime;
800018bc:	00842683          	lw	a3,8(s0)
800018c0:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
800018c4:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
800018c8:	40d506b3          	sub	a3,a0,a3
800018cc:	00d53733          	sltu	a4,a0,a3
800018d0:	40f587b3          	sub	a5,a1,a5
800018d4:	40e787b3          	sub	a5,a5,a4
	*reftime = uptime;
800018d8:	00b42623          	sw	a1,12(s0)
800018dc:	80006737          	lui	a4,0x80006
800018e0:	00100513          	li	a0,1
800018e4:	00f04a63          	bgtz	a5,800018f8 <duration_expire+0xb0>
800018e8:	00079663          	bnez	a5,800018f4 <duration_expire+0xac>
800018ec:	06300793          	li	a5,99
800018f0:	00d7e463          	bltu	a5,a3,800018f8 <duration_expire+0xb0>
800018f4:	00000513          	li	a0,0
800018f8:	800077b7          	lui	a5,0x80007
800018fc:	80007637          	lui	a2,0x80007
80001900:	800065b7          	lui	a1,0x80006
80001904:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
80001908:	4f470713          	addi	a4,a4,1268 # 800064f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f5>
8000190c:	03300693          	li	a3,51
80001910:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
80001914:	61c58593          	addi	a1,a1,1564 # 8000661c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000661d>
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
80001918:	9f0ff0ef          	jal	ra,80000b08 <z_zassert.constprop.6>
8000191c:	430040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
80001920:	00042703          	lw	a4,0(s0)
	tdata.timestamp = k_uptime_get();
80001924:	00a42423          	sw	a0,8(s0)
80001928:	00b42623          	sw	a1,12(s0)
	if (tdata.expire_cnt >= EXPIRE_TIMES) {
8000192c:	00300793          	li	a5,3
80001930:	0ae7de63          	bge	a5,a4,800019ec <duration_expire+0x1a4>
}
80001934:	00812403          	lw	s0,8(sp)
80001938:	00c12083          	lw	ra,12(sp)
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
8000193c:	00048513          	mv	a0,s1
80001940:	00412483          	lw	s1,4(sp)
80001944:	01010113          	addi	sp,sp,16
80001948:	5b80406f          	j	80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
8000194c:	400040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	delta = uptime - *reftime;
80001950:	00842703          	lw	a4,8(s0)
80001954:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
80001958:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
8000195c:	40e50733          	sub	a4,a0,a4
80001960:	00e536b3          	sltu	a3,a0,a4
80001964:	40f587b3          	sub	a5,a1,a5
80001968:	40d787b3          	sub	a5,a5,a3
	*reftime = uptime;
8000196c:	00b42623          	sw	a1,12(s0)
		TIMER_ASSERT(k_uptime_delta(&tdata.timestamp) >= PERIOD, timer);
80001970:	faf046e3          	bgtz	a5,8000191c <duration_expire+0xd4>
80001974:	00079663          	bnez	a5,80001980 <duration_expire+0x138>
80001978:	03100793          	li	a5,49
8000197c:	fae7e0e3          	bltu	a5,a4,8000191c <duration_expire+0xd4>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_TIMER_STOP, k_timer_stop, struct k_timer *, timer)
80001980:	00048513          	mv	a0,s1
80001984:	57c040ef          	jal	ra,80005f00 <z_impl_k_timer_stop>
K_SYSCALL_DECLARE0_RET64(K_SYSCALL_K_UPTIME_GET, k_uptime_get, s64_t)
80001988:	3c4040ef          	jal	ra,80005d4c <z_impl_k_uptime_get>
	delta = uptime - *reftime;
8000198c:	00842683          	lw	a3,8(s0)
80001990:	00c42783          	lw	a5,12(s0)
	*reftime = uptime;
80001994:	00a42423          	sw	a0,8(s0)
	delta = uptime - *reftime;
80001998:	40d506b3          	sub	a3,a0,a3
8000199c:	00d53733          	sltu	a4,a0,a3
800019a0:	40f587b3          	sub	a5,a1,a5
800019a4:	40e787b3          	sub	a5,a5,a4
	*reftime = uptime;
800019a8:	00b42623          	sw	a1,12(s0)
800019ac:	80006737          	lui	a4,0x80006
800019b0:	00100513          	li	a0,1
800019b4:	00f04a63          	bgtz	a5,800019c8 <duration_expire+0x180>
800019b8:	00079663          	bnez	a5,800019c4 <duration_expire+0x17c>
800019bc:	03100793          	li	a5,49
800019c0:	00d7e463          	bltu	a5,a3,800019c8 <duration_expire+0x180>
800019c4:	00000513          	li	a0,0
800019c8:	800077b7          	lui	a5,0x80007
800019cc:	80007637          	lui	a2,0x80007
800019d0:	800065b7          	lui	a1,0x80006
800019d4:	b1878793          	addi	a5,a5,-1256 # 80006b18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b19>
800019d8:	4f470713          	addi	a4,a4,1268 # 800064f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800064f5>
800019dc:	03500693          	li	a3,53
800019e0:	a7060613          	addi	a2,a2,-1424 # 80006a70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006a71>
800019e4:	65058593          	addi	a1,a1,1616 # 80006650 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006651>
800019e8:	f31ff06f          	j	80001918 <duration_expire+0xd0>
}
800019ec:	00c12083          	lw	ra,12(sp)
800019f0:	00812403          	lw	s0,8(sp)
800019f4:	00412483          	lw	s1,4(sp)
800019f8:	01010113          	addi	sp,sp,16
800019fc:	00008067          	ret

80001a00 <test_main>:
			 ztest_unit_test(test_timer_status_get_anytime),
			 ztest_unit_test(test_timer_status_sync),
			 ztest_unit_test(test_timer_k_define),
			 ztest_unit_test(test_timer_user_data),
			 ztest_unit_test(test_timer_remaining_get));
	ztest_run_test_suite(timer_api);
80001a00:	800075b7          	lui	a1,0x80007
80001a04:	80006537          	lui	a0,0x80006
80001a08:	45058593          	addi	a1,a1,1104 # 80007450 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007451>
80001a0c:	7fc50513          	addi	a0,a0,2044 # 800067fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800067fd>
80001a10:	3100106f          	j	80002d20 <z_ztest_run_test_suite>

80001a14 <z_SysFatalErrorHandler>:
 *
 * @return N/A
 */
FUNC_NORETURN __weak void z_SysFatalErrorHandler(unsigned int reason,
						const NANO_ESF *esf)
{
80001a14:	ff010113          	addi	sp,sp,-16
80001a18:	00112623          	sw	ra,12(sp)
80001a1c:	00812423          	sw	s0,8(sp)
#ifdef CONFIG_STACK_SENTINEL
	if (reason == _NANO_ERR_STACK_CHK_FAIL) {
		goto hang_system;
	}
#endif
	if (reason == _NANO_ERR_KERNEL_PANIC) {
80001a20:	00600793          	li	a5,6
80001a24:	02f50463          	beq	a0,a5,80001a4c <z_SysFatalErrorHandler+0x38>
		goto hang_system;
	}
	if (k_is_in_isr() || z_is_thread_essential()) {
80001a28:	2e4030ef          	jal	ra,80004d0c <k_is_in_isr>
80001a2c:	02050463          	beqz	a0,80001a54 <z_SysFatalErrorHandler+0x40>
		printk("Fatal fault in %s! Spinning...\n",
		       k_is_in_isr() ? "ISR" : "essential thread");
80001a30:	2dc030ef          	jal	ra,80004d0c <k_is_in_isr>
		printk("Fatal fault in %s! Spinning...\n",
80001a34:	04051663          	bnez	a0,80001a80 <z_SysFatalErrorHandler+0x6c>
80001a38:	800075b7          	lui	a1,0x80007
80001a3c:	d7458593          	addi	a1,a1,-652 # 80006d74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d75>
80001a40:	80007537          	lui	a0,0x80007
80001a44:	d8850513          	addi	a0,a0,-632 # 80006d88 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d89>
80001a48:	39d000ef          	jal	ra,800025e4 <printk>
#else
	ARG_UNUSED(reason);
#endif

	for (;;) {
		k_cpu_idle();
80001a4c:	409000ef          	jal	ra,80002654 <k_cpu_idle>
80001a50:	ffdff06f          	j	80001a4c <z_SysFatalErrorHandler+0x38>
	if (k_is_in_isr() || z_is_thread_essential()) {
80001a54:	2c8030ef          	jal	ra,80004d1c <z_is_thread_essential>
80001a58:	fc051ce3          	bnez	a0,80001a30 <z_SysFatalErrorHandler+0x1c>
	printk("Fatal fault in thread %p! Aborting.\n", _current);
80001a5c:	80008437          	lui	s0,0x80008
80001a60:	8c440413          	addi	s0,s0,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80001a64:	00842583          	lw	a1,8(s0)
80001a68:	80007537          	lui	a0,0x80007
80001a6c:	da850513          	addi	a0,a0,-600 # 80006da8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006da9>
80001a70:	375000ef          	jal	ra,800025e4 <printk>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001a74:	00842503          	lw	a0,8(s0)
80001a78:	76c030ef          	jal	ra,800051e4 <z_impl_k_thread_abort>
80001a7c:	fd1ff06f          	j	80001a4c <z_SysFatalErrorHandler+0x38>
		printk("Fatal fault in %s! Spinning...\n",
80001a80:	800075b7          	lui	a1,0x80007
80001a84:	d7058593          	addi	a1,a1,-656 # 80006d70 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006d71>
80001a88:	fb9ff06f          	j	80001a40 <z_SysFatalErrorHandler+0x2c>

80001a8c <z_NanoFatalErrorHandler>:
{
80001a8c:	fb010113          	addi	sp,sp,-80
80001a90:	04812423          	sw	s0,72(sp)
80001a94:	04912223          	sw	s1,68(sp)
80001a98:	04112623          	sw	ra,76(sp)
	switch (reason) {
80001a9c:	00600793          	li	a5,6
{
80001aa0:	00050493          	mv	s1,a0
80001aa4:	00058413          	mv	s0,a1
	switch (reason) {
80001aa8:	0ea7e063          	bltu	a5,a0,80001b88 <z_NanoFatalErrorHandler+0xfc>
80001aac:	80007737          	lui	a4,0x80007
80001ab0:	00251793          	slli	a5,a0,0x2
80001ab4:	ac470713          	addi	a4,a4,-1340 # 80006ac4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ac5>
80001ab8:	00e787b3          	add	a5,a5,a4
80001abc:	0007a783          	lw	a5,0(a5)
80001ac0:	00078067          	jr	a5
		printk("**** Kernel Allocation Failure! ****\n");
80001ac4:	80007537          	lui	a0,0x80007
80001ac8:	bf450513          	addi	a0,a0,-1036 # 80006bf4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006bf5>
		printk("***** Kernel OOPS! *****\n");
80001acc:	319000ef          	jal	ra,800025e4 <printk>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80001ad0:	69d020ef          	jal	ra,8000496c <z_impl_k_current_get>
	printk("Current thread ID = %p\n"
80001ad4:	04442783          	lw	a5,68(s0)
80001ad8:	01042883          	lw	a7,16(s0)
80001adc:	00c42803          	lw	a6,12(s0)
80001ae0:	02f12823          	sw	a5,48(sp)
80001ae4:	04042783          	lw	a5,64(s0)
80001ae8:	00442703          	lw	a4,4(s0)
80001aec:	00042683          	lw	a3,0(s0)
80001af0:	02f12623          	sw	a5,44(sp)
80001af4:	03c42783          	lw	a5,60(s0)
80001af8:	04842603          	lw	a2,72(s0)
80001afc:	00050593          	mv	a1,a0
80001b00:	02f12423          	sw	a5,40(sp)
80001b04:	03842783          	lw	a5,56(s0)
80001b08:	80007537          	lui	a0,0x80007
80001b0c:	c7850513          	addi	a0,a0,-904 # 80006c78 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c79>
80001b10:	02f12223          	sw	a5,36(sp)
80001b14:	03442783          	lw	a5,52(s0)
80001b18:	02f12023          	sw	a5,32(sp)
80001b1c:	03042783          	lw	a5,48(s0)
80001b20:	00f12e23          	sw	a5,28(sp)
80001b24:	02c42783          	lw	a5,44(s0)
80001b28:	00f12c23          	sw	a5,24(sp)
80001b2c:	02842783          	lw	a5,40(s0)
80001b30:	00f12a23          	sw	a5,20(sp)
80001b34:	02442783          	lw	a5,36(s0)
80001b38:	00f12823          	sw	a5,16(sp)
80001b3c:	02042783          	lw	a5,32(s0)
80001b40:	00f12623          	sw	a5,12(sp)
80001b44:	01c42783          	lw	a5,28(s0)
80001b48:	00f12423          	sw	a5,8(sp)
80001b4c:	01842783          	lw	a5,24(s0)
80001b50:	00f12223          	sw	a5,4(sp)
80001b54:	01442783          	lw	a5,20(s0)
80001b58:	00f12023          	sw	a5,0(sp)
80001b5c:	00842783          	lw	a5,8(s0)
80001b60:	285000ef          	jal	ra,800025e4 <printk>
	z_SysFatalErrorHandler(reason, esf);
80001b64:	00040593          	mv	a1,s0
80001b68:	00048513          	mv	a0,s1
80001b6c:	ea9ff0ef          	jal	ra,80001a14 <z_SysFatalErrorHandler>
		printk("***** Kernel OOPS! *****\n");
80001b70:	80007537          	lui	a0,0x80007
80001b74:	c1c50513          	addi	a0,a0,-996 # 80006c1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c1d>
80001b78:	f55ff06f          	j	80001acc <z_NanoFatalErrorHandler+0x40>
		printk("***** Kernel Panic! *****\n");
80001b7c:	80007537          	lui	a0,0x80007
80001b80:	c3850513          	addi	a0,a0,-968 # 80006c38 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c39>
80001b84:	f49ff06f          	j	80001acc <z_NanoFatalErrorHandler+0x40>
		printk("**** Unknown Fatal Error %d! ****\n", reason);
80001b88:	80007537          	lui	a0,0x80007
80001b8c:	00048593          	mv	a1,s1
80001b90:	c5450513          	addi	a0,a0,-940 # 80006c54 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006c55>
80001b94:	251000ef          	jal	ra,800025e4 <printk>
		break;
80001b98:	f39ff06f          	j	80001ad0 <z_NanoFatalErrorHandler+0x44>

80001b9c <_Fault>:
	}
}


FUNC_NORETURN void _Fault(const NANO_ESF *esf)
{
80001b9c:	ff010113          	addi	sp,sp,-16
80001ba0:	00812423          	sw	s0,8(sp)
80001ba4:	00112623          	sw	ra,12(sp)
80001ba8:	00050413          	mv	s0,a0
	u32_t mcause;

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001bac:	34202673          	csrr	a2,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;
80001bb0:	00161613          	slli	a2,a2,0x1
80001bb4:	00165613          	srli	a2,a2,0x1
	switch (cause) {
80001bb8:	00500793          	li	a5,5
80001bbc:	02c7e863          	bltu	a5,a2,80001bec <_Fault+0x50>
80001bc0:	80007737          	lui	a4,0x80007
80001bc4:	00261793          	slli	a5,a2,0x2
80001bc8:	ae070713          	addi	a4,a4,-1312 # 80006ae0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ae1>
80001bcc:	00f707b3          	add	a5,a4,a5
80001bd0:	0007a583          	lw	a1,0(a5)
	printk("Exception cause %s (%d)\n", cause_str(mcause), (int)mcause);
80001bd4:	80007537          	lui	a0,0x80007
80001bd8:	b0050513          	addi	a0,a0,-1280 # 80006b00 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b01>
80001bdc:	209000ef          	jal	ra,800025e4 <printk>

	z_NanoFatalErrorHandler(_NANO_ERR_CPU_EXCEPTION, esf);
80001be0:	00040593          	mv	a1,s0
80001be4:	00000513          	li	a0,0
80001be8:	ea5ff0ef          	jal	ra,80001a8c <z_NanoFatalErrorHandler>
	mcause &= SOC_MCAUSE_EXP_MASK;
80001bec:	800075b7          	lui	a1,0x80007
80001bf0:	af858593          	addi	a1,a1,-1288 # 80006af8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006af9>
80001bf4:	fe1ff06f          	j	80001bd4 <_Fault+0x38>

80001bf8 <z_irq_spurious>:
#include <toolchain.h>
#include <kernel_structs.h>
#include <misc/printk.h>

void z_irq_spurious(void *unused)
{
80001bf8:	ff010113          	addi	sp,sp,-16
80001bfc:	00112623          	sw	ra,12(sp)
	u32_t mcause;

	ARG_UNUSED(unused);

	__asm__ volatile("csrr %0, mcause" : "=r" (mcause));
80001c00:	342025f3          	csrr	a1,mcause

	mcause &= SOC_MCAUSE_EXP_MASK;

	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001c04:	80007537          	lui	a0,0x80007
	mcause &= SOC_MCAUSE_EXP_MASK;
80001c08:	00159593          	slli	a1,a1,0x1
	printk("Spurious interrupt detected! IRQ: %d\n", (int)mcause);
80001c0c:	0015d593          	srli	a1,a1,0x1
80001c10:	dd050513          	addi	a0,a0,-560 # 80006dd0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006dd1>
80001c14:	1d1000ef          	jal	ra,800025e4 <printk>
		printk("PLIC interrupt line causing the IRQ: %d\n",
		       riscv_plic_get_irq());
	}
#endif

	z_NanoFatalErrorHandler(_NANO_ERR_SPURIOUS_INT, &_default_esf);
80001c18:	800075b7          	lui	a1,0x80007
80001c1c:	b1c58593          	addi	a1,a1,-1252 # 80006b1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b1d>
80001c20:	00400513          	li	a0,4
80001c24:	e69ff0ef          	jal	ra,80001a8c <z_NanoFatalErrorHandler>

80001c28 <z_irq_do_offload>:
 */
void z_irq_do_offload(void)
{
	irq_offload_routine_t tmp;

	if (!_offload_routine)
80001c28:	800077b7          	lui	a5,0x80007
80001c2c:	6a878793          	addi	a5,a5,1704 # 800076a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a9>
80001c30:	0007a703          	lw	a4,0(a5)
80001c34:	00070c63          	beqz	a4,80001c4c <z_irq_do_offload+0x24>
		return;

	tmp = _offload_routine;
80001c38:	0007a303          	lw	t1,0(a5)
	_offload_routine = NULL;
80001c3c:	0007a023          	sw	zero,0(a5)

	tmp((void *)offload_param);
80001c40:	800077b7          	lui	a5,0x80007
80001c44:	6ac7a503          	lw	a0,1708(a5) # 800076ac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076ad>
80001c48:	00030067          	jr	t1 # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
}
80001c4c:	00008067          	ret

80001c50 <_PrepC>:
 *
 * @return N/A
 */

void _PrepC(void)
{
80001c50:	ff010113          	addi	sp,sp,-16
80001c54:	00112623          	sw	ra,12(sp)
	z_bss_zero();
80001c58:	47c010ef          	jal	ra,800030d4 <z_bss_zero>
#ifdef CONFIG_XIP
	z_data_copy();
#endif
#if defined(CONFIG_RISCV_SOC_INTERRUPT_INIT)
	soc_interrupt_init();
80001c5c:	219000ef          	jal	ra,80002674 <soc_interrupt_init>
#endif
	z_cstart();
80001c60:	4e0010ef          	jal	ra,80003140 <z_cstart>

80001c64 <__initialize>:

	/*
	 * Initially, setup stack pointer to
	 * _interrupt_stack + CONFIG_ISR_STACK_SIZE
	 */
	la sp, _interrupt_stack
80001c64:	00006117          	auipc	sp,0x6
80001c68:	48c10113          	addi	sp,sp,1164 # 800080f0 <_interrupt_stack>
	li t0, CONFIG_ISR_STACK_SIZE
80001c6c:	000012b7          	lui	t0,0x1
80001c70:	80028293          	addi	t0,t0,-2048 # 800 <CONFIG_ISR_STACK_SIZE>
	add sp, sp, t0
80001c74:	00510133          	add	sp,sp,t0

	/*
	 * Jump into C domain. _PrepC zeroes BSS, copies rw data into RAM,
	 * and then enters kernel z_cstart
	 */
	call _PrepC
80001c78:	fd9ff0ef          	jal	ra,80001c50 <_PrepC>

80001c7c <z_thread_entry_wrapper>:
	 * in registers a0, a1, a2 and a3. These registers are used as arguments
	 * to function z_thread_entry. Hence, just call z_thread_entry with
	 * return address set to 0 to indicate a non-returning function call.
	 */

	jal x0, z_thread_entry
80001c7c:	2fc0006f          	j	80001f78 <z_thread_entry>

80001c80 <z_new_thread>:

void z_new_thread(struct k_thread *thread, k_thread_stack_t *stack,
		 size_t stack_size, k_thread_entry_t thread_func,
		 void *arg1, void *arg2, void *arg3,
		 int priority, unsigned int options)
{
80001c80:	fd010113          	addi	sp,sp,-48
80001c84:	02812423          	sw	s0,40(sp)
80001c88:	02912223          	sw	s1,36(sp)
80001c8c:	03212023          	sw	s2,32(sp)
80001c90:	01312e23          	sw	s3,28(sp)
80001c94:	01412c23          	sw	s4,24(sp)
80001c98:	01512a23          	sw	s5,20(sp)
80001c9c:	01612823          	sw	s6,16(sp)
80001ca0:	01712623          	sw	s7,12(sp)
80001ca4:	00078b13          	mv	s6,a5
80001ca8:	02112623          	sw	ra,44(sp)
80001cac:	01812423          	sw	s8,8(sp)
	char *stack_memory = Z_THREAD_STACK_BUFFER(stack);
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001cb0:	00f00793          	li	a5,15
{
80001cb4:	00050493          	mv	s1,a0
80001cb8:	00058413          	mv	s0,a1
80001cbc:	00060993          	mv	s3,a2
80001cc0:	00068a13          	mv	s4,a3
80001cc4:	00070b93          	mv	s7,a4
80001cc8:	00080a93          	mv	s5,a6
80001ccc:	00088913          	mv	s2,a7
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001cd0:	08f89a63          	bne	a7,a5,80001d64 <z_new_thread+0xe4>
80001cd4:	800037b7          	lui	a5,0x80003
80001cd8:	09c78793          	addi	a5,a5,156 # 8000309c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000309d>
80001cdc:	08f69a63          	bne	a3,a5,80001d70 <z_new_thread+0xf0>
	 * if it isn't.
	 */
	*((u32_t *)pStack) = STACK_SENTINEL;
#endif /* CONFIG_STACK_SENTINEL */
	/* Initialize various struct k_thread members */
	z_init_thread_base(&thread->base, prio, _THREAD_PRESTART, options);
80001ce0:	03012683          	lw	a3,48(sp)
80001ce4:	00090593          	mv	a1,s2
80001ce8:	00048513          	mv	a0,s1
80001cec:	00400613          	li	a2,4
80001cf0:	150030ef          	jal	ra,80004e40 <z_init_thread_base>

	z_new_thread_init(thread, stack_memory, stack_size, priority, options);

	/* Initial stack frame for thread */
	stack_init = (struct __esf *)
		STACK_ROUND_DOWN(stack_memory +
80001cf4:	fb098593          	addi	a1,s3,-80
80001cf8:	00b405b3          	add	a1,s0,a1
	 *    restored following the MSTATUS value set within the thread stack;
	 * 2) the core will jump to z_thread_entry_wrapper, as the program
	 *    counter will be restored following the MEPC value set within the
	 *    thread stack.
	 */
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001cfc:	000027b7          	lui	a5,0x2

	/* static threads overwrite it afterwards with real value */
	thread->init_data = NULL;
80001d00:	0404ae23          	sw	zero,92(s1)
	thread->fn_abort = NULL;
80001d04:	0604a023          	sw	zero,96(s1)
		STACK_ROUND_DOWN(stack_memory +
80001d08:	ff05f593          	andi	a1,a1,-16
	stack_init->mstatus = SOC_MSTATUS_DEF_RESTORE;
80001d0c:	88078793          	addi	a5,a5,-1920 # 1880 <CONFIG_ISR_STACK_SIZE+0x1080>
80001d10:	04f5a623          	sw	a5,76(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001d14:	800027b7          	lui	a5,0x80002

	thread->callee_saved.sp = (u32_t)stack_init;
}
80001d18:	02c12083          	lw	ra,44(sp)
80001d1c:	02812403          	lw	s0,40(sp)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001d20:	c7c78793          	addi	a5,a5,-900 # 80001c7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001c7d>
	stack_init->a0 = (u32_t)thread_func;
80001d24:	0345a423          	sw	s4,40(a1)
	stack_init->a1 = (u32_t)arg1;
80001d28:	0375a623          	sw	s7,44(a1)
	stack_init->a2 = (u32_t)arg2;
80001d2c:	0365a823          	sw	s6,48(a1)
	stack_init->a3 = (u32_t)arg3;
80001d30:	0355aa23          	sw	s5,52(a1)
	stack_init->mepc = (u32_t)z_thread_entry_wrapper;
80001d34:	04f5a423          	sw	a5,72(a1)
	thread->callee_saved.sp = (u32_t)stack_init;
80001d38:	02b4a423          	sw	a1,40(s1)
}
80001d3c:	02012903          	lw	s2,32(sp)
80001d40:	02412483          	lw	s1,36(sp)
80001d44:	01c12983          	lw	s3,28(sp)
80001d48:	01812a03          	lw	s4,24(sp)
80001d4c:	01412a83          	lw	s5,20(sp)
80001d50:	01012b03          	lw	s6,16(sp)
80001d54:	00c12b83          	lw	s7,12(sp)
80001d58:	00812c03          	lw	s8,8(sp)
80001d5c:	03010113          	addi	sp,sp,48
80001d60:	00008067          	ret
	Z_ASSERT_VALID_PRIO(priority, thread_func);
80001d64:	01088693          	addi	a3,a7,16
80001d68:	01e00793          	li	a5,30
80001d6c:	f6d7fae3          	bgeu	a5,a3,80001ce0 <z_new_thread+0x60>
80001d70:	80007c37          	lui	s8,0x80007
80001d74:	800075b7          	lui	a1,0x80007
80001d78:	80007537          	lui	a0,0x80007
80001d7c:	df8c0613          	addi	a2,s8,-520 # 80006df8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006df9>
80001d80:	01800693          	li	a3,24
80001d84:	e1858593          	addi	a1,a1,-488 # 80006e18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006e19>
80001d88:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80001d8c:	059000ef          	jal	ra,800025e4 <printk>
80001d90:	80007537          	lui	a0,0x80007
80001d94:	00090593          	mv	a1,s2
80001d98:	ff000693          	li	a3,-16
80001d9c:	00e00613          	li	a2,14
80001da0:	ec450513          	addi	a0,a0,-316 # 80006ec4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ec5>
80001da4:	041000ef          	jal	ra,800025e4 <printk>
80001da8:	01800593          	li	a1,24
80001dac:	df8c0513          	addi	a0,s8,-520
80001db0:	071000ef          	jal	ra,80002620 <assert_post_action>
80001db4:	f2dff06f          	j	80001ce0 <z_new_thread+0x60>

80001db8 <get_bit_ptr>:
 * within that word as the return value
 */
static int get_bit_ptr(struct sys_mem_pool_base *p, int level, int bn,
		       u32_t **word)
{
	u32_t *bitarray = level <= p->max_inline_level ?
80001db8:	00159793          	slli	a5,a1,0x1
80001dbc:	00b787b3          	add	a5,a5,a1
80001dc0:	00279713          	slli	a4,a5,0x2
80001dc4:	00c52783          	lw	a5,12(a0)
80001dc8:	00e787b3          	add	a5,a5,a4
80001dcc:	00b50703          	lb	a4,11(a0)
		&p->levels[level].bits : p->levels[level].bits_p;
80001dd0:	00b75463          	bge	a4,a1,80001dd8 <get_bit_ptr+0x20>
80001dd4:	0007a783          	lw	a5,0(a5)

	*word = &bitarray[bn / 32];
80001dd8:	41f65713          	srai	a4,a2,0x1f
80001ddc:	01f77713          	andi	a4,a4,31
80001de0:	00c70733          	add	a4,a4,a2
80001de4:	40575713          	srai	a4,a4,0x5
80001de8:	00271713          	slli	a4,a4,0x2
80001dec:	00e787b3          	add	a5,a5,a4
80001df0:	00f6a023          	sw	a5,0(a3)

	return bn & 0x1f;
}
80001df4:	01f67513          	andi	a0,a2,31
80001df8:	00008067          	ret

80001dfc <set_free_bit>:

static void set_free_bit(struct sys_mem_pool_base *p, int level, int bn)
{
80001dfc:	fe010113          	addi	sp,sp,-32
	u32_t *word;
	int bit = get_bit_ptr(p, level, bn, &word);
80001e00:	00c10693          	addi	a3,sp,12
{
80001e04:	00112e23          	sw	ra,28(sp)
	int bit = get_bit_ptr(p, level, bn, &word);
80001e08:	fb1ff0ef          	jal	ra,80001db8 <get_bit_ptr>

	*word |= (1<<bit);
80001e0c:	00c12703          	lw	a4,12(sp)
80001e10:	00100793          	li	a5,1
80001e14:	00a79533          	sll	a0,a5,a0
80001e18:	00072783          	lw	a5,0(a4)
}
80001e1c:	01c12083          	lw	ra,28(sp)
	*word |= (1<<bit);
80001e20:	00a7e7b3          	or	a5,a5,a0
80001e24:	00f72023          	sw	a5,0(a4)
}
80001e28:	02010113          	addi	sp,sp,32
80001e2c:	00008067          	ret

80001e30 <z_sys_mem_pool_base_init>:
{
	return ((u8_t *)block + bsz - 1 - (u8_t *)p->buf) < buf_size(p);
}

void z_sys_mem_pool_base_init(struct sys_mem_pool_base *p)
{
80001e30:	fe010113          	addi	sp,sp,-32
80001e34:	00912a23          	sw	s1,20(sp)
	int i;
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001e38:	00452483          	lw	s1,4(a0)
{
80001e3c:	00812c23          	sw	s0,24(sp)
80001e40:	00050413          	mv	s0,a0
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001e44:	00855503          	lhu	a0,8(a0)
80001e48:	00048593          	mv	a1,s1
{
80001e4c:	01212823          	sw	s2,16(sp)
80001e50:	01312623          	sw	s3,12(sp)
80001e54:	01412423          	sw	s4,8(sp)
80001e58:	01512223          	sw	s5,4(sp)
80001e5c:	01612023          	sw	s6,0(sp)
80001e60:	00112e23          	sw	ra,28(sp)
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001e64:	a21fe0ef          	jal	ra,80000884 <__mulsi3>
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001e68:	00042983          	lw	s3,0(s0)

	p->max_inline_level = -1;

	for (i = 0; i < p->n_levels; i++) {
80001e6c:	00a44a83          	lbu	s5,10(s0)
	p->max_inline_level = -1;
80001e70:	fff00793          	li	a5,-1
	size_t buflen = p->n_max * p->max_sz, sz = p->max_sz;
80001e74:	00050a13          	mv	s4,a0
	u32_t *bits = (u32_t *)((u8_t *)p->buf + buflen);
80001e78:	00a989b3          	add	s3,s3,a0
	p->max_inline_level = -1;
80001e7c:	00f405a3          	sb	a5,11(s0)
	for (i = 0; i < p->n_levels; i++) {
80001e80:	00000913          	li	s2,0
		int nblocks = buflen / sz;

		sys_dlist_init(&p->levels[i].free_list);

		if (nblocks < 32) {
80001e84:	01f00b13          	li	s6,31
	for (i = 0; i < p->n_levels; i++) {
80001e88:	03594c63          	blt	s2,s5,80001ec0 <z_sys_mem_pool_base_init+0x90>
		}

		sz = _ALIGN4(sz / 4);
	}

	for (i = 0; i < p->n_max; i++) {
80001e8c:	00000493          	li	s1,0
80001e90:	00845783          	lhu	a5,8(s0)
80001e94:	08f4cc63          	blt	s1,a5,80001f2c <z_sys_mem_pool_base_init+0xfc>
		void *block = block_ptr(p, p->max_sz, i);

		sys_dlist_append(&p->levels[0].free_list, block);
		set_free_bit(p, 0, i);
	}
}
80001e98:	01c12083          	lw	ra,28(sp)
80001e9c:	01812403          	lw	s0,24(sp)
80001ea0:	01412483          	lw	s1,20(sp)
80001ea4:	01012903          	lw	s2,16(sp)
80001ea8:	00c12983          	lw	s3,12(sp)
80001eac:	00812a03          	lw	s4,8(sp)
80001eb0:	00412a83          	lw	s5,4(sp)
80001eb4:	00012b03          	lw	s6,0(sp)
80001eb8:	02010113          	addi	sp,sp,32
80001ebc:	00008067          	ret
		int nblocks = buflen / sz;
80001ec0:	00048593          	mv	a1,s1
80001ec4:	000a0513          	mv	a0,s4
80001ec8:	a79fe0ef          	jal	ra,80000940 <__udivsi3>
		sys_dlist_init(&p->levels[i].free_list);
80001ecc:	00191713          	slli	a4,s2,0x1
80001ed0:	01270733          	add	a4,a4,s2
80001ed4:	00271793          	slli	a5,a4,0x2
80001ed8:	00c42703          	lw	a4,12(s0)
80001edc:	00f70733          	add	a4,a4,a5
80001ee0:	00470793          	addi	a5,a4,4
 * @return N/A
 */

static inline void sys_dlist_init(sys_dlist_t *list)
{
	list->head = (sys_dnode_t *)list;
80001ee4:	00f72223          	sw	a5,4(a4)
	list->tail = (sys_dnode_t *)list;
80001ee8:	00f72423          	sw	a5,8(a4)
		if (nblocks < 32) {
80001eec:	00ab4e63          	blt	s6,a0,80001f08 <z_sys_mem_pool_base_init+0xd8>
			p->max_inline_level = i;
80001ef0:	012405a3          	sb	s2,11(s0)
		sz = _ALIGN4(sz / 4);
80001ef4:	0024d493          	srli	s1,s1,0x2
80001ef8:	00348493          	addi	s1,s1,3
80001efc:	ffc4f493          	andi	s1,s1,-4
	for (i = 0; i < p->n_levels; i++) {
80001f00:	00190913          	addi	s2,s2,1
80001f04:	f85ff06f          	j	80001e88 <z_sys_mem_pool_base_init+0x58>
			bits += (nblocks + 31)/32;
80001f08:	01f50513          	addi	a0,a0,31
80001f0c:	41f55793          	srai	a5,a0,0x1f
80001f10:	01f7f793          	andi	a5,a5,31
80001f14:	00a787b3          	add	a5,a5,a0
80001f18:	4057d793          	srai	a5,a5,0x5
80001f1c:	00279793          	slli	a5,a5,0x2
			p->levels[i].bits_p = bits;
80001f20:	01372023          	sw	s3,0(a4)
			bits += (nblocks + 31)/32;
80001f24:	00f989b3          	add	s3,s3,a5
80001f28:	fcdff06f          	j	80001ef4 <z_sys_mem_pool_base_init+0xc4>
	return (u8_t *)p->buf + lsz * block;
80001f2c:	00442583          	lw	a1,4(s0)
80001f30:	00048513          	mv	a0,s1
80001f34:	951fe0ef          	jal	ra,80000884 <__mulsi3>
80001f38:	00042783          	lw	a5,0(s0)
		set_free_bit(p, 0, i);
80001f3c:	00048613          	mv	a2,s1
80001f40:	00000593          	li	a1,0
	return (u8_t *)p->buf + lsz * block;
80001f44:	00a78533          	add	a0,a5,a0
		sys_dlist_append(&p->levels[0].free_list, block);
80001f48:	00c42783          	lw	a5,12(s0)
	for (i = 0; i < p->n_max; i++) {
80001f4c:	00148493          	addi	s1,s1,1
		sys_dlist_append(&p->levels[0].free_list, block);
80001f50:	00478713          	addi	a4,a5,4
 * @return N/A
 */

static inline void sys_dlist_append(sys_dlist_t *list, sys_dnode_t *node)
{
	node->next = list;
80001f54:	00e52023          	sw	a4,0(a0)
	node->prev = list->tail;
80001f58:	0087a703          	lw	a4,8(a5)
80001f5c:	00e52223          	sw	a4,4(a0)

	list->tail->next = node;
80001f60:	0087a703          	lw	a4,8(a5)
80001f64:	00a72023          	sw	a0,0(a4)
	list->tail = node;
80001f68:	00a7a423          	sw	a0,8(a5)
		set_free_bit(p, 0, i);
80001f6c:	00040513          	mv	a0,s0
80001f70:	e8dff0ef          	jal	ra,80001dfc <set_free_bit>
80001f74:	f1dff06f          	j	80001e90 <z_sys_mem_pool_base_init+0x60>

80001f78 <z_thread_entry>:
 * This routine does not return, and is marked as such so the compiler won't
 * generate preamble code that is only used by functions that actually return.
 */
FUNC_NORETURN void z_thread_entry(k_thread_entry_t entry,
				 void *p1, void *p2, void *p3)
{
80001f78:	ff010113          	addi	sp,sp,-16
80001f7c:	00050793          	mv	a5,a0
80001f80:	00058513          	mv	a0,a1
80001f84:	00060593          	mv	a1,a2
	entry(p1, p2, p3);
80001f88:	00068613          	mv	a2,a3
{
80001f8c:	00112623          	sw	ra,12(sp)
	entry(p1, p2, p3);
80001f90:	000780e7          	jalr	a5
80001f94:	1d9020ef          	jal	ra,8000496c <z_impl_k_current_get>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80001f98:	24c030ef          	jal	ra,800051e4 <z_impl_k_thread_abort>

80001f9c <z_arch_printk_char_out>:
{
	ARG_UNUSED(c);

	/* do nothing */
	return 0;
}
80001f9c:	00000513          	li	a0,0
80001fa0:	00008067          	ret

80001fa4 <print_err>:
{
	return _char_out;
}

static void print_err(out_func_t out, void *ctx)
{
80001fa4:	ff010113          	addi	sp,sp,-16
80001fa8:	00812423          	sw	s0,8(sp)
80001fac:	00050413          	mv	s0,a0
	out('E', ctx);
80001fb0:	04500513          	li	a0,69
{
80001fb4:	00112623          	sw	ra,12(sp)
80001fb8:	00912223          	sw	s1,4(sp)
80001fbc:	00058493          	mv	s1,a1
	out('E', ctx);
80001fc0:	000400e7          	jalr	s0
	out('R', ctx);
80001fc4:	00048593          	mv	a1,s1
80001fc8:	05200513          	li	a0,82
80001fcc:	000400e7          	jalr	s0
	out('R', ctx);
80001fd0:	00040313          	mv	t1,s0
}
80001fd4:	00812403          	lw	s0,8(sp)
80001fd8:	00c12083          	lw	ra,12(sp)
	out('R', ctx);
80001fdc:	00048593          	mv	a1,s1
}
80001fe0:	00412483          	lw	s1,4(sp)
	out('R', ctx);
80001fe4:	05200513          	li	a0,82
}
80001fe8:	01010113          	addi	sp,sp,16
	out('R', ctx);
80001fec:	00030067          	jr	t1

80001ff0 <char_out>:

static int char_out(int c, void *ctx_p)
{
	struct out_context *ctx = ctx_p;

	ctx->count++;
80001ff0:	0005a783          	lw	a5,0(a1)
80001ff4:	00178793          	addi	a5,a5,1
80001ff8:	00f5a023          	sw	a5,0(a1)
	return _char_out(c);
80001ffc:	800077b7          	lui	a5,0x80007
80002000:	52c7a303          	lw	t1,1324(a5) # 8000752c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000752d>
80002004:	00030067          	jr	t1

80002008 <_printk_dec_ulong>:
 * @return N/A
 */
static void _printk_dec_ulong(out_func_t out, void *ctx,
			      const unsigned long num, enum pad_type padding,
			      int min_width)
{
80002008:	fc010113          	addi	sp,sp,-64
8000200c:	02812c23          	sw	s0,56(sp)
80002010:	03312623          	sw	s3,44(sp)
80002014:	03412423          	sw	s4,40(sp)
80002018:	03612023          	sw	s6,32(sp)
8000201c:	01a12823          	sw	s10,16(sp)
80002020:	02112e23          	sw	ra,60(sp)
80002024:	02912a23          	sw	s1,52(sp)
80002028:	03212823          	sw	s2,48(sp)
8000202c:	03512223          	sw	s5,36(sp)
80002030:	01712e23          	sw	s7,28(sp)
80002034:	01812c23          	sw	s8,24(sp)
80002038:	01912a23          	sw	s9,20(sp)
8000203c:	01b12623          	sw	s11,12(sp)
80002040:	00050993          	mv	s3,a0
80002044:	00058a13          	mv	s4,a1
80002048:	00060d13          	mv	s10,a2
8000204c:	00068b13          	mv	s6,a3
80002050:	00100413          	li	s0,1
80002054:	00e05463          	blez	a4,8000205c <_printk_dec_ulong+0x54>
80002058:	00070413          	mv	s0,a4
8000205c:	00100793          	li	a5,1
80002060:	02000c93          	li	s9,32
80002064:	00fb1463          	bne	s6,a5,8000206c <_printk_dec_ulong+0x64>
80002068:	03000c93          	li	s9,48
8000206c:	3b9ad4b7          	lui	s1,0x3b9ad
80002070:	00100913          	li	s2,1
80002074:	00a00a93          	li	s5,10
80002078:	00000c13          	li	s8,0
8000207c:	9ff48493          	addi	s1,s1,-1537 # 3b9ac9ff <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC+0x3ae3aeff>
		if (found_largest_digit != 0 || remainder > pos) {
			found_largest_digit = 1;
			out((int)((remainder / (pos + 1)) + 48), ctx);
			digits++;
		} else if (remaining <= min_width
				&& padding < PAD_SPACE_AFTER) {
80002080:	00200d93          	li	s11,2
		if (found_largest_digit != 0 || remainder > pos) {
80002084:	00148b93          	addi	s7,s1,1
80002088:	000c1463          	bnez	s8,80002090 <_printk_dec_ulong+0x88>
8000208c:	0ba4f263          	bgeu	s1,s10,80002130 <_printk_dec_ulong+0x128>
			out((int)((remainder / (pos + 1)) + 48), ctx);
80002090:	000b8593          	mv	a1,s7
80002094:	000d0513          	mv	a0,s10
80002098:	8a9fe0ef          	jal	ra,80000940 <__udivsi3>
8000209c:	000a0593          	mv	a1,s4
800020a0:	03050513          	addi	a0,a0,48
800020a4:	000980e7          	jalr	s3
			digits++;
800020a8:	00190913          	addi	s2,s2,1
			found_largest_digit = 1;
800020ac:	00100c13          	li	s8,1
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
			digits++;
		}
		remaining--;
		remainder %= (pos + 1);
800020b0:	000b8593          	mv	a1,s7
800020b4:	000d0513          	mv	a0,s10
800020b8:	8d1fe0ef          	jal	ra,80000988 <__umodsi3>
800020bc:	00050d13          	mv	s10,a0
		pos /= 10;
800020c0:	00a00593          	li	a1,10
800020c4:	00048513          	mv	a0,s1
800020c8:	879fe0ef          	jal	ra,80000940 <__udivsi3>
		remaining--;
800020cc:	fffa8a93          	addi	s5,s5,-1
	while (pos >= 9) {
800020d0:	00100793          	li	a5,1
		pos /= 10;
800020d4:	00050493          	mv	s1,a0
	while (pos >= 9) {
800020d8:	fafa96e3          	bne	s5,a5,80002084 <_printk_dec_ulong+0x7c>
	}
	out((int)(remainder + 48), ctx);
800020dc:	000a0593          	mv	a1,s4
800020e0:	030d0513          	addi	a0,s10,48
800020e4:	000980e7          	jalr	s3

	if (padding == PAD_SPACE_AFTER) {
800020e8:	00300793          	li	a5,3
		remaining = min_width - digits;
800020ec:	41240433          	sub	s0,s0,s2
	if (padding == PAD_SPACE_AFTER) {
800020f0:	06fb0663          	beq	s6,a5,8000215c <_printk_dec_ulong+0x154>
		while (remaining-- > 0) {
			out(' ', ctx);
		}
	}
}
800020f4:	03c12083          	lw	ra,60(sp)
800020f8:	03812403          	lw	s0,56(sp)
800020fc:	03412483          	lw	s1,52(sp)
80002100:	03012903          	lw	s2,48(sp)
80002104:	02c12983          	lw	s3,44(sp)
80002108:	02812a03          	lw	s4,40(sp)
8000210c:	02412a83          	lw	s5,36(sp)
80002110:	02012b03          	lw	s6,32(sp)
80002114:	01c12b83          	lw	s7,28(sp)
80002118:	01812c03          	lw	s8,24(sp)
8000211c:	01412c83          	lw	s9,20(sp)
80002120:	01012d03          	lw	s10,16(sp)
80002124:	00c12d83          	lw	s11,12(sp)
80002128:	04010113          	addi	sp,sp,64
8000212c:	00008067          	ret
		} else if (remaining <= min_width
80002130:	f95440e3          	blt	s0,s5,800020b0 <_printk_dec_ulong+0xa8>
				&& padding < PAD_SPACE_AFTER) {
80002134:	f76deee3          	bltu	s11,s6,800020b0 <_printk_dec_ulong+0xa8>
			out((int)(padding == PAD_ZERO_BEFORE ? '0' : ' '), ctx);
80002138:	000a0593          	mv	a1,s4
8000213c:	000c8513          	mv	a0,s9
80002140:	000980e7          	jalr	s3
			digits++;
80002144:	00190913          	addi	s2,s2,1
80002148:	f69ff06f          	j	800020b0 <_printk_dec_ulong+0xa8>
			out(' ', ctx);
8000214c:	000a0593          	mv	a1,s4
80002150:	02000513          	li	a0,32
80002154:	000980e7          	jalr	s3
80002158:	fff40413          	addi	s0,s0,-1
		while (remaining-- > 0) {
8000215c:	fe8048e3          	bgtz	s0,8000214c <_printk_dec_ulong+0x144>
80002160:	f95ff06f          	j	800020f4 <_printk_dec_ulong+0xec>

80002164 <__printk_hook_install>:
	_char_out = fn;
80002164:	800077b7          	lui	a5,0x80007
80002168:	52a7a623          	sw	a0,1324(a5) # 8000752c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000752d>
}
8000216c:	00008067          	ret

80002170 <z_vprintk>:
{
80002170:	fb010113          	addi	sp,sp,-80
80002174:	04812423          	sw	s0,72(sp)
80002178:	04912223          	sw	s1,68(sp)
8000217c:	05212023          	sw	s2,64(sp)
80002180:	03312e23          	sw	s3,60(sp)
80002184:	03412c23          	sw	s4,56(sp)
80002188:	03512a23          	sw	s5,52(sp)
8000218c:	03912223          	sw	s9,36(sp)
80002190:	03a12023          	sw	s10,32(sp)
80002194:	01b12e23          	sw	s11,28(sp)
80002198:	04112623          	sw	ra,76(sp)
8000219c:	03612823          	sw	s6,48(sp)
800021a0:	03712623          	sw	s7,44(sp)
800021a4:	03812423          	sw	s8,40(sp)
800021a8:	00050413          	mv	s0,a0
800021ac:	00058493          	mv	s1,a1
800021b0:	00060a93          	mv	s5,a2
800021b4:	00068d13          	mv	s10,a3
	int long_ctr = 0;
800021b8:	00000a13          	li	s4,0
	int min_width = -1;
800021bc:	fff00913          	li	s2,-1
	enum pad_type padding = PAD_NONE;
800021c0:	00000993          	li	s3,0
	int might_format = 0; /* 1 if encountered a '%' */
800021c4:	00000c93          	li	s9,0
					if (lld > INT32_MAX ||
800021c8:	80000db7          	lui	s11,0x80000
	while (*fmt) {
800021cc:	000ac503          	lbu	a0,0(s5)
800021d0:	04051063          	bnez	a0,80002210 <z_vprintk+0xa0>
}
800021d4:	04c12083          	lw	ra,76(sp)
800021d8:	04812403          	lw	s0,72(sp)
800021dc:	04412483          	lw	s1,68(sp)
800021e0:	04012903          	lw	s2,64(sp)
800021e4:	03c12983          	lw	s3,60(sp)
800021e8:	03812a03          	lw	s4,56(sp)
800021ec:	03412a83          	lw	s5,52(sp)
800021f0:	03012b03          	lw	s6,48(sp)
800021f4:	02c12b83          	lw	s7,44(sp)
800021f8:	02812c03          	lw	s8,40(sp)
800021fc:	02412c83          	lw	s9,36(sp)
80002200:	02012d03          	lw	s10,32(sp)
80002204:	01c12d83          	lw	s11,28(sp)
80002208:	05010113          	addi	sp,sp,80
8000220c:	00008067          	ret
		if (!might_format) {
80002210:	000c9e63          	bnez	s9,8000222c <z_vprintk+0xbc>
			if (*fmt != '%') {
80002214:	02500693          	li	a3,37
80002218:	36d50c63          	beq	a0,a3,80002590 <z_vprintk+0x420>
				out((int)*fmt, ctx);
8000221c:	00048593          	mv	a1,s1
80002220:	000400e7          	jalr	s0
		++fmt;
80002224:	001a8a93          	addi	s5,s5,1
80002228:	fa5ff06f          	j	800021cc <z_vprintk+0x5c>
			switch (*fmt) {
8000222c:	06400693          	li	a3,100
80002230:	12d50063          	beq	a0,a3,80002350 <z_vprintk+0x1e0>
80002234:	06a6e263          	bltu	a3,a0,80002298 <z_vprintk+0x128>
80002238:	03900693          	li	a3,57
8000223c:	02a6ea63          	bltu	a3,a0,80002270 <z_vprintk+0x100>
80002240:	03100693          	li	a3,49
80002244:	0ed57463          	bgeu	a0,a3,8000232c <z_vprintk+0x1bc>
80002248:	02d00693          	li	a3,45
8000224c:	34d50c63          	beq	a0,a3,800025a4 <z_vprintk+0x434>
80002250:	03000793          	li	a5,48
80002254:	0cf50063          	beq	a0,a5,80002314 <z_vprintk+0x1a4>
80002258:	02500713          	li	a4,37
8000225c:	02e51263          	bne	a0,a4,80002280 <z_vprintk+0x110>
				out((int)'%', ctx);
80002260:	00048593          	mv	a1,s1
80002264:	02500513          	li	a0,37
				out((int)*fmt, ctx);
80002268:	000400e7          	jalr	s0
				break;
8000226c:	1600006f          	j	800023cc <z_vprintk+0x25c>
80002270:	05800693          	li	a3,88
80002274:	1cd50063          	beq	a0,a3,80002434 <z_vprintk+0x2c4>
80002278:	06300713          	li	a4,99
8000227c:	30e50063          	beq	a0,a4,8000257c <z_vprintk+0x40c>
				out((int)'%', ctx);
80002280:	00048593          	mv	a1,s1
80002284:	02500513          	li	a0,37
80002288:	000400e7          	jalr	s0
				out((int)*fmt, ctx);
8000228c:	00048593          	mv	a1,s1
80002290:	000ac503          	lbu	a0,0(s5)
80002294:	fd5ff06f          	j	80002268 <z_vprintk+0xf8>
80002298:	07000693          	li	a3,112
8000229c:	16d50c63          	beq	a0,a3,80002414 <z_vprintk+0x2a4>
800022a0:	02a6e063          	bltu	a3,a0,800022c0 <z_vprintk+0x150>
800022a4:	06900693          	li	a3,105
800022a8:	0ad50463          	beq	a0,a3,80002350 <z_vprintk+0x1e0>
800022ac:	06c00693          	li	a3,108
800022b0:	08d50c63          	beq	a0,a3,80002348 <z_vprintk+0x1d8>
800022b4:	06800693          	li	a3,104
800022b8:	f6d506e3          	beq	a0,a3,80002224 <z_vprintk+0xb4>
800022bc:	fc5ff06f          	j	80002280 <z_vprintk+0x110>
800022c0:	07500693          	li	a3,117
800022c4:	10d50863          	beq	a0,a3,800023d4 <z_vprintk+0x264>
800022c8:	02a6ee63          	bltu	a3,a0,80002304 <z_vprintk+0x194>
800022cc:	07300713          	li	a4,115
800022d0:	fae518e3          	bne	a0,a4,80002280 <z_vprintk+0x110>
				char *s = va_arg(ap, char *);
800022d4:	000d2c03          	lw	s8,0(s10)
800022d8:	004d0b13          	addi	s6,s10,4
800022dc:	000c0b93          	mv	s7,s8
				while (*s)
800022e0:	000bc503          	lbu	a0,0(s7)
800022e4:	26051a63          	bnez	a0,80002558 <z_vprintk+0x3e8>
				if (padding == PAD_SPACE_AFTER) {
800022e8:	00300793          	li	a5,3
800022ec:	00f99863          	bne	s3,a5,800022fc <z_vprintk+0x18c>
					int remaining = min_width - (s - start);
800022f0:	418b8bb3          	sub	s7,s7,s8
800022f4:	41790bb3          	sub	s7,s2,s7
					while (remaining-- > 0) {
800022f8:	27704863          	bgtz	s7,80002568 <z_vprintk+0x3f8>
				char *s = va_arg(ap, char *);
800022fc:	000b0d13          	mv	s10,s6
80002300:	0cc0006f          	j	800023cc <z_vprintk+0x25c>
80002304:	07800693          	li	a3,120
80002308:	12d50663          	beq	a0,a3,80002434 <z_vprintk+0x2c4>
8000230c:	07a00693          	li	a3,122
80002310:	fa9ff06f          	j	800022b8 <z_vprintk+0x148>
				if (min_width < 0 && padding == PAD_NONE) {
80002314:	00095e63          	bgez	s2,80002330 <z_vprintk+0x1c0>
80002318:	28098a63          	beqz	s3,800025ac <z_vprintk+0x43c>
					min_width = *fmt - '0';
8000231c:	fd050913          	addi	s2,a0,-48
				if (padding == PAD_NONE) {
80002320:	f00992e3          	bnez	s3,80002224 <z_vprintk+0xb4>
					padding = PAD_SPACE_BEFORE;
80002324:	00200993          	li	s3,2
80002328:	efdff06f          	j	80002224 <z_vprintk+0xb4>
				if (min_width < 0) {
8000232c:	fe0948e3          	bltz	s2,8000231c <z_vprintk+0x1ac>
					min_width = 10 * min_width + *fmt - '0';
80002330:	00291693          	slli	a3,s2,0x2
80002334:	01268933          	add	s2,a3,s2
80002338:	00191913          	slli	s2,s2,0x1
8000233c:	fd090913          	addi	s2,s2,-48
80002340:	01250933          	add	s2,a0,s2
80002344:	fddff06f          	j	80002320 <z_vprintk+0x1b0>
				long_ctr++;
80002348:	001a0a13          	addi	s4,s4,1
8000234c:	ed9ff06f          	j	80002224 <z_vprintk+0xb4>
				if (long_ctr == 0) {
80002350:	040a1263          	bnez	s4,80002394 <z_vprintk+0x224>
					long ld = va_arg(ap, long);
80002354:	000d2603          	lw	a2,0(s10)
80002358:	004d0d13          	addi	s10,s10,4
				if (d < 0) {
8000235c:	02065063          	bgez	a2,8000237c <z_vprintk+0x20c>
					out((int)'-', ctx);
80002360:	00048593          	mv	a1,s1
80002364:	02d00513          	li	a0,45
80002368:	00c12023          	sw	a2,0(sp)
8000236c:	000400e7          	jalr	s0
					d = -d;
80002370:	00012603          	lw	a2,0(sp)
					min_width--;
80002374:	fff90913          	addi	s2,s2,-1
					d = -d;
80002378:	40c00633          	neg	a2,a2
				_printk_dec_ulong(out, ctx, u, padding,
8000237c:	00090713          	mv	a4,s2
80002380:	00098693          	mv	a3,s3
80002384:	00048593          	mv	a1,s1
80002388:	00040513          	mv	a0,s0
8000238c:	c7dff0ef          	jal	ra,80002008 <_printk_dec_ulong>
				break;
80002390:	03c0006f          	j	800023cc <z_vprintk+0x25c>
				} else if (long_ctr == 1) {
80002394:	00100713          	li	a4,1
80002398:	faea0ee3          	beq	s4,a4,80002354 <z_vprintk+0x1e4>
					long long lld = va_arg(ap, long long);
8000239c:	007d0793          	addi	a5,s10,7
800023a0:	ff87f713          	andi	a4,a5,-8
800023a4:	00072603          	lw	a2,0(a4)
800023a8:	00472683          	lw	a3,4(a4)
800023ac:	00870d13          	addi	s10,a4,8
					if (lld > INT32_MAX ||
800023b0:	01b60733          	add	a4,a2,s11
800023b4:	00c73733          	sltu	a4,a4,a2
800023b8:	00d70733          	add	a4,a4,a3
800023bc:	fa0700e3          	beqz	a4,8000235c <z_vprintk+0x1ec>
						print_err(out, ctx);
800023c0:	00048593          	mv	a1,s1
800023c4:	00040513          	mv	a0,s0
800023c8:	bddff0ef          	jal	ra,80001fa4 <print_err>
			might_format = 0;
800023cc:	00000c93          	li	s9,0
800023d0:	e55ff06f          	j	80002224 <z_vprintk+0xb4>
				if (long_ctr == 0) {
800023d4:	000a1863          	bnez	s4,800023e4 <z_vprintk+0x274>
					long lu = va_arg(ap, unsigned long);
800023d8:	000d2603          	lw	a2,0(s10)
800023dc:	004d0d13          	addi	s10,s10,4
800023e0:	f9dff06f          	j	8000237c <z_vprintk+0x20c>
				} else if (long_ctr == 1) {
800023e4:	00100713          	li	a4,1
800023e8:	feea08e3          	beq	s4,a4,800023d8 <z_vprintk+0x268>
					unsigned long long llu =
800023ec:	007d0793          	addi	a5,s10,7
800023f0:	ff87f713          	andi	a4,a5,-8
800023f4:	00870d13          	addi	s10,a4,8
800023f8:	00072603          	lw	a2,0(a4)
800023fc:	00472703          	lw	a4,4(a4)
					if (llu > INT32_MAX) {
80002400:	fc0710e3          	bnez	a4,800023c0 <z_vprintk+0x250>
80002404:	800007b7          	lui	a5,0x80000
80002408:	fff7c793          	not	a5,a5
8000240c:	f6c7f8e3          	bgeu	a5,a2,8000237c <z_vprintk+0x20c>
80002410:	fb1ff06f          	j	800023c0 <z_vprintk+0x250>
				  out('0', ctx);
80002414:	00048593          	mv	a1,s1
80002418:	03000513          	li	a0,48
8000241c:	000400e7          	jalr	s0
				  out('x', ctx);
80002420:	00048593          	mv	a1,s1
80002424:	07800513          	li	a0,120
80002428:	000400e7          	jalr	s0
				  min_width = 8;
8000242c:	00800913          	li	s2,8
				  padding = PAD_ZERO_BEFORE;
80002430:	00100993          	li	s3,1
				if (long_ctr < 2) {
80002434:	00100693          	li	a3,1
80002438:	0b46c263          	blt	a3,s4,800024dc <z_vprintk+0x36c>
					x = va_arg(ap, unsigned long);
8000243c:	000d2783          	lw	a5,0(s10)
80002440:	00012423          	sw	zero,8(sp)
80002444:	004d0d13          	addi	s10,s10,4
80002448:	00f12223          	sw	a5,4(sp)
	int remaining = 16; /* 16 digits max */
8000244c:	01000c13          	li	s8,16
	int digits = 0;
80002450:	00000b93          	li	s7,0
	int found_largest_digit = 0;
80002454:	00012023          	sw	zero,0(sp)
	int size = sizeof(num) * 2;
80002458:	01000893          	li	a7,16
		char nibble = (num >> ((size - 1) << 2) & 0xf);
8000245c:	00412503          	lw	a0,4(sp)
80002460:	00812583          	lw	a1,8(sp)
80002464:	fff88b13          	addi	s6,a7,-1
80002468:	002b1613          	slli	a2,s6,0x2
8000246c:	01112623          	sw	a7,12(sp)
80002470:	e09fd0ef          	jal	ra,80000278 <__lshrdi3>
80002474:	00f57513          	andi	a0,a0,15
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002478:	08051863          	bnez	a0,80002508 <z_vprintk+0x398>
8000247c:	00012783          	lw	a5,0(sp)
			nibble += nibble > 9 ? 87 : 48;
80002480:	03000693          	li	a3,48
		if (nibble != 0 || found_largest_digit != 0 || size == 1) {
80002484:	00079863          	bnez	a5,80002494 <z_vprintk+0x324>
80002488:	00c12883          	lw	a7,12(sp)
8000248c:	00100793          	li	a5,1
80002490:	08f89663          	bne	a7,a5,8000251c <z_vprintk+0x3ac>
			nibble += nibble > 9 ? 87 : 48;
80002494:	00a68533          	add	a0,a3,a0
			out((int)nibble, ctx);
80002498:	01851513          	slli	a0,a0,0x18
8000249c:	00048593          	mv	a1,s1
800024a0:	41855513          	srai	a0,a0,0x18
800024a4:	000400e7          	jalr	s0
			digits++;
800024a8:	001b8b93          	addi	s7,s7,1
	for (; size != 0; size--) {
800024ac:	040b1863          	bnez	s6,800024fc <z_vprintk+0x38c>
	if (padding == PAD_SPACE_AFTER) {
800024b0:	00300693          	li	a3,3
			might_format = 0;
800024b4:	00000c93          	li	s9,0
	if (padding == PAD_SPACE_AFTER) {
800024b8:	d6d996e3          	bne	s3,a3,80002224 <z_vprintk+0xb4>
		remaining = min_width * 2 - digits;
800024bc:	00191713          	slli	a4,s2,0x1
800024c0:	41770bb3          	sub	s7,a4,s7
		while (remaining-- > 0) {
800024c4:	f17054e3          	blez	s7,800023cc <z_vprintk+0x25c>
			out(' ', ctx);
800024c8:	00048593          	mv	a1,s1
800024cc:	02000513          	li	a0,32
800024d0:	000400e7          	jalr	s0
800024d4:	fffb8b93          	addi	s7,s7,-1
800024d8:	fedff06f          	j	800024c4 <z_vprintk+0x354>
					x = va_arg(ap, unsigned long long);
800024dc:	007d0793          	addi	a5,s10,7
800024e0:	ff87f693          	andi	a3,a5,-8
800024e4:	0006a783          	lw	a5,0(a3)
800024e8:	00868d13          	addi	s10,a3,8
800024ec:	00f12223          	sw	a5,4(sp)
800024f0:	0046a783          	lw	a5,4(a3)
800024f4:	00f12423          	sw	a5,8(sp)
800024f8:	f55ff06f          	j	8000244c <z_vprintk+0x2dc>
			found_largest_digit = 1;
800024fc:	01912023          	sw	s9,0(sp)
		char nibble = (num >> ((size - 1) << 2) & 0xf);
80002500:	000b0893          	mv	a7,s6
80002504:	f59ff06f          	j	8000245c <z_vprintk+0x2ec>
			nibble += nibble > 9 ? 87 : 48;
80002508:	00900793          	li	a5,9
8000250c:	05700693          	li	a3,87
80002510:	f8a7e2e3          	bltu	a5,a0,80002494 <z_vprintk+0x324>
80002514:	03000693          	li	a3,48
80002518:	f7dff06f          	j	80002494 <z_vprintk+0x324>
		if (remaining-- <= min_width) {
8000251c:	fffc0793          	addi	a5,s8,-1
80002520:	00f12623          	sw	a5,12(sp)
80002524:	01894c63          	blt	s2,s8,8000253c <z_vprintk+0x3cc>
			if (padding == PAD_ZERO_BEFORE) {
80002528:	00100793          	li	a5,1
8000252c:	00f99c63          	bne	s3,a5,80002544 <z_vprintk+0x3d4>
				out('0', ctx);
80002530:	00048593          	mv	a1,s1
80002534:	03000513          	li	a0,48
				out(' ', ctx);
80002538:	000400e7          	jalr	s0
					x = va_arg(ap, unsigned long);
8000253c:	00c12c03          	lw	s8,12(sp)
80002540:	fc1ff06f          	j	80002500 <z_vprintk+0x390>
			} else if (padding == PAD_SPACE_BEFORE) {
80002544:	00200793          	li	a5,2
80002548:	fef99ae3          	bne	s3,a5,8000253c <z_vprintk+0x3cc>
				out(' ', ctx);
8000254c:	00048593          	mv	a1,s1
80002550:	02000513          	li	a0,32
80002554:	fe5ff06f          	j	80002538 <z_vprintk+0x3c8>
					out((int)(*s++), ctx);
80002558:	00048593          	mv	a1,s1
8000255c:	001b8b93          	addi	s7,s7,1
80002560:	000400e7          	jalr	s0
80002564:	d7dff06f          	j	800022e0 <z_vprintk+0x170>
						out(' ', ctx);
80002568:	00048593          	mv	a1,s1
8000256c:	02000513          	li	a0,32
80002570:	000400e7          	jalr	s0
80002574:	fffb8b93          	addi	s7,s7,-1
80002578:	d81ff06f          	j	800022f8 <z_vprintk+0x188>
				out(c, ctx);
8000257c:	000d2503          	lw	a0,0(s10)
80002580:	00048593          	mv	a1,s1
				int c = va_arg(ap, int);
80002584:	004d0b13          	addi	s6,s10,4
				out(c, ctx);
80002588:	000400e7          	jalr	s0
				break;
8000258c:	d71ff06f          	j	800022fc <z_vprintk+0x18c>
				long_ctr = 0;
80002590:	00000a13          	li	s4,0
				min_width = -1;
80002594:	fff00913          	li	s2,-1
				padding = PAD_NONE;
80002598:	00000993          	li	s3,0
				might_format = 1;
8000259c:	00100c93          	li	s9,1
800025a0:	c85ff06f          	j	80002224 <z_vprintk+0xb4>
				padding = PAD_SPACE_AFTER;
800025a4:	00300993          	li	s3,3
800025a8:	c7dff06f          	j	80002224 <z_vprintk+0xb4>
					padding = PAD_ZERO_BEFORE;
800025ac:	00100993          	li	s3,1
800025b0:	c75ff06f          	j	80002224 <z_vprintk+0xb4>

800025b4 <vprintk>:
{
800025b4:	fe010113          	addi	sp,sp,-32
	z_vprintk(char_out, &ctx, fmt, ap);
800025b8:	00050613          	mv	a2,a0
800025bc:	80002537          	lui	a0,0x80002
800025c0:	00058693          	mv	a3,a1
800025c4:	ff050513          	addi	a0,a0,-16 # 80001ff0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80001ff1>
800025c8:	00c10593          	addi	a1,sp,12
{
800025cc:	00112e23          	sw	ra,28(sp)
	struct out_context ctx = { 0 };
800025d0:	00012623          	sw	zero,12(sp)
	z_vprintk(char_out, &ctx, fmt, ap);
800025d4:	b9dff0ef          	jal	ra,80002170 <z_vprintk>
}
800025d8:	01c12083          	lw	ra,28(sp)
800025dc:	02010113          	addi	sp,sp,32
800025e0:	00008067          	ret

800025e4 <printk>:
{
800025e4:	fc010113          	addi	sp,sp,-64
800025e8:	02b12223          	sw	a1,36(sp)
	va_start(ap, fmt);
800025ec:	02410593          	addi	a1,sp,36
{
800025f0:	00112e23          	sw	ra,28(sp)
800025f4:	02c12423          	sw	a2,40(sp)
800025f8:	02d12623          	sw	a3,44(sp)
800025fc:	02e12823          	sw	a4,48(sp)
80002600:	02f12a23          	sw	a5,52(sp)
80002604:	03012c23          	sw	a6,56(sp)
80002608:	03112e23          	sw	a7,60(sp)
	va_start(ap, fmt);
8000260c:	00b12623          	sw	a1,12(sp)
		vprintk(fmt, ap);
80002610:	fa5ff0ef          	jal	ra,800025b4 <vprintk>
}
80002614:	01c12083          	lw	ra,28(sp)
80002618:	04010113          	addi	sp,sp,64
8000261c:	00008067          	ret

80002620 <assert_post_action>:
__weak void assert_post_action(const char *file, unsigned int line)
{
  ARG_UNUSED(file);
  ARG_UNUSED(line);

  k_panic();
80002620:	800075b7          	lui	a1,0x80007
80002624:	80007537          	lui	a0,0x80007
{
80002628:	ff010113          	addi	sp,sp,-16
  k_panic();
8000262c:	ef858593          	addi	a1,a1,-264 # 80006ef8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ef9>
80002630:	f0c50513          	addi	a0,a0,-244 # 80006f0c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f0d>
80002634:	01e00613          	li	a2,30
{
80002638:	00112623          	sw	ra,12(sp)
  k_panic();
8000263c:	fa9ff0ef          	jal	ra,800025e4 <printk>
80002640:	800075b7          	lui	a1,0x80007
80002644:	b1c58593          	addi	a1,a1,-1252 # 80006b1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006b1d>
80002648:	00600513          	li	a0,6
8000264c:	c40ff0ef          	jal	ra,80001a8c <z_NanoFatalErrorHandler>

80002650 <_ConfigAbsSyms>:
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_STAT, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_DISASSEMBLY, 1);
GEN_ABSOLUTE_SYM(CONFIG_OUTPUT_PRINT_MEMORY_USAGE, 1);
GEN_ABSOLUTE_SYM(CONFIG_BUILD_OUTPUT_BIN, 1);

GEN_ABS_SYM_END
80002650:	00008067          	ret

80002654 <k_cpu_idle>:
 */
static ALWAYS_INLINE void z_arch_irq_unlock(unsigned int key)
{
	unsigned int mstatus;

	__asm__ volatile ("csrrs %0, mstatus, %1"
80002654:	00800793          	li	a5,8
80002658:	3007a7f3          	csrrs	a5,mstatus,a5
	z_sys_trace_idle();
	/* unlock interrupts */
	irq_unlock(key);

	/* Wait for interrupt */
	__asm__ volatile("wfi");
8000265c:	10500073          	wfi
 * @return N/A
 */
void k_cpu_idle(void)
{
	riscv_idle(SOC_MSTATUS_IEN);
}
80002660:	00008067          	ret

80002664 <z_arch_irq_enable>:
	 * CSR mie register is updated using atomic instruction csrrs
	 * (atomic read and set bits in CSR register)
	 */
	__asm__ volatile ("csrrs %0, mie, %1\n"
			  : "=r" (mie)
			  : "r" (1 << irq));
80002664:	00100793          	li	a5,1
80002668:	00a79533          	sll	a0,a5,a0
	__asm__ volatile ("csrrs %0, mie, %1\n"
8000266c:	30452573          	csrrs	a0,mie,a0
}
80002670:	00008067          	ret

80002674 <soc_interrupt_init>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002674:	00800793          	li	a5,8
80002678:	3007b7f3          	csrrc	a5,mstatus,a5
void soc_interrupt_init(void)
{
	/* ensure that all interrupts are disabled */
	(void)irq_lock();

	__asm__ volatile ("csrwi mie, 0\n"
8000267c:	30405073          	csrwi	mie,0
80002680:	34405073          	csrwi	mip,0
			  "csrwi mip, 0\n");
}
80002684:	00008067          	ret

80002688 <console_out>:
 *
 * @return The character passed as input.
 */

static int console_out(int c)
{
80002688:	ff010113          	addi	sp,sp,-16
8000268c:	00812423          	sw	s0,8(sp)
80002690:	00912223          	sw	s1,4(sp)
80002694:	80007437          	lui	s0,0x80007
80002698:	00112623          	sw	ra,12(sp)
		return c;
	}

#endif  /* CONFIG_UART_CONSOLE_DEBUG_SERVER_HOOKS */

	if ('\n' == c) {
8000269c:	00a00793          	li	a5,10
{
800026a0:	00050493          	mv	s1,a0
800026a4:	6b040413          	addi	s0,s0,1712 # 800076b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b1>
	if ('\n' == c) {
800026a8:	00f51c63          	bne	a0,a5,800026c0 <console_out+0x38>
800026ac:	00042503          	lw	a0,0(s0)
						unsigned char out_char)
{
	const struct uart_driver_api *api =
		(const struct uart_driver_api *)dev->driver_api;

	api->poll_out(dev, out_char);
800026b0:	00d00593          	li	a1,13
800026b4:	00452783          	lw	a5,4(a0)
800026b8:	0047a783          	lw	a5,4(a5) # 80000004 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000005>
800026bc:	000780e7          	jalr	a5
		uart_poll_out(uart_console_dev, '\r');
	}
	uart_poll_out(uart_console_dev, c);
800026c0:	00042503          	lw	a0,0(s0)
800026c4:	0ff4f593          	andi	a1,s1,255
800026c8:	00452783          	lw	a5,4(a0)
800026cc:	0047a783          	lw	a5,4(a5)
800026d0:	000780e7          	jalr	a5

	return c;
}
800026d4:	00c12083          	lw	ra,12(sp)
800026d8:	00812403          	lw	s0,8(sp)
800026dc:	00048513          	mv	a0,s1
800026e0:	00412483          	lw	s1,4(sp)
800026e4:	01010113          	addi	sp,sp,16
800026e8:	00008067          	ret

800026ec <uart_console_hook_install>:
 *
 * @return N/A
 */

void uart_console_hook_install(void)
{
800026ec:	ff010113          	addi	sp,sp,-16
800026f0:	00812423          	sw	s0,8(sp)
	__stdout_hook_install(console_out);
800026f4:	80002437          	lui	s0,0x80002
800026f8:	68840513          	addi	a0,s0,1672 # 80002688 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002689>
{
800026fc:	00112623          	sw	ra,12(sp)
	__stdout_hook_install(console_out);
80002700:	558000ef          	jal	ra,80002c58 <__stdout_hook_install>
	__printk_hook_install(console_out);
80002704:	68840513          	addi	a0,s0,1672
}
80002708:	00812403          	lw	s0,8(sp)
8000270c:	00c12083          	lw	ra,12(sp)
80002710:	01010113          	addi	sp,sp,16
	__printk_hook_install(console_out);
80002714:	a51ff06f          	j	80002164 <__printk_hook_install>

80002718 <uart_console_init>:

#ifdef __cplusplus
extern "C" {
#endif

K_SYSCALL_DECLARE1(K_SYSCALL_DEVICE_GET_BINDING, device_get_binding, struct device *, const char *, name)
80002718:	80007537          	lui	a0,0x80007
 * @brief Initialize one UART as the console/debug port
 *
 * @return 0 if successful, otherwise failed.
 */
static int uart_console_init(struct device *arg)
{
8000271c:	ff010113          	addi	sp,sp,-16
80002720:	f1850513          	addi	a0,a0,-232 # 80006f18 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f19>
80002724:	00112623          	sw	ra,12(sp)
80002728:	0d9000ef          	jal	ra,80003000 <z_impl_device_get_binding>

	ARG_UNUSED(arg);

	uart_console_dev = device_get_binding(CONFIG_UART_CONSOLE_ON_DEV_NAME);
8000272c:	800077b7          	lui	a5,0x80007
80002730:	6aa7a823          	sw	a0,1712(a5) # 800076b0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b1>
		}
	}
	k_busy_wait(1000000);
#endif

	uart_console_hook_install();
80002734:	fb9ff0ef          	jal	ra,800026ec <uart_console_hook_install>

	return 0;
}
80002738:	00c12083          	lw	ra,12(sp)
8000273c:	00000513          	li	a0,0
80002740:	01010113          	addi	sp,sp,16
80002744:	00008067          	ret

80002748 <mtime>:
	volatile u32_t *r = (u32_t *)RISCV_MTIME_BASE;
	u32_t lo, hi;

	/* Likewise, must guard against rollover when reading */
	do {
		hi = r[1];
80002748:	f01007b7          	lui	a5,0xf0100
8000274c:	f447a703          	lw	a4,-188(a5) # f00fff44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff45>
		lo = r[0];
80002750:	f407a503          	lw	a0,-192(a5)
	} while (r[1] != hi);
80002754:	f447a583          	lw	a1,-188(a5)
80002758:	fee59ae3          	bne	a1,a4,8000274c <mtime+0x4>

	return (((u64_t)hi) << 32) | lo;
}
8000275c:	00008067          	ret

80002760 <timer_isr>:

static void timer_isr(void *arg)
{
80002760:	fe010113          	addi	sp,sp,-32
80002764:	00812c23          	sw	s0,24(sp)
80002768:	00112e23          	sw	ra,28(sp)
8000276c:	00912a23          	sw	s1,20(sp)
80002770:	01212823          	sw	s2,16(sp)
80002774:	01312623          	sw	s3,12(sp)
80002778:	01412423          	sw	s4,8(sp)
8000277c:	01512223          	sw	s5,4(sp)
80002780:	00800413          	li	s0,8
80002784:	30043473          	csrrc	s0,mstatus,s0
	 * actually a wrapper for a global spinlock!
	 */
	k.key = z_arch_irq_lock();

#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002788:	80007937          	lui	s2,0x80007
8000278c:	6b490513          	addi	a0,s2,1716 # 800076b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80002790:	00847413          	andi	s0,s0,8
80002794:	6c8020ef          	jal	ra,80004e5c <z_spin_lock_valid>
80002798:	02051e63          	bnez	a0,800027d4 <timer_isr+0x74>
8000279c:	800074b7          	lui	s1,0x80007
800027a0:	800075b7          	lui	a1,0x80007
800027a4:	80007537          	lui	a0,0x80007
800027a8:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800027ac:	04e00693          	li	a3,78
800027b0:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800027b4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800027b8:	e2dff0ef          	jal	ra,800025e4 <printk>
800027bc:	80007537          	lui	a0,0x80007
800027c0:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800027c4:	e21ff0ef          	jal	ra,800025e4 <printk>
800027c8:	04e00593          	li	a1,78
800027cc:	f2c48513          	addi	a0,s1,-212
800027d0:	e51ff0ef          	jal	ra,80002620 <assert_post_action>
	while (!atomic_cas(&l->locked, 0, 1)) {
	}
#endif

#ifdef SPIN_VALIDATE
	z_spin_lock_set_owner(l);
800027d4:	6b490513          	addi	a0,s2,1716
	ARG_UNUSED(arg);

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800027d8:	800074b7          	lui	s1,0x80007
800027dc:	6d8020ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
800027e0:	69848493          	addi	s1,s1,1688 # 80007698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007699>
	u64_t now = mtime();
800027e4:	f65ff0ef          	jal	ra,80002748 <mtime>
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800027e8:	0004a983          	lw	s3,0(s1)
800027ec:	0044aa83          	lw	s5,4(s1)
	u64_t now = mtime();
800027f0:	00050793          	mv	a5,a0
	u32_t dticks = (u32_t)((now - last_count) / CYC_PER_TICK);
800027f4:	41350533          	sub	a0,a0,s3
800027f8:	00a7b7b3          	sltu	a5,a5,a0
800027fc:	415585b3          	sub	a1,a1,s5
80002800:	0001d637          	lui	a2,0x1d
80002804:	4c060613          	addi	a2,a2,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002808:	00000693          	li	a3,0
8000280c:	40f585b3          	sub	a1,a1,a5
80002810:	aa1fd0ef          	jal	ra,800002b0 <__udivdi3>
80002814:	00050a13          	mv	s4,a0

	last_count += dticks * CYC_PER_TICK;
80002818:	0001d5b7          	lui	a1,0x1d
8000281c:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002820:	000a0513          	mv	a0,s4
80002824:	860fe0ef          	jal	ra,80000884 <__mulsi3>
80002828:	013509b3          	add	s3,a0,s3
8000282c:	00a9b533          	sltu	a0,s3,a0
80002830:	01550533          	add	a0,a0,s5
80002834:	00a4a223          	sw	a0,4(s1)
static ALWAYS_INLINE void k_spin_unlock(struct k_spinlock *l,
					k_spinlock_key_t key)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002838:	6b490513          	addi	a0,s2,1716
8000283c:	0134a023          	sw	s3,0(s1)
80002840:	644020ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80002844:	02051e63          	bnez	a0,80002880 <timer_isr+0x120>
80002848:	800074b7          	lui	s1,0x80007
8000284c:	800075b7          	lui	a1,0x80007
80002850:	80007537          	lui	a0,0x80007
80002854:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80002858:	06100693          	li	a3,97
8000285c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002860:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80002864:	d81ff0ef          	jal	ra,800025e4 <printk>
80002868:	80007537          	lui	a0,0x80007
8000286c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80002870:	d75ff0ef          	jal	ra,800025e4 <printk>
80002874:	06100593          	li	a1,97
80002878:	f2c48513          	addi	a0,s1,-212
8000287c:	da5ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002880:	30042473          	csrrs	s0,mstatus,s0
		set_mtimecmp(next);
	}

	k_spin_unlock(&lock, key);
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
}
80002884:	01812403          	lw	s0,24(sp)
80002888:	01c12083          	lw	ra,28(sp)
8000288c:	01412483          	lw	s1,20(sp)
80002890:	01012903          	lw	s2,16(sp)
80002894:	00c12983          	lw	s3,12(sp)
80002898:	00412a83          	lw	s5,4(sp)
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
8000289c:	000a0513          	mv	a0,s4
}
800028a0:	00812a03          	lw	s4,8(sp)
800028a4:	02010113          	addi	sp,sp,32
	z_clock_announce(IS_ENABLED(CONFIG_TICKLESS_KERNEL) ? dticks : 1);
800028a8:	12c0306f          	j	800059d4 <z_clock_announce>

800028ac <z_clock_driver_init>:

int z_clock_driver_init(struct device *device)
{
800028ac:	ff010113          	addi	sp,sp,-16
800028b0:	00112623          	sw	ra,12(sp)
	IRQ_CONNECT(RISCV_MACHINE_TIMER_IRQ, 0, timer_isr, NULL, 0);
	set_mtimecmp(mtime() + CYC_PER_TICK);
800028b4:	e95ff0ef          	jal	ra,80002748 <mtime>
800028b8:	0001d7b7          	lui	a5,0x1d
800028bc:	4c078793          	addi	a5,a5,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
	r[1] = 0xffffffff;
800028c0:	f0100737          	lui	a4,0xf0100
	set_mtimecmp(mtime() + CYC_PER_TICK);
800028c4:	00f507b3          	add	a5,a0,a5
	r[1] = 0xffffffff;
800028c8:	fff00693          	li	a3,-1
800028cc:	f4d72623          	sw	a3,-180(a4) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(mtime() + CYC_PER_TICK);
800028d0:	00a7b533          	sltu	a0,a5,a0
800028d4:	00b50533          	add	a0,a0,a1
	r[0] = (u32_t)time;
800028d8:	f4f72423          	sw	a5,-184(a4)
	r[1] = (u32_t)(time >> 32);
800028dc:	f4a72623          	sw	a0,-180(a4)
	irq_enable(RISCV_MACHINE_TIMER_IRQ);
800028e0:	00700513          	li	a0,7
800028e4:	d81ff0ef          	jal	ra,80002664 <z_arch_irq_enable>
	return 0;
}
800028e8:	00c12083          	lw	ra,12(sp)
800028ec:	00000513          	li	a0,0
800028f0:	01010113          	addi	sp,sp,16
800028f4:	00008067          	ret

800028f8 <z_clock_set_timeout>:
	 * logic below to reset the comparator, we'll always bump it
	 * forward to the "next tick" due to MIN_DELAY handling and
	 * the interrupt will never fire!  Just rely on the fact that
	 * the OS gave us the proper timeout already.
	 */
	if (idle) {
800028f8:	1a059263          	bnez	a1,80002a9c <z_clock_set_timeout+0x1a4>
{
800028fc:	fe010113          	addi	sp,sp,-32
80002900:	00112e23          	sw	ra,28(sp)
80002904:	00812c23          	sw	s0,24(sp)
80002908:	00912a23          	sw	s1,20(sp)
8000290c:	01212823          	sw	s2,16(sp)
80002910:	01312623          	sw	s3,12(sp)
80002914:	01412423          	sw	s4,8(sp)
80002918:	01512223          	sw	s5,4(sp)
8000291c:	01612023          	sw	s6,0(sp)
		return;
	}

	ticks = ticks == K_FOREVER ? MAX_TICKS : ticks;
80002920:	fff00793          	li	a5,-1
80002924:	00f51663          	bne	a0,a5,80002930 <z_clock_set_timeout+0x38>
80002928:	00009537          	lui	a0,0x9
8000292c:	bce50513          	addi	a0,a0,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
	ticks = MAX(MIN(ticks - 1, (s32_t)MAX_TICKS), 0);
80002930:	000097b7          	lui	a5,0x9
80002934:	fff50413          	addi	s0,a0,-1
80002938:	bce78793          	addi	a5,a5,-1074 # 8bce <CONFIG_ISR_STACK_SIZE+0x83ce>
8000293c:	1487da63          	bge	a5,s0,80002a90 <z_clock_set_timeout+0x198>
80002940:	00078413          	mv	s0,a5
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002944:	00800913          	li	s2,8
80002948:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000294c:	80007ab7          	lui	s5,0x80007
80002950:	6b4a8513          	addi	a0,s5,1716 # 800076b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80002954:	00897913          	andi	s2,s2,8
80002958:	504020ef          	jal	ra,80004e5c <z_spin_lock_valid>
8000295c:	02051e63          	bnez	a0,80002998 <z_clock_set_timeout+0xa0>
80002960:	800074b7          	lui	s1,0x80007
80002964:	800075b7          	lui	a1,0x80007
80002968:	80007537          	lui	a0,0x80007
8000296c:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80002970:	04e00693          	li	a3,78
80002974:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002978:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
8000297c:	c69ff0ef          	jal	ra,800025e4 <printk>
80002980:	80007537          	lui	a0,0x80007
80002984:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80002988:	c5dff0ef          	jal	ra,800025e4 <printk>
8000298c:	04e00593          	li	a1,78
80002990:	f2c48513          	addi	a0,s1,-212
80002994:	c8dff0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80002998:	6b4a8513          	addi	a0,s5,1716
8000299c:	518020ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u64_t now = mtime();
800029a0:	da9ff0ef          	jal	ra,80002748 <mtime>
	u32_t cyc = ticks * CYC_PER_TICK;

	/* Round up to next tick boundary.  Note use of 32 bit math,
	 * max_ticks is calibrated to permit this.
	 */
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800029a4:	800077b7          	lui	a5,0x80007
800029a8:	69878793          	addi	a5,a5,1688 # 80007698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007699>
	u32_t cyc = ticks * CYC_PER_TICK;
800029ac:	0001d4b7          	lui	s1,0x1d
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800029b0:	0007a983          	lw	s3,0(a5)
	u64_t now = mtime();
800029b4:	00050a13          	mv	s4,a0
	u32_t cyc = ticks * CYC_PER_TICK;
800029b8:	4c048593          	addi	a1,s1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
800029bc:	00040513          	mv	a0,s0
	cyc += (u32_t)(now - last_count) + (CYC_PER_TICK - 1);
800029c0:	0047ab03          	lw	s6,4(a5)
	u32_t cyc = ticks * CYC_PER_TICK;
800029c4:	ec1fd0ef          	jal	ra,80000884 <__mulsi3>
800029c8:	4bf48793          	addi	a5,s1,1215
800029cc:	413787b3          	sub	a5,a5,s3
800029d0:	00f50533          	add	a0,a0,a5
	cyc = (cyc / CYC_PER_TICK) * CYC_PER_TICK;
800029d4:	4c048593          	addi	a1,s1,1216
800029d8:	00aa0533          	add	a0,s4,a0
800029dc:	f65fd0ef          	jal	ra,80000940 <__udivsi3>
800029e0:	4c048593          	addi	a1,s1,1216
800029e4:	ea1fd0ef          	jal	ra,80000884 <__mulsi3>

	if ((s32_t)(cyc + last_count - now) < MIN_DELAY) {
800029e8:	41498a33          	sub	s4,s3,s4
800029ec:	00aa0a33          	add	s4,s4,a0
800029f0:	3e700793          	li	a5,999
800029f4:	0147c663          	blt	a5,s4,80002a00 <z_clock_set_timeout+0x108>
		cyc += CYC_PER_TICK;
800029f8:	4c048493          	addi	s1,s1,1216
800029fc:	00950533          	add	a0,a0,s1
	r[1] = 0xffffffff;
80002a00:	f01007b7          	lui	a5,0xf0100
	}

	set_mtimecmp(cyc + last_count);
80002a04:	013509b3          	add	s3,a0,s3
	r[1] = 0xffffffff;
80002a08:	fff00713          	li	a4,-1
80002a0c:	f4e7a623          	sw	a4,-180(a5) # f00fff4c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf00fff4d>
	set_mtimecmp(cyc + last_count);
80002a10:	00a9b533          	sltu	a0,s3,a0
80002a14:	01650533          	add	a0,a0,s6
	r[0] = (u32_t)time;
80002a18:	f537a423          	sw	s3,-184(a5)
	r[1] = (u32_t)(time >> 32);
80002a1c:	f4a7a623          	sw	a0,-180(a5)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002a20:	6b4a8513          	addi	a0,s5,1716
80002a24:	460020ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80002a28:	02051e63          	bnez	a0,80002a64 <z_clock_set_timeout+0x16c>
80002a2c:	80007437          	lui	s0,0x80007
80002a30:	800075b7          	lui	a1,0x80007
80002a34:	80007537          	lui	a0,0x80007
80002a38:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80002a3c:	06100693          	li	a3,97
80002a40:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002a44:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80002a48:	b9dff0ef          	jal	ra,800025e4 <printk>
80002a4c:	80007537          	lui	a0,0x80007
80002a50:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80002a54:	b91ff0ef          	jal	ra,800025e4 <printk>
80002a58:	06100593          	li	a1,97
80002a5c:	f2c40513          	addi	a0,s0,-212
80002a60:	bc1ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002a64:	30092973          	csrrs	s2,mstatus,s2
	k_spin_unlock(&lock, key);
#endif
}
80002a68:	01c12083          	lw	ra,28(sp)
80002a6c:	01812403          	lw	s0,24(sp)
80002a70:	01412483          	lw	s1,20(sp)
80002a74:	01012903          	lw	s2,16(sp)
80002a78:	00c12983          	lw	s3,12(sp)
80002a7c:	00812a03          	lw	s4,8(sp)
80002a80:	00412a83          	lw	s5,4(sp)
80002a84:	00012b03          	lw	s6,0(sp)
80002a88:	02010113          	addi	sp,sp,32
80002a8c:	00008067          	ret
80002a90:	ea045ae3          	bgez	s0,80002944 <z_clock_set_timeout+0x4c>
80002a94:	00000413          	li	s0,0
80002a98:	eadff06f          	j	80002944 <z_clock_set_timeout+0x4c>
80002a9c:	00008067          	ret

80002aa0 <z_clock_elapsed>:

u32_t z_clock_elapsed(void)
{
80002aa0:	ff010113          	addi	sp,sp,-16
80002aa4:	00812423          	sw	s0,8(sp)
80002aa8:	00112623          	sw	ra,12(sp)
80002aac:	00912223          	sw	s1,4(sp)
80002ab0:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80002ab4:	00800413          	li	s0,8
80002ab8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80002abc:	800074b7          	lui	s1,0x80007
80002ac0:	6b448513          	addi	a0,s1,1716 # 800076b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b5>
	key = (mstatus & SOC_MSTATUS_IEN);
80002ac4:	00847413          	andi	s0,s0,8
80002ac8:	394020ef          	jal	ra,80004e5c <z_spin_lock_valid>
80002acc:	02051e63          	bnez	a0,80002b08 <z_clock_elapsed+0x68>
80002ad0:	80007937          	lui	s2,0x80007
80002ad4:	800075b7          	lui	a1,0x80007
80002ad8:	80007537          	lui	a0,0x80007
80002adc:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80002ae0:	04e00693          	li	a3,78
80002ae4:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002ae8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80002aec:	af9ff0ef          	jal	ra,800025e4 <printk>
80002af0:	80007537          	lui	a0,0x80007
80002af4:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80002af8:	aedff0ef          	jal	ra,800025e4 <printk>
80002afc:	04e00593          	li	a1,78
80002b00:	f2c90513          	addi	a0,s2,-212
80002b04:	b1dff0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80002b08:	6b448513          	addi	a0,s1,1716
80002b0c:	3a8020ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	if (!IS_ENABLED(CONFIG_TICKLESS_KERNEL)) {
		return 0;
	}

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t ret = ((u32_t)mtime() - (u32_t)last_count) / CYC_PER_TICK;
80002b10:	c39ff0ef          	jal	ra,80002748 <mtime>
80002b14:	800077b7          	lui	a5,0x80007
80002b18:	6987a783          	lw	a5,1688(a5) # 80007698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007699>
80002b1c:	0001d5b7          	lui	a1,0x1d
80002b20:	4c058593          	addi	a1,a1,1216 # 1d4c0 <CONFIG_ISR_STACK_SIZE+0x1ccc0>
80002b24:	40f50533          	sub	a0,a0,a5
80002b28:	e19fd0ef          	jal	ra,80000940 <__udivsi3>
80002b2c:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80002b30:	6b448513          	addi	a0,s1,1716
80002b34:	350020ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80002b38:	02051e63          	bnez	a0,80002b74 <z_clock_elapsed+0xd4>
80002b3c:	800074b7          	lui	s1,0x80007
80002b40:	800075b7          	lui	a1,0x80007
80002b44:	80007537          	lui	a0,0x80007
80002b48:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80002b4c:	06100693          	li	a3,97
80002b50:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80002b54:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80002b58:	a8dff0ef          	jal	ra,800025e4 <printk>
80002b5c:	80007537          	lui	a0,0x80007
80002b60:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80002b64:	a81ff0ef          	jal	ra,800025e4 <printk>
80002b68:	06100593          	li	a1,97
80002b6c:	f2c48513          	addi	a0,s1,-212
80002b70:	ab1ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80002b74:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&lock, key);
	return ret;
}
80002b78:	00c12083          	lw	ra,12(sp)
80002b7c:	00812403          	lw	s0,8(sp)
80002b80:	00090513          	mv	a0,s2
80002b84:	00412483          	lw	s1,4(sp)
80002b88:	00012903          	lw	s2,0(sp)
80002b8c:	01010113          	addi	sp,sp,16
80002b90:	00008067          	ret

80002b94 <z_timer_cycle_get_32>:

u32_t z_timer_cycle_get_32(void)
{
80002b94:	ff010113          	addi	sp,sp,-16
80002b98:	00112623          	sw	ra,12(sp)
	return (u32_t)mtime();
80002b9c:	badff0ef          	jal	ra,80002748 <mtime>
}
80002ba0:	00c12083          	lw	ra,12(sp)
80002ba4:	01010113          	addi	sp,sp,16
80002ba8:	00008067          	ret

80002bac <strcmp>:
 * @return negative # if <s1> < <s2>, 0 if <s1> == <s2>, else positive #
 */

int strcmp(const char *s1, const char *s2)
{
	while ((*s1 == *s2) && (*s1 != '\0')) {
80002bac:	00054783          	lbu	a5,0(a0)
80002bb0:	0005c703          	lbu	a4,0(a1)
80002bb4:	00e79463          	bne	a5,a4,80002bbc <strcmp+0x10>
80002bb8:	00079663          	bnez	a5,80002bc4 <strcmp+0x18>
		s1++;
		s2++;
	}

	return *s1 - *s2;
}
80002bbc:	40e78533          	sub	a0,a5,a4
80002bc0:	00008067          	ret
		s1++;
80002bc4:	00150513          	addi	a0,a0,1
		s2++;
80002bc8:	00158593          	addi	a1,a1,1
80002bcc:	fe1ff06f          	j	80002bac <strcmp>

80002bd0 <memset>:
void *memset(void *buf, int c, size_t n)
{
	/* do byte-sized initialization until word-aligned or finished */

	unsigned char *d_byte = (unsigned char *)buf;
	unsigned char c_byte = (unsigned char)c;
80002bd0:	0ff5f693          	andi	a3,a1,255
	unsigned char *d_byte = (unsigned char *)buf;
80002bd4:	00050793          	mv	a5,a0

	while (((unsigned int)d_byte) & 0x3) {
80002bd8:	0037f713          	andi	a4,a5,3
80002bdc:	04071463          	bnez	a4,80002c24 <memset+0x54>
	};

	/* do word-sized initialization as long as possible */

	unsigned int *d_word = (unsigned int *)d_byte;
	unsigned int c_word = (unsigned int)(unsigned char)c;
80002be0:	0ff5f593          	andi	a1,a1,255

	c_word |= c_word << 8;
80002be4:	00859713          	slli	a4,a1,0x8
80002be8:	00b765b3          	or	a1,a4,a1
	c_word |= c_word << 16;
80002bec:	01059713          	slli	a4,a1,0x10
80002bf0:	00b765b3          	or	a1,a4,a1

	while (n >= sizeof(unsigned int)) {
80002bf4:	00c78333          	add	t1,a5,a2
80002bf8:	00078713          	mv	a4,a5
80002bfc:	00300813          	li	a6,3
80002c00:	40e308b3          	sub	a7,t1,a4
80002c04:	03186a63          	bltu	a6,a7,80002c38 <memset+0x68>
80002c08:	00265713          	srli	a4,a2,0x2
80002c0c:	00271593          	slli	a1,a4,0x2
80002c10:	00b787b3          	add	a5,a5,a1
80002c14:	40b60633          	sub	a2,a2,a1
80002c18:	00c78633          	add	a2,a5,a2

	/* do byte-sized initialization until finished */

	d_byte = (unsigned char *)d_word;

	while (n > 0) {
80002c1c:	02c79463          	bne	a5,a2,80002c44 <memset+0x74>
		*(d_byte++) = c_byte;
		n--;
	}

	return buf;
}
80002c20:	00008067          	ret
		if (n == 0) {
80002c24:	fe060ee3          	beqz	a2,80002c20 <memset+0x50>
		*(d_byte++) = c_byte;
80002c28:	00178793          	addi	a5,a5,1
80002c2c:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002c30:	fff60613          	addi	a2,a2,-1
80002c34:	fa5ff06f          	j	80002bd8 <memset+0x8>
		*(d_word++) = c_word;
80002c38:	00470713          	addi	a4,a4,4
80002c3c:	feb72e23          	sw	a1,-4(a4)
		n -= sizeof(unsigned int);
80002c40:	fc1ff06f          	j	80002c00 <memset+0x30>
		*(d_byte++) = c_byte;
80002c44:	00178793          	addi	a5,a5,1
80002c48:	fed78fa3          	sb	a3,-1(a5)
		n--;
80002c4c:	fd1ff06f          	j	80002c1c <memset+0x4c>

80002c50 <_stdout_hook_default>:
static int _stdout_hook_default(int c)
{
	(void)(c);  /* Prevent warning about unused argument */

	return EOF;
}
80002c50:	fff00513          	li	a0,-1
80002c54:	00008067          	ret

80002c58 <__stdout_hook_install>:

static int (*_stdout_hook)(int) = _stdout_hook_default;

void __stdout_hook_install(int (*hook)(int))
{
	_stdout_hook = hook;
80002c58:	800077b7          	lui	a5,0x80007
80002c5c:	52a7a823          	sw	a0,1328(a5) # 80007530 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007531>
}
80002c60:	00008067          	ret

80002c64 <test_cb>:
	k_sem_init(&test_end_signal, 0, 1);
	k_object_access_all_grant(&test_end_signal);
}

static void test_cb(void *a, void *dummy2, void *dummy)
{
80002c64:	fe010113          	addi	sp,sp,-32
80002c68:	00812c23          	sw	s0,24(sp)
	test->setup();
80002c6c:	00852783          	lw	a5,8(a0)
	phase = TEST_PHASE_SETUP;
80002c70:	80007437          	lui	s0,0x80007
{
80002c74:	00912a23          	sw	s1,20(sp)
	phase = TEST_PHASE_SETUP;
80002c78:	53440413          	addi	s0,s0,1332 # 80007534 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007535>
	struct unit_test *test = (struct unit_test *)a;

	ARG_UNUSED(dummy2);
	ARG_UNUSED(dummy);

	test_result = 1;
80002c7c:	800074b7          	lui	s1,0x80007
{
80002c80:	00112e23          	sw	ra,28(sp)
80002c84:	01212823          	sw	s2,16(sp)
80002c88:	01312623          	sw	s3,12(sp)
	test_result = 1;
80002c8c:	6b848493          	addi	s1,s1,1720 # 800076b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b9>
80002c90:	00100993          	li	s3,1
	phase = TEST_PHASE_SETUP;
80002c94:	00042023          	sw	zero,0(s0)
{
80002c98:	00050913          	mv	s2,a0
	test_result = 1;
80002c9c:	0134a023          	sw	s3,0(s1)
	test->setup();
80002ca0:	000780e7          	jalr	a5
	test->test();
80002ca4:	00492783          	lw	a5,4(s2)
	phase = TEST_PHASE_TEST;
80002ca8:	01342023          	sw	s3,0(s0)
	test->test();
80002cac:	000780e7          	jalr	a5
	phase = TEST_PHASE_TEARDOWN;
80002cb0:	00200793          	li	a5,2
80002cb4:	00f42023          	sw	a5,0(s0)
	test->teardown();
80002cb8:	00c92783          	lw	a5,12(s2)
80002cbc:	000780e7          	jalr	a5
	phase = TEST_PHASE_FRAMEWORK;
80002cc0:	00300793          	li	a5,3
80002cc4:	00f42023          	sw	a5,0(s0)
	run_test_functions(test);
	test_result = 0;

	k_sem_give(&test_end_signal);
}
80002cc8:	01812403          	lw	s0,24(sp)
	test_result = 0;
80002ccc:	0004a023          	sw	zero,0(s1)
}
80002cd0:	01c12083          	lw	ra,28(sp)
80002cd4:	01412483          	lw	s1,20(sp)
80002cd8:	01012903          	lw	s2,16(sp)
80002cdc:	00c12983          	lw	s3,12(sp)

K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)

K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)

K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_SEM_GIVE, k_sem_give, struct k_sem *, sem)
80002ce0:	80007537          	lui	a0,0x80007
80002ce4:	76450513          	addi	a0,a0,1892 # 80007764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007765>
80002ce8:	02010113          	addi	sp,sp,32
80002cec:	5550106f          	j	80004a40 <z_impl_k_sem_give>

80002cf0 <ztest_test_fail>:
80002cf0:	80007537          	lui	a0,0x80007
{
80002cf4:	ff010113          	addi	sp,sp,-16
	test_result = -1;
80002cf8:	800077b7          	lui	a5,0x80007
80002cfc:	fff00713          	li	a4,-1
80002d00:	76450513          	addi	a0,a0,1892 # 80007764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007765>
{
80002d04:	00112623          	sw	ra,12(sp)
	test_result = -1;
80002d08:	6ae7ac23          	sw	a4,1720(a5) # 800076b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b9>
80002d0c:	535010ef          	jal	ra,80004a40 <z_impl_k_sem_give>
K_SYSCALL_DECLARE0(K_SYSCALL_K_CURRENT_GET, k_current_get, k_tid_t)
80002d10:	45d010ef          	jal	ra,8000496c <z_impl_k_current_get>
}
80002d14:	00c12083          	lw	ra,12(sp)
80002d18:	01010113          	addi	sp,sp,16
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002d1c:	4c80206f          	j	800051e4 <z_impl_k_thread_abort>

80002d20 <z_ztest_run_test_suite>:
}

#endif /* !KERNEL */

void z_ztest_run_test_suite(const char *name, struct unit_test *suite)
{
80002d20:	fa010113          	addi	sp,sp,-96
80002d24:	04912a23          	sw	s1,84(sp)
	int fail = 0;

	if (test_status < 0) {
80002d28:	800074b7          	lui	s1,0x80007
80002d2c:	6bc4a783          	lw	a5,1724(s1) # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
{
80002d30:	04112e23          	sw	ra,92(sp)
80002d34:	04812c23          	sw	s0,88(sp)
80002d38:	05212823          	sw	s2,80(sp)
80002d3c:	05312623          	sw	s3,76(sp)
80002d40:	05412423          	sw	s4,72(sp)
80002d44:	05512223          	sw	s5,68(sp)
80002d48:	05612023          	sw	s6,64(sp)
80002d4c:	03712e23          	sw	s7,60(sp)
80002d50:	03812c23          	sw	s8,56(sp)
80002d54:	03912a23          	sw	s9,52(sp)
80002d58:	03a12823          	sw	s10,48(sp)
80002d5c:	03b12623          	sw	s11,44(sp)
	if (test_status < 0) {
80002d60:	0807c463          	bltz	a5,80002de8 <z_ztest_run_test_suite+0xc8>
K_SYSCALL_DECLARE3_VOID(K_SYSCALL_K_SEM_INIT, k_sem_init, struct k_sem *, sem, unsigned int, initial_count, unsigned int, limit)
80002d64:	80007437          	lui	s0,0x80007
80002d68:	00100613          	li	a2,1
80002d6c:	00050993          	mv	s3,a0
80002d70:	00058c13          	mv	s8,a1
80002d74:	76440513          	addi	a0,s0,1892 # 80007764 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007765>
80002d78:	00000593          	li	a1,0
80002d7c:	3fd010ef          	jal	ra,80004978 <z_impl_k_sem_init>
		return;
	}

	init_testing();

	PRINT("Running test suite %s\n", name);
80002d80:	80007537          	lui	a0,0x80007
80002d84:	00098593          	mv	a1,s3
80002d88:	fe850513          	addi	a0,a0,-24 # 80006fe8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fe9>
80002d8c:	859ff0ef          	jal	ra,800025e4 <printk>
	PRINT_LINE;
80002d90:	80007937          	lui	s2,0x80007
80002d94:	00090513          	mv	a0,s2
		Z_TC_END_RESULT(ret, test->name);
80002d98:	80007ab7          	lui	s5,0x80007
	PRINT_LINE;
80002d9c:	849ff0ef          	jal	ra,800025e4 <printk>
80002da0:	6bc48493          	addi	s1,s1,1724
	int fail = 0;
80002da4:	00000a13          	li	s4,0
80002da8:	00812e23          	sw	s0,28(sp)
K_SYSCALL_DECLARE10(K_SYSCALL_K_THREAD_CREATE, k_thread_create, k_tid_t, struct k_thread *, new_thread, k_thread_stack_t *, stack, size_t, stack_size, k_thread_entry_t, entry, void *, p1, void *, p2, void *, p3, int, prio, u32_t, options, s32_t, delay)
80002dac:	80008cb7          	lui	s9,0x80008
80002db0:	80007b37          	lui	s6,0x80007
80002db4:	80003d37          	lui	s10,0x80003
	if (test_result == -1) {
80002db8:	80007db7          	lui	s11,0x80007
80002dbc:	80007bb7          	lui	s7,0x80007
		Z_TC_END_RESULT(ret, test->name);
80002dc0:	fa0a8a93          	addi	s5,s5,-96 # 80006fa0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fa1>
	while (suite->test) {
80002dc4:	004c2783          	lw	a5,4(s8)
80002dc8:	04079e63          	bnez	a5,80002e24 <z_ztest_run_test_suite+0x104>
		if (fail && FAIL_FAST) {
			break;
		}
	}
	if (fail) {
		TC_PRINT("Test suite %s failed.\n", name);
80002dcc:	00098593          	mv	a1,s3
	if (fail) {
80002dd0:	100a0663          	beqz	s4,80002edc <z_ztest_run_test_suite+0x1bc>
		TC_PRINT("Test suite %s failed.\n", name);
80002dd4:	80007537          	lui	a0,0x80007
80002dd8:	07050513          	addi	a0,a0,112 # 80007070 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007071>
80002ddc:	809ff0ef          	jal	ra,800025e4 <printk>
	} else {
		TC_PRINT("Test suite %s succeeded\n", name);
	}

	test_status = (test_status || fail) ? 1 : 0;
80002de0:	00100793          	li	a5,1
80002de4:	00f4a023          	sw	a5,0(s1)
}
80002de8:	05c12083          	lw	ra,92(sp)
80002dec:	05812403          	lw	s0,88(sp)
80002df0:	05412483          	lw	s1,84(sp)
80002df4:	05012903          	lw	s2,80(sp)
80002df8:	04c12983          	lw	s3,76(sp)
80002dfc:	04812a03          	lw	s4,72(sp)
80002e00:	04412a83          	lw	s5,68(sp)
80002e04:	04012b03          	lw	s6,64(sp)
80002e08:	03c12b83          	lw	s7,60(sp)
80002e0c:	03812c03          	lw	s8,56(sp)
80002e10:	03412c83          	lw	s9,52(sp)
80002e14:	03012d03          	lw	s10,48(sp)
80002e18:	02c12d83          	lw	s11,44(sp)
80002e1c:	06010113          	addi	sp,sp,96
80002e20:	00008067          	ret
	TC_START(test->name);
80002e24:	000c2583          	lw	a1,0(s8)
80002e28:	800077b7          	lui	a5,0x80007
80002e2c:	04878513          	addi	a0,a5,72 # 80007048 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007049>
80002e30:	fb4ff0ef          	jal	ra,800025e4 <printk>
80002e34:	00012223          	sw	zero,4(sp)
			test->thread_options | K_INHERIT_PERMS,	0);
80002e38:	010c2783          	lw	a5,16(s8)
80002e3c:	000c0713          	mv	a4,s8
80002e40:	40000613          	li	a2,1024
80002e44:	0087e793          	ori	a5,a5,8
80002e48:	fff00893          	li	a7,-1
80002e4c:	00000813          	li	a6,0
80002e50:	c64d0693          	addi	a3,s10,-924 # 80002c64 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80002c65>
80002e54:	00f12023          	sw	a5,0(sp)
80002e58:	8f0c8593          	addi	a1,s9,-1808 # 800078f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f1>
80002e5c:	00000793          	li	a5,0
80002e60:	774b0513          	addi	a0,s6,1908 # 80007774 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007775>
80002e64:	1dc020ef          	jal	ra,80005040 <z_impl_k_thread_create>
K_SYSCALL_DECLARE2(K_SYSCALL_K_SEM_TAKE, k_sem_take, int, struct k_sem *, sem, s32_t, timeout)
80002e68:	01c12783          	lw	a5,28(sp)
80002e6c:	fff00593          	li	a1,-1
80002e70:	76478513          	addi	a0,a5,1892
80002e74:	4b1010ef          	jal	ra,80004b24 <z_impl_k_sem_take>
	if (test_result == -1) {
80002e78:	6b8d8793          	addi	a5,s11,1720 # 800076b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b9>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_ABORT, k_thread_abort, k_tid_t, thread)
80002e7c:	774b0513          	addi	a0,s6,1908
80002e80:	0007a403          	lw	s0,0(a5)
80002e84:	360020ef          	jal	ra,800051e4 <z_impl_k_thread_abort>
	if (test_result == -2) {
80002e88:	800077b7          	lui	a5,0x80007
80002e8c:	6b878793          	addi	a5,a5,1720 # 800076b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076b9>
80002e90:	0007a703          	lw	a4,0(a5)
	if (test_result == -1) {
80002e94:	00140413          	addi	s0,s0,1
	if (test_result == -2) {
80002e98:	ffe00793          	li	a5,-2
	if (test_result == -1) {
80002e9c:	00143413          	seqz	s0,s0
	if (test_result == -2) {
80002ea0:	000c2603          	lw	a2,0(s8)
80002ea4:	02f71463          	bne	a4,a5,80002ecc <z_ztest_run_test_suite+0x1ac>
		Z_TC_END_RESULT(TC_SKIP, test->name);
80002ea8:	800075b7          	lui	a1,0x80007
80002eac:	05c58593          	addi	a1,a1,92 # 8000705c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000705d>
		Z_TC_END_RESULT(ret, test->name);
80002eb0:	064b8513          	addi	a0,s7,100 # 80007064 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007065>
80002eb4:	f30ff0ef          	jal	ra,800025e4 <printk>
80002eb8:	00090513          	mv	a0,s2
80002ebc:	f28ff0ef          	jal	ra,800025e4 <printk>
		fail += run_test(suite);
80002ec0:	008a0a33          	add	s4,s4,s0
		suite++;
80002ec4:	014c0c13          	addi	s8,s8,20
		if (fail && FAIL_FAST) {
80002ec8:	efdff06f          	j	80002dc4 <z_ztest_run_test_suite+0xa4>
		Z_TC_END_RESULT(ret, test->name);
80002ecc:	00241793          	slli	a5,s0,0x2
80002ed0:	00fa87b3          	add	a5,s5,a5
80002ed4:	0007a583          	lw	a1,0(a5)
80002ed8:	fd9ff06f          	j	80002eb0 <z_ztest_run_test_suite+0x190>
		TC_PRINT("Test suite %s succeeded\n", name);
80002edc:	80007537          	lui	a0,0x80007
80002ee0:	08850513          	addi	a0,a0,136 # 80007088 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007089>
80002ee4:	f00ff0ef          	jal	ra,800025e4 <printk>
	test_status = (test_status || fail) ? 1 : 0;
80002ee8:	0004a783          	lw	a5,0(s1)
80002eec:	00f037b3          	snez	a5,a5
80002ef0:	ef5ff06f          	j	80002de4 <z_ztest_run_test_suite+0xc4>

80002ef4 <end_report>:

void end_report(void)
{
	if (test_status) {
80002ef4:	800077b7          	lui	a5,0x80007
80002ef8:	6bc7a783          	lw	a5,1724(a5) # 800076bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076bd>
{
80002efc:	ff010113          	addi	sp,sp,-16
80002f00:	00812423          	sw	s0,8(sp)
80002f04:	80007537          	lui	a0,0x80007
80002f08:	00112623          	sw	ra,12(sp)
80002f0c:	80007437          	lui	s0,0x80007
		TC_END_REPORT(TC_FAIL);
80002f10:	00050513          	mv	a0,a0
	if (test_status) {
80002f14:	02078263          	beqz	a5,80002f38 <end_report+0x44>
		TC_END_REPORT(TC_FAIL);
80002f18:	eccff0ef          	jal	ra,800025e4 <printk>
80002f1c:	800075b7          	lui	a1,0x80007
80002f20:	fac58593          	addi	a1,a1,-84 # 80006fac <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fad>
	} else {
		TC_END_REPORT(TC_PASS);
80002f24:	fb440513          	addi	a0,s0,-76 # 80006fb4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fb5>
	}
}
80002f28:	00812403          	lw	s0,8(sp)
80002f2c:	00c12083          	lw	ra,12(sp)
80002f30:	01010113          	addi	sp,sp,16
		TC_END_REPORT(TC_PASS);
80002f34:	eb0ff06f          	j	800025e4 <printk>
80002f38:	eacff0ef          	jal	ra,800025e4 <printk>
80002f3c:	800075b7          	lui	a1,0x80007
80002f40:	fcc58593          	addi	a1,a1,-52 # 80006fcc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006fcd>
80002f44:	fe1ff06f          	j	80002f24 <end_report+0x30>

80002f48 <main>:

	return test_status;
}
#else
void main(void)
{
80002f48:	ff010113          	addi	sp,sp,-16
80002f4c:	00112623          	sw	ra,12(sp)
	k_mem_domain_init(&ztest_mem_domain, ARRAY_SIZE(parts), parts);
	k_mem_domain_add_thread(&ztest_mem_domain, k_current_get());
#endif /* CONFIG_USERSPACE */

	z_init_mock();
	test_main();
80002f50:	ab1fe0ef          	jal	ra,80001a00 <test_main>
	end_report();
}
80002f54:	00c12083          	lw	ra,12(sp)
80002f58:	01010113          	addi	sp,sp,16
	end_report();
80002f5c:	f99ff06f          	j	80002ef4 <end_report>

80002f60 <uart_vexriscv_sim_poll_out>:



static void uart_vexriscv_sim_poll_out(struct device *dev,
				       unsigned char c)
{
80002f60:	ff010113          	addi	sp,sp,-16
	volatile int *uart = (int*)0xF0010000;
    volatile int i = 0;
80002f64:	00012623          	sw	zero,12(sp)
    i++;
80002f68:	00c12783          	lw	a5,12(sp)
80002f6c:	00178793          	addi	a5,a5,1
80002f70:	00f12623          	sw	a5,12(sp)
    uart[0] = c;
80002f74:	f00107b7          	lui	a5,0xf0010
80002f78:	00b7a023          	sw	a1,0(a5) # f0010000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0xf0010001>
}
80002f7c:	01010113          	addi	sp,sp,16
80002f80:	00008067          	ret

80002f84 <uart_vexriscv_sim_poll_in>:

static int uart_vexriscv_sim_poll_in(struct device *dev, unsigned char *c)
{
	return -1;
}
80002f84:	fff00513          	li	a0,-1
80002f88:	00008067          	ret

80002f8c <uart_vexriscv_sim_init>:
static int uart_vexriscv_sim_init(struct device *dev)
{
	/* Nothing to do */

	return 0;
}
80002f8c:	00000513          	li	a0,0
80002f90:	00008067          	ret

80002f94 <z_sys_device_do_config_level>:
		__device_APPLICATION_start,
		/* End marker */
		__device_init_end,
	};

	for (info = config_levels[level]; info < config_levels[level+1];
80002f94:	00251713          	slli	a4,a0,0x2
80002f98:	800077b7          	lui	a5,0x80007
80002f9c:	00150513          	addi	a0,a0,1 # 80007001 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007002>
80002fa0:	0b878793          	addi	a5,a5,184 # 800070b8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070b9>
80002fa4:	00251513          	slli	a0,a0,0x2
{
80002fa8:	ff010113          	addi	sp,sp,-16
	for (info = config_levels[level]; info < config_levels[level+1];
80002fac:	00e78733          	add	a4,a5,a4
80002fb0:	00a787b3          	add	a5,a5,a0
{
80002fb4:	00812423          	sw	s0,8(sp)
80002fb8:	00912223          	sw	s1,4(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002fbc:	00072403          	lw	s0,0(a4)
80002fc0:	0007a483          	lw	s1,0(a5)
{
80002fc4:	00112623          	sw	ra,12(sp)
	for (info = config_levels[level]; info < config_levels[level+1];
80002fc8:	00946c63          	bltu	s0,s1,80002fe0 <z_sys_device_do_config_level+0x4c>
			info->driver_api = NULL;
		} else {
			z_object_init(info);
		}
	}
}
80002fcc:	00c12083          	lw	ra,12(sp)
80002fd0:	00812403          	lw	s0,8(sp)
80002fd4:	00412483          	lw	s1,4(sp)
80002fd8:	01010113          	addi	sp,sp,16
80002fdc:	00008067          	ret
		retval = device_conf->init(info);
80002fe0:	00042783          	lw	a5,0(s0)
80002fe4:	00040513          	mv	a0,s0
80002fe8:	0047a783          	lw	a5,4(a5)
80002fec:	000780e7          	jalr	a5
		if (retval != 0) {
80002ff0:	00050463          	beqz	a0,80002ff8 <z_sys_device_do_config_level+0x64>
			info->driver_api = NULL;
80002ff4:	00042223          	sw	zero,4(s0)
								info++) {
80002ff8:	00c40413          	addi	s0,s0,12
80002ffc:	fcdff06f          	j	80002fc8 <z_sys_device_do_config_level+0x34>

80003000 <z_impl_device_get_binding>:

struct device *z_impl_device_get_binding(const char *name)
{
80003000:	ff010113          	addi	sp,sp,-16
	/* Split the search into two loops: in the common scenario, where
	 * device names are stored in ROM (and are referenced by the user
	 * with CONFIG_* macros), only cheap pointer comparisons will be
	 * performed.  Reserve string comparisons for a fallback.
	 */
	for (info = __device_init_start; info != __device_init_end; info++) {
80003004:	800077b7          	lui	a5,0x80007
{
80003008:	00912223          	sw	s1,4(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
8000300c:	800074b7          	lui	s1,0x80007
{
80003010:	00812423          	sw	s0,8(sp)
80003014:	00112623          	sw	ra,12(sp)
	for (info = __device_init_start; info != __device_init_end; info++) {
80003018:	54878413          	addi	s0,a5,1352 # 80007548 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007549>
{
8000301c:	01212023          	sw	s2,0(sp)
80003020:	54878793          	addi	a5,a5,1352
80003024:	57848493          	addi	s1,s1,1400 # 80007578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007579>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003028:	00941c63          	bne	s0,s1,80003040 <z_impl_device_get_binding+0x40>
8000302c:	00050913          	mv	s2,a0
		    (info->config->name == name)) {
			return info;
		}
	}

	for (info = __device_init_start; info != __device_init_end; info++) {
80003030:	00078413          	mv	s0,a5
80003034:	02941463          	bne	s0,s1,8000305c <z_impl_device_get_binding+0x5c>
		if (strcmp(name, info->config->name) == 0) {
			return info;
		}
	}

	return NULL;
80003038:	00000413          	li	s0,0
8000303c:	0440006f          	j	80003080 <z_impl_device_get_binding+0x80>
		if ((info->driver_api != NULL) &&
80003040:	00442703          	lw	a4,4(s0)
80003044:	00070863          	beqz	a4,80003054 <z_impl_device_get_binding+0x54>
		    (info->config->name == name)) {
80003048:	00042703          	lw	a4,0(s0)
		if ((info->driver_api != NULL) &&
8000304c:	00072703          	lw	a4,0(a4)
80003050:	02a70863          	beq	a4,a0,80003080 <z_impl_device_get_binding+0x80>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003054:	00c40413          	addi	s0,s0,12
80003058:	fd1ff06f          	j	80003028 <z_impl_device_get_binding+0x28>
		if (info->driver_api == NULL) {
8000305c:	00442783          	lw	a5,4(s0)
80003060:	00079663          	bnez	a5,8000306c <z_impl_device_get_binding+0x6c>
	for (info = __device_init_start; info != __device_init_end; info++) {
80003064:	00c40413          	addi	s0,s0,12
80003068:	fcdff06f          	j	80003034 <z_impl_device_get_binding+0x34>
		if (strcmp(name, info->config->name) == 0) {
8000306c:	00042783          	lw	a5,0(s0)
80003070:	00090513          	mv	a0,s2
80003074:	0007a583          	lw	a1,0(a5)
80003078:	b35ff0ef          	jal	ra,80002bac <strcmp>
8000307c:	fe0514e3          	bnez	a0,80003064 <z_impl_device_get_binding+0x64>
}
80003080:	00040513          	mv	a0,s0
80003084:	00c12083          	lw	ra,12(sp)
80003088:	00812403          	lw	s0,8(sp)
8000308c:	00412483          	lw	s1,4(sp)
80003090:	00012903          	lw	s2,0(sp)
80003094:	01010113          	addi	sp,sp,16
80003098:	00008067          	ret

8000309c <idle>:
#else
#define IDLE_YIELD_IF_COOP() do { } while (false)
#endif

void idle(void *unused1, void *unused2, void *unused3)
{
8000309c:	ff010113          	addi	sp,sp,-16
800030a0:	00812423          	sw	s0,8(sp)
800030a4:	00912223          	sw	s1,4(sp)
800030a8:	00112623          	sw	ra,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
800030ac:	00800413          	li	s0,8
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800030b0:	00200493          	li	s1,2
800030b4:	300437f3          	csrrc	a5,mstatus,s0
	s32_t ticks = z_get_next_timeout_expiry();
800030b8:	73c020ef          	jal	ra,800057f4 <z_get_next_timeout_expiry>
	z_set_timeout_expiry((ticks < IDLE_THRESH) ? 1 : ticks, true);
800030bc:	00a4c463          	blt	s1,a0,800030c4 <idle+0x28>
800030c0:	00100513          	li	a0,1
800030c4:	00100593          	li	a1,1
800030c8:	009020ef          	jal	ra,800058d0 <z_set_timeout_expiry>
	k_cpu_idle();
800030cc:	d88ff0ef          	jal	ra,80002654 <k_cpu_idle>
800030d0:	fe5ff06f          	j	800030b4 <idle+0x18>

800030d4 <z_bss_zero>:
 *
 * @return N/A
 */
void z_bss_zero(void)
{
	(void)memset(&__bss_start, 0,
800030d4:	80007537          	lui	a0,0x80007
800030d8:	800087b7          	lui	a5,0x80008
800030dc:	69850613          	addi	a2,a0,1688 # 80007698 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007699>
800030e0:	8f078793          	addi	a5,a5,-1808 # 800078f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078f1>
800030e4:	40c78633          	sub	a2,a5,a2
800030e8:	00000593          	li	a1,0
800030ec:	69850513          	addi	a0,a0,1688
800030f0:	ae1ff06f          	j	80002bd0 <memset>

800030f4 <bg_thread_main>:
 * init functions, then invokes application's main() routine.
 *
 * @return N/A
 */
static void bg_thread_main(void *unused1, void *unused2, void *unused3)
{
800030f4:	ff010113          	addi	sp,sp,-16
	static const unsigned int boot_delay = CONFIG_BOOT_DELAY;
#else
	static const unsigned int boot_delay;
#endif

	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
800030f8:	00200513          	li	a0,2
{
800030fc:	00112623          	sw	ra,12(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_POST_KERNEL);
80003100:	e95ff0ef          	jal	ra,80002f94 <z_sys_device_do_config_level>
	if (boot_delay > 0 && IS_ENABLED(CONFIG_MULTITHREADING)) {
		printk("***** delaying boot " STRINGIFY(CONFIG_BOOT_DELAY)
		       "ms (per build configuration) *****\n");
		k_busy_wait(CONFIG_BOOT_DELAY * USEC_PER_MSEC);
	}
	PRINT_BOOT_BANNER();
80003104:	80007537          	lui	a0,0x80007
80003108:	0cc50513          	addi	a0,a0,204 # 800070cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800070cd>
8000310c:	cd8ff0ef          	jal	ra,800025e4 <printk>

	/* Final init level before app starts */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_APPLICATION);
80003110:	00300513          	li	a0,3
80003114:	e81ff0ef          	jal	ra,80002f94 <z_sys_device_do_config_level>
	extern void __do_init_array_aux(void);
	__do_global_ctors_aux();
	__do_init_array_aux();
#endif

	z_init_static_threads();
80003118:	01c020ef          	jal	ra,80005134 <z_init_static_threads>
	__main_time_stamp = (u64_t)k_cycle_get_32();
#endif

	extern void main(void);

	main();
8000311c:	e2dff0ef          	jal	ra,80002f48 <main>

	/* Dump coverage data once the main() has exited. */
	gcov_coverage_dump();

	/* Terminate thread normally since it has no more work to do */
	_main_thread->base.user_options &= ~K_ESSENTIAL;
80003120:	800087b7          	lui	a5,0x80008
80003124:	85478793          	addi	a5,a5,-1964 # 80007854 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007855>
80003128:	00c7c703          	lbu	a4,12(a5)
8000312c:	ffe77713          	andi	a4,a4,-2
80003130:	00e78623          	sb	a4,12(a5)
}
80003134:	00c12083          	lw	ra,12(sp)
80003138:	01010113          	addi	sp,sp,16
8000313c:	00008067          	ret

80003140 <z_cstart>:
 * cleared/zeroed.
 *
 * @return Does not return
 */
FUNC_NORETURN void z_cstart(void)
{
80003140:	f6010113          	addi	sp,sp,-160
80003144:	08812c23          	sw	s0,152(sp)
void k_cpu_idle(void);
void k_cpu_atomic_idle(unsigned int key);

static ALWAYS_INLINE void kernel_arch_init(void)
{
	_kernel.irq_stack =
80003148:	800097b7          	lui	a5,0x80009
8000314c:	80008437          	lui	s0,0x80008
80003150:	09312623          	sw	s3,140(sp)
80003154:	8f078793          	addi	a5,a5,-1808 # 800088f0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800088f1>
80003158:	8c440993          	addi	s3,s0,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
8000315c:	00f9a223          	sw	a5,4(s3)

	/* perform any architecture-specific initialization */
	kernel_arch_init();

#ifdef CONFIG_MULTITHREADING
	struct k_thread dummy_thread = {
80003160:	01010793          	addi	a5,sp,16
80003164:	07000613          	li	a2,112
80003168:	00000593          	li	a1,0
8000316c:	00078513          	mv	a0,a5
{
80003170:	08112e23          	sw	ra,156(sp)
80003174:	08912a23          	sw	s1,148(sp)
80003178:	09212823          	sw	s2,144(sp)
	struct k_thread dummy_thread = {
8000317c:	a55ff0ef          	jal	ra,80002bd0 <memset>
80003180:	00100713          	li	a4,1
# ifdef CONFIG_SCHED_CPU_MASK
		 .base.cpu_mask = -1,
# endif
	};

	_current = &dummy_thread;
80003184:	00a9a423          	sw	a0,8(s3)
#ifdef CONFIG_USERSPACE
	z_app_shmem_bss_zero();
#endif

	/* perform basic hardware initialization */
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003188:	00000513          	li	a0,0
	struct k_thread dummy_thread = {
8000318c:	00e10ea3          	sb	a4,29(sp)
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_1);
80003190:	e05ff0ef          	jal	ra,80002f94 <z_sys_device_do_config_level>
	z_sys_device_do_config_level(_SYS_INIT_LEVEL_PRE_KERNEL_2);
80003194:	00100513          	li	a0,1
80003198:	dfdff0ef          	jal	ra,80002f94 <z_sys_device_do_config_level>
	dummy_thread->base.user_options = K_ESSENTIAL;
8000319c:	10100793          	li	a5,257
800031a0:	00f11e23          	sh	a5,28(sp)
	z_sched_init();
800031a4:	370010ef          	jal	ra,80004514 <z_sched_init>
	z_setup_new_thread(_main_thread, _main_stack,
800031a8:	800077b7          	lui	a5,0x80007
800031ac:	11078793          	addi	a5,a5,272 # 80007110 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007111>
	_kernel.ready_q.cache = _main_thread;
800031b0:	80008937          	lui	s2,0x80008
	z_setup_new_thread(_main_thread, _main_stack,
800031b4:	00f12223          	sw	a5,4(sp)
800031b8:	800036b7          	lui	a3,0x80003
800031bc:	00100793          	li	a5,1
800031c0:	800085b7          	lui	a1,0x80008
	_kernel.ready_q.cache = _main_thread;
800031c4:	85490493          	addi	s1,s2,-1964 # 80007854 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007855>
	z_setup_new_thread(_main_thread, _main_stack,
800031c8:	00f12023          	sw	a5,0(sp)
800031cc:	00000713          	li	a4,0
800031d0:	00000793          	li	a5,0
800031d4:	00000893          	li	a7,0
800031d8:	00000813          	li	a6,0
800031dc:	0f468693          	addi	a3,a3,244 # 800030f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800030f5>
800031e0:	20000613          	li	a2,512
800031e4:	cf058593          	addi	a1,a1,-784 # 80007cf0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007cf1>
800031e8:	85490513          	addi	a0,s2,-1964
	_kernel.ready_q.cache = _main_thread;
800031ec:	0299a023          	sw	s1,32(s3)
	z_setup_new_thread(_main_thread, _main_stack,
800031f0:	3a1010ef          	jal	ra,80004d90 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
}

static inline void z_mark_thread_as_started(struct k_thread *thread)
{
	thread->base.thread_state &= ~_THREAD_PRESTART;
800031f4:	00d4c783          	lbu	a5,13(s1)
800031f8:	8c440413          	addi	s0,s0,-1852
800031fc:	ffb7f713          	andi	a4,a5,-5
80003200:	00e486a3          	sb	a4,13(s1)
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003204:	01b7f793          	andi	a5,a5,27
80003208:	00079a63          	bnez	a5,8000321c <z_cstart+0xdc>
	return true;
}

static ALWAYS_INLINE void z_ready_thread(struct k_thread *thread)
{
	if (z_is_thread_ready(thread)) {
8000320c:	0184a783          	lw	a5,24(s1)
80003210:	00079663          	bnez	a5,8000321c <z_cstart+0xdc>
		z_add_thread_to_ready_q(thread);
80003214:	85490513          	addi	a0,s2,-1964
80003218:	175000ef          	jal	ra,80003b8c <z_add_thread_to_ready_q>
	z_setup_new_thread(thr, stack,
8000321c:	800077b7          	lui	a5,0x80007
80003220:	11878793          	addi	a5,a5,280 # 80007118 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007119>
80003224:	00f12223          	sw	a5,4(sp)
80003228:	80007537          	lui	a0,0x80007
8000322c:	00100793          	li	a5,1
80003230:	800036b7          	lui	a3,0x80003
80003234:	800085b7          	lui	a1,0x80008
80003238:	7e450493          	addi	s1,a0,2020 # 800077e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800077e5>
8000323c:	00f12023          	sw	a5,0(sp)
80003240:	00f00893          	li	a7,15
80003244:	00000813          	li	a6,0
80003248:	00000793          	li	a5,0
8000324c:	00000713          	li	a4,0
80003250:	09c68693          	addi	a3,a3,156 # 8000309c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000309d>
80003254:	20000613          	li	a2,512
80003258:	ef058593          	addi	a1,a1,-272 # 80007ef0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007ef1>
8000325c:	7e450513          	addi	a0,a0,2020
80003260:	331010ef          	jal	ra,80004d90 <z_setup_new_thread>
	thread->base.thread_state &= ~_THREAD_PRESTART;
80003264:	00d4c783          	lbu	a5,13(s1)
	_kernel.cpus[0].idle_thread = _idle_thread;
80003268:	00942623          	sw	s1,12(s0)
8000326c:	00800513          	li	a0,8
80003270:	ffb7f793          	andi	a5,a5,-5
80003274:	00f486a3          	sb	a5,13(s1)
	list->head = (sys_dnode_t *)list;
80003278:	800087b7          	lui	a5,0x80008
8000327c:	8dc78793          	addi	a5,a5,-1828 # 800078dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078dd>
80003280:	00f42c23          	sw	a5,24(s0)
	list->tail = (sys_dnode_t *)list;
80003284:	00f42e23          	sw	a5,28(s0)
80003288:	30053573          	csrrc	a0,mstatus,a0
#ifndef CONFIG_ARM
#ifdef CONFIG_TRACING
	sys_trace_thread_switched_out();
#endif
#endif
	ret = __swap(key);
8000328c:	00857513          	andi	a0,a0,8
80003290:	f99fc0ef          	jal	ra,80000228 <__swap>

80003294 <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80003294:	00d54783          	lbu	a5,13(a0)
80003298:	01f7f793          	andi	a5,a5,31
8000329c:	00079863          	bnez	a5,800032ac <z_is_thread_ready+0x18>
800032a0:	01852503          	lw	a0,24(a0)
800032a4:	00153513          	seqz	a0,a0
800032a8:	00008067          	ret
800032ac:	00000513          	li	a0,0
}
800032b0:	00008067          	ret

800032b4 <reset_time_slice>:
 */
static struct k_thread *pending_current;
#endif

static void reset_time_slice(void)
{
800032b4:	ff010113          	addi	sp,sp,-16
800032b8:	00112623          	sw	ra,12(sp)
	/* Add the elapsed time since the last announced tick to the
	 * slice count, as we'll see those "expired" ticks arrive in a
	 * FUTURE z_time_slice() call.
	 */
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800032bc:	fe4ff0ef          	jal	ra,80002aa0 <z_clock_elapsed>
800032c0:	800077b7          	lui	a5,0x80007
800032c4:	6c87a783          	lw	a5,1736(a5) # 800076c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c9>

	z_set_timeout_expiry(slice_time, false);
}
800032c8:	00c12083          	lw	ra,12(sp)
	_current_cpu->slice_ticks = slice_time + z_clock_elapsed();
800032cc:	80008737          	lui	a4,0x80008
800032d0:	00a78533          	add	a0,a5,a0
800032d4:	8ca72a23          	sw	a0,-1836(a4) # 800078d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078d5>
	z_set_timeout_expiry(slice_time, false);
800032d8:	00000593          	li	a1,0
800032dc:	00078513          	mv	a0,a5
}
800032e0:	01010113          	addi	sp,sp,16
	z_set_timeout_expiry(slice_time, false);
800032e4:	5ec0206f          	j	800058d0 <z_set_timeout_expiry>

800032e8 <pended_on.isra.15>:
	pend(thread, wait_q, timeout);
}

static _wait_q_t *pended_on(struct k_thread *thread)
{
	__ASSERT_NO_MSG(thread->base.pended_on);
800032e8:	00052783          	lw	a5,0(a0)
static _wait_q_t *pended_on(struct k_thread *thread)
800032ec:	ff010113          	addi	sp,sp,-16
800032f0:	00812423          	sw	s0,8(sp)
800032f4:	00112623          	sw	ra,12(sp)
800032f8:	00912223          	sw	s1,4(sp)
800032fc:	00050413          	mv	s0,a0
	__ASSERT_NO_MSG(thread->base.pended_on);
80003300:	02079863          	bnez	a5,80003330 <pended_on.isra.15+0x48>
80003304:	800074b7          	lui	s1,0x80007
80003308:	800075b7          	lui	a1,0x80007
8000330c:	80007537          	lui	a0,0x80007
80003310:	1bc58593          	addi	a1,a1,444 # 800071bc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071bd>
80003314:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003318:	18300693          	li	a3,387
8000331c:	1a848613          	addi	a2,s1,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80003320:	ac4ff0ef          	jal	ra,800025e4 <printk>
80003324:	18300593          	li	a1,387
80003328:	1a848513          	addi	a0,s1,424
8000332c:	af4ff0ef          	jal	ra,80002620 <assert_post_action>

	return thread->base.pended_on;
}
80003330:	00042503          	lw	a0,0(s0)
80003334:	00c12083          	lw	ra,12(sp)
80003338:	00812403          	lw	s0,8(sp)
8000333c:	00412483          	lw	s1,4(sp)
80003340:	01010113          	addi	sp,sp,16
80003344:	00008067          	ret

80003348 <k_sched_time_slice_set>:
{
80003348:	fe010113          	addi	sp,sp,-32
8000334c:	00812c23          	sw	s0,24(sp)
80003350:	01312623          	sw	s3,12(sp)
80003354:	01412423          	sw	s4,8(sp)
80003358:	00112e23          	sw	ra,28(sp)
8000335c:	00912a23          	sw	s1,20(sp)
80003360:	01212823          	sw	s2,16(sp)
80003364:	00050a13          	mv	s4,a0
80003368:	00058993          	mv	s3,a1
8000336c:	00800413          	li	s0,8
80003370:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003374:	800074b7          	lui	s1,0x80007
80003378:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
8000337c:	00847413          	andi	s0,s0,8
80003380:	2dd010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003384:	02051e63          	bnez	a0,800033c0 <k_sched_time_slice_set+0x78>
80003388:	80007937          	lui	s2,0x80007
8000338c:	800075b7          	lui	a1,0x80007
80003390:	80007537          	lui	a0,0x80007
80003394:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003398:	04e00693          	li	a3,78
8000339c:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800033a0:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800033a4:	a40ff0ef          	jal	ra,800025e4 <printk>
800033a8:	80007537          	lui	a0,0x80007
800033ac:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800033b0:	a34ff0ef          	jal	ra,800025e4 <printk>
800033b4:	04e00593          	li	a1,78
800033b8:	f2c90513          	addi	a0,s2,-212
800033bc:	a64ff0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800033c0:	6c048513          	addi	a0,s1,1728
800033c4:	2f1010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		_current_cpu->slice_ticks = 0;
800033c8:	800087b7          	lui	a5,0x80008
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
800033cc:	00a00593          	li	a1,10
800033d0:	009a0513          	addi	a0,s4,9
800033d4:	8c07aa23          	sw	zero,-1836(a5) # 800078d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078d5>
800033d8:	d60fd0ef          	jal	ra,80000938 <__divsi3>
		slice_max_prio = prio;
800033dc:	800077b7          	lui	a5,0x80007
		slice_time = z_ms_to_ticks(slice);
800033e0:	80007937          	lui	s2,0x80007
800033e4:	6ca92423          	sw	a0,1736(s2) # 800076c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c9>
		slice_max_prio = prio;
800033e8:	6d37a223          	sw	s3,1732(a5) # 800076c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c5>
		reset_time_slice();
800033ec:	ec9ff0ef          	jal	ra,800032b4 <reset_time_slice>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800033f0:	6c048513          	addi	a0,s1,1728
800033f4:	291010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800033f8:	02051e63          	bnez	a0,80003434 <k_sched_time_slice_set+0xec>
800033fc:	800074b7          	lui	s1,0x80007
80003400:	800075b7          	lui	a1,0x80007
80003404:	80007537          	lui	a0,0x80007
80003408:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
8000340c:	06100693          	li	a3,97
80003410:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003414:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003418:	9ccff0ef          	jal	ra,800025e4 <printk>
8000341c:	80007537          	lui	a0,0x80007
80003420:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003424:	9c0ff0ef          	jal	ra,800025e4 <printk>
80003428:	06100593          	li	a1,97
8000342c:	f2c48513          	addi	a0,s1,-212
80003430:	9f0ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003434:	30042473          	csrrs	s0,mstatus,s0
}
80003438:	01c12083          	lw	ra,28(sp)
8000343c:	01812403          	lw	s0,24(sp)
80003440:	01412483          	lw	s1,20(sp)
80003444:	01012903          	lw	s2,16(sp)
80003448:	00c12983          	lw	s3,12(sp)
8000344c:	00812a03          	lw	s4,8(sp)
80003450:	02010113          	addi	sp,sp,32
80003454:	00008067          	ret

80003458 <z_find_first_thread_to_unpend>:

ALWAYS_INLINE struct k_thread *z_find_first_thread_to_unpend(_wait_q_t *wait_q,
						     struct k_thread *from)
{
80003458:	fe010113          	addi	sp,sp,-32
8000345c:	00812c23          	sw	s0,24(sp)
80003460:	01312623          	sw	s3,12(sp)
80003464:	00112e23          	sw	ra,28(sp)
80003468:	00912a23          	sw	s1,20(sp)
8000346c:	01212823          	sw	s2,16(sp)
80003470:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003474:	00800413          	li	s0,8
80003478:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
8000347c:	800074b7          	lui	s1,0x80007
80003480:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003484:	00847413          	andi	s0,s0,8
80003488:	1d5010ef          	jal	ra,80004e5c <z_spin_lock_valid>
8000348c:	02051e63          	bnez	a0,800034c8 <z_find_first_thread_to_unpend+0x70>
80003490:	80007937          	lui	s2,0x80007
80003494:	800075b7          	lui	a1,0x80007
80003498:	80007537          	lui	a0,0x80007
8000349c:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800034a0:	04e00693          	li	a3,78
800034a4:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800034a8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800034ac:	938ff0ef          	jal	ra,800025e4 <printk>
800034b0:	80007537          	lui	a0,0x80007
800034b4:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800034b8:	92cff0ef          	jal	ra,800025e4 <printk>
800034bc:	04e00593          	li	a1,78
800034c0:	f2c90513          	addi	a0,s2,-212
800034c4:	95cff0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800034c8:	6c048513          	addi	a0,s1,1728
800034cc:	1e9010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	ARG_UNUSED(from);

	struct k_thread *ret = NULL;

	LOCKED(&sched_spinlock) {
		ret = _priq_wait_best(&wait_q->waitq);
800034d0:	00098513          	mv	a0,s3
800034d4:	45c000ef          	jal	ra,80003930 <z_priq_dumb_best>
800034d8:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800034dc:	6c048513          	addi	a0,s1,1728
800034e0:	1a5010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800034e4:	02051e63          	bnez	a0,80003520 <z_find_first_thread_to_unpend+0xc8>
800034e8:	800074b7          	lui	s1,0x80007
800034ec:	800075b7          	lui	a1,0x80007
800034f0:	80007537          	lui	a0,0x80007
800034f4:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800034f8:	06100693          	li	a3,97
800034fc:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003500:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003504:	8e0ff0ef          	jal	ra,800025e4 <printk>
80003508:	80007537          	lui	a0,0x80007
8000350c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003510:	8d4ff0ef          	jal	ra,800025e4 <printk>
80003514:	06100593          	li	a1,97
80003518:	f2c48513          	addi	a0,s1,-212
8000351c:	904ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003520:	30042473          	csrrs	s0,mstatus,s0
	}

	return ret;
}
80003524:	01c12083          	lw	ra,28(sp)
80003528:	01812403          	lw	s0,24(sp)
8000352c:	00090513          	mv	a0,s2
80003530:	01412483          	lw	s1,20(sp)
80003534:	01012903          	lw	s2,16(sp)
80003538:	00c12983          	lw	s3,12(sp)
8000353c:	02010113          	addi	sp,sp,32
80003540:	00008067          	ret

80003544 <z_unpend_thread_no_timeout>:

ALWAYS_INLINE void z_unpend_thread_no_timeout(struct k_thread *thread)
{
80003544:	fe010113          	addi	sp,sp,-32
80003548:	00812c23          	sw	s0,24(sp)
8000354c:	01212823          	sw	s2,16(sp)
80003550:	00112e23          	sw	ra,28(sp)
80003554:	00912a23          	sw	s1,20(sp)
80003558:	01312623          	sw	s3,12(sp)
8000355c:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003560:	00800413          	li	s0,8
80003564:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003568:	800074b7          	lui	s1,0x80007
8000356c:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003570:	00847413          	andi	s0,s0,8
80003574:	0e9010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003578:	02051e63          	bnez	a0,800035b4 <z_unpend_thread_no_timeout+0x70>
8000357c:	800079b7          	lui	s3,0x80007
80003580:	800075b7          	lui	a1,0x80007
80003584:	80007537          	lui	a0,0x80007
80003588:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
8000358c:	04e00693          	li	a3,78
80003590:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003594:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003598:	84cff0ef          	jal	ra,800025e4 <printk>
8000359c:	80007537          	lui	a0,0x80007
800035a0:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800035a4:	840ff0ef          	jal	ra,800025e4 <printk>
800035a8:	04e00593          	li	a1,78
800035ac:	f2c98513          	addi	a0,s3,-212
800035b0:	870ff0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800035b4:	6c048513          	addi	a0,s1,1728
800035b8:	0fd010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	LOCKED(&sched_spinlock) {
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
800035bc:	00890513          	addi	a0,s2,8
800035c0:	d29ff0ef          	jal	ra,800032e8 <pended_on.isra.15>
800035c4:	00090593          	mv	a1,s2
800035c8:	2f0000ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
800035cc:	00d94783          	lbu	a5,13(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800035d0:	6c048513          	addi	a0,s1,1728
800035d4:	ffd7f793          	andi	a5,a5,-3
800035d8:	00f906a3          	sb	a5,13(s2)
800035dc:	0a9010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800035e0:	02051e63          	bnez	a0,8000361c <z_unpend_thread_no_timeout+0xd8>
800035e4:	800074b7          	lui	s1,0x80007
800035e8:	800075b7          	lui	a1,0x80007
800035ec:	80007537          	lui	a0,0x80007
800035f0:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800035f4:	06100693          	li	a3,97
800035f8:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800035fc:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003600:	fe5fe0ef          	jal	ra,800025e4 <printk>
80003604:	80007537          	lui	a0,0x80007
80003608:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
8000360c:	fd9fe0ef          	jal	ra,800025e4 <printk>
80003610:	06100593          	li	a1,97
80003614:	f2c48513          	addi	a0,s1,-212
80003618:	808ff0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000361c:	30042473          	csrrs	s0,mstatus,s0
		z_mark_thread_as_not_pending(thread);
	}

	thread->base.pended_on = NULL;
}
80003620:	01c12083          	lw	ra,28(sp)
80003624:	01812403          	lw	s0,24(sp)
	thread->base.pended_on = NULL;
80003628:	00092423          	sw	zero,8(s2)
}
8000362c:	01412483          	lw	s1,20(sp)
80003630:	01012903          	lw	s2,16(sp)
80003634:	00c12983          	lw	s3,12(sp)
80003638:	02010113          	addi	sp,sp,32
8000363c:	00008067          	ret

80003640 <z_reschedule>:
	return !z_is_in_isr();
}

void z_reschedule(struct k_spinlock *lock, k_spinlock_key_t key)
{
	if (resched()) {
80003640:	800087b7          	lui	a5,0x80008
80003644:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80003648:	ff010113          	addi	sp,sp,-16
8000364c:	00812423          	sw	s0,8(sp)
80003650:	00112623          	sw	ra,12(sp)
80003654:	00912223          	sw	s1,4(sp)
80003658:	00058413          	mv	s0,a1
	if (resched()) {
8000365c:	04079e63          	bnez	a5,800036b8 <z_reschedule+0x78>
 */
static ALWAYS_INLINE void k_spin_release(struct k_spinlock *l)
{
	ARG_UNUSED(l);
#ifdef SPIN_VALIDATE
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003660:	025010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80003664:	02051e63          	bnez	a0,800036a0 <z_reschedule+0x60>
80003668:	800074b7          	lui	s1,0x80007
8000366c:	800075b7          	lui	a1,0x80007
80003670:	80007537          	lui	a0,0x80007
80003674:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003678:	07800693          	li	a3,120
8000367c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003680:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003684:	f61fe0ef          	jal	ra,800025e4 <printk>
80003688:	80007537          	lui	a0,0x80007
8000368c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003690:	f55fe0ef          	jal	ra,800025e4 <printk>
80003694:	07800593          	li	a1,120
80003698:	f2c48513          	addi	a0,s1,-212
8000369c:	f85fe0ef          	jal	ra,80002620 <assert_post_action>
800036a0:	00040513          	mv	a0,s0
		z_swap(lock, key);
	} else {
		k_spin_unlock(lock, key);
	}
}
800036a4:	00812403          	lw	s0,8(sp)
800036a8:	00c12083          	lw	ra,12(sp)
800036ac:	00412483          	lw	s1,4(sp)
800036b0:	01010113          	addi	sp,sp,16
800036b4:	b75fc06f          	j	80000228 <__swap>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800036b8:	7cc010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800036bc:	02051e63          	bnez	a0,800036f8 <z_reschedule+0xb8>
800036c0:	800074b7          	lui	s1,0x80007
800036c4:	800075b7          	lui	a1,0x80007
800036c8:	80007537          	lui	a0,0x80007
800036cc:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800036d0:	06100693          	li	a3,97
800036d4:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800036d8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800036dc:	f09fe0ef          	jal	ra,800025e4 <printk>
800036e0:	80007537          	lui	a0,0x80007
800036e4:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800036e8:	efdfe0ef          	jal	ra,800025e4 <printk>
800036ec:	06100593          	li	a1,97
800036f0:	f2c48513          	addi	a0,s1,-212
800036f4:	f2dfe0ef          	jal	ra,80002620 <assert_post_action>
			  : "=r" (mstatus)
			  : "r" (key & SOC_MSTATUS_IEN)
800036f8:	00847413          	andi	s0,s0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
800036fc:	30042473          	csrrs	s0,mstatus,s0
80003700:	00c12083          	lw	ra,12(sp)
80003704:	00812403          	lw	s0,8(sp)
80003708:	00412483          	lw	s1,4(sp)
8000370c:	01010113          	addi	sp,sp,16
80003710:	00008067          	ret

80003714 <z_reschedule_irqlock>:

void z_reschedule_irqlock(u32_t key)
{
	if (resched()) {
80003714:	80008737          	lui	a4,0x80008
80003718:	8c472703          	lw	a4,-1852(a4) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
8000371c:	00071463          	bnez	a4,80003724 <z_reschedule_irqlock+0x10>
80003720:	b09fc06f          	j	80000228 <__swap>
			  : "r" (key & SOC_MSTATUS_IEN)
80003724:	00857793          	andi	a5,a0,8
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003728:	3007a7f3          	csrrs	a5,mstatus,a5
		z_swap_irqlock(key);
	} else {
		irq_unlock(key);
	}
}
8000372c:	00008067          	ret

80003730 <z_reschedule_unlocked>:
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003730:	00800513          	li	a0,8
80003734:	30053573          	csrrc	a0,mstatus,a0
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80003738:	00857513          	andi	a0,a0,8
8000373c:	fd9ff06f          	j	80003714 <z_reschedule_irqlock>

80003740 <k_sched_lock>:

void k_sched_lock(void)
{
80003740:	fe010113          	addi	sp,sp,-32
80003744:	00812c23          	sw	s0,24(sp)
80003748:	00112e23          	sw	ra,28(sp)
8000374c:	00912a23          	sw	s1,20(sp)
80003750:	01212823          	sw	s2,16(sp)
80003754:	01312623          	sw	s3,12(sp)
80003758:	00800413          	li	s0,8
8000375c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003760:	800074b7          	lui	s1,0x80007
80003764:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003768:	00847413          	andi	s0,s0,8
8000376c:	6f0010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003770:	02051e63          	bnez	a0,800037ac <k_sched_lock+0x6c>
80003774:	80007937          	lui	s2,0x80007
80003778:	800075b7          	lui	a1,0x80007
8000377c:	80007537          	lui	a0,0x80007
80003780:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003784:	04e00693          	li	a3,78
80003788:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000378c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003790:	e55fe0ef          	jal	ra,800025e4 <printk>
80003794:	80007537          	lui	a0,0x80007
80003798:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
8000379c:	e49fe0ef          	jal	ra,800025e4 <printk>
800037a0:	04e00593          	li	a1,78
800037a4:	f2c90513          	addi	a0,s2,-212
800037a8:	e79fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800037ac:	6c048513          	addi	a0,s1,1728
}

static inline void z_sched_lock(void)
{
#ifdef CONFIG_PREEMPT_ENABLED
	__ASSERT(!z_is_in_isr(), "");
800037b0:	80008937          	lui	s2,0x80008
800037b4:	700010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
800037b8:	8c492783          	lw	a5,-1852(s2) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
800037bc:	8c490913          	addi	s2,s2,-1852
800037c0:	02078e63          	beqz	a5,800037fc <k_sched_lock+0xbc>
800037c4:	800079b7          	lui	s3,0x80007
800037c8:	800075b7          	lui	a1,0x80007
800037cc:	80007537          	lui	a0,0x80007
800037d0:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
800037d4:	10000693          	li	a3,256
800037d8:	12098613          	addi	a2,s3,288 # 80007120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007121>
800037dc:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800037e0:	e05fe0ef          	jal	ra,800025e4 <printk>
800037e4:	80007537          	lui	a0,0x80007
800037e8:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800037ec:	df9fe0ef          	jal	ra,800025e4 <printk>
800037f0:	10000593          	li	a1,256
800037f4:	12098513          	addi	a0,s3,288
800037f8:	e29fe0ef          	jal	ra,80002620 <assert_post_action>
	__ASSERT(_current->base.sched_locked != 1, "");
800037fc:	00892783          	lw	a5,8(s2)
80003800:	00f7c703          	lbu	a4,15(a5)
80003804:	00100793          	li	a5,1
80003808:	02f71e63          	bne	a4,a5,80003844 <k_sched_lock+0x104>
8000380c:	800079b7          	lui	s3,0x80007
80003810:	800075b7          	lui	a1,0x80007
80003814:	80007537          	lui	a0,0x80007
80003818:	15858593          	addi	a1,a1,344 # 80007158 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007159>
8000381c:	10100693          	li	a3,257
80003820:	12098613          	addi	a2,s3,288 # 80007120 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007121>
80003824:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003828:	dbdfe0ef          	jal	ra,800025e4 <printk>
8000382c:	80007537          	lui	a0,0x80007
80003830:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80003834:	db1fe0ef          	jal	ra,800025e4 <printk>
80003838:	10100593          	li	a1,257
8000383c:	12098513          	addi	a0,s3,288
80003840:	de1fe0ef          	jal	ra,80002620 <assert_post_action>

	--_current->base.sched_locked;
80003844:	00892703          	lw	a4,8(s2)
80003848:	00f74783          	lbu	a5,15(a4)
8000384c:	fff78793          	addi	a5,a5,-1
80003850:	00f707a3          	sb	a5,15(a4)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003854:	6c048513          	addi	a0,s1,1728
80003858:	62c010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
8000385c:	02051e63          	bnez	a0,80003898 <k_sched_lock+0x158>
80003860:	800074b7          	lui	s1,0x80007
80003864:	800075b7          	lui	a1,0x80007
80003868:	80007537          	lui	a0,0x80007
8000386c:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003870:	06100693          	li	a3,97
80003874:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003878:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
8000387c:	d69fe0ef          	jal	ra,800025e4 <printk>
80003880:	80007537          	lui	a0,0x80007
80003884:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003888:	d5dfe0ef          	jal	ra,800025e4 <printk>
8000388c:	06100593          	li	a1,97
80003890:	f2c48513          	addi	a0,s1,-212
80003894:	d8dfe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003898:	30042473          	csrrs	s0,mstatus,s0
	LOCKED(&sched_spinlock) {
		z_sched_lock();
	}
}
8000389c:	01c12083          	lw	ra,28(sp)
800038a0:	01812403          	lw	s0,24(sp)
800038a4:	01412483          	lw	s1,20(sp)
800038a8:	01012903          	lw	s2,16(sp)
800038ac:	00c12983          	lw	s3,12(sp)
800038b0:	02010113          	addi	sp,sp,32
800038b4:	00008067          	ret

800038b8 <z_priq_dumb_remove>:
	return thread == _idle_thread;
800038b8:	800077b7          	lui	a5,0x80007
	    z_is_thread_prevented_from_running(thread)) {
		return;
	}
#endif

	__ASSERT_NO_MSG(!is_idle(thread));
800038bc:	5447a783          	lw	a5,1348(a5) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
{
800038c0:	ff010113          	addi	sp,sp,-16
800038c4:	00812423          	sw	s0,8(sp)
800038c8:	00112623          	sw	ra,12(sp)
800038cc:	00912223          	sw	s1,4(sp)
800038d0:	00058413          	mv	s0,a1
	__ASSERT_NO_MSG(!is_idle(thread));
800038d4:	02f59863          	bne	a1,a5,80003904 <z_priq_dumb_remove+0x4c>
800038d8:	800074b7          	lui	s1,0x80007
800038dc:	800075b7          	lui	a1,0x80007
800038e0:	80007537          	lui	a0,0x80007
800038e4:	24058593          	addi	a1,a1,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
800038e8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800038ec:	28c00693          	li	a3,652
800038f0:	1a848613          	addi	a2,s1,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
800038f4:	cf1fe0ef          	jal	ra,800025e4 <printk>
800038f8:	28c00593          	li	a1,652
800038fc:	1a848513          	addi	a0,s1,424
80003900:	d21fe0ef          	jal	ra,80002620 <assert_post_action>
 * @return N/A
 */

static inline void sys_dlist_remove(sys_dnode_t *node)
{
	node->prev->next = node->next;
80003904:	00442703          	lw	a4,4(s0)
80003908:	00042783          	lw	a5,0(s0)

	sys_dlist_remove(&thread->base.qnode_dlist);
}
8000390c:	00c12083          	lw	ra,12(sp)
80003910:	00412483          	lw	s1,4(sp)
80003914:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80003918:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
8000391c:	00042023          	sw	zero,0(s0)
	node->prev = NULL;
80003920:	00042223          	sw	zero,4(s0)
80003924:	00812403          	lw	s0,8(sp)
80003928:	01010113          	addi	sp,sp,16
8000392c:	00008067          	ret

80003930 <z_priq_dumb_best>:
	return list->head == list;
80003930:	00052783          	lw	a5,0(a0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003934:	00f51463          	bne	a0,a5,8000393c <z_priq_dumb_best+0xc>

struct k_thread *z_priq_dumb_best(sys_dlist_t *pq)
{
	struct k_thread *t = NULL;
80003938:	00000793          	li	a5,0

	if (n != NULL) {
		t = CONTAINER_OF(n, struct k_thread, base.qnode_dlist);
	}
	return t;
}
8000393c:	00078513          	mv	a0,a5
80003940:	00008067          	ret

80003944 <update_cache>:
{
80003944:	ff010113          	addi	sp,sp,-16
80003948:	00812423          	sw	s0,8(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
8000394c:	80008437          	lui	s0,0x80008
{
80003950:	01212023          	sw	s2,0(sp)
80003954:	00050913          	mv	s2,a0
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003958:	8c440513          	addi	a0,s0,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
8000395c:	02450513          	addi	a0,a0,36
{
80003960:	00912223          	sw	s1,4(sp)
80003964:	00112623          	sw	ra,12(sp)
	struct k_thread *th = _priq_run_best(&_kernel.ready_q.runq);
80003968:	fc9ff0ef          	jal	ra,80003930 <z_priq_dumb_best>
	return th ? th : _current_cpu->idle_thread;
8000396c:	8c440413          	addi	s0,s0,-1852
80003970:	00050493          	mv	s1,a0
80003974:	00051463          	bnez	a0,8000397c <update_cache+0x38>
80003978:	00c42483          	lw	s1,12(s0)
	if (preempt_ok != 0) {
8000397c:	06091e63          	bnez	s2,800039f8 <update_cache+0xb4>
	__ASSERT(_current != NULL, "");
80003980:	00842783          	lw	a5,8(s0)
80003984:	02079e63          	bnez	a5,800039c0 <update_cache+0x7c>
80003988:	80007937          	lui	s2,0x80007
8000398c:	800075b7          	lui	a1,0x80007
80003990:	80007537          	lui	a0,0x80007
80003994:	1d458593          	addi	a1,a1,468 # 800071d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071d5>
80003998:	07f00693          	li	a3,127
8000399c:	1a890613          	addi	a2,s2,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
800039a0:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800039a4:	c41fe0ef          	jal	ra,800025e4 <printk>
800039a8:	80007537          	lui	a0,0x80007
800039ac:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800039b0:	c35fe0ef          	jal	ra,800025e4 <printk>
800039b4:	07f00593          	li	a1,127
800039b8:	1a890513          	addi	a0,s2,424
800039bc:	c65fe0ef          	jal	ra,80002620 <assert_post_action>
	if (z_is_thread_prevented_from_running(_current)) {
800039c0:	00842783          	lw	a5,8(s0)
800039c4:	00d7c703          	lbu	a4,13(a5)
800039c8:	01f77713          	andi	a4,a4,31
800039cc:	02071663          	bnez	a4,800039f8 <update_cache+0xb4>
	if (is_preempt(_current) || is_metairq(th)) {
800039d0:	00e7d683          	lhu	a3,14(a5)
800039d4:	07f00713          	li	a4,127
800039d8:	02d77063          	bgeu	a4,a3,800039f8 <update_cache+0xb4>
		_kernel.ready_q.cache = _current;
800039dc:	02f42023          	sw	a5,32(s0)
}
800039e0:	00c12083          	lw	ra,12(sp)
800039e4:	00812403          	lw	s0,8(sp)
800039e8:	00412483          	lw	s1,4(sp)
800039ec:	00012903          	lw	s2,0(sp)
800039f0:	01010113          	addi	sp,sp,16
800039f4:	00008067          	ret
		if (th != _current) {
800039f8:	00842783          	lw	a5,8(s0)
800039fc:	00978463          	beq	a5,s1,80003a04 <update_cache+0xc0>
			reset_time_slice();
80003a00:	8b5ff0ef          	jal	ra,800032b4 <reset_time_slice>
		_kernel.ready_q.cache = th;
80003a04:	02942023          	sw	s1,32(s0)
}
80003a08:	fd9ff06f          	j	800039e0 <update_cache+0x9c>

80003a0c <k_sched_unlock>:
{
80003a0c:	fe010113          	addi	sp,sp,-32
80003a10:	01212823          	sw	s2,16(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003a14:	80008937          	lui	s2,0x80008
80003a18:	8c490793          	addi	a5,s2,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80003a1c:	0087a783          	lw	a5,8(a5)
{
80003a20:	00112e23          	sw	ra,28(sp)
80003a24:	00812c23          	sw	s0,24(sp)
	__ASSERT(_current->base.sched_locked != 0, "");
80003a28:	00f7c783          	lbu	a5,15(a5)
{
80003a2c:	00912a23          	sw	s1,20(sp)
80003a30:	01312623          	sw	s3,12(sp)
80003a34:	8c490913          	addi	s2,s2,-1852
	__ASSERT(_current->base.sched_locked != 0, "");
80003a38:	02079e63          	bnez	a5,80003a74 <k_sched_unlock+0x68>
80003a3c:	80007437          	lui	s0,0x80007
80003a40:	800075b7          	lui	a1,0x80007
80003a44:	80007537          	lui	a0,0x80007
80003a48:	18058593          	addi	a1,a1,384 # 80007180 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007181>
80003a4c:	22100693          	li	a3,545
80003a50:	1a840613          	addi	a2,s0,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80003a54:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003a58:	b8dfe0ef          	jal	ra,800025e4 <printk>
80003a5c:	80007537          	lui	a0,0x80007
80003a60:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80003a64:	b81fe0ef          	jal	ra,800025e4 <printk>
80003a68:	22100593          	li	a1,545
80003a6c:	1a840513          	addi	a0,s0,424
80003a70:	bb1fe0ef          	jal	ra,80002620 <assert_post_action>
	__ASSERT(!z_is_in_isr(), "");
80003a74:	00092783          	lw	a5,0(s2)
80003a78:	02078e63          	beqz	a5,80003ab4 <k_sched_unlock+0xa8>
80003a7c:	80007437          	lui	s0,0x80007
80003a80:	800075b7          	lui	a1,0x80007
80003a84:	80007537          	lui	a0,0x80007
80003a88:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
80003a8c:	22200693          	li	a3,546
80003a90:	1a840613          	addi	a2,s0,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80003a94:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003a98:	b4dfe0ef          	jal	ra,800025e4 <printk>
80003a9c:	80007537          	lui	a0,0x80007
80003aa0:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80003aa4:	b41fe0ef          	jal	ra,800025e4 <printk>
80003aa8:	22200593          	li	a1,546
80003aac:	1a840513          	addi	a0,s0,424
80003ab0:	b71fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ab4:	00800413          	li	s0,8
80003ab8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003abc:	800074b7          	lui	s1,0x80007
80003ac0:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003ac4:	00847413          	andi	s0,s0,8
80003ac8:	394010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003acc:	02051e63          	bnez	a0,80003b08 <k_sched_unlock+0xfc>
80003ad0:	800079b7          	lui	s3,0x80007
80003ad4:	800075b7          	lui	a1,0x80007
80003ad8:	80007537          	lui	a0,0x80007
80003adc:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003ae0:	04e00693          	li	a3,78
80003ae4:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003ae8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003aec:	af9fe0ef          	jal	ra,800025e4 <printk>
80003af0:	80007537          	lui	a0,0x80007
80003af4:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80003af8:	aedfe0ef          	jal	ra,800025e4 <printk>
80003afc:	04e00593          	li	a1,78
80003b00:	f2c98513          	addi	a0,s3,-212
80003b04:	b1dfe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80003b08:	6c048513          	addi	a0,s1,1728
80003b0c:	3a8010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		++_current->base.sched_locked;
80003b10:	00892703          	lw	a4,8(s2)
		update_cache(1);
80003b14:	00100513          	li	a0,1
		++_current->base.sched_locked;
80003b18:	00f74783          	lbu	a5,15(a4)
80003b1c:	00178793          	addi	a5,a5,1
80003b20:	00f707a3          	sb	a5,15(a4)
		update_cache(1);
80003b24:	e21ff0ef          	jal	ra,80003944 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003b28:	6c048513          	addi	a0,s1,1728
80003b2c:	358010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80003b30:	02051e63          	bnez	a0,80003b6c <k_sched_unlock+0x160>
80003b34:	800074b7          	lui	s1,0x80007
80003b38:	800075b7          	lui	a1,0x80007
80003b3c:	80007537          	lui	a0,0x80007
80003b40:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003b44:	06100693          	li	a3,97
80003b48:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003b4c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003b50:	a95fe0ef          	jal	ra,800025e4 <printk>
80003b54:	80007537          	lui	a0,0x80007
80003b58:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003b5c:	a89fe0ef          	jal	ra,800025e4 <printk>
80003b60:	06100593          	li	a1,97
80003b64:	f2c48513          	addi	a0,s1,-212
80003b68:	ab9fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003b6c:	30042473          	csrrs	s0,mstatus,s0
}
80003b70:	01812403          	lw	s0,24(sp)
80003b74:	01c12083          	lw	ra,28(sp)
80003b78:	01412483          	lw	s1,20(sp)
80003b7c:	01012903          	lw	s2,16(sp)
80003b80:	00c12983          	lw	s3,12(sp)
80003b84:	02010113          	addi	sp,sp,32
	z_reschedule_unlocked();
80003b88:	ba9ff06f          	j	80003730 <z_reschedule_unlocked>

80003b8c <z_add_thread_to_ready_q>:
{
80003b8c:	fe010113          	addi	sp,sp,-32
80003b90:	00812c23          	sw	s0,24(sp)
80003b94:	00912a23          	sw	s1,20(sp)
80003b98:	00112e23          	sw	ra,28(sp)
80003b9c:	01212823          	sw	s2,16(sp)
80003ba0:	01312623          	sw	s3,12(sp)
80003ba4:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003ba8:	00800493          	li	s1,8
80003bac:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003bb0:	80007937          	lui	s2,0x80007
80003bb4:	6c090513          	addi	a0,s2,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003bb8:	0084f493          	andi	s1,s1,8
80003bbc:	2a0010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003bc0:	02051e63          	bnez	a0,80003bfc <z_add_thread_to_ready_q+0x70>
80003bc4:	800079b7          	lui	s3,0x80007
80003bc8:	800075b7          	lui	a1,0x80007
80003bcc:	80007537          	lui	a0,0x80007
80003bd0:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003bd4:	04e00693          	li	a3,78
80003bd8:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003bdc:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003be0:	a05fe0ef          	jal	ra,800025e4 <printk>
80003be4:	80007537          	lui	a0,0x80007
80003be8:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80003bec:	9f9fe0ef          	jal	ra,800025e4 <printk>
80003bf0:	04e00593          	li	a1,78
80003bf4:	f2c98513          	addi	a0,s3,-212
80003bf8:	a29fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80003bfc:	6c090513          	addi	a0,s2,1728
80003c00:	2b4010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	return thread == _idle_thread;
80003c04:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003c08:	5447a783          	lw	a5,1348(a5) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
80003c0c:	02f41863          	bne	s0,a5,80003c3c <z_add_thread_to_ready_q+0xb0>
80003c10:	800079b7          	lui	s3,0x80007
80003c14:	800075b7          	lui	a1,0x80007
80003c18:	80007537          	lui	a0,0x80007
80003c1c:	24058593          	addi	a1,a1,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
80003c20:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003c24:	27600693          	li	a3,630
80003c28:	1a898613          	addi	a2,s3,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80003c2c:	9b9fe0ef          	jal	ra,800025e4 <printk>
80003c30:	27600593          	li	a1,630
80003c34:	1a898513          	addi	a0,s3,424
80003c38:	9e9fe0ef          	jal	ra,80002620 <assert_post_action>
	return list->head == list;
80003c3c:	80008737          	lui	a4,0x80008
80003c40:	8c470693          	addi	a3,a4,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80003c44:	0246a783          	lw	a5,36(a3)
80003c48:	0286a603          	lw	a2,40(a3)
80003c4c:	800086b7          	lui	a3,0x80008
80003c50:	8e868693          	addi	a3,a3,-1816 # 800078e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078e9>
80003c54:	8c470713          	addi	a4,a4,-1852
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003c58:	0ad78663          	beq	a5,a3,80003d04 <z_add_thread_to_ready_q+0x178>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003c5c:	0a078463          	beqz	a5,80003d04 <z_add_thread_to_ready_q+0x178>
	if (t1->base.prio < t2->base.prio) {
80003c60:	00e40583          	lb	a1,14(s0)
80003c64:	00e78503          	lb	a0,14(a5)
80003c68:	08a5d863          	bge	a1,a0,80003cf8 <z_add_thread_to_ready_q+0x16c>
	node->prev = successor->prev;
80003c6c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003c70:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003c74:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003c78:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003c7c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003c80:	00d44783          	lbu	a5,13(s0)
		update_cache(0);
80003c84:	00000513          	li	a0,0
80003c88:	0407e793          	ori	a5,a5,64
80003c8c:	00f406a3          	sb	a5,13(s0)
80003c90:	cb5ff0ef          	jal	ra,80003944 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003c94:	6c090513          	addi	a0,s2,1728
80003c98:	1ec010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80003c9c:	02051e63          	bnez	a0,80003cd8 <z_add_thread_to_ready_q+0x14c>
80003ca0:	80007437          	lui	s0,0x80007
80003ca4:	800075b7          	lui	a1,0x80007
80003ca8:	80007537          	lui	a0,0x80007
80003cac:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003cb0:	06100693          	li	a3,97
80003cb4:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003cb8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003cbc:	929fe0ef          	jal	ra,800025e4 <printk>
80003cc0:	80007537          	lui	a0,0x80007
80003cc4:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003cc8:	91dfe0ef          	jal	ra,800025e4 <printk>
80003ccc:	06100593          	li	a1,97
80003cd0:	f2c40513          	addi	a0,s0,-212
80003cd4:	94dfe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003cd8:	3004a4f3          	csrrs	s1,mstatus,s1
}
80003cdc:	01c12083          	lw	ra,28(sp)
80003ce0:	01812403          	lw	s0,24(sp)
80003ce4:	01412483          	lw	s1,20(sp)
80003ce8:	01012903          	lw	s2,16(sp)
80003cec:	00c12983          	lw	s3,12(sp)
80003cf0:	02010113          	addi	sp,sp,32
80003cf4:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003cf8:	00f60663          	beq	a2,a5,80003d04 <z_add_thread_to_ready_q+0x178>
80003cfc:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003d00:	f60792e3          	bnez	a5,80003c64 <z_add_thread_to_ready_q+0xd8>
	node->prev = list->tail;
80003d04:	00c42223          	sw	a2,4(s0)
	list->tail->next = node;
80003d08:	02872783          	lw	a5,40(a4)
	node->next = list;
80003d0c:	00d42023          	sw	a3,0(s0)
	list->tail->next = node;
80003d10:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80003d14:	02872423          	sw	s0,40(a4)
80003d18:	f69ff06f          	j	80003c80 <z_add_thread_to_ready_q+0xf4>

80003d1c <z_thread_timeout>:
	if (th->base.pended_on != NULL) {
80003d1c:	ff052783          	lw	a5,-16(a0)
{
80003d20:	fe010113          	addi	sp,sp,-32
80003d24:	00812c23          	sw	s0,24(sp)
80003d28:	01312623          	sw	s3,12(sp)
80003d2c:	00112e23          	sw	ra,28(sp)
80003d30:	00912a23          	sw	s1,20(sp)
80003d34:	01212823          	sw	s2,16(sp)
80003d38:	01412423          	sw	s4,8(sp)
80003d3c:	00050413          	mv	s0,a0
	struct k_thread *th = CONTAINER_OF(to, struct k_thread, base.timeout);
80003d40:	fe850993          	addi	s3,a0,-24
	if (th->base.pended_on != NULL) {
80003d44:	0c078463          	beqz	a5,80003e0c <z_thread_timeout+0xf0>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003d48:	00800493          	li	s1,8
80003d4c:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003d50:	80007937          	lui	s2,0x80007
80003d54:	6c090513          	addi	a0,s2,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003d58:	0084f493          	andi	s1,s1,8
80003d5c:	100010ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003d60:	02051e63          	bnez	a0,80003d9c <z_thread_timeout+0x80>
80003d64:	80007a37          	lui	s4,0x80007
80003d68:	800075b7          	lui	a1,0x80007
80003d6c:	80007537          	lui	a0,0x80007
80003d70:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003d74:	04e00693          	li	a3,78
80003d78:	f2ca0613          	addi	a2,s4,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003d7c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003d80:	865fe0ef          	jal	ra,800025e4 <printk>
80003d84:	80007537          	lui	a0,0x80007
80003d88:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80003d8c:	859fe0ef          	jal	ra,800025e4 <printk>
80003d90:	04e00593          	li	a1,78
80003d94:	f2ca0513          	addi	a0,s4,-212
80003d98:	889fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80003d9c:	6c090513          	addi	a0,s2,1728
80003da0:	114010ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80003da4:	ff040513          	addi	a0,s0,-16
80003da8:	d40ff0ef          	jal	ra,800032e8 <pended_on.isra.15>
80003dac:	00098593          	mv	a1,s3
80003db0:	b09ff0ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80003db4:	ff544783          	lbu	a5,-11(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003db8:	6c090513          	addi	a0,s2,1728
80003dbc:	ffd7f793          	andi	a5,a5,-3
80003dc0:	fef40aa3          	sb	a5,-11(s0)
80003dc4:	0c0010ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80003dc8:	02051e63          	bnez	a0,80003e04 <z_thread_timeout+0xe8>
80003dcc:	80007937          	lui	s2,0x80007
80003dd0:	800075b7          	lui	a1,0x80007
80003dd4:	80007537          	lui	a0,0x80007
80003dd8:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003ddc:	06100693          	li	a3,97
80003de0:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003de4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003de8:	ffcfe0ef          	jal	ra,800025e4 <printk>
80003dec:	80007537          	lui	a0,0x80007
80003df0:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003df4:	ff0fe0ef          	jal	ra,800025e4 <printk>
80003df8:	06100593          	li	a1,97
80003dfc:	f2c90513          	addi	a0,s2,-212
80003e00:	821fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003e04:	3004a4f3          	csrrs	s1,mstatus,s1
	thread->base.pended_on = NULL;
80003e08:	fe042823          	sw	zero,-16(s0)
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003e0c:	ff544783          	lbu	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003e10:	00098513          	mv	a0,s3
	thread->base.thread_state &= ~_THREAD_SUSPENDED;
80003e14:	feb7f793          	andi	a5,a5,-21
80003e18:	fef40aa3          	sb	a5,-11(s0)
	if (z_is_thread_ready(thread)) {
80003e1c:	c78ff0ef          	jal	ra,80003294 <z_is_thread_ready>
80003e20:	02050463          	beqz	a0,80003e48 <z_thread_timeout+0x12c>
}
80003e24:	01812403          	lw	s0,24(sp)
80003e28:	01c12083          	lw	ra,28(sp)
80003e2c:	01412483          	lw	s1,20(sp)
80003e30:	01012903          	lw	s2,16(sp)
80003e34:	00812a03          	lw	s4,8(sp)
		z_add_thread_to_ready_q(thread);
80003e38:	00098513          	mv	a0,s3
80003e3c:	00c12983          	lw	s3,12(sp)
80003e40:	02010113          	addi	sp,sp,32
80003e44:	d49ff06f          	j	80003b8c <z_add_thread_to_ready_q>
80003e48:	01c12083          	lw	ra,28(sp)
80003e4c:	01812403          	lw	s0,24(sp)
80003e50:	01412483          	lw	s1,20(sp)
80003e54:	01012903          	lw	s2,16(sp)
80003e58:	00c12983          	lw	s3,12(sp)
80003e5c:	00812a03          	lw	s4,8(sp)
80003e60:	02010113          	addi	sp,sp,32
80003e64:	00008067          	ret

80003e68 <z_move_thread_to_end_of_prio_q>:
{
80003e68:	fe010113          	addi	sp,sp,-32
80003e6c:	00812c23          	sw	s0,24(sp)
80003e70:	01212823          	sw	s2,16(sp)
80003e74:	00112e23          	sw	ra,28(sp)
80003e78:	00912a23          	sw	s1,20(sp)
80003e7c:	01312623          	sw	s3,12(sp)
80003e80:	01412423          	sw	s4,8(sp)
80003e84:	01512223          	sw	s5,4(sp)
80003e88:	00050413          	mv	s0,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80003e8c:	00800913          	li	s2,8
80003e90:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80003e94:	800079b7          	lui	s3,0x80007
80003e98:	6c098513          	addi	a0,s3,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80003e9c:	00897913          	andi	s2,s2,8
80003ea0:	7bd000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80003ea4:	02051e63          	bnez	a0,80003ee0 <z_move_thread_to_end_of_prio_q+0x78>
80003ea8:	800074b7          	lui	s1,0x80007
80003eac:	800075b7          	lui	a1,0x80007
80003eb0:	80007537          	lui	a0,0x80007
80003eb4:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80003eb8:	04e00693          	li	a3,78
80003ebc:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003ec0:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003ec4:	f20fe0ef          	jal	ra,800025e4 <printk>
80003ec8:	80007537          	lui	a0,0x80007
80003ecc:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80003ed0:	f14fe0ef          	jal	ra,800025e4 <printk>
80003ed4:	04e00593          	li	a1,78
80003ed8:	f2c48513          	addi	a0,s1,-212
80003edc:	f44fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80003ee0:	6c098513          	addi	a0,s3,1728
80003ee4:	7d1000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		_priq_run_remove(&_kernel.ready_q.runq, thread);
80003ee8:	800084b7          	lui	s1,0x80008
80003eec:	8c448513          	addi	a0,s1,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80003ef0:	00040593          	mv	a1,s0
80003ef4:	02450513          	addi	a0,a0,36
80003ef8:	9c1ff0ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	return thread == _idle_thread;
80003efc:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
80003f00:	5447a783          	lw	a5,1348(a5) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
80003f04:	80008a37          	lui	s4,0x80008
80003f08:	8c448493          	addi	s1,s1,-1852
80003f0c:	8e8a0a13          	addi	s4,s4,-1816 # 800078e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078e9>
80003f10:	02f41863          	bne	s0,a5,80003f40 <z_move_thread_to_end_of_prio_q+0xd8>
80003f14:	80007ab7          	lui	s5,0x80007
80003f18:	800075b7          	lui	a1,0x80007
80003f1c:	80007537          	lui	a0,0x80007
80003f20:	24058593          	addi	a1,a1,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
80003f24:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003f28:	27600693          	li	a3,630
80003f2c:	1a8a8613          	addi	a2,s5,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80003f30:	eb4fe0ef          	jal	ra,800025e4 <printk>
80003f34:	27600593          	li	a1,630
80003f38:	1a8a8513          	addi	a0,s5,424
80003f3c:	ee4fe0ef          	jal	ra,80002620 <assert_post_action>
	return list->head == list;
80003f40:	0244a783          	lw	a5,36(s1)
80003f44:	0284a703          	lw	a4,40(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80003f48:	0b478e63          	beq	a5,s4,80004004 <z_move_thread_to_end_of_prio_q+0x19c>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80003f4c:	0a078c63          	beqz	a5,80004004 <z_move_thread_to_end_of_prio_q+0x19c>
	if (t1->base.prio < t2->base.prio) {
80003f50:	00e40683          	lb	a3,14(s0)
80003f54:	00e78603          	lb	a2,14(a5)
80003f58:	0ac6d063          	bge	a3,a2,80003ff8 <z_move_thread_to_end_of_prio_q+0x190>
	node->prev = successor->prev;
80003f5c:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80003f60:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80003f64:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80003f68:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80003f6c:	0087a223          	sw	s0,4(a5)
	thread->base.thread_state |= states;
80003f70:	00d44783          	lbu	a5,13(s0)
		update_cache(thread == _current);
80003f74:	0084a503          	lw	a0,8(s1)
80003f78:	0407e793          	ori	a5,a5,64
80003f7c:	40850533          	sub	a0,a0,s0
80003f80:	00153513          	seqz	a0,a0
80003f84:	00f406a3          	sb	a5,13(s0)
80003f88:	9bdff0ef          	jal	ra,80003944 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80003f8c:	6c098513          	addi	a0,s3,1728
80003f90:	6f5000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80003f94:	02051e63          	bnez	a0,80003fd0 <z_move_thread_to_end_of_prio_q+0x168>
80003f98:	80007437          	lui	s0,0x80007
80003f9c:	800075b7          	lui	a1,0x80007
80003fa0:	80007537          	lui	a0,0x80007
80003fa4:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80003fa8:	06100693          	li	a3,97
80003fac:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80003fb0:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80003fb4:	e30fe0ef          	jal	ra,800025e4 <printk>
80003fb8:	80007537          	lui	a0,0x80007
80003fbc:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80003fc0:	e24fe0ef          	jal	ra,800025e4 <printk>
80003fc4:	06100593          	li	a1,97
80003fc8:	f2c40513          	addi	a0,s0,-212
80003fcc:	e54fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80003fd0:	30092973          	csrrs	s2,mstatus,s2
}
80003fd4:	01c12083          	lw	ra,28(sp)
80003fd8:	01812403          	lw	s0,24(sp)
80003fdc:	01412483          	lw	s1,20(sp)
80003fe0:	01012903          	lw	s2,16(sp)
80003fe4:	00c12983          	lw	s3,12(sp)
80003fe8:	00812a03          	lw	s4,8(sp)
80003fec:	00412a83          	lw	s5,4(sp)
80003ff0:	02010113          	addi	sp,sp,32
80003ff4:	00008067          	ret
	return (node == list->tail) ? NULL : node->next;
80003ff8:	00e78663          	beq	a5,a4,80004004 <z_move_thread_to_end_of_prio_q+0x19c>
80003ffc:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004000:	f4079ae3          	bnez	a5,80003f54 <z_move_thread_to_end_of_prio_q+0xec>
	node->prev = list->tail;
80004004:	00e42223          	sw	a4,4(s0)
	list->tail->next = node;
80004008:	0284a783          	lw	a5,40(s1)
	node->next = list;
8000400c:	01442023          	sw	s4,0(s0)
	list->tail->next = node;
80004010:	0087a023          	sw	s0,0(a5)
	list->tail = node;
80004014:	0284a423          	sw	s0,40(s1)
80004018:	f59ff06f          	j	80003f70 <z_move_thread_to_end_of_prio_q+0x108>

8000401c <z_time_slice>:
	if (slice_time && sliceable(_current)) {
8000401c:	800077b7          	lui	a5,0x80007
80004020:	6c87a783          	lw	a5,1736(a5) # 800076c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c9>
80004024:	06078663          	beqz	a5,80004090 <z_time_slice+0x74>
80004028:	800087b7          	lui	a5,0x80008
8000402c:	8c478793          	addi	a5,a5,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004030:	0087a703          	lw	a4,8(a5)
		&& !z_is_thread_timeout_active(t);
80004034:	07f00693          	li	a3,127
80004038:	00e75603          	lhu	a2,14(a4)
8000403c:	04c6ea63          	bltu	a3,a2,80004090 <z_time_slice+0x74>
		&& !z_is_prio_higher(t->base.prio, slice_max_prio)
80004040:	800076b7          	lui	a3,0x80007
80004044:	00e70603          	lb	a2,14(a4)
80004048:	6c46a683          	lw	a3,1732(a3) # 800076c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c5>
8000404c:	04d64263          	blt	a2,a3,80004090 <z_time_slice+0x74>
	return thread == _idle_thread;
80004050:	800076b7          	lui	a3,0x80007
		&& !is_idle(t)
80004054:	5446a683          	lw	a3,1348(a3) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
80004058:	02d70c63          	beq	a4,a3,80004090 <z_time_slice+0x74>
		&& !z_is_thread_timeout_active(t);
8000405c:	01872683          	lw	a3,24(a4)
80004060:	02069863          	bnez	a3,80004090 <z_time_slice+0x74>
		if (ticks >= _current_cpu->slice_ticks) {
80004064:	0107a683          	lw	a3,16(a5)
80004068:	02d54063          	blt	a0,a3,80004088 <z_time_slice+0x6c>
{
8000406c:	ff010113          	addi	sp,sp,-16
			z_move_thread_to_end_of_prio_q(_current);
80004070:	00070513          	mv	a0,a4
{
80004074:	00112623          	sw	ra,12(sp)
			z_move_thread_to_end_of_prio_q(_current);
80004078:	df1ff0ef          	jal	ra,80003e68 <z_move_thread_to_end_of_prio_q>
}
8000407c:	00c12083          	lw	ra,12(sp)
80004080:	01010113          	addi	sp,sp,16
			reset_time_slice();
80004084:	a30ff06f          	j	800032b4 <reset_time_slice>
			_current_cpu->slice_ticks -= ticks;
80004088:	40a686b3          	sub	a3,a3,a0
8000408c:	00d7a823          	sw	a3,16(a5)
80004090:	00008067          	ret

80004094 <z_remove_thread_from_ready_q>:
{
80004094:	fe010113          	addi	sp,sp,-32
80004098:	00812c23          	sw	s0,24(sp)
8000409c:	01312623          	sw	s3,12(sp)
800040a0:	00112e23          	sw	ra,28(sp)
800040a4:	00912a23          	sw	s1,20(sp)
800040a8:	01212823          	sw	s2,16(sp)
800040ac:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800040b0:	00800413          	li	s0,8
800040b4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800040b8:	800074b7          	lui	s1,0x80007
800040bc:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800040c0:	00847413          	andi	s0,s0,8
800040c4:	599000ef          	jal	ra,80004e5c <z_spin_lock_valid>
800040c8:	02051e63          	bnez	a0,80004104 <z_remove_thread_from_ready_q+0x70>
800040cc:	80007937          	lui	s2,0x80007
800040d0:	800075b7          	lui	a1,0x80007
800040d4:	80007537          	lui	a0,0x80007
800040d8:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800040dc:	04e00693          	li	a3,78
800040e0:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800040e4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800040e8:	cfcfe0ef          	jal	ra,800025e4 <printk>
800040ec:	80007537          	lui	a0,0x80007
800040f0:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800040f4:	cf0fe0ef          	jal	ra,800025e4 <printk>
800040f8:	04e00593          	li	a1,78
800040fc:	f2c90513          	addi	a0,s2,-212
80004100:	d20fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004104:	6c048513          	addi	a0,s1,1728
80004108:	5ad000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		if (z_is_thread_queued(thread)) {
8000410c:	00d9c783          	lbu	a5,13(s3)
80004110:	80008937          	lui	s2,0x80008
80004114:	8c490913          	addi	s2,s2,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004118:	0407f793          	andi	a5,a5,64
8000411c:	00078e63          	beqz	a5,80004138 <z_remove_thread_from_ready_q+0xa4>
			_priq_run_remove(&_kernel.ready_q.runq, thread);
80004120:	00098593          	mv	a1,s3
80004124:	02490513          	addi	a0,s2,36
80004128:	f90ff0ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~states;
8000412c:	00d9c783          	lbu	a5,13(s3)
80004130:	fbf7f793          	andi	a5,a5,-65
80004134:	00f986a3          	sb	a5,13(s3)
		update_cache(thread == _current);
80004138:	00892503          	lw	a0,8(s2)
8000413c:	41350533          	sub	a0,a0,s3
80004140:	00153513          	seqz	a0,a0
80004144:	801ff0ef          	jal	ra,80003944 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004148:	6c048513          	addi	a0,s1,1728
8000414c:	539000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004150:	02051e63          	bnez	a0,8000418c <z_remove_thread_from_ready_q+0xf8>
80004154:	800074b7          	lui	s1,0x80007
80004158:	800075b7          	lui	a1,0x80007
8000415c:	80007537          	lui	a0,0x80007
80004160:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80004164:	06100693          	li	a3,97
80004168:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000416c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004170:	c74fe0ef          	jal	ra,800025e4 <printk>
80004174:	80007537          	lui	a0,0x80007
80004178:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
8000417c:	c68fe0ef          	jal	ra,800025e4 <printk>
80004180:	06100593          	li	a1,97
80004184:	f2c48513          	addi	a0,s1,-212
80004188:	c98fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000418c:	30042473          	csrrs	s0,mstatus,s0
}
80004190:	01c12083          	lw	ra,28(sp)
80004194:	01812403          	lw	s0,24(sp)
80004198:	01412483          	lw	s1,20(sp)
8000419c:	01012903          	lw	s2,16(sp)
800041a0:	00c12983          	lw	s3,12(sp)
800041a4:	02010113          	addi	sp,sp,32
800041a8:	00008067          	ret

800041ac <pend>:
{
800041ac:	fe010113          	addi	sp,sp,-32
800041b0:	00812c23          	sw	s0,24(sp)
800041b4:	00912a23          	sw	s1,20(sp)
800041b8:	00050413          	mv	s0,a0
800041bc:	01212823          	sw	s2,16(sp)
800041c0:	00112e23          	sw	ra,28(sp)
800041c4:	01312623          	sw	s3,12(sp)
800041c8:	00058493          	mv	s1,a1
800041cc:	00060913          	mv	s2,a2
	z_remove_thread_from_ready_q(thread);
800041d0:	ec5ff0ef          	jal	ra,80004094 <z_remove_thread_from_ready_q>
	thread->base.thread_state |= _THREAD_PENDING;
800041d4:	00d44783          	lbu	a5,13(s0)
800041d8:	0027e793          	ori	a5,a5,2
800041dc:	00f406a3          	sb	a5,13(s0)
	if (wait_q != NULL) {
800041e0:	06048663          	beqz	s1,8000424c <pend+0xa0>
	return thread == _idle_thread;
800041e4:	800077b7          	lui	a5,0x80007
	__ASSERT_NO_MSG(!is_idle(thread));
800041e8:	5447a783          	lw	a5,1348(a5) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
		thread->base.pended_on = wait_q;
800041ec:	00942423          	sw	s1,8(s0)
	__ASSERT_NO_MSG(!is_idle(thread));
800041f0:	02f41863          	bne	s0,a5,80004220 <pend+0x74>
800041f4:	800079b7          	lui	s3,0x80007
800041f8:	800075b7          	lui	a1,0x80007
800041fc:	80007537          	lui	a0,0x80007
80004200:	24058593          	addi	a1,a1,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
80004204:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004208:	27600693          	li	a3,630
8000420c:	1a898613          	addi	a2,s3,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80004210:	bd4fe0ef          	jal	ra,800025e4 <printk>
80004214:	27600593          	li	a1,630
80004218:	1a898513          	addi	a0,s3,424
8000421c:	c04fe0ef          	jal	ra,80002620 <assert_post_action>
	return list->head == list;
80004220:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004224:	06f48c63          	beq	s1,a5,8000429c <pend+0xf0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004228:	06078a63          	beqz	a5,8000429c <pend+0xf0>
	if (t1->base.prio < t2->base.prio) {
8000422c:	00e40703          	lb	a4,14(s0)
80004230:	00e78683          	lb	a3,14(a5)
80004234:	04d75c63          	bge	a4,a3,8000428c <pend+0xe0>
	node->prev = successor->prev;
80004238:	0047a703          	lw	a4,4(a5)
	node->next = successor;
8000423c:	00f42023          	sw	a5,0(s0)
	node->prev = successor->prev;
80004240:	00e42223          	sw	a4,4(s0)
	successor->prev->next = node;
80004244:	00872023          	sw	s0,0(a4)
	successor->prev = node;
80004248:	0087a223          	sw	s0,4(a5)
	if (timeout != K_FOREVER) {
8000424c:	fff00793          	li	a5,-1
80004250:	06f90463          	beq	s2,a5,800042b8 <pend+0x10c>
80004254:	00a00593          	li	a1,10
80004258:	00990513          	addi	a0,s2,9
8000425c:	edcfc0ef          	jal	ra,80000938 <__divsi3>

extern void z_thread_timeout(struct _timeout *to);

static inline void z_add_thread_timeout(struct k_thread *th, s32_t ticks)
{
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004260:	00150613          	addi	a2,a0,1
80004264:	01840513          	addi	a0,s0,24
}
80004268:	01812403          	lw	s0,24(sp)
8000426c:	01c12083          	lw	ra,28(sp)
80004270:	01412483          	lw	s1,20(sp)
80004274:	01012903          	lw	s2,16(sp)
80004278:	00c12983          	lw	s3,12(sp)
8000427c:	800045b7          	lui	a1,0x80004
80004280:	d1c58593          	addi	a1,a1,-740 # 80003d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003d1d>
80004284:	02010113          	addi	sp,sp,32
80004288:	11c0106f          	j	800053a4 <z_add_timeout>
	return (node == list->tail) ? NULL : node->next;
8000428c:	0044a683          	lw	a3,4(s1)
80004290:	00d78663          	beq	a5,a3,8000429c <pend+0xf0>
80004294:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004298:	f8079ce3          	bnez	a5,80004230 <pend+0x84>
	node->prev = list->tail;
8000429c:	0044a783          	lw	a5,4(s1)
	node->next = list;
800042a0:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800042a4:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800042a8:	0044a783          	lw	a5,4(s1)
800042ac:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800042b0:	0084a223          	sw	s0,4(s1)
800042b4:	f99ff06f          	j	8000424c <pend+0xa0>
}
800042b8:	01c12083          	lw	ra,28(sp)
800042bc:	01812403          	lw	s0,24(sp)
800042c0:	01412483          	lw	s1,20(sp)
800042c4:	01012903          	lw	s2,16(sp)
800042c8:	00c12983          	lw	s3,12(sp)
800042cc:	02010113          	addi	sp,sp,32
800042d0:	00008067          	ret

800042d4 <z_pend_curr>:
{
800042d4:	ff010113          	addi	sp,sp,-16
	pend(_current, wait_q, timeout);
800042d8:	800087b7          	lui	a5,0x80008
{
800042dc:	00812423          	sw	s0,8(sp)
800042e0:	00050413          	mv	s0,a0
	pend(_current, wait_q, timeout);
800042e4:	8cc7a503          	lw	a0,-1844(a5) # 800078cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078cd>
{
800042e8:	00912223          	sw	s1,4(sp)
800042ec:	00058493          	mv	s1,a1
800042f0:	00060593          	mv	a1,a2
	pend(_current, wait_q, timeout);
800042f4:	00068613          	mv	a2,a3
{
800042f8:	00112623          	sw	ra,12(sp)
	pend(_current, wait_q, timeout);
800042fc:	eb1ff0ef          	jal	ra,800041ac <pend>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004300:	00040513          	mv	a0,s0
80004304:	381000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004308:	02051e63          	bnez	a0,80004344 <z_pend_curr+0x70>
8000430c:	80007437          	lui	s0,0x80007
80004310:	800075b7          	lui	a1,0x80007
80004314:	80007537          	lui	a0,0x80007
80004318:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
8000431c:	07800693          	li	a3,120
80004320:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004324:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004328:	abcfe0ef          	jal	ra,800025e4 <printk>
8000432c:	80007537          	lui	a0,0x80007
80004330:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80004334:	ab0fe0ef          	jal	ra,800025e4 <printk>
80004338:	07800593          	li	a1,120
8000433c:	f2c40513          	addi	a0,s0,-212
80004340:	ae0fe0ef          	jal	ra,80002620 <assert_post_action>
}
80004344:	00812403          	lw	s0,8(sp)
80004348:	00c12083          	lw	ra,12(sp)
8000434c:	00048513          	mv	a0,s1
80004350:	00412483          	lw	s1,4(sp)
80004354:	01010113          	addi	sp,sp,16
80004358:	ed1fb06f          	j	80000228 <__swap>

8000435c <z_unpend_first_thread>:
{
8000435c:	fe010113          	addi	sp,sp,-32
80004360:	01212823          	sw	s2,16(sp)
80004364:	01312623          	sw	s3,12(sp)
80004368:	00112e23          	sw	ra,28(sp)
8000436c:	00812c23          	sw	s0,24(sp)
80004370:	00912a23          	sw	s1,20(sp)
80004374:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004378:	00800913          	li	s2,8
8000437c:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004380:	800074b7          	lui	s1,0x80007
80004384:	6c048513          	addi	a0,s1,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004388:	00897913          	andi	s2,s2,8
8000438c:	2d1000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004390:	02051e63          	bnez	a0,800043cc <z_unpend_first_thread+0x70>
80004394:	80007437          	lui	s0,0x80007
80004398:	800075b7          	lui	a1,0x80007
8000439c:	80007537          	lui	a0,0x80007
800043a0:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800043a4:	04e00693          	li	a3,78
800043a8:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800043ac:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800043b0:	a34fe0ef          	jal	ra,800025e4 <printk>
800043b4:	80007537          	lui	a0,0x80007
800043b8:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800043bc:	a28fe0ef          	jal	ra,800025e4 <printk>
800043c0:	04e00593          	li	a1,78
800043c4:	f2c40513          	addi	a0,s0,-212
800043c8:	a58fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800043cc:	6c048513          	addi	a0,s1,1728
800043d0:	2e5000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		ret = _priq_wait_best(&wait_q->waitq);
800043d4:	00098513          	mv	a0,s3
800043d8:	d58ff0ef          	jal	ra,80003930 <z_priq_dumb_best>
800043dc:	00050413          	mv	s0,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800043e0:	6c048513          	addi	a0,s1,1728
800043e4:	2a1000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800043e8:	02051e63          	bnez	a0,80004424 <z_unpend_first_thread+0xc8>
800043ec:	800079b7          	lui	s3,0x80007
800043f0:	800075b7          	lui	a1,0x80007
800043f4:	80007537          	lui	a0,0x80007
800043f8:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800043fc:	06100693          	li	a3,97
80004400:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004404:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004408:	9dcfe0ef          	jal	ra,800025e4 <printk>
8000440c:	80007537          	lui	a0,0x80007
80004410:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80004414:	9d0fe0ef          	jal	ra,800025e4 <printk>
80004418:	06100593          	li	a1,97
8000441c:	f2c98513          	addi	a0,s3,-212
80004420:	a00fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004424:	30092973          	csrrs	s2,mstatus,s2

static inline struct k_thread *z_unpend1_no_timeout(_wait_q_t *wait_q)
{
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);

	if (thread != NULL) {
80004428:	0c040663          	beqz	s0,800044f4 <z_unpend_first_thread+0x198>
	__asm__ volatile ("csrrc %0, mstatus, %1"
8000442c:	00800913          	li	s2,8
80004430:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004434:	6c048513          	addi	a0,s1,1728
	key = (mstatus & SOC_MSTATUS_IEN);
80004438:	00897913          	andi	s2,s2,8
8000443c:	221000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004440:	02051e63          	bnez	a0,8000447c <z_unpend_first_thread+0x120>
80004444:	800079b7          	lui	s3,0x80007
80004448:	800075b7          	lui	a1,0x80007
8000444c:	80007537          	lui	a0,0x80007
80004450:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80004454:	04e00693          	li	a3,78
80004458:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000445c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004460:	984fe0ef          	jal	ra,800025e4 <printk>
80004464:	80007537          	lui	a0,0x80007
80004468:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
8000446c:	978fe0ef          	jal	ra,800025e4 <printk>
80004470:	04e00593          	li	a1,78
80004474:	f2c98513          	addi	a0,s3,-212
80004478:	9a8fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
8000447c:	6c048513          	addi	a0,s1,1728
80004480:	235000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		_priq_wait_remove(&pended_on(thread)->waitq, thread);
80004484:	00840513          	addi	a0,s0,8
80004488:	e61fe0ef          	jal	ra,800032e8 <pended_on.isra.15>
8000448c:	00040593          	mv	a1,s0
80004490:	c28ff0ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	thread->base.thread_state &= ~_THREAD_PENDING;
80004494:	00d44783          	lbu	a5,13(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004498:	6c048513          	addi	a0,s1,1728
8000449c:	ffd7f793          	andi	a5,a5,-3
800044a0:	00f406a3          	sb	a5,13(s0)
800044a4:	1e1000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800044a8:	02051e63          	bnez	a0,800044e4 <z_unpend_first_thread+0x188>
800044ac:	800074b7          	lui	s1,0x80007
800044b0:	800075b7          	lui	a1,0x80007
800044b4:	80007537          	lui	a0,0x80007
800044b8:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800044bc:	06100693          	li	a3,97
800044c0:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800044c4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800044c8:	91cfe0ef          	jal	ra,800025e4 <printk>
800044cc:	80007537          	lui	a0,0x80007
800044d0:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800044d4:	910fe0ef          	jal	ra,800025e4 <printk>
800044d8:	06100593          	li	a1,97
800044dc:	f2c48513          	addi	a0,s1,-212
800044e0:	940fe0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800044e4:	30092973          	csrrs	s2,mstatus,s2
	thread->base.pended_on = NULL;
800044e8:	00042423          	sw	zero,8(s0)
}

static inline int z_abort_thread_timeout(struct k_thread *thread)
{
	return z_abort_timeout(&thread->base.timeout);
800044ec:	01840513          	addi	a0,s0,24
800044f0:	0e0010ef          	jal	ra,800055d0 <z_abort_timeout>
}
800044f4:	00040513          	mv	a0,s0
800044f8:	01c12083          	lw	ra,28(sp)
800044fc:	01812403          	lw	s0,24(sp)
80004500:	01412483          	lw	s1,20(sp)
80004504:	01012903          	lw	s2,16(sp)
80004508:	00c12983          	lw	s3,12(sp)
8000450c:	02010113          	addi	sp,sp,32
80004510:	00008067          	ret

80004514 <z_sched_init>:
	list->head = (sys_dnode_t *)list;
80004514:	800087b7          	lui	a5,0x80008
80004518:	8c478793          	addi	a5,a5,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
8000451c:	02478713          	addi	a4,a5,36
80004520:	02e7a223          	sw	a4,36(a5)
	list->tail = (sys_dnode_t *)list;
80004524:	02e7a423          	sw	a4,40(a5)
		sys_dlist_init(&_kernel.ready_q.runq.queues[i]);
	}
#endif

#ifdef CONFIG_TIMESLICING
	k_sched_time_slice_set(CONFIG_TIMESLICE_SIZE,
80004528:	00000593          	li	a1,0
8000452c:	00000513          	li	a0,0
80004530:	e19fe06f          	j	80003348 <k_sched_time_slice_set>

80004534 <z_impl_k_yield>:
}
#endif
#endif

void z_impl_k_yield(void)
{
80004534:	fe010113          	addi	sp,sp,-32
80004538:	00812c23          	sw	s0,24(sp)
	__ASSERT(!z_is_in_isr(), "");
8000453c:	80008437          	lui	s0,0x80008
80004540:	8c442783          	lw	a5,-1852(s0) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80004544:	00112e23          	sw	ra,28(sp)
80004548:	00912a23          	sw	s1,20(sp)
8000454c:	01212823          	sw	s2,16(sp)
80004550:	01312623          	sw	s3,12(sp)
80004554:	01412423          	sw	s4,8(sp)
80004558:	01512223          	sw	s5,4(sp)
8000455c:	8c440413          	addi	s0,s0,-1852
	__ASSERT(!z_is_in_isr(), "");
80004560:	02078e63          	beqz	a5,8000459c <z_impl_k_yield+0x68>
80004564:	800074b7          	lui	s1,0x80007
80004568:	800075b7          	lui	a1,0x80007
8000456c:	80007537          	lui	a0,0x80007
80004570:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
80004574:	37e00693          	li	a3,894
80004578:	1a848613          	addi	a2,s1,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
8000457c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004580:	864fe0ef          	jal	ra,800025e4 <printk>
80004584:	80007537          	lui	a0,0x80007
80004588:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
8000458c:	858fe0ef          	jal	ra,800025e4 <printk>
80004590:	37e00593          	li	a1,894
80004594:	1a848513          	addi	a0,s1,424
80004598:	888fe0ef          	jal	ra,80002620 <assert_post_action>
	return thread == _idle_thread;
8000459c:	800077b7          	lui	a5,0x80007

	if (!is_idle(_current)) {
800045a0:	00842683          	lw	a3,8(s0)
800045a4:	5447a703          	lw	a4,1348(a5) # 80007544 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007545>
800045a8:	00078a13          	mv	s4,a5
800045ac:	12e68663          	beq	a3,a4,800046d8 <z_impl_k_yield+0x1a4>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800045b0:	00800913          	li	s2,8
800045b4:	30093973          	csrrc	s2,mstatus,s2
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800045b8:	800079b7          	lui	s3,0x80007
800045bc:	6c098513          	addi	a0,s3,1728 # 800076c0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076c1>
	key = (mstatus & SOC_MSTATUS_IEN);
800045c0:	00897913          	andi	s2,s2,8
800045c4:	099000ef          	jal	ra,80004e5c <z_spin_lock_valid>
800045c8:	02051e63          	bnez	a0,80004604 <z_impl_k_yield+0xd0>
800045cc:	800074b7          	lui	s1,0x80007
800045d0:	800075b7          	lui	a1,0x80007
800045d4:	80007537          	lui	a0,0x80007
800045d8:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800045dc:	04e00693          	li	a3,78
800045e0:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800045e4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800045e8:	ffdfd0ef          	jal	ra,800025e4 <printk>
800045ec:	80007537          	lui	a0,0x80007
800045f0:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
800045f4:	ff1fd0ef          	jal	ra,800025e4 <printk>
800045f8:	04e00593          	li	a1,78
800045fc:	f2c48513          	addi	a0,s1,-212
80004600:	820fe0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004604:	6c098513          	addi	a0,s3,1728
80004608:	0ad000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
		LOCKED(&sched_spinlock) {
			if (!IS_ENABLED(CONFIG_SMP) ||
			    z_is_thread_queued(_current)) {
				_priq_run_remove(&_kernel.ready_q.runq,
8000460c:	00842583          	lw	a1,8(s0)
80004610:	02440513          	addi	a0,s0,36
80004614:	aa4ff0ef          	jal	ra,800038b8 <z_priq_dumb_remove>
	__ASSERT_NO_MSG(!is_idle(thread));
80004618:	544a2783          	lw	a5,1348(s4)
						 _current);
				_priq_run_add(&_kernel.ready_q.runq,
8000461c:	00842483          	lw	s1,8(s0)
	return thread == _idle_thread;
80004620:	80008a37          	lui	s4,0x80008
80004624:	8e8a0a13          	addi	s4,s4,-1816 # 800078e8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078e9>
	__ASSERT_NO_MSG(!is_idle(thread));
80004628:	02f49863          	bne	s1,a5,80004658 <z_impl_k_yield+0x124>
8000462c:	80007ab7          	lui	s5,0x80007
80004630:	800075b7          	lui	a1,0x80007
80004634:	80007537          	lui	a0,0x80007
80004638:	24058593          	addi	a1,a1,576 # 80007240 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007241>
8000463c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004640:	27600693          	li	a3,630
80004644:	1a8a8613          	addi	a2,s5,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80004648:	f9dfd0ef          	jal	ra,800025e4 <printk>
8000464c:	27600593          	li	a1,630
80004650:	1a8a8513          	addi	a0,s5,424
80004654:	fcdfd0ef          	jal	ra,80002620 <assert_post_action>
	return list->head == list;
80004658:	02442783          	lw	a5,36(s0)
8000465c:	02842703          	lw	a4,40(s0)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80004660:	0b478a63          	beq	a5,s4,80004714 <z_impl_k_yield+0x1e0>
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004664:	0a078863          	beqz	a5,80004714 <z_impl_k_yield+0x1e0>
	if (t1->base.prio < t2->base.prio) {
80004668:	00e48683          	lb	a3,14(s1)
8000466c:	00e78603          	lb	a2,14(a5)
80004670:	08c6dc63          	bge	a3,a2,80004708 <z_impl_k_yield+0x1d4>
	node->prev = successor->prev;
80004674:	0047a703          	lw	a4,4(a5)
	node->next = successor;
80004678:	00f4a023          	sw	a5,0(s1)
	node->prev = successor->prev;
8000467c:	00e4a223          	sw	a4,4(s1)
	successor->prev->next = node;
80004680:	00972023          	sw	s1,0(a4)
	successor->prev = node;
80004684:	0097a223          	sw	s1,4(a5)
					      _current);
			}
			update_cache(1);
80004688:	00100513          	li	a0,1
8000468c:	ab8ff0ef          	jal	ra,80003944 <update_cache>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004690:	6c098513          	addi	a0,s3,1728
80004694:	7f0000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004698:	02051e63          	bnez	a0,800046d4 <z_impl_k_yield+0x1a0>
8000469c:	80007437          	lui	s0,0x80007
800046a0:	800075b7          	lui	a1,0x80007
800046a4:	80007537          	lui	a0,0x80007
800046a8:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800046ac:	06100693          	li	a3,97
800046b0:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800046b4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800046b8:	f2dfd0ef          	jal	ra,800025e4 <printk>
800046bc:	80007537          	lui	a0,0x80007
800046c0:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800046c4:	f21fd0ef          	jal	ra,800025e4 <printk>
800046c8:	06100593          	li	a1,97
800046cc:	f2c40513          	addi	a0,s0,-212
800046d0:	f51fd0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800046d4:	30092973          	csrrs	s2,mstatus,s2
	__asm__ volatile ("csrrc %0, mstatus, %1"
800046d8:	00800513          	li	a0,8
800046dc:	30053573          	csrrc	a0,mstatus,a0
		}
	}
	z_swap_unlocked();
}
800046e0:	01812403          	lw	s0,24(sp)
800046e4:	01c12083          	lw	ra,28(sp)
800046e8:	01412483          	lw	s1,20(sp)
800046ec:	01012903          	lw	s2,16(sp)
800046f0:	00c12983          	lw	s3,12(sp)
800046f4:	00812a03          	lw	s4,8(sp)
800046f8:	00412a83          	lw	s5,4(sp)
800046fc:	00857513          	andi	a0,a0,8
80004700:	02010113          	addi	sp,sp,32
80004704:	b25fb06f          	j	80000228 <__swap>
	return (node == list->tail) ? NULL : node->next;
80004708:	00e78663          	beq	a5,a4,80004714 <z_impl_k_yield+0x1e0>
8000470c:	0007a783          	lw	a5,0(a5)
	SYS_DLIST_FOR_EACH_CONTAINER(pq, t, base.qnode_dlist) {
80004710:	f4079ee3          	bnez	a5,8000466c <z_impl_k_yield+0x138>
	node->prev = list->tail;
80004714:	00e4a223          	sw	a4,4(s1)
	list->tail->next = node;
80004718:	02842783          	lw	a5,40(s0)
	node->next = list;
8000471c:	0144a023          	sw	s4,0(s1)
	list->tail->next = node;
80004720:	0097a023          	sw	s1,0(a5)
	list->tail = node;
80004724:	02942423          	sw	s1,40(s0)
80004728:	f61ff06f          	j	80004688 <z_impl_k_yield+0x154>

8000472c <z_impl_k_sleep>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER0_SIMPLE_VOID(k_yield);
#endif

s32_t z_impl_k_sleep(s32_t duration)
{
8000472c:	fd010113          	addi	sp,sp,-48
80004730:	02812423          	sw	s0,40(sp)
#ifdef CONFIG_MULTITHREADING
	u32_t expected_wakeup_time;
	s32_t ticks;

	__ASSERT(!z_is_in_isr(), "");
80004734:	80008437          	lui	s0,0x80008
80004738:	8c442783          	lw	a5,-1852(s0) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
8000473c:	02912223          	sw	s1,36(sp)
80004740:	02112623          	sw	ra,44(sp)
80004744:	03212023          	sw	s2,32(sp)
80004748:	01312e23          	sw	s3,28(sp)
8000474c:	01412c23          	sw	s4,24(sp)
80004750:	00050493          	mv	s1,a0
80004754:	8c440413          	addi	s0,s0,-1852
	__ASSERT(!z_is_in_isr(), "");
80004758:	02078e63          	beqz	a5,80004794 <z_impl_k_sleep+0x68>
8000475c:	80007937          	lui	s2,0x80007
80004760:	800075b7          	lui	a1,0x80007
80004764:	80007537          	lui	a0,0x80007
80004768:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
8000476c:	39900693          	li	a3,921
80004770:	1a890613          	addi	a2,s2,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
80004774:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004778:	e6dfd0ef          	jal	ra,800025e4 <printk>
8000477c:	80007537          	lui	a0,0x80007
80004780:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80004784:	e61fd0ef          	jal	ra,800025e4 <printk>
80004788:	39900593          	li	a1,921
8000478c:	1a890513          	addi	a0,s2,424
80004790:	e91fd0ef          	jal	ra,80002620 <assert_post_action>
	__ASSERT(duration != K_FOREVER, "");
80004794:	fff00793          	li	a5,-1
80004798:	1af49463          	bne	s1,a5,80004940 <z_impl_k_sleep+0x214>
8000479c:	80007937          	lui	s2,0x80007
800047a0:	800075b7          	lui	a1,0x80007
800047a4:	80007537          	lui	a0,0x80007
800047a8:	1f458593          	addi	a1,a1,500 # 800071f4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071f5>
800047ac:	39a00693          	li	a3,922
800047b0:	1a890613          	addi	a2,s2,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
800047b4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800047b8:	e2dfd0ef          	jal	ra,800025e4 <printk>
800047bc:	80007537          	lui	a0,0x80007
800047c0:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800047c4:	e21fd0ef          	jal	ra,800025e4 <printk>
800047c8:	39a00593          	li	a1,922
800047cc:	1a890513          	addi	a0,s2,424
800047d0:	e51fd0ef          	jal	ra,80002620 <assert_post_action>
800047d4:	00a00593          	li	a1,10
800047d8:	00948513          	addi	a0,s1,9
800047dc:	95cfc0ef          	jal	ra,80000938 <__divsi3>
	if (duration == 0) {
		k_yield();
		return 0;
	}

	ticks = _TICK_ALIGN + z_ms_to_ticks(duration);
800047e0:	00150993          	addi	s3,a0,1
	expected_wakeup_time = ticks + z_tick_get_32();
800047e4:	550010ef          	jal	ra,80005d34 <z_tick_get_32>
800047e8:	00a98933          	add	s2,s3,a0

	/* Spinlock purely for local interrupt locking to prevent us
	 * from being interrupted while _current is in an intermediate
	 * state.  Should unify this implementation with pend().
	 */
	struct k_spinlock local_lock = {};
800047ec:	00012623          	sw	zero,12(sp)
800047f0:	00800493          	li	s1,8
800047f4:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800047f8:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
800047fc:	0084f493          	andi	s1,s1,8
80004800:	65c000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004804:	02051e63          	bnez	a0,80004840 <z_impl_k_sleep+0x114>
80004808:	80007a37          	lui	s4,0x80007
8000480c:	800075b7          	lui	a1,0x80007
80004810:	80007537          	lui	a0,0x80007
80004814:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80004818:	04e00693          	li	a3,78
8000481c:	f2ca0613          	addi	a2,s4,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004820:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004824:	dc1fd0ef          	jal	ra,800025e4 <printk>
80004828:	80007537          	lui	a0,0x80007
8000482c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80004830:	db5fd0ef          	jal	ra,800025e4 <printk>
80004834:	04e00593          	li	a1,78
80004838:	f2ca0513          	addi	a0,s4,-212
8000483c:	de5fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004840:	00c10513          	addi	a0,sp,12
80004844:	670000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&local_lock);

#if defined(CONFIG_TIMESLICING) && defined(CONFIG_SWAP_NONATOMIC)
	pending_current = _current;
#endif
	z_remove_thread_from_ready_q(_current);
80004848:	00842503          	lw	a0,8(s0)
8000484c:	849ff0ef          	jal	ra,80004094 <z_remove_thread_from_ready_q>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80004850:	00842503          	lw	a0,8(s0)
80004854:	800045b7          	lui	a1,0x80004
80004858:	00098613          	mv	a2,s3
8000485c:	01850513          	addi	a0,a0,24
80004860:	d1c58593          	addi	a1,a1,-740 # 80003d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003d1d>
80004864:	341000ef          	jal	ra,800053a4 <z_add_timeout>
	z_add_thread_timeout(_current, ticks);
	z_mark_thread_as_suspended(_current);
80004868:	00842703          	lw	a4,8(s0)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000486c:	00c10513          	addi	a0,sp,12
	thread->base.thread_state |= _THREAD_SUSPENDED;
80004870:	00d74783          	lbu	a5,13(a4)
80004874:	0107e793          	ori	a5,a5,16
80004878:	00f706a3          	sb	a5,13(a4)
8000487c:	608000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004880:	02051e63          	bnez	a0,800048bc <z_impl_k_sleep+0x190>
80004884:	800079b7          	lui	s3,0x80007
80004888:	800075b7          	lui	a1,0x80007
8000488c:	80007537          	lui	a0,0x80007
80004890:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80004894:	07800693          	li	a3,120
80004898:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000489c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800048a0:	d45fd0ef          	jal	ra,800025e4 <printk>
800048a4:	80007537          	lui	a0,0x80007
800048a8:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800048ac:	d39fd0ef          	jal	ra,800025e4 <printk>
800048b0:	07800593          	li	a1,120
800048b4:	f2c98513          	addi	a0,s3,-212
800048b8:	d69fd0ef          	jal	ra,80002620 <assert_post_action>
800048bc:	00048513          	mv	a0,s1
800048c0:	969fb0ef          	jal	ra,80000228 <__swap>

	(void)z_swap(&local_lock, key);

	__ASSERT(!z_is_thread_state_set(_current, _THREAD_SUSPENDED), "");
800048c4:	00842783          	lw	a5,8(s0)
800048c8:	00d7c783          	lbu	a5,13(a5)
800048cc:	0107f793          	andi	a5,a5,16
800048d0:	02078e63          	beqz	a5,8000490c <z_impl_k_sleep+0x1e0>
800048d4:	80007437          	lui	s0,0x80007
800048d8:	800075b7          	lui	a1,0x80007
800048dc:	80007537          	lui	a0,0x80007
800048e0:	20858593          	addi	a1,a1,520 # 80007208 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007209>
800048e4:	3b700693          	li	a3,951
800048e8:	1a840613          	addi	a2,s0,424 # 800071a8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800071a9>
800048ec:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800048f0:	cf5fd0ef          	jal	ra,800025e4 <printk>
800048f4:	80007537          	lui	a0,0x80007
800048f8:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800048fc:	ce9fd0ef          	jal	ra,800025e4 <printk>
80004900:	3b700593          	li	a1,951
80004904:	1a840513          	addi	a0,s0,424
80004908:	d19fd0ef          	jal	ra,80002620 <assert_post_action>

	ticks = expected_wakeup_time - z_tick_get_32();
8000490c:	428010ef          	jal	ra,80005d34 <z_tick_get_32>
80004910:	40a90533          	sub	a0,s2,a0
	if (ticks > 0) {
		return __ticks_to_ms(ticks);
	}
#endif

	return 0;
80004914:	00000493          	li	s1,0
	if (ticks > 0) {
80004918:	02a05863          	blez	a0,80004948 <z_impl_k_sleep+0x21c>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
8000491c:	3e800613          	li	a2,1000
80004920:	00000693          	li	a3,0
80004924:	41f55593          	srai	a1,a0,0x1f
80004928:	f81fb0ef          	jal	ra,800008a8 <__muldi3>
8000492c:	06400613          	li	a2,100
80004930:	00000693          	li	a3,0
80004934:	97dfb0ef          	jal	ra,800002b0 <__udivdi3>
80004938:	00050493          	mv	s1,a0
		return __ticks_to_ms(ticks);
8000493c:	00c0006f          	j	80004948 <z_impl_k_sleep+0x21c>
	if (duration == 0) {
80004940:	e8049ae3          	bnez	s1,800047d4 <z_impl_k_sleep+0xa8>
K_SYSCALL_DECLARE0_VOID(K_SYSCALL_K_YIELD, k_yield)
80004944:	bf1ff0ef          	jal	ra,80004534 <z_impl_k_yield>
}
80004948:	02c12083          	lw	ra,44(sp)
8000494c:	02812403          	lw	s0,40(sp)
80004950:	00048513          	mv	a0,s1
80004954:	02012903          	lw	s2,32(sp)
80004958:	02412483          	lw	s1,36(sp)
8000495c:	01c12983          	lw	s3,28(sp)
80004960:	01812a03          	lw	s4,24(sp)
80004964:	03010113          	addi	sp,sp,48
80004968:	00008067          	ret

8000496c <z_impl_k_current_get>:
#endif

k_tid_t z_impl_k_current_get(void)
{
	return _current;
}
8000496c:	800087b7          	lui	a5,0x80008
80004970:	8cc7a503          	lw	a0,-1844(a5) # 800078cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078cd>
80004974:	00008067          	ret

80004978 <z_impl_k_sem_init>:

#endif /* CONFIG_OBJECT_TRACING */

void z_impl_k_sem_init(struct k_sem *sem, unsigned int initial_count,
		      unsigned int limit)
{
80004978:	fe010113          	addi	sp,sp,-32
8000497c:	00812c23          	sw	s0,24(sp)
80004980:	00912a23          	sw	s1,20(sp)
80004984:	01212823          	sw	s2,16(sp)
80004988:	00112e23          	sw	ra,28(sp)
8000498c:	01312623          	sw	s3,12(sp)
80004990:	00050413          	mv	s0,a0
80004994:	00058913          	mv	s2,a1
80004998:	00060493          	mv	s1,a2
	__ASSERT(limit != 0U, "limit cannot be zero");
8000499c:	02061e63          	bnez	a2,800049d8 <z_impl_k_sem_init+0x60>
800049a0:	800079b7          	lui	s3,0x80007
800049a4:	800075b7          	lui	a1,0x80007
800049a8:	80007537          	lui	a0,0x80007
800049ac:	26458593          	addi	a1,a1,612 # 80007264 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007265>
800049b0:	04600693          	li	a3,70
800049b4:	25498613          	addi	a2,s3,596 # 80007254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007255>
800049b8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800049bc:	c29fd0ef          	jal	ra,800025e4 <printk>
800049c0:	80007537          	lui	a0,0x80007
800049c4:	27050513          	addi	a0,a0,624 # 80007270 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007271>
800049c8:	c1dfd0ef          	jal	ra,800025e4 <printk>
800049cc:	04600593          	li	a1,70
800049d0:	25498513          	addi	a0,s3,596
800049d4:	c4dfd0ef          	jal	ra,80002620 <assert_post_action>
	__ASSERT(initial_count <= limit, "count cannot be greater than limit");
800049d8:	0324fe63          	bgeu	s1,s2,80004a14 <z_impl_k_sem_init+0x9c>
800049dc:	800079b7          	lui	s3,0x80007
800049e0:	800075b7          	lui	a1,0x80007
800049e4:	80007537          	lui	a0,0x80007
800049e8:	28858593          	addi	a1,a1,648 # 80007288 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007289>
800049ec:	04700693          	li	a3,71
800049f0:	25498613          	addi	a2,s3,596 # 80007254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007255>
800049f4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800049f8:	bedfd0ef          	jal	ra,800025e4 <printk>
800049fc:	80007537          	lui	a0,0x80007
80004a00:	2a050513          	addi	a0,a0,672 # 800072a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072a1>
80004a04:	be1fd0ef          	jal	ra,800025e4 <printk>
80004a08:	04700593          	li	a1,71
80004a0c:	25498513          	addi	a0,s3,596
80004a10:	c11fd0ef          	jal	ra,80002620 <assert_post_action>

	sys_trace_void(SYS_TRACE_ID_SEMA_INIT);
	sem->count = initial_count;
80004a14:	01242423          	sw	s2,8(s0)
	sem->limit = limit;
80004a18:	00942623          	sw	s1,12(s0)
	list->head = (sys_dnode_t *)list;
80004a1c:	00842023          	sw	s0,0(s0)
	list->tail = (sys_dnode_t *)list;
80004a20:	00842223          	sw	s0,4(s0)

	SYS_TRACING_OBJ_INIT(k_sem, sem);

	z_object_init(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_INIT);
}
80004a24:	01c12083          	lw	ra,28(sp)
80004a28:	01812403          	lw	s0,24(sp)
80004a2c:	01412483          	lw	s1,20(sp)
80004a30:	01012903          	lw	s2,16(sp)
80004a34:	00c12983          	lw	s3,12(sp)
80004a38:	02010113          	addi	sp,sp,32
80004a3c:	00008067          	ret

80004a40 <z_impl_k_sem_give>:
		handle_poll_events(sem);
	}
}

void z_impl_k_sem_give(struct k_sem *sem)
{
80004a40:	fe010113          	addi	sp,sp,-32
80004a44:	00912a23          	sw	s1,20(sp)
80004a48:	01312623          	sw	s3,12(sp)
80004a4c:	00112e23          	sw	ra,28(sp)
80004a50:	00812c23          	sw	s0,24(sp)
80004a54:	01212823          	sw	s2,16(sp)
80004a58:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004a5c:	00800493          	li	s1,8
80004a60:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004a64:	80007437          	lui	s0,0x80007
80004a68:	6cc40513          	addi	a0,s0,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
	key = (mstatus & SOC_MSTATUS_IEN);
80004a6c:	0084f493          	andi	s1,s1,8
80004a70:	3ec000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004a74:	02051e63          	bnez	a0,80004ab0 <z_impl_k_sem_give+0x70>
80004a78:	80007937          	lui	s2,0x80007
80004a7c:	800075b7          	lui	a1,0x80007
80004a80:	80007537          	lui	a0,0x80007
80004a84:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80004a88:	04e00693          	li	a3,78
80004a8c:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004a90:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004a94:	b51fd0ef          	jal	ra,800025e4 <printk>
80004a98:	80007537          	lui	a0,0x80007
80004a9c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80004aa0:	b45fd0ef          	jal	ra,800025e4 <printk>
80004aa4:	04e00593          	li	a1,78
80004aa8:	f2c90513          	addi	a0,s2,-212
80004aac:	b75fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004ab0:	6cc40513          	addi	a0,s0,1740
80004ab4:	400000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	struct k_thread *thread = z_unpend_first_thread(&sem->wait_q);
80004ab8:	00098513          	mv	a0,s3
80004abc:	8a1ff0ef          	jal	ra,8000435c <z_unpend_first_thread>
80004ac0:	00050913          	mv	s2,a0
	if (thread != NULL) {
80004ac4:	04050263          	beqz	a0,80004b08 <z_impl_k_sem_give+0xc8>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004ac8:	00d54783          	lbu	a5,13(a0)
80004acc:	01f7f793          	andi	a5,a5,31
80004ad0:	00079863          	bnez	a5,80004ae0 <z_impl_k_sem_give+0xa0>
	if (z_is_thread_ready(thread)) {
80004ad4:	01852783          	lw	a5,24(a0)
80004ad8:	00079463          	bnez	a5,80004ae0 <z_impl_k_sem_give+0xa0>
		z_add_thread_to_ready_q(thread);
80004adc:	8b0ff0ef          	jal	ra,80003b8c <z_add_thread_to_ready_q>
}

static ALWAYS_INLINE void
z_set_thread_return_value(struct k_thread *thread, unsigned int value)
{
	thread->arch.swap_return_value = value;
80004ae0:	06092623          	sw	zero,108(s2)
	k_spinlock_key_t key = k_spin_lock(&lock);

	sys_trace_void(SYS_TRACE_ID_SEMA_GIVE);
	do_sem_give(sem);
	sys_trace_end_call(SYS_TRACE_ID_SEMA_GIVE);
	z_reschedule(&lock, key);
80004ae4:	6cc40513          	addi	a0,s0,1740
}
80004ae8:	01812403          	lw	s0,24(sp)
80004aec:	01c12083          	lw	ra,28(sp)
80004af0:	01012903          	lw	s2,16(sp)
80004af4:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004af8:	00048593          	mv	a1,s1
}
80004afc:	01412483          	lw	s1,20(sp)
80004b00:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004b04:	b3dfe06f          	j	80003640 <z_reschedule>
	sem->count += (sem->count != sem->limit) ? 1U : 0U;
80004b08:	0089a703          	lw	a4,8(s3)
80004b0c:	00c9a783          	lw	a5,12(s3)
80004b10:	40e787b3          	sub	a5,a5,a4
80004b14:	00f037b3          	snez	a5,a5
80004b18:	00e787b3          	add	a5,a5,a4
80004b1c:	00f9a423          	sw	a5,8(s3)
80004b20:	fc5ff06f          	j	80004ae4 <z_impl_k_sem_give+0xa4>

80004b24 <z_impl_k_sem_take>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_sem_give, K_OBJ_SEM, struct k_sem *);
#endif

int z_impl_k_sem_take(struct k_sem *sem, s32_t timeout)
{
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004b24:	800087b7          	lui	a5,0x80008
80004b28:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80004b2c:	fe010113          	addi	sp,sp,-32
80004b30:	01212823          	sw	s2,16(sp)
80004b34:	01312623          	sw	s3,12(sp)
80004b38:	00112e23          	sw	ra,28(sp)
80004b3c:	00812c23          	sw	s0,24(sp)
80004b40:	00912a23          	sw	s1,20(sp)
80004b44:	01412423          	sw	s4,8(sp)
80004b48:	00050913          	mv	s2,a0
80004b4c:	00058993          	mv	s3,a1
	__ASSERT(((z_is_in_isr() == false) || (timeout == K_NO_WAIT)), "");
80004b50:	04078063          	beqz	a5,80004b90 <z_impl_k_sem_take+0x6c>
80004b54:	02058e63          	beqz	a1,80004b90 <z_impl_k_sem_take+0x6c>
80004b58:	80007437          	lui	s0,0x80007
80004b5c:	800075b7          	lui	a1,0x80007
80004b60:	80007537          	lui	a0,0x80007
80004b64:	2c858593          	addi	a1,a1,712 # 800072c8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072c9>
80004b68:	08c00693          	li	a3,140
80004b6c:	25440613          	addi	a2,s0,596 # 80007254 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007255>
80004b70:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004b74:	a71fd0ef          	jal	ra,800025e4 <printk>
80004b78:	80007537          	lui	a0,0x80007
80004b7c:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
80004b80:	a65fd0ef          	jal	ra,800025e4 <printk>
80004b84:	08c00593          	li	a1,140
80004b88:	25440513          	addi	a0,s0,596
80004b8c:	a95fd0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004b90:	00800413          	li	s0,8
80004b94:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004b98:	800074b7          	lui	s1,0x80007
80004b9c:	6cc48513          	addi	a0,s1,1740 # 800076cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076cd>
	key = (mstatus & SOC_MSTATUS_IEN);
80004ba0:	00847413          	andi	s0,s0,8
80004ba4:	2b8000ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004ba8:	02051e63          	bnez	a0,80004be4 <z_impl_k_sem_take+0xc0>
80004bac:	80007a37          	lui	s4,0x80007
80004bb0:	800075b7          	lui	a1,0x80007
80004bb4:	80007537          	lui	a0,0x80007
80004bb8:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80004bbc:	04e00693          	li	a3,78
80004bc0:	f2ca0613          	addi	a2,s4,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004bc4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004bc8:	a1dfd0ef          	jal	ra,800025e4 <printk>
80004bcc:	80007537          	lui	a0,0x80007
80004bd0:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80004bd4:	a11fd0ef          	jal	ra,800025e4 <printk>
80004bd8:	04e00593          	li	a1,78
80004bdc:	f2ca0513          	addi	a0,s4,-212
80004be0:	a41fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004be4:	6cc48513          	addi	a0,s1,1740
80004be8:	2cc000ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>

	sys_trace_void(SYS_TRACE_ID_SEMA_TAKE);
	k_spinlock_key_t key = k_spin_lock(&lock);

	if (likely(sem->count > 0U)) {
80004bec:	00892783          	lw	a5,8(s2)
80004bf0:	06078c63          	beqz	a5,80004c68 <z_impl_k_sem_take+0x144>
		sem->count--;
80004bf4:	fff78793          	addi	a5,a5,-1
80004bf8:	00f92423          	sw	a5,8(s2)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004bfc:	6cc48513          	addi	a0,s1,1740
80004c00:	284000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004c04:	02051e63          	bnez	a0,80004c40 <z_impl_k_sem_take+0x11c>
80004c08:	800074b7          	lui	s1,0x80007
80004c0c:	800075b7          	lui	a1,0x80007
80004c10:	80007537          	lui	a0,0x80007
80004c14:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80004c18:	06100693          	li	a3,97
80004c1c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004c20:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004c24:	9c1fd0ef          	jal	ra,800025e4 <printk>
80004c28:	80007537          	lui	a0,0x80007
80004c2c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80004c30:	9b5fd0ef          	jal	ra,800025e4 <printk>
80004c34:	06100593          	li	a1,97
80004c38:	f2c48513          	addi	a0,s1,-212
80004c3c:	9e5fd0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004c40:	30042473          	csrrs	s0,mstatus,s0
		k_spin_unlock(&lock, key);
		sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);
		return 0;
80004c44:	00000513          	li	a0,0

	sys_trace_end_call(SYS_TRACE_ID_SEMA_TAKE);

	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
	return ret;
}
80004c48:	01c12083          	lw	ra,28(sp)
80004c4c:	01812403          	lw	s0,24(sp)
80004c50:	01412483          	lw	s1,20(sp)
80004c54:	01012903          	lw	s2,16(sp)
80004c58:	00c12983          	lw	s3,12(sp)
80004c5c:	00812a03          	lw	s4,8(sp)
80004c60:	02010113          	addi	sp,sp,32
80004c64:	00008067          	ret
	if (timeout == K_NO_WAIT) {
80004c68:	04099a63          	bnez	s3,80004cbc <z_impl_k_sem_take+0x198>
80004c6c:	6cc48513          	addi	a0,s1,1740
80004c70:	214000ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004c74:	02051e63          	bnez	a0,80004cb0 <z_impl_k_sem_take+0x18c>
80004c78:	800074b7          	lui	s1,0x80007
80004c7c:	800075b7          	lui	a1,0x80007
80004c80:	80007537          	lui	a0,0x80007
80004c84:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80004c88:	06100693          	li	a3,97
80004c8c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004c90:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004c94:	951fd0ef          	jal	ra,800025e4 <printk>
80004c98:	80007537          	lui	a0,0x80007
80004c9c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80004ca0:	945fd0ef          	jal	ra,800025e4 <printk>
80004ca4:	06100593          	li	a1,97
80004ca8:	f2c48513          	addi	a0,s1,-212
80004cac:	975fd0ef          	jal	ra,80002620 <assert_post_action>
80004cb0:	30042473          	csrrs	s0,mstatus,s0
		return -EBUSY;
80004cb4:	ff000513          	li	a0,-16
80004cb8:	f91ff06f          	j	80004c48 <z_impl_k_sem_take+0x124>
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004cbc:	00040593          	mv	a1,s0
}
80004cc0:	01812403          	lw	s0,24(sp)
80004cc4:	01c12083          	lw	ra,28(sp)
80004cc8:	00812a03          	lw	s4,8(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004ccc:	00098693          	mv	a3,s3
80004cd0:	00090613          	mv	a2,s2
}
80004cd4:	00c12983          	lw	s3,12(sp)
80004cd8:	01012903          	lw	s2,16(sp)
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004cdc:	6cc48513          	addi	a0,s1,1740
}
80004ce0:	01412483          	lw	s1,20(sp)
80004ce4:	02010113          	addi	sp,sp,32
	int ret = z_pend_curr(&lock, key, &sem->wait_q, timeout);
80004ce8:	decff06f          	j	800042d4 <z_pend_curr>

80004cec <z_is_thread_ready>:
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80004cec:	00d54783          	lbu	a5,13(a0)
80004cf0:	01f7f793          	andi	a5,a5,31
80004cf4:	00079863          	bnez	a5,80004d04 <z_is_thread_ready+0x18>
80004cf8:	01852503          	lw	a0,24(a0)
80004cfc:	00153513          	seqz	a0,a0
80004d00:	00008067          	ret
80004d04:	00000513          	li	a0,0
}
80004d08:	00008067          	ret

80004d0c <k_is_in_isr>:
#endif
}

bool k_is_in_isr(void)
{
	return z_is_in_isr();
80004d0c:	800087b7          	lui	a5,0x80008
80004d10:	8c47a503          	lw	a0,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
}
80004d14:	00a03533          	snez	a0,a0
80004d18:	00008067          	ret

80004d1c <z_is_thread_essential>:
 *
 * Returns true if current thread is essential, false if it is not.
 */
bool z_is_thread_essential(void)
{
	return (_current->base.user_options & K_ESSENTIAL) == K_ESSENTIAL;
80004d1c:	800087b7          	lui	a5,0x80008
80004d20:	8cc7a783          	lw	a5,-1844(a5) # 800078cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078cd>
80004d24:	00c7c503          	lbu	a0,12(a5)
}
80004d28:	00157513          	andi	a0,a0,1
80004d2c:	00008067          	ret

80004d30 <z_impl_k_busy_wait>:
void z_impl_k_busy_wait(u32_t usec_to_wait)
{
#if !defined(CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT)
	/* use 64-bit math to prevent overflow when multiplying */
	u32_t cycles_to_wait = (u32_t)(
		(u64_t)usec_to_wait *
80004d30:	00b72637          	lui	a2,0xb72
{
80004d34:	ff010113          	addi	sp,sp,-16
		(u64_t)usec_to_wait *
80004d38:	b0060613          	addi	a2,a2,-1280 # b71b00 <CONFIG_SYS_CLOCK_HW_CYCLES_PER_SEC>
80004d3c:	00000693          	li	a3,0
80004d40:	00000593          	li	a1,0
{
80004d44:	00112623          	sw	ra,12(sp)
80004d48:	00812423          	sw	s0,8(sp)
80004d4c:	00912223          	sw	s1,4(sp)
		(u64_t)usec_to_wait *
80004d50:	b59fb0ef          	jal	ra,800008a8 <__muldi3>
		(u64_t)sys_clock_hw_cycles_per_sec() /
80004d54:	000f4637          	lui	a2,0xf4
80004d58:	24060613          	addi	a2,a2,576 # f4240 <CONFIG_RISCV_RAM_SIZE+0xb4240>
80004d5c:	00000693          	li	a3,0
80004d60:	d50fb0ef          	jal	ra,800002b0 <__udivdi3>
80004d64:	00050413          	mv	s0,a0
		(u64_t)USEC_PER_SEC
	);
	u32_t start_cycles = k_cycle_get_32();
80004d68:	e2dfd0ef          	jal	ra,80002b94 <z_timer_cycle_get_32>
80004d6c:	00050493          	mv	s1,a0

	for (;;) {
		u32_t current_cycles = k_cycle_get_32();
80004d70:	e25fd0ef          	jal	ra,80002b94 <z_timer_cycle_get_32>

		/* this handles the rollover on an unsigned 32-bit value */
		if ((current_cycles - start_cycles) >= cycles_to_wait) {
80004d74:	40950533          	sub	a0,a0,s1
80004d78:	fe856ce3          	bltu	a0,s0,80004d70 <z_impl_k_busy_wait+0x40>
		}
	}
#else
	z_arch_busy_wait(usec_to_wait);
#endif /* CONFIG_ARCH_HAS_CUSTOM_BUSY_WAIT */
}
80004d7c:	00c12083          	lw	ra,12(sp)
80004d80:	00812403          	lw	s0,8(sp)
80004d84:	00412483          	lw	s1,4(sp)
80004d88:	01010113          	addi	sp,sp,16
80004d8c:	00008067          	ret

80004d90 <z_setup_new_thread>:
void z_setup_new_thread(struct k_thread *new_thread,
		       k_thread_stack_t *stack, size_t stack_size,
		       k_thread_entry_t entry,
		       void *p1, void *p2, void *p3,
		       int prio, u32_t options, const char *name)
{
80004d90:	fe010113          	addi	sp,sp,-32
	stack_size = STACK_ROUND_DOWN(stack_size
			- sizeof(*new_thread->userspace_local_data));
#endif
#endif

	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004d94:	02012303          	lw	t1,32(sp)
{
80004d98:	00812c23          	sw	s0,24(sp)
80004d9c:	00112e23          	sw	ra,28(sp)
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004da0:	00612023          	sw	t1,0(sp)
{
80004da4:	00050413          	mv	s0,a0
	z_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
80004da8:	ed9fc0ef          	jal	ra,80001c80 <z_new_thread>
	}
#endif
#ifdef CONFIG_SCHED_DEADLINE
	new_thread->base.prio_deadline = 0;
#endif
	new_thread->resource_pool = _current->resource_pool;
80004dac:	800087b7          	lui	a5,0x80008
80004db0:	8cc7a783          	lw	a5,-1844(a5) # 800078cc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078cd>
	sys_trace_thread_create(new_thread);
}
80004db4:	01c12083          	lw	ra,28(sp)
	new_thread->resource_pool = _current->resource_pool;
80004db8:	0687a783          	lw	a5,104(a5)
80004dbc:	06f42423          	sw	a5,104(s0)
}
80004dc0:	01812403          	lw	s0,24(sp)
80004dc4:	02010113          	addi	sp,sp,32
80004dc8:	00008067          	ret

80004dcc <z_thread_single_abort>:
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_thread_resume, K_OBJ_THREAD, k_tid_t);
#endif

void z_thread_single_abort(struct k_thread *thread)
{
	if (thread->fn_abort != NULL) {
80004dcc:	06052783          	lw	a5,96(a0)
{
80004dd0:	ff010113          	addi	sp,sp,-16
80004dd4:	00812423          	sw	s0,8(sp)
80004dd8:	00112623          	sw	ra,12(sp)
80004ddc:	00050413          	mv	s0,a0
	if (thread->fn_abort != NULL) {
80004de0:	00078463          	beqz	a5,80004de8 <z_thread_single_abort+0x1c>
		thread->fn_abort();
80004de4:	000780e7          	jalr	a5

	if (IS_ENABLED(CONFIG_SMP)) {
		z_sched_abort(thread);
	}

	if (z_is_thread_ready(thread)) {
80004de8:	00040513          	mv	a0,s0
80004dec:	f01ff0ef          	jal	ra,80004cec <z_is_thread_ready>
80004df0:	02050463          	beqz	a0,80004e18 <z_thread_single_abort+0x4c>
		z_remove_thread_from_ready_q(thread);
80004df4:	00040513          	mv	a0,s0
80004df8:	a9cff0ef          	jal	ra,80004094 <z_remove_thread_from_ready_q>
		if (z_is_thread_timeout_active(thread)) {
			(void)z_abort_thread_timeout(thread);
		}
	}

	thread->base.thread_state |= _THREAD_DEAD;
80004dfc:	00d44783          	lbu	a5,13(s0)
	z_object_uninit(thread);

	/* Revoke permissions on thread's ID so that it may be recycled */
	z_thread_perms_all_clear(thread);
#endif
}
80004e00:	00c12083          	lw	ra,12(sp)
	thread->base.thread_state |= _THREAD_DEAD;
80004e04:	0087e793          	ori	a5,a5,8
80004e08:	00f406a3          	sb	a5,13(s0)
}
80004e0c:	00812403          	lw	s0,8(sp)
80004e10:	01010113          	addi	sp,sp,16
80004e14:	00008067          	ret
		if (z_is_thread_pending(thread)) {
80004e18:	00d44783          	lbu	a5,13(s0)
80004e1c:	0027f793          	andi	a5,a5,2
80004e20:	00078663          	beqz	a5,80004e2c <z_thread_single_abort+0x60>
			z_unpend_thread_no_timeout(thread);
80004e24:	00040513          	mv	a0,s0
80004e28:	f1cfe0ef          	jal	ra,80003544 <z_unpend_thread_no_timeout>
		if (z_is_thread_timeout_active(thread)) {
80004e2c:	01842783          	lw	a5,24(s0)
80004e30:	fc0786e3          	beqz	a5,80004dfc <z_thread_single_abort+0x30>
	return z_abort_timeout(&thread->base.timeout);
80004e34:	01840513          	addi	a0,s0,24
80004e38:	798000ef          	jal	ra,800055d0 <z_abort_timeout>
80004e3c:	fc1ff06f          	j	80004dfc <z_thread_single_abort+0x30>

80004e40 <z_init_thread_base>:
void z_init_thread_base(struct _thread_base *thread_base, int priority,
		       u32_t initial_state, unsigned int options)
{
	/* k_q_node is initialized upon first insertion in a list */

	thread_base->user_options = (u8_t)options;
80004e40:	00d50623          	sb	a3,12(a0)
	thread_base->thread_state = (u8_t)initial_state;
80004e44:	00c506a3          	sb	a2,13(a0)

	thread_base->prio = priority;
80004e48:	00b50723          	sb	a1,14(a0)

	thread_base->sched_locked = 0U;
80004e4c:	000507a3          	sb	zero,15(a0)
	node->next = NULL;
80004e50:	00052c23          	sw	zero,24(a0)
	node->prev = NULL;
80004e54:	00052e23          	sw	zero,28(a0)

	/* swap_data does not need to be initialized */

	z_init_thread_timeout(thread_base);
}
80004e58:	00008067          	ret

80004e5c <z_spin_lock_valid>:
 * them in spinlock.h is a giant header ordering headache.
 */
#ifdef SPIN_VALIDATE
bool z_spin_lock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu) {
80004e5c:	00052503          	lw	a0,0(a0)
80004e60:	00050e63          	beqz	a0,80004e7c <z_spin_lock_valid+0x20>
		if ((l->thread_cpu & 3) == _current_cpu->id) {
80004e64:	800087b7          	lui	a5,0x80008
80004e68:	8d87c783          	lbu	a5,-1832(a5) # 800078d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078d9>
80004e6c:	00357513          	andi	a0,a0,3
80004e70:	40f50533          	sub	a0,a0,a5
80004e74:	00a03533          	snez	a0,a0
80004e78:	00008067          	ret
			return false;
		}
	}
	return true;
80004e7c:	00100513          	li	a0,1
}
80004e80:	00008067          	ret

80004e84 <z_spin_unlock_valid>:

bool z_spin_unlock_valid(struct k_spinlock *l)
{
	if (l->thread_cpu != (_current_cpu->id | (u32_t)_current)) {
80004e84:	800087b7          	lui	a5,0x80008
80004e88:	8c478793          	addi	a5,a5,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004e8c:	0147c703          	lbu	a4,20(a5)
80004e90:	0087a783          	lw	a5,8(a5)
80004e94:	00e7e7b3          	or	a5,a5,a4
80004e98:	00052703          	lw	a4,0(a0)
80004e9c:	00f71863          	bne	a4,a5,80004eac <z_spin_unlock_valid+0x28>
		return false;
	}
	l->thread_cpu = 0;
80004ea0:	00052023          	sw	zero,0(a0)
	return true;
80004ea4:	00100513          	li	a0,1
80004ea8:	00008067          	ret
		return false;
80004eac:	00000513          	li	a0,0
}
80004eb0:	00008067          	ret

80004eb4 <z_spin_lock_set_owner>:

void z_spin_lock_set_owner(struct k_spinlock *l)
{
	l->thread_cpu = _current_cpu->id | (u32_t)_current;
80004eb4:	800087b7          	lui	a5,0x80008
80004eb8:	8c478793          	addi	a5,a5,-1852 # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
80004ebc:	0147c703          	lbu	a4,20(a5)
80004ec0:	0087a783          	lw	a5,8(a5)
80004ec4:	00e7e7b3          	or	a5,a5,a4
80004ec8:	00f52023          	sw	a5,0(a0)
}
80004ecc:	00008067          	ret

80004ed0 <z_impl_k_thread_start>:
{
80004ed0:	fe010113          	addi	sp,sp,-32
80004ed4:	00812c23          	sw	s0,24(sp)
80004ed8:	01212823          	sw	s2,16(sp)
80004edc:	00112e23          	sw	ra,28(sp)
80004ee0:	00912a23          	sw	s1,20(sp)
80004ee4:	01312623          	sw	s3,12(sp)
80004ee8:	00050913          	mv	s2,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80004eec:	00800413          	li	s0,8
80004ef0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80004ef4:	800074b7          	lui	s1,0x80007
80004ef8:	6d048513          	addi	a0,s1,1744 # 800076d0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d1>
	key = (mstatus & SOC_MSTATUS_IEN);
80004efc:	00847413          	andi	s0,s0,8
80004f00:	f5dff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80004f04:	02051e63          	bnez	a0,80004f40 <z_impl_k_thread_start+0x70>
80004f08:	800079b7          	lui	s3,0x80007
80004f0c:	800075b7          	lui	a1,0x80007
80004f10:	80007537          	lui	a0,0x80007
80004f14:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80004f18:	04e00693          	li	a3,78
80004f1c:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004f20:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004f24:	ec0fd0ef          	jal	ra,800025e4 <printk>
80004f28:	80007537          	lui	a0,0x80007
80004f2c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80004f30:	eb4fd0ef          	jal	ra,800025e4 <printk>
80004f34:	04e00593          	li	a1,78
80004f38:	f2c98513          	addi	a0,s3,-212
80004f3c:	ee4fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80004f40:	6d048513          	addi	a0,s1,1744
80004f44:	f71ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	if (z_has_thread_started(thread)) {
80004f48:	00d94783          	lbu	a5,13(s2)
80004f4c:	0047f713          	andi	a4,a5,4
80004f50:	06071463          	bnez	a4,80004fb8 <z_impl_k_thread_start+0xe8>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80004f54:	6d048513          	addi	a0,s1,1744
80004f58:	f2dff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80004f5c:	02051e63          	bnez	a0,80004f98 <z_impl_k_thread_start+0xc8>
80004f60:	800074b7          	lui	s1,0x80007
80004f64:	800075b7          	lui	a1,0x80007
80004f68:	80007537          	lui	a0,0x80007
80004f6c:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80004f70:	06100693          	li	a3,97
80004f74:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80004f78:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80004f7c:	e68fd0ef          	jal	ra,800025e4 <printk>
80004f80:	80007537          	lui	a0,0x80007
80004f84:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80004f88:	e5cfd0ef          	jal	ra,800025e4 <printk>
80004f8c:	06100593          	li	a1,97
80004f90:	f2c48513          	addi	a0,s1,-212
80004f94:	e8cfd0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80004f98:	30042473          	csrrs	s0,mstatus,s0
}
80004f9c:	01c12083          	lw	ra,28(sp)
80004fa0:	01812403          	lw	s0,24(sp)
80004fa4:	01412483          	lw	s1,20(sp)
80004fa8:	01012903          	lw	s2,16(sp)
80004fac:	00c12983          	lw	s3,12(sp)
80004fb0:	02010113          	addi	sp,sp,32
80004fb4:	00008067          	ret
	thread->base.thread_state &= ~_THREAD_PRESTART;
80004fb8:	ffb7f793          	andi	a5,a5,-5
80004fbc:	00f906a3          	sb	a5,13(s2)
	if (z_is_thread_ready(thread)) {
80004fc0:	00090513          	mv	a0,s2
80004fc4:	d29ff0ef          	jal	ra,80004cec <z_is_thread_ready>
80004fc8:	00050663          	beqz	a0,80004fd4 <z_impl_k_thread_start+0x104>
		z_add_thread_to_ready_q(thread);
80004fcc:	00090513          	mv	a0,s2
80004fd0:	bbdfe0ef          	jal	ra,80003b8c <z_add_thread_to_ready_q>
	z_reschedule(&lock, key);
80004fd4:	00040593          	mv	a1,s0
}
80004fd8:	01812403          	lw	s0,24(sp)
80004fdc:	01c12083          	lw	ra,28(sp)
80004fe0:	01012903          	lw	s2,16(sp)
80004fe4:	00c12983          	lw	s3,12(sp)
	z_reschedule(&lock, key);
80004fe8:	6d048513          	addi	a0,s1,1744
}
80004fec:	01412483          	lw	s1,20(sp)
80004ff0:	02010113          	addi	sp,sp,32
	z_reschedule(&lock, key);
80004ff4:	e4cfe06f          	j	80003640 <z_reschedule>

80004ff8 <schedule_new_thread>:
	if (delay == 0) {
80004ff8:	00059463          	bnez	a1,80005000 <schedule_new_thread+0x8>
K_SYSCALL_DECLARE1_VOID(K_SYSCALL_K_THREAD_START, k_thread_start, k_tid_t, thread)
80004ffc:	ed5ff06f          	j	80004ed0 <z_impl_k_thread_start>
{
80005000:	ff010113          	addi	sp,sp,-16
80005004:	00812423          	sw	s0,8(sp)
80005008:	00050413          	mv	s0,a0
8000500c:	00058513          	mv	a0,a1
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005010:	00950513          	addi	a0,a0,9
80005014:	00a00593          	li	a1,10
80005018:	00112623          	sw	ra,12(sp)
8000501c:	91dfb0ef          	jal	ra,80000938 <__divsi3>
	z_add_timeout(&th->base.timeout, z_thread_timeout, ticks);
80005020:	00150613          	addi	a2,a0,1
80005024:	01840513          	addi	a0,s0,24
}
80005028:	00812403          	lw	s0,8(sp)
8000502c:	00c12083          	lw	ra,12(sp)
80005030:	800045b7          	lui	a1,0x80004
80005034:	d1c58593          	addi	a1,a1,-740 # 80003d1c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80003d1d>
80005038:	01010113          	addi	sp,sp,16
8000503c:	3680006f          	j	800053a4 <z_add_timeout>

80005040 <z_impl_k_thread_create>:
{
80005040:	fc010113          	addi	sp,sp,-64
80005044:	03512223          	sw	s5,36(sp)
80005048:	00068a93          	mv	s5,a3
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000504c:	800086b7          	lui	a3,0x80008
80005050:	8c46a683          	lw	a3,-1852(a3) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80005054:	02812c23          	sw	s0,56(sp)
80005058:	02912a23          	sw	s1,52(sp)
8000505c:	03312623          	sw	s3,44(sp)
80005060:	03412423          	sw	s4,40(sp)
80005064:	02112e23          	sw	ra,60(sp)
80005068:	03212823          	sw	s2,48(sp)
8000506c:	00050413          	mv	s0,a0
80005070:	00058993          	mv	s3,a1
80005074:	00060a13          	mv	s4,a2
80005078:	04412483          	lw	s1,68(sp)
	__ASSERT(!z_is_in_isr(), "Threads may not be created in ISRs");
8000507c:	04068e63          	beqz	a3,800050d8 <z_impl_k_thread_create+0x98>
80005080:	80007937          	lui	s2,0x80007
80005084:	800075b7          	lui	a1,0x80007
80005088:	80007537          	lui	a0,0x80007
8000508c:	1b200693          	li	a3,434
80005090:	2fc90613          	addi	a2,s2,764 # 800072fc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800072fd>
80005094:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
80005098:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
8000509c:	01112e23          	sw	a7,28(sp)
800050a0:	01012c23          	sw	a6,24(sp)
800050a4:	00f12a23          	sw	a5,20(sp)
800050a8:	00e12823          	sw	a4,16(sp)
800050ac:	d38fd0ef          	jal	ra,800025e4 <printk>
800050b0:	80007537          	lui	a0,0x80007
800050b4:	31050513          	addi	a0,a0,784 # 80007310 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007311>
800050b8:	d2cfd0ef          	jal	ra,800025e4 <printk>
800050bc:	1b200593          	li	a1,434
800050c0:	2fc90513          	addi	a0,s2,764
800050c4:	d5cfd0ef          	jal	ra,80002620 <assert_post_action>
800050c8:	01c12883          	lw	a7,28(sp)
800050cc:	01812803          	lw	a6,24(sp)
800050d0:	01412783          	lw	a5,20(sp)
800050d4:	01012703          	lw	a4,16(sp)
	z_setup_new_thread(new_thread, stack, stack_size, entry, p1, p2, p3,
800050d8:	04012683          	lw	a3,64(sp)
800050dc:	00012223          	sw	zero,4(sp)
800050e0:	000a0613          	mv	a2,s4
800050e4:	00d12023          	sw	a3,0(sp)
800050e8:	00098593          	mv	a1,s3
800050ec:	000a8693          	mv	a3,s5
800050f0:	00040513          	mv	a0,s0
800050f4:	c9dff0ef          	jal	ra,80004d90 <z_setup_new_thread>
	if (delay != K_FOREVER) {
800050f8:	fff00793          	li	a5,-1
800050fc:	00f48863          	beq	s1,a5,8000510c <z_impl_k_thread_create+0xcc>
		schedule_new_thread(new_thread, delay);
80005100:	00048593          	mv	a1,s1
80005104:	00040513          	mv	a0,s0
80005108:	ef1ff0ef          	jal	ra,80004ff8 <schedule_new_thread>
}
8000510c:	00040513          	mv	a0,s0
80005110:	03c12083          	lw	ra,60(sp)
80005114:	03812403          	lw	s0,56(sp)
80005118:	03412483          	lw	s1,52(sp)
8000511c:	03012903          	lw	s2,48(sp)
80005120:	02c12983          	lw	s3,44(sp)
80005124:	02812a03          	lw	s4,40(sp)
80005128:	02412a83          	lw	s5,36(sp)
8000512c:	04010113          	addi	sp,sp,64
80005130:	00008067          	ret

80005134 <z_init_static_threads>:
{
80005134:	fe010113          	addi	sp,sp,-32
	_FOREACH_STATIC_THREAD(thread_data) {
80005138:	800077b7          	lui	a5,0x80007
{
8000513c:	01212823          	sw	s2,16(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005140:	80007937          	lui	s2,0x80007
{
80005144:	00812c23          	sw	s0,24(sp)
80005148:	00912a23          	sw	s1,20(sp)
8000514c:	00112e23          	sw	ra,28(sp)
	_FOREACH_STATIC_THREAD(thread_data) {
80005150:	57878413          	addi	s0,a5,1400 # 80007578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007579>
80005154:	57878493          	addi	s1,a5,1400
80005158:	57890913          	addi	s2,s2,1400 # 80007578 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007579>
8000515c:	03246663          	bltu	s0,s2,80005188 <z_init_static_threads+0x54>
	_FOREACH_STATIC_THREAD(thread_data) {
80005160:	00048413          	mv	s0,s1
	k_sched_lock();
80005164:	ddcfe0ef          	jal	ra,80003740 <k_sched_lock>
		if (thread_data->init_delay != K_FOREVER) {
80005168:	fff00493          	li	s1,-1
	_FOREACH_STATIC_THREAD(thread_data) {
8000516c:	07246063          	bltu	s0,s2,800051cc <z_init_static_threads+0x98>
}
80005170:	01812403          	lw	s0,24(sp)
80005174:	01c12083          	lw	ra,28(sp)
80005178:	01412483          	lw	s1,20(sp)
8000517c:	01012903          	lw	s2,16(sp)
80005180:	02010113          	addi	sp,sp,32
	k_sched_unlock();
80005184:	889fe06f          	j	80003a0c <k_sched_unlock>
		z_setup_new_thread(
80005188:	02c42783          	lw	a5,44(s0)
8000518c:	00f12223          	sw	a5,4(sp)
80005190:	02042783          	lw	a5,32(s0)
80005194:	00f12023          	sw	a5,0(sp)
80005198:	01442783          	lw	a5,20(s0)
8000519c:	01c42883          	lw	a7,28(s0)
800051a0:	01842803          	lw	a6,24(s0)
800051a4:	01042703          	lw	a4,16(s0)
800051a8:	00c42683          	lw	a3,12(s0)
800051ac:	00842603          	lw	a2,8(s0)
800051b0:	00442583          	lw	a1,4(s0)
800051b4:	00042503          	lw	a0,0(s0)
800051b8:	bd9ff0ef          	jal	ra,80004d90 <z_setup_new_thread>
		thread_data->init_thread->init_data = thread_data;
800051bc:	00042783          	lw	a5,0(s0)
800051c0:	0487ae23          	sw	s0,92(a5)
	_FOREACH_STATIC_THREAD(thread_data) {
800051c4:	03040413          	addi	s0,s0,48
800051c8:	f95ff06f          	j	8000515c <z_init_static_threads+0x28>
		if (thread_data->init_delay != K_FOREVER) {
800051cc:	02442583          	lw	a1,36(s0)
800051d0:	00958663          	beq	a1,s1,800051dc <z_init_static_threads+0xa8>
			schedule_new_thread(thread_data->init_thread,
800051d4:	00042503          	lw	a0,0(s0)
800051d8:	e21ff0ef          	jal	ra,80004ff8 <schedule_new_thread>
	_FOREACH_STATIC_THREAD(thread_data) {
800051dc:	03040413          	addi	s0,s0,48
800051e0:	f8dff06f          	j	8000516c <z_init_static_threads+0x38>

800051e4 <z_impl_k_thread_abort>:

extern void z_thread_single_abort(struct k_thread *thread);

#if !defined(CONFIG_ARCH_HAS_THREAD_ABORT)
void z_impl_k_thread_abort(k_tid_t thread)
{
800051e4:	fe010113          	addi	sp,sp,-32
800051e8:	00812c23          	sw	s0,24(sp)
800051ec:	00912a23          	sw	s1,20(sp)
800051f0:	00112e23          	sw	ra,28(sp)
800051f4:	01212823          	sw	s2,16(sp)
800051f8:	00050493          	mv	s1,a0
	 * to have been in place to prevent the thread from waking up
	 * due to a delivered interrupt.  Leave a dummy spinlock in
	 * place to do that.  This API should be revisted though, it
	 * doesn't look SMP-safe as it stands.
	 */
	struct k_spinlock lock = {};
800051fc:	00012623          	sw	zero,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005200:	00800413          	li	s0,8
80005204:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005208:	00c10513          	addi	a0,sp,12
	key = (mstatus & SOC_MSTATUS_IEN);
8000520c:	00847413          	andi	s0,s0,8
80005210:	c4dff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005214:	02051e63          	bnez	a0,80005250 <z_impl_k_thread_abort+0x6c>
80005218:	80007937          	lui	s2,0x80007
8000521c:	800075b7          	lui	a1,0x80007
80005220:	80007537          	lui	a0,0x80007
80005224:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005228:	04e00693          	li	a3,78
8000522c:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005230:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005234:	bb0fd0ef          	jal	ra,800025e4 <printk>
80005238:	80007537          	lui	a0,0x80007
8000523c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005240:	ba4fd0ef          	jal	ra,800025e4 <printk>
80005244:	04e00593          	li	a1,78
80005248:	f2c90513          	addi	a0,s2,-212
8000524c:	bd4fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005250:	00c10513          	addi	a0,sp,12
80005254:	c61ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	k_spinlock_key_t key = k_spin_lock(&lock);

	__ASSERT((thread->base.user_options & K_ESSENTIAL) == 0U,
80005258:	00c4c783          	lbu	a5,12(s1)
8000525c:	0017f793          	andi	a5,a5,1
80005260:	02078e63          	beqz	a5,8000529c <z_impl_k_thread_abort+0xb8>
80005264:	80007937          	lui	s2,0x80007
80005268:	800075b7          	lui	a1,0x80007
8000526c:	80007537          	lui	a0,0x80007
80005270:	35058593          	addi	a1,a1,848 # 80007350 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007351>
80005274:	02900693          	li	a3,41
80005278:	33890613          	addi	a2,s2,824 # 80007338 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007339>
8000527c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005280:	b64fd0ef          	jal	ra,800025e4 <printk>
80005284:	80007537          	lui	a0,0x80007
80005288:	38450513          	addi	a0,a0,900 # 80007384 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007385>
8000528c:	b58fd0ef          	jal	ra,800025e4 <printk>
80005290:	02900593          	li	a1,41
80005294:	33890513          	addi	a0,s2,824
80005298:	b88fd0ef          	jal	ra,80002620 <assert_post_action>
		 "essential thread aborted");

	z_thread_single_abort(thread);
8000529c:	00048513          	mv	a0,s1
800052a0:	b2dff0ef          	jal	ra,80004dcc <z_thread_single_abort>
	z_thread_monitor_exit(thread);

	z_reschedule(&lock, key);
800052a4:	00040593          	mv	a1,s0
800052a8:	00c10513          	addi	a0,sp,12
800052ac:	b94fe0ef          	jal	ra,80003640 <z_reschedule>
}
800052b0:	01c12083          	lw	ra,28(sp)
800052b4:	01812403          	lw	s0,24(sp)
800052b8:	01412483          	lw	s1,20(sp)
800052bc:	01012903          	lw	s2,16(sp)
800052c0:	02010113          	addi	sp,sp,32
800052c4:	00008067          	ret

800052c8 <elapsed>:
	sys_dlist_remove(&t->node);
}

static s32_t elapsed(void)
{
	return announce_remaining == 0 ? z_clock_elapsed() : 0;
800052c8:	800077b7          	lui	a5,0x80007
800052cc:	6d47a783          	lw	a5,1748(a5) # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
800052d0:	00079463          	bnez	a5,800052d8 <elapsed+0x10>
800052d4:	fccfd06f          	j	80002aa0 <z_clock_elapsed>
}
800052d8:	00000513          	li	a0,0
800052dc:	00008067          	ret

800052e0 <remove_timeout>:
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
800052e0:	00052783          	lw	a5,0(a0)
800052e4:	02050263          	beqz	a0,80005308 <remove_timeout+0x28>
800052e8:	80007737          	lui	a4,0x80007
	return (node == list->tail) ? NULL : node->next;
800052ec:	53c72703          	lw	a4,1340(a4) # 8000753c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000753d>
800052f0:	00e50c63          	beq	a0,a4,80005308 <remove_timeout+0x28>
	if (next(t) != NULL) {
800052f4:	00078a63          	beqz	a5,80005308 <remove_timeout+0x28>
		next(t)->dticks += t->dticks;
800052f8:	0087a703          	lw	a4,8(a5)
800052fc:	00852683          	lw	a3,8(a0)
80005300:	00d70733          	add	a4,a4,a3
80005304:	00e7a423          	sw	a4,8(a5)
	node->prev->next = node->next;
80005308:	00452703          	lw	a4,4(a0)
8000530c:	00f72023          	sw	a5,0(a4)
	node->next->prev = node->prev;
80005310:	00e7a223          	sw	a4,4(a5)
	node->next = NULL;
80005314:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005318:	00052223          	sw	zero,4(a0)
}
8000531c:	00008067          	ret

80005320 <next_timeout>:

static s32_t next_timeout(void)
{
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
80005320:	800077b7          	lui	a5,0x80007
80005324:	6e07c783          	lbu	a5,1760(a5) # 800076e0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076e1>
{
80005328:	ff010113          	addi	sp,sp,-16
8000532c:	00112623          	sw	ra,12(sp)
80005330:	00812423          	sw	s0,8(sp)
80005334:	00912223          	sw	s1,4(sp)
80005338:	fff00513          	li	a0,-1
	int maxw = can_wait_forever ? K_FOREVER : INT_MAX;
8000533c:	00079663          	bnez	a5,80005348 <next_timeout+0x28>
80005340:	80000537          	lui	a0,0x80000
80005344:	fff54513          	not	a0,a0
	return list->head == list;
80005348:	800077b7          	lui	a5,0x80007
8000534c:	53878793          	addi	a5,a5,1336 # 80007538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007539>
80005350:	0007a403          	lw	s0,0(a5)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005354:	02f40463          	beq	s0,a5,8000537c <next_timeout+0x5c>
	struct _timeout *to = first();
	s32_t ret = to == NULL ? maxw : MAX(0, to->dticks - elapsed());
80005358:	02040263          	beqz	s0,8000537c <next_timeout+0x5c>
8000535c:	00842483          	lw	s1,8(s0)
80005360:	f69ff0ef          	jal	ra,800052c8 <elapsed>
80005364:	40a484b3          	sub	s1,s1,a0
80005368:	00000513          	li	a0,0
8000536c:	0004c863          	bltz	s1,8000537c <next_timeout+0x5c>
80005370:	00842403          	lw	s0,8(s0)
80005374:	f55ff0ef          	jal	ra,800052c8 <elapsed>
80005378:	40a40533          	sub	a0,s0,a0

#ifdef CONFIG_TIMESLICING
	if (_current_cpu->slice_ticks && _current_cpu->slice_ticks < ret) {
8000537c:	800087b7          	lui	a5,0x80008
80005380:	8d47a783          	lw	a5,-1836(a5) # 800078d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078d5>
80005384:	00078663          	beqz	a5,80005390 <next_timeout+0x70>
80005388:	00a7d463          	bge	a5,a0,80005390 <next_timeout+0x70>
8000538c:	00078513          	mv	a0,a5
		ret = _current_cpu->slice_ticks;
	}
#endif
	return ret;
}
80005390:	00c12083          	lw	ra,12(sp)
80005394:	00812403          	lw	s0,8(sp)
80005398:	00412483          	lw	s1,4(sp)
8000539c:	01010113          	addi	sp,sp,16
800053a0:	00008067          	ret

800053a4 <z_add_timeout>:

void z_add_timeout(struct _timeout *to, _timeout_func_t fn, s32_t ticks)
{
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
800053a4:	00052783          	lw	a5,0(a0) # 80000000 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80000001>
{
800053a8:	fd010113          	addi	sp,sp,-48
800053ac:	02812423          	sw	s0,40(sp)
800053b0:	02912223          	sw	s1,36(sp)
800053b4:	01312e23          	sw	s3,28(sp)
800053b8:	02112623          	sw	ra,44(sp)
800053bc:	03212023          	sw	s2,32(sp)
800053c0:	01412c23          	sw	s4,24(sp)
800053c4:	01512a23          	sw	s5,20(sp)
800053c8:	01612823          	sw	s6,16(sp)
800053cc:	01712623          	sw	s7,12(sp)
800053d0:	01812423          	sw	s8,8(sp)
800053d4:	00050413          	mv	s0,a0
800053d8:	00058993          	mv	s3,a1
800053dc:	00060493          	mv	s1,a2
	__ASSERT(!sys_dnode_is_linked(&to->node), "");
800053e0:	02078e63          	beqz	a5,8000541c <z_add_timeout+0x78>
800053e4:	80007937          	lui	s2,0x80007
800053e8:	800075b7          	lui	a1,0x80007
800053ec:	80007537          	lui	a0,0x80007
800053f0:	3b458593          	addi	a1,a1,948 # 800073b4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073b5>
800053f4:	04d00693          	li	a3,77
800053f8:	3a090613          	addi	a2,s2,928 # 800073a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073a1>
800053fc:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005400:	9e4fd0ef          	jal	ra,800025e4 <printk>
80005404:	80007537          	lui	a0,0x80007
80005408:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
8000540c:	9d8fd0ef          	jal	ra,800025e4 <printk>
80005410:	04d00593          	li	a1,77
80005414:	3a090513          	addi	a0,s2,928
80005418:	a08fd0ef          	jal	ra,80002620 <assert_post_action>
	to->fn = fn;
8000541c:	01342623          	sw	s3,12(s0)
	ticks = MAX(1, ticks);
80005420:	00904463          	bgtz	s1,80005428 <z_add_timeout+0x84>
80005424:	00100493          	li	s1,1
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005428:	00800993          	li	s3,8
8000542c:	3009b9f3          	csrrc	s3,mstatus,s3
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005430:	80007a37          	lui	s4,0x80007
80005434:	6d8a0513          	addi	a0,s4,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005438:	0089f993          	andi	s3,s3,8
8000543c:	a21ff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005440:	02051e63          	bnez	a0,8000547c <z_add_timeout+0xd8>
80005444:	80007937          	lui	s2,0x80007
80005448:	800075b7          	lui	a1,0x80007
8000544c:	80007537          	lui	a0,0x80007
80005450:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005454:	04e00693          	li	a3,78
80005458:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000545c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005460:	984fd0ef          	jal	ra,800025e4 <printk>
80005464:	80007537          	lui	a0,0x80007
80005468:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
8000546c:	978fd0ef          	jal	ra,800025e4 <printk>
80005470:	04e00593          	li	a1,78
80005474:	f2c90513          	addi	a0,s2,-212
80005478:	9a8fd0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
8000547c:	6d8a0513          	addi	a0,s4,1752
80005480:	a35ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>

	LOCKED(&timeout_lock) {
		struct _timeout *t;

		to->dticks = ticks + elapsed();
80005484:	e45ff0ef          	jal	ra,800052c8 <elapsed>
80005488:	00950533          	add	a0,a0,s1
	return list->head == list;
8000548c:	800074b7          	lui	s1,0x80007
80005490:	5384a903          	lw	s2,1336(s1) # 80007538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007539>
80005494:	00a42423          	sw	a0,8(s0)
80005498:	53848493          	addi	s1,s1,1336
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000549c:	00990c63          	beq	s2,s1,800054b4 <z_add_timeout+0x110>
		for (t = first(); t != NULL; t = next(t)) {
			__ASSERT(t->dticks >= 0, "");
800054a0:	80007ab7          	lui	s5,0x80007
800054a4:	80007b37          	lui	s6,0x80007
800054a8:	80007bb7          	lui	s7,0x80007
800054ac:	80007c37          	lui	s8,0x80007
		for (t = first(); t != NULL; t = next(t)) {
800054b0:	02091063          	bnez	s2,800054d0 <z_add_timeout+0x12c>
	node->prev = list->tail;
800054b4:	0044a783          	lw	a5,4(s1)
	node->next = list;
800054b8:	00942023          	sw	s1,0(s0)
	node->prev = list->tail;
800054bc:	00f42223          	sw	a5,4(s0)
	list->tail->next = node;
800054c0:	0044a783          	lw	a5,4(s1)
800054c4:	0087a023          	sw	s0,0(a5)
	list->tail = node;
800054c8:	0084a223          	sw	s0,4(s1)
800054cc:	05c0006f          	j	80005528 <z_add_timeout+0x184>
			__ASSERT(t->dticks >= 0, "");
800054d0:	00892783          	lw	a5,8(s2)
800054d4:	0207d663          	bgez	a5,80005500 <z_add_timeout+0x15c>
800054d8:	3d4b0593          	addi	a1,s6,980 # 800073d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073d5>
800054dc:	05600693          	li	a3,86
800054e0:	3a0a8613          	addi	a2,s5,928 # 800073a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073a1>
800054e4:	ea4b8513          	addi	a0,s7,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800054e8:	8fcfd0ef          	jal	ra,800025e4 <printk>
800054ec:	154c0513          	addi	a0,s8,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800054f0:	8f4fd0ef          	jal	ra,800025e4 <printk>
800054f4:	05600593          	li	a1,86
800054f8:	3a0a8513          	addi	a0,s5,928
800054fc:	924fd0ef          	jal	ra,80002620 <assert_post_action>

			if (t->dticks > to->dticks) {
80005500:	00892703          	lw	a4,8(s2)
80005504:	00842783          	lw	a5,8(s0)
80005508:	0ae7d863          	bge	a5,a4,800055b8 <z_add_timeout+0x214>
				t->dticks -= to->dticks;
8000550c:	40f707b3          	sub	a5,a4,a5
80005510:	00f92423          	sw	a5,8(s2)
	node->prev = successor->prev;
80005514:	00492783          	lw	a5,4(s2)
	node->next = successor;
80005518:	01242023          	sw	s2,0(s0)
	node->prev = successor->prev;
8000551c:	00f42223          	sw	a5,4(s0)
	successor->prev->next = node;
80005520:	0087a023          	sw	s0,0(a5)
	successor->prev = node;
80005524:	00892223          	sw	s0,4(s2)
	return list->head == list;
80005528:	0004a783          	lw	a5,0(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
8000552c:	00978a63          	beq	a5,s1,80005540 <z_add_timeout+0x19c>

		if (t == NULL) {
			sys_dlist_append(&timeout_list, &to->node);
		}

		if (to == first()) {
80005530:	00f41863          	bne	s0,a5,80005540 <z_add_timeout+0x19c>
			z_clock_set_timeout(next_timeout(), false);
80005534:	dedff0ef          	jal	ra,80005320 <next_timeout>
80005538:	00000593          	li	a1,0
8000553c:	bbcfd0ef          	jal	ra,800028f8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005540:	6d8a0513          	addi	a0,s4,1752
80005544:	941ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005548:	02051e63          	bnez	a0,80005584 <z_add_timeout+0x1e0>
8000554c:	80007437          	lui	s0,0x80007
80005550:	800075b7          	lui	a1,0x80007
80005554:	80007537          	lui	a0,0x80007
80005558:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
8000555c:	06100693          	li	a3,97
80005560:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005564:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005568:	87cfd0ef          	jal	ra,800025e4 <printk>
8000556c:	80007537          	lui	a0,0x80007
80005570:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005574:	870fd0ef          	jal	ra,800025e4 <printk>
80005578:	06100593          	li	a1,97
8000557c:	f2c40513          	addi	a0,s0,-212
80005580:	8a0fd0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005584:	3009a9f3          	csrrs	s3,mstatus,s3
		}
	}
}
80005588:	02c12083          	lw	ra,44(sp)
8000558c:	02812403          	lw	s0,40(sp)
80005590:	02412483          	lw	s1,36(sp)
80005594:	02012903          	lw	s2,32(sp)
80005598:	01c12983          	lw	s3,28(sp)
8000559c:	01812a03          	lw	s4,24(sp)
800055a0:	01412a83          	lw	s5,20(sp)
800055a4:	01012b03          	lw	s6,16(sp)
800055a8:	00c12b83          	lw	s7,12(sp)
800055ac:	00812c03          	lw	s8,8(sp)
800055b0:	03010113          	addi	sp,sp,48
800055b4:	00008067          	ret
			to->dticks -= t->dticks;
800055b8:	40e787b3          	sub	a5,a5,a4
800055bc:	00f42423          	sw	a5,8(s0)
	return (node == list->tail) ? NULL : node->next;
800055c0:	0044a783          	lw	a5,4(s1)
800055c4:	ef2788e3          	beq	a5,s2,800054b4 <z_add_timeout+0x110>
800055c8:	00092903          	lw	s2,0(s2)
800055cc:	ee5ff06f          	j	800054b0 <z_add_timeout+0x10c>

800055d0 <z_abort_timeout>:

int z_abort_timeout(struct _timeout *to)
{
800055d0:	fe010113          	addi	sp,sp,-32
800055d4:	00812c23          	sw	s0,24(sp)
800055d8:	01312623          	sw	s3,12(sp)
800055dc:	00112e23          	sw	ra,28(sp)
800055e0:	00912a23          	sw	s1,20(sp)
800055e4:	01212823          	sw	s2,16(sp)
800055e8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800055ec:	00800413          	li	s0,8
800055f0:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800055f4:	800074b7          	lui	s1,0x80007
800055f8:	6d848513          	addi	a0,s1,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800055fc:	00847413          	andi	s0,s0,8
80005600:	85dff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005604:	02051e63          	bnez	a0,80005640 <z_abort_timeout+0x70>
80005608:	80007937          	lui	s2,0x80007
8000560c:	800075b7          	lui	a1,0x80007
80005610:	80007537          	lui	a0,0x80007
80005614:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005618:	04e00693          	li	a3,78
8000561c:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005620:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005624:	fc1fc0ef          	jal	ra,800025e4 <printk>
80005628:	80007537          	lui	a0,0x80007
8000562c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005630:	fb5fc0ef          	jal	ra,800025e4 <printk>
80005634:	04e00593          	li	a1,78
80005638:	f2c90513          	addi	a0,s2,-212
8000563c:	fe5fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005640:	6d848513          	addi	a0,s1,1752
80005644:	871ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	int ret = -EINVAL;

	LOCKED(&timeout_lock) {
		if (sys_dnode_is_linked(&to->node)) {
80005648:	0009a783          	lw	a5,0(s3)
	int ret = -EINVAL;
8000564c:	fea00913          	li	s2,-22
		if (sys_dnode_is_linked(&to->node)) {
80005650:	00078863          	beqz	a5,80005660 <z_abort_timeout+0x90>
			remove_timeout(to);
80005654:	00098513          	mv	a0,s3
80005658:	c89ff0ef          	jal	ra,800052e0 <remove_timeout>
			ret = 0;
8000565c:	00000913          	li	s2,0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005660:	6d848513          	addi	a0,s1,1752
80005664:	821ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005668:	02051e63          	bnez	a0,800056a4 <z_abort_timeout+0xd4>
8000566c:	800074b7          	lui	s1,0x80007
80005670:	800075b7          	lui	a1,0x80007
80005674:	80007537          	lui	a0,0x80007
80005678:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
8000567c:	06100693          	li	a3,97
80005680:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005684:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005688:	f5dfc0ef          	jal	ra,800025e4 <printk>
8000568c:	80007537          	lui	a0,0x80007
80005690:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005694:	f51fc0ef          	jal	ra,800025e4 <printk>
80005698:	06100593          	li	a1,97
8000569c:	f2c48513          	addi	a0,s1,-212
800056a0:	f81fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800056a4:	30042473          	csrrs	s0,mstatus,s0
		}
	}

	return ret;
}
800056a8:	01c12083          	lw	ra,28(sp)
800056ac:	01812403          	lw	s0,24(sp)
800056b0:	00090513          	mv	a0,s2
800056b4:	01412483          	lw	s1,20(sp)
800056b8:	01012903          	lw	s2,16(sp)
800056bc:	00c12983          	lw	s3,12(sp)
800056c0:	02010113          	addi	sp,sp,32
800056c4:	00008067          	ret

800056c8 <z_timeout_remaining>:

s32_t z_timeout_remaining(struct _timeout *timeout)
{
	s32_t ticks = 0;

	if (z_is_inactive_timeout(timeout)) {
800056c8:	00052783          	lw	a5,0(a0)
800056cc:	12078063          	beqz	a5,800057ec <z_timeout_remaining+0x124>
{
800056d0:	fe010113          	addi	sp,sp,-32
800056d4:	00912a23          	sw	s1,20(sp)
800056d8:	01312623          	sw	s3,12(sp)
800056dc:	00112e23          	sw	ra,28(sp)
800056e0:	00812c23          	sw	s0,24(sp)
800056e4:	01212823          	sw	s2,16(sp)
800056e8:	00050993          	mv	s3,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
800056ec:	00800493          	li	s1,8
800056f0:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800056f4:	80007937          	lui	s2,0x80007
800056f8:	6d890513          	addi	a0,s2,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
800056fc:	0084f493          	andi	s1,s1,8
80005700:	f5cff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005704:	02051e63          	bnez	a0,80005740 <z_timeout_remaining+0x78>
80005708:	80007437          	lui	s0,0x80007
8000570c:	800075b7          	lui	a1,0x80007
80005710:	80007537          	lui	a0,0x80007
80005714:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005718:	04e00693          	li	a3,78
8000571c:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005720:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005724:	ec1fc0ef          	jal	ra,800025e4 <printk>
80005728:	80007537          	lui	a0,0x80007
8000572c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005730:	eb5fc0ef          	jal	ra,800025e4 <printk>
80005734:	04e00593          	li	a1,78
80005738:	f2c40513          	addi	a0,s0,-212
8000573c:	ee5fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005740:	6d890513          	addi	a0,s2,1752
80005744:	f70ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	return list->head == list;
80005748:	80007737          	lui	a4,0x80007
8000574c:	53870713          	addi	a4,a4,1336 # 80007538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007539>
80005750:	00072783          	lw	a5,0(a4)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005754:	00000413          	li	s0,0
80005758:	00e78663          	beq	a5,a4,80005764 <z_timeout_remaining+0x9c>
	return (node != NULL) ? sys_dlist_peek_next_no_check(list, node) : NULL;
8000575c:	00472703          	lw	a4,4(a4)
		return 0;
	}

	LOCKED(&timeout_lock) {
		for (struct _timeout *t = first(); t != NULL; t = next(t)) {
80005760:	06079863          	bnez	a5,800057d0 <z_timeout_remaining+0x108>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005764:	6d890513          	addi	a0,s2,1752
80005768:	f1cff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
8000576c:	02051e63          	bnez	a0,800057a8 <z_timeout_remaining+0xe0>
80005770:	80007937          	lui	s2,0x80007
80005774:	800075b7          	lui	a1,0x80007
80005778:	80007537          	lui	a0,0x80007
8000577c:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005780:	06100693          	li	a3,97
80005784:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005788:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
8000578c:	e59fc0ef          	jal	ra,800025e4 <printk>
80005790:	80007537          	lui	a0,0x80007
80005794:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005798:	e4dfc0ef          	jal	ra,800025e4 <printk>
8000579c:	06100593          	li	a1,97
800057a0:	f2c90513          	addi	a0,s2,-212
800057a4:	e7dfc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800057a8:	3004a4f3          	csrrs	s1,mstatus,s1
				break;
			}
		}
	}

	return ticks - elapsed();
800057ac:	b1dff0ef          	jal	ra,800052c8 <elapsed>
800057b0:	40a40533          	sub	a0,s0,a0
}
800057b4:	01c12083          	lw	ra,28(sp)
800057b8:	01812403          	lw	s0,24(sp)
800057bc:	01412483          	lw	s1,20(sp)
800057c0:	01012903          	lw	s2,16(sp)
800057c4:	00c12983          	lw	s3,12(sp)
800057c8:	02010113          	addi	sp,sp,32
800057cc:	00008067          	ret
			ticks += t->dticks;
800057d0:	0087a683          	lw	a3,8(a5)
800057d4:	00d40433          	add	s0,s0,a3
			if (timeout == t) {
800057d8:	f93786e3          	beq	a5,s3,80005764 <z_timeout_remaining+0x9c>
800057dc:	f80784e3          	beqz	a5,80005764 <z_timeout_remaining+0x9c>
	return (node == list->tail) ? NULL : node->next;
800057e0:	f8e782e3          	beq	a5,a4,80005764 <z_timeout_remaining+0x9c>
800057e4:	0007a783          	lw	a5,0(a5)
800057e8:	f79ff06f          	j	80005760 <z_timeout_remaining+0x98>
		return 0;
800057ec:	00000513          	li	a0,0
}
800057f0:	00008067          	ret

800057f4 <z_get_next_timeout_expiry>:

s32_t z_get_next_timeout_expiry(void)
{
800057f4:	ff010113          	addi	sp,sp,-16
800057f8:	00812423          	sw	s0,8(sp)
800057fc:	00112623          	sw	ra,12(sp)
80005800:	00912223          	sw	s1,4(sp)
80005804:	01212023          	sw	s2,0(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005808:	00800413          	li	s0,8
8000580c:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005810:	800074b7          	lui	s1,0x80007
80005814:	6d848513          	addi	a0,s1,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005818:	00847413          	andi	s0,s0,8
8000581c:	e40ff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005820:	02051e63          	bnez	a0,8000585c <z_get_next_timeout_expiry+0x68>
80005824:	80007937          	lui	s2,0x80007
80005828:	800075b7          	lui	a1,0x80007
8000582c:	80007537          	lui	a0,0x80007
80005830:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005834:	04e00693          	li	a3,78
80005838:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000583c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005840:	da5fc0ef          	jal	ra,800025e4 <printk>
80005844:	80007537          	lui	a0,0x80007
80005848:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
8000584c:	d99fc0ef          	jal	ra,800025e4 <printk>
80005850:	04e00593          	li	a1,78
80005854:	f2c90513          	addi	a0,s2,-212
80005858:	dc9fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
8000585c:	6d848513          	addi	a0,s1,1752
80005860:	e54ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	s32_t ret = K_FOREVER;

	LOCKED(&timeout_lock) {
		ret = next_timeout();
80005864:	abdff0ef          	jal	ra,80005320 <next_timeout>
80005868:	00050913          	mv	s2,a0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000586c:	6d848513          	addi	a0,s1,1752
80005870:	e14ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005874:	02051e63          	bnez	a0,800058b0 <z_get_next_timeout_expiry+0xbc>
80005878:	800074b7          	lui	s1,0x80007
8000587c:	800075b7          	lui	a1,0x80007
80005880:	80007537          	lui	a0,0x80007
80005884:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005888:	06100693          	li	a3,97
8000588c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005890:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005894:	d51fc0ef          	jal	ra,800025e4 <printk>
80005898:	80007537          	lui	a0,0x80007
8000589c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800058a0:	d45fc0ef          	jal	ra,800025e4 <printk>
800058a4:	06100593          	li	a1,97
800058a8:	f2c48513          	addi	a0,s1,-212
800058ac:	d75fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800058b0:	30042473          	csrrs	s0,mstatus,s0
	}
	return ret;
}
800058b4:	00c12083          	lw	ra,12(sp)
800058b8:	00812403          	lw	s0,8(sp)
800058bc:	00090513          	mv	a0,s2
800058c0:	00412483          	lw	s1,4(sp)
800058c4:	00012903          	lw	s2,0(sp)
800058c8:	01010113          	addi	sp,sp,16
800058cc:	00008067          	ret

800058d0 <z_set_timeout_expiry>:

void z_set_timeout_expiry(s32_t ticks, bool idle)
{
800058d0:	fe010113          	addi	sp,sp,-32
800058d4:	00812c23          	sw	s0,24(sp)
800058d8:	01212823          	sw	s2,16(sp)
800058dc:	01412423          	sw	s4,8(sp)
800058e0:	00112e23          	sw	ra,28(sp)
800058e4:	00912a23          	sw	s1,20(sp)
800058e8:	01312623          	sw	s3,12(sp)
800058ec:	00050913          	mv	s2,a0
800058f0:	00058a13          	mv	s4,a1
	__asm__ volatile ("csrrc %0, mstatus, %1"
800058f4:	00800413          	li	s0,8
800058f8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800058fc:	800074b7          	lui	s1,0x80007
80005900:	6d848513          	addi	a0,s1,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005904:	00847413          	andi	s0,s0,8
80005908:	d54ff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
8000590c:	02051e63          	bnez	a0,80005948 <z_set_timeout_expiry+0x78>
80005910:	800079b7          	lui	s3,0x80007
80005914:	800075b7          	lui	a1,0x80007
80005918:	80007537          	lui	a0,0x80007
8000591c:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005920:	04e00693          	li	a3,78
80005924:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005928:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
8000592c:	cb9fc0ef          	jal	ra,800025e4 <printk>
80005930:	80007537          	lui	a0,0x80007
80005934:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005938:	cadfc0ef          	jal	ra,800025e4 <printk>
8000593c:	04e00593          	li	a1,78
80005940:	f2c98513          	addi	a0,s3,-212
80005944:	cddfc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005948:	6d848513          	addi	a0,s1,1752
8000594c:	d68ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	LOCKED(&timeout_lock) {
		int next = next_timeout();
80005950:	9d1ff0ef          	jal	ra,80005320 <next_timeout>
		 * what we have.  Also don't try to set a timeout when
		 * one is about to expire: drivers have internal logic
		 * that will bump the timeout to the "next" tick if
		 * it's not considered to be settable as directed.
		 */
		if (sooner && !imminent) {
80005954:	00a95c63          	bge	s2,a0,8000596c <z_set_timeout_expiry+0x9c>
80005958:	00100793          	li	a5,1
8000595c:	00a7d863          	bge	a5,a0,8000596c <z_set_timeout_expiry+0x9c>
			z_clock_set_timeout(ticks, idle);
80005960:	000a0593          	mv	a1,s4
80005964:	00090513          	mv	a0,s2
80005968:	f91fc0ef          	jal	ra,800028f8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
8000596c:	6d848513          	addi	a0,s1,1752
80005970:	d14ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005974:	02051e63          	bnez	a0,800059b0 <z_set_timeout_expiry+0xe0>
80005978:	800074b7          	lui	s1,0x80007
8000597c:	800075b7          	lui	a1,0x80007
80005980:	80007537          	lui	a0,0x80007
80005984:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005988:	06100693          	li	a3,97
8000598c:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005990:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005994:	c51fc0ef          	jal	ra,800025e4 <printk>
80005998:	80007537          	lui	a0,0x80007
8000599c:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800059a0:	c45fc0ef          	jal	ra,800025e4 <printk>
800059a4:	06100593          	li	a1,97
800059a8:	f2c48513          	addi	a0,s1,-212
800059ac:	c75fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800059b0:	30042473          	csrrs	s0,mstatus,s0
		}
	}
}
800059b4:	01c12083          	lw	ra,28(sp)
800059b8:	01812403          	lw	s0,24(sp)
800059bc:	01412483          	lw	s1,20(sp)
800059c0:	01012903          	lw	s2,16(sp)
800059c4:	00c12983          	lw	s3,12(sp)
800059c8:	00812a03          	lw	s4,8(sp)
800059cc:	02010113          	addi	sp,sp,32
800059d0:	00008067          	ret

800059d4 <z_clock_announce>:

void z_clock_announce(s32_t ticks)
{
800059d4:	fd010113          	addi	sp,sp,-48
800059d8:	02812423          	sw	s0,40(sp)
800059dc:	01412c23          	sw	s4,24(sp)
800059e0:	02112623          	sw	ra,44(sp)
800059e4:	02912223          	sw	s1,36(sp)
800059e8:	03212023          	sw	s2,32(sp)
800059ec:	01312e23          	sw	s3,28(sp)
800059f0:	01512a23          	sw	s5,20(sp)
800059f4:	01612823          	sw	s6,16(sp)
800059f8:	01712623          	sw	s7,12(sp)
800059fc:	01812423          	sw	s8,8(sp)
80005a00:	01912223          	sw	s9,4(sp)
80005a04:	01a12023          	sw	s10,0(sp)
80005a08:	00050a13          	mv	s4,a0
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005a0c:	00800413          	li	s0,8
#ifdef CONFIG_TIMESLICING
	z_time_slice(ticks);
80005a10:	e0cfe0ef          	jal	ra,8000401c <z_time_slice>
80005a14:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005a18:	80007937          	lui	s2,0x80007
80005a1c:	6d890513          	addi	a0,s2,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005a20:	00847413          	andi	s0,s0,8
80005a24:	c38ff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005a28:	02051e63          	bnez	a0,80005a64 <z_clock_announce+0x90>
80005a2c:	800074b7          	lui	s1,0x80007
80005a30:	800075b7          	lui	a1,0x80007
80005a34:	80007537          	lui	a0,0x80007
80005a38:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005a3c:	04e00693          	li	a3,78
80005a40:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005a44:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005a48:	b9dfc0ef          	jal	ra,800025e4 <printk>
80005a4c:	80007537          	lui	a0,0x80007
80005a50:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005a54:	b91fc0ef          	jal	ra,800025e4 <printk>
80005a58:	04e00593          	li	a1,78
80005a5c:	f2c48513          	addi	a0,s1,-212
80005a60:	bc1fc0ef          	jal	ra,80002620 <assert_post_action>
#endif

	k_spinlock_key_t key = k_spin_lock(&timeout_lock);

	announce_remaining = ticks;
80005a64:	800079b7          	lui	s3,0x80007
	z_spin_lock_set_owner(l);
80005a68:	6d890513          	addi	a0,s2,1752
80005a6c:	c48ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
80005a70:	800074b7          	lui	s1,0x80007
80005a74:	6d49aa23          	sw	s4,1748(s3) # 800076d4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d5>
	return list->head == list;
80005a78:	80007a37          	lui	s4,0x80007
80005a7c:	6d498993          	addi	s3,s3,1748
80005a80:	538a0a13          	addi	s4,s4,1336 # 80007538 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007539>
80005a84:	6a048493          	addi	s1,s1,1696 # 800076a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a1>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005a88:	80007ab7          	lui	s5,0x80007
80005a8c:	80007bb7          	lui	s7,0x80007
80005a90:	80007b37          	lui	s6,0x80007
80005a94:	80007c37          	lui	s8,0x80007
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005a98:	80007cb7          	lui	s9,0x80007
80005a9c:	000a2d03          	lw	s10,0(s4)
80005aa0:	0009a783          	lw	a5,0(s3)
80005aa4:	0004a683          	lw	a3,0(s1)
80005aa8:	0044a503          	lw	a0,4(s1)
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005aac:	014d0c63          	beq	s10,s4,80005ac4 <z_clock_announce+0xf0>

	while (first() != NULL && first()->dticks <= announce_remaining) {
80005ab0:	000d0a63          	beqz	s10,80005ac4 <z_clock_announce+0xf0>
80005ab4:	008d2703          	lw	a4,8(s10)
80005ab8:	0ae7dc63          	bge	a5,a4,80005b70 <z_clock_announce+0x19c>
		t->fn(t);
		key = k_spin_lock(&timeout_lock);
	}

	if (first() != NULL) {
		first()->dticks -= announce_remaining;
80005abc:	40f70733          	sub	a4,a4,a5
80005ac0:	00ed2423          	sw	a4,8(s10)
	}

	curr_tick += announce_remaining;
80005ac4:	00d786b3          	add	a3,a5,a3
80005ac8:	41f7d713          	srai	a4,a5,0x1f
80005acc:	00a70733          	add	a4,a4,a0
80005ad0:	00f6b7b3          	sltu	a5,a3,a5
80005ad4:	00e787b3          	add	a5,a5,a4
80005ad8:	00d4a023          	sw	a3,0(s1)
80005adc:	00f4a223          	sw	a5,4(s1)
	announce_remaining = 0;
80005ae0:	0009a023          	sw	zero,0(s3)

	z_clock_set_timeout(next_timeout(), false);
80005ae4:	83dff0ef          	jal	ra,80005320 <next_timeout>
80005ae8:	00000593          	li	a1,0
80005aec:	e0dfc0ef          	jal	ra,800028f8 <z_clock_set_timeout>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005af0:	6d890513          	addi	a0,s2,1752
80005af4:	b90ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005af8:	02051e63          	bnez	a0,80005b34 <z_clock_announce+0x160>
80005afc:	800074b7          	lui	s1,0x80007
80005b00:	800075b7          	lui	a1,0x80007
80005b04:	80007537          	lui	a0,0x80007
80005b08:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005b0c:	06100693          	li	a3,97
80005b10:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005b14:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005b18:	acdfc0ef          	jal	ra,800025e4 <printk>
80005b1c:	80007537          	lui	a0,0x80007
80005b20:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005b24:	ac1fc0ef          	jal	ra,800025e4 <printk>
80005b28:	06100593          	li	a1,97
80005b2c:	f2c48513          	addi	a0,s1,-212
80005b30:	af1fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005b34:	30042473          	csrrs	s0,mstatus,s0

	k_spin_unlock(&timeout_lock, key);
}
80005b38:	02c12083          	lw	ra,44(sp)
80005b3c:	02812403          	lw	s0,40(sp)
80005b40:	02412483          	lw	s1,36(sp)
80005b44:	02012903          	lw	s2,32(sp)
80005b48:	01c12983          	lw	s3,28(sp)
80005b4c:	01812a03          	lw	s4,24(sp)
80005b50:	01412a83          	lw	s5,20(sp)
80005b54:	01012b03          	lw	s6,16(sp)
80005b58:	00c12b83          	lw	s7,12(sp)
80005b5c:	00812c03          	lw	s8,8(sp)
80005b60:	00412c83          	lw	s9,4(sp)
80005b64:	00012d03          	lw	s10,0(sp)
80005b68:	03010113          	addi	sp,sp,48
80005b6c:	00008067          	ret
		curr_tick += dt;
80005b70:	00d706b3          	add	a3,a4,a3
80005b74:	41f75593          	srai	a1,a4,0x1f
80005b78:	00a585b3          	add	a1,a1,a0
80005b7c:	00e6b633          	sltu	a2,a3,a4
80005b80:	00b60633          	add	a2,a2,a1
		announce_remaining -= dt;
80005b84:	40e787b3          	sub	a5,a5,a4
		remove_timeout(t);
80005b88:	000d0513          	mv	a0,s10
		t->dticks = 0;
80005b8c:	000d2423          	sw	zero,8(s10)
		curr_tick += dt;
80005b90:	00d4a023          	sw	a3,0(s1)
80005b94:	00c4a223          	sw	a2,4(s1)
		announce_remaining -= dt;
80005b98:	00f9a023          	sw	a5,0(s3)
		remove_timeout(t);
80005b9c:	f44ff0ef          	jal	ra,800052e0 <remove_timeout>
80005ba0:	6d890513          	addi	a0,s2,1752
80005ba4:	ae0ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005ba8:	02051663          	bnez	a0,80005bd4 <z_clock_announce+0x200>
80005bac:	f74b8593          	addi	a1,s7,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005bb0:	06100693          	li	a3,97
80005bb4:	f2ca8613          	addi	a2,s5,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005bb8:	ea4b0513          	addi	a0,s6,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005bbc:	a29fc0ef          	jal	ra,800025e4 <printk>
80005bc0:	f8cc0513          	addi	a0,s8,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005bc4:	a21fc0ef          	jal	ra,800025e4 <printk>
80005bc8:	06100593          	li	a1,97
80005bcc:	f2ca8513          	addi	a0,s5,-212
80005bd0:	a51fc0ef          	jal	ra,80002620 <assert_post_action>
80005bd4:	30042473          	csrrs	s0,mstatus,s0
		t->fn(t);
80005bd8:	00cd2783          	lw	a5,12(s10)
80005bdc:	000d0513          	mv	a0,s10
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005be0:	00800413          	li	s0,8
80005be4:	000780e7          	jalr	a5
80005be8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005bec:	6d890513          	addi	a0,s2,1752
	key = (mstatus & SOC_MSTATUS_IEN);
80005bf0:	00847413          	andi	s0,s0,8
80005bf4:	a68ff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005bf8:	02051863          	bnez	a0,80005c28 <z_clock_announce+0x254>
80005bfc:	f44c8593          	addi	a1,s9,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005c00:	04e00693          	li	a3,78
80005c04:	f2ca8613          	addi	a2,s5,-212
80005c08:	ea4b0513          	addi	a0,s6,-348
80005c0c:	9d9fc0ef          	jal	ra,800025e4 <printk>
80005c10:	80007537          	lui	a0,0x80007
80005c14:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005c18:	9cdfc0ef          	jal	ra,800025e4 <printk>
80005c1c:	04e00593          	li	a1,78
80005c20:	f2ca8513          	addi	a0,s5,-212
80005c24:	9fdfc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005c28:	6d890513          	addi	a0,s2,1752
80005c2c:	a88ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	return k;
80005c30:	e6dff06f          	j	80005a9c <z_clock_announce+0xc8>

80005c34 <z_tick_get>:
{
	can_wait_forever = 1;
}

s64_t z_tick_get(void)
{
80005c34:	fe010113          	addi	sp,sp,-32
80005c38:	00912a23          	sw	s1,20(sp)
80005c3c:	00112e23          	sw	ra,28(sp)
80005c40:	00812c23          	sw	s0,24(sp)
80005c44:	01212823          	sw	s2,16(sp)
80005c48:	01312623          	sw	s3,12(sp)
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005c4c:	00800493          	li	s1,8
80005c50:	3004b4f3          	csrrc	s1,mstatus,s1
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005c54:	80007937          	lui	s2,0x80007
80005c58:	6d890513          	addi	a0,s2,1752 # 800076d8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076d9>
	key = (mstatus & SOC_MSTATUS_IEN);
80005c5c:	0084f493          	andi	s1,s1,8
80005c60:	9fcff0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005c64:	02051e63          	bnez	a0,80005ca0 <z_tick_get+0x6c>
80005c68:	80007437          	lui	s0,0x80007
80005c6c:	800075b7          	lui	a1,0x80007
80005c70:	80007537          	lui	a0,0x80007
80005c74:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005c78:	04e00693          	li	a3,78
80005c7c:	f2c40613          	addi	a2,s0,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005c80:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005c84:	961fc0ef          	jal	ra,800025e4 <printk>
80005c88:	80007537          	lui	a0,0x80007
80005c8c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005c90:	955fc0ef          	jal	ra,800025e4 <printk>
80005c94:	04e00593          	li	a1,78
80005c98:	f2c40513          	addi	a0,s0,-212
80005c9c:	985fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005ca0:	6d890513          	addi	a0,s2,1752
80005ca4:	a10ff0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	u64_t t = 0U;

	LOCKED(&timeout_lock) {
		t = curr_tick + z_clock_elapsed();
80005ca8:	df9fc0ef          	jal	ra,80002aa0 <z_clock_elapsed>
80005cac:	800077b7          	lui	a5,0x80007
80005cb0:	6a078793          	addi	a5,a5,1696 # 800076a0 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076a1>
80005cb4:	0007a983          	lw	s3,0(a5)
80005cb8:	0047a403          	lw	s0,4(a5)
80005cbc:	013509b3          	add	s3,a0,s3
80005cc0:	00a9b533          	sltu	a0,s3,a0
80005cc4:	00850433          	add	s0,a0,s0
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80005cc8:	6d890513          	addi	a0,s2,1752
80005ccc:	9b8ff0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80005cd0:	02051e63          	bnez	a0,80005d0c <z_tick_get+0xd8>
80005cd4:	80007937          	lui	s2,0x80007
80005cd8:	800075b7          	lui	a1,0x80007
80005cdc:	80007537          	lui	a0,0x80007
80005ce0:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80005ce4:	06100693          	li	a3,97
80005ce8:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005cec:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005cf0:	8f5fc0ef          	jal	ra,800025e4 <printk>
80005cf4:	80007537          	lui	a0,0x80007
80005cf8:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
80005cfc:	8e9fc0ef          	jal	ra,800025e4 <printk>
80005d00:	06100593          	li	a1,97
80005d04:	f2c90513          	addi	a0,s2,-212
80005d08:	919fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
80005d0c:	3004a4f3          	csrrs	s1,mstatus,s1
	}
	return t;
}
80005d10:	00040593          	mv	a1,s0
80005d14:	01c12083          	lw	ra,28(sp)
80005d18:	01812403          	lw	s0,24(sp)
80005d1c:	00098513          	mv	a0,s3
80005d20:	01412483          	lw	s1,20(sp)
80005d24:	01012903          	lw	s2,16(sp)
80005d28:	00c12983          	lw	s3,12(sp)
80005d2c:	02010113          	addi	sp,sp,32
80005d30:	00008067          	ret

80005d34 <z_tick_get_32>:

u32_t z_tick_get_32(void)
{
80005d34:	ff010113          	addi	sp,sp,-16
80005d38:	00112623          	sw	ra,12(sp)
#ifdef CONFIG_TICKLESS_KERNEL
	return (u32_t)z_tick_get();
80005d3c:	ef9ff0ef          	jal	ra,80005c34 <z_tick_get>
#else
	return (u32_t)curr_tick;
#endif
}
80005d40:	00c12083          	lw	ra,12(sp)
80005d44:	01010113          	addi	sp,sp,16
80005d48:	00008067          	ret

80005d4c <z_impl_k_uptime_get>:
	return z_impl_k_uptime_get_32();
}
#endif

s64_t z_impl_k_uptime_get(void)
{
80005d4c:	ff010113          	addi	sp,sp,-16
80005d50:	00112623          	sw	ra,12(sp)
	return __ticks_to_ms(z_tick_get());
80005d54:	ee1ff0ef          	jal	ra,80005c34 <z_tick_get>
	return (u64_t)ticks * MSEC_PER_SEC / (u64_t)CONFIG_SYS_CLOCK_TICKS_PER_SEC;
80005d58:	3e800613          	li	a2,1000
80005d5c:	00000693          	li	a3,0
80005d60:	b49fa0ef          	jal	ra,800008a8 <__muldi3>
80005d64:	06400613          	li	a2,100
80005d68:	00000693          	li	a3,0
80005d6c:	d44fa0ef          	jal	ra,800002b0 <__udivdi3>
}
80005d70:	00c12083          	lw	ra,12(sp)
80005d74:	01010113          	addi	sp,sp,16
80005d78:	00008067          	ret

80005d7c <z_timer_expiration_handler>:

	/*
	 * if the timer is periodic, start it again; don't add _TICK_ALIGN
	 * since we're already aligned to a tick boundary
	 */
	if (timer->period > 0) {
80005d7c:	02052603          	lw	a2,32(a0)
{
80005d80:	ff010113          	addi	sp,sp,-16
80005d84:	00812423          	sw	s0,8(sp)
80005d88:	00112623          	sw	ra,12(sp)
80005d8c:	00912223          	sw	s1,4(sp)
80005d90:	00050413          	mv	s0,a0
	if (timer->period > 0) {
80005d94:	00c05863          	blez	a2,80005da4 <z_timer_expiration_handler+0x28>
		z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005d98:	800065b7          	lui	a1,0x80006
80005d9c:	d7c58593          	addi	a1,a1,-644 # 80005d7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d7d>
80005da0:	e04ff0ef          	jal	ra,800053a4 <z_add_timeout>
			     timer->period);
	}

	/* update timer's status */
	timer->status += 1U;
80005da4:	02442783          	lw	a5,36(s0)
80005da8:	00178793          	addi	a5,a5,1
80005dac:	02f42223          	sw	a5,36(s0)

	/* invoke timer expiry function */
	if (timer->expiry_fn != NULL) {
80005db0:	01842783          	lw	a5,24(s0)
80005db4:	00078663          	beqz	a5,80005dc0 <z_timer_expiration_handler+0x44>
		timer->expiry_fn(timer);
80005db8:	00040513          	mv	a0,s0
80005dbc:	000780e7          	jalr	a5
	return list->head == list;
80005dc0:	01042483          	lw	s1,16(s0)
	sys_dlist_init(&w->waitq);
}

static inline struct k_thread *z_waitq_head(_wait_q_t *w)
{
	return (void *)sys_dlist_peek_head(&w->waitq);
80005dc4:	01040413          	addi	s0,s0,16
	return sys_dlist_is_empty(list) ? NULL : list->head;
80005dc8:	02848863          	beq	s1,s0,80005df8 <z_timer_expiration_handler+0x7c>
	}

	thread = z_waitq_head(&timer->wait_q);

	if (thread == NULL) {
80005dcc:	02048663          	beqz	s1,80005df8 <z_timer_expiration_handler+0x7c>
	 * place a thread can be taken off this pend queue, and b) the
	 * only place a thread can be put on the pend queue is at
	 * thread level, which of course cannot interrupt the current
	 * context.
	 */
	z_unpend_thread_no_timeout(thread);
80005dd0:	00048513          	mv	a0,s1
80005dd4:	f70fd0ef          	jal	ra,80003544 <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005dd8:	00d4c783          	lbu	a5,13(s1)
80005ddc:	01f7f793          	andi	a5,a5,31
80005de0:	00079a63          	bnez	a5,80005df4 <z_timer_expiration_handler+0x78>
	if (z_is_thread_ready(thread)) {
80005de4:	0184a783          	lw	a5,24(s1)
80005de8:	00079663          	bnez	a5,80005df4 <z_timer_expiration_handler+0x78>
		z_add_thread_to_ready_q(thread);
80005dec:	00048513          	mv	a0,s1
80005df0:	d9dfd0ef          	jal	ra,80003b8c <z_add_thread_to_ready_q>
80005df4:	0604a623          	sw	zero,108(s1)

	z_ready_thread(thread);

	z_set_thread_return_value(thread, 0);
}
80005df8:	00c12083          	lw	ra,12(sp)
80005dfc:	00812403          	lw	s0,8(sp)
80005e00:	00412483          	lw	s1,4(sp)
80005e04:	01010113          	addi	sp,sp,16
80005e08:	00008067          	ret

80005e0c <k_timer_init>:
	sys_dlist_init(&w->waitq);
80005e0c:	01050793          	addi	a5,a0,16

void k_timer_init(struct k_timer *timer,
			 k_timer_expiry_t expiry_fn,
			 k_timer_stop_t stop_fn)
{
	timer->expiry_fn = expiry_fn;
80005e10:	00b52c23          	sw	a1,24(a0)
	timer->stop_fn = stop_fn;
80005e14:	00c52e23          	sw	a2,28(a0)
	timer->status = 0U;
80005e18:	02052223          	sw	zero,36(a0)
	list->head = (sys_dnode_t *)list;
80005e1c:	00f52823          	sw	a5,16(a0)
	list->tail = (sys_dnode_t *)list;
80005e20:	00f52a23          	sw	a5,20(a0)
	node->next = NULL;
80005e24:	00052023          	sw	zero,0(a0)
	node->prev = NULL;
80005e28:	00052223          	sw	zero,4(a0)

	z_waitq_init(&timer->wait_q);
	z_init_timeout(&timer->timeout, z_timer_expiration_handler);
	SYS_TRACING_OBJ_INIT(k_timer, timer);

	timer->user_data = NULL;
80005e2c:	02052423          	sw	zero,40(a0)

	z_object_init(timer);
}
80005e30:	00008067          	ret

80005e34 <z_impl_k_timer_start>:


void z_impl_k_timer_start(struct k_timer *timer, s32_t duration, s32_t period)
{
80005e34:	fd010113          	addi	sp,sp,-48
80005e38:	02812423          	sw	s0,40(sp)
80005e3c:	02912223          	sw	s1,36(sp)
80005e40:	03212023          	sw	s2,32(sp)
80005e44:	02112623          	sw	ra,44(sp)
80005e48:	01312e23          	sw	s3,28(sp)
80005e4c:	00050413          	mv	s0,a0
80005e50:	00058493          	mv	s1,a1
80005e54:	00060913          	mv	s2,a2
	__ASSERT(duration >= 0 && period >= 0 &&
80005e58:	0005c863          	bltz	a1,80005e68 <z_impl_k_timer_start+0x34>
80005e5c:	00064663          	bltz	a2,80005e68 <z_impl_k_timer_start+0x34>
80005e60:	00c5e7b3          	or	a5,a1,a2
80005e64:	02079e63          	bnez	a5,80005ea0 <z_impl_k_timer_start+0x6c>
80005e68:	800079b7          	lui	s3,0x80007
80005e6c:	800075b7          	lui	a1,0x80007
80005e70:	80007537          	lui	a0,0x80007
80005e74:	3f858593          	addi	a1,a1,1016 # 800073f8 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073f9>
80005e78:	07300693          	li	a3,115
80005e7c:	3e498613          	addi	a2,s3,996 # 800073e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073e5>
80005e80:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005e84:	f60fc0ef          	jal	ra,800025e4 <printk>
80005e88:	80007537          	lui	a0,0x80007
80005e8c:	43850513          	addi	a0,a0,1080 # 80007438 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007439>
80005e90:	f54fc0ef          	jal	ra,800025e4 <printk>
80005e94:	07300593          	li	a1,115
80005e98:	3e498513          	addi	a0,s3,996
80005e9c:	f84fc0ef          	jal	ra,80002620 <assert_post_action>
	return (s32_t)ceiling_fraction(ms, ms_per_tick);
80005ea0:	00a00593          	li	a1,10
80005ea4:	00990513          	addi	a0,s2,9
80005ea8:	a91fa0ef          	jal	ra,80000938 <__divsi3>
		 (duration != 0 || period != 0), "invalid parameters\n");

	volatile s32_t period_in_ticks, duration_in_ticks;

	period_in_ticks = z_ms_to_ticks(period);
80005eac:	00a12423          	sw	a0,8(sp)
80005eb0:	00a00593          	li	a1,10
80005eb4:	00948513          	addi	a0,s1,9
80005eb8:	a81fa0ef          	jal	ra,80000938 <__divsi3>
	duration_in_ticks = z_ms_to_ticks(duration);
80005ebc:	00a12623          	sw	a0,12(sp)

	(void)z_abort_timeout(&timer->timeout);
80005ec0:	00040513          	mv	a0,s0
80005ec4:	f0cff0ef          	jal	ra,800055d0 <z_abort_timeout>
	timer->period = period_in_ticks;
80005ec8:	00812783          	lw	a5,8(sp)
	timer->status = 0U;
80005ecc:	02042223          	sw	zero,36(s0)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005ed0:	00040513          	mv	a0,s0
	timer->period = period_in_ticks;
80005ed4:	02f42023          	sw	a5,32(s0)
		     duration_in_ticks);
}
80005ed8:	02812403          	lw	s0,40(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005edc:	00c12603          	lw	a2,12(sp)
}
80005ee0:	02c12083          	lw	ra,44(sp)
80005ee4:	02412483          	lw	s1,36(sp)
80005ee8:	02012903          	lw	s2,32(sp)
80005eec:	01c12983          	lw	s3,28(sp)
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005ef0:	800065b7          	lui	a1,0x80006
80005ef4:	d7c58593          	addi	a1,a1,-644 # 80005d7c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80005d7d>
}
80005ef8:	03010113          	addi	sp,sp,48
	z_add_timeout(&timer->timeout, z_timer_expiration_handler,
80005efc:	ca8ff06f          	j	800053a4 <z_add_timeout>

80005f00 <z_impl_k_timer_stop>:
	return 0;
}
#endif

void z_impl_k_timer_stop(struct k_timer *timer)
{
80005f00:	ff010113          	addi	sp,sp,-16
80005f04:	00812423          	sw	s0,8(sp)
80005f08:	00112623          	sw	ra,12(sp)
80005f0c:	00050413          	mv	s0,a0
	int inactive = z_abort_timeout(&timer->timeout) != 0;
80005f10:	ec0ff0ef          	jal	ra,800055d0 <z_abort_timeout>

	if (inactive) {
80005f14:	06051263          	bnez	a0,80005f78 <z_impl_k_timer_stop+0x78>
		return;
	}

	if (timer->stop_fn != NULL) {
80005f18:	01c42783          	lw	a5,28(s0)
80005f1c:	00078663          	beqz	a5,80005f28 <z_impl_k_timer_stop+0x28>
		timer->stop_fn(timer);
80005f20:	00040513          	mv	a0,s0
80005f24:	000780e7          	jalr	a5
	struct k_thread *thread = z_find_first_thread_to_unpend(wait_q, NULL);
80005f28:	01040513          	addi	a0,s0,16
80005f2c:	00000593          	li	a1,0
80005f30:	d28fd0ef          	jal	ra,80003458 <z_find_first_thread_to_unpend>
80005f34:	00050413          	mv	s0,a0
	if (thread != NULL) {
80005f38:	04050063          	beqz	a0,80005f78 <z_impl_k_timer_stop+0x78>
		z_unpend_thread_no_timeout(thread);
80005f3c:	e08fd0ef          	jal	ra,80003544 <z_unpend_thread_no_timeout>
	return !((z_is_thread_prevented_from_running(thread)) != 0 ||
80005f40:	00d44783          	lbu	a5,13(s0)
80005f44:	01f7f793          	andi	a5,a5,31
80005f48:	00079a63          	bnez	a5,80005f5c <z_impl_k_timer_stop+0x5c>
	if (z_is_thread_ready(thread)) {
80005f4c:	01842783          	lw	a5,24(s0)
80005f50:	00079663          	bnez	a5,80005f5c <z_impl_k_timer_stop+0x5c>
		z_add_thread_to_ready_q(thread);
80005f54:	00040513          	mv	a0,s0
80005f58:	c35fd0ef          	jal	ra,80003b8c <z_add_thread_to_ready_q>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80005f5c:	00800513          	li	a0,8
80005f60:	30053573          	csrrc	a0,mstatus,a0

	if (pending_thread != NULL) {
		z_ready_thread(pending_thread);
		z_reschedule_unlocked();
	}
}
80005f64:	00812403          	lw	s0,8(sp)
80005f68:	00c12083          	lw	ra,12(sp)
	(void) z_reschedule_irqlock(z_arch_irq_lock());
80005f6c:	00857513          	andi	a0,a0,8
80005f70:	01010113          	addi	sp,sp,16
80005f74:	fa0fd06f          	j	80003714 <z_reschedule_irqlock>
80005f78:	00c12083          	lw	ra,12(sp)
80005f7c:	00812403          	lw	s0,8(sp)
80005f80:	01010113          	addi	sp,sp,16
80005f84:	00008067          	ret

80005f88 <z_impl_k_timer_status_get>:
#ifdef CONFIG_USERSPACE
Z_SYSCALL_HANDLER1_SIMPLE_VOID(k_timer_stop, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_get(struct k_timer *timer)
{
80005f88:	fe010113          	addi	sp,sp,-32
80005f8c:	00812c23          	sw	s0,24(sp)
80005f90:	01212823          	sw	s2,16(sp)
80005f94:	00112e23          	sw	ra,28(sp)
80005f98:	00912a23          	sw	s1,20(sp)
80005f9c:	01312623          	sw	s3,12(sp)
80005fa0:	00050913          	mv	s2,a0
80005fa4:	00800413          	li	s0,8
80005fa8:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80005fac:	800074b7          	lui	s1,0x80007
80005fb0:	6dc48513          	addi	a0,s1,1756 # 800076dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076dd>
	key = (mstatus & SOC_MSTATUS_IEN);
80005fb4:	00847413          	andi	s0,s0,8
80005fb8:	ea5fe0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80005fbc:	02051e63          	bnez	a0,80005ff8 <z_impl_k_timer_status_get+0x70>
80005fc0:	800079b7          	lui	s3,0x80007
80005fc4:	800075b7          	lui	a1,0x80007
80005fc8:	80007537          	lui	a0,0x80007
80005fcc:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80005fd0:	04e00693          	li	a3,78
80005fd4:	f2c98613          	addi	a2,s3,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80005fd8:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80005fdc:	e08fc0ef          	jal	ra,800025e4 <printk>
80005fe0:	80007537          	lui	a0,0x80007
80005fe4:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80005fe8:	dfcfc0ef          	jal	ra,800025e4 <printk>
80005fec:	04e00593          	li	a1,78
80005ff0:	f2c98513          	addi	a0,s3,-212
80005ff4:	e2cfc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80005ff8:	6dc48513          	addi	a0,s1,1756
80005ffc:	eb9fe0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
80006000:	6dc48513          	addi	a0,s1,1756
	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
80006004:	02492983          	lw	s3,36(s2)

	timer->status = 0U;
80006008:	02092223          	sw	zero,36(s2)
8000600c:	e79fe0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
80006010:	02051e63          	bnez	a0,8000604c <z_impl_k_timer_status_get+0xc4>
80006014:	800074b7          	lui	s1,0x80007
80006018:	800075b7          	lui	a1,0x80007
8000601c:	80007537          	lui	a0,0x80007
80006020:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
80006024:	06100693          	li	a3,97
80006028:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
8000602c:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80006030:	db4fc0ef          	jal	ra,800025e4 <printk>
80006034:	80007537          	lui	a0,0x80007
80006038:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
8000603c:	da8fc0ef          	jal	ra,800025e4 <printk>
80006040:	06100593          	li	a1,97
80006044:	f2c48513          	addi	a0,s1,-212
80006048:	dd8fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
8000604c:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
80006050:	01c12083          	lw	ra,28(sp)
80006054:	01812403          	lw	s0,24(sp)
80006058:	00098513          	mv	a0,s3
8000605c:	01412483          	lw	s1,20(sp)
80006060:	01012903          	lw	s2,16(sp)
80006064:	00c12983          	lw	s3,12(sp)
80006068:	02010113          	addi	sp,sp,32
8000606c:	00008067          	ret

80006070 <z_impl_k_timer_status_sync>:
Z_SYSCALL_HANDLER1_SIMPLE(k_timer_status_get, K_OBJ_TIMER, struct k_timer *);
#endif

u32_t z_impl_k_timer_status_sync(struct k_timer *timer)
{
	__ASSERT(!z_is_in_isr(), "");
80006070:	800087b7          	lui	a5,0x80008
80006074:	8c47a783          	lw	a5,-1852(a5) # 800078c4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800078c5>
{
80006078:	fe010113          	addi	sp,sp,-32
8000607c:	01312623          	sw	s3,12(sp)
80006080:	00112e23          	sw	ra,28(sp)
80006084:	00812c23          	sw	s0,24(sp)
80006088:	00912a23          	sw	s1,20(sp)
8000608c:	01212823          	sw	s2,16(sp)
80006090:	00050993          	mv	s3,a0
	__ASSERT(!z_is_in_isr(), "");
80006094:	02078e63          	beqz	a5,800060d0 <z_impl_k_timer_status_sync+0x60>
80006098:	80007437          	lui	s0,0x80007
8000609c:	800075b7          	lui	a1,0x80007
800060a0:	80007537          	lui	a0,0x80007
800060a4:	13c58593          	addi	a1,a1,316 # 8000713c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x8000713d>
800060a8:	0ba00693          	li	a3,186
800060ac:	3e440613          	addi	a2,s0,996 # 800073e4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800073e5>
800060b0:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800060b4:	d30fc0ef          	jal	ra,800025e4 <printk>
800060b8:	80007537          	lui	a0,0x80007
800060bc:	15450513          	addi	a0,a0,340 # 80007154 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007155>
800060c0:	d24fc0ef          	jal	ra,800025e4 <printk>
800060c4:	0ba00593          	li	a1,186
800060c8:	3e440513          	addi	a0,s0,996
800060cc:	d54fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrc %0, mstatus, %1"
800060d0:	00800413          	li	s0,8
800060d4:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
800060d8:	800074b7          	lui	s1,0x80007
800060dc:	6dc48513          	addi	a0,s1,1756 # 800076dc <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x800076dd>
	key = (mstatus & SOC_MSTATUS_IEN);
800060e0:	00847413          	andi	s0,s0,8
800060e4:	d79fe0ef          	jal	ra,80004e5c <z_spin_lock_valid>
800060e8:	02051e63          	bnez	a0,80006124 <z_impl_k_timer_status_sync+0xb4>
800060ec:	80007937          	lui	s2,0x80007
800060f0:	800075b7          	lui	a1,0x80007
800060f4:	80007537          	lui	a0,0x80007
800060f8:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
800060fc:	04e00693          	li	a3,78
80006100:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80006104:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80006108:	cdcfc0ef          	jal	ra,800025e4 <printk>
8000610c:	80007537          	lui	a0,0x80007
80006110:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80006114:	cd0fc0ef          	jal	ra,800025e4 <printk>
80006118:	04e00593          	li	a1,78
8000611c:	f2c90513          	addi	a0,s2,-212
80006120:	d00fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
80006124:	6dc48513          	addi	a0,s1,1756
80006128:	d8dfe0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>

	k_spinlock_key_t key = k_spin_lock(&lock);
	u32_t result = timer->status;
8000612c:	0249a903          	lw	s2,36(s3)

	if (result == 0U) {
80006130:	06091e63          	bnez	s2,800061ac <z_impl_k_timer_status_sync+0x13c>
		if (!z_is_inactive_timeout(&timer->timeout)) {
80006134:	0009a783          	lw	a5,0(s3)
80006138:	06078a63          	beqz	a5,800061ac <z_impl_k_timer_status_sync+0x13c>
			/* wait for timer to expire or stop */
			(void)z_pend_curr(&lock, key, &timer->wait_q, K_FOREVER);
8000613c:	00040593          	mv	a1,s0
80006140:	fff00693          	li	a3,-1
80006144:	01098613          	addi	a2,s3,16
80006148:	6dc48513          	addi	a0,s1,1756
8000614c:	988fe0ef          	jal	ra,800042d4 <z_pend_curr>
	__asm__ volatile ("csrrc %0, mstatus, %1"
80006150:	00800413          	li	s0,8
80006154:	30043473          	csrrc	s0,mstatus,s0
	__ASSERT(z_spin_lock_valid(l), "Recursive spinlock");
80006158:	6dc48513          	addi	a0,s1,1756
	key = (mstatus & SOC_MSTATUS_IEN);
8000615c:	00847413          	andi	s0,s0,8
80006160:	cfdfe0ef          	jal	ra,80004e5c <z_spin_lock_valid>
80006164:	02051e63          	bnez	a0,800061a0 <z_impl_k_timer_status_sync+0x130>
80006168:	80007937          	lui	s2,0x80007
8000616c:	800075b7          	lui	a1,0x80007
80006170:	80007537          	lui	a0,0x80007
80006174:	f4458593          	addi	a1,a1,-188 # 80006f44 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f45>
80006178:	04e00693          	li	a3,78
8000617c:	f2c90613          	addi	a2,s2,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
80006180:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
80006184:	c60fc0ef          	jal	ra,800025e4 <printk>
80006188:	80007537          	lui	a0,0x80007
8000618c:	f5c50513          	addi	a0,a0,-164 # 80006f5c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f5d>
80006190:	c54fc0ef          	jal	ra,800025e4 <printk>
80006194:	04e00593          	li	a1,78
80006198:	f2c90513          	addi	a0,s2,-212
8000619c:	c84fc0ef          	jal	ra,80002620 <assert_post_action>
	z_spin_lock_set_owner(l);
800061a0:	6dc48513          	addi	a0,s1,1756
800061a4:	d11fe0ef          	jal	ra,80004eb4 <z_spin_lock_set_owner>

			/* get updated timer status */
			key = k_spin_lock(&lock);
			result = timer->status;
800061a8:	0249a903          	lw	s2,36(s3)
		}
	} else {
		/* timer has already expired at least once */
	}

	timer->status = 0U;
800061ac:	0209a223          	sw	zero,36(s3)
	__ASSERT(z_spin_unlock_valid(l), "Not my spinlock!");
800061b0:	6dc48513          	addi	a0,s1,1756
800061b4:	cd1fe0ef          	jal	ra,80004e84 <z_spin_unlock_valid>
800061b8:	02051e63          	bnez	a0,800061f4 <z_impl_k_timer_status_sync+0x184>
800061bc:	800074b7          	lui	s1,0x80007
800061c0:	800075b7          	lui	a1,0x80007
800061c4:	80007537          	lui	a0,0x80007
800061c8:	f7458593          	addi	a1,a1,-140 # 80006f74 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f75>
800061cc:	06100693          	li	a3,97
800061d0:	f2c48613          	addi	a2,s1,-212 # 80006f2c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f2d>
800061d4:	ea450513          	addi	a0,a0,-348 # 80006ea4 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006ea5>
800061d8:	c0cfc0ef          	jal	ra,800025e4 <printk>
800061dc:	80007537          	lui	a0,0x80007
800061e0:	f8c50513          	addi	a0,a0,-116 # 80006f8c <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80006f8d>
800061e4:	c00fc0ef          	jal	ra,800025e4 <printk>
800061e8:	06100593          	li	a1,97
800061ec:	f2c48513          	addi	a0,s1,-212
800061f0:	c30fc0ef          	jal	ra,80002620 <assert_post_action>
	__asm__ volatile ("csrrs %0, mstatus, %1"
800061f4:	30042473          	csrrs	s0,mstatus,s0
	k_spin_unlock(&lock, key);

	return result;
}
800061f8:	01c12083          	lw	ra,28(sp)
800061fc:	01812403          	lw	s0,24(sp)
80006200:	00090513          	mv	a0,s2
80006204:	01412483          	lw	s1,20(sp)
80006208:	01012903          	lw	s2,16(sp)
8000620c:	00c12983          	lw	s3,12(sp)
80006210:	02010113          	addi	sp,sp,32
80006214:	00008067          	ret

80006218 <init_static_pools>:
	z_waitq_init(&p->wait_q);
	z_sys_mem_pool_base_init(&p->base);
}

int init_static_pools(struct device *unused)
{
80006218:	ff010113          	addi	sp,sp,-16
8000621c:	00812423          	sw	s0,8(sp)
80006220:	00912223          	sw	s1,4(sp)
	ARG_UNUSED(unused);
	struct k_mem_pool *p;

	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006224:	80007437          	lui	s0,0x80007
80006228:	800074b7          	lui	s1,0x80007
{
8000622c:	00112623          	sw	ra,12(sp)
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006230:	68040413          	addi	s0,s0,1664 # 80007680 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007681>
80006234:	68048493          	addi	s1,s1,1664 # 80007680 <CONFIG_OFFLOAD_WORKQUEUE_PRIORITY+0x80007681>
80006238:	00946e63          	bltu	s0,s1,80006254 <init_static_pools+0x3c>
		k_mem_pool_init(p);
	}

	return 0;
}
8000623c:	00c12083          	lw	ra,12(sp)
80006240:	00812403          	lw	s0,8(sp)
80006244:	00412483          	lw	s1,4(sp)
80006248:	00000513          	li	a0,0
8000624c:	01010113          	addi	sp,sp,16
80006250:	00008067          	ret
80006254:	01440793          	addi	a5,s0,20
	z_sys_mem_pool_base_init(&p->base);
80006258:	00040513          	mv	a0,s0
	list->head = (sys_dnode_t *)list;
8000625c:	00f42a23          	sw	a5,20(s0)
	list->tail = (sys_dnode_t *)list;
80006260:	00f42c23          	sw	a5,24(s0)
80006264:	bcdfb0ef          	jal	ra,80001e30 <z_sys_mem_pool_base_init>
	for (p = _k_mem_pool_list_start; p < _k_mem_pool_list_end; p++) {
80006268:	01c40413          	addi	s0,s0,28
8000626c:	fcdff06f          	j	80006238 <init_static_pools+0x20>

80006270 <_OffsetAbsSyms>:
 * point regs
 */
GEN_ABSOLUTE_SYM(_K_THREAD_NO_FLOAT_SIZEOF,
		 STACK_ROUND_UP(sizeof(struct k_thread)));

GEN_ABS_SYM_END
80006270:	00008067          	ret
