"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RepositoryVisibility = exports.GitHubRepository = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const codestar = require("aws-cdk-lib/aws-codestar");
/**
 * (experimental) The GitHubRepository resource.
 *
 * @experimental
 */
class GitHubRepository extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_codestar_alpha_GitHubRepositoryProps(props);
        const resource = new codestar.CfnGitHubRepository(this, 'Resource', {
            repositoryOwner: props.owner,
            repositoryName: props.repositoryName,
            repositoryAccessToken: props.accessToken.toString(),
            code: {
                s3: {
                    bucket: props.contentsBucket.bucketName,
                    key: props.contentsKey,
                    objectVersion: props.contentsS3Version,
                },
            },
            enableIssues: (_b = props.enableIssues) !== null && _b !== void 0 ? _b : true,
            isPrivate: props.visibility === RepositoryVisibility.PRIVATE ? true : false,
            repositoryDescription: props.description,
        });
        this.owner = cdk.Fn.select(0, cdk.Fn.split('/', resource.ref));
        this.repo = cdk.Fn.select(1, cdk.Fn.split('/', resource.ref));
    }
}
exports.GitHubRepository = GitHubRepository;
_a = JSII_RTTI_SYMBOL_1;
GitHubRepository[_a] = { fqn: "@aws-cdk/aws-codestar-alpha.GitHubRepository", version: "2.0.0-alpha.10" };
/**
 * (experimental) Visibility of the GitHubRepository.
 *
 * @experimental
 */
var RepositoryVisibility;
(function (RepositoryVisibility) {
    RepositoryVisibility[RepositoryVisibility["PRIVATE"] = 0] = "PRIVATE";
    RepositoryVisibility[RepositoryVisibility["PUBLIC"] = 1] = "PUBLIC";
})(RepositoryVisibility = exports.RepositoryVisibility || (exports.RepositoryVisibility = {}));
//# sourceMappingURL=data:application/json;base64,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