# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pysignald_async']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pysignald-async',
    'version': '0.1.11',
    'description': 'Python bindings for signald',
    'long_description': 'Signald python bindings\n=======================\n\nMost of the content here is generated by the ``generate.py`` script\nthat uses `<https://signald.org/protocol.json>`_.\nThe point in to use\n\nInstall\n-------\n\n``pip install pysignald-async``\n\nHave signald running. See `their docs <https://signald.org/articles/install/>` about it.\n\nUsage\n-----\n\nExample: registration\n*********************\n\n.. code:: py\n\n   import asyncio\n\n   from pysignald_async import SignaldAPI\n\n   async def main():\n       loop = asyncio.get_running_loop()\n       _, signald = await loop.create_unix_connection(\n           SignaldAPI, path=SIGNALD_SOCKET_PATH)\n       await signald.register(username="+XXXXXX")\n       # Some async code to get the SMS code\n       await signald.verify(username="+XXXXXX", code=code)\n       await signald.on_con_lost\n\n   SIGNALD_SOCKET_PATH = "/var/run/signald/signald.sock"\n\n   asyncio.run(main())\n\nDocs are available on `readthedocs <https://pysignald-async.readthedocs.org>`_.\n',
    'author': 'Nicolas Cedilnik',
    'author_email': 'nicoco@nicoco.fr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://gitlab.com/nicocool84/pysignald-async',
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
