# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['sila2lib_implementations',
 'sila2lib_implementations.BioREACTOR48',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.gRPC',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.gRPC',
 'sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.meta',
 'sila2lib_implementations.BioREACTOR48.lib',
 'sila2lib_implementations.BioREACTOR48.method',
 'sila2lib_implementations.BlueVary',
 'sila2lib_implementations.BlueVary.BlueVaryService',
 'sila2lib_implementations.BlueVary.BlueVaryService.CalibrationServicer',
 'sila2lib_implementations.BlueVary.BlueVaryService.CalibrationServicer.gRPC',
 'sila2lib_implementations.BlueVary.BlueVaryService.DeviceServicer',
 'sila2lib_implementations.BlueVary.BlueVaryService.DeviceServicer.gRPC',
 'sila2lib_implementations.BlueVary.BlueVaryService.SensorServicer',
 'sila2lib_implementations.BlueVary.BlueVaryService.SensorServicer.gRPC',
 'sila2lib_implementations.BlueVary.BlueVaryService.meta',
 'sila2lib_implementations.DASGIP',
 'sila2lib_implementations.DASGIP.DASGIPService',
 'sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.AgitationServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.DOServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.DOServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.DeviceServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.GassingServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.GassingServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.IlluminationServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.LevelServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.LevelServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.OffgasServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.OpcuaClient',
 'sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.OverlayServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PHServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PHServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PressureServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PressureServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpAServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpBServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpCServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.PumpDServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.ReactorServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.RedoxServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.TemperatureServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer',
 'sila2lib_implementations.DASGIP.DASGIPService.TurbidityServicer.gRPC',
 'sila2lib_implementations.DASGIP.DASGIPService.meta',
 'sila2lib_implementations.Flowmeter',
 'sila2lib_implementations.Flowmeter.FlowmeterService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.AlarmService.gRPC',
 'sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.CalibrationService.gRPC',
 'sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.DeviceService.gRPC',
 'sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.FluidDefinitionService.gRPC',
 'sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider',
 'sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementProvider.gRPC',
 'sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService',
 'sila2lib_implementations.Flowmeter.FlowmeterService.MeasurementSettingsService.gRPC',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.DeviceService.gRPC',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService',
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService.MeasurementService.gRPC',
 'sila2lib_implementations.LAUDA',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.ControlParameterServicer',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.ControlParameterServicer.gRPC',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.DeviceServicer',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.DeviceServicer.gRPC',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.TemperatureControlServicer',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.TemperatureControlServicer.gRPC',
 'sila2lib_implementations.LAUDA.LAUDA_ThermostatService.meta',
 'sila2lib_implementations.MT_Viper_SW',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.BalanceService',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.BalanceService.gRPC',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DeviceInformationProvider',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DeviceInformationProvider.gRPC',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DisplayController',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service.DisplayController.gRPC',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.BalanceService',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.BalanceService.gRPC',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.DeviceInformationProvider',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.DeviceInformationProvider.gRPC',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.DisplayController',
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old.DisplayController.gRPC',
 'sila2lib_implementations.Presens',
 'sila2lib_implementations.Presens.PresensService',
 'sila2lib_implementations.Presens.PresensService.CalibrationService',
 'sila2lib_implementations.Presens.PresensService.CalibrationService.gRPC',
 'sila2lib_implementations.Presens.PresensService.DeviceService',
 'sila2lib_implementations.Presens.PresensService.DeviceService.gRPC',
 'sila2lib_implementations.Presens.PresensService.SensorProvider',
 'sila2lib_implementations.Presens.PresensService.SensorProvider.gRPC',
 'sila2lib_implementations.Presens.PresensService_old',
 'sila2lib_implementations.Presens.PresensService_old.CalibrationServicer',
 'sila2lib_implementations.Presens.PresensService_old.CalibrationServicer.gRPC',
 'sila2lib_implementations.Presens.PresensService_old.DeviceController',
 'sila2lib_implementations.Presens.PresensService_old.DeviceController.gRPC',
 'sila2lib_implementations.Presens.PresensService_old.DeviceServicer',
 'sila2lib_implementations.Presens.PresensService_old.DeviceServicer.gRPC',
 'sila2lib_implementations.Presens.PresensService_old.SensorProvider',
 'sila2lib_implementations.Presens.PresensService_old.SensorProvider.gRPC',
 'sila2lib_implementations.Presens.PresensService_old.meta',
 'sila2lib_implementations.Presens.lib',
 'sila2lib_implementations.Presens.method',
 'sila2lib_implementations.RegloDC',
 'sila2lib_implementations.RegloDC.RegloDCService',
 'sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer',
 'sila2lib_implementations.RegloDC.RegloDCService.CalibrationServicer.gRPC',
 'sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer',
 'sila2lib_implementations.RegloDC.RegloDCService.DeviceServicer.gRPC',
 'sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer',
 'sila2lib_implementations.RegloDC.RegloDCService.DriveControlServicer.gRPC',
 'sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer',
 'sila2lib_implementations.RegloDC.RegloDCService.ParameterControlServicer.gRPC',
 'sila2lib_implementations.RegloICC',
 'sila2lib_implementations.RegloICC.RegloICCService',
 'sila2lib_implementations.RegloICC.RegloICCService.CalibrationServicer',
 'sila2lib_implementations.RegloICC.RegloICCService.CalibrationServicer.gRPC',
 'sila2lib_implementations.RegloICC.RegloICCService.ConfigurationServicer',
 'sila2lib_implementations.RegloICC.RegloICCService.ConfigurationServicer.gRPC',
 'sila2lib_implementations.RegloICC.RegloICCService.DeviceServicer',
 'sila2lib_implementations.RegloICC.RegloICCService.DeviceServicer.gRPC',
 'sila2lib_implementations.RegloICC.RegloICCService.DriveControlServicer',
 'sila2lib_implementations.RegloICC.RegloICCService.DriveControlServicer.gRPC',
 'sila2lib_implementations.RegloICC.RegloICCService.ParameterControlServicer',
 'sila2lib_implementations.RegloICC.RegloICCService.ParameterControlServicer.gRPC',
 'sila2lib_implementations.RegloICC.RegloICCService.meta',
 'sila2lib_implementations._framework',
 'tests',
 'tests.BioREACTOR48',
 'tests.BlueVary',
 'tests.DASGIP',
 'tests.Flowmeter_ELFLOWPrestige',
 'tests.LAUDA',
 'tests.MT_Viper_SW',
 'tests.Presens',
 'tests.RegloICC',
 'tests.old_unit_ts']

package_data = \
{'': ['*'],
 'sila2lib_implementations.BioREACTOR48': ['BioREACTOR48_project/*'],
 'sila2lib_implementations.BlueVary': ['BlueVary_project/*'],
 'sila2lib_implementations.DASGIP': ['DASGIP_project/*'],
 'sila2lib_implementations.Flowmeter': ['Flowmeter_project/*'],
 'sila2lib_implementations.Flowmeter.FlowmeterService': ['meta/*'],
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige': ['FlowmeterElflowPrestige_project/*'],
 'sila2lib_implementations.Flowmeter_ELFLOWPrestige.FlowmeterElflowPrestigeService': ['meta/*'],
 'sila2lib_implementations.LAUDA': ['LAUDA_project/*'],
 'sila2lib_implementations.MT_Viper_SW': ['MT_Viper_SW_Balance_project/*'],
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service': ['meta/*'],
 'sila2lib_implementations.MT_Viper_SW.MT_Viper_SW_Balance_Service_old': ['meta/*'],
 'sila2lib_implementations.Presens': ['Presens_project/*',
                                      'Presens_project_old/*'],
 'sila2lib_implementations.Presens.PresensService': ['meta/*'],
 'sila2lib_implementations.RegloDC': ['RegloDC_project/*'],
 'sila2lib_implementations.RegloDC.RegloDCService': ['meta/*'],
 'sila2lib_implementations.RegloICC': ['RegloICC_project/*']}

install_requires = \
['pydantic==1.8.2',
 'pyserial==3.5',
 'pytest==6.2.5',
 'python-dotenv==0.19.1',
 'setuptools==59.1.0',
 'sila2lib==0.2.5',
 'wheel==0.36.0']

setup_kwargs = {
    'name': 'sila2lib-implementations',
    'version': '0.1.1',
    'description': 'A package of SiLA drivers for various devices at TUM-BVT',
    'long_description': '\n\nCreation date: 20.10.2020, 12:50  \nLast modification: 11.11.2021, 12:52  \nAuthors: Lukas Bromig, Nikolas von den Eichen, Felix Moorhoff  \nContributors: Valeryia Sidarava, Jose Jesus de Pina Torres\n\n![sila-python](tests/sila-python-logo.png)\n\nSila2lib_implementations\n=====================================================\n\n[![Pipeline Status](https://gitlab.com/lukas.bromig/sila2lib_implementations/badges/pipenv_to_poetry/pipeline.svg)](https://gitlab.com/lukas.bromig/sila2lib_implementations/commits/master)\n[![coverage report](https://gitlab.com/lukas.bromig/sila2lib_implementations/badges/pipenv_to_poetry/coverage.svg)](https://gitlab.com/lukas.bromig/sila2lib_implementations/-/commits/main)\n[![python](https://img.shields.io/pypi/pyversions/hypercorn.svg)](https://pypi.org/project/sila2lib-implementations/)\n\n\nThis repository contains [SiLA2](https://sila-standard.com) drivers for a variety of devices that are being used at the [Institute of Biochemical Engineering](https://www.mw.tum.de/en/biovt/home/) at TUM.\n\n\nThe following devices are supported:\n- **2mag, BioREACTOR48 (48x Parallel Bioreactor System)**  \n- **BlueSens, BlueVary (Offgas-analytics)**  \n- **Eppendorf, DASGIP (4x Parallel Bioeactor System)**\n- **LAUDA, LOOP 250**\n- **LAUDA, LOOP 500**\n- **PreSens sensor bars**\n- **Reglo, RegloICC (Peristaltic Pump)**\n- **Reglo, RegloDC (Peristaltic Pump)**\n- **Bronkhorst, El-Flow Prestige (Flowmeter)**\n- **Mettler-Toledo, MT Viper SW (Laboratory Balance)**\n\nSiLA version of drivers may vary. In case of incompatibilities, please reach out to:   \n*lukas.bromig@tum.de* \n\n## Content\n\n| **Device**      | **Description**             | **SiLA Python branch(*)** | **State** | **Last update (main)** |\n|-----------------|----------------------|------------------------|-----------|-----------------------------|\n| BioREACTOR48    | mL-Bioreactor system | master (v.1.0)         | in use    |          20.08.2021         |\n| BlueVary        | off-gas analytic     | codegenerator-0.3      | in use    |          23.07.2021         |\n| DASGIP          | L-Bioreactor system  | master (v.1.0)         | in use    |          26.04.2021         |\n| ELFLOW Prestige | flowmeter            | codegenerator-0.3      | testing   |          30.08.2021         |\n| Lauda Loop250   | thermostat           | master (v.1.0)         | not used  |          25.10.2020         |\n| Lauda Loop500   | thermostat           | master (v.1.0)         | not used  |          25.10.2020         |\n| MT Viper SW     | laboratory balance   | codegenerator-0.3      | in use    |          14.04.2021         |\n| Presens         | pH/DO-sensor bars    | codegenerator-0.3      | in use    |          20.08.2021         |\n| RegloDC         | peristaltic pump     | codegenerator-0.3      | in use    |          14.04.2021         |\n| RegloICC        | peristaltic pump     | master (v.1.0)         | in use    |          12.03.2021         |\n\n(*) SiLA Python branches:\nAs of 11.11.2021, SiLA 2 Python versions "master (v.1.0)" and "codegenerator-0.3" are deprecated. Backwards \ncompatibility is intended. If you encounter any issues, please reach out! All forthcoming development and driver updates \nwill use the latest SiLA 2 Python reference implementation.   \n\n## Project structure - generically\n```\n└── sila2lib_implementations\n    ├── sila2lib_implementations\n    │   ├── Device\n    │   │   └── Device_project\n    │   │   │   └── DeviceServicer.sila.xml\n    │   │   │   └── service_description.json\n    │   │   │   └── SiLAFramework.proto\n    │   │   └── DeviceService\n    │   │   │   └── DeviceServicer\n    │   │   │   │   └── DeviceServicer_servicer.py\n    │   │   │   │   └── DeviceServicer_real.py\n    │   │   │   │   └── DeviceServicer_simulation.py\n    │   │   │   │   └── DeviceServicer_default_arguments.py\n    │   │   │   │   └── __init__.py\n    │   │   │   └── DeviceService_client.py\n    │   │   │   └── DeviceService_server.py    \n    │   │   │   └── __init__.py    \n    │   │   └── __init__.py\n    │   └── __init__.py\n    ├── tests\n    │   ├── Device\n    │   │   └── test_device.py  \n    ├── README.md\n    ├── LICENSE\n    ├── pyproject.toml\n    └── setup.py\n```\n\n```sila2lib_implementations```: Projects root  \n```sila2lib_implementations```: All Device implementations  \n```Device```: A device that is implemented  \n```Device_project```: Source code directory of the device implementation  \n```DeviceServicer.sila.xml```: Feature implementation for the Device device  \n```service_description.json```: Keine Ahnung?  \n```SiLAFramework.proto```: Keine Ahnung?  \n```DeviceService```: Code generated directory for the device  \n```DeviceServicer```: Contains the Device implementations for different modi (like simulation or real mode)\nas well as a servicer that starts either the simulation- or real mode. ```DeviceServicer_default_arguments``` contains\nthe default responses for the simulation mode.  \n```DeviceService_client.py```: Sila server implementation specific for the device    \n```DeviceService_client.py```: Sila client implementation specific for the device    \n```tests```: Unit tests for the devices\n\n\nThe folder ```sila2lib_implementations``` contains the listed devices. Each device itself consists of a ```Device_project``` folder\nwhere the devices were defined originally (in the file format ```.xml```). These .xml-files are written according to the \nSiLA2 schema available at [sila_base](https://gitlab.com/SiLA2/sila_base) and are called FDL-files (**F**eature **D**efinition **L**anguage). \nBased on these files, the sila2lib-codegenerator (Deprecated, In archived branch of [sila_python](https://gitlab.com/SiLA2/sila_python))\ngenerated all services in the separate directory ```DeviceService```. Within the ```DeviceService``` directory, server and clients have been\ngenerated. Depending on the device\'s function there can be additional features, named Service, Provider, or Controller. \nTo learn more about the nomenclature of SiLA2 read the [documentation](https://sila2.gitlab.io/sila_base/) which \ncontains links to the specification parts A and B. These features account for the main functionality\nof the device (e.g. providing of sensor data, control of actors). Each feature contains an implementation for a simulation- or real mode, as well as some\ndefault return arguments to enable a meaningful simulation run. The gRPC folders within the ```DeviceService``` folder can be ignored, usually.  \nUnit tests for (almost) all devices can be found in the ```test``` folder (for details see \'Developer note\')\n\n### Installation requirements  \nRequires Python3, (pip, git and poetry)  \nFurther requirements include:  \n- InfluxDB, csv, persistent, opcua, pyserial, cryptography    \nThese packages can be installed via PyPI\n\n## Installation   \nThe repository is setup in a way that it can be installed conveniently as python package.\nIn case of any failures make sure to accomplish the [Installation requirements](#installation-requirements) and read the \ntroubleshooting section. There are two possible ways for an installation:  \n\n### Python Package Index (PyPI) (recommended)   \nStable releases are available at the [Python Package Index (PyPI)](https://pypi.org/project/sila2lib-implementations/).\nUse the package installer for python (pip) for installation:\n``` {.sourceCode .console} \n$ pip install sila2lib_implementations\n```\n\n### Gitlab (for developers):  \nThe [projects Gitlab repository](https://gitlab.com/lukas.bromig/sila2lib_implementations) further offers accessibility\nto a specific branch that might be unstable, however.  \nNavigate into a directory where you would like to build the sila2lib-implementations. Clone the repository (or desired branches)\nand change (cd sila2lib_implementations) into it. Install the package management tool poetry (pip install poetry)\nto be able to install the sila2lib-implementations repository (poetry install). With ```poetry shell``` you can start the\nvenv where poetry installed your software in. Use ```deactivate``` to exit the venv again. Alternatively, pip \nor different methods listed [here](https://packaging.python.org/en/latest/tutorials/installing-packages/) can be used for\ninstallation. They are not recommended, however.  \nFinally, have a look at [Quickstart - first steps  ](#quickstart---first-steps) to verify if installation was entirely successful and to get comfortable with sila2lib-implementations :)\n\n\n``` {.sourceCode .console} \n$ git clone -b pipenv_to_poetry https://gitlab.com/lukas.bromig/sila2lib_implementations\n$ cd sila2lib_implementations\n# with poetry (recommended)\n$ pip install poetry\n$ poetry install\n# with pip\n$ pip install --editable .[dev]  # [dev] installs the development packages, defined in setup.py \n```\n  \n## Quickstart - first steps  \nSee if installation was successful: Try to start your first sila server and run some unit test. In simulation mode, of course ;)  \nIt is assumed that you are located in the ```sila2lib_implementations``` root directory. Refer to section [Project structure - generically](#project-structure---generically)\nto get comfortable with the projects structure. Additionally you need to be within in your virtual environment in case you\ninstalled all the packages there (```source bin/activate```).\n``` {.sourceCode .console} \n$ # start your first server (use str c to shut it down again to be able to issue new commands):\n$ python -m sila2lib_implementations/LAUDA/LAUDA_ThermostatService/LAUDA_ThermostatService_server.py \n$ verify if a device is reacting properly to some simulation tests\n$ poetry run python -m pytest tests\n```\nFor further usage like editing existing devices or implementing new ones please continue reading the Developer sections.\n\n## Developer note  \nAny contribution is highly appreciated, not only on a coding base. If you are having issues of any kind please do not \nhesitate to [open an issue](https://gitlab.com/lukas.bromig/sila2lib_implementations/issues).\nAfter installation have a look at the Quickstart paragraph for some first steps to get comfortable within the project.\nProjects structure technically: gRPC, Protobuffer, .xml codegenerator, (encryption) -> i don\'t have the knowledge to write all this\n\n## Development environment\n[black](https://black.readthedocs.io/): Code formatter  \n[isort](https://pycqa.github.io/isort/): Import sorting  \n[flake8](https://flake8.pycqa.org/): Checks various code problems  \n[pytest](https://docs.pytest.org/): Testing suite  \n[pytest-cov](https://github.com/pytest-dev/pytest-cov): Measures pytests code coverage \n\nBefore commiting please make sure to run the checks to push nice code. You can run the script [`run-formatting`](https://gitlab.com/lukas.bromig/sila2lib_implementations/-/blob/master/run-formatting)\nto apply some auto formatting (that you can define by yourself in the file, too btw.).\nTo verify that your code is executable without issues run some tests to see where conflicts or bugs might arise. Run the [`run-checks`](https://gitlab.com/lukas.bromig/sila2lib_implementations/-/blob/master/run-checks)\nto execute all tests or only execute specific ones you are working on.\n\nDo we want to use tox instead?\nDo we want to run checks in the pipeline or has the user to make it?\n\n## Testing environment  \nThe default execution of the pytest command is regulated in the ```tests/pytest.ini``` file, where some markers\nare defined for default executions or safe executions i.a..  \n**How do I run simulation tests?**  \nTests in simulation mode are executed by default. See the [Quickstart - first steps](#quickstart---first-steps) section to get comfortable.  \n**How do I run "real" tests?**  \nReal tests itself are divided into tests that can be executed safely or not. Tests that can be executed safely are those that\ndo not require a special device set up like cooling- or moving units. By this it is tried to assure no device breakdown in case\ncrucial steps have been forgotten to use a device safely.\n-> set tags etc....  \n**Which tests are run in the GitLAb CI/CD pipeline and when?**   \nWhenever we want...  \nThe pipeline routines are defined in the ```.gitlab-ci.yml``` file and can be changed there.\n\n\n## Implementation of new devices\nPlease refer to the [Sila_python](https://gitlab.gwdg.de/niklas.mertsch/sila2-redo/-/tree/master) project for implementation\nof new devices. In case of extension or changes of existing devices keep in mind to also include the changes in the respective\n.xml files.\n\n## Documentation  \nThe documentation of sila_python can be found here: [Documentation](https://sila2.gitlab.io/sila_python)\nThe official SiLA-Standard specifications can be found at [https://sila-standard.org](https://sila-standard.org).\nIf you still can\'t find an answer, please [open an issue](https://gitlab.com/lukas.bromig/sila2lib_implementations/issues).\n\nWIP: The documentation of this repository is also hosted on readthedocs.io\n\nLicense  \n=======   \nThis code is licensed under the [GNU General Public License](https://www.gnu.org/licenses/gpl-3.0.en.html).\n\n\n### Troubleshooting for Debian based installations (e.g. on Raspberry Pis)\nDistro might be shipped using very old and outdated software. Problems might disappear already by updating your system. Also\ncheck the [Installation requirements](#installation-requirements) once again.\nOn top, this troubleshooting section works best if the latest software is used anyways. It is assumed that all commands listed\nhere are executed in a linux terminal. Update your software: ```sudo apt update && sudo apt upgrade```\n\nInstall issues:\n- pip failure to find ```poetry``` version ```1.2.0a2```\n  - pip might be outdated. Update it via: ```pip install --upgrade pip```\n  - python2 pip might be used preferably by your (old, outdated) OS. Use and update pip3 for installation ```pip3 install -U pip && pip install poetry==1.2.0a2```\n- ```poetry command not found```\n  - logout and login again (```source ~/.bashrc``` not sufficient unfortunately)\n- command ```bdist_wheel``` not found. Probably ```wheel``` is not installed. Install it via:\n  - ```pip install --upgrade wheel setuptools```\n\n(Sub-)Dependency issues:\n- Build issues: Make sure to fulfill the dependencies. To ensure this type: ```pip install --upgrade pip setuptools==59.1.0 wheel==0.36.0```\n- install issues for the package ```cryptography```\n  - cryptography requires a (not too old) rust compiler (rustc). Make sure to have the rustc installed and additional dependencies by typing:\n```sudo apt-get install libssl-dev libffi-dev build-essential python3-dev cargo``` \n- install issues for the package ```psycopg2-binary```\n  - Note: Only applies for the LHS_scheduler: psycopg2-binary requires: ``` libpq-dev```  on Debian (Ubuntu, Mint) or \n  ```libpq-devel``` on Centos/Fedora/Cygwin/Babun. Install them for Debians by typing: ```sudo apt-get install libpq-dev``` \n- install issues for the package ```lxml```\n  - lxml requires 2 additional development packages. Install them by typing: ```sudo apt-get install libxml2-dev libxslt1-dev``` \n\nOn a Raspberry Pi OS Bullseye (python 3.9.2) you can issue this one line command to fulfill all dependencies in case the installation\nfails:```sudo apt-get install libssl-dev libffi-dev libxml2-dev libxslt1-dev libpq-dev```\n\nOn a Raspberry Pi OS Buster (python 3.7.3) you can issue this one line command to fulfill all dependencies in case the installation\nfails:```sudo apt-get install libssl-dev libffi-dev libxml2-dev libxslt1-dev libpq-dev```\n\n\n### Troubleshooting during usage (points to installation issues finally)\n- GLIBC_2.33 not found (BTW. this fix did not work for me :/)\n  - This issue is serious since GLIBC can not be changed easily. \'Upgrading very core libraries like libc can be challenging. \n  It\'s better to find a newer distribution if you can.\'. Try to reinstall an older version of grpcio (1.23.0) without binary (--no-binary)  \n```pip install -U --force-reinstall grpcio==1.23.0 --no-binary=grpcio=1.23.0```  \n```pip install -U --force-reinstall grpcio-tools --no-binary=grpcio-tools```\n- ImportError: undefined symbol: __atomic_exchange_8\n  - Please report the troubleshooting\n- Problems that might arise with newer python version\n  - On a Raspbian OS it was not possible for us to change the python version to enable all installs (the version was changed \n  however that did not enable the install, unfortunately)\n',
    'author': 'Lukas Bromig',
    'author_email': 'lukas.bromig@tum.de',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://www.epe.ed.tum.de/en/biovt/home/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7.0,<4.0.0',
}


setup(**setup_kwargs)
