#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*BioREACTOR48Service client*

:details: BioREACTOR48Service:
    This is a BioREACTOR48 Service

:file:    BioREACTOR48Service_client.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:48.841062
:date: (last modification) 2020-04-16T10:18:48.841062

.. note:: Code generated by sila2codegenerator 0.2.0

_______________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

# import general packages
import logging
import argparse
import grpc
import time

# import meta packages
from typing import Union, Optional

# import SiLA2 library modules
from sila2lib.framework import SiLAFramework_pb2 as silaFW_pb2
from sila2lib.sila_client import SiLA2Client
from sila2lib.framework.std_features import SiLAService_pb2 as SiLAService_feature_pb2
from sila2lib.error_handling import client_err

# import feature gRPC modules
# Import gRPC libraries of features
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.DeviceServicer_default_arguments \
    import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.gRPC import MotorServicer_pb2
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.gRPC import MotorServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.MotorServicer_default_arguments \
    import default_dict as MotorServicer_default_dict


# noinspection PyPep8Naming, PyUnusedLocal
class BioREACTOR48ServiceClient(SiLA2Client):
    """
        This is a BioREACTOR48 Service

    .. note:: For an example on how to construct the parameter or read the response(s) for command calls and properties,
              compare the default dictionary that is stored in the directory of the corresponding feature.
    """
    # The following variables will be filled when run() is executed
    #: Storage for the connected servers version
    server_version: str = ''
    #: Storage for the display name of the connected server
    server_display_name: str = ''
    #: Storage for the description of the connected server
    server_description: str = ''

    def __init__(self,
                 name: str = "BioREACTOR48ServiceClient", description: str = "This is a BioREACTOR48 Service",
                 server_name: Optional[str] = None,
                 client_uuid: Optional[str] = None,
                 version: str = __version__,
                 vendor_url: str = "",
                 server_hostname: str = "localhost", server_ip: str = "127.0.0.1", server_port: int = 50001,
                 cert_file: Optional[str] = None):
        """Class initializer"""
        super().__init__(
            name=name, description=description,
            server_name=server_name,
            client_uuid=client_uuid,
            version=version,
            vendor_url=vendor_url,
            server_hostname=server_hostname,
            server_ip=server_ip,
            server_port=server_port,
            cert_file=cert_file
        )
        self.logger = logging.getLogger(__name__)
        self.logger.info(
            "Starting SiLA2 service client for service BioREACTOR48Service with service name: {server_name}".format(
                server_name=name
            )
        )

        # Create stub objects used to communicate with the server
        self.DeviceServicer_stub = \
            DeviceServicer_pb2_grpc.DeviceServicerStub(self.channel)
        self.MotorServicer_stub = \
            MotorServicer_pb2_grpc.MotorServicerStub(self.channel)

        # initialise class variables for server information storage
        self.server_version = ''
        self.server_display_name = ''
        self.server_description = ''

    def Get_ImplementedFeatures(self):
        """Get a list of all implemented features."""
        # type definition, just for convenience
        grpc_err: grpc.Call

        self.logger.debug("Retrieving the list of implemented features of the server:")
        try:
            response = self.SiLAService_stub.Get_ImplementedFeatures(
                SiLAService_feature_pb2.Get_ImplementedFeatures_Parameters()
            )
            for feature_id in response.ImplementedFeatures:
                self.logger.debug("Implemented feature: {feature_id}".format(
                    feature_id=feature_id.value)
                    )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

        return response.ImplementedFeatures

    def Get_FeatureDefinition(self, feature_identifier: str) -> Union[str, None]:
        """
        Returns the FDL/XML feature definition of the given feature.

        :param feature_identifier: The name of the feature for which the definition should be returned.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        self.logger.debug("Requesting feature definitions of feature {feature_identifier}:".format(
            feature_identifier=feature_identifier)
        )
        try:
            response = self.SiLAService_stub.GetFeatureDefinition(
                SiLAService_feature_pb2.GetFeatureDefinition_Parameters(
                    QualifiedFeatureIdentifier=silaFW_pb2.String(value=feature_identifier)
                    )
                )
            self.logger.debug("Response of GetFeatureDefinition for {feature_identifier} feature: {response}".format(
                response=response,
                feature_identifier=feature_identifier)
            )
            return response
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None

    def run(self) -> bool:
        """
        Starts the actual client and retrieves the meta-information from the server.

        :returns: True or False whether the connection to the server is established.
        """
        # type definition, just for convenience
        grpc_err: grpc.Call

        try:
            # Retrieve the basic server information and store it in internal class variables
            #   Display name
            response = self.SiLAService_stub.Get_ServerName(SiLAService_feature_pb2.Get_ServerName_Parameters())
            self.server_display_name = response.ServerName.value
            self.logger.debug("Display name: {name}".format(name=response.ServerName.value))
            # Server description
            response = self.SiLAService_stub.Get_ServerDescription(
                SiLAService_feature_pb2.Get_ServerDescription_Parameters()
            )
            self.server_description = response.ServerDescription.value
            self.logger.debug("Description: {description}".format(description=response.ServerDescription.value))
            # Server version
            response = self.SiLAService_stub.Get_ServerVersion(SiLAService_feature_pb2.Get_ServerVersion_Parameters())
            self.server_version = response.ServerVersion.value
            self.logger.debug("Version: {version}".format(version=response.ServerVersion.value))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return False

        return True

    def stop(self, force: bool = False) -> bool:
        """
        Stop SiLA client routine

        :param force: If set True, the client is supposed to disconnect and stop immediately. Otherwise it can first try
                      to finish what it is doing.

        :returns: Whether the client could be stopped successfully or not.
        """
        # TODO: Implement all routines that have to be executed when the client is stopped.
        #   Feel free to use the "force" parameter to abort any running processes. Or crash your machine. Your call!
        return True

    def DeviceServicer_GetLog(self,
                              parameter: DeviceServicer_pb2.GetLog_Parameters = None) \
            -> silaFW_pb2.CommandConfirmation:
        """
        Wrapper to call the observable command GetLog on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A command confirmation object with the following information:
            commandExecutionUUID: A command id with which this observable command can be referenced in future calls
            lifetimeOfExecution (optional): The (maximum) lifetime of this command call.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling GetLog:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetLog_Parameters(
                    **DeviceServicer_default_dict['GetLog_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetLog(parameter)
    
            self.logger.debug('GetLog response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Info(self,
                                   uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> silaFW_pb2.ExecutionInfo:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the status information that has been defined for this command. The following fields
                  are defined:
                    * *commandStatus*: Status of the command (enumeration)
                    * *progressInfo*: Information on the progress of the command (0 to 1)
                    * *estimatedRemainingTime*: Estimate of the remaining time required to run the command
                    * *updatedLifetimeOfExecution*: An update on the execution lifetime
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        self.logger.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
        try:
            response = self.DeviceServicer_stub.GetLog_Info(uuid)
            self.logger.debug('GetLog status information: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetLog_Result(self,
                                     uuid: Union[str, silaFW_pb2.CommandExecutionUUID]) \
            -> DeviceServicer_pb2.GetLog_Responses:
        """
        Wrapper to get an intermediate response for the observable command GetLog on the server.
    
        :param uuid: The UUID that has been returned with the first command call. Can be given as string or as the
                     corresponding SiLA2 gRPC object.
    
        :returns: A gRPC object with the result response that has been defined for this command.
    
        .. note:: Whether the result is available or not can and should be evaluated by calling the
                  :meth:`GetLog_Info` method of this call.
        """
        if type(uuid) is str:
            uuid = silaFW_pb2.CommandExecutionUUID(value=uuid)
    
        self.logger.debug(
            "Requesting status information for command GetLog (UUID={uuid}):".format(
                uuid=uuid.value
            )
        )
    
        try:
            response = self.DeviceServicer_stub.GetLog_Result(uuid)
            self.logger.debug('GetLog result response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetDeviceStatus(self,
                                       parameter: DeviceServicer_pb2.GetDeviceStatus_Parameters = None) \
            -> DeviceServicer_pb2.GetDeviceStatus_Responses:
        """
        Wrapper to call the unobservable command GetDeviceStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling GetDeviceStatus:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetDeviceStatus_Parameters(
                    **DeviceServicer_default_dict['GetDeviceStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetDeviceStatus(parameter)
    
            self.logger.debug('GetDeviceStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def DeviceServicer_GetReactorStatus(self,
                                        parameter: DeviceServicer_pb2.GetReactorStatus_Parameters = None) \
            -> DeviceServicer_pb2.GetReactorStatus_Responses:
        """
        Wrapper to call the unobservable command GetReactorStatus on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling GetReactorStatus:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = DeviceServicer_pb2.GetReactorStatus_Parameters(
                    **DeviceServicer_default_dict['GetReactorStatus_Parameters']
                )
    
            response = self.DeviceServicer_stub.GetReactorStatus(parameter)
    
            self.logger.debug('GetReactorStatus response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_StartStirrer(self,
                                   parameter: MotorServicer_pb2.StartStirrer_Parameters = None) \
            -> MotorServicer_pb2.StartStirrer_Responses:
        """
        Wrapper to call the unobservable command StartStirrer on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling StartStirrer:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MotorServicer_pb2.StartStirrer_Parameters(
                    **MotorServicer_default_dict['StartStirrer_Parameters']
                )
    
            response = self.MotorServicer_stub.StartStirrer(parameter)
    
            self.logger.debug('StartStirrer response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_StopStirrer(self,
                                  parameter: MotorServicer_pb2.StopStirrer_Parameters = None) \
            -> MotorServicer_pb2.StopStirrer_Responses:
        """
        Wrapper to call the unobservable command StopStirrer on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling StopStirrer:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MotorServicer_pb2.StopStirrer_Parameters(
                    **MotorServicer_default_dict['StopStirrer_Parameters']
                )
    
            response = self.MotorServicer_stub.StopStirrer(parameter)
    
            self.logger.debug('StopStirrer response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_SetRPM(self, RPM) \
            -> MotorServicer_pb2.SetRPM_Responses:
        """
        Wrapper to call the unobservable command SetRPM on the server.
    
        :param RPM: The parameter gRPC construct required for this command. The rotations per minute of the stirrer.

        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling SetRPM:")
        par_dict = {
            'RPM': silaFW_pb2.Integer(value=RPM)
        }

        try:
            parameter = MotorServicer_pb2.SetRPM_Parameters(**par_dict)
            if parameter is None:
                parameter = MotorServicer_pb2.SetRPM_Parameters(
                    **MotorServicer_default_dict['SetRPM_Parameters']
                )
            response = self.MotorServicer_stub.SetRPM(parameter)
    
            self.logger.debug('SetRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_GetRPM(self,
                             parameter: MotorServicer_pb2.GetRPM_Parameters = None) \
            -> MotorServicer_pb2.GetRPM_Responses:
        """
        Wrapper to call the unobservable command GetRPM on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling GetRPM:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MotorServicer_pb2.GetRPM_Parameters(
                    **MotorServicer_default_dict['GetRPM_Parameters']
                )
    
            response = self.MotorServicer_stub.GetRPM(parameter)
    
            self.logger.debug('GetRPM response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_SetPower(self, Power) \
            -> MotorServicer_pb2.SetPower_Responses:
        """
        Wrapper to call the unobservable command SetPower on the server.
    
        :param Power: The parameter gRPC construct required for this command. The power of the stirrer induction engine.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling SetPower:")
        par_dict = {
            'Power': silaFW_pb2.Integer(value=Power)
        }
        try:
            parameter = MotorServicer_pb2.SetPower_Parameters(**par_dict)
            if parameter is None:
                parameter = MotorServicer_pb2.SetPower_Parameters(
                    **MotorServicer_default_dict['SetPower_Parameters']
                )
    
            response = self.MotorServicer_stub.SetPower(parameter)
    
            self.logger.debug('SetPower response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response
    
    def MotorServicer_GetPower(self,
                               parameter: MotorServicer_pb2.GetPower_Parameters = None) \
            -> MotorServicer_pb2.GetPower_Responses:
        """
        Wrapper to call the unobservable command GetPower on the server.
    
        :param parameter: The parameter gRPC construct required for this command.
    
        :returns: A gRPC object with the response that has been defined for this command.
        """
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Calling GetPower:")
        try:
            # resolve to default if no value given
            #   TODO: Implement a more reasonable default value
            if parameter is None:
                parameter = MotorServicer_pb2.GetPower_Parameters(
                    **MotorServicer_default_dict['GetPower_Parameters']
                )
    
            response = self.MotorServicer_stub.GetPower(parameter)
    
            self.logger.debug('GetPower response: {response}'.format(response=response))
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Subscribe_DeviceServicer_CurrentStatus(self) \
            -> DeviceServicer_pb2.Subscribe_CurrentStatus_Responses:
        """Wrapper to get property CurrentStatus from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Reading observable property CurrentStatus:")

        try:
            # define a timeout of 10 seconds in which we read the parameter
            timeout = time.time() + 10.0
            # initialise a boolean to track whether we set the property manually
            value_set = False
            # loop over responses
            response = None
            for response in self.DeviceServicer_stub.Subscribe_CurrentStatus(DeviceServicer_pb2.Subscribe_CurrentStatus_Responses()):
                # NOTE: This loop might be lagging behind the server. When you execute it, observe when the value
                #   changes to a constant 42. This should be after 5 seconds, however happens with a certain delay.
                #   If this loop contains too many commands, this delay might increase.
                # Note also, that the server implementation manually implements a (blocking) delay of 0.2 seconds,
                #   which helps a lot with this problem since otherwise the server generates the data a lot faster
                #   than this client can process it.
                # print(response)
                self.logger.debug(
                    " " * 8 + 'Currently returned Value: {response} (t = {time_passed} s)'.format(
                        response=response.CurrentStatus.value,
                        time_passed=round(time.time() - timeout + 10, 1)
                    )
                )
                if time.time() > timeout:
                    print('Timeout')
                    break

            self.logger.debug(
                'Subscribe_CurrentStatus response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_DeviceServicer_BarNumber(self) \
            -> DeviceServicer_pb2.Get_BarNumber_Responses:
        """Wrapper to get property BarNumber from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Reading unobservable property BarNumber:")
        try:
            response = self.DeviceServicer_stub.Get_BarNumber(
                DeviceServicer_pb2.Get_BarNumber_Parameters()
            )
            self.logger.debug(
                'Get_BarNumber response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_DeviceServicer_BarReactors(self) \
            -> DeviceServicer_pb2.Get_BarReactors_Responses:
        """Wrapper to get property BarReactors from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Reading unobservable property BarReactors:")
        try:
            response = self.DeviceServicer_stub.Get_BarReactors(
                DeviceServicer_pb2.Get_BarReactors_Parameters()
            )
            self.logger.debug(
                'Get_BarReactors response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    def Get_DeviceServicer_TotalReactors(self) \
            -> DeviceServicer_pb2.Get_TotalReactors_Responses:
        """Wrapper to get property TotalReactors from the server."""
        # noinspection PyUnusedLocal - type definition, just for convenience
        grpc_err: grpc.Call
    
        self.logger.debug("Reading unobservable property TotalReactors:")
        try:
            response = self.DeviceServicer_stub.Get_TotalReactors(
                DeviceServicer_pb2.Get_TotalReactors_Parameters()
            )
            self.logger.debug(
                'Get_TotalReactors response: {response}'.format(
                    response=response
                )
            )
        except grpc.RpcError as grpc_err:
            self.grpc_error_handling(grpc_err)
            return None
    
        return response

    @staticmethod
    def grpc_error_handling(error_object: grpc.Call) -> None:
        """Handles exceptions of type grpc.RpcError"""
        # pass to the default error handling
        grpc_error = client_err.grpc_error_handling(error_object=error_object)

        # Access more details using the return value fields
        # grpc_error.message
        # grpc_error.error_type


def parse_command_line():
    """
    Just looking for command line arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 client: BioREACTOR48Service")
    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    return parser.parse_args()


if __name__ == '__main__':
    # or use self.logger.INFO (=20) or self.logger.ERROR (=30) for less output
    logging.basicConfig(format='%(levelname)-8s| %(module)s.%(funcName)s: %(message)s', level=logging.DEBUG)

    parsed_args = parse_command_line()

    # start the server
    sila_client = BioREACTOR48ServiceClient(server_ip='127.0.0.1', server_port=50004)
    sila_client.run()

    # Log connection info
    logging.info(
        (
            'Connected to SiLA Server {display_name} running in version {version}.' '\n'
            'Service description: {service_description}'
        ).format(
            display_name=sila_client.server_display_name,
            version=sila_client.server_version,
            service_description=sila_client.server_description
        )
    )

    # TODO:
    #   Write your further function calls here to run the client as a standalone application.
