#!/usr/bin/env python3
"""
________________________________________________________________________

:PROJECT: SiLA2_python

*BioREACTOR48Service*

:details: BioREACTOR48Service:
    This is a BioREACTOR48 Service

:file:    BioREACTOR48Service_server.py
:authors: Lukas Bromig

:date: (creation)          2020-04-16T10:18:48.822113
:date: (last modification) 2020-04-16T10:18:48.822113

.. note:: Code generated by sila2codegenerator 0.2.0

________________________________________________________________________

**Copyright**:
  This file is provided "AS IS" with NO WARRANTY OF ANY KIND,
  INCLUDING THE WARRANTIES OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.

  For further Information see LICENSE file that comes with this distribution.
________________________________________________________________________
"""
__version__ = "1.0"

import os
import sys
import logging
import argparse
import time
import sys

# Import the main SiLA library
from sila2lib.sila_server import SiLA2Server

# Import gRPC libraries of features
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.gRPC import DeviceServicer_pb2
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.gRPC import DeviceServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.DeviceServicer_default_arguments \
    import default_dict as DeviceServicer_default_dict
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.gRPC import MotorServicer_pb2
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.gRPC import MotorServicer_pb2_grpc
# import default arguments for this feature
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.MotorServicer_default_arguments import default_dict as MotorServicer_default_dict

# Import the servicer modules for each feature
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.DeviceServicer.DeviceServicer_servicer \
    import DeviceServicer
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.MotorServicer.MotorServicer_servicer import MotorServicer

# import custom implementation libraries
import serial
import serial.tools.list_ports
import multiprocessing
from sila2lib_implementations.BioREACTOR48.BioREACTOR48Service.SerialDetector import serial_ports
# from tests.config import settings  # if this setup, move config.py into root or sila2lib_implementations


class Properties:
    TotalChannels = 48
    TotalBars = 6
    BarSensors = 8
    lock = multiprocessing.Lock()
    server_start_time = time.time()

class BioREACTOR48ServiceServer(SiLA2Server):
    """
    This is a BioREACTOR48 Service
    """

    def __init__(self,
                 server_name: str = 'BioREACTOR48Service',
                 description: str = 'Unknown Type',
                 server_type: str = 'This is a BioREACTOR48 Service',
                 encryption_key: str = None,
                 encryption_cert: str = None,
                 ip: str = '127.0.0.1',  # Comment LB: Do not import the env. var from settings.BIOREACTOR48_IP here
                 port: int = 50051,  # Comment LB: Do not import the env. var. from settings.BIOREACTOR48_PORT here
                 simulation_mode: bool = False):  # Comment LB: Do not import the env. vars from settings.BIOREACTOR48_SIMULATION_MODE here
        """Class initializer"""
        super().__init__(
            name=server_name, description=description,
            server_type=server_type, server_uuid=None,
            version=__version__,
            vendor_url="",
            ip=ip, port=port,
            key_file=encryption_key, cert_file=encryption_cert,
            simulation_mode=simulation_mode, server_hostname=f'{server_name}.sila'
            # server_path=os.path.dirname(os.path.realpath(__file__))
        )
        logging.info(
            "Starting SiLA2 server with server name: {server_name}".format(
                server_name=server_name
            )
        )
        # Define some server properties
        self.properties = Properties
        self.status = "Idle"
        self.simulation_mode = simulation_mode

        if not simulation_mode:
            # respect different port names for different operating systems
            if sys.platform.startswith('win'):
                ports_required = ['COM1']
            elif sys.platform.startswith('linux') or sys.platform.startswith('cygwin'):
                # ports_required = ['/dev/ttyS0']  # in case of build in serial port, adapt number (0) to the port used
                ports_required = ['/dev/ttyUSB0']  # for USB/serial port cables
            elif sys.platform.startswith('darwin'):
                # on Error: Detect the serial port by yourself and overwrite list element '/dev/tty.SLAB_USBtoUART*':
                ports_required = ['/dev/tty.SLAB_USBtoUART*']
                raise EnvironmentError('Serial port names unknown for MacOS, please find them out by your own')
            else:
                raise EnvironmentError('Unsupported platform')

            # Opening a serial port for data communication automatically. ONLY use if no other COM ports exist!
            available_ports = serial_ports()
            ports = []
            ports_not_required = []
            for i in range(0, len(available_ports), 1):
                if available_ports[i] in ports_required:
                    ports.append(available_ports[i])
                else:
                    ports_not_required.append(available_ports[i])
            unavailable_ports = list(set(ports_required) - set(ports))
            if unavailable_ports is not []:
                logging.info(
                    "The following COM/USB ports are not available: {ports}".format(ports=unavailable_ports))
            if ports == []:
                logging.info(
                    "No available COM/USB port to establish connection: {ports}".format(ports=ports))
            else:
                self.ser = serial.Serial(port=ports[0], baudrate=9600, parity=serial.PARITY_NONE,
                                         stopbits=serial.STOPBITS_ONE, bytesize=serial.EIGHTBITS, timeout=2)
                logging.info(
                    "Connection established on port: {ports}".format(ports=ports[0]))
        else:
            self.ser = None

        # registering features
        #  Register DeviceServicer
        self.DeviceServicer_servicer = DeviceServicer(ser=self.ser, lock=self.properties.lock, status=self.status, start_time = self.properties.server_start_time,
                                                      simulation_mode=self.simulation_mode)
        DeviceServicer_pb2_grpc.add_DeviceServicerServicer_to_server(
            self.DeviceServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='DeviceServicer',
                         servicer=self.DeviceServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        #  Register MotorServicer
        self.MotorServicer_servicer = MotorServicer(ser=self.ser, lock=self.properties.lock, status=self.status,
                                                    simulation_mode=self.simulation_mode)
        MotorServicer_pb2_grpc.add_MotorServicerServicer_to_server(
            self.MotorServicer_servicer,
            self.grpc_server
        )
        self.add_feature(feature_id='MotorServicer',
                         servicer=self.MotorServicer_servicer,
                         data_path=os.path.join(
                             os.path.dirname(__file__),
                             'meta')
                         )
        self.simulation_mode = simulation_mode
        # starting and running the gRPC/SiLA2 server
        # self.run()


def parse_command_line():
    """
    Just looking for commandline arguments
    """
    parser = argparse.ArgumentParser(description="A SiLA2 service: BioREACTOR48Service")

    # Simple arguments for the server identification
    parser.add_argument('-s', '--server-name', action='store',
                        default="BioREACTOR48Service", help='start SiLA server with [server-name]')
    parser.add_argument('-t', '--server-type', action='store',
                        default="Unknown Type", help='start SiLA server with [server-type]')
    parser.add_argument('-d', '--description', action='store',
                        default="This is a BioREACTOR48 Service", help='SiLA server description')
    parser.add_argument('-p', '--port', action='store', help='SiLA server port')

    # Encryption
    parser.add_argument('-X', '--encryption', action='store', default=None,
                        help='The name of the private key and certificate file (without extension).')
    parser.add_argument('--encryption-key', action='store', default=None,
                        help='The name of the encryption key (*with* extension). Can be used if key and certificate '
                             'vary or non-standard file extensions are used.')
    parser.add_argument('--encryption-cert', action='store', default=None,
                        help='The name of the encryption certificate (*with* extension). Can be used if key and '
                             'certificate vary or non-standard file extensions are used.')

    parser.add_argument('-v', '--version', action='version', version='%(prog)s ' + __version__)

    parsed_args = parser.parse_args()

    # validate/update some settings
    #   encryption
    if parsed_args.encryption is not None:
        # only overwrite the separate keys if not given manually
        if parsed_args.encryption_key is None:
            parsed_args.encryption_key = parsed_args.encryption + '.key'
        if parsed_args.encryption_cert is None:
            parsed_args.encryption_cert = parsed_args.encryption + '.cert'

    return parsed_args


def init():
    if __name__ == '__main__':
        # or use logging.ERROR for less output
        logging.basicConfig(format  = '%(asctime)s - %(name)s - %(levelname)s- %(module)s - linenumber: %(lineno)d - %(message)s', level=logging.DEBUG)
        args = parse_command_line()

        # generate SiLA2Server
        sila_server = BioREACTOR48ServiceServer(ip='127.0.0.1', port=50004, simulation_mode=True)
        sys.exit(sila_server.run())

init()
